(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6195,        210]
NotebookOptionsPosition[      3836,        145]
NotebookOutlinePosition[      5299,        179]
CellTagsIndexPosition[      5256,        176]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Java Memory Management", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 Cell[TextData[ButtonBox["JavaBlock",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " release any Java objects created during evaluation once evaluation \
finishes"
}], "GuideText",
 CellID->287842012],

Cell[TextData[{
 Cell[TextData[ButtonBox["BeginJavaBlock",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/BeginJavaBlock"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["EndJavaBlock",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/EndJavaBlock"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " mark the beginning and end of a Java block"
}], "GuideText",
 CellID->51107461],

Cell[TextData[{
 Cell[TextData[ButtonBox["KeepJavaObject",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/KeepJavaObject"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " allow a Java object to persist when the current ",
 Cell[TextData[ButtonBox["JavaBlock",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFunctionSans"],
 " ends"
}], "GuideText",
 CellID->469282344],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReleaseJavaObject",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " finish using a Java object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "GuideText",
 CellID->144168739],

Cell["\t", "GuideDelimiter",
 CellID->2117121874],

Cell[TextData[{
 Cell[TextData[ButtonBox["SameObjectQ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/SameObjectQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether two ",
 Cell[TextData[ButtonBox["JavaObject",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFunctionSans"],
 " expressions reference the same Java object"
}], "GuideText",
 CellID->129570571],

Cell["\t", "GuideDelimiter",
 CellID->2071414556],

Cell[TextData[{
 Cell[TextData[ButtonBox["LoadedJavaObjects",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/LoadedJavaObjects"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LoadedJavaClasses",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/LoadedJavaClasses"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list all Java objects or classes in use"
}], "GuideText",
 CellID->1036261045]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "GuideTutorial",
 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Java Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaInterface"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Java Memory Management - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Java Memory Management", "summary" -> 
    "JavaBlock -- release any Java objects created during evaluation once \
evaluation finishes, BeginJavaBlock, EndJavaBlock -- mark the beginning and \
end of a Java block, KeepJavaObject -- allow a Java object to persist when \
the current JavaBlock ends, ReleaseJavaObject -- finish using a Java object \
in Mathematica , SameObjectQ -- whether two JavaObject expressions reference \
the same Java object, LoadedJavaObjects, LoadedJavaClasses -- list all Java \
objects or classes in use", "uri" -> "JLink/guide/JavaMemoryManagement", 
    "type" -> "Guide", "label" -> "J Link Guide", "paclet" -> "JLink", 
    "context" -> "", "keywords" -> {}, "synonyms" -> {}, "status" -> "None", 
    "built" -> "{2007, 4, 20, 15, 29, 3.7453157}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 64, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[686, 28, 309, 9, 70, "GuideText",
 CellID->287842012],
Cell[998, 39, 424, 12, 70, "GuideText",
 CellID->51107461],
Cell[1425, 53, 428, 12, 70, "GuideText",
 CellID->469282344],
Cell[1856, 67, 333, 11, 70, "GuideText",
 CellID->144168739],
Cell[2192, 80, 49, 1, 70, "GuideDelimiter",
 CellID->2117121874],
Cell[2244, 83, 426, 12, 70, "GuideText",
 CellID->129570571],
Cell[2673, 97, 49, 1, 70, "GuideDelimiter",
 CellID->2071414556],
Cell[2725, 100, 439, 12, 70, "GuideText",
 CellID->1036261045]
}, Open  ]],
Cell[CellGroupData[{
Cell[3201, 117, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[3266, 120, 275, 9, 70, "GuideTutorial",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[3578, 134, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3643, 137, 151, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[3809, 143, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

