(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10315,        346]
NotebookOptionsPosition[      8069,        275]
NotebookOutlinePosition[      9184,        305]
CellTagsIndexPosition[      9141,        302]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JavaThrow" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaThrow"], 
          "GetJavaException" :> 
          Documentation`HelpLookup["paclet:JLink/ref/GetJavaException"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"JavaThrow\"\>", 
       2->"\<\"GetJavaException\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Exception Handling" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaExceptionHandling"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Exception Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$JavaExceptionHandler", "ObjectName",
 CellID->78614117],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$JavaExceptionHandler"], "InlineFormula"],
     " \[LineSeparator]allows you to control how exceptions thrown in Java \
are handled in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->404945245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default behavior is for exceptions to appear as messages in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->232714566],

Cell[TextData[{
 "If you want to override this behavior (for example to temporarily silence \
messages from exceptions), assign a value to ",
 Cell[BoxData["$JavaExceptionHandler"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->355012509],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["$JavaExceptionHandler"], "InlineFormula"],
 " is treated as a function that will be passed 3 arguments: the symbol \
associated with the message (this will currently always be the symbol ",
 StyleBox["Java", "InlineCode"],
 "), the message tag (this will be the string ",
 StyleBox["\"excptn\"", "InlineCode"],
 " for a typical exception or ",
 StyleBox["\"pexcptn\"", "InlineCode"],
 " for an exception generated by a manual return method where the exception \
occurs after the method has manually sent its result back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "), and the descriptive string of text associated with the message. "
}], "Notes",
 CellID->191490344],

Cell[TextData[{
 "You will typically set ",
 Cell[BoxData["$JavaExceptionHandler"], "InlineFormula"],
 " within a ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " so that its effect will be limited to a precisely defined segment of code, \
as in the following example that silences messages: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$JavaExceptionHandler", "=", 
      RowBox[{
       ButtonBox["Null",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Null"], "&"}]}], "}"}], ",", 
    RowBox[{
     StyleBox["obj", "TI"], "@", 
     RowBox[{
      StyleBox["method", "TI"], "[", "]"}]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23766082],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["GetJavaException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/GetJavaException"]], "InlineFormula"],
 " within your handler function to obtain the actual Java exception object \
that was thrown."
}], "Notes",
 CellID->413325432]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->633568277],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaThrow",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaThrow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetJavaException",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/GetJavaException"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->255306261]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->419205974],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->445279350],

Cell[TextData[ButtonBox["Java Exception Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaExceptionHandling"]], "MoreAbout",
 CellID->449049073]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$JavaExceptionHandler - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "$JavaExceptionHandler", "summary" -> 
    "$JavaExceptionHandler allows you to control how exceptions thrown in \
Java are handled in Mathematica.", "uri" -> "JLink/ref/$JavaExceptionHandler",
     "type" -> "Symbol", "label" -> "J Link Symbol", "paclet" -> "JLink", 
    "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"java exception handler"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 31, 17.6845883}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2196, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2819, 85, 62, 1, 70, "ObjectName",
 CellID->78614117],
Cell[2884, 88, 451, 14, 70, "Usage",
 CellID->404945245]
}, Open  ]],
Cell[CellGroupData[{
Cell[3372, 107, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3831, 123, 171, 6, 70, "Notes",
 CellID->232714566],
Cell[4005, 131, 238, 6, 70, "Notes",
 CellID->355012509],
Cell[4246, 139, 727, 16, 70, "Notes",
 CellID->191490344],
Cell[4976, 157, 854, 28, 70, "Notes",
 CellID->23766082],
Cell[5833, 187, 301, 9, 70, "Notes",
 CellID->413325432]
}, Closed]],
Cell[CellGroupData[{
Cell[6171, 201, 54, 1, 70, "SeeAlsoSection",
 CellID->633568277],
Cell[6228, 204, 485, 17, 70, "SeeAlso",
 CellID->255306261]
}, Open  ]],
Cell[CellGroupData[{
Cell[6750, 226, 57, 1, 70, "TutorialsSection",
 CellID->419205974],
Cell[6810, 229, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[7084, 240, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[7804, 264, 58, 1, 70, "MoreAboutSection",
 CellID->445279350],
Cell[7865, 267, 162, 3, 70, "MoreAbout",
 CellID->449049073]
}, Open  ]],
Cell[8042, 273, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

