(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9024,        305]
NotebookOptionsPosition[      6758,        235]
NotebookOutlinePosition[      7954,        266]
CellTagsIndexPosition[      7911,        263]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AllowRaggedArrays" :> 
          Documentation`HelpLookup["paclet:JLink/ref/AllowRaggedArrays"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"AllowRaggedArrays\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaConnectionManagement"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Java Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$RelaxedTypeChecking", "ObjectName",
 CellID->319706183],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$RelaxedTypeChecking"], "InlineFormula"],
     " \[LineSeparator]is a flag that can be set to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " to speed up the validation performed in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " (via pattern tests) on arrays of data being sent as arguments to Java \
calls. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->412271540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
For a very large matrix, it can be expensive to test that it is, for \
instance, a rectangular matrix of integers before it is sent to Java. \
\>", "Notes",
 CellID->256774233],

Cell["\<\
This process is made faster by making the tests much less strict, so you must \
make sure that you pass methods exactly the arguments they expect. \
\>", "Notes",
 CellID->24557108],

Cell[TextData[{
 "The default value is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->331825873],

Cell[TextData[{
 "You can set and reset the value whenever you want; a typical use would be \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$RelaxedTypeChecking", " ", "=", " ", 
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]}], "}"}], ",", " ", 
    RowBox[{
     StyleBox["methodcall", "TI"], "[", 
     StyleBox["matrix", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28681968]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->226957649],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["AllowRaggedArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AllowRaggedArrays"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->139563589]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->413983234],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->249904666],

Cell[TextData[ButtonBox["Java Connection Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaConnectionManagement"]], "MoreAbout",
 CellID->96365605]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$RelaxedTypeChecking - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "$RelaxedTypeChecking", "summary" -> 
    "$RelaxedTypeChecking is a flag that can be set to True to speed up the \
validation performed in Mathematica (via pattern tests) on arrays of data \
being sent as arguments to Java calls. ", "uri" -> 
    "JLink/ref/$RelaxedTypeChecking", "type" -> "Symbol", "label" -> 
    "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"relaxed type checking"}, "status" -> 
    "None", "built" -> "{2007, 4, 20, 15, 31, 19.9279259}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2091, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2714, 83, 62, 1, 70, "ObjectName",
 CellID->319706183],
Cell[2779, 86, 666, 19, 70, "Usage",
 CellID->412271540]
}, Open  ]],
Cell[CellGroupData[{
Cell[3482, 110, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3941, 126, 186, 4, 70, "Notes",
 CellID->256774233],
Cell[4130, 132, 191, 4, 70, "Notes",
 CellID->24557108],
Cell[4324, 138, 193, 8, 70, "Notes",
 CellID->331825873],
Cell[4520, 148, 559, 19, 70, "Notes",
 CellID->28681968]
}, Closed]],
Cell[CellGroupData[{
Cell[5116, 172, 54, 1, 70, "SeeAlsoSection",
 CellID->226957649],
Cell[5173, 175, 224, 6, 70, "SeeAlso",
 CellID->139563589]
}, Open  ]],
Cell[CellGroupData[{
Cell[5434, 186, 57, 1, 70, "TutorialsSection",
 CellID->413983234],
Cell[5494, 189, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5768, 200, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6488, 224, 58, 1, 70, "MoreAboutSection",
 CellID->249904666],
Cell[6549, 227, 167, 3, 70, "MoreAbout",
 CellID->96365605]
}, Open  ]],
Cell[6731, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

