(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8260,        277]
NotebookOptionsPosition[      6358,        218]
NotebookOutlinePosition[      7466,        248]
CellTagsIndexPosition[      7423,        245]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Periodical" :> 
          Documentation`HelpLookup["paclet:JLink/ref/Periodical"], 
          "Periodicals" :> 
          Documentation`HelpLookup["paclet:JLink/ref/Periodicals"], 
          "RemovePeriodical" :> 
          Documentation`HelpLookup["paclet:JLink/ref/RemovePeriodical"], 
          "SetPeriodicalInterval" :> 
          Documentation`HelpLookup[
           "paclet:JLink/ref/SetPeriodicalInterval"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Periodical\"\>", 2->"\<\"Periodicals\"\>", 
       3->"\<\"RemovePeriodical\"\>", 
       4->"\<\"SetPeriodicalInterval\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AddPeriodical", "ObjectName",
 CellID->334523074],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AddPeriodical", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", " ", 
        StyleBox["interval", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]adds the computation ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to the set of operations that are periodically performed \
automatically."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->268717038]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["AddPeriodical"], "InlineFormula"],
 " returns an integer ID that can be used in ",
 Cell[BoxData[
  ButtonBox["RemovePeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/RemovePeriodical"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->56749219],

Cell["\<\
The time interval is specified in seconds, and can be less than one second, \
although the timing is not expected to be very precise.\
\>", "Notes",
 CellID->107965459]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->930636119],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Periodical",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/Periodical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Periodicals",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/Periodicals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RemovePeriodical",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/RemovePeriodical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPeriodicalInterval",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/SetPeriodicalInterval"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->499118220]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->538418565],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AddPeriodical - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "AddPeriodical", "summary" -> 
    "AddPeriodical[expr, interval] adds the computation expr to the set of \
operations that are periodically performed automatically.", "uri" -> 
    "JLink/ref/AddPeriodical", "type" -> "Symbol", "label" -> "J Link Symbol",
     "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"add periodical"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 29, 7.6010522}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1894, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2517, 75, 55, 1, 70, "ObjectName",
 CellID->334523074],
Cell[2575, 78, 604, 18, 70, "Usage",
 CellID->268717038]
}, Open  ]],
Cell[CellGroupData[{
Cell[3216, 101, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3675, 117, 291, 9, 70, "Notes",
 CellID->56749219],
Cell[3969, 128, 178, 4, 70, "Notes",
 CellID->107965459]
}, Closed]],
Cell[CellGroupData[{
Cell[4184, 137, 54, 1, 70, "SeeAlsoSection",
 CellID->930636119],
Cell[4241, 140, 1021, 35, 70, "SeeAlso",
 CellID->499118220]
}, Open  ]],
Cell[CellGroupData[{
Cell[5299, 180, 57, 1, 70, "TutorialsSection",
 CellID->538418565],
Cell[5359, 183, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5633, 194, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[6331, 216, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

