(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8771,        292]
NotebookOptionsPosition[      6688,        228]
NotebookOutlinePosition[      7876,        259]
CellTagsIndexPosition[      7833,        256]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JavaShow" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaShow"], "DoModal" :> 
          Documentation`HelpLookup["paclet:JLink/ref/DoModal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JavaShow\"\>", 
       2->"\<\"DoModal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java User Interfaces" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaUserInterfaces"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Java User Interfaces\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AppletViewer", "ObjectName",
 CellID->57358436],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AppletViewer", "[", 
       RowBox[{
        StyleBox["javaclass", "TI"], ",", 
        StyleBox["parameters", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays a window with an applet of the specified ",
     Cell[BoxData[
      ButtonBox["JavaClass",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
     " running in it. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AppletViewer", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"classname\", \"TI\"]\)\>\"", ",", 
        StyleBox["parameters", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays a window running an applet of the named \
class."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->95126842]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["parameters", "TI"]], "InlineFormula"],
 " is a list of strings, each specifying a name=value pair supplying applet \
properties that would normally appear in an HTML file in <PARAM> tags or \
other applet attributes (like WIDTH and HEIGHT attributes). A typical \
specification might be ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<WIDTH=400\>\"", ",", " ", "\"\<HEIGHT=400\>\""}], "}"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->398533698]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->35467900],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaShow",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaShow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DoModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/DoModal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->126633002]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->339769140],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->11310973],

Cell[TextData[ButtonBox["Java User Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaUserInterfaces"]], "MoreAbout",
 CellID->82071812]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AppletViewer - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "AppletViewer", "summary" -> 
    "AppletViewer[javaclass, parameters] displays a window with an applet of \
the specified JavaClass running in it. AppletViewer[\"  classname\", \
parameters] displays a window running an applet of the named class.", "uri" -> 
    "JLink/ref/AppletViewer", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"applet viewer"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 29, 14.6014673}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2145, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2768, 84, 53, 1, 70, "ObjectName",
 CellID->57358436],
Cell[2824, 87, 966, 28, 70, "Usage",
 CellID->95126842]
}, Open  ]],
Cell[CellGroupData[{
Cell[3827, 120, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4286, 136, 496, 13, 70, "Notes",
 CellID->398533698]
}, Closed]],
Cell[CellGroupData[{
Cell[4819, 154, 53, 1, 70, "SeeAlsoSection",
 CellID->35467900],
Cell[4875, 157, 465, 17, 70, "SeeAlso",
 CellID->126633002]
}, Open  ]],
Cell[CellGroupData[{
Cell[5377, 179, 57, 1, 70, "TutorialsSection",
 CellID->339769140],
Cell[5437, 182, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5711, 193, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6431, 217, 57, 1, 70, "MoreAboutSection",
 CellID->11310973],
Cell[6491, 220, 155, 3, 70, "MoreAbout",
 CellID->82071812]
}, Open  ]],
Cell[6661, 226, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

