(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7986,        263]
NotebookOptionsPosition[      6115,        206]
NotebookOutlinePosition[      7282,        237]
CellTagsIndexPosition[      7239,        234]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JavaClass" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaClass"], "GetClass" :> 
          Documentation`HelpLookup["paclet:JLink/ref/GetClass"], "JavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaObject"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JavaClass\"\>", 
       2->"\<\"GetClass\"\>", 3->"\<\"JavaObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Classes and Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ClassName", "ObjectName",
 CellID->713662724],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ClassName", "[", 
       StyleBox["javaclass", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns, as a string, the fully qualified name of the \
specified ",
     Cell[BoxData[
      ButtonBox["JavaClass",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ClassName", "[", 
       StyleBox["javaobject", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the fully qualified name of the Java class of \
the specified ",
     Cell[BoxData[
      ButtonBox["JavaObject",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
     ".  "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->383367819]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->346652207],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaClass",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaClass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetClass",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/GetClass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->560068427]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->185747262],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->244159886],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClassName - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ClassName", "summary" -> 
    "ClassName[javaclass] returns, as a string, the fully qualified name of \
the specified JavaClass.  ClassName[javaobject] returns the fully qualified \
name of the Java class of the specified JavaObject. ", "uri" -> 
    "JLink/ref/ClassName", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"class name"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 29, 18.8277551}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2271, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2894, 85, 51, 1, 70, "ObjectName",
 CellID->713662724],
Cell[2948, 88, 993, 30, 70, "Usage",
 CellID->383367819]
}, Open  ]],
Cell[CellGroupData[{
Cell[3978, 123, 54, 1, 70, "SeeAlsoSection",
 CellID->346652207],
Cell[4035, 126, 724, 26, 70, "SeeAlso",
 CellID->560068427]
}, Open  ]],
Cell[CellGroupData[{
Cell[4796, 157, 57, 1, 70, "TutorialsSection",
 CellID->185747262],
Cell[4856, 160, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5130, 171, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[5850, 195, 58, 1, 70, "MoreAboutSection",
 CellID->244159886],
Cell[5911, 198, 162, 3, 70, "MoreAbout",
 CellID->82588414]
}, Open  ]],
Cell[6088, 204, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

