(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7059,        249]
NotebookOptionsPosition[      5299,        194]
NotebookOutlinePosition[      6387,        224]
CellTagsIndexPosition[      6344,        221]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"J/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UseFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/UseFrontEnd"], 
          "ConnectToFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ConnectToFrontEnd"], 
          "FrontEndLink" :> 
          Documentation`HelpLookup["paclet:JLink/ref/FrontEndLink"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"UseFrontEnd\"\>", 
       2->"\<\"ConnectToFrontEnd\"\>", 
       3->"\<\"FrontEndLink\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CloseFrontEnd", "ObjectName",
 CellID->823445427],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CloseFrontEnd", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]closes the link to the front end that was opened by ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        ButtonBox["UseFrontEnd",
         BaseStyle->"Link",
         ButtonData->"paclet:JLink/ref/UseFrontEnd"], "[", "]"}], " "}]], 
      "InlineFormula"],
     "or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["ConnectToFrontEnd",
        BaseStyle->"Link",
        ButtonData->"paclet:JLink/ref/ConnectToFrontEnd"], "[", "]"}]], 
      "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->536047788]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "After using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UseFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/UseFrontEnd"], "[", "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConnectToFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ConnectToFrontEnd"], "[", "]"}]], 
  "InlineFormula"],
 ", you should ensure that ",
 Cell[BoxData[
  RowBox[{"CloseFrontEnd", "[", "]"}]], "InlineFormula"],
 " is called before you quit the kernel."
}], "Notes",
 CellID->455887013]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->238949097],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UseFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/UseFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConnectToFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ConnectToFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndLink",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/FrontEndLink"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->601325895]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->25963919],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CloseFrontEnd - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "CloseFrontEnd", "summary" -> 
    "CloseFrontEnd[] closes the link to the front end that was opened by \
UseFrontEnd[] or ConnectToFrontEnd[].", "uri" -> "JLink/ref/CloseFrontEnd", 
    "type" -> "Symbol", "label" -> "J Link Symbol", "paclet" -> "JLink", 
    "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"close front end"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 29, 20.8607798}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1504, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2127, 68, 55, 1, 70, "ObjectName",
 CellID->823445427],
Cell[2185, 71, 814, 26, 70, "Usage",
 CellID->536047788]
}, Open  ]],
Cell[CellGroupData[{
Cell[3036, 102, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3495, 118, 551, 20, 70, "Notes",
 CellID->455887013]
}, Closed]],
Cell[CellGroupData[{
Cell[4083, 143, 54, 1, 70, "SeeAlsoSection",
 CellID->238949097],
Cell[4140, 146, 750, 26, 70, "SeeAlso",
 CellID->601325895]
}, Open  ]],
Cell[CellGroupData[{
Cell[4927, 177, 56, 1, 70, "TutorialsSection",
 CellID->25963919],
Cell[4986, 180, 271, 9, 70, "Tutorials",
 CellID->281642142]
}, Open  ]],
Cell[5272, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

