(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8820,        300]
NotebookOptionsPosition[      6872,        239]
NotebookOutlinePosition[      7975,        269]
CellTagsIndexPosition[      7932,        266]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"J/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UseFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/UseFrontEnd"], 
          "CloseFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/CloseFrontEnd"], 
          "$FrontEndLaunchCommand" :> 
          Documentation`HelpLookup["paclet:JLink/ref/$FrontEndLaunchCommand"],
           "$FrontEndInitializationFunction" :> 
          Documentation`HelpLookup[
           "paclet:JLink/ref/$FrontEndInitializationFunction"], 
          "FrontEndLink" :> 
          Documentation`HelpLookup["paclet:JLink/ref/FrontEndLink"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"UseFrontEnd\"\>", 
       2->"\<\"CloseFrontEnd\"\>", 3->"\<\"$FrontEndLaunchCommand\"\>", 
       4->"\<\"$FrontEndInitializationFunction\"\>", 
       5->"\<\"FrontEndLink\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ConnectToFrontEnd", "ObjectName",
 CellID->87206140],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConnectToFrontEnd", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]establishes a link to the notebook front end for use \
by the ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["UseFrontEnd",
        BaseStyle->"Link",
        ButtonData->"paclet:JLink/ref/UseFrontEnd"], "[", "]"}]], 
      "InlineFormula"],
     " function."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->278556528]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ConnectToFrontEnd"], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " to indicate that the link was established correctly, and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " otherwise."
}], "Notes",
 CellID->38839997],

Cell["The front end will be launched if required. ", "Notes",
 CellID->35666290],

Cell[TextData[{
 "Although ",
 Cell[BoxData[
  ButtonBox["UseFrontEnd",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UseFrontEnd"]], "InlineFormula"],
 " will call ",
 Cell[BoxData["ConnectToFrontEnd"], "InlineFormula"],
 " if necessary, ",
 Cell[BoxData["ConnectToFrontEnd"], "InlineFormula"],
 " is provided to allow programmers to conveniently control when the front \
end is launched and to receive a ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "/",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " indication if it was successful. "
}], "Notes",
 CellID->489260017],

Cell["\<\
This function will typically be called only from an external program that is \
driving the kernel, not from code executing in a front end notebook.\
\>", "Notes",
 CellID->165076401]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->710187156],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UseFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/UseFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/CloseFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$FrontEndLaunchCommand",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/$FrontEndLaunchCommand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$FrontEndInitializationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/$FrontEndInitializationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndLink",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/FrontEndLink"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->224584804]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->197264661],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConnectToFrontEnd - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ConnectToFrontEnd", "summary" -> 
    "ConnectToFrontEnd[] establishes a link to the notebook front end for use \
by the UseFrontEnd[] function.", "uri" -> "JLink/ref/ConnectToFrontEnd", 
    "type" -> "Symbol", "label" -> "J Link Symbol", "paclet" -> "JLink", 
    "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"connect to front end"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 29, 23.4746687}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1851, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2474, 74, 58, 1, 70, "ObjectName",
 CellID->87206140],
Cell[2535, 77, 603, 19, 70, "Usage",
 CellID->278556528]
}, Open  ]],
Cell[CellGroupData[{
Cell[3175, 101, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3634, 117, 417, 14, 70, "Notes",
 CellID->38839997],
Cell[4054, 133, 80, 1, 70, "Notes",
 CellID->35666290],
Cell[4137, 136, 718, 23, 70, "Notes",
 CellID->489260017],
Cell[4858, 161, 192, 4, 70, "Notes",
 CellID->165076401]
}, Closed]],
Cell[CellGroupData[{
Cell[5087, 170, 54, 1, 70, "SeeAlsoSection",
 CellID->710187156],
Cell[5144, 173, 1318, 44, 70, "SeeAlso",
 CellID->224584804]
}, Open  ]],
Cell[CellGroupData[{
Cell[6499, 222, 57, 1, 70, "TutorialsSection",
 CellID->197264661],
Cell[6559, 225, 271, 9, 70, "Tutorials",
 CellID->281642142]
}, Open  ]],
Cell[6845, 237, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

