(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8771,        304]
NotebookOptionsPosition[      6699,        238]
NotebookOutlinePosition[      7761,        267]
CellTagsIndexPosition[      7718,        264]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EndModal" :> 
          Documentation`HelpLookup["paclet:JLink/ref/EndModal"], "JavaShow" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaShow"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EndModal\"\>", 
       2->"\<\"JavaShow\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java User Interfaces" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaUserInterfaces"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Java User Interfaces\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DoModal", "ObjectName",
 CellID->37512467],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DoModal", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]does not return until the Java side sends an \
expression of the form ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["EvaluatePacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EvaluatePacket"], "[", 
       RowBox[{
        ButtonBox["EndModal",
         BaseStyle->"Link",
         ButtonData->"paclet:JLink/ref/EndModal"], "[", 
        StyleBox["args", "TI"], "]"}], "]"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4838071]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["DoModal"], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", 
   StyleBox["args", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->36437672],

Cell[TextData[{
 "Use ",
 Cell[BoxData["DoModal"], "InlineFormula"],
 " to have a program wait until some Java user-interface action signals that \
it can proceed. "
}], "Notes",
 CellID->591525503],

Cell[TextData[{
 "Typically, this would be used to implement a modal dialog box that needs to \
return a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when it is dismissed."
}], "Notes",
 CellID->315521453]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->124657540],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaShow",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaShow"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->84900109]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->111575881],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->218471303],

Cell[TextData[ButtonBox["Java User Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaUserInterfaces"]], "MoreAbout",
 CellID->82071812]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DoModal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "DoModal", "summary" -> 
    "DoModal[] does not return until the Java side sends an expression of the \
form EvaluatePacket[EndModal[args]].", "uri" -> "JLink/ref/DoModal", "type" -> 
    "Symbol", "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> 
    "JLink`", "keywords" -> {}, "synonyms" -> {"do modal"}, "status" -> 
    "None", "built" -> "{2007, 4, 20, 15, 29, 27.8411651}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2148, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2771, 84, 48, 1, 70, "ObjectName",
 CellID->37512467],
Cell[2822, 87, 754, 23, 70, "Usage",
 CellID->4838071]
}, Open  ]],
Cell[CellGroupData[{
Cell[3613, 115, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4072, 131, 289, 11, 70, "Notes",
 CellID->36437672],
Cell[4364, 144, 198, 6, 70, "Notes",
 CellID->591525503],
Cell[4565, 152, 225, 7, 70, "Notes",
 CellID->315521453]
}, Closed]],
Cell[CellGroupData[{
Cell[4827, 164, 54, 1, 70, "SeeAlsoSection",
 CellID->124657540],
Cell[4884, 167, 466, 17, 70, "SeeAlso",
 CellID->84900109]
}, Open  ]],
Cell[CellGroupData[{
Cell[5387, 189, 57, 1, 70, "TutorialsSection",
 CellID->111575881],
Cell[5447, 192, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5721, 203, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6441, 227, 58, 1, 70, "MoreAboutSection",
 CellID->218471303],
Cell[6502, 230, 155, 3, 70, "MoreAbout",
 CellID->82071812]
}, Open  ]],
Cell[6672, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

