(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9420,        314]
NotebookOptionsPosition[      7276,        248]
NotebookOutlinePosition[      8464,        279]
CellTagsIndexPosition[      8421,        276]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructors" :> 
          Documentation`HelpLookup["paclet:JLink/ref/Constructors"], 
          "Methods" :> Documentation`HelpLookup["paclet:JLink/ref/Methods"], 
          "ClassName" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ClassName"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructors\"\>", 
       2->"\<\"Methods\"\>", 3->"\<\"ClassName\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Classes and Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fields", "ObjectName",
 CellID->635321852],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Fields", "[", 
       StyleBox["javaclass", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns a list of the Java declarations for all fields \
of the specified ",
     Cell[BoxData[
      ButtonBox["JavaClass",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Fields", "[", "\"\<\!\(\*
StyleBox[\"classname\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]lists the fields for the named class."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Fields", "[", 
       StyleBox["javaobject", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]lists the fields for the class of the specified ",
     Cell[BoxData[
      ButtonBox["JavaObject",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->291642354]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The resulting lists are returned in ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1813665143],

Cell["\<\
To make them easier to read, the declarations have had the keywords \
\"transient\" and \"volatile\" removed. The \"public\" keyword is also \
removed, as the fields are always public.\
\>", "Notes",
 CellID->766768505]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->748075819],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Constructors",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/Constructors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Methods",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/Methods"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClassName",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ClassName"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->35162468]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->21990195],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->235255767],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fields - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Fields", "summary" -> 
    "Fields[javaclass] returns a list of the Java declarations for all fields \
of the specified JavaClass.  Fields[\"  classname\"] lists the fields for the \
named class.  Fields[javaobject] lists the fields for the class of the \
specified JavaObject. ", "uri" -> "JLink/ref/Fields", "type" -> "Symbol", 
    "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 29, 34.2206564}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2285, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2908, 86, 48, 1, 70, "ObjectName",
 CellID->635321852],
Cell[2959, 89, 1199, 35, 70, "Usage",
 CellID->291642354]
}, Open  ]],
Cell[CellGroupData[{
Cell[4195, 129, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4654, 145, 216, 8, 70, "Notes",
 CellID->1813665143],
Cell[4873, 155, 229, 5, 70, "Notes",
 CellID->766768505]
}, Closed]],
Cell[CellGroupData[{
Cell[5139, 165, 54, 1, 70, "SeeAlsoSection",
 CellID->748075819],
Cell[5196, 168, 725, 26, 70, "SeeAlso",
 CellID->35162468]
}, Open  ]],
Cell[CellGroupData[{
Cell[5958, 199, 56, 1, 70, "TutorialsSection",
 CellID->21990195],
Cell[6017, 202, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[6291, 213, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[7011, 237, 58, 1, 70, "MoreAboutSection",
 CellID->235255767],
Cell[7072, 240, 162, 3, 70, "MoreAbout",
 CellID->82588414]
}, Open  ]],
Cell[7249, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

