(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7653,        266]
NotebookOptionsPosition[      5646,        203]
NotebookOutlinePosition[      6759,        233]
CellTagsIndexPosition[      6716,        230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"J/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JavaThrow" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaThrow"], 
          "$JavaExceptionHandler" :> 
          Documentation`HelpLookup[
           "paclet:JLink/ref/$JavaExceptionHandler"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"JavaThrow\"\>", 
       2->"\<\"$JavaExceptionHandler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Exception Handling" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaExceptionHandling"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Exception Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GetJavaException", "ObjectName",
 CellID->291951373],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GetJavaException", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the Java ",
     StyleBox["Exception", "InlineCode"],
     " object that was thrown in the most recent call from ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " to Java."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->185557411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GetJavaException"], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if no exception was thrown in the most recent call."
}], "Notes",
 CellID->794411880],

Cell[TextData[{
 Cell[BoxData["GetJavaException"], "InlineFormula"],
 " can be used in conjunction with ",
 Cell[BoxData[
  ButtonBox["$JavaExceptionHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/$JavaExceptionHandler"]], "InlineFormula"],
 " to implement a custom exception-handling scheme in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->256865176]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->125862503],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaThrow",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaThrow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$JavaExceptionHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/$JavaExceptionHandler"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->910238269]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->366700564],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->116005039],

Cell[TextData[ButtonBox["Java Exception Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaExceptionHandling"]], "MoreAbout",
 CellID->449049073]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GetJavaException - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "GetJavaException", "summary" -> 
    "GetJavaException[] returns the Java Exception object that was thrown in \
the most recent call from Mathematica to Java.", "uri" -> 
    "JLink/ref/GetJavaException", "type" -> "Symbol", "label" -> 
    "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"get java exception"}, "status" -> 
    "None", "built" -> "{2007, 4, 20, 15, 29, 44.4959438}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1988, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2611, 82, 58, 1, 70, "ObjectName",
 CellID->291951373],
Cell[2672, 85, 533, 16, 70, "Usage",
 CellID->185557411]
}, Open  ]],
Cell[CellGroupData[{
Cell[3242, 106, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3701, 122, 282, 9, 70, "Notes",
 CellID->794411880],
Cell[3986, 133, 401, 12, 70, "Notes",
 CellID->256865176]
}, Closed]],
Cell[CellGroupData[{
Cell[4424, 150, 54, 1, 70, "SeeAlsoSection",
 CellID->125862503],
Cell[4481, 153, 495, 17, 70, "SeeAlso",
 CellID->910238269]
}, Open  ]],
Cell[CellGroupData[{
Cell[5013, 175, 57, 1, 70, "TutorialsSection",
 CellID->366700564],
Cell[5073, 178, 271, 9, 70, "Tutorials",
 CellID->281642142]
}, Open  ]],
Cell[CellGroupData[{
Cell[5381, 192, 58, 1, 70, "MoreAboutSection",
 CellID->116005039],
Cell[5442, 195, 162, 3, 70, "MoreAbout",
 CellID->449049073]
}, Open  ]],
Cell[5619, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

