(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9470,        304]
NotebookOptionsPosition[      7137,        236]
NotebookOutlinePosition[      8512,        269]
CellTagsIndexPosition[      8469,        266]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JavaObjectToExpression" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaObjectToExpression"],
           "MakeJavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/MakeJavaObject"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"JavaObjectToExpression\"\>", 
       2->"\<\"MakeJavaObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"], 
          "Java User Interfaces" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaUserInterfaces"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Java Classes and Objects\"\>", 
       2->"\<\"Java User Interfaces\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ImplementJavaInterface", "ObjectName",
 CellID->4847899],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ImplementJavaInterface", "[", 
       StyleBox[
        RowBox[{"interfaces", ",", "mappings"}], "TI"], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]uses the Dynamic Proxy facility of Java to create a \
new Java class and return an object of that class that implements the named \
interface or list of interfaces by calling back into ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     ". In short, it lets you create a Java object that implements a given \
Java interface entirely in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " code."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->177410621]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["mappings", "TI"]], "InlineFormula"],
 " is a list of rules that specify the name of the Java method and the name \
of the method that will be called in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to implement the body of that method, as in ",
 Cell[BoxData[
  RowBox[{"\"\<intfMeth1\>\"", "->", "\"\<mathHandlerMethod1\>\""}]], 
  "InlineFormula"],
 ". The arguments passed to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " method will be exactly the arguments originally passed to the Java \
method."
}], "Notes",
 CellID->850936600]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->53936600],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaObjectToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaObjectToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeJavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/MakeJavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1240876399]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->456179954],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->178375095],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414],

Cell[TextData[ButtonBox["Java User Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaUserInterfaces"]], "MoreAbout",
 CellID->82071812]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImplementJavaInterface - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ImplementJavaInterface", "summary" -> 
    "ImplementJavaInterface[interfaces, mappings] uses the Dynamic Proxy \
facility of Java to create a new Java class and return an object of that \
class that implements the named interface or list of interfaces by calling \
back into Mathematica. In short, it lets you create a Java object that \
implements a given Java interface entirely in Mathematica code.", "uri" -> 
    "JLink/ref/ImplementJavaInterface", "type" -> "Symbol", "label" -> 
    "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"implement java interface"}, "status" -> 
    "None", "built" -> "{2007, 4, 20, 15, 29, 48.6821720}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2393, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3016, 88, 62, 1, 70, "ObjectName",
 CellID->4847899],
Cell[3081, 91, 845, 23, 70, "Usage",
 CellID->177410621]
}, Open  ]],
Cell[CellGroupData[{
Cell[3963, 119, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4422, 135, 600, 17, 70, "Notes",
 CellID->850936600]
}, Closed]],
Cell[CellGroupData[{
Cell[5059, 157, 53, 1, 70, "SeeAlsoSection",
 CellID->53936600],
Cell[5115, 160, 508, 17, 70, "SeeAlso",
 CellID->1240876399]
}, Open  ]],
Cell[CellGroupData[{
Cell[5660, 182, 57, 1, 70, "TutorialsSection",
 CellID->456179954],
Cell[5720, 185, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5994, 196, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6714, 220, 58, 1, 70, "MoreAboutSection",
 CellID->178375095],
Cell[6775, 223, 162, 3, 70, "MoreAbout",
 CellID->82588414],
Cell[6940, 228, 155, 3, 70, "MoreAbout",
 CellID->82071812]
}, Open  ]],
Cell[7110, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

