(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10540,        345]
NotebookOptionsPosition[      8239,        273]
NotebookOutlinePosition[      9403,        304]
CellTagsIndexPosition[      9360,        301]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReleaseJavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ReleaseJavaObject"], 
          "KeepJavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/KeepJavaObject"], 
          "BeginJavaBlock" :> 
          Documentation`HelpLookup["paclet:JLink/ref/BeginJavaBlock"], 
          "EndJavaBlock" :> 
          Documentation`HelpLookup["paclet:JLink/ref/EndJavaBlock"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"ReleaseJavaObject\"\>", 
       2->"\<\"KeepJavaObject\"\>", 3->"\<\"BeginJavaBlock\"\>", 
       4->"\<\"EndJavaBlock\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "Java Interface" :> 
          Documentation`HelpLookup["paclet:JLink/guide/JavaInterface"], 
          "Java Memory Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaMemoryManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"Java Interface\"\>", 
       3->"\<\"Java Memory Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JavaBlock", "ObjectName",
 CellID->401587407],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JavaBlock", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]causes all new Java objects returned to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " during the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to be released when ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " finishes. It is an error to refer to such an object after ",
     Cell[BoxData["JavaBlock"], "InlineFormula"],
     " ends."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->361999716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["JavaBlock"], "InlineFormula"],
 " is a way to mark a set of objects as temporary so they can be \
automatically cleaned up when the block of code ends."
}], "Notes",
 CellID->432895921],

Cell[TextData[{
 Cell[BoxData["JavaBlock"], "InlineFormula"],
 " affects only new objects, not additional references to ones that have \
previously been seen. "
}], "Notes",
 CellID->171001963],

Cell[TextData[{
 "If a ",
 Cell[BoxData["JavaBlock"], "InlineFormula"],
 " returns a single ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " as a result, that object will not be released. "
}], "Notes",
 CellID->290596952]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->159480231],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseJavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ReleaseJavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KeepJavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/KeepJavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BeginJavaBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/BeginJavaBlock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndJavaBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndJavaBlock"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->922749460]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->352361411],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->143015223],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->309385],

Cell[TextData[ButtonBox["Java Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaInterface"]], "MoreAbout",
 CellID->393743373],

Cell[TextData[ButtonBox["Java Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaMemoryManagement"]], "MoreAbout",
 CellID->14965421]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JavaBlock - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "JavaBlock", "summary" -> 
    "JavaBlock[expr] causes all new Java objects returned to Mathematica \
during the evaluation of expr to be released when expr finishes. It is an \
error to refer to such an object after JavaBlock ends.", "uri" -> 
    "JLink/ref/JavaBlock", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"java block"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 29, 55.5223487}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2776, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3399, 95, 51, 1, 70, "ObjectName",
 CellID->401587407],
Cell[3453, 98, 793, 23, 70, "Usage",
 CellID->361999716]
}, Open  ]],
Cell[CellGroupData[{
Cell[4283, 126, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4742, 142, 216, 5, 70, "Notes",
 CellID->432895921],
Cell[4961, 149, 193, 5, 70, "Notes",
 CellID->171001963],
Cell[5157, 156, 308, 10, 70, "Notes",
 CellID->290596952]
}, Closed]],
Cell[CellGroupData[{
Cell[5502, 171, 54, 1, 70, "SeeAlsoSection",
 CellID->159480231],
Cell[5559, 174, 1019, 35, 70, "SeeAlso",
 CellID->922749460]
}, Open  ]],
Cell[CellGroupData[{
Cell[6615, 214, 57, 1, 70, "TutorialsSection",
 CellID->352361411],
Cell[6675, 217, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[6949, 228, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[7669, 252, 58, 1, 70, "MoreAboutSection",
 CellID->143015223],
Cell[7730, 255, 157, 3, 70, "MoreAbout",
 CellID->309385],
Cell[7890, 260, 145, 3, 70, "MoreAbout",
 CellID->393743373],
Cell[8038, 265, 159, 3, 70, "MoreAbout",
 CellID->14965421]
}, Open  ]],
Cell[8212, 271, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

