(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9069,        291]
NotebookOptionsPosition[      7014,        229]
NotebookOutlinePosition[      8243,        261]
CellTagsIndexPosition[      8200,        258]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LoadJavaClass" :> 
          Documentation`HelpLookup["paclet:JLink/ref/LoadJavaClass"], 
          "ClassName" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ClassName"], "JavaClass" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaClass"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LoadJavaClass\"\>", 
       2->"\<\"ClassName\"\>", 3->"\<\"JavaClass\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "Java Interface" :> 
          Documentation`HelpLookup["paclet:JLink/guide/JavaInterface"], 
          "Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"Java Interface\"\>", 
       3->"\<\"Java Classes and Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JavaNew", "ObjectName",
 CellID->200644271],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JavaNew", "[", 
       StyleBox["classname", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a Java object of the specified class."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JavaNew", "[", 
       RowBox[{
        StyleBox["classname", "TI"], ",", " ", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]constructs a Java object of the specified class, \
passing the arguments ",
     Cell[BoxData[
      StyleBox["args", "TI"]], "InlineFormula"],
     " to its constructor"
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JavaNew", "[", 
       RowBox[{
        StyleBox["javaclass", "TI"], ",", " ", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]constructs a Java object of the specified ",
     Cell[BoxData[
      ButtonBox["JavaClass",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->200310066]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->18472596],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LoadJavaClass",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/LoadJavaClass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClassName",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ClassName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaClass",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaClass"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20187107]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20612008],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->737028809],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->686863773],

Cell[TextData[ButtonBox["Java Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaInterface"]], "MoreAbout",
 CellID->336258658],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JavaNew - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "JavaNew", "summary" -> 
    "JavaNew[classname] constructs a Java object of the specified class.  \
JavaNew[classname, args] constructs a Java object of the specified class, \
passing the arguments args to its constructor  JavaNew[javaclass, args] \
constructs a Java object of the specified JavaClass. ", "uri" -> 
    "JLink/ref/JavaNew", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"java new"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 30, 4.1852372}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2594, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3217, 91, 49, 1, 70, "ObjectName",
 CellID->200644271],
Cell[3269, 94, 1255, 37, 70, "Usage",
 CellID->200310066]
}, Open  ]],
Cell[CellGroupData[{
Cell[4561, 136, 53, 1, 70, "SeeAlsoSection",
 CellID->18472596],
Cell[4617, 139, 731, 26, 70, "SeeAlso",
 CellID->20187107]
}, Open  ]],
Cell[CellGroupData[{
Cell[5385, 170, 56, 1, 70, "TutorialsSection",
 CellID->20612008],
Cell[5444, 173, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5718, 184, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6438, 208, 58, 1, 70, "MoreAboutSection",
 CellID->737028809],
Cell[6499, 211, 160, 3, 70, "MoreAbout",
 CellID->686863773],
Cell[6662, 216, 145, 3, 70, "MoreAbout",
 CellID->336258658],
Cell[6810, 221, 162, 3, 70, "MoreAbout",
 CellID->82588414]
}, Open  ]],
Cell[6987, 227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

