(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11105,        380]
NotebookOptionsPosition[      8688,        302]
NotebookOutlinePosition[      9745,        331]
CellTagsIndexPosition[      9702,        328]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MakeJavaExpr" :> 
          Documentation`HelpLookup["paclet:JLink/ref/MakeJavaExpr"], 
          "JavaNew" :> Documentation`HelpLookup["paclet:JLink/ref/JavaNew"], 
          "JavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaObject"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MakeJavaExpr\"\>", 
       2->"\<\"JavaNew\"\>", 3->"\<\"JavaObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"Java Classes and Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MakeJavaObject", "ObjectName",
 CellID->84752216],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MakeJavaObject", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]constructs a new Java object whose \"value\" is ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->105762605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MakeJavaObject"], "InlineFormula"],
 " is shorthand for calling ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2633268],

Cell[TextData[{
 "It is typically used when you need to call a Java method that is typed to \
take ",
 StyleBox["Object", "InlineCode"],
 ", and you want to pass it a numeric, string, or array value. You use ",
 Cell[BoxData["MakeJavaObject"], "InlineFormula"],
 " to manually convert such arguments into Java objects before passing them \
to the method."
}], "Notes",
 CellID->553232399],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " must be an integer or real number, a ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ", a boolean, or a list or matrix of numbers, strings, or booleans."
}], "Notes",
 CellID->87885935],

Cell[TextData[{
 "For an integer ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", the created Java object is of type ",
 StyleBox["java.lang.Integer", "InlineCode"],
 "."
}], "Notes",
 CellID->420240194],

Cell[TextData[{
 "For a real, the created Java object is of type ",
 StyleBox["java.lang.Double", "InlineCode"],
 "."
}], "Notes",
 CellID->553871838],

Cell[TextData[{
 "For a ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ", the created Java object is of type ",
 StyleBox["java.lang.String", "InlineCode"],
 "."
}], "Notes",
 CellID->212407019],

Cell[TextData[{
 "For a boolean, the created Java object is of type ",
 StyleBox["java.lang.Boolean", "InlineCode"],
 "."
}], "Notes",
 CellID->4410204],

Cell[TextData[{
 "For a list or matrix of numbers, strings, or booleans, the created object \
is a Java array of the corresponding primitive type. For example, ",
 Cell[BoxData[
  RowBox[{"MakeJavaObject", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "InlineFormula"],
 " would create an ",
 Cell[BoxData[
  RowBox[{"int", "[", "]"}]], "InlineFormula"],
 " with these values. "
}], "Notes",
 CellID->275463338]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->235935681],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeJavaExpr",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/MakeJavaExpr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaNew",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaNew"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27836179]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->694445193],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->61960256],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->13145500],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MakeJavaObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "MakeJavaObject", "summary" -> 
    "MakeJavaObject[expr] constructs a new Java object whose \"value\" is \
expr. ", "uri" -> "JLink/ref/MakeJavaObject", "type" -> "Symbol", "label" -> 
    "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"make java object"}, "status" -> "None", 
    "built" -> "{2007, 4, 20, 15, 30, 32.2369721}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2447, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3070, 88, 55, 1, 70, "ObjectName",
 CellID->84752216],
Cell[3128, 91, 494, 15, 70, "Usage",
 CellID->105762605]
}, Open  ]],
Cell[CellGroupData[{
Cell[3659, 111, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4118, 127, 257, 9, 70, "Notes",
 CellID->2633268],
Cell[4378, 138, 388, 9, 70, "Notes",
 CellID->553232399],
Cell[4769, 149, 335, 10, 70, "Notes",
 CellID->87885935],
Cell[5107, 161, 221, 8, 70, "Notes",
 CellID->420240194],
Cell[5331, 171, 150, 5, 70, "Notes",
 CellID->553871838],
Cell[5484, 178, 266, 10, 70, "Notes",
 CellID->212407019],
Cell[5753, 190, 152, 5, 70, "Notes",
 CellID->4410204],
Cell[5908, 197, 442, 12, 70, "Notes",
 CellID->275463338]
}, Closed]],
Cell[CellGroupData[{
Cell[6387, 214, 54, 1, 70, "SeeAlsoSection",
 CellID->235935681],
Cell[6444, 217, 727, 26, 70, "SeeAlso",
 CellID->27836179]
}, Open  ]],
Cell[CellGroupData[{
Cell[7208, 248, 57, 1, 70, "TutorialsSection",
 CellID->694445193],
Cell[7268, 251, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[7542, 262, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[8262, 286, 57, 1, 70, "MoreAboutSection",
 CellID->61960256],
Cell[8322, 289, 159, 3, 70, "MoreAbout",
 CellID->13145500],
Cell[8484, 294, 162, 3, 70, "MoreAbout",
 CellID->82588414]
}, Open  ]],
Cell[8661, 300, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

