(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8144,        267]
NotebookOptionsPosition[      6258,        210]
NotebookOutlinePosition[      7440,        241]
CellTagsIndexPosition[      7397,        238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GetClass" :> 
          Documentation`HelpLookup["paclet:JLink/ref/GetClass"], "JavaClass" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaClass"], "ClassName" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ClassName"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GetClass\"\>", 
       2->"\<\"JavaClass\"\>", 3->"\<\"ClassName\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Classes and Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParentClass", "ObjectName",
 CellID->881295108],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ParentClass", "[", 
       StyleBox["javaclass", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the ",
     Cell[BoxData[
      ButtonBox["JavaClass",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
     " expression representing the parent class of the specified ",
     Cell[BoxData[
      ButtonBox["JavaClass",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ParentClass", "[", 
       StyleBox["javaobject", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the parent class for the class of the \
specified ",
     Cell[BoxData[
      ButtonBox["JavaObject",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->362270810]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->202947548],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetClass",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/GetClass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaClass",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaClass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClassName",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ClassName"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->333179142]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->23946081],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->387719699],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParentClass - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ParentClass", "summary" -> 
    "ParentClass[javaclass] returns the JavaClass expression representing the \
parent class of the specified JavaClass.  ParentClass[javaobject] returns the \
parent class for the class of the specified JavaObject.", "uri" -> 
    "JLink/ref/ParentClass", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"parent class"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 30, 36.5834387}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2268, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2891, 85, 53, 1, 70, "ObjectName",
 CellID->881295108],
Cell[2947, 88, 1140, 34, 70, "Usage",
 CellID->362270810]
}, Open  ]],
Cell[CellGroupData[{
Cell[4124, 127, 54, 1, 70, "SeeAlsoSection",
 CellID->202947548],
Cell[4181, 130, 722, 26, 70, "SeeAlso",
 CellID->333179142]
}, Open  ]],
Cell[CellGroupData[{
Cell[4940, 161, 56, 1, 70, "TutorialsSection",
 CellID->23946081],
Cell[4999, 164, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5273, 175, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[5993, 199, 58, 1, 70, "MoreAboutSection",
 CellID->387719699],
Cell[6054, 202, 162, 3, 70, "MoreAbout",
 CellID->82588414]
}, Open  ]],
Cell[6231, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

