(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8733,        296]
NotebookOptionsPosition[      6590,        230]
NotebookOutlinePosition[      7781,        261]
CellTagsIndexPosition[      7738,        258]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"KeepJavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/KeepJavaObject"], 
          "JavaBlock" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaBlock"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"KeepJavaObject\"\>", 
       2->"\<\"JavaBlock\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Memory Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaMemoryManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Memory Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReleaseJavaObject", "ObjectName",
 CellID->102430064],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReleaseJavaObject", "[", 
       StyleBox["javaobject", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]tells the Java memory-management system to forget \
about any references to the specified ",
     Cell[BoxData[
      ButtonBox["JavaObject",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
     " that are being maintained solely for the sake of ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11468725]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is no longer valid after the call."
}], "Notes",
 CellID->981137522],

Cell[TextData[{
 "Call ",
 Cell[BoxData["ReleaseJavaObject"], "InlineFormula"],
 " when you are completely finished with an object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and want to allow it to be garbage-collected in Java."
}], "Notes",
 CellID->45462626]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->362672742],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["KeepJavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/KeepJavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaBlock"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4298438]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->291093270],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->15820439],

Cell[TextData[ButtonBox["Java Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaMemoryManagement"]], "MoreAbout",
 CellID->14965421]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReleaseJavaObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ReleaseJavaObject", "summary" -> 
    "ReleaseJavaObject[javaobject] tells the Java memory-management system to \
forget about any references to the specified JavaObject that are being \
maintained solely for the sake of Mathematica.", "uri" -> 
    "JLink/ref/ReleaseJavaObject", "type" -> "Symbol", "label" -> 
    "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"release java object"}, "status" -> 
    "None", "built" -> "{2007, 4, 20, 15, 30, 46.1076086}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2186, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2809, 85, 59, 1, 70, "ObjectName",
 CellID->102430064],
Cell[2871, 88, 736, 21, 70, "Usage",
 CellID->11468725]
}, Open  ]],
Cell[CellGroupData[{
Cell[3644, 114, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4103, 130, 283, 11, 70, "Notes",
 CellID->981137522],
Cell[4389, 143, 276, 8, 70, "Notes",
 CellID->45462626]
}, Closed]],
Cell[CellGroupData[{
Cell[4702, 156, 54, 1, 70, "SeeAlsoSection",
 CellID->362672742],
Cell[4759, 159, 479, 17, 70, "SeeAlso",
 CellID->4298438]
}, Open  ]],
Cell[CellGroupData[{
Cell[5275, 181, 57, 1, 70, "TutorialsSection",
 CellID->291093270],
Cell[5335, 184, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5609, 195, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6329, 219, 57, 1, 70, "MoreAboutSection",
 CellID->15820439],
Cell[6389, 222, 159, 3, 70, "MoreAbout",
 CellID->14965421]
}, Open  ]],
Cell[6563, 228, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

