(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9931,        326]
NotebookOptionsPosition[      7730,        258]
NotebookOutlinePosition[      8917,        289]
CellTagsIndexPosition[      8874,        286]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JavaObjectToExpression" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaObjectToExpression"],
           "JavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaObject"], 
          "ImplementJavaInterface" :> 
          Documentation`HelpLookup[
           "paclet:JLink/ref/ImplementJavaInterface"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"JavaObjectToExpression\"\>", 
       2->"\<\"JavaObject\"\>", 
       3->"\<\"ImplementJavaInterface\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Classes and Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReturnAsJavaObject", "ObjectName",
 CellID->320801507],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReturnAsJavaObject", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]causes a Java method call or field access during the \
evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to return its result as an object reference (a ",
     Cell[BoxData[
      ButtonBox["JavaObject",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
     " expression), not a value. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->198105844]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Most Java objects are returned as references normally, but those that have \
a meaningful ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " representation are returned \"by value\". Such objects include strings, \
arrays, and the so-called wrapper classes like ",
 StyleBox["java.lang.Integer", "InlineCode"],
 ". ",
 Cell[BoxData["ReturnAsJavaObject"], "InlineFormula"],
 " overrides the normal behavior and forces any object returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to be sent only as a reference. "
}], "Notes",
 CellID->855142762],

Cell[TextData[{
 "Typically used to avoid needlessly sending large arrays of numbers back and \
forth between Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->30806320],

Cell[TextData[{
 "You can use ",
 Cell[BoxData["ReturnAsJavaObject"], "InlineFormula"],
 " to cause only a reference to be sent, then use the ",
 Cell[BoxData[
  ButtonBox["JavaObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectToExpression"]], "InlineFormula"],
 " function at the end if the final value is needed."
}], "Notes",
 CellID->351872145]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->379135817],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaObjectToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaObjectToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImplementJavaInterface",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ImplementJavaInterface"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->493834502]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->13657198],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->111567844],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReturnAsJavaObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ReturnAsJavaObject", "summary" -> 
    "ReturnAsJavaObject[expr] causes a Java method call or field access \
during the evaluation of expr to return its result as an object reference (a \
JavaObject expression), not a value. ", "uri" -> 
    "JLink/ref/ReturnAsJavaObject", "type" -> "Symbol", "label" -> 
    "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"return as java object"}, "status" -> 
    "None", "built" -> "{2007, 4, 20, 15, 30, 50.4140156}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2394, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3017, 89, 60, 1, 70, "ObjectName",
 CellID->320801507],
Cell[3080, 92, 746, 21, 70, "Usage",
 CellID->198105844]
}, Open  ]],
Cell[CellGroupData[{
Cell[3863, 118, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4322, 134, 583, 15, 70, "Notes",
 CellID->855142762],
Cell[4908, 151, 208, 7, 70, "Notes",
 CellID->30806320],
Cell[5119, 160, 384, 10, 70, "Notes",
 CellID->351872145]
}, Closed]],
Cell[CellGroupData[{
Cell[5540, 175, 54, 1, 70, "SeeAlsoSection",
 CellID->379135817],
Cell[5597, 178, 778, 26, 70, "SeeAlso",
 CellID->493834502]
}, Open  ]],
Cell[CellGroupData[{
Cell[6412, 209, 56, 1, 70, "TutorialsSection",
 CellID->13657198],
Cell[6471, 212, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[6745, 223, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[7465, 247, 58, 1, 70, "MoreAboutSection",
 CellID->111567844],
Cell[7526, 250, 162, 3, 70, "MoreAbout",
 CellID->82588414]
}, Open  ]],
Cell[7703, 256, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

