(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9421,        315]
NotebookOptionsPosition[      7301,        249]
NotebookOutlinePosition[      8464,        280]
CellTagsIndexPosition[      8421,        277]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InstanceOf" :> 
          Documentation`HelpLookup["paclet:JLink/ref/InstanceOf"], 
          "JavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaObject"], "JavaNew" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaNew"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InstanceOf\"\>", 
       2->"\<\"JavaObject\"\>", 3->"\<\"JavaNew\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"], 
          "Java Memory Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaMemoryManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Java Classes and Objects\"\>", 
       2->"\<\"Java Memory Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SameObjectQ", "ObjectName",
 CellID->20577619],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SameObjectQ", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["object", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["object", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if and only if the ",
     Cell[BoxData[
      ButtonBox["JavaObject",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
     " expressions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["object", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["object", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " refer to the same Java object. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->266692000]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SameObjectQ"], "InlineFormula"],
 " behaves like the Java language's == operator as applied to object \
references."
}], "Notes",
 CellID->12326890]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->282799726],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstanceOf",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/InstanceOf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaNew",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaNew"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14778137]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->765964529],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->188116069],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414],

Cell[TextData[ButtonBox["Java Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaMemoryManagement"]], "MoreAbout",
 CellID->14965421]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SameObjectQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "SameObjectQ", "summary" -> 
    "SameObjectQ[Subscript[object, 1], Subscript[object, 2]] returns True if \
and only if the JavaObject expressions Subscript[object, 1] and \
Subscript[object, 2] refer to the same Java object. ", "uri" -> 
    "JLink/ref/SameObjectQ", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"same object"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 30, 52.6473383}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2450, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3073, 89, 52, 1, 70, "ObjectName",
 CellID->20577619],
Cell[3128, 92, 1163, 38, 70, "Usage",
 CellID->266692000]
}, Open  ]],
Cell[CellGroupData[{
Cell[4328, 135, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4787, 151, 179, 5, 70, "Notes",
 CellID->12326890]
}, Closed]],
Cell[CellGroupData[{
Cell[5003, 161, 54, 1, 70, "SeeAlsoSection",
 CellID->282799726],
Cell[5060, 164, 723, 26, 70, "SeeAlso",
 CellID->14778137]
}, Open  ]],
Cell[CellGroupData[{
Cell[5820, 195, 57, 1, 70, "TutorialsSection",
 CellID->765964529],
Cell[5880, 198, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[6154, 209, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6874, 233, 58, 1, 70, "MoreAboutSection",
 CellID->188116069],
Cell[6935, 236, 162, 3, 70, "MoreAbout",
 CellID->82588414],
Cell[7100, 241, 159, 3, 70, "MoreAbout",
 CellID->14965421]
}, Open  ]],
Cell[7274, 247, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

