(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7552,        270]
NotebookOptionsPosition[      5740,        212]
NotebookOutlinePosition[      6758,        241]
CellTagsIndexPosition[      6715,        238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fields" :> Documentation`HelpLookup["paclet:JLink/ref/Fields"],
           "JavaNew" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaNew"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Fields\"\>", 
       2->"\<\"JavaNew\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetField", "ObjectName",
 CellID->174433299],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetField", "[", 
       RowBox[{
        RowBox[{
         StyleBox["obj", "TI"], "@", 
         StyleBox["field", "TI"]}], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]sets a value of an object field. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->89634504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SetField", "[", 
   RowBox[{
    RowBox[{
     StyleBox["obj", "TI"], "@", 
     StyleBox["field", "TI"]}], ",", 
    StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
 " is an alternative syntax to ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 "@",
 Cell[BoxData[
  StyleBox["field", "TI"]], "InlineFormula"],
 " = ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1257845499],

Cell[TextData[{
 "For static methods, use ",
 Cell[BoxData[
  RowBox[{"SetField", "[", 
   RowBox[{
    StyleBox["staticfield", "TI"], ",", 
    StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
 "instead of ",
 Cell[BoxData[
  StyleBox["staticfield", "TI"]], "InlineFormula"],
 " = ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->780280625]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->398028515],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fields",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/Fields"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaNew",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaNew"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->319930435]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->70247815],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetField - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "SetField", "summary" -> 
    "SetField[obj@field, val] sets a value of an object field. ", "uri" -> 
    "JLink/ref/SetField", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"set field"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 30, 57.0639092}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1548, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2171, 68, 50, 1, 70, "ObjectName",
 CellID->174433299],
Cell[2224, 71, 508, 16, 70, "Usage",
 CellID->89634504]
}, Open  ]],
Cell[CellGroupData[{
Cell[2769, 92, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3228, 108, 476, 19, 70, "Notes",
 CellID->1257845499],
Cell[3707, 129, 383, 15, 70, "Notes",
 CellID->780280625]
}, Closed]],
Cell[CellGroupData[{
Cell[4127, 149, 54, 1, 70, "SeeAlsoSection",
 CellID->398028515],
Cell[4184, 152, 461, 17, 70, "SeeAlso",
 CellID->319930435]
}, Open  ]],
Cell[CellGroupData[{
Cell[4682, 174, 56, 1, 70, "TutorialsSection",
 CellID->70247815],
Cell[4741, 177, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5015, 188, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[5713, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

