(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8980,        297]
NotebookOptionsPosition[      6733,        228]
NotebookOutlinePosition[      7967,        260]
CellTagsIndexPosition[      7924,        257]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JavaShow" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaShow"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JavaShow\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaConnectionManagement"], 
          "Java User Interfaces" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaUserInterfaces"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Java Connection Management\"\>", 
       2->"\<\"Java User Interfaces\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShowJavaConsole", "ObjectName",
 CellID->195186565],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowJavaConsole", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]displays the Java console window and begins capturing \
output sent to the Java ",
     Cell[BoxData[
      RowBox[{"System", ".", "out"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{"System", ".", "err"}]], "InlineFormula"],
     " streams. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowJavaConsole", "[", "\"\<stdout\>\"", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]captures only ",
     Cell[BoxData[
      RowBox[{"System", ".", "out"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowJavaConsole", "[", "\"\<stederr\>\"", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]captures only ",
     Cell[BoxData[
      RowBox[{"System", ".", "err"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->95472760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Anything written to these streams before ",
 Cell[BoxData["ShowJavaConsole"], "InlineFormula"],
 " is first called will not appear, but subsequent output will be captured \
even if the window is closed and reopened. "
}], "Notes",
 CellID->444412971],

Cell["Only the most recent 1000 lines of output are displayed. ", "Notes",
 CellID->36619417]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->190946818],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["JavaShow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaShow"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->502757274]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->35220805],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->664155216],

Cell[TextData[ButtonBox["Java Connection Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaConnectionManagement"]], "MoreAbout",
 CellID->96365605],

Cell[TextData[ButtonBox["Java User Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaUserInterfaces"]], "MoreAbout",
 CellID->82071812]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowJavaConsole - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ShowJavaConsole", "summary" -> 
    "ShowJavaConsole[] displays the Java console window and begins capturing \
output sent to the Java System.out and System.err streams. \
ShowJavaConsole[\"stdout\"] captures only System.out.  \
ShowJavaConsole[\"stederr\"] captures only System.err.", "uri" -> 
    "JLink/ref/ShowJavaConsole", "type" -> "Symbol", "label" -> 
    "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"show java console"}, "status" -> "None",
     "built" -> "{2007, 4, 20, 15, 31, 3.7138028}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2225, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2848, 86, 57, 1, 70, "ObjectName",
 CellID->195186565],
Cell[2908, 89, 1147, 36, 70, "Usage",
 CellID->95472760]
}, Open  ]],
Cell[CellGroupData[{
Cell[4092, 130, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4551, 146, 268, 6, 70, "Notes",
 CellID->444412971],
Cell[4822, 154, 93, 1, 70, "Notes",
 CellID->36619417]
}, Closed]],
Cell[CellGroupData[{
Cell[4952, 160, 54, 1, 70, "SeeAlsoSection",
 CellID->190946818],
Cell[5009, 163, 206, 6, 70, "SeeAlso",
 CellID->502757274]
}, Open  ]],
Cell[CellGroupData[{
Cell[5252, 174, 56, 1, 70, "TutorialsSection",
 CellID->35220805],
Cell[5311, 177, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5585, 188, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6305, 212, 58, 1, 70, "MoreAboutSection",
 CellID->664155216],
Cell[6366, 215, 167, 3, 70, "MoreAbout",
 CellID->96365605],
Cell[6536, 220, 155, 3, 70, "MoreAbout",
 CellID->82071812]
}, Open  ]],
Cell[6706, 226, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

