(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7314,        248]
NotebookOptionsPosition[      5433,        189]
NotebookOutlinePosition[      6530,        219]
CellTagsIndexPosition[      6487,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"J/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ConnectToFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ConnectToFrontEnd"], 
          "CloseFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/CloseFrontEnd"], 
          "$FrontEndLaunchCommand" :> 
          Documentation`HelpLookup["paclet:JLink/ref/$FrontEndLaunchCommand"],
           "$FrontEndInitializationFunction" :> 
          Documentation`HelpLookup[
           "paclet:JLink/ref/$FrontEndInitializationFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ConnectToFrontEnd\"\>", 
       2->"\<\"CloseFrontEnd\"\>", 3->"\<\"$FrontEndLaunchCommand\"\>", 
       4->"\<\"$FrontEndInitializationFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UseFrontEnd", "ObjectName",
 CellID->29401441],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"UseFrontEnd", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in an environment where the kernel can make use of the services of the \
notebook front end."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->610454519]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The most important such service is producing images involving typeset \
expressions.\
\>", "Notes",
 CellID->194300681],

Cell["The front end will be launched if required.", "Notes",
 CellID->91172907],

Cell["\<\
This function will typically be called only from an external program that is \
driving the kernel, not from code executing in a front end notebook.\
\>", "Notes",
 CellID->111709060]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->476274995],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConnectToFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ConnectToFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/CloseFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$FrontEndLaunchCommand",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/$FrontEndLaunchCommand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$FrontEndInitializationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/$FrontEndInitializationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->243189307]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->38908446],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UseFrontEnd - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "UseFrontEnd", "summary" -> 
    "UseFrontEnd[expr] evaluates expr in an environment where the kernel can \
make use of the services of the notebook front end.", "uri" -> 
    "JLink/ref/UseFrontEnd", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"use front end"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 31, 8.1904631}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1735, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2358, 71, 52, 1, 70, "ObjectName",
 CellID->29401441],
Cell[2413, 74, 544, 16, 70, "Usage",
 CellID->610454519]
}, Open  ]],
Cell[CellGroupData[{
Cell[2994, 95, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3453, 111, 129, 4, 70, "Notes",
 CellID->194300681],
Cell[3585, 117, 79, 1, 70, "Notes",
 CellID->91172907],
Cell[3667, 120, 192, 4, 70, "Notes",
 CellID->111709060]
}, Closed]],
Cell[CellGroupData[{
Cell[3896, 129, 54, 1, 70, "SeeAlsoSection",
 CellID->476274995],
Cell[3953, 132, 1071, 35, 70, "SeeAlso",
 CellID->243189307]
}, Open  ]],
Cell[CellGroupData[{
Cell[5061, 172, 56, 1, 70, "TutorialsSection",
 CellID->38908446],
Cell[5120, 175, 271, 9, 70, "Tutorials",
 CellID->281642142]
}, Open  ]],
Cell[5406, 187, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

