(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    831056,      26537]
NotebookOptionsPosition[    613078,      19431]
NotebookOutlinePosition[    737868,      23238]
CellTagsIndexPosition[    729455,      23023]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Tutorial"
    }], "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Calling Java from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["Preamble", "Section",
 CellTags->"TableOfContents_1.5.1",
 CellID->23811],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users with the ability to interact with arbitrary Java classes directly \
from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can create objects and call methods directly in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. You do not need to write any Java code, or prepare in any way \
the Java classes you want to use. You also do not need to know anything about \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". In effect, all of Java becomes a transparent extension to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", almost as if every existing and future Java class were written in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language itself."
}], "Text",
 CellTags->"jlug:5.1.0.0",
 CellID->31322],

Cell[TextData[{
 "We call this facility \[OpenCurlyDoubleQuote]installable Java\
\[CloseCurlyDoubleQuote] because it generalizes the ability that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has always had to plug in extensions written in other languages through \
the ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " function. We will see later how ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " vastly simplifies this procedure for Java compared to languages like C or \
C++. In fact, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " makes the procedure go away completely, which is why we say that Java \
becomes a transparent extension to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.1.0.0",
 CellID->30333],

Cell[TextData[{
 "Although Java is often referred to as an interpreted language, this is \
really a misnomer. To use Java you must write a complete program, compile it, \
and then execute it (some environments exist that let you interactively \
execute lines of Java code, but these are special tools, and similar tools \
exist for traditional languages like C). ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users have the luxury of working in a true interpreted, interactive \
environment that lets them experiment with functions and build and test \
programs a line at a time. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " brings this same productive environment to Java programmers. You could say \
that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " becomes a scripting language for Java."
}], "Text",
 CellTags->"jlug:5.1.0.0",
 CellID->17673],

Cell[TextData[{
 "To ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users, then, the \[OpenCurlyDoubleQuote]installable Java\
\[CloseCurlyDoubleQuote] feature of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " opens up the expanding universe of Java classes as an extension to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "; for Java users, it allows the extraordinarily powerful and versatile ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment to be used as a shell for interactively developing, \
experimenting with, and testing Java classes."
}], "Text",
 CellTags->"jlug:5.1.0.0",
 CellID->4664]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Loading the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " Package"
}], "Section",
 CellTags->{"jlug:5.2.1.0", "TableOfContents_1.5.2.1"},
 CellID->19690],

Cell[TextData[{
 "The first step is to load the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " package file."
}], "Text",
 CellTags->"jlug:5.2.1.0",
 CellID->1650],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<JLink`\>\"", "]"}]], "Input",
 CellTags->"jlug:5.2.1.0",
 CellLabel->"In[1]:=",
 CellID->5662]
}, Open  ]],

Cell[CellGroupData[{

Cell["Launching the Java Runtime", "Section",
 CellTags->{"jlug:5.2.2.0", "TableOfContents_1.5.2.2"},
 CellID->21634],

Cell[CellGroupData[{

Cell["InstallJava", "Subsection",
 CellTags->{"jlug:5.2.2.1", "TableOfContents_1.5.2.2.1"},
 CellID->10893],

Cell[TextData[{
 "The next step is to launch the Java runtime and \
\[OpenCurlyDoubleQuote]install",
 "\[CloseCurlyDoubleQuote] ",
 "it into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The function for this is ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.2.2.1",
 CellID->10353],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["InstallJava",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/InstallJava"], "[", "]"}], Cell[
    TextData[{
     "launch the Java runtime and prepare it for use from ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText",
     CellTags->"jlug:5.2.2.1"]},
   {
    RowBox[{
     ButtonBox["ReinstallJava",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ReinstallJava"], "[", "]"}], Cell[
    "Quit and restart the Java runtime if it is already running", "TableText",
     
     CellTags->"jlug:5.2.2.1"]},
   {
    RowBox[{
     ButtonBox["JavaLink",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaLink"], "[", "]"}], Cell[TextData[{
     "give the ",
     ButtonBox["LinkObject",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkObject"],
     " that is being used to communicate with the Java runtime"
    }], "TableText",
     CellTags->"jlug:5.2.2.1"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.2.2.1",
 CellID->21416],

Cell["Launching the Java runtime.", "Caption",
 CellTags->"jlug:5.2.2.1",
 CellID->13452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallJava", "[", "]"}]], "Input",
 CellTags->"jlug:5.2.2.1",
 CellLabel->"In[2]:=",
 CellID->14008],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"d:\\\\jdk122\\\\bin\\\\java\"\>", ",", "5", ",", "2"}], 
  "]"}]], "Output",
 CellTags->"jlug:5.2.2.1",
 CellLabel->"Out[2]=",
 CellID->7262]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " can be called more than once in a session. On every call after the first, \
it does nothing. Thus, it is safe to call ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " in any program you write, without considering whether the user has already \
called it. In ."
}], "Text",
 CellTags->"jlug:5.2.2.1",
 CellID->22233],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " creates a command line that is used to launch the Java runtime (typically \
called \[OpenCurlyQuote]java\[CloseCurlyQuote]) and specify some initial \
arguments for it. In rare cases you will need to control what is on this \
command line, so ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " takes a number of options for this purpose. Most users will not need to \
use these options, and in fact you should avoid them. Programmers should not \
assume that they have the ability to control the launch of the Java runtime, \
as it might already be running. If for some reason you absolutely must apply \
options to control the launch of the Java runtime, use ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 " instead of InstallJava."
}], "Text",
 CellTags->"jlug:5.2.2.1",
 CellID->5454],

Cell[BoxData[GridBox[{
   {
    RowBox[{"ClassPath", " ", "\[Rule]", " ", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "use the default class path of your Java runtime", "TableText"]},
   {
    RowBox[{"ClassPath", " ", "\[Rule]", " ", "\"\<dirs\>\""}], Cell[
    "use the specified directories and jar files", "TableText"]},
   {
    RowBox[{"CommandLine", " ", "\[Rule]", " ", "\"\<cmd\>\""}], Cell["\<\
use the specified command line to launch the Java runtime, instead of \
\[OpenCurlyDoubleQuote]java\[CloseCurlyDoubleQuote]\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.2.2.1",
 CellID->16634],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"jlug:5.2.2.1",
 CellID->26303]
}, Open  ]],

Cell[CellGroupData[{

Cell["Controlling the Command Used to Launch Java", "Subsection",
 CellTags->{"jlug:5.2.2.2", "TableOfContents_1.5.2.2.2"},
 CellID->14256],

Cell[TextData[{
 "An important option to ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 " is ",
 StyleBox["CommandLine", "MR"],
 ". This specifies the first part of the command line used to launch Java. \
One use for this option is if you have more than one Java runtime installed \
on your system, and you want to invoke a specific one: "
}], "Text",
 CellTags->"jlug:5.2.2.2",
 CellID->148],

Cell[BoxData[
 RowBox[{"ReinstallJava", "[", 
  RowBox[{
  "CommandLine", "\[Rule]", "\"\<d:\\\\full\\\\path\\\\to\\\\java.exe\>\""}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.2.2",
 CellID->11124],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " will launch the Java runtime that is bundled with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.2 and later. If you have an earlier version of ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " the default command line that will be used is ",
 StyleBox["java", "MR"],
 " on most systems. If the ",
 StyleBox["java", "MR"],
 " executable is not on your system path, you can use ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " to point at it. Another use for this option is to specify arguments to \
Java that are not covered by other options. Here is an example that specifies \
verbose garbage collection and defines a property named ",
 StyleBox["foo", "MR"],
 " to have the value ",
 StyleBox["bar", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.2.2.2",
 CellID->12317],

Cell[BoxData[
 RowBox[{"ReinstallJava", "[", 
  RowBox[{
  "CommandLine", "\[Rule]", "\"\</path/to/java -verbosegc -Dfoo=bar\>\""}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.2.2",
 CellID->4213]
}, Open  ]],

Cell[CellGroupData[{

Cell["Overriding the Class Path", "Subsection",
 CellTags->{"jlug:5.2.2.3", "TableOfContents_1.5.2.2.3"},
 CellID->27109],

Cell[TextData[{
 "The class path is the set of directories in which the Java runtime looks \
for classes. When you launch a Java program from your \
system\[CloseCurlyQuote]s command line, the class path used by Java includes \
some default locations and any locations specified in the ",
 StyleBox["CLASSPATH", "MR"],
 " environment variable, if it exists. If you use the ",
 StyleBox["-classpath", "MR"],
 " command-line option to specify a set of locations, however, then the ",
 StyleBox["CLASSPATH", "MR"],
 " environment variable is ignored. The ",
 StyleBox["ClassPath", "MR"],
 " option to ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 " works the same way. If you leave it at the default value, ",
 StyleBox["Automatic", "MR"],
 ", then ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will include the contents of the ",
 StyleBox["CLASSPATH", "MR"],
 " environment variable in its class search path. If you set it to ",
 StyleBox["None", "MR"],
 " or a string, then the contents of ",
 StyleBox["CLASSPATH", "MR"],
 " are not used. If you set it to be a string, use the same syntax that you \
would use for setting the ",
 StyleBox["CLASSPATH", "MR"],
 " environment variable, which is different for Windows and Unix:"
}], "Text",
 CellTags->"jlug:5.2.2.3",
 CellID->24028],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReinstallJava", "[", 
   RowBox[{
   "ClassPath", "\[Rule]", 
    "\"\<c:\\\\my\\\\java\\\\dir;d:\\\\MyJavaStuff.jar\>\""}], "]"}], "  ", 
  RowBox[{"(*", " ", "Windows", " ", "*)"}]}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.2.3",
 CellID->29200],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReinstallJava", "[", 
   RowBox[{
   "ClassPath", "\[Rule]", "\"\</my/java/dir:/home/me/MyJavaStuff.jar\>\""}], 
   "]"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"Unix", "/", "Linux"}], " ", "*)"}]}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.2.3",
 CellID->36235640],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has its own mechanism for controlling the class search path that is very \
flexible. Not only does ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " automatically search for classes in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application directories, it also lets you dynamically add new search \
locations while the Java runtime is running. This means that using the ",
 StyleBox["ClassPath", "MR"],
 " option to configure the class path when Java first launches is not very \
important. One setting for the ",
 StyleBox["ClassPath", "MR"],
 " option that is sometimes useful is ",
 StyleBox["None", "MR"],
 ", to prevent ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " from finding any classes from the contents of ",
 StyleBox["CLASSPATH", "MR"],
 ". You might want to do this if you had an experimental version of some \
class in a development directory and you wanted to make sure that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " used that version in preference to an older one that was present on your \
",
 StyleBox["CLASSPATH", "MR"],
 ". ",
 ButtonBox["The Java Class Path",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#12623"],
 " presents a complete treatment of the subject of how ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " searches for classes, and how to add locations to this search path."
}], "Text",
 CellTags->"jlug:5.2.2.3",
 CellID->21080]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loading Classes", "Section",
 CellTags->{"jlug:5.2.3.0", "TableOfContents_1.5.2.3"},
 CellID->24948],

Cell[CellGroupData[{

Cell["LoadJavaClass", "Subsection",
 CellTags->{"jlug:5.2.3.1", "TableOfContents_1.5.2.3.1"},
 CellID->1282],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LoadJavaClass",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/LoadJavaClass"], "[", "\"\<classname\>\"",
      "]"}], Cell[TextData[{
     "load the specified class into Java and ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{"LoadClass", "[", "\"\<classname\>\"", "]"}], Cell[TextData[{
     "deprecated name from earlier versions of ",
     StyleBox["J/Link",
      FontSlant->"Italic"],
     "; use ",
     ButtonBox["LoadJavaClass",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/LoadJavaClass"],
     " instead"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.2.3.1",
 CellID->13653],

Cell["Loading classes.", "Caption",
 CellTags->"jlug:5.2.3.1",
 CellID->30674],

Cell[TextData[{
 "To use a Java class in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it must first be loaded into the Java runtime and certain definitions \
must be set up in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This is accomplished with the ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " function. ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " takes a string specifying the fully qualified name of the class (i.e., the \
full hierarchical name with all the periods):"
}], "Text",
 CellTags->"jlug:5.2.3.1",
 CellID->2220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"urlClass", "=", 
  RowBox[{"LoadJavaClass", "[", "\"\<java.net.URL\>\"", "]"}]}]], "Input",
 CellTags->"jlug:5.2.3.1",
 CellLabel->"In[1]:=",
 CellID->5402],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"JavaClass", "[", "\<\"java.net.URL\"\>", "]"}],
  JavaClass["java.net.URL", 0]]], "Output",
 CellTags->"jlug:5.2.3.1",
 CellLabel->"Out[1]=",
 CellID->6923]
}, Open  ]],

Cell[TextData[{
 "The return value is an expression with head ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 ". This ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expression can be used in many places in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", so you might want to assign it to a variable as we do here. Virtually \
everywhere in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " where a class needs to be specified as an argument, you can use either a \
",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expression, the fully qualified class name as a string, or an object of \
the class. Note that you cannot create a valid ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expression by simply typing it in\[LongDash]it must be returned by ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.2.3.1",
 CellID->3831],

Cell[TextData[{
 "When a class has been loaded, you can call static methods in the class, \
create objects of the class, and invoke methods and access fields of these \
objects. You can use any ",
 StyleBox["public",
  FontSlant->"Italic"],
 " constructors, methods, or fields of a class."
}], "Text",
 CellTags->"jlug:5.2.3.1",
 CellID->19369],

Cell[BoxData[GridBox[{
   {
    RowBox[{"StaticsVisible", " ", "\[Rule]", " ", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell["\<\
make static methods and fields accessible by just their names, not in a \
special context\
\>", "TableText"]},
   {
    RowBox[{"AllowShortContext", " ", "\[Rule]", " ", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell["\<\
make static methods and fields accessible only in their fully qualified class \
context\
\>", "TableText"]},
   {
    RowBox[{"UseTypeChecking", " ", "\[Rule]", " ", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell["\<\
suppress the type checking that is normally inserted in definitions for calls \
into Java\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.2.3.1",
 CellID->3878],

Cell[TextData[{
 "Options for ",
 StyleBox[ButtonBox["LoadJavaClass",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/LoadJavaClass"], "InlineCode"],
 "."
}], "Caption",
 CellTags->"jlug:5.2.3.1",
 CellID->20259],

Cell[TextData[{
 ButtonBox["The Java Class Path",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#12623"],
 " discusses the details of how and where",
 StyleBox[" J/Link",
  FontSlant->"Italic"],
 " finds classes. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will be able to find classes on the class path, in the special Java \
extensions directory, and in a set of extra directories that users can \
control even while ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is running."
}], "Text",
 CellTags->"jlug:5.2.3.1",
 CellID->19008]
}, Open  ]],

Cell[CellGroupData[{

Cell["When to Call LoadJavaClass", "Subsection",
 CellTags->{"jlug:5.2.3.2", "TableOfContents_1.5.2.3.2"},
 CellID->22619],

Cell[TextData[{
 "It is often the case that you do not need to explicitly load a class with \
",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 ". As described later, when you create a Java object with ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ", you can supply the class name as a string. If the class has not already \
been loaded, ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " will be called internally by ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ". In fact, anytime a Java object is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " its class is loaded automatically if necessary. This would seem to imply \
that there is little reason to use ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 ". There are a number of reasons why you would want or need to use ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " explicitly:"
}], "Text",
 CellTags->"jlug:5.2.3.2",
 CellID->23971],

Cell["\<\
 You need to call a static method of a class and you will not create, or have \
not yet created, an object of that class. A class must be loaded before any \
of its static methods can be called.\
\>", "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->30003],

Cell[TextData[{
 "You need to use one of the options to ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 ". When ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " is called internally by ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ", it is called with the default option settings."
}], "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->21945],

Cell["\<\
 You want to see errors associated with loading a class reported at a \
well-defined time.\
\>", "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->9781],

Cell["\<\
You want to control where your users experience the initial delay associated \
with loading a class. Loading a class can take several seconds if it or one \
of its parent classes is very large (although it rarely takes that long). You \
might want to avoid a mysterious delay in a function that users expect to be \
very quick.\
\>", "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->26504],

Cell[TextData[{
 "You want to hang on to the ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expression returned by ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " to use it in other functions. Although all functions that take a ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " can also take a class name string, you might prefer to use a named ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " variable for readability purposes. It is also slightly faster than using a \
string, but this will not be perceptible unless you are using it many times \
in a loop."
}], "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->12392],

Cell[CellGroupData[{

Cell["You feel that it makes your code more self-documenting.", "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->32685],

Cell[TextData[{
 "The operation of loading a class in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is only done once in a ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " session (a session is the period between ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["UninstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFormula"],
 "). You can call ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " on a given class as many times as you want, and every call after the first \
one immediately returns the ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expression without doing any work. This is important, as it means that you \
never have to worry whether a class has been loaded already\[LongDash]if you \
are not sure, call ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.2.3.2",
 CellID->25313],

Cell[TextData[{
 "Developers writing code for a wide audience should always call ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " on any classes they need in every function that needs them. It is not \
suitable to call ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " in the body of your package code when it is read in, as the user may quit \
and restart the Java runtime (i.e., ",
 Cell[BoxData[
  ButtonBox["UninstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 ") after your package was read. To be safe, every user-level function that \
uses ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " should call ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " (if ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " is necessary; see below). Both calls execute very quickly if they are not \
needed."
}], "Text",
 CellTags->"jlug:5.2.3.2",
 CellID->6698],

Cell[TextData[{
 "As mentioned above, loading a class can take several seconds in some cases. \
When a class is loaded, all of its superclasses are loaded in succession, \
walking up the inheritance hierarchy. Because a given class is only actually \
loaded once, if you load another class that shares some of the same \
superclasses as a previously-loaded class, these superclasses will not have \
to be loaded again. This means that loading the second class will be much \
quicker than the first if any of the shared superclasses were large. An \
example of this is loading classes in the java.awt package. The class ",
 StyleBox["java.awt.Component", "MR"],
 " is very large, so the first time you load a class that inherits from it, \
say ",
 StyleBox["java.awt.Button", "MR"],
 ", there will be a noticeable delay. Subsequent loading of other classes \
derived from ",
 StyleBox["Component", "MR"],
 " will be much quicker."
}], "Text",
 CellTags->"jlug:5.2.3.2",
 CellID->5589]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Contexts and Visibility of Static Members", "Subsection",
 CellTags->{"jlug:5.2.3.3", "TableOfContents_1.5.2.3.3"},
 CellID->12722],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " has two options that let you control the naming and visibility of static \
methods and fields. To understand these options, you need to understand the \
problems they help to solve. We have to get a bit ahead of ourselves to \
explain the issues, since we have not yet discussed how to call Java methods. \
When a class is loaded, definitions are created in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that allow you to call methods and access fields of objects of that class. \
Static members are treated quite differently from nonstatic ones. None of \
these issues arise for nonstatic members, so we will only be discussing \
static members in this section. Say you have a class named ",
 StyleBox["com.foobar.MyClass", "MR"],
 " that contains a static method named ",
 StyleBox["foo", "MR"],
 ". When you load this class, a definition must be set up for ",
 StyleBox["foo", "MR"],
 " so that it can be called by name, something like ",
 StyleBox["foo[args]", "MR"],
 ". The question becomes: In what context do you want the symbol ",
 StyleBox["foo", "MR"],
 " defined, and do you want this context to be visible (i.e., on ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContextPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ContextPath"], "MR"]], "InlineFormula"],
 ")?"
}], "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->5938],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " always creates a definition for ",
 StyleBox["foo", "MR"],
 " in a context that mirrors its fully qualified classname: ",
 StyleBox["com`foobar`MyClass`foo", "MR"],
 ". This is done to avoid conflicting with symbols named ",
 StyleBox["foo", "MR"],
 " that might be present in other contexts. However, you might find it clumsy \
to have to call ",
 StyleBox["foo", "MR"],
 " by typing the full context name every time, as in ",
 StyleBox["com`foobar`MyClass`foo[args]", "MR"],
 ". The option ",
 StyleBox["AllowShortContext->", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " (this is the default setting) causes ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to also make definitions for ",
 StyleBox["foo", "MR"],
 " accessible in a shortened context, one that consists of just the class \
name without the hierarchical package name prefix. In our example, this means \
that you could call ",
 StyleBox["foo", "MR"],
 " as simply ",
 StyleBox["MyClass`foo[args]", "MR"],
 ". If you need to avoid use of the short context because there is already a \
context of the same name in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you can use ",
 StyleBox["AllowShortContext->", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "MR"]], "InlineFormula"],
 ". This forces all names to be put only in the \[OpenCurlyDoubleQuote]deep\
\[CloseCurlyDoubleQuote] context. Note that even with ",
 StyleBox["AllowShortContext->", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 ", names for statics are also put into the deep context, so you can always \
use the deep context to refer to a symbol if you desire."
}], "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->19037],

Cell[TextData[{
 StyleBox["AllowShortContext", "MR"],
 ", then, lets you control the context where the symbol names are defined. \
The other option, ",
 StyleBox["StaticsVisible", "MR"],
 ", controls whether this context is made visible (put on ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContextPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ContextPath"], "MR"]], "InlineFormula"],
 ") or not. The default is ",
 StyleBox["StaticsVisible->", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "MR"]], "InlineFormula"],
 ", so you have to use a context name when referring to a symbol, as in ",
 StyleBox["MyClass`foo[args]", "MR"],
 ". With ",
 StyleBox["StaticsVisible->", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 StyleBox[", MyClass`", "MR"],
 " will be put on ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContextPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ContextPath"], "MR"]], "InlineFormula"],
 ", so you could just write ",
 StyleBox["foo[args]", "MR"],
 ". Having the default be ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " would be a bit dangerous\[LongDash]every time you load a class a \
potentially large number of names would suddenly be created and made visible \
in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, opening up the possibility for all sorts of  \
\[OpenCurlyDoubleQuote]shadowing\[CloseCurlyDoubleQuote] problems if symbols \
of the same names were already present. This problem is particularly acute \
with Java, because method and field names in Java typically begin with a \
lowercase letter, which is also the convention for user-defined symbols in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Some Java classes define static methods and fields with names like ",
 StyleBox["x", "MR"],
 ",  ",
 StyleBox["y", "MR"],
 ", ",
 StyleBox["width", "MR"],
 ", and so on, so shadowing errors are very likely to occur (see ",
 ButtonBox["Contexts",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Contexts"],
 " for a discussion of contexts and shadowing problems)."
}], "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->6410],

Cell[TextData[{
 "For these reasons ",
 StyleBox["StaticsVisible->", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " is recommended only for classes that you have written, or ones whose \
contents you are familiar with. In such cases, it can save you some typing, \
make your code more readable, and prevent the all-too-easy bug of forgetting \
to type the package prefix. A classic example would be implementing the \
venerable \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " example program. In Java, it might look like this:"
}], "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->31461],

Cell["\<\
public class AddTwo {
\tpublic static int addtwo(int i, int j) {return i + j;}
}\
\>", "Program",
 CellTags->"jlug:5.2.3.3",
 CellID->6234],

Cell[TextData[{
 "With the default ",
 StyleBox["StaticsVisible->", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "MR"]], "InlineFormula"],
 ", you would have to call addtwo as ",
 StyleBox["AddTwo`addtwo[3, 4]", "MR"],
 ". ",
 StyleBox["Setting StaticsVisible->", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " lets you write the more obvious ",
 StyleBox["addtwo[3, 4]", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->12508],

Cell[TextData[{
 "Be reminded that these options are only for ",
 StyleBox["static", "TI"],
 " methods and fields. As discussed later, ",
 "nonstatic",
 "s are handled in a way that makes context and visibility issues go away \
completely."
}], "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->9961]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inner Classes", "Subsection",
 CellTags->{"jlug:5.2.3.4", "TableOfContents_1.5.2.3.4"},
 CellID->3959],

Cell[TextData[{
 "Inner classes are public classes defined inside another public class. For \
example, the class ",
 StyleBox["javax.swing.Box", "MR"],
 " has an inner class named ",
 StyleBox["Filler", "MR"],
 ". When you refer to the ",
 StyleBox["Filler", "MR"],
 " class in a Java program, you typically use the outer class name, followed \
by a period, then the inner class name:"
}], "Text",
 CellTags->"jlug:5.2.3.4",
 CellID->6493],

Cell["\<\
Box.Filler f = new Box.Filler(\[Ellipsis]);\
\>", "Program",
 CellTags->"jlug:5.2.3.4",
 CellID->1515],

Cell[TextData[{
 "You can use inner classes with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", but you need to use the true internal name of the class, which has a $, \
not a period, separating the outer and inner class names:"
}], "Text",
 CellTags->"jlug:5.2.3.4",
 CellID->25269],

Cell[BoxData[
 RowBox[{"filler", "=", 
  RowBox[{"JavaNew", "[", 
   RowBox[{"\"\<java.swing.Box$Filler\>\"", ",", " ", "\[Ellipsis]"}], 
   "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.3.4",
 CellID->24937],

Cell["\<\
If you look at the class files produced by the Java compiler, you will see \
these $-separated class names for inner classes.\
\>", "Text",
 CellTags->"jlug:5.2.3.4",
 CellID->28869]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Conversion of Types Between Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Section",
 CellTags->{"TableOfContents_1.5.2.4", "1.1.4", "jlug:5.2.4.0"},
 CellID->17780],

Cell[TextData[{
 "Before we encounter the operations of creating Java objects and calling \
methods, we should examine the mapping of types between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java. When a Java method returns a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the result is automatically converted into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. For example, Java integer types (e.g., byte, short, int, and \
so on), are converted into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " integers, and Java real number types (float, double) are converted into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reals. The table below shows the complete set of conversions. These \
conversions work both ways\[LongDash]for example, when a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " integer is sent to a Java method that requires a byte value, the integer \
is automatically converted to a Java byte."
}], "Text",
 CellTags->"jlug:5.2.4.0",
 CellID->22578],

Cell[BoxData[GridBox[{
   {Cell["Java type", "TableHeader"], Cell[
    "Mathematica Type", "TableHeader"]},
   {
    RowBox[{
    "byte", ",", " ", "char", ",", " ", "short", ",", " ", "int", ",", " ", 
     "long"}], Cell[TextData[ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"]], "TableText"]},
   {
    RowBox[{
    "Byte", ",", " ", "Character", ",", " ", "Short", ",", " ", "Integer", 
     ",", " ", "Long", ",", " ", "BigInteger"}], Cell[TextData[ButtonBox[
    "Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"]], "TableText"]},
   {
    RowBox[{"float", ",", " ", "double"}], Cell[TextData[ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"]], "TableText"]},
   {
    RowBox[{"Float", ",", " ", "Double", ",", " ", "BigDecimal"}], Cell[
    TextData[ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"]], "TableText"]},
   {"boolean", Cell[TextData[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " or ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]
    }], "TableText"]},
   {"String", Cell[TextData[ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"]], "TableText"]},
   {"array", Cell[TextData[ButtonBox["List",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/List"]], "TableText"]},
   {
    RowBox[{
     RowBox[{"controlled", " ", "by", " ", "user"}], "\n", 
     RowBox[{"(", 
      RowBox[{"see", " ", 
       ButtonBox[
        RowBox[{"Complex", " ", "Numbers"}],
        BaseStyle->"Link",
        ButtonData->
         "paclet:JLink/tutorial/CallingJavaFromMathematica#26063"]}], ")"}]}],
     Cell[TextData[ButtonBox["Complex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complex"]], "TableText"]},
   {"Object", Cell[TextData[ButtonBox["JavaObject",
     BaseStyle->"Link",
     ButtonData->"paclet:JLink/ref/JavaObject"]], "TableText"]},
   {"Expr", Cell["any expression", "TableText"]},
   {"null", Cell[TextData[ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"]], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"jlug:5.2.4.0",
 CellID->12931],

Cell[TextData[{
 "Corresponding types in Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Caption",
 CellTags->"jlug:5.2.4.0",
 CellID->32544],

Cell[TextData[{
 "Java arrays are mapped to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " lists of the appropriate depth. Thus, when you call a method that takes a \
double[], you might pass it ",
 StyleBox["{1.0, 2.0, N[Pi], 1.23}", "MR"],
 ". Similarly, a method that returns a two-deep array of integers (i.e., \
int[][]) might return to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the expression ",
 StyleBox["{{1, 2, 3}, {5, 3, 1}}", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.2.4.0",
 CellID->3340],

Cell[TextData[{
 "In most cases, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will let you supply a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " integer to a method that is typed to take a real type (",
 StyleBox["float", "MR"],
 " or ",
 StyleBox["double", "MR"],
 "). Similarly, a method that takes a ",
 StyleBox["double[]", "MR"],
 " could be passed a list of mixed integers and reals. The only times when \
you cannot do this are the rare cases where a method has two signatures that \
differ only in a real versus integer type at the same argument slot. For \
example, consider a class with these methods:"
}], "Text",
 CellTags->"jlug:5.2.4.0",
 CellID->13487],

Cell["\<\
public void foo(byte b, Object obj);
public void foo(float f, Object obj);
public void bar(float f, Object obj);\
\>", "Program",
 CellTags->"jlug:5.2.4.0",
 CellID->899],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " would create two ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions for the method ",
 StyleBox["foo", "MR"],
 "\[LongDash]one that required an integer for the first argument and invoked \
the first signature, and one that required a real number for the first \
argument and invoked the second signature. The definition created for the \
method ",
 StyleBox["bar", "MR"],
 " would accept an integer or a real for the first argument. In other words, \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will automatically convert integers to reals, except in cases where such \
conversion makes it ambiguous as to which signature of a given method to \
invoke. This is not strictly true, though, as ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " does not try as hard as it possibly could to determine whether real ",
 "versus",
 " integer ambiguity is a problem at every argument position. The presence of \
ambiguity at one position will cause ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to give up and require exact type matching at all argument positions. This \
is starting to sound confusing, but you will find that in most cases ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " allows you to pass integers or lists with integers to methods that take \
reals or arrays of reals, respectively, as arguments. In cases where it does \
not, the call will fail with an error message, and you will have to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 StyleBox["N", "MR"],
 " function to convert all integers to reals explicitly."
}], "Text",
 CellTags->"jlug:5.2.4.0",
 CellID->22525]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating Objects", "Section",
 CellTags->{"jlug:5.2.5.0", "TableOfContents_1.5.2.5"},
 CellID->900],

Cell[TextData[{
 "To instantiate Java objects, use the ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " function. The first argument to ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " is the object\[CloseCurlyQuote]s class, specified either as a ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expression returned from ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " or as a string giving the fully qualified class name (i.e., having the \
full package prefix with all the periods). If you wish to supply any \
arguments to the object\[CloseCurlyQuote]s constructor, they follow as a \
sequence after the class."
}], "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->32591],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["JavaNew",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaNew"], "[", 
     RowBox[{
      StyleBox["cls", "TI"], ",", 
      StyleBox["arg1", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[TextData[{
     "construct a new object of the specified class and return it to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JavaNew",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaNew"], "[", 
     RowBox[{
      StyleBox["\"\<classname\>\"", "TI"], ",", 
      StyleBox["arg1", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[TextData[{
     "construct a new object of the specified class and return it to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.2.5.0",
 CellID->18762],

Cell["Constructing Java objects.", "Caption",
 CellTags->"jlug:5.2.5.0",
 CellID->1655],

Cell[TextData[{
 "For example, this will create a new ",
 StyleBox["Frame", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->17410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"frm", "=", 
  RowBox[{"JavaNew", "[", "\"\<java.awt.Frame\>\"", "]"}]}]], "Input",
 CellTags->"jlug:5.2.5.0",
 CellLabel->"In[1]:=",
 CellID->6359],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]JavaObject", "[", "\<\"java.awt.Frame\"\>", "]"}],
    "\[RightGuillemet]"}],
  JLink`Objects`JavaObject100369839357953]], "Output",
 CellTags->"jlug:5.2.5.0",
 CellLabel->"Out[1]=",
 CellID->27624]
}, Open  ]],

Cell[TextData[{
 "The return value from ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " is a strange expression that looks like it has the head ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 ", except that it is enclosed in angle brackets. The angle brackets are used \
to indicate that the form in which the expression is displayed is quite \
different from its internal representation. These expressions will be \
referred to as ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions. ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions are displayed in a way that shows their class name, but you \
should consider them opaque, meaning that you cannot pick them apart or peer \
into their insides. You can only use them in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " functions that take ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions. For example, if ",
 StyleBox["obj", "MR"],
 " is a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 ", you cannot use ",
 StyleBox["First[obj]", "MR"],
 " to get its class name. Instead, there is a ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " function, ",
 StyleBox["ClassName[obj]", "MR"],
 ", for this purpose."
}], "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->20537],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " invokes a Java constructor appropriate for the types of the arguments \
being passed in, and then returns to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " what is, in effect, a reference to the object. That is how you should \
think of ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions\[LongDash]as references to Java objects very much like object \
references in the Java language itself. What is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is not large no matter what type of object you are constructing. In \
particular, the object\[CloseCurlyQuote]s data (that is, its fields) are not \
sent back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The actual object remains on the Java side, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gets a reference to it."
}], "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->21548],

Cell[TextData[{
 "The ",
 StyleBox["Frame", "MR"],
 " class has a second constructor, which takes a title in the form of a \
string. Here is how you would call that constructor:"
}], "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->6483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"frm", "=", 
  RowBox[{"JavaNew", "[", 
   RowBox[{"\"\<java.awt.Frame\>\"", ",", "\"\<My Example Frame\>\""}], 
   "]"}]}]], "Input",
 CellTags->"jlug:5.2.5.0",
 CellLabel->"In[2]:=",
 CellID->27595],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]JavaObject", "[", "\<\"java.awt.Frame\"\>", "]"}],
    "\[RightGuillemet]"}],
  JLink`Objects`JavaObject76386741977089]], "Output",
 CellTags->"jlug:5.2.5.0",
 CellLabel->"Out[2]=",
 CellID->4041]
}, Open  ]],

Cell[TextData[{
 "Note that simply constructing a ",
 StyleBox["Frame", "MR"],
 " does not cause it to appear. That requires a separate step (calling the \
frame\[CloseCurlyQuote]s ",
 StyleBox["show", "MR"],
 " or ",
 StyleBox["setVisible", "MR"],
 " methods will work, but as we will see later, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides a special function, ",
 Cell[BoxData[
  ButtonBox["JavaShow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaShow"]], "InlineFormula"],
 ", to make Java windows appear and come to the foreground)."
}], "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->3602],

Cell[TextData[{
 "The previous examples specified the class by giving its name as a string. \
You can also use a ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expression, which is a special expression returned by ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " that identifies a class in a particularly efficient manner. When you \
specify the class name as a string, the class is loaded if it has not already \
been."
}], "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->24350],

Cell[BoxData[{
 RowBox[{
  RowBox[{"frameClass", "=", 
   RowBox[{"LoadJavaClass", "[", "\"\<java.awt.Frame\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"frm", "=", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"frameClass", ",", "\"\<My Example Frame\>\""}], "]"}]}], 
  ";"}]}], "Input",
 CellTags->"jlug:5.2.5.0",
 CellLabel->"In[3]:=",
 CellID->10291],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " is not the only way to get a reference to a Java object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Many methods and fields return objects, and when you call such a method, \
a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression is created. Such objects can be used in the same way as ones \
you explicitly construct with ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->30836],

Cell[TextData[{
 "At this point, you may be wondering about things like reference counts and \
how objects returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " get cleaned up. These issues are discussed in ",
 ButtonBox["Object References in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#12022"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#12022"],
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->9374],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has two other functions for creating Java objects, called ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MakeJavaExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaExpr"]], "InlineFormula"],
 ". These specialized functions are described in the section ",
 ButtonBox["MakeJavaObject and MakeJavaExpr",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#29288"],
 "."
}], "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->11020]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calling Methods and Accessing Fields", "Section",
 CellTags->{"TableOfContents_1.5.2.6", "1.1.6", "jlug:5.2.6.0"},
 CellID->15615],

Cell[CellGroupData[{

Cell["Syntax", "Subsection",
 CellTags->{"jlug:5.2.6.1", "TableOfContents_1.5.2.6.1"},
 CellID->20528],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax for calling Java methods and accessing fields is very similar to \
Java syntax. The box below compares the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java ways of calling constructors, methods, fields, static methods, \
and static fields. You can see that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs that use Java are written in almost exactly the same way as Java \
programs, except ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses [] instead of () for arguments, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses @ instead of Java",
 "\[CloseCurlyQuote]",
 "s . (dot) as the \[OpenCurlyDoubleQuote]member access\
\[CloseCurlyDoubleQuote] operator."
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->13234],

Cell[TextData[{
 "An exception is that for static methods, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the context mark ` in place of Java\[CloseCurlyQuote]s dot. This \
parallels Java usage also, as Java\[CloseCurlyQuote]s use of the dot in this \
circumstance is really as a scope resolution operator (like :: in C++). \
Although ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not use this terminology, its scope resolution operator is the \
context mark. Java",
 "\[CloseCurlyQuote]",
 "s hierarchical package names map directly to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s hierarchical contexts."
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->12570],

Cell[BoxData[GridBox[{
   {" ", Cell["Constructors", "TableHeader"]},
   {
    RowBox[{"Java", ":"}], Cell[TextData[StyleBox[
    "MyClass obj = new MyClass(args);", "InlineCode"]], "TableText"]},
   {
    RowBox[{
     StyleBox["Mathematica",
      FontSlant->"Italic"], ":"}], Cell[TextData[{
     StyleBox["obj = ", "InlineCode"],
     StyleBox[ButtonBox["JavaNew",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaNew"], "InlineCode"],
     StyleBox["[\"MyClass\", args];", "InlineCode"]
    }], "TableText"]},
   {
    StyleBox[" ", "TR"], 
    StyleBox["Methods", "TableHeader"]},
   {
    RowBox[{"Java", ":"}], Cell["obj.methodName(args);", "InlineCode"]},
   {
    RowBox[{
     StyleBox["Mathematica",
      FontSlant->"Italic"], ":"}], Cell[TextData[StyleBox[
    "obj@methodName[args]", "InlineCode"]], "TableText"]},
   {
    StyleBox[" ", "TR"], 
    StyleBox["Fields", "TableHeader"]},
   {
    RowBox[{"Java", ":"}], Cell[TextData[{
     StyleBox["obj.fieldName = 1;", "InlineCode"],
     "\n",
     StyleBox["value = obj.fieldName;", "InlineCode"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Mathematica",
      FontSlant->"Italic"], ":"}], Cell[TextData[{
     StyleBox["obj@fieldName = 1;\n", "InlineCode"],
     StyleBox["value = obj@fieldName; ", "InlineCode"]
    }], "TableText"]},
   {
    StyleBox[" ", "TR"], 
    StyleBox[
     RowBox[{"Static", " ", "methods"}], "TableHeader"]},
   {
    RowBox[{"Java", ":"}], Cell[TextData[StyleBox[
    "MyClass.staticMethod(args);", "InlineCode"]], "TableText"]},
   {
    RowBox[{
     StyleBox["Mathematica",
      FontSlant->"Italic"], ":"}], Cell[TextData[StyleBox[
    "MyClass`staticMethod[args];", "InlineCode"]], "TableText"]},
   {
    StyleBox[" ", "TR"], 
    StyleBox[
     RowBox[{"Static", " ", "fields"}], "TableHeader"]},
   {
    RowBox[{"Java", ":"}], Cell[TextData[{
     StyleBox["MyClass.staticField = 1;\n", "InlineCode"],
     StyleBox["value = MyClass.staticField;", "InlineCode"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Mathematica",
      FontSlant->"Italic"], ":"}], Cell[TextData[{
     StyleBox["MyClass`staticField = 1;\n", "InlineCode"],
     StyleBox["value = MyClass`staticField;", "InlineCode"]
    }], "TableText"]}
  },
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {
     False, False, False, True, False, False, True, False, False, True, False,
       False, True, {False}, False}, "RowsIndexed" -> {}}]], "DefinitionBox",
 CellTags->"jlug:5.2.6.1",
 CellID->905],

Cell[TextData[{
 "Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax comparison."
}], "Caption",
 CellTags->"jlug:5.2.6.1",
 CellID->9464],

Cell[TextData[{
 "You may already be familiar with ",
 StyleBox["@", "MR"],
 " as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " operator for applying a function to an argument: ",
 StyleBox["f @ x ", "MR"],
 "is equivalent to the more commonly used ",
 StyleBox["f[x]", "MR"],
 ". ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " does not usurp ",
 StyleBox["@", "MR"],
 " for some special operation\[LongDash]it is really just normal function \
application slightly disguised. This means that you do not have to use @ at \
all. The following are equivalent ways of invoking a method:"
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->19557],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"These", " ", "are", " ", "equivalent"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"obj", "@", 
     RowBox[{"method", "[", "args", "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"obj", "[", 
     RowBox[{"method", "[", "args", "]"}], "]"}], ";"}]}]}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.1",
 CellID->28962],

Cell[TextData[{
 "The first form preserves the natural mapping of Java\[CloseCurlyQuote]s \
syntax to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s, and it will be used exclusively in this manual."
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->14161],

Cell[TextData[{
 "When you call methods or fields and get results back, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " automatically converts arguments and results to and from their ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " representations according to the table in ",
 ButtonBox["Conversion of Types Between Java and ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17780"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17780"],
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->30524],

Cell[TextData[{
 "Method calls can be chained in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just like in Java. For example, if ",
 StyleBox["meth1", "MR"],
 " returns a Java object, you could write in Java ",
 StyleBox["obj.meth1().meth2()", "MR"],
 ". In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", this becomes ",
 StyleBox["obj@meth1[]@meth2[]", "MR"],
 ". Note that there is an apparent problem here: ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 StyleBox["@", "MR"],
 " operator groups to the right, whereas Java\[CloseCurlyQuote]s dot groups \
to the left. In other words, ",
 StyleBox["obj.meth1().meth2()", "MR"],
 " in Java is really ",
 StyleBox["(obj.meth1()).meth2()", "MR"],
 " whereas ",
 StyleBox["obj@meth1[]@meth2[]", "MR"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " would normally be ",
 StyleBox["obj@(meth1[]@meth2[])", "MR"],
 ". I say \[OpenCurlyDoubleQuote]normally\[CloseCurlyDoubleQuote] because ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " automatically causes chained calls to group to the left like Java. It does \
this by defining rules for ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions, not by altering the properties of the ",
 StyleBox["@", "MR"],
 " operator, so the global behavior of ",
 StyleBox["@", "MR"],
 " is not affected. This chaining behavior only applies to method calls, not \
fields. You cannot do this:"
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->12549],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"These", " ", "are", " ", 
    RowBox[{
     StyleBox["incorrect",
      FontSlant->"Italic"], ".", " ", "You"}], " ", "cannot", " ", "chain", 
    " ", "calls", " ", "after", " ", "a", " ", "field", " ", 
    RowBox[{"access", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"obj", "@", 
      RowBox[{"field", "@", 
       RowBox[{"method", "[", "args", "]"}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"obj", "@", 
      RowBox[{"field1", "@", "field2"}]}]}], ";"}]}]}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.1",
 CellID->17469],

Cell["\<\
You would have to split these up into two lines. For example, the second line \
above would become:\
\>", "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->330],

Cell[BoxData[{
 RowBox[{
  RowBox[{"temp", "=", 
   RowBox[{"obj", "@", "field1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"temp", "@", "field2"}]}], ";"}]}], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.1",
 CellID->31923],

Cell[TextData[{
 "In Java, like other object-oriented languages, method and field names are \
scoped by the object on which they are called. In other words, when you write \
",
 StyleBox["obj.meth()", "MR"],
 ", Java knows that you are calling the method named meth that resides in ",
 StyleBox["obj", "MR"],
 "\[CloseCurlyQuote]s class, even though there may be other methods named ",
 StyleBox["meth", "MR"],
 " in other classes. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " preserves this scoping for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols so that there is never a conflict with existing symbols of the \
same name. When you write ",
 StyleBox["obj@meth[]", "MR"],
 ", there is no conflict with any other symbols named ",
 StyleBox["meth", "MR"],
 " in the system\[LongDash]the symbol ",
 StyleBox["meth", "MR"],
 " used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the evaluation of this call is the one set up by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " for this class. Here is an example using a field. First, we create a ",
 StyleBox["Point", "MR"],
 " object:"
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->28350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pt", "=", 
  RowBox[{"JavaNew", "[", "\"\<java.awt.Point\>\"", "]"}]}]], "Input",
 CellTags->"jlug:5.2.6.1",
 CellLabel->"In[1]:=",
 CellID->14333],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]JavaObject", "[", "\<\"java.awt.Point\"\>", "]"}],
    "\[RightGuillemet]"}],
  JLink`Objects`JavaObject1]], "Output",
 CellTags->"jlug:5.2.6.1",
 CellLabel->"Out[1]=",
 CellID->22925]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Point", "MR"],
 " class has fields named ",
 StyleBox["x", "MR"],
 " and ",
 StyleBox["y", "MR"],
 ", which hold its coordinates. A user\[CloseCurlyQuote]s session is also \
likely to have symbols named ",
 StyleBox["x", "MR"],
 " or ",
 StyleBox["y", "MR"],
 " in it, however. Let us set up a definition for ",
 StyleBox["x", "MR"],
 " that will tell us when it is evaluated."
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->10910],

Cell[BoxData[
 RowBox[{"x", ":=", 
  RowBox[{"Print", "[", "\"\<gotcha\>\"", "]"}]}]], "Input",
 CellTags->"jlug:5.2.6.1",
 CellLabel->"In[2]:=",
 CellID->19737],

Cell[TextData[{
 "Now set a value for the field named ",
 StyleBox["x", "MR"],
 " (this would be written as ",
 StyleBox["pt.x = 42", "MR"],
 " in Java)."
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->16336],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"pt", "@", "x"}], "=", "42"}], ";"}], "MB"]], "Input",
 CellTags->"jlug:5.2.6.1",
 CellLabel->"In[3]:=",
 CellID->18337],

Cell[TextData[{
 "You\[CloseCurlyQuote]ll notice that \[OpenCurlyDoubleQuote]gotcha\
\[CloseCurlyDoubleQuote] was not printed. There is no conflict between the \
symbol ",
 StyleBox["x", "MR"],
 " in the ",
 StyleBox["Global`", "MR"],
 " context that has the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " definition and the symbol ",
 StyleBox["x", "MR"],
 " that is used during the evaluation of this line of code. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " protects the names of methods and fields on the right-hand side of ",
 StyleBox["@", "MR"],
 " so that they do not conflict with, or rely on, any definitions that might \
exist for these symbols in visible contexts. Here is a method example that \
demonstrates this issue differently:"
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->1278],

Cell[BoxData[{
 StyleBox[
  RowBox[{
   RowBox[{"frm", "=", 
    RowBox[{"JavaNew", "[", "\"\<java.awt.Frame\>\"", "]"}]}], ";"}], 
  "MB"], "\n", 
 RowBox[{"frm", "@", 
  RowBox[{"show", "[", "]"}]}]}], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.1",
 CellLabel->"In[4]:=",
 CellID->12393],

Cell[TextData[{
 "Even though a new symbol ",
 StyleBox["show", "MR"],
 " is being created here, the ",
 StyleBox["show", "MR"],
 " that is used by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is the one that resides down in the ",
 StyleBox["java`awt`Frame", "MR"],
 " context, which has the necessary definitions set up for it."
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->30714],

Cell[TextData[{
 "In summary, for nonstatic methods and fields, you never have to worry about \
name conflicts and shadowing, no matter what context you are in or what the \
",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContextPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ContextPath"], "MR"]], "InlineFormula"],
 " is at the moment. This is not true for static members, however. Static \
methods and fields are called by their full name, without an object \
reference, so there is no object out front to scope the name. Here is a \
simple example of a static method call that invokes the Java garbage \
collector. We need to call ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " before we call a static method to make sure the class has been loaded."
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->28164],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadJavaClass", "[", "\"\<java.lang.Runtime\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Runtime`gc", "[", "]"}], ";"}]}], "Input",
 CellTags->"jlug:5.2.6.1",
 CellLabel->"In[6]:=",
 CellID->31591],

Cell[TextData[{
 "The name scoping issue is not usually a problem with statics, because they \
are defined in their own contexts (",
 StyleBox["Runtime`", "MR"],
 " in this example). These contexts are usually not on ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContextPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ContextPath"], "MR"]], "InlineFormula"],
 ", so you do not have to worry that there is a symbol of the same name in \
the ",
 StyleBox["Global`", "MR"],
 " context or in a package that has been read. There is more discussion of \
this issue in the ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#1282"],
 " on ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 ", because ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " takes options that determine the contexts in which static methods are \
defined and whether or not they are put on ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContextPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ContextPath"], "MR"]], "InlineFormula"],
 ". If there is already a context named ",
 StyleBox["Runtime`", "MR"],
 " in your session, and it has its own symbol ",
 StyleBox["gc", "MR"],
 ", you can always avoid a conflict by using the fully-hierarchical context \
name that corresponds to the full class name for a static member:"
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->19949],

Cell[BoxData[
 RowBox[{
  RowBox[{"java`lang`Runtime`gc", "[", "]"}], ";"}]], "Input",
 CellTags->"jlug:5.2.6.1",
 CellLabel->"In[8]:=",
 CellID->19135],

Cell[TextData[{
 "Finally, just as in Java, you can call a static method on an object if you \
like. In this case, since there is an object out front, you get the name \
scoping. Here we call a static method of the ",
 StyleBox["Runtime", "MR"],
 " class that returns the current ",
 StyleBox["Runtime", "MR"],
 " object (we cannot create a ",
 StyleBox["Runtime", "MR"],
 " object with ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ", as ",
 StyleBox["Runtime", "MR"],
 " has no constructors). We then invoke the (static) method ",
 StyleBox["gc", "MR"],
 " on the object, and we can use ",
 StyleBox["gc", "MR"],
 " without any context prefix:"
}], "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->2505],

Cell[BoxData[{
 RowBox[{
  RowBox[{"runtime", "=", 
   RowBox[{"Runtime`getRuntime", "[", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"runtime", "@", 
   RowBox[{"gc", "[", "]"}]}], ";"}]}], "Input",
 CellTags->"jlug:5.2.6.1",
 CellLabel->"In[9]:=",
 CellID->13337]
}, Open  ]],

Cell[CellGroupData[{

Cell["Underscores in Java Names", "Subsection",
 CellTags->{"jlug:5.2.6.2", "TableOfContents_1.5.2.6.2"},
 CellID->10004],

Cell[TextData[{
 "Java names can have characters in them that are not legal in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols. The only common one is the underscore. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " maps underscores in class, method, and field names to \[OpenCurlyQuote]U\
\[CloseCurlyQuote]. Note that this mapping is only used where it is necessary\
\[LongDash]when names are used in symbolic form, not as strings. For example, \
assume you have a class named ",
 StyleBox["com.acme.My_Class", "MR"],
 ". When you refer to this class name as a string, you use the underscore:"
}], "Text",
 CellTags->"jlug:5.2.6.2",
 CellID->16337],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadJavaClass", "[", "\"\<com.acme.My_Class\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JavaNew", "[", "\"\<com.acme.My_Class\>\"", "]"}], ";"}]}], "Input",\

 Evaluatable->False,
 CellTags->"jlug:5.2.6.2",
 CellID->2623],

Cell["\<\
But when you call a static method in such a class, the hierarchical context \
name is symbolic, so you must convert the underscore to U:\
\>", "Text",
 CellTags->"jlug:5.2.6.2",
 CellID->28664],

Cell[BoxData[{
 RowBox[{
  RowBox[{"com`acme`MyUClass`staticMethod", "[", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"MyUClass`staticMethod", "[", "]"}], ";"}]}], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.2",
 CellID->9970],

Cell[TextData[{
 "The same rule applies to method and field names. Many Java field names have \
underscores in them, for example ",
 StyleBox["java.awt.Frame.TOP_ALIGNMENT", "MR"],
 ". To refer to this method in code, use the U:"
}], "Text",
 CellTags->"jlug:5.2.6.2",
 CellID->25608],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadJavaClass", "[", "\"\<java.awt.Frame\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", "Frame`TOPUALIGNMENT"}], "Input",
 CellTags->"jlug:5.2.6.2",
 CellLabel->"In[1]:=",
 CellID->30568],

Cell[BoxData["0.`"], "Output",
 CellTags->"jlug:5.2.6.2",
 CellLabel->"Out[2]=",
 CellID->19281]
}, Open  ]],

Cell["In cases where you supply a string, leave the underscore:", "Text",
 CellTags->"jlug:5.2.6.2",
 CellID->7085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fields", "[", 
  RowBox[{"\"\<java.awt.Frame\>\"", ",", "\"\<*_ALIGNMENT\>\""}], 
  "]"}]], "Input",
 CellTags->"jlug:5.2.6.2",
 CellLabel->"In[3]:=",
 CellID->9152],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"\<\"static final float BOTTOM_ALIGNMENT\"\>"},
    {"\<\"static final float CENTER_ALIGNMENT\"\>"},
    {"\<\"static final float LEFT_ALIGNMENT\"\>"},
    {"\<\"static final float RIGHT_ALIGNMENT\"\>"},
    {"\<\"static final float TOP_ALIGNMENT\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{
   "static final float BOTTOM_ALIGNMENT", 
    "static final float CENTER_ALIGNMENT", 
    "static final float LEFT_ALIGNMENT", "static final float RIGHT_ALIGNMENT",
     "static final float TOP_ALIGNMENT"}]]], "Output",
 CellTags->"jlug:5.2.6.2",
 CellLabel->"Out[3]//TableForm=",
 CellID->18373]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Getting Information About Classes and Objects", "Section",
 CellTags->{"jlug:5.2.7.0", "TableOfContents_1.5.2.7"},
 CellID->8526],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has some useful functions that show you the constructors, methods, and \
fields available for a given class or object."
}], "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->13357],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Constructors",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/Constructors"], 
     StyleBox["[", "MR"], 
     StyleBox["cls", "TI"], 
     StyleBox["]", "MR"]}], Cell["\<\
return a table of the public constructors and their arguments\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Constructors",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/Constructors"], 
     StyleBox["[", "MR"], 
     StyleBox["obj", "TI"], 
     StyleBox["]", "MR"]}], Cell["\<\
constructors for this object\[CloseCurlyQuote]s class\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Methods",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/Methods"], 
     StyleBox["[", "MR"], 
     StyleBox["cls", "TI"], 
     StyleBox["]", "MR"]}], Cell[
    "return a table of the public methods and their arguments", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Methods",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/Methods"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["cls", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox[" ", "TI"], 
      StyleBox["\"\<pat\>\"", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "show only methods whose names match the string pattern ",
     StyleBox["pat",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Methods",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/Methods"], 
     StyleBox["[", "MR"], 
     StyleBox["obj", "TI"], 
     StyleBox["]", "MR"]}], Cell["\<\
show methods for this object\[CloseCurlyQuote]s class\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Fields",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/Fields"], 
     StyleBox["[", "MR"], 
     StyleBox["cls", "TI"], 
     StyleBox["]", "MR"]}], Cell[
    "return a table of the public fields", "TableText"]},
   {
    RowBox[{
     ButtonBox["Fields",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/Fields"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["cls", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox[" ", "TI"], 
      StyleBox["\"\<pat\>\"", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "show only fields whose names match the string pattern ",
     StyleBox["pat",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Fields",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/Fields"], 
     StyleBox["[", "MR"], 
     StyleBox["obj", "TI"], 
     StyleBox["]", "MR"]}], Cell["\<\
show fields for this object\[CloseCurlyQuote]s class\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ClassName",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ClassName"], 
     StyleBox["[", "MR"], 
     StyleBox["cls", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "return, as a string, the name of the class represented by ",
     StyleBox["cls",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ClassName",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ClassName"], 
     StyleBox["[", "MR"], 
     StyleBox["obj", "TI"], 
     StyleBox["]", "MR"]}], Cell["\<\
return, as a string, the name of this object\[CloseCurlyQuote]s class\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["GetClass",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/GetClass"], 
     StyleBox["[", "MR"], 
     StyleBox["obj", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "return the ",
     ButtonBox["JavaClass",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaClass"],
     " representing this object\[CloseCurlyQuote]s \nclass"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ParentClass",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ParentClass"], 
     StyleBox["[", "MR"], 
     StyleBox["obj", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "return the ",
     ButtonBox["JavaClass",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaClass"],
     " representing this object\[CloseCurlyQuote]s \nparent class"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InstanceOf",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/InstanceOf"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["cls", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "return ",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if this object is an instance of ",
     StyleBox["cls",
      FontSlant->"Italic"],
     ", ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JavaObjectQ",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaObjectQ"], 
     StyleBox["[", "MR"], 
     StyleBox["expr", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "return ",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if ",
     StyleBox["expr",
      FontSlant->"Italic"],
     " is a valid reference to a Java object, ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.2.7.0",
 CellID->29337],

Cell["Getting information about classes and objects.", "Caption",
 CellTags->"jlug:5.2.7.0",
 CellID->23271],

Cell[TextData[{
 "You can give an object or a class to ",
 Cell[BoxData[
  ButtonBox["Constructors",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/Constructors"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Methods",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/Methods"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Fields",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/Fields"]], "InlineFormula"],
 ". The class can be specified either by its full name as a string, or as a \
",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expression:"
}], "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->23869],

Cell[BoxData[{
 RowBox[{
  RowBox[{"urlClass", " ", "=", " ", 
   RowBox[{"LoadJavaClass", "[", "\"\<java.net.URL\>\"", "]"}]}], ";"}], "\n",
 
 RowBox[{
  RowBox[{
   RowBox[{"urlObject", " ", "=", " ", 
    RowBox[{"JavaNew", "[", 
     RowBox[{
     "\"\<java.net.URL\>\"", ",", " ", "\"\<http://www.wolfram.com\>\""}], 
     "]"}]}], ";"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "next", " ", "three", " ", "lines", " ", "are", " ", 
    "equivalent"}], " ", "*)"}]}], "\n", 
 RowBox[{"Methods", "[", "urlClass", "]"}], "\n", 
 RowBox[{"Methods", "[", "urlObject", "]"}], "\n", 
 RowBox[{"Methods", "[", "\"\<java.net.URL\>\"", "]"}]}], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.7.0",
 CellID->29361],

Cell[TextData[{
 "The declarations returned by these functions have been simplified by \
removing the Java keywords ",
 StyleBox["public", "MR"],
 ", ",
 StyleBox["final", "MR"],
 " (removed only for methods, not fields), ",
 StyleBox["synchronized", "MR"],
 ", ",
 StyleBox["native", "MR"],
 ", ",
 StyleBox["volatile", "MR"],
 ", and ",
 StyleBox["transient", "MR"],
 ". The declarations will always be public, and the other modifiers are \
probably not relevant for use via ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->12896],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Methods",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/Methods"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Fields",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/Fields"]], "InlineFormula"],
 " take one option, ",
 StyleBox["Inherited", "MR"],
 ", which specifies whether to include members inherited from superclasses \
and interfaces or show only members declared in the class itself. The default \
is ",
 StyleBox["Inherited->", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->13022],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Inherited",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inherited"], " ", "\[Rule]", " ", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell["\<\
show only members that are declared in the class itself, not inherited from \
superclasses or interfaces\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.2.7.0",
 CellID->29617],

Cell["Option for Methods and Fields.", "Caption",
 CellTags->"jlug:5.2.7.0",
 CellID->10112],

Cell[TextData[{
 "There are additional functions that give information about objects and \
classes. These functions are ",
 Cell[BoxData[
  ButtonBox["ClassName",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ClassName"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GetClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/GetClass"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ParentClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ParentClass"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InstanceOf",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstanceOf"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["JavaObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectQ"]], "InlineFormula"],
 ". They are self-explanatory, for the most part. The ",
 Cell[BoxData[
  ButtonBox["InstanceOf",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstanceOf"]], "InlineFormula"],
 " function mimics the Java language",
 "\[CloseCurlyQuote]",
 "s ",
 StyleBox["instanceof", "MR"],
 " operator. ",
 Cell[BoxData[
  ButtonBox["JavaObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectQ"]], "InlineFormula"],
 " is useful for writing patterns that match only valid Java objects:"
}], "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->12717],

Cell[BoxData[
 RowBox[{
  RowBox[{"Stringify", "[", 
   RowBox[{"obj_", "?", "JavaObjectQ"}], "]"}], ":=", 
  RowBox[{"obj", "[", 
   RowBox[{"toString", "[", "]"}], "]"}]}]], "Input",
 CellTags->"jlug:5.2.7.0",
 CellID->18696],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JavaObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectQ"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " if and only if its argument is a valid reference to a Java object or if it \
is the symbol ",
 StyleBox["Null", "MR"],
 ", which maps to Java\[CloseCurlyQuote]s ",
 StyleBox["null", "MR"],
 " object."
}], "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->11585]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quitting or Restarting Java", "Section",
 CellTags->{"jlug:5.2.8.0", "TableOfContents_1.5.2.8"},
 CellID->23439],

Cell[TextData[{
 "When you are finished with using Java in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you can quit the Java runtime by calling ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UninstallJava",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/UninstallJava"], "[", "]"}]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellTags->"jlug:5.2.8.0",
 CellID->13428],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["UninstallJava",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/UninstallJava"], "[", "]"}], Cell[
    "quit the Java runtime", "TableText"]},
   {
    RowBox[{
     ButtonBox["ReinstallJava",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ReinstallJava"], "[", "]"}], Cell[
    "restart the Java runtime", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.2.8.0",
 CellID->5912],

Cell["Quitting the Java runtime.", "Caption",
 CellTags->"jlug:5.2.8.0",
 CellID->9762],

Cell[TextData[{
 "In addition to quitting Java, ",
 Cell[BoxData[
  ButtonBox["UninstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFormula"],
 " clears out the many symbols and definitions created in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when you load classes. All outstanding ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions will become invalid when Java is quit. They will no longer \
satisfy ",
 Cell[BoxData[
  ButtonBox["JavaObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectQ"]], "InlineFormula"],
 ", and they will show up as raw symbols like ",
 StyleBox["JLink`Objects`JavaObject12345678", "MR"],
 " instead of ",
 StyleBox["<<JavaObject[classname]>>", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.2.8.0",
 CellID->5967],

Cell[TextData[{
 "Most users will have no reason to call ",
 Cell[BoxData[
  ButtonBox["UninstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFormula"],
 ". You should think of the Java runtime as an integral part of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system\[LongDash]start it up, and then just leave it running. All code \
that uses ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " shares the same Java runtime, and there may be packages that you are using \
that make use of Java without you even knowing it. Shutting down Java might \
compromise their functionality. Developers writing packages should ",
 StyleBox["never",
  FontSlant->"Italic"],
 " call ",
 Cell[BoxData[
  ButtonBox["UninstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFormula"],
 " in their packages. You cannot assume that when your application is done \
with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", your users are done with it as well."
}], "Text",
 CellTags->"jlug:5.2.8.0",
 CellID->24408],

Cell[TextData[{
 "About the only common reason to need to stop and restart Java is when you \
are actively developing Java classes that you want to call from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Once a class is loaded into the Java runtime, it cannot be unloaded. If \
you want to modify and recompile your class, you need to restart Java to \
reload the modified version. Even in this circumstance, though, you will not \
be calling ",
 Cell[BoxData[
  ButtonBox["UninstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFormula"],
 ". Instead, you will call ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 ", which simply calls ",
 Cell[BoxData[
  ButtonBox["UninstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFormula"],
 " followed by ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " again."
}], "Text",
 CellTags->"jlug:5.2.8.0",
 CellID->4415]
}, Open  ]],

Cell[CellGroupData[{

Cell["Version Information", "Section",
 CellTags->{"jlug:5.2.9.0", "TableOfContents_1.5.2.9"},
 CellID->31163],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides three symbols that supply version information. These symbols \
provide the same type of information as their counterparts in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " itself, except that they are in the ",
 StyleBox["JLink`Information`", "MR"],
 " context, which is not on ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContextPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ContextPath"], "MR"]], "InlineFormula"],
 ", so you must specify them by their full names."
}], "Text",
 CellTags->"jlug:5.2.9.0",
 CellID->16683],

Cell[BoxData[GridBox[{
   {
    StyleBox["JLink`Information`$Version", "MR"], Cell[
    "a string giving full version information", "TableText"]},
   {
    StyleBox["JLink`Information`$VersionNumber", "MR"], Cell[
    "a real number giving the current version number", "TableText"]},
   {
    StyleBox["JLink`Information`$ReleaseNumber", "MR"], Cell["\<\
an integer giving the release number (the last digit in a full     x.x.x \
version specification)\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ShowJavaConsole",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ShowJavaConsole"], "[", "]"}], Cell[
    TextData[{
     "the console window will show version information for the Java     \
runtime and the ",
     StyleBox["J/Link",
      FontSlant->"Italic"],
     " Java component"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.2.9.0",
 CellID->13716],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " version information."
}], "Caption",
 CellTags->"jlug:5.2.9.0",
 CellID->19932],

Cell[CellGroupData[{

Cell[BoxData["JLink`Information`$Version"], "Input",
 CellTags->"jlug:5.2.9.0",
 CellLabel->"In[1]:=",
 CellID->25452],

Cell[BoxData["\<\"J/Link Version 4.0.1\"\>"], "Output",
 CellTags->"jlug:5.2.9.0",
 CellLabel->"Out[1]=",
 CellID->2741]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["JLink`Information`$VersionNumber"], "Input",
 CellTags->"jlug:5.2.9.0",
 CellLabel->"In[2]:=",
 CellID->4954],

Cell[BoxData["4.0`"], "Output",
 CellTags->"jlug:5.2.9.0",
 CellLabel->"Out[2]=",
 CellID->6813]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["JLink`Information`$ReleaseNumber"], "Input",
 CellTags->"jlug:5.2.9.0",
 CellLabel->"In[3]:=",
 CellID->2862],

Cell[BoxData["1"], "Output",
 CellTags->"jlug:5.2.9.0",
 CellLabel->"Out[3]=",
 CellID->10396]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ShowJavaConsole",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ShowJavaConsole"], "[", "]"}]], 
  "InlineFormula"],
 " function, described in a later section, will also display some useful \
version information. It shows the version of the Java runtime being used and \
the version of the portion of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " that is written in Java. The version of the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " Java component should match the version of the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " component. "
}], "Text",
 CellTags->"jlug:5.2.9.0",
 CellID->15460]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Controlling the Class Path: How ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " Finds Classes"
}], "Section",
 CellTags->{"TableOfContents_1.5.3.1", "1.2.1", "jlug:5.3.1.0"},
 CellID->19629],

Cell[CellGroupData[{

Cell["The Java Class Path", "Subsection",
 CellTags->{"jlug:5.3.1.1", "TableOfContents_1.5.3.1.1"},
 CellID->12623],

Cell["\<\
The class path tells the Java runtime, compiler, and other tools where to \
find third-party and user-defined classes\[LongDash]classes that are not Java \
\[OpenCurlyDoubleQuote]extensions\[CloseCurlyDoubleQuote] or part of the Java \
platform itself. The class path has always been a source of confusion among \
Java users and programmers.\
\>", "Text",
 CellTags->"jlug:5.3.1.1",
 CellID->24084],

Cell[TextData[{
 "Java can find classes that are part of the standard Java platform \
(so-called \[OpenCurlyDoubleQuote]bootstrap\[CloseCurlyDoubleQuote] classes), \
classes that use the so-called \[OpenCurlyDoubleQuote]extensions",
 "\[CloseCurlyDoubleQuote]",
 " mechanism, and classes on the class path, which is controlled by the ",
 StyleBox["CLASSPATH", "MR"],
 " environment variable or by command-line options when Java is launched. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " can load and use any classes that the Java runtime can find through these \
normal mechanisms. In addition, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " can find classes, resources, and native libraries that are in a set of \
extra locations, beyond what is specified on the class path at startup. This \
set of extra locations can be added to while Java is running."
}], "Text",
 CellTags->"jlug:5.3.1.1",
 CellID->19954],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides two ways to alter the search path Java uses to find classes. The \
first way is via the ",
 StyleBox["ClassPath", "MR"],
 " option to ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 ". The second way, which is superior to modifying the class path at startup, \
is to add new directories and jar files to the special set of extra locations \
that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " searches. These two methods will be described in the next two \
subsections."
}], "Text",
 CellTags->"jlug:5.3.1.1",
 CellID->18756]
}, Open  ]],

Cell[CellGroupData[{

Cell["Overriding the Startup Class Path", "Subsection",
 CellTags->{"jlug:5.3.1.2", "TableOfContents_1.5.3.1.2"},
 CellID->11840],

Cell["\<\
For a class to be accessible via the standard Java class path, one of the \
following must apply:\
\>", "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->4966],

Cell["\<\
\[FilledSmallSquare]  It is inside a .zip or .jar file that is itself named \
on the class path.
\[FilledSmallSquare]  It is a loose class file that is in an appropriately \
nested directory beneath a directory that is on the class path.\
\>", "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->7376],

Cell[TextData[{
 "\[OpenCurlyDoubleQuote]Appropriately nested",
 "\[CloseCurlyDoubleQuote]",
 " means that the class file must be in a directory whose hierarchy mirrors \
the full package name of the class. For example, assume that the directory ",
 StyleBox["c:\\MyClasses", "MR"],
 " is on the class path. If you have a class that is not in a package (there \
is no package statement at the beginning of the code), its class file should \
be put directly into ",
 StyleBox["c:\\MyClasses", "MR"],
 ". If you have a class that is in the package ",
 StyleBox["com.acme.stuff", "MR"],
 ", its class file would need to be in the directory ",
 StyleBox["c:\\MyClasses\\com\\acme\\stuff", "MR"],
 ". Note that jar and zip files must be explicitly named on the class path\
\[LongDash]you cannot just toss them into a directory that is itself named on \
the class path. Directory issues are not relevant for jar and zip files, \
meaning that regardless of how hierarchically organized the classes inside a \
jar file are, you simply name the jar file itself on the class path and all \
the classes inside it can be found."
}], "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->13931],

Cell[TextData[{
 "If you want to specify paths for classes that are not part of the standard \
Java platform or extensions, you can use the ",
 StyleBox["ClassPath", "MR"],
 " option to ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 ". The value that you supply for the ",
 StyleBox["ClassPath", "MR"],
 " option is a string that names the desired directories and zip or jar \
files. This string is platform-dependent; the paths are specified in the \
native style for your platform, and the separator character is a colon on ",
 "Unix",
 " and a semicolon on Windows. Here are typical specifications:"
}], "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->26308],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReinstallJava", "[", 
   RowBox[{
   "ClassPath", "\[Rule]", 
    "\"\<c:\\\\MyJavaDir\\\\MyPackage.jar;c:\\\\MyJavaDir\>\""}], "]"}], "  ",
   
  RowBox[{"(*", " ", "Windows", " ", "*)"}]}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.1.2",
 CellID->16944],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReinstallJava", "[", 
   RowBox[{
   "ClassPath", "\[Rule]", "\"\<~/MyJavaDir/MyPackage.jar:~/MyJavaDir\>\""}], 
   "]"}], "              ", 
  RowBox[{"(*", " ", "Unix", " ", "*)"}]}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.1.2",
 CellID->5040986],

Cell[TextData[{
 "The default setting for ",
 StyleBox["ClassPath", "MR"],
 " is ",
 StyleBox["Automatic", "MR"],
 ", which means to use the value of the ",
 StyleBox["CLASSPATH", "MR"],
 " environment variable. If you set ",
 StyleBox["ClassPath", "MR"],
 " to something else, then J/Link will ignore the ",
 StyleBox["CLASSPATH", "MR"],
 " environment variable",
 "\[LongDash]",
 "it will not be able to find those classes. In other words, if you use a ",
 StyleBox["ClassPath", "MR"],
 " specification, you lose the ",
 StyleBox["CLASSPATH", "MR"],
 " environment variable. This is similar to the behavior of the ",
 StyleBox["-classpath", "MR"],
 " command-line option to the Java runtime and compiler, if you are familiar \
with those tools."
}], "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->32439],

Cell[TextData[{
 "It is recommended that users avoid the ",
 StyleBox["ClassPath", "MR"],
 " option. If you need the dynamic control that the ",
 StyleBox["ClassPath", "MR"],
 " option provides, you should use the more powerful and convenient ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 " mechanism, described in the next section. The most common reason for using \
the ",
 StyleBox["ClassPath", "MR"],
 " option is if you want to specifically prevent the contents of the ",
 StyleBox["CLASSPATH", "MR"],
 " environment variable from being used. To do this, set ",
 StyleBox["ClassPath -> None", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->24626]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dynamically Modifying the Class Path", "Subsection",
 CellTags->{"jlug:5.3.1.3", "TableOfContents_1.5.3.1.3"},
 CellID->11323],

Cell[TextData[{
 "One thing that is inconvenient about the standard Java class path is that \
it cannot be changed after the Java runtime has been launched. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has its own class loader that searches in a set of special locations \
beyond the standard Java class path. This gives ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " an extremely powerful and flexible means of finding classes. To add \
locations to this extra set, use the ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->5537],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AddToClassPath",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/AddToClassPath"], "[", 
     RowBox[{
      StyleBox["\"\<location\>\"", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[TextData[{
     "add the specified directories or jar files to ",
     StyleBox["J",
      FontSlant->"Italic"],
     StyleBox["/",
      FontSlant->"Italic"],
     StyleBox["Link",
      FontSlant->"Italic"],
     "\[CloseCurlyQuote]s class search path"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.1.3",
 CellID->21538],

Cell["Adding classes to the search path.", "Caption",
 CellTags->"jlug:5.3.1.3",
 CellID->16118],

Cell[TextData[{
 "After Java has been started, you can call ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 " whenever you wish, and it will take effect immediately. One convenient \
feature of this extra class search path is that if you add a directory, then \
any jar or zip files in that directory will be searched. This means that you \
do not have to name jar files individually, as you need to do with the \
standard Java class path. For loose class files, the nesting rules are the \
same as for the class path, meaning that if a class is in the package ",
 StyleBox["com.acme.stuff", "MR"],
 ", and you called ",
 StyleBox["AddToClassPath[\"d:\\\\myClasses\"]", "MR"],
 ", then you would need to put the class file into ",
 StyleBox["d:\\MyClasses\\com\\acme\\stuff", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->2082],

Cell[TextData[{
 "Changes to the search path that you make with ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 " only apply to the current Java session. If you quit and restart java, you \
will need to call ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 " again."
}], "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->22929],

Cell[TextData[{
 "In addition to the locations you add yourself with ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 ", ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " automatically includes any ",
 StyleBox["Java", "MR"],
 " subdirectories of any directories in ",
 StyleBox["<Mathematica dir>/AddOns/Applications", "MR"],
 " and ",
 StyleBox["<Mathematica dir>/AddOns/ExtraPackages", "MR"],
 ". This feature is designed to provide extremely easy deployment for \
developers who create applications for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that use Java and ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " for part of their implementation. This is described in ",
 ButtonBox["Deploying Applications that use J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17189"],
 " in more detail, but even casual Java programmers who are writing classes \
to use with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " can take advantage of it. Just create a subdirectory of ",
 StyleBox["AddOns/Applications", "MR"],
 ", say ",
 StyleBox["MyStuff", "MR"],
 ", create a ",
 StyleBox["Java", "MR"],
 " subdirectory within it, and toss class or jar files into it. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will be able to find and use them. Of course, loose class files have to be \
placed into an appropriately nested subdirectory of the ",
 StyleBox["Java", "MR"],
 " directory, corresponding to their package names (if any), as described \
above."
}], "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->16541],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 " function was introduced in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0. Previous versions of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " had a variable called ",
 StyleBox["$ExtraClassPath", "MR"],
 " that specified a list of extra locations. You could add to this list like \
this:"
}], "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->4833],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$ExtraClassPath", ",", "\"\<d:\\\\MyClasses\>\""}], "]"}], 
  ";"}]], "Input",
 CellTags->"jlug:5.3.1.3",
 CellID->31115],

Cell[TextData[{
 StyleBox["$ExtraClassPath", "MR"],
 " was deprecated in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0, but it still works. One advantage of ",
 StyleBox["$ExtraClassPath", "MR"],
 " over using ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 " is that changes made to ",
 StyleBox["$ExtraClassPath", "MR"],
 " persist across a restart of the Java runtime."
}], "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->4639]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examining the Class Path", "Subsection",
 CellTags->{"jlug:5.3.1.4", "TableOfContents_1.5.3.1.4"},
 CellID->29658],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["JavaClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClassPath"]], "InlineFormula"],
 " function returns the set of directories and jar files in which ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will search for classes. This includes all locations added with ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 " or ",
 StyleBox["$ExtraClassPath", "MR"],
 ", as well as ",
 StyleBox["Java", "MR"],
 " subdirectories of application directories in any of the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application locations. It does not display the jar files that make up the \
standard Java platform itself, or jar files in the Java extensions directory. \
Those classes can always be found by Java programs."
}], "Text",
 CellTags->"jlug:5.3.1.4",
 CellID->22704],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["JavaClassPath",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaClassPath"], "[", "]"}], Cell[
    TextData[{
     "gives the complete set of directories and jar files in which ",
     StyleBox["J",
      FontSlant->"Italic"],
     StyleBox["/",
      FontSlant->"Italic"],
     StyleBox["Link",
      FontSlant->"Italic"],
     " will search for classes"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.1.4",
 CellID->9930],

Cell["Inspecting the class search path.", "Caption",
 CellTags->"jlug:5.3.1.4",
 CellID->13977]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s Class Loader Directly"
}], "Subsection",
 CellTags->{"jlug:5.3.1.5", "TableOfContents_1.5.3.1.5"},
 CellID->2306],

Cell[TextData[{
 "As stated earlier, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " uses its own class loader to allow it to find classes and other resources \
in a dynamic set of locations beyond the startup class path. Essentially all \
the classes that you load using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " that are not part of the Java platform itself will be loaded by this class \
loader. One consequence of this is that calling Java",
 "\[CloseCurlyQuote]",
 "s ",
 StyleBox["Class.forName()", "MR"],
 " method from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will often not work. "
}], "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->31673],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadJavaClass", "[", "\"\<java.lang.Class\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{"cls", "=", 
  RowBox[{
  "Class`forName", "[", "\"\<some.class.that.only.JLink.can.find\>\"", 
   "]"}]}]}], "Input",
 CellTags->"jlug:5.3.1.5",
 CellLabel->"In[4]:=",
 CellID->22386],

Cell[BoxData[
 RowBox[{
  RowBox[{"Java", "::", "\<\"excptn\"\>"}], ":", 
  " ", "\<\"A Java exception occurred: java.lang.ClassNotFoundException: \
some.class.that.only.JLink.can.find\\n\\tat \
java.net.URLClassLoader$1.run(Unknown Source)\\n\\tat \
java.security.AccessController.doPrivileged(Native Method)\\n\\tat \
java.net.URLClassLoader.findClass(Unknown Source)\\n\\tat \
java.lang.ClassLoader.loadClass(Unknown Source)\\n\\tat \
sun.misc.Launcher$AppClassLoader.loadClass(Unknown Source)\\n\\tat \
java.lang.ClassLoader.loadClass(Unknown Source)\\n\\tat \
java.lang.ClassLoader.loadClassInternal(Unknown Source)\\n\\tat \
java.lang.Class.forName0(Native Method)\\n\\tat \
java.lang.Class.forName(Unknown Source)\\n\\tat \
sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\\n\\tat \
sun.reflect.NativeMethodAccessorImpl.invoke(Unknown Source)\\n\\tat \
sun.reflect.DelegatingMethodAccessorImpl.invoke(Unknown Source).\"\>"}]], \
"Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"jlug:5.3.1.5",
 CellLabel->"From In[4]:=",
 CellID->5021],

Cell[BoxData["$Failed"], "Output",
 CellTags->"jlug:5.3.1.5",
 CellLabel->"Out[5]=",
 CellID->28745]
}, Open  ]],

Cell[TextData[{
 "The problem is that ",
 StyleBox["Class.forName()", "MR"],
 " finds classes using a default class loader, not the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " class loader, and this default class loader does not know about the \
special directories in which ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " looks for classes (in fact, it doesn\[CloseCurlyQuote]t even know about \
the startup class path, because of details of how ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " launches Java). If you are translating Java code into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", or if you just want to get a Class object for a given class, watch out \
for this problem. The fix is to force ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 "s class loader to be used. One way to do this is to use the 3-argument form \
of ",
 StyleBox["Class.forName()", "MR"],
 ", which allows you to specify the class loader to be used:"
}], "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->26924],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "LoadJavaClass", "[", "\"\<com.wolfram.jlink.JLinkClassLoader\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{"cls", "=", 
  RowBox[{"Class`forName", "[", 
   RowBox[{"\"\<some.class.that.only.JLink.can.find\>\"", ",", "True", ",", 
    RowBox[{"JLinkClassLoader`getInstance", "[", "]"}]}], "]"}]}]}], "Input",
 CellTags->"jlug:5.3.1.5",
 CellID->19072],

Cell[TextData[{
 "An easier way is to use the static ",
 StyleBox["classFromName", "MR"],
 " method of ",
 StyleBox["JLinkClassLoader", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->6270],

Cell[BoxData[
 RowBox[{"cls", "=", 
  RowBox[{
  "JLinkClassLoader`classFromName", "[", 
   "\"\<some.class.that.only.JLink.can.find\>\"", "]"}]}]], "Input",
 CellTags->"jlug:5.3.1.5",
 CellID->5829],

Cell[TextData[{
 "You should think of this ",
 StyleBox["classFromName()", "MR"],
 " method as being the replacement for ",
 StyleBox["Class.forName()", "MR"],
 ". When you find yourself wanting to obtain a ",
 StyleBox["Class", "MR"],
 " object from a class name given as a string, remember to use ",
 StyleBox["JLinkClassLoader.classFromName()", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->26777],

Cell[TextData[{
 StyleBox["Class.forName()", "MR"],
 " is not very commonly found in Java code. One reason it is used is when an \
object needs to be created, but its class was not known at compile time. For \
example, the class name might come from a preferences file or be determined \
programmatically in some other way. Often, the very next line creates an \
instance of the class, like this:"
}], "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->15573],

Cell["\<\
    // Java code
    Class cls = Class.forName(\"SomeClassThatImplementsInterfaceX\");
    X obj = (X) cls.newInstance();\
\>", "Program",
 CellTags->"jlug:5.3.1.5",
 CellID->5097],

Cell[TextData[{
 "If you are translating code like this into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program, this operation can be performed simply by calling ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->16512],

Cell[BoxData[
 RowBox[{"obj", "=", 
  RowBox[{
  "JavaNew", "[", "\"\<SomeClassThatImplementsInterfaceX\>\"", 
   "]"}]}]], "Input",
 CellTags->"jlug:5.3.1.5",
 CellID->23986],

Cell[TextData[{
 "The point here is that for a very common usage of ",
 StyleBox["Class.forName()", "MR"],
 ", you do not have to translate it line-by-line into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[LongDash]you can duplicate the functionality by calling ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->13290]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Performance Issues", "Section",
 CellTags->{"TableOfContents_1.5.3.2", "1.2.1", "jlug:5.3.2.0"},
 CellID->28396],

Cell[CellGroupData[{

Cell["Overhead of Calls to Java", "Subsection",
 CellTags->{"jlug:5.3.2.1", "TableOfContents_1.5.3.2.1"},
 CellID->7572],

Cell["\<\
The speed of Java programs is highly dependent on the Java runtime. On \
certain types of programs, for example, ones that spend most of their time in \
a tight number-crunching loop, the speed of Java can approach that of \
compiled, optimized C. \
\>", "Text",
 CellTags->"jlug:5.3.2.1",
 CellID->6249],

Cell[TextData[{
 "Java is a good choice for computationally-intensive programs. Your mileage \
may vary, but do not rule out Java for any type of program before you have \
done some simple speed testing. For less demanding programs, where every \
ounce of speed is not necessary, the simplicity of using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " instead of programming traditional ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " \[OpenCurlyDoubleQuote]installable\[CloseCurlyDoubleQuote] programs with C \
makes Java an obvious choice."
}], "Text",
 CellTags->"jlug:5.3.2.1",
 CellID->14640],

Cell[TextData[{
 "The speed issues with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " are not, for the most part, the speed of Java execution. Rather, the \
bottleneck is the rate at which you can perform calls into Java, which is \
itself limited mainly by the speed of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " and the processing that must be done in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for each call into Java. The maximum rate of calls into Java is highly \
dependent on which operating system and which Java runtime you use. A fast \
Windows machine can perform more than 5000 Java method calls per second, and \
considerably more if they are static methods, which require less \
preprocessing in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". On some operating systems the results will be less. You should keep in \
mind that there is a more or less fixed cost of a call into Java regardless \
of what the call does, and on slow machines this cost could be as much as \
.001 seconds. Many Java methods will execute in considerably less time than \
this, so the total time for the call is often dominated by the fixed \
turnaround time of a ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " call, not the speed of Java itself."
}], "Text",
 CellTags->"jlug:5.3.2.1",
 CellID->29174],

Cell[TextData[{
 "For most uses, the overhead of a call into Java is not a concern, but if \
you have a loop that calls into Java 500,000 times, you will have a problem \
(unless your program takes so long that the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " cost is negligible, in which case you have an even bigger problem!). If \
your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program is structured in a way that requires a great many calls into Java, \
you may need to refactor it to do more on the Java side and thus reduce the \
number of times you need to cross the Java-",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " boundary. This will probably involve writing some Java code, which \
unfortunately defeats the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " premise of being able to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to script the functionality of an arbitrary Java program. There are uses \
of Java that just cannot be feasibly scripted in this way, and for these you \
will need to write more of the functionality in Java and less in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.2.1",
 CellID->18819]
}, Open  ]],

Cell[CellGroupData[{

Cell["Speeding up Sending Large Arrays", "Subsection",
 CellTags->{"jlug:5.3.2.4", "TableOfContents_1.5.3.2.4"},
 CellID->16074],

Cell[TextData[{
 "You can send and receive arrays of most \[OpenCurlyDoubleQuote]primitive\
\[CloseCurlyDoubleQuote] Java types (e.g., byte, short, int, float, double) \
nearly as fast as in a C-language program. The set of types that can be \
passed quickly corresponds to the set of types for which the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C API has single functions to put arrays. The Java types long (these are \
64 bits), boolean, and String do not have fast ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions, and so sending or receiving these types is much slower. Try to \
avoid using extremely large arrays of these types (say, more than 100,000 \
elements) if possible."
}], "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->13509],

Cell[TextData[{
 "A setting that has a big effect on the speed of moving multidimensional \
arrays is the one used to control whether \[OpenCurlyDoubleQuote]ragged\
\[CloseCurlyDoubleQuote] arrays are allowed. As discussed in ",
 ButtonBox["Ragged Arrays",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#1908"],
 ", the default behavior of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is to require that all arrays be fully rectangular. But Java does not \
require that arrays conform to this restriction, and if you want to send or \
receive ragged arrays, you can call ",
 Cell[BoxData[
  ButtonBox["AllowRaggedArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AllowRaggedArrays"]], "InlineFormula"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 StyleBox["]", "MR"],
 " in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. This causes ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to switch to a much slower method for reading and writing arrays. Avoid \
using this setting unless you need it, and switch it off as soon as you no \
longer require it."
}], "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->30300],

Cell[TextData[{
 "When you load a class with a method that takes, say, an int[][], the \
definition in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " creates for calling this method uses a pattern test that requires its \
argument to be a two-dimensional array of integers. If the array is quite \
large, say on the order of 500 by 500, this test can take a significant \
amount of time, probably similar to the time it takes to actually transfer \
the array to Java. If you want to avoid the time taken by this testing of \
array arguments, you can set the variable ",
 Cell[BoxData[
  ButtonBox["$RelaxedTypeChecking",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/$RelaxedTypeChecking"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 ". If you do this, you are on your own to ensure that the arrays you send \
are of the right type and dimensionality. If you pass a bad array, you will \
get a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " error, but this will not cause any problems for ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " (other than that the call will return ",
 StyleBox["$Failed", "MR"],
 ")."
}], "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->19695],

Cell[TextData[{
 "You probably do not want to leave ",
 Cell[BoxData[
  ButtonBox["$RelaxedTypeChecking",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/$RelaxedTypeChecking"]], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " for a long time, and if you are writing code for others to use you \
certainly do not want to alter its value in their session. ",
 Cell[BoxData[
  ButtonBox["$RelaxedTypeChecking",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/$RelaxedTypeChecking"]], "InlineFormula"],
 " is intended to be used in a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "MR"]], "InlineFormula"],
 " construct, where it is given the value of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " for a short period:"
}], "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->9573],

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$RelaxedTypeChecking", "=", "True"}], "}"}], ",", 
   RowBox[{"obj", "[", 
    RowBox[{"meth", "[", "someLargeArray", "]"}], "]"}]}], "]"}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.2.4",
 CellID->15589],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$RelaxedTypeChecking",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/$RelaxedTypeChecking"]], "InlineFormula"],
 " only has an effect for arrays, which are the only types for which the \
pattern test that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " creates is expensive relative to the actual call into Java."
}], "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->13161],

Cell[TextData[{
 "Another optimization to speed up ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programs is to use ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " to avoid unnecessary passing of large arrays or strings back and forth \
between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java. ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " is discussed in the section ",
 ButtonBox["ReturnAsJavaObject",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#13210"],
 "."
}], "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->31172]
}, Open  ]],

Cell[CellGroupData[{

Cell["An Optimization Example", "Subsection",
 CellTags->{"jlug:5.3.2.5", "TableOfContents_1.5.3.2.5"},
 CellID->17968],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s examine a simple example of steps you might take to \
improve the speed of a ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " program. Java has a powerful ",
 StyleBox["DecimalFormat", "MR"],
 " class we can use to format ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " numbers in a desired way for output to a file. Here we create a ",
 StyleBox["DecimalFormat", "MR"],
 " object that will format numbers to exactly four decimal places:"
}], "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->27358],

Cell[BoxData[
 RowBox[{
  RowBox[{"fmt", "=", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<java.text.DecimalFormat\>\"", ",", "\"\<#.0000\>\""}], 
    "]"}]}], ";"}]], "Input",
 CellTags->"jlug:5.3.2.5",
 CellLabel->"In[1]:=",
 CellID->26031],

Cell[TextData[{
 "To use the ",
 StyleBox["fmt", "MR"],
 " object, we call its ",
 StyleBox["format()", "MR"],
 " method, supplying the number we want formatted:"
}], "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->26268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fmt", "@", 
  RowBox[{"format", "[", "12.34", "]"}]}]], "Input",
 CellTags->"jlug:5.3.2.5",
 CellLabel->"In[2]:=",
 CellID->19426],

Cell[BoxData["\<\"12.3400\"\>"], "Output",
 CellTags->"jlug:5.3.2.5",
 CellLabel->"Out[2]=",
 CellID->28510]
}, Open  ]],

Cell["\<\
This returns a string with the requested format. Now suppose we want to use \
this ability to format a list of 20000 numbers before writing them to a file.\
\
\>", "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->10422],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", "40000", "}"}]}], "]"}]}], ";"}]], "Input",
 CellTags->"jlug:5.3.2.5",
 CellLabel->"In[3]:=",
 CellID->30774],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"fmt", "@", 
       RowBox[{"format", "[", "#", "]"}]}], "&"}], ",", "data"}], "]"}], 
   ";"}], "MB"]], "Input",
 CellTags->"jlug:5.3.2.5",
 CellLabel->"In[4]:=",
 CellID->8779],

Cell[TextData[{
 "The above ",
 StyleBox["Map", "MR"],
 " call, which invokes the format method 40000 times, takes 46 seconds on a \
certain PC (this is wall clock time, not the result of the ",
 StyleBox["Timing", "MR"],
 " function, which is not accurate for ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs on most systems). Clearly this is not acceptable. As a first \
step, we try using ",
 StyleBox["MethodFunction", "MR"],
 " because we are calling the same method many times."
}], "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->30910],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"methodFunc", "=", 
    RowBox[{"MethodFunction", "[", 
     RowBox[{"fmt", ",", "format"}], "]"}]}], ";"}], "MB"]], "Input",
 CellTags->"jlug:5.3.2.5",
 CellLabel->"In[5]:=",
 CellID->23552],

Cell[TextData[{
 "Note that we use ",
 StyleBox["fmt", "MR"],
 " as the first argument to ",
 StyleBox["MethodFunction", "MR"],
 ". The first argument merely specifies the class; as with virtually all \
functions in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " that take a class specification, we can use an object of the class if we \
desire. The ",
 StyleBox["MethodFunction", "MR"],
 " that is created can be used on any object of the ",
 StyleBox["DecimalFormat", "MR"],
 " class, not just the ",
 StyleBox["fmt",
  FontSlant->"Italic"],
 " object."
}], "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->4182],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"methodFunc", "[", 
       RowBox[{"fmt", ",", "#"}], "]"}], "&"}], ",", "data"}], "]"}], ";"}], 
  "MB"]], "Input",
 CellTags->"jlug:5.3.2.5",
 CellLabel->"In[6]:=",
 CellID->25391],

Cell[TextData[{
 "Using ",
 StyleBox["methodFunc", "MR"],
 ", this now takes 36 seconds. There is a slight speed improvement, much less \
than in earlier versions of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". This means we are getting about 1100 calls per second, and it is still \
not fast enough to be useful. The only thing to do is to write our own Java \
method that takes an ",
 StyleBox["array",
  FontSlant->"Italic"],
 " of numbers, formats them all, and returns an array of strings. This will \
reduce the number of calls from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into Java 40000 down to one."
}], "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->15495],

Cell[TextData[{
 "Here is the code for the trivial Java class necessary. Note that there is \
nothing about this code that suggests it will be called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". This is exactly the same code we would write if we wanted to use this \
functionality within Java."
}], "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->5764],

Cell["\<\
public class FormatArray {
\tpublic static String[] format(java.text.DecimalFormat fmt,double[] d) {
\t\tString[] result=new String[d.length];
\t\tfor (int i = 0; i < d.length; i++)
\t\t\tresult[i] = fmt.format(d[i]);
\t\treturn result;
\t}
}\
\>", "Program",
 CellTags->"jlug:5.3.2.5",
 CellID->874],

Cell["This new version takes less than 2 seconds:", "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->1364],

Cell[BoxData[{
 StyleBox[
  RowBox[{
   RowBox[{"LoadJavaClass", "[", "\"\<FormatArray\>\"", "]"}], ";"}], 
  "MB"], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"FormatArray`format", "[", 
    RowBox[{"fmt", ",", "data"}], "]"}], ";"}], "MB"]}], "Input",
 CellTags->"jlug:5.3.2.5",
 CellLabel->"In[7]:=",
 CellID->67080215]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reference Counts and Memory Management", "Section",
 CellTags->{"TableOfContents_1.5.3.3", "1.2.2", "jlug:5.3.3.0"},
 CellID->12158],

Cell[CellGroupData[{

Cell[TextData[{
 "Object References in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Subsection",
 CellTags->{"jlug:5.3.3.1", "TableOfContents_1.5.3.3.1"},
 CellID->12022],

Cell[TextData[{
 "In our earlier treatment of ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions we avoided discussing deeper issues such as reference counts \
and uniqueness. Every time a Java object reference is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", either as a result of a method or field or an explicit call to ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ", ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " looks to see if a reference to this object has been sent previously in \
this session. If not, it creates a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and sets up a number of definitions for it. This is a comparatively \
time-consuming process. If this object has already been sent to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", in most cases ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " simply creates a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression that is identical to the one created previously. This is a much \
faster operation."
}], "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->1146],

Cell[TextData[{
 "There are some exceptions to this last rule, meaning that sometimes when an \
object is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " a new and different ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression is created for it, even though this same object has previously \
been sent to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Specifically, any time an object\[CloseCurlyQuote]s ",
 StyleBox["hashCode()", "MR"],
 " value has changed since the last time it was seen in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression created will be different. You do not really need to be \
concerned with the details of this, except to remember that ",
 StyleBox["SameQ", "MR"],
 " is not a valid way to compare ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions to decide whether they refer to the same object. You must use \
the ",
 Cell[BoxData[
  ButtonBox["SameObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/SameObjectQ"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->18392],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SameObjectQ",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/SameObjectQ"], "[", 
     StyleBox["obj1", "TI"], ",", 
     StyleBox["obj2", "TI"], "]"}], Cell[TextData[{
     "return ",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if the ",
     ButtonBox["JavaObject",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaObject"],
     " expressions ",
     Cell[BoxData[
      StyleBox["obj1", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["obj2", "TI"]], "InlineFormula"],
     " refer to the same Java object, ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.3.1",
 CellID->13037],

Cell["Comparing JavaObject expressions. ", "Caption",
 CellTags->"jlug:5.3.3.1",
 CellID->3925],

Cell["Here is an example.", "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->10647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pt", " ", "=", " ", 
  RowBox[{"JavaNew", "[", 
   RowBox[{"\"\<java.awt.Point\>\"", ",", " ", "1", ",", " ", "1"}], 
   "]"}]}]], "Input",
 CellTags->"jlug:5.3.3.1",
 CellLabel->"In[1]:=",
 CellID->29458],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]JavaObject", "[", "\<\"java.awt.Point\"\>", "]"}],
    "\[RightGuillemet]"}],
  JLink`Objects`JavaObject138675904053249]], "Output",
 CellTags->"jlug:5.3.3.1",
 CellLabel->"Out[1]=",
 CellID->6602]
}, Open  ]],

Cell[TextData[{
 "The variable ",
 StyleBox["pt", "MR"],
 " refers to a Java ",
 StyleBox["Point", "MR"],
 " object. Now we put it into a container so we can get it back out later:"
}], "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->30807],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec", " ", "=", " ", 
   RowBox[{"JavaNew", "[", "\"\<java.util.Vector\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vec", "@", 
   RowBox[{"add", "[", "pt", "]"}]}], ";"}]}], "Input",
 CellTags->"jlug:5.3.3.1",
 CellLabel->"In[2]:=",
 CellID->4098],

Cell[TextData[{
 "Now we change the value of one of its fields. For a ",
 StyleBox["Point", "MR"],
 " object, changing the value of one of its fields changes its ",
 StyleBox["hashCode()", "MR"],
 " value."
}], "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->27830],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pt", "@", "x"}], " ", "=", " ", "2"}], ";"}]], "Input",
 CellTags->"jlug:5.3.3.1",
 CellLabel->"In[4]:=",
 CellID->29292],

Cell[TextData[{
 "Now we compare the ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression given by ",
 StyleBox["pt", "MR"],
 " and the ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression created when we ask for the first element of the ",
 StyleBox["Vector", "MR"],
 " to be returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Even though these are both references to the same Java object, the ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions are different:"
}], "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->14600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pt", "===", 
  RowBox[{"vec", "@", 
   RowBox[{"elementAt", "[", "0", "]"}]}]}]], "Input",
 CellTags->"jlug:5.3.3.1",
 CellLabel->"In[5]:=",
 CellID->7278],

Cell[BoxData["False"], "Output",
 CellTags->"jlug:5.3.3.1",
 CellLabel->"Out[5]=",
 CellID->20799]
}, Open  ]],

Cell[TextData[{
 "Because we cannot use ",
 StyleBox["SameQ", "MR"],
 " (",
 StyleBox["===", "MR"],
 ") to decide whether two object references in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " refer to the same Java object, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides a function, ",
 Cell[BoxData[
  ButtonBox["SameObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/SameObjectQ"]], "InlineFormula"],
 ", for this purpose:"
}], "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->18352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SameObjectQ", "[", 
  RowBox[{"pt", ",", 
   RowBox[{"vec", "@", 
    RowBox[{"elementAt", "[", "0", "]"}]}]}], "]"}]], "Input",
 CellTags->"jlug:5.3.3.1",
 CellLabel->"In[6]:=",
 CellID->20448],

Cell[BoxData["True"], "Output",
 CellTags->"jlug:5.3.3.1",
 CellLabel->"Out[6]=",
 CellID->13882]
}, Open  ]],

Cell[TextData[{
 "You may be wondering why the ",
 Cell[BoxData[
  ButtonBox["SameObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/SameObjectQ"]], "InlineFormula"],
 " function is necessary. Can\[CloseCurlyQuote]t we just call an object\
\[CloseCurlyQuote]s ",
 StyleBox["equals()", "MR"],
 " method? It certainly gives the correct result for this example:"
}], "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pt", "@", 
  RowBox[{"equals", "[", 
   RowBox[{"vec", "@", 
    RowBox[{"elementAt", "[", "0", "]"}]}], "]"}]}]], "Input",
 CellTags->"jlug:5.3.3.1",
 CellLabel->"In[7]:=",
 CellID->28315],

Cell[BoxData["True"], "Output",
 CellTags->"jlug:5.3.3.1",
 CellLabel->"Out[7]=",
 CellID->4575]
}, Open  ]],

Cell[TextData[{
 "The problem with this technique is that ",
 StyleBox["equals()", "MR"],
 " does not always compare object references. Any class is free to override \
",
 StyleBox["equals()", "MR"],
 " to provide any desired behavior for comparing two objects of that class. \
Some classes make ",
 StyleBox["equals()", "MR"],
 " compare the \[OpenCurlyDoubleQuote]contents\[CloseCurlyDoubleQuote] of the \
objects, such as the ",
 StyleBox["String", "MR"],
 " class, which uses it for string comparison. Java provides two distinct \
equality operations, the ",
 StyleBox["==", "MR"],
 " operator and the ",
 StyleBox["equals()", "MR"],
 " method. The ",
 StyleBox["==", "MR"],
 " operator always compares references, returning ",
 StyleBox["true", "MR"],
 " if and only if the references point to the same object, but ",
 StyleBox["equals()", "MR"],
 " is often overridden for some other type of comparison. Because there is no \
method call in Java that mimics the behavior of the \
language\[CloseCurlyQuote]s ",
 StyleBox["==", "MR"],
 " operator as applied to object references, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " needs a ",
 Cell[BoxData[
  ButtonBox["SameObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/SameObjectQ"]], "InlineFormula"],
 " function that provides that behavior for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programmers."
}], "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->8762],

Cell[TextData[{
 "In an unusual case where you need to compare object references for equality \
a very large number of times, the comparative slowness of ",
 Cell[BoxData[
  ButtonBox["SameObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/SameObjectQ"]], "InlineFormula"],
 " compared to ",
 StyleBox["SameQ", "MR"],
 " could become an issue. The only thing that could cause two ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions that refer to the exact same Java object to be not ",
 StyleBox["SameQ", "MR"],
 " is if the ",
 StyleBox["hashCode()", "MR"],
 " value of the object changed between the times that the two ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions were created. If you know this has not happened, then you can \
safely use ",
 StyleBox["SameQ", "MR"],
 " as the test whether they refer to the same object."
}], "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->9567]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReleaseJavaObject", "Subsection",
 CellTags->{"jlug:5.3.3.2", "TableOfContents_1.5.3.3.2"},
 CellID->22336],

Cell[TextData[{
 "The Java language has a built-in facility called \
\[OpenCurlyDoubleQuote]garbage collection\[CloseCurlyDoubleQuote] for freeing \
up memory occupied by objects that are no longer in use by a program. Objects \
become eligible for garbage collection when no references to them exist \
anywhere, except perhaps in other objects that are also unreferenced. When an \
object is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", either as a result of a call to ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " or as the return value of a method call or field access, the ",
 StyleBox["J/Lin",
  FontSlant->"Italic"],
 "k code holds a special reference to the object on the Java side to ensure \
that it cannot be garbage-collected while it is in use by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you know that you no longer need to use a given Java object in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you can explicitly tell ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to release its reference. The function that does this is ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 ". In addition to releasing the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-specific reference in Java, ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " clears out internal definitions for the object that were created in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Any subsequent attempt to use this object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will fail."
}], "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->18397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"frm", "=", 
  RowBox[{"JavaNew", "[", "\"\<java.awt.Frame\>\"", "]"}]}]], "Input",
 CellTags->"jlug:5.3.3.2",
 CellLabel->"In[1]:=",
 CellID->31418],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]JavaObject", "[", "\<\"java.awt.Frame\"\>", "]"}],
    "\[RightGuillemet]"}],
  JLink`Objects`JavaObject134324354547713]], "Output",
 CellTags->"jlug:5.3.3.2",
 CellLabel->"Out[1]=",
 CellID->19897]
}, Open  ]],

Cell[TextData[{
 "Now tell Java that we no longer need to use this object from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->25828],

Cell[BoxData[
 RowBox[{"ReleaseJavaObject", "[", "frm", "]"}]], "Input",
 CellTags->"jlug:5.3.3.2",
 CellLabel->"In[2]:=",
 CellID->13851],

Cell[TextData[{
 "It is now an error to refer to ",
 StyleBox["frm", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->26816],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReleaseJavaObject",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ReleaseJavaObject"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[TextData[{
     "let Java know that you are done using ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["ReleaseObject", "MR"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[TextData[{
     "deprecated; replaced by ",
     StyleBox[ButtonBox["ReleaseJavaObject",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ReleaseJavaObject"], "InlineCode"],
     " in ",
     StyleBox["J/Link",
      FontSlant->"Italic"],
     " 2.0"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JavaBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaBlock"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "all novel Java objects returned to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " during the evaluation of ",
     StyleBox["expr",
      FontSlant->"Italic"],
     " will be released when ",
     StyleBox["expr",
      FontSlant->"Italic"],
     " finishes"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BeginJavaBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/BeginJavaBlock"], "[", "]"}], Cell[
    TextData[{
     "all novel Java objects returned to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " between now and the matching ",
     ButtonBox["EndJavaBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/EndJavaBlock"],
     "[]",
     " will be released"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EndJavaBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/EndJavaBlock"], "[", "]"}], Cell[
    TextData[{
     "release all novel objects seen since the matching ",
     ButtonBox["BeginJavaBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/BeginJavaBlock"],
     "[]"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadedJavaObjects",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/LoadedJavaObjects"], "[", "]"}], Cell[
    TextData[{
     "return a list of all objects that are in use in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadedJavaClasses",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/LoadedJavaClasses"], "[", "]"}], Cell[
    TextData[{
     "return a list of all classes loaded into ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.3.2",
 CellID->24230],

Cell["J/Link memory management functions.", "Caption",
 CellTags->"jlug:5.3.3.2",
 CellID->4449],

Cell[TextData[{
 "Calling ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " will not necessarily cause the object to be garbage-collected. It is quite \
possible that other references to it exist in Java. ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " does not tell Java to throw the object away, only that it does not need to \
be kept around solely for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s sake."
}], "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->16925],

Cell[TextData[{
 "An important fact about the references that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " maintains for objects sent to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that only one reference is kept for each object, no matter how many \
times it is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It is your responsibility to make sure that after you call ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 ", you never attempt to use that object through any reference that might \
exist to it in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session."
}], "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->658],

Cell[BoxData[{
 RowBox[{
  RowBox[{"frm", "=", 
   RowBox[{"JavaNew", "[", "\"\<java.awt.Frame\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b1", "=", 
   RowBox[{"JavaNew", "[", "\"\<java.awt.Button\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"jlug:5.3.3.2",
 CellLabel->"In[3]:=",
 CellID->229],

Cell[TextData[{
 "The ",
 StyleBox["add()", "MR"],
 " method of the ",
 StyleBox["Frame", "MR"],
 " class returns the object added, so ",
 StyleBox["b2", "MR"],
 " refers to the same object as ",
 StyleBox["b1", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->24520],

Cell[BoxData[
 RowBox[{
  RowBox[{"b2", "=", 
   RowBox[{"frm", "@", 
    RowBox[{"add", "[", "b1", "]"}]}]}], ";"}]], "Input",
 CellTags->"jlug:5.3.3.2",
 CellLabel->"In[5]:=",
 CellID->10940],

Cell[TextData[{
 "If we call ",
 StyleBox["ReleaseJavaObject[b1]", "MR"],
 ", it is not the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbol ",
 StyleBox["b1", "MR"],
 " that is affected, but the Java object that ",
 StyleBox["b1", "MR"],
 " refers to. Therefore, using ",
 StyleBox["b2", "MR"],
 " is also an error (or any other way to refer to this same ",
 StyleBox["Button", "MR"],
 " object, such as ",
 StyleBox["%", "MR"],
 ")."
}], "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->29560],

Cell[TextData[{
 "Calling ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " is often not necessary in casual use. If you are not making heavy use of \
Java in your session then you will usually not need to be concerned about \
keeping track of what objects may or may not be needed anymore\[LongDash]you \
can just let them pile up. There are special times, though, when memory use \
in Java will be important, and you may need the extra control that ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " provides."
}], "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->15147]
}, Open  ]],

Cell[CellGroupData[{

Cell["JavaBlock", "Subsection",
 CellTags->{"jlug:5.3.3.3", "TableOfContents_1.5.3.3.3"},
 CellID->25162],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " is provided mainly for developers who are writing code for others to use. \
Because one can never predict how one\[CloseCurlyQuote]s code will be used, \
developers should always be sure that their code cleans up any unnecessary \
references it creates. Probably the most useful function for this is ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->639716680],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " automates the process of releasing objects encountered during the \
evaluation of an expression. Often, a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program will need to create some Java objects with ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ", operate with them, perhaps causing other objects to be returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as the results of method calls, and finally return some result such as a \
number or string. Every Java object encountered by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " during this operation is needed only during the lifetime of the program, \
much like the local variables provided in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by ",
 StyleBox["Block", "MR"],
 " and ",
 StyleBox["Module", "MR"],
 ", and in C, C++, Java, and many other languages by block scoping constructs \
(e.g., {}). ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " allows you to mark a block of code as having the property that any new \
objects returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " during the evaluation are to be treated as temporary, and released when ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " finishes."
}], "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->20675],

Cell[TextData[{
 "It is important to note that the preceding sentence said \
\[OpenCurlyDoubleQuote]new objects.\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " will not cause every object encountered during the evaluation to be \
released, only those that are being encountered for the first time. Objects \
that have already been seen by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not be affected. This means that you do not have to worry that ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " will aggressively release an object that is not truly temporary to that \
evaluation."
}], "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->792],

Cell[TextData[{
 "It is not enough simply to call ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " on every object you create with ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ", because many Java method calls return objects. You may not be interested \
in these return values, or you may never assign them to a named variable \
because they may be chained together with other calls (as in ",
 StyleBox["obj@returnsObject[]@foo[]", "MR"],
 "), but you still need to release them. Using ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " is an easy way to be sure that all novel objects are released when a block \
of code finishes."
}], "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->22361],

Cell[TextData[{
 StyleBox["JavaBlock[expr]", "MR"],
 " returns whatever ",
 StyleBox["expr", "MR"],
 " returns."
}], "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->31754],

Cell[TextData[{
 "Many ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs will have the following structure:"
}], "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->16398],

Cell[BoxData[
 RowBox[{
  RowBox[{"MyFunc", "[", "args__", "]"}], ":=", "\[IndentingNewLine]", "\t", 
  RowBox[{"JavaBlock", "[", "\[IndentingNewLine]", "\t\t", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "locals", "}"}], ",", "\[IndentingNewLine]", "\t\t\t", 
     "..."}], "\t\t", "\[IndentingNewLine]", "\t\t", "]"}], 
   "\[IndentingNewLine]", "\t", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.3.3",
 CellID->23146],

Cell[TextData[{
 "It is very common to write a function that creates and manipulates a number \
of ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions, and then returns one of them, the rest being temporary. To \
facilitate this, if the return value of a ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " is a single ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 ", it will not be released."
}], "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->8714],

Cell[BoxData[
 RowBox[{
  RowBox[{"MyOtherFunc", "[", "args__", "]"}], ":=", "\n", "\t", 
  RowBox[{"JavaBlock", "[", "\n", "\t\t", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "obj", "}"}], ",", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"...", "\n", "\t\t\t", "obj"}], "=", 
         RowBox[{"JavaNew", "[", "\"\<java.awt.Frame\>\"", "]"}]}], ";"}], 
       "\n", "\t\t\t", "..."}], " ", "\n", "\t\t\t", 
      RowBox[{"Return", "[", "obj", "]"}]}]}], "  ", 
    RowBox[{"(*", " ", 
     RowBox[{"OK", ":", " ", 
      RowBox[{
      "obj", " ", "will", " ", "not", " ", "be", " ", "released", " ", "when",
        " ", "JavaBlock", " ", 
       RowBox[{"finishes", "."}]}]}], " ", "*)"}], "\n", "\t\t", "]"}], "\n", 
   "\t", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.3.3",
 CellID->26946],

Cell[TextData[{
 "New in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.1 is the ",
 Cell[BoxData[
  ButtonBox["KeepJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/KeepJavaObject"]], "InlineFormula"],
 " function, which allows you to specify an object or sequence of objects \
that should not be released when the ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " ends. Calling ",
 Cell[BoxData[
  ButtonBox["KeepJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/KeepJavaObject"]], "InlineFormula"],
 " on a single object or sequence of objects means they will not be released \
when the first enclosing ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " ends. If there is an outer enclosing ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ", the objects will be freed when ",
 StyleBox["it",
  FontSlant->"Italic"],
 " ends, however, so if you want the objects to escape a nested set of ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 "s, you must call ",
 Cell[BoxData[
  ButtonBox["KeepJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/KeepJavaObject"]], "InlineFormula"],
 " at each level. Alternatively, you can call ",
 StyleBox["KeepJavaObject[obj, Manual]", "MR"],
 ", where the ",
 StyleBox["Manual", "MR"],
 " argument tells ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " that the object should not be released by any enclosing ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 "s. The only way such object will be released is if you manually call ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " on it. Here is an example that uses ",
 Cell[BoxData[
  ButtonBox["KeepJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/KeepJavaObject"]], "InlineFormula"],
 " to allow us to return a list of two objects without them being released:"
}], "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->21188],

Cell["\<\
MyOtherFunc[args__] :=
\tModule[{obj1, obj2, obj3}, 
\t\tJavaBlock[
\t\t\tobj1 = JavaNew[\"java.awt.Frame\"]; 
\t\t\tobj2 = JavaNew[\"java.awt.Button\"]; 
     \t\tobj3 = JavaNew[\"SomeTemporaryObject\"];
     \t\t...
     \t\tKeepJavaObject[obj1, obj2];
     \t\t{obj1, obj2}
     \t]
     ]\
\>", "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.3.3",
 CellID->19569],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BeginJavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/BeginJavaBlock"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EndJavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/EndJavaBlock"]], "InlineFormula"],
 " can be used to provide the same functionality as ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " across more than one evaluation. ",
 Cell[BoxData[
  ButtonBox["EndJavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/EndJavaBlock"]], "InlineFormula"],
 " releases all novel Java objects returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " since the previous matching ",
 Cell[BoxData[
  ButtonBox["BeginJavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/BeginJavaBlock"]], "InlineFormula"],
 ". These functions are mainly of use during development, when you might want \
to set a mark in your session, do some work, and then release all novel \
objects returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " since that point. ",
 Cell[BoxData[
  ButtonBox["BeginJavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/BeginJavaBlock"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EndJavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/EndJavaBlock"]], "InlineFormula"],
 " can be nested. Every ",
 Cell[BoxData[
  ButtonBox["BeginJavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/BeginJavaBlock"]], "InlineFormula"],
 " should have a matching ",
 Cell[BoxData[
  ButtonBox["EndJavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/EndJavaBlock"]], "InlineFormula"],
 ", although it is not a serious error to forget to call ",
 Cell[BoxData[
  ButtonBox["EndJavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/EndJavaBlock"]], "InlineFormula"],
 ", even if you have nested levels of them\[LongDash]you will only fail to \
release some objects."
}], "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->8638]
}, Open  ]],

Cell[CellGroupData[{

Cell["LoadedJavaObjects and LoadedJavaClasses", "Subsection",
 CellTags->{"jlug:5.3.3.5", "TableOfContents_1.5.3.3.5"},
 CellID->24515],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LoadedJavaObjects",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/LoadedJavaObjects"], "[", "]"}]], 
  "InlineFormula"],
 " returns a list of all Java objects that are currently referenced in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This includes all objects explicitly created with ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " and all those that were returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as the result of a Java method call or field access. It does not include \
objects that have been released with ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " or through ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["LoadedJavaObjects",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadedJavaObjects"]], "InlineFormula"],
 " is intended mainly for debugging. It is very useful to call it before and \
after some function you are working on. If the list grows, your function \
leaks references, and you need to examine its use of ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " and/or ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.3.5",
 CellID->11521],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LoadedJavaClasses",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/LoadedJavaClasses"], "[", "]"}]], 
  "InlineFormula"],
 " returns a list of ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expressions representing all classes loaded into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Like ",
 Cell[BoxData[
  ButtonBox["LoadedJavaObjects",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadedJavaObjects"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LoadedJavaClasses",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadedJavaClasses"]], "InlineFormula"],
 " is intended mainly for debugging. Note that you do not have to determine \
if a class has already been loaded before you call ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 ". If the class has been loaded, ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " does nothing but return the appropriate ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expression."
}], "Text",
 CellTags->"jlug:5.3.3.5",
 CellID->475]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exceptions", "Section",
 CellTags->{"TableOfContents_1.5.3.4", "1.2.3", "jlug:5.3.4.0"},
 CellID->10195],

Cell[CellGroupData[{

Cell["How Exceptions are Handled", "Subsection",
 CellTags->{"jlug:5.3.4.1", "TableOfContents_1.5.3.4.1"},
 CellID->32525],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " handles Java exceptions automatically. If an uncaught exception is thrown \
during any call into Java, you will get a message in ",
 StyleBox["Mathematica", "TI",
  FontSlant->"Italic"],
 StyleBox[".", "TI"],
 " Here is an example that tries to format a real number as an integer:"
}], "Text",
 CellTags->"jlug:5.3.4.1",
 CellID->1264],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadClass", "[", "\"\<java.lang.Integer\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Integer`parseInt", "[", "\"\<1234.5\>\"", "]"}]}], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.4.1",
 CellLabel->"In[1]:=",
 CellID->8260],

Cell[BoxData[
 RowBox[{"Java", "::", 
  RowBox[{"excptn", ":", " ", 
   RowBox[{"A", " ", "Java", " ", "exception", " ", 
    RowBox[{"occurred", ":", " ", 
     RowBox[{
     "java", ".", "lang", ".", "ArrayIndexOutOfBoundsException", 
      "."}]}]}]}]}]], "Message", "MSG",
 CellTags->"jlug:5.3.4.1",
 CellID->6202],

Cell[BoxData[
 StyleBox["$Failed", "MR"]], "Output",
 CellTags->"jlug:5.3.4.1",
 CellLabel->"Out[1]=",
 CellID->8116]
}, Open  ]],

Cell[TextData[{
 "If the exception is thrown before the method returns a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", as above, the result of the call will be ",
 StyleBox["$Failed", "MR"],
 ". As discussed later in ",
 ButtonBox["Manually Returning a Result to ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#27753"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#27753"],
  FontSlant->"Italic"],
 ", it is possible to write your own methods that manually send a result to \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " before they return. In such cases, if an exception is thrown after the \
result is sent to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " but before the method returns, you will get a warning message reporting \
the exception, but the result of the call will be unaffected."
}], "Text",
 CellTags->"jlug:5.3.4.1",
 CellID->5030],

Cell[TextData[{
 "If the Java code was compiled with debugging information included, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " message you get as a result of an exception will show the full stack trace \
to the point where the exception occurred, with the exact line numbers in \
each file."
}], "Text",
 CellTags->"jlug:5.3.4.1",
 CellID->20326]
}, Open  ]],

Cell[CellGroupData[{

Cell["The JavaThrow Function", "Subsection",
 CellTags->{"jlug:5.3.4.2", "TableOfContents_1.5.3.4.2"},
 CellID->29011],

Cell[TextData[{
 "In some cases, you may want to cause an exception to be thrown in Java. \
This can be done with the ",
 Cell[BoxData[
  ButtonBox["JavaThrow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaThrow"]], "InlineFormula"],
 " function. ",
 Cell[BoxData[
  ButtonBox["JavaThrow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaThrow"]], "InlineFormula"],
 " is new in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0 and should be considered experimental. Its behavior might change in \
future versions."
}], "Text",
 CellTags->"jlug:5.3.4.2",
 CellID->30771],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["JavaThrow",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaThrow"], "[", 
     StyleBox["exceptionObj", "TI"], "]"}], Cell[
    "throw the given exception object in Java", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.4.2",
 CellID->6411],

Cell[TextData[{
 "Throwing Java exceptions from ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"]
}], "Caption",
 CellTags->"jlug:5.3.4.2",
 CellID->25547],

Cell[TextData[{
 "You will only want to use ",
 Cell[BoxData[
  ButtonBox["JavaThrow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaThrow"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code that is itself called from Java. It is quite common for ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programs written in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to involve both calls from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into Java and calls from Java back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Such \[OpenCurlyDoubleQuote]callbacks\[CloseCurlyDoubleQuote] to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are used extensively in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs that create Java user interfaces, as described in detail later in \
the section ",
 ButtonBox["Creating Windows and Other User Interface Elements",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4596"],
 ". For example, you can associate a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function to be called when the user clicks a Java button. This ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function is called directly from Java, and you might want it to behave \
just like a Java method, including having the ability to throw Java \
exceptions."
}], "Text",
 CellTags->"jlug:5.3.4.2",
 CellID->21153],

Cell[TextData[{
 "An example of throwing an exception in a callback from a user interface \
action like clicking a button is not very realistic because there is \
typically nothing in Java to catch such exceptions; thus they are essentially \
ignored. A more meaningful example would be a program that involved a mix of \
Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code where, for flexibility and ease of development reasons, you have a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function being called to implement the \[OpenCurlyDoubleQuote]guts\
\[CloseCurlyDoubleQuote] of a Java method that can throw an exception. As a \
concrete example, say you are doing XML processing with Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using the SAX (Simple API for XML) API. SAX processing is based on a set \
of handler methods that are called as certain events occur during parsing of \
the XML document. Each such method can throw a ",
 StyleBox["SAXException", "MR"],
 " to indicate an error and halt the parsing. You want to implement these \
handler methods in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code, and thus you want a way to throw a ",
 StyleBox["SAXException", "MR"],
 " from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Here is a hypothetical example of one such handler method, the ",
 StyleBox["startDocument()", "MR"],
 " method, which is invoked by the SAX engine when document processing \
starts:"
}], "Text",
 CellTags->"jlug:5.3.4.2",
 CellID->21520],

Cell[BoxData[
 RowBox[{
  RowBox[{"startDocument", "[", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"!", "readyToAcceptParsingEvents"}], ",", 
    RowBox[{"JavaThrow", "[", 
     RowBox[{"JavaNew", "[", 
      RowBox[{
      "\"\<org.xml.sax.SAXException\>\"", ",", 
       "\"\<Mathematica code has not been initialized\>\""}], "]"}], "]"}]}], 
   "]"}]}]], "Input",
 CellTags->"jlug:5.3.4.2",
 CellID->29790],

Cell[TextData[{
 "After a call to ",
 Cell[BoxData[
  ButtonBox["JavaThrow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaThrow"]], "InlineFormula"],
 ", the rest of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function executes normally, but there is no result returned to Java."
}], "Text",
 CellTags->"jlug:5.3.4.2",
 CellID->14924]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Returning Objects ",
 StyleBox["\[OpenCurlyDoubleQuote]", "TB"],
 "By Value",
 StyleBox["\[CloseCurlyDoubleQuote]", "TB"],
 " and ",
 StyleBox["\[OpenCurlyDoubleQuote]", "TB"],
 "By Reference",
 StyleBox["\[CloseCurlyDoubleQuote]", "TB"]
}], "Section",
 CellTags->{"TableOfContents_1.5.3.5", "1.2.5", "jlug:5.3.5.0"},
 CellID->31497],

Cell[CellGroupData[{

Cell["References and Values", "Subsection",
 CellTags->{"jlug:5.3.5.1", "TableOfContents_1.5.3.5.1"},
 CellID->2785],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides a mapping between certain ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions and their Java counterparts. What this means is that these ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions are automatically converted to and from their Java \
counterparts as they are passed between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java. For example, Java integer types (",
 StyleBox["long", "MR"],
 ", ",
 StyleBox["short", "MR"],
 ", ",
 StyleBox["int", "MR"],
 ", and so on) are converted to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " integers and Java real types (",
 StyleBox["float", "MR"],
 " and ",
 StyleBox["double", "MR"],
 ") are converted to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " real numbers. Another mapping is that Java objects are converted to ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". These ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions are ",
 StyleBox["references",
  FontSlant->"Italic"],
 " to Java objects\[LongDash]they have no meaning in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " except as they are manipulated by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". However, some Java objects are things that have meaningful values in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and these objects are by default converted to values. Examples of such \
objects are strings and arrays."
}], "Text",
 CellTags->"jlug:5.3.5.1",
 CellID->18529],

Cell[TextData[{
 "One could say, then, that Java objects are by default returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \[OpenCurlyDoubleQuote]by reference,\[CloseCurlyDoubleQuote] except for a \
few special cases. These special cases are strings, arrays, complex numbers \
(discussed later), ",
 StyleBox["BigDecimal", "MR"],
 " and ",
 StyleBox["BigInteger", "MR"],
 " (discussed later), and  the \[OpenCurlyDoubleQuote]wrapper\
\[CloseCurlyDoubleQuote] classes (e.g., ",
 StyleBox["java.lang.Integer", "MR"],
 "). You could say that these exceptional cases are returned \
\[OpenCurlyDoubleQuote]by value.\[CloseCurlyDoubleQuote] The table in ",
 ButtonBox["Conversion of Types Between Java and ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17780"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17780"],
  FontSlant->"Italic"],
 " shows how these special Java object types are mapped into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " values."
}], "Text",
 CellTags->"jlug:5.3.5.1",
 CellID->31540],

Cell[TextData[{
 "In summary, every Java object that has a meaningful value representation in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is converted into this value, simply because that is the most useful \
behavior. There are times, however, when you might want to override this \
default behavior. Probably the most common reason for doing this is to avoid \
unnecessary traffic of large expressions over ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.5.1",
 CellID->18805],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReturnAsJavaObject",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "a Java object returned by ",
     StyleBox["expr",
      FontSlant->"Italic"],
     " will be in the form of a reference"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["ByRef", "MR"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "deprecated; replaced by ",
     ButtonBox["ReturnAsJavaObject",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"],
     " in ",
     StyleBox["J/Link",
      FontSlant->"Italic"],
     " 2.0"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JavaObjectToExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaObjectToExpression"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[TextData[{
     "give the value of the Java object ",
     StyleBox["obj",
      FontSlant->"Italic"],
     " as a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Val", "MR"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[TextData[{
     "deprecated; replaced by ",
     ButtonBox["JavaObjectToExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaObjectToExpression"],
     " in ",
     StyleBox["J/Link",
      FontSlant->"Italic"],
     " 2.0"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.5.1",
 CellID->28791],

Cell[TextData[{
 StyleBox["\[OpenCurlyDoubleQuote]", "TR"],
 "By reference",
 StyleBox["\[CloseCurlyDoubleQuote]", "TR"],
 " and ",
 StyleBox["\[OpenCurlyDoubleQuote]", "TR"],
 "by value",
 StyleBox["\[CloseCurlyDoubleQuote]", "TR"],
 " control."
}], "Caption",
 CellTags->"jlug:5.3.5.1",
 CellID->13392]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReturnAsJavaObject", "Subsection",
 CellTags->{"jlug:5.3.5.2", "TableOfContents_1.5.3.5.2"},
 CellID->13210],

Cell[TextData[{
 "Consider the case where you have a static method in class ",
 StyleBox["MyClass", "MR"],
 " called ",
 StyleBox["arrayAbs()", "MR"],
 " that takes an array of doubles and returns a new array where each element \
is the absolute value of the corresponding element in the argument array. The \
declaration of this method thus looks like ",
 StyleBox["double[] arrayAbs(double[] a)", "MR"],
 ". This is how you would call such a method from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->13549],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadJavaClass", "[", 
   RowBox[{"\"\<MyClass\>\"", ",", 
    RowBox[{"StaticsVisible", "\[Rule]", "True"}]}], "]"}], ";"}], "\n", 
 RowBox[{"arrayAbs", "[", 
  RowBox[{"{", 
   RowBox[{"1.", ",", 
    RowBox[{"-", "2."}], ",", "3.", ",", "4."}], "}"}], "]"}]}], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellLabel->"In[1]:=",
 CellID->21578],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"1.", ",", "2.", ",", "3.", ",", "4."}], "}"}], "MR"]], "Output",
 CellTags->"jlug:5.3.5.2",
 CellLabel->"Out[2]=",
 CellID->26979]
}, Open  ]],

Cell[TextData[{
 "The above example is how you probably want the method to work: you pass a \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list and get back a list. Now assume you have another method named ",
 StyleBox["arraySqrt()", "MR"],
 " that acts like ",
 StyleBox["arrayAbs()", "MR"],
 " except that it performs the ",
 StyleBox["sqrt()", "MR"],
 " function instead of ",
 StyleBox["abs()", "MR"],
 ". "
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->30971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"arraySqrt", "[", 
  RowBox[{"arrayAbs", "[", 
   RowBox[{"{", 
    RowBox[{"1.", ",", 
     RowBox[{"-", "2."}], ",", "3.", ",", "4."}], "}"}], "]"}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellLabel->"In[3]:=",
 CellID->9277],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"1.", ",", "1.41421", ",", "1.73205", ",", "2."}], "}"}], 
  "MR"]], "Output",
 CellTags->"jlug:5.3.5.2",
 CellLabel->"Out[3]=",
 CellID->73]
}, Open  ]],

Cell[TextData[{
 "In this computation, the original list is sent over ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to Java and a Java array is created with these values. That array is \
passed as an argument to ",
 StyleBox["arrayAbs()", "MR"],
 ", which itself creates and returns another array. This array is then sent \
back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to create a list, which is then promptly sent back to Java as the argument \
for ",
 StyleBox["arraySqrt()", "MR"],
 ". We can see that it was a waste of time to send the array data back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[LongDash]we had a perfectly good array (the one returned by the ",
 StyleBox["arrayAbs()", "MR"],
 " method) living on the Java side, ready to be passed to ",
 StyleBox["arraySqrt()", "MR"],
 ", but instead we sent its contents back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " only to have it immediately come back to Java again as a new array with \
the same values! For this example, the cost is negligible, but what if the \
array has 200,000 elements?"
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->20193],

Cell[TextData[{
 "What is needed is a way to let the array data remain in Java and return \
only a reference to the array, not the actual data itself. This can be \
accomplished with the ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " function:"
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->1620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReturnAsJavaObject", "[", 
  RowBox[{"arrayAbs", "[", 
   RowBox[{"{", 
    RowBox[{"1.", ",", 
     RowBox[{"-", "2."}], ",", "3.", ",", "4."}], "}"}], "]"}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellLabel->"In[4]:=",
 CellID->21497],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]JavaObject", "[", "\<\"[D\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject4579100917761]], "Output",
 CellTags->"jlug:5.3.5.2",
 CellLabel->"Out[4]=",
 CellID->13826]
}, Open  ]],

Cell[TextData[{
 "Note that the class name of the ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " is \[OpenCurlyDoubleQuote][D\[CloseCurlyDoubleQuote], which, although a \
bit cryptic, is the actual Java class name of a one-dimensional array of \
doubles. Here is how the computation looks using ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->31276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"arraySqrt", "[", 
  RowBox[{"ReturnAsJavaObject", "[", 
   RowBox[{"arrayAbs", "[", 
    RowBox[{"{", 
     RowBox[{"1.", ",", 
      RowBox[{"-", "2."}], ",", "3.", ",", "4."}], "}"}], "]"}], "]"}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellLabel->"In[5]:=",
 CellID->19790],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"1.", ",", "1.41421", ",", "1.73205", ",", "2."}], "}"}], 
  "MR"]], "Output",
 CellTags->"jlug:5.3.5.2",
 CellLabel->"Out[5]=",
 CellID->6582]
}, Open  ]],

Cell[TextData[{
 "Earlier we saw ",
 StyleBox["arraySqrt()", "MR"],
 " being called with an argument that was a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list of reals. Here it is being called with a reference to a Java object \
that is a one-dimensional array of doubles. All methods and fields that take \
an array can be called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with either a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list or a reference to a Java array of the appropriate type."
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->13578],

Cell[TextData[{
 "Strings are the other type for which ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " is useful. Like arrays, strings have the two properties that (1) they are \
represented in Java as objects but also have a meaningful ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " value, and (2) they can be large, so it is useful to be able to avoid \
passing their data back and forth unnecessarily. As an example, say your \
class ",
 StyleBox["MyClass", "MR"],
 " has a static method that appends to a string a digit taken from an \
external device that you are controlling from Java. It takes a string and \
returns a new one, so its signature is ",
 StyleBox["static String appendDigit(String s)", "MR"],
 ". You have a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " variable named ",
 StyleBox["veryLongString", "MR"],
 " that holds a long string, and you want to append to this string 100 times. \
This code will cause the string contents to make 100 round trips between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java:"
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->11159],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"veryLongString", "=", 
     RowBox[{"appendString", "[", "veryLongString", "]"}]}], ",", 
    RowBox[{"{", "100", "}"}]}], "]"}], ";"}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellLabel->"In[6]:=",
 CellID->20418],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " lets the strings remain on the Java side, and thus it generates virtually \
no ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " traffic:"
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->26489],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"veryLongString", "=", 
     RowBox[{"ReturnAsJavaObject", "[", 
      RowBox[{"appendString", "[", "veryLongString", "]"}], "]"}]}], ",", 
    RowBox[{"{", "100", "}"}]}], "]"}], ";"}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellLabel->"In[7]:=",
 CellID->159],

Cell["\<\
This example is somewhat contrived, since repeatedly appending to a growing \
string is not a very efficient style of programming, but it illustrates the \
issues.\
\>", "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->3449],

Cell[TextData[{
 "When the above ",
 StyleBox["Do", "MR"],
 " loop is executed, ",
 StyleBox["veryLongString", "MR"],
 " gets assigned values that are not ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings, but ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions that refer to strings residing in Java. That means that ",
 StyleBox["appendString()", "MR"],
 " gets called with a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string the very first iteration, but with a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression thereafter. As is the case with arrays, any Java method or \
field that takes a string can be called in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " either with a string or a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression that refers to one. The ",
 StyleBox["veryLongString", "MR"],
 " variable started out holding a string, but at the end of the loop it holds \
a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression:"
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->12924],

Cell[CellGroupData[{

Cell[BoxData["veryLongString"], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellLabel->"In[8]:=",
 CellID->9072],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", "[", "\<\"java.lang.String\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject4299292673]], "Output",
 CellTags->"jlug:5.3.5.2",
 CellLabel->"Out[8]=",
 CellID->10380]
}, Open  ]],

Cell[TextData[{
 "At some point, we probably want an actual ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string, not this string object reference. How do we get the value back? We \
will visit this example again below when we introduce the ",
 Cell[BoxData[
  ButtonBox["JavaObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectToExpression"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->27008],

Cell[TextData[{
 "In summary, the ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " function causes methods and fields that return objects that would normally \
be converted into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " values to return references instead. It is an optimization to avoid \
unnecessarily passing large amounts of data between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java, and as such it will be useful primarily for very large arrays \
and strings. As with all optimizations, you should not concern yourself with \
",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " unless you have some code that is running at an unacceptable speed, or you \
know ahead of time that the code you are writing will benefit measurably from \
it. Objects of most Java classes have no meaningful \[OpenCurlyDoubleQuote]by \
value\[CloseCurlyDoubleQuote] representation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and they are always returned \[OpenCurlyDoubleQuote]by reference.\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " will have no effect in these cases."
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->27967],

Cell[TextData[{
 "Finally, note that ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " has no effect on methods in which the Java programmer manually sends the \
result back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (this topic is discussed later in this User Guide). Manually returning a \
result bypasses the normal result-handling routines in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", so there is no chance for the ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " request to be accommodated."
}], "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->10208]
}, Open  ]],

Cell[CellGroupData[{

Cell["JavaObjectToExpression", "Subsection",
 CellTags->{"jlug:5.3.5.3", "TableOfContents_1.5.3.5.3"},
 CellID->6477],

Cell[TextData[{
 "In the previous section, we saw how the ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " function can be used to cause objects normally returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by value to be returned by reference. It is necessary to have a function \
that does the reverse\[LongDash]takes a reference and converts it to its \
value representation. That function is ",
 Cell[BoxData[
  ButtonBox["JavaObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectToExpression"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.5.3",
 CellID->18503],

Cell[TextData[{
 "Returning to the ",
 StyleBox["appendString()", "MR"],
 " example above, we used ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " to avoid costly passing of string data back and forth over ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". The result of this was that the ",
 StyleBox["veryLongString", "MR"],
 " variable now held a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression, not a literal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string. ",
 Cell[BoxData[
  ButtonBox["JavaObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectToExpression"]], "InlineFormula"],
 " can be used to get the value of this string object as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string:"
}], "Text",
 CellTags->"jlug:5.3.5.3",
 CellID->15370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JavaObjectToExpression", "[", "veryLongString", "]"}]], "Input",
 CellTags->"jlug:5.3.5.3",
 CellLabel->"In[9]=",
 CellID->32607],

Cell[BoxData["\<\"\
037118086362644534489492294928989287822791948284089742269122236592851667829700\
62739405320988762893368\"\>"], "Output",
 CellTags->"jlug:5.3.5.3",
 CellLabel->"Out[9]=",
 CellID->14196]
}, Open  ]],

Cell[TextData[{
 "The majority of Java objects have no meaningful value representation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". These objects can only be represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions, and using ",
 Cell[BoxData[
  ButtonBox["JavaObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectToExpression"]], "InlineFormula"],
 " on them has no effect."
}], "Text",
 CellTags->"jlug:5.3.5.3",
 CellID->12074],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " function is not the only way to get a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression for an object that is normally returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a value. The ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " function always returns a reference:"
}], "Text",
 CellTags->"jlug:5.3.5.3",
 CellID->13722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JavaNew", "[", 
  RowBox[{"\"\<java.lang.String\>\"", ",", "\"\<a string\>\""}], 
  "]"}]], "Input",
 CellTags->"jlug:5.3.5.3",
 CellLabel->"In[10]:=",
 CellID->12611],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", "[", "\<\"java.lang.String\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject66044640100353]], "Output",
 CellTags->"jlug:5.3.5.3",
 CellLabel->"Out[10]=",
 CellID->19019]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JavaObjectToExpression", "[", "%", "]"}]], "Input",
 CellTags->"jlug:5.3.5.3",
 CellLabel->"In[11]:=",
 CellID->28761],

Cell[BoxData["\<\"a string\"\>"], "Output",
 CellTags->"jlug:5.3.5.3",
 CellLabel->"Out[11]=",
 CellID->11056]
}, Open  ]],

Cell[TextData[{
 "The next section introduces the ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " function, which is easier than using ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " to construct Java objects out of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings and arrays."
}], "Text",
 CellTags->"jlug:5.3.5.3",
 CellID->12890]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeJavaObject and MakeJavaExpr", "Section",
 CellTags->{"TableOfContents_1.5.3.6", "1.2.6", "jlug:5.3.6.0"},
 CellID->29288],

Cell[CellGroupData[{

Cell["Preamble", "Subsection",
 CellTags->{"jlug:5.3.6.1", "TableOfContents_1.5.3.6.1"},
 CellID->28082],

Cell[TextData[{
 "In addition to ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ", which calls a class constructor, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides two convenience functions for creating Java objects from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. These functions are ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MakeJavaExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaExpr"]], "InlineFormula"],
 ". Do not get them confused, despite their similar names. ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " is a commonly-used function for constructing objects of some special \
types.  ",
 Cell[BoxData[
  ButtonBox["MakeJavaExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaExpr"]], "InlineFormula"],
 " is an advanced function that creates an object of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 StyleBox["Expr", "MR"],
 " class representing an arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression."
}], "Text",
 CellTags->"jlug:5.3.6.1",
 CellID->1954]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeJavaObject", "Subsection",
 CellTags->{"jlug:5.3.6.2", "TableOfContents_1.5.3.6.2"},
 CellID->16085],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MakeJavaObject",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/MakeJavaObject"], "[", 
     StyleBox["val", "TI"], "]"}], Cell[TextData[{
     "construct an object of the appropriate type to represent the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression ",
     StyleBox["val",
      FontSlant->"Italic"],
     " (numbers, strings, lists, and so on)."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.6.2",
 CellID->20710],

Cell["MakeJavaObject.", "Caption",
 CellTags->"jlug:5.3.6.2",
 CellID->24484],

Cell[TextData[{
 "When you call a Java method from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that takes, say, a Java ",
 StyleBox["String", "MR"],
 " object, you can call it with a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string. The internals of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will construct a Java string that has the same characters as the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string, and pass that string to the Java method. Sometimes, however, you \
want to pass a string to a method that is typed to take ",
 StyleBox["Object", "MR"],
 ". You cannot call such a method from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a string as the argument because although ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " recognizes that a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string corresponds to a Java string, it does not recognize that a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string corresponds to a Java ",
 StyleBox["Object", "MR"],
 ". It does this deliberately, for the sake of imposing as much type safety \
as possible on calls into Java. For this example, assume that the class ",
 StyleBox["MyClass", "MR"],
 " has a method with the following signature:"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->24774],

Cell["void foo(Object obj);", "Program",
 CellTags->"jlug:5.3.6.2",
 CellID->8380],

Cell[TextData[{
 "Assume also that ",
 StyleBox["theObj", "MR"],
 " is an object of this class, created with ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ". Let\[CloseCurlyQuote]s try to call ",
 StyleBox["foo", "MR"],
 " with a literal string:"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->29815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"theObj", "@", 
  RowBox[{"foo", "[", "\"\<this is a string\>\"", "]"}]}]], "Input",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"In[1]:=",
 CellID->25951],

Cell[BoxData[
 RowBox[{"Java", "::", 
  RowBox[{"argxs", ":", 
   RowBox[{
   "The", " ", "method", " ", "foo", " ", "was", " ", "called", " ", "with", 
    " ", "an", " ", "incorrect", " ", "number", " ", "or", " ", "type", " ", 
    "of", " ", 
    RowBox[{"arguments", "."}]}]}]}]], "Message", "MSG",
 CellTags->"jlug:5.3.6.2",
 CellID->6541],

Cell[BoxData[
 StyleBox["$Failed", "MR"]], "Output",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"Out[1]=",
 CellID->18115]
}, Open  ]],

Cell[TextData[{
 "It fails for the reason given above. To call a Java method that is typed to \
take an ",
 StyleBox["Object", "MR"],
 " with a string, you must first explicitly create a Java string object with \
the appropriate value. You can do this using ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->1679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"javaStr", "=", 
  RowBox[{"JavaNew", "[", 
   RowBox[{"\"\<java.lang.String\>\"", ",", "\"\<this is a string\>\""}], 
   "]"}]}]], "Input",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"In[2]:=",
 CellID->17110],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", "[", "\<\"java.lang.String\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject121445428232193]], "Output",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"Out[2]=",
 CellID->25898]
}, Open  ]],

Cell[TextData[{
 "Now it works, because the argument is a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression:"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->23073],

Cell[BoxData[
 RowBox[{"theObj", "@", 
  RowBox[{"foo", "[", "javaStr", "]"}]}]], "Input",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"In[3]:=",
 CellID->788],

Cell[TextData[{
 "To avoid having to call ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " to create a Java string object, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides the ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " function:"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->23977],

Cell[BoxData[
 RowBox[{
  RowBox[{"javaStr", "=", 
   RowBox[{"MakeJavaObject", "[", "\"\<this is a string\>\"", "]"}]}], 
  ";"}]], "Input",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"In[4]:=",
 CellID->18132],

Cell[TextData[{
 "In the case of a string, ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " just calls ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " for you. Of course, it would not be of much use if it could only construct \
",
 StyleBox["String", "MR"],
 " objects. The same issue arises with other Java objects that are direct \
representations of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " values. This includes the \[OpenCurlyDoubleQuote]wrapper\
\[CloseCurlyDoubleQuote] classes like ",
 StyleBox["java.lang.Integer", "MR"],
 ", ",
 StyleBox["java.lang.Boolean", "MR"],
 ", and so on, and the array classes. If you want to call a Java method that \
takes a ",
 StyleBox["java.lang.Integer", "MR"],
 " as an argument, you can call it from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a raw integer. But if you want to pass an integer to a method that is \
typed to take an ",
 StyleBox["Object", "MR"],
 ", you must explicitly create an object of type ",
 StyleBox["java.lang.Integer", "MR"],
 "\[LongDash]",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will not construct one automatically from an integer argument. It is \
simpler to call ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " than ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " for this:"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->29956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeJavaObject", "[", "42", "]"}]], "Input",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"In[5]:=",
 CellID->28689],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", "[", "\<\"java.lang.Integer\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject2752513]], "Output",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"Out[5]=",
 CellID->26113]
}, Open  ]],

Cell[TextData[{
 "When given an integer argument, ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " always constructs a ",
 StyleBox["java.lang.Integer", "MR"],
 ", never a ",
 StyleBox["java.lang.Short", "MR"],
 ", ",
 StyleBox["java.lang.Long", "MR"],
 ", or other \[OpenCurlyDoubleQuote]integer\[CloseCurlyDoubleQuote] Java \
wrapper object. Similarly, if you call ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " with a real number, it creates a ",
 StyleBox["java.lang.Double", "MR"],
 ", never a ",
 StyleBox["java.lang.Float", "MR"],
 ". If you require an object of one of these other types, you will have to \
call ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " explicitly."
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->10008],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " also works for ",
 StyleBox["Boolean", "MR"],
 " values:"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->12941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeJavaObject", "[", "True", "]"}]], "Input",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"In[6]:=",
 CellID->15790],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", "[", "\<\"java.lang.Boolean\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject80674817]], "Output",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"Out[6]=",
 CellID->1723]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " were only a shortcut for calling ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ", it would not be all that useful. It becomes indispensable, however, for \
creating objects of an array class. Recall that in Java, arrays are objects \
and they belong to a class. These classes have cryptic names, but if you know \
them you can create array objects with ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ". When creating array objects, the second argument to ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " is a list giving the length in each dimension. Here we create a 2 x 3 \
array of ints:"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->21363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"intArray2D", "=", 
  RowBox[{"JavaNew", "[", 
   RowBox[{"\"\<[[I\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"In[7]:=",
 CellID->28],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]JavaObject", "[", "\<\"[[I\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject23170352742401]], "Output",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"Out[7]=",
 CellID->25184]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " lets us create array objects, but it does not let us supply initial values \
for the elements of the array. ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 ", on the other hand, takes a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list and converts it into a Java array object with the same values:"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->24778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"intArray2D", "=", 
  RowBox[{"MakeJavaObject", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"In[8]:=",
 CellID->7200],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]JavaObject", "[", "\<\"[[I\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject42085388713985]], "Output",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"Out[8]=",
 CellID->5071]
}, Open  ]],

Cell[TextData[{
 "Thus, ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " is particularly useful for creating array objects, because it lets you \
supply the initial values for the array elements, and it frees you from \
having to learn and remember the names of the Java array classes ([[I for a \
2-dimensional array of ints, [D for a one-dimensional array of doubles, and \
so on",
 ").",
 " ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " can create arrays up to three dimensions deep of integers, doubles, \
strings, booleans, and objects."
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->1885],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["JavaObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectToExpression"]], "InlineFormula"],
 " function is discussed in the section ",
 ButtonBox["JavaObjectToExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#6477"],
 ", and you can think of ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " as being the inverse of ",
 Cell[BoxData[
  ButtonBox["JavaObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectToExpression"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " takes a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression that has a corresponding Java object that can represent its \
value, and creates that object. It literally \[OpenCurlyDoubleQuote]makes it \
into a Java object.\[CloseCurlyDoubleQuote] The ",
 Cell[BoxData[
  ButtonBox["JavaObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectToExpression"]], "InlineFormula"],
 " function goes the other way\[LongDash]it takes a Java object that has a \
meaningful ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " representation and converts it into that expression. It will always be the \
case that, for any ",
 StyleBox["x", "MR"],
 " that ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " can operate on,"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->21974],

Cell[BoxData[
 RowBox[{
  RowBox[{"JavaObjectToExpression", "[", 
   RowBox[{"MakeJavaObject", "[", "x", "]"}], "]"}], "===", "x"}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.6.2",
 CellID->1071],

Cell[TextData[{
 "Remember that ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " is not a commonly used function. You do not need to explicitly construct \
Java objects from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings, arrays, and so on, just to pass them to Java methods\[LongDash]",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " does this automatically for you. But even though ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will create objects automatically from certain arguments in most \
circumstances, it will not do so when an argument is typed as a generic ",
 StyleBox["Object", "MR"],
 ". Then you must create a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " yourself, and ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " is the easiest way to do this."
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->11333],

Cell[TextData[{
 "The code for the ",
 Cell[BoxData[
  ButtonBox["SetInternetProxy",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/SetInternetProxy"]], "InlineFormula"],
 " function discussed in the section ",
 ButtonBox["SetInternetProxy",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7128"],
 " provides a concrete example of using ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 ". To specify proxy information (for users behind firewalls), we need to set \
some system properties using the ",
 StyleBox["Properties", "MR"],
 " class. This class is a subclass of ",
 StyleBox["Hashtable", "MR"],
 ", so it has a method with the signature"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->22867],

Cell["Object put(Object key, Object value);", "Program",
 CellTags->"jlug:5.3.6.2",
 CellID->26153],

Cell[TextData[{
 "You should always specify keys and values for ",
 StyleBox["Properties", "MR"],
 " in the form of strings. Thus, you might try this from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->14295],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadJavaClass", "[", "\"\<java.lang.System\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"System`getProperties", "[", "]"}], "@", 
  RowBox[{"put", "[", 
   RowBox[{"\"\<proxySet\>\"", ",", " ", "\"\<true\>\""}], "]"}]}]}], "Input",\

 CellTags->"jlug:5.3.6.2",
 CellLabel->"In[9]:=",
 CellID->32168],

Cell[BoxData[
 RowBox[{
  RowBox[{"Java", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"Method named \\!\\(\\\"put\\\"\\) defined in class \
\\!\\(\\\"java.util.Properties\\\"\\) was called with an incorrect number or \
type of arguments. The arguments, shown here in a list, were \
\\!\\({\\\"proxySet\\\", \\\"true\\\"}\\).\"\>"}]], "Message", "MSG",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"From In[9]:=",
 CellID->20825],

Cell[BoxData["$Failed"], "Output",
 CellTags->"jlug:5.3.6.2",
 CellLabel->"Out[10]=",
 CellID->9676]
}, Open  ]],

Cell[TextData[{
 "For this to work, you need to use ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " to create Java ",
 StyleBox["String", "MR"],
 " objects: "
}], "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->15629],

Cell[BoxData[
 RowBox[{
  RowBox[{"System`getProperties", "[", "]"}], "@", 
  RowBox[{"put", "[", 
   RowBox[{
    RowBox[{"MakeJavaObject", "[", "\"\<proxySet\>\"", "]"}], ",", " ", 
    RowBox[{"MakeJavaObject", "[", "\"\<true\>\"", "]"}]}], "]"}]}]], "Input",\

 CellTags->"jlug:5.3.6.2",
 CellLabel->"In[11]:=",
 CellID->28650]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeJavaExpr", "Subsection",
 CellTags->{"jlug:5.3.6.3", "TableOfContents_1.5.3.6.3"},
 CellID->2598],

Cell[TextData[{
 "To understand the ",
 Cell[BoxData[
  ButtonBox["MakeJavaExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaExpr"]], "InlineFormula"],
 " function, you need to understand the motivation for ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 StyleBox["Expr", "MR"],
 " class, which is discussed in detail in ",
 ButtonBox["Motivation for the Expr Class",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21763"],
 ". Basically, an ",
 StyleBox["Expr", "MR"],
 " is a Java object that can represent an arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. Its main use is as a convenience for Java programmers who want \
to examine and operate on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in Java. Sometimes it is useful to have a way of creating ",
 StyleBox["Expr", "MR"],
 " objects in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language instead of from Java. ",
 Cell[BoxData[
  ButtonBox["MakeJavaExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaExpr"]], "InlineFormula"],
 " is the function that fills this need."
}], "Text",
 CellTags->"jlug:5.3.6.3",
 CellID->3309],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MakeJavaExpr",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/MakeJavaExpr"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "construct an object of ",
     StyleBox["J/Link",
      FontSlant->"Italic"],
     "\[CloseCurlyQuote]s ",
     StyleBox["Expr", "MR"],
     " class that represents the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.6.3",
 CellID->4693],

Cell["MakeJavaExpr.", "Caption",
 CellTags->"jlug:5.3.6.3",
 CellID->4686],

Cell[TextData[{
 "Note that if you are calling a Java method that is typed to take an ",
 StyleBox["Expr", "MR"],
 ", then you don\[CloseCurlyQuote]t have to call ",
 Cell[BoxData[
  ButtonBox["MakeJavaExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaExpr"]], "InlineFormula"],
 " to construct an ",
 StyleBox["Expr", "MR"],
 " object. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will automatically convert any expression you supply as the argument to an \
",
 StyleBox["Expr", "MR"],
 " object, as it does with other automatic ",
 ButtonBox["conversions",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17780"],
 ". Like ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MakeJavaExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaExpr"]], "InlineFormula"],
 " is used in cases where you are calling a method that takes a generic ",
 StyleBox["Object", "MR"],
 ", not an ",
 StyleBox["Expr", "MR"],
 ", and therefore ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will not perform any automatic conversion for you. In such cases you need \
to explicitly create an ",
 StyleBox["Expr", "MR"],
 " object out of some ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. One reason you might want to do this is to store a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression in Java for retrieval later."
}], "Text",
 CellTags->"jlug:5.3.6.3",
 CellID->30080],

Cell[TextData[{
 "Here is a simple example of ",
 Cell[BoxData[
  ButtonBox["MakeJavaExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaExpr"]], "InlineFormula"],
 ". This demonstrates a few methods from the ",
 StyleBox["Expr", "MR"],
 " class, which has a number of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-like methods for examining, modifying, and extracting portions of \
expressions. Of course, this is a highly contrived example\[LongDash]if you \
wanted to know the length of an expression you would just call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 "s ",
 StyleBox["Length[]", "MR"],
 " function. The ",
 StyleBox["Expr", "MR"],
 " methods demonstrated here are typically called from Java, not ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.6.3",
 CellID->10116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", " ", "=", " ", 
  RowBox[{"MakeJavaExpr", "[", 
   RowBox[{"1", " ", "+", " ", 
    RowBox[{"2", "x"}], " ", "+", " ", 
    RowBox[{"x", "^", "2"}]}], "]"}]}]], "Input",
 CellTags->"jlug:5.3.6.3",
 CellLabel->"In[17]:=",
 CellID->12249],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", "[", "\<\"com.wolfram.jlink.Expr\"\>", "]"}],
    "\[RightGuillemet]"}],
  JLink`Objects`JavaObject196802095611905]], "Output",
 CellTags->"jlug:5.3.6.3",
 CellLabel->"Out[17]=",
 CellID->26667]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "@", 
  RowBox[{"length", "[", "]"}]}]], "Input",
 CellTags->"jlug:5.3.6.3",
 CellLabel->"In[18]:=",
 CellID->1528],

Cell[BoxData["3"], "Output",
 CellTags->"jlug:5.3.6.3",
 CellLabel->"Out[18]=",
 CellID->26679]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "@", 
  RowBox[{"part", "[", "3", "]"}]}]], "Input",
 CellTags->"jlug:5.3.6.3",
 CellLabel->"In[19]:=",
 CellID->7864],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 CellTags->"jlug:5.3.6.3",
 CellLabel->"Out[19]=",
 CellID->29421]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "@", 
  RowBox[{"insert", "[", 
   RowBox[{
    RowBox[{"x", "^", "3"}], ",", " ", 
    RowBox[{"-", "1"}]}], "]"}]}]], "Input",
 CellTags->"jlug:5.3.6.3",
 CellLabel->"In[20]:=",
 CellID->8405],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 CellTags->"jlug:5.3.6.3",
 CellLabel->"Out[20]=",
 CellID->8826]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 StyleBox["Expr", "MR"],
 " objects, like ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions, are immutable. The above call to ",
 StyleBox["insert()", "MR"],
 " did not modify ",
 StyleBox["e", "MR"],
 "; instead, it returned a new ",
 StyleBox["Expr", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.6.3",
 CellID->6816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JavaObjectToExpression", "[", "e", "]"}]], "Input",
 CellTags->"jlug:5.3.6.3",
 CellLabel->"In[21]:=",
 CellID->7516],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 CellTags->"jlug:5.3.6.3",
 CellLabel->"Out[21]=",
 CellID->27726]
}, Open  ]],

Cell[TextData[{
 "If you are having trouble understanding why you might want to use ",
 Cell[BoxData[
  ButtonBox["MakeJavaExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaExpr"]], "InlineFormula"],
 " in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program, do not worry. It is an advanced function that few programmers \
will have any use for."
}], "Text",
 CellTags->"jlug:5.3.6.3",
 CellID->28666]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating Windows and Other User Interface Elements", "Section",
 CellTags->{"jlug:5.3.7.0", "TableOfContents_1.5.3.7"},
 CellID->4596],

Cell[CellGroupData[{

Cell["Preamble", "Subsection",
 CellTags->{"jlug:5.3.7.1", "TableOfContents_1.5.3.7.1"},
 CellID->24021],

Cell[TextData[{
 "One of the most useful applications for ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is to write user interface elements for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs. Examples of such elements would be a progress bar monitoring the \
completion of a computation, a window that displays an image or animation, a \
dialog box that prompts the user for input or helps them compose a proper \
call of an unfamiliar function, or a mini-application that leads the user \
through the steps of an analysis. These types of user interfaces are distinct \
from what you might write for a Java program that uses ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the background in that they \[OpenCurlyDoubleQuote]pop up\
\[CloseCurlyDoubleQuote] when the user invokes some ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. They do not replace the notebook front end, they just augment it. In \
this way, they are like an extension of the palettes and other specialty \
notebook elements you can create in the front end."
}], "Text",
 CellTags->"jlug:5.3.7.1",
 CellID->27348],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with",
 StyleBox[" J/Link",
  FontSlant->"Italic"],
 " is an extremely powerful and productive environment for creating user \
interfaces. The complexity of user interface code is ideally suited to the \
interactive line-at-a-time nature of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " development. You can literally build, modify, and experiment with your \
user interface ",
 StyleBox["while", "TI"],
 StyleBox[" it is running",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellTags->"jlug:5.3.7.1",
 CellID->23199],

Cell[TextData[{
 "Anyone considering writing user interfaces for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs should also look at the ",
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit"],
  FontSlant->"Italic"],
 " add-on. GUIKit is built on top of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", and provides an extremely high-level means of creating interfaces. \
Further discussion of GUIKit is beyond the scope of this manual, but be aware \
that GUIKit was specifically designed to provide an easier means of creating \
user interfaces than writing in \[OpenCurlyDoubleQuote]raw\
\[CloseCurlyDoubleQuote] ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", as described here."
}], "Text",
 CellTags->"jlug:5.3.7.1",
 CellID->19668]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interactive and Non-Interactive Interfaces", "Subsection",
 CellTags->{"jlug:5.3.7.2", "TableOfContents_1.5.3.7.2"},
 CellID->314330245],

Cell[TextData[{
 "To write ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs that create Java windows you need to understand important \
distinctions between several types of such user interfaces. These \
distinctions relate to how they interact with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. "
}], "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->8281],

Cell[TextData[{
 "At the highest level of categorization, there is a distinction between \
\[OpenCurlyDoubleQuote]interactive\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]non-interactive\[CloseCurlyDoubleQuote] interfaces. \
The interactiveness under consideration here is with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, not with the user. What we are calling non-interactive user \
interfaces have no need to communicate back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", although they typically are controlled by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Such interfaces often accept no user input at all\[LongDash]they are \
created, manipulated, and destroyed by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. An example of this type is a window that shows a progress bar (a \
complete progress bar program is presented in ",
 ButtonBox["A Progress Bar",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#5535"],
 "). A progress bar does not return a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and it does not need to respond to user actions, at least not by \
interacting with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In other words, the window may go away when its close box is clicked (a \
user action), but this is not relevant to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " because it does not return a result or trigger a call back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". A progress bar is completely driven by a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program. The flow of information is in one direction only."
}], "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->4734],

Cell[TextData[{
 "Such user interfaces typically have lifetimes that are encompassed by a \
single ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program, as is the case with a progress bar. This is not required, \
however. Hosting an applet in its own window, as described in ",
 ButtonBox["Hosting Applets",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#13169"],
 ", is an example where the window lives on after the code that created it \
ends execution. The applet window is only dismissed when the user clicks in \
its close box. Again, though, the important property is that the applet does \
not need to interact with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->53],

Cell[TextData[{
 "This type of user interface, which requires no interaction back with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", poses no special issues that need to be discussed in this section. A \
program that creates, runs, and destroys such an interface is very much like \
a non-GUI Java computation that is accomplished with a series of calls into \
Java. It just happens to produce a visual effect. You can examine the \
progress bar code in ",
 ButtonBox["A Progress Bar",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#5535"],
 " if you want to see a fully fleshed out example."
}], "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->1999],

Cell[TextData[{
 "The more common \[OpenCurlyDoubleQuote]interactive\[CloseCurlyDoubleQuote] \
type of user interface needs to communicate back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This might be to return a result, like a typical modal input dialog, or \
to initiate a computation as a consequence of the user clicking a button. To \
understand the special problem this imposes, it is useful to examine some \
basic considerations about the kernel\[CloseCurlyQuote]s \
\[OpenCurlyDoubleQuote]main loop,\[CloseCurlyDoubleQuote] whereby it acquires \
input, evaluates it, and sends off any output."
}], "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->26418],

Cell[TextData[{
 "When the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is being used from the front end, it spends most of its life \
waiting for input to arrive on the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " that it uses to communicate with the front end. This ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is given by ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 ", and it is ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 " that has the kernel\[CloseCurlyQuote]s \[OpenCurlyDoubleQuote]attention.\
\[CloseCurlyDoubleQuote] When input arrives on ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 ", it is evaluated, any results are sent back on the link, and the kernel \
goes back to waiting for more input on ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 ". When ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is being used, the kernel has another ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " open, the one that connects to the Java runtime. When you execute some \
code that calls into Java, the kernel sends something to Java and then blocks \
waiting for the return value from Java. During this period when the kernel is \
waiting for a return value from Java, the Java link has the kernel\
\[CloseCurlyQuote]s attention. It is only during this period of time that the \
kernel is paying attention to the Java link. A more general way of saying \
this is that the kernel is only listening for input arriving from Java when \
it has been specifically instructed to do so. The rest of the time it is \
listening only to ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 ", which is typically the notebook front end."
}], "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->27938],

Cell[TextData[{
 "Consider what happens when the user clicks on a button in your Java window \
and that button tries to execute some code that calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The Java side sends something to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and then waits for the result, but the kernel will never get the request \
because it is not paying attention to the Java link. It is necessary to use \
some means to tell the kernel to look for input arriving on the Java link. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides three different ways to manage the kernel\[CloseCurlyQuote]s \
attention to the Java link, and thereby control its readiness to accept \
requests for evaluations initiated by the Java side."
}], "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->6900],

Cell[TextData[{
 "These three ways can be called \[OpenCurlyDoubleQuote]modal,\
\[CloseCurlyDoubleQuote] \[OpenCurlyDoubleQuote]modeless,\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]manual.\
\[CloseCurlyDoubleQuote] In modal interaction, characterized by the use of \
the ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, the kernel is pointed at the Java link until the Java side \
releases it. The kernel is a complete slave to the Java side, and is \
unavailable for any other computations. In modeless interaction, \
characterized by the use of the ",
 StyleBox["ShareKernel", "MR"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, the kernel is kept in a state where it is receptive to \
evaluation requests arriving from either the notebook front end or Java, \
evenly sharing its attention between these two programs. Lastly, there is a \
manual mode, characterized by the use of the ",
 StyleBox["ServiceJava", "MR"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, which in some ways is intermediate between modal and modeless \
operation. Here, you manually instruct the kernel to allow single requests \
from Java while in the middle of running a larger program. The next few \
sections are devoted to further exploration of these types of user \
interfaces."
}], "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->3788],

Cell[TextData[{
 "Before we go on, it is important to remember that all these issues about \
how to prepare the kernel for computations arriving from Java are only \
relevant for computations ",
 StyleBox["initiated",
  FontSlant->"Italic"],
 " in Java, typically by user actions like clicking a button. Calls from Java \
to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that are part of a back-and-forth series of calls that involve a call from \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into Java are not a problem. Any time ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has called into Java, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is actively listening for results arriving from Java. This may sound \
confusing, but that is mostly because it is only in a much later ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#9198"],
 " that we discuss writing your own Java methods to be called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "; such methods can call back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for computations before they return their result (typical examples are to \
print something in the notebook window or display a message). These are true \
",
 StyleBox["callbacks",
  FontSlant->"Italic"],
 " into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is always ready to handle them. In contrast, calls to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that occur as the result of a user action in the Java side are, in effect, \
a surprise to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and it is not normally in a state where it is ready to accept them. "
}], "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->18127]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modal versus Modeless Operation", "Subsection",
 CellTags->{"jlug:5.3.7.3", "TableOfContents_1.5.3.7.3"},
 CellID->467],

Cell[TextData[{
 "A common type of user interface element is like a modal dialog: once it is \
displayed, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program hangs waiting for the user to dismiss the window. Typically, this \
is because the window returns a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", so it is not meaningful for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to continue until the window is closed. An example of such a window is a \
simple input window that asks the user for some value, which it returns to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when the ",
 StyleBox["OK", "SR"],
 " button is clicked."
}], "Text",
 CellTags->"jlug:5.3.7.3",
 CellID->3728],

Cell[TextData[{
 "It is important to understand our slightly generalized use of the term \
\[OpenCurlyDoubleQuote]modal\[CloseCurlyDoubleQuote] to describe these \
windows. They may not be modal in the traditional sense that they must be \
dismissed before anything else can be done in the user interface. Rather, \
they are modal with respect to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel\[LongDash]the kernel cannot do anything else until they are closed. \
A Java window that you create might not be modal with respect to other Java \
windows on the screen (i.e., a dialog might not have the ",
 StyleBox["isModal", "MR"],
 " property set), but it ties up the kernel\[CloseCurlyQuote]s attention \
until it is dismissed."
}], "Text",
 CellTags->"jlug:5.3.7.3",
 CellID->14893],

Cell[TextData[{
 "Another type of user interface element is like a modeless dialog: after it \
is displayed, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that created it will finish, leaving the window visible and usable \
while the user continues working in the notebook front end. This sounds a lot \
like the first type of user interface element described above, but these \
windows are distinguished by the fact that they can initiate interactions \
with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " while they are visible. An example would be a window that lets users load \
packages into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by selecting them from a scrolling list. You write a J/Link program that \
creates this window, displays it, and returns. The window is left open and \
usable until the user clicks in its close box. In the meantime, the user is \
free to continue working in the front end, going back to use this Java window \
whenever it is convenient."
}], "Text",
 CellTags->"jlug:5.3.7.3",
 CellID->24648],

Cell[TextData[{
 "Such a window is almost like another type of notebook or palette window in \
the front end. You can have any number of front end or Java windows open at \
once, and active, meaning that they can be used to initiate computations in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". They are each their own little interface onto the same kernel. What is \
different about the Java window is that it is much more general than a \
notebook window, and, importantly, it lives in a different application layer \
than the front end. This last fact makes the Java window in effect a second \
front end, rather than an extension of the notebook front end. To accommodate \
such a second front end, the kernel must be kept in a special state that \
allows it to handle requests for evaluations arriving from either the \
notebook front end or Java. "
}], "Text",
 CellTags->"jlug:5.3.7.3",
 CellID->22483],

Cell[TextData[{
 "Before we present examples of how to implement modal and modeless windows, \
it is necessary to jump ahead a little bit and explain the main mechanism by \
which Java user interface elements can communicate with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.3",
 CellID->17807]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Handling Events with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Code: The \[OpenCurlyDoubleQuote]MathListener\[CloseCurlyDoubleQuote] \
Classes"
}], "Subsection",
 CellTags->{"jlug:5.3.7.4", "TableOfContents_1.5.3.7.4"},
 CellID->2421],

Cell["\<\
User interface elements typically have active components like buttons, \
scrollbars, menus, and text fields that need to trigger some action when they \
are clicked. In the Java event model, components fire events in response to \
user actions, and other components indicate their interest in these events by \
registering as event listeners. In practice, though, components do not \
usually act as event listeners directly. Instead, the programmer writes an \
adapter class that implements the desired event-listener interface and calls \
certain methods in the component in response to various events. This avoids \
having to subclass the responding component just to have it act as an event \
listener. The only specialty code goes into the adapter class, allowing the \
components that fire and respond to events to be generic.\
\>", "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->14310],

Cell[TextData[{
 "As an example, say you are writing a standard Java program and you have a \
button that you want to use to control the appearance of a text area. \
Clicking the button should toggle between black text on a white background \
and white text on a black background. Buttons fire ",
 StyleBox["ActionEvents", "MR"],
 " when they are clicked, and a class that wants to receive notifications of \
clicks must implement the ",
 StyleBox["ActionListener", "MR"],
 " interface, and register with the button by calling its ",
 StyleBox["addActionListener()", "MR"],
 " method. You would write a class, perhaps called ",
 StyleBox["MyActionAdapter", "MR"],
 ", that implements ",
 StyleBox["ActionListener", "MR"],
 ". In its ",
 StyleBox["actionPerformed()", "MR"],
 " method, which is what will be called when the button is clicked, you would \
call the appropriate methods to set the foreground and background colors of \
the text area."
}], "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->6617],

Cell["\<\
If you have ever used a Java GUI builder that lets you create an application \
by dropping components on a form and then wiring them together via events, \
the code that is being generated for you consists in large part of adapter \
classes that manage the logic of calling certain methods in the target \
objects when events are fired by the source objects.\
\>", "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->22813],

Cell[TextData[{
 "What all this is leading up to is simply that the wiring of components in a \
GUI typically involves writing a lot of Java code in the form of classes that \
implement various event-listener interfaces. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programmers want to write GUIs that use the standard Java event model, and \
they shouldn",
 "\[CloseCurlyQuote]",
 "t have to write Java code to do it. The solution is simple: ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides a complete set of classes that implement the standard \
event-listener interfaces and whose actions are to call back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to execute user-defined code. This brings all the event-handling logic \
down into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", where it can be scripted like every other part of the program."
}], "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->9514],

Cell[TextData[{
 "Not only does this solution preserve the \[OpenCurlyDoubleQuote]pure ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote] property of even complex Java GUIs, it is vastly \
more flexible than writing a traditional application in Java. When you write \
in Java, or use a fancy drag-and-drop GUI builder, you hard-code the event \
logic. You have to decide at compile time what every click, scroll, and \
keystroke will do. But when you use ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", you decide how your program is wired together at run time. You can even \
change the behavior on the fly simply by typing a few lines of code."
}], "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->14309],

Cell[TextData[{
 "J/Link provides implementations of all the standard AWT event-listener \
classes. These classes are named after the interfaces they implement, with \
\[OpenCurlyDoubleQuote]Math\[CloseCurlyDoubleQuote] prepended. Thus, the \
class that implements ",
 StyleBox["ActionListener", "MR"],
 " is ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 ". (Perhaps these classes would be better named ",
 StyleBox["MathXXXAdapter", "MR"],
 ".) The table below shows a summary of all the ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes, the methods they implement, and the arguments they send to your \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handler function."
}], "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->7616],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell["Class", "TableHeader"], Cell["Methods", "TableHeader"], Cell[
     "Arguments to Mathematica Handler", "TableHeader"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathActionListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{"actionPerformed", 
       RowBox[{"(", 
        RowBox[{"ActionEvent", " ", "e"}], ")"}]}], "MR"], 
     StyleBox[
      RowBox[{"e", ",", "\n", 
       RowBox[{
        RowBox[{"e", ".", "getActionCommand"}], 
        RowBox[{"(", ")"}], " ", 
        RowBox[{"(", "String", ")"}]}]}], "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathAdjustmentListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{"adjustmentValueChanged", 
       RowBox[{"(", "\n", 
        RowBox[{Cell["\t"], "AdjustmentEvent", " ", "e"}], ")"}]}], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"e", ",", "\n", 
        RowBox[{
         RowBox[{"e", ".", "getAdjustmentType"}], 
         RowBox[{"(", ")"}]}], ",", 
        RowBox[{"(", "Integer", ")"}]}], "\n", 
       RowBox[{
        RowBox[{"e", ".", "getValue"}], 
        RowBox[{"(", ")"}], " ", 
        RowBox[{"(", "Integer", ")"}]}]}], "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathComponentListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"componentHidden", 
        RowBox[{"(", 
         RowBox[{"ComponentEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"componentShown", 
        RowBox[{"(", 
         RowBox[{"ComponentEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"componentResized", 
        RowBox[{"(", 
         RowBox[{"ComponentEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"componentMoved", 
        RowBox[{"(", 
         RowBox[{"ComponentEvent", " ", "e"}], ")"}]}]}], "MR"], 
     StyleBox["e", "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathContainerListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"componentAdded", 
        RowBox[{"(", 
         RowBox[{"ContainerEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"componentRemoved", 
        RowBox[{"(", 
         RowBox[{"ContainerEvent", " ", "e"}], ")"}]}]}], "MR"], 
     StyleBox["e", "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathFocusListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"focusGained", 
        RowBox[{"(", 
         RowBox[{"FocusEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"focusLost", 
        RowBox[{"(", 
         RowBox[{"FocusEvent", " ", "e"}], ")"}]}]}], "MR"], 
     StyleBox["e", "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathItemListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{"itemStateChanged", 
       RowBox[{"(", 
        RowBox[{"ItemEvent", " ", "e"}], ")"}]}], "MR"], 
     StyleBox[
      RowBox[{"e", ",", "\n", 
       RowBox[{
        RowBox[{"e", ".", "getStateChange"}], 
        RowBox[{"(", ")"}], " ", 
        RowBox[{"(", "Integer", ")"}]}]}], "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathKeyListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"keyPressed", 
        RowBox[{"(", 
         RowBox[{"KeyEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"keyReleased", 
        RowBox[{"(", 
         RowBox[{"KeyEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"keyTyped", 
        RowBox[{"(", 
         RowBox[{"KeyEvent", " ", "e"}], ")"}]}]}], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"e", ",", "\n", 
        RowBox[{
         RowBox[{"e", ".", "getKeyChar"}], 
         RowBox[{"(", ")"}]}], ",", 
        RowBox[{"(", "Integer", ")"}]}], "\n", 
       RowBox[{
        RowBox[{"e", ".", "getKeyCode"}], 
        RowBox[{"(", ")"}], " ", 
        RowBox[{"(", "Integer", ")"}]}]}], "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathMouseListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"mouseClicked", 
        RowBox[{"(", 
         RowBox[{"MouseEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"mouseEntered", 
        RowBox[{"(", 
         RowBox[{"MouseEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"mouseExited", 
        RowBox[{"(", 
         RowBox[{"MouseEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"mousePressed", 
        RowBox[{"(", 
         RowBox[{"MouseEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"mouseReleased", 
        RowBox[{"(", 
         RowBox[{"MouseEvent", " ", "e"}], ")"}]}]}], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"e", ",", "\n", 
        RowBox[{
         RowBox[{"e", ".", "getX"}], 
         RowBox[{"(", ")"}]}], ",", " ", 
        RowBox[{"(", "Integer", ")"}]}], "\n", 
       RowBox[{
        RowBox[{
         RowBox[{"e", ".", "getY"}], 
         RowBox[{"(", ")"}]}], ",", " ", 
        RowBox[{"(", "Integer", ")"}]}], "\n", 
       RowBox[{
        RowBox[{"e", ".", "getClickCount"}], 
        RowBox[{"(", ")"}], " ", 
        RowBox[{"(", "Integer", ")"}]}]}], "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathMouseMotionListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"mouseMoved", 
        RowBox[{"(", 
         RowBox[{"MouseEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"mouseDragged", 
        RowBox[{"(", 
         RowBox[{"MouseEvent", " ", "e"}], ")"}]}]}], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"e", ",", "\n", 
        RowBox[{
         RowBox[{"e", ".", "getX"}], 
         RowBox[{"(", ")"}]}], ",", " ", 
        RowBox[{"(", "Integer", ")"}]}], "\n", 
       RowBox[{
        RowBox[{
         RowBox[{"e", ".", "getY"}], 
         RowBox[{"(", ")"}]}], ",", " ", 
        RowBox[{"(", "Integer", ")"}]}], "\n", 
       RowBox[{
        RowBox[{"e", ".", "getClickCount"}], 
        RowBox[{"(", ")"}], " ", 
        RowBox[{"(", "Integer", ")"}]}]}], "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathPropertyChangeListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{"propertyChanged", 
       RowBox[{"(", "\n", "\t", 
        RowBox[{"PropertyChangeEvent", " ", "e"}], ")"}]}], "MR"], 
     StyleBox["e", "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathTextListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{"textValueChanged", 
       RowBox[{"(", 
        RowBox[{"TextEvent", " ", "e"}], ")"}]}], "MR"], 
     StyleBox["e", "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathVetoableChangeListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{"vetoableChange", 
       RowBox[{"(", "\n", "\t", 
        RowBox[{"PropertyChangeEvent", " ", "e"}], ")"}]}], "MR"], 
     StyleBox[
      RowBox[{"e", "\n", "  ", 
       RowBox[{"(", 
        RowBox[{
        "veto", " ", "the", " ", "change", " ", "by", "\n", "   ", 
         "returning", " ", "False", " ", "from", "\n", "   ", "your", " ", 
         "handler"}], ")"}]}], "MR"]},
    {
     StyleBox[
      ButtonBox[
       StyleBox["MathWindowListener", "MR"],
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/java/"], "MR"], 
     StyleBox[
      RowBox[{
       RowBox[{"windowOpened", 
        RowBox[{"(", 
         RowBox[{"WindowEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"windowClosed", 
        RowBox[{"(", 
         RowBox[{"WindowEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"windowClosing", 
        RowBox[{"(", 
         RowBox[{"WindowEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"windowActivated", 
        RowBox[{"(", 
         RowBox[{"WindowEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"windowDeactivated", 
        RowBox[{"(", 
         RowBox[{"WindowEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"windowIconified", 
        RowBox[{"(", 
         RowBox[{"WindowEvent", " ", "e"}], ")"}]}], "\n", 
       RowBox[{"windowDeiconified", 
        RowBox[{"(", 
         RowBox[{"WindowEvent", " ", "e"}], ")"}]}]}], "MR"], 
     StyleBox["e", "MR"]}
   }], TextForm]], "DefinitionBox",
 CellFrameMargins->3,
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{"Columns" -> {False, {
      AbsoluteThickness[0.5]}, False}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {
      AbsoluteThickness[0.5]}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.335]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->"jlug:5.3.7.4",
 CellID->18935],

Cell[TextData[{
 "Listener classes provided with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "."
}], "Caption",
 CellTags->"jlug:5.3.7.4",
 CellID->17451],

Cell[TextData[{
 "As an example of how to read this table, take the ",
 Cell[BoxData[
  ButtonBox["MathKeyListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathKeyListener"]], "InlineFormula"],
 " class.  ",
 Cell[BoxData[
  ButtonBox["MathKeyListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathKeyListener"]], "InlineFormula"],
 " implements the ",
 StyleBox["KeyListener", "MR"],
 " interface, which contains the methods ",
 StyleBox["keyPressed()", "MR"],
 ", ",
 StyleBox["keyReleased()", "MR"],
 ", and ",
 StyleBox["keyTyped()", "MR"],
 ". If you register a ",
 Cell[BoxData[
  ButtonBox["MathKeyListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathKeyListener"]], "InlineFormula"],
 " object with a component that fires ",
 StyleBox["KeyEvents", "MR"],
 ", then these three methods will be called in response to the key events \
they are named after. When any of these methods are called, they will call \
into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and execute a user-defined function, passing it three arguments: the ",
 StyleBox["KeyEvent", "MR"],
 " object itself, followed by two integers that are the results of the event \
object\[CloseCurlyQuote]s ",
 StyleBox["getKeyChar()", "MR"],
 " and ",
 StyleBox["getKeyCode()", "MR"],
 " methods. All the ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes pass your handler function the event object itself, and a few, \
like this one, pass additional integer arguments that are commonly needed \
values. This just saves you the overhead of having to call back into Java to \
get these additional values."
}], "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->20600],

Cell[TextData[{
 "To specify the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function associated with any of the methods of a ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " object, call the object\[CloseCurlyQuote]s ",
 StyleBox["setHandler()", "MR"],
 " method. ",
 StyleBox["setHandler()", "MR"],
 " takes two strings, the first of which is the name of the event-handler \
method (e.g., \[OpenCurlyDoubleQuote]",
 StyleBox["actionPerformed", "MR"],
 "\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]",
 StyleBox["keyPressed", "MR"],
 "\[CloseCurlyDoubleQuote]), and the second of which is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that should be called in response. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function can be a name, as in \[OpenCurlyDoubleQuote]",
 StyleBox["myButtonFunction", "MR"],
 "\[CloseCurlyDoubleQuote] or a pure function (specified as a string). The \
reason for supplying the name of the actual Java method in the listener \
interface is that many of the listeners have multiple methods. ",
 StyleBox["setHandler()", "MR"],
 " returns ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " if the handler was set correctly and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "MR"]], "InlineFormula"],
 " otherwise (for example, if the method you named is not spelled \
correctly)."
}], "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->5249],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["obj", "TI"], 
     StyleBox["@", "MR"], 
     RowBox[{
      StyleBox["setHandler", "MR"], "[", 
      RowBox[{
       StyleBox["\"\<methodName\>\"", "TI"], ",", " ", 
       StyleBox["\"\<funcName\>\"", "TI"]}], "]"}]}], Cell[TextData[{
     "set the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " function that will be called when the MathListener object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     "\[CloseCurlyQuote]s event-handler method ",
     StyleBox["methodName()", "MR"],
     " is called."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.7.4",
 CellID->16519],

Cell[TextData[{
 "Assigning the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that will be called in response to an event notification."
}], "Caption",
 CellTags->"jlug:5.3.7.4",
 CellID->31556],

Cell[TextData[{
 "The use of these classes will become clear in the simple examples below for \
modal and modeless windows, and in the more fully worked-out examples in the \
sections ",
 ButtonBox["A Simple Modal Input Dialog",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7391"],
 " and ",
 ButtonBox["A Piano Keyboard",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#3737"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->22798],

Cell[TextData[{
 "You are not required to use the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes for creating calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " triggered by user actions. They are provided simply as a convenience. You \
could write your own classes to handle events and put calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directly into their code. All the \[OpenCurlyDoubleQuote]MathListener\
\[CloseCurlyDoubleQuote] classes in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " are derived from an abstract base class called, appropriately, ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 ". The code in ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " takes care of all of the details of interacting with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and it also provides the ",
 StyleBox["setHandler()", "MR"],
 " methods that you use to associate events with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. Users who want to write their own ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 "-style classes (for example, for one of the Swing-specific event-listener \
interfaces, which ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " does not provide) are strongly encouraged to make their classes subclasses \
of ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " to inherit all this functionality. You should examine the source code for \
one of the concrete classes derived from ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " (",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 " is probably the simplest one) to see how it is written. You can use this \
as a starting point for your own implementation. If you do not make your \
class a subclass of ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 ", and instead choose instead to write your own event-handler code that \
calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you ",
 StyleBox["must",
  FontSlant->"Italic"],
 " read ",
 ButtonBox["Writing Your Own Event Handler Code",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#27065"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->30303]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bringing Java Windows to the Foreground", "Subsection",
 CellTags->{"jlug:5.3.7.5", "TableOfContents_1.5.3.7.5"},
 CellID->6224],

Cell[TextData[{
 "If you are creating a Java window with a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program, you probably want that window to pop up in front of the notebook \
the user is working in, so that its presence becomes apparent. You might \
expect that the ",
 StyleBox["toFront()", "MR"],
 " method of Java\[CloseCurlyQuote]s ",
 StyleBox["Window", "MR"],
 " class is what you would use for this, but this does not work on the \
Macintosh, and it works slightly differently on different Java runtimes on \
Windows. As a result of these differences, it is difficult to write a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that behaves identically on all platforms and all Java virtual \
machines with respect to making Java windows visible in front of all other \
windows the user might see."
}], "Text",
 CellTags->"jlug:5.3.7.5",
 CellID->11008],

Cell[TextData[{
 "As a result of these unfortunate differences, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, ",
 Cell[BoxData[
  ButtonBox["JavaShow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaShow"]], "InlineFormula"],
 ", which performs the proper steps on all configurations. You should use ",
 StyleBox["JavaShow[window]", "MR"],
 " in place of ",
 StyleBox["window@setVisible[", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 StyleBox["]", "MR"],
 ", ",
 StyleBox["window@show[]", "MR"],
 ", or ",
 StyleBox["window@toFront[]", "MR"],
 ". You will see ",
 Cell[BoxData[
  ButtonBox["JavaShow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaShow"]], "InlineFormula"],
 " used in all the example programs. The argument to ",
 Cell[BoxData[
  ButtonBox["JavaShow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaShow"]], "InlineFormula"],
 " must be a Java object that is an instance of a class that can represent a \
top-level window. Specifically, it must be of class ",
 StyleBox["java.awt.Window", "MR"],
 " or a subclass. This includes the AWT ",
 StyleBox["Frame", "MR"],
 " and ",
 StyleBox["Dialog", "MR"],
 " windows, and also the Swing classes used for top-level windows (",
 StyleBox["JFrame", "MR"],
 ", ",
 StyleBox["JWindow", "MR"],
 ", and ",
 StyleBox["JDialog", "MR"],
 ")."
}], "Text",
 CellTags->"jlug:5.3.7.5",
 CellID->5844],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["JavaShow",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/JavaShow"], 
     StyleBox["[", "MR"], 
     StyleBox["windowObj", "TI"], 
     StyleBox["]", "MR"]}], Cell["\<\
make the specified Java window visible and bring it in front of all other \
windows, including notebook windows.\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.7.5",
 CellID->32609],

Cell["Bringing a Java window to the foreground.", "Caption",
 CellTags->"jlug:5.3.7.5",
 CellID->14989]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modal Windows", "Subsection",
 CellTags->{"jlug:5.3.7.6", "TableOfContents_1.5.3.7.6"},
 CellID->32702],

Cell[TextData[{
 "Here is an example of a simple \[OpenCurlyDoubleQuote]modal\
\[CloseCurlyDoubleQuote] window. The window contains a button and a text \
field. The text field starts out displaying the value 1, and each time the \
button is clicked the value is incremented. We use the ",
 StyleBox["com.wolfram.jlink.", "MR"],
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " class for the enclosing window. ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " is a simple extension to ",
 StyleBox["java.awt.Frame", "MR"],
 " that calls ",
 StyleBox["dispose()", "MR"],
 " on itself when its close box is clicked (the standard ",
 StyleBox["Frame", "MR"],
 " class does nothing)."
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->3195],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"frm", "=", 
    RowBox[{"JavaNew", "[", "\"\<com.wolfram.jlink.MathFrame\>\"", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"button", "=", 
   RowBox[{"JavaNew", "[", "\"\<java.awt.Button\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"textField", "=", 
    RowBox[{"JavaNew", "[", "\"\<java.awt.TextField\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"frm", "@", 
   RowBox[{"setLayout", "[", 
    RowBox[{"JavaNew", "[", "\"\<java.awt.GridLayout\>\"", "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"frm", "@", 
   RowBox[{"add", "[", "button", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"frm", "@", 
   RowBox[{"add", "[", "textField", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"frm", "@", 
   RowBox[{"pack", "[", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"JavaShow", "[", "frm", "]"}], ";"}]}], "Input",
 CellTags->"jlug:5.3.7.6",
 CellLabel->"In[1]:=",
 CellID->20485],

Cell["\<\
At this point, you should see a small frame window with a button on the left \
and a text field on the right. Now label the button and set the starting text \
for the field:\
\>", "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->3093],

Cell[BoxData[{
 RowBox[{
  RowBox[{"button", "@", 
   RowBox[{"setLabel", "[", "\"\<++\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"textField", "@", 
   RowBox[{"setText", "[", "\"\<1\>\"", "]"}]}], ";"}]}], "Input",
 CellTags->"jlug:5.3.7.6",
 CellLabel->"In[9]:=",
 CellID->14343],

Cell[TextData[{
 "Now we want to add behavior to the button that causes it to increment the \
text field value. Buttons fire ",
 StyleBox["ActionEvents", "MR"],
 ", so we need an instance of ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->30523],

Cell[BoxData[
 RowBox[{
  RowBox[{"buttonListener", "=", 
   RowBox[{
   "JavaNew", "[", "\"\<com.wolfram.jlink.MathActionListener\>\"", "]"}]}], 
  ";"}]], "Input",
 CellTags->"jlug:5.3.7.6",
 CellLabel->"In[11]:=",
 CellID->1587],

Cell[TextData[{
 "It must be registered with the button by calling ",
 StyleBox["addActionListener", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->29314],

Cell[BoxData[
 RowBox[{
  RowBox[{"button", "@", 
   RowBox[{"addActionListener", "[", "buttonListener", "]"}]}], 
  ";"}]], "Input",
 CellTags->"jlug:5.3.7.6",
 CellLabel->"In[12]:=",
 CellID->9503],

Cell[TextData[{
 "At this point, if we were to click the ",
 StyleBox["++", "SR"],
 " button, the ",
 StyleBox["actionPerformed()", "MR"],
 " method of our ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 " would be called (don\[CloseCurlyQuote]t click the button yet!). We see \
from the ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " table in the previous subsection that the ",
 StyleBox["actionPerformed()", "MR"],
 " method will call a user-defined ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function with two arguments: the ",
 StyleBox["ActionEvent", "MR"],
 " object itself and the integer value that results from the event\
\[CloseCurlyQuote]s ",
 StyleBox["getActionCommand()", "MR"],
 " method."
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->7448],

Cell[TextData[{
 "We have not yet set the user-defined code to be called by the ",
 StyleBox["actionPerformed()", "MR"],
 " method. That is done for all the ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes with the ",
 StyleBox["setHandler()", "MR"],
 " method. This method takes two strings, the first being the name of the \
method in the event-listener interface, and the second being the function you \
want called. "
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->25200],

Cell[BoxData[
 RowBox[{
  RowBox[{"buttonListener", "@", 
   RowBox[{"setHandler", "[", 
    RowBox[{"\"\<actionPerformed\>\"", ",", "\"\<buttonFunc\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"jlug:5.3.7.6",
 CellLabel->"In[13]:=",
 CellID->13458],

Cell[TextData[{
 "Now we need to define ",
 StyleBox["buttonFunc", "MR"],
 ". It must be written to take two arguments, but in this example we are not \
interested in either argument."
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->6618],

Cell[BoxData[
 RowBox[{
  RowBox[{"buttonFunc", "[", 
   RowBox[{"_", ",", "_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"curText", ",", "newVal"}], "}"}], ",", "\[IndentingNewLine]", 
    "\t", 
    RowBox[{
     RowBox[{"curText", "=", 
      RowBox[{"textField", "@", 
       RowBox[{"getText", "[", "]"}]}]}], ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"newVal", "=", 
      RowBox[{
       RowBox[{"ToExpression", "[", "curText", "]"}], "+", "1"}]}], ";", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"textField", "@", 
      RowBox[{"setText", "[", 
       RowBox[{"ToString", "[", "newVal", "]"}], "]"}]}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"jlug:5.3.7.6",
 CellLabel->"In[14]:=",
 CellID->20580],

Cell[TextData[{
 "We are still not quite ready to try the button. If we click the button now, \
the Java user interface thread will hang because it will call into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " trying to evaluate ",
 StyleBox["buttonFunc", "MR"],
 " and wait for the result, but the result will never come because the kernel \
is not waiting for input to arrive on the Java link. What we need is a way to \
put the kernel into a state where it is continuously reading from the Java \
link. This is what makes our window \[OpenCurlyDoubleQuote]modal\
\[CloseCurlyDoubleQuote]\[LongDash]the kernel cannot do anything else until \
the window is closed. The function that implements this modal state is ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->19796],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DoModal",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/DoModal"], "[", "]"}], Cell["\<\
put the kernel into a state where its attention is solely directed at the \
Java link\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["EndModal",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}], Cell[TextData[{
     "what the Java program must call to make the ",
     ButtonBox["DoModal",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/DoModal"],
     " function return, ending the modal state"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.7.6",
 CellID->14798],

Cell["Entering and exiting the modal state.", "Caption",
 CellTags->"jlug:5.3.7.6",
 CellID->15281],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " will not return until the Java program calls back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to evaluate ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 ". While ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " is executing, the kernel is ready to handle callbacks from \
Java\[LongDash]for example, from ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " objects. The way to get the Java side to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 " is typically to use a ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 ". For example, if your window had ",
 StyleBox["OK", "SR"],
 " and ",
 StyleBox["Cancel", "SR"],
 " buttons, these should dismiss the window, so you would create ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 " objects and register them with these two buttons. These ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 " objects would be set to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 " in their ",
 StyleBox["actionPerformed()", "MR"],
 " methods."
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->19589],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " returns whatever the block of code that calls ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 " returns. You would typically use this return value to determine how the \
window was closed\[LongDash]for example, whether it was the ",
 StyleBox["OK", "SR"],
 " or ",
 StyleBox["Cancel", "SR"],
 " button. You could then take appropriate action. See ",
 ButtonBox["A Simple Modal Input Dialog",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7391"],
 " for an example of using the return value of ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->20798],

Cell[TextData[{
 "In our present example, the only way to close the window is by clicking its \
close box. Clicking the close box fires a ",
 StyleBox["windowClosing", "MR"],
 " event, so we use a ",
 Cell[BoxData[
  ButtonBox["MathWindowListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathWindowListener"]], 
  "InlineFormula"],
 " to receive notifications:"
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->28009],

Cell[BoxData[{
 RowBox[{
  RowBox[{"windowListener", "=", 
   RowBox[{
   "JavaNew", "[", "\"\<com.wolfram.jlink.MathWindowListener\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"frm", "@", 
   RowBox[{"addWindowListener", "[", "windowListener", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"jlug:5.3.7.6",
 CellLabel->"In[15]:=",
 CellID->27157],

Cell[TextData[{
 "Now we assign the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function to be called when the close box is clicked. All we need it to do \
is call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 ", so we can specify a pure function that ignores its arguments and does \
nothing but execute ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->20472],

Cell[BoxData[
 RowBox[{
  RowBox[{"windowListener", "@", 
   RowBox[{"setHandler", "[", 
    RowBox[{"\"\<windowClosing\>\"", ",", "\"\<EndModal[]&\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"jlug:5.3.7.6",
 CellLabel->"In[17]:=",
 CellID->23622],

Cell[TextData[{
 "The preceding few lines are a fine example of how to use a ",
 Cell[BoxData[
  ButtonBox["MathWindowListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathWindowListener"]], 
  "InlineFormula"],
 " to trigger a call to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 " when a window\[CloseCurlyQuote]s close box is clicked. You would use \
something similar to this, except with a ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 ", if you wanted to have an explicit ",
 StyleBox["Close", "SR"],
 " button. In this example, though, there is an easier way. We said earlier \
that the ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " class is just a normal AWT ",
 StyleBox["Frame", "MR"],
 " except that it calls ",
 StyleBox["dispose()", "MR"],
 " on itself when its close box is clicked. Actually it has another useful \
property\[LongDash]it can also execute ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 " when its close box is clicked. Thus, if you use ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " as the top-level window class for your interfaces, you won\
\[CloseCurlyQuote]t have to manually create a ",
 Cell[BoxData[
  ButtonBox["MathWindowListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathWindowListener"]], 
  "InlineFormula"],
 " to terminate the modal loop every time. To enable this behavior of ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 ", you need to call its ",
 StyleBox["setModal", "MR"],
 " method:"
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->18538],

Cell["\<\
(***
 This is even easier than using the MathWindowListener above.
 We won't call it here, though, because we have already arranged
 for EndModal to be called, and bad things will happen if we try
 to call it twice.

frm@setModal[]

***)\
\>", "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.7.6",
 CellID->12292],

Cell[TextData[{
 "You must not call ",
 StyleBox["setModal", "MR"],
 " if you are not using ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ". This is because after ",
 StyleBox["setModal", "MR"],
 " has been called, the ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " will try to call into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when it is closed (to execute ",
 Cell[BoxData[
  ButtonBox["EndModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/EndModal"]], "InlineFormula"],
 "), and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " needs to be in a state where it is ready for calls originating in Java. \
The same issue exists for any ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " you create yourself."
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->6038],

Cell["\<\
Now that everything is ready, we can enter the modal state and use the \
window:\
\>", "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->24179],

Cell[BoxData[
 RowBox[{"DoModal", "[", "]"}]], "Input",
 CellTags->"jlug:5.3.7.6",
 CellLabel->"In[18]:=",
 CellID->18190],

Cell[TextData[{
 "When you are done playing with the window, click the close box in the \
frame, which will trigger a callback into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that calls ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " then returns, and the kernel is ready to be used from the front end. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DoModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/DoModal"], "[", "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Null",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Null"], "MR"]], "InlineFormula"],
 " if you click the close box of a ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->29657],

Cell[TextData[{
 "Here is how the entire example looks when packaged into a single program. \
(The code for ",
 StyleBox["SimpleModal", "MR"],
 " is also available as ",
 StyleBox["SimpleModal.nb", "MR"],
 " in the ",
 StyleBox["JLink/Examples/Part1", "MR"],
 " directory.)"
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->7958],

Cell["\<\
SimpleModal[] :=
\tJavaBlock[
\t\tModule[{frm, button, textField, windowListener,
\t\t\t\tbuttonListener, buttonFunc},

\t\t(* Create the GUI components. *)
\t\tfrm = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\tbutton = JavaNew[\"java.awt.Button\"];
\t\ttextField = JavaNew[\"java.awt.TextField\"];

\t\t(* Configure their properties. *)
\t\tfrm@setLayout[JavaNew[\"java.awt.GridLayout\"]];
\t\tfrm@add[button];
\t\tfrm@add[textField];
\t\tbutton@setLabel[\"++\"];
\t\ttextField@setText[\"1\"];
\t\tfrm@pack[];

\t\t(* Create the listener and set its handler function. *)
\t\tbuttonListener =
\t\t\tJavaNew[\"com.wolfram.jlink.MathActionListener\"];
\t\tbuttonListener@setHandler[\"actionPerformed\", ToString[buttonFunc]];
\t\tbutton@addActionListener[buttonListener];

\t\t(* Define buttonFunc. *)
\t\tbuttonFunc[_, _] :=
\t\t\tJavaBlock[
\t\t\t\tModule[{curText, newVal},
\t\t\t\t\tcurText = textField@getText[];
\t\t\t\t\tnewVal = ToExpression[curText] + 1;
\t\t\t\t\ttextField@setText[ToString[newVal]]
\t\t\t\t]
\t\t\t];

\t\t(* Make the window visible and bring it in front of any
\t\t   notebook windows. *)
\t\tJavaShow[frm];

\t\t(* Tell the frame to end the modal loop when it is closed. *)
\t\tfrm@setModal[];

\t\t(* Enter the modal loop. *)
\t\tDoModal[];
\t]
]\
\>", "Input",
 CellTags->"jlug:5.3.7.6",
 CellLabel->"In[19]:=",
 CellID->6191],

Cell[TextData[{
 "Remember that ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " will not return until the Java side calls ",
 Cell[BoxData[
  ButtonBox["EndModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/EndModal"]], "InlineFormula"],
 ". You have to be a little careful when you call ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " that you have already established a way for the Java side to trigger a \
call to ",
 Cell[BoxData[
  ButtonBox["EndModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/EndModal"]], "InlineFormula"],
 ". As explained above, you will typically have done this by using a ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " as the frame window and calling its ",
 StyleBox["setModal", "MR"],
 " method, or by creating and registering a ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " of your own that will call ",
 Cell[BoxData[
  ButtonBox["EndModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/EndModal"]], "InlineFormula"],
 " in response to a user action (such as clicking an ",
 StyleBox["OK", "SR"],
 " or ",
 StyleBox["Cancel", "SR"],
 " button). Once ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " has begun, the kernel is not responsive to the front end and thus it is \
too late to set anything up. If you call ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " and realize that for some reason you cannot end it from Java, you can \
abort it from the front end by selecting ",
 StyleBox["Evaluation ", "MenuName"],
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 StyleBox[" ", "MenuName"],
 StyleBox[ButtonBox["Interrupt Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/InterruptEvaluation"], "MenuName"],
 " in the menu, and then in the resulting dialog, clicking the button labeled \
",
 StyleBox["Abort", "SR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->19815],

Cell[TextData[{
 "There is one subtlety you might notice in the code for ",
 StyleBox["SimpleModal", "MR"],
 " that is not directly related to ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". In the line that calls ",
 StyleBox["buttonListener@setHandler", "MR"],
 ", we pass the name of the button function not as the literal string ",
 StyleBox["\"buttonFunc\"", "MR"],
 ", but as ",
 StyleBox["ToString[buttonFunc]", "MR"],
 ". This is because ",
 StyleBox["buttonFunc", "MR"],
 " is a local name in a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "MR"]], "InlineFormula"],
 ", and thus its real name is not ",
 StyleBox["buttonFunc", "MR"],
 ", but something like ",
 StyleBox["buttonFunc$42", "MR"],
 ". To make sure we capture its true run-time name, we call ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"], "MR"]], "InlineFormula"],
 " on the symbolic name. We could avoid this by simply not making the name ",
 StyleBox["buttonFunc", "MR"],
 " local to the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "MR"]], "InlineFormula"],
 ", but the way we have done it automatically cleans up the definition for ",
 StyleBox["buttonFunc", "MR"],
 " when the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "MR"]], "InlineFormula"],
 " finishes. "
}], "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->22888]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathFrame and MathJFrame", "Subsection",
 CellTags->{"jlug:5.3.7.7", "TableOfContents_1.5.3.7.7"},
 CellID->19156],

Cell[TextData[{
 "We encountered the ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " class in this section, which is a useful top-level window class for ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programmers because it has three special properties. We have already \
encountered two of them: it calls ",
 StyleBox["dispose()", "MR"],
 " on itself when it is closed, and it has the ",
 StyleBox["setModal()", "MR"],
 " method, which gives it easy support for use with ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ". The third property is that it has an ",
 StyleBox["onClose()", "MR"],
 " method that you can use to specify ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code that will be executed when the window is closed. The ",
 StyleBox["onClose()", "MR"],
 " method is used in the Palette example in ",
 ButtonBox["Sharing the Front End: Palette-Type Buttons",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#8177"],
 ".  ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " also has a ",
 Cell[BoxData[
  ButtonBox["MathJFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathJFrame"]], "InlineFormula"],
 " class, which is a subclass of the Swing ",
 StyleBox["JFrame", "MR"],
 " class, and it also has these three special properties. Programmers who \
want to create interfaces with Swing components instead of AWT ones can use \
",
 Cell[BoxData[
  ButtonBox["MathJFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathJFrame"]], "InlineFormula"],
 " as their top-level window class."
}], "Text",
 CellTags->"jlug:5.3.7.7",
 CellID->11511]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modeless Windows: Sharing the Kernel with Java", "Subsection",
 CellTags->{"jlug:5.3.7.8", "TableOfContents_1.5.3.7.8"},
 CellID->16202],

Cell[TextData[{
 "The previous subsection demonstrated how to write ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programs that display Java windows and then how to use the ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " function to cause the kernel to wait until the window is closed. During \
the time that ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " is running, the kernel is able to receive and process requests for \
computations that originate from the Java side. The word \
\[OpenCurlyDoubleQuote]modal\[CloseCurlyDoubleQuote] is used in this context \
to refer to the fact that the kernel is busy servicing the Java link, and \
thus the notebook front end cannot use the kernel until ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " returns."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->2634],

Cell[TextData[{
 "This arrangement works fine for many types of Java windows, and it is \
required for those that return a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", because the kernel cannot sensibly proceed until the window is dismissed. \
Unfortunately, it is too restrictive for a large class of user interface \
elements. Consider trying to duplicate the general concept of a front end \
palette window in Java. We want to have a window of buttons that, when \
clicked, cause some computation to occur in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Like a front end palette window, we want this window to be created and \
remain visible and active indefinitely. It wouldn\[CloseCurlyQuote]t be of \
much use if every time we wanted to click one of the buttons we had first to \
execute ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DoModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/DoModal"], "[", "]"}]], "InlineFormula"],
 " (and we would also have to arrange for each button to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 " as part of the computation it triggers). We want to be able to go back and \
forth between notebook windows in the front end and our Java window without \
needing manually to switch the kernel into and out of some special state each \
time."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->24272],

Cell[TextData[{
 "What is needed is a way for the kernel to automatically pay attention to \
input arriving from the Java link in addition to the notebook front end link. \
What we really have here is two front ends vying for the kernel\
\[CloseCurlyQuote]s attention. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " solves this problem by introducing a simple way in which the kernel can be \
put into a state where it is simultaneously listening for input on any number \
of links. The function that accomplishes this is ",
 StyleBox["ShareKernel", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->20055],

Cell[TextData[{
 StyleBox["Important Note:",
  FontWeight->"Bold"],
 " In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.1 and later, the kernel is always shared with Java. This means that the \
functions ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["UnshareKernel", "MR"],
 " are not necessary and, in fact, do nothing at all. If you are writing \
program that only need to run in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.1 and later, you never need to call ",
 StyleBox["ShareKernel", "MR"],
 " or ",
 StyleBox["UnshareKernel", "MR"],
 " (",
 StyleBox["ShareFrontEnd", "MR"],
 " and ",
 StyleBox["UnshareFrontEnd", "MR"],
 " are still useful, however.) If your programs need to work on all versions \
of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you will need to use ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["UnshareKernel", "MR"],
 " as described below."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->20328],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["ShareKernel", "MR"], "[", "]"}], Cell[
    "begin sharing the kernel with Java", "TableText"]},
   {
    RowBox[{
     StyleBox["ShareKernel", "MR"], 
     StyleBox["[", "MR"], 
     StyleBox["link", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "begin sharing the kernel with ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["UnshareKernel", "MR"], 
     StyleBox["[", "MR"], 
     StyleBox["id", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "unregisters the request for sharing  (that is, the call to ",
     StyleBox["ShareKernel", "MR"],
     ") that returned ",
     Cell[BoxData[
      StyleBox["id", "TI"]], "InlineFormula"],
     "; kernel sharing will not be turned off unless no other requests are \
outstanding"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["UnshareKernel", "MR"], 
     StyleBox["[", "MR"], 
     StyleBox["link", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "end sharing of the kernel with ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["UnshareKernel", "MR"], "[", "]"}], Cell[
    "end sharing of the kernel with Java", "TableText"]},
   {
    RowBox[{
     StyleBox["KernelSharedQ", "MR"], "[", "]"}], Cell[TextData[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if the kernel is currently being shared; ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["SharingLinks", "MR"], "[", "]"}], Cell[
    "a list of the links currently sharing the kernel", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.7.8",
 CellID->22646],

Cell["Sharing the kernel.", "Caption",
 CellTags->"jlug:5.3.7.8",
 CellID->26362],

Cell[TextData[{
 StyleBox["ShareKernel", "MR"],
 " takes a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkObject"], "MR"]], "InlineFormula"],
 " as an argument and initiates sharing of the kernel between that link and \
the current ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 " (typically, the notebook front end). If you call ",
 StyleBox["ShareKernel", "MR"],
 " with no arguments, it assumes you mean the link to Java. Most users will \
call it with no arguments."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->4886],

Cell[BoxData[
 RowBox[{
  RowBox[{"ShareKernel", "[", "]"}], ";"}]], "Input",
 CellTags->"jlug:5.3.7.8",
 CellLabel->"In[1]:=",
 CellID->18875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "+", "2"}]], "Input",
 CellTags->"jlug:5.3.7.8",
 CellLabel->"(sharing) In[2]:=",
 CellID->28433],

Cell[BoxData["4"], "Output",
 CellTags->"jlug:5.3.7.8",
 CellLabel->"Out[2]=",
 CellID->29869]
}, Open  ]],

Cell[TextData[{
 "Note that while the kernel is being shared, the input prompt has \
\[OpenCurlyDoubleQuote](sharing)\[CloseCurlyDoubleQuote] prepended to it. The \
string that is prepended is specified by the ",
 StyleBox["SharingPrompt", "MR"],
 " option to ",
 StyleBox["ShareKernel", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->20142],

Cell[TextData[{
 "Sharing is transparent to the user. Other than the changed input prompt, \
there is nothing to suggest that anything different is going on. Input sent \
from either the front end or a Java program to the kernel will be evaluated \
and the result sent back to the program that sent the input. Each link is the \
kernel\[CloseCurlyQuote]s ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 " during the time that the kernel is computing input that arrived from that \
link. In other words, ",
 StyleBox["ShareKernel", "MR"],
 " takes care of shuffling the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 " value back and forth between links as input arrives on each."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->23844],

Cell[TextData[{
 "It is safe to call ",
 StyleBox["ShareKernel", "MR"],
 " if the kernel is already being shared. This means that programs you write \
can call it without your having to worry that a user might already have \
initiated sharing. When you are finished with the need to share the kernel \
with Java, you can call ",
 StyleBox["UnshareKernel", "MR"],
 ". This restores the kernel to its normal mode of operation, paying \
attention only to the front end."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->1416],

Cell[BoxData[
 RowBox[{"UnshareKernel", "[", "]"}]], "Input",
 CellTags->"jlug:5.3.7.8",
 CellLabel->"(sharing) In[3]:=",
 CellID->21881],

Cell[TextData[{
 "When called with no arguments, ",
 StyleBox["UnshareKernel", "MR"],
 " shuts down sharing. This is not a desirable thing in most cases, because \
it might be that some other Java-based program is running that requires \
sharing. If you are writing code for others to use, you certainly cannot shut \
down sharing on your users just because your code is done with it. To solve \
this problem, ",
 StyleBox["ShareKernel", "MR"],
 " returns a token (it is just an integer, but you should not be concerned \
with its representation) that reflects a request for sharing functionality. \
In other words, calling ",
 StyleBox["ShareKernel", "MR"],
 " registers a request for sharing, turns it on if it is not on already, and \
returns a token that represents that particular request. When you call ",
 StyleBox["UnshareKernel", "MR"],
 ", you pass it the token to \[OpenCurlyDoubleQuote]unregister",
 "\[CloseCurlyDoubleQuote]",
 " that particular request for sharing. Only if there are no other \
outstanding requests will sharing actually be turned off."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->31998],

Cell[TextData[{
 "A quirk of ",
 StyleBox["ShareKernel", "MR"],
 " is that you cannot call ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["UnshareKernel", "MR"],
 " in the same cell. Doing so will cause the kernel to hang. Of course, there \
is no reason to ever do this, as kernel sharing is only relevant when it \
spans multiple evaluations (more precisely, the evaluation of multiple \
cells). There would be no point to turning sharing on and off within the \
scope of a single computation."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->10322],

Cell[TextData[{
 "An example of a nontrivial user interface that uses ",
 StyleBox["ShareKernel", "MR"],
 " is presented in ",
 ButtonBox["Real-Time Algebra: A Mini-Application",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#142"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->18651]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sharing the Front End", "Subsection",
 CellTags->{"jlug:5.3.7.9", "TableOfContents_1.5.3.7.9"},
 CellID->10021],

Cell[TextData[{
 "One goal of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " was to have Java user interface elements be as close as possible to \
first-class citizens of the notebook front end environment, in the way that \
notebooks and palettes are. The ability to share the kernel mimics one \
important aspect of this citizenship, hiding the fact that the Java runtime \
is a separate program and the kernel is normally only waiting for input from \
the front end."
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->5699],

Cell[TextData[{
 "There is one more important thing that palettes can do that would be nice \
to do from Java, and that is interact with the front end. You can create a \
palette button that, when clicked, evaluates the code ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 StyleBox["[\"hello\"]", "MR"],
 ". You can do this easily with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " also, but with one big difference: when you click the palette button, ",
 StyleBox["hello", "MR"],
 " appears in the active notebook, but when you click the Java button, the \
\[OpenCurlyDoubleQuote]hello\[CloseCurlyDoubleQuote] gets sent back to the \
Java program (which is, after all, the kernel\[CloseCurlyQuote]s ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 " at that moment). Even if we persuaded the kernel to write the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextPacket"], "MR"]], "InlineFormula"],
 " that contains \[OpenCurlyDoubleQuote]hello\[CloseCurlyDoubleQuote] to the \
front end link instead of the Java link, nothing useful would happen because \
the front end is not paying attention to the kernel link when the front end \
is not waiting for the result of a computation. Poking some output at the \
front end while it is idle simply will not work."
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->3557],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides the ",
 StyleBox["ShareFrontEnd", "MR"],
 " function as the solution to this problem. ",
 StyleBox["ShareFrontEnd[]", "MR"],
 " causes ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output and graphics generated by a Java user-interface element to appear \
in the front end. It also lets the Java side call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions that manipulate elements of notebooks and have them work \
properly in the front end (for example, ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionEvaluate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionEvaluate"], "MR"]], "InlineFormula"],
 ", and so on). While sharing is on, the front end behaves normally, and you \
can continue to use it for editing, calculations, or whatever. The sharing is \
transparent."
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->28476],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     RowBox[{"ShareFrontEnd", "[", "]"}], "MR"], Cell[
    "begin sharing the front end with Java", "TableText"]},
   {
    RowBox[{
     StyleBox["UnshareFrontEnd", "MR"], 
     StyleBox["[", "MR"], 
     StyleBox["id", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "unregisters the request for sharing (that is, the call to ",
     StyleBox["ShareFrontEnd", "MR"],
     ") that returned ",
     Cell[BoxData[
      StyleBox["id", "TI"]], "InlineFormula"],
     "; front end sharing will not be turned off unless no other requests are \
outstanding"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["UnshareFrontEnd", "MR"], "[", "]"}], Cell[
    "end sharing of the front end with Java", "TableText"]},
   {
    RowBox[{
     ButtonBox["FrontEndSharedQ",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/FrontEndSharedQ"], "[", "]"}], Cell[
    TextData[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if the front end is currently being shared with Java; ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.7.9",
 CellID->27892],

Cell["Sharing the notebook front end.", "Caption",
 CellTags->"jlug:5.3.7.9",
 CellID->24389],

Cell[TextData[{
 StyleBox["ShareFrontEnd", "MR"],
 " currently does not work with a remote kernel; the same machine must be \
running the kernel and the front end. "
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->5075],

Cell[TextData[{
 StyleBox["ShareFrontEnd", "MR"],
 " is as close as we currently can come to having Java user interfaces hosted \
directly by the notebook front end itself, as if they were special types of \
notebook windows. This type of tight integration might be possible in the \
future."
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->10712],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " output, graphics, and messages generated by a ",
 StyleBox["modal",
  FontSlant->"Italic"],
 " Java window will appear in the front end without needing to call ",
 StyleBox["ShareFrontEnd", "MR"],
 ". This is because ",
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 " remains the front end link during ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " (these \[OpenCurlyDoubleQuote]side effect\[CloseCurlyDoubleQuote] packets \
always get sent to ",
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 "), and also because the front end is able to handle various packets \
arriving from the kernel because the front end ",
 StyleBox["is",
  FontSlant->"Italic"],
 " in the middle of a computation\[LongDash]it is waiting for the result of \
the code that called ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ". ",
 StyleBox["ShareFrontEnd", "MR"],
 " is a way to restore a feature that was lost when we gained the ability to \
create ",
 StyleBox["modeless",
  FontSlant->"Italic"],
 " interfaces via ",
 StyleBox["ShareKernel", "MR"],
 ". That is how to think of ",
 StyleBox["ShareFrontEnd\[LongDash]", "MR"],
 "as a step beyond ",
 StyleBox["ShareKernel", "MR"],
 " that allows side effect output generated by computations triggered in Java \
to appear in the notebook front end. ",
 StyleBox["ShareFrontEnd", "MR"],
 " is particularly useful when developing code that needs to use ",
 StyleBox["ShareKernel", "MR"],
 ", even if the code does not need the extra functionality of ",
 StyleBox["ShareFrontEnd", "MR"],
 ". This is because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " error messages generated by computations triggered by Java events get lost \
with ",
 StyleBox["ShareKernel", "MR"],
 ". The messages will show up in the front end if front end sharing is turned \
on. "
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->2600],

Cell[TextData[{
 "When you are done with the need to share the front end, call ",
 StyleBox["UnshareFrontEnd", "MR"],
 ". Like the ",
 StyleBox["ShareKernel", "MR"],
 "/",
 StyleBox["UnshareKernel", "MR"],
 " pair of functions, ",
 StyleBox["ShareFrontEnd", "MR"],
 " returns a token that you should pass to ",
 StyleBox["UnshareFrontEnd", "MR"],
 " to unregister the request for front end sharing. Only when all calls to ",
 StyleBox["ShareFrontEnd", "MR"],
 " have been unregistered by calls to ",
 StyleBox["UnshareFrontEnd", "MR"],
 " will front end sharing be turned off. You can force front end sharing to \
be shut down immediately by calling ",
 StyleBox["UnshareFrontEnd", "MR"],
 " with no arguments, but although this is convenient when you are developing \
code of your own, it should never be called in code that is intended for \
others to use. Just because your code is done with front end sharing does not \
mean that your users are done with it. Instead, save the token returned from \
",
 StyleBox["ShareFrontEnd", "MR"],
 " and pass it to ",
 StyleBox["UnshareFrontEnd", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->2510],

Cell[TextData[{
 StyleBox["ShareFrontEnd", "MR"],
 " requires that the kernel be shared, so it calls ",
 StyleBox["ShareKernel", "MR"],
 " internally. Calling ",
 StyleBox["UnshareKernel", "MR"],
 " with no arguments forces kernel sharing to stop immediately, and this \
turns off front end sharing as well. Thus, you can use ",
 StyleBox["UnshareKernel[]", "MR"],
 " as a quick shortcut to immediately shut down all sharing."
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->21003],

Cell[TextData[{
 "An example of some simple palette-type buttons that use ",
 StyleBox["ShareFrontEnd", "MR"],
 " is presented in ",
 ButtonBox["Sharing the Front End: Palette-Type Buttons",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#8177"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->26869],

Cell[TextData[{
 "An important use for ",
 StyleBox["ShareFrontEnd", "MR"],
 " is to allow a pop-up Java user interface to display graphics containing \
typeset expressions. When the kernel is asked to produce a graphic containing \
typeset expressions, say a plot with ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotLabel"], "MR"]], "InlineFormula"],
 StyleBox["->", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "MR"]], "InlineFormula"],
 StyleBox["[z]", "MR"],
 ", it crunches out PostScript for the plot itself, but when it comes time to \
produce PostScript for the typeset label, it cannot do this. Instead, it \
sends a special request back to the front end, asking it for the PostScript \
representation. Because dealing with typeset expressions is a skill possessed \
only by the notebook front end, when any other interface is driving the \
kernel, the interface must be careful to instruct the kernel to not attempt \
to typeset anything in a graphic (",
 StyleBox["ShareKernel", "MR"],
 " handles this automatically for you). This works fine, but you lose the \
ability to get pictures of typeset expressions in your Java interface."
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->17861],

Cell[TextData[{
 StyleBox["ShareFrontEnd", "MR"],
 " does two things to overcome this limitation: it fools the kernel into \
thinking that the Java runtime is a notebook front end and, therefore, \
capable of handling the special \[OpenCurlyDoubleQuote]convert to PostScript\
\[CloseCurlyDoubleQuote] requests; and it gives Java the ability to make good \
on this promise by forwarding the requests to the front end. ",
 ButtonBox["GraphicsDlg: Graphics and Typeset Output in a Window",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4678"],
 " describes an example of a Java dialog box that displays typeset \
expressions using ",
 StyleBox["ShareFrontEnd", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->14688]
}, Open  ]],

Cell[CellGroupData[{

Cell["Summary of Modal and Modeless Operation", "Subsection",
 CellTags->{"jlug:5.3.7.10", "TableOfContents_1.5.3.7.10"},
 CellID->13401],

Cell[TextData[{
 "The previous discussion of modal and modeless operation, ",
 StyleBox["ShareKernel", "MR"],
 ", and ",
 StyleBox["ShareFrontEnd", "MR"],
 " may have seemed complex. In fact, the principles and uses of these \
techniques are simple. This will become clear upon seeing some more examples. \
Many of the example programs in ",
 ButtonBox["Example Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#16139"],
 " use ",
 StyleBox["ShareKernel", "MR"],
 " or ",
 StyleBox["ShareFrontEnd", "MR"],
 ". The important thing is to understand the capabilities they provide so \
that you can begin to see how to use them in your own programs."
}], "Text",
 CellTags->"jlug:5.3.7.10",
 CellID->9789],

Cell[TextData[{
 "If you want your user-interface element (typically a window) to tie up the \
kernel until the user dismisses it, then you will use the ",
 StyleBox["setModal/DoModal/EndModal", "MR"],
 " suite. Because the internal workings of the modal state are simpler than \
the modeless state, you should use this style unless your program needs the \
features of a modeless window. You will always want to use this type of \
window if you need to return a result to a running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program, such as if you are creating a dialog box into which the user will \
enter values and then click OK. ",
 ButtonBox["A Simple Modal Input Dialog",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7391"],
 " gives an example of this type of dialog."
}], "Text",
 CellTags->"jlug:5.3.7.10",
 CellID->15255],

Cell[TextData[{
 "If you want your window to remain visible and active while the user returns \
to work in the front end, you must run your window in a \
\[OpenCurlyDoubleQuote]modeless\[CloseCurlyDoubleQuote] fashion. This \
requires calling ",
 StyleBox["ShareKernel", "MR"],
 " to put the kernel into a state where it is simultaneously receptive to \
input arriving from either the notebook front end or Java. At this point the \
kernel is dividing its attention between two independent and essentially \
equivalent front ends. One drawback (or feature, depending on your point of \
view) of this state is that all side effect output like ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output, messages, or plots triggered by Java code is sent to Java instead \
of the front end (and the standard Java ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes just throw all this output away). Thus, you  could not create a \
button that prints something in a notebook window when it is clicked, like \
you can with a palette button in the front end. If you want to give your Java \
program the ability to interact with the front end the way that notebook and \
palette windows themselves can, you must instead use ",
 StyleBox["ShareFrontEnd", "MR"],
 ", which you can think of as an extension to ",
 StyleBox["ShareKernel", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.10",
 CellID->16423],

Cell[TextData[{
 "A very common mistake is to create a Java window, wire up a ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " class that calls back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on some event, and then trigger the event before you have called ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " or ",
 StyleBox["ShareKernel", "MR"],
 ". This will cause the Java user interface thread to hang. A symptom that \
the UI thread is hanging is that the controls in your Java window are \
visually unresponsive (for example, buttons will not appear to depress when \
you click them). If you do inadvertently get into this state, you can just \
call ",
 StyleBox["ShareKernel", "MR"],
 " to allow the queued-up call(s) from Java to proceed."
}], "Text",
 CellTags->"jlug:5.3.7.10",
 CellID->5002]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
\[OpenCurlyDoubleQuote]Manual\[CloseCurlyDoubleQuote] Interfaces: The \
ServiceJava Function\
\>", "Subsection",
 CellTags->{"jlug:5.3.7.11", "TableOfContents_1.5.3.7.11"},
 CellID->10585],

Cell[TextData[{
 "In addition to the modal and modeless types of interfaces just discussed, \
there is another type that in some ways is intermediate. Consider the \
following scenario. You want to create a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that puts up a Java window and displays something in it that \
changes over the course of the program. So far, this sounds like an example \
of a \[OpenCurlyDoubleQuote]non-interactive\[CloseCurlyDoubleQuote] \
interface, which was discussed way back at the ",
 ButtonBox["beginning",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#314330245"],
 " of this section, the progress bar example being a classic case. Now, \
though, you want to add some interactivity to the window, meaning that you \
want user actions in the window to trigger calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Keeping with the progress bar example, say you want to add an ",
 StyleBox["Abort", "SR"],
 " button that stops the program. How do you manage to get the kernel\
\[CloseCurlyQuote]s attention directed at the Java side so that Java events \
can trigger calls to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "?"
}], "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->24182],

Cell[TextData[{
 "The modal type of interface will not work, because in the modal state the \
kernel is executing ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ", not your computation\[LongDash]the kernel is doing nothing but paying \
attention to Java. The modeless type of interface will not work either, \
because the modeless technique causes the kernel to pay attention to the \
front end and Java alternately, letting each perform a full computation in \
turn. There is no sharing within the context of a single computation."
}], "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->10285],

Cell[TextData[{
 "The obvious answer is the there needs to be a function that allows the \
kernel to service a single computation arriving from Java, if there is one \
waiting. That function is ",
 StyleBox["ServiceJava", "MR"],
 ". Calling ",
 StyleBox["ServiceJava", "MR"],
 " in a program will cause the kernel to accept one request for a computation \
from the Java side. It performs the computation and then returns control to \
your program. If there is no request waiting, ",
 StyleBox["ServiceJava", "MR"],
 " returns immediately."
}], "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->27088],

Cell[TextData[{
 "Here is some pseudocode showing the structure of a program that displays a \
progress bar with an ",
 StyleBox["Abort", "SR"],
 " button and periodically calls ",
 StyleBox["ServiceJava", "MR"],
 " to handle user clicks on that button, stopping the computation if \
requested."
}], "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->31426],

Cell["\<\
\t... create progress bar ...
\tprogressBar@addActionListener[
\t\tJavaNew[\"com.wolfram.jlink.MathActionListener\", \"(userCancelled = \
True)&\"]
\t];
\tJavaShow[progressBar];
\tWhile[i < 100 && !userCancelled,
\t\t... compute one iteration ...
\t\t... update progress bar ...
\t\tServiceJava[];
\t\ti++
\t];
\t... destroy progress bar ...\
\>", "Program",
 CellTags->"jlug:5.3.7.11",
 CellID->28617],

Cell[TextData[{
 "You might recognize that ",
 StyleBox["ServiceJava", "MR"],
 " is closely related to ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ", and although this is not the actual implementation, you can think of ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " as being written in terms of ",
 StyleBox["ServiceJava", "MR"],
 " as follows:"
}], "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->23757],

Cell["\<\
(* Not the actual implementation of DoModal, but the principle is correct. *)
DoModal[] :=
\tWhile[!endModal,
\t\tServiceJava[]
\t]\
\>", "Program",
 CellTags->"jlug:5.3.7.11",
 CellID->9832],

Cell[TextData[{
 "Seen in this way, ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " is a special case of the use of ",
 StyleBox["ServiceJava", "MR"],
 ", where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is doing nothing but servicing requests from Java. Sometimes you need \
something else to be going on in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but still need to be able to handle requests arriving from Java. That is \
when you call ",
 StyleBox["ServiceJava", "MR"],
 " yourself. Like ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ", there is no shifting of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 " when ",
 StyleBox["ServiceJava", "MR"],
 " is called. Thus, side effect output like graphics, messages, and ",
 StyleBox["Print", "MR"],
 " output triggered by Java computations appear in the notebook, just as if \
they were hard-coded into the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that called ",
 StyleBox["ServiceJava", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->30932],

Cell[TextData[{
 "The BouncingBalls example program presented in ",
 ButtonBox["BouncingBalls: Drawing in a Window",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#3487"],
 " uses ",
 StyleBox["ServiceJava", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->4169]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using a GUI Builder", "Subsection",
 CellTags->{"jlug:5.3.7.12", "TableOfContents_1.5.3.7.12"},
 CellID->2154],

Cell[TextData[{
 "The preceding discussion on modal and modeless interfaces featured examples \
that were created entirely with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. For complex user interfaces, you might find it more convenient to \
lay out your windows and wire up events with a drag-and-drop GUI builder like \
the ones present in most commercial Java development environments. You are \
free to write as much or as little of the code for your interface in native \
Java. If you want events in your GUI to trigger calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you can use any of the ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes from Java code just as they are used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. Alternatively, you could write your own Java code that calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " at appropriate times. See the section ",
 ButtonBox["Writing Your Own Installable Java Classes",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4680"],
 " for information about how to write Java code that calls back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 ButtonBox["GraphicsDlg: Graphics and Typeset Output in a Window",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4678"],
 " gives a simple example of a dialog box that was created with a GUI builder \
and is then invoked and controlled by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code."
}], "Text",
 CellTags->"jlug:5.3.7.12",
 CellID->25721]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Drawing and Displaying ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Images in Java Windows"
}], "Section",
 CellTags->{"jlug:5.3.8.0", "TableOfContents_1.5.3.8"},
 CellID->23775],

Cell[CellGroupData[{

Cell["The MathCanvas and MathGraphicsJPanel classes", "Subsection",
 CellTags->{"jlug:5.3.8.1", "TableOfContents_1.5.3.8.1"},
 CellID->20608],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " makes it easy to draw into Java windows from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and also display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics and typeset expressions. The ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " classes are provided for this purpose. You can use these classes in pure \
Java programs that use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, as described in ",
 ButtonBox["Writing Java Programs that use ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
  FontSlant->"Italic"],
 ", but it is also handy for Java windows that are created and scripted from \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Note that the ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " class is new in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0."
}], "Text",
 CellTags->"jlug:5.3.8.1",
 CellID->109591723],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " is a subclass of the AWT ",
 StyleBox["Canvas", "MR"],
 " class, and ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " is a subclass of the Swing ",
 StyleBox["JPanel", "MR"],
 " class. In terms of their special added ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics capabilities, they are identical. These  classes provide two ways \
to supply the image to be displayed. The first way is by providing a fragment \
of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code whose output will be displayed. The output can either be a graphics \
object, or a non-graphics expression that will be typeset. This makes it \
trivial to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics or typeset expressions in a Java window. The second way to \
control the display is to provide a Java ",
 StyleBox["Image", "MR"],
 " object that will be painted. This ",
 StyleBox["Image", "MR"],
 " will typically be created by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code, such as code that creates a bitmap out of raw ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " data, or code that draws something using calls to Java\[CloseCurlyQuote]s \
graphics routines."
}], "Text",
 CellTags->"jlug:5.3.8.1",
 CellID->5997],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " are Java classes and can be used from Java programs as well as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs, there is full JavaDoc format documentation for them in the  ",
 StyleBox["JLink/Documentation/JavaDoc", "MR"],
 " directory. You can browse that documentation for more details."
}], "Text",
 CellTags->"jlug:5.3.8.1",
 CellID->17549]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Showing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Graphics and Typeset Expressions"
}], "Subsection",
 CellTags->{"jlug:5.3.8.2", "TableOfContents_1.5.3.8.2"},
 CellID->29556],

Cell[TextData[{
 "Here is a simple example of displaying a window that shows a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " plot. This example uses ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 ", but the relevant parts would look the same if we used ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 ". We will be using this window throughout this section, so do not close it \
if you are evaluating the code as you read this section:"
}], "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->25561],

Cell["\<\
frame = JavaNew[\"com.wolfram.jlink.MathFrame\"];
frame@setLayout[JavaNew[\"java.awt.BorderLayout\"]];
mathCanvas = JavaNew[\"com.wolfram.jlink.MathCanvas\"];
frame@add[\"Center\", mathCanvas];
frame@setSize[400, 400];
frame@layout[];
mathCanvas@setMathCommand[\"Plot[x, {x,0,1}]\"];
JavaShow[frame];\
\>", "Input",
 CellTags->"jlug:5.3.8.2",
 CellLabel->"In[1]:=",
 CellID->31627],

Cell[TextData[{
 "As you can see, it is as simple as calling the canvas\[CloseCurlyQuote] ",
 StyleBox["setMathCommand()", "MR"],
 " method. The argument to ",
 StyleBox["setMathCommand()", "MR"],
 " is a string giving the code to be evaluated. This code must ",
 StyleBox["return",
  FontSlant->"Italic"],
 " a graphics expression, not just cause one to be produced. For example, ",
 StyleBox["setMathCommand[\"Plot[x, {x,0,1}];\"]", "MR"],
 " will not work because the trailing semicolon causes the expression to \
evaluate to ",
 StyleBox["Null", "MR"],
 ". The image is automatically rendered at the correct size, and centered in \
the canvas if the actual image size produced by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not completely fill the requested area (as is often the case with \
typeset output)."
}], "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->6467],

Cell[TextData[{
 "Calling ",
 StyleBox["setMathCommand()", "MR"],
 " again resets the image:"
}], "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->29541],

Cell["\<\
mathCanvas@setMathCommand[\"Plot3D[Sin[x Cos[y]], {x,0,2Pi}, {y,0,2Pi}]\"];\
\>", "Input",
 CellTags->"jlug:5.3.8.2",
 CellLabel->"In[9]:=",
 CellID->26129],

Cell[TextData[{
 "If the plotting command depends on variables in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you can call ",
 StyleBox["recompute()", "MR"],
 " to cause the graphic to be recomputed and rendered. For example, this \
displays a slow animation in the window:"
}], "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->31240],

Cell["\<\
n = 1.0;
mathCanvas@setMathCommand[\"Plot3D[Sin[n x Cos[y]], {x,0,2Pi}, {y,0,2Pi}]\"];
Do[n += 0.1; mathCanvas@recompute[]; Pause[1], {10}]\
\>", "Input",
 CellTags->"jlug:5.3.8.2",
 CellLabel->"In[10]:=",
 CellID->27813],

Cell["\<\
Because you supply the expression as a string, remember to escape any quote \
marks inside the string with a backslash:\
\>", "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->43861508],

Cell["\<\
mathCanvas@setMathCommand[\"Plot[x, {x,0,1}, PlotLabel->\\\"This is a \
plot\\\"]\"];\
\>", "Input",
 CellTags->"jlug:5.3.8.2",
 CellLabel->"In[13]:=",
 CellID->20601],

Cell[TextData[{
 "A ",
 StyleBox["MathCanvas", "MR"],
 " can also display typeset expressions. The default behavior of ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " is to expect that the expression supplied in ",
 StyleBox["setMathCommand()", "MR"],
 " will evaluate to a graphics object, which should be rendered. To get it to \
instead typeset the return value, call the ",
 StyleBox["setImageType()", "MR"],
 " method, supplying the constant ",
 StyleBox["TYPESET", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->6077],

Cell["\<\
mathCanvas@setImageType[MathCanvas`TYPESET];
mathCanvas@setMathCommand[\"Integrate[Sqrt[x] Sqrt[1+x], x]\"];\
\>", "Input",
 CellTags->"jlug:5.3.8.2",
 CellLabel->"In[14]:=",
 CellID->20215],

Cell[TextData[{
 "To switch back to displaying graphics, call ",
 StyleBox["mathCanvas@setImageType[MathCanvas`GRAPHICS]", "MR"],
 ". The default format for typeset output is ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"], "MR"]], "InlineFormula"],
 ". To switch to ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"], "MR"]], "InlineFormula"],
 ", use the ",
 StyleBox["setUsesTraditionalForm()", "MR"],
 " method. We call ",
 StyleBox["recompute()", "MR"],
 " here because changing the output type does not force the image to be \
redrawn:"
}], "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->8683],

Cell["\<\
mathCanvas@setUsesTraditionalForm[True];
mathCanvas@recompute[];\
\>", "Input",
 CellTags->"jlug:5.3.8.2",
 CellLabel->"In[16]:=",
 CellID->8213],

Cell[TextData[{
 "Graphics are rendered using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 "s ",
 StyleBox["Display", "MR"],
 " command, which is fast and does not require the notebook front end to be \
running. For higher quality, though, particularly for 3D graphics, an \
alternative method is available that uses the front end for rendering \
services. You can switch to using this technique by calling the ",
 StyleBox["setUsesFE()", "MR"],
 " method:"
}], "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->23992],

Cell["\<\
(* First, change back to graphics mode from typeset mode. *)
mathCanvas@setImageType[MathCanvas`GRAPHICS];

mathCanvas@setUsesFE[True];
mathCanvas@setMathCommand[\"Plot3D[Sin[x Cos[y]], {x,0,2Pi}, {y,0,2Pi}]\"];\
\>", "Input",
 CellTags->"jlug:5.3.8.2",
 CellLabel->"In[18]:=",
 CellID->25824],

Cell[TextData[{
 "You might want to compare the resulting plot with ",
 StyleBox["setUsesFE[", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 StyleBox["]", "MR"],
 " and ",
 StyleBox["setUsesFE[", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "MR"]], "InlineFormula"],
 StyleBox["]", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->5601],

Cell[TextData[{
 "An important point about using the front end for rendering is that when the \
computation to produce the image is performed, the front end must be in a \
state where it is receptive to requests for services from the kernel. There \
are two times when this is the case: either a cell in the front end is \
currently evaluating (as will be the case when you are calling ",
 StyleBox["setMathCommand()", "MR"],
 " or ",
 StyleBox["recompute()", "MR"],
 " from a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program), or ",
 StyleBox["ShareFrontEnd", "MR"],
 " has been called. Looking at it from the other direction, the only time it \
will not work is if ",
 StyleBox["ShareKernel", "MR"],
 " is in use, but not ",
 StyleBox["ShareFrontEnd", "MR"],
 ", and the computation is triggered by an event in Java. The rule is that if \
you want to involve the front end for rendering, and you want to call ",
 StyleBox["setMathCommand()", "MR"],
 " or ",
 StyleBox["recompute()", "MR"],
 " from Java in response to a user action in a modeless interface, you need \
to use ",
 StyleBox["ShareFrontEnd", "MR"],
 "; ",
 StyleBox["ShareKernel", "MR"],
 " is not enough. Modal and modeless interfaces and ",
 StyleBox["ShareFrontEnd", "MR"],
 " were discussed in the section ",
 ButtonBox["Creating Windows and Other User Interface Elements",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4596"],
 "."
}], "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->23392]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Drawing Using Java\[CloseCurlyQuote]s Graphics Functions\
\>", "Subsection",
 CellTags->{"jlug:5.3.8.3", "TableOfContents_1.5.3.8.3"},
 CellID->15759],

Cell[TextData[{
 "We saw above that the ",
 StyleBox["setMathCommand()", "MR"],
 " method of the ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " classes lets you supply a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression whose output is to be displayed. You can also use a ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " to display a Java ",
 StyleBox["Image", "MR"],
 " by using the ",
 StyleBox["setImage()", "MR"],
 " method instead of ",
 StyleBox["setMathCommand()", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->2670],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s look at a simple example of drawing into a Java \
window from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". We will continue to use the same window and ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " we have been working with. If this program used a ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " instead, the portions of the code related to drawing would look exactly \
the same. To draw into the ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 ", we create an offscreen image of the same dimensions, get a graphics \
context for drawing onto it, draw, and then use the ",
 StyleBox["setImage()", "MR"],
 " method of ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " to cause the offscreen image to be displayed. Drawing into an offscreen \
image and then blitting it to the screen is a standard technique for \
flicker-free drawing."
}], "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->26428],

Cell["\<\
offscreen = mathCanvas@createImage[mathCanvas@getSize[]@width,
                                   mathCanvas@getSize[]@height];
g = offscreen@getGraphics[];
g@drawRect[100, 100, 200, 150];
mathCanvas@setImage[offscreen];\
\>", "Input",
 CellTags->"jlug:5.3.8.3",
 CellLabel->"In[22]:=",
 CellID->28027],

Cell[TextData[{
 "Programs that want to draw manually into a Java window from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will generally all have this same structure. It takes just a few more \
lines of code to turn our ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " into a scribble program. Here is the complete program (this code is also \
provided as the file ",
 StyleBox["Scribble.nb", "MR"],
 " in the ",
 StyleBox["JLink/Examples/Part1", "MR"],
 " directory):"
}], "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->4084],

Cell["\<\
Scribble[] :=
\tJavaBlock[
\t\tModule[{frame, mathCanvas, offscreen, g, mml, pts},
\t\t\tframe = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\t\tframe@setLayout[JavaNew[\"java.awt.BorderLayout\"]];
\t\t\tmathCanvas = JavaNew[\"com.wolfram.jlink.MathCanvas\"];
\t\t\tframe@add[\"Center\", mathCanvas];
\t\t\tframe@setSize[400, 400];
\t\t\tframe@layout[];
\t\t\tJavaShow[frame];
\t\t\t(* Now create the offscreen image and the graphics context
\t\t\t   for drawing into it.
\t\t\t*)
\t\t\toffscreen = mathCanvas@createImage[mathCanvas@getSize[]@width,
                                  \t\t mathCanvas@getSize[]@height];
\t\t\tg = offscreen@getGraphics[];
\t\t\t(* Now create the MathMouseMotionListener that will do the drawing
\t\t\t   and set its mouseDragged event handler callback.
\t\t\t*)
\t\t\tmml = JavaNew[\"com.wolfram.jlink.MathMouseMotionListener\"];
\t\t\tmml@setHandler[\"mouseDragged\", \"mouseDraggedFunc\"];
\t\t\tmathCanvas@addMouseMotionListener[mml];
\t\t\tmouseDraggedFunc[_, x_, y_, _] :=
\t\t\t\t(g@drawLine[pts[[-1, 1]], pts[[-1, 2]], x, y];
\t\t\t\t mathCanvas@setImage[offscreen];
\t\t\t\t mathCanvas@repaintNow[];
\t\t\t\t AppendTo[pts, {x,y}];);
\t\t\t(* Initialize the pts list and run the program modally. *)
\t\t\tpts = {{0,0}};
\t\t\tframe@setModal[];
\t\t\tDoModal[];
\t\t\tpts
\t\t]
\t]\
\>", "Input",
 CellTags->"jlug:5.3.8.3",
 CellLabel->"In[26]:=",
 CellID->10075],

Cell[TextData[{
 "Run the program, then click and drag the mouse to draw in the window. Close \
the window to end the program and the ",
 StyleBox["Scribble", "MR"],
 " function will return the list of points drawn."
}], "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->18786],

Cell["pts = Scribble[];", "Input",
 CellTags->"jlug:5.3.8.3",
 CellLabel->"In[27]:=",
 CellID->15498],

Cell[TextData[{
 "If you examine the list of points returned, you will see that they are \
based on Java\[CloseCurlyQuote]s coordinate system, which has (0, 0) in the \
upper left. If you want to plot the points in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphic, you have to invert the ",
 StyleBox["y",
  FontSlant->"Italic"],
 " values. This is demonstrated in the ",
 StyleBox["Scribble.nb", "MR"],
 " example notebook.."
}], "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->24970],

Cell[TextData[{
 "There is one new ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " method demonstrated in this program, ",
 StyleBox["repaintNow()", "MR"],
 ". In a computation-intensive program like this, where events are being \
fired on the user interface thread very quickly, and the handlers for these \
events take a nontrivial amount of time to execute, Java will sometimes delay \
repainting the window. The drawing becomes very chunky, with no visual effect \
for a while and then suddenly all the lines drawn in the last few seconds \
will appear. Even calling the standard ",
 StyleBox["repaint()", "MR"],
 " method after every new point will not ensure that the window is updated in \
a timely manner. To solve this problem, the ",
 StyleBox["repaintNow()", "MR"],
 " method is provided, which forces an immediate redraw of the canvas. If \
your program relies on smooth visual feedback from user events that fire \
rapidly, you should call ",
 StyleBox["repaintNow()", "MR"],
 " also, even if it does not seem necessary on your system. There can be very \
significant differences between different platforms and different Java \
runtimes on the responsiveness of the screen updating mechanism."
}], "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->6287],

Cell[TextData[{
 "The ability to draw in response to events in a ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " opens up the possibility for some impressive interactive demonstrations, \
tutorials, and so on. Two of the larger example programs provided draw into a \
",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " from ",
 StyleBox["Mathematica:",
  FontSlant->"Italic"],
 " BouncingBalls (in the section ",
 ButtonBox["BouncingBalls: Drawing in a Window",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#3487"],
 ") and Spirograph (in the section ",
 ButtonBox["Spirograph",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#25423"],
 ")."
}], "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->23847]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bitmaps", "Subsection",
 CellTags->{"jlug:5.3.8.4", "TableOfContents_1.5.3.8.4"},
 CellID->32604],

Cell[TextData[{
 "We have seen how to draw into a ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " by using an offscreen image. Another type of image that you can create \
with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code and display using ",
 StyleBox["setImage()", "MR"],
 " is a bitmap. In this example we will create an indexed-color bitmap out of \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " data and display it. We will use an 8-bit color table, meaning that every \
data point in the image will be treated as an index into a 256-element list \
of colors. You could use a larger color table if desired."
}], "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->503],

Cell[TextData[{
 "We closed our frame window in the ",
 StyleBox["Scribble", "MR"],
 " example above, so let\[CloseCurlyQuote]s first create a new frame and \
canvas for the bitmap:"
}], "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->21221],

Cell["\<\
frame = JavaNew[\"com.wolfram.jlink.MathFrame\"];
frame@setLayout[JavaNew[\"java.awt.BorderLayout\"]];
mathCanvas = JavaNew[\"com.wolfram.jlink.MathCanvas\"];
frame@add[\"Center\", mathCanvas];
frame@setSize[450, 450];
frame@layout[];
JavaShow[frame];\
\>", "Input",
 CellTags->"jlug:5.3.8.4",
 CellLabel->"In[1]:=",
 CellID->22663],

Cell["\<\
Here is the color table. It is an array of {r,g,b} triplets, with each color \
component being in the range 0..255. In this example, colors with low indices \
are mostly blue, and ones with high indices are mostly red.\
\>", "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->5706],

Cell["colors = Table[{i, 0, 255 - i}, {i, 0, 255}];", "Input",
 CellTags->"jlug:5.3.8.4",
 CellLabel->"In[8]:=",
 CellID->2363],

Cell["\<\
The data is a 400 x 400 matrix of integers in the range 0..255 (because they \
are indices into the 256-element color table). In a real application, this \
data might be read from a file or computed in some more sophisticated way. If \
the range of numbers in the data did not span 0..255, we would have to scale \
it into that range, or a larger range if we wanted to use a deeper color \
table.\
\>", "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->9010],

Cell["\<\
data = Table[Round[255 (0.5 + Sin[x]Cos[y]/2)],
\t\t\t{x, Pi/100., 4Pi, Pi/100.}, {y, Pi/100., 4Pi, Pi/100.}];\
\>", "Input",
 CellTags->"jlug:5.3.8.4",
 CellLabel->"In[9]:=",
 CellID->22171],

Cell["\<\
Here we create the Java objects that represent the color model and bitmap. \
You can read the standard Java documentation on these classes for more \
information.\
\>", "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->27489],

Cell["\<\
colorModel = JavaNew[\"java.awt.image.IndexColorModel\", 8, 256,
\t\t\t\t\t\t\tFlatten[colors], 0, False];
bitmap = JavaNew[\"java.awt.image.MemoryImageSource\", 400, 400,
\t\t\t\t\t\t  colorModel, Flatten[data], 0, 400];\
\>", "Input",
 CellTags->"jlug:5.3.8.4",
 CellLabel->"In[10]:=",
 CellID->18240],

Cell["Now create an Image out of the bitmap and display it:", "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->12164],

Cell["\<\
image = frame@getToolkit[]@createImage[bitmap];
mathCanvas@setImage[image];\
\>", "Input",
 CellTags->"jlug:5.3.8.4",
 CellLabel->"In[12]:=",
 CellID->25542]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Java Console Window", "Section",
 CellTags->{"jlug:5.3.9.0", "TableOfContents_1.5.3.9"},
 CellID->22549],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides a convenient means to display the Java \
\[OpenCurlyDoubleQuote]console\[CloseCurlyDoubleQuote] window. Any output \
written to the standard ",
 StyleBox["System.out", "MR"],
 " and ",
 StyleBox["System.err", "MR"],
 " streams will be directed to this window. If you are calling Java code that \
writes diagnostic information to ",
 StyleBox["System.out", "MR"],
 " or ",
 StyleBox["System.err", "MR"],
 ", then you can see this output while your program runs. Like most ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " features, the console window can be used easily from either ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or Java programs (its use from Java code is described in ",
 ButtonBox["Writing Java Programs that use ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
  FontSlant->"Italic"],
 "). To use it from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", call the ",
 Cell[BoxData[
  ButtonBox["ShowJavaConsole",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ShowJavaConsole"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"jlug:5.3.9.0",
 CellID->9496],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ShowJavaConsole",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ShowJavaConsole"], "[", "]"}], Cell[
    TextData[{
     "display the Java console window and begin capturing output written to ",
     
     StyleBox["System.out", "MR"],
     " and ",
     StyleBox["System.err", "MR"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ShowJavaConsole",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ShowJavaConsole"], "[", 
     StyleBox["\"\<stream\>\"",
      FontSlant->"Italic"], "]"}], Cell[TextData[{
     "display the Java console window and begin capturing output written to \
the specified stream, which should be \"stdout\" for ",
     StyleBox["System.out", "MR"],
     " or \"stderr\" for ",
     StyleBox["System.err", "MR"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ShowJavaConsole",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ShowJavaConsole"], "[", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], "]"}], Cell[
    "stop all capturing of output", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.9.0",
 CellID->18584],

Cell["Showing the console window.", "Caption",
 CellTags->"jlug:5.3.9.0",
 CellID->9515],

Cell[CellGroupData[{

Cell["ShowJavaConsole[]", "Input",
 CellTags->"jlug:5.3.9.0",
 CellLabel->"In[2]:=",
 CellID->17964],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", 
    "[", "\<\"com.wolfram.jlink.ui.ConsoleWindow\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject280145214570497]], "Output",
 CellTags->"jlug:5.3.9.0",
 CellLabel->"Out[2]=",
 CellID->23342]
}, Open  ]],

Cell[TextData[{
 "Capturing of output only begins when you call ",
 Cell[BoxData[
  ButtonBox["ShowJavaConsole",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ShowJavaConsole"]], "InlineFormula"],
 ", so when the window first appears it will not have any content that might \
have been previously written to ",
 StyleBox["System.out", "MR"],
 " or ",
 StyleBox["System.err", "MR"],
 ". You will also note that the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " console window displays version information about the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " Java component and the Java runtime itself. Calling ",
 Cell[BoxData[
  ButtonBox["ShowJavaConsole",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ShowJavaConsole"]], "InlineFormula"],
 " when the window is already open will cause it to come to the foreground."
}], "Text",
 CellTags->"jlug:5.3.9.0",
 CellID->8075],

Cell[TextData[{
 "To demonstrate, we can write some output from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you executed the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ShowJavaConsole",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ShowJavaConsole"], "[", "]"}]], 
  "InlineFormula"],
 " above, then you will see \[OpenCurlyDoubleQuote]Hello from Java",
 "\[CloseCurlyDoubleQuote]",
 " printed in the window: "
}], "Text",
 CellTags->"jlug:5.3.9.0",
 CellID->17913],

Cell["\<\
LoadJavaClass[\"java.lang.System\"];
System`out@println[\"Hello from Java\"]\
\>", "Input",
 CellTags->"jlug:5.3.9.0",
 CellLabel->"In[3]:=",
 CellID->16142],

Cell[TextData[{
 "Although it is convenient to demonstrate writing to the window using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code like this, this is typically done from Java code instead. Actually, \
there is one common circumstance where it is quite useful to use the Java \
console window for diagnostic output written from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. This is the case where you have a \[OpenCurlyDoubleQuote]modeless\
\[CloseCurlyDoubleQuote] Java user interface (as described in the section ",
 ButtonBox["Creating Windows and Other User Interface Elements",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4596"],
 ") and you have not used the ",
 StyleBox["ShareFrontEnd", "MR"],
 " function. Recall that in this circumstance, output from calls to ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not appear in the notebook front end. If you write to ",
 StyleBox["System.out", "MR"],
 " instead, as in the above example, then you will always be able to see the \
output. You might want to do this in other circumstances just to avoid \
cluttering up your notebook with debugging output."
}], "Text",
 CellTags->"jlug:5.3.9.0",
 CellID->31196]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using JavaBeans", "Section",
 CellTags->{"jlug:5.3.10.0", "TableOfContents_1.5.3.10"},
 CellID->15748],

Cell["\<\
JavaBeans is Java\[CloseCurlyQuote]s component architecture. Beans are \
reusable components that can be manipulated visually in a builder tool. At \
the code level, a Bean is essentially just a normal Java class that conforms \
to a particular design pattern with respect to how its methods are named and \
how it supports events and persistence.\
\>", "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->19923],

Cell[TextData[{
 "We have not mentioned JavaBeans up to this point because there really is \
not anything special to be said. Beans are just Java classes, and they can be \
used and called like any other classes. It is probably the case that many \
Java classes you use from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will be Beans, whether they advertise themselves to be or not. This is \
especially true for user interface components."
}], "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->3359],

Cell[TextData[{
 "Beans are typically designed to be used in a visual builder tool, where the \
programmer is not writing code and calling named methods directly. Instead, a \
Bean exposes \[OpenCurlyDoubleQuote]properties\[CloseCurlyDoubleQuote] to the \
builder tool, which can be examined and set using a property editor window. \
In a typical simple example, a Bean might have methods named ",
 StyleBox["setColor", "MR"],
 " and ",
 StyleBox["getColor", "MR"],
 ", and by virtue of this it would be said to have a property named \
\[OpenCurlyDoubleQuote]color.\[CloseCurlyDoubleQuote] A property editor would \
have a line showing the name \[OpenCurlyDoubleQuote]color\
\[CloseCurlyDoubleQuote] and an edit field where you could type in a color. \
It might even have a fancy editor that puts up a color picker window to let \
you visually select a desired color."
}], "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->32257],

Cell[TextData[{
 "For the purposes of a visual builder tool or other type of automated \
manipulation, beans try to hide the low-level details of actual method names. \
If you want to call methods in a Bean class from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code, you call them by name in the usual way, without any consideration of \
the \[OpenCurlyDoubleQuote]Bean-ness\[CloseCurlyDoubleQuote] of the class."
}], "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->24766],

Cell[TextData[{
 "Note that it would be quite possible to add ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions to ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " that would provide explicit support for Bean properties. For example, a \
function ",
 StyleBox["BeanSetProperty", "MR"],
 " could be written that would take a Bean object, a property name as a \
string, and the value to set the property to. Then, instead of writing what \
is currently required:"
}], "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->4944],

Cell[BoxData[
 RowBox[{"bean", "@", 
  RowBox[{"setColor", "[", "Color`green", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.10.0",
 CellID->14955],

Cell["you could write:", "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->23318],

Cell[BoxData[
 RowBox[{"BeanSetProperty", "[", 
  RowBox[{"bean", ",", "\"\<color\>\"", ",", "Color`green"}], "]"}]], "Input",\

 Evaluatable->False,
 CellTags->"jlug:5.3.10.0",
 CellID->32726],

Cell[TextData[{
 "The ",
 StyleBox["BeanSetProperty", "MR"],
 " function lets you write code that manipulates nebulous things called \
properties instead of calling specific methods in the Bean class. If you do \
not see any particular advantage in the ",
 StyleBox["BeanSetProperty", "MR"],
 " style, then you know why there is no special Bean support along these \
lines in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". The advantages of working with properties versus directly calling methods \
accrues only when you are using a builder tool and not actually writing code \
by hand."
}], "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->25411],

Cell[TextData[{
 "If you are interested, here are simplistic implementations of ",
 StyleBox["BeanSetProperty", "MR"],
 " and ",
 StyleBox["BeanGetProperty", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->21025],

Cell["\<\
BeanSetProperty[bean_?JavaObjectQ, propName_String, val_] := 
\tModule[{methName = \"set\" <> ToUpperCase[StringTake[propName, 1]] <> 
\t\t\tStringDrop[propName, 1]},
\t\tThrough[(bean @@ ToHeldExpression[methName])[val]]
\t]

BeanGetProperty[bean_?JavaObjectQ, propName_String] := 
\tModule[{methName = \"get\" <> ToUpperCase[StringTake[propName, 1]] <> 
\t\t\tStringDrop[propName, 1]},
\t\tThrough[(bean @@ ToHeldExpression[methName])[]]
\t]\
\>", "Input",
 CellTags->"jlug:5.3.10.0",
 CellID->20355],

Cell[TextData[{
 "To make use of events that a JavaBean fires, you can use one of the \
standard ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes, as described in the section ",
 ButtonBox["Creating Windows and Other User Interface Elements",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4596"],
 ". JavaBeans often fire ",
 StyleBox["PropertyChangeEvents", "MR"],
 ", and you can arrange for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to be executed in response to these events by using a ",
 Cell[BoxData[
  ButtonBox["MathPropertyChangeListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathPropertyChangeListener"]], 
  "InlineFormula"],
 " or a ",
 Cell[BoxData[
  ButtonBox["MathVetoableChangeListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathVetoableChangeListener"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->31001]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hosting Applets", "Section",
 CellTags->{"TableOfContents_1.5.3.12", "1.2.12", "jlug:5.3.12.0"},
 CellID->13169],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " gives you the ability to run most applets in their own window directly \
from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Although this may seem immensely useful, given the vast number of applets \
that have been created, most applets do not export any useful public methods. \
They are generally stand-alone pieces of functionality, and thus they benefit \
little from the scriptability that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides. Still, there are many applets that may be useful to launch from \
a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program."
}], "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->23831],

Cell[TextData[{
 "Note that this section is not about writing applets that use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. That topic is covered in ",
 ButtonBox["Writing Applets",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#20615"],
 "."
}], "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->20040],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AppletViewer",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/AppletViewer"], "[", 
     StyleBox["\"\<applet class\>\"", "TI"], "]"}], Cell["\<\
runs the named applet class in its own window. The default width and height \
are 300 pixels.\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["AppletViewer",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/AppletViewer"], "[", 
     RowBox[{
      StyleBox["\"\<applet class\>\"", "TI"], ",", 
      StyleBox["params", "TI"]}], "]"}], Cell["\<\
runs the named applet class in its own window, supplying it the given \
parameters, which is a list of \"name=value\" specifications like those used \
in an HTML page.\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.12.0",
 CellID->26488],

Cell["Running applets.", "Caption",
 CellTags->"jlug:5.3.12.0",
 CellID->28685],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " includes an ",
 Cell[BoxData[
  ButtonBox["AppletViewer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AppletViewer"]], "InlineFormula"],
 " function for running applets. This function takes care of all the steps of \
creating the applet instance, providing a frame window to hold it, and \
starting it running. The first argument to ",
 Cell[BoxData[
  ButtonBox["AppletViewer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AppletViewer"]], "InlineFormula"],
 " is the fully qualified name of the applet class. The second argument is an \
optional list of parameters in \[OpenCurlyDoubleQuote]name=value\
\[CloseCurlyDoubleQuote] format, corresponding to the parameters supplied to \
an applet in an HTML page that hosts it. For example, if the <applet> tag in \
a web page that hosts an applet looks like this:"
}], "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->19090],

Cell["\<\
   <applet code=\"SomeApplet.class\" width=400 height=300>
\t\t<param name=foo value=bar>
   </applet>
\
\>", "Program",
 CellTags->"jlug:5.3.12.0",
 CellID->19497],

Cell[TextData[{
 "you would call ",
 Cell[BoxData[
  ButtonBox["AppletViewer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AppletViewer"]], "InlineFormula"],
 " like this:"
}], "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->2589],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppletViewer", "[", 
   RowBox[{"\"\<SomeApplet\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
     "\"\<width=400\>\"", ",", " ", "\"\<height=300\>\"", ",", " ", 
      "\"\<foo=bar\>\""}], "}"}]}], "]"}], ";"}]], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.12.0",
 CellID->25990],

Cell["\<\
You will typically supply at least \[OpenCurlyDoubleQuote]WIDTH=\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]HEIGHT=\
\[CloseCurlyDoubleQuote] specifications to control the width and height of \
the applet window. If you do not specify these parameters, the default width \
and height are 300 pixels.\
\>", "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->15145],

Cell[TextData[{
 "An excellent example of an applet that is useful to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users is LiveGraphics3D, written by Martin Kraus. LiveGraphics3D is an \
interactive viewer for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 3D graphics. It gives you the ability to rotate and zoom images, view them \
in stereo, and more. If you want to try the example below, you will need to \
get the LiveGraphics3D materials, available from ",
 ButtonBox["http://wwwvis.informatik.uni-stuttgart.de/~kraus/LiveGraphics3D/",
  
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://wwwvis.informatik.uni-stuttgart.de/~kraus/LiveGraphics3D/"], 
    None}],
 ". Make sure you put ",
 StyleBox["live.jar", "MR"],
 " onto your ",
 StyleBox["CLASSPATH", "MR"],
 " before trying the example below, or use the ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 " ",
 ButtonBox["feature",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#11323"],
 " of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to make it available."
}], "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->19353],

Cell[TextData[{
 "First, load the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyhedronOperations",
    BaseStyle->"Link",
    ButtonData->
     "paclet:PolyhedronOperations/guide/PolyhedronOperationsPackage"], "`"}]],
   "InlineFormula"],
 " package and create the graphic to display. The LiveGraphics3D \
documentation gives a more general-purpose function for turning a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics expression into appropriate input for the LiveGraphics3D applet \
but, for many examples, using ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"], "MR"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "MR"]], "InlineFormula"],
 " is sufficient:"
}], "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->19314],

Cell[BoxData[{
 RowBox[{"<<", "PolyhedronOperations`"}], "\n", 
 RowBox[{
  RowBox[{"dodec", "=", 
   RowBox[{"ToString", "[", 
    RowBox[{"InputForm", "[", 
     RowBox[{"N", "[", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"Stellate", "[", 
        RowBox[{"Normal", "[", 
         RowBox[{"PolyhedronData", "[", 
          RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], 
         "]"}], "]"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellTags->"jlug:5.3.12.0",
 CellLabel->"In[1]:=",
 CellID->66209135],

Cell[TextData[{
 "You specify the image to be displayed via the ",
 StyleBox["INPUT", "MR"],
 " parameter, which takes a string giving the ",
 StyleBox["InputForm", "MR"],
 " representation of the graphic."
}], "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->26740],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppletViewer", "[", 
   RowBox[{"\"\<Live\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<INPUT=\>\"", "<>", "dodec"}], ",", "\"\<WIDTH=400\>\"", 
      ",", "\"\<HEIGHT=400\>\""}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"jlug:5.3.12.0",
 CellLabel->"In[3]:=",
 CellID->22044],

Cell["\<\
The Live applet has a number of keyboard and mouse controls for manipulating \
the image. You can read about them in the LiveGraphics3D documentation. Try \
\[AltKey]-S to switch into a stereo view.\
\>", "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->11258],

Cell["\<\
When you are done with an applet, just click the window\[CloseCurlyQuote]s \
close box.\
\>", "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->335],

Cell[TextData[{
 "If the applet needs to refer to other files, you should be aware that ",
 Cell[BoxData[
  ButtonBox["AppletViewer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AppletViewer"]], "InlineFormula"],
 " sets the document base to be the directory specified by the ",
 StyleBox["\"user.dir\"", "MR"],
 " Java system property. This will normally be ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s current directory (given by ",
 StyleBox["Directory[]", "MR"],
 ") at the time that ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " was called."
}], "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->8759],

Cell[TextData[{
 "Most applets expose no public methods useful for controlling from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", so there is nothing to do but start them up with ",
 Cell[BoxData[
  ButtonBox["AppletViewer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AppletViewer"]], "InlineFormula"],
 " and then let the user close the window when they are finished. The Live \
applet is an exception\[LongDash]it provides a full set of methods to allow \
the viewpoint, spin, and so on to be modified by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. These methods are in the Live class, so to call them we need an \
instance of the Live class. The way we used ",
 Cell[BoxData[
  ButtonBox["AppletViewer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AppletViewer"]], "InlineFormula"],
 " earlier does not give us any instance of the applet class. The \
construction and destruction of the applet instance was hidden within the \
internals of ",
 Cell[BoxData[
  ButtonBox["AppletViewer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AppletViewer"]], "InlineFormula"],
 ". You can also call ",
 Cell[BoxData[
  ButtonBox["AppletViewer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AppletViewer"]], "InlineFormula"],
 " with an instance of an applet class instead of just the class name. This \
lets you manage the lifetime of the applet instance."
}], "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->11192],

Cell[BoxData[{
 RowBox[{
  RowBox[{"applet", "=", 
   RowBox[{"JavaNew", "[", "\"\<Live\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AppletViewer", "[", 
   RowBox[{"applet", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<INPUT=\>\"", "<>", "dodec"}], ",", "\"\<WIDTH=400\>\"", 
      ",", "\"\<HEIGHT=400\>\""}], "}"}]}], "]"}], ";"}]}], "Input",
 CellTags->"jlug:5.3.12.0",
 CellLabel->"In[4]:=",
 CellID->7605],

Cell["\<\
Now we can call methods on the applet instance. See the LiveGraphics3D \
documentation for the full set of methods. This scriptability opens up lots \
of possibilities, such as programming \[OpenCurlyDoubleQuote]flyby\
\[CloseCurlyDoubleQuote] views of objects, or creating buttons that jump the \
image into certain orientations or spins. \
\>", "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->25264],

Cell[BoxData[
 RowBox[{
  RowBox[{"applet", "@", 
   RowBox[{"setMagnification", "[", "0.5", "]"}]}], ";"}]], "Input",
 CellTags->"jlug:5.3.12.0",
 CellLabel->"In[6]:=",
 CellID->12181],

Cell[TextData[{
 "When we are done, we call ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " to release the applet instance. This can be done before or after the \
applet window is closed. "
}], "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->28503],

Cell[BoxData[
 RowBox[{"ReleaseJavaObject", "[", "applet", "]"}]], "Input",
 CellTags->"jlug:5.3.12.0",
 CellLabel->"In[7]:=",
 CellID->3829]
}, Open  ]],

Cell[CellGroupData[{

Cell["Periodical Tasks", "Section",
 CellTags->{"jlug:5.3.13.0", "TableOfContents_1.5.3.13"},
 CellID->28255],

Cell[TextData[{
 "The section ",
 ButtonBox["Creating Windows and Other User Interface Elements",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4596"],
 " described the ",
 StyleBox["ShareKernel", "MR"],
 " function and how it allows Java and the notebook front end to share the \
kernel\[CloseCurlyQuote]s attention. A side benefit of this functionality is \
that it becomes easy to provide a means whereby users can schedule arbitrary \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs to run at periodical intervals during a session. Say you have a \
source that provides continuously updated financial data and you want to have \
some variables in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " constantly reflect the current values. You have written a program that \
goes out and reads from the source to get the information, but you have to \
manually run this program all the time while you are working. A better \
solution would be to set up a periodical task that pulls the data from the \
source and sets the variables every 15 seconds."
}], "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->4460],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AddPeriodical",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/AddPeriodical"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["secs", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "cause ",
     StyleBox["expr", "TI"],
     " to be evaluated every ",
     StyleBox["secs", "TI"],
     " seconds while the kernel is idle"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RemovePeriodical",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/RemovePeriodical"], 
     StyleBox["[", "MR"], 
     StyleBox["id", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "stop scheduling of the periodical represented by ",
     StyleBox["id", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Periodical",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/Periodical"], 
     StyleBox["[", "MR"], 
     StyleBox["id", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "return a list {",
     ButtonBox["HoldForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HoldForm"],
     StyleBox["[", "MR"],
     StyleBox["expr", "TI"],
     StyleBox["]", "MR"],
     ", ",
     StyleBox["secs", "TI"],
     "}",
     " showing the expression and time interval associated with the \
periodical represented by ",
     StyleBox["id", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Periodicals",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/Periodicals"], "[", "]"}], Cell[
    TextData[{
     "return a list of the ",
     StyleBox["id", "TI"],
     " numbers of all currently scheduled periodicals"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetPeriodicalInterval",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/SetPeriodicalInterval"], 
     StyleBox["[", "MR"], 
     StyleBox["id", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "reset the periodical interval for the periodical task represented by ",
     StyleBox["id", "TI"]
    }], "TableText"]},
   {
    StyleBox["$ThisPeriodical", "MR"], Cell[TextData[{
     "holds the ",
     StyleBox["id", "TI"],
     " of the currently-executing periodical task"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.13.0",
 CellID->474],

Cell["Controlling periodical tasks. ", "Caption",
 CellTags->"jlug:5.3.13.0",
 CellID->6972],

Cell[TextData[{
 "You can set up such a task with the ",
 Cell[BoxData[
  ButtonBox["AddPeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddPeriodical"]], "InlineFormula"],
 " function:"
}], "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->26821],

Cell[BoxData[
 RowBox[{
  RowBox[{"id", "=", 
   RowBox[{"AddPeriodical", "[", 
    RowBox[{
     RowBox[{"updateFinancialData", "[", "]"}], ",", "15"}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"jlug:5.3.13.0",
 CellLabel->"In[1]:=",
 CellID->26122],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AddPeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddPeriodical"]], "InlineFormula"],
 " returns an integer ID number that you must use to identify the task\
\[LongDash]for example, when it comes time to stop scheduling it by calling \
",
 Cell[BoxData[
  ButtonBox["RemovePeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/RemovePeriodical"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["AddPeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddPeriodical"]], "InlineFormula"],
 " relies on kernel sharing, so it calls ",
 StyleBox["ShareKernel", "MR"],
 " if it has not already been called. There is no limit on the number of \
periodicals that can be established."
}], "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->446439732],

Cell[TextData[{
 "After scheduling the above task, ",
 StyleBox["updateFinancialData[]", "MR"],
 " will be executed every 15 seconds while the kernel is idle. Note that \
periodical tasks are run only when the kernel is not busy\[LongDash]they do \
not interrupt other evaluations. If the kernel is in the middle of another \
evaluation when the allotted 15 seconds elapses, the task will wait to be \
executed until immediately after the computation finishes. Any such delayed \
periodicals are guaranteed to be executed as soon as the kernel finishes with \
the current computation. They cannot be indefinitely delayed if the user is \
busy with numerous computations in the front end or in Java. The converse to \
these facts is also true\[LongDash]if a periodical is executing when the user \
evaluates a cell in the front end, the evaluation will not be able to start \
until all periodicals finish, but it is guaranteed to start immediately \
thereafter."
}], "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->21577],

Cell[TextData[{
 "To remove a single periodical task, use ",
 Cell[BoxData[
  ButtonBox["RemovePeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/RemovePeriodical"]], "InlineFormula"],
 ", supplying the ID number of the periodical as the argument. To remove all \
periodical tasks, use ",
 Cell[BoxData[
  ButtonBox["RemovePeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/RemovePeriodical"]], "InlineFormula"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  ButtonBox["Periodicals",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/Periodicals"]], "InlineFormula"],
 StyleBox["[]]", "MR"],
 ". Periodical tasks are all removed if you call ",
 StyleBox["UnshareKernel[]", "MR"],
 " with no arguments, which turns off all kernel sharing. You would then need \
to use ",
 Cell[BoxData[
  ButtonBox["AddPeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddPeriodical"]], "InlineFormula"],
 " again to reestablish periodical tasks."
}], "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->13634400],

Cell[TextData[{
 "You can reset the scheduling interval for a periodical task by calling ",
 Cell[BoxData[
  ButtonBox["SetPeriodicalInterval",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/SetPeriodicalInterval"]], "InlineFormula"],
 ", which is new in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0. This line makes the financial data periodical execute every 10 \
seconds, instead of 15 as shown above:"
}], "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->25605],

Cell["SetPeriodicalInterval[id, 10]", "Input",
 CellTags->"jlug:5.3.13.0",
 CellLabel->"(sharing) In[2]:=",
 CellID->30195],

Cell[TextData[{
 "Sometimes you might want to change the interval for a periodical task or \
remove it entirely from within the code of the task itself. ",
 StyleBox["$ThisPeriodical", "MR"],
 " is a variable that holds the ID of the currently executing periodical \
task. It will only have a value during the execution of a periodical task. \
You use ",
 StyleBox["$ThisPeriodical", "MR"],
 " from within your periodical task to obtain its ID so that you can call ",
 Cell[BoxData[
  ButtonBox["RemovePeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/RemovePeriodical"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["SetPeriodicalInterval",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/SetPeriodicalInterval"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->27594],

Cell[TextData[{
 "Periodical tasks do not necessarily have anything to do with Java, nor do \
they need to use Java. Technically, Java does not even need to be running. \
However, because Java is used by the internals of ",
 StyleBox["ShareKernel", "MR"],
 " to yield the CPU, if Java is not running then setting a periodical task \
will cause the kernel to keep the CPU continuously busy. Periodical task \
functionality is included in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " because it is a simple extension to ",
 StyleBox["ShareKernel", "MR"],
 ", and it does have some nice uses in association with Java."
}], "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->7950],

Cell["\<\
A final note about periodical tasks is that they do not cause output to \
appear in the front end. Look at this attempt:\
\>", "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->16343],

Cell[BoxData[
 RowBox[{
  RowBox[{"id", "=", 
   RowBox[{"AddPeriodical", "[", 
    RowBox[{
     RowBox[{"Print", "[", "\"\<hello\>\"", "]"}], ",", "10"}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"jlug:5.3.13.0",
 CellLabel->"(sharing) In[3]:=",
 CellID->754],

Cell[TextData[{
 "The programmer expects to get ",
 StyleBox["hello", "MR"],
 " printed in his notebook every 10 seconds, but nothing happens. During the \
time when periodicals are executed, ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 " is not assigned to the front end (or Java). Results or side effects like \
",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output, messages, or graphics vanish into the ether."
}], "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->2481],

Cell["\<\
Before proceeding, let\[CloseCurlyQuote]s clean up the periodical tasks we \
created:\
\>", "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->1012],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemovePeriodical", "[", 
   RowBox[{"Periodicals", "[", "]"}], "]"}], ";"}]], "Input",
 CellTags->"jlug:5.3.13.0",
 CellLabel->"(sharing) In[4]:=",
 CellID->11672]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some Special Number Classes", "Section",
 CellTags->{"jlug:5.3.14.0", "TableOfContents_1.5.3.14"},
 CellID->10938],

Cell[CellGroupData[{

Cell["Preamble", "Subsection",
 CellTags->{"jlug:5.3.14.1", "TableOfContents_1.5.3.14.1"},
 CellID->1881],

Cell[TextData[{
 "There is a set of special number-related classes in Java that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " maps to their ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " numeric representation. Like strings and arrays, objects of these number \
classes have an important property: although they are objects in Java, they \
have a meaningful \[OpenCurlyDoubleQuote]by value\[CloseCurlyDoubleQuote] \
representation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", so it is convenient for ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to automatically convert them to numbers as they are returned from Java to \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and back to objects as they are sent from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to Java."
}], "Text",
 CellTags->"jlug:5.3.14.1",
 CellID->9257],

Cell[TextData[{
 "These classes are the so-called \[OpenCurlyDoubleQuote]wrapper\
\[CloseCurlyDoubleQuote] classes that represent primitive types (",
 StyleBox["Byte", "MR"],
 ", ",
 StyleBox["Integer", "MR"],
 ", ",
 StyleBox["Long", "MR"],
 ", ",
 StyleBox["Double", "MR"],
 ", and so on), ",
 StyleBox["BigDecimal", "MR"],
 " and ",
 StyleBox["BigInteger", "MR"],
 ", and any class used to represent complex numbers. The treatment of these \
classes is described in this section."
}], "Text",
 CellTags->"jlug:5.3.14.1",
 CellID->22750]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The \[OpenCurlyDoubleQuote]Wrapper\[CloseCurlyDoubleQuote] Classes: Integer, \
Float, Boolean, and Others\
\>", "Subsection",
 CellTags->{"jlug:5.3.14.2", "TableOfContents_1.5.3.14.2"},
 CellID->28614],

Cell[TextData[{
 "Java has a set of so-called \[OpenCurlyDoubleQuote]wrapper\
\[CloseCurlyDoubleQuote] classes that represent primitive types. These \
classes are ",
 StyleBox["Byte", "MR"],
 ", ",
 StyleBox["Character", "MR"],
 ", ",
 StyleBox["Short", "MR"],
 ", ",
 StyleBox["Integer", "MR"],
 ", ",
 StyleBox["Long", "MR"],
 ", ",
 StyleBox["Float", "MR"],
 ", ",
 StyleBox["Double", "MR"],
 ", and ",
 StyleBox["Boolean", "MR"],
 ". The wrapper classes hold single values of their respective primitive \
types, and are necessary to allow everything in Java to be represented as a \
subclass of Object. This lets various utility methods and data structures \
that deal with objects handle primitive types in a straightforward way. It is \
also necessary for Java\[CloseCurlyQuote]s reflection capabilities."
}], "Text",
 CellTags->"jlug:5.3.14.2",
 CellID->18598],

Cell[TextData[{
 "If you have a Java method that returns one of these objects, it will arrive \
in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as an integer (for ",
 StyleBox["Byte", "MR"],
 ", ",
 StyleBox["Character", "MR"],
 ", ",
 StyleBox["Short", "MR"],
 ", ",
 StyleBox["Integer", "MR"],
 ", and ",
 StyleBox["Long", "MR"],
 "), real number (for ",
 StyleBox["Float", "MR"],
 " and ",
 StyleBox["Double", "MR"],
 "), or the symbols ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "MR"]], "InlineFormula"],
 " (for ",
 StyleBox["Boolean", "MR"],
 "). Likewise, a Java method that takes one of these objects as an argument \
can be called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with the appropriate raw ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " value. The same rules hold true for arrays of these objects, which are \
mapped to lists of values."
}], "Text",
 CellTags->"jlug:5.3.14.2",
 CellID->28458],

Cell[TextData[{
 "In the unlikely event that you want to defeat these automatic \
\[OpenCurlyDoubleQuote]pass by value\[CloseCurlyDoubleQuote] semantics, you \
can use the ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["JavaObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectToExpression"]], "InlineFormula"],
 " functions, discussed in ",
 ButtonBox["References and Values",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2785"],
 "."
}], "Text",
 CellTags->"jlug:5.3.14.2",
 CellID->2661]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complex Numbers", "Subsection",
 CellTags->{"1.2.14", "jlug:5.3.14.3", "TableOfContents_1.5.3.14.3"},
 CellID->26063],

Cell[TextData[{
 "We have seen that Java number types (e.g., ",
 StyleBox["byte", "MR"],
 ", ",
 StyleBox["int", "MR"],
 ", ",
 StyleBox["double", "MR"],
 ") are returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as integers and reals, and integers and reals are converted to the \
appropriate types when sent as arguments to Java. What about complex numbers? \
It would be nice to have a Java class representing complex numbers that \
mapped directly to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " type, so that automatic conversions would occur as they were passed back \
and forth between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java. Java does not have a standard class for complex numbers, so ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " lets you name the class that you want to participate in this mapping."
}], "Text",
 CellTags->"jlug:5.3.14.3",
 CellID->32756],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SetComplexClass",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/SetComplexClass"], 
     StyleBox["[", "MR"], 
     StyleBox["\"\<classname\>\"", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "set the class to be mapped to complex numbers in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GetComplexClass",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/GetComplexClass"], "[", "]"}], Cell[
    "return the class currently used for complex numbers", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.14.3",
 CellID->20807],

Cell["Setting the class for complex numbers.", "Caption",
 CellTags->"jlug:5.3.14.3",
 CellID->20278],

Cell["\<\
You can use any class you like as long as it has the following properties:\
\>", "Text",
 CellTags->"jlug:5.3.14.3",
 CellID->19489],

Cell[TextData[{
 StyleBox["1.",
  FontWeight->"Bold"],
 "  A public constructor that takes two doubles (the real and imaginary \
parts, in that order)"
}], "ItemizedText",
 CellTags->"jlug:5.3.14.3",
 CellID->19435],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["2.",
  FontWeight->"Bold"],
 "  Methods that return the real and imaginary parts, having the following \
signatures:"
}], "ItemizedText",
 CellTags->"jlug:5.3.14.3",
 CellID->6365],

Cell["\<\
public double re();
public double im();\
\>", "Program",
 CellTags->"jlug:5.3.14.3",
 CellID->32075],

Cell[TextData[{
 "Say that you are doing some computations with complex numbers in Java, and \
you want to interact with these methods from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You like to use the complex number class available from netlib. This \
class is named ",
 StyleBox["ORG.netlib.math.complex.Complex", "MR"],
 " and is available at ",
 ButtonBox["http://www.netlib.org/java/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.netlib.org/java/"], None}],
 ". You use the ",
 Cell[BoxData[
  ButtonBox["SetComplexClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/SetComplexClass"]], "InlineFormula"],
 " function to specify the name of the class:"
}], "Text",
 CellTags->"jlug:5.3.14.3",
 CellID->7586],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetComplexClass", "[", "\"\<ORG.netlib.math.complex.Complex\>\"", "]"}], 
  ";"}]], "Input",
 CellTags->"jlug:5.3.14.3",
 CellID->1386],

Cell[TextData[{
 "Now any method or field that takes an argument of type ",
 StyleBox["ORG.netlib.math.complex.Complex", "MR"],
 " will accept a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " complex number, and any object of class ",
 StyleBox["ORG.netlib.math.complex.Complex", "MR"],
 " returned from a method or field will automatically be converted into a \
complex number in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The same holds true for arrays of complex numbers."
}], "Text",
 CellTags->"jlug:5.3.14.3",
 CellID->7833],

Cell[TextData[{
 "Note that you must call ",
 Cell[BoxData[
  ButtonBox["SetComplexClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/SetComplexClass"]], "InlineFormula"],
 " before you load any classes that use complex numbers, not merely before \
you call any methods of the class."
}], "Text",
 CellTags->"jlug:5.3.14.3",
 CellID->8360]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BigInteger and BigDecimal", "Subsection",
 CellTags->{"jlug:5.3.14.4", "TableOfContents_1.5.3.14.4"},
 CellID->13330],

Cell[TextData[{
 "Java has standard classes for arbitrary-precision floating-point numbers \
and arbitrary-precision integers. These classes are ",
 StyleBox["java.math.BigDecimal and java.math.BigInteger", "MR"],
 ", respectively. Because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effortlessly handles such \[OpenCurlyDoubleQuote]bignums,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " maps ",
 StyleBox["BigInteger", "MR"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " integers and ",
 StyleBox["BigDecimal", "MR"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reals. What this means is that any Java method or field that takes, say, a \
",
 StyleBox["BigInteger", "MR"],
 " can be called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by passing an integer. Likewise, any method or field that returns a ",
 StyleBox["BigDecimal", "MR"],
 " will have the value returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a real number."
}], "Text",
 CellTags->"jlug:5.3.14.4",
 CellID->26048]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ragged Arrays", "Section",
 CellTags->{"jlug:5.3.15.0", "TableOfContents_1.5.3.15"},
 CellID->1908],

Cell[TextData[{
 "Java allows arrays that are deeper than one dimension to be \
\[OpenCurlyDoubleQuote]ragged,\[CloseCurlyDoubleQuote] or non-rectangular, \
meaning that they do not have the same length at every position at the same \
level. For example, ",
 StyleBox["{{1,2,3},{4,5},{6,7,8}}", "MR"],
 " is a ragged two-dimensional array. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " allows you to send and receive ragged arrays, but it is not the default \
behavior. The reason for this is simply efficiency\[LongDash]the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library has functions that allow very efficient transfer of rectangular \
arrays of most primitive types (e.g., ",
 StyleBox["byte", "MR"],
 ", ",
 StyleBox["int", "MR"],
 ", ",
 StyleBox["double", "MR"],
 ", and so on), whereas ragged ones have to be picked apart tediously with a \
series of individual calls to get every piece. This all happens deep inside \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", so you do not have to be concerned with the mechanics of array passing, \
but it has a huge impact on speed. To maximize speed, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " assumes that arrays of primitive types are rectangular. You can toggle \
back and forth between allowing and rejecting ragged arrays by calling the ",
 Cell[BoxData[
  ButtonBox["AllowRaggedArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AllowRaggedArrays"]], "InlineFormula"],
 " function with either ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "MR"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->17223],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AllowRaggedArrays",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/AllowRaggedArrays"], "[", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], Cell["\<\
allow ragged (i.e., non-rectangular) arrays to be sent to Java\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.15.0",
 CellID->11759],

Cell["Ragged array support.", "Caption",
 CellTags->"jlug:5.3.15.0",
 CellID->26434],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["AllowRaggedArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AllowRaggedArrays"]], "InlineFormula"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 StyleBox["]", "MR"],
 ", sending of arrays deeper than one dimension is greatly slowed. Here is an \
example of array behavior and how it is affected. Assume the class ",
 StyleBox["Testing", "MR"],
 " has the following method, which takes a two-dimensional array of ints and \
simply returns it:"
}], "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->5204],

Cell["\<\
public static int[][] intArrayIdentity(int[][] a) {
\treturn a;
}\
\>", "Program",
 CellTags->"jlug:5.3.15.0",
 CellID->29486],

Cell["Look what happens if we call it with a ragged array:", "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->4319],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadClass", "[", "\"\<Testing\>\"", "]"}], ";"}], "\n", 
 RowBox[{"Testing`intArrayIdentity", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}]}], "}"}], "]"}]}], "Input",
 CellTags->"jlug:5.3.15.0",
 CellLabel->"In[1]:=",
 CellID->958],

Cell[BoxData[
 RowBox[{
  RowBox[{"Java", "::", "\<\"argxs1\"\>"}], ":", 
  " ", "\<\"The static method Testing`intArrayIdentity was called with an \
incorrect number or type of arguments. The argument was \
{{1,2,3},{4,5}}.\"\>"}]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"jlug:5.3.15.0",
 CellLabel->"From In[1]:=",
 CellID->5945],

Cell[BoxData["$Failed"], "Output",
 CellTags->"jlug:5.3.15.0",
 CellLabel->"Out[2]=",
 CellID->26806]
}, Open  ]],

Cell[TextData[{
 "An error occurs because the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definition for the ",
 StyleBox["Testing`intArrayIdentity()", "MR"],
 " function requires that is argument be a two-dimensional rectangular array \
of integers. The call never even gets out of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->8166],

Cell[TextData[{
 "Here we turn on support for ragged arrays, and the call works. This \
requires modifications in both the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-side type checking on method arguments and the Java-side array-reading \
routines:"
}], "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->18700],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"AllowRaggedArrays", "[", "True", "]"}], "\n", 
 RowBox[{"Testing`intArrayIdentity", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}]}], "}"}], "]"}]}], "Input",
 CellTags->"jlug:5.3.15.0",
 CellLabel->"In[3]:=",
 CellID->11367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellTags->"jlug:5.3.15.0",
 CellLabel->"Out[4]=",
 CellID->17692]
}, Open  ]],

Cell["\<\
It is a good idea to turn off support for ragged arrays as soon as you no \
longer need it, since it slows arrays down so much:\
\>", "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->21787],

Cell[BoxData[
 RowBox[{"AllowRaggedArrays", "[", "False", "]"}]], "Input",
 CellTags->"jlug:5.3.15.0",
 CellLabel->"In[5]:=",
 CellID->28532]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Implementing a Java Interface with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Code"
}], "Section",
 CellTags->{"1.2.17", "jlug:5.3.17.0", "TableOfContents_1.5.3.17"},
 CellID->7619],

Cell[TextData[{
 "We have seen how ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " lets you write programs that use existing Java classes. We have also seen \
how you can wire up the behavior of a Java user interface via callbacks to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via the ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes. You can think of any of these ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes, such as ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 ", as a class that \[OpenCurlyDoubleQuote]proxies\[CloseCurlyDoubleQuote] \
its behavior to arbitrary user-defined ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. It is as if we have a Java class that has its implementation written \
in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This functionality is extremely useful because it greatly extends the set \
of programs we can write purely in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", without resorting to writing our own Java classes. "
}], "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->20913],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ImplementJavaInterface",
      BaseStyle->"Link",
      ButtonData->"paclet:JLink/ref/ImplementJavaInterface"], 
     StyleBox["[", "MR"], 
     RowBox[{Cell[TextData[StyleBox["\"interfaceName\"", "TI"]]], ",", 
      RowBox[{
       StyleBox["{", "MR"], 
       RowBox[{
        RowBox[{Cell[TextData[StyleBox["\"methName\"", "TI"]]], 
         StyleBox[" ", "MR"], 
         StyleBox["->", "MR"], 
         StyleBox[" ", "MR"], Cell[TextData[StyleBox[
         "\"mathFunc\"", "TI"]]]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], 
       StyleBox["}", "MR"]}]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "create an instance of a Java class that implements the  named Java \
interface by calling back to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " according to the given mappings of Java methods to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " functions"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"jlug:5.3.17.0",
 CellID->7591],

Cell[TextData[{
 "Implementing a Java interface ",
 "entirely",
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Caption",
 CellTags->"jlug:5.3.17.0",
 CellID->6704],

Cell[TextData[{
 "It would be nice to be able to take this behavior and generalize it, so \
that you could take ",
 StyleBox["any",
  FontSlant->"Italic"],
 " Java interface and implement its methods via callbacks to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions, and do it all without having to write any Java code. The ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " function, new in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0, lets you do precisely that. This function is easier to understand \
with a concrete example. Say you are writing a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that uses ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to display a Java window with a Swing menu, and you want to script the \
behavior of the menu in ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"],
 " The Swing ",
 StyleBox["JMenu", "MR"],
 " class fires events to registered ",
 StyleBox["MenuListener", "MR"],
 "s,  so what you need is a class that implements ",
 StyleBox["MenuListener", "MR"],
 " by calling into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". A quick glance at the ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2421"],
 " on MathListeners reveals that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " does not provide a ",
 Cell[BoxData["MathMenuListener"], "InlineFormula"],
 " class for you. You could choose to write your own implementation of such a \
class, and in fact this would be very easy, even trivial, since you would \
make it a subclass of ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " and inherit virtually all the functionality you would need. For the sake \
of this discussion, assume that you choose not to do that, perhaps because \
you don\[CloseCurlyQuote]t know Java or you don\[CloseCurlyQuote]t want to \
deal with all the extra steps required for that solution. Instead, you can \
use ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " to create such a Java class with a single line of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code:"
}], "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->31818],

Cell["\<\
mathMenuListener =
\tImplementJavaInterface[\"javax.swing.event.MenuListener\",
\t\t{\"menuSelected\" -> \"menuSelectedFunc\",
\t\t \"menuCanceled\" -> \"menuCanceledFunc\",
\t\t \"menuDeselected\" -> \"menuDeselectedFunc\"}
\t];
myMenu@addMenuListener[mathMenuListener];

...

(* Later, define the three Mathematica event-handler functions: *)
menuSelectedFunc[menuEvent_] := ...

menuCanceledFunc[menuEvent_] := ...

menuDeselectedFunc[menuEvent_] := ...\
\>", "Input",
 CellTags->"jlug:5.3.17.0",
 CellID->9232],

Cell[TextData[{
 "The first argument to ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " is the Java interface or list of interfaces you want to implement. The \
second argument is a list of rules that associate the name of a Java method \
from one of the interfaces with the name of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function to call to implement that method. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function will be called with the same arguments that the Java method \
takes. What ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " returns is a Java object of a newly-created class that implements the \
named interface(s). You use it just like any ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " obtained by calling ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " or through any other means. It is just as if you had written your own Java \
class that implemented the named interface by calling the associated ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions, and then called ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " to create an instance of that class."
}], "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->750],

Cell[TextData[{
 "It is not necessary to associate every method in the interface with a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function. Any Java methods you leave out of your list of mappings will be \
given a default Java implementation that returns ",
 StyleBox["null", "MR"],
 ". If this is not an appropriate return value for the method (e.g., if the \
method returns an int) and the method gets called at some point an exception \
will be thrown. Generally, this exception will propagate to the top of the \
Java call stack and be ignored, but it is recommended that you implement all \
the methods in the Java interface."
}], "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->25205],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " function makes use of the \[OpenCurlyDoubleQuote]dynamic proxy\
\[CloseCurlyDoubleQuote] capability introduced in Java 1.3. It will not work \
in Java versions earlier than 1.3. All of the Java runtimes bundled with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.2 and later are at version 1.3 or later. If you have ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.0 or 4.1, the ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " function is another reason to make sure you have an up-to-date Java \
runtime for your system."
}], "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->4975],

Cell[TextData[{
 "At first glance, the ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " function might seem to give us the capability to write arbitrary Java \
classes in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language, and to some extent that is true. One important thing you cannot \
do is extend, or subclass, an existing Java class. You also cannot add \
methods that do not exist in the interface you are implementing. \
Event-handler classes are a good example of the type of classes for which \
this facility is useful. You might think that the ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes are rendered obsolete by ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 ", and it is true that their functionality can be duplicated with it. The ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes are still useful for Java versions earlier than 1.3, but most \
importantly they are useful for writing pure Java programs that call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Using a class implemented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " in a Java program that calls ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " would be possible, but quite cumbersome. If you want a dual-purpose class \
that is as easy to use from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as from Java, you should write your own subclass of ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 ". One ",
 StyleBox["poor",
  FontSlant->"Italic"],
 " reason for choosing to use ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " instead of writing a custom Java class is that you are worried about \
complicating your application by requiring it to include its own Java classes \
in addition to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. As explained in the section on deploying applications that use ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", it is extremely easy to include supporting Java classes in your \
application. Your users will not require any extra installation steps nor \
will they need to modify the Java class path."
}], "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->1539]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing Your Own Installable Java Classes", "Section",
 CellTags->{"1.2.18", "jlug:5.3.18.0", "TableOfContents_1.5.3.18"},
 CellID->4680],

Cell[CellGroupData[{

Cell["Preamble", "Subsection",
 CellTags->{"jlug:5.3.18.1", "TableOfContents_1.5.3.18.1"},
 CellID->9198],

Cell[TextData[{
 "The previous sections have shown how to load and use existing Java classes. \
This gives ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programmers immediate access to the entire universe of Java classes. \
Sometimes, though, existing Java classes are not enough, and you need to \
write your own."
}], "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->27032],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " essentially obliterates the boundary between Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", letting you pass expressions of any type back and forth and use Java \
objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a meaningful way. This means that when writing your own Java classes to \
call from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you usually do not need to do anything special. You write the code in \
exactly the same way as you would if you wanted to use the class only from \
Java. (One important exception to this rule is that because it is \
comparatively slow to call into Java from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you ",
 StyleBox["might",
  FontSlant->"Italic"],
 " need to design your classes in a way that will not require an excessive \
number of method calls from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to get the job done. This issue is discussed in detail in ",
 ButtonBox["Overhead of Calls to Java",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7572"],
 ".)"
}], "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->14387],

Cell[TextData[{
 "In some cases, you might want to exert more direct control over the \
interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". For example, you might want a method to return something different to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " than what the method itself returns. Or you might want the method to not \
just return something, but also trigger a side effect in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[LongDash]for example, printing something or displaying a message under \
certain conditions. You can even have an extended \
\[OpenCurlyDoubleQuote]dialog\[CloseCurlyDoubleQuote] with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " before your method returns, perhaps invoking multiple computations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and reading their results. You might also want to write a ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 "-type class that calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as the result of some event triggered in Java."
}], "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->32584],

Cell[TextData[{
 "If you do not want to do any of these things, then you can happily ignore \
this section. The whole point of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is to make unnecessary the need to be concerned about the interaction with \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " through ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". Most programmers who want to write Java classes to be used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will just write Java classes, period, without thinking about ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". Those programmers who want more control, or want to know more about the \
possibilities available with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", read on."
}], "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->7240],

Cell[TextData[{
 "The issues discussed in this section require some knowledge of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programming (or, more precisely, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programming using the Java methods that use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "), which is discussed in detail in ",
 ButtonBox["Writing Java Programs that use ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
  FontSlant->"Italic"],
 ". The fact that we meet some of these methods and issues here is a \
consequence of the false but useful dichotomy, noted in the ",
 ButtonBox["Introduction",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Introduction#25629"],
 ", between using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to write \[OpenCurlyDoubleQuote]installable\[CloseCurlyDoubleQuote] \
functions to be called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to write front ends for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is always used in the same way, it is just that virtually all of it is \
handled for you in the installable case. Here we will be talking about how to \
go beyond this default behavior, so we will be making direct ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " calls to read and write to the link. Thus we will encounter concepts, \
classes, and methods in this section that are not explained until ",
 ButtonBox["Writing Java Programs that use ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->3517],

Cell[TextData[{
 "Some of the discussion in this section will compare and contrast the \
process of writing an installable program in C. This is designed to help \
experienced ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programmers understand how ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " works, and also to convince you that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is a superior solution to using C, C++, or FORTRAN."
}], "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->17006]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Installable Functions\[LongDash]The Old Way\
\>", "Subsection",
 CellTags->{"jlug:5.3.18.2", "TableOfContents_1.5.3.18.2"},
 CellID->8670],

Cell[TextData[{
 "Writing a so-called \[OpenCurlyDoubleQuote]installable\
\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]template\
\[CloseCurlyDoubleQuote] program in C requires a number of steps. If you have \
a file ",
 StyleBox["foo.c", "MR"],
 " that contains a function ",
 StyleBox["foo", "MR"],
 ", to call it from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " you must first write a template (.tm) file that contains a template entry \
describing how you want ",
 StyleBox["foo", "MR"],
 " to be called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", what types of arguments it takes, and what it returns. You then pass this \
.tm file through a tool called ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 ", which writes a file of C code that manages some, possibly all, of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-related aspects of the program. You also need to write a simple ",
 StyleBox["main", "MR"],
 " routine, which is always the same. You then compile all of these files, \
resulting in an executable for just one platform."
}], "Text",
 CellTags->"jlug:5.3.18.2",
 CellID->241],

Cell[TextData[{
 "Two big drawbacks of this method are that you need to write a template \
entry for every single function you want to call (imagine doing that for a \
whole function library), and the compiled program is not portable to other \
platforms. The biggest drawback, however, is that there is no automatic \
support for anything but the simplest types. If you want to do something as \
basic as returning a list of integers, you need to write the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " calls to do that yourself. And forget about object-oriented programming, \
as there is no way to pass \[OpenCurlyDoubleQuote]objects\
\[CloseCurlyDoubleQuote] to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.18.2",
 CellID->18882]
}, Open  ]],

Cell[CellGroupData[{

Cell["Installable Functions in Java", "Subsection",
 CellTags->{"jlug:5.3.18.3", "TableOfContents_1.5.3.18.3"},
 CellID->25249],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " makes all those steps go away. As we have seen all throughout this \
tutorial, you can literally call any method in any class, without any \
preparation."
}], "Text",
 CellTags->"jlug:5.3.18.3",
 CellID->3523],

Cell["\<\
It is only in cases where the default behavior of calling a method and \
receiving its result is not enough that you need to write specialty Java \
code. The rest of this section will examine some of the special techniques \
that can be used.\
\>", "Text",
 CellTags->"jlug:5.3.18.3",
 CellID->31758]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Setting up Definitions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " When Your Class is Loaded"
}], "Subsection",
 CellTags->{"jlug:5.3.18.4", "TableOfContents_1.5.3.18.4"},
 CellID->12105],

Cell[TextData[{
 "Template entries in .tm files required by installable ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs written in C have two features that might appear to be lost in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". The first feature is the ability to specify arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to be evaluated when the program is first \
\[OpenCurlyDoubleQuote]installed.\[CloseCurlyDoubleQuote] This is done by \
using the ",
 StyleBox[":Evaluate:", "MR"],
 " line in a template entry. The second feature is the ability to specify the \
way in which the function is to be called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", including the name of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that maps to the C function, its argument sequence, how those \
arguments are mapped to the ones provided to the C function, and possibly \
some processing to be done on them before they are sent. This information is \
specified in the ",
 StyleBox[":Pattern:", "MR"],
 " and ",
 StyleBox[":Arguments:", "MR"],
 " lines of a template entry."
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->29621],

Cell[TextData[{
 "These two features are related to each other, because they both rely on the \
ability to specify ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code that is loaded when an external program is installed. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " gives you this ability and more, through two special methods called ",
 StyleBox["onLoadClass()", "MR"],
 " and ",
 StyleBox["onUnloadClass()", "MR"],
 ". When a class is loaded into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", either directly through ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " or indirectly by calling ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 ", it is examined to see if it has a method with the following signature:"
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->17095],

Cell["public static void onLoadClass(KernelLink ml);", "Program",
 CellTags->"jlug:5.3.18.4",
 CellID->7296],

Cell[TextData[{
 "If such a method is present, it will be called after all the method and \
field definitions for the class are set up in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Because a class can only be loaded once in a Java session, this method \
will only be called once in the lifetime of a single Java runtime, although \
it may be called more than once in the lifetime of a single ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel (because the user can repeatedly launch and quit the Java runtime). \
The ",
 StyleBox["KernelLink", "MR"],
 " that is provided as an argument to this method is of course the link back \
to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->9916],

Cell["\<\
A typical use for this feature would be to define the text for an error \
message issued by one of the methods in the class. Here is an example:\
\>", "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->15678],

Cell["\<\
public static void onLoadClass(KernelLink ml) throwsMathLinkException {
\tml.evaluate(\"MyClass::sun = \\\"The foo() method can only be called on \
Sunday.\\\"\");
\tml.discardAnswer();
}\
\>", "Program",
 CellTags->"jlug:5.3.18.4",
 CellID->10178],

Cell[TextData[{
 "Note that this method throws ",
 StyleBox["MathLinkException", "MR"],
 ". Your ",
 StyleBox["onLoadClass()", "MR"],
 " method can throw any exceptions you like (a ",
 StyleBox["MathLinkException", "MR"],
 " would be typical). This will not interfere with the matching of the \
expected signature for ",
 StyleBox["onLoadClass()", "MR"],
 ". If an exception is thrown during ",
 StyleBox["onLoadClass", "MR"],
 ", it will be handled gracefully, meaning that the normal operation of ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " will not be affected. The only exception to this rule is if your code \
throws an exception while it is interacting with the link to the kernel, and \
more specifically, in the period between the time that it sends a computation \
to the kernel and the time that it begins to read the result. In other words, \
exceptions you throw will not break the ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " mechanism, but it is up to you to make sure that you do not screw up the \
link\[CloseCurlyQuote]s state by starting something you do not finish."
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->13579],

Cell[TextData[{
 "Another reason to use ",
 StyleBox["onLoadClass()", "MR"],
 " would be if you wanted to create a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function for users to call that \[OpenCurlyDoubleQuote]wrapped\
\[CloseCurlyDoubleQuote] a static method call, providing it with a preferred \
name or argument sequence. If you have a class named ",
 StyleBox["MyClass", "MR"],
 " with the method ",
 StyleBox["public static void myMethod(double[a]", "MR"],
 "), the definition that will be automatically created for it in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will require that its argument be a list of real numbers or integers. Let\
\[CloseCurlyQuote]s say you want to add a definition named ",
 StyleBox["MyMethod", "MR"],
 ", having the traditional ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " capitalization, and you also want this function automatically to use ",
 StyleBox["N", "MR"],
 " on its argument so that it will work for anything that will ",
 StyleBox["evaluate",
  FontSlant->"Italic"],
 " to a list of numbers, such as ",
 StyleBox["{Pi, 2Pi, 3Pi}", "MR"],
 ". Here is how you would set up such an additional definition:"
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->25058],

Cell["\<\
public static void onLoadClass(KernelLink ml) throwsMathLinkException {
\tml.evaluate(\"MyMethod[x_] := myMethod[N[x]]\");
\tml.discardAnswer();
}\
\>", "Program",
 CellTags->"jlug:5.3.18.4",
 CellID->27577],

Cell[TextData[{
 "In other words, if you are not happy with the interface to the class that \
will automatically be created in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can use ",
 StyleBox["onLoadClass()", "MR"],
 " to set up the desired definitions without changing the Java interface."
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->12750],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " context that will be current when ",
 StyleBox["onLoadClass()", "MR"],
 " is called is the context in which all the class\[CloseCurlyQuote] static \
methods and fields are defined. That is why in the preceding example we made \
the definition for ",
 StyleBox["MyMethod", "MR"],
 " and not ",
 StyleBox["MyClass`MyMethod", "MR"],
 ". This is important since you cannot know the correct context in your Java \
code because it is determined by the user via the ",
 StyleBox["AllowShortContext", "MR"],
 " option to ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->14007],

Cell[TextData[{
 "It is generally not a good idea to use ",
 StyleBox["onLoadClass()", "MR"],
 " to send a lot of code to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This will make the behavior of your class hard for people to understand \
because the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code is hidden, and also inflexible since you would have to recompile it \
to make changes to the embedded ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. If you have a lot of code that needs to accompany a Java class, it \
is better to put that code into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package file that you or your users load. That is, rather than having \
users load a class that dumps a lot of code into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you should have your users load a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package that loads your class. This will provide the greatest flexibility \
for future changes and maintenance."
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->23729],

Cell[TextData[{
 "Finally, there is no reason why your ",
 StyleBox["onLoadClass()", "MR"],
 " method needs to restrict itself to making ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " calls. You could perform operations specific to the Java side, for \
example, writing some debugging information to the Java console window, \
opening a file for writing, or whatever else you desire."
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->24081],

Cell[TextData[{
 "Similar to the handling of the ",
 StyleBox["onLoadClass()", "MR"],
 " method, the ",
 StyleBox["onUnloadClass()", "MR"],
 " method is called when a class is unloaded. Every loaded class is unloaded \
automatically by ",
 Cell[BoxData[
  ButtonBox["UninstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFormula"],
 " right before it quits the Java runtime. You can use ",
 StyleBox["onUnloadClass()", "MR"],
 " to remove definitions created by ",
 StyleBox["onLoadClass()", "MR"],
 ", or perform any other clean-up you would like. The signature of ",
 StyleBox["onUnloadClass()", "MR"],
 " must be the following, although it can throw any exceptions:"
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->2995],

Cell["public static void onUnloadClass(KernelLink ml);", "Program",
 CellTags->"jlug:5.3.18.4",
 CellID->2678],

Cell[TextData[{
 "Note that the meaning of loading and unloading classes here refers to being \
loaded by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " either directly or indirectly. It does not refer to the loading and \
unloading of classes internally by the Java runtime. Class loading by the \
Java runtime occurs when the class is first used, which may have occurred \
long before ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " was called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->24676]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Manually Returning a Result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Subsection",
 CellTags->{"jlug:5.3.18.5", "TableOfContents_1.5.3.18.5"},
 CellID->27753],

Cell[TextData[{
 "The default behavior of a Java method called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is to return to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " exactly what the method itself returns. There are times, however, when you \
want to return something else. For example, you might want to return an \
integer in some circumstances, and a symbol in others. Or you might want a \
method to return one thing when it is being called from Java, and return \
something different to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In these cases, you will need to manually send a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " before the method returns."
}], "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->20899],

Cell[TextData[{
 "Say you are writing a file-reading class that you want to call from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Because you want almost the identical behavior to the standard class ",
 StyleBox["java.io.FileInputStream", "MR"],
 ", your class will be a subclass of it. The only changes you want to make \
are to provide some more ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-like behavior. One example is that you want the ",
 StyleBox["read", "MR"],
 " method to return not -1 when it reaches the end of the file, but rather \
the symbol ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndOfFile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EndOfFile"], "MR"]], "InlineFormula"],
 ", which is what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s built-in file-reading functions return."
}], "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->11784],

Cell["\<\
import java.io.*;
import com.wolfram.jlink.*;

public class MyFileReader extends FileInputStream {

\t<<constructors, other methods deleted>>

\tpublic int read() {

\t\tint i = super.read();
\t\tif (i == -1) {
\t\t\tKernelLink link = StdLink.getLink();
\t\t\tif (link != null) {
\t\t\t\tlink.beginManual();
\t\t\t\ttry {
\t\t\t\t\tlink.putSymbol(\"EndOfFile\");
\t\t\t\t} catch (MathLinkException e) {}
\t\t\t}
\t\t}
\t\treturn i;
\t}
}\
\>", "Program",
 CellTags->"jlug:5.3.18.5",
 CellID->15565],

Cell[TextData[{
 "If the file has reached the end, ",
 StyleBox["i", "MR"],
 " will be -1, and we want to manually return something to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The first thing we need to do is get a ",
 StyleBox["KernelLink", "MR"],
 " object that can be used to communicate with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This is obtained by calling the static method ",
 StyleBox["StdLink.getLink()", "MR"],
 ". If you have written installable ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs in C, you will recognize the choice of names here. A C program \
has a global variable named stdlink that holds the link back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has a ",
 StyleBox["StdLink", "MR"],
 " class that has a few methods related to this link object."
}], "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->294743168],

Cell[TextData[{
 "The first thing we do is check whether ",
 StyleBox["getLink()", "MR"],
 " returns ",
 StyleBox["null", "MR"],
 ". It will never be ",
 StyleBox["null", "MR"],
 " if the method is being called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", so we can use this test to determine whether the method is being called \
from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or as part of a normal Java program. In this way, we can have a method \
that can be used from Java in the usual way when a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is nowhere in sight. The ",
 StyleBox["getLink()", "MR"],
 " call works no matter if the method is called directly from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", or indirectly as part of a chain of methods triggered by a call from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->13608],

Cell[TextData[{
 "Once we have verified that a link back to the kernel exists, the first \
thing we do is inform ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " that we will be sending the result back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ourselves, so it should not try automatically to send the method\
\[CloseCurlyQuote]s return value. This is accomplished by calling the ",
 StyleBox["beginManual()", "MR"],
 " method on the ",
 StyleBox["KernelLink", "MR"],
 " object. "
}], "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->6172],

Cell[TextData[{
 "You ",
 StyleBox["must",
  FontSlant->"Italic"],
 " call ",
 StyleBox["beginManual()", "MR"],
 " before you send any part of a result back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you fail to do this, the link will get out of sync and the next ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " call you make from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will probably hang. It is safe to call ",
 StyleBox["beginManual()", "MR"],
 " more than once, so you do not have to worry that your method might be \
called from another method that has already called ",
 StyleBox["beginManual()", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->11243],

Cell[TextData[{
 "Returning to the example program, the next thing after ",
 StyleBox["beginManual()", "MR"],
 " is to make the required \
\[OpenCurlyDoubleQuote]put\[CloseCurlyDoubleQuote]-type calls to send the \
result back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (in this case, just a single ",
 StyleBox["putSymbol()", "MR"],
 "). As always, these calls can throw a ",
 StyleBox["MathLinkException", "MR"],
 ", so we need to wrap them in a ",
 StyleBox["try/catch", "MR"],
 " block. The ",
 StyleBox["catch", "MR"],
 " handler is empty, since there really is not anything to do in the unlikely \
event of a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " error. The internal ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " code that wraps all method calls will handle the cleanup and recovery from \
any ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " error that might have occurred calling ",
 StyleBox["putSymbol()", "MR"],
 ". You do not need to do anything for ",
 StyleBox["MathLinkExceptions", "MR"],
 " that occur while you are putting a result manually. The method call will \
return ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Failed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Failed"], "MR"]], "InlineFormula"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically."
}], "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->29929],

Cell[TextData[{
 "Installable programs written in C can also manually send results back. This \
is indicated by using the ",
 StyleBox["Manual", "MR"],
 " keyword in the function\[CloseCurlyQuote]s template entry. Thus for C \
programs the manual/automatic decision must be made at compile time, whereas \
with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " it is a runtime switch. We can have it both ways with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[LongDash]a normal automatic return in some circumstances and a manual \
return in others, as the preceding example demonstrates."
}], "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->7514]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Requesting Evaluations by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Subsection",
 CellTags->{"jlug:5.3.18.6", "TableOfContents_1.5.3.18.6"},
 CellID->10168],

Cell[TextData[{
 "So far, we have seen only cases where a Java method has a very simple \
interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It is called and returns a result, either automatically or manually. \
There are many circumstances, however, where you might want to have a more \
complex interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You might want a message to appear in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", or some ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " output, or you might want to have ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluate something and return the answer to you. This is a completely \
separate issue from what you want to return to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " at the ",
 StyleBox["end",
  FontSlant->"Italic"],
 " of your method\[LongDash]you can request evaluations from the body of a \
method whether it returns its final result manually or not."
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->5055],

Cell[TextData[{
 "In some sense, when we perform this type of interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " we are turning the tables on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", reversing the \[OpenCurlyDoubleQuote]master\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]slave\[CloseCurlyDoubleQuote] roles for a moment. When \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calls into Java, the Java code is acting as the slave, performing a \
computation and returning control to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In the middle of a Java method, however, we can call back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", temporarily turning it into a computational server for the Java side. \
Thus we would expect to encounter essentially all the same issues that are \
discussed in ",
 ButtonBox["Writing Java Programs that use ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
  FontSlant->"Italic"],
 ", and we would need to understand the full ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " Java-side API."
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->11191],

Cell[TextData[{
 "The full treatment of the ",
 StyleBox["MathLink", "MR"],
 " and ",
 StyleBox["KernelLink", "MR"],
 " interfaces is presented in ",
 ButtonBox["Writing Java Programs that Use ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
  FontSlant->"Italic"],
 ". In this section we will discuss a few special methods in ",
 StyleBox["KernelLink", "MR"],
 " that are specifically for use by \[OpenCurlyDoubleQuote]installed\
\[CloseCurlyDoubleQuote] methods. We have already seen one, the ",
 StyleBox["beginManual()", "MR"],
 " method. Now we will treat the ",
 StyleBox["message()", "MR"],
 ", ",
 StyleBox["print()", "MR"],
 ", and ",
 StyleBox["evaluate()", "MR"],
 " methods."
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->5973],

Cell[TextData[{
 "The task of issuing a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " message from a Java method and triggering some ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output are so commonly done that the ",
 StyleBox["KernelLink", "MR"],
 " interface has special methods for these operations. The method ",
 StyleBox["message()", "MR"],
 " performs all the steps of issuing a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " message. It comes in two signatures:"
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->8922],

Cell["\<\
public void message(String symtag, String arg);
public void message(String symtag, String[] args);\
\>", "Program",
 CellTags->"jlug:5.3.18.6",
 CellID->6748],

Cell[TextData[{
 "The first form is for when you just have a single string argument to be \
slotted into the message text, and the second form is for if the message text \
needs two or more arguments. You can pass ",
 StyleBox["null", "MR"],
 " as the second argument if the message text needs no arguments."
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->5651],

Cell[TextData[{
 "The ",
 StyleBox["print()", "MR"],
 " method performs all the steps necessary to invoke ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " function:"
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->10986],

Cell["public void print(String s);", "Program",
 CellTags->"jlug:5.3.18.6",
 CellID->2144],

Cell[TextData[{
 "Here is an example method that uses both. Assume that the following \
messages are defined in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (this could be from loading a package or during this class\
\[CloseCurlyQuote] ",
 StyleBox["onLoadClass()", "MR"],
 " method):"
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->16446],

Cell[TextData[StyleBox["Foo::arg = \"The `1` argument to foo must be greater \
than or equal to 0.\"", "MR"]], "Program",
 CellTags->"jlug:5.3.18.6",
 CellID->31577],

Cell["Here is the Java code:", "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->26517],

Cell["\<\
public static double foo(double x, double y) {

\tKernelLink link = StdLink.getLink();
\tif (link != null) {
\t\tlink.print(\"inside foo\");
\t\tif (x < 0) 
\t\t\tlink.message(\"Foo::arg\", \"first\");
\t\tif (y < 0) 
\t\t\tlink.message(\"Foo::arg\", \"second\");
\t}
\treturn Math.sqrt(x) * Math.sqrt(y);
}\
\>", "Program",
 CellTags->"jlug:5.3.18.6",
 CellID->14629],

Cell[TextData[{
 "Note that ",
 StyleBox["print()", "MR"],
 " and ",
 StyleBox["message()", "MR"],
 " send the required code to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and also read the result from the link (it will always be the symbol ",
 StyleBox["Null", "MR"],
 "). They do not throw ",
 StyleBox["MathLinkException", "MR"],
 " so you do not have to wrap them in ",
 StyleBox["try/catch", "MR"],
 " blocks."
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->29916],

Cell[TextData[{
 "Here is what happens when we call ",
 StyleBox["foo()", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->5874],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadJavaClass", "[", 
   RowBox[{"\"\<MyClass\>\"", ",", 
    RowBox[{"StaticsVisible", "\[Rule]", "True"}]}], "]"}], ";"}], "\n", 
 RowBox[{"foo", "[", 
  RowBox[{"1.0", ",", 
   RowBox[{"-", "2.0"}]}], "]"}]}], "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.18.6",
 CellID->15791],

Cell[BoxData[
 RowBox[{"inside", " ", "foo"}]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"jlug:5.3.18.6",
 CellID->15469],

Cell[BoxData[
 RowBox[{"Foo", "::", 
  RowBox[{"arg", ":", 
   RowBox[{
   "The", " ", "second", " ", "argument", " ", "to", " ", "foo", " ", "must", 
    " ", "be", " ", "greater", " ", "than", " ", "or", " ", "equal", " ", 
    "to", " ", "0."}]}]}]], "Message", "MSG",
 CellTags->"jlug:5.3.18.6",
 CellID->22912],

Cell[BoxData[
 StyleBox["Indeterminate", "MR"]], "Output",
 CellTags->"jlug:5.3.18.6",
 CellID->8146]
}, Open  ]],

Cell[TextData[{
 "Note that you automatically get ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Indeterminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Indeterminate"], "MR"]], "InlineFormula"],
 " returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when a floating-point result from Java is NaN \
(\[OpenCurlyDoubleQuote]Not-a-Number\[CloseCurlyDoubleQuote])."
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->30693],

Cell[TextData[{
 "The methods ",
 StyleBox["print()", "MR"],
 " and ",
 StyleBox["message()", "MR"],
 " are convenience functions for two special cases of the more general notion \
of sending intermediate evaluations to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " before your method returns a result. The general means of doing this is to \
wrap whatever you send to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 ", which is a signal to the kernel that this is not the final result, but \
rather something that it should evaluate and send the result back to Java. \
You can explicitly send the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 " head, or you can use one of the methods in ",
 StyleBox["KernelLink", "MR"],
 " that use ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 " for you. These methods are:"
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->9091],

Cell[BoxData[{
 RowBox[{
  RowBox[{"void", " ", "evaluate", 
   RowBox[{"(", 
    RowBox[{"String", " ", "s"}], ")"}], " ", "throws", " ", 
   "MathLinkException"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"String", " ", "evaluateToInputForm", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"String", " ", "s"}], ",", 
     RowBox[{"int", " ", "pageWidth"}]}], ")"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"String", " ", "evaluateToOutputForm", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"String", " ", "s"}], ",", 
     RowBox[{"int", " ", "pageWidth"}]}], ")"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"byte", "[", "]"}], " ", "evaluateToImage", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"String", " ", "s"}], ",", 
     RowBox[{"int", " ", "width"}], ",", 
     RowBox[{"int", " ", "height"}]}], ")"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"byte", "[", "]"}], " ", "evaluateToTypeset", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"String", " ", "s"}], ",", 
     RowBox[{"int", " ", "pageWidth"}], ",", 
     RowBox[{"boolean", " ", "useStdForm"}]}], ")"}]}], ";"}]}], "DisplayMath",\

 CellTags->"jlug:5.3.18.6",
 CellID->9815],

Cell[TextData[{
 "These methods are discussed in ",
 ButtonBox["Writing Java Programs that use ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#15141"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#15141"],
  FontSlant->"Italic"],
 " (actually, they also come in several more flavors with other argument \
sequences). Here is a simple example:"
}], "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->26949],

Cell["\<\
public static double foo(double x, double y) {

\tKernelLink link = StdLink.getLink();
\tif (link != null) {
\t\ttry {
\t\t\tlink.evaluate(\"2+2\");
\t\t\t// Wait for, and then read, the answer.
\t\t\tlink.waitForAnswer();
\t\t\tint sum1 = link.getInteger();
\t\t\t
\t\t\t// evaluateToOutputForm makes the result come back as a
\t\t\t// string formatted in OutputForm, and all in one step
\t\t\t// (no waitForAnswer call needed).
\t\t\tString s = link.evaluateToOutputForm(\"3+3\");
\t\t\tint sum2 = Integer.parseInt(s);

\t\t\t// If you want, put the whole evaluation piece by piece,
\t\t\t// including the EvaluatePacket head.
\t\t\tlink.putFunction(\"EvaluatePacket\");
\t\t\tlink.putFunction(\"Plus\", 2);
\t\t\tlink.put(4);
\t\t\tlink.put(4);
\t\t\tlink.waitForAnswer();
\t\t\tint sum3 = link.getInteger();
\t\t} catch (MathLinkException e) {
\t\t\t// The only type of mathlink error we are likely to get
\t\t\t// is from a \"get\" function when what we are trying to
\t\t\t// get is not the type of expression that is waiting. We
\t\t\t// just clear the error state, throw away the packet we
\t\t\t// are reading, and let the method finish normally.
\t\t\tlink.clearError();
\t\t\tlink.newPacket();
\t\t}
\t}
\treturn Math.sqrt(x) * Math.sqrt(y);
}
\
\>", "Program",
 CellTags->"jlug:5.3.18.6",
 CellID->26857]
}, Open  ]],

Cell[CellGroupData[{

Cell["Throwing Exceptions", "Subsection",
 CellTags->{"jlug:5.3.18.7", "TableOfContents_1.5.3.18.7"},
 CellID->20640],

Cell[TextData[{
 "Any exceptions that your method throws will be handled gracefully by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", resulting in the printing of a message in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " describing the exception. This was discussed in ",
 ButtonBox["How Exceptions are Handled",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#32525"],
 ". If you are sending computations to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as described in the previous section, you need to make sure that an \
exception does not interrupt your code unexpectedly. In other words, if you \
start a transaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", make sure you complete it or you will leave the link out of sync and \
future calls to Java will probably hang."
}], "Text",
 CellTags->"jlug:5.3.18.7",
 CellID->26052]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making a Method Interruptible", "Subsection",
 CellTags->{"jlug:5.3.18.8", "TableOfContents_1.5.3.18.8"},
 CellID->236],

Cell[TextData[{
 "If you are writing a method that may take a while to complete, you should \
consider making it interruptible from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs, a global variable named ",
 StyleBox["MLAbort", "MR"],
 " is provided for this purpose. In ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programs, you call the ",
 StyleBox["wasInterrupted()", "MR"],
 " method in the ",
 StyleBox["KernelLink", "MR"],
 " interface:"
}], "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->8551],

Cell["public boolean wasInterrupted();", "Program",
 CellTags->"jlug:5.3.18.8",
 CellID->9487],

Cell[TextData[{
 "Here is an example method that performs a long computation, checking every \
100 iterations whether the user tried to abort it (using the ",
 StyleBox[ButtonBox["Interrupt Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/InterruptEvaluation"], "MenuName"],
 " or ",
 StyleBox[ButtonBox["Abort Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AbortEvaluation"], "MenuName"],
 " commands in the ",
 StyleBox["Evaluation", "MenuName"],
 " menu)."
}], "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->31226],

Cell["\<\
public int foo() {

\tKernelLink link = StdLink.getLink();
\tfor (int i = 0; i < 10000, i++) {
\t\t... perform one step ...
\t\tif (i % 100 == 0 && link.wasInterrupted())
\t\t\treturn 0;  // Return value will not be seen by Mathematica.
\t}
\treturn 42;
}\
\>", "Program",
 CellTags->"jlug:5.3.18.8",
 CellID->28162],

Cell[TextData[{
 "This method returns 0 if it detects an attempt by the user to abort, but \
this value will never be seen by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This is because ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " causes a method or constructor call that is aborted to return ",
 StyleBox["Abort[]", "MR"],
 ", whether or not you detect the abort in your code. Therefore, if you \
detect an abort and want to honor the user\[CloseCurlyQuote]s request, just \
return some value right away. When ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " returns ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"], "MR"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 ", the user\[CloseCurlyQuote]s entire computation is aborted, just as if the \
",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"], "MR"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 " was embedded in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. This means that you don\[CloseCurlyQuote]t have to be concerned with \
any details of propagating the abort back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[LongDash]all you have to do is return prematurely if you detect an abort \
request, and the rest is handled for you."
}], "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->16955],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " makes no distinction between an interrupt request and an abort request; \
they each cause ",
 StyleBox["wasInterrupted()", "MR"],
 " to return ",
 StyleBox["true", "MR"],
 ". Recall that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has separate commands for interrupting and aborting computations. The \
\[OpenCurlyDoubleQuote]Abort\[CloseCurlyDoubleQuote] operation (",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["-", "KeyEvent"],
 ". on Windows) causes the entire computation to end as soon as possible and \
return ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Aborted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Aborted"], "MR"]], "InlineFormula"],
 ". The \[OpenCurlyDoubleQuote]Interrupt\[CloseCurlyDoubleQuote] operation \
(",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["-", "KeyEvent"],
 ", on Windows) brings up a dialog box with further choices. If this \
Interrupt dialog box is triggered when a Java method is executing, it has a \
different set of buttons than when normal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code is executing. One of the options is ",
 StyleBox["Send Abort to Linked Program", "SR"],
 " and another is ",
 StyleBox["Send Interrupt to Linked Program", "SR"],
 ". Both of these choices have the same effect for Java methods, which is to \
cause ",
 StyleBox["wasInterrupted()", "MR"],
 " to return ",
 StyleBox["true", "MR"],
 " and the call to return ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"], "MR"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 " when it completes. The third button is ",
 StyleBox["Kill Linked Program", "SR"],
 ", which will cause the Java runtime to quit. If you call a Java method that \
is not interruptible, killing the Java runtime in this way is the only way to \
make the method call terminate (you can also kill the Java runtime using \
process control features of your operating system)."
}], "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->23183],

Cell[TextData[{
 "Sometimes you might want a Java method to detect an abort and do something \
other than cause the entire ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " computation to abort. For example, you might want a loop to stop and \
return its results up to that point. Note that this is not generally \
recommended. Users expect a program to abort and return ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Aborted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Aborted"], "MR"]], "InlineFormula"],
 " when they issue an abort request. In some cases, however, especially if \
the code is not intended for use by a large community, you might find it \
useful to use an abort as a \[OpenCurlyDoubleQuote]message\
\[CloseCurlyDoubleQuote] to communicate some information to your Java code \
instead of just having the computation aborted. This idea is similar to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CheckAbort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CheckAbort"], "MR"]], "InlineFormula"],
 " function, which allows you to detect an abort and absorb it so that it \
does not propagate further and abort the entire computation. To \
\[OpenCurlyDoubleQuote]absorb\[CloseCurlyDoubleQuote] the abort in your Java \
code so that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " does not return ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"], "MR"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 ", simply call the ",
 StyleBox["clearInterrupt()", "MR"],
 " method:"
}], "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->8394],

Cell["public void clearInterrupt();", "Program",
 CellTags->"jlug:5.3.18.8",
 CellID->30180],

Cell["Here is an example:", "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->16097],

Cell["\<\
public int foo() {

\tKernelLink link = StdLink.getLink();
\tfor (int i = 0; i < 10000, i++) {
\t\t... perform one step ...
\t\tif (i % 100 == 0 && link.wasInterrupted()) {
\t\t\tlink.clearInterrupt();
\t\t\treturn resultSoFar; // This is the value that will be returned to \
Mathematica
\t\t}
\t}
\t...
\treturn 42;
}\
\>", "Program",
 CellTags->"jlug:5.3.18.8",
 CellID->3065]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing Your Own Event Handler Code", "Subsection",
 CellTags->{"jlug:5.3.18.9", "TableOfContents_1.5.3.18.9"},
 CellID->27065],

Cell[TextData[{
 ButtonBox["Handling Events with ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2421"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2421"],
  FontSlant->"Italic"],
 ButtonBox[" Code: The \[OpenCurlyDoubleQuote]MathListener\
\[CloseCurlyDoubleQuote] Classes",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2421"],
 " introduced the topic of triggering calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a response to events fired in Java, such as clicking a button. A set of \
",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 "-derived classes is provided by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " for this purpose. You are not required to use the provided ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " classes, of course. You can write your own classes to handle events and \
put calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directly into their code. All the event handler classes in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " are derived from the abstract base class ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 ", which takes care of all of the details of interacting with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and also provides the ",
 StyleBox["setHandler()", "MR"],
 " methods that you use to associate events with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. Users who want to write their own ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 "-style classes (for example, for one of the Swing-specific event listener \
interfaces, which ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " does not provide) are strongly encouraged to make their classes subclasses \
of ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " to inherit all this functionality. You should examine the source code for \
",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 ", and also one of the concrete classes derived from it (",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 " is probably the simplest one) to see how it is written. You can use this \
as a starting point for your own implementation."
}], "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->2513],

Cell[TextData[{
 "There is a new feature of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0 that should be pointed out in this context. This is the ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, which lets you implement any Java interface entirely in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 " is described in more detail in ",
 ButtonBox["Implementing a Java Interface with ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7619"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7619"],
  FontSlant->"Italic"],
 ButtonBox[" Code",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7619"],
 ", but a common use for it would be to create event-handler classes that \
implement a \[OpenCurlyDoubleQuote]Listener\[CloseCurlyDoubleQuote]-type \
interface for which ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " does not have a built-in ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 ". This is discussed in more detail in the section on ",
 Cell[BoxData[
  ButtonBox["ImplementJavaInterface",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], "InlineFormula"],
 ", and if you choose this technique, then you do not have to worry about any \
of the issues in this section because they are handled for you."
}], "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->9261],

Cell[TextData[{
 "If you are going to write a Java class, and you choose not to derive your \
class from ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 ", there are two very important rules that ",
 StyleBox["must",
  FontSlant->"Italic"],
 " be adhered to when writing event-handler code that calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". To be more precise, these rules apply whenever you are writing code that \
needs to call into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " at a point when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is not currently calling into Java. That may sound confusing, but it is \
really very simple. An earlier ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#10168"],
 " showed how to request evaluations by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from within a Java method. In this case, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has called your Java method, and while ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is waiting for the result, your code calls back to perform some \
computation. This works fine as described in that earlier section, because at \
the point the code calls back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is in the middle of a call to Java. This is a true \
\[OpenCurlyDoubleQuote]callback\[CloseCurlyDoubleQuote]",
 StyleBox["\[LongDash]Mathematica",
  FontSlant->"Italic"],
 " has called Java, and during the handling of this call, Java calls back to \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In contrast, consider the case where some Java code executes in response \
to a button click. When the button click event fires, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is probably not in the middle of a call to Java."
}], "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->12578],

Cell[TextData[{
 "Special considerations are necessary in the latter case because there are \
two threads in the Java runtime that are using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". The first one is created and used by the internals of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to handle standard calls into Java originating in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as described throughout this tutorial. The second one is the Java user \
interface thread (sometimes called the AWT thread), which is the one on which \
your event handler code will be called. You need to make sure that your use \
of the link back to the kernel on the user interface thread does not \
interfere with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s internal thread."
}], "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->21078],

Cell[TextData[{
 "The code below shows an idealized version of the ",
 StyleBox["actionPerformed()", "MR"],
 " method in the ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 " class. The actual code in ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 " is different, because this work is farmed out to the parent class, ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 ", but this example shows the correct flow of operations. This is the code \
that is executed when the associated object\[CloseCurlyQuote]s action occurs \
(like a button click). "
}], "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->16878],

Cell["\<\
public void actionPerformed(ActionEvent e) { 
\tKernelLink ml = StdLink.getLink();  \t
\tStdLink.requestTransaction();
\tsynchronized (ml) {
\t\ttry {
\t\t\t// Send the code to perform the user's requested operation.
\t\t\tml.putFunction(\"EvaluatePacket\", 1);
\t\t\t... code to put rest of expression to evaluate goes here ...
\t\t\tml.endPacket();
\t\t\tml.discardAnswer();
\t\t} catch (MathLinkException exc) {
\t\t\t...
\t\t}
\t}
}\
\>", "Program",
 CellTags->"jlug:5.3.18.9",
 CellID->14140],

Cell[TextData[{
 "The first rule to note in this code is that the complete transaction with \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", which includes sending the code to evaluate and completely reading the \
result, is wrapped in a ",
 StyleBox["synchronized(ml)", "MR"],
 " block. This is how you ensure that the user interface thread has exclusive \
access to the link for the entire transaction. The second rule is that the ",
 StyleBox["synchronized(ml)", "MR"],
 " statement must be preceded by a call to ",
 StyleBox["StdLink.requestTransaction()", "MR"],
 ". This call will block until the kernel is at a point where it is ready to \
accommodate evaluations originating in Java. The call must occur before the \
",
 StyleBox["synchronized(ml)", "MR"],
 " block begins, and once you call it you must make sure that you send \
something to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In other words, when ",
 StyleBox["requestTransaction()", "MR"],
 " returns, the kernel will be blocking in an attempt to read from the Java \
link. The kernel will be stuck in this state until you send it something, so \
you must protect against a Java exception being thrown after you call ",
 StyleBox["requestTransaction()", "MR"],
 " but before you send anything. Typically you will do this simply by calling \
",
 StyleBox["requestTransaction()", "MR"],
 " immediately before the ",
 StyleBox["synchronized(ml)", "MR"],
 " block begins and you start sending something."
}], "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->4611],

Cell[TextData[{
 "It was just said that ",
 StyleBox["StdLink.requestTransaction()", "MR"],
 " will block until the kernel is ready to accept evaluations originating in \
Java. To be specific, it will block until one of the following conditions \
occurs:"
}], "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->31947],

Cell[TextData[{
 "   \[FilledSmallSquare]  ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " executes ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"]
}], "BulletText",
 CellTags->"jlug:5.3.18.9",
 CellID->2445],

Cell[TextData[{
 "   \[FilledSmallSquare]  ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " executes ",
 StyleBox["ServiceJava", "MR"]
}], "BulletText",
 CellTags->"jlug:5.3.18.9",
 CellID->170],

Cell[TextData[{
 "   \[FilledSmallSquare]  ",
 "Kernel sharing has been turned on via ",
 StyleBox["ShareKernel", "MR"],
 " or ",
 StyleBox["ShareFrontEnd", "MR"],
 ", and the kernel is not busy with another computation"
}], "BulletText",
 CellTags->"jlug:5.3.18.9",
 CellID->29975],

Cell[TextData[{
 "   \[FilledSmallSquare]  ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is already in the middle of a call to Java"
}], "BulletText",
 CellTags->"jlug:5.3.18.9",
 CellID->13489],

Cell[TextData[{
 "   \[FilledSmallSquare]  ",
 "Java is not being used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " has not been called)"
}], "BulletText",
 CellTags->"jlug:5.3.18.9",
 CellID->24750],

Cell[TextData[{
 "These conditions should make sense given the discussion about creating user \
interface elements in the section ",
 ButtonBox["Creating Windows and Other User Interface Elements",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4596"],
 ". ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ", ",
 StyleBox["ShareKernel", "MR"],
 ", and ",
 StyleBox["ServiceJava", "MR"],
 " are the three ways in which you direct the kernel\[CloseCurlyQuote]s \
attention to the Java link so that it can detect incoming request for \
computations."
}], "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->6149],

Cell[TextData[{
 "If you make the common mistake of inadvertently triggering a call to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from Java before you have called ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " or ",
 StyleBox["ShareKernel", "MR"],
 ", the Java user interface thread will hang. This can be easily remedied by \
calling ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ", ",
 StyleBox["ShareKernel", "MR"],
 ", or ",
 StyleBox["ServiceJava", "MR"],
 " afterwards (",
 StyleBox["ServiceJava", "MR"],
 " may need to be called more than once, if more than one event callback is \
queued up)."
}], "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->3333],

Cell[TextData[{
 "If the rule about when it is necessary to use ",
 StyleBox["StdLink.requestTransaction()", "MR"],
 " and ",
 StyleBox["synchronized(ml)", "MR"],
 " is confusing, you will be happy to learn that it is fine to use these \
constructs in any code that calls ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In code that does not need them, they are pointless, but harmless, and \
will not cause the calling thread to block. If you are writing a Java method \
that needs to call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and there is any chance that it might be called from the user interface \
thread, add the ",
 StyleBox["StdLink.requestTransaction()", "MR"],
 " and ",
 StyleBox["synchronized(ml)", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->13865]
}, Open  ]],

Cell[CellGroupData[{

Cell["Debugging Your Java Classes", "Subsection",
 CellTags->{"jlug:5.3.18.10", "TableOfContents_1.5.3.18.10"},
 CellID->22214],

Cell[TextData[{
 "You can use your favorite debugger to debug Java code that is called from \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The only issue is that you typically have to launch a Java program inside \
the debugger to do this. The Java program that you need to launch is the one \
that is normally launched for you when you call ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 ". The class that contains ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 StyleBox["main()", "MR"],
 " method is ",
 StyleBox["com.wolfram.jlink.Install", "MR"],
 ". Thus, the command line to start ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " that is executed internally by ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " is typically"
}], "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->17282],

Cell["java -classpath /path/to/JLink.jar com.wolfram.jlink.Install", "Program",
 CellTags->"jlug:5.3.18.10",
 CellID->27007],

Cell[TextData[{
 "There may be additions or modifications to this depending on the options to \
",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 ", and also some extra ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-specific arguments are tacked on at the end. To use a debugger, you just \
have to launch Java with the appropriate command-line arguments that allow \
you to establish the link to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " manually."
}], "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->27432],

Cell[TextData[{
 "If you use a development environment that has an integrated debugger, then \
the debugger probably has a setting for the main class to use (the class \
whose ",
 StyleBox["main()", "MR"],
 " method will be invoked) and a setting for command-line arguments. For \
example, in WebGain Visual Caf\[EAcute], you can set these values in the ",
 StyleBox["Project", "SR"],
 " panel of the ",
 StyleBox["Project/Options", "SR"],
 " dialog. Set the main class to be ",
 StyleBox["com.wolfram.jlink.Install", "MR"],
 ", and the arguments to be something like this:"
}], "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->8896],

Cell["\<\
(On Windows:)
-linkmode listen -linkname foo           

(On Unix/Linux:)
-linkmode listen -linkprotocol tcp -linkname 1234\
\>", "Program",
 CellTags->"jlug:5.3.18.10",
 CellID->16367],

Cell[TextData[{
 "Then start the debugging session. You should see the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " copyright notice printed and then Java will wait for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to connect. To do this, go to your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, make sure the ",
 StyleBox["JLink.m", "MR"],
 " package has been read in, and execute:"
}], "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->28522],

Cell["\<\
(* On Windows: *)
ReinstallJava[LinkConnect[\"foo\"]]

(* On Unix: *)
ReinstallJava[LinkConnect[\"1234\", LinkProtocol -> \"TCP\"]]\
\>", "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.18.10",
 CellID->4882],

Cell[TextData[{
 "This works because ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 " can take a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkObject"], "MR"]], "InlineFormula"],
 " as its argument, in which case it will not try to launch Java itself. This \
allows you to manually establish the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection between Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then feed that link to ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 " and let it do the rest of the work of preparing the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java sides for interacting with each other."
}], "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->31810],

Cell["\<\
If you like to use a command-line debugger like jdb, you can do the \
following:\
\>", "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->17641],

Cell["\<\
C:\\>jdb
Initializing jdb...
> run com.wolfram.jlink.Install -linkmode listen -linkname foo
running ...
main[1] J/Link (tm)
Copyright (C) 1999-2000, Wolfram Research, Inc. All Rights Reserved.
www.wolfram.com
Version 1.1

Current thread \"main\" died. Execution continuing...
>\
\>", "Program",
 CellTags->"jlug:5.3.18.10",
 CellID->7231],

Cell[TextData[{
 "The message about the main thread dying is normal. Now jdb is ready for \
commands. First, though, you have to execute in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkConnect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkConnect"], "MR"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 " lines shown earlier. This example was for Windows, so Unix users will have \
to adjust the ",
 StyleBox["run", "MR"],
 " line to reflect the proper arguments:"
}], "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->2187],

Cell["\<\
> run com.wolfram.jlink.Install -linkmode listen -linkprotocol tcp -linkname \
1234\
\>", "Program",
 CellTags->"jlug:5.3.18.10",
 CellID->6705]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Deploying Applications that use ",
 StyleBox["J/Link",
  FontSlant->"Italic"]
}], "Section",
 CellTags->{"jlug:5.3.19.0", "TableOfContents_1.5.3.19"},
 CellID->17189],

Cell[TextData[{
 "This section discusses some issues relevant to developers who are creating \
add-ons for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that use ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->19976],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " uses its own custom class loader that allows it to find classes in a set \
of locations beyond the startup class path. As described in ",
 ButtonBox["Dynamically Modifying the Class Path",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#11323"],
 ", users can grow this set of extra locations to search for classes by \
calling the ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 " function. One of the motivations for having a custom class loader was to \
make it easy for application developers to distribute applications that have \
parts of their implementation in Java. If you structure your application \
directory properly, your users will be able to install it simply by copying \
it into any standard location for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " will be able to find your Java classes immediately, without users having \
to perform any classpath-related operations or even restart Java. "
}], "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->31329],

Cell[TextData[{
 "If your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application uses ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " and includes its own Java components, you should create a ",
 StyleBox["Java", "MR"],
 " subdirectory in your application directory. You can place any jar files \
that your application needs into this ",
 StyleBox["Java", "MR"],
 " subdirectory. If you have loose class files (not bundled into a jar file), \
they should go into an appropriately nested subdirectory of the ",
 StyleBox["Java", "MR"],
 " directory. \[OpenCurlyDoubleQuote]Appropriately nested\
\[CloseCurlyDoubleQuote] means that if your class is in the Java package ",
 StyleBox["com.somecompany.math", "MR"],
 ", then its class file goes into the ",
 StyleBox["com/somecompany/math", "MR"],
 " subdirectory of the ",
 StyleBox["Java", "MR"],
 " directory. If the class is not in any package, it can go directly into the \
",
 StyleBox["Java", "MR"],
 " directory. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " can also find native libraries and resources your application needs. \
Native libraries must be in a subdirectory of your ",
 StyleBox["Java/Libraries", "MR"],
 " directory that is named after the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SystemID",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SystemID"], "MR"]], "InlineFormula"],
 " of the platform on which it is installed. Here is an example directory \
structure for an application that uses ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->2368],

Cell["\<\
\t\tMyApp/
\t\t\t... other files and directories used by the application ...
\t\t\tJava/
\t\t\t\tMyAppClasses.jar
\t\t\t\tMyImage.gif
\t\t\t\tLibraries/
\t\t\t\t\tWindows/
\t\t\t\t\t\tMyNativeLibrary.dll
\t\t\t\t\tPowerMac/
\t\t\t\t\t\tMyNativeLibrary
\t\t\t\t\tDarwin/
\t\t\t\t\t\tlibMyNativeLibrary.jnilib
\t\t\t\t\tLinux/
\t\t\t\t\t\tlibMyNativeLibrary.so
\t\t\t\t\t... and so on for other Unix platforms\t\t\t\t\t\t\t\
\>", "Program",
 CellTags->"jlug:5.3.19.0",
 CellID->28692],

Cell[TextData[{
 "Your application directory must be placed into one of the standard \
locations for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications. These locations are listed below. In this notation, ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 StyleBox["/AddOns/Applications", "MR"],
 " means \[OpenCurlyDoubleQuote]The ",
 StyleBox["AddOns/Applications", "MR"],
 " subdirectory of the directory whose value is given by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " variable ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["$InstallationDirectory", "MR"],
    BaseStyle->"Link"], "MR"]], "InlineFormula"],
 ".\[CloseCurlyDoubleQuote]\n\t",
 Cell[BoxData[
  StyleBox["$UserAddOnsDirectory", "MR"]], "InlineCode"],
 StyleBox["/Applications         [", "MR"],
 StyleBox["Mathematica", "MR",
  FontSlant->"Italic"],
 " 4.2 and later only]\n\t",
 StyleBox["$AddOnsDirectory/Applications             [", "MR"],
 StyleBox["Mathematica", "MR",
  FontSlant->"Italic"],
 " 4.2 and later only]\n\t",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InstallationDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$InstallationDirectory"], "MR"]], 
  "InlineFormula"],
 StyleBox["/AddOns/Applications", "MR"],
 "\n\t",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InstallationDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$InstallationDirectory"], "MR"]], 
  "InlineFormula"],
 StyleBox["/AddOns/ExtraPackages", "MR"]
}], "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->21425],

Cell[CellGroupData[{

Cell["Coding Tips", "Subsection",
 CellTags->{"jlug:5.3.19.0", "TableOfContents_1.5.3.19.1"},
 CellID->10555],

Cell["\<\
Here are a few tips on producing high-quality applications. These suggestions \
are guided by mistakes that developers frequently make.\
\>", "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->3434],

Cell[TextData[{
 StyleBox["Call ",
  FontWeight->"Bold"],
 StyleBox["InstallJava", "MR",
  FontWeight->"Bold"],
 StyleBox[" in the body of a function or functions, not when your package is \
read in",
  FontWeight->"Bold"],
 ". It is best to avoid side effects during the reading of a package. Users \
expect reading in a package to be fast and to do nothing but load \
definitions. If you launch Java at this time, and it fails, it could cause a \
mysterious hang in the loading process. It is better to call ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " in the code of one or more of your functions. You probably do not need to \
call ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " in every single function that uses Java. Most applications have a few \
\[OpenCurlyDoubleQuote]major\[CloseCurlyDoubleQuote] functions that users are \
likely to use almost exclusively, or at least at the start of their session. \
If your application does not have this property, then provide an \
initialization function that your users must call first, and call ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " inside it."
}], "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->16549],

Cell[TextData[{
 StyleBox["Call ",
  FontWeight->"Bold"],
 StyleBox["InstallJava", "MR",
  FontWeight->"Bold"],
 StyleBox[" with no arguments",
  FontWeight->"Bold"],
 ". You cannot know what options your users need for Java on their systems, \
so do not override what they may have set up. It is the \
user\[CloseCurlyQuote]s responsibility to make sure that they call ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"], "MR"]], "InlineFormula"],
 " to customize the options for ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " as necessary. Typically this would be done in their ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"init", ".", "m"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/init.m"]], "InlineFormula"],
 " file."
}], "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->7441],

Cell[TextData[{
 StyleBox["Make sure you use ",
  FontWeight->"Bold"],
 StyleBox["JavaBlock", "MR",
  FontWeight->"Bold"],
 StyleBox[" and/or ",
  FontWeight->"Bold"],
 StyleBox["ReleaseJavaObject", "MR",
  FontWeight->"Bold"],
 StyleBox[" to avoid leaking object references",
  FontWeight->"Bold"],
 ". You cannot know how others will use your code, so you need to be careful \
to avoid cluttering up their sessions with a potentially large number of \
useless objects. Sometimes you need to create an object that persists beyond \
the lifetime of a single ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, like a viewer window. In such cases, use a ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MathJFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathJFrame"]], "InlineFormula"],
 " as your top-level window and use its ",
 StyleBox["onClose()", "MR"],
 " method to specify ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code that releases all outstanding objects and unregisters kernel or front \
end sharing you may have used. If this is not possible, provide a cleanup \
function that users can call manually. Use ",
 Cell[BoxData[
  ButtonBox["LoadedJavaObjects",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadedJavaObjects"]], "InlineFormula"],
 " to look at the list of objects referenced in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " before and after your functions run; it should not grow in length."
}], "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->9512],

Cell[TextData[{
 StyleBox["If you use ",
  FontWeight->"Bold"],
 StyleBox["ShareKernel", "MR",
  FontWeight->"Bold"],
 StyleBox[" or ",
  FontWeight->"Bold"],
 StyleBox["ShareFrontEnd", "MR",
  FontWeight->"Bold"],
 StyleBox[", make sure you save the return values from these functions and \
pass them as arguments to ",
  FontWeight->"Bold"],
 StyleBox["UnshareKernel", "MR",
  FontWeight->"Bold"],
 StyleBox[" and ",
  FontWeight->"Bold"],
 StyleBox["UnshareFrontEnd", "MR",
  FontWeight->"Bold"],
 ". Do not call ",
 StyleBox["UnshareFrontEnd", "MR"],
 " or ",
 StyleBox["UnshareKernel", "MR"],
 " with no arguments, as this will shut down sharing even if other \
applications are using it."
}], "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->30145],

Cell[TextData[{
 StyleBox["Do not assume that the Java runtime will not be restarted during \
the lifetime of your application",
  FontWeight->"Bold"],
 ". Although users are strongly discouraged to call ",
 Cell[BoxData[
  ButtonBox["UninstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 ", it happens. It is unavoidable that some applications will fail if the \
Java runtime is shut down at an inopportune time (e.g., when they have a Java \
window displayed), but there are steps you can take to increase the \
robustness of your application in the face of Java shutdowns and restarts. \
One step was already given as the first tip above\[LongDash]call ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " at the start of your \[OpenCurlyDoubleQuote]major\[CloseCurlyDoubleQuote] \
functions. Another step is to avoid caching ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions unnecessarily, as these will become invalid if Java restarts. \
An example of this is calling ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " and then ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " several times when your package file is read in, and storing the results \
in private variables for the lifetime of your package. This is problematic if \
Java is restarted. Never store ",
 Cell[BoxData[
  ButtonBox["JavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
 " expressions\[LongDash]call ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " whenever there is any doubt about whether a class has been loaded into the \
current Java runtime. Calling ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " is very inexpensive if the class has already been loaded. If you have a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " that is very expensive to create and therefore you feel it necessary to \
cache it over a long period of time in a user\[CloseCurlyQuote]s session, \
consider using the following idiom to test whether it is still valid whenever \
it is used. The ",
 Cell[BoxData[
  ButtonBox["JavaObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectQ"]], "InlineFormula"],
 " test will fail if Java has been shut down or restarted since the object \
was last created, so you can then restart Java and create and store a new \
instance of the object."
}], "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->18060],

Cell["\<\
SomeFunction[] :=
\tModule[{...},
\t\tIf[!JavaObjectQ[$myCachedExpensiveJavaObject],
\t\t\tInstallJava[];
\t\t\t$myCachedExpensiveJavaObject = JavaNew[...];
\t\t];
\t\t... use $myCachedExpensiveJavaObject ...
\t]\
\>", "Input",
 CellTags->"jlug:5.3.19.0",
 CellID->21718],

Cell[TextData[{
 StyleBox["Do not call ",
  FontWeight->"Bold"],
 StyleBox["UninstallJava", "MR",
  FontWeight->"Bold"],
 StyleBox[" or ",
  FontWeight->"Bold"],
 StyleBox["ReinstallJava", "MR",
  FontWeight->"Bold"],
 StyleBox[" in your application",
  FontWeight->"Bold"],
 ". You need to coexist politely with other applications that may be using \
Java. Do not assume that when your package is done with Java, the user is \
done with it as well. Only users should ever call ",
 Cell[BoxData[
  ButtonBox["UninstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFormula"],
 ", and they should probably never call it either. There is no cost to \
leaving Java running. Likewise, users will rarely call ",
 Cell[BoxData[
  ButtonBox["ReinstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFormula"],
 " unless they are doing active Java development and need to reload modified \
versions of their classes."
}], "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->3753]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Programs", "Section",
 CellTags->{"TableOfContents_1.5.4", "1.3", "jlug:5.4.0.0"},
 CellID->16139],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->{"jlug:5.4.1.0", "TableOfContents_1.5.4.1"},
 CellID->12423],

Cell[TextData[{
 "This section will work through some example programs. These examples are \
intended to demonstrate a wide variety of techniques and subtleties. We will \
discuss some nuances in the implementations and touch on most of the major \
issues in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programming."
}], "Text",
 CellTags->"jlug:5.4.1.0",
 CellID->16279],

Cell[TextData[{
 "We will take a relatively rigorous approach, and in particular we will be \
careful to avoid leaking references. As discussed in the section ",
 ButtonBox["JavaBlock",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#25162"],
 ", ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " are the tools in this fight, but if you find yourself becoming the least \
bit confused about the subject, just ignore it completely. For many casual, \
personal uses of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", you can forget about memory management issues, and just let Java objects \
pile up."
}], "Text",
 CellTags->"jlug:5.4.1.0",
 CellID->25996],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " includes a number of notebooks with sample programs, including most of the \
programs developed in this section. These notebooks can be found in the ",
 StyleBox[ButtonBox["<Mathematica \
dir>/SystemFiles/Links/JLink/Examples/Part1",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonData:>{
    URL[
     ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "JLink", 
       "Examples", "Part1"}]], None}], "MR"],
 " directory."
}], "Text",
 CellTags->"jlug:5.4.1.0",
 CellID->16687]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Beep Function", "Subsection",
 CellTags->{"jlug:5.4.2.0", "TableOfContents_1.5.4.2"},
 CellID->12529],

Cell[TextData[{
 "Here is a very simple example. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not have a ",
 StyleBox["Beep", "MR"],
 " function to provide simple alerts. But Java has a ",
 StyleBox["beep()", "MR"],
 " method and, by virtue of that, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has one too:"
}], "Text",
 CellTags->"jlug:5.4.2.0",
 CellID->31673922],

Cell[BoxData[
 RowBox[{
  RowBox[{"Beep", "[", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadJavaClass", "[", "\"\<java.awt.Toolkit\>\"", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Toolkit`getDefaultToolkit", "[", "]"}], "@", 
     RowBox[{"beep", "[", "]"}]}]}], "\[IndentingNewLine]", ")"}]}]], "Input",\

 CellTags->"jlug:5.4.2.0",
 CellLabel->"In[1]:=",
 CellID->17437],

Cell[TextData[{
 "You will notice a short delay the first time ",
 StyleBox["Beep[]", "MR"],
 " is executed. This is due to the ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " call, which only takes measurable time the first time it is called for any \
given class."
}], "Text",
 CellTags->"jlug:5.4.2.0",
 CellID->19866],

Cell[BoxData[
 RowBox[{"Beep", "[", "]"}]], "Input",
 CellTags->"jlug:5.4.2.0",
 CellLabel->"In[2]:=",
 CellID->12949],

Cell["\<\
This is a perfectly good beep function, and many users will not need to go \
beyond this. If you are writing code for others to use, however, you will \
probably want to embellish this code a little bit. Here is a more \
professional version of the same function:\
\>", "Text",
 CellTags->"jlug:5.4.2.0",
 CellID->193],

Cell["\<\
BetterBeep[]:=
\tJavaBlock[
\t\tInstallJava[];
\t\tLoadJavaClass[\"java.awt.Toolkit\"];
\t\tToolkit`getDefaultToolkit[]@beep[];
\t]\
\>", "Input",
 CellTags->"jlug:5.4.2.0",
 CellLabel->"In[3]:=",
 CellID->23195],

Cell[TextData[{
 "Note that the first thing we do is call ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 ". It is a good habit to call ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " in functions that use ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", at least if you are writing code for others to use. If ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " has already been called, subsequent calls will do nothing and return very \
quickly. The whole program is wrapped in ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ". As discussed in the section ",
 ButtonBox["JavaBlock",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#25162"],
 ", ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " automates the process of releasing references to objects returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The ",
 StyleBox["getDefaultToolkit()", "MR"],
 " method returns a ",
 StyleBox["Toolkit", "MR"],
 " object, so we want to release the ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " that gets created in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The ",
 StyleBox["getDefaultToolkit()", "MR"],
 " method returns a reference to the same ",
 StyleBox["Toolkit", "MR"],
 " object every time it is called, so even if we do not call ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ", we will only \[OpenCurlyDoubleQuote]leak\[CloseCurlyDoubleQuote] one \
object in an entire session. We could also write ",
 StyleBox["Beep", "MR"],
 " using an explicit call to ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 ":"
}], "Text",
 CellTags->"jlug:5.4.2.0",
 CellID->3297],

Cell["\<\
(* Alternative version *)
BetterBeep2[]:=
\tModule[{toolkit},
\t\tInstallJava[];
\t\tLoadJavaClass[\"java.awt.Toolkit\"];
\t\ttoolkit = Toolkit`getDefaultToolkit[];
\t\ttoolkit@beep[];
\t\tReleaseJavaObject[toolkit]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.2.0",
 CellLabel->"In[4]:=",
 CellID->20416],

Cell[TextData[{
 "The advantage to using ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " is that we do not have to think about what, if any, methods might return \
objects, and we do not have to assign them to variables. "
}], "Text",
 CellTags->"jlug:5.4.2.0",
 CellID->28286]
}, Open  ]],

Cell[CellGroupData[{

Cell["Formatting Dates", "Subsection",
 CellTags->{"jlug:5.4.3.0", "TableOfContents_1.5.4.3"},
 CellID->16105],

Cell[TextData[{
 "Here is an example of a computation performed in Java. Java provides a \
number of powerful date- and calendar-oriented classes. Say we want to create \
a nicely formatted string showing the time and date. In this first step we \
create a new Java ",
 StyleBox["Date", "MR"],
 " object representing the current date and time:"
}], "Text",
 CellTags->"jlug:5.4.3.0",
 CellID->24488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"date", "=", 
  RowBox[{"JavaNew", "[", "\"\<java.util.Date\>\"", "]"}]}]], "Input",
 CellTags->"jlug:5.4.3.0",
 CellLabel->"In[1]:=",
 CellID->16282],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]JavaObject", "[", "\<\"java.util.Date\"\>", "]"}],
    "\[RightGuillemet]"}],
  JLink`Objects`JavaObject27706971914241]], "Output",
 CellTags->"jlug:5.4.3.0",
 CellLabel->"Out[1]=",
 CellID->12455]
}, Open  ]],

Cell[TextData[{
 "Next we load the ",
 StyleBox["DateFormat", "MR"],
 " class and create a formatter capable of formatting dates:"
}], "Text",
 CellTags->"jlug:5.4.3.0",
 CellID->25734],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadJavaClass", "[", "\"\<java.text.DateFormat\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{"dateFormatter", "=", 
  RowBox[{"DateFormat`getInstance", "[", "]"}]}]}], "Input",
 CellTags->"jlug:5.4.3.0",
 CellLabel->"In[2]:=",
 CellID->18114],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", "[", "\<\"java.text.SimpleDateFormat\"\>", 
    "]"}], "\[RightGuillemet]"}],
  JLink`Objects`JavaObject95371963006978]], "Output",
 CellTags->"jlug:5.4.3.0",
 CellLabel->"Out[3]=",
 CellID->11701]
}, Open  ]],

Cell[TextData[{
 "Now we call the ",
 StyleBox["format()", "MR"],
 " method, passing the ",
 StyleBox["Date", "MR"],
 " object as its argument:"
}], "Text",
 CellTags->"jlug:5.4.3.0",
 CellID->31316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dateFormatter", "@", 
  RowBox[{"format", "[", "date", "]"}]}]], "Input",
 CellTags->"jlug:5.4.3.0",
 CellLabel->"In[4]:=",
 CellID->20671],

Cell[BoxData["\<\"10/9/00 4:56 AM\"\>"], "Output",
 CellTags->"jlug:5.4.3.0",
 CellLabel->"Out[4]=",
 CellID->5786]
}, Open  ]],

Cell[TextData[{
 "There are many different ways in which dates and times can be formatted, \
including respecting a user\[CloseCurlyQuote]s locale. Java also has a useful \
number-formatting class, an example of which was given in ",
 ButtonBox["An Optimization Example",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17968"],
 "."
}], "Text",
 CellTags->"jlug:5.4.3.0",
 CellID->12263]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Progress Bar", "Subsection",
 CellTags->{"jlug:5.4.5.0", "TableOfContents_1.5.4.5"},
 CellID->5535],

Cell[TextData[{
 "A simple example of a pop-up user interface for a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program is a progress bar. This is an example of a \
\[OpenCurlyDoubleQuote]non-interactive\[CloseCurlyDoubleQuote] user \
interface, as defined in ",
 ButtonBox["Interactive and Non-Interactive Interfaces",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#314330245"],
 ", because it does not need to call back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or return a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The implementation uses the Swing user interface classes, because Swing \
has a built-in class for progress bars. (You cannot run this example unless \
you have Swing installed. It comes as a standard part of Java 1.2 or later, \
but you can get it separately for Java 1.1.x. Most Java development tools \
that are still at version 1.1.x come with Swing.) The complete code for this \
example is also provided in the file ",
 StyleBox[ButtonBox["ProgressBar.nb",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonFunction:>(NotebookOpen[
    ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "JLink", 
      "Examples", "Part1"}, #]]& )], "MR"],
 " in the ",
 StyleBox["JLink/Examples/Part1", "MR"],
 " directory."
}], "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->20450],

Cell[TextData[{
 "The code is commented to point out the general structure. There are several \
classes and methods used in this code that may be unfamiliar to you. Just \
keep in mind that this is completely standard Java code translated into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " conventions. It is line-for-line identical to a Java program that does the \
same thing."
}], "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->11173],

Cell[TextData[{
 "This code is presented as a complete program, but this does not suggest \
that it should be developed that way. The interactive nature of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " lets you tinker with Java objects a line at a time, experimenting until \
you get things just how you want them. Of course, this is how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs are typically written, and ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " lets you do the same with Java objects and methods."
}], "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->10466],

Cell[TextData[{
 "We create a function ",
 StyleBox["ShowProgressBar", "MR"],
 " that prepares and displays a progress bar dialog. The bar will be used to \
show percentage completion of a computation. You can supply the initial \
percent completed or use the default value of zero. ",
 StyleBox["ShowProgressBar", "MR"],
 " returns the ",
 StyleBox["JProgressBar", "MR"],
 " object because the bar needs to be updated later by calling ",
 StyleBox["setValue()", "MR"],
 ". Note that because we return the ",
 StyleBox["bar", "MR"],
 " object from the ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ", it is not released like all other new Java objects created within this ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ". This is a new behavior of ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0. If what is returned from a ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " is precisely a single Java object (and not, for example, a list of \
objects), then this object is not released. ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " is discussed in the section ",
 ButtonBox["JavaBlock",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#25162"],
 "."
}], "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->12044],

Cell["\<\
ShowProgressBar[title_String:\"Computation Progress\",
\t\t\t    \tcaption_String:\"Percent complete:\",
\t\t\t    \tpercent_Integer:0
\t\t\t   \t  ] :=
\tJavaBlock[
\t\tModule[{frame, panel, label, bar},
\t\t\tInstallJava[];
\t\t\tbar = JavaNew[\"javax.swing.JProgressBar\"];
\t\t\tframe = JavaNew[\"javax.swing.JFrame\", title];
\t\t\tframe@setSize[300, 110];
\t\t\tframe@setResizable[False];
\t\t\tframe@setLocation[400, 400];
\t\t\tpanel = JavaNew[\"javax.swing.JPanel\"];
\t\t\tpanel@setLayout[Null];
\t\t\tframe@getContentPane[]@add[panel];
\t\t\tlabel = JavaNew[\"javax.swing.JLabel\", caption];
\t\t\tlabel@setBounds[20, 10, 260, 20];
\t\t\tpanel@add[label];
\t\t\tbar@setBounds[20, 40, 260, 30];
\t\t\tbar@setMinimum[0];
\t\t\tbar@setMaximum[100];
\t\t\tbar@setValue[percent];
\t\t\tpanel@add[bar];
\t\t\tJavaShow[frame];
\t\t\tbar
\t\t]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.5.0",
 CellLabel->"In[1]:=",
 CellID->21659],

Cell[TextData[{
 "We also need a function to close the progress dialog and clean up after it. \
Only two things need to be done. First, the ",
 StyleBox["dispose()", "MR"],
 " method must be called on the top-level frame window that contains the bar. \
Second, if we want to avoid leaking object references, we need to call ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " on the bar object because it is the only object reference that escaped the \
",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " in ",
 StyleBox["ShowProgressBar", "MR"],
 ". We need to call ",
 StyleBox["dispose()", "MR"],
 " on the ",
 StyleBox["JFrame", "MR"],
 " object we created in ",
 StyleBox["ShowProgressBar", "MR"],
 ", but we did not save a reference to it. The ",
 StyleBox["SwingUtilities", "MR"],
 " class has a handy method ",
 StyleBox["windowForComponent()", "MR"],
 " that will retrieve this frame, given the bar object."
}], "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->26292],

Cell["\<\
DestroyProgressBar[bar_?JavaObjectQ] :=
\tJavaBlock[
\t\tLoadJavaClass[\"javax.swing.SwingUtilities\"];
\t\tSwingUtilities`windowForComponent[bar]@dispose[];
\t\tReleaseJavaObject[bar]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.5.0",
 CellLabel->"In[2]:=",
 CellID->26439],

Cell[TextData[{
 "The bar dialog has a close box in it, so a user can dismiss it prematurely \
if desired. This would take care of disposing the dialog, but we would still \
need to release the bar object. ",
 StyleBox["DestroyProgressBar", "MR"],
 " (and the bar\[CloseCurlyQuote]s ",
 StyleBox["setValue()", "MR"],
 " method) is safe to call whether or not the user closed the dialog."
}], "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->17253],

Cell[TextData[{
 "Here is how we would use the progress bar in a computation. The call to ",
 StyleBox["ShowProgressBar", "MR"],
 " displays the bar dialog and returns a reference to the bar object. Then, \
while the computation is running, we periodically call the ",
 StyleBox["setValue()", "MR"],
 " method to update the bar\[CloseCurlyQuote]s appearance. When the \
computation is done, we call ",
 StyleBox["DestroyProgressBar", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->20024],

Cell["\<\
bar = ShowProgressBar[];
n = 0;
While[n <= 5,
\tbar@setValue[n/5 * 100];
\tPause[1]; (* This simulates the time-consuming computation. *)
\tn++
];
DestroyProgressBar[bar];\
\>", "Input",
 CellTags->"jlug:5.4.5.0",
 CellLabel->"In[3]:=",
 CellID->26154],

Cell[TextData[{
 "An easy way to test whether your code leaks object references is to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LoadedJavaObjects",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/LoadedJavaObjects"], "[", "]"}]], 
  "InlineFormula"],
 " before and after the computation. If the list of objects gets longer, then \
you have forgotten to use ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " or improperly used ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->29510],

Cell[TextData[{
 "It can take several seconds to load all the Swing classes used in this \
example. This means that the first time ",
 StyleBox["ShowProgressBar", "MR"],
 " is called, there will be a significant delay. You could avoid this delay \
by using ",
 Cell[BoxData[
  ButtonBox["LoadJavaClass",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFormula"],
 " ahead of time to explicitly load the classes that appear in ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " statements."
}], "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->4745],

Cell[TextData[{
 "The dialog appears onscreen with its upper left at the coordinates (400, \
400). It is left as an exercise to the reader to make it centered on the \
screen. (Hint: the ",
 StyleBox["java.awt.Toolkit", "MR"],
 " class has a ",
 StyleBox["getScreenSize()", "MR"],
 " method)."
}], "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->20649],

Cell["\<\
Finally, because the progress bar uses the Swing classes, we can play with \
the look-and-feel options that Swing provides. Specifically, we can change \
the theme at runtime. The progress bar window is not very complicated, so it \
changes very little in going from one look-and-feel theme to another, but \
this demonstrates how to do it. The effect is much more dramatic for more \
complex windows.\
\>", "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->13186],

Cell["First, create a new progress bar window:", "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->8313],

Cell[BoxData[
 RowBox[{
  RowBox[{"bar", "=", 
   RowBox[{"ShowProgressBar", "[", "]"}]}], ";"}]], "Input",
 CellTags->"jlug:5.4.5.0",
 CellLabel->"In[7]:=",
 CellID->4474],

Cell["\<\
Now load some classes from which we need to call static methods:\
\>", "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->28022],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadJavaClass", "[", "\"\<javax.swing.UIManager\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"LoadJavaClass", "[", "\"\<javax.swing.SwingUtilities\>\"", "]"}], 
  ";"}]}], "Input",
 CellTags->"jlug:5.4.5.0",
 CellLabel->"In[8]:=",
 CellID->2168],

Cell["\<\
The default look and feel is the \[OpenCurlyDoubleQuote]metal\
\[CloseCurlyDoubleQuote] theme. You can change it to the native style look \
for your platform as follows (it helps to be able to see the window when \
doing this):\
\>", "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->14018],

Cell["\<\
JavaBlock[
\tUIManager`setLookAndFeel[UIManager`getSystemLookAndFeelClassName[]];
\tframe = SwingUtilities`windowForComponent[bar];
\tSwingUtilities`updateComponentTreeUI[frame]
]\
\>", "Input",
 CellTags->"jlug:5.4.5.0",
 CellLabel->"In[10]:=",
 CellID->18787],

Cell["Clean up.", "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->9905],

Cell[BoxData[
 RowBox[{"DestroyProgressBar", "[", "bar", "]"}]], "Input",
 CellTags->"jlug:5.4.5.0",
 CellLabel->"In[11]:=",
 CellID->17958]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Simple Modal Input Dialog", "Subsection",
 CellTags->{"jlug:5.4.6.0", "TableOfContents_1.5.4.6"},
 CellID->7391],

Cell[TextData[{
 "We saw one example of a simple modal dialog in ",
 ButtonBox["Modal Windows",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#32702"],
 ". Here we present another one\[LongDash]a basic dialog that prompts the \
user to enter an angle, with a choice of whether it is being specified in \
degrees or radians. This will demonstrate a dialog that returns a value to a \
running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program when it is dismissed, much like ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s built-in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"], "MR"]], "InlineFormula"],
 " function, which requests a string from the user before returning. Dialogs \
like this one are not \[OpenCurlyDoubleQuote]modal\[CloseCurlyDoubleQuote] in \
the traditional sense that they must be closed before other Java windows can \
be used, but rather they are modal with respect to the kernel, which is kept \
busy until they are dismissed (that is, until ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DoModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/DoModal"], "[", "]"}]], "InlineFormula"],
 " returns). The section ",
 ButtonBox["Creating Windows and Other User Interface Elements",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4596"],
 " discusses modal and modeless Java windows in detail."
}], "Text",
 CellTags->"jlug:5.4.6.0",
 CellID->10202],

Cell[TextData[{
 "The code is rather straightforward and warrants little in the way of \
commentary. In creating the window and the controls within it, it exactly \
mirrors the Java code you would use if you were writing the program in Java. \
One technique it demonstrates is determining whether the ",
 StyleBox["OK", "SR"],
 " or ",
 StyleBox["Cancel", "SR"],
 " button was clicked to dismiss the dialog. This is done by having the ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 " objects assigned to the two buttons return different things in addition to \
calling ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 ". Recall that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DoModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/DoModal"], "[", "]"}]], "InlineFormula"],
 " returns whatever the code that calls ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 " returns, so here we have the ",
 StyleBox["OK", "SR"],
 " button execute ",
 StyleBox["(EndModal[]; True)&", "MR"],
 ", a pure function that ignores its arguments, calls ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 ", and returns ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 ", whereas the ",
 StyleBox["Cancel", "SR"],
 " button executes ",
 StyleBox["(EndModal[]; False)&", "MR"],
 ". Thus, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DoModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/DoModal"], "[", "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 " if the ",
 StyleBox["OK", "SR"],
 " button was clicked, or ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "MR"]], "InlineFormula"],
 " if the ",
 StyleBox["Cancel", "SR"],
 " button was clicked. It will return ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Null",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Null"], "MR"]], "InlineFormula"],
 " if the window\[CloseCurlyQuote]s close box was clicked (this behavior \
comes from the ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " itself)."
}], "Text",
 CellTags->"jlug:5.4.6.0",
 CellID->3625],

Cell[TextData[{
 "It may take several seconds to display the dialog the first time ",
 StyleBox["GetAngle[]", "MR"],
 " is called. This is due to the one-time cost of loading the several large \
AWT classes required. Subsequent invocations of ",
 StyleBox["GetAngle[]", "MR"],
 " will be much quicker."
}], "Text",
 CellTags->"jlug:5.4.6.0",
 CellID->26477],

Cell[TextData[{
 "The complete code for this example is also provided in the file ",
 StyleBox[ButtonBox["ModalInputDialog.nb",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonFunction:>(NotebookOpen[
    ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "JLink", 
      "Examples", "Part1"}, #]]& )], "MR"],
 " in the ",
 StyleBox["JLink/Examples/Part1", "MR"],
 " directory."
}], "Text",
 CellTags->"jlug:5.4.6.0",
 CellID->4414],

Cell["\<\
GetAngle[] :=
\tJavaBlock[
\t\tModule[{frm, inputField, cbGroup, degBox, radBox,
\t\t\t\t\tlabel, okButton, cancelButton, wasOKButton, angle},

\t\t\tInstallJava[]; (* In case the user hasn't called it already. *)

\t\t\tfrm = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\t\tlabel = JavaNew[\"java.awt.Label\", \"Enter an angle:\"];
\t\t\tinputField = JavaNew[\"java.awt.TextField\"];
\t\t\tcbGroup = JavaNew[\"java.awt.CheckboxGroup\"];
\t\t\tdegBox = JavaNew[\"java.awt.Checkbox\", \"degrees\", cbGroup, True];
\t\t\tradBox = JavaNew[\"java.awt.Checkbox\", \"radians\", cbGroup, False];
\t\t\tokButton = JavaNew[\"java.awt.Button\", \"OK\"];
\t\t\tcancelButton = JavaNew[\"java.awt.Button\", \"Cancel\"];
\t\t\t
\t\t\tfrm@setLayout[Null];
\t\t\tfrm@add[label];
\t\t\tfrm@add[inputField];
\t\t\tfrm@add[degBox];
\t\t\tfrm@add[radBox];
\t\t\tfrm@add[okButton];
\t\t\tfrm@add[cancelButton];
\t\t\t
\t\t\tfrm@setBounds[200, 200, 200, 160];
\t\t\tlabel@setBounds[20, 30, 150, 20];
\t\t\tinputField@setBounds[20, 70, 60, 28];
\t\t\tdegBox@setBounds[100, 60, 80, 20];
\t\t\tradBox@setBounds[100, 80, 80, 20];
\t\t\tokButton@setBounds[40, 120, 50, 20];
\t\t\tcancelButton@setBounds[100, 120, 50, 20];
\t\t\tfrm@setResizable[False];

\t\t\tokButton@addActionListener[
\t\t\t\tJavaNew[\"com.wolfram.jlink.MathActionListener\",
\t\t\t\t\t\t\t\"(EndModal[]; True)&\"]
\t\t\t];
\t\t\tcancelButton@addActionListener[
\t\t\t\tJavaNew[\"com.wolfram.jlink.MathActionListener\",
\t\t\t\t\t\t\t\"(EndModal[]; False)&\"]
\t\t\t];
\t\t\t
\t\t\t(* Now make the window visible and bring it to the foreground. *)
\t\t\tJavaShow[frm];

\t\t\tfrm@setModal[];
\t\t\twasOKButton = DoModal[];
\t\t\t(* Even though the window may have been closed, it is perfectly
\t\t\t   OK to extract values from the controls in the window.
\t\t\t*)
\t\t\tIf[TrueQ[wasOKButton],
\t\t\t\tangle = ToExpression[inputField@getText[]];
\t\t\t\tIf[angle =!= Null && degBox@getState[], angle *= Pi/180],
\t\t\t(* else *)
\t\t\t\t(* We will get here if the Cancel button was clicked
\t\t\t\t   (wasOKButton will be False), or the dialog was closed
\t\t\t\t   by clicking in its close box (wasOKButton will be Null).
\t\t\t\t*)
\t\t\t\tangle = $Failed
\t\t\t];
\t\t\t(* If the cancel or OK buttons were clicked, frm is still
\t\t\t   visible, so we dispose it here.
\t\t\t*)
\t\t\tfrm@dispose[];
\t\t\tangle
\t\t]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.6.0",
 CellLabel->"In[1]:=",
 CellID->9314],

Cell["Now invoke it:", "Text",
 CellTags->"jlug:5.4.6.0",
 CellID->246580910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetAngle", "[", "]"}]], "Input",
 CellTags->"jlug:5.4.6.0",
 CellLabel->"In[2]:=",
 CellID->29334],

Cell[BoxData["\[Pi]"], "Output",
 CellTags->"jlug:5.4.6.0",
 CellLabel->"Out[2]=",
 CellID->25874]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A File Chooser Dialog Box", "Subsection",
 CellTags->{"jlug:5.4.7.0", "TableOfContents_1.5.4.7"},
 CellID->24372],

Cell[TextData[{
 "A useful feature for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs is to be able to produce a file chooser dialog, such as the \
typical Open or Save dialog boxes. You could use such a dialog box to prompt \
a user for an input file or a file into which to write data. This is easily \
accomplished in a cross-platform way with Java, specifically with the ",
 StyleBox["JFileChooser", "MR"],
 " class in the standard Swing library. The code for such a dialog box is \
provided in the file ",
 StyleBox[ButtonBox["FileChooserDialog.nb",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonFunction:>(NotebookOpen[
    ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "JLink", 
      "Examples", "Part1"}, #]]& )], "MR"],
 " in the ",
 StyleBox["JLink/Examples/Part1", "MR"],
 " directory."
}], "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->20159],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.0 introduced a new \[OpenCurlyDoubleQuote]experimental\
\[CloseCurlyDoubleQuote] function called ",
 StyleBox["FileBrowse[]", "MR"],
 " that displays a file browser in the front end. Although this function is \
usable, it has several shortcomings compared to the Java technique presented \
below. One of the limitations is that it requires that the front end be in \
use. Another is that it is not customizable, so you always get a \
\[OpenCurlyDoubleQuote]Save file as:\[CloseCurlyDoubleQuote] dialog box and \
the concomitant behavior, which is not appropriate for an \
\[OpenCurlyDoubleQuote]Open\[CloseCurlyDoubleQuote]-type dialog box. The ",
 StyleBox["JFileChooser", "MR"],
 " class used here allows very sophisticated customization, including setting \
the initial directory, masking out files based on their names or properties, \
controlling the title and text on the various buttons, supplying functions to \
validate the choice before the dialog box is allowed to be dismissed, \
allowing for multiple file selection, and allowing directories to be selected \
instead of files."
}], "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->11833],

Cell["\<\
Although this example is a short program, the code has some unfortunate \
complexity (meaning \[OpenCurlyDoubleQuote]ugliness\[CloseCurlyDoubleQuote]) \
in it related to making this special type of dialog window come to the \
foreground on all platforms. For this reason, the code is not presented here. \
Instead, we will just mention some topics in the program code; you can read \
the full code and its associated comments in the example file if you are \
interested in the implementation details.\
\>", "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->28070],

Cell[TextData[{
 "The ",
 StyleBox["FileChooserDialog", "MR"],
 " function takes three string arguments. The first is the title of the \
dialog box (for example, \[OpenCurlyDoubleQuote]Select a data file to import\
\[CloseCurlyDoubleQuote]), the second is the text to appear on what is \
essentially the ",
 StyleBox["OK", "SR"],
 " button (typically this will be \[OpenCurlyDoubleQuote]Open\
\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]Save\
\[CloseCurlyDoubleQuote]), and the third is the directory in which to start. \
You can also supply no arguments and get a default Open dialog box that \
starts in the kernel\[CloseCurlyQuote]s current directory."
}], "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->7487],

Cell[TextData[{
 "Although this is a \[OpenCurlyDoubleQuote]modal",
 "\[CloseCurlyDoubleQuote]",
 " dialog box, there is no need to use ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ", because the ",
 StyleBox["showDialog()", "MR"],
 " method will not return until the user dismisses the dialog box. Recall \
that ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " is a way to force ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to stall until the dialog box or other window is dismissed. Here, we get \
this behavior for free from ",
 StyleBox["showDialog()", "MR"],
 ". The other thing that ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " does is put the kernel into a loop where it is ready to receive input from \
Java, so you can script some of the functionality of the dialog via callbacks \
to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The file chooser dialog box does not need to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in any way until it returns the selected file, so we have no need for this \
other aspect that ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " provides."
}], "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->28297],

Cell[TextData[{
 "A second point of interest is in the name of the constant that ",
 StyleBox["showDialog()", "MR"],
 " returns to indicate that the user clicked the ",
 StyleBox["Save", "SR"],
 " or ",
 StyleBox["Open", "SR"],
 " button instead of the ",
 StyleBox["Cancel", "SR"],
 " button. The name of this constant in Java is ",
 StyleBox["JFileChooser.APPROVE_OPTION", "MR"],
 ". Java names map to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols, so they must be translated if they contain characters that are \
not legal in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols, such as the underscore. Underscores are converted to a \
\[OpenCurlyDoubleQuote]U\[CloseCurlyDoubleQuote] when they appear in symbols, \
so the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " name of this constant is ",
 StyleBox["JFileChooser`APPROVEUOPTION", "MR"],
 ". See ",
 ButtonBox["Underscores in Java Names",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#10004"],
 " for more information."
}], "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->7518]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sharing the Front End: Palette-Type Buttons", "Subsection",
 CellTags->{"jlug:5.4.8.0", "TableOfContents_1.5.4.8"},
 CellID->8177],

Cell[TextData[{
 "As discussed in the section ",
 ButtonBox["Creating Windows and Other User Interface Elements",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4596"],
 ", one of the goals of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is to allow Java user interface elements to be as close as possible to \
first-class members of the notebook front end environment in the way notebook \
and palette windows are. One of the ways this is accomplished is with the ",
 StyleBox["ShareKernel", "MR"],
 " function, which allows Java windows to share the kernel\[CloseCurlyQuote]s \
attention with notebook windows. We refer to such Java windows as \
\[OpenCurlyDoubleQuote]modeless,\[CloseCurlyDoubleQuote] not in the \
traditional sense of allowing other Java windows to remain active, but \
modeless with respect to the kernel, meaning that the kernel is not kept busy \
while they are open."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->17773],

Cell[TextData[{
 "Beyond the ability to have Java windows share the kernel with the front \
end, it would be nice to allow actions in Java to cause effects in notebook \
windows, such as printing something, displaying a graph, or any of the \
notebook-manipulation commands like ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookApply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookApply"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPrint"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionEvaluate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionEvaluate"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionMove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionMove"], "MR"]], "InlineFormula"],
 ", and so on. A good example of this is palette buttons. A palette button \
can cause the current selection to be replaced by something else and the \
resulting expression to be evaluated in place."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->32270],

Cell[TextData[{
 "The ",
 StyleBox["ShareFrontEnd", "MR"],
 " function lets actions in Java modeless windows trigger events in a \
notebook window just like can be done from palette buttons or ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code you evaluate manually in a notebook. Remember that you get \
automatically the ability to interact with the front end when you use a ",
 StyleBox["modal",
  FontSlant->"Italic"],
 " dialog (i.e., when ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " is running). When Java is being run in a modal way, the kernel\
\[CloseCurlyQuote]s ",
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 " always points at the front end, so all side effect outputs get sent to the \
front end automatically. A modal window would not be acceptable for our \
palette example here because we need the palette to be an unobtrusive \
enhancement to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment\[LongDash]it cannot lock up the kernel while it is alive. ",
 StyleBox["ShareKernel", "MR"],
 " allows Java windows to call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " without tying up the kernel, and ",
 StyleBox["ShareFrontEnd", "MR"],
 " is an extension to ",
 StyleBox["ShareKernel", "MR"],
 " (it calls ",
 StyleBox["ShareKernel", "MR"],
 " internally) that allows such \[OpenCurlyDoubleQuote]modeless\
\[CloseCurlyDoubleQuote] Java windows to interact with the front end. ",
 StyleBox["ShareFrontEnd", "MR"],
 " is discussed in more detail in ",
 ButtonBox["Sharing the Front End",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#10021"],
 "."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->1763],

Cell[TextData[{
 "In the ",
 StyleBox["PrintButton", "MR"],
 " example below, we develop a simple palette-type button in Java that prints \
its label at the current cursor position in the active notebook. Because of \
current limitations with ",
 StyleBox["ShareFrontEnd", "MR"],
 ", this example will not work with a remote kernel; the same machine must be \
running the kernel and the front end."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->2668],

Cell["\<\
PrintButton[label_String] :=
\tJavaBlock[
\t\tModule[{frm, button, listener, tok},
\t\t\tInstallJava[];
\t\t\tfrm = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\t\tbutton = JavaNew[\"java.awt.Button\"];
\t\t\tfrm@add[button];
\t\t\tfrm@pack[];
\t\t\tbutton@setLabel[label];
\t\t\tlistener = JavaNew[\"com.wolfram.jlink.MathActionListener\",
\t\t\t\t\t            \"printButtonFunc\"];
\t\t\tbutton@addActionListener[listener];
\t\t\ttok = ShareFrontEnd[];
\t\t\tfrm@onClose[\"UnshareFrontEnd[\" <> ToString[tok] <> \"]\"];
\t\t\tJavaShow[frm]
\t\t]
\t]
\t
printButtonFunc[event_, _] :=
\tJavaBlock[
\t\tNotebookApply[SelectedNotebook[], event@getSource[]@getLabel[]];
\t\t(* We need to explicitly release the event object, since it was
\t\t   sent to Mathematica before the JavaBlock was entered. *)
\t\tReleaseJavaObject[event]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.8.0",
 CellLabel->"In[1]:=",
 CellID->17192],

Cell[TextData[{
 "Now invoke the ",
 StyleBox["PrintButton", "MR"],
 " function to create and display the palette. Click the button to see the \
button\[CloseCurlyQuote]s label (",
 StyleBox["foo", "MR"],
 " in this example) inserted at the current cursor location. When you are \
done, click the window\[CloseCurlyQuote]s close box."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->13985],

Cell[BoxData[
 RowBox[{"PrintButton", "[", "\"\<foo\>\"", "]"}]], "Input",
 CellTags->"jlug:5.4.8.0",
 CellLabel->"In[4]:=",
 CellID->3102],

Cell[TextData[{
 "The code is mostly straightforward. As usual, we use the ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " class for the frame window because it closes and disposes of itself when \
its close box is clicked. We create a ",
 Cell[BoxData[
  ButtonBox["MathActionListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathActionListener"]], 
  "InlineFormula"],
 " that calls ",
 StyleBox["buttonFunc", "MR"],
 " and we assign it to the button. From the ",
 ButtonBox["table",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#18935"],
 " in the section Handling Events with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Code: The \[OpenCurlyDoubleQuote]MathListener\[CloseCurlyDoubleQuote] \
Classes, we know that ",
 StyleBox["buttonFunc", "MR"],
 " will be called with two arguments, the first of which is the ",
 StyleBox["ActionEvent", "MR"],
 " object. From this object we can obtain the button that was clicked and \
then its label, which we insert at the current cursor location using the \
standard ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookApply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookApply"], "MR"]], "InlineFormula"],
 " function. One subtlety is that we need to specify ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectedNotebook"], "MR"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 " as the target for notebook operations like ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookApply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookApply"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPrint"], "MR"]], "InlineFormula"],
 ", and so on, which take a notebook as an argument. Because of \
implementation details of ",
 StyleBox["ShareFrontEnd", "MR"],
 ", the notebook given by ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationNotebook"], "MR"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 " is not the correct target (after all, there isn\[CloseCurlyQuote]t any \
evaluation currently in progress in the front end when the button is \
clicked)."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->8480],

Cell[TextData[{
 "The important thing to note in ",
 StyleBox["PrintButton", "MR"],
 " is the use of ",
 StyleBox["ShareFrontEnd", "MR"],
 " and ",
 StyleBox["UnshareFrontEnd", "MR"],
 ". As discussed earlier, ",
 StyleBox["ShareFrontEnd", "MR"],
 " puts Java into a state where it forwards everything other than the result \
of a computation to the front end, and puts the front end into a state where \
it is able to receive it. This is why the ",
 StyleBox["Print", "MR"],
 " output triggered by clicking the Java button, which would normally be sent \
to Java (and just discarded there), appears in the front end. Front end \
sharing (and also kernel sharing) should be turned off when they are no \
longer needed, but if you are writing code for others to use you cannot just \
blindly shut sharing down\[LongDash]the user could have other Java windows \
open that need sharing. To handle this issue, ",
 StyleBox["ShareFrontEnd", "MR"],
 " (and ",
 StyleBox["ShareKernel", "MR"],
 ") works on a register/unregister principle. Every time you call ",
 StyleBox["ShareFrontEnd", "MR"],
 ", it returns a token that represents a request for front end sharing. If \
front end sharing is not on, it will be turned on. When a program no longer \
needs front end sharing, it should call ",
 StyleBox["UnshareFrontEnd", "MR"],
 ", passing the token from ",
 StyleBox["ShareFrontEnd", "MR"],
 " as the argument. Only when all requests for sharing have been unregistered \
in this way will sharing actually be turned off."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->29213],

Cell[TextData[{
 "The ",
 StyleBox["onClose()", "MR"],
 " method of the ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " class lets you specify ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to be executed when the frame is closed. This code is executed after \
all event listeners have been notified, so it is a safe place to turn off \
sharing. In the ",
 StyleBox["onClose()", "MR"],
 " code, we call ",
 StyleBox["UnshareFrontEnd", "MR"],
 " with the token returned by ",
 StyleBox["ShareFrontEnd", "MR"],
 ". Using the ",
 StyleBox["onClose()", "MR"],
 " method in this way allows us to avoid writing a cleanup function that \
users would have to call manually after they were finished with the palette. \
It is not a problem to leave front end sharing turned on, but it is desirable \
to have your program alter the user\[CloseCurlyQuote]s session as little as \
possible."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->7627],

Cell[TextData[{
 "Now let\[CloseCurlyQuote]s expand this example to include more buttons that \
perform different operations. The complete code for this example is provided \
in the file ",
 StyleBox[ButtonBox["Palette.nb",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonFunction:>(NotebookOpen[
    ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "JLink", 
      "Examples", "Part1"}, #]]& )], "MR"],
 " in the ",
 StyleBox["JLink/Examples/Part1", "MR"],
 " directory."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->4802],

Cell[TextData[{
 "The first thing we do is separate the code that manages the frame \
containing the buttons from the code that produces a button. In this way we \
will have a reusable palette frame that can hold any number of different \
buttons. The ",
 StyleBox["ShowPalette", "MR"],
 " function below takes a list of buttons, arranges them vertically in a \
frame window, calls ",
 StyleBox["ShareFrontEnd", "MR"],
 ", and displays the frame in front of the user\[CloseCurlyQuote]s notebook \
window."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->4099],

Cell["\<\
ShowPalette[buttons:{__?JavaObjectQ}] :=
\tJavaBlock[
\t\tModule[{frm, tok},
\t\t\tfrm = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\t\tfrm@setLayout[JavaNew[\"java.awt.GridLayout\", 0, 1]];
\t\t\tfrm@add[#]& /@ buttons;
\t\t\tReleaseJavaObject[buttons];
\t\t\tfrm@pack[];
\t\t\ttok = ShareFrontEnd[];
\t\t\tfrm@onClose[\"UnshareFrontEnd[\" <> ToString[tok] <> \"]\"];
\t\t\tJavaShow[frm];
\t\t]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.8.0",
 CellLabel->"In[5]:=",
 CellID->30527],

Cell[TextData[{
 "Note that we don\[CloseCurlyQuote]t return anything from the ",
 StyleBox["ShowPalette", "MR"],
 " function\[LongDash]specifically, we don\[CloseCurlyQuote]t return the \
frame object itself. This is because we don\[CloseCurlyQuote]t need to refer \
to the frame ever again. It is destroyed automatically when its close box is \
clicked (remember, this is a feature of the ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " class). Because we don\[CloseCurlyQuote]t need to keep references to any \
of the Java objects we create, the entire body of ",
 StyleBox["ShowPalette", "MR"],
 " can be wrapped in ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->2625],

Cell[TextData[{
 "Now let\[CloseCurlyQuote]s create a reusable ",
 StyleBox["PaletteButton", "MR"],
 " function that creates a button. We have to pass in only two things: the \
label text we want on the button and the function (as a string) we want to \
have invoked when the button is clicked. This is sufficient to allow \
completely arbitrary button behavior, as the entire functionality of the \
button is tied up in the button function we pass in as the second argument."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->1543],

Cell["\<\
PaletteButton[label_String, buttonFunc_String] :=
\tJavaBlock[
\t\tModule[{button, listener},
\t\t\tbutton = JavaNew[\"java.awt.Button\"];
\t\t\tbutton@setLabel[label];
\t\t\tlistener = JavaNew[\"com.wolfram.jlink.MathActionListener\", \
buttonFunc];
\t\t\tbutton@addActionListener[listener];
\t\t\tbutton
\t\t]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.8.0",
 CellLabel->"In[6]:=",
 CellID->1924],

Cell[TextData[{
 "We will use the ",
 StyleBox["PaletteButton", "MR"],
 " function to create four buttons. The first is just the print button \
defined above, the behavior of which is specified by ",
 StyleBox["printButtonFunc", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->11023],

Cell[BoxData[
 RowBox[{
  RowBox[{"btn1", "=", 
   RowBox[{"PaletteButton", "[", 
    RowBox[{"\"\<foo\>\"", ",", "\"\<printButtonFunc\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"jlug:5.4.8.0",
 CellLabel->"In[7]:=",
 CellID->29972],

Cell[TextData[{
 "The second will duplicate the functionality of the buttons in the standard \
AlgebraicManipulation front end palette. These buttons wrap a function (e.g., \
",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"], "MR"]], "InlineFormula"],
 ") around the current selection and evaluate the resulting expression in \
place. Here is how we create the button and define the button function for \
that operation:"
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->13061],

Cell["\<\
btn2 = PaletteButton[\"Expand[\[SelectionPlaceholder]]\", \
\"applyButtonFunc\"];

applyButtonFunc[event_, _] :=
\tJavaBlock[
\t\tWith[{nb = SelectedNotebook[]},
\t\t\tNotebookApply[nb, event@getSource[]@getLabel[], All];
\t\t\tReleaseJavaObject[event];
\t\t\tSelectionEvaluate[nb]
\t\t];
\t]\
\>", "Input",
 CellTags->"jlug:5.4.8.0",
 CellLabel->"In[8]:=",
 CellID->14181],

Cell[TextData[{
 "The third button will create a plot. All we have to do is call a plotting \
function\[LongDash]the work of directing the graphics output to a new cell in \
the frontmost notebook is handled internally by ",
 StyleBox["J/Lin",
  FontSlant->"Italic"],
 "k as a result of having front end sharing turned on via ",
 StyleBox["ShareFrontEnd", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->31003],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"btn3", " ", "=", " ", 
    RowBox[{"PaletteButton", "[", 
     RowBox[{"\"\<Create Plot\>\"", ",", " ", "\"\<plotButtonFunc\>\""}], 
     "]"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotButtonFunc", "[", 
   RowBox[{"event_", ",", " ", "_"}], "]"}], " ", ":=", "\n", "\t", 
  RowBox[{"(", "\n", "\t\t", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ";", "\n", "\t\t", 
    RowBox[{"ReleaseJavaObject", "[", "event", "]"}], ";"}], "\n", "\t", 
   ")"}]}]}], "Input",
 CellTags->"jlug:5.4.8.0",
 CellLabel->"In[10]:=",
 CellID->863759],

Cell[TextData[{
 "The final button demonstrates another method for causing text to be \
inserted at the current cursor location. The first example of this, ",
 StyleBox["printButtonFunc", "MR"],
 ", uses ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookApply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookApply"], "MR"]], "InlineFormula"],
 ". We can also just call ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 "\[LongDash]as with graphics, ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output is automatically routed to the frontmost notebook window by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " when front end sharing is on. This quick-and-easy ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " method works fine for many situations when you want something to appear in \
a notebook window, but using ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookApply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookApply"], "MR"]], "InlineFormula"],
 " is a more rigorous technique. You will see some differences in the effects \
of these two buttons if you put the insertion point into a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"], "MR"]], "InlineFormula"],
 " cell and try them."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->17505],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"btn4", " ", "=", " ", 
    RowBox[{"PaletteButton", "[", 
     RowBox[{"\"\<foo\>\"", ",", " ", "\"\<printButtonFunc2\>\""}], "]"}]}], 
   ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"printButtonFunc2", "[", 
   RowBox[{"event_", ",", " ", "_"}], "]"}], " ", ":=", "\n", "\t", 
  RowBox[{"JavaBlock", "[", "\n", "\t\t", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"event", "@", 
      RowBox[{
       RowBox[{"getSource", "[", "]"}], "@", 
       RowBox[{"getLabel", "[", "]"}]}]}], "]"}], ";", "\n", "\t\t", 
    RowBox[{"ReleaseJavaObject", "[", "event", "]"}], ";"}], "\n", "\t", 
   "]"}]}]}], "Input",
 CellTags->"jlug:5.4.8.0",
 CellLabel->"In[12]:=",
 CellID->27593],

Cell["Now we are finally ready to create the palette and show it:", "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->22725],

Cell[BoxData[
 RowBox[{"ShowPalette", "[", 
  RowBox[{"{", 
   RowBox[{"btn1", ",", "btn2", ",", "btn3", ",", "btn4"}], "}"}], 
  "]"}]], "Input",
 CellTags->"jlug:5.4.8.0",
 CellLabel->"In[14]:=",
 CellID->13031],

Cell[TextData[{
 "In closing, it must be noted that although this example has demonstrated \
some useful techniques, it is not a particularly valuable way to use ",
 StyleBox["ShareFrontEnd", "MR"],
 ". In creating a simple palette of buttons, we have done nothing that the \
front end cannot do all by itself. The real uses you will find for ",
 StyleBox["ShareFrontEnd", "MR"],
 " will presumably involve aspects that cannot be duplicated within the front \
end, such as more sophisticated dialog boxes or other user interface \
elements."
}], "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->8492]
}, Open  ]],

Cell[CellGroupData[{

Cell["Real-Time Algebra: A Mini-Application", "Subsection",
 CellTags->{"jlug:5.4.9.0", "TableOfContents_1.5.4.9"},
 CellID->142],

Cell[TextData[{
 "This example will put together everything we have learned about modal and \
modeless Java user interfaces. We will implement the same \
\[OpenCurlyDoubleQuote]mini-application\[CloseCurlyDoubleQuote] (essentially \
just a dialog box) in both modal and modeless flavors. The application is \
inspired by the classic ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " example program RealTimeAlgebra, originally written for the NeXT computer \
by Theodore Gray and then done in HyperCard by Doug Stein and John Bonadies. \
The original RealTimeAlgebra provides an input window into which the user \
types an expression that depends on certain parameters, an output window that \
displays the result of the computation, and some sliders that are used to \
vary the values of the parameters. The output window updates as the sliders \
are moved, hence the name RealTimeAlgebra. Our implementation of \
RealTimeAlgebra will be very simplistic, with only a single slider to modify \
the value of one parameter."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->17222],

Cell[TextData[{
 "The complete code for this example is provided in the file ",
 StyleBox[ButtonBox["RealTimeAlgebra.nb",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonFunction:>(NotebookOpen[
    ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "JLink", 
      "Examples", "Part1"}, #]]& )], "MR"],
 " in the ",
 StyleBox["JLink/Examples/Part1", "MR"],
 " directory."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->31286],

Cell["Here is the function that creates and displays the window:", "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->13064],

Cell["\<\
CreateWindow[] :=
\tModule[{frame, slider, listener},
\t\tInstallJava[];
\t\t(* inText and outText are globals, because we need to refer to
\t\t   them by name in the scrollFunc. This also means we must
\t\t   create them outside the JavaBlock below.
\t\t*)
\t\tinText = JavaNew[\"java.awt.TextArea\", \"Expand[(x+1)^a]\", 8, 40];
\t\toutText = JavaNew[\"java.awt.TextArea\", 8, 40];
\t\t(* This frame could be created inside the JavaBlock, because it is \
returned
\t\t   from the JavaBlock and therefore will not be released, but it makes
\t\t   our intentions more clear to create it outside.
\t\t*)
\t\tframe = JavaNew[\"com.wolfram.jlink.MathFrame\", \"RealTimeAlgebra\"];
\t\tJavaBlock[
\t\t\tframe@setLayout[JavaNew[\"java.awt.BorderLayout\"]];
\t\t\t(* Note that we can refer to the Scrollbar`HORIZONTAL constant within \
the JavaNew
\t\t\t   command that first loads the Scrollbar class. Its value will not \
need to be
\t\t\t   resolved until that class has been loaded and all necessary \
definitions created.
\t\t\t*)
\t\t\tslider = JavaNew[\"java.awt.Scrollbar\", Scrollbar`HORIZONTAL, 0, 1, 0, \
20];
\t\t\tframe@add[slider, ReturnAsJavaObject[BorderLayout`NORTH]];
\t\t\tframe@add[outText, ReturnAsJavaObject[BorderLayout`CENTER]];
\t\t\tframe@add[inText, ReturnAsJavaObject[BorderLayout`SOUTH]];
\t\t\tframe@pack[];
\t\t\t(* Use a fixed-width font for the output window to preserve
\t\t\t   formatting of multi-line expressions. *)
\t\t\toutText@setFont[JavaNew[\"java.awt.Font\", \"Courier\", Font`PLAIN, \
12]];
\t\t\tlistener = JavaNew[\"com.wolfram.jlink.MathAdjustmentListener\"];
\t\t\tlistener@setHandler[\"adjustmentValueChanged\", \"sliderFunc\"];
\t\t\tslider@addAdjustmentListener[listener];
\t\t\tframe@setLocation[200, 200];
\t\t\tJavaShow[frame];
\t\t];
\t\tframe
\t]

(* This is what will be called in response to moving the slider position: *)

sliderFunc[evt_, type_, scrollPos_] :=
\toutText@setText[
\t\tBlock[{a = scrollPos}, ToString[ToExpression[inText@getText[]]]]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.9.0",
 CellLabel->"In[1]:=",
 CellID->7900],

Cell[TextData[{
 "The ",
 StyleBox["sliderFunc", "MR"],
 " function is called by the ",
 Cell[BoxData[
  ButtonBox["MathAdjustmentListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathAdjustmentListener"]], 
  "InlineFormula"],
 " whenever the slider\[CloseCurlyQuote]s position changes. It gets the text \
in the ",
 StyleBox["inputText", "MR"],
 " box, evaluates it in an environment where ",
 StyleBox["a", "MR"],
 " has the value of the slider position (the range for this is 0..20, as \
established in the ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " call that creates the slider), and puts the resulting string into the ",
 StyleBox["outText", "MR"],
 " box. It then calls ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " to release the first argument, which is the ",
 StyleBox["AdjustmentEvent", "MR"],
 " object itself. This is the only object passed in as an argument (the other \
two arguments are integers). If you are wondering how we determine the \
argument sequence for ",
 StyleBox["sliderFunc", "MR"],
 ", we get it from the ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " ",
 ButtonBox["table",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#18935"],
 " in the section Handling Events with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Code: The \[OpenCurlyDoubleQuote]MathListener\[CloseCurlyDoubleQuote] \
Classes. Note that we need to refer by name to the input and output text \
boxes in ",
 StyleBox["sliderFunc", "MR"],
 ", so we cannot make their names local variables in ",
 StyleBox["CreateWindow", "MR"],
 "\[CloseCurlyQuote]s ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "MR"]], "InlineFormula"],
 ", and of course they cannot be created inside that function\
\[CloseCurlyQuote]s ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->19187],

Cell[TextData[{
 "There is one interesting thing in the code that deserves a remark. Look at \
the lines where we add the three components to the frame. What is the ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " doing there? The method we are calling here is in the ",
 StyleBox["Frame", "MR"],
 " class, and has the following signature:"
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->399338963],

Cell["void add(Component comp, Object constraints);", "Program",
 CellTags->"jlug:5.4.9.0",
 CellID->22413],

Cell[TextData[{
 "The second argument, ",
 StyleBox["constraints", "MR"],
 ", is typed only as ",
 StyleBox["Object", "MR"],
 ". The value you pass in depends on the layout manager in use, but typically \
it is a string, as is the case here (",
 StyleBox["BorderLayout`NORTH", "MR"],
 ", for example, is just the string \[OpenCurlyDoubleQuote]NORTH\
\[CloseCurlyDoubleQuote]). The problem is that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " creates a definition for this signature of ",
 StyleBox["add", "MR"],
 " that expects a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " for the second argument, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings do not satisfy ",
 Cell[BoxData[
  ButtonBox["JavaObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObjectQ"]], "InlineFormula"],
 ", although they are converted to Java string objects when sent. This means \
that we can only pass strings to methods that expect an argument of type ",
 StyleBox["String", "MR"],
 ". In the rare cases where a Java method is typed to take an ",
 StyleBox["Object", "MR"],
 " and you want to pass a string from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you must first create a Java ",
 StyleBox["String", "MR"],
 " object with the value you want, and pass that object instead of the raw ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string. We have encountered this issue several times before, and we have \
used ",
 Cell[BoxData[
  ButtonBox["MakeJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFormula"],
 " as the trick to get the raw string turned into a reference to a Java ",
 StyleBox["String", "MR"],
 " object. ",
 StyleBox["MakeJavaObject[BorderLayout`NORTH]", "MR"],
 " would work fine here, but it is instructive to use a different technique \
(it also saves a call into Java). ",
 StyleBox["BorderLayout`NORTH", "MR"],
 " calls into Java to get the value of the ",
 StyleBox["BorderLayout.NORTH", "MR"],
 " static field, but in the process of returning this string object to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it gets converted to a raw ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string. We need the object reference, not the raw string, so we wrap the \
access in ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 ", which causes the string, which is normally returned by value, to be \
returned in the form of a reference."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->30974],

Cell[TextData[{
 "Getting back to the RealTimeAlgebra dialog box, we are now ready to run it \
as a modal window. We write a special modal version that uses ",
 StyleBox["CreateWindow", "MR"],
 " internally:"
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->14270],

Cell["\<\
RealTimeAlgebraModal[] :=
\tJavaBlock[
\t\t(* In the modal case, we can wrap the whole thing in JavaBlock
\t\t   and be sure that all the objects will get released, including
\t\t   the inText and outText ones needed during event handling.
\t\t*)
\t\tModule[{frm},
\t\t\tfrm = CreateWindow[];
\t\t\tfrm@setModal[];
\t\t\tDoModal[];
\t\t]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.9.0",
 CellLabel->"In[4]:=",
 CellID->29170],

Cell[TextData[{
 "Note that the whole function is wrapped in ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ". This is an easy way to make sure that all object references created in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " while the dialog is running are treated as temporary and released when ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " finishes. This saves us having to properly use ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " in all the handler functions used for our ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " objects (you\[CloseCurlyQuote]ll notice that these calls are absent from \
the ",
 StyleBox["sliderFunc", "MR"],
 " function)."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->235],

Cell[TextData[{
 "Now run the dialog. The ",
 StyleBox["RealTimeAlgebraModal", "MR"],
 " function will not return until we close the RealTimeAlgebra window, which \
is what we mean when we call this a \[OpenCurlyDoubleQuote]modal\
\[CloseCurlyDoubleQuote] interface."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->30833],

Cell[BoxData[
 StyleBox[
  RowBox[{"RealTimeAlgebraModal", "[", "]"}], "DisplayMath"]], "Input",
 CellTags->"jlug:5.4.9.0",
 CellLabel->"In[5]:=",
 CellID->19711],

Cell[TextData[{
 "It may take several seconds before the window appears the first time. As \
always, this is the one-time cost of loading all the necessary classes. Play \
around by dragging the slider, and try changing the text in the input box, \
for example, to ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "MR"]], "InlineFormula"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"], "MR"]], "InlineFormula"],
 StyleBox[", 2a]", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->25760],

Cell[TextData[{
 "Recall that while ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is evaluating ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DoModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/DoModal"], "[", "]"}]], "InlineFormula"],
 ", any ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output, messages, graphics, or any other output or commands other than the \
result of computations triggered from Java will be sent to the front end. To \
see this in action, try putting ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 StyleBox["[a]", "MR"],
 " in the input text box (you will want to arrange windows on your screen so \
that you can see the notebook window while you are dragging the slider). \
Next, try ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"], "MR"]], "InlineFormula"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "MR"]], "InlineFormula"],
 StyleBox["[a x], {x, 0, 4 ", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"], "MR"]], "InlineFormula"],
 StyleBox["}]", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->18896],

Cell[TextData[{
 "Quit RealTimeAlgebra by clicking the window\[CloseCurlyQuote]s close box. \
In addition to closing and disposing of the window, this causes ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 " to be executed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", which then causes ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " to return. The disposing of the window is due to our using the ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " class for the window, and executing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EndModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndModal"], "[", "]"}]], "InlineFormula"],
 " is the result of our calling the ",
 StyleBox["setModal()", "MR"],
 " method of ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 ", as discussed in ",
 ButtonBox["Modal Windows",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#32702"],
 "."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->4667],

Cell[TextData[{
 "Now let\[CloseCurlyQuote]s implement RealTimeAlgebra as a modeless window. \
The ",
 StyleBox["CreateWindow", "MR"],
 " function can be used unmodified. The only difference is how we make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " able to service the computations triggered by dragging the slider. For a \
modal window, we use ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " to force ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to pay attention exclusively to the Java link. The drawback to this is \
that we cannot use the kernel from the notebook front end until ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " ends. To allow the notebook front end and Java to share the kernel\
\[CloseCurlyQuote]s attention, we use ",
 StyleBox["ShareKernel", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->7285],

Cell["\<\
RealTimeAlgebraModeless[] :=
\tModule[{frm, token},
\t\tfrm = CreateWindow[];
\t\t\[IndentingNewLine]token = ShareKernel[];
\t\t\[IndentingNewLine](* We use the MathFrame onClose method to specify code \
to
\t\t   be executed when the frame is closed.The use here is
\t\t   typical--we clean up the object references that need to
\t\t   persist throughout the lifetime of the window (otherwise
\t\t   we would leak these references),and we call UnshareKernel
\t\t   to unregister this application's request for kernel sharing.
\t\t*)
\t\tfrm@onClose[
\t\t\t\"ReleaseJavaObject[inText, outText]; UnshareKernel[\" <> \
ToString[token] <> \"];\"
\t\t];
\t\t\[IndentingNewLine]ReleaseJavaObject[frm]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.9.0",
 CellLabel->"In[6]:=",
 CellID->12550],

Cell["Now run it:", "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->140],

Cell[BoxData[
 StyleBox[
  RowBox[{"RealTimeAlgebraModeless", "[", "]"}], "DisplayMath"]], "Input",
 CellTags->"jlug:5.4.9.0",
 CellLabel->"In[7]:=",
 CellID->13694],

Cell[TextData[{
 StyleBox["RealTimeAlgebraModeless", "MR"],
 " returns immediately after the window is displayed, leaving the front end \
and the RealTimeAlgebra window able to use the kernel for computations."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->2695],

Cell[TextData[{
 "We still need a little bit of polish on the modeless version, however. \
First, to avoid leaking object references, we must change ",
 StyleBox["sliderFunc", "MR"],
 ". With the modal version, we did not bother to use ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " in ",
 StyleBox["sliderFunc", "MR"],
 " because we had ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " wrapped in ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ". Every call to ",
 StyleBox["sliderFunc", "MR"],
 ", or any other ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " handler function, occurs entirely within the scope of ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ", so we can handle all object releasing at this level. With a modeless \
interface, we no longer have a single function call that spans the lifetime \
of the window. Thus, we put memory-management functions in our handler \
functions. Here is the new ",
 StyleBox["sliderFunc", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->21624],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"sliderFunc", "[", 
    RowBox[{"evt_", ",", " ", "type_", ",", " ", "scrollPos_"}], "]"}], " ", ":=",
    "\n", "\t", 
   RowBox[{"JavaBlock", "[", "\n", "\t\t", 
    RowBox[{
     RowBox[{"outText", "@", 
      RowBox[{"setText", "[", "\n", "\t\t\t", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", " ", "=", " ", "scrollPos"}], "}"}], ",", " ", 
         RowBox[{"ToString", "[", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"inText", "@", 
            RowBox[{"getText", "[", "]"}]}], "]"}], "]"}]}], "]"}], "\n", 
       "\t\t", "]"}]}], ";", "\n", "\t\t", 
     RowBox[{"ReleaseJavaObject", "[", "evt", "]"}]}], "\n", "\t", "]"}]}], 
  "DisplayMath"]], "Input",
 CellTags->"jlug:5.4.9.0",
 CellLabel->"In[8]:=",
 CellID->28019],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 " here is unnecessary because the code it wraps creates no new object \
references. Out of habit, though, we wrap these handlers in ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ". We need to explicitly call ",
 Cell[BoxData[
  ButtonBox["ReleaseJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
 " on ",
 StyleBox["evt", "MR"],
 ", which is the ",
 StyleBox["AdjustmentEvent", "MR"],
 " object, because its reference is created in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " before ",
 StyleBox["sliderFunc", "MR"],
 " is entered, so it will not be released by the ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ". The ",
 StyleBox["type", "MR"],
 " and ",
 StyleBox["scrollPos", "MR"],
 " arguments are integers, not objects."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->2125],

Cell[TextData[{
 "Try setting the input text to ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 StyleBox["[a]", "MR"],
 ". Notice that nothing appears in the front end when you move the slider, in \
contrast to the modal case. With a modeless interface, the Java link is the \
kernel\[CloseCurlyQuote]s ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"], "MR"]], "InlineFormula"],
 " during the times when the kernel is servicing a request initiated from the \
Java side. Thus, the output from ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " and graphics goes to Java, not the notebook front end. (The Java side \
ignores this output, in case you are wondering.) To get this output sent to \
the front end instead, use ",
 StyleBox["ShareFrontEnd", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->26576],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"ShareFrontEnd", "[", "]"}], ";"}], "DisplayMath"]], "Input",
 CellTags->"jlug:5.4.9.0",
 CellLabel->"In[9]:=",
 CellID->21694],

Cell[TextData[{
 "Now if you set the input text to, say, ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 StyleBox["[a]", "MR"],
 " or ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"], "MR"]], "InlineFormula"],
 StyleBox["[a x, {x,0,a}]", "MR"],
 ", you will see the text and graphics appearing in the front end."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->22658],

Cell[TextData[{
 "When you are finished, quit ",
 StyleBox["RealTimeAlgebra", "InlineCode"],
 " by clicking its close box. Then turn off front end sharing that was turned \
on in the previous input."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->26302],

Cell[BoxData[
 StyleBox[
  RowBox[{"UnshareFrontEnd", "[", "]"}], "DisplayMath"]], "Input",
 CellTags->"jlug:5.4.9.0",
 CellLabel->"(sharing) In[10]:=",
 CellID->17371],

Cell[TextData[{
 "A modal interface is simpler than a modeless one in terms of how it uses ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and is therefore the preferred method unless you specifically need the \
modeless attribute. ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["ShareFrontEnd", "MR"],
 " are complex functions that put the kernel into an unusual state. They work \
fine, but don\[CloseCurlyQuote]t use them unnecessarily."
}], "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->22466]
}, Open  ]],

Cell[CellGroupData[{

Cell["GraphicsDlg: Graphics and Typeset Output in a Window", "Subsection",
 CellTags->{"jlug:5.4.10.0", "TableOfContents_1.5.4.10"},
 CellID->4678],

Cell[TextData[{
 "It is useful to be able to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics and typeset expressions in your Java user interface, and this is \
easy to do using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " class. This example demonstrates a simple dialog box that allows the user \
to type in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression and see the output in the form of a picture. If the expression \
is a plotting or other graphics function, the resulting image is displayed. \
If the expression is not a graphic, then it is typeset in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"], "MR"]], "InlineFormula"],
 " and displayed as a picture. We first present the example in modal form and \
then in modeless form using ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["ShareFrontEnd", "MR"],
 "."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->22593],

Cell[TextData[{
 "This example also demonstrates a trivial example of using Java code that \
was created by a drag-and-drop GUI builder of the type present in most Java \
development environments. For layout of simple windows, it is easy enough to \
do everything from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". We have chosen this method for all the examples in this tutorial, writing \
no Java code of our own and instead scripting the creation and layout of \
controls in windows with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calls into Java. This has the advantage of not requiring any Java classes \
to be written and compiled. For more complex windows, however, you will \
probably find it much easier to create the controls, arrange them in \
position, set their properties in a GUI builder, and let it generate Java \
code for you. You might also want to write some additional Java code by \
hand."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->23851],

Cell[TextData[{
 "If you choose this route, the question becomes, \[OpenCurlyDoubleQuote]How \
do I connect the Java code thus generated with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "?\[CloseCurlyDoubleQuote] Any public fields or methods can be called \
directly from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but your GUI builder may not have made public all the ones you need to \
use. You could make these fields and methods public or add some new public \
methods that expose them. The latter approach is probably preferable since it \
does not involve modifying the code that the GUI builder wrote, which could \
confuse the builder or cause it to overwrite your changes in future \
modifications."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->25484],

Cell[TextData[{
 "The complete code for this example is provided in the ",
 StyleBox["JLink/Examples/Part1/GraphicsDlg", "MR"],
 " directory. Some of the code is in Java."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->1018],

Cell[TextData[{
 "This example uses the GUI builder in the WebGain Visual Caf\[EAcute] Java \
development environment. The builder was used to create a frame window with \
three controls. The frame window was made to be a subclass of ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " because we want to inherit the ",
 StyleBox["setModal()", "MR"],
 " method. In the top left is an AWT ",
 StyleBox["TextArea", "MR"],
 " that serves as the input box for the expression. To its right is an ",
 StyleBox["Evaluate", "SR"],
 " button. Occupying the rest of the window is a ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->28464],

Cell[TextData[{
 "Up to this point, no code has been written by hand at \
all\[LongDash]everything has been done automatically as we dropped components \
into the frame and set their properties. All that is left to do is to wire up \
the button so that when it is clicked the input text is taken and supplied as \
to the ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " via its ",
 StyleBox["setMathCommand()", "MR"],
 " method. We could write that code in Java, using Visual Caf\[EAcute]\
\[CloseCurlyQuote]s Interaction Wizard to wire up this event (similar \
facilities exist in other Java GUI builders). We would have to write some \
Java code by hand, as the code\[CloseCurlyQuote]s logic is more complex than \
can be handled by graphical tools for creating event handlers."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->21119],

Cell[TextData[{
 "Rather than doing that, we will now move to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to script the rest of the behavior because it is easier and more flexible. \
We will need to access the ",
 StyleBox["TextArea", "MR"],
 ", ",
 StyleBox["Button", "MR"],
 ", and ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " objects from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but the GUI builder made these non-public fields of the frame class. \
Thus, we need to add three public methods that return these objects to the \
frame class:"
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->23152],

Cell["\<\
public Button getEvalButton()\t\t{return evalButton;}
public TextArea getInputTextArea()\t{return inputTextArea;}
public MathCanvas getMathCanvas()\t{return mathCanvas;}\
\>", "Program",
 CellTags->"jlug:5.4.10.0",
 CellID->2800],

Cell["\<\
That is all we need to do to the Java code created by the GUI builder.\
\>", "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->18087],

Cell[TextData[{
 "The GUI builder created a subclass of ",
 Cell[BoxData[
  ButtonBox["MathFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathFrame"]], "InlineFormula"],
 " that we named ",
 StyleBox["GraphicsDlg", "MR"],
 ". It also gave it a ",
 StyleBox["main()", "MR"],
 " method that does nothing but create an instance of the frame and make it \
visible. We will not bother with the ",
 StyleBox["main()", "MR"],
 " method, choosing instead to do those two steps manually, since we need a \
reference to the frame."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->31060],

Cell[TextData[{
 "Before we run the code, we need to demonstrate one more feature of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[LongDash]the ability to add directories to the class search path \
dynamically. We need to load the Java classes for this example, but they are \
not on the Java class path. With ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", we can add the directory in which the classes reside to the search path \
by calling ",
 Cell[BoxData[
  ButtonBox["AddToClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFormula"],
 ". This will work exactly as written in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.2 and later. You will need to modify the path if you have an earlier \
version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->1926],

Cell["\<\
classDir = ToFileName[{$TopDirectory, \"AddOns\", \"JLink\",
\t\t\t\t\t\t\"Examples\", \"Part1\", \"GraphicsDlg\"}];
InstallJava[];
AddToClassPath[classDir];\
\>", "Input",
 CellTags->"jlug:5.4.10.0",
 CellLabel->"In[1]:=",
 CellID->273216376],

Cell[TextData[{
 "Here is the first implementation of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to create and run our graphics dialog. This runs the dialog in a \
modal loop."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->4757],

Cell["\<\
DoGraphicsDialogModal[] :=
\tJavaBlock[
\t\tModule[{frm, btn, listener},
\t\t\tInstallJava[];
\t\t\t(* We named the MathFrame subclass GUI builder created \"MyFrame\". *)
\t\t\tfrm = JavaNew[\"GraphicsDlg\"];
\t\t\t(* Here we call one of the accessor methods we had to add
\t\t\t   by hand to the GraphicsDlg class.
\t\t\t*)
\t\t\tbtn = frm@getEvalButton[];
\t\t\tlistener = JavaNew[\"com.wolfram.jlink.MathActionListener\"];
\t\t\tlistener@setHandler[\"actionPerformed\", \"btnFunc\"];
\t\t\tbtn@addActionListener[listener];
\t\t\tJavaShow[frm];
\t\t\tfrm@setModal[];
\t\t\tDoModal[]
\t\t]
\t]
\t
btnFunc[event_, _] :=
\tJavaBlock[
\t\tModule[{frm, expr, textArea, inputText, mathCanvas},
\t\t\tfrm = event@getSource[]@getParent[];
\t\t\t(* Here we call two of the accessor methods we had to add
\t\t\t   by hand to the GraphicsDlg class.
\t\t\t*)
\t\t\ttextArea = frm@getInputTextArea[];
\t\t\tmathCanvas = frm@getMathCanvas[];
\t\t\t
\t\t\tinputText = textArea@getText[];
\t\t\t(* We have to evaluate the expression ahead of time to determine
\t\t\t   whether it is a graphics object or not, so we can decide
\t\t\t   whether it display it as a plot or as a typeset result.
\t\t\t*)
\t\t\texpr = Block[{$DisplayFunction = Identity}, ToExpression[inputText]];
\t\t\tIf[MatchQ[expr, _Graphics | _Graphics3D | _SurfaceGraphics |
\t\t\t\t\t\t\t\tDensityGraphics | _ContourGraphics],
\t\t\t\tmathCanvas@setImageType[MathCanvas`GRAPHICS],
\t\t\t(* else *)
\t\t\t\tmathCanvas@setImageType[MathCanvas`TYPESET];
\t\t\t\tmathCanvas@setUsesTraditionalForm[True]
\t\t\t];
\t\t\tmathCanvas@setMathCommand[ToString[expr, InputForm]];
\t\t\tReleaseJavaObject[event]
\t\t]
\t]\
\>", "Input",
 CellTags->"jlug:5.4.10.0",
 CellLabel->"In[3]:=",
 CellID->32170],

Cell[TextData[{
 "We mentioned in the section ",
 ButtonBox["Creating Windows and Other User Interface Elements",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4596"],
 " that only the notebook front end can perform the feat of taking a typeset \
(i.e., \[OpenCurlyDoubleQuote]box\[CloseCurlyDoubleQuote]) expression and \
creating a graphical representation of it. Thus, the ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " can render typeset expressions provided that it has a front end available \
to farm out the chore of creating the appropriate representation. We are \
using the front end to run this example, but it is really because we are \
running our Java dialog \
\[OpenCurlyDoubleQuote]modally\[CloseCurlyDoubleQuote] that everything works \
the way it does. All the while the dialog is up, the front end is waiting for \
a result from a computation (",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DoModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/DoModal"], "[", "]"}]], "InlineFormula"],
 "), and therefore it is receptive to requests from the kernel for various \
services. As far as the front end is concerned, the code for ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " invoked the request for typesetting, even though it was actually triggered \
by clicking a Java button."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->20315],

Cell["Now run the dialog:", "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->9576],

Cell["DoGraphicsDialogModal[]", "Input",
 CellTags->"jlug:5.4.10.0",
 CellLabel->"In[6]:=",
 CellID->30227],

Cell[TextData[{
 "What if we are not happy with the restriction of running the dialog \
modally? Now we want to have the dialog remain open and active while not \
interfering with normal use of the kernel from the front end. As discussed in \
",
 ButtonBox["Modal Windows",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#32702"],
 " and ",
 ButtonBox["Real-Time Algebra: A Mini-Application",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#142"],
 ", we get a lot of useful behavior regarding the front end for free when we \
run our Java user interface modally. One of these features is that the front \
end is kept receptive to the various sorts of requests the kernel can send to \
it (such as for typesetting services). We know we can run a Java user \
interface in a \[OpenCurlyDoubleQuote]modeless\[CloseCurlyDoubleQuote] way by \
using ",
 StyleBox["ShareKernel", "MR"],
 ", but then we give up the ability to have the kernel use the front end \
during computations initiated by actions in Java. Luckily, the ",
 StyleBox["ShareFrontEnd", "MR"],
 " function exists to restore these features for modeless windows."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->12043],

Cell["\<\
Let\[CloseCurlyQuote]s reimplement the graphics dialog in modeless form.\
\>", "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->22758],

Cell["\<\
DoGraphicsDialogModeless[] :=
\tJavaBlock[
\t\tModule[{frm, btn, listener, tok},
    \t\tInstallJava[];
    \t\tfrm = JavaNew[\"GraphicsDlg\"];
    \t\tbtn = frm@getEvalButton[]; 
\t\t\tlistener = JavaNew[\"com.wolfram.jlink.MathActionListener\"]; 
\t\t\tlistener@setHandler[\"actionPerformed\", \"btnFunc\"];
\t\t\tbtn@addActionListener[listener]; 
     \t\ttok = ShareFrontEnd[];
     \t\tfrm@onClose[\"UnshareFrontEnd[\" <> ToString[tok] <> \"]\"];
     \t\tJavaShow[frm]
     \t]
     ]\
\>", "Input",
 CellTags->"jlug:5.4.10.0",
 CellLabel->"In[7]:=",
 CellID->7164],

Cell[TextData[{
 "The above code is exactly the same as ",
 StyleBox["DoGraphicsDialogModal", "MR"],
 " except for the last few lines. We call ",
 StyleBox["ShareFrontEnd", "MR"],
 " here instead of ",
 StyleBox["setModal", "MR"],
 " and ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 ". That is the only difference\[LongDash]the rest of the code (including ",
 StyleBox["btnFunc", "MR"],
 ") is exactly the same. Notice also that we use the ",
 StyleBox["onClose()", "MR"],
 " method of ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " to execute code that unregisters the request for front end sharing when \
the window is closed."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->5109],

Cell["\<\
Run the modeless version. Note how you can continue to perform computations \
in the front end while the window is active:\
\>", "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->7882],

Cell["DoGraphicsDialogModeless[]", "Input",
 CellTags->"jlug:5.4.10.0",
 CellLabel->"In[8]:=",
 CellID->17086],

Cell[TextData[{
 "This new version functions exactly like the modeless version except that it \
does not leave the front end hanging in the middle of a computation. It is \
interesting to contrast what happens if we turn off front end sharing (but we \
need to leave kernel sharing on or the Java dialog will break completely). We \
can do this by replacing ",
 StyleBox["ShareFrontEnd", "MR"],
 " and ",
 StyleBox["UnshareFrontEnd", "MR"],
 " in ",
 StyleBox["DoGraphicsDialogModeless", "MR"],
 " with ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["UnshareKernel", "MR"],
 ". Now if we use the dialog we will find that it fails to render typeset \
expressions, producing just a blank window, but it still renders graphics \
normally (unless they have some typeset elements in them, such as a plot \
label). We have kept all the functionality intact except for the ability of \
the kernel to make use of the front end for typesetting services."
}], "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->29565]
}, Open  ]],

Cell[CellGroupData[{

Cell["BouncingBalls: Drawing in a Window", "Subsection",
 CellTags->{"jlug:5.4.11.0", "TableOfContents_1.5.4.11"},
 CellID->3487],

Cell[TextData[{
 "This example demonstrates drawing in Java windows using the Java graphics \
API directly from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It also demonstrates the use of the ",
 StyleBox["ServiceJava", "MR"],
 " function to periodically allow event handler callbacks into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from Java. The issues surrounding ",
 StyleBox["ServiceJava", "MR"],
 " and how it compares to ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " and ",
 StyleBox["ShareKernel", "MR"],
 " are discussed in greater detail in ",
 ButtonBox["\[OpenCurlyDoubleQuote]Manual\[CloseCurlyDoubleQuote] Interfaces: \
The ServiceJava Function",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#10585"],
 "."
}], "Text",
 CellTags->"jlug:5.4.11.0",
 CellID->29577],

Cell[TextData[{
 "The full code is a little too long to include here in its entirety, but it \
is available in the sample file ",
 StyleBox[ButtonBox["BouncingBalls.nb",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonFunction:>(NotebookOpen[
    ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "JLink", 
      "Examples", "Part1"}, #]]& )], "MR"],
 " in the ",
 StyleBox["JLink/Examples/Part1", "MR"],
 " directory. Here is an excerpt that demonstrates the use of ",
 StyleBox["ServiceJava", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:5.4.11.0",
 CellID->14474],

Cell["\<\
...
mwl = JavaNew[\"com.wolfram.jlink.MathWindowListener\"];
mwl@setHandler[\"windowClosing\", \"(keepOn = False)&\"];
mathCanvas@addWindowListener[mwl];
keepOn = True;
While[keepOn,
\tg@setColor[bkgndColor];
\tg@fillRect[0, 0, 300, 300];
\tdrawBall[g, #]& /@ balls;
\tmathCanvas@setImage[offscreen];
\tballs = recomputePosition /@ balls;
\tServiceJava[]
];
...\
\>", "Program",
 CellTags->"jlug:5.4.11.0",
 CellID->25627],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["MathWindowListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathWindowListener"]], 
  "InlineFormula"],
 " is used to set ",
 StyleBox["keepOn = ", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "MR"]], "InlineFormula"],
 " when the window is closed, which will cause the loop to terminate. While \
the window is up, mouse clicks will cause new balls to be created, appended \
to the ",
 StyleBox["balls", "MR"],
 " list, and set in motion. This is done with a ",
 Cell[BoxData[
  ButtonBox["MathMouseListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathMouseListener"]], "InlineFormula"],
 " (not shown above). Thus, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " needs to be able to handle calls originating from user actions in Java. As \
discussed in the section ",
 ButtonBox["Creating Windows and Other User Interface Elements",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4596"],
 ", there are three ways to enable ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to do this: ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " (modal interfaces), ",
 StyleBox["ShareKernel", "MR"],
 " or ",
 StyleBox["ShareFrontEnd", "MR"],
 " (modeless interfaces), and ",
 StyleBox["ServiceJava", "MR"],
 " (manual interfaces). A modal loop via ",
 Cell[BoxData[
  ButtonBox["DoModal",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/DoModal"]], "InlineFormula"],
 " would not be appropriate here because the kernel needs to be computing \
something at the same time it is servicing calls from Java (it is computing \
the new positions of the balls and drawing them). ",
 StyleBox["ShareKernel", "MR"],
 " would not help because that is a way to give Java access to the kernel ",
 StyleBox["between",
  FontSlant->"Italic"],
 " computations triggered from the front end, not ",
 StyleBox["during",
  FontSlant->"Italic"],
 " such computations."
}], "Text",
 CellTags->"jlug:5.4.11.0",
 CellID->5629],

Cell[TextData[{
 "We need to periodically point the kernel\[CloseCurlyQuote]s attention at \
Java to service requests if any are pending, then let the kernel get back to \
its other work. The function that does this is ",
 StyleBox["ServiceJava", "MR"],
 ", and the code above is typical in that it has a loop that calls ",
 StyleBox["ServiceJava", "MR"],
 " every time through. The calls from Java that ",
 StyleBox["ServiceJava", "MR"],
 " will handle are the ones from mouse clicks to create new balls and when \
the window is closed."
}], "Text",
 CellTags->"jlug:5.4.11.0",
 CellID->31928]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spirograph", "Subsection",
 CellTags->{"jlug:5.4.12.0", "TableOfContents_1.5.4.12"},
 CellID->25423],

Cell[TextData[{
 "This example is just a little fun to create an interesting, nontrivial \
application\[LongDash]an implementation of a simple Spirograph-type drawing \
program. It is run as a modal window, and it demonstrates drawing into a Java \
window from ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " along with a number of ",
 Cell[BoxData[
  ButtonBox["MathListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathListener"]], "InlineFormula"],
 " objects for various event callbacks. It uses the Java Graphics2D API, so \
it will not run on systems that have only a Java 1.1.x runtime."
}], "Text",
 CellTags->"jlug:5.4.12.0",
 CellID->28520],

Cell[TextData[{
 "The code for this example can be found in the file ",
 StyleBox[ButtonBox["Spirograph.nb",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonFunction:>(NotebookOpen[
    ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "JLink", 
      "Examples", "Part1"}, #]]& )], "MR"],
 " in the ",
 StyleBox["JLink/Examples/Part1", "MR"],
 " directory."
}], "Text",
 CellTags->"jlug:5.4.12.0",
 CellID->6902],

Cell[TextData[{
 "One of the things you will notice is that on a reasonably fast machine, the \
speed is perfectly acceptable. There is nothing to suggest that the entire \
functionality of the application is scripted from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It is very responsive despite the fact that a large number of callbacks \
to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are triggered. For example, the cursor is changed as you float the mouse \
over various regions of the window (it changes to a resize cursor in some \
places), so there is a constant flow of callbacks to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as you move the mouse. This example demonstrates the feasibility of \
writing a sophisticated application entirely in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:5.4.12.0",
 CellID->14962],

Cell[TextData[{
 "This application was written in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but it could also have been written entirely in Java, or a combination of \
Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". An advantage of doing it in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that you generally can be much more productive. Spirograph would have \
taken at least twice as long to write in Java. It is invaluable to be able to \
write and test the program a line at a time, and to debug and modify it while \
it is running. Even if you intend to eventually port the code to pure Java, \
it can be very useful to begin writing it in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", just to take advantage of the scripting mode of development."
}], "Text",
 CellTags->"jlug:5.4.12.0",
 CellID->123],

Cell[TextData[{
 "Modal programs like this are best developed using ",
 StyleBox["ShareFrontEnd", "MR"],
 ", then made modal only when they are complete. Making it modeless while it \
is being developed is necessary to be able to build and debug it \
interactively, because while it is running you can continue to use the front \
end to modify the code, make new definitions, add debugging statements, and \
so on. Using ",
 StyleBox["ShareFrontEnd", "MR"],
 " instead of ",
 StyleBox["ShareKernel", "MR"],
 " for modeless operation lets ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " error and warning messages generated by event callbacks, and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " statement inserted for debugging, show up in the notebook window. Only \
when everything is working as desired do you add the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DoModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/DoModal"], "[", "]"}]], "InlineFormula"],
 " call to turn it into a modal window."
}], "Text",
 CellTags->"jlug:5.4.12.0",
 CellID->24596]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Piano Keyboard", "Subsection",
 CellTags->{"jlug:5.4.13.0", "TableOfContents_1.5.4.13"},
 CellID->3737],

Cell[TextData[{
 "With the inclusion of the Java Sound API in Java 1.3 and later, it becomes \
possible to write Java programs that do sophisticated things with sound, such \
as playing MIDI instruments. The ",
 StyleBox[ButtonBox["Piano.nb",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonFunction:>(NotebookOpen[
    ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "JLink", 
      "Examples", "Part1"}, #]]& )], "MR"],
 " example in the ",
 StyleBox["JLink/Examples/Part1", "MR"],
 " directory displays a keyboard and lets you play it by clicking the mouse. \
A pop up menu at the top lists the available MIDI instruments. This example \
was created precisely because it is so far outside the limitations of \
traditional ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming. Using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", we can actually write a short and completely portable program, entirely \
in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language, that displays a MIDI keyboard and lets you play it! With just a \
little more work, the code could be modified to record a sequence played and \
then return it to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", where you could manipulate it by transposing, altering the tempo, ",
 "and so on."
}], "Text",
 CellTags->"jlug:5.4.13.0",
 CellID->13261]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Calling Java from Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Calling Java from Mathematica", "summary" -> 
    "J/Link provides Mathematica users with the ability to interact with \
arbitrary Java classes directly from Mathematica. You can create objects and \
call methods directly in the Mathematica language. You do not need to write \
any Java code, or prepare in any way the Java classes you want to use. You \
also do not need to know anything about MathLink. In effect, all of Java \
becomes a transparent extension to Mathematica, almost as if every existing \
and future Java class were written in the Mathematica language itself. We \
call this facility 'installable Java' because it generalizes the ability that \
Mathematica has always had to plug in extensions written in other languages \
through the Install function. We will see later how J/Link vastly simplifies \
this procedure for Java compared to languages like C or C++. In fact, J/Link \
makes the procedure go away completely, which is why we say that Java becomes \
a transparent extension to Mathematica. Although Java is often referred to as \
an interpreted language, this is really a misnomer. To use Java you must \
write a complete program, compile it, and then execute it (some environments \
exist that let you interactively execute lines of Java code, but these are \
special tools, and similar tools exist for traditional languages like C). \
Mathematica users have the luxury of working in a true interpreted, \
interactive environment that lets them experiment with functions and build \
and test programs a line at a time. J/Link brings this same productive \
environment to Java programmers. You could say that Mathematica becomes a \
scripting language for Java.", "uri" -> 
    "JLink/tutorial/CallingJavaFromMathematica", "type" -> "Tutorial", 
    "label" -> "J Link Tutorial", "paclet" -> "JLink", "context" -> "", 
    "keywords" -> {}, "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 31, 27.2488178}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "TableOfContents_1.5.1"->{
  Cell[945, 43, 79, 2, 70, "Section",
   CellTags->"TableOfContents_1.5.1",
   CellID->23811]},
 "jlug:5.1.0.0"->{
  Cell[1027, 47, 891, 27, 70, "Text",
   CellTags->"jlug:5.1.0.0",
   CellID->31322],
  Cell[1921, 76, 842, 25, 70, "Text",
   CellTags->"jlug:5.1.0.0",
   CellID->30333],
  Cell[2766, 103, 870, 20, 70, "Text",
   CellTags->"jlug:5.1.0.0",
   CellID->17673],
  Cell[3639, 125, 633, 18, 70, "Text",
   CellTags->"jlug:5.1.0.0",
   CellID->4664]},
 "jlug:5.2.1.0"->{
  Cell[4309, 148, 175, 7, 70, "Section",
   CellTags->{"jlug:5.2.1.0", "TableOfContents_1.5.2.1"},
   CellID->19690],
  Cell[4487, 157, 166, 7, 70, "Text",
   CellTags->"jlug:5.2.1.0",
   CellID->1650],
  Cell[4656, 166, 136, 4, 70, "Input",
   CellTags->"jlug:5.2.1.0",
   CellID->5662]},
 "TableOfContents_1.5.2.1"->{
  Cell[4309, 148, 175, 7, 70, "Section",
   CellTags->{"jlug:5.2.1.0", "TableOfContents_1.5.2.1"},
   CellID->19690]},
 "jlug:5.2.2.0"->{
  Cell[4829, 175, 117, 2, 70, "Section",
   CellTags->{"jlug:5.2.2.0", "TableOfContents_1.5.2.2"},
   CellID->21634]},
 "TableOfContents_1.5.2.2"->{
  Cell[4829, 175, 117, 2, 70, "Section",
   CellTags->{"jlug:5.2.2.0", "TableOfContents_1.5.2.2"},
   CellID->21634]},
 "jlug:5.2.2.1"->{
  Cell[4971, 181, 107, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.2.1", "TableOfContents_1.5.2.2.1"},
   CellID->10893],
  Cell[5081, 185, 415, 15, 70, "Text",
   CellTags->"jlug:5.2.2.1",
   CellID->10353],
  Cell[5499, 202, 1060, 34, 70, "DefinitionBox",
   CellTags->"jlug:5.2.2.1",
   CellID->21416],
  Cell[6562, 238, 89, 2, 70, "Caption",
   CellTags->"jlug:5.2.2.1",
   CellID->13452],
  Cell[6676, 244, 125, 4, 70, "Input",
   CellTags->"jlug:5.2.2.1",
   CellID->14008],
  Cell[6804, 250, 199, 6, 70, "Output",
   CellTags->"jlug:5.2.2.1",
   CellID->7262],
  Cell[7018, 259, 553, 15, 70, "Text",
   CellTags->"jlug:5.2.2.1",
   CellID->22233],
  Cell[7574, 276, 1115, 25, 70, "Text",
   CellTags->"jlug:5.2.2.1",
   CellID->5454],
  Cell[8692, 303, 670, 17, 70, "DefinitionBox",
   CellTags->"jlug:5.2.2.1",
   CellID->16634],
  Cell[9365, 322, 226, 9, 70, "Caption",
   CellTags->"jlug:5.2.2.1",
   CellID->26303]},
 "TableOfContents_1.5.2.2.1"->{
  Cell[4971, 181, 107, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.2.1", "TableOfContents_1.5.2.2.1"},
   CellID->10893]},
 "jlug:5.2.2.2"->{
  Cell[9628, 336, 139, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.2.2", "TableOfContents_1.5.2.2.2"},
   CellID->14256],
  Cell[9770, 340, 625, 18, 70, "Text",
   CellTags->"jlug:5.2.2.2",
   CellID->148],
  Cell[10398, 360, 218, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.2.2",
   CellID->11124],
  Cell[10619, 369, 1040, 30, 70, "Text",
   CellTags->"jlug:5.2.2.2",
   CellID->12317],
  Cell[11662, 401, 215, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.2.2",
   CellID->4213]},
 "TableOfContents_1.5.2.2.2"->{
  Cell[9628, 336, 139, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.2.2", "TableOfContents_1.5.2.2.2"},
   CellID->14256]},
 "jlug:5.2.2.3"->{
  Cell[11914, 413, 121, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.2.3", "TableOfContents_1.5.2.2.3"},
   CellID->27109],
  Cell[12038, 417, 1519, 39, 70, "Text",
   CellTags->"jlug:5.2.2.3",
   CellID->24028],
  Cell[13560, 458, 294, 9, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.2.3",
   CellID->29200],
  Cell[13857, 469, 313, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.2.3",
   CellID->36235640],
  Cell[14173, 481, 1491, 40, 70, "Text",
   CellTags->"jlug:5.2.2.3",
   CellID->21080]},
 "TableOfContents_1.5.2.2.3"->{
  Cell[11914, 413, 121, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.2.3", "TableOfContents_1.5.2.2.3"},
   CellID->27109]},
 "jlug:5.2.3.0"->{
  Cell[15713, 527, 106, 2, 70, "Section",
   CellTags->{"jlug:5.2.3.0", "TableOfContents_1.5.2.3"},
   CellID->24948]},
 "TableOfContents_1.5.2.3"->{
  Cell[15713, 527, 106, 2, 70, "Section",
   CellTags->{"jlug:5.2.3.0", "TableOfContents_1.5.2.3"},
   CellID->24948]},
 "jlug:5.2.3.1"->{
  Cell[15844, 533, 108, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.3.1", "TableOfContents_1.5.2.3.1"},
   CellID->1282],
  Cell[15955, 537, 743, 24, 70, "DefinitionBox",
   CellTags->"jlug:5.2.3.1",
   CellID->13653],
  Cell[16701, 563, 78, 2, 70, "Caption",
   CellTags->"jlug:5.2.3.1",
   CellID->30674],
  Cell[16782, 567, 742, 22, 70, "Text",
   CellTags->"jlug:5.2.3.1",
   CellID->2220],
  Cell[17549, 593, 180, 5, 70, "Input",
   CellTags->"jlug:5.2.3.1",
   CellID->5402],
  Cell[17732, 600, 201, 6, 70, "Output",
   CellTags->"jlug:5.2.3.1",
   CellID->6923],
  Cell[17948, 609, 1287, 38, 70, "Text",
   CellTags->"jlug:5.2.3.1",
   CellID->3831],
  Cell[19238, 649, 344, 9, 70, "Text",
   CellTags->"jlug:5.2.3.1",
   CellID->19369],
  Cell[19585, 660, 891, 27, 70, "DefinitionBox",
   CellTags->"jlug:5.2.3.1",
   CellID->3878],
  Cell[20479, 689, 217, 8, 70, "Caption",
   CellTags->"jlug:5.2.3.1",
   CellID->20259],
  Cell[20699, 699, 580, 18, 70, "Text",
   CellTags->"jlug:5.2.3.1",
   CellID->19008]},
 "TableOfContents_1.5.2.3.1"->{
  Cell[15844, 533, 108, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.3.1", "TableOfContents_1.5.2.3.1"},
   CellID->1282]},
 "jlug:5.2.3.2"->{
  Cell[21316, 722, 122, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.3.2", "TableOfContents_1.5.2.3.2"},
   CellID->22619],
  Cell[21441, 726, 1433, 40, 70, "Text",
   CellTags->"jlug:5.2.3.2",
   CellID->23971],
  Cell[22877, 768, 269, 6, 70, "BulletedText",
   CellTags->"jlug:5.2.3.2",
   CellID->30003],
  Cell[23149, 776, 608, 19, 70, "BulletedText",
   CellTags->"jlug:5.2.3.2",
   CellID->21945],
  Cell[23760, 797, 164, 5, 70, "BulletedText",
   CellTags->"jlug:5.2.3.2",
   CellID->9781],
  Cell[23927, 804, 402, 8, 70, "BulletedText",
   CellTags->"jlug:5.2.3.2",
   CellID->26504],
  Cell[24332, 814, 969, 26, 70, "BulletedText",
   CellTags->"jlug:5.2.3.2",
   CellID->12392],
  Cell[25326, 844, 122, 2, 70, "BulletedText",
   CellTags->"jlug:5.2.3.2",
   CellID->32685],
  Cell[25451, 848, 1266, 38, 70, "Text",
   CellTags->"jlug:5.2.3.2",
   CellID->25313],
  Cell[26720, 888, 1553, 46, 70, "Text",
   CellTags->"jlug:5.2.3.2",
   CellID->6698],
  Cell[28276, 936, 983, 19, 70, "Text",
   CellTags->"jlug:5.2.3.2",
   CellID->5589]},
 "TableOfContents_1.5.2.3.2"->{
  Cell[21316, 722, 122, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.3.2", "TableOfContents_1.5.2.3.2"},
   CellID->22619]},
 "jlug:5.2.3.3"->{
  Cell[29308, 961, 137, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.3.3", "TableOfContents_1.5.2.3.3"},
   CellID->12722],
  Cell[29448, 965, 1503, 34, 70, "Text",
   CellTags->"jlug:5.2.3.3",
   CellID->5938],
  Cell[30954, 1001, 1997, 55, 70, "Text",
   CellTags->"jlug:5.2.3.3",
   CellID->19037],
  Cell[32954, 1058, 2369, 67, 70, "Text",
   CellTags->"jlug:5.2.3.3",
   CellID->6410],
  Cell[35326, 1127, 736, 18, 70, "Text",
   CellTags->"jlug:5.2.3.3",
   CellID->31461],
  Cell[36065, 1147, 149, 6, 70, "Program",
   CellTags->"jlug:5.2.3.3",
   CellID->6234],
  Cell[36217, 1155, 605, 22, 70, "Text",
   CellTags->"jlug:5.2.3.3",
   CellID->12508],
  Cell[36825, 1179, 294, 9, 70, "Text",
   CellTags->"jlug:5.2.3.3",
   CellID->9961]},
 "TableOfContents_1.5.2.3.3"->{
  Cell[29308, 961, 137, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.3.3", "TableOfContents_1.5.2.3.3"},
   CellID->12722]},
 "jlug:5.2.3.4"->{
  Cell[37156, 1193, 108, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.3.4", "TableOfContents_1.5.2.3.4"},
   CellID->3959],
  Cell[37267, 1197, 439, 12, 70, "Text",
   CellTags->"jlug:5.2.3.4",
   CellID->6493],
  Cell[37709, 1211, 112, 4, 70, "Program",
   CellTags->"jlug:5.2.3.4",
   CellID->1515],
  Cell[37824, 1217, 287, 8, 70, "Text",
   CellTags->"jlug:5.2.3.4",
   CellID->25269],
  Cell[38114, 1227, 223, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.3.4",
   CellID->24937],
  Cell[38340, 1236, 192, 5, 70, "Text",
   CellTags->"jlug:5.2.3.4",
   CellID->28869]},
 "TableOfContents_1.5.2.3.4"->{
  Cell[37156, 1193, 108, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.3.4", "TableOfContents_1.5.2.3.4"},
   CellID->3959]},
 "TableOfContents_1.5.2.4"->{
  Cell[38581, 1247, 201, 6, 70, "Section",
   CellTags->{"TableOfContents_1.5.2.4", "1.1.4", "jlug:5.2.4.0"},
   CellID->17780]},
 "1.1.4"->{
  Cell[38581, 1247, 201, 6, 70, "Section",
   CellTags->{"TableOfContents_1.5.2.4", "1.1.4", "jlug:5.2.4.0"},
   CellID->17780]},
 "jlug:5.2.4.0"->{
  Cell[38581, 1247, 201, 6, 70, "Section",
   CellTags->{"TableOfContents_1.5.2.4", "1.1.4", "jlug:5.2.4.0"},
   CellID->17780],
  Cell[38785, 1255, 1047, 26, 70, "Text",
   CellTags->"jlug:5.2.4.0",
   CellID->22578],
  Cell[39835, 1283, 2416, 66, 70, "DefinitionBox",
   CellTags->"jlug:5.2.4.0",
   CellID->12931],
  Cell[42254, 1351, 164, 7, 70, "Caption",
   CellTags->"jlug:5.2.4.0",
   CellID->32544],
  Cell[42421, 1360, 524, 16, 70, "Text",
   CellTags->"jlug:5.2.4.0",
   CellID->3340],
  Cell[42948, 1378, 682, 19, 70, "Text",
   CellTags->"jlug:5.2.4.0",
   CellID->13487],
  Cell[43633, 1399, 180, 6, 70, "Program",
   CellTags->"jlug:5.2.4.0",
   CellID->899],
  Cell[43816, 1407, 1707, 42, 70, "Text",
   CellTags->"jlug:5.2.4.0",
   CellID->22525]},
 "jlug:5.2.5.0"->{
  Cell[45560, 1454, 105, 2, 70, "Section",
   CellTags->{"jlug:5.2.5.0", "TableOfContents_1.5.2.5"},
   CellID->900],
  Cell[45668, 1458, 1006, 27, 70, "Text",
   CellTags->"jlug:5.2.5.0",
   CellID->32591],
  Cell[46677, 1487, 942, 29, 70, "DefinitionBox",
   CellTags->"jlug:5.2.5.0",
   CellID->18762],
  Cell[47622, 1518, 87, 2, 70, "Caption",
   CellTags->"jlug:5.2.5.0",
   CellID->1655],
  Cell[47712, 1522, 142, 6, 70, "Text",
   CellTags->"jlug:5.2.5.0",
   CellID->17410],
  Cell[47879, 1532, 171, 5, 70, "Input",
   CellTags->"jlug:5.2.5.0",
   CellID->6359],
  Cell[48053, 1539, 271, 8, 70, "Output",
   CellTags->"jlug:5.2.5.0",
   CellID->27624],
  Cell[48339, 1550, 1754, 51, 70, "Text",
   CellTags->"jlug:5.2.5.0",
   CellID->20537],
  Cell[50096, 1603, 1113, 30, 70, "Text",
   CellTags->"jlug:5.2.5.0",
   CellID->21548],
  Cell[51212, 1635, 232, 7, 70, "Text",
   CellTags->"jlug:5.2.5.0",
   CellID->6483],
  Cell[51469, 1646, 223, 7, 70, "Input",
   CellTags->"jlug:5.2.5.0",
   CellID->27595],
  Cell[51695, 1655, 269, 8, 70, "Output",
   CellTags->"jlug:5.2.5.0",
   CellID->4041],
  Cell[51979, 1666, 619, 19, 70, "Text",
   CellTags->"jlug:5.2.5.0",
   CellID->3602],
  Cell[52601, 1687, 653, 17, 70, "Text",
   CellTags->"jlug:5.2.5.0",
   CellID->24350],
  Cell[53257, 1706, 357, 12, 70, "Input",
   CellTags->"jlug:5.2.5.0",
   CellID->10291],
  Cell[53617, 1720, 758, 23, 70, "Text",
   CellTags->"jlug:5.2.5.0",
   CellID->30836],
  Cell[54378, 1745, 564, 16, 70, "Text",
   CellTags->"jlug:5.2.5.0",
   CellID->9374],
  Cell[54945, 1763, 667, 20, 70, "Text",
   CellTags->"jlug:5.2.5.0",
   CellID->11020]},
 "TableOfContents_1.5.2.5"->{
  Cell[45560, 1454, 105, 2, 70, "Section",
   CellTags->{"jlug:5.2.5.0", "TableOfContents_1.5.2.5"},
   CellID->900]},
 "TableOfContents_1.5.2.6"->{
  Cell[55649, 1788, 136, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.2.6", "1.1.6", "jlug:5.2.6.0"},
   CellID->15615]},
 "1.1.6"->{
  Cell[55649, 1788, 136, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.2.6", "1.1.6", "jlug:5.2.6.0"},
   CellID->15615]},
 "jlug:5.2.6.0"->{
  Cell[55649, 1788, 136, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.2.6", "1.1.6", "jlug:5.2.6.0"},
   CellID->15615]},
 "jlug:5.2.6.1"->{
  Cell[55810, 1794, 102, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.6.1", "TableOfContents_1.5.2.6.1"},
   CellID->20528],
  Cell[55915, 1798, 850, 25, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->13234],
  Cell[56768, 1825, 716, 19, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->12570],
  Cell[57487, 1846, 2552, 76, 70, "DefinitionBox",
   CellTags->"jlug:5.2.6.1",
   CellID->905],
  Cell[60042, 1924, 158, 7, 70, "Caption",
   CellTags->"jlug:5.2.6.1",
   CellID->9464],
  Cell[60203, 1933, 652, 20, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->19557],
  Cell[60858, 1955, 397, 13, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.6.1",
   CellID->28962],
  Cell[61258, 1970, 280, 8, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->14161],
  Cell[61541, 1980, 643, 18, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->30524],
  Cell[62187, 2000, 1587, 47, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->12549],
  Cell[63777, 2049, 670, 21, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.6.1",
   CellID->17469],
  Cell[64450, 2072, 164, 5, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->330],
  Cell[64617, 2079, 250, 9, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.6.1",
   CellID->31923],
  Cell[64870, 2090, 1177, 33, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->28350],
  Cell[66072, 2127, 171, 5, 70, "Input",
   CellTags->"jlug:5.2.6.1",
   CellID->14333],
  Cell[66246, 2134, 257, 8, 70, "Output",
   CellTags->"jlug:5.2.6.1",
   CellID->22925],
  Cell[66518, 2145, 468, 17, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->10910],
  Cell[66989, 2164, 161, 5, 70, "Input",
   CellTags->"jlug:5.2.6.1",
   CellID->19737],
  Cell[67153, 2171, 209, 8, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->16336],
  Cell[67365, 2181, 180, 7, 70, "Input",
   CellTags->"jlug:5.2.6.1",
   CellID->18337],
  Cell[67548, 2190, 900, 25, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->1278],
  Cell[68451, 2217, 299, 11, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.6.1",
   CellID->12393],
  Cell[68753, 2230, 390, 13, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->30714],
  Cell[69146, 2245, 911, 21, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->28164],
  Cell[70060, 2268, 239, 8, 70, "Input",
   CellTags->"jlug:5.2.6.1",
   CellID->31591],
  Cell[70302, 2278, 1601, 43, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->19949],
  Cell[71906, 2323, 152, 5, 70, "Input",
   CellTags->"jlug:5.2.6.1",
   CellID->19135],
  Cell[72061, 2330, 781, 23, 70, "Text",
   CellTags->"jlug:5.2.6.1",
   CellID->2505],
  Cell[72845, 2355, 264, 9, 70, "Input",
   CellTags->"jlug:5.2.6.1",
   CellID->13337]},
 "TableOfContents_1.5.2.6.1"->{
  Cell[55810, 1794, 102, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.6.1", "TableOfContents_1.5.2.6.1"},
   CellID->20528]},
 "jlug:5.2.6.2"->{
  Cell[73146, 2369, 121, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.6.2", "TableOfContents_1.5.2.6.2"},
   CellID->10004],
  Cell[73270, 2373, 666, 15, 70, "Text",
   CellTags->"jlug:5.2.6.2",
   CellID->16337],
  Cell[73939, 2390, 281, 9, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.6.2",
   CellID->2623],
  Cell[74223, 2401, 203, 5, 70, "Text",
   CellTags->"jlug:5.2.6.2",
   CellID->28664],
  Cell[74429, 2408, 232, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.6.2",
   CellID->9970],
  Cell[74664, 2417, 284, 7, 70, "Text",
   CellTags->"jlug:5.2.6.2",
   CellID->25608],
  Cell[74973, 2428, 222, 6, 70, "Input",
   CellTags->"jlug:5.2.6.2",
   CellID->30568],
  Cell[75198, 2436, 96, 3, 70, "Output",
   CellTags->"jlug:5.2.6.2",
   CellID->19281],
  Cell[75309, 2442, 115, 2, 70, "Text",
   CellTags->"jlug:5.2.6.2",
   CellID->7085],
  Cell[75449, 2448, 189, 6, 70, "Input",
   CellTags->"jlug:5.2.6.2",
   CellID->9152],
  Cell[75641, 2456, 973, 25, 70, "Output",
   CellTags->"jlug:5.2.6.2",
   CellID->18373]},
 "TableOfContents_1.5.2.6.2"->{
  Cell[73146, 2369, 121, 2, 70, "Subsection",
   CellTags->{"jlug:5.2.6.2", "TableOfContents_1.5.2.6.2"},
   CellID->10004]},
 "jlug:5.2.7.0"->{
  Cell[76675, 2488, 135, 2, 70, "Section",
   CellTags->{"jlug:5.2.7.0", "TableOfContents_1.5.2.7"},
   CellID->8526],
  Cell[76813, 2492, 237, 7, 70, "Text",
   CellTags->"jlug:5.2.7.0",
   CellID->13357],
  Cell[77053, 2501, 5439, 188, 70, "DefinitionBox",
   CellTags->"jlug:5.2.7.0",
   CellID->29337],
  Cell[82495, 2691, 108, 2, 70, "Caption",
   CellTags->"jlug:5.2.7.0",
   CellID->23271],
  Cell[82606, 2695, 731, 25, 70, "Text",
   CellTags->"jlug:5.2.7.0",
   CellID->23869],
  Cell[83340, 2722, 730, 21, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.2.7.0",
   CellID->29361],
  Cell[84073, 2745, 583, 21, 70, "Text",
   CellTags->"jlug:5.2.7.0",
   CellID->12896],
  Cell[84659, 2768, 710, 24, 70, "Text",
   CellTags->"jlug:5.2.7.0",
   CellID->13022],
  Cell[85372, 2794, 450, 14, 70, "DefinitionBox",
   CellTags->"jlug:5.2.7.0",
   CellID->29617],
  Cell[85825, 2810, 92, 2, 70, "Caption",
   CellTags->"jlug:5.2.7.0",
   CellID->10112],
  Cell[85920, 2814, 1356, 44, 70, "Text",
   CellTags->"jlug:5.2.7.0",
   CellID->12717],
  Cell[87279, 2860, 227, 7, 70, "Input",
   CellTags->"jlug:5.2.7.0",
   CellID->18696],
  Cell[87509, 2869, 552, 19, 70, "Text",
   CellTags->"jlug:5.2.7.0",
   CellID->11585]},
 "TableOfContents_1.5.2.7"->{
  Cell[76675, 2488, 135, 2, 70, "Section",
   CellTags->{"jlug:5.2.7.0", "TableOfContents_1.5.2.7"},
   CellID->8526]},
 "jlug:5.2.8.0"->{
  Cell[88098, 2893, 118, 2, 70, "Section",
   CellTags->{"jlug:5.2.8.0", "TableOfContents_1.5.2.8"},
   CellID->23439],
  Cell[88219, 2897, 393, 14, 70, "Text",
   CellTags->"jlug:5.2.8.0",
   CellID->13428],
  Cell[88615, 2913, 470, 15, 70, "DefinitionBox",
   CellTags->"jlug:5.2.8.0",
   CellID->5912],
  Cell[89088, 2930, 87, 2, 70, "Caption",
   CellTags->"jlug:5.2.8.0",
   CellID->9762],
  Cell[89178, 2934, 911, 27, 70, "Text",
   CellTags->"jlug:5.2.8.0",
   CellID->5967],
  Cell[90092, 2963, 1090, 30, 70, "Text",
   CellTags->"jlug:5.2.8.0",
   CellID->24408],
  Cell[91185, 2995, 1130, 31, 70, "Text",
   CellTags->"jlug:5.2.8.0",
   CellID->4415]},
 "TableOfContents_1.5.2.8"->{
  Cell[88098, 2893, 118, 2, 70, "Section",
   CellTags->{"jlug:5.2.8.0", "TableOfContents_1.5.2.8"},
   CellID->23439]},
 "jlug:5.2.9.0"->{
  Cell[92352, 3031, 110, 2, 70, "Section",
   CellTags->{"jlug:5.2.9.0", "TableOfContents_1.5.2.9"},
   CellID->31163],
  Cell[92465, 3035, 615, 18, 70, "Text",
   CellTags->"jlug:5.2.9.0",
   CellID->16683],
  Cell[93083, 3055, 895, 26, 70, "DefinitionBox",
   CellTags->"jlug:5.2.9.0",
   CellID->13716],
  Cell[93981, 3083, 142, 6, 70, "Caption",
   CellTags->"jlug:5.2.9.0",
   CellID->19932],
  Cell[94148, 3093, 118, 3, 70, "Input",
   CellTags->"jlug:5.2.9.0",
   CellID->25452],
  Cell[94269, 3098, 120, 3, 70, "Output",
   CellTags->"jlug:5.2.9.0",
   CellID->2741],
  Cell[94426, 3106, 123, 3, 70, "Input",
   CellTags->"jlug:5.2.9.0",
   CellID->4954],
  Cell[94552, 3111, 96, 3, 70, "Output",
   CellTags->"jlug:5.2.9.0",
   CellID->6813],
  Cell[94685, 3119, 123, 3, 70, "Input",
   CellTags->"jlug:5.2.9.0",
   CellID->2862],
  Cell[94811, 3124, 94, 3, 70, "Output",
   CellTags->"jlug:5.2.9.0",
   CellID->10396],
  Cell[94920, 3130, 740, 25, 70, "Text",
   CellTags->"jlug:5.2.9.0",
   CellID->15460]},
 "TableOfContents_1.5.2.9"->{
  Cell[92352, 3031, 110, 2, 70, "Section",
   CellTags->{"jlug:5.2.9.0", "TableOfContents_1.5.2.9"},
   CellID->31163]},
 "TableOfContents_1.5.3.1"->{
  Cell[95697, 3160, 210, 7, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.1", "1.2.1", "jlug:5.3.1.0"},
   CellID->19629]},
 "1.2.1"->{
  Cell[95697, 3160, 210, 7, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.1", "1.2.1", "jlug:5.3.1.0"},
   CellID->19629],
  Cell[116853, 3824, 118, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.2", "1.2.1", "jlug:5.3.2.0"},
   CellID->28396]},
 "jlug:5.3.1.0"->{
  Cell[95697, 3160, 210, 7, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.1", "1.2.1", "jlug:5.3.1.0"},
   CellID->19629]},
 "jlug:5.3.1.1"->{
  Cell[95932, 3171, 115, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.1.1", "TableOfContents_1.5.3.1.1"},
   CellID->12623],
  Cell[96050, 3175, 408, 8, 70, "Text",
   CellTags->"jlug:5.3.1.1",
   CellID->24084],
  Cell[96461, 3185, 918, 19, 70, "Text",
   CellTags->"jlug:5.3.1.1",
   CellID->19954],
  Cell[97382, 3206, 691, 20, 70, "Text",
   CellTags->"jlug:5.3.1.1",
   CellID->18756]},
 "TableOfContents_1.5.3.1.1"->{
  Cell[95932, 3171, 115, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.1.1", "TableOfContents_1.5.3.1.1"},
   CellID->12623]},
 "jlug:5.3.1.2"->{
  Cell[98110, 3231, 129, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.1.2", "TableOfContents_1.5.3.1.2"},
   CellID->11840],
  Cell[98242, 3235, 163, 5, 70, "Text",
   CellTags->"jlug:5.3.1.2",
   CellID->4966],
  Cell[98408, 3242, 303, 7, 70, "Text",
   CellTags->"jlug:5.3.1.2",
   CellID->7376],
  Cell[98714, 3251, 1171, 22, 70, "Text",
   CellTags->"jlug:5.3.1.2",
   CellID->13931],
  Cell[99888, 3275, 749, 18, 70, "Text",
   CellTags->"jlug:5.3.1.2",
   CellID->26308],
  Cell[100640, 3295, 300, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.1.2",
   CellID->16944],
  Cell[100943, 3307, 296, 9, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.1.2",
   CellID->5040986],
  Cell[101242, 3318, 802, 23, 70, "Text",
   CellTags->"jlug:5.3.1.2",
   CellID->32439],
  Cell[102047, 3343, 759, 20, 70, "Text",
   CellTags->"jlug:5.3.1.2",
   CellID->24626]},
 "TableOfContents_1.5.3.1.2"->{
  Cell[98110, 3231, 129, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.1.2", "TableOfContents_1.5.3.1.2"},
   CellID->11840]},
 "jlug:5.3.1.3"->{
  Cell[102843, 3368, 132, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.1.3", "TableOfContents_1.5.3.1.3"},
   CellID->11323],
  Cell[102978, 3372, 690, 18, 70, "Text",
   CellTags->"jlug:5.3.1.3",
   CellID->5537],
  Cell[103671, 3392, 615, 20, 70, "DefinitionBox",
   CellTags->"jlug:5.3.1.3",
   CellID->21538],
  Cell[104289, 3414, 96, 2, 70, "Caption",
   CellTags->"jlug:5.3.1.3",
   CellID->16118],
  Cell[104388, 3418, 934, 20, 70, "Text",
   CellTags->"jlug:5.3.1.3",
   CellID->2082],
  Cell[105325, 3440, 506, 15, 70, "Text",
   CellTags->"jlug:5.3.1.3",
   CellID->22929],
  Cell[105834, 3457, 1659, 46, 70, "Text",
   CellTags->"jlug:5.3.1.3",
   CellID->16541],
  Cell[107496, 3505, 518, 18, 70, "Text",
   CellTags->"jlug:5.3.1.3",
   CellID->4833],
  Cell[108017, 3525, 185, 6, 70, "Input",
   CellTags->"jlug:5.3.1.3",
   CellID->31115],
  Cell[108205, 3533, 527, 17, 70, "Text",
   CellTags->"jlug:5.3.1.3",
   CellID->4639]},
 "TableOfContents_1.5.3.1.3"->{
  Cell[102843, 3368, 132, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.1.3", "TableOfContents_1.5.3.1.3"},
   CellID->11323]},
 "jlug:5.3.1.4"->{
  Cell[108769, 3555, 120, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.1.4", "TableOfContents_1.5.3.1.4"},
   CellID->29658],
  Cell[108892, 3559, 954, 26, 70, "Text",
   CellTags->"jlug:5.3.1.4",
   CellID->22704],
  Cell[109849, 3587, 517, 18, 70, "DefinitionBox",
   CellTags->"jlug:5.3.1.4",
   CellID->9930],
  Cell[110369, 3607, 95, 2, 70, "Caption",
   CellTags->"jlug:5.3.1.4",
   CellID->13977]},
 "TableOfContents_1.5.3.1.4"->{
  Cell[108769, 3555, 120, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.1.4", "TableOfContents_1.5.3.1.4"},
   CellID->29658]},
 "jlug:5.3.1.5"->{
  Cell[110501, 3614, 206, 7, 70, "Subsection",
   CellTags->{"jlug:5.3.1.5", "TableOfContents_1.5.3.1.5"},
   CellID->2306],
  Cell[110710, 3623, 669, 20, 70, "Text",
   CellTags->"jlug:5.3.1.5",
   CellID->31673],
  Cell[111404, 3647, 301, 10, 70, "Input",
   CellTags->"jlug:5.3.1.5",
   CellID->22386],
  Cell[111708, 3659, 1084, 22, 70, "Message",
   CellTags->"jlug:5.3.1.5",
   CellID->5021],
  Cell[112795, 3683, 100, 3, 70, "Output",
   CellTags->"jlug:5.3.1.5",
   CellID->28745],
  Cell[112910, 3689, 1034, 28, 70, "Text",
   CellTags->"jlug:5.3.1.5",
   CellID->26924],
  Cell[113947, 3719, 382, 10, 70, "Input",
   CellTags->"jlug:5.3.1.5",
   CellID->19072],
  Cell[114332, 3731, 201, 8, 70, "Text",
   CellTags->"jlug:5.3.1.5",
   CellID->6270],
  Cell[114536, 3741, 199, 6, 70, "Input",
   CellTags->"jlug:5.3.1.5",
   CellID->5829],
  Cell[114738, 3749, 414, 12, 70, "Text",
   CellTags->"jlug:5.3.1.5",
   CellID->26777],
  Cell[115155, 3763, 452, 9, 70, "Text",
   CellTags->"jlug:5.3.1.5",
   CellID->15573],
  Cell[115610, 3774, 190, 6, 70, "Program",
   CellTags->"jlug:5.3.1.5",
   CellID->5097],
  Cell[115803, 3782, 362, 12, 70, "Text",
   CellTags->"jlug:5.3.1.5",
   CellID->16512],
  Cell[116168, 3796, 175, 6, 70, "Input",
   CellTags->"jlug:5.3.1.5",
   CellID->23986],
  Cell[116346, 3804, 458, 14, 70, "Text",
   CellTags->"jlug:5.3.1.5",
   CellID->13290]},
 "TableOfContents_1.5.3.1.5"->{
  Cell[110501, 3614, 206, 7, 70, "Subsection",
   CellTags->{"jlug:5.3.1.5", "TableOfContents_1.5.3.1.5"},
   CellID->2306]},
 "TableOfContents_1.5.3.2"->{
  Cell[116853, 3824, 118, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.2", "1.2.1", "jlug:5.3.2.0"},
   CellID->28396]},
 "jlug:5.3.2.0"->{
  Cell[116853, 3824, 118, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.2", "1.2.1", "jlug:5.3.2.0"},
   CellID->28396]},
 "jlug:5.3.2.1"->{
  Cell[116996, 3830, 120, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.2.1", "TableOfContents_1.5.3.2.1"},
   CellID->7572],
  Cell[117119, 3834, 314, 7, 70, "Text",
   CellTags->"jlug:5.3.2.1",
   CellID->6249],
  Cell[117436, 3843, 603, 14, 70, "Text",
   CellTags->"jlug:5.3.2.1",
   CellID->14640],
  Cell[118042, 3859, 1329, 30, 70, "Text",
   CellTags->"jlug:5.3.2.1",
   CellID->29174],
  Cell[119374, 3891, 1211, 30, 70, "Text",
   CellTags->"jlug:5.3.2.1",
   CellID->18819]},
 "TableOfContents_1.5.3.2.1"->{
  Cell[116996, 3830, 120, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.2.1", "TableOfContents_1.5.3.2.1"},
   CellID->7572]},
 "jlug:5.3.2.4"->{
  Cell[120622, 3926, 128, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.2.4", "TableOfContents_1.5.3.2.4"},
   CellID->16074],
  Cell[120753, 3930, 761, 16, 70, "Text",
   CellTags->"jlug:5.3.2.4",
   CellID->13509],
  Cell[121517, 3948, 1277, 34, 70, "Text",
   CellTags->"jlug:5.3.2.4",
   CellID->30300],
  Cell[122797, 3984, 1364, 37, 70, "Text",
   CellTags->"jlug:5.3.2.4",
   CellID->19695],
  Cell[124164, 4023, 1060, 33, 70, "Text",
   CellTags->"jlug:5.3.2.4",
   CellID->9573],
  Cell[125227, 4058, 293, 9, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.2.4",
   CellID->15589],
  Cell[125523, 4069, 423, 12, 70, "Text",
   CellTags->"jlug:5.3.2.4",
   CellID->13161],
  Cell[125949, 4083, 785, 25, 70, "Text",
   CellTags->"jlug:5.3.2.4",
   CellID->31172]},
 "TableOfContents_1.5.3.2.4"->{
  Cell[120622, 3926, 128, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.2.4", "TableOfContents_1.5.3.2.4"},
   CellID->16074]},
 "jlug:5.3.2.5"->{
  Cell[126771, 4113, 119, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.2.5", "TableOfContents_1.5.3.2.5"},
   CellID->17968],
  Cell[126893, 4117, 542, 15, 70, "Text",
   CellTags->"jlug:5.3.2.5",
   CellID->27358],
  Cell[127438, 4134, 243, 8, 70, "Input",
   CellTags->"jlug:5.3.2.5",
   CellID->26031],
  Cell[127684, 4144, 217, 8, 70, "Text",
   CellTags->"jlug:5.3.2.5",
   CellID->26268],
  Cell[127926, 4156, 154, 5, 70, "Input",
   CellTags->"jlug:5.3.2.5",
   CellID->19426],
  Cell[128083, 4163, 108, 3, 70, "Output",
   CellTags->"jlug:5.3.2.5",
   CellID->28510],
  Cell[128206, 4169, 224, 6, 70, "Text",
   CellTags->"jlug:5.3.2.5",
   CellID->10422],
  Cell[128433, 4177, 255, 9, 70, "Input",
   CellTags->"jlug:5.3.2.5",
   CellID->30774],
  Cell[128691, 4188, 279, 11, 70, "Input",
   CellTags->"jlug:5.3.2.5",
   CellID->8779],
  Cell[128973, 4201, 551, 15, 70, "Text",
   CellTags->"jlug:5.3.2.5",
   CellID->30910],
  Cell[129527, 4218, 238, 8, 70, "Input",
   CellTags->"jlug:5.3.2.5",
   CellID->23552],
  Cell[129768, 4228, 612, 20, 70, "Text",
   CellTags->"jlug:5.3.2.5",
   CellID->4182],
  Cell[130383, 4250, 283, 11, 70, "Input",
   CellTags->"jlug:5.3.2.5",
   CellID->25391],
  Cell[130669, 4263, 684, 19, 70, "Text",
   CellTags->"jlug:5.3.2.5",
   CellID->15495],
  Cell[131356, 4284, 418, 12, 70, "Text",
   CellTags->"jlug:5.3.2.5",
   CellID->5764],
  Cell[131777, 4298, 310, 11, 70, "Program",
   CellTags->"jlug:5.3.2.5",
   CellID->874],
  Cell[132090, 4311, 101, 2, 70, "Text",
   CellTags->"jlug:5.3.2.5",
   CellID->1364],
  Cell[132194, 4315, 336, 11, 70, "Input",
   CellTags->"jlug:5.3.2.5",
   CellID->67080215]},
 "TableOfContents_1.5.3.2.5"->{
  Cell[126771, 4113, 119, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.2.5", "TableOfContents_1.5.3.2.5"},
   CellID->17968]},
 "TableOfContents_1.5.3.3"->{
  Cell[132579, 4332, 138, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.3", "1.2.2", "jlug:5.3.3.0"},
   CellID->12158]},
 "1.2.2"->{
  Cell[132579, 4332, 138, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.3", "1.2.2", "jlug:5.3.3.0"},
   CellID->12158]},
 "jlug:5.3.3.0"->{
  Cell[132579, 4332, 138, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.3", "1.2.2", "jlug:5.3.3.0"},
   CellID->12158]},
 "jlug:5.3.3.1"->{
  Cell[132742, 4338, 181, 6, 70, "Subsection",
   CellTags->{"jlug:5.3.3.1", "TableOfContents_1.5.3.3.1"},
   CellID->12022],
  Cell[132926, 4346, 1488, 43, 70, "Text",
   CellTags->"jlug:5.3.3.1",
   CellID->1146],
  Cell[134417, 4391, 1418, 41, 70, "Text",
   CellTags->"jlug:5.3.3.1",
   CellID->18392],
  Cell[135838, 4434, 870, 30, 70, "DefinitionBox",
   CellTags->"jlug:5.3.3.1",
   CellID->13037],
  Cell[136711, 4466, 95, 2, 70, "Caption",
   CellTags->"jlug:5.3.3.1",
   CellID->3925],
  Cell[136809, 4470, 78, 2, 70, "Text",
   CellTags->"jlug:5.3.3.1",
   CellID->10647],
  Cell[136912, 4476, 229, 7, 70, "Input",
   CellTags->"jlug:5.3.3.1",
   CellID->29458],
  Cell[137144, 4485, 270, 8, 70, "Output",
   CellTags->"jlug:5.3.3.1",
   CellID->6602],
  Cell[137429, 4496, 236, 8, 70, "Text",
   CellTags->"jlug:5.3.3.1",
   CellID->30807],
  Cell[137668, 4506, 289, 9, 70, "Input",
   CellTags->"jlug:5.3.3.1",
   CellID->4098],
  Cell[137960, 4517, 261, 8, 70, "Text",
   CellTags->"jlug:5.3.3.1",
   CellID->27830],
  Cell[138224, 4527, 168, 6, 70, "Input",
   CellTags->"jlug:5.3.3.1",
   CellID->29292],
  Cell[138395, 4535, 815, 26, 70, "Text",
   CellTags->"jlug:5.3.3.1",
   CellID->14600],
  Cell[139235, 4565, 179, 6, 70, "Input",
   CellTags->"jlug:5.3.3.1",
   CellID->7278],
  Cell[139417, 4573, 98, 3, 70, "Output",
   CellTags->"jlug:5.3.3.1",
   CellID->20799],
  Cell[139530, 4579, 515, 19, 70, "Text",
   CellTags->"jlug:5.3.3.1",
   CellID->18352],
  Cell[140070, 4602, 218, 7, 70, "Input",
   CellTags->"jlug:5.3.3.1",
   CellID->20448],
  Cell[140291, 4611, 97, 3, 70, "Output",
   CellTags->"jlug:5.3.3.1",
   CellID->13882],
  Cell[140403, 4617, 426, 12, 70, "Text",
   CellTags->"jlug:5.3.3.1",
   CellID->540],
  Cell[140854, 4633, 213, 7, 70, "Input",
   CellTags->"jlug:5.3.3.1",
   CellID->28315],
  Cell[141070, 4642, 96, 3, 70, "Output",
   CellTags->"jlug:5.3.3.1",
   CellID->4575],
  Cell[141181, 4648, 1443, 41, 70, "Text",
   CellTags->"jlug:5.3.3.1",
   CellID->8762],
  Cell[142627, 4691, 1089, 29, 70, "Text",
   CellTags->"jlug:5.3.3.1",
   CellID->9567]},
 "TableOfContents_1.5.3.3.1"->{
  Cell[132742, 4338, 181, 6, 70, "Subsection",
   CellTags->{"jlug:5.3.3.1", "TableOfContents_1.5.3.3.1"},
   CellID->12022]},
 "jlug:5.3.3.2"->{
  Cell[143753, 4725, 113, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.3.2", "TableOfContents_1.5.3.3.2"},
   CellID->22336],
  Cell[143869, 4729, 1888, 49, 70, "Text",
   CellTags->"jlug:5.3.3.2",
   CellID->18397],
  Cell[145782, 4782, 172, 5, 70, "Input",
   CellTags->"jlug:5.3.3.2",
   CellID->31418],
  Cell[145957, 4789, 271, 8, 70, "Output",
   CellTags->"jlug:5.3.3.2",
   CellID->19897],
  Cell[146243, 4800, 190, 7, 70, "Text",
   CellTags->"jlug:5.3.3.2",
   CellID->25828],
  Cell[146436, 4809, 138, 4, 70, "Input",
   CellTags->"jlug:5.3.3.2",
   CellID->13851],
  Cell[146577, 4815, 135, 6, 70, "Text",
   CellTags->"jlug:5.3.3.2",
   CellID->26816],
  Cell[146715, 4823, 2797, 94, 70, "DefinitionBox",
   CellTags->"jlug:5.3.3.2",
   CellID->24230],
  Cell[149515, 4919, 96, 2, 70, "Caption",
   CellTags->"jlug:5.3.3.2",
   CellID->4449],
  Cell[149614, 4923, 691, 19, 70, "Text",
   CellTags->"jlug:5.3.3.2",
   CellID->16925],
  Cell[150308, 4944, 768, 23, 70, "Text",
   CellTags->"jlug:5.3.3.2",
   CellID->658],
  Cell[151079, 4969, 303, 10, 70, "Input",
   CellTags->"jlug:5.3.3.2",
   CellID->229],
  Cell[151385, 4981, 278, 12, 70, "Text",
   CellTags->"jlug:5.3.3.2",
   CellID->24520],
  Cell[151666, 4995, 193, 7, 70, "Input",
   CellTags->"jlug:5.3.3.2",
   CellID->10940],
  Cell[151862, 5004, 503, 19, 70, "Text",
   CellTags->"jlug:5.3.3.2",
   CellID->29560],
  Cell[152368, 5025, 764, 18, 70, "Text",
   CellTags->"jlug:5.3.3.2",
   CellID->15147]},
 "TableOfContents_1.5.3.3.2"->{
  Cell[143753, 4725, 113, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.3.2", "TableOfContents_1.5.3.3.2"},
   CellID->22336]},
 "jlug:5.3.3.3"->{
  Cell[153169, 5048, 105, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.3.3", "TableOfContents_1.5.3.3.3"},
   CellID->25162],
  Cell[153277, 5052, 655, 16, 70, "Text",
   CellTags->"jlug:5.3.3.3",
   CellID->639716680],
  Cell[153935, 5070, 1675, 47, 70, "Text",
   CellTags->"jlug:5.3.3.3",
   CellID->20675],
  Cell[155613, 5119, 844, 21, 70, "Text",
   CellTags->"jlug:5.3.3.3",
   CellID->792],
  Cell[156460, 5142, 951, 24, 70, "Text",
   CellTags->"jlug:5.3.3.3",
   CellID->22361],
  Cell[157414, 5168, 167, 7, 70, "Text",
   CellTags->"jlug:5.3.3.3",
   CellID->31754],
  Cell[157584, 5177, 227, 10, 70, "Text",
   CellTags->"jlug:5.3.3.3",
   CellID->16398],
  Cell[157814, 5189, 451, 11, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.3.3",
   CellID->23146],
  Cell[158268, 5202, 710, 21, 70, "Text",
   CellTags->"jlug:5.3.3.3",
   CellID->8714],
  Cell[158981, 5225, 878, 24, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.3.3",
   CellID->26946],
  Cell[159862, 5251, 2390, 69, 70, "Text",
   CellTags->"jlug:5.3.3.3",
   CellID->21188],
  Cell[162255, 5322, 381, 15, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.3.3",
   CellID->19569],
  Cell[162639, 5339, 2122, 62, 70, "Text",
   CellTags->"jlug:5.3.3.3",
   CellID->8638]},
 "TableOfContents_1.5.3.3.3"->{
  Cell[153169, 5048, 105, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.3.3", "TableOfContents_1.5.3.3.3"},
   CellID->25162]},
 "jlug:5.3.3.5"->{
  Cell[164798, 5406, 135, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.3.5", "TableOfContents_1.5.3.3.5"},
   CellID->24515],
  Cell[164936, 5410, 1689, 49, 70, "Text",
   CellTags->"jlug:5.3.3.5",
   CellID->11521],
  Cell[166628, 5461, 1428, 44, 70, "Text",
   CellTags->"jlug:5.3.3.5",
   CellID->475]},
 "TableOfContents_1.5.3.3.5"->{
  Cell[164798, 5406, 135, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.3.5", "TableOfContents_1.5.3.3.5"},
   CellID->24515]},
 "TableOfContents_1.5.3.4"->{
  Cell[168105, 5511, 110, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.4", "1.2.3", "jlug:5.3.4.0"},
   CellID->10195]},
 "1.2.3"->{
  Cell[168105, 5511, 110, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.4", "1.2.3", "jlug:5.3.4.0"},
   CellID->10195]},
 "jlug:5.3.4.0"->{
  Cell[168105, 5511, 110, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.4", "1.2.3", "jlug:5.3.4.0"},
   CellID->10195]},
 "jlug:5.3.4.1"->{
  Cell[168240, 5517, 122, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.4.1", "TableOfContents_1.5.3.4.1"},
   CellID->32525],
  Cell[168365, 5521, 398, 11, 70, "Text",
   CellTags->"jlug:5.3.4.1",
   CellID->1264],
  Cell[168788, 5536, 278, 8, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.4.1",
   CellID->8260],
  Cell[169069, 5546, 318, 9, 70, "Message",
   CellTags->"jlug:5.3.4.1",
   CellID->6202],
  Cell[169390, 5557, 117, 4, 70, "Output",
   CellTags->"jlug:5.3.4.1",
   CellID->8116],
  Cell[169522, 5564, 1002, 26, 70, "Text",
   CellTags->"jlug:5.3.4.1",
   CellID->5030],
  Cell[170527, 5592, 363, 9, 70, "Text",
   CellTags->"jlug:5.3.4.1",
   CellID->20326]},
 "TableOfContents_1.5.3.4.1"->{
  Cell[168240, 5517, 122, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.4.1", "TableOfContents_1.5.3.4.1"},
   CellID->32525]},
 "jlug:5.3.4.2"->{
  Cell[170927, 5606, 118, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.4.2", "TableOfContents_1.5.3.4.2"},
   CellID->29011],
  Cell[171048, 5610, 600, 19, 70, "Text",
   CellTags->"jlug:5.3.4.2",
   CellID->30771],
  Cell[171651, 5631, 326, 10, 70, "DefinitionBox",
   CellTags->"jlug:5.3.4.2",
   CellID->6411],
  Cell[171980, 5643, 157, 6, 70, "Caption",
   CellTags->"jlug:5.3.4.2",
   CellID->25547],
  Cell[172140, 5651, 1466, 43, 70, "Text",
   CellTags->"jlug:5.3.4.2",
   CellID->21153],
  Cell[173609, 5696, 1545, 35, 70, "Text",
   CellTags->"jlug:5.3.4.2",
   CellID->21520],
  Cell[175157, 5733, 426, 13, 70, "Input",
   CellTags->"jlug:5.3.4.2",
   CellID->29790],
  Cell[175586, 5748, 363, 12, 70, "Text",
   CellTags->"jlug:5.3.4.2",
   CellID->14924]},
 "TableOfContents_1.5.3.4.2"->{
  Cell[170927, 5606, 118, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.4.2", "TableOfContents_1.5.3.4.2"},
   CellID->29011]},
 "TableOfContents_1.5.3.5"->{
  Cell[175998, 5766, 351, 11, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.5", "1.2.5", "jlug:5.3.5.0"},
   CellID->31497]},
 "1.2.5"->{
  Cell[175998, 5766, 351, 11, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.5", "1.2.5", "jlug:5.3.5.0"},
   CellID->31497]},
 "jlug:5.3.5.0"->{
  Cell[175998, 5766, 351, 11, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.5", "1.2.5", "jlug:5.3.5.0"},
   CellID->31497]},
 "jlug:5.3.5.1"->{
  Cell[176374, 5781, 116, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.5.1", "TableOfContents_1.5.3.5.1"},
   CellID->2785],
  Cell[176493, 5785, 1793, 58, 70, "Text",
   CellTags->"jlug:5.3.5.1",
   CellID->18529],
  Cell[178289, 5845, 1145, 28, 70, "Text",
   CellTags->"jlug:5.3.5.1",
   CellID->31540],
  Cell[179437, 5875, 530, 14, 70, "Text",
   CellTags->"jlug:5.3.5.1",
   CellID->18805],
  Cell[179970, 5891, 1567, 54, 70, "DefinitionBox",
   CellTags->"jlug:5.3.5.1",
   CellID->28791],
  Cell[181540, 5947, 304, 11, 70, "Caption",
   CellTags->"jlug:5.3.5.1",
   CellID->13392]},
 "TableOfContents_1.5.3.5.1"->{
  Cell[176374, 5781, 116, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.5.1", "TableOfContents_1.5.3.5.1"},
   CellID->2785]},
 "jlug:5.3.5.2"->{
  Cell[181881, 5963, 114, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.5.2", "TableOfContents_1.5.3.5.2"},
   CellID->13210],
  Cell[181998, 5967, 567, 15, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->13549],
  Cell[182590, 5986, 394, 12, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.5.2",
   CellID->21578],
  Cell[182987, 6000, 183, 6, 70, "Output",
   CellTags->"jlug:5.3.5.2",
   CellID->26979],
  Cell[183185, 6009, 476, 16, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->30971],
  Cell[183686, 6029, 280, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.5.2",
   CellID->9277],
  Cell[183969, 6041, 193, 7, 70, "Output",
   CellTags->"jlug:5.3.5.2",
   CellID->73],
  Cell[184177, 6051, 1220, 32, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->20193],
  Cell[185400, 6085, 402, 11, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->1620],
  Cell[185827, 6100, 290, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.5.2",
   CellID->21497],
  Cell[186120, 6112, 257, 8, 70, "Output",
   CellTags->"jlug:5.3.5.2",
   CellID->13826],
  Cell[186392, 6123, 590, 16, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->31276],
  Cell[187007, 6143, 330, 11, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.5.2",
   CellID->19790],
  Cell[187340, 6156, 195, 7, 70, "Output",
   CellTags->"jlug:5.3.5.2",
   CellID->6582],
  Cell[187550, 6166, 589, 17, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->13578],
  Cell[188142, 6185, 1221, 30, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->11159],
  Cell[189366, 6217, 304, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.5.2",
   CellID->20418],
  Cell[189673, 6229, 370, 13, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->26489],
  Cell[190046, 6244, 351, 11, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.5.2",
   CellID->159],
  Cell[190400, 6257, 229, 6, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->3449],
  Cell[190632, 6265, 1408, 43, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->12924],
  Cell[192065, 6312, 126, 4, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.5.2",
   CellID->9072],
  Cell[192194, 6318, 272, 9, 70, "Output",
   CellTags->"jlug:5.3.5.2",
   CellID->10380],
  Cell[192481, 6330, 474, 13, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->27008],
  Cell[192958, 6345, 1491, 36, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->27967],
  Cell[194452, 6383, 778, 22, 70, "Text",
   CellTags->"jlug:5.3.5.2",
   CellID->10208]},
 "TableOfContents_1.5.3.5.2"->{
  Cell[181881, 5963, 114, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.5.2", "TableOfContents_1.5.3.5.2"},
   CellID->13210]},
 "jlug:5.3.5.3"->{
  Cell[195267, 6410, 117, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.5.3", "TableOfContents_1.5.3.5.3"},
   CellID->6477],
  Cell[195387, 6414, 727, 19, 70, "Text",
   CellTags->"jlug:5.3.5.3",
   CellID->18503],
  Cell[196117, 6435, 1012, 32, 70, "Text",
   CellTags->"jlug:5.3.5.3",
   CellID->15370],
  Cell[197154, 6471, 153, 4, 70, "Input",
   CellTags->"jlug:5.3.5.3",
   CellID->32607],
  Cell[197310, 6477, 206, 5, 70, "Output",
   CellTags->"jlug:5.3.5.3",
   CellID->14196],
  Cell[197531, 6485, 640, 20, 70, "Text",
   CellTags->"jlug:5.3.5.3",
   CellID->12074],
  Cell[198174, 6507, 692, 22, 70, "Text",
   CellTags->"jlug:5.3.5.3",
   CellID->13722],
  Cell[198891, 6533, 191, 6, 70, "Input",
   CellTags->"jlug:5.3.5.3",
   CellID->12611],
  Cell[199085, 6541, 277, 9, 70, "Output",
   CellTags->"jlug:5.3.5.3",
   CellID->19019],
  Cell[199399, 6555, 142, 4, 70, "Input",
   CellTags->"jlug:5.3.5.3",
   CellID->28761],
  Cell[199544, 6561, 110, 3, 70, "Output",
   CellTags->"jlug:5.3.5.3",
   CellID->11056],
  Cell[199669, 6567, 522, 17, 70, "Text",
   CellTags->"jlug:5.3.5.3",
   CellID->12890]},
 "TableOfContents_1.5.3.5.3"->{
  Cell[195267, 6410, 117, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.5.3", "TableOfContents_1.5.3.5.3"},
   CellID->6477]},
 "TableOfContents_1.5.3.6"->{
  Cell[200240, 6590, 131, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.6", "1.2.6", "jlug:5.3.6.0"},
   CellID->29288]},
 "1.2.6"->{
  Cell[200240, 6590, 131, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.6", "1.2.6", "jlug:5.3.6.0"},
   CellID->29288]},
 "jlug:5.3.6.0"->{
  Cell[200240, 6590, 131, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.6", "1.2.6", "jlug:5.3.6.0"},
   CellID->29288]},
 "jlug:5.3.6.1"->{
  Cell[200396, 6596, 104, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.6.1", "TableOfContents_1.5.3.6.1"},
   CellID->28082],
  Cell[200503, 6600, 1406, 44, 70, "Text",
   CellTags->"jlug:5.3.6.1",
   CellID->1954]},
 "TableOfContents_1.5.3.6.1"->{
  Cell[200396, 6596, 104, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.6.1", "TableOfContents_1.5.3.6.1"},
   CellID->28082]},
 "jlug:5.3.6.2"->{
  Cell[201946, 6649, 110, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.6.2", "TableOfContents_1.5.3.6.2"},
   CellID->16085],
  Cell[202059, 6653, 541, 17, 70, "DefinitionBox",
   CellTags->"jlug:5.3.6.2",
   CellID->20710],
  Cell[202603, 6672, 77, 2, 70, "Caption",
   CellTags->"jlug:5.3.6.2",
   CellID->24484],
  Cell[202683, 6676, 1331, 38, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->24774],
  Cell[204017, 6716, 82, 2, 70, "Program",
   CellTags->"jlug:5.3.6.2",
   CellID->8380],
  Cell[204102, 6720, 382, 13, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->29815],
  Cell[204509, 6737, 173, 5, 70, "Input",
   CellTags->"jlug:5.3.6.2",
   CellID->25951],
  Cell[204685, 6744, 345, 9, 70, "Message",
   CellTags->"jlug:5.3.6.2",
   CellID->6541],
  Cell[205033, 6755, 118, 4, 70, "Output",
   CellTags->"jlug:5.3.6.2",
   CellID->18115],
  Cell[205166, 6762, 442, 13, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->1679],
  Cell[205633, 6779, 229, 7, 70, "Input",
   CellTags->"jlug:5.3.6.2",
   CellID->17110],
  Cell[205865, 6788, 277, 9, 70, "Output",
   CellTags->"jlug:5.3.6.2",
   CellID->25898],
  Cell[206157, 6800, 260, 9, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->23073],
  Cell[206420, 6811, 154, 5, 70, "Input",
   CellTags->"jlug:5.3.6.2",
   CellID->788],
  Cell[206577, 6818, 474, 17, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->23977],
  Cell[207054, 6837, 207, 7, 70, "Input",
   CellTags->"jlug:5.3.6.2",
   CellID->18132],
  Cell[207264, 6846, 1694, 51, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->29956],
  Cell[208983, 6901, 134, 4, 70, "Input",
   CellTags->"jlug:5.3.6.2",
   CellID->28689],
  Cell[209120, 6907, 270, 9, 70, "Output",
   CellTags->"jlug:5.3.6.2",
   CellID->26113],
  Cell[209405, 6919, 1006, 31, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->10008],
  Cell[210414, 6952, 268, 10, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->12941],
  Cell[210707, 6966, 136, 4, 70, "Input",
   CellTags->"jlug:5.3.6.2",
   CellID->15790],
  Cell[210846, 6972, 270, 9, 70, "Output",
   CellTags->"jlug:5.3.6.2",
   CellID->1723],
  Cell[211131, 6984, 1051, 28, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->21363],
  Cell[212207, 7016, 240, 8, 70, "Input",
   CellTags->"jlug:5.3.6.2",
   CellID->28],
  Cell[212450, 7026, 259, 8, 70, "Output",
   CellTags->"jlug:5.3.6.2",
   CellID->25184],
  Cell[212724, 7037, 599, 17, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->24778],
  Cell[213348, 7058, 339, 11, 70, "Input",
   CellTags->"jlug:5.3.6.2",
   CellID->7200],
  Cell[213690, 7071, 258, 8, 70, "Output",
   CellTags->"jlug:5.3.6.2",
   CellID->5071],
  Cell[213963, 7082, 787, 21, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->1885],
  Cell[214753, 7105, 1751, 50, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->21974],
  Cell[216507, 7157, 205, 6, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.6.2",
   CellID->1071],
  Cell[216715, 7165, 1118, 32, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->11333],
  Cell[217836, 7199, 838, 23, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->22867],
  Cell[218677, 7224, 99, 2, 70, "Program",
   CellTags->"jlug:5.3.6.2",
   CellID->26153],
  Cell[218779, 7228, 266, 9, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->14295],
  Cell[219070, 7241, 357, 11, 70, "Input",
   CellTags->"jlug:5.3.6.2",
   CellID->32168],
  Cell[219430, 7254, 419, 9, 70, "Message",
   CellTags->"jlug:5.3.6.2",
   CellID->20825],
  Cell[219852, 7265, 100, 3, 70, "Output",
   CellTags->"jlug:5.3.6.2",
   CellID->9676],
  Cell[219967, 7271, 308, 11, 70, "Text",
   CellTags->"jlug:5.3.6.2",
   CellID->15629],
  Cell[220278, 7284, 331, 10, 70, "Input",
   CellTags->"jlug:5.3.6.2",
   CellID->28650]},
 "TableOfContents_1.5.3.6.2"->{
  Cell[201946, 6649, 110, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.6.2", "TableOfContents_1.5.3.6.2"},
   CellID->16085]},
 "jlug:5.3.6.3"->{
  Cell[220646, 7299, 107, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.6.3", "TableOfContents_1.5.3.6.3"},
   CellID->2598],
  Cell[220756, 7303, 1266, 38, 70, "Text",
   CellTags->"jlug:5.3.6.3",
   CellID->3309],
  Cell[222025, 7343, 548, 19, 70, "DefinitionBox",
   CellTags->"jlug:5.3.6.3",
   CellID->4693],
  Cell[222576, 7364, 74, 2, 70, "Caption",
   CellTags->"jlug:5.3.6.3",
   CellID->4686],
  Cell[222653, 7368, 1594, 49, 70, "Text",
   CellTags->"jlug:5.3.6.3",
   CellID->30080],
  Cell[224250, 7419, 883, 27, 70, "Text",
   CellTags->"jlug:5.3.6.3",
   CellID->10116],
  Cell[225158, 7450, 264, 8, 70, "Input",
   CellTags->"jlug:5.3.6.3",
   CellID->12249],
  Cell[225425, 7460, 284, 9, 70, "Output",
   CellTags->"jlug:5.3.6.3",
   CellID->26667],
  Cell[225746, 7474, 143, 5, 70, "Input",
   CellTags->"jlug:5.3.6.3",
   CellID->1528],
  Cell[225892, 7481, 95, 3, 70, "Output",
   CellTags->"jlug:5.3.6.3",
   CellID->26679],
  Cell[226024, 7489, 146, 5, 70, "Input",
   CellTags->"jlug:5.3.6.3",
   CellID->7864],
  Cell[226173, 7496, 118, 4, 70, "Output",
   CellTags->"jlug:5.3.6.3",
   CellID->29421],
  Cell[226328, 7505, 222, 8, 70, "Input",
   CellTags->"jlug:5.3.6.3",
   CellID->8405],
  Cell[226553, 7515, 207, 7, 70, "Output",
   CellTags->"jlug:5.3.6.3",
   CellID->8826],
  Cell[226775, 7525, 366, 15, 70, "Text",
   CellTags->"jlug:5.3.6.3",
   CellID->6816],
  Cell[227166, 7544, 141, 4, 70, "Input",
   CellTags->"jlug:5.3.6.3",
   CellID->7516],
  Cell[227310, 7550, 174, 6, 70, "Output",
   CellTags->"jlug:5.3.6.3",
   CellID->27726],
  Cell[227499, 7559, 434, 13, 70, "Text",
   CellTags->"jlug:5.3.6.3",
   CellID->28666]},
 "TableOfContents_1.5.3.6.3"->{
  Cell[220646, 7299, 107, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.6.3", "TableOfContents_1.5.3.6.3"},
   CellID->2598]},
 "jlug:5.3.7.0"->{
  Cell[227982, 7578, 140, 2, 70, "Section",
   CellTags->{"jlug:5.3.7.0", "TableOfContents_1.5.3.7"},
   CellID->4596]},
 "TableOfContents_1.5.3.7"->{
  Cell[227982, 7578, 140, 2, 70, "Section",
   CellTags->{"jlug:5.3.7.0", "TableOfContents_1.5.3.7"},
   CellID->4596]},
 "jlug:5.3.7.1"->{
  Cell[228147, 7584, 104, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.1", "TableOfContents_1.5.3.7.1"},
   CellID->24021],
  Cell[228254, 7588, 1128, 24, 70, "Text",
   CellTags->"jlug:5.3.7.1",
   CellID->27348],
  Cell[229385, 7614, 588, 19, 70, "Text",
   CellTags->"jlug:5.3.7.1",
   CellID->23199],
  Cell[229976, 7635, 789, 22, 70, "Text",
   CellTags->"jlug:5.3.7.1",
   CellID->19668]},
 "TableOfContents_1.5.3.7.1"->{
  Cell[228147, 7584, 104, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.1", "TableOfContents_1.5.3.7.1"},
   CellID->24021]},
 "jlug:5.3.7.2"->{
  Cell[230802, 7662, 142, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.2", "TableOfContents_1.5.3.7.2"},
   CellID->314330245],
  Cell[230947, 7666, 387, 12, 70, "Text",
   CellTags->"jlug:5.3.7.2",
   CellID->8281],
  Cell[231337, 7680, 1768, 43, 70, "Text",
   CellTags->"jlug:5.3.7.2",
   CellID->4734],
  Cell[233108, 7725, 780, 19, 70, "Text",
   CellTags->"jlug:5.3.7.2",
   CellID->53],
  Cell[233891, 7746, 694, 15, 70, "Text",
   CellTags->"jlug:5.3.7.2",
   CellID->1999],
  Cell[234588, 7763, 673, 13, 70, "Text",
   CellTags->"jlug:5.3.7.2",
   CellID->26418],
  Cell[235264, 7778, 2239, 60, 70, "Text",
   CellTags->"jlug:5.3.7.2",
   CellID->27938],
  Cell[237506, 7840, 829, 18, 70, "Text",
   CellTags->"jlug:5.3.7.2",
   CellID->6900],
  Cell[238338, 7860, 1517, 36, 70, "Text",
   CellTags->"jlug:5.3.7.2",
   CellID->3788],
  Cell[239858, 7898, 1852, 52, 70, "Text",
   CellTags->"jlug:5.3.7.2",
   CellID->18127]},
 "TableOfContents_1.5.3.7.2"->{
  Cell[230802, 7662, 142, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.2", "TableOfContents_1.5.3.7.2"},
   CellID->314330245]},
 "jlug:5.3.7.3"->{
  Cell[241747, 7955, 125, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.3", "TableOfContents_1.5.3.7.3"},
   CellID->467],
  Cell[241875, 7959, 738, 21, 70, "Text",
   CellTags->"jlug:5.3.7.3",
   CellID->3728],
  Cell[242616, 7982, 802, 16, 70, "Text",
   CellTags->"jlug:5.3.7.3",
   CellID->14893],
  Cell[243421, 8000, 1073, 23, 70, "Text",
   CellTags->"jlug:5.3.7.3",
   CellID->24648],
  Cell[244497, 8025, 921, 17, 70, "Text",
   CellTags->"jlug:5.3.7.3",
   CellID->22483],
  Cell[245421, 8044, 341, 9, 70, "Text",
   CellTags->"jlug:5.3.7.3",
   CellID->17807]},
 "TableOfContents_1.5.3.7.3"->{
  Cell[241747, 7955, 125, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.3", "TableOfContents_1.5.3.7.3"},
   CellID->467]},
 "jlug:5.3.7.4"->{
  Cell[245799, 8058, 265, 8, 70, "Subsection",
   CellTags->{"jlug:5.3.7.4", "TableOfContents_1.5.3.7.4"},
   CellID->2421],
  Cell[246067, 8068, 898, 14, 70, "Text",
   CellTags->"jlug:5.3.7.4",
   CellID->14310],
  Cell[246968, 8084, 1001, 22, 70, "Text",
   CellTags->"jlug:5.3.7.4",
   CellID->6617],
  Cell[247972, 8108, 425, 8, 70, "Text",
   CellTags->"jlug:5.3.7.4",
   CellID->22813],
  Cell[248400, 8118, 940, 23, 70, "Text",
   CellTags->"jlug:5.3.7.4",
   CellID->9514],
  Cell[249343, 8143, 732, 15, 70, "Text",
   CellTags->"jlug:5.3.7.4",
   CellID->14309],
  Cell[250078, 8160, 946, 26, 70, "Text",
   CellTags->"jlug:5.3.7.4",
   CellID->7616],
  Cell[251027, 8188, 9265, 285, 70, "DefinitionBox",
   CellTags->"jlug:5.3.7.4",
   CellID->18935],
  Cell[260295, 8475, 158, 7, 70, "Caption",
   CellTags->"jlug:5.3.7.4",
   CellID->17451],
  Cell[260456, 8484, 1800, 49, 70, "Text",
   CellTags->"jlug:5.3.7.4",
   CellID->20600],
  Cell[262259, 8535, 1666, 46, 70, "Text",
   CellTags->"jlug:5.3.7.4",
   CellID->5249],
  Cell[263928, 8583, 697, 22, 70, "DefinitionBox",
   CellTags->"jlug:5.3.7.4",
   CellID->16519],
  Cell[264628, 8607, 212, 7, 70, "Caption",
   CellTags->"jlug:5.3.7.4",
   CellID->31556],
  Cell[264843, 8616, 515, 14, 70, "Text",
   CellTags->"jlug:5.3.7.4",
   CellID->22798],
  Cell[265361, 8632, 3010, 86, 70, "Text",
   CellTags->"jlug:5.3.7.4",
   CellID->30303]},
 "TableOfContents_1.5.3.7.4"->{
  Cell[245799, 8058, 265, 8, 70, "Subsection",
   CellTags->{"jlug:5.3.7.4", "TableOfContents_1.5.3.7.4"},
   CellID->2421]},
 "jlug:5.3.7.5"->{
  Cell[268408, 8723, 134, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.5", "TableOfContents_1.5.3.7.5"},
   CellID->6224],
  Cell[268545, 8727, 889, 20, 70, "Text",
   CellTags->"jlug:5.3.7.5",
   CellID->11008],
  Cell[269437, 8749, 1564, 52, 70, "Text",
   CellTags->"jlug:5.3.7.5",
   CellID->5844],
  Cell[271004, 8803, 441, 14, 70, "DefinitionBox",
   CellTags->"jlug:5.3.7.5",
   CellID->32609],
  Cell[271448, 8819, 103, 2, 70, "Caption",
   CellTags->"jlug:5.3.7.5",
   CellID->14989]},
 "TableOfContents_1.5.3.7.5"->{
  Cell[268408, 8723, 134, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.5", "TableOfContents_1.5.3.7.5"},
   CellID->6224]},
 "jlug:5.3.7.6"->{
  Cell[271588, 8826, 109, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.6", "TableOfContents_1.5.3.7.6"},
   CellID->32702],
  Cell[271700, 8830, 907, 24, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->3195],
  Cell[272610, 8856, 1036, 32, 70, "Input",
   CellTags->"jlug:5.3.7.6",
   CellID->20485],
  Cell[273649, 8890, 239, 6, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->3093],
  Cell[273891, 8898, 287, 9, 70, "Input",
   CellTags->"jlug:5.3.7.6",
   CellID->14343],
  Cell[274181, 8909, 406, 13, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->30523],
  Cell[274590, 8924, 231, 8, 70, "Input",
   CellTags->"jlug:5.3.7.6",
   CellID->1587],
  Cell[274824, 8934, 167, 6, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->29314],
  Cell[274994, 8942, 199, 7, 70, "Input",
   CellTags->"jlug:5.3.7.6",
   CellID->9503],
  Cell[275196, 8951, 977, 30, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->7448],
  Cell[276176, 8983, 579, 15, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->25200],
  Cell[276758, 9000, 252, 8, 70, "Input",
   CellTags->"jlug:5.3.7.6",
   CellID->13458],
  Cell[277013, 9010, 238, 7, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->6618],
  Cell[277254, 9019, 806, 23, 70, "Input",
   CellTags->"jlug:5.3.7.6",
   CellID->20580],
  Cell[278063, 9044, 908, 20, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->19796],
  Cell[278974, 9066, 701, 22, 70, "DefinitionBox",
   CellTags->"jlug:5.3.7.6",
   CellID->14798],
  Cell[279678, 9090, 99, 2, 70, "Caption",
   CellTags->"jlug:5.3.7.6",
   CellID->15281],
  Cell[279780, 9094, 2002, 63, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->19589],
  Cell[281785, 9159, 966, 28, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->20798],
  Cell[282754, 9189, 437, 13, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->28009],
  Cell[283194, 9204, 348, 12, 70, "Input",
   CellTags->"jlug:5.3.7.6",
   CellID->27157],
  Cell[283545, 9218, 638, 21, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->20472],
  Cell[284186, 9241, 251, 8, 70, "Input",
   CellTags->"jlug:5.3.7.6",
   CellID->23622],
  Cell[284440, 9251, 2136, 61, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->18538],
  Cell[286579, 9314, 326, 13, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.7.6",
   CellID->12292],
  Cell[286908, 9329, 1060, 35, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->6038],
  Cell[287971, 9366, 147, 5, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->24179],
  Cell[288121, 9373, 122, 4, 70, "Input",
   CellTags->"jlug:5.3.7.6",
   CellID->18190],
  Cell[288246, 9379, 1082, 36, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->29657],
  Cell[289331, 9417, 328, 11, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->7958],
  Cell[289662, 9430, 1368, 49, 70, "Input",
   CellTags->"jlug:5.3.7.6",
   CellID->6191],
  Cell[291033, 9481, 2380, 68, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->19815],
  Cell[293416, 9551, 1574, 49, 70, "Text",
   CellTags->"jlug:5.3.7.6",
   CellID->22888]},
 "TableOfContents_1.5.3.7.6"->{
  Cell[271588, 8826, 109, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.6", "TableOfContents_1.5.3.7.6"},
   CellID->32702]},
 "jlug:5.3.7.7"->{
  Cell[295027, 9605, 120, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.7", "TableOfContents_1.5.3.7.7"},
   CellID->19156],
  Cell[295150, 9609, 1804, 50, 70, "Text",
   CellTags->"jlug:5.3.7.7",
   CellID->11511]},
 "TableOfContents_1.5.3.7.7"->{
  Cell[295027, 9605, 120, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.7", "TableOfContents_1.5.3.7.7"},
   CellID->19156]},
 "jlug:5.3.7.8"->{
  Cell[296991, 9664, 142, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.8", "TableOfContents_1.5.3.7.8"},
   CellID->16202],
  Cell[297136, 9668, 1054, 27, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->2634],
  Cell[298193, 9697, 1493, 33, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->24272],
  Cell[299689, 9732, 619, 14, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->20055],
  Cell[300311, 9748, 981, 34, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->20328],
  Cell[301295, 9784, 1880, 61, 70, "DefinitionBox",
   CellTags->"jlug:5.3.7.8",
   CellID->22646],
  Cell[303178, 9847, 81, 2, 70, "Caption",
   CellTags->"jlug:5.3.7.8",
   CellID->26362],
  Cell[303262, 9851, 693, 21, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->4886],
  Cell[303958, 9874, 143, 5, 70, "Input",
   CellTags->"jlug:5.3.7.8",
   CellID->18875],
  Cell[304126, 9883, 125, 4, 70, "Input",
   CellTags->"jlug:5.3.7.8",
   CellID->28433],
  Cell[304254, 9889, 94, 3, 70, "Output",
   CellTags->"jlug:5.3.7.8",
   CellID->29869],
  Cell[304363, 9895, 354, 10, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->20142],
  Cell[304720, 9907, 941, 23, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->23844],
  Cell[305664, 9932, 521, 12, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->1416],
  Cell[306188, 9946, 137, 4, 70, "Input",
   CellTags->"jlug:5.3.7.8",
   CellID->21881],
  Cell[306328, 9952, 1122, 22, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->31998],
  Cell[307453, 9976, 559, 14, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->10322],
  Cell[308015, 9992, 330, 10, 70, "Text",
   CellTags->"jlug:5.3.7.8",
   CellID->18651]},
 "TableOfContents_1.5.3.7.8"->{
  Cell[296991, 9664, 142, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.8", "TableOfContents_1.5.3.7.8"},
   CellID->16202]},
 "jlug:5.3.7.9"->{
  Cell[308382, 10007, 117, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.9", "TableOfContents_1.5.3.7.9"},
   CellID->10021],
  Cell[308502, 10011, 527, 12, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->5699],
  Cell[309032, 10025, 1573, 36, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->3557],
  Cell[310608, 10063, 1340, 41, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->28476],
  Cell[311951, 10106, 1273, 40, 70, "DefinitionBox",
   CellTags->"jlug:5.3.7.9",
   CellID->27892],
  Cell[313227, 10148, 93, 2, 70, "Caption",
   CellTags->"jlug:5.3.7.9",
   CellID->24389],
  Cell[313323, 10152, 219, 6, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->5075],
  Cell[313545, 10160, 347, 8, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->10712],
  Cell[313895, 10170, 2311, 66, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->2600],
  Cell[316209, 10238, 1155, 29, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->2510],
  Cell[317367, 10269, 481, 12, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->21003],
  Cell[317851, 10283, 343, 10, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->26869],
  Cell[318197, 10295, 1332, 30, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->17861],
  Cell[319532, 10327, 763, 16, 70, "Text",
   CellTags->"jlug:5.3.7.9",
   CellID->14688]},
 "TableOfContents_1.5.3.7.9"->{
  Cell[308382, 10007, 117, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.9", "TableOfContents_1.5.3.7.9"},
   CellID->10021]},
 "jlug:5.3.7.10"->{
  Cell[320332, 10348, 137, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.10", "TableOfContents_1.5.3.7.10"},
   CellID->13401],
  Cell[320472, 10352, 747, 19, 70, "Text",
   CellTags->"jlug:5.3.7.10",
   CellID->9789],
  Cell[321222, 10373, 885, 18, 70, "Text",
   CellTags->"jlug:5.3.7.10",
   CellID->15255],
  Cell[322110, 10393, 1584, 33, 70, "Text",
   CellTags->"jlug:5.3.7.10",
   CellID->16423],
  Cell[323697, 10428, 989, 25, 70, "Text",
   CellTags->"jlug:5.3.7.10",
   CellID->5002]},
 "TableOfContents_1.5.3.7.10"->{
  Cell[320332, 10348, 137, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.10", "TableOfContents_1.5.3.7.10"},
   CellID->13401]},
 "jlug:5.3.7.11"->{
  Cell[324723, 10458, 198, 5, 70, "Subsection",
   CellTags->{"jlug:5.3.7.11", "TableOfContents_1.5.3.7.11"},
   CellID->10585],
  Cell[324924, 10465, 1287, 28, 70, "Text",
   CellTags->"jlug:5.3.7.11",
   CellID->24182],
  Cell[326214, 10495, 668, 14, 70, "Text",
   CellTags->"jlug:5.3.7.11",
   CellID->10285],
  Cell[326885, 10511, 595, 14, 70, "Text",
   CellTags->"jlug:5.3.7.11",
   CellID->27088],
  Cell[327483, 10527, 351, 10, 70, "Text",
   CellTags->"jlug:5.3.7.11",
   CellID->31426],
  Cell[327837, 10539, 412, 16, 70, "Program",
   CellTags->"jlug:5.3.7.11",
   CellID->28617],
  Cell[328252, 10557, 566, 18, 70, "Text",
   CellTags->"jlug:5.3.7.11",
   CellID->23757],
  Cell[328821, 10577, 201, 8, 70, "Program",
   CellTags->"jlug:5.3.7.11",
   CellID->9832],
  Cell[329025, 10587, 1322, 42, 70, "Text",
   CellTags->"jlug:5.3.7.11",
   CellID->30932],
  Cell[330350, 10631, 312, 10, 70, "Text",
   CellTags->"jlug:5.3.7.11",
   CellID->4169]},
 "TableOfContents_1.5.3.7.11"->{
  Cell[324723, 10458, 198, 5, 70, "Subsection",
   CellTags->{"jlug:5.3.7.11", "TableOfContents_1.5.3.7.11"},
   CellID->10585]},
 "jlug:5.3.7.12"->{
  Cell[330699, 10646, 116, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.12", "TableOfContents_1.5.3.7.12"},
   CellID->2154],
  Cell[330818, 10650, 1724, 41, 70, "Text",
   CellTags->"jlug:5.3.7.12",
   CellID->25721]},
 "TableOfContents_1.5.3.7.12"->{
  Cell[330699, 10646, 116, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.7.12", "TableOfContents_1.5.3.7.12"},
   CellID->2154]},
 "jlug:5.3.8.0"->{
  Cell[332591, 10697, 206, 7, 70, "Section",
   CellTags->{"jlug:5.3.8.0", "TableOfContents_1.5.3.8"},
   CellID->23775]},
 "TableOfContents_1.5.3.8"->{
  Cell[332591, 10697, 206, 7, 70, "Section",
   CellTags->{"jlug:5.3.8.0", "TableOfContents_1.5.3.8"},
   CellID->23775]},
 "jlug:5.3.8.1"->{
  Cell[332822, 10708, 141, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.8.1", "TableOfContents_1.5.3.8.1"},
   CellID->20608],
  Cell[332966, 10712, 1502, 48, 70, "Text",
   CellTags->"jlug:5.3.8.1",
   CellID->109591723],
  Cell[334471, 10762, 1523, 43, 70, "Text",
   CellTags->"jlug:5.3.8.1",
   CellID->5997],
  Cell[335997, 10807, 689, 20, 70, "Text",
   CellTags->"jlug:5.3.8.1",
   CellID->17549]},
 "TableOfContents_1.5.3.8.1"->{
  Cell[332822, 10708, 141, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.8.1", "TableOfContents_1.5.3.8.1"},
   CellID->20608]},
 "jlug:5.3.8.2"->{
  Cell[336723, 10832, 206, 7, 70, "Subsection",
   CellTags->{"jlug:5.3.8.2", "TableOfContents_1.5.3.8.2"},
   CellID->29556],
  Cell[336932, 10841, 700, 19, 70, "Text",
   CellTags->"jlug:5.3.8.2",
   CellID->25561],
  Cell[337635, 10862, 391, 12, 70, "Input",
   CellTags->"jlug:5.3.8.2",
   CellID->31627],
  Cell[338029, 10876, 883, 21, 70, "Text",
   CellTags->"jlug:5.3.8.2",
   CellID->6467],
  Cell[338915, 10899, 148, 6, 70, "Text",
   CellTags->"jlug:5.3.8.2",
   CellID->29541],
  Cell[339066, 10907, 166, 5, 70, "Input",
   CellTags->"jlug:5.3.8.2",
   CellID->26129],
  Cell[339235, 10914, 354, 10, 70, "Text",
   CellTags->"jlug:5.3.8.2",
   CellID->31240],
  Cell[339592, 10926, 231, 7, 70, "Input",
   CellTags->"jlug:5.3.8.2",
   CellID->27813],
  Cell[339826, 10935, 189, 5, 70, "Text",
   CellTags->"jlug:5.3.8.2",
   CellID->43861508],
  Cell[340018, 10942, 177, 6, 70, "Input",
   CellTags->"jlug:5.3.8.2",
   CellID->20601],
  Cell[340198, 10950, 628, 18, 70, "Text",
   CellTags->"jlug:5.3.8.2",
   CellID->6077],
  Cell[340829, 10970, 200, 6, 70, "Input",
   CellTags->"jlug:5.3.8.2",
   CellID->20215],
  Cell[341032, 10978, 753, 23, 70, "Text",
   CellTags->"jlug:5.3.8.2",
   CellID->8683],
  Cell[341788, 11003, 155, 6, 70, "Input",
   CellTags->"jlug:5.3.8.2",
   CellID->8213],
  Cell[341946, 11011, 543, 15, 70, "Text",
   CellTags->"jlug:5.3.8.2",
   CellID->23992],
  Cell[342492, 11028, 303, 9, 70, "Input",
   CellTags->"jlug:5.3.8.2",
   CellID->25824],
  Cell[342798, 11039, 513, 20, 70, "Text",
   CellTags->"jlug:5.3.8.2",
   CellID->5601],
  Cell[343314, 11061, 1509, 38, 70, "Text",
   CellTags->"jlug:5.3.8.2",
   CellID->23392]},
 "TableOfContents_1.5.3.8.2"->{
  Cell[336723, 10832, 206, 7, 70, "Subsection",
   CellTags->{"jlug:5.3.8.2", "TableOfContents_1.5.3.8.2"},
   CellID->29556]},
 "jlug:5.3.8.3"->{
  Cell[344860, 11104, 160, 4, 70, "Subsection",
   CellTags->{"jlug:5.3.8.3", "TableOfContents_1.5.3.8.3"},
   CellID->15759],
  Cell[345023, 11110, 1062, 37, 70, "Text",
   CellTags->"jlug:5.3.8.3",
   CellID->2670],
  Cell[346088, 11149, 1325, 35, 70, "Text",
   CellTags->"jlug:5.3.8.3",
   CellID->26428],
  Cell[347416, 11186, 312, 9, 70, "Input",
   CellTags->"jlug:5.3.8.3",
   CellID->28027],
  Cell[347731, 11197, 625, 18, 70, "Text",
   CellTags->"jlug:5.3.8.3",
   CellID->4084],
  Cell[348359, 11217, 1411, 38, 70, "Input",
   CellTags->"jlug:5.3.8.3",
   CellID->10075],
  Cell[349773, 11257, 271, 7, 70, "Text",
   CellTags->"jlug:5.3.8.3",
   CellID->18786],
  Cell[350047, 11266, 101, 3, 70, "Input",
   CellTags->"jlug:5.3.8.3",
   CellID->15498],
  Cell[350151, 11271, 497, 14, 70, "Text",
   CellTags->"jlug:5.3.8.3",
   CellID->24970],
  Cell[350651, 11287, 1353, 27, 70, "Text",
   CellTags->"jlug:5.3.8.3",
   CellID->6287],
  Cell[352007, 11316, 1115, 33, 70, "Text",
   CellTags->"jlug:5.3.8.3",
   CellID->23847]},
 "TableOfContents_1.5.3.8.3"->{
  Cell[344860, 11104, 160, 4, 70, "Subsection",
   CellTags->{"jlug:5.3.8.3", "TableOfContents_1.5.3.8.3"},
   CellID->15759]},
 "jlug:5.3.8.4"->{
  Cell[353159, 11354, 103, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.8.4", "TableOfContents_1.5.3.8.4"},
   CellID->32604],
  Cell[353265, 11358, 942, 27, 70, "Text",
   CellTags->"jlug:5.3.8.4",
   CellID->503],
  Cell[354210, 11387, 237, 7, 70, "Text",
   CellTags->"jlug:5.3.8.4",
   CellID->21221],
  Cell[354450, 11396, 342, 11, 70, "Input",
   CellTags->"jlug:5.3.8.4",
   CellID->22663],
  Cell[354795, 11409, 284, 6, 70, "Text",
   CellTags->"jlug:5.3.8.4",
   CellID->5706],
  Cell[355082, 11417, 127, 3, 70, "Input",
   CellTags->"jlug:5.3.8.4",
   CellID->2363],
  Cell[355212, 11422, 462, 9, 70, "Text",
   CellTags->"jlug:5.3.8.4",
   CellID->9010],
  Cell[355677, 11433, 201, 6, 70, "Input",
   CellTags->"jlug:5.3.8.4",
   CellID->22171],
  Cell[355881, 11441, 229, 6, 70, "Text",
   CellTags->"jlug:5.3.8.4",
   CellID->27489],
  Cell[356113, 11449, 313, 8, 70, "Input",
   CellTags->"jlug:5.3.8.4",
   CellID->18240],
  Cell[356429, 11459, 112, 2, 70, "Text",
   CellTags->"jlug:5.3.8.4",
   CellID->12164],
  Cell[356544, 11463, 167, 6, 70, "Input",
   CellTags->"jlug:5.3.8.4",
   CellID->25542]},
 "TableOfContents_1.5.3.8.4"->{
  Cell[353159, 11354, 103, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.8.4", "TableOfContents_1.5.3.8.4"},
   CellID->32604]},
 "jlug:5.3.9.0"->{
  Cell[356760, 11475, 114, 2, 70, "Section",
   CellTags->{"jlug:5.3.9.0", "TableOfContents_1.5.3.9"},
   CellID->22549],
  Cell[356877, 11479, 1365, 39, 70, "Text",
   CellTags->"jlug:5.3.9.0",
   CellID->9496],
  Cell[358245, 11520, 1207, 37, 70, "DefinitionBox",
   CellTags->"jlug:5.3.9.0",
   CellID->18584],
  Cell[359455, 11559, 88, 2, 70, "Caption",
   CellTags->"jlug:5.3.9.0",
   CellID->9515],
  Cell[359568, 11565, 100, 3, 70, "Input",
   CellTags->"jlug:5.3.9.0",
   CellID->17964],
  Cell[359671, 11570, 300, 10, 70, "Output",
   CellTags->"jlug:5.3.9.0",
   CellID->23342],
  Cell[359986, 11583, 901, 25, 70, "Text",
   CellTags->"jlug:5.3.9.0",
   CellID->8075],
  Cell[360890, 11610, 491, 16, 70, "Text",
   CellTags->"jlug:5.3.9.0",
   CellID->17913],
  Cell[361384, 11628, 167, 6, 70, "Input",
   CellTags->"jlug:5.3.9.0",
   CellID->16142],
  Cell[361554, 11636, 1391, 32, 70, "Text",
   CellTags->"jlug:5.3.9.0",
   CellID->31196]},
 "TableOfContents_1.5.3.9"->{
  Cell[356760, 11475, 114, 2, 70, "Section",
   CellTags->{"jlug:5.3.9.0", "TableOfContents_1.5.3.9"},
   CellID->22549]},
 "jlug:5.3.10.0"->{
  Cell[362982, 11673, 108, 2, 70, "Section",
   CellTags->{"jlug:5.3.10.0", "TableOfContents_1.5.3.10"},
   CellID->15748],
  Cell[363093, 11677, 415, 8, 70, "Text",
   CellTags->"jlug:5.3.10.0",
   CellID->19923],
  Cell[363511, 11687, 505, 11, 70, "Text",
   CellTags->"jlug:5.3.10.0",
   CellID->3359],
  Cell[364019, 11700, 924, 17, 70, "Text",
   CellTags->"jlug:5.3.10.0",
   CellID->32257],
  Cell[364946, 11719, 481, 10, 70, "Text",
   CellTags->"jlug:5.3.10.0",
   CellID->24766],
  Cell[365430, 11731, 532, 15, 70, "Text",
   CellTags->"jlug:5.3.10.0",
   CellID->4944],
  Cell[365965, 11748, 162, 5, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.10.0",
   CellID->14955],
  Cell[366130, 11755, 76, 2, 70, "Text",
   CellTags->"jlug:5.3.10.0",
   CellID->23318],
  Cell[366209, 11759, 193, 6, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.10.0",
   CellID->32726],
  Cell[366405, 11767, 647, 16, 70, "Text",
   CellTags->"jlug:5.3.10.0",
   CellID->25411],
  Cell[367055, 11785, 225, 8, 70, "Text",
   CellTags->"jlug:5.3.10.0",
   CellID->21025],
  Cell[367283, 11795, 512, 14, 70, "Input",
   CellTags->"jlug:5.3.10.0",
   CellID->20355],
  Cell[367798, 11811, 1062, 31, 70, "Text",
   CellTags->"jlug:5.3.10.0",
   CellID->31001]},
 "TableOfContents_1.5.3.10"->{
  Cell[362982, 11673, 108, 2, 70, "Section",
   CellTags->{"jlug:5.3.10.0", "TableOfContents_1.5.3.10"},
   CellID->15748]},
 "TableOfContents_1.5.3.12"->{
  Cell[368897, 11847, 118, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.12", "1.2.12", "jlug:5.3.12.0"},
   CellID->13169]},
 "1.2.12"->{
  Cell[368897, 11847, 118, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.12", "1.2.12", "jlug:5.3.12.0"},
   CellID->13169]},
 "jlug:5.3.12.0"->{
  Cell[368897, 11847, 118, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.3.12", "1.2.12", "jlug:5.3.12.0"},
   CellID->13169],
  Cell[369018, 11851, 716, 20, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->23831],
  Cell[369737, 11873, 373, 12, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->20040],
  Cell[370113, 11887, 836, 24, 70, "DefinitionBox",
   CellTags->"jlug:5.3.12.0",
   CellID->26488],
  Cell[370952, 11913, 79, 2, 70, "Caption",
   CellTags->"jlug:5.3.12.0",
   CellID->28685],
  Cell[371034, 11917, 952, 22, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->19090],
  Cell[371989, 11941, 174, 7, 70, "Program",
   CellTags->"jlug:5.3.12.0",
   CellID->19497],
  Cell[372166, 11950, 238, 9, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->2589],
  Cell[372407, 11961, 320, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.12.0",
   CellID->25990],
  Cell[372730, 11973, 377, 8, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->15145],
  Cell[373110, 11983, 1240, 36, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->19353],
  Cell[374353, 12021, 1039, 35, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->19314],
  Cell[375395, 12058, 537, 15, 70, "Input",
   CellTags->"jlug:5.3.12.0",
   CellID->66209135],
  Cell[375935, 12075, 262, 8, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->26740],
  Cell[376200, 12085, 331, 10, 70, "Input",
   CellTags->"jlug:5.3.12.0",
   CellID->22044],
  Cell[376534, 12097, 266, 6, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->11258],
  Cell[376803, 12105, 153, 5, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->335],
  Cell[376959, 12112, 732, 21, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->8759],
  Cell[377694, 12135, 1474, 36, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->11192],
  Cell[379171, 12173, 428, 13, 70, "Input",
   CellTags->"jlug:5.3.12.0",
   CellID->7605],
  Cell[379602, 12188, 408, 8, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->25264],
  Cell[380013, 12198, 185, 6, 70, "Input",
   CellTags->"jlug:5.3.12.0",
   CellID->12181],
  Cell[380201, 12206, 346, 10, 70, "Text",
   CellTags->"jlug:5.3.12.0",
   CellID->28503],
  Cell[380550, 12218, 141, 4, 70, "Input",
   CellTags->"jlug:5.3.12.0",
   CellID->3829]},
 "jlug:5.3.13.0"->{
  Cell[380728, 12227, 109, 2, 70, "Section",
   CellTags->{"jlug:5.3.13.0", "TableOfContents_1.5.3.13"},
   CellID->28255],
  Cell[380840, 12231, 1164, 25, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->4460],
  Cell[382007, 12258, 2342, 79, 70, "DefinitionBox",
   CellTags->"jlug:5.3.13.0",
   CellID->474],
  Cell[384352, 12339, 92, 2, 70, "Caption",
   CellTags->"jlug:5.3.13.0",
   CellID->6972],
  Cell[384447, 12343, 261, 9, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->26821],
  Cell[384711, 12354, 249, 9, 70, "Input",
   CellTags->"jlug:5.3.13.0",
   CellID->26122],
  Cell[384963, 12365, 835, 23, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->446439732],
  Cell[385801, 12390, 1017, 17, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->21577],
  Cell[386821, 12409, 1038, 29, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->13634400],
  Cell[387862, 12440, 478, 13, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->25605],
  Cell[388343, 12455, 123, 3, 70, "Input",
   CellTags->"jlug:5.3.13.0",
   CellID->30195],
  Cell[388469, 12460, 829, 21, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->27594],
  Cell[389301, 12483, 675, 15, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->7950],
  Cell[389979, 12500, 188, 5, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->16343],
  Cell[390170, 12507, 260, 9, 70, "Input",
   CellTags->"jlug:5.3.13.0",
   CellID->754],
  Cell[390433, 12518, 669, 20, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->2481],
  Cell[391105, 12540, 152, 5, 70, "Text",
   CellTags->"jlug:5.3.13.0",
   CellID->1012],
  Cell[391260, 12547, 198, 6, 70, "Input",
   CellTags->"jlug:5.3.13.0",
   CellID->11672]},
 "TableOfContents_1.5.3.13"->{
  Cell[380728, 12227, 109, 2, 70, "Section",
   CellTags->{"jlug:5.3.13.0", "TableOfContents_1.5.3.13"},
   CellID->28255]},
 "jlug:5.3.14.0"->{
  Cell[391495, 12558, 120, 2, 70, "Section",
   CellTags->{"jlug:5.3.14.0", "TableOfContents_1.5.3.14"},
   CellID->10938]},
 "TableOfContents_1.5.3.14"->{
  Cell[391495, 12558, 120, 2, 70, "Section",
   CellTags->{"jlug:5.3.14.0", "TableOfContents_1.5.3.14"},
   CellID->10938]},
 "jlug:5.3.14.1"->{
  Cell[391640, 12564, 105, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.14.1", "TableOfContents_1.5.3.14.1"},
   CellID->1881],
  Cell[391748, 12568, 870, 26, 70, "Text",
   CellTags->"jlug:5.3.14.1",
   CellID->9257],
  Cell[392621, 12596, 539, 18, 70, "Text",
   CellTags->"jlug:5.3.14.1",
   CellID->22750]},
 "TableOfContents_1.5.3.14.1"->{
  Cell[391640, 12564, 105, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.14.1", "TableOfContents_1.5.3.14.1"},
   CellID->1881]},
 "jlug:5.3.14.2"->{
  Cell[393197, 12619, 211, 5, 70, "Subsection",
   CellTags->{"jlug:5.3.14.2", "TableOfContents_1.5.3.14.2"},
   CellID->28614],
  Cell[393411, 12626, 867, 26, 70, "Text",
   CellTags->"jlug:5.3.14.2",
   CellID->18598],
  Cell[394281, 12654, 1157, 44, 70, "Text",
   CellTags->"jlug:5.3.14.2",
   CellID->28458],
  Cell[395441, 12700, 701, 20, 70, "Text",
   CellTags->"jlug:5.3.14.2",
   CellID->2661]},
 "TableOfContents_1.5.3.14.2"->{
  Cell[393197, 12619, 211, 5, 70, "Subsection",
   CellTags->{"jlug:5.3.14.2", "TableOfContents_1.5.3.14.2"},
   CellID->28614]},
 "1.2.14"->{
  Cell[396179, 12725, 123, 2, 70, "Subsection",
   CellTags->{"1.2.14", "jlug:5.3.14.3", "TableOfContents_1.5.3.14.3"},
   CellID->26063]},
 "jlug:5.3.14.3"->{
  Cell[396179, 12725, 123, 2, 70, "Subsection",
   CellTags->{"1.2.14", "jlug:5.3.14.3", "TableOfContents_1.5.3.14.3"},
   CellID->26063],
  Cell[396305, 12729, 1062, 31, 70, "Text",
   CellTags->"jlug:5.3.14.3",
   CellID->32756],
  Cell[397370, 12762, 697, 21, 70, "DefinitionBox",
   CellTags->"jlug:5.3.14.3",
   CellID->20807],
  Cell[398070, 12785, 101, 2, 70, "Caption",
   CellTags->"jlug:5.3.14.3",
   CellID->20278],
  Cell[398174, 12789, 142, 4, 70, "Text",
   CellTags->"jlug:5.3.14.3",
   CellID->19489],
  Cell[398319, 12795, 215, 7, 70, "ItemizedText",
   CellTags->"jlug:5.3.14.3",
   CellID->19435],
  Cell[398559, 12806, 207, 7, 70, "ItemizedText",
   CellTags->"jlug:5.3.14.3",
   CellID->6365],
  Cell[398769, 12815, 110, 5, 70, "Program",
   CellTags->"jlug:5.3.14.3",
   CellID->32075],
  Cell[398882, 12822, 754, 21, 70, "Text",
   CellTags->"jlug:5.3.14.3",
   CellID->7586],
  Cell[399639, 12845, 173, 6, 70, "Input",
   CellTags->"jlug:5.3.14.3",
   CellID->1386],
  Cell[399815, 12853, 551, 15, 70, "Text",
   CellTags->"jlug:5.3.14.3",
   CellID->7833],
  Cell[400369, 12870, 351, 10, 70, "Text",
   CellTags->"jlug:5.3.14.3",
   CellID->8360]},
 "TableOfContents_1.5.3.14.3"->{
  Cell[396179, 12725, 123, 2, 70, "Subsection",
   CellTags->{"1.2.14", "jlug:5.3.14.3", "TableOfContents_1.5.3.14.3"},
   CellID->26063]},
 "jlug:5.3.14.4"->{
  Cell[400769, 12886, 123, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.14.4", "TableOfContents_1.5.3.14.4"},
   CellID->13330],
  Cell[400895, 12890, 1091, 35, 70, "Text",
   CellTags->"jlug:5.3.14.4",
   CellID->26048]},
 "TableOfContents_1.5.3.14.4"->{
  Cell[400769, 12886, 123, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.14.4", "TableOfContents_1.5.3.14.4"},
   CellID->13330]},
 "jlug:5.3.15.0"->{
  Cell[402035, 12931, 105, 2, 70, "Section",
   CellTags->{"jlug:5.3.15.0", "TableOfContents_1.5.3.15"},
   CellID->1908],
  Cell[402143, 12935, 1830, 50, 70, "Text",
   CellTags->"jlug:5.3.15.0",
   CellID->17223],
  Cell[403976, 12987, 418, 13, 70, "DefinitionBox",
   CellTags->"jlug:5.3.15.0",
   CellID->11759],
  Cell[404397, 13002, 84, 2, 70, "Caption",
   CellTags->"jlug:5.3.15.0",
   CellID->26434],
  Cell[404484, 13006, 677, 20, 70, "Text",
   CellTags->"jlug:5.3.15.0",
   CellID->5204],
  Cell[405164, 13028, 136, 6, 70, "Program",
   CellTags->"jlug:5.3.15.0",
   CellID->29486],
  Cell[405303, 13036, 111, 2, 70, "Text",
   CellTags->"jlug:5.3.15.0",
   CellID->4319],
  Cell[405439, 13042, 381, 12, 70, "Input",
   CellTags->"jlug:5.3.15.0",
   CellID->958],
  Cell[405823, 13056, 372, 10, 70, "Message",
   CellTags->"jlug:5.3.15.0",
   CellID->5945],
  Cell[406198, 13068, 101, 3, 70, "Output",
   CellTags->"jlug:5.3.15.0",
   CellID->26806],
  Cell[406314, 13074, 405, 13, 70, "Text",
   CellTags->"jlug:5.3.15.0",
   CellID->8166],
  Cell[406722, 13089, 317, 9, 70, "Text",
   CellTags->"jlug:5.3.15.0",
   CellID->18700],
  Cell[407064, 13102, 362, 11, 70, "Input",
   CellTags->"jlug:5.3.15.0",
   CellID->11367],
  Cell[407429, 13115, 248, 9, 70, "Output",
   CellTags->"jlug:5.3.15.0",
   CellID->17692],
  Cell[407692, 13127, 195, 5, 70, "Text",
   CellTags->"jlug:5.3.15.0",
   CellID->21787],
  Cell[407890, 13134, 141, 4, 70, "Input",
   CellTags->"jlug:5.3.15.0",
   CellID->28532]},
 "TableOfContents_1.5.3.15"->{
  Cell[402035, 12931, 105, 2, 70, "Section",
   CellTags->{"jlug:5.3.15.0", "TableOfContents_1.5.3.15"},
   CellID->1908]},
 "1.2.17"->{
  Cell[408068, 13143, 211, 7, 70, "Section",
   CellTags->{"1.2.17", "jlug:5.3.17.0", "TableOfContents_1.5.3.17"},
   CellID->7619]},
 "jlug:5.3.17.0"->{
  Cell[408068, 13143, 211, 7, 70, "Section",
   CellTags->{"1.2.17", "jlug:5.3.17.0", "TableOfContents_1.5.3.17"},
   CellID->7619],
  Cell[408282, 13152, 1381, 39, 70, "Text",
   CellTags->"jlug:5.3.17.0",
   CellID->20913],
  Cell[409666, 13193, 1060, 30, 70, "DefinitionBox",
   CellTags->"jlug:5.3.17.0",
   CellID->7591],
  Cell[410729, 13225, 184, 9, 70, "Caption",
   CellTags->"jlug:5.3.17.0",
   CellID->6704],
  Cell[410916, 13236, 2490, 67, 70, "Text",
   CellTags->"jlug:5.3.17.0",
   CellID->31818],
  Cell[413409, 13305, 524, 19, 70, "Input",
   CellTags->"jlug:5.3.17.0",
   CellID->9232],
  Cell[413936, 13326, 1644, 43, 70, "Text",
   CellTags->"jlug:5.3.17.0",
   CellID->750],
  Cell[415583, 13371, 700, 14, 70, "Text",
   CellTags->"jlug:5.3.17.0",
   CellID->25205],
  Cell[416286, 13387, 887, 23, 70, "Text",
   CellTags->"jlug:5.3.17.0",
   CellID->4975],
  Cell[417176, 13412, 2940, 74, 70, "Text",
   CellTags->"jlug:5.3.17.0",
   CellID->1539]},
 "TableOfContents_1.5.3.17"->{
  Cell[408068, 13143, 211, 7, 70, "Section",
   CellTags->{"1.2.17", "jlug:5.3.17.0", "TableOfContents_1.5.3.17"},
   CellID->7619]},
 "1.2.18"->{
  Cell[420153, 13491, 143, 2, 70, "Section",
   CellTags->{"1.2.18", "jlug:5.3.18.0", "TableOfContents_1.5.3.18"},
   CellID->4680]},
 "jlug:5.3.18.0"->{
  Cell[420153, 13491, 143, 2, 70, "Section",
   CellTags->{"1.2.18", "jlug:5.3.18.0", "TableOfContents_1.5.3.18"},
   CellID->4680]},
 "TableOfContents_1.5.3.18"->{
  Cell[420153, 13491, 143, 2, 70, "Section",
   CellTags->{"1.2.18", "jlug:5.3.18.0", "TableOfContents_1.5.3.18"},
   CellID->4680]},
 "jlug:5.3.18.1"->{
  Cell[420321, 13497, 105, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.1", "TableOfContents_1.5.3.18.1"},
   CellID->9198],
  Cell[420429, 13501, 380, 10, 70, "Text",
   CellTags->"jlug:5.3.18.1",
   CellID->27032],
  Cell[420812, 13513, 1233, 34, 70, "Text",
   CellTags->"jlug:5.3.18.1",
   CellID->14387],
  Cell[422048, 13549, 1225, 31, 70, "Text",
   CellTags->"jlug:5.3.18.1",
   CellID->32584],
  Cell[423276, 13582, 877, 28, 70, "Text",
   CellTags->"jlug:5.3.18.1",
   CellID->7240],
  Cell[424156, 13612, 2077, 56, 70, "Text",
   CellTags->"jlug:5.3.18.1",
   CellID->3517],
  Cell[426236, 13670, 500, 15, 70, "Text",
   CellTags->"jlug:5.3.18.1",
   CellID->17006]},
 "TableOfContents_1.5.3.18.1"->{
  Cell[420321, 13497, 105, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.1", "TableOfContents_1.5.3.18.1"},
   CellID->9198]},
 "jlug:5.3.18.2"->{
  Cell[426773, 13690, 148, 4, 70, "Subsection",
   CellTags->{"jlug:5.3.18.2", "TableOfContents_1.5.3.18.2"},
   CellID->8670],
  Cell[426924, 13696, 1215, 32, 70, "Text",
   CellTags->"jlug:5.3.18.2",
   CellID->241],
  Cell[428142, 13730, 784, 17, 70, "Text",
   CellTags->"jlug:5.3.18.2",
   CellID->18882]},
 "TableOfContents_1.5.3.18.2"->{
  Cell[426773, 13690, 148, 4, 70, "Subsection",
   CellTags->{"jlug:5.3.18.2", "TableOfContents_1.5.3.18.2"},
   CellID->8670]},
 "jlug:5.3.18.3"->{
  Cell[428963, 13752, 127, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.3", "TableOfContents_1.5.3.18.3"},
   CellID->25249],
  Cell[429093, 13756, 272, 8, 70, "Text",
   CellTags->"jlug:5.3.18.3",
   CellID->3523],
  Cell[429368, 13766, 310, 7, 70, "Text",
   CellTags->"jlug:5.3.18.3",
   CellID->31758]},
 "TableOfContents_1.5.3.18.3"->{
  Cell[428963, 13752, 127, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.3", "TableOfContents_1.5.3.18.3"},
   CellID->25249]},
 "jlug:5.3.18.4"->{
  Cell[429715, 13778, 219, 7, 70, "Subsection",
   CellTags->{"jlug:5.3.18.4", "TableOfContents_1.5.3.18.4"},
   CellID->12105],
  Cell[429937, 13787, 1195, 31, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->29621],
  Cell[431135, 13820, 965, 28, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->17095],
  Cell[432103, 13850, 108, 2, 70, "Program",
   CellTags->"jlug:5.3.18.4",
   CellID->7296],
  Cell[432214, 13854, 768, 20, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->9916],
  Cell[432985, 13876, 212, 5, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->15678],
  Cell[433200, 13883, 258, 8, 70, "Program",
   CellTags->"jlug:5.3.18.4",
   CellID->10178],
  Cell[433461, 13893, 1334, 30, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->13579],
  Cell[434798, 13925, 1242, 31, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->25058],
  Cell[436043, 13958, 217, 7, 70, "Program",
   CellTags->"jlug:5.3.18.4",
   CellID->27577],
  Cell[436263, 13967, 362, 10, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->12750],
  Cell[436628, 13979, 789, 23, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->14007],
  Cell[437420, 14004, 1079, 29, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->23729],
  Cell[438502, 14035, 443, 11, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->24081],
  Cell[438948, 14048, 766, 20, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->2995],
  Cell[439717, 14070, 110, 2, 70, "Program",
   CellTags->"jlug:5.3.18.4",
   CellID->2678],
  Cell[439830, 14074, 810, 24, 70, "Text",
   CellTags->"jlug:5.3.18.4",
   CellID->24676]},
 "TableOfContents_1.5.3.18.4"->{
  Cell[429715, 13778, 219, 7, 70, "Subsection",
   CellTags->{"jlug:5.3.18.4", "TableOfContents_1.5.3.18.4"},
   CellID->12105]},
 "jlug:5.3.18.5"->{
  Cell[440677, 14103, 193, 6, 70, "Subsection",
   CellTags->{"jlug:5.3.18.5", "TableOfContents_1.5.3.18.5"},
   CellID->27753],
  Cell[440873, 14111, 773, 20, 70, "Text",
   CellTags->"jlug:5.3.18.5",
   CellID->20899],
  Cell[441649, 14133, 913, 25, 70, "Text",
   CellTags->"jlug:5.3.18.5",
   CellID->11784],
  Cell[442565, 14160, 508, 25, 70, "Program",
   CellTags->"jlug:5.3.18.5",
   CellID->15565],
  Cell[443076, 14187, 944, 28, 70, "Text",
   CellTags->"jlug:5.3.18.5",
   CellID->294743168],
  Cell[444023, 14217, 949, 29, 70, "Text",
   CellTags->"jlug:5.3.18.5",
   CellID->13608],
  Cell[444975, 14248, 552, 16, 70, "Text",
   CellTags->"jlug:5.3.18.5",
   CellID->6172],
  Cell[445530, 14266, 706, 23, 70, "Text",
   CellTags->"jlug:5.3.18.5",
   CellID->11243],
  Cell[446239, 14291, 1399, 44, 70, "Text",
   CellTags->"jlug:5.3.18.5",
   CellID->29929],
  Cell[447641, 14337, 650, 16, 70, "Text",
   CellTags->"jlug:5.3.18.5",
   CellID->7514]},
 "TableOfContents_1.5.3.18.5"->{
  Cell[440677, 14103, 193, 6, 70, "Subsection",
   CellTags->{"jlug:5.3.18.5", "TableOfContents_1.5.3.18.5"},
   CellID->27753]},
 "jlug:5.3.18.6"->{
  Cell[448328, 14358, 188, 6, 70, "Subsection",
   CellTags->{"jlug:5.3.18.6", "TableOfContents_1.5.3.18.6"},
   CellID->10168],
  Cell[448519, 14366, 1119, 32, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->5055],
  Cell[449641, 14400, 1344, 35, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->11191],
  Cell[450988, 14437, 929, 27, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->5973],
  Cell[451920, 14466, 639, 20, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->8922],
  Cell[452562, 14488, 168, 5, 70, "Program",
   CellTags->"jlug:5.3.18.6",
   CellID->6748],
  Cell[452733, 14495, 363, 8, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->5651],
  Cell[453099, 14505, 387, 15, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->10986],
  Cell[453489, 14522, 90, 2, 70, "Program",
   CellTags->"jlug:5.3.18.6",
   CellID->2144],
  Cell[453582, 14526, 351, 11, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->16446],
  Cell[453936, 14539, 165, 3, 70, "Program",
   CellTags->"jlug:5.3.18.6",
   CellID->31577],
  Cell[454104, 14544, 82, 2, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->26517],
  Cell[454189, 14548, 378, 15, 70, "Program",
   CellTags->"jlug:5.3.18.6",
   CellID->14629],
  Cell[454570, 14565, 482, 17, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->29916],
  Cell[455055, 14584, 140, 6, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->5874],
  Cell[455220, 14594, 322, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.18.6",
   CellID->15791],
  Cell[455545, 14606, 150, 5, 70, "Print",
   CellTags->"jlug:5.3.18.6",
   CellID->15469],
  Cell[455698, 14613, 315, 8, 70, "Message",
   CellTags->"jlug:5.3.18.6",
   CellID->22912],
  Cell[456016, 14623, 101, 3, 70, "Output",
   CellTags->"jlug:5.3.18.6",
   CellID->8146],
  Cell[456132, 14629, 441, 14, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->30693],
  Cell[456576, 14645, 1264, 38, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->9091],
  Cell[457843, 14685, 1143, 36, 70, "DisplayMath",
   CellTags->"jlug:5.3.18.6",
   CellID->9815],
  Cell[458989, 14723, 544, 15, 70, "Text",
   CellTags->"jlug:5.3.18.6",
   CellID->26949],
  Cell[459536, 14740, 1326, 40, 70, "Program",
   CellTags->"jlug:5.3.18.6",
   CellID->26857]},
 "TableOfContents_1.5.3.18.6"->{
  Cell[448328, 14358, 188, 6, 70, "Subsection",
   CellTags->{"jlug:5.3.18.6", "TableOfContents_1.5.3.18.6"},
   CellID->10168]},
 "jlug:5.3.18.7"->{
  Cell[460899, 14785, 117, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.7", "TableOfContents_1.5.3.18.7"},
   CellID->20640],
  Cell[461019, 14789, 912, 23, 70, "Text",
   CellTags->"jlug:5.3.18.7",
   CellID->26052]},
 "TableOfContents_1.5.3.18.7"->{
  Cell[460899, 14785, 117, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.7", "TableOfContents_1.5.3.18.7"},
   CellID->20640]},
 "jlug:5.3.18.8"->{
  Cell[461968, 14817, 125, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.8", "TableOfContents_1.5.3.18.8"},
   CellID->236],
  Cell[462096, 14821, 579, 20, 70, "Text",
   CellTags->"jlug:5.3.18.8",
   CellID->8551],
  Cell[462678, 14843, 94, 2, 70, "Program",
   CellTags->"jlug:5.3.18.8",
   CellID->9487],
  Cell[462775, 14847, 557, 15, 70, "Text",
   CellTags->"jlug:5.3.18.8",
   CellID->31226],
  Cell[463335, 14864, 326, 13, 70, "Program",
   CellTags->"jlug:5.3.18.8",
   CellID->28162],
  Cell[463664, 14879, 1413, 41, 70, "Text",
   CellTags->"jlug:5.3.18.8",
   CellID->16955],
  Cell[465080, 14922, 2139, 57, 70, "Text",
   CellTags->"jlug:5.3.18.8",
   CellID->23183],
  Cell[467222, 14981, 1690, 44, 70, "Text",
   CellTags->"jlug:5.3.18.8",
   CellID->8394],
  Cell[468915, 15027, 92, 2, 70, "Program",
   CellTags->"jlug:5.3.18.8",
   CellID->30180],
  Cell[469010, 15031, 79, 2, 70, "Text",
   CellTags->"jlug:5.3.18.8",
   CellID->16097],
  Cell[469092, 15035, 388, 17, 70, "Program",
   CellTags->"jlug:5.3.18.8",
   CellID->3065]},
 "TableOfContents_1.5.3.18.8"->{
  Cell[461968, 14817, 125, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.8", "TableOfContents_1.5.3.18.8"},
   CellID->236]},
 "jlug:5.3.18.9"->{
  Cell[469517, 15057, 133, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.9", "TableOfContents_1.5.3.18.9"},
   CellID->27065],
  Cell[469653, 15061, 2974, 80, 70, "Text",
   CellTags->"jlug:5.3.18.9",
   CellID->2513],
  Cell[472630, 15143, 1893, 50, 70, "Text",
   CellTags->"jlug:5.3.18.9",
   CellID->9261],
  Cell[474526, 15195, 2072, 57, 70, "Text",
   CellTags->"jlug:5.3.18.9",
   CellID->12578],
  Cell[476601, 15254, 862, 21, 70, "Text",
   CellTags->"jlug:5.3.18.9",
   CellID->21078],
  Cell[477466, 15277, 914, 25, 70, "Text",
   CellTags->"jlug:5.3.18.9",
   CellID->16878],
  Cell[478383, 15304, 507, 18, 70, "Program",
   CellTags->"jlug:5.3.18.9",
   CellID->14140],
  Cell[478893, 15324, 1546, 35, 70, "Text",
   CellTags->"jlug:5.3.18.9",
   CellID->4611],
  Cell[480442, 15361, 311, 8, 70, "Text",
   CellTags->"jlug:5.3.18.9",
   CellID->31947],
  Cell[480756, 15371, 292, 11, 70, "BulletText",
   CellTags->"jlug:5.3.18.9",
   CellID->2445],
  Cell[481051, 15384, 200, 8, 70, "BulletText",
   CellTags->"jlug:5.3.18.9",
   CellID->170],
  Cell[481254, 15394, 282, 9, 70, "BulletText",
   CellTags->"jlug:5.3.18.9",
   CellID->29975],
  Cell[481539, 15405, 203, 7, 70, "BulletText",
   CellTags->"jlug:5.3.18.9",
   CellID->13489],
  Cell[481745, 15414, 352, 13, 70, "BulletText",
   CellTags->"jlug:5.3.18.9",
   CellID->24750],
  Cell[482100, 15429, 718, 20, 70, "Text",
   CellTags->"jlug:5.3.18.9",
   CellID->6149],
  Cell[482821, 15451, 831, 27, 70, "Text",
   CellTags->"jlug:5.3.18.9",
   CellID->3333],
  Cell[483655, 15480, 803, 22, 70, "Text",
   CellTags->"jlug:5.3.18.9",
   CellID->13865]},
 "TableOfContents_1.5.3.18.9"->{
  Cell[469517, 15057, 133, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.9", "TableOfContents_1.5.3.18.9"},
   CellID->27065]},
 "jlug:5.3.18.10"->{
  Cell[484495, 15507, 127, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.10", "TableOfContents_1.5.3.18.10"},
   CellID->22214],
  Cell[484625, 15511, 1000, 30, 70, "Text",
   CellTags->"jlug:5.3.18.10",
   CellID->17282],
  Cell[485628, 15543, 124, 2, 70, "Program",
   CellTags->"jlug:5.3.18.10",
   CellID->27007],
  Cell[485755, 15547, 609, 18, 70, "Text",
   CellTags->"jlug:5.3.18.10",
   CellID->27432],
  Cell[486367, 15567, 630, 15, 70, "Text",
   CellTags->"jlug:5.3.18.10",
   CellID->8896],
  Cell[487000, 15584, 195, 8, 70, "Program",
   CellTags->"jlug:5.3.18.10",
   CellID->16367],
  Cell[487198, 15594, 472, 15, 70, "Text",
   CellTags->"jlug:5.3.18.10",
   CellID->28522],
  Cell[487673, 15611, 221, 9, 70, "Input",
   Evaluatable->False,
   CellTags->"jlug:5.3.18.10",
   CellID->4882],
  Cell[487897, 15622, 966, 30, 70, "Text",
   CellTags->"jlug:5.3.18.10",
   CellID->31810],
  Cell[488866, 15654, 149, 5, 70, "Text",
   CellTags->"jlug:5.3.18.10",
   CellID->17641],
  Cell[489018, 15661, 348, 14, 70, "Program",
   CellTags->"jlug:5.3.18.10",
   CellID->7231],
  Cell[489369, 15677, 725, 22, 70, "Text",
   CellTags->"jlug:5.3.18.10",
   CellID->2187],
  Cell[490097, 15701, 154, 5, 70, "Program",
   CellTags->"jlug:5.3.18.10",
   CellID->6705]},
 "TableOfContents_1.5.3.18.10"->{
  Cell[484495, 15507, 127, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.18.10", "TableOfContents_1.5.3.18.10"},
   CellID->22214]},
 "jlug:5.3.19.0"->{
  Cell[490300, 15712, 184, 6, 70, "Section",
   CellTags->{"jlug:5.3.19.0", "TableOfContents_1.5.3.19"},
   CellID->17189],
  Cell[490487, 15720, 278, 11, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->19976],
  Cell[490768, 15733, 1233, 28, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->31329],
  Cell[492004, 15763, 1594, 44, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->2368],
  Cell[493601, 15809, 492, 18, 70, "Program",
   CellTags->"jlug:5.3.19.0",
   CellID->28692],
  Cell[494096, 15829, 1630, 50, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->21425],
  Cell[495751, 15883, 109, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.19.0", "TableOfContents_1.5.3.19.1"},
   CellID->10555],
  Cell[495863, 15887, 202, 5, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->3434],
  Cell[496068, 15894, 1433, 34, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->16549],
  Cell[497504, 15930, 948, 29, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->7441],
  Cell[498455, 15961, 1660, 45, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->9512],
  Cell[500118, 16008, 750, 26, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->30145],
  Cell[500871, 16036, 3463, 86, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->18060],
  Cell[504337, 16124, 281, 11, 70, "Input",
   CellTags->"jlug:5.3.19.0",
   CellID->21718],
  Cell[504621, 16137, 1043, 28, 70, "Text",
   CellTags->"jlug:5.3.19.0",
   CellID->3753]},
 "TableOfContents_1.5.3.19"->{
  Cell[490300, 15712, 184, 6, 70, "Section",
   CellTags->{"jlug:5.3.19.0", "TableOfContents_1.5.3.19"},
   CellID->17189]},
 "TableOfContents_1.5.3.19.1"->{
  Cell[495751, 15883, 109, 2, 70, "Subsection",
   CellTags->{"jlug:5.3.19.0", "TableOfContents_1.5.3.19.1"},
   CellID->10555]},
 "TableOfContents_1.5.4"->{
  Cell[505713, 16171, 112, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.4", "1.3", "jlug:5.4.0.0"},
   CellID->16139]},
 "1.3"->{
  Cell[505713, 16171, 112, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.4", "1.3", "jlug:5.4.0.0"},
   CellID->16139]},
 "jlug:5.4.0.0"->{
  Cell[505713, 16171, 112, 2, 70, "Section",
   CellTags->{"TableOfContents_1.5.4", "1.3", "jlug:5.4.0.0"},
   CellID->16139]},
 "jlug:5.4.1.0"->{
  Cell[505850, 16177, 106, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.1.0", "TableOfContents_1.5.4.1"},
   CellID->12423],
  Cell[505959, 16181, 377, 10, 70, "Text",
   CellTags->"jlug:5.4.1.0",
   CellID->16279],
  Cell[506339, 16193, 930, 25, 70, "Text",
   CellTags->"jlug:5.4.1.0",
   CellID->25996],
  Cell[507272, 16220, 562, 16, 70, "Text",
   CellTags->"jlug:5.4.1.0",
   CellID->16687]},
 "TableOfContents_1.5.4.1"->{
  Cell[505850, 16177, 106, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.1.0", "TableOfContents_1.5.4.1"},
   CellID->12423]},
 "jlug:5.4.2.0"->{
  Cell[507871, 16241, 109, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.2.0", "TableOfContents_1.5.4.2"},
   CellID->12529],
  Cell[507983, 16245, 391, 14, 70, "Text",
   CellTags->"jlug:5.4.2.0",
   CellID->31673922],
  Cell[508377, 16261, 457, 13, 70, "Input",
   CellTags->"jlug:5.4.2.0",
   CellID->17437],
  Cell[508837, 16276, 414, 12, 70, "Text",
   CellTags->"jlug:5.4.2.0",
   CellID->19866],
  Cell[509254, 16290, 118, 4, 70, "Input",
   CellTags->"jlug:5.4.2.0",
   CellID->12949],
  Cell[509375, 16296, 328, 7, 70, "Text",
   CellTags->"jlug:5.4.2.0",
   CellID->193],
  Cell[509706, 16305, 222, 10, 70, "Input",
   CellTags->"jlug:5.4.2.0",
   CellID->23195],
  Cell[509931, 16317, 2330, 69, 70, "Text",
   CellTags->"jlug:5.4.2.0",
   CellID->3297],
  Cell[512264, 16388, 310, 13, 70, "Input",
   CellTags->"jlug:5.4.2.0",
   CellID->20416],
  Cell[512577, 16403, 362, 10, 70, "Text",
   CellTags->"jlug:5.4.2.0",
   CellID->28286]},
 "TableOfContents_1.5.4.2"->{
  Cell[507871, 16241, 109, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.2.0", "TableOfContents_1.5.4.2"},
   CellID->12529]},
 "jlug:5.4.3.0"->{
  Cell[512976, 16418, 110, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.3.0", "TableOfContents_1.5.4.3"},
   CellID->16105],
  Cell[513089, 16422, 399, 9, 70, "Text",
   CellTags->"jlug:5.4.3.0",
   CellID->24488],
  Cell[513513, 16435, 173, 5, 70, "Input",
   CellTags->"jlug:5.4.3.0",
   CellID->16282],
  Cell[513689, 16442, 270, 8, 70, "Output",
   CellTags->"jlug:5.4.3.0",
   CellID->12455],
  Cell[513974, 16453, 185, 6, 70, "Text",
   CellTags->"jlug:5.4.3.0",
   CellID->25734],
  Cell[514184, 16463, 271, 8, 70, "Input",
   CellTags->"jlug:5.4.3.0",
   CellID->18114],
  Cell[514458, 16473, 287, 9, 70, "Output",
   CellTags->"jlug:5.4.3.0",
   CellID->11701],
  Cell[514760, 16485, 199, 8, 70, "Text",
   CellTags->"jlug:5.4.3.0",
   CellID->31316],
  Cell[514984, 16497, 163, 5, 70, "Input",
   CellTags->"jlug:5.4.3.0",
   CellID->20671],
  Cell[515150, 16504, 115, 3, 70, "Output",
   CellTags->"jlug:5.4.3.0",
   CellID->5786],
  Cell[515280, 16510, 425, 10, 70, "Text",
   CellTags->"jlug:5.4.3.0",
   CellID->12263]},
 "TableOfContents_1.5.4.3"->{
  Cell[512976, 16418, 110, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.3.0", "TableOfContents_1.5.4.3"},
   CellID->16105]},
 "jlug:5.4.5.0"->{
  Cell[515742, 16525, 107, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.5.0", "TableOfContents_1.5.4.5"},
   CellID->5535],
  Cell[515852, 16529, 1394, 33, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->20450],
  Cell[517249, 16564, 503, 13, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->11173],
  Cell[517755, 16579, 590, 15, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->10466],
  Cell[518348, 16596, 1722, 49, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->12044],
  Cell[520073, 16647, 941, 31, 70, "Input",
   CellTags->"jlug:5.4.5.0",
   CellID->21659],
  Cell[521017, 16680, 1149, 31, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->26292],
  Cell[522169, 16713, 279, 10, 70, "Input",
   CellTags->"jlug:5.4.5.0",
   CellID->26439],
  Cell[522451, 16725, 442, 10, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->17253],
  Cell[522896, 16737, 500, 12, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->20024],
  Cell[523399, 16751, 262, 12, 70, "Input",
   CellTags->"jlug:5.4.5.0",
   CellID->26154],
  Cell[523664, 16765, 729, 22, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->29510],
  Cell[524396, 16789, 653, 18, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->4745],
  Cell[525052, 16809, 348, 10, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->20649],
  Cell[525403, 16821, 468, 9, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->13186],
  Cell[525874, 16832, 98, 2, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->8313],
  Cell[525975, 16836, 172, 6, 70, "Input",
   CellTags->"jlug:5.4.5.0",
   CellID->4474],
  Cell[526150, 16844, 131, 4, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->28022],
  Cell[526284, 16850, 286, 9, 70, "Input",
   CellTags->"jlug:5.4.5.0",
   CellID->2168],
  Cell[526573, 16861, 294, 7, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->14018],
  Cell[526870, 16870, 271, 9, 70, "Input",
   CellTags->"jlug:5.4.5.0",
   CellID->18787],
  Cell[527144, 16881, 67, 2, 70, "Text",
   CellTags->"jlug:5.4.5.0",
   CellID->9905],
  Cell[527214, 16885, 140, 4, 70, "Input",
   CellTags->"jlug:5.4.5.0",
   CellID->17958]},
 "TableOfContents_1.5.4.5"->{
  Cell[515742, 16525, 107, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.5.0", "TableOfContents_1.5.4.5"},
   CellID->5535]},
 "jlug:5.4.6.0"->{
  Cell[527391, 16894, 120, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.6.0", "TableOfContents_1.5.4.6"},
   CellID->7391],
  Cell[527514, 16898, 1557, 37, 70, "Text",
   CellTags->"jlug:5.4.6.0",
   CellID->10202],
  Cell[529074, 16937, 2797, 90, 70, "Text",
   CellTags->"jlug:5.4.6.0",
   CellID->3625],
  Cell[531874, 17029, 357, 9, 70, "Text",
   CellTags->"jlug:5.4.6.0",
   CellID->26477],
  Cell[532234, 17040, 451, 13, 70, "Text",
   CellTags->"jlug:5.4.6.0",
   CellID->4414],
  Cell[532688, 17055, 2456, 71, 70, "Input",
   CellTags->"jlug:5.4.6.0",
   CellID->9314],
  Cell[535147, 17128, 77, 2, 70, "Text",
   CellTags->"jlug:5.4.6.0",
   CellID->246580910],
  Cell[535249, 17134, 122, 4, 70, "Input",
   CellTags->"jlug:5.4.6.0",
   CellID->29334],
  Cell[535374, 17140, 98, 3, 70, "Output",
   CellTags->"jlug:5.4.6.0",
   CellID->25874]},
 "TableOfContents_1.5.4.6"->{
  Cell[527391, 16894, 120, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.6.0", "TableOfContents_1.5.4.6"},
   CellID->7391]},
 "jlug:5.4.7.0"->{
  Cell[535521, 17149, 119, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.7.0", "TableOfContents_1.5.4.7"},
   CellID->24372],
  Cell[535643, 17153, 896, 22, 70, "Text",
   CellTags->"jlug:5.4.7.0",
   CellID->20159],
  Cell[536542, 17177, 1215, 22, 70, "Text",
   CellTags->"jlug:5.4.7.0",
   CellID->11833],
  Cell[537760, 17201, 567, 10, 70, "Text",
   CellTags->"jlug:5.4.7.0",
   CellID->28070],
  Cell[538330, 17213, 716, 15, 70, "Text",
   CellTags->"jlug:5.4.7.0",
   CellID->7487],
  Cell[539049, 17230, 1499, 44, 70, "Text",
   CellTags->"jlug:5.4.7.0",
   CellID->28297],
  Cell[540551, 17276, 1109, 32, 70, "Text",
   CellTags->"jlug:5.4.7.0",
   CellID->7518]},
 "TableOfContents_1.5.4.7"->{
  Cell[535521, 17149, 119, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.7.0", "TableOfContents_1.5.4.7"},
   CellID->24372]},
 "jlug:5.4.8.0"->{
  Cell[541697, 17313, 136, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.8.0", "TableOfContents_1.5.4.8"},
   CellID->8177],
  Cell[541836, 17317, 990, 20, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->17773],
  Cell[542829, 17339, 1169, 33, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->32270],
  Cell[544001, 17374, 1858, 49, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->1763],
  Cell[545862, 17425, 452, 11, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->2668],
  Cell[546317, 17438, 923, 29, 70, "Input",
   CellTags->"jlug:5.4.8.0",
   CellID->17192],
  Cell[547243, 17469, 389, 10, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->13985],
  Cell[547635, 17481, 139, 4, 70, "Input",
   CellTags->"jlug:5.4.8.0",
   CellID->3102],
  Cell[547777, 17487, 2631, 75, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->8480],
  Cell[550411, 17564, 1571, 34, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->29213],
  Cell[551985, 17600, 1035, 28, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->7627],
  Cell[553023, 17630, 547, 15, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->4802],
  Cell[553573, 17647, 559, 13, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->4099],
  Cell[554135, 17662, 491, 17, 70, "Input",
   CellTags->"jlug:5.4.8.0",
   CellID->30527],
  Cell[554629, 17681, 898, 22, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->2625],
  Cell[555530, 17705, 530, 10, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->1543],
  Cell[556063, 17717, 405, 15, 70, "Input",
   CellTags->"jlug:5.4.8.0",
   CellID->1924],
  Cell[556471, 17734, 295, 9, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->11023],
  Cell[556769, 17745, 237, 8, 70, "Input",
   CellTags->"jlug:5.4.8.0",
   CellID->29972],
  Cell[557009, 17755, 539, 14, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->13061],
  Cell[557551, 17771, 383, 15, 70, "Input",
   CellTags->"jlug:5.4.8.0",
   CellID->14181],
  Cell[557937, 17788, 422, 11, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->31003],
  Cell[558362, 17801, 701, 20, 70, "Input",
   CellTags->"jlug:5.4.8.0",
   CellID->863759],
  Cell[559066, 17823, 1630, 48, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->17505],
  Cell[560699, 17873, 745, 21, 70, "Input",
   CellTags->"jlug:5.4.8.0",
   CellID->27593],
  Cell[561447, 17896, 118, 2, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->22725],
  Cell[561568, 17900, 213, 7, 70, "Input",
   CellTags->"jlug:5.4.8.0",
   CellID->13031],
  Cell[561784, 17909, 595, 12, 70, "Text",
   CellTags->"jlug:5.4.8.0",
   CellID->8492]},
 "TableOfContents_1.5.4.8"->{
  Cell[541697, 17313, 136, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.8.0", "TableOfContents_1.5.4.8"},
   CellID->8177]},
 "jlug:5.4.9.0"->{
  Cell[562416, 17926, 129, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.9.0", "TableOfContents_1.5.4.9"},
   CellID->142],
  Cell[562548, 17930, 1079, 19, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->17222],
  Cell[563630, 17951, 446, 13, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->31286],
  Cell[564079, 17966, 117, 2, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->13064],
  Cell[564199, 17970, 2097, 53, 70, "Input",
   CellTags->"jlug:5.4.9.0",
   CellID->7900],
  Cell[566299, 18025, 2316, 66, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->19187],
  Cell[568618, 18093, 501, 12, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->399338963],
  Cell[569122, 18107, 107, 2, 70, "Program",
   CellTags->"jlug:5.4.9.0",
   CellID->22413],
  Cell[569232, 18111, 2706, 71, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->30974],
  Cell[571941, 18184, 263, 7, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->14270],
  Cell[572207, 18193, 432, 16, 70, "Input",
   CellTags->"jlug:5.4.9.0",
   CellID->29170],
  Cell[572642, 18211, 1220, 35, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->235],
  Cell[573865, 18248, 322, 8, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->30833],
  Cell[574190, 18258, 162, 5, 70, "Input",
   CellTags->"jlug:5.4.9.0",
   CellID->19711],
  Cell[574355, 18265, 631, 20, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->25760],
  Cell[574989, 18287, 1457, 49, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->18896],
  Cell[576449, 18338, 1348, 41, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->4667],
  Cell[577800, 18381, 1015, 28, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->7285],
  Cell[578818, 18411, 790, 22, 70, "Input",
   CellTags->"jlug:5.4.9.0",
   CellID->12550],
  Cell[579611, 18435, 68, 2, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->140],
  Cell[579682, 18439, 165, 5, 70, "Input",
   CellTags->"jlug:5.4.9.0",
   CellID->13694],
  Cell[579850, 18446, 264, 6, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->2695],
  Cell[580117, 18454, 1585, 46, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->21624],
  Cell[581705, 18502, 841, 23, 70, "Input",
   CellTags->"jlug:5.4.9.0",
   CellID->28019],
  Cell[582549, 18527, 1173, 38, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->2125],
  Cell[583725, 18567, 1071, 30, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->26576],
  Cell[584799, 18599, 174, 6, 70, "Input",
   CellTags->"jlug:5.4.9.0",
   CellID->21694],
  Cell[584976, 18607, 518, 18, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->22658],
  Cell[585497, 18627, 254, 7, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->26302],
  Cell[585754, 18636, 168, 5, 70, "Input",
   CellTags->"jlug:5.4.9.0",
   CellID->17371],
  Cell[585925, 18643, 511, 13, 70, "Text",
   CellTags->"jlug:5.4.9.0",
   CellID->22466]},
 "TableOfContents_1.5.4.9"->{
  Cell[562416, 17926, 129, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.9.0", "TableOfContents_1.5.4.9"},
   CellID->142]},
 "jlug:5.4.10.0"->{
  Cell[586473, 18661, 147, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.10.0", "TableOfContents_1.5.4.10"},
   CellID->4678],
  Cell[586623, 18665, 1171, 33, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->22593],
  Cell[587797, 18700, 989, 20, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->23851],
  Cell[588789, 18722, 786, 17, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->25484],
  Cell[589578, 18741, 226, 6, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->1018],
  Cell[589807, 18749, 855, 22, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->28464],
  Cell[590665, 18773, 927, 19, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->21119],
  Cell[591595, 18794, 721, 22, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->23152],
  Cell[592319, 18818, 239, 6, 70, "Program",
   CellTags->"jlug:5.4.10.0",
   CellID->2800],
  Cell[592561, 18826, 138, 4, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->18087],
  Cell[592702, 18832, 598, 17, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->31060],
  Cell[593303, 18851, 882, 25, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->1926],
  Cell[594188, 18878, 253, 8, 70, "Input",
   CellTags->"jlug:5.4.10.0",
   CellID->273216376],
  Cell[594444, 18888, 252, 8, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->4757],
  Cell[594699, 18898, 1755, 50, 70, "Input",
   CellTags->"jlug:5.4.10.0",
   CellID->32170],
  Cell[596457, 18950, 1574, 34, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->20315],
  Cell[598034, 18986, 78, 2, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->9576],
  Cell[598115, 18990, 107, 3, 70, "Input",
   CellTags->"jlug:5.4.10.0",
   CellID->30227],
  Cell[598225, 18995, 1251, 25, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->12043],
  Cell[599479, 19022, 140, 4, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->22758],
  Cell[599622, 19028, 581, 18, 70, "Input",
   CellTags->"jlug:5.4.10.0",
   CellID->7164],
  Cell[600206, 19048, 859, 25, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->5109],
  Cell[601068, 19075, 189, 5, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->7882],
  Cell[601260, 19082, 110, 3, 70, "Input",
   CellTags->"jlug:5.4.10.0",
   CellID->17086],
  Cell[601373, 19087, 1009, 22, 70, "Text",
   CellTags->"jlug:5.4.10.0",
   CellID->29565]},
 "TableOfContents_1.5.4.10"->{
  Cell[586473, 18661, 147, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.10.0", "TableOfContents_1.5.4.10"},
   CellID->4678]},
 "jlug:5.4.11.0"->{
  Cell[602419, 19114, 129, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.11.0", "TableOfContents_1.5.4.11"},
   CellID->3487],
  Cell[602551, 19118, 922, 27, 70, "Text",
   CellTags->"jlug:5.4.11.0",
   CellID->29577],
  Cell[603476, 19147, 582, 16, 70, "Text",
   CellTags->"jlug:5.4.11.0",
   CellID->14474],
  Cell[604061, 19165, 432, 17, 70, "Program",
   CellTags->"jlug:5.4.11.0",
   CellID->25627],
  Cell[604496, 19184, 2195, 63, 70, "Text",
   CellTags->"jlug:5.4.11.0",
   CellID->5629],
  Cell[606694, 19249, 594, 13, 70, "Text",
   CellTags->"jlug:5.4.11.0",
   CellID->31928]},
 "TableOfContents_1.5.4.11"->{
  Cell[602419, 19114, 129, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.11.0", "TableOfContents_1.5.4.11"},
   CellID->3487]},
 "jlug:5.4.12.0"->{
  Cell[607325, 19267, 106, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.12.0", "TableOfContents_1.5.4.12"},
   CellID->25423],
  Cell[607434, 19271, 679, 16, 70, "Text",
   CellTags->"jlug:5.4.12.0",
   CellID->28520],
  Cell[608116, 19289, 433, 13, 70, "Text",
   CellTags->"jlug:5.4.12.0",
   CellID->6902],
  Cell[608552, 19304, 900, 22, 70, "Text",
   CellTags->"jlug:5.4.12.0",
   CellID->14962],
  Cell[609455, 19328, 859, 21, 70, "Text",
   CellTags->"jlug:5.4.12.0",
   CellID->123],
  Cell[610317, 19351, 1169, 30, 70, "Text",
   CellTags->"jlug:5.4.12.0",
   CellID->24596]},
 "TableOfContents_1.5.4.12"->{
  Cell[607325, 19267, 106, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.12.0", "TableOfContents_1.5.4.12"},
   CellID->25423]},
 "jlug:5.4.13.0"->{
  Cell[611523, 19386, 111, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.13.0", "TableOfContents_1.5.4.13"},
   CellID->3737],
  Cell[611637, 19390, 1375, 34, 70, "Text",
   CellTags->"jlug:5.4.13.0",
   CellID->13261]},
 "TableOfContents_1.5.4.13"->{
  Cell[611523, 19386, 111, 2, 70, "Subsection",
   CellTags->{"jlug:5.4.13.0", "TableOfContents_1.5.4.13"},
   CellID->3737]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"TableOfContents_1.5.1", 615693, 19476},
 {"jlug:5.1.0.0", 615808, 19480},
 {"jlug:5.2.1.0", 616173, 19493},
 {"TableOfContents_1.5.2.1", 616493, 19503},
 {"jlug:5.2.2.0", 616631, 19507},
 {"TableOfContents_1.5.2.2", 616780, 19511},
 {"jlug:5.2.2.1", 616918, 19515},
 {"TableOfContents_1.5.2.2.1", 617879, 19546},
 {"jlug:5.2.2.2", 618022, 19550},
 {"TableOfContents_1.5.2.2.2", 618573, 19568},
 {"jlug:5.2.2.3", 618716, 19572},
 {"TableOfContents_1.5.2.2.3", 619277, 19590},
 {"jlug:5.2.3.0", 619421, 19594},
 {"TableOfContents_1.5.2.3", 619571, 19598},
 {"jlug:5.2.3.1", 619710, 19602},
 {"TableOfContents_1.5.2.3.1", 620763, 19636},
 {"jlug:5.2.3.2", 620906, 19640},
 {"TableOfContents_1.5.2.3.2", 621987, 19674},
 {"jlug:5.2.3.3", 622131, 19678},
 {"TableOfContents_1.5.2.3.3", 622910, 19703},
 {"jlug:5.2.3.4", 623054, 19707},
 {"TableOfContents_1.5.2.3.4", 623677, 19727},
 {"TableOfContents_1.5.2.4", 623832, 19731},
 {"1.1.4", 623974, 19735},
 {"jlug:5.2.4.0", 624123, 19739},
 {"jlug:5.2.5.0", 624908, 19764},
 {"TableOfContents_1.5.2.5", 626578, 19819},
 {"TableOfContents_1.5.2.6", 626727, 19823},
 {"1.1.6", 626869, 19827},
 {"jlug:5.2.6.0", 627018, 19831},
 {"jlug:5.2.6.1", 627167, 19835},
 {"TableOfContents_1.5.2.6.1", 629918, 19927},
 {"jlug:5.2.6.2", 630063, 19931},
 {"TableOfContents_1.5.2.6.2", 631152, 19967},
 {"jlug:5.2.7.0", 631297, 19971},
 {"TableOfContents_1.5.2.7", 632562, 20012},
 {"jlug:5.2.8.0", 632701, 20016},
 {"TableOfContents_1.5.2.8", 633394, 20038},
 {"jlug:5.2.9.0", 633534, 20042},
 {"TableOfContents_1.5.2.9", 634583, 20076},
 {"TableOfContents_1.5.3.1", 634734, 20080},
 {"1.2.1", 634876, 20084},
 {"jlug:5.3.1.0", 635155, 20091},
 {"jlug:5.3.1.1", 635304, 20095},
 {"TableOfContents_1.5.3.1.1", 635728, 20108},
 {"jlug:5.3.1.2", 635873, 20112},
 {"TableOfContents_1.5.3.1.2", 636793, 20142},
 {"jlug:5.3.1.3", 636938, 20146},
 {"TableOfContents_1.5.3.1.3", 637914, 20177},
 {"jlug:5.3.1.4", 638060, 20181},
 {"TableOfContents_1.5.3.1.4", 638498, 20194},
 {"jlug:5.3.1.5", 638644, 20198},
 {"TableOfContents_1.5.3.1.5", 640066, 20244},
 {"TableOfContents_1.5.3.2", 640222, 20248},
 {"jlug:5.3.2.0", 640372, 20252},
 {"jlug:5.3.2.1", 640522, 20256},
 {"TableOfContents_1.5.3.2.1", 641040, 20272},
 {"jlug:5.3.2.4", 641185, 20276},
 {"TableOfContents_1.5.3.2.4", 641999, 20302},
 {"jlug:5.3.2.5", 642145, 20306},
 {"TableOfContents_1.5.3.2.5", 643835, 20361},
 {"TableOfContents_1.5.3.3", 643992, 20365},
 {"1.2.2", 644135, 20369},
 {"jlug:5.3.3.0", 644285, 20373},
 {"jlug:5.3.3.1", 644435, 20377},
 {"TableOfContents_1.5.3.3.1", 646575, 20447},
 {"jlug:5.3.3.2", 646721, 20451},
 {"TableOfContents_1.5.3.3.2", 648237, 20500},
 {"jlug:5.3.3.3", 648383, 20504},
 {"TableOfContents_1.5.3.3.3", 649696, 20547},
 {"jlug:5.3.3.5", 649842, 20551},
 {"TableOfContents_1.5.3.3.5", 650181, 20561},
 {"TableOfContents_1.5.3.4", 650338, 20565},
 {"1.2.3", 650481, 20569},
 {"jlug:5.3.4.0", 650631, 20573},
 {"jlug:5.3.4.1", 650781, 20577},
 {"TableOfContents_1.5.3.4.1", 651501, 20600},
 {"jlug:5.3.4.2", 651647, 20604},
 {"TableOfContents_1.5.3.4.2", 652449, 20629},
 {"TableOfContents_1.5.3.5", 652606, 20633},
 {"1.2.5", 652750, 20637},
 {"jlug:5.3.5.0", 652901, 20641},
 {"jlug:5.3.5.1", 653052, 20645},
 {"TableOfContents_1.5.3.5.1", 653675, 20664},
 {"jlug:5.3.5.2", 653820, 20668},
 {"TableOfContents_1.5.3.5.2", 656394, 20754},
 {"jlug:5.3.5.3", 656540, 20758},
 {"TableOfContents_1.5.3.5.3", 657692, 20795},
 {"TableOfContents_1.5.3.6", 657848, 20799},
 {"1.2.6", 657991, 20803},
 {"jlug:5.3.6.0", 658141, 20807},
 {"jlug:5.3.6.1", 658291, 20811},
 {"TableOfContents_1.5.3.6.1", 658540, 20818},
 {"jlug:5.3.6.2", 658686, 20822},
 {"TableOfContents_1.5.3.6.2", 662484, 20947},
 {"jlug:5.3.6.3", 662630, 20951},
 {"TableOfContents_1.5.3.6.3", 664325, 21006},
 {"jlug:5.3.7.0", 664470, 21010},
 {"TableOfContents_1.5.3.7", 664621, 21014},
 {"jlug:5.3.7.1", 664761, 21018},
 {"TableOfContents_1.5.3.7.1", 665191, 21031},
 {"jlug:5.3.7.2", 665337, 21035},
 {"TableOfContents_1.5.3.7.2", 666306, 21066},
 {"jlug:5.3.7.3", 666456, 21070},
 {"TableOfContents_1.5.3.7.3", 667062, 21089},
 {"jlug:5.3.7.4", 667206, 21093},
 {"TableOfContents_1.5.3.7.4", 668647, 21139},
 {"jlug:5.3.7.5", 668792, 21143},
 {"TableOfContents_1.5.3.7.5", 669321, 21159},
 {"jlug:5.3.7.6", 669466, 21163},
 {"TableOfContents_1.5.3.7.6", 672538, 21264},
 {"jlug:5.3.7.7", 672684, 21268},
 {"TableOfContents_1.5.3.7.7", 672934, 21275},
 {"jlug:5.3.7.8", 673080, 21279},
 {"TableOfContents_1.5.3.7.8", 674780, 21334},
 {"jlug:5.3.7.9", 674926, 21338},
 {"TableOfContents_1.5.3.7.9", 676278, 21381},
 {"jlug:5.3.7.10", 676426, 21385},
 {"TableOfContents_1.5.3.7.10", 676956, 21401},
 {"jlug:5.3.7.11", 677106, 21405},
 {"TableOfContents_1.5.3.7.11", 678102, 21436},
 {"jlug:5.3.7.12", 678252, 21440},
 {"TableOfContents_1.5.3.7.12", 678507, 21447},
 {"jlug:5.3.8.0", 678655, 21451},
 {"TableOfContents_1.5.3.8", 678808, 21455},
 {"jlug:5.3.8.1", 678950, 21459},
 {"TableOfContents_1.5.3.8.1", 679388, 21472},
 {"jlug:5.3.8.2", 679535, 21476},
 {"TableOfContents_1.5.3.8.2", 681240, 21531},
 {"jlug:5.3.8.3", 681387, 21535},
 {"TableOfContents_1.5.3.8.3", 682459, 21569},
 {"jlug:5.3.8.4", 682606, 21573},
 {"TableOfContents_1.5.3.8.4", 683758, 21610},
 {"jlug:5.3.9.0", 683905, 21614},
 {"TableOfContents_1.5.3.9", 684889, 21645},
 {"jlug:5.3.10.0", 685032, 21649},
 {"TableOfContents_1.5.3.10", 686334, 21691},
 {"TableOfContents_1.5.3.12", 686490, 21695},
 {"1.2.12", 686638, 21699},
 {"jlug:5.3.12.0", 686793, 21703},
 {"jlug:5.3.13.0", 689097, 21777},
 {"TableOfContents_1.5.3.13", 690826, 21832},
 {"jlug:5.3.14.0", 690971, 21836},
 {"TableOfContents_1.5.3.14", 691127, 21840},
 {"jlug:5.3.14.1", 691272, 21844},
 {"TableOfContents_1.5.3.14.1", 691617, 21854},
 {"jlug:5.3.14.2", 691766, 21858},
 {"TableOfContents_1.5.3.14.2", 692205, 21871},
 {"1.2.14", 692348, 21875},
 {"jlug:5.3.14.3", 692508, 21879},
 {"TableOfContents_1.5.3.14.3", 693715, 21916},
 {"jlug:5.3.14.4", 693875, 21920},
 {"TableOfContents_1.5.3.14.4", 694131, 21927},
 {"jlug:5.3.15.0", 694281, 21931},
 {"TableOfContents_1.5.3.15", 695827, 21980},
 {"1.2.17", 695964, 21984},
 {"jlug:5.3.17.0", 696118, 21988},
 {"TableOfContents_1.5.3.17", 697121, 22019},
 {"1.2.18", 697268, 22023},
 {"jlug:5.3.18.0", 697422, 22027},
 {"TableOfContents_1.5.3.18", 697587, 22031},
 {"jlug:5.3.18.1", 697741, 22035},
 {"TableOfContents_1.5.3.18.1", 698456, 22057},
 {"jlug:5.3.18.2", 698605, 22061},
 {"TableOfContents_1.5.3.18.2", 698950, 22071},
 {"jlug:5.3.18.3", 699099, 22075},
 {"TableOfContents_1.5.3.18.3", 699443, 22085},
 {"jlug:5.3.18.4", 699593, 22089},
 {"TableOfContents_1.5.3.18.4", 701235, 22141},
 {"jlug:5.3.18.5", 701385, 22145},
 {"TableOfContents_1.5.3.18.5", 702382, 22176},
 {"jlug:5.3.18.6", 702532, 22180},
 {"TableOfContents_1.5.3.18.6", 704847, 22254},
 {"jlug:5.3.18.7", 704997, 22258},
 {"TableOfContents_1.5.3.18.7", 705252, 22265},
 {"jlug:5.3.18.8", 705402, 22269},
 {"TableOfContents_1.5.3.18.8", 706488, 22303},
 {"jlug:5.3.18.9", 706636, 22307},
 {"TableOfContents_1.5.3.18.9", 708296, 22359},
 {"jlug:5.3.18.10", 708447, 22363},
 {"TableOfContents_1.5.3.18.10", 709756, 22404},
 {"jlug:5.3.19.0", 709908, 22408},
 {"TableOfContents_1.5.3.19", 711394, 22454},
 {"TableOfContents_1.5.3.19.1", 711552, 22458},
 {"TableOfContents_1.5.4", 711710, 22462},
 {"1.3", 711848, 22466},
 {"jlug:5.4.0.0", 711995, 22470},
 {"jlug:5.4.1.0", 712142, 22474},
 {"TableOfContents_1.5.4.1", 712571, 22487},
 {"jlug:5.4.2.0", 712716, 22491},
 {"TableOfContents_1.5.4.2", 713694, 22522},
 {"jlug:5.4.3.0", 713839, 22526},
 {"TableOfContents_1.5.4.3", 714904, 22560},
 {"jlug:5.4.5.0", 715049, 22564},
 {"TableOfContents_1.5.4.5", 717200, 22634},
 {"jlug:5.4.6.0", 717344, 22638},
 {"TableOfContents_1.5.4.6", 718229, 22666},
 {"jlug:5.4.7.0", 718373, 22670},
 {"TableOfContents_1.5.4.7", 719076, 22692},
 {"jlug:5.4.8.0", 719221, 22696},
 {"TableOfContents_1.5.4.8", 721833, 22781},
 {"jlug:5.4.9.0", 721977, 22785},
 {"TableOfContents_1.5.4.9", 724866, 22879},
 {"jlug:5.4.10.0", 725010, 22883},
 {"TableOfContents_1.5.4.10", 727374, 22959},
 {"jlug:5.4.11.0", 727521, 22963},
 {"TableOfContents_1.5.4.11", 728142, 22982},
 {"jlug:5.4.12.0", 728289, 22986},
 {"TableOfContents_1.5.4.12", 728906, 23005},
 {"jlug:5.4.13.0", 729054, 23009},
 {"TableOfContents_1.5.4.13", 729305, 23016}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 176, 7, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[801, 34, 119, 5, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[945, 43, 79, 2, 70, "Section",
 CellTags->"TableOfContents_1.5.1",
 CellID->23811],
Cell[1027, 47, 891, 27, 70, "Text",
 CellTags->"jlug:5.1.0.0",
 CellID->31322],
Cell[1921, 76, 842, 25, 70, "Text",
 CellTags->"jlug:5.1.0.0",
 CellID->30333],
Cell[2766, 103, 870, 20, 70, "Text",
 CellTags->"jlug:5.1.0.0",
 CellID->17673],
Cell[3639, 125, 633, 18, 70, "Text",
 CellTags->"jlug:5.1.0.0",
 CellID->4664]
}, Open  ]],
Cell[CellGroupData[{
Cell[4309, 148, 175, 7, 70, "Section",
 CellTags->{"jlug:5.2.1.0", "TableOfContents_1.5.2.1"},
 CellID->19690],
Cell[4487, 157, 166, 7, 70, "Text",
 CellTags->"jlug:5.2.1.0",
 CellID->1650],
Cell[4656, 166, 136, 4, 70, "Input",
 CellTags->"jlug:5.2.1.0",
 CellID->5662]
}, Open  ]],
Cell[CellGroupData[{
Cell[4829, 175, 117, 2, 70, "Section",
 CellTags->{"jlug:5.2.2.0", "TableOfContents_1.5.2.2"},
 CellID->21634],
Cell[CellGroupData[{
Cell[4971, 181, 107, 2, 70, "Subsection",
 CellTags->{"jlug:5.2.2.1", "TableOfContents_1.5.2.2.1"},
 CellID->10893],
Cell[5081, 185, 415, 15, 70, "Text",
 CellTags->"jlug:5.2.2.1",
 CellID->10353],
Cell[5499, 202, 1060, 34, 70, "DefinitionBox",
 CellTags->"jlug:5.2.2.1",
 CellID->21416],
Cell[6562, 238, 89, 2, 70, "Caption",
 CellTags->"jlug:5.2.2.1",
 CellID->13452],
Cell[CellGroupData[{
Cell[6676, 244, 125, 4, 70, "Input",
 CellTags->"jlug:5.2.2.1",
 CellID->14008],
Cell[6804, 250, 199, 6, 70, "Output",
 CellTags->"jlug:5.2.2.1",
 CellID->7262]
}, Open  ]],
Cell[7018, 259, 553, 15, 70, "Text",
 CellTags->"jlug:5.2.2.1",
 CellID->22233],
Cell[7574, 276, 1115, 25, 70, "Text",
 CellTags->"jlug:5.2.2.1",
 CellID->5454],
Cell[8692, 303, 670, 17, 70, "DefinitionBox",
 CellTags->"jlug:5.2.2.1",
 CellID->16634],
Cell[9365, 322, 226, 9, 70, "Caption",
 CellTags->"jlug:5.2.2.1",
 CellID->26303]
}, Open  ]],
Cell[CellGroupData[{
Cell[9628, 336, 139, 2, 70, "Subsection",
 CellTags->{"jlug:5.2.2.2", "TableOfContents_1.5.2.2.2"},
 CellID->14256],
Cell[9770, 340, 625, 18, 70, "Text",
 CellTags->"jlug:5.2.2.2",
 CellID->148],
Cell[10398, 360, 218, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.2.2",
 CellID->11124],
Cell[10619, 369, 1040, 30, 70, "Text",
 CellTags->"jlug:5.2.2.2",
 CellID->12317],
Cell[11662, 401, 215, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.2.2",
 CellID->4213]
}, Open  ]],
Cell[CellGroupData[{
Cell[11914, 413, 121, 2, 70, "Subsection",
 CellTags->{"jlug:5.2.2.3", "TableOfContents_1.5.2.2.3"},
 CellID->27109],
Cell[12038, 417, 1519, 39, 70, "Text",
 CellTags->"jlug:5.2.2.3",
 CellID->24028],
Cell[13560, 458, 294, 9, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.2.3",
 CellID->29200],
Cell[13857, 469, 313, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.2.3",
 CellID->36235640],
Cell[14173, 481, 1491, 40, 70, "Text",
 CellTags->"jlug:5.2.2.3",
 CellID->21080]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15713, 527, 106, 2, 70, "Section",
 CellTags->{"jlug:5.2.3.0", "TableOfContents_1.5.2.3"},
 CellID->24948],
Cell[CellGroupData[{
Cell[15844, 533, 108, 2, 70, "Subsection",
 CellTags->{"jlug:5.2.3.1", "TableOfContents_1.5.2.3.1"},
 CellID->1282],
Cell[15955, 537, 743, 24, 70, "DefinitionBox",
 CellTags->"jlug:5.2.3.1",
 CellID->13653],
Cell[16701, 563, 78, 2, 70, "Caption",
 CellTags->"jlug:5.2.3.1",
 CellID->30674],
Cell[16782, 567, 742, 22, 70, "Text",
 CellTags->"jlug:5.2.3.1",
 CellID->2220],
Cell[CellGroupData[{
Cell[17549, 593, 180, 5, 70, "Input",
 CellTags->"jlug:5.2.3.1",
 CellID->5402],
Cell[17732, 600, 201, 6, 70, "Output",
 CellTags->"jlug:5.2.3.1",
 CellID->6923]
}, Open  ]],
Cell[17948, 609, 1287, 38, 70, "Text",
 CellTags->"jlug:5.2.3.1",
 CellID->3831],
Cell[19238, 649, 344, 9, 70, "Text",
 CellTags->"jlug:5.2.3.1",
 CellID->19369],
Cell[19585, 660, 891, 27, 70, "DefinitionBox",
 CellTags->"jlug:5.2.3.1",
 CellID->3878],
Cell[20479, 689, 217, 8, 70, "Caption",
 CellTags->"jlug:5.2.3.1",
 CellID->20259],
Cell[20699, 699, 580, 18, 70, "Text",
 CellTags->"jlug:5.2.3.1",
 CellID->19008]
}, Open  ]],
Cell[CellGroupData[{
Cell[21316, 722, 122, 2, 70, "Subsection",
 CellTags->{"jlug:5.2.3.2", "TableOfContents_1.5.2.3.2"},
 CellID->22619],
Cell[21441, 726, 1433, 40, 70, "Text",
 CellTags->"jlug:5.2.3.2",
 CellID->23971],
Cell[22877, 768, 269, 6, 70, "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->30003],
Cell[23149, 776, 608, 19, 70, "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->21945],
Cell[23760, 797, 164, 5, 70, "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->9781],
Cell[23927, 804, 402, 8, 70, "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->26504],
Cell[24332, 814, 969, 26, 70, "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->12392],
Cell[CellGroupData[{
Cell[25326, 844, 122, 2, 70, "BulletedText",
 CellTags->"jlug:5.2.3.2",
 CellID->32685],
Cell[25451, 848, 1266, 38, 70, "Text",
 CellTags->"jlug:5.2.3.2",
 CellID->25313],
Cell[26720, 888, 1553, 46, 70, "Text",
 CellTags->"jlug:5.2.3.2",
 CellID->6698],
Cell[28276, 936, 983, 19, 70, "Text",
 CellTags->"jlug:5.2.3.2",
 CellID->5589]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29308, 961, 137, 2, 70, "Subsection",
 CellTags->{"jlug:5.2.3.3", "TableOfContents_1.5.2.3.3"},
 CellID->12722],
Cell[29448, 965, 1503, 34, 70, "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->5938],
Cell[30954, 1001, 1997, 55, 70, "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->19037],
Cell[32954, 1058, 2369, 67, 70, "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->6410],
Cell[35326, 1127, 736, 18, 70, "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->31461],
Cell[36065, 1147, 149, 6, 70, "Program",
 CellTags->"jlug:5.2.3.3",
 CellID->6234],
Cell[36217, 1155, 605, 22, 70, "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->12508],
Cell[36825, 1179, 294, 9, 70, "Text",
 CellTags->"jlug:5.2.3.3",
 CellID->9961]
}, Open  ]],
Cell[CellGroupData[{
Cell[37156, 1193, 108, 2, 70, "Subsection",
 CellTags->{"jlug:5.2.3.4", "TableOfContents_1.5.2.3.4"},
 CellID->3959],
Cell[37267, 1197, 439, 12, 70, "Text",
 CellTags->"jlug:5.2.3.4",
 CellID->6493],
Cell[37709, 1211, 112, 4, 70, "Program",
 CellTags->"jlug:5.2.3.4",
 CellID->1515],
Cell[37824, 1217, 287, 8, 70, "Text",
 CellTags->"jlug:5.2.3.4",
 CellID->25269],
Cell[38114, 1227, 223, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.3.4",
 CellID->24937],
Cell[38340, 1236, 192, 5, 70, "Text",
 CellTags->"jlug:5.2.3.4",
 CellID->28869]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38581, 1247, 201, 6, 70, "Section",
 CellTags->{"TableOfContents_1.5.2.4", "1.1.4", "jlug:5.2.4.0"},
 CellID->17780],
Cell[38785, 1255, 1047, 26, 70, "Text",
 CellTags->"jlug:5.2.4.0",
 CellID->22578],
Cell[39835, 1283, 2416, 66, 70, "DefinitionBox",
 CellTags->"jlug:5.2.4.0",
 CellID->12931],
Cell[42254, 1351, 164, 7, 70, "Caption",
 CellTags->"jlug:5.2.4.0",
 CellID->32544],
Cell[42421, 1360, 524, 16, 70, "Text",
 CellTags->"jlug:5.2.4.0",
 CellID->3340],
Cell[42948, 1378, 682, 19, 70, "Text",
 CellTags->"jlug:5.2.4.0",
 CellID->13487],
Cell[43633, 1399, 180, 6, 70, "Program",
 CellTags->"jlug:5.2.4.0",
 CellID->899],
Cell[43816, 1407, 1707, 42, 70, "Text",
 CellTags->"jlug:5.2.4.0",
 CellID->22525]
}, Open  ]],
Cell[CellGroupData[{
Cell[45560, 1454, 105, 2, 70, "Section",
 CellTags->{"jlug:5.2.5.0", "TableOfContents_1.5.2.5"},
 CellID->900],
Cell[45668, 1458, 1006, 27, 70, "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->32591],
Cell[46677, 1487, 942, 29, 70, "DefinitionBox",
 CellTags->"jlug:5.2.5.0",
 CellID->18762],
Cell[47622, 1518, 87, 2, 70, "Caption",
 CellTags->"jlug:5.2.5.0",
 CellID->1655],
Cell[47712, 1522, 142, 6, 70, "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->17410],
Cell[CellGroupData[{
Cell[47879, 1532, 171, 5, 70, "Input",
 CellTags->"jlug:5.2.5.0",
 CellID->6359],
Cell[48053, 1539, 271, 8, 70, "Output",
 CellTags->"jlug:5.2.5.0",
 CellID->27624]
}, Open  ]],
Cell[48339, 1550, 1754, 51, 70, "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->20537],
Cell[50096, 1603, 1113, 30, 70, "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->21548],
Cell[51212, 1635, 232, 7, 70, "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->6483],
Cell[CellGroupData[{
Cell[51469, 1646, 223, 7, 70, "Input",
 CellTags->"jlug:5.2.5.0",
 CellID->27595],
Cell[51695, 1655, 269, 8, 70, "Output",
 CellTags->"jlug:5.2.5.0",
 CellID->4041]
}, Open  ]],
Cell[51979, 1666, 619, 19, 70, "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->3602],
Cell[52601, 1687, 653, 17, 70, "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->24350],
Cell[53257, 1706, 357, 12, 70, "Input",
 CellTags->"jlug:5.2.5.0",
 CellID->10291],
Cell[53617, 1720, 758, 23, 70, "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->30836],
Cell[54378, 1745, 564, 16, 70, "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->9374],
Cell[54945, 1763, 667, 20, 70, "Text",
 CellTags->"jlug:5.2.5.0",
 CellID->11020]
}, Open  ]],
Cell[CellGroupData[{
Cell[55649, 1788, 136, 2, 70, "Section",
 CellTags->{"TableOfContents_1.5.2.6", "1.1.6", "jlug:5.2.6.0"},
 CellID->15615],
Cell[CellGroupData[{
Cell[55810, 1794, 102, 2, 70, "Subsection",
 CellTags->{"jlug:5.2.6.1", "TableOfContents_1.5.2.6.1"},
 CellID->20528],
Cell[55915, 1798, 850, 25, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->13234],
Cell[56768, 1825, 716, 19, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->12570],
Cell[57487, 1846, 2552, 76, 70, "DefinitionBox",
 CellTags->"jlug:5.2.6.1",
 CellID->905],
Cell[60042, 1924, 158, 7, 70, "Caption",
 CellTags->"jlug:5.2.6.1",
 CellID->9464],
Cell[60203, 1933, 652, 20, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->19557],
Cell[60858, 1955, 397, 13, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.1",
 CellID->28962],
Cell[61258, 1970, 280, 8, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->14161],
Cell[61541, 1980, 643, 18, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->30524],
Cell[62187, 2000, 1587, 47, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->12549],
Cell[63777, 2049, 670, 21, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.1",
 CellID->17469],
Cell[64450, 2072, 164, 5, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->330],
Cell[64617, 2079, 250, 9, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.1",
 CellID->31923],
Cell[64870, 2090, 1177, 33, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->28350],
Cell[CellGroupData[{
Cell[66072, 2127, 171, 5, 70, "Input",
 CellTags->"jlug:5.2.6.1",
 CellID->14333],
Cell[66246, 2134, 257, 8, 70, "Output",
 CellTags->"jlug:5.2.6.1",
 CellID->22925]
}, Open  ]],
Cell[66518, 2145, 468, 17, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->10910],
Cell[66989, 2164, 161, 5, 70, "Input",
 CellTags->"jlug:5.2.6.1",
 CellID->19737],
Cell[67153, 2171, 209, 8, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->16336],
Cell[67365, 2181, 180, 7, 70, "Input",
 CellTags->"jlug:5.2.6.1",
 CellID->18337],
Cell[67548, 2190, 900, 25, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->1278],
Cell[68451, 2217, 299, 11, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.1",
 CellID->12393],
Cell[68753, 2230, 390, 13, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->30714],
Cell[69146, 2245, 911, 21, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->28164],
Cell[70060, 2268, 239, 8, 70, "Input",
 CellTags->"jlug:5.2.6.1",
 CellID->31591],
Cell[70302, 2278, 1601, 43, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->19949],
Cell[71906, 2323, 152, 5, 70, "Input",
 CellTags->"jlug:5.2.6.1",
 CellID->19135],
Cell[72061, 2330, 781, 23, 70, "Text",
 CellTags->"jlug:5.2.6.1",
 CellID->2505],
Cell[72845, 2355, 264, 9, 70, "Input",
 CellTags->"jlug:5.2.6.1",
 CellID->13337]
}, Open  ]],
Cell[CellGroupData[{
Cell[73146, 2369, 121, 2, 70, "Subsection",
 CellTags->{"jlug:5.2.6.2", "TableOfContents_1.5.2.6.2"},
 CellID->10004],
Cell[73270, 2373, 666, 15, 70, "Text",
 CellTags->"jlug:5.2.6.2",
 CellID->16337],
Cell[73939, 2390, 281, 9, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.2",
 CellID->2623],
Cell[74223, 2401, 203, 5, 70, "Text",
 CellTags->"jlug:5.2.6.2",
 CellID->28664],
Cell[74429, 2408, 232, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.6.2",
 CellID->9970],
Cell[74664, 2417, 284, 7, 70, "Text",
 CellTags->"jlug:5.2.6.2",
 CellID->25608],
Cell[CellGroupData[{
Cell[74973, 2428, 222, 6, 70, "Input",
 CellTags->"jlug:5.2.6.2",
 CellID->30568],
Cell[75198, 2436, 96, 3, 70, "Output",
 CellTags->"jlug:5.2.6.2",
 CellID->19281]
}, Open  ]],
Cell[75309, 2442, 115, 2, 70, "Text",
 CellTags->"jlug:5.2.6.2",
 CellID->7085],
Cell[CellGroupData[{
Cell[75449, 2448, 189, 6, 70, "Input",
 CellTags->"jlug:5.2.6.2",
 CellID->9152],
Cell[75641, 2456, 973, 25, 70, "Output",
 CellTags->"jlug:5.2.6.2",
 CellID->18373]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[76675, 2488, 135, 2, 70, "Section",
 CellTags->{"jlug:5.2.7.0", "TableOfContents_1.5.2.7"},
 CellID->8526],
Cell[76813, 2492, 237, 7, 70, "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->13357],
Cell[77053, 2501, 5439, 188, 70, "DefinitionBox",
 CellTags->"jlug:5.2.7.0",
 CellID->29337],
Cell[82495, 2691, 108, 2, 70, "Caption",
 CellTags->"jlug:5.2.7.0",
 CellID->23271],
Cell[82606, 2695, 731, 25, 70, "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->23869],
Cell[83340, 2722, 730, 21, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.2.7.0",
 CellID->29361],
Cell[84073, 2745, 583, 21, 70, "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->12896],
Cell[84659, 2768, 710, 24, 70, "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->13022],
Cell[85372, 2794, 450, 14, 70, "DefinitionBox",
 CellTags->"jlug:5.2.7.0",
 CellID->29617],
Cell[85825, 2810, 92, 2, 70, "Caption",
 CellTags->"jlug:5.2.7.0",
 CellID->10112],
Cell[85920, 2814, 1356, 44, 70, "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->12717],
Cell[87279, 2860, 227, 7, 70, "Input",
 CellTags->"jlug:5.2.7.0",
 CellID->18696],
Cell[87509, 2869, 552, 19, 70, "Text",
 CellTags->"jlug:5.2.7.0",
 CellID->11585]
}, Open  ]],
Cell[CellGroupData[{
Cell[88098, 2893, 118, 2, 70, "Section",
 CellTags->{"jlug:5.2.8.0", "TableOfContents_1.5.2.8"},
 CellID->23439],
Cell[88219, 2897, 393, 14, 70, "Text",
 CellTags->"jlug:5.2.8.0",
 CellID->13428],
Cell[88615, 2913, 470, 15, 70, "DefinitionBox",
 CellTags->"jlug:5.2.8.0",
 CellID->5912],
Cell[89088, 2930, 87, 2, 70, "Caption",
 CellTags->"jlug:5.2.8.0",
 CellID->9762],
Cell[89178, 2934, 911, 27, 70, "Text",
 CellTags->"jlug:5.2.8.0",
 CellID->5967],
Cell[90092, 2963, 1090, 30, 70, "Text",
 CellTags->"jlug:5.2.8.0",
 CellID->24408],
Cell[91185, 2995, 1130, 31, 70, "Text",
 CellTags->"jlug:5.2.8.0",
 CellID->4415]
}, Open  ]],
Cell[CellGroupData[{
Cell[92352, 3031, 110, 2, 70, "Section",
 CellTags->{"jlug:5.2.9.0", "TableOfContents_1.5.2.9"},
 CellID->31163],
Cell[92465, 3035, 615, 18, 70, "Text",
 CellTags->"jlug:5.2.9.0",
 CellID->16683],
Cell[93083, 3055, 895, 26, 70, "DefinitionBox",
 CellTags->"jlug:5.2.9.0",
 CellID->13716],
Cell[93981, 3083, 142, 6, 70, "Caption",
 CellTags->"jlug:5.2.9.0",
 CellID->19932],
Cell[CellGroupData[{
Cell[94148, 3093, 118, 3, 70, "Input",
 CellTags->"jlug:5.2.9.0",
 CellID->25452],
Cell[94269, 3098, 120, 3, 70, "Output",
 CellTags->"jlug:5.2.9.0",
 CellID->2741]
}, Open  ]],
Cell[CellGroupData[{
Cell[94426, 3106, 123, 3, 70, "Input",
 CellTags->"jlug:5.2.9.0",
 CellID->4954],
Cell[94552, 3111, 96, 3, 70, "Output",
 CellTags->"jlug:5.2.9.0",
 CellID->6813]
}, Open  ]],
Cell[CellGroupData[{
Cell[94685, 3119, 123, 3, 70, "Input",
 CellTags->"jlug:5.2.9.0",
 CellID->2862],
Cell[94811, 3124, 94, 3, 70, "Output",
 CellTags->"jlug:5.2.9.0",
 CellID->10396]
}, Open  ]],
Cell[94920, 3130, 740, 25, 70, "Text",
 CellTags->"jlug:5.2.9.0",
 CellID->15460]
}, Open  ]],
Cell[CellGroupData[{
Cell[95697, 3160, 210, 7, 70, "Section",
 CellTags->{"TableOfContents_1.5.3.1", "1.2.1", "jlug:5.3.1.0"},
 CellID->19629],
Cell[CellGroupData[{
Cell[95932, 3171, 115, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.1.1", "TableOfContents_1.5.3.1.1"},
 CellID->12623],
Cell[96050, 3175, 408, 8, 70, "Text",
 CellTags->"jlug:5.3.1.1",
 CellID->24084],
Cell[96461, 3185, 918, 19, 70, "Text",
 CellTags->"jlug:5.3.1.1",
 CellID->19954],
Cell[97382, 3206, 691, 20, 70, "Text",
 CellTags->"jlug:5.3.1.1",
 CellID->18756]
}, Open  ]],
Cell[CellGroupData[{
Cell[98110, 3231, 129, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.1.2", "TableOfContents_1.5.3.1.2"},
 CellID->11840],
Cell[98242, 3235, 163, 5, 70, "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->4966],
Cell[98408, 3242, 303, 7, 70, "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->7376],
Cell[98714, 3251, 1171, 22, 70, "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->13931],
Cell[99888, 3275, 749, 18, 70, "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->26308],
Cell[100640, 3295, 300, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.1.2",
 CellID->16944],
Cell[100943, 3307, 296, 9, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.1.2",
 CellID->5040986],
Cell[101242, 3318, 802, 23, 70, "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->32439],
Cell[102047, 3343, 759, 20, 70, "Text",
 CellTags->"jlug:5.3.1.2",
 CellID->24626]
}, Open  ]],
Cell[CellGroupData[{
Cell[102843, 3368, 132, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.1.3", "TableOfContents_1.5.3.1.3"},
 CellID->11323],
Cell[102978, 3372, 690, 18, 70, "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->5537],
Cell[103671, 3392, 615, 20, 70, "DefinitionBox",
 CellTags->"jlug:5.3.1.3",
 CellID->21538],
Cell[104289, 3414, 96, 2, 70, "Caption",
 CellTags->"jlug:5.3.1.3",
 CellID->16118],
Cell[104388, 3418, 934, 20, 70, "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->2082],
Cell[105325, 3440, 506, 15, 70, "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->22929],
Cell[105834, 3457, 1659, 46, 70, "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->16541],
Cell[107496, 3505, 518, 18, 70, "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->4833],
Cell[108017, 3525, 185, 6, 70, "Input",
 CellTags->"jlug:5.3.1.3",
 CellID->31115],
Cell[108205, 3533, 527, 17, 70, "Text",
 CellTags->"jlug:5.3.1.3",
 CellID->4639]
}, Open  ]],
Cell[CellGroupData[{
Cell[108769, 3555, 120, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.1.4", "TableOfContents_1.5.3.1.4"},
 CellID->29658],
Cell[108892, 3559, 954, 26, 70, "Text",
 CellTags->"jlug:5.3.1.4",
 CellID->22704],
Cell[109849, 3587, 517, 18, 70, "DefinitionBox",
 CellTags->"jlug:5.3.1.4",
 CellID->9930],
Cell[110369, 3607, 95, 2, 70, "Caption",
 CellTags->"jlug:5.3.1.4",
 CellID->13977]
}, Open  ]],
Cell[CellGroupData[{
Cell[110501, 3614, 206, 7, 70, "Subsection",
 CellTags->{"jlug:5.3.1.5", "TableOfContents_1.5.3.1.5"},
 CellID->2306],
Cell[110710, 3623, 669, 20, 70, "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->31673],
Cell[CellGroupData[{
Cell[111404, 3647, 301, 10, 70, "Input",
 CellTags->"jlug:5.3.1.5",
 CellID->22386],
Cell[111708, 3659, 1084, 22, 70, "Message",
 CellTags->"jlug:5.3.1.5",
 CellID->5021],
Cell[112795, 3683, 100, 3, 70, "Output",
 CellTags->"jlug:5.3.1.5",
 CellID->28745]
}, Open  ]],
Cell[112910, 3689, 1034, 28, 70, "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->26924],
Cell[113947, 3719, 382, 10, 70, "Input",
 CellTags->"jlug:5.3.1.5",
 CellID->19072],
Cell[114332, 3731, 201, 8, 70, "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->6270],
Cell[114536, 3741, 199, 6, 70, "Input",
 CellTags->"jlug:5.3.1.5",
 CellID->5829],
Cell[114738, 3749, 414, 12, 70, "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->26777],
Cell[115155, 3763, 452, 9, 70, "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->15573],
Cell[115610, 3774, 190, 6, 70, "Program",
 CellTags->"jlug:5.3.1.5",
 CellID->5097],
Cell[115803, 3782, 362, 12, 70, "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->16512],
Cell[116168, 3796, 175, 6, 70, "Input",
 CellTags->"jlug:5.3.1.5",
 CellID->23986],
Cell[116346, 3804, 458, 14, 70, "Text",
 CellTags->"jlug:5.3.1.5",
 CellID->13290]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[116853, 3824, 118, 2, 70, "Section",
 CellTags->{"TableOfContents_1.5.3.2", "1.2.1", "jlug:5.3.2.0"},
 CellID->28396],
Cell[CellGroupData[{
Cell[116996, 3830, 120, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.2.1", "TableOfContents_1.5.3.2.1"},
 CellID->7572],
Cell[117119, 3834, 314, 7, 70, "Text",
 CellTags->"jlug:5.3.2.1",
 CellID->6249],
Cell[117436, 3843, 603, 14, 70, "Text",
 CellTags->"jlug:5.3.2.1",
 CellID->14640],
Cell[118042, 3859, 1329, 30, 70, "Text",
 CellTags->"jlug:5.3.2.1",
 CellID->29174],
Cell[119374, 3891, 1211, 30, 70, "Text",
 CellTags->"jlug:5.3.2.1",
 CellID->18819]
}, Open  ]],
Cell[CellGroupData[{
Cell[120622, 3926, 128, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.2.4", "TableOfContents_1.5.3.2.4"},
 CellID->16074],
Cell[120753, 3930, 761, 16, 70, "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->13509],
Cell[121517, 3948, 1277, 34, 70, "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->30300],
Cell[122797, 3984, 1364, 37, 70, "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->19695],
Cell[124164, 4023, 1060, 33, 70, "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->9573],
Cell[125227, 4058, 293, 9, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.2.4",
 CellID->15589],
Cell[125523, 4069, 423, 12, 70, "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->13161],
Cell[125949, 4083, 785, 25, 70, "Text",
 CellTags->"jlug:5.3.2.4",
 CellID->31172]
}, Open  ]],
Cell[CellGroupData[{
Cell[126771, 4113, 119, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.2.5", "TableOfContents_1.5.3.2.5"},
 CellID->17968],
Cell[126893, 4117, 542, 15, 70, "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->27358],
Cell[127438, 4134, 243, 8, 70, "Input",
 CellTags->"jlug:5.3.2.5",
 CellID->26031],
Cell[127684, 4144, 217, 8, 70, "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->26268],
Cell[CellGroupData[{
Cell[127926, 4156, 154, 5, 70, "Input",
 CellTags->"jlug:5.3.2.5",
 CellID->19426],
Cell[128083, 4163, 108, 3, 70, "Output",
 CellTags->"jlug:5.3.2.5",
 CellID->28510]
}, Open  ]],
Cell[128206, 4169, 224, 6, 70, "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->10422],
Cell[128433, 4177, 255, 9, 70, "Input",
 CellTags->"jlug:5.3.2.5",
 CellID->30774],
Cell[128691, 4188, 279, 11, 70, "Input",
 CellTags->"jlug:5.3.2.5",
 CellID->8779],
Cell[128973, 4201, 551, 15, 70, "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->30910],
Cell[129527, 4218, 238, 8, 70, "Input",
 CellTags->"jlug:5.3.2.5",
 CellID->23552],
Cell[129768, 4228, 612, 20, 70, "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->4182],
Cell[130383, 4250, 283, 11, 70, "Input",
 CellTags->"jlug:5.3.2.5",
 CellID->25391],
Cell[130669, 4263, 684, 19, 70, "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->15495],
Cell[131356, 4284, 418, 12, 70, "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->5764],
Cell[131777, 4298, 310, 11, 70, "Program",
 CellTags->"jlug:5.3.2.5",
 CellID->874],
Cell[132090, 4311, 101, 2, 70, "Text",
 CellTags->"jlug:5.3.2.5",
 CellID->1364],
Cell[132194, 4315, 336, 11, 70, "Input",
 CellTags->"jlug:5.3.2.5",
 CellID->67080215]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[132579, 4332, 138, 2, 70, "Section",
 CellTags->{"TableOfContents_1.5.3.3", "1.2.2", "jlug:5.3.3.0"},
 CellID->12158],
Cell[CellGroupData[{
Cell[132742, 4338, 181, 6, 70, "Subsection",
 CellTags->{"jlug:5.3.3.1", "TableOfContents_1.5.3.3.1"},
 CellID->12022],
Cell[132926, 4346, 1488, 43, 70, "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->1146],
Cell[134417, 4391, 1418, 41, 70, "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->18392],
Cell[135838, 4434, 870, 30, 70, "DefinitionBox",
 CellTags->"jlug:5.3.3.1",
 CellID->13037],
Cell[136711, 4466, 95, 2, 70, "Caption",
 CellTags->"jlug:5.3.3.1",
 CellID->3925],
Cell[136809, 4470, 78, 2, 70, "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->10647],
Cell[CellGroupData[{
Cell[136912, 4476, 229, 7, 70, "Input",
 CellTags->"jlug:5.3.3.1",
 CellID->29458],
Cell[137144, 4485, 270, 8, 70, "Output",
 CellTags->"jlug:5.3.3.1",
 CellID->6602]
}, Open  ]],
Cell[137429, 4496, 236, 8, 70, "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->30807],
Cell[137668, 4506, 289, 9, 70, "Input",
 CellTags->"jlug:5.3.3.1",
 CellID->4098],
Cell[137960, 4517, 261, 8, 70, "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->27830],
Cell[138224, 4527, 168, 6, 70, "Input",
 CellTags->"jlug:5.3.3.1",
 CellID->29292],
Cell[138395, 4535, 815, 26, 70, "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->14600],
Cell[CellGroupData[{
Cell[139235, 4565, 179, 6, 70, "Input",
 CellTags->"jlug:5.3.3.1",
 CellID->7278],
Cell[139417, 4573, 98, 3, 70, "Output",
 CellTags->"jlug:5.3.3.1",
 CellID->20799]
}, Open  ]],
Cell[139530, 4579, 515, 19, 70, "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->18352],
Cell[CellGroupData[{
Cell[140070, 4602, 218, 7, 70, "Input",
 CellTags->"jlug:5.3.3.1",
 CellID->20448],
Cell[140291, 4611, 97, 3, 70, "Output",
 CellTags->"jlug:5.3.3.1",
 CellID->13882]
}, Open  ]],
Cell[140403, 4617, 426, 12, 70, "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->540],
Cell[CellGroupData[{
Cell[140854, 4633, 213, 7, 70, "Input",
 CellTags->"jlug:5.3.3.1",
 CellID->28315],
Cell[141070, 4642, 96, 3, 70, "Output",
 CellTags->"jlug:5.3.3.1",
 CellID->4575]
}, Open  ]],
Cell[141181, 4648, 1443, 41, 70, "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->8762],
Cell[142627, 4691, 1089, 29, 70, "Text",
 CellTags->"jlug:5.3.3.1",
 CellID->9567]
}, Open  ]],
Cell[CellGroupData[{
Cell[143753, 4725, 113, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.3.2", "TableOfContents_1.5.3.3.2"},
 CellID->22336],
Cell[143869, 4729, 1888, 49, 70, "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->18397],
Cell[CellGroupData[{
Cell[145782, 4782, 172, 5, 70, "Input",
 CellTags->"jlug:5.3.3.2",
 CellID->31418],
Cell[145957, 4789, 271, 8, 70, "Output",
 CellTags->"jlug:5.3.3.2",
 CellID->19897]
}, Open  ]],
Cell[146243, 4800, 190, 7, 70, "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->25828],
Cell[146436, 4809, 138, 4, 70, "Input",
 CellTags->"jlug:5.3.3.2",
 CellID->13851],
Cell[146577, 4815, 135, 6, 70, "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->26816],
Cell[146715, 4823, 2797, 94, 70, "DefinitionBox",
 CellTags->"jlug:5.3.3.2",
 CellID->24230],
Cell[149515, 4919, 96, 2, 70, "Caption",
 CellTags->"jlug:5.3.3.2",
 CellID->4449],
Cell[149614, 4923, 691, 19, 70, "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->16925],
Cell[150308, 4944, 768, 23, 70, "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->658],
Cell[151079, 4969, 303, 10, 70, "Input",
 CellTags->"jlug:5.3.3.2",
 CellID->229],
Cell[151385, 4981, 278, 12, 70, "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->24520],
Cell[151666, 4995, 193, 7, 70, "Input",
 CellTags->"jlug:5.3.3.2",
 CellID->10940],
Cell[151862, 5004, 503, 19, 70, "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->29560],
Cell[152368, 5025, 764, 18, 70, "Text",
 CellTags->"jlug:5.3.3.2",
 CellID->15147]
}, Open  ]],
Cell[CellGroupData[{
Cell[153169, 5048, 105, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.3.3", "TableOfContents_1.5.3.3.3"},
 CellID->25162],
Cell[153277, 5052, 655, 16, 70, "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->639716680],
Cell[153935, 5070, 1675, 47, 70, "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->20675],
Cell[155613, 5119, 844, 21, 70, "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->792],
Cell[156460, 5142, 951, 24, 70, "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->22361],
Cell[157414, 5168, 167, 7, 70, "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->31754],
Cell[157584, 5177, 227, 10, 70, "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->16398],
Cell[157814, 5189, 451, 11, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.3.3",
 CellID->23146],
Cell[158268, 5202, 710, 21, 70, "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->8714],
Cell[158981, 5225, 878, 24, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.3.3",
 CellID->26946],
Cell[159862, 5251, 2390, 69, 70, "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->21188],
Cell[162255, 5322, 381, 15, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.3.3",
 CellID->19569],
Cell[162639, 5339, 2122, 62, 70, "Text",
 CellTags->"jlug:5.3.3.3",
 CellID->8638]
}, Open  ]],
Cell[CellGroupData[{
Cell[164798, 5406, 135, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.3.5", "TableOfContents_1.5.3.3.5"},
 CellID->24515],
Cell[164936, 5410, 1689, 49, 70, "Text",
 CellTags->"jlug:5.3.3.5",
 CellID->11521],
Cell[166628, 5461, 1428, 44, 70, "Text",
 CellTags->"jlug:5.3.3.5",
 CellID->475]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[168105, 5511, 110, 2, 70, "Section",
 CellTags->{"TableOfContents_1.5.3.4", "1.2.3", "jlug:5.3.4.0"},
 CellID->10195],
Cell[CellGroupData[{
Cell[168240, 5517, 122, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.4.1", "TableOfContents_1.5.3.4.1"},
 CellID->32525],
Cell[168365, 5521, 398, 11, 70, "Text",
 CellTags->"jlug:5.3.4.1",
 CellID->1264],
Cell[CellGroupData[{
Cell[168788, 5536, 278, 8, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.4.1",
 CellID->8260],
Cell[169069, 5546, 318, 9, 70, "Message",
 CellTags->"jlug:5.3.4.1",
 CellID->6202],
Cell[169390, 5557, 117, 4, 70, "Output",
 CellTags->"jlug:5.3.4.1",
 CellID->8116]
}, Open  ]],
Cell[169522, 5564, 1002, 26, 70, "Text",
 CellTags->"jlug:5.3.4.1",
 CellID->5030],
Cell[170527, 5592, 363, 9, 70, "Text",
 CellTags->"jlug:5.3.4.1",
 CellID->20326]
}, Open  ]],
Cell[CellGroupData[{
Cell[170927, 5606, 118, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.4.2", "TableOfContents_1.5.3.4.2"},
 CellID->29011],
Cell[171048, 5610, 600, 19, 70, "Text",
 CellTags->"jlug:5.3.4.2",
 CellID->30771],
Cell[171651, 5631, 326, 10, 70, "DefinitionBox",
 CellTags->"jlug:5.3.4.2",
 CellID->6411],
Cell[171980, 5643, 157, 6, 70, "Caption",
 CellTags->"jlug:5.3.4.2",
 CellID->25547],
Cell[172140, 5651, 1466, 43, 70, "Text",
 CellTags->"jlug:5.3.4.2",
 CellID->21153],
Cell[173609, 5696, 1545, 35, 70, "Text",
 CellTags->"jlug:5.3.4.2",
 CellID->21520],
Cell[175157, 5733, 426, 13, 70, "Input",
 CellTags->"jlug:5.3.4.2",
 CellID->29790],
Cell[175586, 5748, 363, 12, 70, "Text",
 CellTags->"jlug:5.3.4.2",
 CellID->14924]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[175998, 5766, 351, 11, 70, "Section",
 CellTags->{"TableOfContents_1.5.3.5", "1.2.5", "jlug:5.3.5.0"},
 CellID->31497],
Cell[CellGroupData[{
Cell[176374, 5781, 116, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.5.1", "TableOfContents_1.5.3.5.1"},
 CellID->2785],
Cell[176493, 5785, 1793, 58, 70, "Text",
 CellTags->"jlug:5.3.5.1",
 CellID->18529],
Cell[178289, 5845, 1145, 28, 70, "Text",
 CellTags->"jlug:5.3.5.1",
 CellID->31540],
Cell[179437, 5875, 530, 14, 70, "Text",
 CellTags->"jlug:5.3.5.1",
 CellID->18805],
Cell[179970, 5891, 1567, 54, 70, "DefinitionBox",
 CellTags->"jlug:5.3.5.1",
 CellID->28791],
Cell[181540, 5947, 304, 11, 70, "Caption",
 CellTags->"jlug:5.3.5.1",
 CellID->13392]
}, Open  ]],
Cell[CellGroupData[{
Cell[181881, 5963, 114, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.5.2", "TableOfContents_1.5.3.5.2"},
 CellID->13210],
Cell[181998, 5967, 567, 15, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->13549],
Cell[CellGroupData[{
Cell[182590, 5986, 394, 12, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellID->21578],
Cell[182987, 6000, 183, 6, 70, "Output",
 CellTags->"jlug:5.3.5.2",
 CellID->26979]
}, Open  ]],
Cell[183185, 6009, 476, 16, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->30971],
Cell[CellGroupData[{
Cell[183686, 6029, 280, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellID->9277],
Cell[183969, 6041, 193, 7, 70, "Output",
 CellTags->"jlug:5.3.5.2",
 CellID->73]
}, Open  ]],
Cell[184177, 6051, 1220, 32, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->20193],
Cell[185400, 6085, 402, 11, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->1620],
Cell[CellGroupData[{
Cell[185827, 6100, 290, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellID->21497],
Cell[186120, 6112, 257, 8, 70, "Output",
 CellTags->"jlug:5.3.5.2",
 CellID->13826]
}, Open  ]],
Cell[186392, 6123, 590, 16, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->31276],
Cell[CellGroupData[{
Cell[187007, 6143, 330, 11, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellID->19790],
Cell[187340, 6156, 195, 7, 70, "Output",
 CellTags->"jlug:5.3.5.2",
 CellID->6582]
}, Open  ]],
Cell[187550, 6166, 589, 17, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->13578],
Cell[188142, 6185, 1221, 30, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->11159],
Cell[189366, 6217, 304, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellID->20418],
Cell[189673, 6229, 370, 13, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->26489],
Cell[190046, 6244, 351, 11, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellID->159],
Cell[190400, 6257, 229, 6, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->3449],
Cell[190632, 6265, 1408, 43, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->12924],
Cell[CellGroupData[{
Cell[192065, 6312, 126, 4, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.5.2",
 CellID->9072],
Cell[192194, 6318, 272, 9, 70, "Output",
 CellTags->"jlug:5.3.5.2",
 CellID->10380]
}, Open  ]],
Cell[192481, 6330, 474, 13, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->27008],
Cell[192958, 6345, 1491, 36, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->27967],
Cell[194452, 6383, 778, 22, 70, "Text",
 CellTags->"jlug:5.3.5.2",
 CellID->10208]
}, Open  ]],
Cell[CellGroupData[{
Cell[195267, 6410, 117, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.5.3", "TableOfContents_1.5.3.5.3"},
 CellID->6477],
Cell[195387, 6414, 727, 19, 70, "Text",
 CellTags->"jlug:5.3.5.3",
 CellID->18503],
Cell[196117, 6435, 1012, 32, 70, "Text",
 CellTags->"jlug:5.3.5.3",
 CellID->15370],
Cell[CellGroupData[{
Cell[197154, 6471, 153, 4, 70, "Input",
 CellTags->"jlug:5.3.5.3",
 CellID->32607],
Cell[197310, 6477, 206, 5, 70, "Output",
 CellTags->"jlug:5.3.5.3",
 CellID->14196]
}, Open  ]],
Cell[197531, 6485, 640, 20, 70, "Text",
 CellTags->"jlug:5.3.5.3",
 CellID->12074],
Cell[198174, 6507, 692, 22, 70, "Text",
 CellTags->"jlug:5.3.5.3",
 CellID->13722],
Cell[CellGroupData[{
Cell[198891, 6533, 191, 6, 70, "Input",
 CellTags->"jlug:5.3.5.3",
 CellID->12611],
Cell[199085, 6541, 277, 9, 70, "Output",
 CellTags->"jlug:5.3.5.3",
 CellID->19019]
}, Open  ]],
Cell[CellGroupData[{
Cell[199399, 6555, 142, 4, 70, "Input",
 CellTags->"jlug:5.3.5.3",
 CellID->28761],
Cell[199544, 6561, 110, 3, 70, "Output",
 CellTags->"jlug:5.3.5.3",
 CellID->11056]
}, Open  ]],
Cell[199669, 6567, 522, 17, 70, "Text",
 CellTags->"jlug:5.3.5.3",
 CellID->12890]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[200240, 6590, 131, 2, 70, "Section",
 CellTags->{"TableOfContents_1.5.3.6", "1.2.6", "jlug:5.3.6.0"},
 CellID->29288],
Cell[CellGroupData[{
Cell[200396, 6596, 104, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.6.1", "TableOfContents_1.5.3.6.1"},
 CellID->28082],
Cell[200503, 6600, 1406, 44, 70, "Text",
 CellTags->"jlug:5.3.6.1",
 CellID->1954]
}, Open  ]],
Cell[CellGroupData[{
Cell[201946, 6649, 110, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.6.2", "TableOfContents_1.5.3.6.2"},
 CellID->16085],
Cell[202059, 6653, 541, 17, 70, "DefinitionBox",
 CellTags->"jlug:5.3.6.2",
 CellID->20710],
Cell[202603, 6672, 77, 2, 70, "Caption",
 CellTags->"jlug:5.3.6.2",
 CellID->24484],
Cell[202683, 6676, 1331, 38, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->24774],
Cell[204017, 6716, 82, 2, 70, "Program",
 CellTags->"jlug:5.3.6.2",
 CellID->8380],
Cell[204102, 6720, 382, 13, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->29815],
Cell[CellGroupData[{
Cell[204509, 6737, 173, 5, 70, "Input",
 CellTags->"jlug:5.3.6.2",
 CellID->25951],
Cell[204685, 6744, 345, 9, 70, "Message",
 CellTags->"jlug:5.3.6.2",
 CellID->6541],
Cell[205033, 6755, 118, 4, 70, "Output",
 CellTags->"jlug:5.3.6.2",
 CellID->18115]
}, Open  ]],
Cell[205166, 6762, 442, 13, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->1679],
Cell[CellGroupData[{
Cell[205633, 6779, 229, 7, 70, "Input",
 CellTags->"jlug:5.3.6.2",
 CellID->17110],
Cell[205865, 6788, 277, 9, 70, "Output",
 CellTags->"jlug:5.3.6.2",
 CellID->25898]
}, Open  ]],
Cell[206157, 6800, 260, 9, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->23073],
Cell[206420, 6811, 154, 5, 70, "Input",
 CellTags->"jlug:5.3.6.2",
 CellID->788],
Cell[206577, 6818, 474, 17, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->23977],
Cell[207054, 6837, 207, 7, 70, "Input",
 CellTags->"jlug:5.3.6.2",
 CellID->18132],
Cell[207264, 6846, 1694, 51, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->29956],
Cell[CellGroupData[{
Cell[208983, 6901, 134, 4, 70, "Input",
 CellTags->"jlug:5.3.6.2",
 CellID->28689],
Cell[209120, 6907, 270, 9, 70, "Output",
 CellTags->"jlug:5.3.6.2",
 CellID->26113]
}, Open  ]],
Cell[209405, 6919, 1006, 31, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->10008],
Cell[210414, 6952, 268, 10, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->12941],
Cell[CellGroupData[{
Cell[210707, 6966, 136, 4, 70, "Input",
 CellTags->"jlug:5.3.6.2",
 CellID->15790],
Cell[210846, 6972, 270, 9, 70, "Output",
 CellTags->"jlug:5.3.6.2",
 CellID->1723]
}, Open  ]],
Cell[211131, 6984, 1051, 28, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->21363],
Cell[CellGroupData[{
Cell[212207, 7016, 240, 8, 70, "Input",
 CellTags->"jlug:5.3.6.2",
 CellID->28],
Cell[212450, 7026, 259, 8, 70, "Output",
 CellTags->"jlug:5.3.6.2",
 CellID->25184]
}, Open  ]],
Cell[212724, 7037, 599, 17, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->24778],
Cell[CellGroupData[{
Cell[213348, 7058, 339, 11, 70, "Input",
 CellTags->"jlug:5.3.6.2",
 CellID->7200],
Cell[213690, 7071, 258, 8, 70, "Output",
 CellTags->"jlug:5.3.6.2",
 CellID->5071]
}, Open  ]],
Cell[213963, 7082, 787, 21, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->1885],
Cell[214753, 7105, 1751, 50, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->21974],
Cell[216507, 7157, 205, 6, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.6.2",
 CellID->1071],
Cell[216715, 7165, 1118, 32, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->11333],
Cell[217836, 7199, 838, 23, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->22867],
Cell[218677, 7224, 99, 2, 70, "Program",
 CellTags->"jlug:5.3.6.2",
 CellID->26153],
Cell[218779, 7228, 266, 9, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->14295],
Cell[CellGroupData[{
Cell[219070, 7241, 357, 11, 70, "Input",
 CellTags->"jlug:5.3.6.2",
 CellID->32168],
Cell[219430, 7254, 419, 9, 70, "Message",
 CellTags->"jlug:5.3.6.2",
 CellID->20825],
Cell[219852, 7265, 100, 3, 70, "Output",
 CellTags->"jlug:5.3.6.2",
 CellID->9676]
}, Open  ]],
Cell[219967, 7271, 308, 11, 70, "Text",
 CellTags->"jlug:5.3.6.2",
 CellID->15629],
Cell[220278, 7284, 331, 10, 70, "Input",
 CellTags->"jlug:5.3.6.2",
 CellID->28650]
}, Open  ]],
Cell[CellGroupData[{
Cell[220646, 7299, 107, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.6.3", "TableOfContents_1.5.3.6.3"},
 CellID->2598],
Cell[220756, 7303, 1266, 38, 70, "Text",
 CellTags->"jlug:5.3.6.3",
 CellID->3309],
Cell[222025, 7343, 548, 19, 70, "DefinitionBox",
 CellTags->"jlug:5.3.6.3",
 CellID->4693],
Cell[222576, 7364, 74, 2, 70, "Caption",
 CellTags->"jlug:5.3.6.3",
 CellID->4686],
Cell[222653, 7368, 1594, 49, 70, "Text",
 CellTags->"jlug:5.3.6.3",
 CellID->30080],
Cell[224250, 7419, 883, 27, 70, "Text",
 CellTags->"jlug:5.3.6.3",
 CellID->10116],
Cell[CellGroupData[{
Cell[225158, 7450, 264, 8, 70, "Input",
 CellTags->"jlug:5.3.6.3",
 CellID->12249],
Cell[225425, 7460, 284, 9, 70, "Output",
 CellTags->"jlug:5.3.6.3",
 CellID->26667]
}, Open  ]],
Cell[CellGroupData[{
Cell[225746, 7474, 143, 5, 70, "Input",
 CellTags->"jlug:5.3.6.3",
 CellID->1528],
Cell[225892, 7481, 95, 3, 70, "Output",
 CellTags->"jlug:5.3.6.3",
 CellID->26679]
}, Open  ]],
Cell[CellGroupData[{
Cell[226024, 7489, 146, 5, 70, "Input",
 CellTags->"jlug:5.3.6.3",
 CellID->7864],
Cell[226173, 7496, 118, 4, 70, "Output",
 CellTags->"jlug:5.3.6.3",
 CellID->29421]
}, Open  ]],
Cell[CellGroupData[{
Cell[226328, 7505, 222, 8, 70, "Input",
 CellTags->"jlug:5.3.6.3",
 CellID->8405],
Cell[226553, 7515, 207, 7, 70, "Output",
 CellTags->"jlug:5.3.6.3",
 CellID->8826]
}, Open  ]],
Cell[226775, 7525, 366, 15, 70, "Text",
 CellTags->"jlug:5.3.6.3",
 CellID->6816],
Cell[CellGroupData[{
Cell[227166, 7544, 141, 4, 70, "Input",
 CellTags->"jlug:5.3.6.3",
 CellID->7516],
Cell[227310, 7550, 174, 6, 70, "Output",
 CellTags->"jlug:5.3.6.3",
 CellID->27726]
}, Open  ]],
Cell[227499, 7559, 434, 13, 70, "Text",
 CellTags->"jlug:5.3.6.3",
 CellID->28666]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[227982, 7578, 140, 2, 70, "Section",
 CellTags->{"jlug:5.3.7.0", "TableOfContents_1.5.3.7"},
 CellID->4596],
Cell[CellGroupData[{
Cell[228147, 7584, 104, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.7.1", "TableOfContents_1.5.3.7.1"},
 CellID->24021],
Cell[228254, 7588, 1128, 24, 70, "Text",
 CellTags->"jlug:5.3.7.1",
 CellID->27348],
Cell[229385, 7614, 588, 19, 70, "Text",
 CellTags->"jlug:5.3.7.1",
 CellID->23199],
Cell[229976, 7635, 789, 22, 70, "Text",
 CellTags->"jlug:5.3.7.1",
 CellID->19668]
}, Open  ]],
Cell[CellGroupData[{
Cell[230802, 7662, 142, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.7.2", "TableOfContents_1.5.3.7.2"},
 CellID->314330245],
Cell[230947, 7666, 387, 12, 70, "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->8281],
Cell[231337, 7680, 1768, 43, 70, "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->4734],
Cell[233108, 7725, 780, 19, 70, "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->53],
Cell[233891, 7746, 694, 15, 70, "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->1999],
Cell[234588, 7763, 673, 13, 70, "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->26418],
Cell[235264, 7778, 2239, 60, 70, "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->27938],
Cell[237506, 7840, 829, 18, 70, "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->6900],
Cell[238338, 7860, 1517, 36, 70, "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->3788],
Cell[239858, 7898, 1852, 52, 70, "Text",
 CellTags->"jlug:5.3.7.2",
 CellID->18127]
}, Open  ]],
Cell[CellGroupData[{
Cell[241747, 7955, 125, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.7.3", "TableOfContents_1.5.3.7.3"},
 CellID->467],
Cell[241875, 7959, 738, 21, 70, "Text",
 CellTags->"jlug:5.3.7.3",
 CellID->3728],
Cell[242616, 7982, 802, 16, 70, "Text",
 CellTags->"jlug:5.3.7.3",
 CellID->14893],
Cell[243421, 8000, 1073, 23, 70, "Text",
 CellTags->"jlug:5.3.7.3",
 CellID->24648],
Cell[244497, 8025, 921, 17, 70, "Text",
 CellTags->"jlug:5.3.7.3",
 CellID->22483],
Cell[245421, 8044, 341, 9, 70, "Text",
 CellTags->"jlug:5.3.7.3",
 CellID->17807]
}, Open  ]],
Cell[CellGroupData[{
Cell[245799, 8058, 265, 8, 70, "Subsection",
 CellTags->{"jlug:5.3.7.4", "TableOfContents_1.5.3.7.4"},
 CellID->2421],
Cell[246067, 8068, 898, 14, 70, "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->14310],
Cell[246968, 8084, 1001, 22, 70, "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->6617],
Cell[247972, 8108, 425, 8, 70, "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->22813],
Cell[248400, 8118, 940, 23, 70, "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->9514],
Cell[249343, 8143, 732, 15, 70, "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->14309],
Cell[250078, 8160, 946, 26, 70, "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->7616],
Cell[251027, 8188, 9265, 285, 70, "DefinitionBox",
 CellTags->"jlug:5.3.7.4",
 CellID->18935],
Cell[260295, 8475, 158, 7, 70, "Caption",
 CellTags->"jlug:5.3.7.4",
 CellID->17451],
Cell[260456, 8484, 1800, 49, 70, "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->20600],
Cell[262259, 8535, 1666, 46, 70, "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->5249],
Cell[263928, 8583, 697, 22, 70, "DefinitionBox",
 CellTags->"jlug:5.3.7.4",
 CellID->16519],
Cell[264628, 8607, 212, 7, 70, "Caption",
 CellTags->"jlug:5.3.7.4",
 CellID->31556],
Cell[264843, 8616, 515, 14, 70, "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->22798],
Cell[265361, 8632, 3010, 86, 70, "Text",
 CellTags->"jlug:5.3.7.4",
 CellID->30303]
}, Open  ]],
Cell[CellGroupData[{
Cell[268408, 8723, 134, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.7.5", "TableOfContents_1.5.3.7.5"},
 CellID->6224],
Cell[268545, 8727, 889, 20, 70, "Text",
 CellTags->"jlug:5.3.7.5",
 CellID->11008],
Cell[269437, 8749, 1564, 52, 70, "Text",
 CellTags->"jlug:5.3.7.5",
 CellID->5844],
Cell[271004, 8803, 441, 14, 70, "DefinitionBox",
 CellTags->"jlug:5.3.7.5",
 CellID->32609],
Cell[271448, 8819, 103, 2, 70, "Caption",
 CellTags->"jlug:5.3.7.5",
 CellID->14989]
}, Open  ]],
Cell[CellGroupData[{
Cell[271588, 8826, 109, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.7.6", "TableOfContents_1.5.3.7.6"},
 CellID->32702],
Cell[271700, 8830, 907, 24, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->3195],
Cell[272610, 8856, 1036, 32, 70, "Input",
 CellTags->"jlug:5.3.7.6",
 CellID->20485],
Cell[273649, 8890, 239, 6, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->3093],
Cell[273891, 8898, 287, 9, 70, "Input",
 CellTags->"jlug:5.3.7.6",
 CellID->14343],
Cell[274181, 8909, 406, 13, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->30523],
Cell[274590, 8924, 231, 8, 70, "Input",
 CellTags->"jlug:5.3.7.6",
 CellID->1587],
Cell[274824, 8934, 167, 6, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->29314],
Cell[274994, 8942, 199, 7, 70, "Input",
 CellTags->"jlug:5.3.7.6",
 CellID->9503],
Cell[275196, 8951, 977, 30, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->7448],
Cell[276176, 8983, 579, 15, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->25200],
Cell[276758, 9000, 252, 8, 70, "Input",
 CellTags->"jlug:5.3.7.6",
 CellID->13458],
Cell[277013, 9010, 238, 7, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->6618],
Cell[277254, 9019, 806, 23, 70, "Input",
 CellTags->"jlug:5.3.7.6",
 CellID->20580],
Cell[278063, 9044, 908, 20, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->19796],
Cell[278974, 9066, 701, 22, 70, "DefinitionBox",
 CellTags->"jlug:5.3.7.6",
 CellID->14798],
Cell[279678, 9090, 99, 2, 70, "Caption",
 CellTags->"jlug:5.3.7.6",
 CellID->15281],
Cell[279780, 9094, 2002, 63, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->19589],
Cell[281785, 9159, 966, 28, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->20798],
Cell[282754, 9189, 437, 13, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->28009],
Cell[283194, 9204, 348, 12, 70, "Input",
 CellTags->"jlug:5.3.7.6",
 CellID->27157],
Cell[283545, 9218, 638, 21, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->20472],
Cell[284186, 9241, 251, 8, 70, "Input",
 CellTags->"jlug:5.3.7.6",
 CellID->23622],
Cell[284440, 9251, 2136, 61, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->18538],
Cell[286579, 9314, 326, 13, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.7.6",
 CellID->12292],
Cell[286908, 9329, 1060, 35, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->6038],
Cell[287971, 9366, 147, 5, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->24179],
Cell[288121, 9373, 122, 4, 70, "Input",
 CellTags->"jlug:5.3.7.6",
 CellID->18190],
Cell[288246, 9379, 1082, 36, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->29657],
Cell[289331, 9417, 328, 11, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->7958],
Cell[289662, 9430, 1368, 49, 70, "Input",
 CellTags->"jlug:5.3.7.6",
 CellID->6191],
Cell[291033, 9481, 2380, 68, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->19815],
Cell[293416, 9551, 1574, 49, 70, "Text",
 CellTags->"jlug:5.3.7.6",
 CellID->22888]
}, Open  ]],
Cell[CellGroupData[{
Cell[295027, 9605, 120, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.7.7", "TableOfContents_1.5.3.7.7"},
 CellID->19156],
Cell[295150, 9609, 1804, 50, 70, "Text",
 CellTags->"jlug:5.3.7.7",
 CellID->11511]
}, Open  ]],
Cell[CellGroupData[{
Cell[296991, 9664, 142, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.7.8", "TableOfContents_1.5.3.7.8"},
 CellID->16202],
Cell[297136, 9668, 1054, 27, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->2634],
Cell[298193, 9697, 1493, 33, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->24272],
Cell[299689, 9732, 619, 14, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->20055],
Cell[300311, 9748, 981, 34, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->20328],
Cell[301295, 9784, 1880, 61, 70, "DefinitionBox",
 CellTags->"jlug:5.3.7.8",
 CellID->22646],
Cell[303178, 9847, 81, 2, 70, "Caption",
 CellTags->"jlug:5.3.7.8",
 CellID->26362],
Cell[303262, 9851, 693, 21, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->4886],
Cell[303958, 9874, 143, 5, 70, "Input",
 CellTags->"jlug:5.3.7.8",
 CellID->18875],
Cell[CellGroupData[{
Cell[304126, 9883, 125, 4, 70, "Input",
 CellTags->"jlug:5.3.7.8",
 CellID->28433],
Cell[304254, 9889, 94, 3, 70, "Output",
 CellTags->"jlug:5.3.7.8",
 CellID->29869]
}, Open  ]],
Cell[304363, 9895, 354, 10, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->20142],
Cell[304720, 9907, 941, 23, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->23844],
Cell[305664, 9932, 521, 12, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->1416],
Cell[306188, 9946, 137, 4, 70, "Input",
 CellTags->"jlug:5.3.7.8",
 CellID->21881],
Cell[306328, 9952, 1122, 22, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->31998],
Cell[307453, 9976, 559, 14, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->10322],
Cell[308015, 9992, 330, 10, 70, "Text",
 CellTags->"jlug:5.3.7.8",
 CellID->18651]
}, Open  ]],
Cell[CellGroupData[{
Cell[308382, 10007, 117, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.7.9", "TableOfContents_1.5.3.7.9"},
 CellID->10021],
Cell[308502, 10011, 527, 12, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->5699],
Cell[309032, 10025, 1573, 36, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->3557],
Cell[310608, 10063, 1340, 41, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->28476],
Cell[311951, 10106, 1273, 40, 70, "DefinitionBox",
 CellTags->"jlug:5.3.7.9",
 CellID->27892],
Cell[313227, 10148, 93, 2, 70, "Caption",
 CellTags->"jlug:5.3.7.9",
 CellID->24389],
Cell[313323, 10152, 219, 6, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->5075],
Cell[313545, 10160, 347, 8, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->10712],
Cell[313895, 10170, 2311, 66, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->2600],
Cell[316209, 10238, 1155, 29, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->2510],
Cell[317367, 10269, 481, 12, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->21003],
Cell[317851, 10283, 343, 10, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->26869],
Cell[318197, 10295, 1332, 30, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->17861],
Cell[319532, 10327, 763, 16, 70, "Text",
 CellTags->"jlug:5.3.7.9",
 CellID->14688]
}, Open  ]],
Cell[CellGroupData[{
Cell[320332, 10348, 137, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.7.10", "TableOfContents_1.5.3.7.10"},
 CellID->13401],
Cell[320472, 10352, 747, 19, 70, "Text",
 CellTags->"jlug:5.3.7.10",
 CellID->9789],
Cell[321222, 10373, 885, 18, 70, "Text",
 CellTags->"jlug:5.3.7.10",
 CellID->15255],
Cell[322110, 10393, 1584, 33, 70, "Text",
 CellTags->"jlug:5.3.7.10",
 CellID->16423],
Cell[323697, 10428, 989, 25, 70, "Text",
 CellTags->"jlug:5.3.7.10",
 CellID->5002]
}, Open  ]],
Cell[CellGroupData[{
Cell[324723, 10458, 198, 5, 70, "Subsection",
 CellTags->{"jlug:5.3.7.11", "TableOfContents_1.5.3.7.11"},
 CellID->10585],
Cell[324924, 10465, 1287, 28, 70, "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->24182],
Cell[326214, 10495, 668, 14, 70, "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->10285],
Cell[326885, 10511, 595, 14, 70, "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->27088],
Cell[327483, 10527, 351, 10, 70, "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->31426],
Cell[327837, 10539, 412, 16, 70, "Program",
 CellTags->"jlug:5.3.7.11",
 CellID->28617],
Cell[328252, 10557, 566, 18, 70, "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->23757],
Cell[328821, 10577, 201, 8, 70, "Program",
 CellTags->"jlug:5.3.7.11",
 CellID->9832],
Cell[329025, 10587, 1322, 42, 70, "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->30932],
Cell[330350, 10631, 312, 10, 70, "Text",
 CellTags->"jlug:5.3.7.11",
 CellID->4169]
}, Open  ]],
Cell[CellGroupData[{
Cell[330699, 10646, 116, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.7.12", "TableOfContents_1.5.3.7.12"},
 CellID->2154],
Cell[330818, 10650, 1724, 41, 70, "Text",
 CellTags->"jlug:5.3.7.12",
 CellID->25721]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[332591, 10697, 206, 7, 70, "Section",
 CellTags->{"jlug:5.3.8.0", "TableOfContents_1.5.3.8"},
 CellID->23775],
Cell[CellGroupData[{
Cell[332822, 10708, 141, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.8.1", "TableOfContents_1.5.3.8.1"},
 CellID->20608],
Cell[332966, 10712, 1502, 48, 70, "Text",
 CellTags->"jlug:5.3.8.1",
 CellID->109591723],
Cell[334471, 10762, 1523, 43, 70, "Text",
 CellTags->"jlug:5.3.8.1",
 CellID->5997],
Cell[335997, 10807, 689, 20, 70, "Text",
 CellTags->"jlug:5.3.8.1",
 CellID->17549]
}, Open  ]],
Cell[CellGroupData[{
Cell[336723, 10832, 206, 7, 70, "Subsection",
 CellTags->{"jlug:5.3.8.2", "TableOfContents_1.5.3.8.2"},
 CellID->29556],
Cell[336932, 10841, 700, 19, 70, "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->25561],
Cell[337635, 10862, 391, 12, 70, "Input",
 CellTags->"jlug:5.3.8.2",
 CellID->31627],
Cell[338029, 10876, 883, 21, 70, "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->6467],
Cell[338915, 10899, 148, 6, 70, "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->29541],
Cell[339066, 10907, 166, 5, 70, "Input",
 CellTags->"jlug:5.3.8.2",
 CellID->26129],
Cell[339235, 10914, 354, 10, 70, "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->31240],
Cell[339592, 10926, 231, 7, 70, "Input",
 CellTags->"jlug:5.3.8.2",
 CellID->27813],
Cell[339826, 10935, 189, 5, 70, "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->43861508],
Cell[340018, 10942, 177, 6, 70, "Input",
 CellTags->"jlug:5.3.8.2",
 CellID->20601],
Cell[340198, 10950, 628, 18, 70, "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->6077],
Cell[340829, 10970, 200, 6, 70, "Input",
 CellTags->"jlug:5.3.8.2",
 CellID->20215],
Cell[341032, 10978, 753, 23, 70, "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->8683],
Cell[341788, 11003, 155, 6, 70, "Input",
 CellTags->"jlug:5.3.8.2",
 CellID->8213],
Cell[341946, 11011, 543, 15, 70, "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->23992],
Cell[342492, 11028, 303, 9, 70, "Input",
 CellTags->"jlug:5.3.8.2",
 CellID->25824],
Cell[342798, 11039, 513, 20, 70, "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->5601],
Cell[343314, 11061, 1509, 38, 70, "Text",
 CellTags->"jlug:5.3.8.2",
 CellID->23392]
}, Open  ]],
Cell[CellGroupData[{
Cell[344860, 11104, 160, 4, 70, "Subsection",
 CellTags->{"jlug:5.3.8.3", "TableOfContents_1.5.3.8.3"},
 CellID->15759],
Cell[345023, 11110, 1062, 37, 70, "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->2670],
Cell[346088, 11149, 1325, 35, 70, "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->26428],
Cell[347416, 11186, 312, 9, 70, "Input",
 CellTags->"jlug:5.3.8.3",
 CellID->28027],
Cell[347731, 11197, 625, 18, 70, "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->4084],
Cell[348359, 11217, 1411, 38, 70, "Input",
 CellTags->"jlug:5.3.8.3",
 CellID->10075],
Cell[349773, 11257, 271, 7, 70, "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->18786],
Cell[350047, 11266, 101, 3, 70, "Input",
 CellTags->"jlug:5.3.8.3",
 CellID->15498],
Cell[350151, 11271, 497, 14, 70, "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->24970],
Cell[350651, 11287, 1353, 27, 70, "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->6287],
Cell[352007, 11316, 1115, 33, 70, "Text",
 CellTags->"jlug:5.3.8.3",
 CellID->23847]
}, Open  ]],
Cell[CellGroupData[{
Cell[353159, 11354, 103, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.8.4", "TableOfContents_1.5.3.8.4"},
 CellID->32604],
Cell[353265, 11358, 942, 27, 70, "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->503],
Cell[354210, 11387, 237, 7, 70, "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->21221],
Cell[354450, 11396, 342, 11, 70, "Input",
 CellTags->"jlug:5.3.8.4",
 CellID->22663],
Cell[354795, 11409, 284, 6, 70, "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->5706],
Cell[355082, 11417, 127, 3, 70, "Input",
 CellTags->"jlug:5.3.8.4",
 CellID->2363],
Cell[355212, 11422, 462, 9, 70, "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->9010],
Cell[355677, 11433, 201, 6, 70, "Input",
 CellTags->"jlug:5.3.8.4",
 CellID->22171],
Cell[355881, 11441, 229, 6, 70, "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->27489],
Cell[356113, 11449, 313, 8, 70, "Input",
 CellTags->"jlug:5.3.8.4",
 CellID->18240],
Cell[356429, 11459, 112, 2, 70, "Text",
 CellTags->"jlug:5.3.8.4",
 CellID->12164],
Cell[356544, 11463, 167, 6, 70, "Input",
 CellTags->"jlug:5.3.8.4",
 CellID->25542]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[356760, 11475, 114, 2, 70, "Section",
 CellTags->{"jlug:5.3.9.0", "TableOfContents_1.5.3.9"},
 CellID->22549],
Cell[356877, 11479, 1365, 39, 70, "Text",
 CellTags->"jlug:5.3.9.0",
 CellID->9496],
Cell[358245, 11520, 1207, 37, 70, "DefinitionBox",
 CellTags->"jlug:5.3.9.0",
 CellID->18584],
Cell[359455, 11559, 88, 2, 70, "Caption",
 CellTags->"jlug:5.3.9.0",
 CellID->9515],
Cell[CellGroupData[{
Cell[359568, 11565, 100, 3, 70, "Input",
 CellTags->"jlug:5.3.9.0",
 CellID->17964],
Cell[359671, 11570, 300, 10, 70, "Output",
 CellTags->"jlug:5.3.9.0",
 CellID->23342]
}, Open  ]],
Cell[359986, 11583, 901, 25, 70, "Text",
 CellTags->"jlug:5.3.9.0",
 CellID->8075],
Cell[360890, 11610, 491, 16, 70, "Text",
 CellTags->"jlug:5.3.9.0",
 CellID->17913],
Cell[361384, 11628, 167, 6, 70, "Input",
 CellTags->"jlug:5.3.9.0",
 CellID->16142],
Cell[361554, 11636, 1391, 32, 70, "Text",
 CellTags->"jlug:5.3.9.0",
 CellID->31196]
}, Open  ]],
Cell[CellGroupData[{
Cell[362982, 11673, 108, 2, 70, "Section",
 CellTags->{"jlug:5.3.10.0", "TableOfContents_1.5.3.10"},
 CellID->15748],
Cell[363093, 11677, 415, 8, 70, "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->19923],
Cell[363511, 11687, 505, 11, 70, "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->3359],
Cell[364019, 11700, 924, 17, 70, "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->32257],
Cell[364946, 11719, 481, 10, 70, "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->24766],
Cell[365430, 11731, 532, 15, 70, "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->4944],
Cell[365965, 11748, 162, 5, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.10.0",
 CellID->14955],
Cell[366130, 11755, 76, 2, 70, "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->23318],
Cell[366209, 11759, 193, 6, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.10.0",
 CellID->32726],
Cell[366405, 11767, 647, 16, 70, "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->25411],
Cell[367055, 11785, 225, 8, 70, "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->21025],
Cell[367283, 11795, 512, 14, 70, "Input",
 CellTags->"jlug:5.3.10.0",
 CellID->20355],
Cell[367798, 11811, 1062, 31, 70, "Text",
 CellTags->"jlug:5.3.10.0",
 CellID->31001]
}, Open  ]],
Cell[CellGroupData[{
Cell[368897, 11847, 118, 2, 70, "Section",
 CellTags->{"TableOfContents_1.5.3.12", "1.2.12", "jlug:5.3.12.0"},
 CellID->13169],
Cell[369018, 11851, 716, 20, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->23831],
Cell[369737, 11873, 373, 12, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->20040],
Cell[370113, 11887, 836, 24, 70, "DefinitionBox",
 CellTags->"jlug:5.3.12.0",
 CellID->26488],
Cell[370952, 11913, 79, 2, 70, "Caption",
 CellTags->"jlug:5.3.12.0",
 CellID->28685],
Cell[371034, 11917, 952, 22, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->19090],
Cell[371989, 11941, 174, 7, 70, "Program",
 CellTags->"jlug:5.3.12.0",
 CellID->19497],
Cell[372166, 11950, 238, 9, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->2589],
Cell[372407, 11961, 320, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.12.0",
 CellID->25990],
Cell[372730, 11973, 377, 8, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->15145],
Cell[373110, 11983, 1240, 36, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->19353],
Cell[374353, 12021, 1039, 35, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->19314],
Cell[375395, 12058, 537, 15, 70, "Input",
 CellTags->"jlug:5.3.12.0",
 CellID->66209135],
Cell[375935, 12075, 262, 8, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->26740],
Cell[376200, 12085, 331, 10, 70, "Input",
 CellTags->"jlug:5.3.12.0",
 CellID->22044],
Cell[376534, 12097, 266, 6, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->11258],
Cell[376803, 12105, 153, 5, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->335],
Cell[376959, 12112, 732, 21, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->8759],
Cell[377694, 12135, 1474, 36, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->11192],
Cell[379171, 12173, 428, 13, 70, "Input",
 CellTags->"jlug:5.3.12.0",
 CellID->7605],
Cell[379602, 12188, 408, 8, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->25264],
Cell[380013, 12198, 185, 6, 70, "Input",
 CellTags->"jlug:5.3.12.0",
 CellID->12181],
Cell[380201, 12206, 346, 10, 70, "Text",
 CellTags->"jlug:5.3.12.0",
 CellID->28503],
Cell[380550, 12218, 141, 4, 70, "Input",
 CellTags->"jlug:5.3.12.0",
 CellID->3829]
}, Open  ]],
Cell[CellGroupData[{
Cell[380728, 12227, 109, 2, 70, "Section",
 CellTags->{"jlug:5.3.13.0", "TableOfContents_1.5.3.13"},
 CellID->28255],
Cell[380840, 12231, 1164, 25, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->4460],
Cell[382007, 12258, 2342, 79, 70, "DefinitionBox",
 CellTags->"jlug:5.3.13.0",
 CellID->474],
Cell[384352, 12339, 92, 2, 70, "Caption",
 CellTags->"jlug:5.3.13.0",
 CellID->6972],
Cell[384447, 12343, 261, 9, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->26821],
Cell[384711, 12354, 249, 9, 70, "Input",
 CellTags->"jlug:5.3.13.0",
 CellID->26122],
Cell[384963, 12365, 835, 23, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->446439732],
Cell[385801, 12390, 1017, 17, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->21577],
Cell[386821, 12409, 1038, 29, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->13634400],
Cell[387862, 12440, 478, 13, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->25605],
Cell[388343, 12455, 123, 3, 70, "Input",
 CellTags->"jlug:5.3.13.0",
 CellID->30195],
Cell[388469, 12460, 829, 21, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->27594],
Cell[389301, 12483, 675, 15, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->7950],
Cell[389979, 12500, 188, 5, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->16343],
Cell[390170, 12507, 260, 9, 70, "Input",
 CellTags->"jlug:5.3.13.0",
 CellID->754],
Cell[390433, 12518, 669, 20, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->2481],
Cell[391105, 12540, 152, 5, 70, "Text",
 CellTags->"jlug:5.3.13.0",
 CellID->1012],
Cell[391260, 12547, 198, 6, 70, "Input",
 CellTags->"jlug:5.3.13.0",
 CellID->11672]
}, Open  ]],
Cell[CellGroupData[{
Cell[391495, 12558, 120, 2, 70, "Section",
 CellTags->{"jlug:5.3.14.0", "TableOfContents_1.5.3.14"},
 CellID->10938],
Cell[CellGroupData[{
Cell[391640, 12564, 105, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.14.1", "TableOfContents_1.5.3.14.1"},
 CellID->1881],
Cell[391748, 12568, 870, 26, 70, "Text",
 CellTags->"jlug:5.3.14.1",
 CellID->9257],
Cell[392621, 12596, 539, 18, 70, "Text",
 CellTags->"jlug:5.3.14.1",
 CellID->22750]
}, Open  ]],
Cell[CellGroupData[{
Cell[393197, 12619, 211, 5, 70, "Subsection",
 CellTags->{"jlug:5.3.14.2", "TableOfContents_1.5.3.14.2"},
 CellID->28614],
Cell[393411, 12626, 867, 26, 70, "Text",
 CellTags->"jlug:5.3.14.2",
 CellID->18598],
Cell[394281, 12654, 1157, 44, 70, "Text",
 CellTags->"jlug:5.3.14.2",
 CellID->28458],
Cell[395441, 12700, 701, 20, 70, "Text",
 CellTags->"jlug:5.3.14.2",
 CellID->2661]
}, Open  ]],
Cell[CellGroupData[{
Cell[396179, 12725, 123, 2, 70, "Subsection",
 CellTags->{"1.2.14", "jlug:5.3.14.3", "TableOfContents_1.5.3.14.3"},
 CellID->26063],
Cell[396305, 12729, 1062, 31, 70, "Text",
 CellTags->"jlug:5.3.14.3",
 CellID->32756],
Cell[397370, 12762, 697, 21, 70, "DefinitionBox",
 CellTags->"jlug:5.3.14.3",
 CellID->20807],
Cell[398070, 12785, 101, 2, 70, "Caption",
 CellTags->"jlug:5.3.14.3",
 CellID->20278],
Cell[398174, 12789, 142, 4, 70, "Text",
 CellTags->"jlug:5.3.14.3",
 CellID->19489],
Cell[398319, 12795, 215, 7, 70, "ItemizedText",
 CellTags->"jlug:5.3.14.3",
 CellID->19435],
Cell[CellGroupData[{
Cell[398559, 12806, 207, 7, 70, "ItemizedText",
 CellTags->"jlug:5.3.14.3",
 CellID->6365],
Cell[398769, 12815, 110, 5, 70, "Program",
 CellTags->"jlug:5.3.14.3",
 CellID->32075],
Cell[398882, 12822, 754, 21, 70, "Text",
 CellTags->"jlug:5.3.14.3",
 CellID->7586],
Cell[399639, 12845, 173, 6, 70, "Input",
 CellTags->"jlug:5.3.14.3",
 CellID->1386],
Cell[399815, 12853, 551, 15, 70, "Text",
 CellTags->"jlug:5.3.14.3",
 CellID->7833],
Cell[400369, 12870, 351, 10, 70, "Text",
 CellTags->"jlug:5.3.14.3",
 CellID->8360]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[400769, 12886, 123, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.14.4", "TableOfContents_1.5.3.14.4"},
 CellID->13330],
Cell[400895, 12890, 1091, 35, 70, "Text",
 CellTags->"jlug:5.3.14.4",
 CellID->26048]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[402035, 12931, 105, 2, 70, "Section",
 CellTags->{"jlug:5.3.15.0", "TableOfContents_1.5.3.15"},
 CellID->1908],
Cell[402143, 12935, 1830, 50, 70, "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->17223],
Cell[403976, 12987, 418, 13, 70, "DefinitionBox",
 CellTags->"jlug:5.3.15.0",
 CellID->11759],
Cell[404397, 13002, 84, 2, 70, "Caption",
 CellTags->"jlug:5.3.15.0",
 CellID->26434],
Cell[404484, 13006, 677, 20, 70, "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->5204],
Cell[405164, 13028, 136, 6, 70, "Program",
 CellTags->"jlug:5.3.15.0",
 CellID->29486],
Cell[405303, 13036, 111, 2, 70, "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->4319],
Cell[CellGroupData[{
Cell[405439, 13042, 381, 12, 70, "Input",
 CellTags->"jlug:5.3.15.0",
 CellID->958],
Cell[405823, 13056, 372, 10, 70, "Message",
 CellTags->"jlug:5.3.15.0",
 CellID->5945],
Cell[406198, 13068, 101, 3, 70, "Output",
 CellTags->"jlug:5.3.15.0",
 CellID->26806]
}, Open  ]],
Cell[406314, 13074, 405, 13, 70, "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->8166],
Cell[406722, 13089, 317, 9, 70, "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->18700],
Cell[CellGroupData[{
Cell[407064, 13102, 362, 11, 70, "Input",
 CellTags->"jlug:5.3.15.0",
 CellID->11367],
Cell[407429, 13115, 248, 9, 70, "Output",
 CellTags->"jlug:5.3.15.0",
 CellID->17692]
}, Open  ]],
Cell[407692, 13127, 195, 5, 70, "Text",
 CellTags->"jlug:5.3.15.0",
 CellID->21787],
Cell[407890, 13134, 141, 4, 70, "Input",
 CellTags->"jlug:5.3.15.0",
 CellID->28532]
}, Open  ]],
Cell[CellGroupData[{
Cell[408068, 13143, 211, 7, 70, "Section",
 CellTags->{"1.2.17", "jlug:5.3.17.0", "TableOfContents_1.5.3.17"},
 CellID->7619],
Cell[408282, 13152, 1381, 39, 70, "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->20913],
Cell[409666, 13193, 1060, 30, 70, "DefinitionBox",
 CellTags->"jlug:5.3.17.0",
 CellID->7591],
Cell[410729, 13225, 184, 9, 70, "Caption",
 CellTags->"jlug:5.3.17.0",
 CellID->6704],
Cell[410916, 13236, 2490, 67, 70, "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->31818],
Cell[413409, 13305, 524, 19, 70, "Input",
 CellTags->"jlug:5.3.17.0",
 CellID->9232],
Cell[413936, 13326, 1644, 43, 70, "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->750],
Cell[415583, 13371, 700, 14, 70, "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->25205],
Cell[416286, 13387, 887, 23, 70, "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->4975],
Cell[417176, 13412, 2940, 74, 70, "Text",
 CellTags->"jlug:5.3.17.0",
 CellID->1539]
}, Open  ]],
Cell[CellGroupData[{
Cell[420153, 13491, 143, 2, 70, "Section",
 CellTags->{"1.2.18", "jlug:5.3.18.0", "TableOfContents_1.5.3.18"},
 CellID->4680],
Cell[CellGroupData[{
Cell[420321, 13497, 105, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.18.1", "TableOfContents_1.5.3.18.1"},
 CellID->9198],
Cell[420429, 13501, 380, 10, 70, "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->27032],
Cell[420812, 13513, 1233, 34, 70, "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->14387],
Cell[422048, 13549, 1225, 31, 70, "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->32584],
Cell[423276, 13582, 877, 28, 70, "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->7240],
Cell[424156, 13612, 2077, 56, 70, "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->3517],
Cell[426236, 13670, 500, 15, 70, "Text",
 CellTags->"jlug:5.3.18.1",
 CellID->17006]
}, Open  ]],
Cell[CellGroupData[{
Cell[426773, 13690, 148, 4, 70, "Subsection",
 CellTags->{"jlug:5.3.18.2", "TableOfContents_1.5.3.18.2"},
 CellID->8670],
Cell[426924, 13696, 1215, 32, 70, "Text",
 CellTags->"jlug:5.3.18.2",
 CellID->241],
Cell[428142, 13730, 784, 17, 70, "Text",
 CellTags->"jlug:5.3.18.2",
 CellID->18882]
}, Open  ]],
Cell[CellGroupData[{
Cell[428963, 13752, 127, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.18.3", "TableOfContents_1.5.3.18.3"},
 CellID->25249],
Cell[429093, 13756, 272, 8, 70, "Text",
 CellTags->"jlug:5.3.18.3",
 CellID->3523],
Cell[429368, 13766, 310, 7, 70, "Text",
 CellTags->"jlug:5.3.18.3",
 CellID->31758]
}, Open  ]],
Cell[CellGroupData[{
Cell[429715, 13778, 219, 7, 70, "Subsection",
 CellTags->{"jlug:5.3.18.4", "TableOfContents_1.5.3.18.4"},
 CellID->12105],
Cell[429937, 13787, 1195, 31, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->29621],
Cell[431135, 13820, 965, 28, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->17095],
Cell[432103, 13850, 108, 2, 70, "Program",
 CellTags->"jlug:5.3.18.4",
 CellID->7296],
Cell[432214, 13854, 768, 20, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->9916],
Cell[432985, 13876, 212, 5, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->15678],
Cell[433200, 13883, 258, 8, 70, "Program",
 CellTags->"jlug:5.3.18.4",
 CellID->10178],
Cell[433461, 13893, 1334, 30, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->13579],
Cell[434798, 13925, 1242, 31, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->25058],
Cell[436043, 13958, 217, 7, 70, "Program",
 CellTags->"jlug:5.3.18.4",
 CellID->27577],
Cell[436263, 13967, 362, 10, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->12750],
Cell[436628, 13979, 789, 23, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->14007],
Cell[437420, 14004, 1079, 29, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->23729],
Cell[438502, 14035, 443, 11, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->24081],
Cell[438948, 14048, 766, 20, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->2995],
Cell[439717, 14070, 110, 2, 70, "Program",
 CellTags->"jlug:5.3.18.4",
 CellID->2678],
Cell[439830, 14074, 810, 24, 70, "Text",
 CellTags->"jlug:5.3.18.4",
 CellID->24676]
}, Open  ]],
Cell[CellGroupData[{
Cell[440677, 14103, 193, 6, 70, "Subsection",
 CellTags->{"jlug:5.3.18.5", "TableOfContents_1.5.3.18.5"},
 CellID->27753],
Cell[440873, 14111, 773, 20, 70, "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->20899],
Cell[441649, 14133, 913, 25, 70, "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->11784],
Cell[442565, 14160, 508, 25, 70, "Program",
 CellTags->"jlug:5.3.18.5",
 CellID->15565],
Cell[443076, 14187, 944, 28, 70, "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->294743168],
Cell[444023, 14217, 949, 29, 70, "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->13608],
Cell[444975, 14248, 552, 16, 70, "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->6172],
Cell[445530, 14266, 706, 23, 70, "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->11243],
Cell[446239, 14291, 1399, 44, 70, "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->29929],
Cell[447641, 14337, 650, 16, 70, "Text",
 CellTags->"jlug:5.3.18.5",
 CellID->7514]
}, Open  ]],
Cell[CellGroupData[{
Cell[448328, 14358, 188, 6, 70, "Subsection",
 CellTags->{"jlug:5.3.18.6", "TableOfContents_1.5.3.18.6"},
 CellID->10168],
Cell[448519, 14366, 1119, 32, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->5055],
Cell[449641, 14400, 1344, 35, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->11191],
Cell[450988, 14437, 929, 27, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->5973],
Cell[451920, 14466, 639, 20, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->8922],
Cell[452562, 14488, 168, 5, 70, "Program",
 CellTags->"jlug:5.3.18.6",
 CellID->6748],
Cell[452733, 14495, 363, 8, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->5651],
Cell[453099, 14505, 387, 15, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->10986],
Cell[453489, 14522, 90, 2, 70, "Program",
 CellTags->"jlug:5.3.18.6",
 CellID->2144],
Cell[453582, 14526, 351, 11, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->16446],
Cell[453936, 14539, 165, 3, 70, "Program",
 CellTags->"jlug:5.3.18.6",
 CellID->31577],
Cell[454104, 14544, 82, 2, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->26517],
Cell[454189, 14548, 378, 15, 70, "Program",
 CellTags->"jlug:5.3.18.6",
 CellID->14629],
Cell[454570, 14565, 482, 17, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->29916],
Cell[455055, 14584, 140, 6, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->5874],
Cell[CellGroupData[{
Cell[455220, 14594, 322, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.18.6",
 CellID->15791],
Cell[455545, 14606, 150, 5, 70, "Print",
 CellTags->"jlug:5.3.18.6",
 CellID->15469],
Cell[455698, 14613, 315, 8, 70, "Message",
 CellTags->"jlug:5.3.18.6",
 CellID->22912],
Cell[456016, 14623, 101, 3, 70, "Output",
 CellTags->"jlug:5.3.18.6",
 CellID->8146]
}, Open  ]],
Cell[456132, 14629, 441, 14, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->30693],
Cell[456576, 14645, 1264, 38, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->9091],
Cell[457843, 14685, 1143, 36, 70, "DisplayMath",
 CellTags->"jlug:5.3.18.6",
 CellID->9815],
Cell[458989, 14723, 544, 15, 70, "Text",
 CellTags->"jlug:5.3.18.6",
 CellID->26949],
Cell[459536, 14740, 1326, 40, 70, "Program",
 CellTags->"jlug:5.3.18.6",
 CellID->26857]
}, Open  ]],
Cell[CellGroupData[{
Cell[460899, 14785, 117, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.18.7", "TableOfContents_1.5.3.18.7"},
 CellID->20640],
Cell[461019, 14789, 912, 23, 70, "Text",
 CellTags->"jlug:5.3.18.7",
 CellID->26052]
}, Open  ]],
Cell[CellGroupData[{
Cell[461968, 14817, 125, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.18.8", "TableOfContents_1.5.3.18.8"},
 CellID->236],
Cell[462096, 14821, 579, 20, 70, "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->8551],
Cell[462678, 14843, 94, 2, 70, "Program",
 CellTags->"jlug:5.3.18.8",
 CellID->9487],
Cell[462775, 14847, 557, 15, 70, "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->31226],
Cell[463335, 14864, 326, 13, 70, "Program",
 CellTags->"jlug:5.3.18.8",
 CellID->28162],
Cell[463664, 14879, 1413, 41, 70, "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->16955],
Cell[465080, 14922, 2139, 57, 70, "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->23183],
Cell[467222, 14981, 1690, 44, 70, "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->8394],
Cell[468915, 15027, 92, 2, 70, "Program",
 CellTags->"jlug:5.3.18.8",
 CellID->30180],
Cell[469010, 15031, 79, 2, 70, "Text",
 CellTags->"jlug:5.3.18.8",
 CellID->16097],
Cell[469092, 15035, 388, 17, 70, "Program",
 CellTags->"jlug:5.3.18.8",
 CellID->3065]
}, Open  ]],
Cell[CellGroupData[{
Cell[469517, 15057, 133, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.18.9", "TableOfContents_1.5.3.18.9"},
 CellID->27065],
Cell[469653, 15061, 2974, 80, 70, "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->2513],
Cell[472630, 15143, 1893, 50, 70, "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->9261],
Cell[474526, 15195, 2072, 57, 70, "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->12578],
Cell[476601, 15254, 862, 21, 70, "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->21078],
Cell[477466, 15277, 914, 25, 70, "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->16878],
Cell[478383, 15304, 507, 18, 70, "Program",
 CellTags->"jlug:5.3.18.9",
 CellID->14140],
Cell[478893, 15324, 1546, 35, 70, "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->4611],
Cell[480442, 15361, 311, 8, 70, "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->31947],
Cell[480756, 15371, 292, 11, 70, "BulletText",
 CellTags->"jlug:5.3.18.9",
 CellID->2445],
Cell[481051, 15384, 200, 8, 70, "BulletText",
 CellTags->"jlug:5.3.18.9",
 CellID->170],
Cell[481254, 15394, 282, 9, 70, "BulletText",
 CellTags->"jlug:5.3.18.9",
 CellID->29975],
Cell[481539, 15405, 203, 7, 70, "BulletText",
 CellTags->"jlug:5.3.18.9",
 CellID->13489],
Cell[481745, 15414, 352, 13, 70, "BulletText",
 CellTags->"jlug:5.3.18.9",
 CellID->24750],
Cell[482100, 15429, 718, 20, 70, "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->6149],
Cell[482821, 15451, 831, 27, 70, "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->3333],
Cell[483655, 15480, 803, 22, 70, "Text",
 CellTags->"jlug:5.3.18.9",
 CellID->13865]
}, Open  ]],
Cell[CellGroupData[{
Cell[484495, 15507, 127, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.18.10", "TableOfContents_1.5.3.18.10"},
 CellID->22214],
Cell[484625, 15511, 1000, 30, 70, "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->17282],
Cell[485628, 15543, 124, 2, 70, "Program",
 CellTags->"jlug:5.3.18.10",
 CellID->27007],
Cell[485755, 15547, 609, 18, 70, "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->27432],
Cell[486367, 15567, 630, 15, 70, "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->8896],
Cell[487000, 15584, 195, 8, 70, "Program",
 CellTags->"jlug:5.3.18.10",
 CellID->16367],
Cell[487198, 15594, 472, 15, 70, "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->28522],
Cell[487673, 15611, 221, 9, 70, "Input",
 Evaluatable->False,
 CellTags->"jlug:5.3.18.10",
 CellID->4882],
Cell[487897, 15622, 966, 30, 70, "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->31810],
Cell[488866, 15654, 149, 5, 70, "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->17641],
Cell[489018, 15661, 348, 14, 70, "Program",
 CellTags->"jlug:5.3.18.10",
 CellID->7231],
Cell[489369, 15677, 725, 22, 70, "Text",
 CellTags->"jlug:5.3.18.10",
 CellID->2187],
Cell[490097, 15701, 154, 5, 70, "Program",
 CellTags->"jlug:5.3.18.10",
 CellID->6705]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[490300, 15712, 184, 6, 70, "Section",
 CellTags->{"jlug:5.3.19.0", "TableOfContents_1.5.3.19"},
 CellID->17189],
Cell[490487, 15720, 278, 11, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->19976],
Cell[490768, 15733, 1233, 28, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->31329],
Cell[492004, 15763, 1594, 44, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->2368],
Cell[493601, 15809, 492, 18, 70, "Program",
 CellTags->"jlug:5.3.19.0",
 CellID->28692],
Cell[494096, 15829, 1630, 50, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->21425],
Cell[CellGroupData[{
Cell[495751, 15883, 109, 2, 70, "Subsection",
 CellTags->{"jlug:5.3.19.0", "TableOfContents_1.5.3.19.1"},
 CellID->10555],
Cell[495863, 15887, 202, 5, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->3434],
Cell[496068, 15894, 1433, 34, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->16549],
Cell[497504, 15930, 948, 29, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->7441],
Cell[498455, 15961, 1660, 45, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->9512],
Cell[500118, 16008, 750, 26, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->30145],
Cell[500871, 16036, 3463, 86, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->18060],
Cell[504337, 16124, 281, 11, 70, "Input",
 CellTags->"jlug:5.3.19.0",
 CellID->21718],
Cell[504621, 16137, 1043, 28, 70, "Text",
 CellTags->"jlug:5.3.19.0",
 CellID->3753]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[505713, 16171, 112, 2, 70, "Section",
 CellTags->{"TableOfContents_1.5.4", "1.3", "jlug:5.4.0.0"},
 CellID->16139],
Cell[CellGroupData[{
Cell[505850, 16177, 106, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.1.0", "TableOfContents_1.5.4.1"},
 CellID->12423],
Cell[505959, 16181, 377, 10, 70, "Text",
 CellTags->"jlug:5.4.1.0",
 CellID->16279],
Cell[506339, 16193, 930, 25, 70, "Text",
 CellTags->"jlug:5.4.1.0",
 CellID->25996],
Cell[507272, 16220, 562, 16, 70, "Text",
 CellTags->"jlug:5.4.1.0",
 CellID->16687]
}, Open  ]],
Cell[CellGroupData[{
Cell[507871, 16241, 109, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.2.0", "TableOfContents_1.5.4.2"},
 CellID->12529],
Cell[507983, 16245, 391, 14, 70, "Text",
 CellTags->"jlug:5.4.2.0",
 CellID->31673922],
Cell[508377, 16261, 457, 13, 70, "Input",
 CellTags->"jlug:5.4.2.0",
 CellID->17437],
Cell[508837, 16276, 414, 12, 70, "Text",
 CellTags->"jlug:5.4.2.0",
 CellID->19866],
Cell[509254, 16290, 118, 4, 70, "Input",
 CellTags->"jlug:5.4.2.0",
 CellID->12949],
Cell[509375, 16296, 328, 7, 70, "Text",
 CellTags->"jlug:5.4.2.0",
 CellID->193],
Cell[509706, 16305, 222, 10, 70, "Input",
 CellTags->"jlug:5.4.2.0",
 CellID->23195],
Cell[509931, 16317, 2330, 69, 70, "Text",
 CellTags->"jlug:5.4.2.0",
 CellID->3297],
Cell[512264, 16388, 310, 13, 70, "Input",
 CellTags->"jlug:5.4.2.0",
 CellID->20416],
Cell[512577, 16403, 362, 10, 70, "Text",
 CellTags->"jlug:5.4.2.0",
 CellID->28286]
}, Open  ]],
Cell[CellGroupData[{
Cell[512976, 16418, 110, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.3.0", "TableOfContents_1.5.4.3"},
 CellID->16105],
Cell[513089, 16422, 399, 9, 70, "Text",
 CellTags->"jlug:5.4.3.0",
 CellID->24488],
Cell[CellGroupData[{
Cell[513513, 16435, 173, 5, 70, "Input",
 CellTags->"jlug:5.4.3.0",
 CellID->16282],
Cell[513689, 16442, 270, 8, 70, "Output",
 CellTags->"jlug:5.4.3.0",
 CellID->12455]
}, Open  ]],
Cell[513974, 16453, 185, 6, 70, "Text",
 CellTags->"jlug:5.4.3.0",
 CellID->25734],
Cell[CellGroupData[{
Cell[514184, 16463, 271, 8, 70, "Input",
 CellTags->"jlug:5.4.3.0",
 CellID->18114],
Cell[514458, 16473, 287, 9, 70, "Output",
 CellTags->"jlug:5.4.3.0",
 CellID->11701]
}, Open  ]],
Cell[514760, 16485, 199, 8, 70, "Text",
 CellTags->"jlug:5.4.3.0",
 CellID->31316],
Cell[CellGroupData[{
Cell[514984, 16497, 163, 5, 70, "Input",
 CellTags->"jlug:5.4.3.0",
 CellID->20671],
Cell[515150, 16504, 115, 3, 70, "Output",
 CellTags->"jlug:5.4.3.0",
 CellID->5786]
}, Open  ]],
Cell[515280, 16510, 425, 10, 70, "Text",
 CellTags->"jlug:5.4.3.0",
 CellID->12263]
}, Open  ]],
Cell[CellGroupData[{
Cell[515742, 16525, 107, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.5.0", "TableOfContents_1.5.4.5"},
 CellID->5535],
Cell[515852, 16529, 1394, 33, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->20450],
Cell[517249, 16564, 503, 13, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->11173],
Cell[517755, 16579, 590, 15, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->10466],
Cell[518348, 16596, 1722, 49, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->12044],
Cell[520073, 16647, 941, 31, 70, "Input",
 CellTags->"jlug:5.4.5.0",
 CellID->21659],
Cell[521017, 16680, 1149, 31, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->26292],
Cell[522169, 16713, 279, 10, 70, "Input",
 CellTags->"jlug:5.4.5.0",
 CellID->26439],
Cell[522451, 16725, 442, 10, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->17253],
Cell[522896, 16737, 500, 12, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->20024],
Cell[523399, 16751, 262, 12, 70, "Input",
 CellTags->"jlug:5.4.5.0",
 CellID->26154],
Cell[523664, 16765, 729, 22, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->29510],
Cell[524396, 16789, 653, 18, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->4745],
Cell[525052, 16809, 348, 10, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->20649],
Cell[525403, 16821, 468, 9, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->13186],
Cell[525874, 16832, 98, 2, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->8313],
Cell[525975, 16836, 172, 6, 70, "Input",
 CellTags->"jlug:5.4.5.0",
 CellID->4474],
Cell[526150, 16844, 131, 4, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->28022],
Cell[526284, 16850, 286, 9, 70, "Input",
 CellTags->"jlug:5.4.5.0",
 CellID->2168],
Cell[526573, 16861, 294, 7, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->14018],
Cell[526870, 16870, 271, 9, 70, "Input",
 CellTags->"jlug:5.4.5.0",
 CellID->18787],
Cell[527144, 16881, 67, 2, 70, "Text",
 CellTags->"jlug:5.4.5.0",
 CellID->9905],
Cell[527214, 16885, 140, 4, 70, "Input",
 CellTags->"jlug:5.4.5.0",
 CellID->17958]
}, Open  ]],
Cell[CellGroupData[{
Cell[527391, 16894, 120, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.6.0", "TableOfContents_1.5.4.6"},
 CellID->7391],
Cell[527514, 16898, 1557, 37, 70, "Text",
 CellTags->"jlug:5.4.6.0",
 CellID->10202],
Cell[529074, 16937, 2797, 90, 70, "Text",
 CellTags->"jlug:5.4.6.0",
 CellID->3625],
Cell[531874, 17029, 357, 9, 70, "Text",
 CellTags->"jlug:5.4.6.0",
 CellID->26477],
Cell[532234, 17040, 451, 13, 70, "Text",
 CellTags->"jlug:5.4.6.0",
 CellID->4414],
Cell[532688, 17055, 2456, 71, 70, "Input",
 CellTags->"jlug:5.4.6.0",
 CellID->9314],
Cell[535147, 17128, 77, 2, 70, "Text",
 CellTags->"jlug:5.4.6.0",
 CellID->246580910],
Cell[CellGroupData[{
Cell[535249, 17134, 122, 4, 70, "Input",
 CellTags->"jlug:5.4.6.0",
 CellID->29334],
Cell[535374, 17140, 98, 3, 70, "Output",
 CellTags->"jlug:5.4.6.0",
 CellID->25874]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[535521, 17149, 119, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.7.0", "TableOfContents_1.5.4.7"},
 CellID->24372],
Cell[535643, 17153, 896, 22, 70, "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->20159],
Cell[536542, 17177, 1215, 22, 70, "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->11833],
Cell[537760, 17201, 567, 10, 70, "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->28070],
Cell[538330, 17213, 716, 15, 70, "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->7487],
Cell[539049, 17230, 1499, 44, 70, "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->28297],
Cell[540551, 17276, 1109, 32, 70, "Text",
 CellTags->"jlug:5.4.7.0",
 CellID->7518]
}, Open  ]],
Cell[CellGroupData[{
Cell[541697, 17313, 136, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.8.0", "TableOfContents_1.5.4.8"},
 CellID->8177],
Cell[541836, 17317, 990, 20, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->17773],
Cell[542829, 17339, 1169, 33, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->32270],
Cell[544001, 17374, 1858, 49, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->1763],
Cell[545862, 17425, 452, 11, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->2668],
Cell[546317, 17438, 923, 29, 70, "Input",
 CellTags->"jlug:5.4.8.0",
 CellID->17192],
Cell[547243, 17469, 389, 10, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->13985],
Cell[547635, 17481, 139, 4, 70, "Input",
 CellTags->"jlug:5.4.8.0",
 CellID->3102],
Cell[547777, 17487, 2631, 75, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->8480],
Cell[550411, 17564, 1571, 34, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->29213],
Cell[551985, 17600, 1035, 28, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->7627],
Cell[553023, 17630, 547, 15, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->4802],
Cell[553573, 17647, 559, 13, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->4099],
Cell[554135, 17662, 491, 17, 70, "Input",
 CellTags->"jlug:5.4.8.0",
 CellID->30527],
Cell[554629, 17681, 898, 22, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->2625],
Cell[555530, 17705, 530, 10, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->1543],
Cell[556063, 17717, 405, 15, 70, "Input",
 CellTags->"jlug:5.4.8.0",
 CellID->1924],
Cell[556471, 17734, 295, 9, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->11023],
Cell[556769, 17745, 237, 8, 70, "Input",
 CellTags->"jlug:5.4.8.0",
 CellID->29972],
Cell[557009, 17755, 539, 14, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->13061],
Cell[557551, 17771, 383, 15, 70, "Input",
 CellTags->"jlug:5.4.8.0",
 CellID->14181],
Cell[557937, 17788, 422, 11, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->31003],
Cell[558362, 17801, 701, 20, 70, "Input",
 CellTags->"jlug:5.4.8.0",
 CellID->863759],
Cell[559066, 17823, 1630, 48, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->17505],
Cell[560699, 17873, 745, 21, 70, "Input",
 CellTags->"jlug:5.4.8.0",
 CellID->27593],
Cell[561447, 17896, 118, 2, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->22725],
Cell[561568, 17900, 213, 7, 70, "Input",
 CellTags->"jlug:5.4.8.0",
 CellID->13031],
Cell[561784, 17909, 595, 12, 70, "Text",
 CellTags->"jlug:5.4.8.0",
 CellID->8492]
}, Open  ]],
Cell[CellGroupData[{
Cell[562416, 17926, 129, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.9.0", "TableOfContents_1.5.4.9"},
 CellID->142],
Cell[562548, 17930, 1079, 19, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->17222],
Cell[563630, 17951, 446, 13, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->31286],
Cell[564079, 17966, 117, 2, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->13064],
Cell[564199, 17970, 2097, 53, 70, "Input",
 CellTags->"jlug:5.4.9.0",
 CellID->7900],
Cell[566299, 18025, 2316, 66, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->19187],
Cell[568618, 18093, 501, 12, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->399338963],
Cell[569122, 18107, 107, 2, 70, "Program",
 CellTags->"jlug:5.4.9.0",
 CellID->22413],
Cell[569232, 18111, 2706, 71, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->30974],
Cell[571941, 18184, 263, 7, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->14270],
Cell[572207, 18193, 432, 16, 70, "Input",
 CellTags->"jlug:5.4.9.0",
 CellID->29170],
Cell[572642, 18211, 1220, 35, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->235],
Cell[573865, 18248, 322, 8, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->30833],
Cell[574190, 18258, 162, 5, 70, "Input",
 CellTags->"jlug:5.4.9.0",
 CellID->19711],
Cell[574355, 18265, 631, 20, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->25760],
Cell[574989, 18287, 1457, 49, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->18896],
Cell[576449, 18338, 1348, 41, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->4667],
Cell[577800, 18381, 1015, 28, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->7285],
Cell[578818, 18411, 790, 22, 70, "Input",
 CellTags->"jlug:5.4.9.0",
 CellID->12550],
Cell[579611, 18435, 68, 2, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->140],
Cell[579682, 18439, 165, 5, 70, "Input",
 CellTags->"jlug:5.4.9.0",
 CellID->13694],
Cell[579850, 18446, 264, 6, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->2695],
Cell[580117, 18454, 1585, 46, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->21624],
Cell[581705, 18502, 841, 23, 70, "Input",
 CellTags->"jlug:5.4.9.0",
 CellID->28019],
Cell[582549, 18527, 1173, 38, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->2125],
Cell[583725, 18567, 1071, 30, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->26576],
Cell[584799, 18599, 174, 6, 70, "Input",
 CellTags->"jlug:5.4.9.0",
 CellID->21694],
Cell[584976, 18607, 518, 18, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->22658],
Cell[585497, 18627, 254, 7, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->26302],
Cell[585754, 18636, 168, 5, 70, "Input",
 CellTags->"jlug:5.4.9.0",
 CellID->17371],
Cell[585925, 18643, 511, 13, 70, "Text",
 CellTags->"jlug:5.4.9.0",
 CellID->22466]
}, Open  ]],
Cell[CellGroupData[{
Cell[586473, 18661, 147, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.10.0", "TableOfContents_1.5.4.10"},
 CellID->4678],
Cell[586623, 18665, 1171, 33, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->22593],
Cell[587797, 18700, 989, 20, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->23851],
Cell[588789, 18722, 786, 17, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->25484],
Cell[589578, 18741, 226, 6, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->1018],
Cell[589807, 18749, 855, 22, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->28464],
Cell[590665, 18773, 927, 19, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->21119],
Cell[591595, 18794, 721, 22, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->23152],
Cell[592319, 18818, 239, 6, 70, "Program",
 CellTags->"jlug:5.4.10.0",
 CellID->2800],
Cell[592561, 18826, 138, 4, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->18087],
Cell[592702, 18832, 598, 17, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->31060],
Cell[593303, 18851, 882, 25, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->1926],
Cell[594188, 18878, 253, 8, 70, "Input",
 CellTags->"jlug:5.4.10.0",
 CellID->273216376],
Cell[594444, 18888, 252, 8, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->4757],
Cell[594699, 18898, 1755, 50, 70, "Input",
 CellTags->"jlug:5.4.10.0",
 CellID->32170],
Cell[596457, 18950, 1574, 34, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->20315],
Cell[598034, 18986, 78, 2, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->9576],
Cell[598115, 18990, 107, 3, 70, "Input",
 CellTags->"jlug:5.4.10.0",
 CellID->30227],
Cell[598225, 18995, 1251, 25, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->12043],
Cell[599479, 19022, 140, 4, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->22758],
Cell[599622, 19028, 581, 18, 70, "Input",
 CellTags->"jlug:5.4.10.0",
 CellID->7164],
Cell[600206, 19048, 859, 25, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->5109],
Cell[601068, 19075, 189, 5, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->7882],
Cell[601260, 19082, 110, 3, 70, "Input",
 CellTags->"jlug:5.4.10.0",
 CellID->17086],
Cell[601373, 19087, 1009, 22, 70, "Text",
 CellTags->"jlug:5.4.10.0",
 CellID->29565]
}, Open  ]],
Cell[CellGroupData[{
Cell[602419, 19114, 129, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.11.0", "TableOfContents_1.5.4.11"},
 CellID->3487],
Cell[602551, 19118, 922, 27, 70, "Text",
 CellTags->"jlug:5.4.11.0",
 CellID->29577],
Cell[603476, 19147, 582, 16, 70, "Text",
 CellTags->"jlug:5.4.11.0",
 CellID->14474],
Cell[604061, 19165, 432, 17, 70, "Program",
 CellTags->"jlug:5.4.11.0",
 CellID->25627],
Cell[604496, 19184, 2195, 63, 70, "Text",
 CellTags->"jlug:5.4.11.0",
 CellID->5629],
Cell[606694, 19249, 594, 13, 70, "Text",
 CellTags->"jlug:5.4.11.0",
 CellID->31928]
}, Open  ]],
Cell[CellGroupData[{
Cell[607325, 19267, 106, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.12.0", "TableOfContents_1.5.4.12"},
 CellID->25423],
Cell[607434, 19271, 679, 16, 70, "Text",
 CellTags->"jlug:5.4.12.0",
 CellID->28520],
Cell[608116, 19289, 433, 13, 70, "Text",
 CellTags->"jlug:5.4.12.0",
 CellID->6902],
Cell[608552, 19304, 900, 22, 70, "Text",
 CellTags->"jlug:5.4.12.0",
 CellID->14962],
Cell[609455, 19328, 859, 21, 70, "Text",
 CellTags->"jlug:5.4.12.0",
 CellID->123],
Cell[610317, 19351, 1169, 30, 70, "Text",
 CellTags->"jlug:5.4.12.0",
 CellID->24596]
}, Open  ]],
Cell[CellGroupData[{
Cell[611523, 19386, 111, 2, 70, "Subsection",
 CellTags->{"jlug:5.4.13.0", "TableOfContents_1.5.4.13"},
 CellID->3737],
Cell[611637, 19390, 1375, 34, 70, "Text",
 CellTags->"jlug:5.4.13.0",
 CellID->13261]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[613051, 19429, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

