(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8818,        259]
NotebookOptionsPosition[      5191,        170]
NotebookOutlinePosition[      8332,        241]
CellTagsIndexPosition[      8221,        235]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Tutorial"
    }], "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["How to Use This Guide", "Title",
 PageBreakAbove->True,
 CellTags->"TableOfContents_1.4",
 CellID->48558995],

Cell[TextData[{
 "This User Guide is divided into two parts, reflecting the traditional \
distinction between the two ways of using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with external programs. The first use is to extend the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment by \[OpenCurlyDoubleQuote]installing\[CloseCurlyDoubleQuote] \
external programs so their functionality appears to be a built-in part of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This is similar to the \[OpenCurlyDoubleQuote]plug-in\
\[CloseCurlyDoubleQuote] concept supported by many popular applications and \
tools. The second use is to create programs that call on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a computational engine running in the background."
}], "Text",
 CellTags->"jlug:4.0.0.0",
 CellID->58203706],

Cell[TextData[{
 "Extending the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment by loading and calling Java classes is described in ",
 ButtonBox["Calling Java From ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ". This part will appeal to the widest audience because it requires no \
special programming skills, meaning that you do not have to be a Java \
programmer to use the features it describes. If this is what you want to use \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " for, read through ",
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview#1687036525"],
  FontSlant->"Italic"],
 ButtonBox[" Basics",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview#1687036525"],
 " in the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " User Guide. You should be able to start using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " right after this. You should also at least take a look at ",
 ButtonBox["Advanced Topics",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview#32713434"],
 " in the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " User Guide. You can examine that section in more depth later, as your \
familiarity with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " grows. ",
 ButtonBox["Example Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview#79753027"],
 " works through some complete examples of useful programs."
}], "Text",
 CellTags->"jlug:4.0.0.0",
 CellID->172971285],

Cell[TextData[{
 ButtonBox["Writing Java Programs that use ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
  FontSlant->"Italic"],
 " describes how to write Java programs that use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for computations. This part documents ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " as a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " developer\[CloseCurlyQuote]s kit for Java. Some familiarity with ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is assumed. ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is documented in ",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "."
}], "Text",
 CellTags->"jlug:4.0.0.0",
 CellID->448104335],

Cell[TextData[{
 "This manual uses the phrase \[OpenCurlyDoubleQuote]",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programming\[CloseCurlyDoubleQuote] to describe the creation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs that call Java, as well as Java programs that use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for computations. It should be clear from the context which of these is \
meant."
}], "Text",
 CellTags->"jlug:4.0.0.0",
 CellID->217968686]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"How to Use This Guide - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "How to Use This Guide", "summary" -> 
    "This User Guide is divided into two parts, reflecting the traditional \
distinction between the two ways of using Mathematica with external programs. \
The first use is to extend the Mathematica environment by 'installing' \
external programs so their functionality appears to be a built-in part of \
Mathematica. This is similar to the 'plug-in' concept supported by many \
popular applications and tools. The second use is to create programs that \
call on Mathematica as a computational engine running in the background. \
Extending the Mathematica environment by loading and calling Java classes is \
described in Calling Java From Mathematica. This part will appeal to the \
widest audience because it requires no special programming skills, meaning \
that you do not have to be a Java programmer to use the features it \
describes. If this is what you want to use J/Link for, read through J/Link \
Basics in the J/Link User Guide. You should be able to start using J/Link \
right after this. You should also at least take a look at Advanced Topics in \
the J/Link User Guide. You can examine that section in more depth later, as \
your familiarity with J/Link grows. Example Programs works through some \
complete examples of useful programs. Writing Java Programs that use \
Mathematica describes how to write Java programs that use Mathematica for \
computations. This part documents J/Link as a MathLink developer's kit for \
Java. Some familiarity with MathLink is assumed. MathLink is documented in \
MathLink and External Program Communication.", "uri" -> 
    "JLink/tutorial/HowToUseThisGuide", "type" -> "Tutorial", "label" -> 
    "J Link Tutorial", "paclet" -> "JLink", "context" -> "", "keywords" -> {},
     "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 31, 37.9747757}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "TableOfContents_1.4"->{
  Cell[801, 34, 114, 3, 70, "Title",
   PageBreakAbove->True,
   CellTags->"TableOfContents_1.4",
   CellID->48558995]},
 "jlug:4.0.0.0"->{
  Cell[918, 39, 858, 20, 70, "Text",
   CellTags->"jlug:4.0.0.0",
   CellID->58203706],
  Cell[1779, 61, 1720, 50, 70, "Text",
   CellTags->"jlug:4.0.0.0",
   CellID->172971285],
  Cell[3502, 113, 1152, 36, 70, "Text",
   CellTags->"jlug:4.0.0.0",
   CellID->448104335],
  Cell[4657, 151, 492, 14, 70, "Text",
   CellTags->"jlug:4.0.0.0",
   CellID->217968686]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"TableOfContents_1.4", 7695, 214},
 {"jlug:4.0.0.0", 7835, 219}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 176, 7, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[801, 34, 114, 3, 70, "Title",
 PageBreakAbove->True,
 CellTags->"TableOfContents_1.4",
 CellID->48558995],
Cell[918, 39, 858, 20, 70, "Text",
 CellTags->"jlug:4.0.0.0",
 CellID->58203706],
Cell[1779, 61, 1720, 50, 70, "Text",
 CellTags->"jlug:4.0.0.0",
 CellID->172971285],
Cell[3502, 113, 1152, 36, 70, "Text",
 CellTags->"jlug:4.0.0.0",
 CellID->448104335],
Cell[4657, 151, 492, 14, 70, "Text",
 CellTags->"jlug:4.0.0.0",
 CellID->217968686]
}, Open  ]],
Cell[5164, 168, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

