(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14778,        463]
NotebookOptionsPosition[      9743,        326]
NotebookOutlinePosition[     13670,        422]
CellTagsIndexPosition[     13517,        415]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Tutorial"
    }], "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Introduction to ",
 StyleBox["J/Link",
  FontSlant->"Italic"]
}], "Title",
 PageBreakAbove->True,
 CellTags->"TableOfContents_1.1",
 CellID->25620],

Cell[TextData[{
 "Welcome to ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", a product that integrates ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " lets you call Java from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a completely transparent way, and it also lets you use and control the \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel from a Java program. For ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " makes the whole universe of existing and future Java classes an automatic \
extension to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment. For Java programmers, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " turns ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into a scripting shell that lets you experiment with, build, and test Java \
classes a line at a time. It also makes Java the ideal language for writing \
programs that use the computational services of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->748],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s most unique feature is that it lets you load arbitrary \
Java classes into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and then create Java objects, call methods, and access fields directly \
from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. Thus, you can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to \[OpenCurlyDoubleQuote]script\[CloseCurlyDoubleQuote] the functionality \
of an arbitrary Java program\[LongDash]in effect, writing a Java program in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Essentially anything you can do from Java you can now do from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", perhaps even more easily because you are working in a true interpreted \
environment."
}], "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->27067],

Cell[TextData[{
 "For example, you can now create a Java-based user interface entirely with \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. This could be anything from a simple progress bar for a long \
computation to a dialog box or sophisticated wizard that walks users through \
a calculation. Such an interface is completely portable and can make full use \
of AWT, Swing, or any other user-interface class library."
}], "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->4536],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
     "\[FilledSmallSquare]", "  ", "Call", " ", "Java", " ", "methods", " ", 
      "from", " ", "Mathematica", " "}]},
    {
     RowBox[{
     "\[FilledSmallSquare]", "  ", "Write", " ", "Java", " ", "programs", " ",
       "that", " ", "use", " ", "Mathematica", " ", "services"}]},
    {
     RowBox[{
     "\[FilledSmallSquare]", "  ", "Create", " ", "alternative", " ", "front",
       " ", "ends", " ", "for", " ", "Mathematica", " "}]},
    {
     RowBox[{
     "\[FilledSmallSquare]", "  ", "Create", " ", "dialog", " ", "boxes", " ",
       "and", " ", "other", " ", "pop", " ", "up", " ", "user", " ", 
      "interface", " ", "elements", " ", "for", " ", "Mathematica", " ", 
      "programs", " "}]},
    {
     RowBox[{
     "\[FilledSmallSquare]", "  ", "Write", " ", "applets", " ", "that", " ", 
      "use", " ", "Mathematica", " ", "kernels", " ", "on", " ", "the", " ", 
      "client", " ", "or", " ", "server", " "}]},
    {
     RowBox[{
     "\[FilledSmallSquare]", "  ", "Write", " ", "servlets", " ", "that", " ",
       "make", " ", "Mathematica", " ", "services", " ", "available", " ", 
      "to", " ", "HTTP", " ", "clients", " "}]}
   }], TraditionalForm]], "DefinitionBox1Col",
 CellTags->"jlug:1.0.0.0",
 CellID->20783],

Cell[TextData[{
 "Some uses for ",
 StyleBox["J/Link.",
  FontSlant->"Italic"]
}], "Caption",
 CellTags->"jlug:1.0.0.0",
 CellID->18035],

Cell[TextData[{
 "Java is a fast, robust, and portable general-purpose programming language. \
It is not just an \[OpenCurlyDoubleQuote]internet\[CloseCurlyDoubleQuote] \
language, although it does have many useful ",
 "internet",
 " features. Java is also emphatically ",
 StyleBox["not",
  FontSlant->"Italic"],
 " just a language for writing applets. Applets are a powerful use for Java, \
but Java is good for much more than that. In fact, applets have already been \
relegated to a relatively minor category of Java programs. Today, Java is \
everywhere\[LongDash]on the client, server, browser, database, device, and \
desktop. And ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " lets you put ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java together in any way you want."
}], "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->32226],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is designed for end-users and developers alike. The same features that let \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users transparently call any Java method also let developers create \
sophisticated commercial add-ons to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Programmers who want to write custom front ends for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", or use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a computational engine for another program, will find using Java with \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is easier than using the traditional ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " interface from C or C++."
}], "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->15185],

Cell[TextData[{
 StyleBox["Finally, ",
  FormatType->InputForm],
 StyleBox["J/Link",
  FormatType->InputForm,
  FontSlant->"Italic"],
 StyleBox[" comes with full source code. This includes the components written \
in ",
  FormatType->InputForm],
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 StyleBox[", Java, and C. You can examine the code to supplement the \
documentation, get tips for your own programs, better understand how to use \
advanced features, or just see how it works.",
  FormatType->InputForm]
}], "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->7038],

Cell[TextData[{
 "Some familiarity with both Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is assumed in this manual. Even if you do not know Java, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is easy to use as a means to call existing Java classes from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This only requires learning what classes and methods are available\
\[LongDash]the syntax and intricacies of the Java language are irrelevant, \
since you will be writing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs, not Java programs."
}], "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->9853],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " and ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " "
}], "Section",
 CellTags->{"TableOfContents_1.1.1", "jlug:1.0.0.0"},
 CellID->25629],

Cell[TextData[{
 "The underlying glue that makes this all work is ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", Wolfram Research\[CloseCurlyQuote]s protocol for sending data and \
commands back and forth between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and other programs. At its core, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " developer\[CloseCurlyQuote]s kit for Java, although it goes far beyond \
this. In fact, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s best feature is that for a large class of uses, it \
hides ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " completely, so users and programmers do not need to know anything about \
it. This class corresponds to the so-called \
\[OpenCurlyDoubleQuote]installable\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]template\[CloseCurlyDoubleQuote] ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs, which plug into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and extend its functionality. For all types of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides a higher-level layer of functionality than the traditional C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programming interface. This makes Java the easiest and most convenient \
language for writing programs to interact with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->11224]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to J/Link - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Introduction to J/Link", "summary" -> 
    "Welcome to J/Link, a product that integrates Mathematica and Java. \
J/Link lets you call Java from Mathematica in a completely transparent way, \
and it also lets you use and control the Mathematica kernel from a Java \
program. For Mathematica users, J/Link makes the whole universe of existing \
and future Java classes an automatic extension to the Mathematica \
environment. For Java programmers, J/Link turns Mathematica into a scripting \
shell that lets you experiment with, build, and test Java classes a line at a \
time. It also makes Java the ideal language for writing programs that use the \
computational services of Mathematica. J/Link's most unique feature is that \
it lets you load arbitrary Java classes into Mathematica and then create Java \
objects, call methods, and access fields directly from the Mathematica \
language. Thus, you can use Mathematica to 'script' the functionality of an \
arbitrary Java program--in effect, writing a Java program in Mathematica. \
Essentially anything you can do from Java you can now do from Mathematica, \
perhaps even more easily because you are working in a true interpreted \
environment. For example, you can now create a Java-based user interface \
entirely with Mathematica code. This could be anything from a simple progress \
bar for a long computation to a dialog box or sophisticated wizard that walks \
users through a calculation. Such an interface is completely portable and can \
make full use of AWT, Swing, or any other user-interface class library.", 
    "uri" -> "JLink/tutorial/Introduction", "type" -> "Tutorial", "label" -> 
    "J Link Tutorial", "paclet" -> "JLink", "context" -> "", "keywords" -> {},
     "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 31, 40.6687838}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "TableOfContents_1.1"->{
  Cell[801, 34, 165, 7, 70, "Title",
   PageBreakAbove->True,
   CellTags->"TableOfContents_1.1",
   CellID->25620]},
 "jlug:1.0.0.0"->{
  Cell[969, 43, 1181, 41, 70, "Text",
   CellTags->"jlug:1.0.0.0",
   CellID->748],
  Cell[2153, 86, 902, 26, 70, "Text",
   CellTags->"jlug:1.0.0.0",
   CellID->27067],
  Cell[3058, 114, 489, 11, 70, "Text",
   CellTags->"jlug:1.0.0.0",
   CellID->4536],
  Cell[3550, 127, 1306, 32, 70, "DefinitionBox1Col",
   CellTags->"jlug:1.0.0.0",
   CellID->20783],
  Cell[4859, 161, 136, 6, 70, "Caption",
   CellTags->"jlug:1.0.0.0",
   CellID->18035],
  Cell[4998, 169, 850, 21, 70, "Text",
   CellTags->"jlug:1.0.0.0",
   CellID->32226],
  Cell[5851, 192, 821, 27, 70, "Text",
   CellTags->"jlug:1.0.0.0",
   CellID->15185],
  Cell[6675, 221, 569, 17, 70, "Text",
   CellTags->"jlug:1.0.0.0",
   CellID->7038],
  Cell[7247, 240, 642, 18, 70, "Text",
   CellTags->"jlug:1.0.0.0",
   CellID->9853],
  Cell[7914, 262, 205, 9, 70, "Section",
   CellTags->{"TableOfContents_1.1.1", "jlug:1.0.0.0"},
   CellID->25629],
  Cell[8122, 273, 1567, 47, 70, "Text",
   CellTags->"jlug:1.0.0.0",
   CellID->11224]},
 "TableOfContents_1.1.1"->{
  Cell[7914, 262, 205, 9, 70, "Section",
   CellTags->{"TableOfContents_1.1.1", "jlug:1.0.0.0"},
   CellID->25629]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"TableOfContents_1.1", 12215, 369},
 {"jlug:1.0.0.0", 12352, 374},
 {"TableOfContents_1.1.1", 13377, 408}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 176, 7, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[801, 34, 165, 7, 70, "Title",
 PageBreakAbove->True,
 CellTags->"TableOfContents_1.1",
 CellID->25620],
Cell[969, 43, 1181, 41, 70, "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->748],
Cell[2153, 86, 902, 26, 70, "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->27067],
Cell[3058, 114, 489, 11, 70, "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->4536],
Cell[3550, 127, 1306, 32, 70, "DefinitionBox1Col",
 CellTags->"jlug:1.0.0.0",
 CellID->20783],
Cell[4859, 161, 136, 6, 70, "Caption",
 CellTags->"jlug:1.0.0.0",
 CellID->18035],
Cell[4998, 169, 850, 21, 70, "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->32226],
Cell[5851, 192, 821, 27, 70, "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->15185],
Cell[6675, 221, 569, 17, 70, "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->7038],
Cell[7247, 240, 642, 18, 70, "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->9853],
Cell[CellGroupData[{
Cell[7914, 262, 205, 9, 70, "Section",
 CellTags->{"TableOfContents_1.1.1", "jlug:1.0.0.0"},
 CellID->25629],
Cell[8122, 273, 1567, 47, 70, "Text",
 CellTags->"jlug:1.0.0.0",
 CellID->11224]
}, Open  ]]
}, Open  ]],
Cell[9716, 324, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

