(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4533,        141]
NotebookOptionsPosition[      3729,        109]
NotebookOutlinePosition[      4122,        126]
CellTagsIndexPosition[      4079,        123]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "J/Link Example: The GetURL Function\n\n",
 StyleBox["Code for the URL-reading functions from section 1.3.4 of the \
J/Link User Guide.\n\nTo try this example, evaluate all the initialization \
cells (you can do this with the menu command Kernel/Evaluation/Evaluate \
Initialization). Then go to the Examples section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell[TextData[{
 "Needs[\"JLink`\"]\n\nGetURL[url_String, opts___?OptionQ] :=\n\tJavaBlock[\n\
\t\tModule[{u, stream, numRead, outFile, buf},\n\t\t\tInstallJava[];\n\t\t\tu \
= JavaNew[\"java.net.URL\", url];\n\t\t\t(* This is where the error will show \
up if the URL is not valid.\n\t\t\t   A Java exception will be thrown during \
openStream, which\n\t\t\t   causes the method to return $Failed.\n\t\t\t*)\n\t\
\t\tstream = u@openStream[];\n\t\t\tIf[stream === $Failed, Return[$Failed]];\n\
\t\t\tbuf = JavaNew[\"[B\", 5000]; (* 5000 is an arbitrary buffer size *)\n\t\
\t\toutFile = OpenTemporary[DOSTextFormat->False, CharacterEncoding->{}];\n\t\
\t\tWhile[(numRead = stream@read[buf]) > 0,\n\t\t\t\t",
 StyleBox["WriteString[outFile, FromCharacterCode[If[# < 0, # + 256, #]& /@\n\
\t\t\t\t\t\tTake[JavaObjectToExpression[buf], numRead]]]\n",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False],
 "\t\t\t];\n\t\t\tstream@close[];\n\t\t\tClose[outFile]   (* Close returns \
the filename *)\n\t\t]\n\t]\n\nUnprotect[Get];\nGet[s_String] :=\n\t\
Module[{tempFile, res},\n\t\ttempFile = GetURL[s];\n\t\tIf[tempFile =!= \
$Failed,\n\t\t\tres = Get[tempFile];\n\t\t\tDeleteFile[tempFile];\n\t\t\tres,\
\n\t\t(* else *)\n\t\t\t$Failed\n\t\t]\n\t] /; StringMatchQ[s, \"http://*\"]\n\
Protect[Get];\n\nNotebookOpenURL[url_String] := NotebookOpen[GetURL[url]]"
}], "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[TextData[{
 "If you use a proxy server to access the Internet, the examples below might \
fail, probably after a long timeout. On some systems you may need to call the \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " function SetInternetProxy with the correct values for your network. You \
can get these values from your system administrator or read them from your \
browser settings. Typical values might look something like:"
}], "Text"],

Cell["\<\
(** Uncomment, edit, and evaluate if necessary

SetInternetProxy[\"proxy.mycompany.com\", 8080]

**)\
\>", "Input"],

Cell["Try these:", "Text"],

Cell["<<http://www.wolfram.com/solutions/mathlink/jlink/hello.m", "Input"],

Cell["\<\
NotebookOpenURL[\"http://www.wolfram.com/solutions/mathlink/jlink/hello.nb\"]\
\
\>", "Input"],

Cell["Here is demonstration of how to read an image.", "Text"],

Cell["\<\
imgFile = GetURL[\"http://www.wolfram.com/images/gallery/infinity.gif\"];
img = Import[imgFile, \"GIF\"]; (* Use \"JPEG\" format specification for JPEG \
images *)
DeleteFile[imgFile];
Show[img]\
\>", "Input"]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{800, 529},
WindowMargins->{{7, Automatic}, {Automatic, 3}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 432, 9, 215, "Title"],
Cell[CellGroupData[{
Cell[1047, 36, 26, 0, 34, "Subsection"],
Cell[1076, 38, 1479, 24, 714, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[2592, 67, 30, 0, 26, "Subsection"],
Cell[2625, 69, 448, 9, 71, "Text"],
Cell[3076, 80, 125, 6, 102, "Input"],
Cell[3204, 88, 26, 0, 33, "Text"],
Cell[3233, 90, 74, 0, 30, "Input"],
Cell[3310, 92, 104, 3, 30, "Input"],
Cell[3417, 97, 62, 0, 33, "Text"],
Cell[3482, 99, 219, 6, 84, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

