(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4597,        160]
NotebookOptionsPosition[      4007,        134]
NotebookOutlinePosition[      4400,        151]
CellTagsIndexPosition[      4357,        148]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "J/Link Example: A Modal Input Dialog\n\n",
 StyleBox["Code for the GetAngle function from section 1.3.5 of the J/Link \
User Guide.\n\nThis example demonstrates the use of ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DoModal",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" to create a simple modal input dialog that returns a result to ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[".\n\nTo try this example, evaluate all the initialization cells \
(you can do this with the menu command Kernel/Evaluation/Evaluate \
Initialization). Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell["\<\
Needs[\"JLink`\"]

GetAngle[] :=
\tJavaBlock[
\t\tModule[{frm, inputField, cbGroup, degBox, radBox, label, okButton, \
cancelButton, wasOKButton, angle},

\t\t\tInstallJava[];

\t\t\tfrm = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\t\tlabel = JavaNew[\"java.awt.Label\", \"Enter an angle:\"];
\t\t\tinputField = JavaNew[\"java.awt.TextField\"];
\t\t\tcbGroup = JavaNew[\"java.awt.CheckboxGroup\"];
\t\t\tdegBox = JavaNew[\"java.awt.Checkbox\", \"degrees\", cbGroup, True];
\t\t\tradBox = JavaNew[\"java.awt.Checkbox\", \"radians\", cbGroup, False];
\t\t\tokButton = JavaNew[\"java.awt.Button\", \"OK\"];
\t\t\tcancelButton = JavaNew[\"java.awt.Button\", \"Cancel\"];
\t\t\t
\t\t\tfrm@setLayout[Null];
\t\t\tfrm@add[label];
\t\t\tfrm@add[inputField];
\t\t\tfrm@add[degBox];
\t\t\tfrm@add[radBox];
\t\t\tfrm@add[okButton];
\t\t\tfrm@add[cancelButton];
\t\t\t
\t\t\tfrm@setBounds[200, 200, 200, 160];
\t\t\tlabel@setBounds[20, 30, 150, 20];
\t\t\tinputField@setBounds[20, 70, 60, 28];
\t\t\tdegBox@setBounds[100, 60, 80, 20];
\t\t\tradBox@setBounds[100, 80, 80, 20];
\t\t\tokButton@setBounds[40, 120, 50, 20];
\t\t\tcancelButton@setBounds[100, 120, 50, 20];
\t\t\tfrm@setResizable[False];
\t\t\t
\t\t\tokButton@addActionListener[JavaNew[\"com.wolfram.jlink.\
MathActionListener\", \"(EndModal[]; True)&\"]];
\t\t\tcancelButton@addActionListener[JavaNew[\"com.wolfram.jlink.\
MathActionListener\", \"(EndModal[]; False)&\"]];
\t\t\t
\t\t\tJavaShow[frm];

\t\t\tfrm@setModal[];
\t\t\twasOKButton = DoModal[];
\t\t\t(* Even though the window may have been closed, it is perfectly OK to \
extract values fom the
\t\t\t   controls in the window.
\t\t\t*)
\t\t\tIf[TrueQ[wasOKButton],
\t\t\t\tangle = ToExpression[inputField@getText[]];
\t\t\t\tIf[angle =!= Null && degBox@getState[], angle *= Pi/180],
\t\t\t(* else *)
\t\t\t\t(* We will get here if the Cancel button was clicked (wasOKButton \
will be False),
\t\t\t\t   or if the dialog was closed by clicking in its close box \
(wasOKButton will be Null).
\t\t\t\t*)
\t\t\t\tangle = $Failed
\t\t\t];
\t\t\t(* If the cancel or OK buttons were clicked, frm is still visible, so \
we dispose it here. *)
\t\t\tfrm@dispose[];
\t\t\tangle
\t\t]
\t]\
\>", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["GetAngle[]", "Input"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{768, 501},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 944, 25, 261, "Title"],
Cell[CellGroupData[{
Cell[1559, 52, 26, 0, 34, "Subsection"],
Cell[1588, 54, 2295, 69, 1056, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[3920, 128, 29, 0, 26, "Subsection"],
Cell[3952, 130, 27, 0, 24, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

