(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5448,        200]
NotebookOptionsPosition[      4784,        172]
NotebookOutlinePosition[      5177,        189]
CellTagsIndexPosition[      5134,        186]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "J/Link Example: A Button Palette\n\n",
 StyleBox["Code for the Palette example from section 1.3 of the J/Link User \
Guide.\n",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["\nThis example demonstrates the use of the ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["ShareFrontEnd",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" function to allow Java interface elements interact with notebook \
windows in the same way that front end palettes can.\n\nBecause of current \
limitations with ShareFrontEnd, this example will not work with a remote \
kernel; the same machine must be running the kernel and the front end.\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["\nTo try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell["\<\
BeginPackage[\"PaletteDemo`\", \"JLink`\"];

PaletteDemo;

Begin[\"`Private`\"];

paletteButton[label_String, buttonFunc_String] :=
\tJavaBlock[
\t\tModule[{button, listener},
\t\t\tbutton = JavaNew[\"java.awt.Button\"];
\t\t\tbutton@setLabel[label];
\t\t\t(* Note that the button function callbacks are private to this package, \
so we need
\t\t\t   to make sure that when they are called from Java their full names \
are used. Thus,
\t\t\t   we prepend this package's Private` context to the names we send to \
Java.
\t\t\t*)
\t\t\tlistener = JavaNew[\"com.wolfram.jlink.MathActionListener\", \
\"PaletteDemo`Private`\" <> buttonFunc];
\t\t\tbutton@addActionListener[listener];
\t\t\tbutton
\t\t]
\t]

showPalette[buttons:{__?JavaObjectQ}] :=
\tJavaBlock[
\t\tModule[{frm, tok},
\t\t\tfrm = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\t\tfrm@setLayout[JavaNew[\"java.awt.GridLayout\", 0, 1]];
\t\t\tfrm@add[#]& /@ buttons;
\t\t\tReleaseJavaObject[buttons];
\t\t\tfrm@pack[];
\t\t\ttok = ShareFrontEnd[];
\t\t\t(* We use the frame's onClose method to unregister the request for
\t\t\t   front end sharing.
\t\t\t*)
\t\t\tfrm@onClose[\"UnshareFrontEnd[\" <> ToString[tok] <> \"]\"];
\t\t\tJavaShow[frm];
\t\t]
\t]

printButtonFunc[event_, _] :=
\tJavaBlock[
\t\tNotebookApply[SelectedNotebook[], event@getSource[]@getLabel[]];
\t\t(* We need to explicitly release the event object, since it was sent to
\t\t   Mathematica before the JavaBlock was entered. *)
\t\tReleaseJavaObject[event]
\t]

applyButtonFunc[event_, _] :=
\tJavaBlock[
\t\tWith[{nb = SelectedNotebook[]},
\t\t\tNotebookApply[nb, event@getSource[]@getLabel[], All];
\t\t\tReleaseJavaObject[event];
\t\t\tSelectionEvaluate[nb]
\t\t];
\t]

plotButtonFunc[event_, _] :=
\t(
\t\tPlot[x,{x,0,1}];
\t\tReleaseJavaObject[event];
\t)

printButtonFunc2[event_, _] :=
\tJavaBlock[
\t\tPrint[event@getSource[]@getLabel[]];
\t\tReleaseJavaObject[event];
\t]

PaletteDemo[] :=
\tJavaBlock[
\t\tModule[{btn1, btn2, btn3, btn4},
\t\t\tInstallJava[];
\t\t\tbtn1 = paletteButton[\"insertMe\", \"printButtonFunc\"];
\t\t\tbtn2 = paletteButton[\"Expand[\\[SelectionPlaceholder]]\", \
\"applyButtonFunc\"];
\t\t\tbtn3 = paletteButton[\"Create Plot\", \"plotButtonFunc\"];
\t\t\tbtn4 = paletteButton[\"printMe\", \"printButtonFunc2\"];
\t\t\tshowPalette[{btn1, btn2, btn3, btn4}]
\t\t]
\t]
\t
End[];
EndPackage[];\
\>", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["\<\
You should have called InstallJava prior to running this example.\
\>", "Text"],

Cell["PaletteDemo[]", "Input"],

Cell["\<\
Note that you can continue to use the front end normally while the palette \
window is visible and active.

When you are finished with the palette window, close it. This will shut down \
front end sharing and kernel sharing.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{817, 512},
WindowMargins->{{6, Automatic}, {Automatic, 9}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1206, 30, 365, "Title"],
Cell[CellGroupData[{
Cell[1821, 57, 26, 0, 34, "Subsection"],
Cell[1850, 59, 2464, 90, 1470, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[4351, 154, 29, 0, 26, "Subsection"],
Cell[4383, 156, 89, 2, 26, "Text"],
Cell[4475, 160, 30, 0, 24, "Input"],
Cell[4508, 162, 248, 6, 56, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

