(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      3757,        140]
NotebookOptionsPosition[      3132,        113]
NotebookOutlinePosition[      3525,        130]
CellTagsIndexPosition[      3482,        127]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "J/Link Example: The SimpleModal Dialog\n\n",
 StyleBox["Code for the SimpleModal dialog from section 1.2.7 of the J/Link \
User Guide.\n\nThis example demonstrates basic use of the ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DoModal",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" function to create a modal inteface (as described in section \
1.2.7 of the User Guide).\n\nTo try this example, evaluate all the \
initialization cells (you can do this with the menu command \
Kernel/Evaluation/Evaluate Initialization). Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell["\<\
Needs[\"JLink`\"]

SimpleModal[] :=
\tJavaBlock[
\t\tModule[{frm, button, textField, windowListener, buttonListener, \
buttonFunc},

\t\t\t(* Create the GUI components. *)
\t\t\tfrm = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\t\tbutton = JavaNew[\"java.awt.Button\"];
\t\t\ttextField = JavaNew[\"java.awt.TextField\"];

\t\t\t(* Configure their properties. *)
\t\t\tfrm@setLayout[JavaNew[\"java.awt.GridLayout\"]];
\t\t\tfrm@add[button];
\t\t\tfrm@add[textField];
\t\t\tbutton@setLabel[\"++\"];
\t\t\ttextField@setEditable[False];
\t\t\ttextField@setText[\"1\"];
\t\t\tfrm@pack[];

\t\t\t(* Create the listener and set its handler function. *)
\t\t\tbuttonListener = JavaNew[\"com.wolfram.jlink.MathActionListener\"];
\t\t\tbuttonListener@setHandler[\"actionPerformed\", ToString[buttonFunc]];
\t\t\tbutton@addActionListener[buttonListener];

\t\t\t(* Define buttonFunc. *)
\t\t\tbuttonFunc[_, _] :=
\t\t\t\tJavaBlock[
\t\t\t\t\tModule[{curText, newVal},
\t\t\t\t\t\tcurText = textField@getText[];
\t\t\t\t\t\tnewVal = ToExpression[curText] + 1;
\t\t\t\t\t\ttextField@setText[ToString[newVal]]
\t\t\t\t\t]
\t\t\t\t];

\t\t\tfrm@setLocation[200, 200];
\t\t\t(* Make the window visible and bring it in front of any
\t\t\t   notebook windows. *)
\t\t\tJavaShow[frm];

\t\t\t(* Tell the frame to end the modal loop when it is closed. *)
\t\t\tfrm@setModal[];

\t\t\t(* Enter the modal loop. *)
\t\t\tDoModal[];
\t\t]
\t]\
\>", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["\<\
You must have called InstallJava prior to running this example.\
\>", "Text"],

Cell["SimpleModal[]", "Input"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{760, 498},
WindowMargins->{{6, Automatic}, {Automatic, 0}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 747, 17, 331, "Title"],
Cell[CellGroupData[{
Cell[1362, 44, 26, 0, 34, "Subsection"],
Cell[1391, 46, 1524, 52, 858, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[2952, 103, 29, 0, 26, "Subsection"],
Cell[2984, 105, 87, 2, 26, "Text"],
Cell[3074, 109, 30, 0, 24, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

