(* :Title: JLink *)

(* :Context: JLink` *)

(* :Author:
        Todd Gayley
        tgayley@wolfram.com
*)

(* :Package Version: 4.0 *)

(* :Mathematica Version: 4.0 *)
		     
(* :Copyright: J/Link source code (c) 1999-2007, Wolfram Research, Inc. All rights reserved.

   Use is governed by the terms of the J/Link license agreement, which can be found at
   www.wolfram.com/solutions/mathlink/jlink.
*)

(* :Discussion:
   J/Link is a Mathematica enhancement that integrates Java and Mathematica. You can use J/Link to call
   Java from Mathematica or call Mathematica from Java. Find out more at www.wolfram.com/solutions/mathlink/jlink.

   J/Link uses a special system wherein one package context (JLink`) has its implementation
   split among a number of .m files. Each component file has its own private context, and also
   potentially introduces public symbols (in the JLink` context) and so-called "package" symbols,
   where the term "package" comes from Java terminology, referring to symbols that are visible
   everywhere within the implementation of J/Link, but not to clients.
*)

(* :Keywords: Java MathLink *)



BeginPackage["JLink`"]


Java::usage = "Java is only used as a generic symbol for some messages."


(*********************  Try to locate the JLink .mx file  *********************)

`Package`$jlinkDir = DirectoryName[System`Private`FindFile[$Input]]


If[SyntaxQ["<*$VersionNumber*>"] && SyntaxQ["<*$ReleaseNumber*>"] &&
		ToExpression["<*$VersionNumber*>"] == $VersionNumber && ToExpression["<*$ReleaseNumber*>"] == $ReleaseNumber,
	`Private`foundMX = True;
	Quiet[
		Check[
			Get[ToFileName[{`Package`$jlinkDir, "SystemFiles", "Kernel", "SystemResources", $SystemID}, "JLink.mx"]],
		(* On message: *)
			`Private`foundMX = False
		]
	],
(* else *)
	`Private`foundMX = False
]


(* Read .m files if no appropriate JLink.mx was found. *)
If[!`Private`foundMX,

	(***************************  Information Context  ****************************)
	
	(* Programmers can use these values (using their full context, as in
	   JLink`Information`$ReleaseNumber) to test version information about a user's
	   J/Link installation.
	*)
	
	(* The SyntaxQ checks allow this file to be used (albeit without meaningful
	   values for these constants) even if the Ant preprocessing step that replaces
	   the @name@ parts is not performed. This is for debugging in the Workbench.
	*)
	`Information`$VersionNumber = If[SyntaxQ["4.0"], ToExpression["4.0"], 0.0]; 
	`Information`$ReleaseNumber = If[SyntaxQ["1"], ToExpression["1"], 0];
	`Information`$BuildNumber = If[SyntaxQ["100000"], ToExpression["100000"], 0];
	`Information`$CreationID = If[SyntaxQ["20070420152745"], ToExpression["20070420152745"], 0];
	`Information`$CreationDate = If[SyntaxQ["{2007,04,20,15,27,45}"], ToExpression["{2007,04,20,15,27,45}"], {0,0,0,0,0,0}];
	`Information`$Version = "J/Link Version 4.0.1";
	
	
	(*******************  Read in the implementation files.  **********************)
		
	`Private`implementationFiles = 
		{
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "Debug.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "InstallJava.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "CallJava.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "Java.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "Exceptions.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "Reflection.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "JavaBlock.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "MakeJavaObject.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "Sharing.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "Misc.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "ArgumentTests.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "EvaluateTo.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "FrontEndServer.m"],
			ToFileName[{`Package`$jlinkDir, "Kernel"}, "JVMs.m"]
		};
	
	`Private`processDecls[`Private`file_] :=
		Module[{`Private`strm, `Private`e, `Private`moreLines = True},
			`Private`strm = OpenRead[`Private`file];
			If[Head[`Private`strm] =!= InputStream,
				Return[$Failed]
			];
			While[`Private`moreLines,
				`Private`e = Read[`Private`strm, Hold[Expression]];
				ReleaseHold[`Private`e];
				If[`Private`e === $Failed || MatchQ[`Private`e, Hold[_End]],
					`Private`moreLines = False
				]
			];
			Close[`Private`file]
		];
		
		
	(* If we don't turn this message off, user will get shadowing warnings if a Global` symbol
	   has the same name as any Package` symbols. It's not a valid warning, because Package`
	   is never on ContextPath at the same time as Global`.
	*)
	`Private`wasOn = (Head[General::shdw] =!= $Off);
	Off[General::shdw];
	
	(* Make the Package` symbols visible to all implementation files. *)
	AppendTo[$ContextPath, "JLink`Package`"];
	
	(* Read the public and package-visibility exports from the implementation files. *)
	`Private`processDecls /@ `Private`implementationFiles;
	
	(* Read in the code. *)
	Get /@ `Private`implementationFiles;
	
	If[`Private`wasOn, On[General::shdw]]

]

EndPackage[]
