(* :Title: PacletManager *)

(* :Context: PacletManager` *)

(* :Author:
        Todd Gayley
        tgayley@wolfram.com
*)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 6.0 *)
		     
(* :Copyright: Mathematica source code (c) 1999-2007, Wolfram Research, Inc. All rights reserved. *)

(* :Discussion:
*)

(* :Keywords:  *)


BeginPackage["PacletManager`"]

Needs["JLink`"]

(* Needs["ResourceLocator`"] *)


(***************************  Information Context  ****************************)

(* Programmers can use these values (using their full context, as in
   PacletManager`Information`$ReleaseNumber) to test version information about a user's
   PacletManager installation.
*)

(* The SyntaxQ checks allow this file to be used (albeit without meaningful
   values for these constants) even if the Ant preprocessing step that replaces
   the @name@ parts is not performed. This is for debugging in the Workbench.
*)
`Information`$VersionNumber = If[SyntaxQ["1.0"], ToExpression["1.0"], 0.0] 
`Information`$ReleaseNumber = If[SyntaxQ["0"], ToExpression["0"], 0]
`Information`$CreationID = If[SyntaxQ["20070420181712"], ToExpression["20070420181712"], 0]
`Information`$CreationDate = If[SyntaxQ["{2007,04,20,18,17,12}"], ToExpression["{2007,04,20,18,17,12}"], {0,0,0,0,0,0}]
`Information`$Version = "PacletManager Version 1.0.0"


(*******************  Read in the implementation files.  **********************)

`Package`$pmDir = DirectoryName[System`Private`FindFile[$Input]]


(* If we don't turn this message off, user will get shadowing warnings if a Global` symbol
   has the same name as any Package` symbols. It's not a valid warning, because Package`
   is never on ContextPath at the same time as Global`.
*)
`Private`wasOn = (Head[General::shdw] =!= $Off)
Off[General::shdw]

(* Make the Package` symbols visible to all implementation files. *)
AppendTo[$ContextPath, "PacletManager`Package`"]


Begin["`Private`"]

implementationFiles = 
	{
		ToFileName[{$pmDir, "Kernel"}, "Documentation.m"],
		ToFileName[{$pmDir, "Kernel"}, "Services.m"],
		ToFileName[{$pmDir, "Kernel"}, "Utils.m"],
		ToFileName[{$pmDir, "Kernel"}, "Packer.m"],
		ToFileName[{$pmDir, "Kernel"}, "Manager.m"]
	}

processDecls[file_] :=
	Module[{strm, e, moreLines = True},
		strm = OpenRead[file];
		If[Head[strm] =!= InputStream,
			Return[$Failed]
		];
		While[moreLines,
			e = Read[strm, Hold[Expression]];
			ReleaseHold[e];
			If[e === $Failed || MatchQ[e, Hold[_End]],
				moreLines = False
			]
		];
		Close[file]
	]

End[]  (* `Private` *)
	
(* Read the public and package-visibility exports from the implementation files. *)
`Private`processDecls /@ `Private`implementationFiles

(* Read in the code. *)
Get /@ `Private`implementationFiles


If[`Private`wasOn, On[General::shdw]]

EndPackage[]
