(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   2161584,      36430]
NotebookOptionsPosition[   1870254,      29560]
NotebookOutlinePosition[   2063494,      33929]
CellTagsIndexPosition[   2054593,      33673]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["AuthorTools",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Chapter"],

Cell[CellGroupData[{

Cell[TextData[{
 "What Is ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 "?"
}], "Section",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell[TextData[{
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " is an add-on package that simplifies the creation of technical books and \
articles in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The package contains functions to process notebooks for print or online \
publication. Using ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 ", you can:"
}], "Text",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell["create a table of contents", "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell["create an index", "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell["\<\
create a browser categories file (for adding information to the Help Browser)\
\
\>", "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell[TextData[{
 "create bilaterally formatted cells (for displaying examples of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calculations)"
}], "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell["find all differences between any two notebooks", "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell["\<\
extract all cells of a particular type and save them in a desired format\
\>", "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell["\<\
insert objects to display the current values of variables such as the date, \
time, and filename\
\>", "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell["set printing options such as headers and footers", "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell["\<\
Most of these operations can be done either on a single notebook or a set of \
notebooks that make up a project. For example, you can generate a unified \
index or table of contents for a book consisting of several notebooks.\
\>", "Text",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell[TextData[{
 "The ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package consists of about sixty functions and ten palettes. The palettes \
provide an easy point-and-click interface for performing most common tasks. \
However, advanced users might prefer to type and evaluate functions directly \
because some functions are not accessible from the palettes."
}], "Text",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell["The documentation is organized into three parts:", "Text",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell[TextData[{
 ButtonBox["Function Interface",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 "\[LongDash]explains how to use selected package functions."
}], "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell[TextData[{
 ButtonBox["Palette Interface",
  ButtonData:>"Using Palettes: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 "\[LongDash]explains how to perform common tasks using palettes."
}], "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}],

Cell[TextData[{
 ButtonBox["Reference Guide",
  ButtonData:>"NotebookFilePath",
  ButtonStyle->"AddOnsLinkText"],
 "\[LongDash]gives a description of each function along with its arguments \
and options."
}], "BulletedList",
 CellTags->{"i:54", "What Is AuthorTools?"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function Interface", "Section"],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->"FunctionsIntro"],

Cell[TextData[{
 "Most ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " functions require you to specify a notebook as the first argument. In \
general, you can specify a notebook either as a notebook object or a notebook \
file."
}], "Text",
 CellTags->"FunctionsIntro"],

Cell[CellGroupData[{

Cell["Notebook Objects", "Subsubsection",
 CellTags->{"FunctionsIntro", "i:55"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel refers to any open notebook via an expression of the form ",
 StyleBox["NotebookObject[", "MR"],
 StyleBox["fe", "TI"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["id", "TI"],
 StyleBox["]", "MR"],
 ", where ",
 StyleBox["fe", "TI"],
 " specifies the front end in which the notebook is open and ",
 StyleBox["id", "TI"],
 " is a unique serial number for the notebook."
}], "Text",
 CellTags->{"FunctionsIntro", "i:55"}],

Cell[TextData[{
 "The command ",
 StyleBox["Notebooks[]", "MR"],
 " returns a list of notebook objects corresponding to all notebooks \
currently open in the front end."
}], "Text",
 CellTags->{"FunctionsIntro", "i:55"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Notebooks", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellTags->{"FunctionsIntro", "i:55"}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     RowBox[{
     "\[LeftSkeleton]", "\<\"AuthorToolsGuide.nb\"\>", "\[RightSkeleton]"}], 
     "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["ParentLink", 1, 1]], 136],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     RowBox[{"\[LeftSkeleton]", "\<\"Messages\"\>", "\[RightSkeleton]"}], 
     "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["ParentLink", 1, 1]], 7],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellTags->{"FunctionsIntro", "i:55"}]
}, Open  ]],

Cell[TextData[{
 "This assigns the variable ",
 StyleBox["nb", "MR"],
 " to represent the first notebook object in the list."
}], "Text",
 CellTags->{"FunctionsIntro", "i:55"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nb", "=", 
  RowBox[{"%", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellTags->{"FunctionsIntro", "i:55"}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   RowBox[{
   "\[LeftSkeleton]", "\<\"AuthorToolsGuide.nb\"\>", "\[RightSkeleton]"}], 
   "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["ParentLink", 1, 1]], 136],
  Editable->False]], "Output",
 CellLabel->"Out[2]=",
 CellTags->{"FunctionsIntro", "i:55"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Files", "Subsubsection",
 CellTags->{"FunctionsIntro", "i:56"}],

Cell[TextData[{
 "Alternatively, you can identify a notebook by specifying the name and \
location of the notebook file. You can use the ",
 StyleBox["ToFileName", "MR"],
 " function to construct a string specifying the full ",
 "pathname",
 " of the file."
}], "Text",
 CellTags->{"FunctionsIntro", "i:56"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nb", "=", 
  RowBox[{"ToFileName", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "$InstallationDirectory", " ", ",", "\"\<AddOns\>\"", ",", 
      "\"\<Applications\>\"", ",", "\"\<AuthorTools\>\"", ",", 
      "\"\<Documentation\>\"", ",", "\"\<English\>\""}], "}"}], ",", 
    "\"\<AuthorToolsGuide.nb\>\""}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellTags->{"FunctionsIntro", "i:56"}],

Cell[BoxData["\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/AuthorTools/Documentation/English/\
AuthorToolsGuide.nb\"\>"], "Output",
 CellLabel->"Out[3]=",
 CellTags->{"FunctionsIntro", "i:56"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loading the Package", "Subsubsection",
 CellTags->{"FunctionsIntro", "i:57"}],

Cell[TextData[{
 "This loads the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package."
}], "Text",
 CellTags->{"FunctionsIntro", "i:57"}],

Cell[BoxData[
 RowBox[{"<<", "AuthorTools`"}]], "Input",
 CellLabel->"In[4]:=",
 CellTags->{"FunctionsIntro", "i:57"}],

Cell[TextData[{
 "You can then use the symbol ",
 StyleBox["nb", "MR"],
 " as an argument to any notebook function."
}], "Text",
 CellTags->{"FunctionsIntro", "i:57"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookName", "[", "nb", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellTags->{"FunctionsIntro", "i:57"}],

Cell[BoxData["\<\"AuthorToolsGuide.nb\"\>"], "Output",
 CellLabel->"Out[5]=",
 CellTags->{"FunctionsIntro", "i:57"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Processing Multiple Notebooks", "Subsubsection",
 CellTags->{"FunctionsIntro", "i:58"}],

Cell[TextData[{
 "You can use ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " functions to process either a single notebook or multiple notebooks in the \
directory."
}], "Text",
 CellTags->{"FunctionsIntro", "i:58"}],

Cell[TextData[StyleBox["To process a single notebook:", "TB"]], "Text",
 CellTags->{"FunctionsIntro", "i:58"}],

Cell["\<\
Specify the notebook as the first argument of the function you want to use.\
\>", "IndentedText",
 CellTags->{"FunctionsIntro", "i:58"}],

Cell[TextData[{
 "In general, a function that acts on notebooks can accept either a notebook \
object or a notebook file as the first argument. The exceptions are those \
functions that act on the current selection in an open notebook, for example, \
",
 StyleBox["HorizontalInsertionPointQ", "MR"],
 ", ",
 StyleBox["AddIndexEntry", "MR"],
 ", ",
 StyleBox["SelectionRemoveCellTags", "MR"],
 ", or ",
 StyleBox["IndexCellOnSelection", "MR"],
 ". These functions can accept a notebook object as the first argument but \
not a notebook file."
}], "Text",
 CellTags->{"FunctionsIntro", "i:58"}],

Cell[TextData[StyleBox["To process multiple notebooks:", "TB"]], "Text",
 CellTags->{"FunctionsIntro", "i:58"}],

Cell[TextData[{
 "Create a project file that lists all the notebooks you ",
 "want",
 " to process. (See ",
 ButtonBox["Creating a Project File",
  ButtonData:>"Creating a Project File",
  ButtonStyle->"AddOnsLinkText"],
 " for more information.)"
}], "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"FunctionsIntro", "i:58"}],

Cell["\<\
Specify the project file as the first argument of the function you want to \
use. Alternatively, load the project file using the MakeProject dialog box, \
then use the notebook object corresponding to the dialog box as the argument \
of the function. \
\>", "ItemizedList",
 CellTags->{"FunctionsIntro", "i:58"}],

Cell[TextData[{
 "In general, a function that accepts a notebook file will also accept a \
project file. The exceptions are those functions that are only defined for a \
single notebook and hence cannot be applied to a project, for example, ",
 StyleBox["NotebookName", "MR"],
 ", ",
 StyleBox["NotebookFolder", "MR"],
 ", ",
 StyleBox["NotebookCellTags", "MR"],
 ", or ",
 StyleBox["NotebookFileOptions", "MR"],
 ". These functions can accept a notebook file as the first argument but not \
a project file."
}], "Text",
 CellTags->{"FunctionsIntro", "i:58"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General Notebook Manipulation", "Subsection",
 CellTags->"General Notebook Manipulation"],

Cell[CellGroupData[{

Cell["Getting Notebook Information", "Subsubsection",
 CellTags->"Getting Notebook Information"],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variable ",
 StyleBox["nb", "MR"],
 " to represent the notebook you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " for more information.)"
}], "Text",
 CellTags->"Getting Notebook Information"],

Cell["This gives the full pathname of the notebook object.", "Text",
 CellTags->"Getting Notebook Information"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookFilePath", "[", "nb", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellTags->"Getting Notebook Information"],

Cell[BoxData["\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/AuthorTools/Documentation/English/\
AuthorToolsGuide.nb\"\>"], "Output",
 CellLabel->"Out[6]=",
 CellTags->"Getting Notebook Information"]
}, Open  ]],

Cell["This gives the name of the notebook.", "Text",
 CellTags->"Getting Notebook Information"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookName", "[", "nb", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellTags->"Getting Notebook Information"],

Cell[BoxData["\<\"AuthorToolsGuide.nb\"\>"], "Output",
 CellLabel->"Out[7]=",
 CellTags->"Getting Notebook Information"]
}, Open  ]],

Cell["This gives the directory in which the notebook is located.", "Text",
 CellTags->"Getting Notebook Information"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookFolder", "[", "nb", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellTags->"Getting Notebook Information"],

Cell[BoxData["\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/AuthorTools/Documentation/English/\"\>"], "Output",\

 CellLabel->"Out[8]=",
 CellTags->"Getting Notebook Information"]
}, Open  ]],

Cell["This gives all front end options set in the notebook.", "Text",
 CellTags->"Getting Notebook Information"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookFileOptions", "[", "nb", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellTags->"Getting Notebook Information"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FrontEndVersion", "\[Rule]", "\<\"6.0 for Macintosh\"\>"}], ",", 
   RowBox[{"ScreenRectangle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1112"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "746"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ScreenStyleEnvironment", "\[Rule]", "\<\"Brackets\"\>"}], ",", 
   RowBox[{
   "PrintingStyleEnvironment", "\[Rule]", "\<\"EnhancedPrintout\"\>"}], ",", 
   RowBox[{"WindowToolbars", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"WindowSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"644", ",", "719"}], "}"}]}], ",", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "14"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PrintingCopies", "\[Rule]", "1"}], ",", 
   RowBox[{"PrintingPageRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"PrintingOptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"GraphicsPrintingFormat\"\>", 
      "\[Rule]", "\<\"RenderInFrontEnd\"\>"}], "}"}]}], ",", 
   RowBox[{"DefaultNewCellStyle", "\[Rule]", "\<\"Text\"\>"}], ",", 
   RowBox[{"Magnification", "\[Rule]", "1"}], ",", 
   RowBox[{"StyleDefinitions", "\[Rule]", "\<\"HelpBrowser.nb\"\>"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellTags->"Getting Notebook Information"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["NotebookFilePath",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["nb",
       "TI"], 
      StyleBox["]",
       "MR"]}], Cell[TextData[StyleBox[
     "the full path to the specified notebook",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {
     RowBox[{
      StyleBox["NotebookName",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["nb",
       "TI"], 
      StyleBox["]",
       "MR"]}], Cell[TextData[{
      StyleBox["the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      "filename",
      StyleBox[" of the specified notebook",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {
     RowBox[{
      StyleBox["NotebookFolder",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["nb",
       "TI"], 
      StyleBox["]",
       "MR"]}], Cell[TextData[StyleBox[
     "the directory of the specified notebook",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"Getting Notebook Information"],

Cell["Some notebook functions.", "Caption",
 CellTags->"Getting Notebook Information"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using the Notebook Cache", "Subsubsection",
 CellTags->"Using the Notebook Cache"],

Cell["\<\
Any notebook file created in the front end has a cache that contains \
information about the notebook\[CloseCurlyQuote]s cell structure. The cache \
appears at the end of the notebook file and can be inspected by opening the \
notebook in a text editor.\
\>", "Text",
 CellTags->"Using the Notebook Cache"],

Cell["\<\
The notebook\[CloseCurlyQuote]s cache contains information on the position, \
style, grouping, and size of each cell. When you open an existing notebook, \
the front end uses the information in the cache to read into memory only \
those cells that need to be displayed on the screen. This reduces the memory \
and time required to read and render a notebook since the entire notebook \
does not have to be read into memory at once.\
\>", "Text",
 CellTags->"Using the Notebook Cache"],

Cell["\<\
The main component of the cache is a notebook file outline. This has the same \
form as the notebook expression describing the notebook but with each cell \
expression replaced by a condensed version. Instead of the actual contents of \
the cell, the condensed expression contains information on the cell\
\[CloseCurlyQuote]s position in the notebook and the number of bytes of data \
it contains.\
\>", "Text",
 CellTags->"Using the Notebook Cache"],

Cell[TextData[{
 "Each condensed expression is of the form ",
 StyleBox["Cell[", "MR"],
 StyleBox["a", "TI"],
 StyleBox[",", "MR"],
 StyleBox[" ", "TR"],
 StyleBox["b", "TI"],
 StyleBox[",", "MR"],
 StyleBox[" ", "TR"],
 StyleBox["c", "TI"],
 StyleBox[",", "MR"],
 StyleBox[" ", "TR"],
 StyleBox["d", "TI"],
 StyleBox[",", "MR"],
 StyleBox[" ", "TR"],
 StyleBox["e", "TI"],
 StyleBox[",", "MR"],
 StyleBox[" ", "TR"],
 StyleBox["rules", "TI"],
 StyleBox[",", "MR"],
 StyleBox[" ", "TR"],
 StyleBox["string", "TI"],
 StyleBox["]", "MR"],
 ". The parameters ",
 StyleBox["a", "TI"],
 " through ",
 StyleBox["e", "TI"],
 " are integers and denote the following:"
}], "Text",
 CellTags->"Using the Notebook Cache"],

Cell[TextData[{
 StyleBox["a", "TI"],
 " = stream position of the cell expression, counting all newlines as 1 byte \
long"
}], "IndentedText",
 CellTags->"Using the Notebook Cache"],

Cell[TextData[{
 StyleBox["b", "TI"],
 " = number of newlines in the file before the cell expression"
}], "IndentedText",
 CellTags->"Using the Notebook Cache"],

Cell[TextData[{
 StyleBox["c", "TI"],
 " = length of the cell expression in bytes, counting all newlines as 1 byte \
long"
}], "IndentedText",
 CellTags->"Using the Notebook Cache"],

Cell[TextData[{
 StyleBox["d", "TI"],
 " = number of newlines in the cell expression"
}], "IndentedText",
 CellTags->"Using the Notebook Cache"],

Cell[TextData[{
 StyleBox["e", "TI"],
 " = approximate pixel height in the cell (used in determining the full \
height of the notebook for purposes of scaling the scrollbar thumb)"
}], "IndentedText",
 CellTags->"Using the Notebook Cache"],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variable ",
 StyleBox["nb", "MR"],
 " to represent the notebook you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " for more information.)"
}], "Text",
 CellTags->"Using the Notebook Cache"],

Cell[TextData[{
 "You can view the file outline in a notebook\[CloseCurlyQuote]s cache using \
the ",
 StyleBox["NotebookFileOutline", "MR"],
 " function."
}], "Text",
 CellTags->"Using the Notebook Cache"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookFileOutline", "[", "nb", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellTags->"Using the Notebook Cache"],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{"{", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
         "1727", ",", "52", ",", "22", ",", "0", ",", "108", 
          ",", "\<\"Title\"\>"}], "]"}], ",", 
        RowBox[{"Cell", "[", 
         RowBox[{"CellGroupData", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cell", "[", 
              RowBox[{
              "1774", ",", "56", ",", "28", ",", "0", ",", "56", 
               ",", "\<\"Section\"\>"}], "]"}], ",", 
             RowBox[{"Cell", "[", 
              RowBox[{"CellGroupData", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Cell", "[", 
                   RowBox[{
                   "1827", ",", "60", ",", "34", ",", "0", ",", "46", 
                    ",", "\<\"Subsection\"\>"}], "]"}], ",", 
                  RowBox[{"Cell", "[", 
                   RowBox[{
                   "1864", ",", "62", ",", "27", ",", "0", ",", "30", 
                    ",", "\<\"Text\"\>"}], "]"}]}], "}"}], ",", "Open"}], 
               "]"}], "]"}], ",", 
             RowBox[{"Cell", "[", 
              RowBox[{
              "1906", ",", "65", ",", "34", ",", "0", ",", "46", 
               ",", "\<\"Subsection\"\>"}], "]"}]}], "}"}], ",", "Open"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Cell", "[", 
         RowBox[{
         "1955", ",", "68", ",", "28", ",", "0", ",", "56", 
          ",", "\<\"Section\"\>"}], "]"}]}], "}"}], ",", "Open"}], "]"}], 
    "]"}], "}"}], "]"}]], "Output",
 CellLabel->"Out[10]=",
 CellTags->"Using the Notebook Cache"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["NotebookLookup", "MR"],
 " function extracts information from the notebook file outline. With ",
 StyleBox["\"CellOutline\"", "MR"],
 " as the second argument of ",
 StyleBox["NotebookLookup", "MR"],
 ", you get a list of all the condensed cell expressions occurring in the \
notebook file outline."
}], "Text",
 CellTags->"Using the Notebook Cache"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookLookup", "[", 
  RowBox[{"nb", ",", " ", "\"\<CellOutline\>\""}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellTags->"Using the Notebook Cache"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{
    "1727", ",", "52", ",", "22", ",", "0", ",", "108", 
     ",", "\<\"Title\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{
    "1774", ",", "56", ",", "28", ",", "0", ",", "56", 
     ",", "\<\"Section\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{
    "1805", ",", "58", ",", "36", ",", "0", ",", "46", 
     ",", "\<\"Subsection\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{
    "1844", ",", "60", ",", "36", ",", "0", ",", "46", 
     ",", "\<\"Subsection\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{
    "1895", ",", "63", ",", "28", ",", "0", ",", "56", 
     ",", "\<\"Section\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{
    "1926", ",", "65", ",", "28", ",", "0", ",", "56", 
     ",", "\<\"Section\"\>"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[11]=",
 CellTags->"Using the Notebook Cache"]
}, Open  ]],

Cell[TextData[{
 "With ",
 StyleBox["\"CellExpression\"", "MR"],
 " as the second argument of ",
 StyleBox["NotebookLookup", "MR"],
 ", you get the complete cell expression for each cell in the notebook."
}], "Text",
 CellTags->"Using the Notebook Cache"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookLookup", "[", 
  RowBox[{"nb", ",", " ", "\"\<CellExpression\>\""}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellTags->"Using the Notebook Cache"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Title\"\>", ",", "\<\"Title\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Section 1\"\>", ",", "\<\"Section\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Subsection 1.1\"\>", ",", "\<\"Subsection\"\>"}], "]"}], ",",
    
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Subsection 1.2\"\>", ",", "\<\"Subsection\"\>"}], "]"}], ",",
    
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Section 2\"\>", ",", "\<\"Section\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Section 3\"\>", ",", "\<\"Section\"\>"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[12]=",
 CellTags->"Using the Notebook Cache"]
}, Open  ]],

Cell[TextData[{
 "With ",
 StyleBox["\"CellIndex\"", "MR"],
 " as the second argument of ",
 StyleBox["NotebookLookup", "MR"],
 ", you get the serial number of each cell in the notebook. The first cell in \
the notebook has serial number 1 and so on."
}], "Text",
 CellTags->"Using the Notebook Cache"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookLookup", "[", 
  RowBox[{"nb", ",", " ", "\"\<CellIndex\>\""}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellTags->"Using the Notebook Cache"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
  "}"}]], "Output",
 CellLabel->"Out[13]=",
 CellTags->"Using the Notebook Cache"]
}, Open  ]],

Cell[TextData[{
 "The two-argument form of ",
 StyleBox["NotebookLookup", "MR"],
 " simply generates a list of the form ",
 StyleBox["{1, 2, ...,", "MR"],
 StyleBox[" n", "TI"],
 StyleBox["}", "MR"],
 " for a notebook containing ",
 StyleBox["n", "TI"],
 " cells. The ",
 StyleBox["NotebookLookup", "MR"],
 " command becomes more useful if you use the optional third argument to \
specify a pattern. This allows you to extract information on all cells that \
fit the pattern. For example, the following command gives the serial number \
of all Section cells."
}], "Text",
 CellTags->"Using the Notebook Cache"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookLookup", "[", 
  RowBox[{"nb", ",", " ", "\"\<CellIndex\>\"", ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"___", ",", "\"\<Section\>\"", ",", "___"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellTags->"Using the Notebook Cache"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "14", ",", "245", ",", "385"}], "}"}]], "Output",
 CellLabel->"Out[14]=",
 CellTags->"Using the Notebook Cache"]
}, Open  ]],

Cell["\<\
The following command returns the cell expressions of all Section cells.\
\>", "Text",
 CellTags->"Using the Notebook Cache"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookLookup", "[", 
  RowBox[{"nb", ",", " ", "\"\<CellExpression\>\"", ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"___", ",", "\"\<Section\>\"", ",", "___"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellTags->"Using the Notebook Cache"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"What Is AuthorTools?\"\>", ",", "\<\"Section\"\>", ",", 
     RowBox[{"CellTags", "\[Rule]", "\<\"What is AuthorTools?\"\>"}]}], "]"}],
    ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Packages\"\>", ",", "\<\"Section\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Functions List\"\>", ",", "\<\"Section\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Palettes\"\>", ",", "\<\"Section\"\>"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[15]=",
 CellTags->"Using the Notebook Cache"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["NotebookFileOutline",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["nb",
       "TI"], 
      StyleBox["]",
       "MR"]}], Cell[TextData[StyleBox[
     "returns the notebook file outline cache for the specified notebook",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {
     RowBox[{
      StyleBox["NotebookLookup",
       "MR"], 
      StyleBox["[",
       "MR"], 
      RowBox[{
       StyleBox["nb",
        "TI"], 
       StyleBox[",",
        "MR"], 
       StyleBox[
        RowBox[{" ", "obj"}],
        "TI"]}], 
      StyleBox["]",
       "MR"]}], Cell[TextData[{
      StyleBox["returns the objects specified by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["obj", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the specified notebook",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {
     RowBox[{
      StyleBox["NotebookLookup",
       "MR"], 
      StyleBox["[",
       "MR"], 
      RowBox[{
       StyleBox["nb",
        "TI"], 
       StyleBox[",",
        "MR"], 
       StyleBox[
        RowBox[{" ", "obj"}],
        "TI"], 
       StyleBox[",",
        "MR"], 
       StyleBox[
        RowBox[{" ", "pat"}],
        "TI"]}], 
      StyleBox["]",
       "MR"]}], Cell[TextData[{
      Cell[BoxData[
       FormBox[Cell[TextData[Cell[BoxData[
         FormBox[
          StyleBox[
           RowBox[{
           "returns", " ", "the", " ", "objects", " ", "specified", " ", "by",
             " ", 
            StyleBox["obj",
             "TI"], 
            StyleBox[" ",
             "TI"], "that", " ", "match", " ", "the", " ", "pattern", " ", 
            StyleBox["pat",
             "TI"], " ", "in", " ", "the", " ", "specified", " ", 
            "notebook"}],
           GridBoxOptions->{RowLines->False,
           RowSpacings->0.4}], TraditionalForm]]]],
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}], TraditionalForm]],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NotebookFileOptions[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nb", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[
     "the front end options set in the specified notebook"]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"Using the Notebook Cache"],

Cell["\<\
Some functions that provide information about a notebook\[CloseCurlyQuote]s \
contents.\
\>", "Caption",
 CellTags->"Using the Notebook Cache"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Adding and Removing Cell Tags", "Subsubsection",
 CellTags->"Adding and Removing Cell Tags"],

Cell[TextData[{
 "A cell tag is a string that serves as a tag or marker to identify a \
specific cell in a notebook. Cell tags are used, for example, to define the \
targets of hyperlinks or to identify the information that appears when you \
click a topic in the Help Browser. ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " includes functions for adding or removing cell tags in a notebook."
}], "Text",
 CellTags->"Adding and Removing Cell Tags"],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variable ",
 StyleBox["nb", "MR"],
 " to represent the notebook you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " for more information.)"
}], "Text",
 CellTags->"Adding and Removing Cell Tags"],

Cell[TextData[{
 StyleBox["NotebookCellTags", "MR"],
 " returns a list of all cell tags in the specified notebook. The ",
 StyleBox["n", "TI"],
 "th element of the output list is a list of all cell tags for the ",
 StyleBox["n", "TI"],
 "th cell in the notebook. Each cell that does not have a cell tag is \
represented by an empty list."
}], "Text",
 CellTags->"Adding and Removing Cell Tags"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookCellTags", "[", "nb", "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellTags->"Adding and Removing Cell Tags"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[16]=",
 CellTags->"Adding and Removing Cell Tags"]
}, Open  ]],

Cell[TextData[{
 "You can add cell tags to cells in a notebook using ",
 StyleBox["AddCellTags", "MR"],
 "."
}], "Text",
 CellTags->"Adding and Removing Cell Tags"],

Cell[TextData[{
 "You can remove cell tags from cells in a notebook using ",
 StyleBox["RemoveCellTags", "MR"],
 "."
}], "Text",
 CellTags->"Adding and Removing Cell Tags"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["AddCellTags",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["nb",
       "TI"], 
      StyleBox["]",
       "MR"]}], Cell[TextData[{
      StyleBox[
      "adds the string or list of strings to the cell tags of the currently \
selected cell(s) in the notebook object ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nb", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {
     RowBox[{
      StyleBox["RemoveCellTags",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox[
       RowBox[{"nb", ",", " ", "pat"}],
       "TI"], 
      StyleBox["]",
       "MR"]}], Cell[TextData[{
      StyleBox["removes all cell tags from the notebook object ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nb", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" that match the string pattern ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {
     RowBox[{
      StyleBox["SelectionRemoveCellTags",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox[
       RowBox[{"nb", ",", " ", "tags"}],
       "TI"], 
      StyleBox["]",
       "MR"]}], Cell[TextData[{
      StyleBox[
      "removes the specified tag or list of tags from the currently selected \
cell(s) in the notebook object ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nb", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NotebookCellTags[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nb", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], 
     RowBox[{"returns", " ", 
      StyleBox["a",
       FontSlant->"Plain"], " ", "list", " ", "of", " ", "all", " ", "the", 
      " ", "cell", " ", "tags", " ", "present", " ", "in", " ", "the", " ", 
      "notebook", " ", "object", " ", 
      StyleBox["nb",
       "TI"]}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"Adding and Removing Cell Tags"],

Cell["Some functions for adding and removing cell tags.", "Caption",
 CellTags->"Adding and Removing Cell Tags"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Processing Multiple Notebooks", "Subsection",
 CellTags->"Processing Multiple Notebooks"],

Cell[CellGroupData[{

Cell["Creating a Project File", "Subsubsection",
 CellTags->{
 "Project File: Creating", "Processing Multiple Notebooks", "i:59"}],

Cell["\<\
The first step in processing multiple notebooks is to create a project file. \
This is a file that specifies the names and location of all notebooks in a \
project. You will need to create a different project file for each project \
you are working on.\
\>", "Text",
 CellTags->{
 "Project File: Creating", "Processing Multiple Notebooks", "i:59"}],

Cell[TextData[{
 "A project file is a plain text file with a ",
 StyleBox[".m", "MR"],
 " suffix. The file must include data in the following format."
}], "Text",
 CellTags->{
 "Project File: Creating", "Processing Multiple Notebooks", "i:59"}],

Cell[TextData[{
 StyleBox["{\"Name\" -> ", "MR"],
 StyleBox["name", "TI"],
 StyleBox[",\n\"Directory\" -> ", "MR"],
 StyleBox["directory", "TI"],
 StyleBox[",\n\"Files\" -> {", "MR"],
 StyleBox["nb1", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["nb2", "TI"],
 StyleBox[",...}}", "MR"]
}], "FramedBox",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{
 "Project File: Creating", "Processing Multiple Notebooks", "i:59"}],

Cell[TextData[{
 "Here ",
 StyleBox["name", "TI"],
 " is the name of the project, ",
 StyleBox["directory", "TI"],
 " is the full ",
 "pathname",
 " of the project directory, and ",
 StyleBox["{", "MR"],
 StyleBox["nb1", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["nb2", "TI"],
 StyleBox[",...}", "MR"],
 " is a list of all notebooks that make up the project."
}], "Text",
 CellTags->{
 "Project File: Creating", "Processing Multiple Notebooks", "i:59"}],

Cell["There are several different ways to create a project file:", "Text",
 CellTags->{
 "Project File: Creating", "Processing Multiple Notebooks", "i:59"}],

Cell[TextData[{
 "Enter the project data in the text fields of the MakeProject dialog box. \
(See ",
 ButtonBox["Make Project",
  ButtonData:>"Make Project: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " for details.)"
}], "BulletedList",
 CellTags->{
 "Project File: Creating", "Processing Multiple Notebooks", "i:59"}],

Cell[TextData[{
 "Use the command ",
 StyleBox["WriteProjectData[", "MR"],
 StyleBox["file", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["data", "TI"],
 StyleBox["]", "MR"],
 ", where ",
 StyleBox["data", "TI"],
 " specifies the project data in the list format shown in the preceding box."
}], "BulletedList",
 CellTags->{
 "Project File: Creating", "Processing Multiple Notebooks", "i:59"}],

Cell[TextData[{
 "Type the project data directly into a text file and save the file with a ",
 StyleBox[".m", "MR"],
 " suffix."
}], "BulletedList",
 CellTags->{
 "Project File: Creating", "Processing Multiple Notebooks", "i:59"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using a Project File", "Subsubsection",
 CellTags->{"Project File: Using", "Processing Multiple Notebooks", "i:60"}],

Cell[TextData[{
 "Once you have created a project file, you can process all notebooks in the \
project in one step. To do this you simply specify the project file as the \
argument to the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " function you ",
 "want",
 " to use."
}], "Text",
 CellTags->{"Project File: Using", "Processing Multiple Notebooks", "i:60"}],

Cell[TextData[{
 "For example, to generate a table of contents for a project, you can \
evaluate the command, ",
 StyleBox["MakeContents[", "MR"],
 StyleBox["projectfile", "TI"],
 StyleBox[",\"Book\"]", "MR"],
 ". The command for generating a table of contents for a single notebook is \
",
 StyleBox["MakeContents[", "MR"],
 StyleBox["nb", "TI"],
 StyleBox[",\"Book\"]", "MR"],
 "."
}], "Text",
 CellTags->{"Project File: Using", "Processing Multiple Notebooks", "i:60"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Editing a Project File", "Subsubsection",
 CellTags->{"Project File: Editing", "Processing Multiple Notebooks", "i:61"}],

Cell[TextData[{
 "When you evaluate an ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " function with a project file as an argument, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses ",
 StyleBox["Get", "MR"],
 " to read in the project file. Any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands present in the project file are evaluated at this time. Thus, the \
project file is a convenient place to store commands that you ",
 "want",
 " to apply to a project."
}], "Text",
 CellTags->{"Project File: Editing", "Processing Multiple Notebooks", "i:61"}],

Cell["\<\
For example, suppose you prepend the following command to the contents of \
your project file.\
\>", "Text",
 CellTags->{"Project File: Editing", "Processing Multiple Notebooks", "i:61"}],

Cell[TextData[StyleBox["Needs[\"AuthorTools`MakeContents`\"];\n  \
SetOptions[MakeContents,\n    SelectedCellStyles -> {\"Chapter\", \
\"Heading\", \"Subheading\"}];", "MR"]], "FramedBox",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Project File: Editing", "Processing Multiple Notebooks", "i:61"}],

Cell[TextData[{
 "This sets the option ",
 StyleBox["SelectedCellStyles", "MR"],
 " of the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " function ",
 StyleBox["MakeContents", "MR"],
 ". If you then use ",
 StyleBox["MakeContents", "MR"],
 " to create a table of contents for that project, the option setting \
specified in the project file will be automatically used, overriding the \
default behavior of ",
 StyleBox["MakeContents", "MR"],
 "."
}], "Text",
 CellTags->{"Project File: Editing", "Processing Multiple Notebooks", "i:61"}],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " Any commands you have added to a project file will be overwritten if you \
use the ",
 StyleBox["WriteProjectData", "MR"],
 " function or the MakeProject dialog box to modify the project file."
}], "Text",
 CellTags->{"Project File: Editing", "Processing Multiple Notebooks", "i:61"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating a Table of Contents", "Subsection",
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variable ",
 StyleBox["nb", "MR"],
 " to represent the notebook you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " for more information.)"
}], "Text",
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell["\<\
This generates a table of contents for the notebook. The table of contents is \
saved in the same directory as the source notebook. \
\>", "Text",
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell[TextData[StyleBox["MakeContents[nb,\"Simple\"]", "MR"]], "FramedBox",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell[TextData[{
 "The second argument of the function specifies the format of the table of \
contents. You can choose from three different formats: ",
 StyleBox["\"Simple\"", "MR"],
 ", ",
 StyleBox["\"Book\"", "MR"],
 ", or ",
 StyleBox["\"BookCondensed\"", "MR"],
 ". (See ",
 ButtonBox["Make Contents",
  ButtonData:>"Make Contents: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " for more information on these formats.)"
}], "Text",
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " The ",
 StyleBox["MakeContents", "MR"],
 " command inserts cell tags into the source notebook and automatically saves \
the changes. If you do not want your source notebook modified, you should \
keep a separate copy as a backup."
}], "Text",
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell[TextData[{
 "If you are going to generate a table of contents in any format other than \
",
 StyleBox["Simple", "MR"],
 ", you should first use ",
 StyleBox["Paginate", "MR"],
 ". This function calculates the page numbers for the specified notebook and \
stores them as ",
 StyleBox["TaggingRules", "MR"],
 " in the notebook."
}], "Text",
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell[TextData[{
 "Paginate[",
 StyleBox["nb", "TR",
  FontSlant->"Italic"],
 "]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell[TextData[{
 "The following command generates a table of contents in the ",
 StyleBox["Book", "MR"],
 " format."
}], "Text",
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell["MakeContents[nb,\"Book\"]", "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell[TextData[{
 "The option ",
 StyleBox["SelectedCellStyles", "MR"],
 " determines which cells in the notebook are included in the table of \
contents. The default setting is ",
 StyleBox["SelectedCellStyles", "MR"],
 " ",
 StyleBox["\[Rule]", "MR"],
 " ",
 StyleBox["{\"Title\", \"Section\", \"Subsection\", \"Subsubsection\"}", 
  "MR"],
 ". The following command generates a table of contents in the ",
 StyleBox["Book", "MR"],
 " format that includes only title, section, and subsection cells."
}], "Text",
 CellTags->{"Creating a Table of Contents", "i:62"}],

Cell["\<\
MakeContents[nb,\"Book\",SelectedCellStyles \[Rule] {\"Title\", \"Section\", \
\"Subsection\"}]\
\>", "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Creating a Table of Contents", "i:62"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating an Index", "Subsection",
 CellTags->{"Creating an Index", "i:63"}],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variable ",
 StyleBox["nb", "MR"],
 " to represent the notebook you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " to see how to do this.)"
}], "Text",
 CellTags->{"Creating an Index", "i:63"}],

Cell["There are two steps involved in setting up an index.", "Text",
 CellTags->{"Creating an Index", "i:63"}],

Cell["\<\
Associate index entries with specific cells in your source notebook.\
\>", "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Creating an Index", "i:63"}],

Cell[TextData[{
 "The simplest way to insert index entries is using the Edit Notebook Index \
dialog box, accessed from the ",
 ButtonBox["MakeIndex",
  ButtonData:>"Make Index: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " palette. Alternatively, you can type and evaluate the ",
 StyleBox["AddIndexEntry", "MR"],
 " function. The following command associates the specified main entry and \
subentry with the currently selected cell(s) in the notebook."
}], "ListNote",
 CellTags->{"Creating an Index", "i:63"}],

Cell[TextData[{
 "AddIndexEntry[",
 StyleBox["nb", "TR",
  FontSlant->"Italic"],
 ", {",
 StyleBox["main", "TI"],
 ", ",
 StyleBox["sub", "TI"],
 "}]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Creating an Index", "i:63"}],

Cell[TextData[{
 "Generate the index using the ",
 StyleBox["MakeIndex", "MR"],
 " function."
}], "ItemizedList",
 CellTags->{"Creating an Index", "i:63"}],

Cell["This generates an index for the notebook.", "ListNote",
 CellTags->{"Creating an Index", "i:63"}],

Cell[TextData[{
 "MakeIndex[",
 StyleBox["nb", "TR",
  FontSlant->"Italic"],
 ",\"Simple\"]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Creating an Index", "i:63"}],

Cell[TextData[{
 "The second argument of ",
 StyleBox["MakeIndex", "MR"],
 " specifies the format of the index. You can choose from four different \
formats: ",
 StyleBox["\"Simple\"", "MR"],
 ", ",
 StyleBox["\"Book\"", "MR"],
 ", ",
 StyleBox["\"TwoColumn\"", "MR"],
 ", or ",
 StyleBox["\"BrowserIndex\"", "MR"],
 ". (See ",
 ButtonBox["Make Index",
  ButtonData:>"Make Index: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " for more information on these formats.)"
}], "Text",
 CellTags->{"Creating an Index", "i:63"}],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " The ",
 StyleBox["MakeIndex", "MR"],
 " command inserts cell tags into the source notebook and automatically saves \
the changes. If you do not want your source notebook modified, you should \
keep a separate copy as a ",
 "backup",
 "."
}], "Text",
 CellTags->{"Creating an Index", "i:63"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finding Differences", "Subsection",
 CellTags->"Finding Differences"],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variables ",
 StyleBox["nb1", "MR"],
 " and ",
 StyleBox["nb2", "MR"],
 " to represent the notebooks you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " for more information.)"
}], "Text",
 CellTags->"Finding Differences"],

Cell[TextData[{
 "This generates a notebook that lists the differences between the two \
notebooks, ",
 StyleBox["nb1", "TR",
  FontSlant->"Italic"],
 " and ",
 StyleBox["nb2.", "TR",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellTags->"Finding Differences"],

Cell[TextData[{
 "NotebookDiff[",
 StyleBox["nb1", "TR",
  FontSlant->"Italic"],
 ",",
 StyleBox["nb2", "TR",
  FontSlant->"Italic"],
 "]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->"Finding Differences"],

Cell[TextData[{
 StyleBox["NotebookDiff",
  FontFamily->"Courier"],
 " will also find the differences between two projects, directories, or lists \
of files. This generates a notebook that summarizes the differences in the \
two sets of notebooks."
}], "Text",
 CellTags->"Finding Differences"],

Cell[TextData[{
 "NotebookDiff[",
 StyleBox["project1", "TR",
  FontSlant->"Italic"],
 ", ",
 StyleBox["project2", "TR",
  FontSlant->"Italic"],
 "]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->"Finding Differences"],

Cell[TextData[{
 "By default, ",
 StyleBox["NotebookDiff", "MR"],
 " finds all possible differences between the notebooks, including \
differences in cell styles or options. However, you can narrow the scope of \
differences reported by ",
 StyleBox["NotebookDiff", "MR"],
 " by specifying options. For example, this excludes cells in the Input and \
Output style from the diffing operation. "
}], "Text",
 CellTags->"Finding Differences"],

Cell[TextData[{
 "NotebookDiff[",
 StyleBox["nb1", "TR",
  FontSlant->"Italic"],
 ",",
 StyleBox["nb2", "TR",
  FontSlant->"Italic"],
 ", ExcludeCellsOfStyles\[Rule] {\"Input\",\"Output\"}]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->"Finding Differences"],

Cell[TextData[{
 "There are several other options to ",
 StyleBox["NotebookDiff", "MR"],
 ", for example, to ignore cells that have the same content but differ only \
in their cell style or only in their options. "
}], "Text",
 CellTags->"Finding Differences"],

Cell[TextData[{
 "To view the differences within two different cells, use ",
 StyleBox["CellDiff",
  FontFamily->"Courier"],
 ". This highlights the differences in content by enclosing them in colored \
brackets of the form (",
 StyleBox["\[LeftAngleBracket]",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 1, 0]],
 " and ",
 StyleBox["\[RightAngleBracket]",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 1, 0]],
 "). Style and option differences are also listed."
}], "Text",
 CellTags->"Finding Differences"],

Cell[TextData[{
 "CellDiff[",
 StyleBox["cell1", "TR",
  FontSlant->"Italic"],
 ", ",
 StyleBox["cell2", "TR",
  FontSlant->"Italic"],
 "]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->"Finding Differences"],

Cell[TextData[{
 "If the notebooks you are comparing are stylesheets, you can either use ",
 StyleBox["NotebookDiff",
  FontFamily->"Courier"],
 " or a more specialized version called ",
 StyleBox["StyleSheetDiff", "MR"],
 "."
}], "Text",
 CellTags->"Finding Differences"],

Cell[TextData[{
 "StyleSheetDiff[",
 StyleBox["nb1", "TR",
  FontSlant->"Italic"],
 ",",
 StyleBox["nb2", "TR",
  FontSlant->"Italic"],
 "]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->"Finding Differences"],

Cell[TextData[{
 StyleBox["NotebookDiff",
  FontFamily->"Courier"],
 " and ",
 StyleBox["StyleSheetDiff",
  FontFamily->"Courier"],
 " are both implemented in terms of a lower-level function called ",
 StyleBox["DiffReport",
  FontFamily->"Courier"],
 ". This compares two generic lists, creating a report of all the insertions, \
deletions, and updates between the two lists."
}], "Text",
 CellTags->"Finding Differences"],

Cell[TextData[{
 "DiffReport[",
 StyleBox["list1", "TR",
  FontSlant->"Italic"],
 ",",
 StyleBox["list2", "TR",
  FontSlant->"Italic"],
 "]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->"Finding Differences"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Restoring a Notebook", "Subsection",
 CellTags->"Restoring a Notebook"],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variables ",
 StyleBox["nb1", "MR"],
 " and ",
 StyleBox["nb2", "MR"],
 " to represent the notebooks you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " for more information.)"
}], "Text",
 CellTags->"Restoring a Notebook"],

Cell[CellGroupData[{

Cell["NotebookRestore", "Subsubsection",
 CellTags->"Restoring a Notebook"],

Cell[TextData[{
 StyleBox["NotebookRestore", "MR"],
 " takes a notebook containing one or more syntax errors and creates a new \
notebook containing all the cells that did not have a syntax error. For \
example, suppose ",
 StyleBox["nbFile", "MR"],
 " represents a notebook file that has been corrupted by removing one quote \
from a cell style name. If you try to open this file, the front end will \
report a syntax error and suggest you cancel the open operation."
}], "Text",
 CellTags->"Restoring a Notebook"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nbObj", " ", "=", " ", 
  RowBox[{"NotebookOpen", "[", "nbFile", "]"}]}]], "Input",
 CellTags->"Restoring a Notebook"],

Cell[BoxData["$Failed"], "Output",
 CellTags->"Restoring a Notebook"]
}, Open  ]],

Cell[TextData[{
 "Using ",
 StyleBox["NotebookRestore", "MR"],
 ", you can at least access those cells in the notebook that are not \
corrupted. ",
 StyleBox["NotebookRestore", "MR"],
 " will open a new notebook window containing all the good cells from the \
given notebook file and insert an indicator at each place where notebook data \
has been deleted."
}], "Text",
 CellTags->"Restoring a Notebook"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRestore", "[", "nbFile", "]"}]], "Input",
 CellTags->"Restoring a Notebook"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   RowBox[{"\[LeftSkeleton]", "\<\"Untitled-1\"\>", "\[RightSkeleton]"}], 
   "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["ParentLink", 1, 1]], 13]]], "Output",
 CellTags->"Restoring a Notebook"]
}, Open  ]],

Cell[TextData[{
 "Instead of deleting the corrupt data, you can display it verbatim within \
the indicator by setting the option ",
 StyleBox["DeleteCorruptCells \[Rule] False", "MR"],
 "."
}], "Text",
 CellTags->"Restoring a Notebook"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nbObj", "=", 
  RowBox[{"NotebookRestore", "[", 
   RowBox[{"nbFile", ",", 
    RowBox[{"DeleteCorruptCells", " ", "\[Rule]", " ", "False"}]}], 
   "]"}]}]], "Input",
 CellTags->"Restoring a Notebook"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   RowBox[{"\[LeftSkeleton]", "\<\"Untitled-2\"\>", "\[RightSkeleton]"}], 
   "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["ParentLink", 1, 1]], 15]]], "Output",
 CellTags->"Restoring a Notebook"]
}, Open  ]],

Cell[TextData[{
 "All the corrupt cell indicators have the cell tag \"Corrupt\", so you can \
easily highlight them by choosing ",
 StyleBox["Corrupt", "SR"],
 " from the list of cell tags displayed under the ",
 StyleBox["Find \[RightTriangle] Cell Tags", "SR"],
 " menu. Alternatively, you can walk through each indicator one by one using \
the ",
 StyleBox["NextCorruptCell", "MR"],
 " function."
}], "Text",
 CellTags->"Restoring a Notebook"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextCorruptCell", "[", "nbObj", "]"}]], "Input",
 CellTags->"Restoring a Notebook"],

Cell[BoxData[
 RowBox[{"NotebookSelection", "[", 
  InterpretationBox[
   RowBox[{"NotebookObject", "[", 
    RowBox[{"\[LeftSkeleton]", "\<\"Untitled-4\"\>", "\[RightSkeleton]"}], 
    "]"}],
   NotebookObject[
    FrontEndObject[
     LinkObject["ParentLink", 1, 1]], 17]], "]"}]], "Output",
 CellTags->"Restoring a Notebook"]
}, Open  ]],

Cell[TextData[{
 "If your notebook contains large graphics cells or large blocks of \
typesetting, it may take a long time for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to read in the expression and try to determine if it contains any syntax \
errors. For that reason, there are options that allow you to skip over \
graphics and/or typeset cells without processing them."
}], "Text",
 CellTags->"Restoring a Notebook"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "NotebookRestore", "]"}]], "Input",
 CellTags->"Restoring a Notebook"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DeleteCorruptCells", "\[RuleDelayed]", "$DeleteCorruptCells"}], 
   ",", 
   RowBox[{"DeleteGraphicsCells", "\[RuleDelayed]", "$DeleteGraphicsCells"}], 
   ",", 
   RowBox[{"DeleteTypesetCells", "\[RuleDelayed]", "$DeleteTypesetCells"}]}], 
  "}"}]], "Output",
 CellTags->"Restoring a Notebook"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRestore", "[", 
  RowBox[{"nbFile", ",", 
   RowBox[{"DeleteTypesetCells", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"Restoring a Notebook"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   RowBox[{"\[LeftSkeleton]", "\<\"Untitled-3\"\>", "\[RightSkeleton]"}], 
   "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["ParentLink", 1, 1]], 17]]], "Output",
 CellTags->"Restoring a Notebook"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SalvageCells", "Subsubsection",
 CellTags->"Restoring a Notebook"],

Cell[TextData[{
 StyleBox["SalvageCells", "MR"],
 " is a non-interactive way to extract the list cells from a corrupt notebook \
file. This function is intended for users who want to manipulate the cell \
listing directly, as part of a program. ",
 StyleBox["SalvageCells", "MR"],
 " takes the same options, and returns the same information, as ",
 StyleBox["NotebookRestore", "MR"],
 "."
}], "Text",
 CellTags->"Restoring a Notebook"],

Cell["This salvages all the cells from a notebook file.", "Text",
 CellTags->"Restoring a Notebook"],

Cell[BoxData[
 RowBox[{
  RowBox[{"cellList", " ", "=", " ", 
   RowBox[{"SalvageCells", "[", 
    RowBox[{"nbFile", ",", 
     RowBox[{"DeleteCorruptCells", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"Restoring a Notebook"],

Cell["This gives the total number of cells.", "Text",
 CellTags->"Restoring a Notebook"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "cellList", "]"}]], "Input",
 CellTags->"Restoring a Notebook"],

Cell[BoxData["16"], "Output",
 CellTags->"Restoring a Notebook"]
}, Open  ]],

Cell["\<\
This gives the total number of blocks removed from the notebook.\
\>", "Text",
 CellTags->"Restoring a Notebook"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"badCells", " ", "=", " ", 
   RowBox[{"Cases", "[", 
    RowBox[{"cellList", ",", 
     RowBox[{"Cell", "[", 
      RowBox[{"___", ",", 
       RowBox[{"CellTags", "->", "\"\<Corrupt\>\""}], ",", "___"}], "]"}]}], 
    "]"}]}], "]"}]], "Input",
 CellTags->"Restoring a Notebook"],

Cell[BoxData["2"], "Output",
 CellTags->"Restoring a Notebook"]
}, Open  ]],

Cell["You can view just the bad data in a separate notebook.", "Text",
 CellTags->"Restoring a Notebook"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookPut", "[", 
  RowBox[{"Notebook", "[", "badCells", "]"}], "]"}]], "Input",
 CellTags->"Restoring a Notebook"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   RowBox[{"\[LeftSkeleton]", "\<\"Untitled-4\"\>", "\[RightSkeleton]"}], 
   "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["ParentLink", 1, 1]], 19]]], "Output",
 CellTags->"Restoring a Notebook"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pagination", "Subsection",
 CellTags->{"Pagination", "i:64"}],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variable ",
 StyleBox["nb", "MR"],
 " to represent the notebook you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " to see how to do this.)"
}], "Text",
 CellTags->{"Pagination", "i:64"}],

Cell["\<\
This paginates the specified notebook. If the argument is a project file, the \
command paginates all notebooks in the project.\
\>", "Text",
 CellTags->{"Pagination", "i:64"}],

Cell[TextData[{
 "Paginate[",
 StyleBox["nb", "TR",
  FontSlant->"Italic"],
 "]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Pagination", "i:64"}],

Cell[TextData[{
 "This paginates all notebooks in a project. The setting ",
 StyleBox["StartingPages", "MR"],
 " \[Rule] ",
 StyleBox["\"Next\"", "MR"],
 " means that the starting page for each notebook is the next page following \
the last page of the previous notebook."
}], "Text",
 CellTags->{"Pagination", "i:64"}],

Cell[TextData[{
 "Paginate[",
 StyleBox["projectfile", "TR",
  FontSlant->"Italic"],
 ", StartingPages \[Rule] \"Next\"]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Pagination", "i:64"}],

Cell[TextData[{
 "Other possible settings for ",
 StyleBox["StartingPages", "MR"],
 " are ",
 StyleBox["\"Even\"", "MR"],
 ", ",
 StyleBox["\"Odd\"", "MR"],
 ", ",
 StyleBox["Inherited", "MR"],
 ", or a list of integers. The following command paginates all notebooks in a \
project and sets the starting page for the first four notebooks to be 1, 25, \
57, and 83."
}], "Text",
 CellTags->{"Pagination", "i:64"}],

Cell[TextData[{
 "Paginate[",
 StyleBox["projectfile", "TR",
  FontSlant->"Italic"],
 ", StartingPages \[Rule] {1,25,57,83}]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Pagination", "i:64"}],

Cell[TextData[{
 "The following paginates all notebooks in a project. The starting page \
number for each notebook in the project is inherited from the setting of the \
option ",
 StyleBox["StartingPageNumber", "MR"],
 " for that notebook."
}], "Text",
 CellTags->{"Pagination", "i:64"}],

Cell[TextData[{
 "Paginate[",
 StyleBox["projectfile", "TR",
  FontSlant->"Italic"],
 ", StartingPages \[Rule] Inherited]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Pagination", "i:64"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating a Browser Categories File", "Subsection",
 CellTags->{"Creating a Browser Categories File", "i:65"}],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variable ",
 StyleBox["nb", "MR"],
 " to represent the notebook you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " to see how to do this.)"
}], "Text",
 CellTags->{"Creating a Browser Categories File", "i:65"}],

Cell["\<\
This generates a simple browser categories file for the notebook.\
\>", "Text",
 CellTags->{"Creating a Browser Categories File", "i:65"}],

Cell[TextData[{
 "MakeBrowserCategories[",
 StyleBox["nb", "TR",
  FontSlant->"Italic"],
 "]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Creating a Browser Categories File", "i:65"}],

Cell[TextData[{
 "The second argument of ",
 StyleBox["MakeCategories", "MR"],
 " specifies the format of the BrowserCategories.m file. You can choose from \
three different formats: ",
 StyleBox["\"Simple\"", "MR"],
 ", ",
 StyleBox["\"Full\"", "MR"],
 ", or ",
 StyleBox["\"FullNoTags\"", "MR"],
 ". "
}], "Text",
 CellTags->{"Creating a Browser Categories File", "i:65"}],

Cell["\<\
The following command generates a full browser categories file for the \
notebook.\
\>", "Text",
 CellTags->{"Creating a Browser Categories File", "i:65"}],

Cell[TextData[{
 "MakeBrowserCategories[",
 StyleBox["nb", "TR",
  FontSlant->"Italic"],
 ", \"Full\"]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Creating a Browser Categories File", "i:65"}],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " The ",
 StyleBox["MakeCategories", "MR"],
 " command inserts cell tags into the source notebook and automatically saves \
the changes. If you do not want your source notebook modified, you should \
keep a separate copy as a ",
 "backup",
 "."
}], "Text",
 CellTags->{"Creating a Browser Categories File", "i:65"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating Bilateral Cells", "Subsection",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell[TextData[{
 "You can use the ",
 StyleBox["MakeBilateral", "MR"],
 " function to create bilateral cells for displaying sample ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calculations. Each bilateral cell consists of two columns with expository \
text to the left and input and output cells to the right."
}], "Text",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variable ",
 StyleBox["nb", "MR"],
 " to represent the notebook you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " to see how to do this.)"
}], "Text",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell["\<\
To create a bilateral cell, you must have a pair of input and output cells \
preceded by a cell containing text, as shown here.\
\>", "Text",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell["This is the integral of the sine function.", "MathCaption",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Output",
 CellLabel->"Out[1]=",
 CellTags->{"i:66", "CreatingBilateralCells"}]
}, Open  ]],

Cell["\<\
This converts the text cell and input-output pair into a bilateral cell.\
\>", "Text",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell[BoxData[
 RowBox[{"MakeBilateral", "[", "nb", "]"}]], "Input",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell["Here is the resulting bilateral cell.", "Text",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["This is the integral of the sine function. ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]], "MathCaption",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], GridBox[{
       {Cell[TextData[StyleBox["In[1]:=",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}]], "CellLabel",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}], Cell[BoxData[
         RowBox[{"Integrate", "[", 
          RowBox[{
           RowBox[{"Sin", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}]},
       {Cell[TextData[StyleBox["Out[1]=",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}]], "CellLabel",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}], Cell[BoxData[
         RowBox[{"-", 
          RowBox[{"Cos", "[", "x", "]"}]}]], "Output",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}]}
       },
      ColumnAlignments->{Left}]}
    },
   ColumnAlignments->{Left},
   ColumnWidths->{0.33, 0.6},
   RowAlignments->Top], Global`InlineCell]], "Text",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell[TextData[{
 "The cell styles that appear in the left column of the bilateral cell are \
determined by ",
 StyleBox["FirstBilateralStyles", "MR"],
 ", an option to ",
 StyleBox["MakeBilateral", "MR"],
 ". The default setting of this option includes only one style, MathCaption."
}], "Text",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell[TextData[{
 "The cell styles that appear in the right column of the bilateral cell are \
determined by ",
 StyleBox["RestBilateralStyles", "MR"],
 ". The default setting includes Input, Output,",
 " ",
 "and Graphics cell styles."
}], "Text",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell["\<\
Once you have created a bilateral cell, you can reverse the process and get \
back the constituent cells using the following command.\
\>", "Text",
 CellTags->{"i:66", "CreatingBilateralCells"}],

Cell[TextData[{
 "DivideBilateral[",
 StyleBox["nb", "TR",
  FontSlant->"Italic"],
 "]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"i:66", "CreatingBilateralCells"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extracting Cells from a Notebook", "Subsection",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variable ",
 StyleBox["nb", "MR"],
 " to represent the notebook you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " to see how to do this.)"
}], "Text",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell["This exports all cells of Section style to a notebook.", "Text",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportNotebook", "[", 
  RowBox[{"nb", ",", " ", "\"\<Section\>\"", ",", "\"\<Notebook\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[BoxData[
 RowBox[{"{", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/AuthorTools/Documentation/English/Sample11.nb\"\>\
", "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}]
}, Open  ]],

Cell[TextData[{
 "You can also extract all Section cells by specifying a list of two elements \
as the second argument. ",
 StyleBox["ExportNotebook[nb1,", "MR"],
 " ",
 StyleBox["{\"CellStyle\",", "MR"],
 " ",
 StyleBox["\"Section\"},", "MR"],
 " ",
 StyleBox["\"Notebook\"]", "MR"],
 " is equivalent to ",
 StyleBox["ExportNotebook[nb1,", "MR"],
 " ",
 StyleBox["\"Section\"", "MR"],
 " ",
 StyleBox["\"Notebook\"]", "MR"],
 "."
}], "Text",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportNotebook", "[", 
  RowBox[{"nb", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<CellStyle\>\"", ",", "\"\<Section\>\""}], "}"}], ",", 
   "\"\<Notebook\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[BoxData[
 RowBox[{"{", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/AuthorTools/Documentation/English/Sample11.nb\"\>\
", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}]
}, Open  ]],

Cell["\<\
This command exports all cell groups in which the heading cell is an input \
cell. This enables you, for example, to extract all input-output pairs in a \
notebook.\
\>", "Text",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportNotebook", "[", 
  RowBox[{"nb", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<CellGroup\>\"", ",", "\"\<Input\>\""}], "}"}], ",", 
   "\"\<Notebook\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[BoxData[
 RowBox[{"{", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/AuthorTools/Documentation/English/Sample11.nb\"\>\
", "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}]
}, Open  ]],

Cell["\<\
This command exports all cells having the cell tag \"Reference1\".\
\>", "Text",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportNotebook", "[", 
  RowBox[{"nb", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<CellTags\>\"", ",", "\"\<Reference1\>\""}], "}"}], ",", 
   "\"\<Notebook\>\""}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[BoxData[
 RowBox[{"{", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/AuthorTools/Documentation/English/Sample11.nb\"\>\
", "}"}]], "Output",
 CellLabel->"Out[6]=",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}]
}, Open  ]],

Cell["\<\
This command exports all graphics cells as separate GIF files.\
\>", "Text",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportNotebook", "[", 
  RowBox[{"nb", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<CellTags\>\"", ",", "\"\<reference1\>\""}], "}"}], ",", 
   "\"\<GIF\>\""}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}],

Cell[BoxData[
 RowBox[{"{", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/AuthorTools/Documentation/English/Sample11.nb\"\>\
", "}"}]], "Output",
 CellLabel->"Out[7]=",
 CellTags->{"i:67", "Exporting Cells from a Notebook"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Printing", "Subsection",
 CellTags->{"Printing", "i:68"}],

Cell[TextData[{
 "This section assumes that you have already loaded the ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " package and set the variable ",
 StyleBox["nb", "MR"],
 " to represent the notebook you ",
 "want",
 " to process. (See ",
 ButtonBox["Using Functions",
  ButtonData:>"Using Functions: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " to see how to do this.)"
}], "Text",
 CellTags->{"Printing", "i:68"}],

Cell["\<\
This sets the starting page number of the specified notebook.\
\>", "Text",
 CellTags->{"Printing", "i:68"}],

Cell[TextData[{
 "SetOptions[",
 StyleBox["nb", "TR",
  FontSlant->"Italic"],
 ", StartingPageNumber \[Rule] ",
 StyleBox["n", "TR",
  FontSlant->"Italic"],
 "]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Printing", "i:68"}],

Cell[TextData[{
 "This sets the printing margins in the specified notebook. The option value \
is a list of four numbers, ",
 StyleBox["{", "MR"],
 StyleBox["l", "TI"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["r", "TI"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["b", "TI"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["t", "TI"],
 StyleBox["}", "MR"],
 ", that specify the value of the left, right, bottom, and top margins in \
printer\[CloseCurlyQuote]s points."
}], "Text",
 CellTags->{"Printing", "i:68"}],

Cell[TextData[{
 "SetOptions[",
 StyleBox["nb", "TR",
  FontSlant->"Italic"],
 ", PrintingMargins \[Rule] {",
 StyleBox["l", "TR",
  FontSlant->"Italic"],
 ",",
 StyleBox["r", "TR",
  FontSlant->"Italic"],
 ",",
 StyleBox["b", "TR",
  FontSlant->"Italic"],
 ",",
 StyleBox["t", "TR",
  FontSlant->"Italic"],
 "}]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Printing", "i:68"}],

Cell["\<\
This modifies the notebook so the cell brackets are invisible when the \
notebook is printed.\
\>", "Text",
 CellTags->{"Printing", "i:68"}],

Cell[TextData[{
 "SetOptions[",
 StyleBox["nb", "TR",
  FontSlant->"Italic"],
 ", CellBrackets \[Rule] False]"
}], "FramedBox",
 FontFamily->"Courier",
 GridBoxOptions->{ColumnAlignments->{Left},
 RowSpacings->1.5},
 CellTags->{"Printing", "i:68"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Palette Interface", "Section"],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->{"PalettesIntroduction", "i:69"}],

Cell[TextData[{
 "The ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 " palettes provide an easy point-and-click interface to the package \
functions. For more advanced applications, you may prefer to evaluate the \
functions directly. But for users who only want to perform the most basic \
operations, the palettes provide a simpler alternative."
}], "Text",
 CellTags->{"PalettesIntroduction", "i:69"}],

Cell["\<\
You can use the palettes to process either a single notebook or multiple \
notebooks in a single directory.\
\>", "Text",
 CellTags->{"PalettesIntroduction", "i:69"}],

Cell[TextData[StyleBox["To process a single notebook:", "TB"]], "Text",
 CellTags->{"PalettesIntroduction", "i:69"}],

Cell["\<\
Open the notebook. If it is already open, click the notebook to select it.\
\>", "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"PalettesIntroduction", "i:69"}],

Cell["Click the button on the palette you want to use.", "ItemizedList",
 CellTags->{"PalettesIntroduction", "i:69"}],

Cell[TextData[StyleBox["To process multiple notebooks:", "TB"]], "Text",
 CellTags->{"PalettesIntroduction", "i:69"}],

Cell["Open the MakeProject dialog box.", "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"PalettesIntroduction", "i:69"}],

Cell[TextData[{
 "Click ",
 StyleBox["Load", "SR"],
 " and choose a project file. (If you have not already created a project \
file, see ",
 ButtonBox["Creating a Project File",
  ButtonData:>"Creating a Project File",
  ButtonStyle->"AddOnsLinkText"],
 " to learn how.)"
}], "ItemizedList",
 CellTags->{"PalettesIntroduction", "i:69"}],

Cell["\<\
With the MakeProject dialog box as the current notebook, click the button for \
the palette you want to use. The palette functions will apply to all \
notebooks that belong to the specified project.\
\>", "ItemizedList",
 CellTags->{"PalettesIntroduction", "i:69"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["AuthorTools Palette", "Subsection",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell["\<\
The AuthorTools palette provides a convenient way to access the other \
palettes in the package. Click any button to open the corresponding palette. \
Click the top button of this or any other palette to get help.\
\>", "Text",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[CellGroupData[{

Cell[BoxData[
 ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "OpenCloseItemizedPicture",
   FormatType->StandardForm,
   ImageSize->{54, 13},
   ImageMargins->{{0, 0}, {0, 0}},
   ImageRegion->{{0, 1}, {0, 1}}],
  Active->True,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& )]], "OpenCloseItemizedPicture",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000250001NR000`400?l00000o`00003o00SoH5i/
ogQfQ?mRHFooIVEcofY/NomKGFcoIVQgofMYN0;oIVQg0_mYIgD2ofYVM@03ofeUM?m/IWCoJFMd05oo
J6Qd0_mXIgD2ofYVM@;oK6Ee00CoJVIgofUVMomXIgGoIVQe0_mUJGD02?mXJ7CoJFMdofYWL_mZIg;o
Hf=_of1RK_mVJ7OoKg600OmKG7000008og5_OOoakogoo_goooOfooolo_oom_Wooo_nooofnOl2ooSk
o`04ooWkoookn_oono[ooocio`;ooOWoGooln_l01?okn_oonO_oooWkoookn_l3oocio`03oo_joooi
n_oon?_o00?om_co00Son?coooWkoooln_ooo?[ooogmooolo_oom_SoooCfo`7oKVn100002?mQGF_o
o_coojVX]_nXZ[OoYjZiojBZ^_nTZk_oXJZk0onRZk`01_nSZ[coY:ZjojJY^_nVZK[oZJRjoj^V^Uko
[JFj00CoZZNjojBZ^_nSZ[[oY:Vl0_nVZK`03onTZKcoXjZmoj:Z_OnU/L7oVJFeojFa_onY]L?oXZVi
oj6W]On[[K[oZ:ZfojFW/on[[KWoZJ^hoo_mo`01ofAUM`0000SoLFekoooloonRXJooIVQgofU_OomM
IWOoG6Ujof5aP@CoFfan06KoG6]noei[O?mOJWkoHFUlofEWO_mVIgcoIVInofIWO?mVIWkoIVMlofIV
O_mVIgcoIVInofIWO?mVIWkoIVMlofIVO_mVIgcoIVInofIWO?mVIWkoIVMlofIVO_mVIgcoIVInofIW
O?mVIWkoIVMlofIVO_mVIgcoIVInofIWO?mVIWkoIVMlofIVO_mVIgcoIVInofIWO?mVIWkoIVMlofIV
O_mVIgcoIVInofIWO?mVIWkoIVMlofIVO_mVIgcoIVInofIWO?mVIWkoIVMlofIVO_mVIgcoIVInofIW
O?mVIWkoIVMlofIVO_mVIgcoIVInofIWO?mVIWkoIVMlofIVO_mVIgcoIVInofIWO?mVIWkoIVMlofIV
O_mVIgcoIVInofIWO?mVIWkoIVMlofIVO_mVIgcoIVInofIWO?mVIWkoIVMlofIVO_mVIgcoIVInofIW
O?mVIWkoIVMlofIVO_mVIgcoIVInofIWO?mVIWkoIVMlofIVO_mVIgcoIVInofIWO?mVIWkoHfQloei[
O?mLK7`3oei[OP0?oeiZP?mLJh3oFfb0oea^P_mDJG[oFFiooeU/NomJJWWoHVinof1YN?mJH6koKW9m
oeMIIOnXZ[Ool_Co007oIFIh00002OmQFfOonOGoojVX]_m^LH3oa/oPomGRloo7f^_oamk`olCOlP03
ol?Om01TolCOm?o4go;oaMkdolGNl_o7gOCoamgbolOMm?o7gO;oamgdolOMl_o7gOCoamgbolOMm?o7
gO;oamgdolOMl_o7gOCoamgbolOMm?o7gO;oamgdolOMl_o7gOCoamgbolOMm?o7gO;oamgdolOMl_o7
gOCoamgbolOMm?o7gO;oamgdolOMl_o7gOCoamgbolOMm?o7gO;oamgdolOMl_o7gOCoamgbolOMm?o7
gO;oamgdolOMl_o7gOCoamgbolOMm?o7gO;oamgdolOMl_o7gOCoamgbolOMm?o7gO;oamgdolOMl_o7
gOCoamgbolOMm?o7gO;oamgdolOMl_o7gOCoamgbolOMm?o7gO;oamgdolOMl_o7gOCoamgbolOMm?o7
gO;oamgdolOMl_o7gOCoamgbolOMm?o7gO;oamgdolOMl_o7gOCoamgbolOMm?o7gO;oamgdolOMl_o7
gOCoamgbolOMm?o7gO;oamgdolOMl_o7gOCoamgbolOMm?o7gO;oamgdolOMlP;oa=ob0_o5g_@04?o7
gOCoaMgeolCNmOo3goGo`n;gol3Olonog_3o`Mk^olOQl?o<hO;ob]_[omo[nOoAen?oMgV5ooCfoool
o_l1ofAUM`0000[oLfeioooloonZZKOoGfEcom3Lk?o:gNkoNiBXofN6V_mZSJ7oJ8jS0_mVSj<0J_mX
SZGoJ8jSofR>YOmXSZ?oIHnUofF@XomUSjGoII2SofF?YOmUT:?oIHnUofF@XomUSjGoII2SofF?YOmU
T:?oIHnUofF@XomUSjGoII2SofF?YOmUT:?oIHnUofF@XomUSjGoII2SofF?YOmUT:?oIHnUofF@XomU
SjGoII2SofF?YOmUT:?oIHnUofF@XomUSjGoII2SofF?YOmUT:?oIHnUofF@XomUSjGoII2SofF?YOmU
T:?oIHnUofF@XomUSjGoII2SofF?YOmUT:?oIHnUofF@XomUSjGoII2SofF?YOmUT:?oIHnUofF@XomU
SjGoII2SofF?YOmUT:?oIHnUofF@XomUSjGoII2SofF?YOmUT:?oIHnUofF@XomUSjGoII2SofF?YOmU
T:?oIHnUofF@XomUSjGoII2SofF?YOmUT:?oIHnUofF@XomUSjGoII2SofF?YOmUT:?oIHnUofF@XomU
SjGoII2SofF?YOmUT:?oIHnUofF@XomUSjGoII2SofF?YOmUT:?oIXnSofR>XOmYSJ?oJHfUofZ<YOmY
SJL2ofR=Y`0<ofR@ZOmUSZCoHhbPofbAY?m`TJCoJhRJog>=W_nkc=cod][UoeiQJ_okoOoonO_o0OmS
I7H0001bofUQK_omnOooZ:Neof5XN?o>g^kobN3bofR7VomYSjCoI96Vof:BZ?mPTZWoGi>YoenCZomO
TjWoGi>[oefDZOmIUZ_oEYNYoeJGZomFUjWoEYN[oeJGZOmFUj_oEYNYoeJGZomFUjWoEYN[oeJGZOmF
Uj_oEYNYoeJGZomFUjWoEYN[oeJGZOmFUj_oEYNYoeJGZomFUjWoEYN[oeJGZOmFUj_oEYNYoeJGZomF
UjWoEYN[oeJGZOmFUj_oEYNYoeJGZomFUjWoEYN[oeJGZOmFUj_oEYNYoeJGZomFUjWoEYN[oeJGZOmF
Uj_oEYNYoeJGZomFUjWoEYN[oeJGZOmFUj_oEYNYoeJGZomFUjWoEYN[oeJGZOmFUj_oEYNYoeJGZomF
UjWoEYN[oeJGZOmFUj_oEYNYoeJGZomFUjWoEYN[oeJGZOmFUj_oEYNYoeJGZomFUjWoEYN[oeJGZOmF
Uj_oEYNYoeJGZomFUjWoEYN[oeJGZOmFUj_oEYNYoeJGZomFUjWoEYN[oeJGZOmFUj_oEYNYoeJGZomF
UjWoEYN[oeJGZOmFUj_oEYNYoeJGZomFUjWoEYN[oeVFZOmMU:SoH9>X0_mRTZT04?mRTJ_oHY6]of2B
[OmPTZgoGI2[oefAZOmLSZGoHi6XofB?X_mRR9_oKXnRoloVm_oBg>SoIVUboo_mooolo_l1ofa]O`00
00_oKFEboooloonXYkGoIVemolWJj_o5h??oI8VLofnL/OmNTZSoFi>ZoeRD[004oeNE[P03oeFE[_mA
V:koD9R^05goD9R^00?oDIR^oeFFZ_mGUJX00_mJU:`04?mJTjkoFY>`oeZC/OmHU;3oEY:^oebH/_mI
Tj_oF8jVoe^=Y?mUTZOoIXnSol7Nl?o@g>SoKg9koo3booobm?l1ofQYN`0000coKfMdoochoonTXk7o
HfakolSKk?o2g_?oHX^Ooef@YOmKUJ_oEYJ_oeBG/OmBV;42oe6I/P03oe6I/OmBV;;oE9Nb05koEIJd
00?oE9Nboe:I[omBVJl00_mEUk400omFU[;oEIJboeFF]002oeBG]00;oeNJ]OmEUk7oEiF/oeR@YomV
V:ooHHnVok_Lkoo9eN7oKG1iooOioooinol00Om]KX00000;ofeWLooknOooZ:^jofA[Noo<fNWo`M_Z
ofZEZ?mIT:GoEiF/oeBF/?mAU[<00om>V;D01?m>V;7oD9Raoe>F/omDUK<6oeBE]@05oeFD/omGU;?o
EiBcoeFD/omDUKD00omDU;L3oeFD]@03oeBE]OmDU;OoDiFg00?oDiFg00GoE9FeoeFD/omEU;?oEIBc
oeFD]@03oeBE]@06oeFD/omEUK7oEIFaoeFD]OmEU;OoEIBe0_mEU;<00omEU;GoEIBgoeFD]@02oeFE
/@07oeFD/omDUKGoEIBgoeFD]omDU;OoE9FeoeFD/`02oeFE/@?oEiBa00CoEIFaoeFD/omEU;GoE9Fe
0_mEU;D3oeNC]@09oeFD]OmGU;?oEiBcoeND/omEU;?oEiBcoeFD/omGU;?oEIBc00;oEIBe0_mGTkD5
oeFD]@CoE9Fe0omDU;L3oeFD]@05oe>E]Om@V;7oCYRaoe6G/OmCU[400_mAUk42oe2G/`0<oe:G]?m=
TZooCi:]oeZJ/omDT:SoFiBXoeb<X?o3ioOocMWUofQ[M?olo_oomOOo0OmWJGP0000BofQXL?oioOoo
XjZlof9YNOoGf^7ocM_TofF@XOmIUZ_oDiBZoe:D[_mBUkSoD9JjodbB]_m>UKGoEIbhodN=Y_mEVkGo
DiJa0_mCV;L0IOmBU;CoEIReoe>H]OmAU;7oCXjZoenK]omESZ_oFIJcoe6C/om=TKCoFIg0odf?/_mB
T[GoEiRhoe2A/OmJW;koB8j`oeFN`Om?V;WoC9FfodZC]?mGW[koD96]oeFE/?mFU[;oDY>aoeNI^OmD
U[KoD9>`oeNI/OmCTZCoGifdoeNF^OmASkCoE9>boeBD/?m?Sj_oI:?2odb:[om<RjkoH9jeoe2?XOmE
UjooDIBaoeJF^_mDU;[oEYRkoeFG]om9RJCoDHnVoefK/_mHU:coFIJ[oeREZ_mLV[7oE9B]oe:C/OmB
U;KoEYJioeJB]_mITKCoFY2bodj9ZomMV[WoGYZfoeFAZomHU:koF9J_oe2<Y_mETjcoFiNaoeZG/om<
RjcoEIBgoenI__mFTK?oDXj`of2M_?m;R:OoEIBcoefM`?m@T[CoCI:coeJK_?mBU;KoDI>foeBJ_?mB
U[WoCHf`oeZI^_mDTkKoDYBfodjG]om<U[?oD9>`odj@Z_mBV[;oE:6eodVG[Om9UJgoDIJc00;oEIJd
00WoDi>^oeNH[?mIU:CoGi>PokoTkOo?g>GoIfMaooclooojnOl00OmWIWH00024ofEZL?ogo_ooXZZm
of=YNOoKfMkodM[OofF@XOmHUZgoEiV_oe6D[_m@T[GoF9W1oeNH__m<S[3oDiJaof6U_?m?Tj[oEiZd
odN=Yom?U;7oE9Vfoe:H/_m=T:_oEiVcoe^I/_mJUZkoFYB/oebH/_mBTk7oEIZioe6E^?mCUKOoDY6`
oebI]_mDTk;oEiViodfC]Om=U[WoD9^kodbE]_mBVKWoCY>`oeNG/_mIUk3oG9bgoe:B[_m?T:koDY>a
oeVJ]_mGVJooE9JVoe>AY_mCT[GoDY2goe^J^OmDU;3oG9bhod^:ZOmFU;_oGik1oejL/OmFV:SoEIN]
oeNH]?mHV;_oEIFiodbA/?mEV;?oHZ2gofFN/_mJSJ;oFXZNof>BY?mDQi[oEi2SoeFCZ?mJW;KoE9Nd
oeFD]OmIUKOoH9RioeF>[?mUW[coEY:^odj8X?mSWK?oCX^PoeVFZomPWK;oGIZ_oe>?YomIUk3oGIZg
oeND/om;QZSoGIRhoeZG]?mETZkoFIVdoeZJ]_m<SjcoDIJcoeBK]om:U;7oF9nmoe:I]om=U;;oCiJd
oeFH]OmCU;;oCXn]oeBG]?mCV[[oDiRioefJ]omNV[CoEiV_od^DYom7UJWoEJ6hoeBE/omHU;KoEYFd
oe>C[_mFVJcoEiFTof6CW_o2hncodM_TofMWKoolo?oon_Wo0OmWIWH00017ofIYL?oioOooXZZmof=X
NooKf=ood=_Qof>@XomFUZooC8jVoeRK]_mFV;[oDY:hoeNE^_mLVkcoE9:Yodb:WomBTjOoG9fcoeZL
/_mHW;?oE9Zcod^AZ_mMW[CoFYR]oeVHZ_mEU:KoFIN/oeBBYomDT:SoGIfhodF:YomHVkSoFI6ZoebB
[?mJUK?oCi2^oe:C/omBU;CoCI:aoe:E/_mJV;7oE92XoefJ]_mDTJgoEI6[oeNC[OmJU[3oGIVeoe:>
Z_mDTZ_oEiZ]odnAZOmHUkSoEYBioeRG^?mBTK3oF9Nfoe2?/?mFU;WoD8n`odN9XOmCUZWoFiVboe>>
[?mEU;?oCi2^oeVK/omIVZkoEY2TojCDj?oSool00_o]ool03?oPooooYMKWoeB?XOmFUjWoFibboeFE
/?mCT:goEIF`odn=Y_mHTZSoFI:VofBN]0;ocooo02goGYb[odn>WOmOWZooE9:Woe2<Y?m?Rj?oFiNa
oeFF/_mIVkGoEiR/oe2AXomEV:_oCY:Woe6EZ?mDVjgoBY:Xoe>N]Om:UZgoCIZ^odfDZ?m@U:WoEine
odnF[?mEUjgoFI^aoe:C[omHUK;oG8n/oeN9X_mFSj?oFiZ/oeNK[_m?Tj[oEiBaoeVD]?mHUKCoDi>^
oeNH[?mIU:CoHi6PolGQkOoAfnCoIfM_ooclooojnOl00OmWIWH0000PofQXL?oioOooXjZmof=XNooJ
fMooc]_Sof:AYOmEUk7oG9nioe6D[om?Sk;oEI>hoe6<[_mLUK;oGIBXofBIZomNTZOoIIV^oe69V_mN
VJ_oEI>/oeJ?Z_mNT:OoFHRJoeN<V_mMUJCoDX^Oof>J[omVUJWoGHfSoeND/?mIUJl2ofNDZ@1RoeJ>
ZOmCT:goG9NeofFQ_Om?Sj_oF9B/of:EY_mOTZGoDhnYofJS`?mESjOoEhfUoefCZomPTZWoHhnXof6A
YomPVjgoGIb^oeZBZomMTjooDhVUof6G/omLTZkoHiVeoe^A[OmOUk3oHJ2boeNBY?mQTJOoH8jXoeV?
ZomSWKGoCXNHof2HYOmKT:;ogooool3GiomlR9SoZ[K6onWnoooAo?ooFXnOoeZ?WOmLU:?oFY2Xof2J
/_mFU:_oHI^_ofBCYOmNS9coG8bRomSooooIooooDXRBofFKYomAQYKoHYJ/ofRJ/omQT:CoJ9^`odj:
X_mBT:GoGiBTof2AX?mNTZOoH9N[oeR@WOmOVJGoI9f`odn<Wom5RY[oG9j^ofNL[?mIS9goGIZ]odj=
WomOU:KoGi:UoeVCZOmNU:koIY2YofV>Z?mTSj;oHY:Vof6J[OmHU:coFY>`oeVD]?mFUKCoDY>_oeNH
[_mJTjKoIXnQolSOkooBf^GoIfM_ooclooojnOl1ofMVMP0008CoJFQ^oo[loonSZ[goHfQlom[IhOo>
fnCoHI6XoeBG]?m:SJOoDI:^ofBSa?mQW;koEHZZoiS:hoo<noooh?ooonKooooKn_oobN_gof:9V?mZ
U[7oHHRWomO_ooo]ooooi_ooomkooomYTjWoIh^Sok_@hooXo_oof_oooef;X_oToooof__oofVK]_mP
UkGoFHbWoeb@Z?mJTZ_oH9>Von?ooooPooooH9RaodZ7Y?mPU[3ofoooomgooomYSZ3oi__oongooomS
SiSoG8jGon;ooooTooooJhnOok_Pl_oPooooeo_oofb@W_oHooooeoooofVEW_o]ooook_ooofbAZomJ
Q9[ohoooon;ooomTTZ;oJYBTomkfooo_o_oobMSOonkooooRooooHXfMogNLYOnWbM?oboCoomCooooI
ooooa_?oojW3d_mhRicoLHfUonCooooRooooc?7iomcooooHo?ooKHnZofV7Xoo1encojOooom;ooomX
V:coj_ooongooom/Q9coM8nTolgYm?oZooooh__oolo]oomcW[7oHhZIonoooooaooooIhZPofR>Xoo]
ooooj?ooof6>XOnFaMWoc^koon[ooooYooooeOSooj7@i?mHS:;oG9:^oe^D/_mEU[CoDIB_oeNH[_mK
TZKoJXfQol_NkooCfNGoIfM_ooclooojnOl1ofMVMP0008CoJVM^oocloonTZKgoHfQlom[Hhoo=fnKo
Gi6ZoeBG]?mEV;?oDY>_oe>?/Om?QjSoJY^iomSooooRoooo]]KQog:7W?njcMkokOooomkloom[SjWo
`^7nooCoooo5dN7oY;o6on3oooo;lOooKXfRooSoooogooooGh>IofRAXoo`ooook_oooeJ2VomUV;Go
Hi2Woe^8Vom]WK?oII2PoncooooZooooEhfWoebI^?mQTjcog_ooon7ooom/R9KonOooooOooomUS9?o
IiBIon?oooo]ooooLHbGon?ooooUooooPIbWoff6RooYoooogoooofV@Uoo[mOoomokoofb;X?mbUJWo
koooon_ooom/Sj;oa>Wion_oooo4f]Sof>k/on_ooooSooooJhbMojRk`_oYn_ooh?oooic5fOnCa=Go
d?Oooo;ooonna=;oLhBNon;jooo[ooooc^[^olSTj?oTooooc>KoognC[_o/mOoolOooofRCY?mGQICo
k?ooooGooomkRj;ob=[^oo7oooo6f=[oe^?donkooonig^koL9:LooSloookooooM92UofJ7V_odoooo
k_ooofnGXooDo_oojooook31eOnW^/_ojoooomoooomVU:_oGY6/oe^D/OmDUk;oCiF_oeJH[_mMTJOo
K8bSolcMlOoCfNGoIfM_ooclooojnOl1ofMVMP00023oK6M^oogkoonTZKooHfQlomWIhoo=fnKoGi6Z
oe:G]_mIW[_oDY>_oeRE]?mSV;SoEXBNofnEZ?mTQHkoNIBKoh2CX_nic=[ojoooonOooomKQ9[oi?oo
onoloon4TI[oMI>EofJ?TomWUZKoKI2SooWooooYl__oJiFUof6=VP;olooo01GoJY>Yof:D[omZT:?o
J8fOoen:WOmZSY[omOoooo7ooomMTJWoEY:doeV9X?oRooooi_ooogR>Voomo?oomOgoofN?VOmWV9oo
ioooongooom`RYL00_o[ool07?mZQ97oM8fBonOooooGooooKIFOooKnoooko_ooJhZNofZ9Vooioooo
noooog>9W_oSooooioooog2AR_mdUHkofO_lonOooomkT:?ojNWaoocooondc]goII>Sof:JYonZfN7o
mOooonO[m?m_PIT2on[oo`0]og2>S?m^S8[ohOkoonWooomaQIgom?_ooo;ooomOSiWoHiZQonWoooo^
ooooJhRHon3ooooZooooM9::ogN=V?oRooooe_ooof>CUoobo_komoooofbHXomOTIcojoooonkooomN
QXkoIXjJoh6DYOnka]Soj_Gooo3oooo;k?ooKiV_oejBZ_mIUK7oDYRbodbF[omEVK3oFi:Wofb<YOo=
g?7odmWUofMWKoolo?oon_Wo007oIfIf00006Om/IfkooO_oojBY_omSJ7kofMWSol_Li_mNTJcoDYNf
oe:G]?m@TJgoE8n_ofNJ^OmRS:GoK92Pog:?UOo1f]oohOCoonkooooXoooodoOeofJCY_oRooool?oo
oo?ooooYool00_oHool07?m[TZ7okOCjooSooomTTigoHi:JooKoo_ohoooohOooomKooooSooood?7o
ofR>XOm_Si[onOokon[jnOmTUZooFIFgof2>Y_oTooooioooogN9UOoooOoom?[oofZDX_mQTicoiooo
on_ooom`RYL2on_oo`1;ogNAW_m`RHgohOooom_ooomTSY[omogooo_noomVRigoKi>Qoo_oooojn?oo
NXbTonKooooQooooL9><ofV<QOoWooooiOooof]jTOoonooolo;hog2=VomOTj7oDHfGofbMX_o]nOWo
nokoog^=YOoYoooogO[nog>BSOm`Sh[ojOooon?ooomeRj;onOooonWinOmWVJ3oFI>GonGoooo[oooo
JXVKonKooooUoogoK8Z0ogR>VOoVooooeOooof2CU_ogooooloooof:BW?mKTIgoj_ooonkooom_V9ko
]MgWon_nooogoooolO[ooncmooo6iOOoH8^NoejBZ_mFU[7oCiVdod^G[omCV[3oFY:Yofb<YOo<g??o
dmWUofMWKoolo?oon_Wo007oIfIf0000Eom]IVkoo_[oojBY_omSJ7kofMWSol_Li_mNTJcoDIRfodjC
/?mHVKGoEY6_oejA[_m]UjooWl?ConSoooo]ooook_ooongooooQoo[oIHb9of6@X_oOooool?ooogb=
U?m/T8kof_ooomCooomKQYKol__oooOooomEQHooHiBIooOooOoiooooHXJLof:@Z_o5i_Woioooom3f
oom]RiKom_gfooGooomZVK?oEI2bofB@ZOoToooohoooogV9U_oooOoolOOooffGYOmJS9Goioooongo
oombS9Woj?ooon_ooomZQ97oOIJJonKooooKooooHhfIooWoooocn_ooIYJToef?V_o^oOoonoooofj2
WOoPnoooj_ooogB@TOm`S8gojoooomgeoon3TjgooO_oooSooomYTiooDHnLoeNGX?mNSY;om_ooooco
oomhS:Coi?ooonWoo`02ofb<R@0[onWooooPo_ooJGnFooWoooodooooFXbCof:IX?o[oooojocoog:;
XOoUooookOooogN=R_mjRY[ojoooomKooomSSYGoo?ooooCgo_m^UJKoI9:Ron_ooooaooooJi>KomGo
ooo]ooooj_Ooom?Pl?mZP8koJHfMofNFZ_mKTjcoEINaodjJ]?m8V;7oD9^boeVCZOmZS:Goc=ccom?I
iOmWIfooo?cooo[io`01ofMVMP0008CoKFI^ookjoonTZKooHfQnomWIhoo;g>KoGY:Zoe6H]_mCVK?o
Ci2/oeB?[OmJSJ[oHhfVomSkoooUooooioooonCkooned=WoIhN2ofjFUOmPT:Co_>Koon_oooo8g>Go
]]cMom_ooonbj_WoJ9>SooGooooRkoGoJi^WofJGW_ocoooomoooofB9W?maWKSoIHRKonGooooPoooo
KXjKooSoooobooooU/SQoe^F^?mYUjooe?WoonOooomgRYSon_coooSoooo5ko_oV<W@onOooooXoooo
LXZFon_ooooWooooNY:Nofn8S?oToooog?ooofZDX?obn_oomOoookGYmonHd=gojoooon?eoombT:co
bnkoonWooonnfN3oe>gdon[ooooWooooJh>Ooo;looo_ooooHI6OofJT/omOVjKoKibRonojo_ofn_oo
LHFMonOooooYoooodo;dol[YjooGn?ooe_CoogfCZoo]m_ool?ooof2@V_mSUj;ohokooo7ooomeSJOo
bnOmon3looo6g^3od^?gon[ooonkk?goI92Moo7hoooioooo]=gaoik;h?oXo_oojooooej:TooLoooo
hoooogV<VonR^<Koj_ooom[ooomGRYooFYB/oeBG/_m=V[CoB9Raoe2K/_mGU:WoJ8jUol_MlooCfNGo
IfM_ooclooojnOl1ofMVMP0008CoK6I`oogkoonTZKooHfQnomWIhoo;g>KoGY:Xoe:G]?mBV;7oCY6[
oe^H]OmPUKCoHi6[on;ooooNoooodo3hogF?W_m]QiCoKhjAof^BVOmQSjOoIXn]omWboooZoooohooo
okc/m_mTUj[oh?oooo3ooooboooog_oooe^7U?oboooom?ooof^AY_mLRZ;oJ8jQon7ooooIooooKiBT
onGin_o]ooooeOoool?noomOSjKoh?ooon?ooombS9_on?ooooCooonYdMWof_ooon3oooo7h>GokOoo
on[oooo]ooooi_koogJ?U?oUoooogOooofF=UOoYmoool_oook?PmOo:oooofOoookcPk_mUU:koIiVd
omGjoooSoooo_M[ZomoooooMooooIi6Zom?`o_oYoooo[MS[oeR;X?m@PiCo_>;_ooGooooPj?GoOI6/
on7loooQoooo_n3Won;ooooQooooJXRTon_oooogooool_ooon3ooomIR9Soi_ooonWooomRQZ3oK9:Y
om3go_oTooooi_oookoRo_m?R9coKZ6bonkooooVo?oo_NgooloooooSoooo_=kZoejBWonHcM_ofOko
omkkoooWooooeocooiK7f?mSW;3oEiF^oe:H/_m>V[CoBYNaoe2K/?mFU:WoIXnUolWNlOoBf^GoIfM_
ooclooojnOl1ofMVMP0008CoK6I`oogkoonTZKooHfQlomWIhOo=fnCoGi:Woe:H/_m<TjWoH:BkoeZJ
]_m;PZ7oHi:^olWcoooSooooWl7;ofR9V_ngfn_oh_ooom[ooomMTJWoHY>aoej2W?m]T:CoHHnNoeN;
VOmNUJ[oGhjRonCooooVooooF8RLofRGZOoWooook_ooof29WOmTU:_ob?;oomooooo9moooHXfNof^9
TOmYRiGoGi>[oeF>ZomTUZooIiJZofF@XomUR9coIgj@og^GYOmUUJ7oGY2IofnGXOmXRYKoJhfIonCo
oooVooooKi6Moff?VomVSYSoF8ZCofVIXomYQ9GoMI2UofJBZomPTZWoIYFUof2DX_mIUk3oChfVof6?
Y_mSS:3oIhfRoffJ/OmJTZgoGIF^oj?>g_oCn_oof_ooofJ@ZOm[Vk7ob_GoonGloon`aMKoKHbXof^@
ZomdWJooHXbJofB>W?mNQiWoJi:_ofJ8Y?oYooooh_goofFDZ?mRUJSoHhjNof:;WOm_WKOoDh>Joej>
W?mTTYooIY2XofZI]OmSXKSoCXRLofjCYOmZSj;oEHfToeZD[?mPRikoJ9JVoeVDY_mJUjWoLYndof26
VOmTSIooH8nQoeRAY?mJV:goEIF`oeBG]?m?VKKoC9Jaoe:J/?mGU:OoIXnSolSOlOoBf^GoIfM_oocl
ooojnOl1ofMVMP0002?oJVMboockoonTZKooHfQlom[Igoo=g>?oGi:UoeBH[omEW;3oCY:Yodn?ZomN
VKWoGY6`ofVH/_o7l_oog_ooomcoooo@ooooboooohk<fom?TJWoEiVcoeF?YomOV:coFIJXoe^M[OmD
UJWoFYBXojWJjoo:oOooDi6Vof:K[ooSooooh_ooomgoo`02olkoo`1OolSjoomNU:coG8jUof^FY_mK
RISoGYB/oeZC[_mAQioof?ooomWooomQT:[oKIbhoeB8X?mGUJ[oEIJZoebD[OmUV;?oGY2Yoj3BjOo8
n?ooFhfVoe^>ZOoEoooocooooeZIZomPTjkoGX^XofJA/OmNSJOoFi:VoeFDY_m>VJkoDYZboe>?YomW
W[?oHIF[odf7WOm<T:OoFI^aof6H[?nKb=goe_Woon;ooooHoooo^_7ooj3?gomTTJCoH9B/oeJ@Z?m>
RikoEY>UofBQ/om?S9ooIIjioeR>Z?nXe^gocoooodn9WomPWK;oe_ooomGooomDS:GoFiF]of2K[OmH
TjGoFi>/oeFAZom@TjgoDiF]oejEZ_mISJ?oCHfVof>S_?mPUjcoE8fQoe>E[Om>T:SoFHnWoej>YOmS
UjcoGIRZoeRI[Om:SZGoEIBcoeJE]_mDU[SoDIBaoeJH/?mITjOoII2SolKPkooBf^GoIfM_oocloooj
nOl00OmWIWH0001XofUWL_ojo?ooXjVoof=XNooJfMooc]_Qof6BXomDV:goCYFWodnCZ?mDUK7oGY^j
oeJ=[?mHRjSoJ9R/oeb=W_mUWJkoFYFWoe6@X_mMWkGoDYRboeBK]om>TJcoDIB^oe>E[Om<SZCoFibb
oe^I/?m?S:7oFIF]oeVK]Om>RZ;oIY>VofF>X?mNS:CoH9B/of6G/OmQV[GoDHfWoenI/OmFSJ;oIYZ`
oebDZomKTjcoI9beoefE[_m8P9_oG9RdoeRG]_m@TJooDiZ`oeRL/om?SZooDhnaoe^D/_mOV;?oFI:]
of2K^OmRWKooAHBUoe6E[?m=U:[oDI:`oebI^?mGRZWoGYB`odj?YOmKY;OoD9bcodbH[omATj_oCXbU
oebH/_mLW;GoGJ>lodV@Y_mETjSoHiN_oef6X_mVSjgoEH^UoeZG[?mMUjgoEHnUoeBD[OmHV[;oFYje
oeRO]Om:TJOoEYfcodV<Y_mIVkGoEY:/oeJBZ_mFU:goDY2YoeVE[OmGTJWoEY:/of:P^Om9RZ3oGj6g
oe:D[_mEV;<2oe2F/00?oeNG/?mPX;WoCi6[odnAZomDTZ_oFi^doe6H]?mEV[OoFiNcofBL]omJV:oo
CHnUoeFM/omAUk7oEIBe00;oF9Bh00WoDi:aoeVG/?mJTjOoII2SolGQkooBf^GoIfM_ooclooojnOl0
0OmWIWH00024ofQXM?ojo?ooXjVoof=XNooJfMkoc]cOof6BXOmDV:_oFJ2boeBH[Om@TJgoFIRioeJ>
[omLTK3oGI6WofJJ[omBRIkoGiN^oe:>Z_mOW;WoCi2^odf?[omEUkWoGZ32oeVF]OmSW[coF96/oe><
YomOVkOoEY6_oeNB/_mLTk7oEhVRof2@Y_mRU:goFHnYofBM^_mASZ_oDi>_oeJF/_mFTk3oDXjXoeVA
Z_mFSZGoFY>^oe>?ZomMV[OoEiRfod^@[omGWKOoDYFXoeFF[?mHU;KoEI6eof>L^OmITj_oGIN_odJ2
W_mGTKKoG9RjoeRI[omEV:_oDiVcoe>H]OmOX[coD9B[oeVT^om:UZgoAHfUoeZP^Om=SJWoGibioe6<
Z_mHUK;oDI6/oe>C[?mNW[OoCXbSoeR@ZOmUVkGoGYB`ofJM^om<R:CoHIjkoeRH]?m<SJWoDiJaodnD
/OmFVkSoDiReod^>ZomGV;KoDi:aoeVF]OmQV[SoFY>aoe6=ZOmNV[CoGiffod^;Y_mCU;3oDiJaodbB
[?mFVkSoEIZgodnD/Om5RZOoEIZgoeVJ]_mGUk;oE9B`oe>F/om>UkSoCYBfodn>[omFTk3oDIB^odbG
[?mBW[GoDI^foeFD]omKT[WoFi>hoeR@/OmJU[3oFi:VofJ?XOo5hNood][UofMWKoolo?oon_Wo0OmW
IWH0001iofUWM?ojo?ooXjZmof9YNOoJfMkoc]cOof6BXomEUjgoCi>XoeNK/?m?T:coEIBcoejK^_mG
T:koGYJ_oeJ>YOmJTZ_oFiB_oeZE/omASZgoF9NhoeJG]omATkGoCHf`oe:>/?mLU;GoF8n]of:K^?m@
SJcoFYNfoeF@/_mLUK?oHYRdoeZ@Z_mHSZSoGYNboe2=Z_mEU;?oFY^iodn@[_mGV[OoEIFaoeRD[_mN
V;3oEY:^oeJC/?mOW[goCI2]oeFL^?m:T:[oG9faoe6?Y_mEU;?oGIbmodf9YOmMUjooF9:Zof>P_?mC
T[?oEIJfoeFCZ_mCU:[oEIffodZF/?m9TjcoD9^bodRBZom@Uk?oE9ZdodnB[OmJVkWoD8n^of6L_?mC
SZcoEi:`oe^K]_m<Sj[oEI^doe^K]?m@S:KoFI2^oeN@[_mKV;OoDI:`oe2A[OmLWKWoC8n/oeJK^_m=
T[7oEibkoeNJ]omAU;7oDY>coeVH^OmDSjooFI:`oeJC/?mOW;SoBhRToejN^OmDUK?oEINgoe6F/om>
Tk3oBHbYoebQ__mCV[SoDIRfoeBE/OmBTZkoE9FaoeBF]_mDV[coDINioeNH^?mGV;KoDIVboe6L/om;
UJkoCiBaoeFD]`02oeVC^009oeJA/OmJU[3oGI6VofJ?XOo6h>ood][UofMWKoolo?oon_Wo007oIfIf
00002?mZIWCoo?_ooj>Z_?mRJWOofM[LolgLgomQTJOoEIJd0omDU[000omEUK3oEIFaoeFE/@03oeND
/003oeFE/?mEUK7oEIFa00CoE9Fc00?oEIBcoeFE/OmGU;400omEUK400omEU;?oEiBaoeND/002oeRD
/003oeND/?mEUK7oEIFa00CoE9Fa0_mEUK02oeFE/@0<oeBE/OmCU[7oDINaoe>F/?mJTjkoF9B^oe6G
/Om@Uk?oEIFaoeRD/?mHTk7oE9Fa0_m@Uk<2oeND/@04oe2G/om=V;GoCYRcoe6G/@;oEiBc00SoE9Fc
oe2G/om>V;?oDIJcoeND/omJT[?oEiBcoe>F/`;oCYRc00CoEIBcoeND/OmEUK7oE9Fa1?mCU[401?mA
Uk7oDIJcoe6F/omAU[<2oe6G/@;oDiJc0omDUK43oeFE/@03oeFD/omDUK?oE9Fc00;oE9Fc00?oDiJc
oe6F/omAU[<00omCU[405OmCU[?oDiFeoe>E]OmCU[?oDINaoe>F/?mDU[3oEIFaoeND/omGTkGoEYFf
oeBF]_mAU:ooFIN^oefAYomXSZ?ob=oaom;JiOmWIfooo?cooo[io`01ofMVMP0000coJVIdoockoonS
Z[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc4?mDUK46oeFE/@[o
E9Fa00ooDiJ`oeBF/?mKT[3oF9B`oe2H/Om>V;7oEIFaoeRC/OmGU;7oE9FcodfI/om>V;?oEiBcoeRC
/omAU[D00_m>V;<04?mCU[?oFY:coe^A/omDUK?oD9NcodfI/om>V;?oEiBcoeZB/omEU;?oDIJcodbI
]Om=VK?oE9FeoeND/omDUK4?oe>F/@;oE9Fc1_mEU;<2oeBE/`;oDiJc00CoDiJaoe6G/OmAUk7oDiJa
0_mDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kc
om;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE
/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/@ooEIF`00GoE9J`oe>F/?mDU[3oFY>`oeRD/002oe2H
/009oeFE/?mHU;3oF9B`oeBE/Om>V;7oD9RaoeRC/OmJTk7oDiJc00;oD9Ra013oDiJaoeZC/OmKT[7o
EIFaoe6G/Om>V;7oD9RaoeND/OmJTk7oEiBaoe>F/Om=VK?oCYRaoeFD/omGU;7oEIFa3_mDU[000omD
UK7oE9FcoeBE/`09oeBE/`03oe>F/omCU[7oDiJa00;oDiJa0_mDUK<2oe6G/@0@oe>F/?mEUK3oFY>a
oeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf0000
3?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@
oeBE/@ooEIF`00?oE9J`oe>F/?mDU[000_mHU;000omAUk3oD9R`oeFE/002oeRD/006oeFE/?m@V;7o
D9RaoeRC/OmJTk3oE9Fa0_mAUk404?mCU[7oFY>aoeZC/OmEUK7oDINaodjH/OmAUk7oEiBaoeZC/OmG
U;7oDiJaodjH/Om@V;7oEIFaoeRC/OmGU;0?oeFE/003oeBE/OmDUK?oE9Fc00WoE9Fc00KoE9Faoe>F
/OmDUK7oE9FaoeFD/omDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^
oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgL
hOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/@ooEIF`00?oE9J`oe>F/OmCU[40
0_mGU;400omAUk3oD9R`oeFE/002oeND/006oeFE/?mAUk3oDIN`oeRD/?mJTjkoE9J`0_mAUk002omC
U[3oF9B`oeRD/?mEUK3oDiJ`oe2H/?mAUk3oEiB`oeRD/?mGU;3oE9J`00;oD9R`00?oEIF`oeRD/?mG
U;003_mGU;000omEUK3oE9FaoeBE/@06oeBE/@KoE9Fc0omEU;<01OmDUK?oDINaoe6G/OmCU[3oEIF`
00;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMV
MP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;o
E9Fc4?mDUK42oeBF/006oeFE/?mDU[3oEIF`oeBF/?mEUK3oE9J`1omEUK000omDUK7oDiJaoe>F/@02
oeFE/@03oe6G/Om@V;3oE9Fa00;oEIF`01?oE9J`oe6G/?mCU[3oEiB`oeRD[_mDUZkoDiJ`oe6G/?mC
U[3oEiBaoeND/?mEUK7oDiJ`oe6G/OmCU[3oEiB`oeRD/?mEUK3oE9J`00;oDIN`01;oEIF`oeND/?mG
U;3oEIF`oeND/OmEUK3oEiBaoeFE/?mGU;7oEIF`oeND/OmEUK3oEiBaoeFE/?mGU;7oEIF`oeND/OmE
UK48oeBE/@CoE9Fc1OmEU;<01OmDUK?oDINaoe6G/OmCU[3oEIF`00;oFY>a00coEi>eoeBF]_mAV;Co
CYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYe
omWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc4OmDUK401omCU[7oE9Faoe>F
/OmDUK7oDiJaoeBE/OmCU[401omDUK400omCU[7oDIJcoe6F/`02oe>F/`03oe6F/om@V;7oDiJc00?o
E9Fa00koDINaoe>F/?mEUK3oEIF`oeBF/?mCU[3oDINaoe>F/OmDUK?oEIFaoeBE/omCU[7oDIJcoe>F
/@?oEIFa00?oE9Faoe6G/OmAUk400omEUK403_mDUK7oEIBcoeBE/OmEU;?oE9FaoeFD/omDUK7oEIBc
oeBE/OmEU;?oE9FaoeFD/omDUK7oEIBc1OmDUK44oe>F/@;oE9Fa0_mEU;<4oeND/`06oeFD/omDUK?o
DINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmW
Ifooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3o
EIF`oeFE[P;oE9J`0_mDUK<@oeBE/@[oDiJa1OmDUK400omCU[?oDIJeoe2G]@05oe6F/`;oDiJc0omC
U[401_mDUK7oE9J`oeBE/OmCU[7oDiJcoe6F/`KoDiJc00CoE9FcoeBE/OmDUK7oE9Fa0_mCU[42oeBE
/@03oeBE/omCU[?oDiJc00coDiJc00?oE9FcoeBE/OmDUK400omDUK43oe>F/@;oE9Fa0_mEU;<4oeND
/`06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomX
SZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSo
EIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/@0<oeVL^Om?U;7oCiBaoeJK^?m?U;7oD9Fb
odjA[_mDUkCoDIBaoefP_OmHVKOoBX^Y0_mFUkD02OmCU;;oE9Ndoe2E]?mFWK_oE9^iodbC/Om=T[7o
D9FdodjC/P02oe2E/P0EodjA[_mDUkCoFIbiodf@[OmGV[GoE9Fcoe2C/?mCU[?oEibkodR=[?mFVk[o
EYRhoe2B/_mGVKWoCi:_odf@[OmEV;GoEYNeodn@[_mHV;CoGIfi00;oDiB`01OoBi2]oeFJ^OmCV;Oo
DiRgoeBI^?m;T:ooDIJeoeJK^_mDVKSoBi2_oe2E]?mEV[WoCY>boeFJ^OmDVKSoDYFboe6A[OmHV;?o
FIVdodj@Z_mBU:koFYbfoeBG/P02oe>F/@03oeBE/OmEUK7oEIFa00;oEiBc00CoF9>coeND/omEU;?o
E9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooB
f^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?o
E9J`oeFE/?mEUJh2oeBF/0;oE9Fc4?mDUK405?mBUK3oEiZeoe>F/om@TjkoDIBaoeJI]?mFUkGoF9Ve
oeJG]Om;S:SoDI2_oeVI]OmHUkKoE9B`oeRG]_mEU;?oCi2^oe>F/om<TJkoEIZg0_mFUkD07?mEV;Go
EiZgoebO_?mIW;OoBHRWoeBC/_mJWK[oDYFboe6B/?mGU[GoCi2^oe:E/_m@UKCoE9VfoeBG]?m@TJoo
EIBcoeJE]?mNXKkoCY6/oeRI]OmKVkOoBhNSoe2<Z?mKV;CoE9FaoenR_omAU[<2odnD/@03oeBI]_mE
V[OoCiBa00;oDYNd00ooE9Vfoe>H]OmFVkSoBi2]odZ?[?m;T:goE9Nboe:B[OmQW[[oDHjZoe2@ZomI
VKCoCY2Zoe6D[omGV[D00_mCU[402?mDUK7oEIFaoeND/omGU;?oF9>coeND/omEU;?oE9Fc0_mAUk40
4?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/0;oE9Fc4?mDUK40=?m@TJgoEiVcoe>D/?mCUJooEIFaoeBD[omHUK;oEI:^oeND/OmGU;3o
FYFcoeVE/OmFTJooEY:^oeZC/OmHTJkoFiNcoeZG/omEUk7oEYRboeVE/Om>QjCoD92/oe2A[Om7R:Co
D92[ofBO_OmGT[3oCXn[oeFH/omEUK7oF9Fbof2K^OmIVKGoE9Ndoe6D[om@T:coFYFcoeVB/?mJU[;o
C8bWoeBF/?mASjSoEi>]ofbR__mPU[;oDHZUoefK]?mATJcoDi>^oeJF/OmJV[D2odj>Z@0BoeNG/_mC
TjkoDi>^oeBD[om;RjKoF9RcoeJF/OmIVKCoEiNboeZJ]OmIUJooCh^UoeRD[_mKVK;oEIF`oeJH/_mB
UJooCI2Z0_mCU[42oeBE/@;oEIBc0_mGU;<01_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00co
Ei>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVId
oockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK40
BOmEUK3oEI>/oejJ/_mJU[3oGIVaof2I]?mITj_oEhnZoebD[OmLU:ooEhnXoeZ@[?mISjWoFi6]of:H
/_mVVKKoEhZUoeb@Z?mRV;3oD8jSof2M/_mDR:3oJiffoeRBZ_mPW[GoGifdoeVE[omISj_oG9:^oefM
^?mDU[3oEi>_oeV@[_m?Q:?oFY>^oe>C[_mHV;7oEi2[ofBJ]?mOT:koEXVTof6M]OmIUjcoF9:XoejB
Z?mNS:CoH8jVof:I[_mHTJGoEXjUofBN]?mCRj;oGIN]of6I/?mPV[3oHYZaoe6;XOmLU:_oGYR^oeVA
Z?mLUZcoEXjUoebF[?mKTj[oDh^Tof:J/omBRjKoHibgoefI/om<RJGoEIF`oeRJ]?mAU:h00_mCU[42
oeBE/@;oEIBc0_mGU;<01_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;Co
CYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYe
omWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK40BOmGU;3oG9B[oeJ=
XOmJSZCoHYJ[oe:6W?mLT:GoH9:YoffP]Om/W;?oG8bRof>CZ_mTU:[oJIN_oeb:XOmSTJWoHi2Wof6;
XOmPSj7oHi^ZoeF:V_m_VJooIY2VoeZ=X_mFSJ7oFI2TofJJ/?mFQ9coGHfToeZDZ_mASZ?oI9ZdoenA
[?m/VkGoH9:Yoe6;XOmJU:SoI9R^oeZ8WomXTZ_oIiB[oe^?Y?mHT:7oFhjQofVFZOmZSZCoIH^PofNF
Z?mLSIkoHI6Uoef=XOmTTjOoH92ToeN6V_mRTZKoEhJJog2P]?mQT:CoFh^Oof:AYOmOSj?oHi:VofBD
Z?mRTJGoH92VoeR<Y?mXW[SoBH6JoeVCZomSXK[oBHVRoeFG/OmFVK<00_mAUk42oe>F/@;oE9Fc0omE
U;<01OmDUK?oDINaoe6G/OmCU[3oEIF`00;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jU
olSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF
]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK400omGUJkoFhnTofNFZ002omcoo`05of:AXooK
oooogOooodagR_mLQiX00_oPool0?OmTSJ7oTkc@ol[`oooRoooohOooomoooonSbMKoFh^Gof>AW_o<
l?oof__oomoooooEooooHY>TofBCYOoRoooogooooejEZOmFSj;oK9bcojWFkOoPooooe?ooof>HZ_mP
V:OoE8>Eon;ooooQoooogoooofJEYOmTUJ?oJINVok?Hj?oYoooof?Ooom3goooOooooh_ooofV@WooS
ooooh_ooofjCYOnjhO3ogOooomGloonUb]coh_ooon?ooomSRYWoKY>UokkUm?oRooooh?ooolcloomT
Uk;oII^eoenI/Om>RZCoHJ6joe2B[?m>TJ/00_mAUk42oe>F/@;oE9Fc0omEU;<01OmDUK?oDINaoe6G
/OmCU[3oEIF`00;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/0;oE9Fc3omDUK40BOmHU:coH96RofVCXOoEooooh?ooofnIYooRoooofoooog>HZ?m^Tj?o
i?ooom_ooomaUJGof_koomkooonce>GoWko>on?ooooQooooJI6Iolkfo_oOnooob>Cbok7Gi?o=nOoo
dooooeZ4U?oVoooohooooeJ9V_mQUZKoH8fRon;ooooOooooKY>UoeJ7UOmNSigoa>knonCooooXoooo
jOoookSRk_mQSIKoIXjHom[jooo]oooo/<OEok[Li_oTooooioooofj<UooQoOoog?[oog^GYOoRoooo
g_[ook?Ag?o0g>[ojOooon?ooomeTikocn_ionWooonbc]coZlcMomgoooo1loooEhfWodb4WOmYX[go
CXbUoe6C[OmHVkD01?mAUk42oe>F/`;oE9Fc00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<
oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYV
M?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`ooE9Fa
00?oF9B/of>DXomVSYX00_oVool05_mNPXkoi?ooonWooomaSIWoL8jIomcloooVooooIHFBogB<V?mf
S9Wo]lgKomG]nOo]oooojOooofZAU_oHooookOooog::U_mTQY3oL9RPofF=Uom]Tj02onKoo`0/ofRF
XomOTIcoH8NHonKooooYooooI8FDoffLY_mOSYSodoGoonCooooJlOoojooooloanomaUYkoK8jGon[o
ooobooooM8BAogNBVooWoooojoooogR?Uoo_ooool?ooog69TooWooookOooofn7TomhSY_oj?ooon_o
oom_RYGoiO_ooo3ooomlTYgoJXJDofR<X_mQSJKoJi^boebBZ_mDT:SoFI^codfC[?m=UJd2oe6G/@03
oe>F/OmDUK?oE9Fc00?oE9Fc00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[Ko
DIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZj
of9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`ooE9Fa04coEiF/oe^C
X_mYU9gojOooongooomdU9ooh?oooo3ooomgR8ooNHbConSooooRooooIXRBom;Mhooio?oomoooonom
oooXoooo^]_PofbHVOoRooooj?ooonkooooWoooohOooonCooomVQi3okOooonSooomWTYSoIiNKof:7
SooYooooj_ooof^;V?mRTIOoI96Gon[ooooZoOooLHVEonOoooo/ooooL8^Dog:?Uoo4fn?om?[oonc_
o_ncaLooj?oooo3ooomgRHgolO_oooCooombSICojOooon_ooomaQiCoMhZHongooooRooooKhbDongn
ooodooook?ooongoooo[ooooioooof:=X?mMTZCoEYNYodnHZom:Uj_oCYZaoe2H/OmCU[?oEIBc0_mG
U;<01OmEU;?oE9FaoeBE/OmEU;?oE9Fc00;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRd
odjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9Z
MOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`ooE9Fa057oEIF^oeF@X?mZ
UZ7okooooo;ooom/S9Woiooooo;ooomoS9CoN8^AonWooooBooooLYZTonScmoooo_oolOSoom3Niomk
TIcoKH^CofJ?UOoNoooojoooofYlR?mjUJ3oiOooomomoomnVJ;olOooonSnoomVRi?oJ96EofR6T?o[
ooooioooog>CW_mXTi[o/=SPongooooKk_coKh^FomC`noo_oooob=cWof^8T?mfTI[o`LWFom;Hi_oa
ooook_ooon[ooon0TiOom?koonkloomYQhoohoooonKooomlTj7oJ7n?on[ooooSooooLI>Loo7ooooU
lokoNi:Hoff5SooZoooohOcoog:K[OmOU:KoD9>TodfJZ_m<WK3oBiV`oe2G/omDUK?oF9>eoeZB]OmH
Tk?oEiBcoeBE/OmCU[400_mDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZoo
EiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_J
olgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<?oeBE/@0foeFE[_mKUJWoK9ZZon;j
ooo_ooooLI:SonCooooSnOooc>3[oj:mb?oSooooeooooej?WOo^oooomOooofMkQ_n`amGoio[oon7f
oomgU:Cob^KdongioooTkooo`=7Uonkoooo@iOSoM8FGonojooodoooo]]7RogNDX_miSZ7oj_goon_o
oomOOhcoJi6LomKjoooSn_oo`=[WofJ;U?nben3ok_ooom[`o_meUj7od_CnokoGhom/PXooZ/G@on[o
oooOo?ooLXfFoo3oooo^ooooKI>N0_oPool05om[RYcoLY6UonCooooMooooGXJBolKPkoo^oooo_M_V
ol7Qk_oZoooo^MW^ofJ@Y_mMU:SoE9R[odbIZom<V[3oCYZboe6F/omEU;GoF9>eoeZB]OmHTk?oEIFa
00;oDiJa0_mDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomX
SZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSo
EIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<?oeBE/@0?oeFE/?mKUjooG8ZQonWoooo]ooooHhVN
omoooooYoooob>?domkooooIooooYNCfof>N/?nI_LWog?Oo00;oi?oo01gofoOoojo;hOmXSJ3oKY6U
omG[oooVmoooj_ooolOSnOmfTZSoJ8:Ioo3oooo]ooood_GoolodoooXooooj_ooonOooooLnoooYlSI
onOooooYooooGWj=ofJBWOmXTYkod^cmon_ooon@]/?oY=3Kom[oo`02onCoo`0Qon;ooonefNGoLiFQ
on[ooooMo?ooII>Rom_ooooLooooH8VOof:8WooGoooofooooen>W_m/Sj;oa^Gion?ooooRoooo_^7e
oh2V_OmIRIooFYBXoeJJ[om=V:goC9R`odfG/_mCUKGoEIBeoeRC]OmHTk?oEiBaoeFE/OmCU[7oDINa
00;oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSN
looBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mD
UK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK408?mEUK7oFiNcoeb>ZOoVooooioooof6=Y_mWUJgo
FX2EofR<X_mWU:WoBH:Foe>K/om>UJ_oHi>Wog2K[?mGR9WoGY>Uof>G[OmMU:WoBhRKof:L/?mSTj[o
FhVQofFG[_mQV:goE8^Pof6CZ_mQSjOoGXjUoenI[OmGU:OoGiJ[0_oKool0:OmaU:Ooa>3eomokoooA
kOooLiR[of2DX_mMSYgoeOGoon3ooonfi?CoHIJToefBX?mAQI?oIYFUof2>W_mTTZ;oFXFFon3ooooO
ooooH9BYoejGZomHS:CoI9J_of^J]?mJSZKoEY2Vof:I[_mUTZWoH8ZRofFDZ?mRTZKoIiB[oeR6W_mS
VK7oF9J]odfAZ?mCVk?oDYbeodZ?[?mDUKGoEi>e00;oF9>c00CoEiBaoeBE/OmAUk3oDINa0_mDUK<2
oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmW
Ifooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3o
EIF`oeFE[P;oE9J`0_mDUK<@oeBE/@1>oeRE/_mOUK7ogoooomWnoomKSJKoFi6Yog6O]omPSZKoFi6[
oe^K]_mGYl3oCIZdoe:<Y?mRUZcoGibaodj?YOm=SJKoFYjeoeFM/om>UJ_oFIN`oe>?ZOmFUZooDIF/
oe^M]OmIVK;oEi>]oe^I/_m<TjWoCYJ/oeRL/onGe>Woeooooej4VOoHn?ooiooooj73g?mQSZ?oH9VZ
of:JZonJ`mWoh_ooolkooomNVJ_oFIRYoeNFYomRVJgoFhnTof2DZOmRUZ_ofoooomWooom=RJ7oD8jU
ofNP_OmFSjcoDhbYoeNC[om=SJKoFiVbof:E/?mJS:OoH9J^oeB<XomHS:CoDXRPof2L]?mFUZooC9:[
oe>K]?mBUkCoDYFboeFD]OmHTkGoFY:coeRC/omEUK7oDiJ`0_m@V;001_mDUK7oE9Fcoe6G/OmAUk7o
DiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocloooj
nOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2
oeBF/0;oE9Fc4?mDUK40D_mFUkGoCXZVofJC/?m_WKOoG9J^oe6=YOmERjGoFHnYoeRD/?m>Tk3o@iBa
oe6P__mGUk?oCHVUoe^M]omEV;;oFIbgoe:H/_m=UJkoAhfWof:S_omJV[KoEIRcodbB[?m?TZgoCI2[
oeVI]Om<SJWoE9Zdoe6I/_mCVK?oDI6ZoeJ<Y?mNS:?oJI6ZofN?Z?mWTjcoG8jUoeZDZ_mARj7oIYF_
of2>Z?mBRZ7oFYR_oe:FZomCUJ_oE9:YoeZD[?mHTZ[oFI>[oeZB[OmFSj[oEYJaoejP^_m9R:OoFIRg
oeNF]OmLWK_oDYF`odn@[?mKUk?oGIJcoefI]OmFTjooIZ:loeRF[omATJcoDYF`oe>I/omDVKKoCI2]
oeZK^omGTkGoF9>eoeZB/omHTk?oEIFaoe6G/?m>VK3oD9R`oeBE/OmDUK<2oe6G/@0@oe>F/?mEUK3o
FY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf
00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mD
UK<@oeBE/@0BodjA[_mRX[koEH^WoeR;Y_mIUjkoEiR^oebH/_mITZooEiJeoeBI^?m?W[go@hn_oeFF
]_mLVKSoDIB_oe2F/?mAU;7oD96_0_mJVkT0=Om?SZgoDi:aoeNH]_mEU[CoEiRfoeBE/omEU;?oGIbk
odj?[OmFUkGoDY>aoeVI]OmJU:coGYB/oe^?YomMTJWoFY2ZoeR@ZOmKUk7oGYZdoefE/?mESJSoGi^g
odj>ZOmFV;;oEYVcoeFE/OmFU[7oEiB`oeNE[_mHUK7oFIVdodn@[?mEV;?oEYNeoeFG]omCUKGoBXb/
oeNJ]omAU;7oDI:^oeBD/?mEUK7oE9B`odb=ZOmKW;SoE9NbodnD/OmBUkCoF9fjodf>[_mHUkSoEi>e
00;oF9>c00OoEiBaoeBF/?mAUk3oCYV^odjI/?mDUK7oE9Fc00;oDINa013oDiJ`oeFE/?mJTk7oFY>a
oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYV
M?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`ooE9Fa
01;oDiJaoe6G/OmCU[7oF9B`oeRD[_mDUj[oDiNZoeFE[_mGU;7oEIBeoe6F]om=V;OoCYNgoeFD]omG
TkGoE9FcoeBE/OmHTk<3oeZB/`;oF9>c1?mJT[<2oeRC/`?oFY:c00OoFY>aoeRD[_mGUJcoEIJ/oeBF
[?mEUJkoEiF^00;oF9B`00CoE9J`oe>F/?mEUK7oEIFa0_mGU;<2oeBE/`;oEIF`0_mDU[02oeBE/@03
oe>F/omAU[?oDIJc00GoDiJc0_mDUK400omCU[7oDIJcoe6F/`02oe6F]@04oe>E]OmDUKGoEIBeoeND
/`;oF9>c00OoEiBaoeBF/?mAUk3oCYV^odjI/?mDUK7oE9Fc00;oDINa013oDiJ`oeFE/?mJTk7oFY>a
oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYV
M?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`ooE9Fa
01GoDiJaoe2H/Om@V;3oE9FaoeFE[_mAV:[oDIVXoeBF[_mDUK7oE9Feoe>E]Om@UkGoDIJeoeNC^?mH
T[OoEIBcoeFE/OmHTk7oFY:coe^A/omJT[<00_mGU;<01?mHTk?oFY:coeZB/omHTk<2oeND/`0FoeZB
/omKTK?oFY:coeRC/OmEUK3oDiN^odjI/?m=VK3oD9R`oeBF/?mJTk7oF9>aoe2H/Om=VK7oE9FcoeND
/omJT[GoF9>eoeBE]OmDUK?oEIFaoeFE/0;oDiJ`0_mEUK401?mCU[7oDINaoe6F/omCU[<2oeBE/`0;
oe6F/om@Uk?oDiJaoe>F/OmAU[?oD9Ncoe2G]OmAU[GoDiFeoeBE]OmEU;D00omGU;<02?mGU;7oEIFa
oeBF/?mAUk3oD9R^oe2H/?mDUK7oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;Co
CYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYe
omWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK404OmCU[7oD9R`oe2H
/?mAUk7oDiJ`oe6IZ?mAVJOoDiN/oeBE/OmDUK?oE9FeoeBE/OmEU;?oF9:hoeRB]omGU;7oEIF^00;o
DiJa00GoEiBaoeFE/Om@V;7oCYRaoe6G/@02oe>F/@03oe6G/Om>V;7oD9Ra00;oEIFa01CoE9Faoe>F
/OmCU[7oD9R`odZJ/Om9Vk7oC9Zaoe6G/OmJT[?oF9>codfI/om:V[?oE9FcoeRC/omKTK?oFY:coeFD
]OmDUK?oEIF`oeFE[P;oDiN^0_mGU;001?mCU[3oDIN`oe6G/OmCU[42oeFE/@;oD9Ra00?oDiJaoeBE
/Om@Uk<00_m@UkD01?mAU[GoDiJcoeBE/omEU;<2oeND/`03oeND/OmEUK7oE9Fa00;oDiJ`0_mAUk00
1_mDUK7oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jU
olSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF
]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK401OmCU[3oDIN`oe2H/?mAU[?oDIN`00;oDIVW
017oDIR/oe>F/OmDUKGoEIBcoeFE/?mGU;7oF9:hoeRB]omGU;3oE9J/oe6G/?mAUk7oEIFaoeBE/Om=
VK7oC9Zaoe2H/@02oe6G/@0:oe2H/Om<V[7oCIVaoeBE/OmEUK7oDINaoe2H/OmAUk7oCYRaodbJ/@;o
BYZa00goD9RaoeZB/omHTk?oC9VcodZJ/omDUK?oFY:coe^A/omJT[?oEIBcoeBE/OmEUK3oEIF^00;o
DIR^00?oEiB`oeRD/?mDU[000_mAUk003?mCU[3oEiBaoeFE/Om@V;7oCYRaoe>F/OmDUK7oDIJcoe2G
]OmAU[GoDiJcoeBE/`;oEIBc00GoEiBaoeFE/OmEUK7oE9Faoe>F/@04oe>F/0;oE9Fc0_mAUk404?mC
U[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocloooj
nOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2
oeBF/0;oE9Fc3omDUK42oeBF/00Foe>F/?mAU[GoDINaoe6IYomAVJGoDIR^oe>F/OmDUKGoEIBcoeFE
[_mGU;3oEI>hoeFD]omDUZkoDiN/oe>F/?mDUK7oF9>aoeND/Om>V;7oCIVaoe6G/@;oE9Fa00SoDINa
odfI/Om>V;7oEiBaoeRC/OmDUK7oDINaoe6F/`;oD9Nc00?oCYRcodbI/om@Uk<00_mHTk42odfI/@03
oeFE/OmJTk7oEiBa00;oEIFa00?oEIF`oeND/?mDU[000_m@V;000omHU:koFY>^oeBF/002oe6G/007
oeBF/?mHU;3oEiB`odjH/Om=VK7oDiJaoeBE/@02oe6F/`03oe>F/omDUK7oE9Fa00;oEIFa00?oEIF`
oeBF/?mCU[001?mCU[02oeBF/006oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jf
oe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z
^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/@0:oeND/?mE
UK7oDiFgoe>F/omCV:OoDiVUoe6H[_mAU[?oDiFgoeBE/`;oEIF^00_oDiFhoe6F]omAV:koDIRZoe>F
/?mEUK7oFi:aoeRC/Om@V;7oCYRaoe>F/@02oeFE/@0;oe>F/Om>V;7oD9RaoeRC/OmKT[7oEIFaoe>F
/OmAU[?oDiJcoeND/omEU;<00_m>V;<2oeND/@;oCYRa00GoEiBaoeRD/?mCU[7oDIN`oeBF/002oeND
/006oeBF/?m>VK3oD9R`oeRD/?mJTjkoE9J`0_mAUk001omDU[3oF9B`oeND/?m>V;7oCIVaoe>F/OmD
UK<00_mCU[<00omDUK7oEIFaoeFE/@02oeFE/003oeBF/?mCU[3oDIN`00;oDIN`00KoDiJ`oeBF/?mE
UK3oEIFaoeFD/omDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefA
YomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQ
TJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<?oeBE/@0HoeFE/OmHTk7oF9>coeFC^_mDUKGo
E9NXoe>HYomAUk3oDIJeoe>E]omDUKGoEIJ/oeBF[_m@U[SoCIRhodfJ[_m>VZ[oDiJ`oeND/omLTK?o
FY:coe2G/om=VK?oE9Fc0_mGU;<05_mDUK?oCIVcoe2G/omJT[?oG96coeND/omCU[?oDIJcoeFD/omL
TK?oFi6coe6G/Om>V;7oEIFaoeND/OmAUk3oDiJ`oeRD/?mGUJkoCIV`odbJ[_mDUZh2oeND/00>oeBE
/Om=VK7oCYV`oeRD/?mJTk3oDiJ`oe2H/?m@V;7oDiJaoeRC/OmGU;7oCIVcodbI/omAU[<2oeBE/`04
oeBE/OmEUK7oEiBaoeND/0;oEIF`00OoE9J^oe6H[_m@V:koD9R`oe6G/?mCU[3oE9J`00;oEiBa00Ko
EIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8
g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[Ko
E9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`ooE9Fa01SoEIFaoeND/OmGU;?oEI>hoeBD]omAV:coD9VZ
oe>F/OmCUKGoDIJgoe6F]OmCU[3oDIN`odfH^?m<V;SoC9Z`odjI[_mCU[7oEIBcoeZB/omGU;?oCYRc
odfI/omCU[<2oeND/`0?oeBE/om=VK?oCIVcoeFD/omHTk?oEIBeoe>E]OmAU[GoEIBcoen?]OmOSk?o
EIBcoe>F/OmEU;?oEiBa00;oE9Fa01KoEiB`oe>F/?m9Vk3oBI^`oeBF/?mHU;3oEiBcoeBE/om>V;?o
CYRaoeFE/OmGU;3oEIF`oeBF/?mCU[7oE9FaoeRC/OmEU;?oCIVcodbI]OmAU[GoE9Fe0_mCU[<2oeBE
/`;oEIFa0_mDU[03oe>G[P;oDiJ`00GoE9FaoeFE/OmEU;?oEIBcoeBE/`02oe6G/@0@oe>F/?mEUK3o
FY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf
00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mD
UK<@oeBE/@19oeFH/omBUK;oEYFfoe6C/om7Uk3oBYZaoeBE/OmIU[GoCY>`odnI]_m?VkGoCIReodbG
]_m?V[WoCYZdodbD[OmEUkOoDI:boeZI^?m8RjSoD9bfodjK]OmDVKKoEiNcoeZE/om@SjkoDYfjodZJ
]Om2SJ[oCYReoeBF^?mHV[goCIBdoe^L_?mNSkOoGhbcoenC^?mITK;oFiNioe>B/OmBTK3oEIJdodnD
/Om?VkGoAiVaodZG/OmAT:ooGiZjoenK_om>S[7oCiBcoeVP__m6T:_oE9NboeV@[omTVKWoFYFcoeNG
/omET[7oF9VgodfH]Om>VkWoEiVkoe:B]Om?U;?oEYfkodV@[_m@UkGoD9FdoeBF]_mEU[CoEIFaoeND
/003oeNE[P04oeFE/?mDUK7oDiFeoe>E]@;oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF
]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonS
Z[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK40B_mCU[7o
DINaodf@ZomGU;7oEiZgodJJ/_m:W;CoFiJdoeJ=[?mFUk?oCYRaodbH/_m>V[CoCiVdodnF/_m@U[3o
EYNeoe>@[omGU;?oFIZfoeVO^Om<U[7oDI^fodR9YOmGU;7oEi:`oeJE]?mAVkKoBiRdodnO^_m@VkSo
E9JhodJ6ZOm=U;CoB8ZZoe^A]OmRT[SoGY:goeJ>[om=S:_oG9fkoebI^?m?SZgoDiReoe6M]om<W;Go
Ci^eoe^J^Om>RJ_oB8NZof6SaOmIW[goBI>`oe2M]omFWKWoDHJVoeV:ZomHTk7oEIFaoeJE]?mBUK;o
BiRdod:?ZomATkGoF9NhoeFJ]omEW;SoCINdodnI]_m?U[KoDIJgoe>D]?mCTjooF9B`0_mJTjh00omH
U:koEiB`oeBE/@02oe6F]@;oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_
oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWK
f_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc4?mDUK40??mIVKCoEY>_oeZC[_mH
VJooA9FVodRFZ_mSV;OoH8j_oeZC/?mFV;3oDYV]odnFZ_mAUJ[oEIN]oeZF/?mKT[3oIYBeof6D/omD
U;3oDINaoe>E[omDU:ooLjc:oe>;[?mFTK7oEIFaod^AZom>UZooFj2modJ9Y_mJUK?oIJ:ooeVN^om@
UK;oEY6aoeVB/?mBTZkoEIRcodjF[om>TJcoEI2^oeJ?[OmASZ_oFY^god>=Y_m?Uk3oE9B`oeRE]?mJ
VkWoDIBaodV@[?m8U:koC9jdoe6M]OmNUkGoHIJfoe:B[_m?TZgoDYF`odR@Z@;oDZ:k00_oG9nloe>C
[om=SjWoBHbVoe6G/OmBUkCoDIJeoe:G^?mATk?oD96_oeND/@02oeRD[P03oeNE[_mEUK3oDiJa00;o
DIJc0_mDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGo
b=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJf
oeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/@19odj=[?mETZooG9F`oe^L/?m>X:koC9^/oefB
/_mPS;7oFi:aoe:?Zom@TjKoEiZ[oeRIZomETZOoEXf[oen@[_m/Tk3oFHFPoeNG/?mAV:koG9Z_oeJ>
YOm>Pj;oH9Riodn>[OmLWk[oE9J/odb>Y?mHVkKoF9RdoeVAZ_mCSJGoBHbVoeFK]OmBTZgoFYZeodZB
Z?m:Uj_oEjFioe6I[omSW;OoHYFboeV?Zom?RjGoGJ6hodnF[?m?TJ_oFYZeoeRH/Om@TZ[oEijdoe:M
/_m1TZOoDYjeoeZC/?mERZWoGZ2joe2F[omIW;KoDiVbodJDZ?m5TjOoDI>[oeRD[?mTXKKoEiFZoebL
]OmBTjooC8j^odnA/omDU[SoF9ZjoeFE/@02oeND/005oeNE[_mEUK3oDiJ`oe6G/OmAU[<00_mDUK<2
oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmW
Ifooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3o
EIF`oeFE[P;oE9J`0_mDUK<?oeBE/@1;oeBE/omIVkkoF9RkoeJC[om<Sj;oBIbZodfN/OmFS;;oHI2l
oeV@^OmIV;WoEiV_oe6DY?mDTjCoG9V^of2F^?mRT;;oeOSoon3ooom;SJ?oE9f`oeZHYOmMUJCoGiNb
oejK^?m@UK;oDYZ`oe6EX_mCUjCoCiJ/oeVK/omITZ?oGiVWoe:FZOmAVJooCY:WoeNP/om9VjWoBj6^
odNKY_m9UJ?oChRLofFE[?mQT:[oHIN_oe>DZ_mEVJkoCHnWoeRI[omETZGoFYNYoeFFZ?mDVJWoAiBT
oeFN/Om>QYooJYfjoe2>Yom>T:KoFY^aoeRK[_m:UZCoGZJeoebGZOmFRYooFHjPoeB;WomITjWoFIN`
oeJE]?mDU[SoDYBfoeBF^?mCUKGoE9Fc00;oEIF`00CoE9J^oeBF/?mCU[3oDiJa0_mDUK<2oe6G/@0@
oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?co
oo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE
[P;oE9J`0_mDUK<?oeBE/@1=oeBE/omATkKoAhJWof:H/?mITj7oCINPoeVQ/?mHRZgoHhjioe^?]omF
SjgoEi2QoejDW_mPU:7oGXjRoef>[_mWT:koj_ooonWooomGRj3oG9JZoef=UomSTYcoII^codb8Y?mG
U;7oE8jToe^AVomRWJGoCi>Voe6BY_mZUZ?oHH^GoejIZOmEV:_oF9NYoe6BY?m5TIkoFZZeod6?VOmH
W:WoHI6UofZ@YomVRjGoI96Xoe:;WomKVZcoGIZ_oenFZomTTj?oHHnNoeV:VOmTW:_oE9>RoenL[_m]
Uk3oGHFOof>E[_mOUZ_oH9BYoeJ>WomHUZ?oFiFQoeN2T_mfWJkoJIBTofVHZ?mCQicoGiN`oefJ]omI
V[[oC96bodb@/omAU[OoDiJcoeBE/OmDU[000_mDUZh01?mCUjkoE9J`oeFE/OmDUK<2oe6G/@0@oe>F
/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[i
o`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;o
E9J`0_mDUK<?oeBE/@1=oeFE/OmHUK;oIYZbom_ooooToooob_onomSooooOoooohooooj;>jooMoooo
dOKnogFEU?mhU9Oof?GmonCooon_c^?om?oooo?oooo3fO7ojOooomkfoomaTYWoGXjRofJG]Oo9jooo
j?ooon_ooonhgnKoHZ6`oeVBXooZo?oomOooofJ=W_mKSZ?oI96VokWXo?oFoooo_OSooffW/omHRISo
]MGZomG_oooZoooof_goolgjoomYVJooC7ZBofR>Xoo>j?Wol?ooon_oooo=kOcoKYRXof:8Voo^oooo
l?ooog2>Z?oTooooiooooff<X?nG_L[of_coon_nooo`ooooc>kjokOQkomOSZ3oFHnWoe:>Z_mDUKGo
CiBeoeFK_Om@UkOoDIJeoe>F/omDU[001?mDUZh01_mEUK7oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a
00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000co
JVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc4?mD
UK40D_mEUK3oFhjSon_ooooTo?koLIZFofJCU_mVRZ3oIhbYoej<Y_o3k_ooj_ooolOIfOo:f=WolOoo
olc]oom_RYgonOkoooknoooMkOooa=[_ooCooooCj>goJ8fPokkWoooVooooa=[bol_NiOoYoooo^Ngk
of>CXOogoooonOooof^<WOm^VJcoGh:HonCooooMooooHHnNof>AX?nTc]coiOooomohoom[Qico/mKZ
omOoooo;n_ooIi6Yolo_oooaoooodMoZojk0c?o[oooof?coof^<Voo[n_oom?ooog:;XOoYooook?oo
ogNAX?oLn_ooj?oookW7d_n[^LCoj_ooomGmoomPSYkoGi>YoeRD/?mJVk_oCiJfoe2I^_m@UkOoD9Ne
oe6F/omCU[3oE9J`oeBF[_mDUZcoE9J^oeFE/OmDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGo
E9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_o
oj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<?oeBE/@1Coe>F
/OmAVkKoEiBYon[oooo`ooooI8Z=ofFDW?mRT:SoGi:aoeNC[omNTZSoi?ooooCoooo/m_ool?ooohZd
b_m]T:Coo_gooognoom]TikoHI2Hoo3oooodooooJh6Fon?ooooLooooHY2Mog>CT_oZoooofOgoofn@
Woo/ooool?ooofF?VomRTJ?oKI2Ton7ooooSooooJY:NofJBWOo?nOoohoooojW=gOmRSIgoIiRWoeVC
XOmKTjCoJIN^om[ooooZooooKXZ=ogRGV_mYTI?oH92DofVFW?oXooookOooog2BW_oOoooog?koog:G
WOmUTI;oJi>CokgFf_oEk?;ojOooomWooomSSYooI9N/oeB@Z_mEU[CoDiZjodRA/_m>UkOoD9Neoe6F
/omCU[3oE9J`oeBF[_mDUZcoE9J^oeFE/OmDUK<00_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF
]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonS
Z[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK404OmCU[7o
@hjUoenI[OoZoooomOooog:?Tom[Ti_oGH^RoeZ@[?mMWKKoEXfQolGLj_ohoooon_kooloOk_mbWk;o
JY6R00;oooko01ooJHnHof6@V?o/ooooloooogN8W?oUoooof_oooffLY_m_ShkohoglonWooomcSigo
l_ooongooomPSiWoIIJUoej1UOoYooooioooof>7UOm[Tigog?ooon;ooomQSISoFY2Loe:>VOmKWJWo
ChjMoeZ=X_oPoooojOoo00;oi_oo01[og_ooomoooom`VIgohOWoonkooom_Si[oi?ooonOooomWRXko
^nGTomWooooWooookOooomgnoonjh>goKif]oeR<XOmFTZcoE9FcodjE]OmAV[[oCYNgoe2G]OmCU[7o
DiJ`oeBF/0?oE9J^00KoEIFaoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF
[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoI
fm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`ooE9Fa00KoE9J^oeRKZomXV:;o
mOoooo_jooobool2on?oo`15omcooomOVJGoG8bFongnoooko?oon_Onoo?moomVSY[oI8ZEoo_ooooh
moooKH:CogNCXOobooookOcooh6FZOoYoooojoooofj4VOmbQH_ol?ooonKooomPOHgonOooooGooomT
T9_oGY:Pog>FZ_oPnoooh_ooofZ:VOm]UIoog?ooom7moom`XZ_oF9BNoe>GX?mIXZ_oI:ReoeF<X?oP
ooook_ooogZ8TOmlSiKokOooon;ooomSOXOomooooo;hoomhR9Ooi?SoonoooomiSISog?Woon_ooooU
locobMWVof^;V?mYTj?oFXVKof:F[?mRW[SoDiBbodZ?[_mBVKOoD9Neoe6F/omCU[7oE9J`00;oEIF`
0_mDU[001_mEUK7oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mM
TJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7o
HI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK40>_mEUZcoEiNSof:AVOogooooo?ko
ogF8S_mYRXooJY2Moen?WOmITikoa?KoonCjoooFgNOofmoZon_kooo7lokoHhnJoncnooogoooogO;o
okkIj_o]ooooeO3iofj=XOnmfo?oj_ooolkRn_o2f>GoiOoool7[nom/TJ?omOoooo3moonhh_;oF8NI
of^:Woo]ooooj?koogbGZ?m/SIcogOooonCooomEOhgoJin/oejJYOm6R9KoDI2QoeN9X?o4j?ook_oo
olSHionmcmgok?ooolOUkomgSi_oloSooocmoomiQID2oo;oo`0@ogF7UOoZoooojoooogZ:VOnaa=Go
i_ooolOeoomOTZOoGIF/oe2=ZOm@TJgoEY^hoeBI]_mAU[?oDiJaoeBF/0?oEIF`0_mDUK401_mEU;?o
E9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooB
f^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?o
E9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK40C?mDUZkoDiFUoeZ>W?o]oooojocoof^?WOmZV:OoHI2T
ofFI[_n8bM_oe?ooom?ioom_RYooMI2UomWloooFooooTlcMon3ooooVoooo]n3bomgooooJooooEXBA
oeZ9VomcWK?ob^ooomgooooPoooo_^kjoe^DYOmNTJCoioooonSoooo@looohOooonkooooZn?ool?oo
onkooom/PiGohO_ooo3ooon[`MKoI8>Hof^AY_mVU:_oJ9J^og:F]_m/Rj[obnOoonWooooWoooo_Mk_
og2HY?m_Sicom?oooo;joom_PY7okOooon;ioom`RicoXlSHomSooooYooooh?ooolSaoonUf>_oEXfR
oejH/?mEUK3oE9NboeFK]Om<TZcoDiJ`oeBF/?mEUJh2oeFE/005oeFE/OmDUK?oE9FcoeFD/omDUK<0
0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^Go
IfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`
oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK400omDUZkoH9naoeJ;W@02onOoo`16oeR7VOmLU:GoI9B[oeB8
W_mJVjooChfRoej@YomPS:GoIY2Yof6@Z_m<RZ7oGifbofJI[_mPT:CoEi2Soe2=WomSXK3oDhjNofNN
/_mEQikoGXjUoe^;XOmHSj?oGIZ/oeRGZOmFT:KoII6ZofB<YOmUSJKoK92ZogRB[OoUoOooj_ooof^:
W?mQPY?oZLKFonkooooFj?ooNi>]okKHlOoMooooa?;ooen6YomYT;7oHHRUof:<Y?mVTjSoI9>Uof2A
X?mSSI_okOoooo7ooomiU:GogOkoonKooom[TJCoGY6RoeV>X?mQRj?oKiVbof6AYomFSJ;oHI^coeJD
[OmDU[3oC8nZodjD[_mIW;KoE9J^oeFE[P;oEiF^00KoEIF`oeBE/omDUKGoDiFeoeFD/omDUK<2oe6G
/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfoo
o?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`
oeFE[P;oE9J`0_mDUK<?oeBE/@07oeFE[_mBRikoIIJWonCooooPooooe_ooolCoo`02omcoo`11oeVC
YomHUJSoGYJ]of2F/?mQU;7oG9B_oeJDZomETj[oEXjWoeF?YomLW[CoDIR/odjEZOmCU:[oI9beoeb@
Z?mSVK7oEHnWoebL]OmGVK7oD92YoeNC[OmRUkKoGYB`oe^EZomJTjKoGI2Soj?DiOo;ooooF9BLofRS
ZomNTYgoZ/oQon3ooooToooogooookC/oomQWKGoGYNdoeB=Z_mTWK[oEHjYoeF?YomFTjKoEIBSoeVA
W_oKo?oojOooof68UooMooooe?oooenDY_mHVJ_oFYbboenH/omJT:coHIVboeB>Y_mOVkGoD92[oeNH
]?mEV;?oE9Naoe6D[_mEUJh00_mGUJ`01omGUJkoEIF`oeBE/omDU;OoDiFgoeFD]OmDUK<00_mAUk40
4?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/0;oE9Fc3omDUK40B_mEUJkoFiFYof6EZ_mMRZ7oGXjUoeRGZOmIV:[oG8jUoen?Y_mITjOo
FiV^oeFC[?mGU;3oE92/oe:?ZomKVkCoDY:[oeVF/omEUK7oCiF^oe:M]?m;UJkoE9NboeJB[_mNU[7o
E92ZoeNG/_mGWKOoAHZWoebL^?mHUK;oEY6aoeJC/?mDUZkoDiJYoeJEYomFV:SoDINSoeFMZOm:T9[o
Fi^Wof:EZ?mTTJKoH8jUoejBZ_mDTZWoEIRboe6D[omGV[GoD96]oe:C[omEUk7oEYZ_oe>HZ?mGUZOo
IYFYof6<WomMT:7oHIVZoeVBYOmHUZ_oBY:XoeFP]om5R:?oFi^goeBA[OmMVkCoCHfXoeVK]OmATZko
DiJaoebO^OmATjgoEIF^0omGUJh01_mEUK3oE9FcoeBE]OmDUKGoEIBeoeBE/`;oDINa013oDiJ`oeFE
/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmW
IWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02
oeBE/`ooE9Fa00GoE9J`oeFE[_mGUJkoF9B^oeNE[P02oeBF[P;oEiF^00?oEIF^oeBF/?mDU[000omD
UK401OmDU[3oE9FaoeBE]OmCUKGoDIJc00;oD9Nc00GoDIJcoeBE/omDUK?oE9Faoe>F/@02oe>F/`;o
E9Fa00CoEIFaoeBE/OmDUK7oDiJ`0_mDU[03oe>G[P09oeBF[_mGUJkoF9B^oeRD/?mGU;3oE9Faoe>F
/OmCU[?oDiJa00;oDiJ`0_mCUjh03_mCUjcoE9J/oeNE[?mHU:coEIJ/oeBF[?mDUZkoDiJ`oe2H/?m@
V;7oDINaoe>F/OmDUK7oEIF`1_mDUK401?mDU[3oEIF`oeFE/?mEUK02oeBE/@;oE9Fc00KoEIBcoeBE
/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][U
ofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF
/?mEUK3oEIF^0_mDU[02oeBE/a3oE9Fa3omCU[402OmCU[?oDiFeoe>E]OmCUKGoDIJcoe>E]OmAU[?o
DiFeoe6F/`03oe>F/`?oDiJa0_mDUK42oe>F/@0?oe>F/omCU[7oDiJcoe>F/OmCU[?oDiJaoe>F/omC
U[7oDiJcoe>F/OmCU[?oDiJaoe>F/omCU[7oDiJ`00GoDiN^00CoDiJ`oe6G/?mCU[3oDIN`1_mAUk40
0omCU[7oE9FaoeBE/@0=oeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jf
oe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z
^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/A3oDiJa0omD
UK<01OmCU[7oE9Fcoe>F/OmDUK?oDiJa00?oE9Fa1omDU[003OmDUK7oE9J`oeBE/OmDU[3oE9FaoeBF
/?mDUK7oE9J`oeBE/OmDU[3oE9FaoeBF/?mDUK401omDU[000omDUK7oDiJaoeBE/@07oe>F/A3oE9Fa
00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>
YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mE
U[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/a3oE9Fa4?mCU[401_mDUK7oE9J`oeBE/OmDU[3oE9Fa
oeBF/0CoE9Fa5_mDU[02oeFE/003oeBE/OmDU[3oE9Fa00GoE9Fa00GoEIFaoeBE/OmEUK7oE9FaoeFE
/@0AoeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^
oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgL
hOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<PoeBE/@06oeFE/?mEUJkoEIF`oeFE[_mE
UK3oEIF^1?mEUK06oeBF/0ooEIF^00KoEIF`oeFE/OmEUK7oEIBcoeFE/OmEU;<5oeFE/@06oeND/OmE
UK7oEiBaoeFE/OmGU;7oEIFa4?mDUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>e
oeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoock
oonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc8?mDUK400omD
U[3oEIF^oeFE[P05oeFE[P03oeFE/?mDU[3oE9J`00?oE9J`00?oE9FaoeBF/?mDU[003_mEUJh00omE
UK3oEIBcoeBE/`04oeFD/`;oEIFa1omGU;42oeFE/@ooE9Fa00KoEIBcoeBE/omAUk7oDINaoe>F/?mE
UK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmW
IWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02
oeBE/b3oE9Fa2?mDU[03oeBE/@?oDiJa00?oDiJcoe>F/OmDU[003omDU[001?mDUK?oDiFeoeBE]OmD
UKD4oeBE/`CoEIFa0_mGU;400omGU;3oEIF`oeFE/@0?oeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3o
EIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7o
IfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`
0_mDUK<PoeBE/@?oDiJ`00?oE9J`oeBE/OmDU[001?mDUK42oe>F/@;oDiJc0_mAU[<04OmCU[7oDiJ`
oeBE/OmCU[3oE9Faoe>F/?mDUK7oDiJ`oeBE/OmCU[3oE9Faoe>F/?mDUK7oDiJ`oeBE/OmCU[7oDiJc
00?oDiFe0_mCU[<2oeBE/`;oE9Fa1?mEUK42oeFE/13oE9Fa00KoEIBcoeBE/omAUk7oDINaoe>F/?mE
UK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmW
IWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02
oeBE/aSoE9Fa01OoD96]oeZK]omHVKGoD96]oe:C[omFUk?oDiB`oe6D[om@U[3oDYRbodjD[_mEV;?o
DiJcoe6D[omJVkWoDiBboeBE/omAT[3oFIZhoeNJ]om:S:coFYnnoe>H]`02odjC/00@oe>I/omDUkCo
DiVcodnB[omGWKOoC8n/oeFK]OmBUK;oDYRboe2C/?mCVK?oDiJcodnE[omIW;WoD9FbodV>Z`;oE9Vf
00goD9FbodfB[om?U;7oEiZeoe:E/?mDUk;oEYVdoe6B[_mIV[KoDiB`odZ;YomEU[;oDI:^013oE9Fa
00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>
YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mE
U[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/aSoE9Fa02?oFibhodR9YOm;S:SoFIZfoeJG/om@TJgo
E9Faoe>F/OmDV[CoCiN`odjC/?mCV;GoEIReoe2A[omBTk7oEYFdoe^J^OmEUK7oBhZYoeZI^?mIV[So
DYFboeBG]?mAU;7oEibioe>H]Om8SJ[oBi2]oeRM^_mGW;WoBi2]oe>H]OmDVKKoD9FbodjC/002oe>H
]@08odfB[om?U;7oDYNdoeNM]om=TjgoBhjYoeFK]OmGW;T2odbB[009oe:H/_mAU:ooEYVdodf@Zom@
TjkoE9NboeJI]?mNXKcoEIRc013oE9Fa00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC
]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?ol
noooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/a3oE9Fa2?mE
UK40<_mDU;3oFYZfoejN^_mIVKGoD92/oe6A[OmEUK7oE9Faod^AZomDW;GoF9jhodnB[OmCU;3oG9bh
oeJC/?mBSjcoChZXoeVE/OmLUkGoFIBboeND/OmDTJkoEYJboe6B[_m?TZooD9>`oebO_?mKW[_oBhj[
odnB[omNXKkoC8n/odf@[OmGV[OoFYfjodnB[omBUK;oFYfjoe:E/_m>TJcoF9^eoeNJ]?mCUJooCY6[
oe2C[_mEV;;oEYVcoe>F/?m>TJcoFIbg0_mCVK<01?mBV;;oC9:/odjD[_m?TZd@oeBE/@06oeFD/omD
UK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;J
iOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omD
U[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/@SoEIFa02;oDi>_oeJF/_m;RjOoC8bXoejN^_mJV[KoChn[
oeJG/omJWKSoCYB]odjAZom?TJ_oEiB`oeFA[OmCS:WoIinjofjT`?mCRJGoFY2/oeR>Z?mMUJkoH9Ra
oeNAZOmMVK?oChnZoefN^_m@TJgoDI:^oe>D/?mEU[;oDiB`oe6B[_mKW;SoDI:^0_m?T:`04OmDUK7o
DI:^odf>Z_mPX[coDI6Zoe2AYomIVK;oFi^doeRH/OmDU[3oD9:/oeFG/OmBTjooDYF`oe2C[_mDV[Co
F9^f00;oC9:/00?oFYfhoeBE/OmDUK403_mDUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a
00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000co
JVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc4?mD
UK49oeFE/@0LoeZJ]_mHV;CoDY:^oeFE/OmIVKGoEiNcoe:B[_mATjgoDYB/oeJF[omGUJkoG9J^oejD
[_mJSZKoGhjXoe^9XomTTZ[oJiVaof>AZ?mKRj7oH92Vof6DZOmOTjWoGiVaoeVE[om?RjGoH9bfoe2<
YP;oEI6[00GoGi^eoeFAZomFTZcoFIF_oeRD[P02oeZF/00BoeB@Z_mFTZ[oFiF[oeZDZ_mOVK7oDXjV
oe6=YOmLV;;oEiF^oeZH/OmNW[WoEiNboe6B[_mAU:ooEiRfoeNJ]omDUkCoEiZg4?mDUK401_mEU;?o
E9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooB
f^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?o
E9J`oeFE/?mEUJh2oeBF/0;oE9Fc4?mDUK48oeFE/@0hoeBD/?m;RjOoFIVeoebL^?m9RJGoD92/oejN
^_mATJcoDi>/oe^I/?mIUZ_oFi>ZoeN=YOmNT:OoJYR_oej8X?nWd>Koh?ooomcooooPooood__ooi_6
eom^VJ[oFXVKoefAYomGSjKoGiN^of>K/_mESJCoIIfdoebDZomHT:OoFI6XoenG[_mLU:_oFi>ZoeJ>
YOmJTZWoHi^boeB<XomQV:goF8nToenFZomHSZKoFY:Yof>K]?mFT:SoEI6[oe6=ZOmBSj_oGIfioeRH
]?m@SjkoEYNeoe>D/_m=SZ`@oeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGo
E9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_o
oj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/@SoEIFa
00?oFi^goeBD/?mDU;000_mJV[H0<omCTjooDY:^oeZJ]OmGU:WoF9:Voe><X?mXW;7oH92VoeZ7W?me
W[;oHhVNon3oooo1i?OoJ8^Noi:fa_oTooooeogoof>9U_m_VJOoIiN[odn3VOmVV[3oE8RNoeV=XomQ
UJ_oGI6Wof2DZ_mMTJOoG92VoeJ:X?mXW;;oGI6WoeF9Wom]XKOoFHfRof2CZ?mFQYcoHiJ[of6CZ_mO
TjWoH9B/oe>9XomTW;GoI9bgodj7Y?mJUK?oG9Vfoe:?[_mGU[GoFYVhoeJG]@0@oeBE/@06oeFD/omD
UK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;J
iOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omD
U[3oEIF`oeFE[P;oE9J`0_mDUK<?oeBE/@03oeFE/OmGU;3oEiB`00;oEIFa0_mDUK406OmEUK7oEiB`
oeNC[ooDooooboooofBM^?m@RJCoGi^goeFB[_mHU:coFY>Vok;WmooEoooodoooolWboooPoooog?oo
ofb@X?m`RY_ofO?oon7ooonjgnSoiOooon[ooombTi`00_oLool08?mQSZ7oh_ooon3ooomPTjKoGI2S
omgooooRooooHXnTokGUnOoFooooe?ooolSboooMooooeoooofNBXonlgo?ohOooolgloomXVJ[oHHbM
okkYo?oKooooe_ooolOcoom`WkWoDHZWoeBE/OmCU;3oEiRdoeJE]?mEU;?oEIFa3omDUK401_mEU;?o
E9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooB
f^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?o
E9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK401OmEUK3oFY>^oeZC[_mGU;3oE9Fa00;oDINa00ooE9Fa
oeRD[_mLSj[ofoooomOooomORjCoII>[oenAZ_mGSjSoHYV^oef=VooOoooog?ooojK<fOo4hNl00_oS
ool0:_mZRiCohncmoo3nooo4jo3obO;don_oooobooooJ8N<on;ooooNooooKY:Roo;oooo]ooooEhZK
of6DYOo]oooolOooofV<X_oOooooh_ooojc>f_nofo7oi_ooon;ooombSigolOgooo7ooomQT9[oHYBK
olk[looYoooo`^Kloj?7goo]oooofo[ooebE/?m8TZ_oDZ2dodJAZ?mHUkSoE8naoeFD/`ooE9Fa00Ko
EIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8
g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[Ko
E9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`ooE9Fa04;oEiB`oe^C[_mKTjkoEiB`oe>F/Om@Uk?oD9Ra
oeBF/?mJU:coFh^RomoooooTooooKY6WofR<X_mORIooJ9R^oeR9V_m]Uj?oh?ooon7ooomgUJ3oLhVF
on[ooooVooooKhZCoo[kooofo?ooJ92BoffGU_oeoooom_koogREVOoKoooogoooog6?V_ohnooom?oo
ofjO[OmPTYgol_ooooWooomdT:GogOooomoooomeT9OoMHZMonkooooSooooOYFMookmooohooooJIJK
of2CU_o[oooolOooogJEZOmVQI[oMX>Dof^2U?mPV[;oD9jeodJIZOmDXKGoD8b^oebD^OmEU;<?oeBE
/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomX
SZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSo
EIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<?oeBE/@12oeFE/OmJTk3oF9>aoeFE/OmCU[?oD9Nc
oe6G/OmEUJkoFi>ZofREZ_oSooooioooon3moooWooooi?ooolC^o_mXTZ3oL96PokGBh?oZooooeNcj
ok[:f_oaoooog_[oogbBWOomn_oonogoogFFVomJOH7on?oooo_ooom]Q8[oi_ooon?ooom/RHgon_go
ooOooomJRi3oJ9VMoo3koookooooJXJBol7VkooYooooeNo^ojc0boo`oooojoooofQmP_olo_ookOOo
ofbIW_mIS8gok_ooonoooooSooooioooooCoooo]ooooFI>YodRF[?m=W:_oA8nRoejI^OmLU;OoEIBc
3omDUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mM
TJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7o
HI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK40=OmEUK7oEiBaoeND/omDUK?oDIJc
oe2G/omAUk7oEiF^oebCZ?mTSj;of__oonSooomnV:GoK8RDolCRkOoSooood?CoofN7U?m/RIOo[/[H
omG/o?oLjokok_ooon[ooom_QI?omoGooocmoomWQHgoMiROooOnoooko_ooLXVAonOooooNooooO9FI
oo_nooohooooK9VLoe^9ROogoooonoooog28T_m/SiGo[/c:om?/jOoPlo[olOooonGnoon3V9_olo[o
ooCooomOSi?oFXf>00;ojooo00_oJhnOofZ;W_oaooooi_ooodj8W?mIY[[oCIZZoe6H[?mKU[CoDXZ[
oeND/@0?oeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZoo
EiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_J
olgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/@11oeFD/omEU;GoDiFeoe2G
]Om@Uk?oDiJaoeRD[?mNTZOoJiBVonKoooo[ooooJX:<og29T?mhTi[ojOooonCooomeUZGog_oookKG
j?m/RIWo/lSKonkooooSooooL8bJomcRn?ogoooo]]SRolgbnoobooooko_oofn:UOoVooooioooogF<
U?ono_ookO?ool7XkonZdmOoj_?joocooomlTYoog?[ookK?domiSY7o/lC>oo;oooo`ooooKH68ooKo
ooo`ooooGXnDofVOXOo>kO3oh?_ook_Pl?o1i_Woiocoolo/o_mDSZ;oC9NZoeFQ/Om@U:OoDX^Xof>L
^_mGU;403omDUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_
oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWK
f_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc4?mDUK400omEU;?oE9Feoe6F]`02
oe2G]@0Voe>F/OmHU:koGY:Woe^6U_oVooooiOooogRAV?mgT9GoJhN;onWooooVooooG8>Boj;=g_o=
n?ooh_ooonOooooMo?ooY<kNog6FY_miRj?of>goomcooonij?;oi?ooon_ooomZT9gog_ooon3ooomT
Q97olOkooo7ooon`h>cog?ooon[mooo:f^WoIXJEoi_3cooMool2onWoo`0Domkjoonbd]gojOoooo3o
oooYooood?oooe^BUomVRi?oa^KaomoooooHooood>_oofJ6VomXYK[oB9>VodRAX_mNX[OoFIFaoeF>
[?mEUK4?oeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZoo
EiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_J
olgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/@;oE9Fc0omAU[D0??mCU[7o
F9B^oebCZ?m_WJgog_ooonCooom`SYSoJ8J>olcZl_oWooood_[oof>FYomNUj[oGYV[oeVAX_mOSJCo
JIR/oeZCY?mJSiooIXbSofN=X_mITj7oF9BOoeN5UOmaW:goI9RVoeJ@W_mLVZWoHIVZof6:X?mdXKKo
BXnOodjCX_mSTZCoHhbPofFN/OmKV:[oF9>QoejFYOmIS9ooIi^`oe^DYOmNTZ3og?ooomgooom]YZoo
G9NOof2>VomaVjWoFX^Lof:AYOm`TjWoFhBJoe2AYOm7TZOoEIjaodJ:XOmKV;CoF9>aoeFE/@ooE9Fa
00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>
YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mE
U[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/a7oE9Fa03ooE9Fcoe>F/omAU[GoDiFeoeBE/omGU;3o
Fi>Zof2@Y?oKoooogoooon;ooooSooooh_ooom?koomOSYkoFiFYodb?X_mHW;7oD9>VoebF[_mARj7o
GJ6doe:EY_mMTJWoIIV_oe6DYOmDVJWoHifaoeF>X_mEU:Koc?ooolOooomDUZkoGI>_oe>;Y_mAWKCo
BiV_oe^D[omLTZkoDiF_odfC[?mBUZgoDI>YoebJ/om@SZOoF9ZboeREZ_nZfNgoeOooodn:V?mDTYoo
IIZZoeb?X_mGSZ;oHIF[oef7X?mYUk7oEIV`odZF[OmFW[KoG9njodJ6X_mLW;P04?mDUK401_mEU;?o
E9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooB
f^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?o
E9J`oeFE/?mEUJh2oeBF/0;oE9Fc4?mDUK402omEUK3oE9J`oeBE/OmCU[?oE9FeoeBE/omGU;7oFY>^
oebBZ_mNTZOoGi:U00;oHI:S00ooHI6UoenBYomKTj[oE9J^oe2H/?m=VK7oCYV`oeBE/OmDU[3oCYV`
odjI[_mEUK3oEIF^oe6H[_m@V:h00_mCUjh01_mAV:koD9R`oe6F/omEU;GoG92eoe^A]@;oD9Nc00Ko
FY:eoe^A]OmEU;?oE9FcoeFD]OmGU;<2oeRC/`07oeFD/omGU;3oG9:ZoebCYomGUZSoEIJXoeREZP02
oeRD[009oeZC[_mOT;3oG96aoe2H/Om<V[7oD9Ncoe6F]OmCUKGoDiJc013oE9Fa00KoEIBcoeBE/omA
Uk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMW
Koolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mE
UK3oEIF^0_mDU[02oeBE/`ooE9Fa00_oE9J`oeFE[_mEUJkoE9J`oeBE/OmDUK?oEIBeoeFD/omGU;7o
F9B^oeZD[003oeZDZP09oeZD[?mHU:koEiBaoe>F/om>V;?oC9VeodfI/omCUKGoDiJc00;oCIVc00Ko
DIJcoe>F/OmAU[?oD9Raoe2G/om@V;42oe2G/`04oe6F/omEU;GoFY:goeRC]@;oD9Nc00KoEi>goeRB
]omDUK?oDiJcoeBD]omEU;L2oeND/`06oeBE]OmEU;?oEiB`oeNE[?mDUZcoDiN/0_mDUK402omDU[3o
EiB`oe^A]OmHTkGoCYRcodbI/om@UkOoDIJgoe6F]OmAU[?oDiJa00ooE9Fa00KoEIBcoeBE/omAUk7o
DINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKool
o?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3o
EIF^0_mDU[02oeBE/`ooE9Fa00KoE9J`oeFE[_mEUJkoEIF`oeFE/OmEU;<2oeFD]@03oeBE/omEUK7o
E9J`00;oE9J`00?oE9FaoeBE/omDUKD00_mDU;L03omCUKGoCYNgoe2G]OmGTkOoEi>eoe6F]Om@UkGo
DiFeoeBE/omEU;GoE9Fcoe6F]OmAU[?oDiFeoe>F/`02oe6G/@04oeBE/omCU[7oCYV^odjI[P;oDiFe
00KoDIR^oe2H[_m@Uk?oDIJcoe6G/?mAV:h2oe6G/@0Aoe>F/OmDU[3oE9J^oe>F/?mAU[GoD9Neoe>F
/OmDUK7oEi>hoeBD^?m=VK?oC9Vcoe6F]omCUKSoD9Neoe2G/omCU[403omDUK401_mEU;?oE9Fcoe6G
/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_
ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE
/?mEUJh2oeBF/0;oE9Fc3omDUK401OmDU[3oE9J^oeFE[_mEUK3oEIFa00;oEIBe00?oE9FeoeBE/omC
U[<00omAUk402omAU[?oDIJeoe6E^?mCUKSoEi>goeFD]OmAU[GoDiFeoeRC]OmJT[GoE9Fe00;oDiFe
00_oEIBcoeRC]OmGU;?oDiFeoe6F]OmEU;GoEIBcoe>F/?mAV:koDiJaoe>F/002oe6HZP;oDiJc00Co
DiN/oe6HZ_mAUk7oDIJc0_mCUj`04omAUk3oDINaoe6F/omCU[7oEIF`oeFE/Om@U[SoCYNhoe>F/OmD
UK7oEI>joe>D^_m=VK?oCIVaoe>E]omDU;OoD9Ncoe2H/OmCU[403omDUK401_mEU;?oE9Fcoe6G/OmA
Uk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/0;oE9Fc3omDUK404omDU[3oE9J^oeBF[_mEUK3oEIFaoeFD]OmEU;OoE9FeoeBE/omCU[?o
DINaoe6G/?m@V;7oD9Ncoe6F]OmAUKSoE9BgoeRC]OmGU;<00_mCU[<00omJT[?oFi6coeFD/`02oe>F
/`0;oeFE/OmKTK?oFY>aoe>F/omAU[?oEiBcoeZC/OmHU:koEiF^oeND/OmGU;000_mHUJP2oeND/`0I
oeREZ_mHUJSoF9>aoeRC/omGUJcoEiFZoeRD[_mEUK7oDiJcoe>F/OmHU:koF9>aoe2F^?m>UkSoE9J`
oeFE/?mETk[oDiBjodjH/Om@V;3oEIBeoeNC]OmAUk3oD9R^oe>F/@0?oeBE/@06oeFD/omDUK?oDINa
oe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfoo
o?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`
oeFE[P;oE9J`0_mDUK<@oeBE/@;oDiJ`00OoE9FaoeFD/omEU;GoEIBgoeFD]OmDUK?oDiJa00?oDIN`
00KoDINaoe>F/omDUKGoEIBeoeRC/OmGU;02oe6G/0;oFY>`00koEIF`oe>F/?m@V;3oDiJ`oe^B/?mJ
Tk3oDIN`oe2H/?mGU;7oFY>`oeRD[_mGU;3oEIBcoeFE/@;oF9FZ0_mEU;D06OmGUJ[oF9FZoeRC]OmG
TkGoEiF^oeNEZ_mHU;3oEIFaoe>F/omDUK7oG9:^oe^B/?mAUKSoCYNhoeFE[_mGUJkoEI>joe>D^_m@
V:koDIR/oeRC/omJT[?oDiN^oe2I[?mCU[003omDUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;o
FY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP00
00coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc
3omDUK401OmCU[7oDINaoe2H/OmCU[?oE9Fe00;oEIBg00CoEIBeoeBE/omCU[3oDiN^0_mCUj`01_mD
UZkoEIF`oeND/OmHU;3oF9B^oeFF[0;oCYV/0_mGUJh01?mCUjkoD9R^odfJ[_m@V:h2oeRD[P0BodfJ
[_m<VZkoDiJ`oeFE/?mDUK7oDIJcodjG^?m@UkOoDiN^oe>F/?m@U[[oCYNjoe6H[_mCUjkoDIFhoe6E
^_mAUk7oD9R`0_mAU[D04OmAU[?oEiB`oenA[?mNTJkoDiFhoe2G]omGUJcoF9B/oeNC^?mDU;SoDIR/
oeBGZ?mKT[3oFi:aoeBGZ_mAV:[oDiJ`00ooE9Fa00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC
/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<
ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`03
oeFE/OmEUK3oEIF`00?oEIF`0_mDU[02oeFE/0;oE9J`0omEUK401OmCU[7oDINaoe2H/OmCU[7oE9Fc
00;oEIBc00coEIFaoeBF/?mDUZkoE9J/oe>G[?mCUj[oE9J/oeFF[?mGUJkoF9B^oeNE[?mDUZ`2oe>G
[0;oEiF/00CoE9J/oe2I[?m<VjcoCYV/0_mJU:`02?m@VJcoCYV/oe>G[_mDU[3oDINaoe2G/om>UkSo
CYNg0_mCU[001?m@U[SoCYNhoe6H[_mAV:h2oe2F^00Hoe2G/om@V;7oDIJeoe6F]OmCU[7oEIF^oebB
[?mKTjkoDIJeoe2G]OmEUZcoEiF/oeFD]OmDUK?oDiNZoeFGYomKTjkoFY>`oeBGZ_mAV:coE9J`oeBE
/OmDU[3oE9J^0_mGU;001?mEUK7oE9FaoeFE/?mEUK02oe>F/@03oeFD/omEUK7oEIF`00;oEIF`00Go
EIFaoe6F/omAU[?oDiJcoeFE/@02oeZC/@0<oeRC/omFUKCoDYNdodnE[omIUk3oGI6WofV=YOo8go7o
d][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9Fc
oeBF/?mEUK3oEIF^0_mDU[001?mDUK?oEIFaoeND/?mHU:h2oeNE[004oeRD[?mGUJcoEIJ/oeFF[0;o
EiF/0_mEUJh3oeND/003oeBF/?mCU[3oDIR^00KoE9J^0_mEUZ`01OmDUZcoDiN/oe6H[?mCUjcoE9J^
00;oEIF^00CoEiF^oe^C[_mLTZcoFYB/0_mHU:`02OmEUZcoCYV/oe6H[?mLTZcoGi6/oeZC[_mEUJko
EiB`oeFE/002oe6G/004oe>F/OmDU[3oEIF^oeNE[P;oEIF`00coEIJ/oeBF[_mCU[7oDiJaoe>F/?mD
U[3oEiBaoeND/?mCUjcoDiNZoeBF[?mCUjh2odjH/@0^oe6G/?mCUjkoE9J^oeBF[_mDUjSoEIJXoeFF
[?mDUZcoDIR^oe6G/?mEU;?oEIFaoe>GZ_mEUZSoFi>ZoebB[_mGU;7oEIFaoeRD[?mGUJcoDIN`oe6G
/OmHTkGoFY>aoeNE[?mGUZSoF9B/oeND/?mCUKGoDIFhoe>E^?mEU;OoFY:coe^B/?mJTk3oFIFaoeFF
]?mBTk7oG9Fbof2?ZOmYSJ?obMk_om;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mR
JWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`00SoE9FcoeBE/OmGU;3oEiF^oeFE
[_mEUZcoEiF/oeFF[0;oDiN/0_mEUZ`2oe>G[P06oeFE/?mEUK7oEIFaoeBE/OmCU[7oDiJ`0_mEUK00
2?mDU[3oDiJ`oeBF/?mDU[3oEIF`oeND/?mEUK3oE9J`0_mAUk03oeBE/@0?oeFE/OmKT[3oFi:`oeFE
[_mDUZkoF9B^oeNE[_m@V:koDIR^oe^C[_mLTZkoF9B`oeFE/?mGU;7oE9J`00;oD9R`00KoDiJ`oeBF
/?mEUJkoEIF^oeNE[_mEUJh2oeBF[P?oDiJ`00OoE9J`oeND/OmGU;3oE9J^oe6H[?m@V;3oCYRa00;o
CYRc00?oD9Ncoe6G/OmDUZh00omEUZ`0:?mDUZkoDiJ`oe2H/OmAU[GoE9BgoeBE/omAV:[oDiRWoe^C
Z_mLTZkoEIBcoeBE/OmGUJcoEIJ/odjI/?m>V;?oEi>goeZB/omGUJ[oEINWoeREZ?mGUJkoDiFgoe6E
^_mAUKcoE9BhoeZB/omKT[3oFi>^oeVE[omFUKCoDi:aoebE/omPSjWoJHfSolSOkOoBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/004oeBE/omCU[?oDiJcoe6G/@;oD9Ra00CoDIN`oe2H/?m>VK3oCYV`0_m@V;02odjH/@?o
D9Nc00CoD9Neoe>E]omDU;OoEIBg0_mEU;D00omDUKGoEIBeoeFD]@03oeNC]@03oeFD]OmDUKGoE9Fe
00;oE9Bg00[oDiFeoe>F/omCU[?oD9NcodZJ/Om<V[7oEIF`oeND/?m>VK3oCIV`0_mAUk42odfI/`;o
DiJc00CoCYRcodbJ/Om>V;7oD9Ra0_mAUk401?mCU[7oDINaoe2H/Om>V;42odjH/`;oD9Nc00KoDIJc
oe>F/omDUK?oE9Fcoe>E]OmAU[L3oe6E^003oe>E]omEU;GoEiBc00;oEiBc00?oEIBeoeBD]omAUKP0
0_m@U[X08om>V;GoC9^/odjJZ?mGUJkoEiBaoe2G]Om>V;GoDiJ`oe6H[_m:V[7oBYZeoe6E^_mDU;Oo
DIR^oe>HZ?mGUZSoEiF/oe>E]Om@U[[oD9Floe>E^?mGU;?oF9B`oeRD[_mFU[7oE9Ndoe6D/OmJUK?o
GY2YofR>Xoo8gngod][UofMWKoolo?oon_Wo007oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgL
hOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`00?oE9Fcoe>F/omAU[D00_m@UkD2oe2G/`;oD9Ra
00?oCYRaoe2H/Om@V;400_m@Uk<3oe2G]@03oe6F]OmDU;OoEIBg00[oEi>e0_mEU;D2oeFD]`0CoeBE
]OmCUKGoD9NeodbI]Om7VkGoBYZcoeFD/omHTk7oDINaodfI/Om@Uk?oCYRcodVJ]Om:V[GoDiFeoeBE
]Om@UkGoCIVcoe2G/`04oe6F/`05oe2G/omAU[GoD9Neoe2G]Om>V;D00_m@UkD01_mAU[GoE9FeoeFD
/omEU;?oEIBeoeBD]`?oDiFh00?oE9BgoeNC]OmHTk<00_mHTk<0:?mGTkGoEIBgoe>D^_mAUKcoD9Fl
odjG]om=VZkoD9VZoeND/?mGU;?oD9NgodjG]omDUK7oDiJ`odZJ/om:VKOoDIFloeBD^?mCU[3oDiNZ
oeNFZ?mGUJcoDiFeoe2F^?m@U[[oDIFhoeFD/omGU;3oEiF^oeFG/OmBUkCoCiBaoeVF/omMTJWoIXnS
olKPkOoBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF
]_mDUK?oE9J`oeFE/?mEUJh2oeBF/003oeBE/omDUKGoE9Bg00;oE9Bg0_mDUKD00omDUK?oEIBcoeBE
/`02oeBE/`;oEIBc0_mEU;D01?mEU;OoEIBeoeRC/OmHU;03oeND/0?oF9B`1?mGU;02oeRD/00BoeND
/?mGU;7oEi>eoeNC]omDU;OoD9NeodbI]Om>V;?oFi6coebA/omEU;?oDiJcoeBE]OmCUKGoCIRgodjG
]omGTkOoF9>e0_mDUKD2oeZB]@08oeNC]OmDUKGoDiFeoeBE]OmHT[OoFY:goeNC]omDU;L2oe>E]`07
oeRB]omJT[GoFY>^oeRD[?mHU:koEiB`oeFE/@02oeBE/@03oeFE/?mHU:koFY>^00;oFY>^02SoF9B`
oeND/OmDUKGoDiFhoeBC_?mCUKSoDiJ`oeFF[?mKT[7oFi6eoe>E^?mCUKOoFY>aoeRC/Om@UkGoCYNh
oeFB__mHT[[oEiBaoeNEZ_mHUJSoEiFZoe>F/om@U[SoCYNjoe6E^?mDUK?oEIF`oeBF[_mDUk7oDIRd
odjE/OmGUk?oFi6YofF@Xoo5hNgodM_UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9Z
MOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`;oE9Fe00CoEIBeoeFD/omD
UK?oEIFa0_mGU;42oeFE/@;oF9>a00WoEiBaoeFD/omGU;?oEiBcoeRD/?mGUJkoEIF^oeBF[_mEUJh0
0omGUJh01?mEUJkoE9J^oeBF[_mEUJh2oeRD[P03oeFE[_mEUK3oEIBc00;oEi>e02KoE9FcodjH/omA
Uk7oFi:aoebA/OmEUK7oDiJaoeND/OmGU;?oDIJcoe6F]OmGTkGoF9>coeND/omHTk7oFi:aoe^A/omH
Tk?oEIBcoeBE]OmEU;GoFY:eoe^A]OmJT[GoEi>eoeBE]OmEU;GoF9>eoe^A/omJU:coFYBXoeNE[?mE
UJkoE9J`oeBE/OmDU[3oE9J^oeNE[P?oF9B/02SoEiB`oeFE/OmCU[?oDiFgoeBD^_mDU;OoEIF^oeRE
Z_mLTZkoFi6coe>E]omCUKGoFi:`oeZC/?mAU[?oD9NgoeFC^_mHT[SoF9B^oeZDZ?mKU:OoF9FZoeBE
/Om@UkOoD9Jhoe6F]omDUK7oE9J`oeBF[_mBV;7oCiVdodjE/OmFUk?oFY:YofF@XOo5hNgodM_TofMW
Koolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mE
UK3oEIF^0_mDU[002_mDUK?oDiJcoe>F/OmCU[7oE9FaoeBF/?mAUk3oDiN^oeNE[_mGUJ`2oe>G[0;o
EiF/00?oE9J/oe>G[_mDUZh00_mEUK002omDU[3oD9Raoe2H/OmAUk7oDiJaoeBE/omCU[?oD9NcodjH
/om@V;7oDiJa00;oEIFa00[oDiJ`oe2H/?m@V;3oDiJ`oeRD/?mHU:koDiN^oe>G[?mHU:coEiF/0_m@
VJ`00omHU:coFi>^oeFE[P02oe>F/004oeBF/?mHU:coFYB/oeNE[0?oEIF^1?mEUK04oeND/0;oEIF`
0_mGUJ`00omDU[3oDiJaoe2G/`02oe2G/`03oe6G/OmCU[7oE9J`00;oE9J`00[oDiJcoe6F]Om@UkOo
CYNhoe2G]omAUk7oE9NXoeNFYOmKU:SoF9B^0_m@V;407?mHU:coF9FZoe2H[_m=VK7oDIJeoeBE/omG
UJ[oFYFUoejCXomLTjOoEIF`oe>E]OmAUKSoDIJgoeBE/OmDU[3oE9J^oe:H/Om?VKKoCYFcoeJG/omJ
TZWoII2QolGQkOoAfnCoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7o
HI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/008oeBE/omEUK7oEiF^oeREZ_mLTZ[oFiBXoeNFZ?mH
UJL2oenBY`0DoeZEYomHUJOoGY:WoejBYomJUJOoF9FWoeZDZ?mLTjSoGY:XoebCZ?mHUJ[oEiFZoeZD
Z_mKTj[oG9:/oe^C[?mEUZcoE9J/oeNE[?mKTjX2oenAZP0/oe^DZ?mGUZSoE9NZoeNEZ_mQTJSoHY2X
oebCYomKU:OoGY:Woe^DYomDUjOoEiJWof:@YomUSjOoGi6XoeZDZ?mHUJ[oFiBXof>@YOmST:?oFYFU
oeNFYomKU:OoGY:Xof6AZ?mOTJ[oF9FZoeNEZ_mKTj[oGi6Zof>?Z_mRT:[oFYBZoeREZ?mNTjGoGi:U
oebCZ?mKTj[oF9B/oeNE[?mHU:coFYB/oe^CZ_mKU:P2oebCZ00<oe^C[?mJTjkoF9B`oeND/OmEUK7o
EiF/oe^EXomNU:3oHI:SoejBYomDUZcoE9NZ0_mOTZD06_mGUZSoDiN/oeFE/?mJU:coGY>Sof6BX?mR
TZ3oGi:UoeZC[_mEU;?oE9BgoeBE]OmEUK7oEIF`oeBF[_mBV;7oDIRfodjE/omGUk?oFi6YofJ?XOo6
h>god]_TofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[Ko
E9FcoeBF/?mEUK3oEIF^0_mDU[00M_mDUK?oF9B`of2>YOoRooooi_ooofJ9WOmUSZ3o]Mc]on[ooooU
ooooHXVHofVCXOo<jogohOkoomooooo8loooJY2Sofb=W_o3f^[okOooomcnoomZSiSoIHFBom;^o?oX
ooooj_ooom3foomcVjGoH8B@onWoooo`oooo_M3OonKooooFo?ooI8nOof><X?m]Qikoe^koonCooooL
oOoodNkoofR9V_mVTYooIY2NoloXo_oYoOooi?ooolO/oomXSZ?oKHfRononooo`ooooJIRRoeZ?UooB
nOooj_oook[;iOoVo_oog?oooe^>WomUSZ;oMI6YolSCkooaooooboKoof2@W?o>k?Koj_ooon_ooooK
moooKhnLoff>WOnK_<_oeOGoonWooooPo?oojooooj:mb?mbSYco`]g^onWooooGn_ooIY2Xof>@YOo8
k?[oh_ooonCoooo8jokoHI6Uof>BY?oYooooh_gooffHZOmOSj?oHHnWoffF[?o8jOSogoooon3oooo;
n?ooFhjYoefF]?mETK?oEi>eoefH]_mNV[CoEIF^oeBG/OmBUkKoCiBcoeVF/omNT:WoJHjQolSOkOoB
fnCoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?o
E9J`oeFE/?mEUJh2oeBF/008oeBE/omJTjkoI8fOon?oooo[ooooO9>Sog:DX?oHm_l2onooo`1/og2@
VonifnGok_ooom;Xm_nde^;ogooool?Sl_m[PY3omOoooo?ooomeSY?oN9FKomKZloo_oooofNGcojjn
booYooooe?GlogfHXOo/o_oon?koon_co_o0dmWojoooomCdoom^Rigod^OjonKhooo<i_Goa^3_oo3o
ooo@i_CoKXbGol[XlooZnoooeNCgolkXnOoRoooob^Oiog>8VOoloOoomOgoofJ<SonIa/Woioooom[]
o?mmQI[ol?ooon;ooomWTj3oJX^LogJ8W?odm_ook_Kooj36dOo?n?kol?ooolSEfonfa<golOooon3f
oombRYCofO7konkoooncam3oYKRooo;ooooWn?ooOHjHonknoooaooooMi6RofV<X?o4jO_ohoooom7X
l?oAioCohooool3[nomUSigok?oooo3ooom`TJ3oK9JVoeb5VOo5j?_oj_ooolcWl?nYbMKoh_ooomCo
oomNTk?oG9Bgoe:=[omJTk3oCh^UoeNE[_mEUk7oDYNfoe6C/omJUK?oH8nYofZ=XOo9gngod]_TofMW
Koolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mE
UK3oEIF^0_mDU[004_mDUK?oFYB/ofZFXooWooookOooofN2Ronffn7oi_oooncmoooaooooKI>Fon3o
oooTo?ooKhNAofbEVooOoooohoooogJDWP;olOoo00goIHR>ofZ?UooZooook_ooog>4U_m]PY?oK9:O
of^FWomYRiOokOoooo7moomdP8koL8^B00;ogooo03OoLY:OonKooooVooooL9NNofR:Too`ooooi_So
og6<UOoTooookOooofb8TomURiCohoooon;ooomfRIOokoSoooOooonhf=Oo`^[YonKooon`c]KoMHfI
on[ooooSooooGhN?ofb<Uoo;h_3olOooolgSl?m]UYcof_ooonWooon2UZ7oMXjJof^7Tom_SicoMiVU
ofJ6Tom[RICo/LgHom_foooVooook_ooogfCX?o/ooooi_gooff<W_mVT:3of_ooonWooom]RHcoKHR?
onKooooFooooHY>J00;ojooo01[oGXJ>of:BW?mYVJOoeoooonWooom[Qh_oK8RCofZ>W_mKQj3oGi2`
of>I^omMUKKoF96^oenK]OmGU;3oEIJboe:G]_mATk?oG9Fcof2?ZOm/S:7obmk]om?Ji?mWIfooo?co
oo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE
[P;oE9J`07KoE9Fcoe^CZ_mSRiGoj_ooongooom`Qhgoi_ooon3oooo_o?oolOooofJ9RooSooook_oo
og:8Tom_V9cog?ooom7goombT9[olOooonWooom]U9WoHHbBonKoooo[ooook_ooon_ooooIoooofooo
ofnEX?oYoooom?ooog^9U_mfUI[oi_ooonGooomSPHcoi_ooon?ooomJQH_oJXnEoo7oooo`o_ooMXjH
on[ooooVooooK8fFofF@UooLoooojOooogV<V_ohooookOOion_ooooNo_gof?[lofN:S_mXQXkoiOoo
on;ooomeUYoo`McWoncoooo[ooooKX^CoffDVOoNoooohoooonKooooYooooi_ooon7ooomXSY_o^MoZ
on;ooooWoooohOooonWooonlemkoJHB=onSoooo[ooooL92OofRCXooOooooi_ooog:;Som`Ri;oh?oo
omWooomUUYgoiOkoonkooom`UYooIiNQofFFY?oOooooi_ooongoooo[ooooioooon3ooomNSjgoDhV[
oefH^?mMU[?oEI6[oeFE/?mDUk;oDIRfoe6C/omJUK?oH8nYofb<XOo;g^godm[TofMWKoolo?oon_Wo
0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mD
U[002?mDUK?oG9:Zoff?Vooaoooomoooom;Oj?o[oooo]LkC0_okool01OmcT9Kof__oooCooomcPi;o
HXB>00;oh_oo03koLXfHoo;oooo^ooooJI>BofRFU_oPoooojOooognBX?mPNhKogoooom3ooomVSiGo
j_oooo7moomgQHkoNIRJomSnoooYooooKhbLomknoooNooooM9bVofB6T?oboooomoooog>6U?oQo?oo
joooog6?V_mZTYcoh_ooomoloomdQIGomOWooocoooofoooolOoool3Lh?mdTiSoLY2Jon[oooo]oooo
l?ooonOhooo^ooooh??ook?>eomUQXgoioooon[ooomeTYSoK8fDon;ooooKooooHXZBon;ooooQoooo
gOoookoQh_mZR8SoMY:Cog:;S`;okOoo02GoJHNBofF<WOoIo_ook_ooogZ;TomhS9Ooioooom;ooomR
SYWokOooooCooomZRYOoH8ZHoen=WOoKooooiOgoogb@Uom]QHooioooomGmoomWVKCoHY^iodJ3X?mK
Uk?oGI^doeBF/?mBV;;oCiVfodjE/omIU[?oGY2YofZ=XOo9gngod]_TofMWKoolo?oon_Wo007oIfIf
00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`07Ko
E9FcoebBZ_m]SI[ojocoooClooofooooioooogZAVOokoOoom?Ooofn=Uoo:joCol?goom3Ol_o3ioGo
e?oookkRl_mgTj7ol_ooonkooomNQhWoJ9JFolGWl?o]oooo`M;RolkXmOoLooooa_WmofF>U?oVoooo
loooonOdoOnif=_ohooool?Ym_mbUJSo_n3aonCooonji?;oa>SfonOlooo@hO?oLHfKolOWm?oZoooo
_Mg/okSOk_oPooooa>OjogF:Voolo_oono_ook;4b?oUoooojOooojC0bom/QY?oi?koon[ooom]QiSo
P9>TokO8f_obooooiO_oogFGX?ngg^GohOoool?QjonmgnWof_oool[bo?mNRI;ofOooon;ooomXSY7o
X/C5on[ooooPo?goMHjBon;kooo]ooooMYBOofN@X_o2j?_ok_ooolSHiOo4f^Soi_oookW]n_mTTZ7o
k?ooooCooonjfN_oJIBUof:AYOo5k_oojoooolSLioo5gNOoiooool7[oom:OISoIj2noeRH]?mHV;?o
BhfUoe6G/?m?VK;oCIZfodbF/omGUk?oGI6YofV>XOo8gngod]_TofMWKoolo?oon_Wo0OmWIWH0000<
ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[004_mDUK?o
Fi>/ofjDXOo^oooomOooonWiooo1h^WoK8ZBoo?jooogooooKY:Nof::U?oGk?ooj?koomoooonnl_oo
KYV/omkoo`;ol?oo01koh?ooof>BV_maT:;obn7foo7ooooVo?oo_^cloej?WOm]U:?oj_ooooOoooo9
e>KogO_oomGooomPU:7oHiJWofJ?Xoo9koooe_ooomooooo:kOooJXnQofBDX_mQSikob>_oonCooooO
oooo_o3ooef@XOm/T:02ooWko`0Kog:JV_nCalGoh?ooonOooongb=cokOooomGooomUUZCoKY:Rofb1
U_oho_oolOoooeZ;T_mVWJ;obNolonOooooMoooobo7ooffFZ_m/UjSoXlgMomSooooRooooioooom?_
n_nO^/?okOoo00;ok_oo02GogokoofBBZOmPSj?ocN[jongooooYooooa>gooeRCXomNUZGojoooongo
oooAmooobokooeVAZ?mUV:go_Mk_on_ooooVoooobngiofFBYomRV;;oCXVWoeNH]?mGVK?oDYJ]oe2H
/?m>V[;oBi^fod^F/omEV;?oFi6YofR>XOo8gngod]_TofMWKoolo?oon_Wo007oIfIf00003?mZIWCo
o?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`03;oE9FcoeZC[_mN
RI[oioooon_ooooQo?ooIXjJofbDX?oYoooojoooof6?W_mUUZGoIhZPofJ:X_mOU:KoFIBVoejBZ?mU
SjOojOooonKooomZV:SoEhRIofF;X_mcTJ_oIWnMofn>Z_mUUJcoEh^Pog2M/_oLo_ooiO[oogJ<Y?mc
V:[oFHZIoe^FZ?m?S9ooHiF/of2>Y_mPTjSoH9BYoen?XomNTJCoF9>SoefFYomRSjKoHXbToeb>YOmJ
TjOoFYNZof2?X@;ol_oo04;oFhb@ofBQX_mLRiGoJHZKogR>YOoWoooof?oooeNBX?mRT:3o/]7Voo;o
oooWnoooGI>MoeVHXOmTTjGoGXJOog2J/_mTTZ[oEhNNof6AZ?mOSJCoI9>WofB?X_mMPiKoKI:TofjA
Y?m/SJ3oi_ooon;ooom^U:_oFY2XoejD[?mTSj;oIX^Mof><X?mNTJKoEiR/oeJCY_mXSZGoKI2Vof:B
Z?mKUJ_oDY2YoefG[OmVTjKoJ8nPofV>W_mZU:CoFhjSoeNAZOmMWKSoDI:^odf?ZOmGV[CoDIN`odnI
/_m=V[KoBiNaoeFH/_mJTZWoIXnQolKPkOoBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonS
Z[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/00ToeBE/omGU;3oG8jUomco
oooMoooo[Mc`of>FZOmRUJSoeOooom_ooomKU:SoFYBZoebBZ_mKTjcoEiF/oeFF[?mGUJkoFY>^oj3B
kOo6n?ooGYB/oejF[omKSZWoGHnZoen>Z_mRU:ooFY:]oeVCZomMTjgof?ooom_ooomRTJ_oGI6YoeZB
ZomGUJkoEIF^0omHU:h01OmGUJkoF9B^oeRD[_mEUJkoEiF^00;oFY>^01KoF9B^oeNE[_mEUJkoFi>Z
omoooooRooooHY>RoefBX?mUUZOoJYNZoeR1UooOoooof?ooom;ooooKoooogOooom;hoonJ`mWoJIb]
oeJ?X_mJU:[oFY>^0_mHU:h2oeNE[P;oF9B^00SoEi6YoebD[OmLTZcoEH^Uof6G/OnVg?Ko_>oooenG
/P;oEiB`00WoFYB/oe^C[?mJU:coF9B^oeBF/?mEUJkoFi>^oe^C[?mHU:h00omEUK001OmJU:coFi>/
oebB[?mJU:coEIF^00;oE9J`00ooEIF`oeRC/OmGU;7oEIBcoe:G]?m?VKCoC9J_oeJH/?mKTZOoJ8jS
olSOlOoBf^GoIfM_ooclooojnOl00OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mE
U[KoE9FcoeBF/?mEUK3oEIF^0_mDU[003?mDUK?oEiBaoeN?Z?mMU:WoFY6VoeRAYOmHT:OoF9:XoebH
/?mHUZgoEiF^oeFE[P;oE9J`0_mCU[001omCU[7oE9Faoe6>Z_mZY/;oCHVUoeFA[OmJU[800_mLV;@0
1?mGTjooEY:^oenK]omKUk<2oeNC[`04oe^G/omOVkOoEI:^oeFE/@koE9Fa00koEiB`oeZBZOmPU:[o
FXjToeb@Y_mCQigoG92VoejBZ?mTV:koIIV_of2DZ_mMTJOoH9BZoenCZ@;oFXjT00?oG9B[oeFE/?mC
U[401?mCU[42oeBE/@08oeZK]omFUk?oE9B`oeVI]Om@T:coDY:^of2P_?m?Sj/@oeBE/@06oeFD/omD
UK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;J
iOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omD
U[3oEIF`oeFE[P;oE9J`00coE9FcoeFE/OmTW[KoDXZQof6I/?mLUZcoGiVaof6M]Om=RJ?oEiF^oeND
/?mEUK02oeBF/0?oDiJa00CoE9Faoe>C[_m>RjOoHIjj0_mIU[801_mGU;3oFYNcoe:?ZomLVKGoCX^W
oe^H]0;oD8fY00CoFiRdodj;YomLVKGoEIFa3_mDUK402?mEUK3oGIJaoeN?Z?mUWKKoGIF^of2H/OmL
U:goIYjg0_mDS:D02?mHT:WoFY:[oeVAZ_mKTjcoH9Raof6I/_mKUk7oEIF`1OmCU[42oeBE/@08oe6B
[_mGV;CoDI6]oeJF/_mJV[KoChn[oe:B[_mMWKT@oeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`
0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf
00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`00[o
E9FcoeFE/OmCSjWoGYR^oejH/?mETJWoDHfUoeBBZOmIUk3oEIF^0_mEUK02oeBF/0?oDiJa00OoE9Fa
oenO^_m=RZKoHYnkoe>@[?mDTJgoDHjZ00;oFIJb00?oEiB`oeFB[_mFTjl00_mNVkL00omFTjooEI:^
oeFE/00?oeBE/@0BoeFE/OmGU;3oFiNcodj:Y_mCSj_oGIVeoeJB[_m<R:CoGIVeoeVE/OmLV;CoFiNc
oeFA[OmDT:coF9B`oeNC[omASZ[oE9Fa1OmCU[42oeBE/@08odn@[?mJVkOoDY:^odf=ZOmIVKGoGIfi
oeJF/_mCTjl@oeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>
UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGo
fM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`00_oE9FcoeFE/OmETjcoFIN^odf;Y?mI
Uk3oGI^doeBD[OmKVkKoD92[oeFE/@03oeBE/@?oE9Fc00?oE9Faoe:B[Om@T:/00_mBTZd01omIVKCo
DY:]oeFE/?mGUk;oDY:]oe^K]_m?SjX00_mCTjh00om?Sj[oFi^foe:B[@0@oeBE/@0:odj?ZomFUk?o
EIJboefN^_m?T:coGIjjoeJG/om@TJgoEIJboe>D/0?oDI:^00?oDiB`oeFF/_mGV;@01?mCU[44oeBE
/@05oeFF/_mCU;3oEiRdoeJG/omBTZh00_m@T:`00omATJgoE9FaoeBE/@0>oeBE/@06oeFD/omDUK?o
DINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmW
Ifooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3o
EIF`oeFE[P;oE9J`00[oE9FcoeBE/OmFU[7oE9B]oeRH/OmEUjooEIF^oeJF/OmDU:ooF9Rc1?mDUK44
oeBE/`0;oeBD/?mNW[WoDI6/oeNG/_mNW[WoE9B_oe:B[OmCTjkoEYJaoe:B[OmGUk800_mIVK@00omG
Uk;oDY:]oeJF/@0@oeBE/@0;oeFH]OmDUkCoF9^hoe:E/_m8RjSoD9>`oeRK^?m>TJkoDYFboe2C/?mC
U[<00_mHVkP00omBUK;oCi:_oe2C/004oe>F/@GoE9Fa00GoC8fYoeVJ]_mIV[KoDI6]oeNG/`02oeVI
]A3oE9Fa00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:ko
GI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQ
of6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[002_mDUK?oE9FaoeRJ]?mCUJooE9J`odZ=Yom=SjWo
FIZfoeBE/OmBTjl6oeBE/`0=oeBE]OmDUK?oDI:^oeBF/?m?TJ_oCY2ZoeBF/?mATjgoEYRboeBF/?mA
TjgoEINaoeZL]P02odZ<YP03oeZL]_mEUk7oDI>]013oE9Fa00[oCI2]odfB/Om?U;?oCiBcoeVN_Om@
UKCoCiBcoeRM_?mCV;OoCiBc0_m=T[401Om>Tk;oCiBcoe:G]_mIW;WoDiJa00OoE9Fa00SoEYNcoe2A
[OmGV;CoCi2/odj?ZomIV[KoDI:^odf>ZQ3oE9Fa00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC
/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<
ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`08
oe6D[omBUJooCY6[oeZM]omIW;OoC8nZoe>D/?mDUK46oeBE/`0=oeBE]OmDUK?oEiRdoe2B[?mMWkWo
DI>]oe:D[_mATjgoF9Zdoe2B[?mFV;;oEINaodj@ZP02oeRJ]003odj@Z_mEUk7oEYRb013oE9Fa013o
EYVfoeJK^?mBU;CoDiReodnA/OmCV;GoD9:bodjC/?mBU;CoDIJcoeBF]_mAU[?oDYBdoe6F/omCUKGo
DIBa2?mDUK402?mGV;CoDI:^oeJG/omCU;3oEiRdoe>D/?m9RZKoGIjj4?mDUK401_mEU;?oE9Fcoe6G
/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_
ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE
/?mEUJh2oeBF/0;oE9Fc00CoDiJaoe6G/OmAUk7oDINa0_mCU[42oe>F/`KoE9Fc00?oEIBcoeBE/omD
UK403omCU[4AoeBE/@0>oe>F/OmDUK?oDiJaoeBE/omCU[7oE9Fcoe>F/OmDUK?oDiJaoeBE/omCU[7o
E9Fcoe>F/OmDUK<QoeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H
]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mR
JWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<01?mCU[7oDINaoe6G/OmA
Uk42oe>F/@;oDiJc1_mDUK<00omEU;?oE9FcoeBE/@0?oe>F/A7oE9Fa00goE9J`oeBE/OmDU[3oE9Fa
oeBF/?mDUK7oE9J`oeBE/OmDU[3oE9FaoeBF/?mDUK7oE9J`02;oE9Fa00KoEIBcoeBE/omAUk7oDINa
oe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oo
n_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^
0_mDU[02oeBE/`KoDiJa:_mDUK403_mEUK3oEIF^oeFE/?mEUJkoEIF`oeFE[_mEUK3oEIF^oeFE/?mE
UJkoEIF`oeFE[_mEUK3oEIF^0_mEUK04oeFE/@SoE9Fa1?mCU[4@oeBE/@06oeFD/omDUK?oDINaoe6G
/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?co
oo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE
[P;oE9J`0_mDUK<01?mDUK7oDiJaoeBE/OmCU[4/oeBE/@0>oeFE/?mEUJkoEIF`oeFE[_mEUK3oEIF^
oeFE/?mEUJkoEIF`oeFE[_mEUK3oEIF^oeFE/?mEUJh2oeFE/0CoEIFa2?mDUK44oe>F/A3oE9Fa00Ko
EIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8
g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[Ko
E9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`;oE9Fa00?oEIFaoeBE/OmEUK401OmDUK46oeBF/27oE9Fa
00goE9J`oeBE/OmDU[3oE9FaoeBF/?mDUK7oE9J`oeBE/OmDU[3oE9FaoeBF/?mDUK7oE9J`00;oE9Fa
1_mEUK44oeBE/@KoDiJa4?mDUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF
]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonS
Z[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc1omEUK43oeBE/@Ko
E9J`8_mDUK403_mDUK?oE9FaoeBE/omDUK7oE9FcoeBE/OmDUK?oE9FaoeBE/omDUK7oE9FcoeBE/OmD
UK?oE9Fa1_mEUK44oeBE/@KoDiJa4?mDUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00co
Ei>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVId
oockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc00GoEIFa
oeND/OmGU;7oEiBaoeND/005oeFE/0KoE9J`4?mEUK4@oeBE/@;oDiJc00koDiFeoe>F/omCUKGoDiJc
oe>E]OmCU[?oDiFeoe>F/omCUKGoDiJcoe>E]OmCU[?oDiFeoeBE/`KoEIFa1?mDUK46oe>F/A3oE9Fa
00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>
YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mE
U[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`;oE9Fa0_mGU;42oeND/0CoEIFa0_mCU[001OmDUZko
EiF/oe^CZ_mLTZcoF9B^00;oEiB`00GoEiF^oeRD[?mJU:coF9B/oeZD[002oe^CZPCoF9B^00[oF9B`
oeND/?mGU;3oEiF^oeRD/?mHU:koFY>^oeNE[_mCU[3oE9J`0_mKTj`01_mGU;3oEIF`oeRD[_mJTjko
EiF^oeFE/0;oEiB`00?oF9B`oeND/?mGU;000omGU;000omEUK7oEIF`oeND/@04oeND/005oeNE[_mH
U:coF9B/oeNE[_mHU:h00_mJU:X02_mHTk7oF9B`oeZD[?mJU:[oEiB`oeFE/?mGUJcoEIJZoeFF[?mE
UJh3oeRD[P04oeNE[_mGU;3oEIF`oeFE/@SoE9Fa00?oEIFaoeFD/omDUK<00_mAUk404?mCU[3oEIF`
oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMV
MP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/006
oeBE/omCU[?oCYRaoe2H/?mEUK3oF9B`0_mGU;42oeND/`1Aoe^G^OmAT:ooDYZcodjI[_mDVJWoGIJW
off@XomYRIkoFhfToeJBZ_mFTZcoHifaoeB8U_mSU:;oGi:SofFFYOmUTIcoGh^Fof2CY_mSUjgoGI2U
of2BZOmOUJooGYJaoe^CZ_mMU:WoHY6[oeb:X_mYUZ_oEhnPoeBK[OmJVjooHhVNogFH[_mGSjKoEiBY
ofRF[OmJQicoFY>Wof6K[omNTJCoJY^/oej=XOmXV:coGY6VoeZ>XomNTJKoHiN/oeZAY_mIT:CoGi>Y
oenBYomPU:WoHIFZoeF8WOmUV:WoGI>OoeVAW_mHTJGoHIFZof:AVomTTYooHiBdoef<Z_mVTJ7oI92M
oenB[OmNU[7oFHjLoejGX?mKUZCoFYFWoe^>XOmXV:coGY6Voeb@Y_mMUJcoFYJ`oeND/?m@TJgoDiJa
00?oDiJc0_mDUK401?mEUK3oEIFaoeFD/omDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jf
oe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z
^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`00KoE9Fcoe6G/Om=VK7oCYV`
oeFE/?mHU;02oeND/@;oEi>e02WoEI6eoeRI^Om<V;;oB9FYod^CXOmZWZ_of>oooo3ooomVTJCoGY:W
okKYo_oCoooogOooof^FWOmFOXSobo7jomgooooSooooa>_joeEnT?m[UZOo]>7dom?oooo5mOooGXjR
of6@X_o1jOooh_ooomkoooo?ooooF9ZXoeB=W_o[ooooi_Wook;Un?oCoooodOSoogFJ[?mMSYooFXfN
okkZm`02omkoo`0VolkcoomNSYcoIIFSog2EZ?nkhOCofoooomCoooo5jokoKiBVoeZ5UOoMooooh?oo
oej6T_m/U9coc_WoomgooonSc]ooi_ooon?oooo=nOoogOooon7ooonadmcoGh^Tof>AZooRoooogooo
ofNCX?oJooooh?ooof:<W?mRSIkoe_ooomSooomBRZ7oF9B^oenO^_mCU[43oe>F/`;oE9Fa00CoEIF`
oeND/OmEU;?oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOo
J8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6X
oeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/008oeBE/omCU[7oCYRaoe2H/?mEUK3oF9B`oeND/OmEUK42
oeFD]@0Poe6=[omKW;[oC9R`odnL[_mCVJGoGi>PonkoooobooooIXVLofNAXOoKo?ooi?ooomoooomV
SYKocnK/onkooonlhn[o]=cTon[ooooLm?ooJHjNomoooooQooooMiZ]ofR=WOo;l?ooi?oool3Sm_nS
b=7oh?ooolWooomUT:02ooOoo`0`ol?^o_nbi_Coi?oookoOk?m]U:?oao?oon;oooo1hNcobn3aonKo
oonhjO3oJYVQolWKkoo^oooo]NO`ojgOj?o]oooobMk_ofN?VOoHooooioooog68U_nQ/koolOooomC^
oomZQI[ok_ooonWooomZU:goFHFNomSfo_oSoooo_>;iofV=YooSnOool?ooogB7V?o]ooooioooof:8
UOm]U:Gogoooom_ooomIT:GoIIngodZ7XomDUK7oDiJa0_mCU[<2oeBE/@;oEIFa00KoEIBcoeBE/omA
Uk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMW
Koolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mE
UK3oEIF^0_mDU[00A_mDUK?oDiJcoe6G/OmAUk3oEiB`oeRD/?mEUK7oE9FaoeBE/omDUKGoFIRioeRI
]om:U:goCIZ/oeRLZOmLSYWol?ooon[eoomdT9ko_mcZoo3oooo]oooof_ooofR?U_ogooook_coofnF
WOm[Ti_ol?ooon7^mom[RiKoh?ooon[ooomWPHkoM9:MomShoooPooooKhnNof>4ROmcVIcoI92KogBD
XOobkoooo_goofN;VOmOSYSoioooonGooomkWJWoe?Soom[loomkUj;oLh2@oo3ooooHooooIiBJonof
ooogooooGXnDofNJW_o_o?oolo[oogNJX?oOooook?oookk<fOoIhnoomOoook77g_mfS:42ongoo`0D
ofBAZ?mVTjSoZlO;ongooooGo?ooHh>Hoo;oooohooooQ8fNonOfoooVooooJH^Gof^?WooRooooeooo
of6DZOmKTj[oGi^eoeFE/?mDUK42oe>F/`?oE9Fa00?oEIFaoeFD/omDUK<00_mAUk404?mCU[3oEIF`
oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMV
MP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;o
E9Fc00KoDiJaoeBE/OmGU;3oF9B`oeFE/?mCU[42oe>F/`0KoeFD/om>Sj_oDijeodjJZ_mGVJGoHI6M
oo7oooohooooM8JBon;do_oioooomOooon?ooomcU9_okO;hooWooomRQhooIHbCooSooookooooKXVB
onOooooaooooLhB>ogR@V_oZooooi_oo00;ojooo03Koh?goonGooombQI?ooo[ooookoomaSIWoJI6I
on;ooooZooooL8jIonGooooYooooJh6<oh:9VOoboooog_ooofJ?UOoloOoonokoof6>TOm/W9komO_o
ooCcoom/RHgoi_oooo3oooo_nOoom?ooom?Ym_m^SIooM9BSongoooo[ooooIYFWof:AXOmgT9CoiOgo
on7ooomXSIgolOoooo;ooomeQi7ok_ooongooomiUJ3oJXNEonCooooNooooHi:Voe^?YOmESjOoEiF^
oeFE/OmDUK<4oe>F/`03oeBE/omEU;?oE9Fc00;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[Ko
DIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZj
of9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`0/oeBE/OmEUK7oF9>a
oeRD/?mDU[3oDIN`oe6G/OmAU[?oDiBbodb=ZOmIXKWoD9VZoeJHY?mTTYookOkoooKloooHiNkomOoo
om?Gh?ogooooh?koog:?Uoohoooom?koog>FW?mYSYColoooongfoomhTIKoh_kooo;ooomlSIGoJ8J>
omooooo]ooooM8NFofn3R_o[ooooeOGoogfCX?ooo?oom>kjogN=V_mfUZ42oncoo`0]og:DW_oLoooo
iOooogjFX?mkQ9?ol_ooom3koomaV9ookoCoooOloomWT9CoJIFHoo;jooolo_ooLXjAon?ooooaoooo
moooonomooo<h_3oJHZKof^;V_o`ooooiOooof:CX_mLSI_oKXN;onkooooRooooKI>Nongnooohoooo
KG^4oo3ooooYooooN92JofN3SooWoooohooooef8Vom/WkCoEhnVoeRD[_mEUK3oE9Fa00GoDiJc0_mD
UK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;J
iOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omD
U[3oEIF`oeFE[P;oE9J`0_mDUK<0FomEU;?oEiBaoeRC/OmGU;7oDiJ`oe2H/?m@V;7oDINaoefN_?mD
UK7oCYJ/odZAXomEUJ7oJINToo7ooooioooomoooonGbn_mfP8col?ooon_ooom_S9Co`mSYongoooo5
io3o]=OMongooooDioGoM8fBonkooooaooooLXfDofjNX_nghncol?ooomkVnoo1cm[okOoool7[momW
SISomOooooKloooRlooo`=GXooCooooDj_GoFhZBokGZl_oOoooo_]cWolGJjoo[ooooc?Cnof:8TooB
iOKol?oool3Vkoo0iNkolOooolcJiomhTi[oj_oooo3ooon_^lOom?WoooGmoonT_M?oMI2Soo3oooo[
ooooI9ZVoefFXOm_S93okOooom;moomTR9Con?ooooOeoon:RIWon?ooongnoomiSi[oM8jKonWooooT
ooooJ96SodinT_m[X[OoFYB/oeND/?mEUK400_mCU[<2oe6F]@03oe>E]OmDUK?oE9Fc00;oDINa013o
DiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oo
n_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^
0_mDU[006_mDUK?oEIBcoeND/omHTk?oFY>aoeND/OmCU[3oD9R`odjH/Om@V;7oDI:`oeRI]Om@Ujgo
DiZ/oeVHYomRTZ3okOooooKooooaoOoocn7[ogB9V_o[ooooh?_oofj>VOm`U:[ob>ko0_oPool05oo>
loooIHRKon[oooo[ooooiOgoonKooomKT9SoIYZWolSTn_oUnOoojoooolCYl_mVUJGoIY2Poo7oooob
oooocNSmon;ooooNn?ooJH^GofVOZomJU:3o`Non00;ohooo02[oa^_mofJ@X?mRS9coKI2SolOZoOoL
oooohoooolKVmOmaSYcoJh^FonKooooZooooMH^Hok70dooaooooiOooojS7g?o^ooookOoooefAWomO
Tj3o[lOAonkooooBn_ooKi>Qoo?ooooko_oon?ooon_hoooaooook?ooon_ooooUooooi?ooon3ooomW
UZ[oEh^QoeZD[?mGUJkoEIF`oe>F/OmCUKD2oe6F]@03oe>E]OmDUK?oE9Fc00;oDINa013oDiJ`oeFE
/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmW
IWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[00
<_mDUK?oEIBcoeND/omHTk?oFY>aoeND/OmAUk3oCYV`odjH/OmAUk7oDi:aoeVI]OmAUk3oDIRZoeBF
Y_mISI_ojooooo;ooooXo_ooM96OofJ;W_oMooooi?ooofV?X_mFSZOoGIF^og2K[_mGPY?oHYJ/oeZ>
Xom[T:3og_ooonCooomORIOoHI:SoenBYomQTJSoGi:WoeZFX?mKUJ3oHI6Xofb;YooeoooolOoooe^9
X?mFTjKoG9JToebDXOmPUj_oFhnU0_mQTJL01?mNTZOoGi:Wof:@YomQTJL2oejBY`05ofNDZOmPRiko
HI2Rof^IZOmKQID00_oRool07_mNR9KoIi:Soej;W_mRUJ[oFhRMongoooo[ooooK9:YofN;XOoOk?oo
lOkook7DiomOQYOoMi>Qog>=V_mURiSohoooon[ooom]QiCoLXjLon;ooooSooooHHbOof2@Y?mJSZCo
FYBZoeNE[_mEUK3oDiJaoe>E]@;oDIJe00?oDiFeoeBE/omDUK<00_mAUk404?mCU[3oEIF`oeZC/OmJ
Tk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000co
JVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/00aoeBE/omE
U;?oEiBcoeRC/omJTk7oEiBaoe6G/?m>VK3oCYRaoe6G/OmHUKCoFIJeodjAZomAV:coFYn_ofZR/OoU
ooookOoook_Jk_mKQ9KoHiJ[omWooooOooooIYJ]odV<Y_mLX[_oG8nZoeF7X?mKVkCoEiR^ofFDZ?n[
e^Oo^n[lofZM/?mKU:SoFYB/oeZC/?mEUZcoD9ZWoe6IYomKTjkoIXf^ongooooWooooIj2koeNO]omA
VJSoD9>ToeZF[P02oe^C[P0/oeZD[?mGUJcoEiF/oe^C[_mKTjcoEIF^oeFF[?mISjWoIIVaoe^EZOmF
TJ?oIIR]om_ooooIooooHIVZoeVFZ?mFUjWoFY^_of6J[_oGnoooi_ooom3moooPoooojoooolgSn_mU
SjGoHI6Uomooooo:n?ooHi^Xok3Vl_oLooooioooom_loonef^codO[oomgooooBooooFY6VoeZD[?mG
UJkoEIF`oeBE/OmCU[<2oe6F]@03oe>E]OmDUK?oE9Fc00;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC
]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?ol
noooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[006_mDUK?oEIBcoeND
/omGU;?oF9>aoeFE/?mAUk3oCYV`oe2H/OmCU[7oF9>coe^F]_mCU[?oDYZbodbCYom3P9;oLYR]ofJ6
WOmXUJcoGIBYoeREZ_mETj[oFHj^oeJA[omGXk[o@8bS0_mHU;H06?mDW;;oCYNZoe><YomPU[3oI9bc
oe:@YOm@V:koD9RaoeZB]OmJTk7oDIR/odjI[?m@Uk?oEiBcoe^:Y?m[V[Co@GjModj@/?mGVK7oE9R_
oe>K]?m?U[;oDiJaoeBE/@;oDiJa02SoE9FcoeBE/OmAU[?oDINaoeBE/OmCTjooDI>]oeZJ/om>RZCo
FYB/oeNCZomBT:OoCi>Xoe6I[om;TjWoBXjSof:L/?mITZKoFY^_oe^J[?mOTZGoCX6DoeVFZOmHVJ_o
DXfOof6L[?mMWjooChfLof:?X_mWSJ3oHHZLof>>XOm]W;3oE8NLoeN>XomJU:[oF9B/oeNE[_mEUK3o
E9Fa0_mCU[<2oe>E]@;oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH
[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=
g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc03;oEIBcoeND/OmHTk7oEIF`oe6G/?m@
V;3oDINaoeBE/omFS[7oF92coe2B/_mDW;GoE9ndoeNJ[OmXUZgoHhfUoeR>Z_mBT:WoF9baoeVL]_mK
Uk_oEIFhod^I[om<V[3oEYRkoeFG^_m<UjkoCIR]oeNF]OmBSJgoCXbUoe:I[om:V[7oCIReoe^A]omL
T;GoDIR^odbJ[_m:VKOoCYReoeJD[OmPV[;oEiJioeVI_?mJV[KoDIB^odZG/om8UK7oD9Ncoe6F/`;o
DIJe1?m@UkD04?m=U;;oCiJdoe6F/omHVkKoFIZfodnAZomATJcoH::loe>I/_mDW[OoDIVaoeRN]omC
UJgoC8fSoeNI[om>SjD2oefJ[`0@oe>DZ?mBUJSoEIN]oe>EZomDV:goEIJZoeR<XOmTU:[oHi>YoeZ=
X_mOTjWoGIJZoeRBZ?mPW;CoEiF^oeFE/0;oE9Fa0_mCU[<01?mCUKGoE9FeoeFD/omDUK<2oe6G/@0@
oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?co
oo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE
[P;oE9J`0_mDUK<0=?mEU;?oEIFaoeND/OmEUK3oDIN`oe2H/?mCU[7oEIBcof:H_?mMTkWoD92codVC
/?m7UJcoDYZ`oeZ@Z?mPTZ_oFYFcoeNH]?mDVk7oBHnXodZ:[OmEV[_oCIZ^oe2L/omBU[WoDI>fod^F
[Om@V:koF9VioeVH^OmGV;CoEYbeodfI/om@UkGoG92goeb@]Om@V:koBIb^odZI]om=V;GoEiN`oeFC
Z_mFUKSoCXjaoe2@[?m@TjgoDI^hoeFO_?mAU[?oDiJaoe>F/omAU[<2oe2G]@;oDIJe01WoDI^hoe>M
^_mCV;GoBhjYoe6G/OmHVkKoEYNcodV:Y_m@UK;oCiBaoe6A[OmGU;7oEI:^oefF/OmOTZooH9:]oenE
/OmHSZ[oE8ZVof6I]?mKV;CoB8VUodjA[?mFV;;oGYZb00;oFI>[00OoF9:ZoeJBZ_mPW[GoDY:[odf=
Y_mEUK3oE9J`00;oE9Fa1?mDUK<01_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF
]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonS
Z[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc00CoEIBcoeFE/OmG
U;3oEIF`0_mAUk00;_mDUK?oEi>eoef>]_mJS[GoEIFhodnJ^Om:W;CoD9jeoeBBZomHT:_oEiNcodfB
[om=UJkoEYjgoeNH^?mGV[OoB9>ZodbG[_mCU;;oE9Fcoe>I/_m@UZooCHj/oe6@/OmCU;;oBhjYoe2H
/OmDUK?oGhngoebA/om>VJcoBIb/odbI]Om@UkGoDiBZoeBBZOmHUkSoE9BgoeNG/_mFV;;oDIBaoe:E
/_mDUK7oEIF`oeFE/OmDUK42oe6F/`;oDiJc02;oCYFaodR?ZomBUK;oFIZfoe>F/Om=T:_oEYNcoebM
^OmCU;;oE9>boebG]OmIU;;oFIVeoenL^?mHRjSoGY6/odf:Y_mMV[KoHYRdoe^B/?mCT[7oEYVfoe^L
_?m@TJooDiB`od^=YomHV;?oFifgodj@Z_m@TZcoEIRboeZM]omCU[3oE9J`0_mDUK43oeBE/`;oEIBc
00GoE9Fcoe6G/OmAUk7oDiJ`oeFE/002oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8
g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[Ko
E9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`04oeBE/OmEUK7oEiB`oeFE/0;oDIN`02koE9FcoeRC]OmQ
TKWoF8bdoeBD^?m;U[KoA9RbodNI/OmHV[CoF9FaoeBE/OmBUkCoBYB_oe>K]?mASjSoFIVboe>K]?m>
UZkoE92XoeRD[?mFVKCoE9NdoeNC[omIUK7oFYNfoeRG]_mEUK3oFY>aof:>]OmNT;7oCIZZodVLZ_m>
V;?oE9FaoebFZ_mNV:coDY:^oe2A[omCTjcoF9J_oeF@[_mLUK?oFY>^oeRD[?mHU:koEiF^0_mEUK02
oeBE/@0RoeNH]?mIV[KoE9Faoe:D[_mBTZgoF9RcoeJC[om?S:SoFiRgoeJA/OmJTK3oCX^XodNCZom:
UZkoDiF[oeNK/?m=WkCoAIN]oeBG/OmGUk;oCIB`odjE/omFUKSoEIBeoeZL_?m@UkGoD9Fboe:G]?mB
V;;oCI>]oe6G/Om=TjgoDINaoe>F/@;oE9Fa1?mEUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;o
FY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP00
00[oK6EeoogjoonSZ[[oHVYeomOKf_o;gMooGi6XoeBF]_mCU[7oE9J`0_mEUK002?mDU[3oE9FaoeBE
/omDUK?oDiJcoeBE/OmEUK7oE9Fa0_mAUk40;?mDUK?oF9>eoefA^?mFS;;oEYRkodnJ^_m:VkSoAIF^
oeJL]_m>Sj_oDYF`oe>H]Om:U;7oFJ2loe2>YOmGUJcoEifgoe2F/?mHUJ[oFYN/oe6B[_mAU;7oG9Ve
oeRD/?m?SZgoEYFdoeND/OmJTk7oGi2aoe^B/Om>VJkoBY^^oe6G/OmEUK3oEHnSoenI[om?SZgoE9Fc
oeNI/OmJV:ooEHj/oeZC/OmHU:koF9B/0_mHU:h01omGUJkoEIF^oe>F/?mCU[7oChn[oeZG]?mATJ`0
0_mDU[006omFV;;oDY2YoefJ]_mGU[GoDI2_oeRC/OmEU[;oCIffodNG[_mHWkGoBI6WodJN/_m2VZko
DYZboe6D[om<U[?oCiRhoe2@/omHUk[oBi2_oe>M^_m?VKCoBYB_oeBN^Om9TjcoD9ZeodjH/@02oe2H
/@0Joe>F/OmCU[3oE9J`oeBF/?mEUK3oEIFaoeBE/omCU[?oDINaoe>F/OmEUK3oEiB`oeRC/OmGU;?o
EIBeoeFF]_mBUkCoCiF^oeJH[_mJTjOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000_oKf=i
ookioonTZKcoHF]eomKLf?o9gmcoG9BUoe6I/_mAUk7oDiJ`oeBF/002oeFE/@;oE9Fc00?oDiFeoe6F
]OmAU[<00_mCU[<2oe2G/`0>oe>F/omDUK?oEIBeoeBE]OmAU[OoCYNgodjH]Om@UkGoD9Ncoe6F/omC
U[7oDINaoe2G/om@V;42oeBF/004oe6G/Om@V;7oDiJ`oeBF/0GoDiJa01goDiJcoeBD]omEU;GoF9B`
oeND/?m@UkOoCYNgoe>F/omDUZkoEIJ/oeFE/?mCUKSoDIJgoeBF[_mDUZcoE9Fcoe>E]OmCU[3oE9J^
oeND/?mHU;3oE9J`oe6G/?m=VK7oCYRcoeBE/omGU;7oEIF`oe>F/002odfI/@08oeFE/?mGU;3oDIJe
oe2G]omCUKGoDIJeodfH]Om>V;<2oe>F/@;oCIVc00OoDiJaoe>F/om>V;GoCYReoe2G]omAU[GoDIJc
00;oD9Ra0_m>V;400om=VK3oCIVaodfI/002odfI/00Joe2H/?m@V:koDIR^oe>G[_mDUZkoDiJ`oe6G
/OmAU[?oDiJaoeFE/OmKT[3oFY>`oeBE/OmCU[?oE9FeoeJE]_mHUKCoDi>^oeFI[_mGU:KoIXnSolSO
lOoBf^GoIfM_ooclooojnOl1ofMVMP0000koL69kooohoonTZKgoHF]eomCNe_o7h=coG9BSoe6I/_mA
Uk3oDiJ`oeBE/OmEUK7oEIBcoeBE/`;oDiFe00CoDIJcoe>F/omDUK?oE9Fc0_mCU[<01?mDUK7oEIFa
oeFE/OmDUK42oe>F/`;oE9Fc0_mCU[<2oeBE/@;oDiJa0_mEUK401?mDUK7oDiJaoe>F/OmDUK42oeFE
/@;oDiJa00WoE9FaoeBE/omCUKSoDiFeoeBF[?mDUZkoDiFhoe6E^_mDUK400_mDUZ`02OmDU[3oDIFh
oe6F]omDUZcoE9NZoe6G/Om@UkGoD9R`oe>F/002oeRC/@08oeFE/?m@V;3oC9ZaodfI/omEU;?oF9>a
oeRD/?mCU[02odbJ/@04oeFE/?mHU;3oDiJcoe2G]@;oDiFe0_mCU[<01?mEUK7oEiBaoeBE/OmDUK42
oeFE/@09oe>F/omAU[?oDIJcoe>F/omDUK7oE9J`oeBE/OmCU[7oDINa00;oD9Ra0_m>V;400om@V;3o
DIN`oe6G/002oeBF[P0FoeFE[_mDU[3oD9Raoe2G/omDUK7oEiBaoebA/?mKT[3oDiJcoe2G/omDUKGo
F9Bfoe^C]?mFTZkoDiZ/oeJEY_mVSj?ob=oaom;JiOmWIfooo?cooo[io`7oIfIf00003?m_Hg_oo_Wo
ojBY_OmQJgGoe]gFolWOg?mNTj?oDYRboe6G/OmCU[7oE9FcoeFD/`;oE9Fc00CoDiFeoe>F/omGU;7o
F9B`0_mJTjh2oeRD[PCoFY>^0_mHU:h2oeZC[P;oF9B`0_mJTk42oeRC/@;oFi:a1?mJTk42oe^B/@;o
F9>a00KoFY>aoeRC/omEU;GoE9FaoeFFZ?mEUZX2oeBE]@04oeBF[_mEUZ[oEIJXoeBF[0;oDiJc00Ko
E9NXoeBGYomCUjkoDiJaoe>F/?mEUK02oe^B/@08oeRD/?mDU[3oD9Raoe6F/omHTk?oFi:aoe^B/?mG
U;02oe2H/@04oeRD/?mKT[3oF9B`oeND/0CoF9B`0_mKT[02oeZC/0;oFi>^0omHU:h01_mHU;3oFY>a
oeZC/OmJT[?oF9>coeND/`CoEIBc00?oEIFaoeND/OmGU;400_mJTk405_mKT[3oF9>aoe6F/om>V;?o
DiJaoeND/OmLTK3oFY>`oe6F/om>V;?oDiFeoeJE]_mKTkCoEY:^oe>J[?mFUJKoIXnQolWNkooBf^Go
IfM_ooclooojnOl1ofMVMP0000[oK6AkoogjoonSZ[goHF]eomOLe_o:g]coGi:UoeBG/_mCU[7oE9Fa
0_mEU;<01OmDUK?oDiJcoe6F]OmCU[?oEiB`00;oF9B^00WoF9B/oeRD[_mHU:coF9B^oeRD[?mHU:ko
F9B/oeRD[_mHU:`00omHU:h00omHU;3oF9>aoeRC/@02oeRC/@SoFY>a1?mHTk401?mEU;?oE9J`oeFF
Z?mEUZX2oeFD/`04oeFE[_mEUZ[oEIJXoeBF[0;oE9Fa00KoEIJXoeBGYomDUZcoDiJ`oeBF/?mEUK42
oebA/@0CoeRC/OmDUK7oDIJcoeBE/omJT[?oG96aoe^B/OmGU;7oDIJcoe>F/OmJTk7oFi:`oeRD[_mH
U:coF9B^oeZC[_mHU:koF9B`oeZC/002oeRD/003oeRD[_mJTjkoFY>^00?oF9B/00GoFY>^oeZC/OmJ
T[?oFY:coeRC/`02oeNC]@?oEIBe00CoEIBcoeNC]OmGU;?oF9>e0_mJT[<05OmGU;?oD9NcodjH/OmC
U[7oEiBaoe^B/?mJTk7oDIJcodjH/omAU[GoEYFfoe^C]?mFTZkoDiZ^oeJEY_mXSZ7obMk_om;JiOmW
Ifooo?cooo[io`01ofMVMP0000[oJVEioockoonRZkcoHF]domOLf?o;gMgoHI6WoeFF]?mDUK?oEIBc
0_mEU;D01?mDUK?oDiJcoe6F/om@Uk<3oe6G/009oe6H[_mCU[3oDiN^oe6G/?mAV:koDIN`oe6H[_mC
U[3oDiN^00CoDIN`00CoDINaoe>F/omCU[?oDiJc0_mAU[<4oe>F/`;oDIJc1?mCU[<01?mDUKGoEIFa
oeBF[?mEUZ`2oeFD]@04oeFE/?mDUZcoE9J/oeBF[P;oEIBc00KoEIJZoeBGZ?mDUZkoE9Faoe>F/OmD
UK42oe^B/@0>oeFD/omCU[?oDIJcoeBE/OmJTk7oFi:aoeRC/omEU;?oDiJcoe>F/OmGU;7oF9>aoeFE
[_mCUj`2oe>G[P04oe>F/?mCU[7oDINaoe2H/@?oDINa00KoDIN`oe>G[_mDUZkoE9J/oeBF[_mDUK<2
oeBE]@03oe>E]OmAU[GoDIJe00?oD9Ng00CoD9Neoe2G]omAU[GoDIJg0_mCUKL05OmAU[GoCYRcodjH
/OmCU[7oEiB`oe^B/OmHTk7oD9NcodfI/omAU[GoEIJfoeVD]?mETZkoEIV^oeJEY_mXSZ7obMk_om;J
iOmWIfooo?cooo[io`01ofMVMP0000ooJ6MiooWloonRZkcoHF]domWKf?o>g=goHY2WoeJE]_mEU;Go
EIBcoeFD]OmDUKGoE9Fcoe>F/omAU[<00_mAUk400om@V;7oCYRaodjH/@02oe6G/@04oe2H/Om>V;7o
CYRcoe2H/@;oDINa00CoD9RaodjH/Om@V;7oDINa0_m@Uk<01?mCU[?oDIJcoe2G/om>V;<2oe6F/`04
oe>F/omAU[?oCYRcoe2G/`CoDIJc00CoE9FeoeBE/omDU[3oE9J`0_mEU;L01_mDUK?oDiJaoe>F/OmD
UK7oEi>goeFD]@;oE9J^00CoEIFaoeBE/omAU[?oDiJc0_mHTk407?mCUKGoDIJeoe6G/OmCU[3oEiBa
oeRC/OmDUKGoDiJcoe6G/OmCU[7oE9FcoeFE/OmDU[3oDiN^oe6G/?mAUk7oDiJcoe6F]Om>V;GoCIRe
oe2G]om@UkGoCYReoe2G/omCU[7oDiJ`oe>G[_mCU[02oe>F/`04oe6F]OmAU[?oDIJcoe2G/`GoD9Ne
1?m@UkL05Om@UkGoCYRcoe2H/?mCU[3oEiB`oe^B/OmHTk7oCYRcodbI/om@UkOoEIJfoeVD]_mETZko
EIV^oeNDY_mXSZ7obmk_om?IiOmWIfooo?cooo[io`01ofMVMP0000SoIVQgooOmoonP[;coHV]dom[J
f?o@fmgoHhnXoeRD]P;oEIBe0_mDUKD01_mDUK?oDiJaoe>F/OmCU[7oEIBcoeBE]@;oDIJe0_mEU;L0
1?mCUKOoDIJgoe6E^?mCUKL2oeFD]`06oe>E]OmAU[GoE9FeoeFD]OmDUK?oE9Fa0_mGU;402?mCU[7o
DINaoeBE/OmEUK7oEiBaoeBE/OmAUk7oDiJa0_mGU;401?mDUK7oDiJcoeFD]omDU;L2oe6F]@03oeFC
^?mETk[oDiFh00;oDIJg00?oDiFgoeNC^?mEU;L00_mCU[<01?mEU;GoE9FeodjH]Om>V;<2oeBF/00<
odjH]Om=V;GoD9Raoe6H[_mDU[3oE9Faoe2G]Om>V;?oD9R`oe6G/?m@Uk?oDiJc0_mGU;401?mEU;?o
EIBeoeNC]omETkP2oe2F^P06oeBC_?mETk[oDIFjoe>E^?mEU;GoEiBc0_mGU;42oeFE/@03oeFD/omE
UK7oEIFa00?oE9Fa0omDUK<3oeBE]@0Foe>E]OmCU[?oDINaoe6H[_mDUZkoF9B^oe^B/?mHTk7oCYRc
odbI/om@UkOoEIJfoeVD]_mETZkoEIV^oeNDY_mYSZ7obmk_om?IiOmWIfooo?cooo[io`7oIfIf0000
5omUJ7Oomogooj2/^_mRJgCof][Hom3KgOmUSjSoF9BhoeNC]OmEU;GoE9FeoeBE/omEUK7oEIF`oeFE
[_mEUK3oEiBaoeFD/omAU[?oDiFeoeNC]OmHT[OoE9Bg00;oDIJg01?oE9BgoeRB]omGTkGoDiFeoe6F
/omEU;?oEiBaoeBE/OmDU[3oFY>`oeRD/?mCU[3oDIN`oeFE/?mGU;3oF9B`oeFE/?mAUk3oDiJ`00;o
F9B`00koEIF`oe>F/OmDUKGoDiFgodjH]Om@UkGoE9BgoeBD^?mAUKSoCYNhodjG]omAU[OoEIBgoeFD
]@;oDIJc00KoEIBcoeBE/om@UkGoD9RaoeFF[?mDUZ`2odjH/`04oe6H[_mDUZcoEIJ/oeBF[P;oCYRc
00coDiN/oeBF[?m@V;7oDIJcoeND/OmHU;3oEIFaoeFD/omJT[OoEi>hoe6E^_m@U[X2oeNB^P06oe6E
^_mAUKSoEi>eoeRC/omGU;?oEIFa0omEUK02oeFE[P06oeFF[?mEUJkoEIF^oeNE[_mEUJkoEIF`0_mD
UK42oeBE/`0Eoe>F/OmDUZkoEIJ/oeNE[?mJU:coG9:^oeZC/?m@V;7oC9Vcoe2G]OmDU[KoF9BfoeFB
[_mEVJkoEiBVofV>XOo;g^oodmWUofMWKoolo?oon_Wo007oIfIf0000Q?mSJGGom_kooj2/^_mRJgCo
fm[Hom7JgomUSjSoF9BhoeB@/_mRXL;oDi:aoe6A[OmKVK;oGIVaoeJ@Y_mKUJ_oEi>[oe6BZ?m>VJko
E9bboe6>Z_mJUK?oEI^eod^E[_m?VK;oCiF_oefH]_m>RjOoEIfcoe6L/OmATZSoEYN]oeFI[_mDV:go
Ei>[oeBBZOmBWK3oCIZ/oeBF[?mEUZcoF9J]oeBH[Om;UZWoBYFXoeNE[?mGTj_oEYZ_odjEZOm=TJSo
FInhodbJ/Om?Vk?oEYRboe2A[Om<U[7oC9VcodnL]_m:U:goFYZeoeRH/Om<UjkoBiJ[oeBD[OmFU:go
DIB_oeBF/?mKUJWoFIJYoe6D[omDUk;oG9V^oeB=X?mOV:_oDi6Voe2F/?mEV;?oFiFYoejGZomDU[3o
E9Nboe>C[?mGV:koCI6VoeNK/_mCSj_oH9fjod2:YOmGXKkoF9BfoeJB]?m7TJkoBiF`oeZK]omKVkKo
CHnYoe2G[OmAV:coEYf_odfDY_mBUjOoDiRXoeRKZomDUjSoDIBUoeVJ[?m;SYooF9^^oe2DYomBUZ_o
EYfcoe2G[OmCUjcoDY2UoeNAYOmMUZ[oGI6WoenAZ_mGSj[oDiVbodfI/om@UkGoE9JfoeRD]_mETZko
EIV^oeNDY_mYSZ7obmk_om?IiOmWIfooo?cooo[io`7oIfIf0000Q?mSJGGom_kooj2/^_mRJgCofmWJ
om7JgomUSjSoF9BhoeBC]?m;RZWoDI6]of>P_?m?RJ7oDX^OofBG[?mXV:coI9>Uof6FY_mKVjOoEYFT
ofJF[?mQTJOoEHnSoeVJ[?mEUZSoFI>WofFCZ_mRTZSoD8jMoeFEXOmZWJkoD8>Doe:=WomPVZkoHI6X
of:DZomATZCoGJ2aoe29WOmOTjWoG8jUoebEZOmMX;7oE9FWoej@YomUUJcoE8jRoenJ[?mTVJ_oDXZK
od^<W_mEU:KoH9>Xoeb?Y?mNVk3oFIZ`oeBEZomMUjgoFHRLof>BY_mIU:KoIJ:dof2AX_mTTjOoH9Jb
oe^C[?mSU:GoHYFVoeF>ZOmCS:WoHi6Xof^FYomNSIgoGI6Vof>P_?mARZGoII:UoeZ7V_mHTJcoFYRa
oe^BY_mNUZOoFiVXodj9Vom[Vk7oGHfToefL[_mASjCoGhjXofFD[_mHVJgoG9nboeB<Xom=Q9WoIZ2f
oeNFZ?mDUJOoD8nPoeVHZOmHUZGoEY6Ooe2:V?mMUJCoGYJSoejFYOmUWJcoGYJUof2IZ_mJTjKoDhjP
oeRBY_mKUJWoIYj_ofNJ[OmGQi_oIiJZofB@ZOmKSjOoG:2godfG/?m@UkGoE9JfoeRE]?mCTjooDiZ^
oeNDY_mYSZ7obmk_om?IiOmWIfooo?cooo[io`7oIfIf0000;_mUJGComogooj:[^_mSJWCogMWJom7J
gomUSZ[oF9BhoeVJ^_mLWK_oGIfhodf9XOmOUZ_ofoooomoooomOPi?oa=cXon_oooncf^7oIH^Donko
oooVnoooJhbKokKNj_oRooooeoSoom7TmOo^ooooi?ooofR?U_o/ooookOooofj?X_m/S:?odnSoonSo
oon/eNWoHHbOolo]oooZoooojoooom?aoomNRIcoH8VMon_oooo/ool2onKoo`04onkooooNmOoo/M;S
ofR9VP;olOoo01KoKHVNomKioooVooooNYFXol_HjOo^noooh?_ool[WmOoaooookOkoof64X?n_fO;o
hoooomSmoombWkcoH8bYom7]oooRo?ooioooolkdoomSTZkoGh^X0_oZool0=_mQSJSoGhjXofZ?XOnc
e>?ogOooon?oooo@iOSoj_ooon3ooomcVJCok_ooonKkoomYT9ooH8^Kok3Ai?oVoooog_ooom_oooo?
n_ooHXfPofVBY_m^U:Oob^goonKooooSoooofoSoofV6V?mZQiWojOooomgloomhVJcogoooonCooomZ
Sj;oRkG5olggoooPoooog_ooomGkoonYenooB8VOoe6I/OmAU[?oEIJfoeRE]?mCTjooDiZ^oeJEY_mX
SZ7obmk_om?IiOmWIfooo?cooo[io`7oIfIf0000Q?mUJGComogooj:[^_mSJWCogMWJom7JgomSSj[o
EYFhodj@/?m3QZ7oFIVbof2J/?mOTZGofOooonKooomeS9[oiNohoo;moooRo_ooM8fAonogoooioooo
P9JQonOooooToooo//SComcRl?ocnoooioooog:>SooboOoologoogB9V_nT^]7omokoonWeoomcSjCo
d?7oon;doooBg_So[k_Eoo3ooooGn?ooMYFYon_eoooan?ooNY2Wog27Uonoc=Gom?ooom_foomhT9co
l__ooo?ioon0Tj7ojoooongooomdQYCol_Cooocooonda];oc^;]oo_oooofo_ooN9:[onGooooZoooo
MI>Noe^0Voo4iOool?ooom?Qk_nV_<WoioooomCmoomWRZKol_ooonknoom_Tj_oJI6Zofb9VOoYoooo
iooooj6laOoBg>Somoooon?ooom[Qh_onOooooSooom`SIGo[LoHongooooAj?[oKHbNojoDi_oNoooo
doKoofj>Xoo:jOgoj_oool?Jk?n]`]?ol?ooon3aoon0TJ7olOooonkooomcR9_ojoooon;hoomeT:?o
hOooonKooonUaM;oXL3BonOooooBnoooGY^`oe2F[omCU[?oEIJfoeRE]?mCTjooDiZ^oeJEYomXSZ?o
bMk_om;JiOmWIfooo?cooo[io`7oIfIf00005?mVJ7ConOgooj>Z^_mUJGCogMWJom7JgomRT:[oEIFh
oeRM^_m@UZooFibboeZCY_mTTZ;oi?ooonWooomlSIOon?ooooOooooMn_SoL8f;0_ohool0K_m[PXSo
i?ooonOooomdRi7oO8>=ooSoooo[ooooP9fIooCoooogoooo_=CPol?Mk?oco_oo]L;Eofb>V_oPoooo
k_ooog:1U?mjRIcoM8VJog6EXOm]Si_okocoooGooomZQ9?oKh^FogB9S?o]oooofoooof69Rooaoooo
l_ooofN8SooOoooohoooog>BUooeooool_ooofB3Q_mhVYcojogmooCooomaS:7oi_ooon;koomdSiKo
Ki>[on7oooodooooOXN@ohBGW_mPOXWoKIF^og6AZ_o_n?oomoooof^;X?mMQYcoK8fNonGooooSoooo
JhbAogb9T_o^nOooj_ooogNDT_ohoOoonOooofR7R_o=m?Woiooook7<gOmVSIkoK9ZZofJAY?mcW[7o
G8:EonCooooQooooLXjLofj5TomfS9WoNhjLofUlR_o_ooool?ooogfCXOo]ooooioooog6;V_mgTYgo
J82:okS@g?oIl?kojoooomgooomMUZ[oDIF/oeBE/omFUKKoF9Fdoe>C[omBVjkoE9FWofJ?Xoo9g_7o
d][UofMWKoolo?oon_Wo0OmWIWH0001VofQXM?ojo?ooY:ZjofEYMOoMfM[odM[Oof:@Z_mDU[SoDIRd
odfE[OmCUZWoFI:Sof^EXooWoooolOoookK0b_o]l_Soio;don[ooonS_l3on?oooo?ioomlUI[o^mcQ
onOooooSo?oo];[6ooSoooo[ooooI8:0ooOoooo^nOgoi_ooomkjooo/n?ooPXnOofjCVooLooook?oo
oo;oooo_ooookOooomSooom/TIWol_oooo;noomfTYgoKXfBokoGeooYoooof?ooog:MXoo^oooolOoo
of>8T?oOooooh?ooofF6SOo6eMSom?ooomWloonQa<SolOoooo;ooombSJ3oioooongooomSPH?oJi6T
onKoooodoooom_ooonoooooWoooofOooofR;Woogooool?_oog2DY?mYUZWoJY2SokOLk?oOooooc_?k
ok6mbOogooooh?klofj;QooloooonOgoofF6RooRoooojOooof:1UOmVTjKoFhjQoej>X_mCPYKoJYNZ
on3ooooMooooiooo0_oZool02_o/ooooNhnJoo3oooo^ooooJX:>on_ooooZooooL8^FolgQj_o/oOl2
oo7oo`0@on7foonhfNcoGIBXoeFF[?mDUK7oEYFfoeRE]?mCTjooDY^^oeBEYomVSjGobMkaom;JiOmW
Ifooo?cooo[io`7oIfIf0000Q?mYIgGon_coojBZ^_mUJGGogMWJom3KhOmQTJSoDYNfodnI]?mBV[3o
E9NXoeN?W_mZTYkojoooooGooooBe^7oo?kookk8dOoZoooo`=gSooWoooobmoooJh:@ogFGXOn/c]So
b^7_ooCioooenoooj_ooofb9SOocoOoomoooonSooooZoooobmOSog62S?mWSi7oh?ooon7loomhRYCo
MhVCon_ooooNooooHHV;oo;oooobo_ooi_ooonWoooo_ooooi_[ooiFkb?mXS9[ol_ooonkjoomjUjOo
eocoon3ooomlUjSoNh>>ojng`_oCkogoi?oooo3jooodooooJ8NIon;ooooTooooJHf9ofRFYOoLoooo
i_Wooh6AT?m[R8?ohoooom?ooomORY[om?oooo?ooomXU9ooFXnQofRBZ_mHPIOoW/gMom7foooboooo
m?goon[ooom^RXgolO?ooo_noomaTIcof_ooonKooomWRJGoKj6loeJ>YomVWK;oH9>Vof6BXooLoooo
h_oooeIhQ?maSi[ojoooonSnoom_QXkok_ooonSooom]R9?oj_ooomgkoomhTikojOSoooKooooYm_ko
d^3[og62T_mhUJOoF8^NoeVG[_mEUK7oEYFdoeRE]?mCTjooDYZ`oeBEYomUSjGob=kcom;JiOmWIfoo
o?cooo[io`7oIfIf00005?mZIWGoo?_oojBZ^_mUJGGofmWJolkKhOmOTJSoDIRfodbF/Om>UZcoF9V[
of:GYomZT9goi?coooGooooPi_;okOCoogF5T_oSooood^gf0_ogool0HomgTJ3oeoSookCHj?maSZ3o
[KcCoo;ooooMnoooL8jFooCoooo/oOooZ/gComcooooZoooo/LWEof:?U?nnko?oioooolGMioo2f^Co
h_oooko_lOmWTiKojoooonoooom]SYGoL9>IokK:doo`oooobncmoff<W_o_ooool_ooofB0UOoToooo
hOooofn:WOoXmOooc]k]of^8V_nO_]3olOooonSjoom`TJ;ohOooonCooom_UiKoGHfIol?^o_oZoooo
a]oSokkRh_oLoooo^NklofVIYooZoooojOooojWIhomLU:GoH92Wom[ooon^g_;oGXNIok?9g_o/oooo
hOooog2>U_ogooookOSoog2AX?oKoooohooooff?ZomIQj7oHIF]oeB;X?mVVZooH9>VokOVn?oOoooo
`^OgokgOjooToooob^Kaofn:TooYooooj_ooog:>VOoXoooojOooofV5T?oWoOoolOooofn3S_nbb=Go
ioooomOloomQUJ[oEi>[oeND/002oeRE]009oe:C[omBV[3oE9FYofJ?YOo9g_?od][UofMWKoolo?oo
n_Wo007oIfIf0000=om]I7Ooo_[oojBZ^_mSJGGofM_Jol[NgomLTjSoCiVfodjH/omDV[?oEiFZof6D
YomUS9goj_ooon[koooZn_ooeN[mog>=W_oElOgokOooonOhoooaooooKhVFoj;3e?oFooooh?ooon;o
oooOoooo/]KVof^9Too`ooooj?ooof6@V_nPdN3ohOooon;ooon@a];oGiRSol3[nooSooooi?oookkX
m_mYWJSoH92LonKooooZooooJHnLofVAVom[RICojOooonOooomYRIKoioooon[ooomXRIP00_oSool0
1omSQiOo[loNom[koooNooooh?ooom?goonjfnX00_oTool2on3oo`0YofZEY_mUTZGo_nWion3ooooM
oooo`?7oof:GZOmQU:GoeOooon3oooo2l_ood?oooefAY_nKcnCoc?ooomWooooQoooofooooj_@h?m`
U:;oioooon[ooom^Sikoc^ononOooonXbM[oHXNIofZEY_mMT:?oGIBXof2DZOmPTjKo_nkoomgooooL
oooobO3oofb@W_mZS9Soi_ooonOooomQPHh00_oYool05Om]Si_oZ<oPom3ioooRooooh?ooom;ooonI
c^3oGiV]oeB@Z?mJTk3oFIBboeFF/_m>UZkoDY^^oeJEYomXSZGobmgcom?IiOmWIfooo?cooo[io`01
ofMVMP0000koKf=gookjoonTZ[[oHV]domOKf_o:g]ooFiBXodnI]_m:U:ooDiVboeNE[?mFRYooH8VM
onOoo`;okOoo07Co_]kcofV<X?nog>coioooongoooo[ooooIXJCog6FZ?mPSZGoGY:ZoeR;Y_mRU:_o
JIBUof65TOoZooooi_oooenDX_mESZ;oFXRPofRH[omLVJ_oBhRJoffP/omKR9goIY2Voej=WomHT9oo
H9>Ton?ooooEn?ooL9^/oef8V?n]dn3oi_ooomKhoom^TZ3oMYZXof:8UOmbUjOoh_ooon3ooomHPi?o
HHbMofJDY?mTTj?oIiJVofJEYomTTZ;oJHjNonCooooSooooJY>Uoeb9W?mLRiooH9:YofJJ/?mHSZKo
G9:ZoeF<XOmHSjCoIi^`of:EZ?mLS:3oIIR[oeB=X?mJU:SoGYFZoefAY_mOTZOoIYFYofNBYOmRRioo
h_ooon?ooomWRYgoWL7AonCoooo>l_ooKi>QojC>g?oIooooaooooeN>XomKTZKoFhnTofNJ[OmDQIKo
Hi:TofB?X?mYTj?oeokoon?ooomcUjOoi?ooomoooombVJSoFXfRofJM/_mRU:_oF8bQoeZDZ?mBSj;o
CXZRoenK]OmKT[3oFIBboe:H/_m<UjkoDY^^oeNDYomYSJGobmgcom?IiOmWIfooo?cooo[io`7oIfIf
0000;_m]I7Goo_[oojBZ^_mSJWCofM_Jol_MgomLTjSoDIRfodjE/OmAUk7oGYbeoejEZ_m]VZooeo[o
on;ooooUooooTK[@ofREZ_ncf^_ohoooonOooooOooooKYFVoen<XOmLTZ[oHinioeZF/_mHTZ[oG92U
ofjLZooLooooh?ooofNP/omIUJgoG8jYoenB[OmJV:goD96Uof:H/?mLSZGoI9B[oe^?YOmMV:[oGIJY
omSooooNool2om_oo`1DomoooooAnoooZ=;Roen8V_oEo_oof_ooofjI[?oBoooodOooofbL/?mTU:[o
FhjSoeb?Y?mHRj3oFhnUof6AYomQSiooXlkNolgjoomTTjOoGY6Vof:F[?mTV[CoCHFNof2I]?mDT:[o
G9J^of2J/_mESJCoEHbQoejBZ?mJTJKoH9fboeJDZomGTJOoG9B[oefCZomKSJCoGhnUofVG[_oKoooo
gooooef8VomZTjGo[=GWomKooooPoooog?oook;[oomHU:coI9jdoeVCZOmJTZWoEhjSofBH[OmPTjSo
GXjRofNFZ?oMoooogoooofF@XOoNooooh_ooodYgR_mKSjGoGIF/oejBZ_mKTZOoGYR^oeZH[OmGUJco
GIVcoe^B/?mIU;;oDYRbodbG[_mBVjkoFI>WofV=YOo;gO?odmWUofMWKoolo?oon_Wo0OmWIWH0001:
ofeTMOomn_ooY:Zjof=ZM?oJf][ocMcOoejBZ?mBUkSoFJ2nodnB[OmFUZooEhnVoe>3VOmcW;3oJXnR
ofnEZ_mVV:ooCh>Koej>X_mZV:SoI8jNofnJZ_mIR9[oHIR]odf:Y_mEU[;oDIBaoeJG/omHUJ[oFHjP
ofbJYomJRiWoDXnToe6A[?mOU;?oG9>aoe>E[Om?TJWoEi2[of>I]OmKTJ_oGYJ_oe>AY_mCT:GoKInh
of:BZOmDRj3oEHbQoe64UomZVJgoHI6Uoen?YOmdY;[oFXZPoef@YOmXV[7oJIfcoeF;XomPUZkoG9B[
ofBJ/_mNUZooGiN`oeV?YomWVZooFHVMofnR]omISJ?oGIF^oeJ?Z_m@S:SoHIjjoe:B[_mHV;@2oeJC
[`04oebH/_mGTjgoEY2Xof6K/`;oE9B]03;oEiF^oeZF/?mLUZkoFY:[oeV?YomKSjOoHI>/oenAZ?mV
UZgoJYZ`oe20U_mMSJ?oHY:XoenCZOmSWkOoDI6Zoe2>YomJV;7oHIfeoeB@Z?mOVJooEHfToefCZomH
S:;oFhfTof>FZomEQI_oGhnUof>AZ?m]WkKoFY:[oeRBZ_mMTjgoGiN`oeZF[_mFUjgoDi>/oe6>Z_mJ
Tk7oFIBboe:H/_m<UjkoDiZ^oeVCYomYSJGobmgcom?IiOmWIfooo?cooo[io`7oIfIf0000Q?m/IGGo
oO[oojBZ^_mUJGCofmWJolkLgomQTJSoE9JhodjC/_m8RjSoE9B_oebH/_mMTj_oHi>Yoeb9W_mOSjGo
GIJaoeVF/_mGTJOoGiJ[oe^?Y?mPU:WoGIF/oeNE[_mIW[_oEIjnodRC/om<U[?oD9>]oeVG[?mITJ3o
FY>ToeFE[_mCU;;oF9>coeFB/OmFVKKoEY^hoe2=Z_mHTk7oEI6]oeZG/om<SjWoFYbdoeJ>ZOmKTJgo
FYJ`oebJ/OmRW;CoEhnVoenG[_m@R:7oEHnWoenI/OmITj_oDX^Voe6:YOmIUK7oFYJboe:?ZomIUK7o
EI:_oeZG]?mHU;3oFiF]oefE[?mCSJ?oCHVQoefJ]_mKVkOoCXn]oeFH]Om;SJgoFI^koeBE]Om@TJoo
GIfioeBD/?m<RJGoF9RcoeJH/_mFVK?oEINaoe:B[OmDTJgoFIFaoe^G/omLUK3oGiRcoeB<YomKTjko
GYJ_of>K]?mXX;WoEXjWoeJB[?m>SZWoGj:lodZ<Y_mGVK?oBXZUoeVI]?mDTJgoEi>]oeJB[?mPVKCo
G9F`of2H/OmQVK;oFY:[oeR>Z?mLU:ooGIVeoeNC[omJTJooF96/odj>YomBU:coFYbfoefJ]omJTk7o
FIBdoe:H/_m<UjkoDiZ/oeVDY_mZSJ?oc=gaom?IiOmWIfooo?cooo[io`7oIfIf00009omZIWGoo?_o
ojBZ^_mUJGCofmWJom3KgomRT:SoEIFhoe>E]omFV;SoF9VeoeFE/?mHU:coGYJ]oejEZ_mKTj[oDi>_
oeRK^?mBTZgoEYB[oeFBYomDT:SoEiN`oe2C[_m2SJcoAiJeodbK_?mEXL7oD9ZeoeFI/?mAT:;oHJ2b
oeBE/OmGVKWoF9NhoeJE]_m>Tk;oDYNfodn@/002oeZI^011oeNH]?mBV;;oEIRcoe>@[OmCSj_oF9Rd
oe>E[omCTjkoDi2/oejK]omMV[KoDY:]oe:B[_mIVKGoEIFaoefM^OmJVKSoD8n^odn@[_mFUKCoD96_
oeFD]OmHV;CoE96]oeJD[OmHV;7oE9B_oeJG]Om>TJkoFj2oodF<Z_mKX<7oDIJgod^@/Om>T;;oD9:b
oeJG]OmIV;OoDiB`oe:E/?m?UJooDiJaoeRK]_mIV[KoEYJboeBD/?mEUK7oD8fZofNT`?mCT:goD8fZ
oeBA[_m=RZOoF9FboeFE/OmIW;OoA8ZTofNZaOmCU[7oDYF`oeNH]?mFUk?oDY>_oe6A[OmHV;<00_mF
Tk006?mGU;7oEY>`oeVD/_mETZooEIBcoeFE/OmLUkGoGIVeoe>E[omAU:koE9Faoe:B[_mJT[?oFIBd
oe:H/_m<UjkoDiZ/oeVDY_mZSJ?oc=gaom?IiOmWIfooo?cooo[io`7oIfIf0000>OmYIgGoo?_oojBZ
^_mUJGCogMWJom7JgomUSZ[oF9Bhoe:B]OmHV[[oCi2^odj?Zom?TJ_oE9B]oeRF[OmETjcoCi:_oeFJ
^OmFVKCoEINaoeJF[omCTjkoEIRcoeFL^?mJYLGoCIbmod6@/Om4Tk;oBYFboeFK]?m?TJOoDiBZoe:E
/_mDU[SoCHb_oeBD]om?TK?oEIZioeBE]OmCU;CoDI:bodjA[_mDVKKoCiBaoeRI]omFU[;oEYVfoe>F
/OmFVKCoEIRcodV<YomFVKCoEiZeodnB[omFVKKoCY6^oeBG]002odf?[`0HoeJH^?mHVKWoEINgoeBD
]omCU;;oDI:^oeJH/_mAU:koD9>^oenT`Om7SZcoCiJfoeNP`?m=TkGoBi6coeNN__mLXL;oD9:boe6C
/omIV[[oDiBboeBG/_m?UJooCY>`0_mAU;401_mAT[3oDiBboeJG]OmNWkgo@X>Ooe:C/@;oFIZh02Oo
GIjlod^<Z_mJWK[oC8nZoejT__m4RJKoC96^oeNL^Om7RZOoD9>`oeJI]_mCU;;oF9VeoeBE/omAT[3o
DY>aoeNH]_mFUkGoF9VgodnA/OmAT[;oEI:aoeJC/?mCU[7oDYRboeFH/omGV;KoF9>eoeRE]?mBV;;o
C9N^oe>J[?mIU:KoK8bSolgLlOoCfNGoIfM_ooclooojnOl00OmWIWH0000fofUWMOojo?ooY:ZjofEY
M?oMfMSod]WOofF>Z_mHU;WoEYFhoeRH^om:S:coEIZgoeNM]omCU[3oDiN^oeFH/_mDVKKoDYNfoe:E
/_m@TJgoF9ZdoeJH/_m@TjkoCYFcodNB/Om<V;SoCi^koe2M^om=UkCoDiVcoeBF[_mEUk7oD96_oeNH
^?mAT;?oG9fmodnA/omCUKGoEIJfoe6B/?mBU;CoDYFboe:G]?m?U;7oDYFboeVL^Om>TJkoDYNdoe>H
]Om<TJkoE9VfoeJK^?m9SZ_oCiBa0_mEV[T2oe2E]00_oeVK^omFV;[oBXb^oe>E]omEUkWoCi6aoeBG
/_mDUk7oDYRboe6G/Om<TjooDYVgoe2G]Om:TK7oE9^koe:I^Om?U[KoCY>boe>E]OmDUkCoE9Feoe6B
/?mAU:ooEI^eoeNJ]Om@TjkoD9>`oeJI]?mFVKKoD9>`od^>ZomNXKkoE9Ndoe:E/_m<SZkoDYBdoeZL
_?m@Tk3oFIbgodB:Y?mFVKCoFj6kodb?[?mDV[CoF9^hodnB[omIW;T00_mAU;406OmHVkSoDI>coe:D
]?m>T;3oE9Jfoe:G^?mFV;[oEYFfoeJE]?mHVkSoE9Zdoe:E/_mCU;;oF9>eoeRE]?mBUkCoC9N^oe:K
[?mIU:KoK8bSolgLlOoCfNGoIfM_ooclooojnOl00OmWIWH0000;ofQWMOojo?ooY:ZjofEYM?oMfMSo
d][MofF?Z?mHU;SoEIBgoe>E]omAU[D00_m@Uk<2oe2H/@05oe6G/OmCU[?oE9FcoeBE/OmEUK400_mE
UK000omDUK7oDiJcoe2G]@02oe2G]`05oe2G]OmAU[?oE9FaoeFE[_mEUK000_mEU;<02?mEU;GoE9Fc
oeFD]OmEU;?oE9FcoeBE/OmCU[?oDiJa0_mDUK44oe>F/@;oDINa1?mAU[<4oe>F/`03oeBE/omDUKGo
E9Fe00;oE9Fe00CoE9Fcoe>F/OmCU[3oDIN`0_mAUk42oe6F/`CoDIJe0_mCU[<01OmDUK7oEIBcoeBE
/OmDUK7oDiJ`00;oE9J`00?oE9FaoeBF/?mCU[401OmCU[44oe>F/`07oe>F/OmCU[3oE9J`oe>F/?mD
UK7oDiJ`oeBE/@05oe>F/@?oDiJc01GoDiFeoe6F]omCUKOoE9FeoeBE/omAU[?oD9Ncoe6F/omDUK?o
F9>eoeRE]?mAV;CoC9N^oe:K[?mIU:KoK8bQolgLkooCfNGoIfM_ooclooojnOl00OmWIWH0000<ofQW
MOojo?ooXjZjofEYM?oMfMSodM_MofF?Z?mHU;SoEIBgoe>E]omAU[GoD9Ne0_m>V;<00om>V;7oD9Ra
oeBE/@02oeFE/@06oeND/OmGU;3oEiB`oeFE/OmDUK7oE9Fc0_mCU[<00omDUK?oE9FaoeFE/002oeND
/0;oEiBa00SoE9FcoeBE/OmGU;?oEiBaoeFE/OmDUK7oDiJaoeBE/@;oEIFa00SoDiJaoe6G/OmDUK7o
E9Faoe>F/OmAUk7oDiJcoe6F/`CoDiJc1_mDUK<00omDUKGoE9FcoeBE/@02oe>F/003oe6G/?mCU[7o
DiJa00;oDiJa00?oDiJcoe>F/OmDUK<00_mDUK42oeFE/@;oEIF`00?oE9J`oeFE/?mDU[000omDU[00
0omCU[3oDiJaoe>F/@04oe>F/@05oe>F/omDUK7oE9J`oeBF/?mEUK001OmDU[001_mDUK7oDiJaoeBE
/OmCU[7oE9Faoe>F/@;oDiJc01CoDIJgoe>E]omDUKGoE9Fcoe6F/om@Uk?oDIJcoeBE/omHTkGoF9Fd
oe6H]?m<UjkoDY^/oeVDY_m/S:7ocMc_om?IiOmWIfooo?cooo[io`7oIfIf00003?mXIgOon_cooj>Z
^_mUJGCogMWHom7KgOmUSjSoEYFhoeBD]omCUKOoDIJeoe2G]@;oD9Nc00?oD9Raoe6G/OmEUK401omG
U;04oeND/@CoEiB`00OoF9B`oeND/?mDUK7oE9J`oeRC/OmJTk3oEIF`00;oE9J`00_oEIF`oeRD/?mG
U;3oDiJ`oe6G/?mDU[3oEIF`oeBE/OmCU[7oE9Faoe>F/@04oeBE/@KoEIFa00?oEIBcoeBE/OmDU[00
0_mDU[000omCU[3oE9J`oeBF/002oeBF/003oeBE/OmDU[3oEIFa00;oEIF`1?mGU;001?mEUJkoEiF^
oeFE[_mEUJh3oeBF[P;oDiJ`1?mDU[001OmDUK7oEIF`oeFE/?mEUJkoEiF^00GoEIF^01coEIF`oeBF
/?mEUK3oE9J`oeFE/?mDU[3oE9Faoe>F/OmAU[GoDiFgoeFD]OmEU;?oDIJcoe2H/OmAU[?oE9FcoeRC
]OmHUKCoDYNdodbG[_mBVjcoFIBVofb<Xoo=g?7odmWUofMWKoolo?oon_Wo0OmWIWH0000;ofQWMooj
o?ooXjZlof=ZM?oKf]Sod=_Mof>?Z?mFUKSoDiFgoe6F]Om@UkD00_m@Uk<01?mAU[?oDINaoe>F/OmE
UK04oeND/0;oEIF`0_mGU;04oeRD/0?oEiB`00CoF9B`oeND/?mCU[3oDiJ`0_mJTk002omEUK3oDiJ`
oeBF/?mEUK3oFY>`oeRD/?mCU[3oDIN`oeFE/?mGU;3oEIFa00GoE9Fa2_mEUK46oeBF/0SoEIF`0omG
U;001_mGUJkoEiB`oeFE[_mEUK3oE9J^oeBF/0?oDiJ`1?mDU[02oeFE/006oeND/?mGUJkoEiB`oeNE
[_mEUK3oEIF^2?mEUK005_mDU[3oE9Faoe>E]OmCUKGoEiBcoeFE/OmCU[7oDINaoe>F/omDUK?oF9>e
oeRE]?mBV;;oC9N^oe>J[?mIU:KoK8bSolgLlOoCfNGoIfM_ooclooojnOl1ofMVMP0000WoJ6Mgoo[l
oonSZ[coHfYdom_Jf?o@fmgoHY2WoeFF]_mAU[D00om@Uk<01?mAU[?oDiJaoeBE/OmDUK43oeFE/0Co
E9Fa00?oEIF`oeND/?mGUJh00_mHU:h05?mGU;3oEIF`oeBE/OmDUK7oEiB`oeFE/?m@V;3oDIN`oeRD
/?mJTk3oE9J`oe6G/?mCU[7oE9FaoeZC/OmHTk7oDINaoe2H/OmEUK7oEiBa5_mEUK47oeFE/00:oeBF
/?mEUK7oEIFaoeND/OmGU;3oEIFaoeFE/?mDUK7oDiJ`oe>F/@?oDINa00CoDiJ`oeBF/?mDU[3oEIF`
0_mGU;02oeFE/004oeFE/OmEUK3oEIFaoeFE/0CoEIFa1OmEUK005OmDUK7oE9FcoeBE/omHTk?oEiBa
oeBE/OmCU[3oDiJaoeFE/OmHTk?oF9Fdoe:H/_m<UjkoDiZ/oeVDY_mZSJ?oc=gaom?IiOmWIfooo?co
oo[io`01ofMVMP0000SoJ6Mgoo[koonSZ[coHfYdom_Jf?o>g=goHI6WoeBF]P?oD9Nc00WoDINaoe>F
/OmDUK7oEIFaoeND/?mEUK3oE9J`oe>F/OmCU[<00_mAU[<02?mCU[?oE9FaoeFE/?mGUJkoEiF/oeNE
[_mEUK3oE9Fa0_mCU[<03?mEUK7oDiJ`odfI/Om>VK3oF9>aoeZC/?mDUK7oD9Raoe6G/OmDUK7oFY>a
oeRC/@;oD9Ra00GoEIBcoeRC/OmGU;?oEIFaoeFD/`0:oeFE/@03oeBE/OmEUK7oEIFa00;oEIFa00?o
EIBcoeFE/OmEUK400_mEUK44oeFE/003oeBF/?mDUK7oDiJa00;oE9Fa0omEU;<01?mDUK7oDiJcoe6G
/OmAU[<3oe6G/@05oe>F/OmCU[3oE9J`oeFE/?mGU;000_mEUK401_mDUK?oEIBcoeBE/OmEU;?oE9Fa
oeFD/`CoEIFa1?mEUK03oeFE/@0BoeRC/OmHU;3oEIF`oe>F/?mDUK7oEIFaoeRC/omHUKCoDYRbodbG
[_mCVZcoFIBVofZ=Xoo<gO7odmWUofMWKoolo?oon_Wo0OmWIWH00008ofUVNOojnoooXjZlof9[M?oJ
f]Soc]cMoenBYOmBUk@2oe2G/`04oe2H/OmCU[7oE9FaoeND/0;oF9B`00CoE9J`oe6G/?m@V;7oD9Nc
0_m>V;D00om@Uk?oDINaoeBF/002oeFE[P03oeBF[_mCU[3oDINa00;oD9Ne01CoDiJcoe6G/Om<VK?o
CIVaoeND/omHTk7oDiJcodjH/om@Uk?oDiJcoeZB/omHTk?oD9NcodjH/omEU;GoF9>coeNC]OmGU;?o
Ei>eoeND/`CoEIBc1OmDUK<00omCU[?oE9FcoeBE/`02oeBE/`03oeFD]OmEU;?oEIBc00;oEIBc00Oo
EIFaoeBE/OmDUK7oE9Faoe>F/OmCU[?oDIJc00;oDiJc0omDUKD01?mCU[?oDiFeoe6F/omAU[D3oe2G
/`04oe6F/omCU[7oE9FaoeBE/@;oEIFa00OoE9Feoe>E]OmDUKGoDiJcoeBE]OmCU[?oE9Fe00CoE9Fc
1?mDUK42oeFE/@0CoeND/OmJTk3oF9B^oeFE[_mDUZkoE9J`oeFE/OmJT[?oFIBdoe:H/_m<UjkoDiZ^
oeVCYomZSJ?oc=gaom?IiOmWIfooo?cooo[io`01ofMVMP0001?oJFIgoo[koonSZ[coHV]dom[Jf?o=
gMgoGi:Woe:G]?m@Uk?oD9Raoe6G/OmCU[3oEIF`oeND/?mHU;3oEiB`oe>F/?mAUk7oDIJc00;oD9Nc
00WoD9Raoe6F/omAUk7oDiJ`oeBF/?mDUZkoDiN^oeBE/OmCU[<00_mAU[<02_mDUK?oDIJcodbI/om=
VK?oEiBcoeZB/omCU[?oCYRaodjH/omAUk42oeRC/`;oCYRc00CoEiBcoeRC/omEU;?oE9Fc0_mEU;<4
oeND/`;oEIBe00?oEIBcoeBE/omDUK400omDU[001OmCU[?oE9FeoeNC]OmGU;?oE9Fc00;oDiJc00Ko
E9FcoeND/OmEUK3oE9Faoe>F/OmDUK42oeFE/006oeND/?mHU;3oF9B`oeRD/?mGU;7oDiJa0omCU[<0
1?m@Uk?oD9Raoe>F/omDUK42oe>F/@04oeBE/OmDUK?oEIBcoeBE/`;oDIJe0_mDUKD07_mDUK?oDiFe
oe>E]OmCUKGoE9FeoeBE/omDUK7oE9J`oeBE/OmDUK?oEIFaoeND/OmHU;3oEiF^oeFE[_mDUZkoEIF`
oeND/OmHTk?oF9Fdoe:G]?m>UZkoDiZ^oeZCYomZSJ?obmgaom?IiOmWIfooo?cooo[io`7oIfIf0000
2_mZIWGoo?_ooj>Z^_mRJWGofM_JolgLgomQTJSoE9Jfoe>F/omCU[43oeBF/01YoeFE/?mEUK7oE9Fa
oe6D[_mBUK3oFibloe>D/_mAUJ[oCI6ToeNI/omCU;3oFIbiodjA[?mFV[7oD9B[oe6>[OmKU[KoEY:/
oeZF[_mGU;3oE9NbodZF[_m?VK;oG9FcoeZA/?mDUK7oCIR_odjJ/_mFW[KoC8NUoe^H]?mDW;CoC9B/
oeVB[omMU[?oEIRbodjF[_mFVK?oEYJaof2L^?mFSjgoFi6coeR@/omHT[OoFI>hoeVE]omDTk;oDI6Z
oeRI[Om;RY_oGIj`oe6G/?mEV;GoEhf_of:J^om;SZWoDYbeodnI]?mFVKCoG9Fbof6I]?mATJcoDI6Z
oeNAZOmNTZ[oHIF]oef?Y_mPSj7oIY>VofBAZ?mPTZWoF9J]odj@Z_mNUkGoFIBbodjF[omJX[[oDi2]
oe6>ZomFW;KoC9B]oe2E/_mCU;3oG9Rbodj>ZOm=V;GoBiJeoe:A/_mJUKGoEY>`oeBE/om>Uk[oCYBh
oe>C]omFUKKoD9:/oeVM]?mDUkCoDiFeoeFD/omEUK7oE9Faoe>F/?mDU[3oEIF`00;oF9>a00coEiBc
oeFF]?mAV;CoCYJ_oeJH[_mKTZOoJHfUolWNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoock
oonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/01ToeBE/omDUK7oF9^f
oe6B[_mBTK;oDi2]oeZGZOmOWJcoGi^coeJB[_mCT:goF9FaoeRFZomMVk;oHYZkoefB/_mLT:KoGY:W
of>K]?mETjcoFYbdod^;Y?mNTJkoHIBaoeRD[?mIVk7oBhnToeVK/OmQWKGoE8jVoe>DZ_mTX[WoF8^V
oeZ=Z?mFUZooCY:YoeBD[OmDT:SoF92YoeV?ZOmRV;CoGYFcoeVB/?mBSJgoDhj/oeVE/OmLUZkoHIZ^
oenGZ?mGT:7oCY2VoejL]OmHRJWoHiBdoe2BZ_m8TjSoEIfcodj>YomGRZGoEHNPofRR^?mCSJ7oJ9^`
ojWFjooJooooh?ooon;oooo>m?ooXlSKofNAYomLUJWoFIF]of2C/?mDRJSoCY2Xodb@YomPVKCoG9Fb
oeRK]Om8T:WoE9^goe:B[_mKTZOoI9faoe>K]?mCV[KoGIBcoeb?[?mHT:WoEI:^odZ>/OmQYL[oCXR]
oeV@[_mLVJkoC8^MoeJF/OmCT[7oEIBcoeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[Ko
DIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZj
of9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[00I?mDUK?oE9FaoeNH]?m?Sj_o
FiRgoebE/_mTUjSoJIZYoeB4V_mMSjSoGi6Zof:DZomOTZGoFHbQoef>[?mPSjgoGhjRofBCYOmCQYWo
IIR]ofJDZomNS:?oH8jUofbJ/OmKRj7oGi:WofJJ[om=Q9SoGIJYofBK[omCPiWoH8jUof>@YomUTjgo
F8VWofNL^omIS:OoFXjTofjS]OmLTJ7oE8bKoe^DYOmPVjgoEiBWoe^EZomOUJgoEXROoeb9X?mYTJ[o
HXnVof:I[OmFSJ;oIhbVofJ>Z?mKV:goCI2SoeZGZOmLTjOoJ9J^ofZG[_mIS9goGY:Pof>@XooPoooo
^Mk`ofZ>W_nJ^l[oh_ooomSkoomLQI_oHYB[ofBH/?mGQZ;oIYRcof>M]OmESjOoHYF`oeV?ZOmDTJgo
CI2[ofFXaOm?RjOoIi:Uoe^6UomHUJSoCX^Pof>AZOm[UJ_oI9>WoenFZ_mKV;CoBhRUofNH]_mWUJco
H96Pof>GY?mPTjSoFHnYoeRC/OmDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>
UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGo
fM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`06CoE9FcoeBE/Om=SJSoIZ>ooe>>[_mG
SJWofOooomkooomaUZSoa>[oon;oooncfNcoJHfMon?ooooOooooII6ZokGKk_oQoooogooool;Yn_oM
nOoojOooofbFY_o@noooi?ooofB7V_mSR9[odokoomSooonTeNCoJHbPomOcoooPoooof?koomcooomE
PIkoLinhoej;X?nOcMcoe?ooomSooooFoooo^NokoefEX_mOU:Co[mocomoooooSoooo`>3gonCooooG
ooooM::bokkJkooWoooobOgoof6L[?mHRIOoaO7nom3ioooPooooc?KoofjIX_mWTJ7oHXNGomOgoooW
ooooa^3]on_ooooYooooHH:EogFJ[OnmhoSog_ooomoooonii?OoKIR[ofB?X_oLoooofOoooenG/?m?
R:GoIiV`onOooooRooooGXjLofjO/?o6jogoeoSoon?oooo3lOooH9BYoeR<X_nG`=KobNkoon?ooooP
ooooe?WoojWFjomJTjkoE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH
[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=
g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/01ToeBE/omEUK7oG9VeoeVE/OmHU;3oG8jWonWo
ooo`ooooKXFCom7[n_o[ooood^Wiogf?WOo]oooogoooogJL[ooMoOoojOoooj?5c_o1gNSomoooooGo
oomXRYCohoooongooomjRi_oX[O8onOoooo7nOooGhjHom_]ooo]nOooa=k_oj[>g_oKooood__oofB:
WOnOa=Coh_ooomgooom/U9coZ]GLon3ooooCooooL9^[om3joooTooooZL[Kol;OkooUoooohOoooef1
SOobooookoooof6?WomOTj7od?OlonGoooo=l?ooX/GIonCooooFmocoJXjLomOhoooRoOooc>3YomOU
k_o]noook_ooogb@Voo8fnWok_ooolgUkoo2f^Col?ooolgSk_maS9GoiOooonCooom`UJSoHXbRofR=
WooVn?oolOooofZ?V?o9ko[oioooolcRkOnVaL[ohoooom;ooomZUJGofOWoon_ooonZa/Wo[LW<onCl
oooKo?ooG9:/oeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6W
ofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6A
Z?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[00;OmDUK?oEIFaodf9YOmFTZcoGYbeoeV9Woo`ooool_[o
ogf;U_obooooj_[oooGooomoPhkom_ooon;ooomRR9Goj_ooongooom_S9;oO92Gooklooogm_ooKHZ@
onCooooYn_ooalkNomOSlOoVo_oo[MgQofNBVOoZl_oonogoof^1SomcTIcoKHfLog6AX?mYRIKof?So
onKooonH_LKoH8RBofbFX_mRSY_oHXfMofB>WP02on?oo`0KogR?WOm`Q8ook_ooonKooomhUIgonOoo
ooGooomYT9ooGhfJonOooooTo?ooJXVMoemnTon0VIkoKHJ:ofR8UOoSooook_ooog>4S?n6U9gom?oo
oo3ooomfR9Com?ooon[koom_QXcoPIJK00;omOoo01SoLXV?on[ooooZooooKXnRof><X_m]SZ7om?oo
ooOooom/RHoohOoooo7ooomkS9?oKhV:ofB6R?mQRI?oIhfJofn9U_mcQHoo_];ComCXioobooooj?oo
oenA[?mDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGo
b=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJf
oeBE/omDU[3oEIF`oeFE[P;oE9J`03coE9FcoeFE/OmSWk_oCXZToeRH/OmUUJWol_ooooknoonl`l_o
m?koonWco?okoooo^kJmoocooooZooooLYNPokSCf_o]oooof_KiojVj`Ooon_oooocoogNCUooVoooo
mOoooo7doooanOooj_oooeV6ROm/UI_on?oooocmooo`ooooj?ooonkoooodooooNhfGonCooooVoooo
HhnLoejBX?mPVJ[oHI^_oe^BY_mRTZKo^]oaon_ooooDh^_o`/G<ooOnooo]ooooKHB:on_/lOoioooo
KY>Soen;U_o^ooool_ooonWooooUool2oo3oo`0OofN7U?oWooooi?[oogZ<U_mZOi3oj?ooonOooomd
TJ7ojOkoonkooomdU9ooJ8J@on[joooZo?ooIhNBon?ooooTooooHhRRoe^=Z?mZTjWomOooooWooom]
QXgoj_oooncmooodooooi_koonOooooRooooHhVDolWQk@02oo;oo`05onkno_oYm_ooaMc^oenA[?mD
UK<00_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooB
f^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?o
E9J`oeFE/?mEUJh2oeBF/01ToeBE/omEUK7oDXn[oebJ/omEUjgoGY6RooCoooojnOoocmCJooSooonj
`lSoo?ooomSBe_onoooojOooofJ<UOmeT9Oo]/kBol_Wj_oZoOoooogooocloomdT9Coh?ooooCoooob
n_oom_oool7IhomXUI[oIi2Foo;oooo^mOooN8nMofn:ToodoooojoKlogn@V?o[oooohOooofVGY_mH
Sj?oDi2Uoe2>YomLV;3oGY2WofV?X_nbc=Wof^O_ooCenOoio_ooj_ooog68S_onoooonOooof:7VOmX
U:7oj?kloo;ooom_SJGoKXjUonWmoooXooooK8fLon7oooo]ooooLXREog2:VooWoooog_ooofN;VooX
o_ookOooofR=U_m^T9WolOooonkooomaTioog?ooon;ooomWSjWoI9NdofB>Y_ocoooom_ooogNBVooQ
oooolOooogN:T?m`S8ooi_ooom[ooomTRi[oj_ooon_ooooZoOoob=[Logj<Uom^Qi_oGi6/oeBE/`;o
DINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMW
Koolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mE
UK3oEIF^0_mDU[00I?mDUK?oE9Faoe6A[?mFUZooDiZ^oeR@WooaoooonokoomoXkOo]n_ooOX^Aoo?j
oooRh>GonoooonKooom^Vj7odoCiol3MhOm[S97o[/_AooGoooo[moooMYBLon;oooo`oooo/lGConco
oooUooooWLcDof>?V?o@ioWokOoool7Ql?nkgNOokOooomC[lOmcS9?oi?ooon3ooomST:?oG8jWoejF
/OmFSjgoG9>aoej@ZooGoooo^][Yog>9U?nf`lWol_ooonCooom/Qi3onoooooGooomSS:3oIiJVom;/
kOoYo_oo_^3kol;VoooIm?godnocofV?X_o0jOgojOooolGOk?o@k?[oioooon?ooom^T9cobn7_onko
ooo5i^_oa>?Voo7ooooBhn[oL8nDon?ooooVooooZLkQoef;X_m/UJWolOoooo3ooom]Si_ob>kkon_o
ooo6g^[o`^?/omkooonjjo[oH8nQomoooooZooooLhbCoj[3b_o^ooooe_GooejA[_mDUK<2oe6G/@0@
oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?co
oo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE
[P;oE9J`05koE9FcoeBE/OmHV[CoE9R_odnG[Om@RI[okOooooOooooZnooogO7hofj2ROoTlo[onooo
ooCooooIooooFXZDok7HgooBmO_oh_ooomWooooRo?oo_mWVofN;UooTooooi_ooofb7V?nXamWohOoo
om[ooonKc=[oJhjQolo`oooRoooof_ooolG_nomRRYCoGHF?om_ooooQooooY<gQofbF[omLR:GoK9^i
oef<Z_mIR:CoV/KOol[coooTooooh_ooonCooon_en7oi_ooooOoooo/o?oog?oooe>8V_mZRi;odo3h
on3oooo>moooe_Soog2BVomMS:3oJ9J]olodoooJnooo^mo_on;ooooOooooFH>AogNFZ?o9jOSofooo
on?ooooAjO?oLXZDofV@UooKooooh?ooomcoooo@ooooHi6Xon[ooooUooooJ9>Tof2=X?o<kOooh?oo
on?oooo3lOooHIR]oeZ>Y_nVcnGog?go0_oVool01?oAl?oo[=7[oe^B/?mDUK<2oe6G/@0@oe>F/?mE
UK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7o
IfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`
01OoE9FcoeBE/Om>TJ_oCYF[oe:J/?mETZCoiooooo3ooooWoooo_=[TogJDWoo1g>OolOooonSooooL
ooooH9FUoej:UOmZUIkoI9BPof2@W_mYTj?oI8^Lof><WP02on3oo`1;offFZ?mWU:OoFHZKoenGY_mU
WJkoDh>Goen>X_mRTZSoGIBXoe2AXomIW:goJ:>coho2dooLooood??oog2<Y?nie>oofoSoomkooomZ
TK3oII>]ofFI/Om>Qi_oFYRWoe:@WOmDS9_oG8JFonkooooUo_ooDXRPofBQ]?mVT9coJ8fMofF@/_m^
W;goIY6RoeV7U?mOUZ_oH9J^of2?XomUU:SoGI6Woe28XOmJUZkoGYR`oenB[OmQUJgoDXbPof2GZomU
TZGoHi2SoefBY?mMUZ[oHIVbodb7YOmFUkOoB8BPofF;X?m[T:;oF8nToe^C[?mST:OoJI:Xoeb;WOmR
UZ_oEI:^oeZE/omHQj?oH8fTofVGYomOSIgoG8VPoef<Z?mJTk7oE9Fc00;oDINa013oDiJ`oeFE/?mJ
Tk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0
000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[005omD
UK?oDiJaoeZM]om@UZooBi>[oenM/_oLooooioooomkooonQb=WoIHnOojG<gOoVoooohoooom7ooomZ
XkOoE8FFofFFYOmKU:GoF96TofRL/OmFRIkoGHfS00;of_oo04_oEXROoeB;X?mNUj_oI:6dodJ3U_mW
XKOoEhnVoeZBZOmFU:_oCYRaod^G[om;SJGoGiR/oj7>hooSoooogOcoonOoooo=kOooKY6]oeb8YOmM
T:goAh>OoenQ^om?UjooEijdof>T]_mMT:?oZ/WNom_moomIUJooBhfUof>FYomTTjOoGXn`oeZ<[OmD
R9goH9VZoeJBZ_mJV;7oF92Wof2G[?mLV;3oFYZeoeRI]OmFUk?oB8RToeZJ]_mOWk[oDHnXoenI/OmC
Rj;oFI>YoefK/_m>RjOoE9FcoefR`omLWK_of_ooom_ooomEUJkoFibhoe^>ZOmSTJ_oGi>YoeVCZomB
U;CoDY:eoeV@[omXVkKoG9>WoeJ>WomVW[OoG9FboeND/OmDUK<00_mAUk404?mCU[3oEIF`oeZC/OmJ
Tk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000co
JVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/01ToeBE/omC
U[7oBhjXoeBJ/omBUkCoD8jWofNHYomMRIKoIYFWoeZ:X?mSUJkoGY2Woej>X_mLSjCoGIJcoe:=ZomL
TjSoHY^^oeBEZOmDUZcoEiF/oeZD[?mMUJkoFi>/oeR>Z_mWWk[oHinioe>AZ_m4QYkoDiF]oeZJ/omI
Uk3oF9J_oefM^Om;SJooG9k0oeNG/omQVk?oFhnToeN:VomMSYgoFXjLoenDY_mITZKoEY2Xof2M^OmM
V[WoDY6bodf<[omIV[SoBXjUoe:?Y?m_Uk7oHHfXoeNI/omAVK7oFiR]oeJ>YOmQUkWoF92aof2N]OmM
X;?oDYB^odV;YOmEUJkoFYN/oeNAYomHTZSoEI6YoefK]?mHV;?oC8bWoe^G/omJU[3oF9B/oe^EZomK
TZOoH9V]oeFAZOmHUZoo@h>Noe^I/_mOUZ_oE8jRodbF[om<U[7oDX^XofJI]_mVW[OoCX^Woe>I^omA
UK[oF9>eoeZC/?mFUJOoDiBVoe:D[_mDUK7oEIBcoeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC
]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?ol
noooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`0koeJI]?mE
V;?oDI:boeRE/OmNUjSoFi>RoejD[?mITZgoE8n]oeFB[_mETJWoHIfgoe:>/_mGTkOoGYNdoe:>Y_mD
V[?oC9B]oeBE/OmIVKGoEYJboeVF/omGT[3oBhJToe2=Z_mIV[KoDiVcoenU__m;S:SoDI>]oe6B[_m=
SZcoFIRkoeBC]_mASZgoFiNaoeRBY_mDTJ?oGIb[oebN[?mEV:WoDiN/oeJI/om@Tk3oCi2`oeVH^omG
TKKoEY:doeVO^OmDUZkoH96_oeR;Z_mDV[CoCYZbodbBZomGUk;oFI6boeZE]Om3RJ800_m>UZh08omK
XK[oC9:[oeBF[_mIUZ_oG9J/oe>=YOmASJWoGj:moe>F/omMV[OoDhn[of2P^OmDTZWoG9:ZoeJ<Y?mF
TZ[oGYbcoeNC[OmHU:koGYR/oe^N/Om?WkSoC9VeofBQ__m=PZ7oD8VToefM^Om<UKSoBi>ioebK__mH
UK;oDYFXoe:IZom<U:coEYfi00;oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;Co
CYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYe
omWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc06;oCY6/odj?[OmKV[goFYNf
oeVHZ_mEU:KoE96]oeFD]OmFU[[oEIZkoe>H]OmEUkOoC8^doe:@^OmKU[KoEiNcodbF/Om?V[OoD9:b
oeFF]_mDUkCoCY6^oeFB/OmUX/7oDY6`oeRK^?m;UK3oB9:[oeZK^OmCTjooFYfjoeRI]omFUKCoFYNf
oeRE/OmDTZ_oFYR_oeVL[omBUZ_oBY:XodZE[?m@W;CoDYbiod>:Z?mFV;SoFiZiodZ2XomPWK[oBiF^
odjF[omKU;;oHi^lodR@ZOmDXK_o@XfZoenT`omGT[;oG9Vhoe>M^?m7UJcoEInhodfH[om<UjkoDYRa
oeJF[omKUk7oEi:`oeFD]Om@Vk[o@Xf]oe>C]omIV;_oBi:`odfB[omUW[_oGIBboeFE/?mFV;;oFIJc
oeFB[_mGUJ[oAhjPodZN]_m7V;?oCXjZof^R`?mKU:ooE9B`oeFN`Om8T;KoDY:eoeBD/?m@UjWoEJ6a
oe2L/om9TjkoDiJcoeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:ko
GI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQ
of6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`0boe^L^_m>SjgoG9^nod^:ZomFV;3oEIV`
oe>F/omCUKOoDIFhodnE]omBVKOoBY6_oeRI`OmGU[ooD96aoeBG/_mBWK[oBI>`oe>D]?mPWl3oB8n]
odnF/_mLVkcoC8VXoe:A/_mFVKKoBYJ`odjH/omBTK3oDi2_oeVL^Om=T:_oE96^oeVE/OmFTjooFIN`
oeJF[om<T:OoE9ZcodfG/?m>V[CoAi:_oe:L^OmEW;[oCHn_oe>B/OmSW;[oD8fZoe2J/om@V[D2oeFB
/@0/odbD[Om>V[CoDYfjodR?[OmJUkKoD92/odjH/om=V[CoBiF^odfG/?mCWKKoC9B]oe6C[OmEUK3o
EY>boeNG^_m<UkOoD9ZmoeRI_om@TKOoDIblodfG]?mAT:ooEiBaodj?ZomHVkKoEIBcoe>C[omATJ[o
HZVood:DZ_m<W;?oFifgodf9YOmNVKOoDXj`od^?]?mJW/?oEIJfoe6C[OmBVjcoBYJVodVE[OmEW;X2
oeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?o
d][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9Fc
oeBF/?mEUK3oEIF^0_mDU[02oeBE/`;oEIBe00CoE9Bgoe>E]OmAU[?oDIJc0_mAU[D2oe>E]@;oDiJc
00KoDiFeoe6F]OmAUk7oD9RaodjH/OmAU[<2oeRC/`0=oe2G/om>V;7oEIBcoeRC/OmGU;?oE9FaodfI
/Om>V;7oF9>aoeZC/OmCU[7oDINaoeFE/@03oeND/004oeFE/?mDU[3oDiJaoe>F/@;oDIJc00KoDiJc
oe>E]OmDUKGoEIBeoeND/omEU;<2oe6F/`;oE9Fc0_mAUk401_mAU[?oDiJcoeFE/OmDUK7oDINaoe2H
/@?oDIJc00GoD9Raoe6G/OmCU[7oE9Fcoe>E]@02oe6F]`;oDiFh0_m>UkL06?m@UkGoDIJcoe6F/omC
U[?oE9FaoeFD/omGTkGoE9FeodjI/?m>VJcoDIR/oeBF/?mHTkGoFY6joeRA_?mETkSoDiJ`oe6HZ_m@
VJSoD9VZoe>F/omDU;OoEIBeoeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF
[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoI
fm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`;oEIBe00OoDiFeoe6F]Om@UkGo
D9Ncoe2G]OmAU[?oE9Fc00?oEIFa00_oE9Faoe6G/OmAUk3oD9R`oe2H/OmDUK7oFY>aoeRC/Om@V;7o
CYRaoeFE/@02oeRC/@0:oeFE/Om>V;7oD9RaoeRC/OmJTk7oE9Faoe6G/OmEUK3oEiB`oeND/@?oEIFa
0omDUK43oeBE/`;oEIBc00CoEIBeoeFD/omDUK?oE9Fc0_mEU;<4oeFE/@05oeND/OmEUK7oEIFaoeFE
/OmEU;<00_mDUK<3oe>F/@0PoeBE/OmEU;?oEiBcoeNC]OmEU;OoE9Bgoe>E]omAU[GoD9Neoe6F/omC
U[?oE9FaoeND/OmHTk?oF9:hoeFD]omCUjkoD9VZoe6HZ_mCUjkoF9:goeZA^_mJT;coF9:goe>G[?mA
VJSoD9ZWoe6HZ_mEU;?oEi>goeFD]OmDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H
]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mR
JWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`1?mDUK<01omCU[?oDIJcoe2G/om@
V;7oDIJcoe>F/OmEUK400_mGU;402OmGU;3oEIF`oeBF/?mDU[3oDiJ`oe6G/?mDU[3oFY>`oeRD/002
oe2H/004oeFE/?mHU;3oF9B`oeFE/0;oD9R`00GoF9B`oeZC/?mDU[3oDiJ`oeBF/004oeFE/0CoE9J`
0omDUK42oeFE/@04oeFD/omGU;7oF9>aoeRC/@CoFY>a0_mJTk000omKT[3oFY>`oeZC/@04oeZC/@;o
F9>a00?oF9B`oeZC/?mKT[400_mLTK<05OmKTKGoFY:eoeRC]OmGTkGoEIBeoeND/omHTk7oFY>`oebA
/?mKTK?oF9:goeFD]OmCUjkoDIRZoe>GZ_mDUZkoEi>eoeRB^?mHT[[oEi>eoeBF[002oe>HY`05oeBG
Z_mGU;7oF9>eoeND/omDUK<00_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH
[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=
g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc00CoE9Faoe>F/?mCU[3oDIN`0_m@V;00
1?mAUk7oDiJaoeFE/OmGU;43oeRD/007oeND/?mEUK3oE9J`oe6G/?mCU[3oF9B`oeND/002oe2H/004
oeBF/?mGU;3oEiB`oeBF/0;oD9R`00GoEiB`oeRD/?mCU[3oDIN`oe>F/003oeBF/0OoDiJ`00KoE9J`
oeBE/OmDU[3oE9FaoeFE/OmGU;45oeRC/@CoF9B`1OmHTk402_mGU;7oEiB`oeND/?mHU;3oFY>`oe^B
/OmKTK?oFY:coeRC/omGTkD2oeFD/`08oeFE/OmGU;3oF9B`oe^B/?mJTk7oEi>goeFD]OmDUZh2oe>G
ZP06oeBF[_mDUKGoEIBgoeFD]omEU;?oEIJ/0_mEUjL01OmGUJ[oF9>aoeRC]OmGU;?oE9Fc00;oDINa
013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKool
o?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3o
EIF^0_mDU[000omDUK?oE9FaoeBF/002oe>G[P07oe6H[_m@V:koD9R^oe6G/?mDU[3oEIF`oeRD/002
oeZC/004oeRC/OmGU;7oEIFaoeBE/@;oDINa00GoEIFaoeBE/Om>V;7oCYRaoe>F/@02oeBE/@06oe>F
/Om>V;7oCYRaoeBE/OmEUK7oDINa0om@V;49oe6G/005oe>G[_mCU[3oDiN^oe>F/?mAUk003omAUk40
1Om@V;7oCYV`odjI[_mAUk3oDiJ`00?oE9Fa00?oDiJaoe2G/om>V;400_m>V;401?m@V;3oDIN`oe>G
[_mDU[02oeBE]@0@oeFE[_mDUZcoE9J/oe>G[_mCU[?oDIJeoe>E]OmDUK7oEIJ/oeNFZ?mHUJSoFYBZ
oeZC/OmHTk?oEiBcoeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:ko
GI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQ
of6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[001_mDUK?oE9FaoeBF[_mDUZcoDiN/oe6H[0;oD9R^
01WoDIR^oe>G[_mEUK3oEiB`oeZC/?mJTk7oF9>aoeND/OmEUK7oE9Faoe>F/omCU[7oEIBcoeFE/OmA
U[?oDINaoeBE/omEUK7oEIBcoeBE/OmAU[?oDINaoeFD/omEUK7oDiJc00?oDINa00?oDiJaoe>F/?mC
U[400omCU[03oeBF/0CoE9J^00CoDiJ`oe2H/Om>V;7oD9Ra1Om>V;400om>V;?oCYRaodjH/@03odjH
/@06oe2H/Om>V;7oCIV`odfI/?m@V;3oDIN`0omCU[400omAUk7oCYRaodfI/@02odfI/@0FodjI/?m@
V;3oDIN`oe>F/OmCUKGoE9FeoeFE/?mEUJkoE9J^oe>F/?m@Uk?oCYRcoe2G/omAUk7oEIJ/oeREZ_mJ
U:[oFi>/oeZC/OmHTk?oEiBcoeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF
[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoI
fm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[001_mDUK?oE9FaoeFE/?mEUJkoDiN^oe6H
[P;oD9R`00?oDIN`oe>F/?mEUK400_mGU;400omGU;?oEIBcoeBE/`02oe>F/`0?oeNC]OmHTk?oFi6e
oeZB/omHTkGoEiBcoeZB]OmJT[?oFY:eoeZB/omGTkGoEiBcoe^A]OmKTK?oF9>e00CoF9>c00?oF9>a
oeZB/omJTk400_mJTk401?mKT[7oFi:`oe^B/?mKT[03oeZC/005oeRD/?mEUK7oDiJaoeBE/OmCU[40
1?mCU[<01?mCUKGoDiJcoe>F/omCU[<2oe>F/@07oeBE/OmCU[7oD9Raoe2H/OmCU[7oE9FaoeFE/@02
oeND/@03oeFE/OmCU[7oDINa00;oD9Ra00CoDINaoe>F/OmDUK7oE9Fa0_mCUKD01OmDUK?oEIFaoeBF
/?mAUk7oCYRc00;oCIVc00WoD9RaoeBF/?mGUJkoFY>^oe^B/?mJTk7oF9>coeND/omDUK<00_mAUk40
4?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/00<oeBE/omEUK7oEiB`oeND/?mDU[3oDiJ`oe6G/?m@V;3oDINaoe>F/OmDUK7oEIFa0_mE
U;<01omDUK?oDIJcoe2G]OmAU[GoEIBeoeRC]OmJT[D00_mHTkD00omGTkGoF9>eoeRC]@08oeRC]@Co
F9>c0_mJT[<5oe^B/@;oFY>`0omHU;001_mGU;7oEIFaoeFE/OmEUK7oEIBcoeBE/`CoE9Fe0_mDUK<4
oeFE/@;oDiJa00?oE9FaoeND/OmHTk400_mHTk400omGU;7oEIFaoeBE/@02oe>F/@;oE9Fa00WoEIFa
oeFD/omDUKGoDiFeoeBE]OmDUK?oDiJcoe6G/Om>V;400_m=VK401?m>V;7oDiJaoeFE/OmHTk42oeRC
/`03oeND/omEU;?oE9Fc00;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:ko
GI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQ
of6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[001_mDUK?oEIBcoeRC/OmHTk7oEIFaoeBE/@;oDINa
0_mAU[<03?mDUkCoE9Fcodj?[OmBUK;oD9FboeBN^Om9UJooCYZdodjE/OmCV;GoD9FboeFJ]`;oDIJc
04coE9Vfoe6F/om?U;7oCY>`oeRK^?m@UK;oEIZgodnF/_m<TJkoDiReoe6F/omCV;GoDIBaoeJI]_mF
UkGoCi2^oeBC/_mGU[GoEYFdoeBD/?mATZkoFY^god^>ZOmGWKOoCiF_oeJI]?mHV;?oFiRdoeRE/_m9
RJGoEiJeoebK^_m@TK7oE9FeoeJG]omAT[;oFYVhoeFD/omASZ_oEI:_of2M^Om@T:coD9>^oeBI]_mF
UkGoG9Vhoe2;ZOmGT:koGIJdoe>>[?mHUK;oE9Faoe>F/OmDUk;oEIJdoeBE/omEU;?oEYFdoeFD/omC
U;CoCXn_oe6B/?mHVkSoDYRbodjF[om@Vk;oC9N^oe6I/_mCV;GoEINgoeJE]_m?S[7oDi:eoe>B/omE
U;?oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSN
looBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mD
UK?oE9J`oeFE/?mEUJh2oeBF/007oeBE/omEU;?oF9>coeRC/omGTkGoE9Fcoe>F/`02oe6F/`0Ooe>F
/omDUK?oCHjZoefN^_mIV[KoDINaodfE[_m;UjooCIVaoeFO^?m9TjcoBiN_oe6M]Om?Uk3oC9:/oeJP
^Om8U:coEZ2ioe:L]Om:T:[oB92YodjJ/_m<V;3oD9ZcodnG/?mDW;GoBi>/odnG/?m@U[3oDINaoeRK
]P02oe:E/00RoeFH/omBUK3oEYbfodnG/?mFX;WoAI6Yoe2L]?m:TZ[oDi>/odZ6X?mNVkOoI:6moeJF
/_m<SJWoEYNeoeFF]?mCU;;oDI:`oeBC/_mFU[;oEiB`oebI]OmDT:[oFYZcoe>I/om?Uk3oCi2/oe:B
[_mNVKOoG9Fboe:;Z?mQWKWoEiB`oeBF/0;oDiJ`01KoDiJaoeBE/OmDUK7oEIFaoebG]OmBSjcoG9^j
oeJG]Om@Tk3oCI2[oe2BZ_mHV[;oEiVaodjAZom>Tk3oBXn`oe2D]omHV[goE9Bgoe^J^omEU;?oE9Fc
0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^Go
IfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`
oeFE/?mEUJh2oeBF/007oeBE/omEU;?oF9>eoeRC]OmGTkOoE9Feoe>E]@02oe>F/`16oeBE/OmJV[Ko
DXn[oejJ]_m?S:SoC8bUoeFG[omBVJgoCYFYoe2DZOm?UZ[oDIb_od^FZOmNX[OoEiV_odR?XomBWK3o
D9V/od^BY_m=SjGoFIfboe2K[_m6TJCoD9N[oe6EZ_mFWK?oBi:XoeFL/_mKWkKoBXjUoeJH/?mTY/3o
BXbVoe:D[_mIW;KoAH^Toe>K/om:UJcoC9R_odbJ/?mEX;GoG9faoenL/OmHUZgoChfToeFE[_m?TJ_o
EiRdoe2C[_mCU[7oEYVcoe:D[_mDU:goF9J]oe^I/?m<RIkoEIJZoe>K/Om3SZGoIJS2oeJH/?mFU:go
E92ZoebH/?m>S:?oEiR^oeBF[?mCUjkoDiZ`oe>I/P;oDiJ`01?oFIN`oe^AZomQUk7oDHbZodb<Z?mN
Wk_oDi6ZoenG[_mHSjCoFi:WoeJBZ_mMX;goDibloe2I_?mDV[koBXZ]oeVH^OmEU;?oE9Fc00;oDINa
013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKool
o?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3o
EIF^0_mDU[001OmDUK?oEIBcoeNC]OmGTkOoEIBg00;oE9Fe01;oE9FcoeFE/OmGU;3oFY>^oefE[_mO
Tj_oEh^Sof:I[_mTWK3oDHbNoeVDY_mQUJ[oFY6UoeVFZ?mIU:KoD8>HofZJ/?mNUJT2oe^FZ008oeZA
YOm^W[CoG8nToe2;WOmOW:koHIR/oeb@YOmMUZX2oejGZ`0ZoeV@YOmNUJ[oFXjToe:6W_mWVk?oF8jV
oenG/?mOVK7oCH^RoefM]_mDUZkoDiN^oe:CYomGSj3oFhjOoejBYomPUj_oH9J^oeF=Y?mQVk?oFiF]
oejH/?mMUjooE8bSoebEZOmSUjgoF8fOofZM/?mKTjCoGIb^oeJI[?m?S:7oFiF[oe26W_mXW;;oIIN^
of2DZOmJTJGoGIRZoe^HZomEU:KoEY>X0_mKV:d04omJTJKoIiB[oeZ7W_mPV;7oFiVboejJ]?mKTJWo
KiV_ofB:WOmTSJ7oH9:Yod^<Z?m9U;?oBiNiodbG]om>SjooFiRgoeFD/omDUK<00_mAUk404?mCU[3o
EIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1
ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF
/0;oE9Fc0_mEU;D0BomDUKGoE9FcoeBE/OmEUK3oF9B^oe^CZ_mOTJSoeoooomoooomdWK7o[MKXomco
oonnjOWoKiJUon[ooooQn_ooMiRYol3OlOo^ooooj_coom3YoOoYooooi_ooofZ3UooYnoook_ooofZ9
Vom/SIkodN[nongooonU`MOoLi:WolCSn?oWoooojOooom_goomgTZgoKXVTof^9XonYbnKof_koon3o
oooLoooo_N_ooffM]?mHQI[oJHbOolg]o?oOoooofOcoolS[oom]TJOoHhVPon3ooooJooooKI>ZofN;
XOoPooooi_ooof^<WOnjfN_ohooool_hoomMSJ7oKiV_okgVn_oSooooh_ooomShoomRQIWoJi2Somoo
oooLooooII:UofNAY`02omcoo`0CofZ@YOnie^Soi?ooolgooomHTJGoO;?8om3moooOo?ook_ooomOa
oonigoCoFYJ`odjI]_m?X;koC9VgoeNG/omCS:WoEiBaoeBE/`02oe6G/@0@oe>F/?mEUK3oFY>aoeZC
/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZ
IWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<0H_mC
UKGoDiJcoe>F/omCU[7oE9J`oeFF[?mJU:[oGY:Wof2=X_oRooooi_ooofR5UOoJm_ooj_ooomCboOm[
Phool_ooooGooom/PXooiOSoonkeooo7c=ooe>7aon?eoooaooooNHJFooWnooo]m?ooPYFSojFkb?od
ooook?Oooh:EY_oFkOgokOoool;Gj_ncaMWoi_SoonCioombR9oo//SOon;loooImOooJ8ROok7EkOoP
oooocoWoog6FZOo;iOCol?ooolSNk?o@ioOojooook[Ej?mmVJkoi_ooon?ooom`S:7oKHRKon_oooo]
ooooLXRFon_nooo[ooooK92PofV@XOo<koooi_ooolkYo?nX`]?okOooonCnoom^RI[oioooonKooomX
S9coJ8^NonCooooVooooKHZLonkooooZooooH8jKof6FY?oHooooh_oookg=g?n`]lOomOooomScoomF
SZGoBI>/odVJ]Om6TjgoHIfgoeZBZomHTk7oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF
]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonS
Z[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/01ToeBE/omCU[?oDIJcoe2G
/om@V;7oDIN`oe>G[?mGUJ[oFiBWof6BXomWSYooioooonWooomhRiWok?gooo?oooo^ooooQ9:Koo7n
ooobooooKh^?ongoooogooooO8B?ogB7S_o^ooook?ooofj1R?ohoooomooookG>doo:i^[ol_oookG8
comWPXWohOooonWooomiUj7oI82;ognKYomYQi;oJh^HomShoooTooooWLCEofB?WomWUZKoIYZXof2E
XomIQiCoh?goonoooomaR8koL8V@onOooooXooooMI:PonCooooWooooM96Oofn;Uoo[ooooj_ooogJ=
Too`ooookOooofJ:U_mgWj_oe_[oon?ooomaRi[oKXFCogF<V_mZQI3oL8bGonWooooWooooK8jHofZ>
V_oTooooi_ooog6;V?oeooool_ooof::T_mVV:7oI9:Oof:2SOo9cm_oin7]ookmoooUn?ooIib^oeBO
]?m;WKGoAI>ZoeZDZ_mMTJWoF9B`oeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRd
odjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9Z
MOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[009OmDUK?oDiJcoe6F]Om@Uk?oD9Ra
oe2H/?mCUjcoEIJXoe^DYOmRTJ7oI8RHon_oooo`oooo]/;>ooOooooYm?[olokookO2a_ogooook_oo
ogFDU_nif=[oloooonGco?nY`/Ooj_ooon_ooomgRhconOooooOooooOnocoioooonOkoomcQhkoLi:G
onGooooSool00_oWool08OoSooooiOooog2BW?oOooooh_ooofRCXomPSiooGI:RoeVCXOmJUJGoI9FS
onWoooo^ooooM8^AogjGW?oVooooj?ooog2<V?oZoooojOooogF@Vom`R9;ok_ooon[noomoTYKojogo
onkooom/SYSoHXZDonCooooWooooj_ooonSoo`02on_oo`05og2;U_oZoooojOooofb=U_m[SIL00_oV
ool04om`RiComOooooCooom`TISoI8nFokOMi_oZooool_[ooocnooo`m_ooc>;`oeZ=X?m>TZOoCYZa
oe:M/_mITjWoGYB/oeRD/?mDUK<00_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_
oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWK
f_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/00WoeBE/omDUKGoE9BgoeBD]omAU[GoD9Ra
oe2H[_mCUj[oFYFWof:AXom]SYookOooooCoooo@f^Komooook_8c_odooooc=[KooWooooaooooK8nA
ofJ;TOnfbMSoh?7oomCdoooVooooj?ooogb>S_onoooonoooon?ooooVooooa=cXofn5TomaSISohOoo
onSooomaSiWoKH^E00;oi_oo03_oJh^FonCooooRooooIi:Uof>AZ?mJSZCoGYJ_oe^D[omOTZOohOoo
onkooomfSIGoJ82:onWooooVooooJhFBon_oooo]ooooM8ZGogJ:UOo^oooom?ooog=nQ?ohooool_oo
og:BWOmSRiOof_koonKooom/S9_oM96Oon[ooooVooooKHNDon_ooooRo_ooMY:NofV7TOoVoooojOoo
og>>Uoo_oooom?ooogR?UOm^Ri7og__oon[ooooLmooo_]SUofV6U_mcVZ_oEHRKoejH[?mCU:[oD9:X
oeZH[omKUk7oEiBaoeBE/`02oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^
oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgL
hOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`06CoE9FcoeBE]OmGTkOoEIBgoe6F]Om@Uk?oCYV`
oe6H[?mHUJSoHI:SofV<WooZoooom?ooomSTl_o_o?ooQ9>Jon?fn_oJk>konOooooCooomYT9God_go
olCMlomXOYKoZLkNon3ooooRooooLhR;oo?dnOoio_oo/=;ComkooooYoooo[<OLog6@X_o5i_Goiooo
okgMk?nmgN[oiooool[ZmomWR9Ooh?ooomKmoomUT:?oHi6XofBF[omMTjooDXVWof6C[?nkgngoj_oo
olKRkOo:j??ojOoool3Pkom]RY[ojOooon[oooo1fn[o_M?PonWmooo`ooooPHjFooGoooo/ooooIHJE
ofnIZOo6kOkoh_oookgPlonngo3oh?ooolCTlom_S9cohoooonWooonnfnWo]=CQonOooooFm_ooKH^E
onkooooXo?ooMhjDog^DVooMnOooioooofN;VOnPb]SogOoookg]oomYWK;oFiBXoeZG[?mKVK3oF9Ra
odn?Z_mEUK7oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOo
J8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6X
oeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/00PoeBE/omDUKGoEi>goeFD]omAU[GoD9RaodjI/?mAV:co
EiJXoenBYOmXSJ3oj_ooonooooo[noooh?3mof]oR?oJloSok?oooo?ooooUo?ooI9>Koj?Dh_o9jOoo
ioooomgoooo@oooo]moWogFBV?ogoooomOooofJ=U?nPcmT2omkoo`03oiJldomUSZ;ocO?o00;oh_oo
01oob^oooeUnS_mbUjOoc_Goon3ooonOb]goHY6UoeV;X_mTV;3oGYB^of>E[?mfX;3o_N?`omkooooO
oooo^N3aog>L[_mZT:?ofOooon;ooonmh_Coe?GoonWooonkeN;okOooonGkoooZooooh?oooe:1UOmU
U:Soc?Wo00;ogooo01Ooc?;oofjCY_mTRIcohoooon3ooonoi?Cog_ooom?joonniOCohoooonWooooZ
oooohoooofZ:UOnXb]KocoGoon3ooooMooooaoOooic@i_mHT:OoDhnWoeZH/@02oeJH/P03oe6B[_mE
U;?oE9Fc00;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8
g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[Ko
E9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`1<oeNC]OmEU;GoDIJcoe2H/Om>VK3oDIR^oeFFZ_mLTjSo
HH^QonKooooZooookOoookoFi_m`S9SoanSaonWoooo]oooojOoooeR<VOmTW:goKiJcofbC/?mMTJOo
FY:SoeV9UOm`UIkoj_coonkooomWUJ;oHiRVoeb6W_m]U[;oJ9NcofbN]omHQj7oI9:YofJCZ?mPSJ3o
M9nboef8VOnOb]_og_ooolgjoomOSZ;oZm_aomOoooo1loooGY2Woef>WomUU:CoHY>TofRIZ_mWVZgo
FhjSoeZ<XomUV:goH92Vof2?XomUTZGoHhbNog6FZ?mXS9[oi_ooomgooomPT:CoIIbaof>G[omDR9ko
FH^Rof>CZOmTTZ[oGX^RofNDZomRSjCoG8VNofJCYP;oH8fP01;oJ9NYoef;VooJooooh_ooog2EYOm^
UJCoHXfMofVGYomRTZKoFHbQoenFZomPV:ooDXjXoeVI/_mJW;KoCY6/oe2C/?mCU[<2oeBE/`;oDINa
013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKool
o?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3o
EIF^0_mDU[02oeBE/`0JoeND/omEU;?oDIJcoe2H/Om>VK3oD9R^oeBF[?mJU:[oI9B[omOooooVoooo
i?oooibmd?m[T:;oZ=;PomcooooQooooh?oooefHZ_m@SZGoFhb/oe:0X_mTX;coFiV`oeZCY?mWUJD2
onKoo`12oebAXom@SJ3oHYFboeV:ZomKTkCoDHbZodn8Y_mNU[7oGYB^oeZ<YOmSTjWoHi:Voej=XOnV
eNOoaOCoom_ooooJoooobOcoofNJ[omHS:7oF96UoejH[?mHUJ[oDXnToe:@YomDTZWoGiffoe>AZ_m?
RjGoIIngoenG[_mHS:;oGI2UofFDY_nTdNCodOooof2J/_m>S:GoDXjZoejJ]?mJTjkoG9B]of2F/_mM
TjgoEhfWoebBZ_mJT:SoGIBYof2G[?mGSZ?oFY6Vof6EZ_nUeNWod_oooeV8W?mTU:SoG8nToe^?YOmJ
TZWoFiF]oeB@Z_mLV[?oEiNcoe>D/?mEV;GoCY>`0_mAU[D2oeBE/`;oDINa013oDiJ`oeFE/?mJTk7o
FY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<
ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`;o
EIBc02[oDINaoe2H/Om>VK3oD9R`oe>G[_mGUJcoGY:Zof^I/omSSJKoIXjWoffG[omLRIkoHY:VofBD
Z?m/UZcoEHFLoeJH[_mHVkKoHiVmoenE^Om=SZcoCi:/oejL/omHSjCoK9:Yof>;Y?m?S:7oEiVaoeR@
/OmRV[goFYVloe>C]_mJVK[oG9VhoeNC[omITZgoFHnYoe^?YOmNTJKoHiJ[ofRK[_mHRih2oeb?Y00b
oeB8WOmUW[;oF9J]oeRJ/_mDUk7oEIRboeNM]omBV;;oE9VfodnE[omEV;?oDYB^oeJF[omETj[oG9J^
oejF[OmES:7oF9:Xoe:B[OmDUk;oEYNeoefN^_mFU[;oE9B`oe6>ZomFTZkoFiNcof:N^_mKUk7oCh^U
oefI/omJU[3oEi>]oeNCZomSVk;oG9FYoe>;X_mRV[7oEHnWof:N]_mJU[3oF9FaoeBD[omGV;CoE9Nd
odV<ZOmAU[GoDiRgoe>J^_mAU[D2oeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRd
odjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9Z
MOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`0doeFE/OmDUK7oDiJaoe2H
/Om>V;7oD9R`oe>F/?mEUJkoF96/oeR>Z_mJS:OoG8^Wof6C[_mHSZKoFY:YoenG[_mOTJ[oFI6ZoefS
_?m>UK7oCXZ^oe:>/_mIW[ooDIRdoe2C[OmFTZ[oHi:/oenAZ_mKWKGoEifgoe2?/?m@S[?oDI>fodfA
]?m@T[CoE9Feoe>B/OmGU;3oH9VdoenI/OmMUJcoE8bSoeZCYomITZKoG9FYoejGZomHTJGoF9FZoeFH
/_m:TZ_oBI6Zoe6I/P;oCiVd02[oBYBaodnI]_mEW;[oBHj[oeRK]_mJW;KoDI6/oeZH/OmOWKCoDY:[
odfC[OmIX;coC96`odbA[_mBUK;oFIbiodnB[omKW;[oCi2^odj?ZomGV;CoCi2/oeRJ]?mGVK?oF9Zd
oe:B[Om?SjSoChfVofRV_om;RJ;oEIF^oeNG/_m<S:OoEYNcoe6B[_mCU[?oFYfjoe6D/OmHWKcoD9Fd
odnD/om@T[82oeBE/`;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6W
ofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6A
Z?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`04oeFE/OmDUK7oDiJaoe6G/@;oD9Ra053oDIN`
oeBF/?mDTJgoHIZgoeR?[OmQV;KoEHj[of2L^?mFTjooDi2/oeR?[OmLV;CoC9B]odNA[_mNWL3oEIBg
odfD]?m?VKKoEI^eoe>C[_mNU;3oGiNbodf@Zom?U[;oFYZmoeBD^?mFV;_oDYJioeBI^_mEUkOoDY>a
oeFE/OmHUK7oDHnXoeRD[_mGTjgoG9R`oeVG[_m?SJCoFiV`oebJ/OmBTZ_oEYbfodbC[om?U[;oDifh
odZD/OmBW;WoBY>coe2J]om?U[CoDiZhoeBI]_m?TZooEiRdoeBF/?m?Sj[oFYbfodfB[omCV[SoDIRf
oeFL^_m:SjkoEY^joe:G]_m>Tk3oF9^hodjA[_mIW;WoDIBaoe>F/Om=T:_oE9Nboe>F/OmCUJooFifg
odf?ZOmDU[3oEiVcoe>E[`;oDiB`00SoEiZeoe2C[_mEV;GoC8n/oeNJ]om>TJkoD9>`oeJI]P;oE9Fc
0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^Go
IfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`
oeFE/?mEUJh2oeBF/0;oE9Fc00?oEIFaoeBF/?mCU[401?mAUk400omCU[7oE9FaoeFE/@02oeND/@08
oeFD/omDUK?oDiJcoeBE/omHTk7oEiBaoe6F/om@Uk<2oeBE]@0>oe2G]Om>V;GoDINaoeBF/?mJTk3o
F9B`oe>F/OmAU[?oE9FeoeFD]OmDUKGoDiFeoe>F/omDUK<2oeBE/@05oeFE/OmEUK3oE9J`oeBF/?mD
UK401OmCU[42oe6G/@04oe6F/om@Uk?oD9Ncoe2G/`;oD9Ne00SoDIJeoe6F/omCU[?oDiJcoeBE/OmD
U[3oEIF`oeBF/0WoDIJc0omAUk44oe>F/@KoDiJ`1?mDU[06oeBE/@06oeFD/omDUK?oDINaoe6G/OmC
U[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[i
o`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;o
E9J`0_mDUK<00omEUK7oE9J`oeBE/@02oe>F/@;oDINa00?oDiJaoe>F/omDUK<00_mDUK<2oe>E]@04
oe6F]OmCU[?oEiBcoeFE/@;oDIJc0_mDUK<02OmAU[?oD9Ncoe6G/OmCU[7oEiB`oeND/OmCU[7oDiJc
oeBE/`02oeFD/`03oeBE/OmEUK7oE9Fa00?oE9Fa0_mCU[42oe6F/`;oD9Ne0_m>V;D00om@UkGoDiJa
oeBE/@02oe>F/@CoDiJc00?oE9FcoeBE/OmDUK<00_mDUK400omEUK7oEIF`oeFE/002oe>F/@05oe>F
/omAUk7oDIJcoe6G/OmAU[<01OmAUk44oe>F/@KoDiJ`1?mDU[06oeFE/006oeFE/OmDUK?oDINaoe6G
/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?co
oo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE
[P;oE9J`0_mDUK<5oeBE/@03oe>F/OmCU[?oDiJc00;oDiJc0_mCUKD3oe6F]@09oe>F/omEU;?oEIFa
oeBE/OmCU[7oEIFaoeBE/OmCU[7oDINa00;oDiJa0_mEUK42oeBE/@05oeFE/OmGU;3oEiB`oeFE/?mG
U;000_mEUK001_mDU[3oE9Faoe>F/OmCU[?oDIJcoe2G]@;oCYNg0_m=V;L00om>V;GoE9FaoeFE/002
oeFE/0GoEIFa00CoEIF`oeFE/OmEUK3oEIF`0_mGU;02oeFE/006oeBF/?mDUK7oDiJ`oe>F/OmCU[3o
DiJa1OmCU[0:oeBF/0;oEIF`0_mEUJh5oeNE[P03oeND/?mEUK7oE9Fc00;oDINa013oDiJ`oeFE/?mJ
Tk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0
000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE
/`KoE9Fa00?oE9Fcoe>F/omCU[<00omAU[<01OmAU[GoDIJcoe>E]OmCU[?oEIBc00;oEIFa0omEUK00
1?mDU[3oDiJ`oe>F/OmCU[43oeBE/@03oeFE/OmGU;3oEiB`00?oEiF^0_mEUK000omDU[3oDiJaoe>F
/@02oe6F/`07oe2G]Om>UkOoCYNgodjG]om=V;OoD9NeoeBE/@0>oeND/004oeFE/?mGU;3oEIF`oeFE
/0;oE9J`1omCU[02oeBF/0?oEIF`1OmDU[03oeFE/003oeFE[_mGU;3oEiF^00?oEiF^00?oEiB`oeFE
/OmDUK<00_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSN
looBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mD
UK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc00?oDiJaoeBE/OmDUK401?mEUK400omDUK7oDiJaoe>F/@02
oe6G/@03oe>F/omCU[7oE9Fc00;oE9Fc0_mEUK42oeFE/00<oeFE[_mEUK3oE9J`oe>F/OmCU[?oDIJc
oe>F/omDUK7oEIFaoeND/?mGUJkoEiB`0_mEUK02oeFE/@04oeBE/OmCU[?oDiJcoe>F/`;oDIJc1?m@
Uk<00omAUk7oEIFaoeND/008oeND/0CoEIF`0_mEUK43oeND/@03oeFE/OmDUK7oE9Fa00CoDiJa0_mD
UK42oeFE/@03oeND/OmEUK7oEIFa00SoEIFa00?oEIF`oeFE/OmEUK001?mEUK001_mEUK7oE9Fcoe6G
/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_
ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE
/?mEUJh2oeBF/0;oE9Fc0_mCU[42oeFE/@?oEiBa00?oEIFaoeBE/OmCU[400omCU[400omDU[3oEIFa
oeFE/@02oeBE/`0<oeND/OmGU;3oEIF^oeFE[_mEUK3oE9Faoe>F/omAU[?oD9Ncoe6F/omDUK?oEiBa
0_mGU;001OmEUK7oE9FaoeBE/OmDUK7oE9Fc00CoDiJc0omCU[43oe>F/008oeBF/?mEUK3oEIF`oeND
/?mEUK3oEiB`oeFE/?mGU;04oeFE/0;oE9J`0omDUK400omGU;7oF9>aoeND/@02oeFE/@03oeBE/OmC
U[7oDiJa00;oDiJa0_mDUK403omEU;?oEIFaoeND/omGU;7oEIBcoeFE/OmEU;?oEIFaoeFD/omEUK7o
EIBcoeFE/OmEU;?oE9FaoeFD/`05oeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mG
TkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCo
o?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<2oe>F/`;o
EIBc0omGU;400omEUK7oE9J`oe>F/002oe>F/004oeBF/?mEUJkoEiB`oeFE/0;oE9Fe00ooEiBaoeND
/?mEUJkoE9J^oeFE/?mDUK7oDiJcoe6F]Om>V;GoD9NeoeBE/omGU;7oEiB`oeFE/OmDUK<00_mCUKD0
0omCU[?oDiFeoe>F/`02oe>F/`04oeBE/OmDU[3oEIF`oeFE[P;oEiF/00WoEiFZoeNE[?mEUK3oE9Fa
oeFE/OmDUK7oEIF`oeBF/?mEUK000omDU[000omDUK7oDiJaoe>F/@02oe6F/`04oe>F/omGU;?oF9>c
oeND/`;oEIBc00?oE9Fcoe>F/omCU[<00omCU[<04?mDUK?oEIBeoeFD/omGTkGoEiBcoeFD]OmEU;?o
E9FeoeBE/omDUKGoE9FcoeBE]OmDUK?oE9Feoe>F/omDUKD5oe>F/`;oE9Fc0_mAUk404?mCU[3oEIF`
oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMV
MP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;o
E9Fc00CoDiJcoeBE/omDUK?oEIBc0omGU;401?mEUK7oE9J`oeBF/?mCU[02oeBF/003oeFE[_mGU;3o
EIF`00;oE9Fc00KoEiBcoeND/OmHU;3oEiB`oe>F/OmAU[<2oe>E]@07oe2G]om@UkGoDiJcoeFE/OmH
U;3oEiBaoeBE]@02oe6F]@03oe>F/omDUK7oE9Fa00;oDiJc0_mEUK02oeFE/@06oeRD[_mJU:coFYB/
oeRD[_mDUK7oDiJa0_mDU[001_mEUK7oE9Faoe>F/?mCU[3oDIN`oe>F/@;oE9Fc00KoDiJaoe6G/OmA
U[?oDIJcoeFD/omGU;<2oeBE/`?oEIBc00GoE9Fcoe>F/omCU[?oDiFeoeBE]@02oeFD]@0BoeBE]OmD
UK?oEIBeoeFD/omDUKGoE9FcoeBE]OmDUK?oE9FeoeBE/omCUKGoDiJcoe>E]OmCU[?oDiFeoe6F/omC
UKGoDiJc0_mDUK<2oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomX
SZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSo
EIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<4oeBE/@?oEIFa1_mDUK40DOmDU[3oEIFaoeFE/OmJ
UkCoDY:^of2P_?mAS:[oFXb_oejF]om?V[OoAiNboe6A]?mOVkooB8f/odfG]?mEWk[oCI2[of2I]_mJ
TK3oE9>bod^=[OmFV;SoEiRdoeF?YomITj_oGj2nod^<[?mETJgoEi>_oe^M`?m>T;?oFIBboejG]?mG
T:goEiBaodnA/OmGW;WoCY2Xoe>C[_mKUkWoDI2coeNM]om;UZgoDIbcod^AZomKUk_oDHb^oeFC[?mG
VK7oE9ZdodfB/OmEU[CoCi2^oe2J]om=UkCoEYFfoe^C]_mITKCoFYFgoeZL_?m8SJcoFY^ioeBC/_mH
UkKoDiBbodfD/?mAVK;oFIbioe>D/?mDUK?oEiRdoe:C/OmATZkoEIJdoeNH]?mDUK?oE9FaoeBE/omD
UK7oE9Fcoe>F/@02oeBE/`06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H
]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mR
JWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<@oeBE/@0koe2B[?mFV;;o
DYF`oe^H]OmQTkKoDh^/odjN^Om9WKOoDI:boeF@/_mGV[OoBYB_odRF[Om?V[7oEI6]oebC/OmFU[;o
HjK1od^@[OmATjgoHib`odn9WOmBUK;oFYfjof>O^OmBSj_oCiFiodVB]OmEU;?oCh^WoefJ]omBTk7o
EYfkodF<Z?mMWkGoFYRaodn;[omASkCoDi^dodjK[om;V:coDIVboenN`OmMV;[oF9B/oe>DZ?mBV;;o
DiZfoeNH]_mBUK3oA9B]odVF/?mNWKcoE8Z/oe>9ZomKU[KoB8fZoeZQ_Om@TJl00_mGUk<01_mEV;?o
C9J_oe:M]?m=T:_oCHjZoe6B[P;oEIJb00?oF9VeoeJG/om>Sj/02?mDUK401_mEU;?oE9Fcoe6G/OmA
Uk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/0;oE9Fc3omDUK40BOmCU[7oCiN`oe6K]?m9TjcoDiJaoe^D/_mCT:goB9R_odZL/_mDUk7o
D92[oe^N^?mBWKCoAIN/oe>Q]OmGUk3oF9B^odjAZom2RZ;oCYRaoeVP]?mJV:OoFIRWoe6I/Om;UJko
CY2VoeNI[om7T[7oE:6ooefP^_mDUJ_oDYB/oe2F[om>V[CoAI6Yoe^N/OmHUZgoFibloe>H^Om;UZgo
CIb]odZIZ_m9U:WoCY2`oeZI^?mETjSoCHjPodfH[omAVkCoCY2Zoe^N^?mCY;Wo@iBYoe2A[OmIU;;o
IJ2noe2@[?mEWkSoCYV`oe6D[_mDU[3oEYRbodjEZom<UjcoCIR]oejQ^omMW[[oFY^goe:C[om<SJWo
E9FaoeVJ]_mCU;002?mDUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mA
V;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[o
HVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK40BOmCU[7oE9jg
odbH/?mAVK;oCi6[oe^C[_mWX;_oBi:VoeFN/OmBT:GoGiV_oeF?YOmGV:coC9V[odZEZ?mESjOoEhfW
oe^I/?mIVk7oGIneodb=WomCRiSoG9BQoe6CZOmBUZgoEY>Uof:O/_mDVKKoB8n[odn=Y?mESj?oFiR[
oeJGZom=TjcoDIF/oeV@Y?mMTJOoE8n]odZ9Z?mMWkGoD9FUoefR/_mEV:_oChn[of:K^?mOTjSoG9BU
oeRJ/?m=SjOoII^eoe>=Xom@W:coDijaoeR>Z?mIR:CoHINcoe:@Yom<TjWoCiJZoebD[OmLTZcoEI>Z
oeZK[omJV:goF9V_od^=Yom>Sj_oEYNcoeNH]?mBTjooDiB`oeJG/omBTjl02?mDUK401_mEU;?oE9Fc
oe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^Go
IfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`
oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK40BOmCU[7oB8jXoeNJ]OmLV;CoH9Jbof>AZomLRZ;oFhjSoeN<
W_mWUZSoI8nRof:8WomQSZ?oE9>Tof6P/_mPS:OoLIJcofRF[OmCQY_oGI2Uof:AXomcVJKoJI6MofFE
ZomRU:_oK9NXof2=X?mKTJgoGYB`ofbI/?m[UZWoI96Toej>X_mQUjooHYB[ofF8W?m/S:?oJiNdof>D
/_mKRj7oHY>Toef>WomVUZcoI9Fcof2<ZOmRPYWoIXVMofFG[_mQTJSoIhFQoff?Z?mCTZ7oEiBVogBB
[_meS:_oI8VToenCZ?mNVjkoH9N[ofN6X_mgUK7oFh^Qof>HZ_mPRIooHXnVofFN^OmBTjooD96]oeNH
]?mFUk?oDiB`oeBE/OmCU;002?mDUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>e
oeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoock
oonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc4?mDUK40:OmN
Wk_oDhn[oeR9YooLoooohoooog:BYonmg_7oi_oookgNkOm`SIgok_ooon[ooomJRi[oYm[]onKooooI
l_oo_n;fon;ooooPooooKiBTomKboOoYooooIXbOofV?X_o=k_gog?ooojgIl_mPS:GobnkoomKgoooT
ooooe_gooen>X?mIPYCok_ooon_ooomWRjGoe_ooon;ooomYSYkoIHZL00;ogOoo01WoJHfWohRM/_oO
m_oogooookKOloo`ooook_oooen@W_mQTZ3obn7ioo7ooooLnoooeooooeB9VOnPcmooj?ooom_aoomZ
Sj;oFH2AonWooooNooooSLGNofFV`_m@TJgoDY>_00;oE9Fa0_mEU[88oeBE/@06oeFD/omDUK?oDINa
oe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfoo
o?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`
oeFE[P;oE9J`0_mDUK<?oeBE/@0SoeFE/Om=RJGoJIbiofZ?[?oVooooj?ooog25V?oVm_ook?coom__
n?mfQi7omo[oonScoombV:Goh?ooon_ooonhb>;ocnclomgooooSooooJhfFongoooo[ooooIh^GoiNm
b_oYooooh_ooofB=Woo2kOkoi_ooom3^n?nM_LSohoooom;ooom]UJ400_oaool09?mNPiGogoooon?o
oomYRiGoL9:Non?ooooKooooL9FXol_Lk?o_oooo^>;`olC^o?oWoOoolOooofn?V_noi>gojOoookSC
i?nddN7ofOgoomKooomKRiGoa^kjonOoooo:i??oa=_YonSoooo?m?ooJ:2goe6B[_m>Sj_oEYNcoeVJ
]_mGV;CoEIJboe2A[@SoE9Fa00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[Ko
DIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZj
of9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`ooE9Fa04?oEIF`oeRD
[_mLT:SoIXZTon[oooo]ooooLhFAonoiooohooool_ooog^6R_oooOoonOooofN9T_oNoooolOooogZ6
W?m]Q9;ojOooonKooom]RY3olOooongooonedmgoaNK_ongooon_b]7oJHnLon7ooooVooooLhnCoff:
T?maU9[oHi2Fof^@V?oaoooolOgoog2AX?oPoooofogoogNEWOmWQHgoi?ooomWooomWS9col_oooo7o
oom[TIcoIhnIon_oooodooooK8>;on[ooooSooooJX^Dofj:U_maTIcoIY6HofBCVOmST9Kog_ooonWk
ooocooooi_oooiRnbOmGSjKoDY>_00;oF9Ve00CoD96]odn@[?mFUk?oFIZf2?mDUK401_mEU;?oE9Fc
oe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^Go
IfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`
oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK404_mDU[3oE9F[oe^DZ?mTSJ7oi_ooonSooonab<komOooomk/
kOo`oooo_<[:ooknoooco?ooKIFGok[Uk?oUo?oog^knok;6d@;ok?oo027oNI6EooCooooboooojooo
onOooooOl_KoPIJKofN7T_oVooookOooon[oooo]ooooj_ooon?ooom]SY?on?oooo;koom[RICohOoo
onWooom^RXkoKHZ@on?ooooRooooLI>Ooo3moooeooooKI:KofZ?UoobooookoSoog^<Too^ool00_oU
ool03oo[ooooi_ooon;ooomWTYSoJY>Gol;Qi_oaoooomoooolkSj?mZSiSoGYFZoeFF/_mBTjooD96]
oe>D/002oeRI]@WoE9Fa00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRd
odjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9Z
MOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`ooE9Fa01OoE9J`oeBEZOmM
V:[oJ9>TonCooooXoooo`MWMoo;ooonnc/gol_oookg=c?okoooom?oooen8R_m`WJ;o/loMom[[nooW
nOoolOooonWmoomkS9?ok_KhooSoo`02onkoo`0Zol[Ig_meQXgoK8RDon;noooVn_ooN8Z>ohFHWooW
oooogooooff:T?ofoOoonOooogF?W?oUooooi?ooog29S_meSYGojOooon?ooomWQ9;omooooo;loomV
R9;oKXnHooOooooen_ooLhR;om[cmoo`ooooL8B=og67U?oYoooog?ooof::T_mXQY3ok_oooo;ooooU
locok_ooog:@VomCRYooE9Fa0_mLWKT01?mCU;3oCHjZodj?ZomCU;08oeBE/@06oeFD/omDUK?oDINa
oe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfoo
o?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`
oeFE[P;oE9J`0_mDUK<?oeBE/@15oeFE/?mFU:WoG9BUof>>WooOooookOooomocn_oQm?SoOY2Bon[l
o?oZn?_okoKnonkooom]UY[ob_OmokWDiOmeR9Wo[[k=ooCooooZn_ooQI>Noo_oooogo_oo[;c;oo3o
ooogoooo[[c7ogRBXooEk_oolOooom7Oj?o0d=gojooool;Pjon1VJGol?OoooKjoomgS9gojOooongo
ooo?j>oo/l_EonSooooGm_ooLhbPomOPkooeooooa^KcolkZn?obm?ooo?ooogNFVOo6incomOcoomKI
k?o3f>Woi_oooko[m_m^U:7ocMc_ooGooonmf>?of_Gnoo;oooo8gnooIi^coeFF/_m?T:coDY>_00;o
EYNc00?oEiRdoeZK]omDUK401omDUK401_mEU;?oE9Fcoe6G/OmAUk7oDiJ`oeFE/0;oFY>a00coEi>e
oeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoock
oonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/0;oE9Fc3omDUK408omE
UK3oE8jTof2DZOmWTZGoi_ooongooooYnooocnK^ogB8SooLkOGok_coooGoooo^ooooK9NNoic;eOoG
m_ookOooonOnoooXoooo_]SYofn6U?oWmOkojocoogfGZ?nZaMKoiO_oongooonSa]coHXJLolWTmOo]
oooojoooolk[nomXSY_oGh6=00;ol_oo02CoJ8>HonCooooVoooo]MOQom_moooMooooaNWoogFE[?md
RI[of_7oom[ooonkg_7omOooooCooomLRHcoJiRNom?RmOoeooooiOoookgXnOmGS9[oZ=OWoncooooQ
mOooL9JSof28T_oHm?ooioooohVofOmUY/;oCHjZodb=ZOmDUK7oEIJbodn@[?m;S:P8oeBE/@06oeFD
/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kc
om;JiOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE
/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<?oeBE/@19oeND/?mRV[?oGi6Xoe^5WOoSooookooooo7oooo2
g^coMi>Ool_Lk?obooool?ooon?ooomIQiKoGHbLoff=Y?mYQiooIXnSofNFZ?mSTjOoH8jMonCooooS
ooooFHZKoef@XomUTj;oH92Noe::XOmQVk7oHIBUoej>W?mLSIcoH9>Tof:JZOmNTj7oh_ooon?ooomO
S:?oGY6VoeF:V_mTWZWoH9ZVodf6UomDRZCoJ9Zcoen:Vom[VZ[oD8ZNoebEZ?oSoooofoooof>NY?mJ
UZ3oIY6TofbBZOmXUZkoEhnVoeNJ[OmFUj_oHI>Zoen=Y?mISZ3oH9RWofBHY_mOUjSoFYRaodj?Zom<
SJWoDiB`oeRI]OmGV;CoF9VeoefN^P08oeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJTk40
3?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf00003?mZ
IWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<?oeBE
/@0aoeFE/?mFTZcoFi>ZofJH/OoPoooojoooonCloonI_m;oF86Cok;=h_oXo_oogokoomoooomWWk3o
GiR[oef7X?m]U[;oEXbToebI[_m<RZ7oGIN[om[ooooGooooF9J[oeRJ/?mDSj7oG9V/oeZR^olnQJ7o
HZ>goe6@XOmJVJ_oFY^_oe2CY_mEU:God_ooom7ooomOUJooEXnZoeVJ[?m:SikoFIj^oeRL/OmNVk[o
DhbZoeN@Y?mJUj[oD9J_oeNI/@02omWoo`0Coe>EXOm;SYkoDh^Rof^N^om<Pj7oG9bhoe6H]?m;UJko
E9FaoefK]?mGUJcoDY2Uoe6DYOm>TJCoE9J`oeBE/OmGV;CoFIZfoeBE/@02odf>ZP03oe:C[omDUK7o
E9Fa00KoE9Fa00KoEIBcoeBE/omAUk7oDINaoe>F/?mEUK02oeZC/@0<oeNC]OmDU[KoDIRdodjF[omG
V:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[o
cMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/a3oE9Fa04GoCi:/oe:F[Om;SJGoIinh
ofV<Z_mURZGoGiV]of6L[_mVT:SoKI:/oej@YomASZ?oC9>Woe2G[OmPW;KoE8fZoenL^OmDU;3oFIZh
oeBD[omHSj?oF96UodnB[OmAU[?oEYB]oeBF/?m?Vk_oCi^modZ@Z_mHV[;oE9Naodb?ZOmNX;[oDY2Y
of6J[_mQUjooG96coebD]om?TJ_oEIjaodZBZ?m6S:KoEi>hoe^E^omJU[;oDi>/oe6H]_m>T;3oG9:/
oeN>XomGVZgoH:Biof6J]om>PjGoH9Jloe>A]_m@U[[oE9fnodf?/_mHUkSoFIRgoe>D/?mNY;goCiF^
oe:E/?mATZkoD96]oe6B[_mDUK400omGV;@8oeBE/@06oeFD/omDUK?oDINaoe6G/OmCU[3oEIF`0_mJ
Tk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7oIfIf0000
3?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`0_mDUK<9
oeBE/@1BoeBF/?mEUK7oE9J`oeFE/OmDU[3oEIFaoeBF/?mBV;7oE9bboe:J/_m:RZ?oHiF`oe^=Z?mH
W:ooCI6ToeJ<Y?mRUZkoDi6XoeFL/?m;V:coCYZaoe2C[OmGV;CoD96]oe:C/Om?TZooEiRdoebI[_mE
Tj[oEibiodjE/OmDUk7oDIB_odZF]_m9UKGoFZ6moe:E[om:T:[oFj6kodb?[?mMWKWoEY:/oe><ZOmL
T[KoG9Jkodb=ZomCVK?oDIVboeZO__mBSKGoF9Bioe2@[?mIV[KoCIBdoe>E]omITZooGYNbodj@Z?m@
TjgoFiJfoebB]_mLTk[oEY6ioe2D^OmEVkooDI6eoeBC]_mLVkcoCi2^odZ=Z_mJX;[oDIB_oe>F/?mE
U[;oE9J`oeBE/OmEU[;oDiB`odn@[?mDUK7oDiJaoeBE/@CoDiJa00?oE9FaoeFD/omDUK<00_mAUk40
4?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/0;oE9Fc0_mCU[<4oeBE/@?oEIF`00_oEIF^oeND/?mEUJkoEiB`oeFE[_mGU;3oEIF^oe>G
[_mAV:coDIR^oeBF[002oeNE[00:oe>G[?mAV:coEIJ/oeFF[?mCUjcoDIR/oe2I[?m@V:koDIR^oe>G
[P;oE9J^00CoDiN^oe>G[?mDUj[oDiNZ0_m@V:h2oe6H[0;oD9R`00GoDIR^oe>G[?mCUjcoDiN^oe>F
/`02oeBE/`04oeFD/omEU;GoEIBeoeBE/`?oDiJc00SoEIBeoeFD/omDUK7oE9Faoe>F/omDUK?oEiBc
oeND/@;oEIFa00CoEiBcoeRC/omHTk?oF9>e0_mEU;D4oeND/`06oeFD/omDUK7oDiJ`oe6H[_mCU[3o
DiN^1OmCU[000omAUk3oDiJaoe6G/@03oe6G/@03oe>F/OmDUK?oE9Fc00;oDINa013oDiJ`oeFE/?mJ
Tk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0
000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE
/`;oDiJc1?mDUK42oeFE/0OoEiF^00?oEIF`oeBF/?mDU[001?mDU[09oe>F/003oe>G[_mEUJkoEIF^
00;oE9J^0_mCUjh4oe6H[P;oDiN^0_mDUZh01omEUJkoEIF`oeBE/omCU[?oE9Feoe>F/omDUKD01?mD
UK<7oeBE/@;oE9Fc0omEU;<00omEUK7oEiBaoeND/@06oeND/@04oeFE/OmDUK7oDiJ`oe6H[PCoDiN^
1?mCU[000omCU[7oDINaoe6G/@02oe6G/@03oe>F/OmDUK?oE9Fc00;oDINa013oDiJ`oeFE/?mJTk7o
FY>aoeNC]OmDU[KoDIRdodjF[omGV:koGI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<
ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQof6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[02oeBE/`Ko
E9Fa2OmEUK000omEUK7oEi>eoeNC]@02oeNC]@coEIBe00CoF9>eoeRC/omGU;?oEiBc0_mEU;<4oeBE
/`;oEIBc0_mGU;<01omHTk?oEiBcoeFD/omDUK7oEIBcoeBE/OmEU;<01?mEUK46oeFE/003oeBE/OmC
U[7oDINa00;oDINa00?oDiJaoe>F/?mCU[002omCU[04oeBF/0GoE9Fa1?mCU[400omDUK7oEIBcoeBE
/`02oe6G/@0@oe>F/?mEUK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;J
iOmWIfooo?cooo[io`7oIfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omD
U[3oEIF`oeFE[P;oE9J`0_mDUK<6oeBE/@?oEIF`00CoE9J`oeFE/OmDU[3oEIFa0_mDUK400omDUK?o
EIBgoeNC^002oeNC^0coEI>h0omGTkL3oeFD]`CoE9Bg0_mEU;L2oeNC]`06oeRB]omGTkGoEiBaoeFE
/?mEUK7oEIF`1?mEUK47oeFE/003oeBF/?mAUk7oD9Ra00;oDINa2omAUk001OmCU[3oE9J`oeBF/?mD
UK7oE9J`00;oE9Fa1OmEUK400omDUK7oEIFaoeBE/@02oeFE/@06oeFD/omDUK?oDINaoe6G/OmCU[3o
EIF`0_mJTk403?mGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7o
IfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`
0_mDUK<9oeBE/@04oe>F/OmDUK?oDiJaoeBE/`?oDiJc4?mCUKL3oeBD]`;oDiFg1omAU[L2oe>E]`06
oeBD]omEU;GoEIFaoeNE[_mEUK3oEIF^2?mEUK04oeBF/003oe>F/?mAUk3oDiJ`00_oDIN`0_mCU[00
1OmDUK7oEIFaoeFD/omEUK7oEIBc00?oEIFa0omGU;401omEUK7oEiBaoeFE/OmGU;7oEIFaoeFD/omD
UK<00_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooB
f^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?o
E9J`oeFE/?mEUJh2oeBF/0;oE9Fc1omDUK400omCU[7oDiJcoe>F/`06oe>F/`;oDIJc01ooDIJeoe6F
/omAU[GoDIJcoe6F]OmAU[?oDIJeoe6F/omCUKGoDIJcoe>E]OmAU[?oDiFeoe>F/omCUKGoDiJcoe6F
]OmAU[?oDIJeoe2G/omAU[GoD9Ncoe6F]Om@Uk?oDIJeoe6F/omAU[GoDIJcoe>E]OmDUK?oEIF`00Co
EIF^00[oE9J^oeFE/?mDU[3oEIF`oeBF/?mEUK3oE9J`oeBE/OmDU[3oE9Fa1OmDU[04oe>F/008oe>F
/OmCU[3oDiJaoe>F/?mCU[7oDiJ`oeBF/?mDUK46oeFD/`?oEIFa1omGU;401_mEU;?oE9Fcoe6G/OmA
Uk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/0;oE9Fc00CoEIFaoeFE/?mEUK3oEIF`0_mDUK42oe>F/`04oe>E]OmAU[GoDIJeoe6F]@?o
DiJc01ooDiJaoe>F/?mCUjkoDiJ`oe>G[_mCU[3oDiN^oe>F/?mCUjkoDiJ`oe>G[_mDU[3oDiN^oeBF
/?mCUjkoE9J`oe>G[_mCU[3oDiN^oe>F/?mCUjkoDiJ`oe6H[_mCU[3oDIR^oe>F/?mAV:koDiJ`oe>G
[_mCU[3oDiN^00;oDiJ`1OmDU[003OmCU[3oE9Faoe>F/OmDUK7oDiJaoeBE/OmCU[7oDiJcoe>F/OmC
U[?oE9FaoeND/?mHU;001?mGU;42oeFE/@05oeFD/omEUK7oEIBcoeFE/OmGU;<00omGU;401?mEU;?o
EIBeoeBE]OmDUKD4oeBE/`03oeBE/OmEUK7oEIFa00?oEIFa00CoEiB`oeND/OmEU;?oE9Fc0_mAUk40
4?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/003oeBE/omDUK7oEIF`00?oEIF`00CoE9Faoe>F/OmCU[?oDiJc0omAU[D01_mAU[?oDiJc
oe>F/omCU[?oE9FaoeBF[PKoE9J/1OmEUZ`00omGUJcoEIJ/oeNE[002oeFF[00=oeBF[?mDUZkoE9J/
oeBF[_mDUZcoEIF^oeBF[?mEUJkoE9J/oeFE[_mDUZcoE9J^oeBF[002oeBF[P03oeBF/?mCU[3oDiJa
00GoDiJa1_mCU[<01OmAU[?oDiJcoeND/OmHU;3oF9>a00;oEiBa00OoEiBcoeFD/omEU;?oEIBeoeFD
/omEU;GoEIBc00CoEiBc00GoEIBcoeBE]OmDUKGoE9FeoeBE/`03oe>F/`;oDiJa0omDUK401OmEUK7o
EIF`oeFE/OmEU;?oE9Fc00;oDINa013oDiJ`oeFE/?mJTk7oFY>aoeNC]OmDU[KoDIRdodjF[omGV:ko
GI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000<ofYVM?olnoooXjZjof9ZMOoIfm[ocMcQ
of6AZ?mEU[KoE9FcoeBF/?mEUK3oEIF^0_mDU[001?mDUK?oE9FaoeFE/?mGUJh2oeFE/00LoeBE/OmC
U[?oDiFeoe6F]OmBUkKoC96`oeJI]_mEV;GoEIJdodn@[?mIV[KoChnZoeFC[?mJU[3oDhnYoeNC[OmL
V;;oFiNaoe:>Z?mKU:ooGYNboe:;Y_mKU:ooDhbWof>K]_mHTJcoFY:]oefF/@;oFYJ`017oCh^WoefI
/omKUk?oFiNaoeB=Z_mJU[3oG9Fboe6=YomTWK[oEI6[oeFA[OmGTjgoGIVeoe:B[Om=T:_oE9ZdodfB
[`02oe6F/`07oe>H]Om<TJkoEibioe2E]?mAU[GoDiRgodnD/`02oe6F]@0JodbA/?mCUKGoG9bhoeBA
[Om?S:WoFi^goe2?[_m=SZcoFifmodj@/?mGVK_oCY2`oe:D]_mEUkOoDI:boejO_OmBTK3oDi:aoeJG
]Om>SjgoFIZhoebO_?m;SZ_oCI:_oeZP^_m>U:h2oe6G/@?oDiJa0omDUK401_mEU;?oE9Fcoe6G/OmA
Uk7oDiJ`oeFE/0;oFY>a00coEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_oocl
ooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mE
UJh2oeBF/008oeBE/omDUK7oEiB`oeNE[_mEUK3oE9J`oeBE/omCU[<2oe6F]@08oe>H]om=TZooDiJc
oe:C[omATZkoDi>^oeVI]?mHUZl2oeJC[`0;oe>@[?mNVkOoF9Faoe^H]?mETJgoF9B`oe2<Z?mMVKGo
HIZgoeVB[omMU[<00_mHTJh02OmKU;7oEiBaoeZG]?mMV[OoFYNdoe>>[?m>RJOoH9^ioebG]@02oeNB
/00^oeJA[omHTk7oHYnloeFB[om=RZOoFYZfoeBI]_mEW;SoD9NcodjE/Om=U;;oE9Vhoe2E]?m9SZgo
EINgodjA[_mATk?oDiJcoeBF]_mHV[[oEINgoe:C/Om;RjKoGIffoe:B[OmCU;3oFYfhoe6F/omAU[Go
E9^iodnF]_mMY<;oDiZjodbC/Om@UKCoBHj[oeJI]_mFVKCoCi2/oeVJ]_m:RjOoEYVdoeZM^_m<TZco
Di^dodbD[@?oD9Ra0_mAUk43oe>F/@;oE9Fc0_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mA
V;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[o
HVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/008oeBE/omDUK7oEiB`oeNE[_mE
UK3oE9J`oeBE/omCU[<2oe6F]@0:oe:E/_mAU;7oEIJdoeJG/omFU[7oFiVboeFAZOmDTZ_oDiJcoe:I
]`;oCY>b02SoA8VXoe>H]omGVKWoDiFeoeRJ^_mJW;coAhRXoeBE]Om?SZooD8n`of>R`om>SjooDIJg
od^B/_m>TkCoCiBeodjC]?mMX/?oA8JXoe>E]omATkGoG9k0odZ?/?m4RJ[oD9FfoeNL_OmEW;coEYfk
odjE/om8SjgoD9FboeJK^?mAU[?oCI2]oeFH]OmKW[_oF9VgoeJG/omHVKOoEYNc0_m>SJ`06_mGU;?o
EIFaoeNI[omGVjkoEYZ_oeBK/Om<U:coA8jWodnI]?m;Uk7oBiRdodJC[Om7TZooDYjhodZD[OmFXKSo
CYJ^od^AZ_mHV;?oGIZfodZ7XomKVkKoEYVdodnE[_m;Tj_oEIfe0om>V;42oe2H/@;oDINa00?oDiJa
oeBE/omDUK<00_mAUk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jU
olSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF
]_mDUK?oE9J`oeFE/?mEUJh2oeBF/01LoeBE/omDUK7oEiB`oeNE[_mEUK3oE9J`oeBE/omCU[?oDIJe
oe6F/omJWK[oEYNcoe2A[Om@T:_oDY2YoeZF[_mHTZSoF9J]oe6G/Om;UK3oCYReoeJM^OmIX;koDIRd
odnD/omBUkCoCI:aodnD/OmLW[koD9>`oebM_OmKW;[o@86QoenQ`Om;T[3oDYbioe6J^_mCV[SoBi:b
oe^R`?mCV;WoCiBcodnD]Om@UKCoEIbloeVP__mCV[[o@hfZodjG]om8TZooDiZhoeJK^?mEV;GoBhjY
oeBE/OmIV[KoEYNcodZ:Y_mBSj_oFIFaoeB@[?mFTZcoG9FboeVB[OmMUK3oGIN_oeNDYom@Sj3oDiBV
oeBGZ_mHW;7oEYfcoeZR^_m;UJkoDiffodjH/OmCWKKoCYJ^oeRP]_m7SZ;oEYfaoe^M/omJUZkoD8ZR
ofjW`_m:R:7oEIF^odnAZomIWkSoC9B/oe2H/Om>V;43oe2H/@;oDINa00?oDiJaoeBE/omDUK<00_mA
Uk404?mCU[3oEIF`oeZC/OmJTk7oEi>eoeBF]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_
ooclooojnOl1ofMVMP0000coJVIdoockoonSZ[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE
/?mEUJh2oeBF/007oeBE/omDUK7oEiB`oeNE[_mEUK3oE9J`oeBE/`03oe>F/`1Boe2A[omBTjooDY:]
oe^I/_mPV[3oGYN[of:I[OmHTZKoDiF[oe:J/?m@V;3oAXfSoe2F[om@UjgoE9NaoeBH[omIVkGoC8jV
odj@Z_mCUJgoE9B_oe2@ZOmJV[GoD9:/oeRN]om?Ujoo@XZSoeJL]OmFVKCo?h:LofJYa?m<SjWoF9^f
odf@Z_mAU:ooCI2ZoeVO^OmBV[;oGJFnodnG/?m@TjkoDiB`oeFE/OmJV[GoG9Veoe:?ZomDT:[oIYnj
oebD[OmUVkGoEXZRoe^?YOm/W[OoI9J]oef=Y?mHR9coao_oomWooonZgngoDh^JoeRCYOmFTjKoChfR
oeJG[Om8RIooHjBjod^<X_mFU:WoHZ2eoe:?X_mJUJOoFI:Uoe^?YOmFR:7oGI>]oenG/?mNV;3oF9J_
oe>E[OmBUZgoDIN`oe2H/0;oDINa00KoDIJcoe>F/omCU[?oE9FcoeFD/omDUK<2oe6G/@0@oe>F/?mE
UK3oFY>aoeZC/OmGTkGoE9Jfoe6H]?m>UZooEiR^oefAYomXSZGob=kcom;JiOmWIfooo?cooo[io`7o
IfIf00003?mZIWCoo?_ooj>Z^_mRJWGofM_JolgLhOmQTJSoEIJfoeBE/omDU[3oEIF`oeFE[P;oE9J`
00KoE9FcoeBE/OmEUK3oEIF^oeFE/?mDUK44oe>F/`1@oeBE/OmHV;?oEiF^oeZF[_mFSj?oAgjBofRM
[omHSIooGiR[oeZEYomLUjWoIJ2boeN@XomLUJSoH9N[of:I[OmSUjcoHYJ[oe^?Y?mQUJ[oGi:Wof6D
ZOmPTjSoFHfRoe2:W_mOW:ooGIN[oenI[OmKTZOoHYV^odZ1U_mUW;7oF8nToeV@YOmWW[?oDhbPoeF>
X_mFT:CoEY>Voe:?Y?mGUJcoEI>/oeFAZomMVK?oD8ZRoe^C[?mKTJWoFHfUoeb>YOmVUZcoGHbPof:?
Y?mQSZ?oGXVLof^FZOm[UJGoKI>PomgooooPooooJiNTof6?Wom/VjgoI9BXoejAY_mXW;;oCh>HoffP
]OmNTJCoEhNKofVHZ_mVU:CoI96Tof>@YombX;SoGHfToefAZOmHSZKoFiF]oebJ/Om>T:P2oe>F/0;o
DiJa00?oDiJcoeBE/omDUK<00_mEU;<01OmDUK?oDINaoe6G/OmCU[3oEIF`00;oFY>a00coEi>eoeBF
]_mAV;CoCYJ_oeNH[_mMTJOoJ8jUolSNlooBf^GoIfM_ooclooojnOl1ofMVMP0000coJVIdoockoonS
Z[[oHVYeomWKf_o=g>7oHI6XoeFF]_mDUK?oE9J`oeFE/?mEUJh2oeBF/006oeBE/omDUK7oEIF`oeFE
/?mEUK7oE9Fa1?mCU[<05?mEU[;oEiNboe>?YomJU:[oHiZ^ofbQ/ooIoooogOooof:9V?o6j_Soi?oo
okgNkOmeUZGoi_ooom[joomWQiKo^=GUon7noooZoooobNCe0_o[ool08om/QYOojOooon;ooom^U:7o
Ih^IolO[nOoWoooo/];Qog2=WOo?k?coiOooonWooooDm?ooM9FTof62TOoToooohoooof>>W_mIT:Go
Gi^coe^EZomGSjKoHYV^omSooooIooooIYJ/ofBCYomFPiKoLij_ol3Zn_oRoooohooool3UmOmYRISo
MhnK00;okOoo01OoIh6@ogF@XonjfNgohOooonCooooHo?ooH8BJog2CZOm^TJGobncoonCooooVoooo
fOSoojO;hOmIPI[o^>;jom_oooo?ooooEhfUoeJ@Z?mGUJcoEIF^oeBF/002oeBE/@03oeBE/omEU;?o
EIBc00;oEIBc00GoE9Fcoe6G/OmAUk7oDiJ`oeFE/002oeZC/@0<oeNC]OmDU[KoDIRdodjF[omGV:ko
GI6WofR>YOo8g_?od][UofMWKoolo?oon_Wo0OmWIWH0000:ofaVL_olo?ooXj^hof9[M?oIfmSocMcO
of6AYomEU[CoE9FaoeBF/0?oE9J^00KoDiJ`oe>F/OmDUK7oEiBaoeFE/OmCU[42oe6G/@1Joe>F/OmD
UK?oEIBcoe>B/OmIVKGoEIF`oeNEZ_mJTjKoFhbKon;ooooWooooMY6JomKZmOoboooohoGoofInR?o[
ooool?ooogZ<V_o_oooolOooojc2coo?h_3omOooonohoon5TZ;ojogoonoooomgRiCoYKO1oo7ooooT
o?ooLHNBom;RlOoboooob>3/ojk6d_oaooooh_CoogN?VooWoooojOooofj;VOmWUJGoFHjPoe^CX_mV
VjgoE8NLomcooooOooooGHRIoef<W_m]V:Wo_=WYon[ooonkgngo^]k/on[oooo<h^ooLhNBoo7oooo/
ooooPIBSol_PlOo]ooooaMo`ojc5fOoVoooog_Woofj9W?o9i?Ooj_ooolWTmOnW`]?oioooomOloom^
TjKoioooon;ooomRTZSoFYBXoeNDZOmLV;3oFY>^oeRD[_mDU[3oDiJaoeBE/OmEUK7oEiBa0_mGU;<0
4omEU;?oDiJcoe6G/OmCU[7oE9FaoeRC/OmHTk?oEi>eoeBF]_m?VKKoCYJ_oeNG/?mMTJOoJ8jUolSN
looBf^GoIfM_ooclooojnOl00OmWIWH00009ofeVKOomo?ooY:^eof=ZL?oIg=GocMgLoenBYOmDUk;o
DiJ`00CoDiN/00KoDIR/oe6H[_mDUK7oFY:eoeRB]om@Uk<2odfI/01Noe6G/?mHTk7oFY:eoeF?]?mH
V;_oCINdoe:J/_mJUjWoII6NonkoooofooooNhjDonSgo_olo_oom?coofn<T?oUooook_ooogR8UOob
ooook?ooofN8SomdTIWon?oooo_noomfQY?ol?oooo?oooo0bloog>3Yoo;loonddMGoK8V?oo;koooe
ooooIHZCofnDWOmnSYkoMh>Cofn:UOoVoooolOooofn5T_mXRISoJIFPof>EW?mPTY_oHhfSon;ooooT
ooooJY2Mof>FZOmPRikolOWoooWooom_SicoI8RDonokooogooooKXB?onWooooRo_ooNI>PonSoooo[
ooooN8jLog:8U_mbRIWoJXBCogF@XOoUooooh_ooofZ?XOmYT:7oHhnLof:AVOm]TIgol?cooo3ooomJ
SYcoBY2LoeZO[omGTj_oHI2^oejA[_mAUk3oC9Z`oe6G/?mDU[3oEiB`oeRC/OmJT[GoF9>eoeBE/`;o
DINa00ooDiJaoeFD/omGTkGoEIBgoeBF^?m?VKKoCYFaoeNG/_mKTJWoIXjWolKOlooBf^GoIfM_oocl
ooojnOl00OmWIWH0000;ofeUL?onnoooY:Zfof=ZL_oJf]SocMgMof6AYomEU[CoDiJ`oe>G[_mCUj`0
0_mDUZ`0B_mCUjcoDiN^oeFE/OmKTKOoF9:godjH/Om:VjkoC9^/oe2I[?mHU;3oFi6cof>J`OmCUKSo
B9NeodFCZOmCUJ?oK9NPooOooooloooo[K[0ooCoooodm?oonOooojC1aooVooookOooogB6T_o4e^Co
kOooomOloonM_/Ooko_ooo7hoomhRYSojOoooo3ooooeoooon_[oon_dnomfV9[oIXN<ooGoooo_oooo
h?ooomSooooaoooom?ooogZHX?oWooooiOWooo3ooooWoooogOooolKcm_mNSI?oJYFXon?ooooZoooo
JXbFoeF=W_mST:Gon?goooWkoom`TYcoKYBMooGoooohooooNIBOomWioooYooooJXJAon_oooo]oooo
j?ko0_o^ool07Oo]ooooMI6Oon3ooooMooooJiFUofZEYOmPT9coHYNMoeZ0ROoioOook?Kooe^CX?mH
YJooBiBUoe6?Y_mSS[3oHHn`odjH/Om9Vk7oD9RaoeBE/OmGU;3oF9>aoe^A/omHTk?oDiJcoe2H/Om@
V;3oDIN`00;oE9Fc00coE9Bgoe:G]_m?VKKoCYJ_oeNG/?mKTJWoIXnUolGPlooAfnGoIfM_oocloooj
nOl1ofMVMP0000_oKFAiookioonVZ;ooIFQiom_Hgoo>fnCoHXn^oeJD^OmGTkGoEiBcoeND/@03oeRD
/01foeRC/OmHTk?oFi6eoeND/om>VJkoBIbZodZLZ?m>VZ[oEiF/oeZC/?mGT[CoBHj]oe:T_?m:Vjko
EIVTofBCVOo^oooom_goolSEgOoboooo^L??oo7oooo8hnkoioooonWooomdRiWoLhfLojc8e_o:k?So
g__oonkooooaooooLHRFongoooo`ooooiOOgooOooonod]KoIH^<ofZBU?oUnoooioooof>BV?m@OhGo
joooom[`oOmVRHooh_ooon_ooom_RY7oK8jGokgTjooToooob?7gofZKZ_oDooooi?ooofnAVomYXK3o
EhZKonCjoooaooooJ92HofZEW?o/oooogo?jof^6TOoYooooiooooff8Too]ooooiogoogbBWOmZP8_o
k?ooomoioomYQI?oioooomkooomYSYkoIHbMof6?W_mJSiOoLYbXooGoooo_o_ooF96Toe2M[Om=V:go
Fi^fof6?/omNT;?oCIReodNK]Om>V;?oDiJcoeFD/omGU;?oF9>aoeND/?mAUk3oCYV^odjI[?m@VJco
DiJ`oeBF/?mDUK?oDYRbodnI/_m<UjcoEYV/oeZCY_mUT:?oaN3aom7KiOmWIfooo?cooo[io`7oIfIf
00003?mZI7koo?[ooj>XaOmRJ7kofMWSolkJj?mRS[7oEYBmoeNC^?mGTkGoF9>coeRC/@;oFY>a0_mJ
T[<07?mKTKGoF9>coe2H/?m<VjcoC9^Zoe2IZ_mHU:koFi:aoeRC]Om=Sk7oDIjjodbJ[_mGVJOoHY6I
oo7ooooiooooh>gfonSioomeRICoi_coomS^noo]ooooj?ooofj;VOoMoOoo]=7Oog2;W?n`c=X2onGo
o`15ogB>WOoSnoooiooookC;dOo^ooook?oooik5c?mWSiOodo3nonOoooo0koWo]^G_onGooooAkO_o
K96JonCooooQoOooLhnJofnDWOmaTigojoooomcloomLSj3ofOooonOoooneeNCoDhNLof>J[_o<l?ko
iOoookGOkOnli_Coi_ooolg[mOmZRYOoi?ooonSooomdTIoobNGconCoooo5hNoo`=g[on?oooo=kOco
K8fNolc`oooRoooo_NKhoj39gOoMoooocoooof2:V?odooool?oooeF>XOm?Vj_oAXjToeJF/OmQSk?o
GY2codjH]Om:V[GoD9NcoeBE/omGU;?oF9>coeZC/OmGU;7oDiJ`00;oD9R^00ooDIR^oeBF/?mEUK3o
EIBcoeBG]?mAVK;oCiJ/oeVG[?mMTJKoIXnSolKPlOoBf^GoIfM_ooclooojnOl00OmWIWH0000kofEW
P?ofo?ooWj[6oeiZP?oDfnGob]cXoen@/OmDUKgoE9BgoeBE/omEUK7oEiB`oeRD/?mGU;3oEiBaoeRC
/omLT;OoFi6goe>F/om@V;7oD9R`oeBF/?mKTK?oGXngof2C__mKU[koC9:doe2G/omNV:koHHZLoo7o
ooo^m?oolOWoomo]m_m]R8ooi?ooonCdooo^o_ooj_ooog2BW?n[d=Wof_[oonWnooo[oooohOooojkC
g?mjU:7ok_ooon_ooomhTZ?oXK[>on;noooSooooYL_PoeanUoo4j?ooe?koomooooo:kOl00_m`T:D0
5?oRooooiOooog6>X?mVQi[oK8NLooCoooo^ooooJYZaom7ooooUoooogOOoom;ooomJSJ[oI96Vol3Y
nooPoooogOoookKOlOmWT:;oJHnT0_oRool08?mIOiCoK9:WolS^oooPoooogoooolScoomRSjCoI96V
oef;X_o4l_oocoooom_oooo<o?ooVLgJon3oooo]nOoolOooomSooomBUjKoG9nboeNAZOmSS[3oHHn`
oe>F/?m>VK3oE9J`oeND/?mJTjkoFi:`oebA/omJT[GoEIBc0_mCU[403omDUK7oF9>coeZB/omJT[Oo
F9BhoeFF]_mCT[7oGIF`of6?ZOm/RjOobmgcom?IiomWIfooo?cooo[io`01ofMVMP0000_oHfQlooGm
oonM[<?oG6alomCKhOo9gNKoGY6^oeBF^OmCUKGoE9FaoeFE/002oeFE[P;oEIF`013oEiBcoe^A]omJ
TKSoDiFeoe2G/om@V;7oE9FcoeZB]OmLT;SoEHZdoejI`om?UKOoDYVgoeRD[_mST:OokOoo0_odool0
0onne>7oJ8fFol3UkP02oo3oo`1NonCooomPS9OoGXZGofjCXomeSZ;oJHBGof>CWomYVjKoHhBCon[o
oooVooooKI6YofV=YomXT:WoF8:Kof>?Z_mXUK;oII:_ofRE/_mLRZCoIi>/ofF?Z?mSR:;ohoooon3o
oom`TjWoJi6XokoMmoodoooofnkooeJ<Y_mKU:ooMiJcofR2XomSTK?oH9VgoeZBZOmFRZ3oI96^ofNC
/?mOTjWoH9BZof6?YomNRZ?oGHVRof6?YomRTZWoIIN^oeF9WomHSjCoFY2XoeV?YomPU[3oFY2ZoenE
[omRV;CoDHNSoe^AZOmJSiooJ9>SonkooooYooooF92Qoe6FY_mDUZcoE92Zof6?/?mOT;3oDiJaodjI
/?mDUK7oEiB`oeZC/?mJTk7oFi6eoeRC]OmEU;GoDiJcoe6F/omDUK?oF9>coeZB]OmJT[OoF9BhoeJE
^?mCT[7oGIBbof6>Zom/RjSobMgeom?IiomWIfooo?cooo[io`7oIfIf00002_mVJ7Gomogooin/_?mN
K7Goe]cJol_MgomOTZOoEIJdoeBF/?mDUZ`2oeFFZP0HoeFF[?mDUZcoE9J^oeBE/OmGTkGoE9BgodjH
]Om<VK?oC9ZaodjH/omDUKGoEi>goe>A]_mEVKcoBiNgodND/?m=TJSoIijcolkboooYooooj?ooojK9
gOmTUjSoV/gN0_oVool0BOoBooooHIb^oefGZomOTjWoHhRSog6K]?m@Sj3oEiVYofJF[?oLoooofooo
oe^?YomNUZooF92YofFK]omLU:ooEIF`oeBD[omLU:ooGiNboeFAZOmKUJgoH9:[om?ooooKooood_oo
omWooooJooooeNcoofj=Z_mDUZkoCiJ/ofFB[omRRj_oF92aodjA[_mBV;7oE9R_oe29Y_mIT:koG9fc
oe>DZ_mPU[3oeOooomWooomPU:coG9:ZoeRBZ?mQWKGoF9J]oefK/_mCU:[oChfVofFS_?mDSJSoEi2]
of6H]_mLUK3oGib_oeV=X_nUan?of?gooeJG[Om@W;?oBI>/oefP_OmJT[GoF9>eodjG]om<VKGoCYNg
oe6F]OmDUKD00_mEU;D01_mCUKGoD9NcodfI/Om=VK7oCYRaoeBE/`;oEIBe00_oE9Jfoe:G]_m?UJoo
EiN`oe^AZOmVSZOoaN3com;JiOmWIfooo?cooo[io`01ofMVMP0000WoJVM`oocloonSZkKoHV]bom[K
eOo>g=coHi2SoeRE/OmGUJ`00omGUJX01omEUZcoE9J^oeBF/?mDUK7oE9Fcoe>F/om=VK400_m<V[00
F_m>VK3oDiJaoeBE/omGVKWoC9>aodjK]om<V[7oDYV]oeZGZ_mUU:KoIH^PofJ;YOmUTj_oDXbPoenI
[OmXU:ooGh^Vof:J/omBTjWoD9:Zoe^G/OmKS:[oH9>`oeVP]?m6Sj;oFiN_oeZBZomGT:_oGYbeodj@
Z?mDUZkoGIJaoeBA[Om9U:_oD9^boe6=ZOmNV[CoCi>ZodjBYomQVK3oGi>YoeRAYOmOVZcoEY6Sof:F
ZomZSJWoIHnXoe6H[?m=V:goF8jZofBE/omIVKGoCIF^od^F[OmDW;CoEIF`oeND/?m@UjgoD9BYoeR@
ZOmSUjooGI6YoeR@YomJU:coF9J]odj?YOmHV[3oC92WoefQ^?mATj_oDi>/oeVG/?mFTZcoGiReoeRD
[_mETjSoG9J/ofRA[omRSjkoEINaodbH[om=Uk3oCI:_oeNC]OmEU;GoCIRgodbI]Om>UkOoDIJeoe>E
]@;oE9Fc01?oDINaodjI/?m<VZkoC9Z^odjI[_mCU[3oEIFaoeBE/OmDUk;oDIVbodjF[?mFV:koFY>V
ofF@Xoo5h?7odM_UofMWKoolo?oon_Wo007oIfIf00002OmaIFooooWoojZX]OmZJG7oi=cIoloEeOm/
TZOoEXf[oe^C[P02oeZD[008oeRD[_mGU;3oEIFaoeBE]OmDUK?oEiB`oeFE[_mAV:`2oe2I[00=oe6H
[?mDUZcoEIF^oeFE[_mCUjkoD9R^oe2I[?mCV:SoF9JUof6BXomST:?oHY2WoejBZP02oeREZP;oGY6/
023oF9B^oeFE[_mDU[3oEIF`oeZC[_mHU:koDIR/oe2I[?mEUZcoEiF/oeRD[?mGUJcoDIR/oe>G[?mJ
U:coEiF^odfJ[_m>VJcoF9B/oeZDZ_mAV:[oDiRXoe^DYomNTZOoFiBWoeZEYOmHUZGoFiBUof6AYomN
TZOoDiRWoe6IZ0;oFi>/00CoE9J/oe6H[?mCUjkoE9J^0_mGUJ`00omDUZcoEiF/oebCZ002oejBZ005
oe^DZ?mHUJ[oEIJZoeBGZ_mCUjX00_mCUj`01?mDUZcoEIJ/oeNE[?mHU:`2oeZDZP0>oeREZ?mKU:So
HhnXof6@Z_mEUZcoD9V/oe6H[_mCU[3oF9B`oeND/?mAUk7oCYV`oe6G/OmDU[02oeFE/00DoeNE[_mD
UZcoDIRZodjJZ?m@VJSoDIRZoeFFZ_mHU:coEiF^oeBD[Om?UZ[oE9VYoeFDYOmGSicoKINUol?Mj_oB
fnCoIfM_ooclooojnOl1ofMVMP0001CoKVA_ooohoonXYkGoIVA_on7IeooCf=_oKYB[of:I^?mJTk7o
FY>`oeRD/?mGU;7oEIBeoeBD]omCU;[oDiFgoeND/OmGUJkoE9J^oe6H[P;oDiN/00coEIF^oeNE[_mE
UJkoEIF^oe>G[_mCUjcoE9NZoeREZ?mLTjOoGY:XoebBZ_mJU:`2oeRD[0;oF9B^00KoEIF`oeBF/?mD
UK7oDiJ`oeBF/?mCU[02oe6H[P04oe>G[_mDUZkoEiB`oeFE/0;oDIN`00KoF9B`oeND/?m=VK3oCIV`
oeRD[_mJTjh2oe6H[004oeZDZ_mLTjSoFiBXoeREZ0;oEiJX00CoFYBZoeREZ_mDUjSoE9NZ0_mHU;00
3omDUZcoDiN/oeND/?mHTk7oEiF^oeFE[_mGU;3oF9B^oe^C[?mKTj[oFYB/oeRD[?mEUZcoDiN/oe6H
[P03oe2H[P05oe6H[_mCUjkoE9J^oeFE[_mHU:`00_mHUJX01?mKU:SoGi6ZoejBZ_mEUZX2oe>G[007
oeBF[?mGUJkoEiF^oe>G[_mAV:koE9J^oeFE[P02oeNE[P0DoeRD[_mGUJcoDiN/oe2IZ_mAV:[oE9NZ
oeRD[?mJU:coFYJboeZG/omFV[7oE9R[oeNFYomMTZ;oJ9:RokoIi_oBf^GoIfM_ooclooojnOl1ofMV
MP0001CoIFAbooWloonU[[ooHf]homWJg?o=g>7oFHNOoe>B/omEU[KoEIJdoeBF]_mBUkKoDINiodnH
^om>V;ooDIJmoeJE^?mHUKCoEIJdoeBG]0;oEIJf00?oEYFfoeRD]_mHU;H00_mFUK@00omEU[CoEYFd
oeRE/P02oeVD/P;oF9Fa00CoFIFaoeRE/OmDUk;oDYRb0omEU[@00omDUkCoCiVdodnI/P02oeBG/P08
oe6I/OmBV;;oEIFhoeFE^OmAV;SoDYNhoeVC^?mHU;P2odjI^00:oeVD]_mKTkKoDYNdoe:G]?mKTkCo
G9>boe^D/_mHUK;oEIJboeBG/P;oE9Jf00KoEINaoeJF/_mFU;WoEIFioeBG/_mEU[82oe^B^@05oeJE
]_mEU[CoFIBfoeVD]_mFUK@00_mEU[@01?mBUkCoDIRfodnI]_m>VKP3odfJ^0;oCYVf00WoCiVdoe6H
]?mDUkCoEIJboeJF[omIUJgoG9B]oe^E[OmFUjd00omEUjl2oeJF[`;oEIN_00OoEYJ_oeRF[omHUZoo
FIFaoeVD]?mHUKCoE9Nd00;oDYRb00ooEIJboeVD]?mKTkCoE8jcoeFA]OmFV;SoD9>`oeNG/?mQUjoo
Ii6YolKQm?oAfnOoIfM_ooclooojnOl00OmWIWH00009ofA[OOoeooooW:fooeMWM_oAfM_od>?Yoej@
ZOmQXl?oDYFb00;oDYF`00WoDYFboe2E]?m?UKOoCIJiodnE^OmDTkKoEY:doeBC]?mCU;@00_mCTkH0
1?mDTkKoE9>doeJB]?mFT[@3oeBC]00:oe>D]?mCTkKoDi>foe:D]?mCU;;oEY>boeBC/_m?U[CoCINd
oe:D]P;oDi>f00WoD9FfodbG]_m<UkCoDYBdoe>D]?m?U[;oCiJdoe:D]omCTkL00_m@U;L01_mFT[Oo
E9:godfF]om=U[KoEY:foeNA]P;oD9Fd00koEi:doeVA]?mFT[CoE9>boe:D]?m@UKCoC9JiodfF]omC
U;3oE9>boe:C^Om@U;WoD9Fboe>D/0;oFI2i00GoDYBdoe:E/_mFT[KoEi6foeBC]P02oe:D]004oe2E
]?m?U[KoCIJfodfF]`?oC9Ng00KoC9NfodfF]_m?U[CoCiJdoe2E]?mBUK82oeBD/0;oEY>`0omCU;00
3?mCUJooDiB`oe>E[omCU;3oDiF_oeBD/?mFTjooEY>`oeNB/?mGT[CoEY:foe:D]0;oD9Fb00ooDYFb
oeNB]?mITKKoFiFkoeBB]omEV[_oCIBboe>E[omHTZ[oFXRPol3OlooAfnOoIfM_ooclooojnOl00OmW
IWH0000:oeYWN?o^oOooVZo2oeY/N_oCgMkobMcPoeV9Wom@T:coEIJ/oeNEZP;oF9FX00?oF9FZoeNE
[_mEUK000omEUK02oeBE/@;oE9Fc0_mDUK403?mEUK7oEIF`oeFE/?mEUK7oE9Faoe>F/om@UkGoD9Ng
oe2F^?mAUKSoEI>hoeBD^0;oCYNj00CoDiBloeBC_?mDTkcoDiBj0_m>UkX2oeBD^0;oD9Ng00CoDiFe
oeBE/omAU[?oDiJc0_mEU;<01?m>V;?oCYRaoeFE/OmEUK42oe6G/@0CoeFE/OmGU;7oEIFaoeBE/OmC
U[?oD9NcodbH^?m=V;GoE9J^oeFE/?mAUKSoD9Jhoe6H[_mCUjcoEi>eoeFD]omAUk3oD9R`oeBE/`02
oeND/`?oEiBa00?oEiBcoeFD]OmEU;D00_mEU;D00omDUKGoE9FcoeFD/`02oeFE/@03oeFE/?mEUK7o
E9Bg00?oDiFh0omCUKL07OmCUKGoDiFgoe>E]OmDU;OoE9FeoeFD]omEU;GoEIBgoeNC]OmHTkGoEiBc
oe>F/Om@V;7oD9R`oe>F/?mGU;7oF9>coeVE]om@TK7oCYRcodnI/_mDVk7oEiFZof2CZ?o7j?WocmcU
ofMWKoolo?oon_Wo007oIfIf00002_mMI7OolOWooj6``omRKW[og]kLol_Ee_mcV:[oHYJ/of:CY?mS
Tj42ofJBW@03ofJBWomVTJ7oI9:R00;oHi:R0_mRTj@01OmRTZKoHY:Xof:BZ?mPTjKoH9>T00CoHi:T
00KoH9>VoenCZOmKUJ_oFiF]oebD[OmOTj/2of:A[@0FoefC[OmMTjooH96_of:A[omST:ooH96_oenB
[omOTZgoHi2]of>AZomPTZ_oGi>Yof:BZ?mRTZKoH9>Xof2CY_mSTZKoHY:VoenDY_mOU:CoHY:Vof>B
YP;oH9>V0_mSTZH04omSTJSoHY:Xof2CZ?mMU:WoFiF]oebDZomRTj;oHi:RoenB[OmMTj_oGiFQof2D
WomRTZWoH9:[oefEX_mLUZ;oGiBVof:BZ?mSTZH00omTTJH01OmTTJSoIY2YofJ@ZOmVT:WoI92Y00;o
I96X00OoI96Vof>BY_mSTZCoHi:Tof:BY_mRTJgoGi:_00;oGI>_00CoGi:_of2B[OmPTZgoH9:[0_mO
Tj/00omRTJ_oHi6[of>AZ`03of>AZ`06ofJ@ZOmSTJSoH9>XoefEY_mMUJCoH9>T0_mTTJP03?mPS:Go
FH^RoeF>XOmLUjOoGiNTof:DWom_UJ3o^];Lom;Ki?mWIfooo?cooo[io`7oIfIf00003?mdJgkoooSo
ojZW^_mUGf_oimGCon;GeOo4e>?o_mc^olGPjoo:g^Goc=kRolkMh0;oc]gR00Koc]gTolkMh_o>gN3o
c]gPoloLh_o?g>@2olkLi@0<olcMi?o<g^;ocmgPoloMh?oAg>3ocmcRolcMi?o:g^OoaN3[olCQjOo8
h>CobmoP0_o>gN802_o<g^;oc=gToloLi?o?g>CodM_ToloLh_o>gN;oc]gPom7Lh?oAg=h2oloMgP;o
cmcR00Koc]gTolkMh_o?g>;ocmcRolcNh_o<g^04olkMhP?ocmcT00Goc]gTolkLiOo<gNOob]g[ol_M
i`02oloMgP0:ol_MjOo:g^Woc=oKolcOfoo;g^Gob]kWol[Pg_o8hMgob>3Rol[Oi0;obmkR00?oc=kR
olcMi?o<gND01Oo>g>D04Oo<gNGoc=gTol_Nh_o;gn3ob]oPol[Oh_o<gNGobmgWolOPioo7h>GobmkU
olkMi?o<gNCobmkTol[Oh_o;g^;oc]gR00CocmcR00OocmcTom;JiOo?g>Goc=gUol[Oi?o;g^;oc=kR
00;odM_U00coe=kZom?Tk_o5g^?ob>CWolCMf_o4em?oc]C@onOWiooHfMkoIfM_ooclooojnOl1ofMV
MP0000coKF5eoogdoonaZKkoKV=aoncHfOoOcloog=cTom;Li_o@gNGodmcQomOKg?oJf]P2om_Jf005
om[Jf_oJf]Sofm[Fom_Je_oKf]P00ooKfMX02ooJf][of][Hom_Je_oMfMKog]WFomgIf?oJf][oem_L
om?MgooCgMkoemcH00;of]_E00?ofm[Eom_Je_oKf]H01?oMfMH2omgJe@;og]WC0_oMf]<02?oMfMKo
fm[HomgIf?oKf]SogMWHom_Je_oKf]Sofm[F1?oKf]P2om_IfP08omgIf_oKfM[ofmWLom[Jg?oJfMoo
f]WNomgIe_oKf]H2omWJgP;of]_C00KofM[LomOKg?oGg=GoemcEomKLf?oFg=X2omKLf003omOLf?oG
fm[oem_L00GofM[L0_oIfmX01?oGg=SoemcFomKMe_oGg=H2omWKfP0:omCMg?oFg=[ofM_Jom[Jf_oJ
f]SofM_HomOLe_oIfmKofm[FomgIeP?ofm[F01GogMWHomkHg?oMf=cof][JomWKf_oIfmSof][JomgI
f_oNf=coeM3DomoOhOoAemOoen3MomGLeOoMg]Koh]_ComS@cOoHf>3oIFMcoocloookn_l00OmYIG@0
000>ofUWOOohnOooYZVlofQZNOoJe=kogmKIomoEdooLf=OodmcSom;MhooIfm[ogM[EomgJdooMf]D2
om_JeP;of][H1_oJf]X01_oJf]Sofm[Hom_Jf?oKfM[of][JomWKfP;oem_L00?ofM_Jom[Jf?oJf]P0
0ooJf]P;om_Jf007om[Jf_oKfM[of][Jom_If_oJf]Sof][Jom[Jf006om[JfP04om_If_oJf][of][J
om[JfP;of][L00Cofm[Hom[Jf?oJf]cof][L0_oJf]P01?oJf][ofM_JomWKf?oIfmP2omWKfP?oem_J
0ooGfm`2omOKgP03omOKg?oIf]cofM[L00;ofM_J0ooIfmP2omWJg003omOKg_oGfmcofM[L00GofM[L
1_oJf]`00ooKfMcofmWJom[JfP03om[JfP?ofmWJ00_of][JomWKf_oIfm[ofM_Hom[Jf?oKf]Kof]WN
omKKk_mLHW;oooooooggm`01ofmTLP0000_oI6UlooGkoonTZ[[oIF]iomCFh_oJf=_ohmG<on7Fd?oA
f^7oc]_TomOHfP03om_Ge010omWHe_oHf=Sof=SHomSHe_oHf=Sof=SFomSHf?oHf=Kof=SHomSHe_oH
f=Sof=SFomSHf?oHf=Kof=SHomSHe_oHf=Sof=SFomSHf?oHf=Kof=SHomSHe_oHf=Sof=SFomSHf?oH
f=Kof=SHomSHe_oHf=Sof=SFomSHf?oHf=Kof=SHomSHe_oHf=Sof=SFomSHf?oHf=Kof=SHomSHe_oH
f=Sof=SFomSHf?oHf=Kof=SHomSHe_oHf=Sof=SFomSHf?oHf=Kof=SHomSHe_oHf=Sof=SFomSHf?oH
f=Kof=SHomSHe_oHf=Sof=SFomSHf?oHf=Kof=SHomSHeP;of=SH00?oemWHomGIf?oGfMP00ooEfMP3
omGIfP?oemWH01?of=SHomSHe_oHf=Kof=SFomSHf?oGf=[of=SJomOHf_oHf=[oemSJomSHf_oGf=[o
f=SJomOHf_oHf=[oemSJomSHf_oGf=[of=SJ00;of=SH01?of=SFomSHf?oHf=Kof=SHomSHe_oHf=So
f=SFomSHf?oHf=Kof=SHomSHe_oHf=Sof=SFomSHf?oEf=oocmO^oeiVNOolo?[oookj007oLFEc0000
ComVJW?omocoojJ[/OmWK7;oe=SKomcHeOoSeL[oh=O>om?Mi_o>g^_oem_Tom_JgooLf]oofm[Pom[J
i?oJf^;ofm_KomcKeooLfmWog=_GomcKfOoLfmOog=_IomcKeooLfmWog=_GomcKfOoLfmOog=_IomcK
eooLfmWog=_GomcKfOoLfmOog=_IomcKeooLfmWog=_GomcKfOoLfmOog=_IomcKeooLfmWog=_GomcK
fOoLfmOog=_IomcKeooLfmWog=_GomcKfOoLfmOog=_IomcKeooLfmWog=_GomcKfOoLfmOog=_IomcK
eooLfmWog=_GomcKfOoLfmOog=_IomcKeooLfmWog=_GomcKfOoLfmOog=_IomcKeooLfmWog=_GomcK
fOoLfmOog=_IomcKeooLfmT00_oKfmT00ooJg=Wofm_Iom[Lf@02om[Lf@?of]cK0ooKfmT00ooLfmWo
g=_GomcKe`02omcKe`0=om_LeooLfmOofmcGomcKeooKg=Oog=_Gom_LeooLfmOofmcGomcKeooKg=Oo
g=_Gom_Le`04omcKe`0BomcKfOoLfmOog=_IomcKeooLfmWog=_GomcKfOoLfmOog=_IomcKeooLfmWo
g=_GomcKfOoHfn3obM?/ofQcQoo`l_7ooooj0OmYGV`0000AofUYLOojn_ooYjZaofQ[L_oDemcof]SI
omoFcooJfMOo00@Eo`067_l01AOo00@Co`045Ol011Oo00@Ko`046Ol01A<0AOl01A04o`044PKo00D@
0_l01@h03_l010ko00D>o`043_l01@ko00@>o`053_l010ko00D>o`043_l01@ko00@>o`053_l010ko
00D>3ol01A001Ol011Go00DQoem[PookoooomOC`007oJV9a00003_m]IWKoo_Oooj^W^?mZJGWoe=KU
omKHi?oHemcoc]cUob1<JOlECgCo64i`oaM?L?lDD7;o4E5e0_l>DWT00olAD7_o4Tmkoa9?N`0moa9?
N`So4U1i1olBCg/04_lBD7Wo4U1goa9@MOlDD7Go4U1eoaA@MOlBD7Go551eoa9@MOlDD7Go4U1eoaA@
MOlBD7Go551eoa9@MOlDD7Go4U1goa9@N@ko4Tmk00Go6DeeobE5JomJJhGok?Khookoo`01ofm[O000
04ooKVEhooofoon[YkSoJfQiom?FiOoCfNGoe=SQolSNk?lEBfoo24mmo`Q?Nol6DG_o0e5oo`1CP_l0
E8Co05>8o`1BROl0DHWo056;o`1AROl0DH_o0569o`1ARol0DHWo056;o`1AROl0DH_o0569o`1ARol0
DHWo056;o`1AROl0DH_o0569o`1ARol0DHWo056;o`1AROl0DH_o0569o`1ARol0DHWo056;o`1AROl0
DH_o0569o`1ARol0DHWo056;o`1AROl0DH_o0569o`1ARol0DHWo056;o`1AROl0DH_o0569o`1ARol0
DHWo056;o`1AROl0DH_o0569o`1ARol0DHWo056;o`1AROl0DH_o0569o`1ARol0DHWo056;o`1AROl0
DH_o0569o`1ARol0DHWo056;00[o05690_l0D8/4o`1AR`03o`1AROl0DXSo056600ko05660_l0DHT0
4_l0DH_o0569o`1ARol0DHWo056;o`1AROl0DH_o0569o`1ARol0DHWo056;o`1AROl0DH_o2Tf2oa]2
KOmSN9?okogooo?gn07oJ6Eh0000C_m]Ig?oo?Wooj^X/omZJWCoe=OPomGIh_oEf=gob]g[oaI<L?l9
Ch3o255no`MAP?l4DX?o0E:7o`1CROl0Dh[o05::o`5BROl1DX[o0E:9o`5BR_l1DXWo0E::o`5BROl1
DX[o0E:9o`5BR_l1DXWo0E::o`5BROl1DX[o0E:9o`5BR_l1DXWo0E::o`5BROl1DX[o0E:9o`5BR_l1
DXWo0E::o`5BROl1DX[o0E:9o`5BR_l1DXWo0E::o`5BROl1DX[o0E:9o`5BR_l1DXWo0E::o`5BROl1
DX[o0E:9o`5BR_l1DXWo0E::o`5BROl1DX[o0E:9o`5BR_l1DXWo0E::o`5BROl1DX[o0E:9o`5BR_l1
DXWo0E::o`5BROl1DX[o0E:9o`5BR_l1DXWo0E::o`5BR@Ko0E::1Ol1DXT01?l1DX[o05::o`1BR_l0
DX`2o`1CS003o`1CR_l0DhOo05>500go05>501Go05>7o`5BROl1DXWo0E::o`5BROl1DX[o0E:9o`5B
R_l1DXWo0E::o`5BROl1DX[o0E:9o`5BR_l1DXWo0E::o`]>P_lQBWKoC6>2oo?ooooiool00OmQH780
000>ofYYLOokn_ooZZV_ofY[L?oDemkoeM[NomGIg?o:gN_o5Tabo`Q@P?l8D8;o1E62o`9BQOl1DXT2
o`1BRP;o05>903ko0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo
0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo
05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo
0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo
05>9o`5BROl0DhWo0E:9o`1CR@?o05:<0_l0DXX3o`1CR@04o`5BROl0DhWo05::o`1CRPCo05><00?o
05>9o`1DQol0E8L03?l0E8L05Ol0DhOo05>9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo
05>9o`5BROl0DhWo0E:9o`1CROl1DXWo2Dn2oae8MOmJMI?ol_ooonoin`01of]/P00000goJFUeoo[j
oonYZK7oJVYbomCGg?oFfMkoeMWLolSNjolECG;o1E62o`EAPol4DX?o0E:704;o05>900_o05>:o`1?
R_l1EiCo056<o`1@Rol0EHko05B;o`1>QOl1EXgo0569o`1BR@02o`1BR`05o`1CSOl0E8go05B=o`1D
SOl0Dh/07_l0DhT01Ol8Ch?o6TUgoe5^S_o_oooom?go007oIfQl00003OmWJ7[on?[oojVX]_mZJWKo
e=OPomKIh?oDfMgoamk^oa1>MOl2DXOo0E:7o`1DQol0E8X00_l0EHX00ol0E8Wo05>9o`1CQ`0mo`1C
Q`09o`1CROl0E8oo05FBo`1@Rol0D8Wo0EJ=o`5FS?l0DHOo05:600;o0EB800Co0EB:o`1DR_l0EH_o
05J;0_l0EHd?o`1ER`03o`1DRol0DhWo05>700go05>700Go2522oaY9Mom@KhkokoooooCmo`01ofMX
O000017oIVN3ooShoonYYkgoJVUkomCFiOoEfNGod]WQol?Pl_l<Cgco05B<o`1ES?l0EXko05N>o`1H
S_l0Ehko05N:o`1DQ`0no`5CQ@0:o`5BQol0EHko05B=o`1CR_l0DXSo0U>8o`1BQ?l1DH;o0U20o`=A
P@;o0E:100?o05:1o`1BP_l0DX@00_l0DX@00ol0DXKo0566o`1AQP0=o`1AQPoo0E>500Go2Dn0oaY9
MOm@KhkokoooooCmo`01ofMXO000017oI6R3ooOioonWZ;coJVUiomKEhooFfN;oe=WOolCOl?l>CW[o
05><o`1DS?l0EHco05J>o`1FS?l0EX[o05F9o`1CQ`0no`5CQ@0:o`1CQol0ChKo0529o`9GS_l0DhOo
0UB6o`5?Ool9EXCo2UN3o`EBOP;o1E9l00Go15=no`ABP?l2Dh3o0U>0o`9CPP02o`9BP`0>o`ABPol2
DX?o15:3o`9BPol4DX?o0U:3o`ABPol2DX?o15:3o`9BPol4DX?o0U:3o`ABPol2DX<?o`5CQ@05o`U?
P?lJBGGoDFj<onooooodo_l00OmYIg`0000:of9[N_odo?ooYjZcofY[L?oHe]Wof]WGomWHe?o;gNOo
5Tabo`M@P`Co1e2500?o2Dn2o`Q?Pol1DXL0?ol0DhX02?l1Ei3o05:;o`1DRol0CH7o1eV;o`=APOl5
DWko0dih0ol8Dg/00ol6E7_o1U=mo`EDO@02o`EDO`;o1E>100oo1U>1o`ECPOl6Dh7o1E>1o`ICPOl5
Dh7o1U>1o`ECPOl6Dh7o1E>1o`ICPOl5Dh7o1U>1o`=DPol0DhL03_l0DhX01Ol8Ch?o6TUeoe5^S?o_
oooom?ko007oJFQj00002_mRK7Som?goojNZ/Om[Jfgof=OEomcHeOoKf=?oc]cUoaM;L_l8Ch<2o`Q?
Q@13o`Q?Qol9CXGo34j2o`U?Pol1DXWo05B:o`1CR_l0E8[o05>:o`1DR_l0Dh[o05B:o`1CR_l0E8[o
05>:o`1DR_l0Dh[o05B:o`1CR_l0E8[o05>:o`1DR_l0Dh[o05B:o`1CR_l0E8[o05>:o`1DR_l0Dh[o
05B:o`1CR_l0E8[o05>:o`1DR_l0Dh[o05B:o`1CR_l0E8[o05>:o`1DR_l0Dh[o05B:o`1CR_l0E8[o
05>:o`1DR_l0Dh[o05B:o`1CR_l0E8[o05>:o`1DR_l0Dh[o05B:o`1CR_l0E8[o05>:o`1DR_l0Dh[o
05B:o`1CR_l0E8[o05>:o`1DR_l0Dh[o05B:o`1CRP02o`1DRP09o`1>QOl0D8Co25Z<od2>__m;V<Co
D9W2odbD_?m<U;[oCYBh00;oC9Fh0_m;UKX2odZE_0;oBiFl02;oBiBmod^E_?m;U;goBiFlod^D_Om;
UKcoBiBmod^E_?m;U;goBiFlod^D_Om;UKcoBiBmodRE`Ol0DhOo05B:o`1CR_l0E8[o05>:o`1DR_l0
Dh[o05B:o`1CR_l0E8[o05>:o`1DR_l0Dh[o05B:o`1CR_l7D8?o6TUeoe=^Roo`oooomOgo0OmZIgP0
000?ofAYOOogn_ooZJVeofaYL_oJeM_of]SKomWGf?o:gNco4Teio`5AS?l0DXko05>>o`1CT?l0Dhko
05::043o05>900Wo05>7o`IISOl4EXSo0U20o`QEPom<UL3oDY[2oe6E^_m?TK<00_mEU[H2oeFF]0;o
E9Jf0_mBUkH2oeBF]P0?oeBF^?mDU[KoE9JhoeBF]_mDU[SoE9JfoeBF^?mDU[KoE9JhoeBF]_mDU[So
E9JfoeBF^?m?Ukgo0U>200ko05>900Go2522oaa9LomCKXWol?ooooGno@01ofYXMP0000[oIVQmooSi
oonZYkSoK6QfomSEg?oJf=goemSJolSNk?l?CW[o05:>0_l0E9001Ol0EI3o05F>o`1ES?l0Dhco05::
00;o05>900Go05B7o`1CROl0E8Oo05B7o`1CQ`02o`9BQ@;o05>:00Co0E:7o`1CQOl0E8Oo05B90_l0
DhL4o`1CR@;o05B:00So05B9o`1CROl1DXOo0U:5o`EAPol2DXGo05B:o`1CS0;o05>7013o05F:o`1D
R_l1DhGo0U:3o`5CPol1DXOo0E6<o`5BR_l1DXOo05>5o`1EQol0E8Oo0E>5o`9BQOl1DhGo05>70_l0
DhT01?l1DXOo0E>5o`1CROl0E8T2o`1CR@04o`1CR_l0DhWo0E>5o`5CQ@;o05>900_o04n3o`=EQOl3
DH7o1e9lodbD_?m@U;OoD9:boeRG]_mEUK7oEiB`oeND/@02oeFE/@03oeFD/omDUK?oE9Fa00CoE9Fa
0omDUK<00omDUK7oEIFaoeFE/@03oeFE/004oeFE/OmDUK7oD9Jho`ABP0ko05>700Go2520oaY9LomC
KX_ol_ooooOmo@01of]WN00000coIVUhooSjoonYZ;[oJfQiomOFg_oHfM_oemWFolSNjOlBCGWo0E6>
o`1BS?l0DhX2o`1EQ`19o`1CR_l0DXco15BAo`19Q?l8FY;o0525o`1AQ_l3GI7o04f1o`=FR?l5CGgo
0T]no`=IU_l0EYGo15B7o`1;Nol0EXWo05N;o`1;POl:Fi;o0U:=o`9BSol1DHko04Z6o`1IU?l0D8[o
05VAo`1>Q_l7Ehco04Ijoa9@Ool>E8Oo05NFo`1CTol0CXCo25jAo`1FTol0EI;o0U21o`]BO_l6EH3o
04n2o`I>U_l:DiSo0U:5o`1BOOl0G8co05J8o`ABPol6D7oo1EJ5o`1EQ_l0E8go04j7o`aISOl2D87o
0525o`1HTOl0F93o05>>o`1DT?l0ChSo1e>4o`ABP_l0D8So05NBo`1FSOl0E8Wo0E>3o`=BOOm?Ukgo
DIJgoeBE/@03oeFE/00:oeFE/OmDUK?oE9FcoeBE]OmEU;GoE9Fcodn@[?mHVkKoBi6[oe6F/`;oDiZh
00CoC96`oe>F/omDUK7oEIF`0_mGUJh01OmEUJkoE9J`oe>F/Om>UkSo0U>200ko05>900Go2522oaM:
MOm@Kh_olooooo[ko`01of]VNP0005OoIVYeooOkoonYYkcoJVUkomKFg_oHf]WoeM[DolSOiolBCGWo
0U6<o`9AR_l0DhOo05B2o`1DPol0DhWo05:<o`1;ROl6EY?o04f6o`1FS?l0Ehco0523o`9JS?l0CWgo
3E5no`eDR?l0CI3o04^@o`1@Qol>Ghko05^:o`1APol;G9Co04V2o`5AS_l0C8Ko1EJ=o`=HS_l0F8oo
05nIo`1ET_l0EI7o2eZCo`M=POlBCgco03e_o`1FU?l0FIWo0UF;o`1?QOl0EYSo05NKo`ICROl:CW_o
1E1ho`aHS?l0@i?o14fLo`1@Qol5GX[o05>3o`1=P?l6DXKo4eV<o`18NOl0DH?o0efIo`1;Qol0BGgo
25B6o`1AROl0DXgo0529o`1CSOl0CH[o05NAo`MEQOl8EXCo05J=o`1BS?l0EXoo05F:o`1CQOl3DWgo
CiRkoe6F]OmDU[000_mEUJh00omDU[3oE9FaoeBE/`02oeBE]@0CoeFD]omEU;GoEYNcoeNJ]?m>U:ko
C9>_odbF/om?V;SoCIBboe>H]OmDUK7oEIF`oeNE[_mGUJcoEIF^oeBF/?mCU[7oCYNho`9CPP0>o`1C
R@05o`MAP_lFBgGoCW2;oo?ooookn_l00Om[IWX0001TofIZMOognoooZJNlofYYNooFe]kof=[IomGJ
e?o8gnOo4Teio`9AS?l2DH[o05>7o`1DP_l0E8?o05>9o`1BS?l:FICo04N2o`9HTol0EHgo05J:o`9J
R_l0BGSo3EZ6o`M:MOl6DXKo05RQo`1LYol2F9?o04alo`1:MOl6E8Co0DR6o`iHUol0CXKo05J5o`1@
MOl7Fgoo04Yeo`17O?l0CXoo04J<o`1AT_l9EXko2TikoaAKQol0CH;o0E>;o`ICROl2DXgo05NLo`1F
WOl1DHko2E24o`QAO?l0A7_o2UBYo`1=Y?l0D93o0efAo`16Nol0Ehgo3efKo`13OolBDHOo3EB<o`1>
Rol0Gi_o15V?o`=?POlBF9?o0TZ5o`ICRol9GYGo05RCo`1PUol0C7[o04mko`1ISOl0FHoo05J?o`1E
R_l0DhGo0e9modnH^omCUKGoE9J`oeFE[_mDUZkoE9J`oeBE/OmCU[?oDiFeoeBE]OmEU;GoEIBcoe>C
[_mBTZ_oEYVdoe6F/`;oDYVg00CoCYFcoe:E/_mDUK7oEIF`0_mGUJh01OmEUK3oE9J`oe>F/Om>Uk[o
0U>200ko05>900Go1e62oaI;MOm>L8_olooooo_jo`01of]VNP0005coIVYeooOkoonYYkcoJVUkomKF
g_oHf]WoeM[DolSOiolBCGWo0U6<o`9AR_l0DhOo05B2o`1DPol0DhWo0E::o`9>R?l5E8co05>:o`1C
ROl0E8So05F5o`EFQOl5D7[o3Diho`=<Ool0F9oo04ZEo`1AR_l3Ch3o3eb8o`EAP_l>F9Oo04B4o`9G
S_l0EX;o0eMio`IFMol3D7[o462Eo`=JWOl0CYGo0EVIo`5CRol0AG;o2E9mo`ADQol1DXWo1eB<o`1=
Q_l0A8?o05NEo`1?SOl0Agoo2eJ0o`iGR_l0AYKo0E>Uo`1FU?l0Ch;o05R<o`ANTol0C8Oo356<oa1?
Q?l0BGko04j>o`1IVOl0EH_o1565o`=:P_l@EHco14^1o`19P?l0CX[o05J?o`1CP_l8FHKo15N9o`1>
Q?l0EHgo05B:o`5CQOl4DGgoCiRkoe>E]OmDU[3oEIF^oeBF[_mDU[3oDiJaoe>F/`;oDiFe01?oE9Fe
oeFE/OmJUZkoEY:ZoeJF[om>Sj_oC96^odjC/_mDVKSoFYfjoeBE/OmEUK3oEiB`oeNE[_mEUK3oE9Fa
oe>F/om>Uk[o0U>200ko05>900Go1e62oaI;MOm>L8_olooooo_jo`01of]VNP0005SoIVYeooOkoonY
YkcoJVUkomKFg_oHf]WoeM[DolSOiolBCGWo0U6<o`9AR_l0DhOo05B2o`1DPol0DhWo0U69o`QAQ_l5
Ch3o04eno`=FR?l0F8[o0522o`1APol6Dh7o6ER1o`I8N?l1EYKo1V2Oo`UEROl3Bg_o0e>4o`1AQol0
CHSo05VEo`1<R?l7G9?o14imo`5;N?l0D8Go0529o`1ETol0F9So05B>o`19OolJIiGo04]lo`EIUOl0
DY7o056:o`=CQ_l=F83o2eZ3o`1ISOl1Gi?o0UAjo`1=Mol9FISo04V:o`=OT?l0GHSo05f>o`1FROl0
BG[o2E1lo`YHO_l1F8Go056Do`1HW_l0CHWo0525o`iQTol0AWGo45R:o`E>QOl9G9ko04nAo`5<Pol5
CGoo1Dj1o`UFS?l0E8go05>:o`5CQOl4DGgoCiRkoe>E]OmDUK7oEIF`0_mDU[002omCU[7oDINaoe>F
/omCU[?oE9FcoeND/?mJTZWoHYV^oebF[_mLVKGoFIZf00;oDIBa00?oCi:_oeBE/OmEUK000_mGU;00
1OmEUK7oE9Faoe>F/om>Uk[o0U>200ko05>900Go1e62oaI;MOm>L8_olooooo_jo`01of]VNP0005[o
IVYeooOkoonYYkcoJVUkomKFg_oHf]WoeM[DolSOiolBCGWo0U6<o`9AR_l0DhOo05B2o`1DPol0DhWo
0E::o`9BQol6DXCo2eB1o`YDPOl7EH?o0eJ8o`1ERol0DhWo1Deoo`E<P?l0BHGo1EB<o`a7KolHCW3o
34abo`aAN_l7D7Wo259oo`ICROl5C83o4DafoaECO?l6EXOo0525o`1HR?l0D7ko3ER2o`i?Mol9@FKo
5eEno`13N?l3F97o0Tn3o`M:M?lIDF[o1T9Jo`=FO_l0D7_o0di^o`i@L?l>CGSo2dmlo`1BN?l0CW7o
055fo`QDN?lJDWGo64i`o`E7Iol4Dgco1ebLo`1BUOlBFi;o24]ho`M8K_lEE7Go4d]^o`e8M?l8D8_o
0e6Aoa1GSOl9DH?o04Mjo`=CQ_l1Dh_o05::o`9BQOl6D7goDINkoe>E]OmDUK7oEIF`oeBF/?mCU[02
oe6G/@;oDiJc00[oE9FcoeNE[_mHS:7oJIb_odImT_mESjOoFYNcoeFF]?mGV;KoDiBb0_mEUK401omG
U;3oEIF`oeBE/OmCU[?oDiFeodjF_?l2DX<03_l0DhT01Ol7DH;o5T]eodi`Roocoooono[o007oJfIj
0000F_mVJWGomo_oojVW_?mZJG_oe]KNomSJfOoEf]Cob=oWoa9=NOl2DHco0U6:o`1CQol0E8;o05B3
o`1CROl0Dhko05BCo`1AR_l=DW_obooool[oool9E7ko05>>o`1EVOl0CXko36JUo`1?Sol4B7WoR:c2
onKlooo[ooooeO;oohRV/OoSoooo_>kooaA6JooNoooogOooo`iDM_l;E7Oo5d]Qok3EiooQo?ookooo
oo7oooo7i_[o4U9eo`UBNolFBgGoT;OFonOooooVoooo]N_ooaQEL_n?`]gogoooonSooooCm_oo44aX
oaQHLonXeNSohOooomcbooo]oooob>KooaU:Lol3D8So04UooebA^ooBm?ool?oooo;ooooCjOCoS[O9
o`M;L_l0AWOo1Dn0o`]IROl0Dh?o05J7o`1ERol1DX[o1565o`I@OOmAU[goDiFgoeBE/OmEUK3oE9J`
oe>F/0;oDINa0_mCU[402_mDUK7oF9B/om_ooooKooooK9ndof>I/OmHU:koDi2]oeJG]OmDUK<4oeFE
/@05oeBE/omCU[?oDiFeodjF_?l2DX<03_l0DhT01Ol7DH;o5T]eodi`Roocoooono[o007oJfIj0000
4omVJWGomo_oojVW_?mZJG_oe]KNomSJfOoEf]Cob=oWoa9=NOl2DHco0U6:o`1CQol0E8;o05B3o`1C
ROl0Dhko05BCo`1DR_lAD7<00_oHool0@ol@D7Ko05B=o`1FUol0E9Co05>?o`1=Q_lGDGWog_Kooo?n
ooo^oooolOooon_dnOoaoooo43eLoae;K?oZooooi?ooo`U;KOlADGCoW;c;ooCooooeo_oonOooooco
oooXo?oo`ocoo`Y;LOlRC7Cog__oongooooPoOoo`_Cooa95H_oVooooj?ooongoooo9j?go6di[ohZj
dOo`oooonOooooSoooodooook_oool;ZoolBF8Wo2E61olWjoooUoooonOooooOhoOohooooa^Kcoa1B
MOl9Fh[o04mno`1@P?l0D8;o05R<o`1DRol1DXWo1565o`M@OOmAU[goDiFgoeBE/OmDU[000_mCU[02
oe6G/@0<oe>F/OmDU[3oEIF`oeZDZ_oMooooh?oooe^:W?mLT:KoG9B]oeND/?mIVKGoDI:`1?mEUK42
oeBE/`03oe>E]om>U[co0U:300ko05>900Go1e62oaI;MOm>L8_olooooo_jo`01of]VNP0001?oIVYe
ooOkoonYYkcoJVUkomKFg_oHf]WoeM[DolSOiolBCGWo0U6<o`9AR_l0DhOo05B2o`1DPol0DhWo05::
o`1?Q?l>EH7o4dIS00;ogooo05?o4TMWo`iHQol4E8Wo2520o`mBOOl>CGSo64UYonOnooo`ooooNIjh
oibofoodooook?oooaIANol;Bg7oi_ooon?oool;Cgko4E>5omG[ooogooooTJ_4obe9HOleAe?o8ci?
oaI>Lol=Bg[o7DQeon7ooooPoooo54EUo`]>NOlGDGKoj__oooCooolUCG3o2D=[oa1<LOoAoOoomOoo
ojJWZole@E_o9SeLobA5E_lLBV7o2diho`aCOolGDW3o7DYOobU6E?laAE3ol_ooonOoool7BG_o0EJ?
o`1ERol0D8Go1dn9o`Q>R_l3DXgo0E:9o`EAQOl7D7goDIJmoe>E]omDUK?oE9Faoe6D[_m@TjgoFIbg
oe:E/?mLW[SoC8jXoejN^OmESJCoHXfMofZ?WomYU:GoGXjToe^C[?mCSj_oE9B`oeRI]`02oeBE/@;o
EIFa0_mDUK<00omCUKOoCYJlo`9BP`0>o`1CR@05o`MAP_lFBgGoCW2;oo?ooookn_l00Om[IWX0000o
ofIZMOognoooZJNlofYYNooFe]kof=[IomGJe?o8gnOo4Teio`9AS?l2DH[o05>7o`1DP_l0E8?o05>9
o`5BROl;FHWo34ecoam=IooTooooioooobA8G_l>@fGo5e5foa98J_lLDWCo4DmfoaU?LOnP`mOoi_oo
oj[Hn_moYl[okO[oon_ooolDE8;o3E1jon[ooooYoooo24Yno`]9P_o`oooon?ooonKooooNooooi?[o
on[ooooEoooo4deoob5;NooNooood_oooa5?M?l5EHKo1TE^ooOooooanOoo4dYco`aER?lFEH3odogo
ooOoooolooook_oo00;oi_oo02OogOoooaIDNOl3AW7o241QojkPnOo8lOoofoooon;oooo<n?oo1Tj8
o`1AT?l2Ei3o04Ino`QCSOl4CX_o0U:=o`5BROl5DH?o1e1moe6F_OmAU[OoDiJcoeBE/OmHVkGoCY6[
oeFH/om>T:[oD9:/oeBD[OmJV;7oGYFZon;ooooKooooIXnQofJEZOmDRZ;oIZ:nodj>Z_m@TJl00_mD
UK42oeFE/@;oE9Fc00?oE9Feoe2E_?l4DX<03_l0DhT01Ol7DH;o5T]eodi`Roocoooono[o007oJfIj
0000F_mVJWGomo_oojVW_?mZJG_oe]KNomSJfOoEf]Cob=oWoa9=NOl2DHco0U6:o`1CQol0E8;o05B3
o`1CROl1DXWo1UB5o`U=M?lLBfOoi_oooo;oooodooook_ooon;oooo3j?_o85=bo`18Mol4D87o6e5e
oh2]c?nXe_Soeo_oooGoooo^oooo44]eo`m6KoogoooomOoooa9;P?l=B83olOoooo;ioooVooooiooo
oo;ooooYooood?gooa97NOlIAG;og?ooom;ooolBDg?o0ER5o`U=M?o_n?oon?ooo`m>Mol0CX3o3e1f
omgoooo[oOool_ooonOooooPooooj_ooomKgool?AF_o75F2okgYooo>mOoogoooolKeoonWh?go1dac
o`1ET?l0E9Go04b9o`EJTOl0FXoo05B8o`1ESOl1DXWo15:3o`I@OOm?UkgoDIJgoe>F/omCU[7oD9>]
odZ=Y`;oFifg00coE9B_oefK]?mCSJGoG8nTolKZn_oWoooo`^Wjof2?XomHSZKoH9bhod^<Z?mGV[L2
oe>F/@;oE9J`00GoEIFaoeBE/omDUKGoD9Flo`ABP`0>o`1CR@05o`MAP_lFBgGoCW2;oo?ooookn_l0
0Om[IWX0001XofIZMOognoooZJNlofYYNooFe]kof=[IomGJe?o8gnOo4Teio`9AS?l2DH[o05>7o`1D
P_l0E8?o05>9o`5BROl3DH;o34mioae?L?oSoooojooooo?oooobooook_ooonWooon]go[o04Yko`aM
T_l=Afco74QSoc1BJon<Xk?ol_cnonGioolJCgWo74eeoo_oooofoooo44YjoaIDQooLlOoonOoooiBW
]_lnDF3oWJN`onkoooo5mOoo3TA`oae3J?oTooooh_oooaQ<HOl@EGKo759^oocnoooknooo6T]Yoa=G
O?l?AfSocoSooo;ooonKZJ[o<DaOoi:bbooVooooc?3ooa]AMolEC7Gog?ooonKooomeUk3o7TIOoaU=
Hol6AfOo0563o`MLUOl7E8[o0526o`1HSOl0FI3o05J=o`5BROl4DX?o1U1modnG_Om@UkOoDIJcoe>F
/OmKW[SoCi:/oe6C[OmATJcoDi6ZoeVE[OmNUZgoI9BXog2DX_oBl_oogOoook?PmOmISjOoEiB`oeRI
]OmAU;42oe>F/@;oE9J`0_mEUK400omDUK?oD9Jjo`ABPP0>o`1CR@05o`MAP_lFBgGoCW2;oo?ooook
n_l00Om[IWX0000fofIZMOognoooZJNlofYYNooFe]kof=[IomGJe?o8gnOo4Teio`9AS?l2DH[o05>7
o`1DP_l0E8?o05>9o`9AROl;Dh?o14MaoaQCOOoFoooogOooobI9IolK?ESoT;37om[moooIoooo2UB1
o`M@NooBooooj?ooooOoooo_loKoo?ooom__n_lLD7So6TaaooCoooo`oooo24aao`]BO_nN_]?ol?[o
oo_nooobmOool?Koon?noomj^MSo3di]oncoooofo?oomoooon_ooooVooooio_o0_oon_l0<_odo_oo
iooooam4GonN_=ConoooooKfm_oaoOooj_ooomoooon4^mWo24U_oaACM?oEooooi_oooo7oooocoooo
l?koonGoool;@F?o0d]co`I?N?l;G8_o052<o`1EU?l0E8oo05>9o`9BPol4DG_oCYRmoe2G]omAU[?o
DiJaoe:E/?mAU:ooD9:/oeBD[omPW;KoCHNOofJL]?mMS:3oJhbKofR8UOoSoooogOooof6G[omHUK7o
CXn[oe>H]OmAUk7oDiJa0_mDU[001OmEUK3oEIFaoeFE/OmAUKSo15:200ko05>900Go1e62oaI;MOm>
L8_olooooo_jo`01of]VNP0006SoIVYeooOkoonYYkcoJVUkomKFg_oHf]WoeM[DolSOiolBCGWo0U6<
o`9AR_l0DhOo05B2o`1DPol0DhWo0E:9o`aHROl;Cgco4Teiom;ooooGoooo;Di]obe8HonI]L_oiooo
omcoool0B7?o2E>0ogJX`ooGm_ooj_gooo;oooo8g^_oSK79o`Q7L_l<AVcok_ooon_oool=Cg;o1U1m
oaA6IonP_mcogo;oonSioooZooooV<COo`Q=K?lBDVkojoooooSoooobo_kol_ooon_oooo`oooon_;o
ooohoooboooohoooob=<J_lL@f;oXKS6oo7ooooVooood_[oohBjg?l@E7Wo14mio`Y@M?mi[;ood_So
onGoooo]oooofnkmohVX_OlJD7;o45Elo`18K_l;F8Co04R6o`1FVOl0E8oo05B7o`9BPol4DG_oCYRm
oe2G]omAU[?oDiJaodnB[OmHVkKoE9B_oe:@ZOmQV[GoI9bcolGioooMooooYlSGokCDhOoKoooob?Oo
oeB<XomDU:ooDYF`oe:G]0;oDINa00OoDiJ`oeBF/?mEUK3oEIF`oeFE/OmAUKSo15:200ko05>900Go
1e62oaI;MOm>L8_olooooo_jo`01of]VNP00037oIVYeooOkoonYYkcoJVUkomKFg_oHf]WoeM[DolSO
iolBCGWo0U6<o`9AR_l0DhOo05B2o`1DPol0DhWo05:<o`17P?l7D8?o5d]conCoooodoooom_[oooGh
ooohoooolOoool3[o_l8EH7o0566o`eDP?l?CGKo4D]io`a6M?lFDgoo3UF1o`1AQol=EWooi_ooonGo
oolABg3o35F:o`aGT?l4CHCo2Tioo`Y=N_l4BgGo251ho`E9K_lGDgGo5T9M00;ohooo03ko5dMAo`Q:
H_lJCfkom?oooo3nool>C77o15F0o`M>N_l?DWco5EIlo`96Jol5CGGo45V2oa=JQ?l0A77o1UN<o`9?
Pol;BW?o4TiboaUJQ?l2Ag7o1dafo`18MOl4EXSo04]mo`iGQ?l3D7ko05RAo`1ASOl0EXgo05B7o`5C
Pol3DW_oCYRmoe2F^?mAU[GoDIJcodjA[?mJWKSoFi^foeVG/?mFSj[oEhfUoj3BjOo4koooi_ooon?o
oooGo_ooHi:VoejF[OmJV[GoEYVdodV@[?m@V;7oDINaoe>F/?mDUZkoEIF^oeNE[_mGU;3oDiFgo`AB
PPko05>900Go1e62oaI;MOm>L8_olooooo_jo`01of]VNP0000coIVYfooSjoonYZ;[oJVUgomKFg_oH
fM_oeM[FolSNjOlBCGWo0U6<o`5BR_l0DhT2o`1DQ@07o`1CR_l0DXko05VEo`5@R?lCC7OogoooonOm
o`02ooCoo`0`oo3oooo7i_So6di[o`=CQ?l0FiCo04j5o`1>Q_l:FYOo05:>o`1BR_l0BH;o05VCo`1A
P?oHoooogooooa=@O?l0C8Co04nBo`1DU?l0FI;o05B9o`1FRol0DH;o3EJ3o`Y;LolBD7GoNkSGokSe
oolDFW?o055ho`E@N_n:[M?ocOCoo`1DR_l0EHgo1ebBo`16N?l3Fhgo05F8o`1FRol0Ch?o04ioo`YG
Rol0DX_o056;o`QAQ_l5CX7o04Z10_l0FI807ol0EHko052;o`9HTOl6DXCo0U21o`1CROl0FI?o05J=
o`1CROl1Dh?o0e9modfH_om>Uk[oD9Neoe6F/omJWKSoDI>]odb<YomIUk3oG9F`oe^C[?mPUZkoHI6W
ofB=WomVT:3oG8^MoenCZOmETJWoCHnYoeJL]_m@Uk<00_mAUk400omCU[3oE9J^oeFE/002oeFE/00E
oe6E^?l4DX;o05>9o`1BR_l0DhWo05::o`1CROl0DX[o05>9o`1BR_l0DhWo05::o`1CROl0DX[o05>9
o`1BR_l7D8?o5T]eodi`Roocoooono[o007oKFEj00002omWJGSon?[oojVY]Om[JGCoe]KNomSIgOoE
fM[ob=k[oa9=Mol2DH[o05::00?o05><0ol0Dhh01?l0DX[o1E65o`U?P?l>CWX2oa1=N@05o`m>NOl<
Cg[o1e60o`1CROl0Dh`00_l0DXX03?l0DXco05><o`1CS?l0Dhco05B>o`1CROl8DGko2E1no`AAQOl0
DX[o05>@o`1DT0?o05><01Go05>:o`5BQol4DHGo15:3o`EAP_l5DX3o0U>2o`1DQol1DXOo2dj2o`U?
Pol0Dh[o05F>o`1CR_l0DX[o05>:o`1DR_l0Dhco05B:o`1CROl0DXX00_l0Dh`00ol1DX[o0E:9o`1C
S003o`1CS00@o`1CS_l0Dhco0E:9o`1CROl0Dhco05B>o`1DSol0Dhco05:6o`IGQ_m7U;koCiVnoe2G
]om@U[3oDiJ`oeBF[P;oEIF^0_mEUK001omGU;7oEiB`oeZD[?mJU:coF9B/oeNE[_mDU[000_mCU[40
1OmAUk7oDiJaoe>F/OmCU[7oDiJ`00?oE9Fa01GoD9Jho`9BPol0Dh[o05><o`1CR_l0Dhco05>:o`1C
S?l0Dh[o05><o`1CR_l0Dhco05>:o`1CS?l0Dh[o05><o`M@PolFBgGoD6n;ooGooookn_l00Om]IGX0
000<ofMXN_ohn_ooZJVeof]ZL_oFemcof=WMomGIf_o8g^co4Tego`9AROl1DX[o05>:1?l0Dha0o`1B
RP09o`1>R_l0D8Wo04n4o`9CP_m<Ul7oD9RnoeBI^?mGV[GoDiF]00?oE9B]01GoE9B_oe>D/?mCU;;o
DYFboe>D/?mBUK3oDiB`oe:E/?mCU;3oDYF`oe>D/?mBUK3oDiB`oe:E/?mCU;3oDYF`oe>D/?mBUK3o
DiB`odnE]ol4DX<03_l0DXX01Ol7D8?o5dYeoe1_Rooeooooo?Wo007oKFEj00003omVJGcomo[oojVX
]_mZJWCoe]KNomSIgOoGf=[ob=k[oa==MOl4DHOo0U:7o`5BQol1DXWo05>9o`5BR@11o`9BQ`09o`AE
SOl5EXgo1eF6o`9?Nom?VL3oCI>eodjA[_mATjgoE9F[00;oEYB[01KoE9B]oeBD[omDU;3oE9>boe>D
/_mDU;3oDiF_oeBD[omCUJooE9B_oe>E[omDU:ooDiF_oeBD[omCUJooE9B_oe>E[omDU:ooDiF_oeBD
[om@UKKo1E:03_l2DXL01Ol9Ch3o5dYeoe1_Rooeooooo?Wo007oKFEj00002OmTJGcomO_oojNY]_mZ
JWCoe]KNomSIgOoGf=[ob]g[oa==L`02o`EAQ@03o`AAQOl2DXGo0U:500;o1565@?l2DXL03_l2ChGo
1E63o`I@Ool3C7OoEY_2oe:G^?mEU[;oF9RaoeRF[OmHUZ_oF9J]oeRF[omHUK7oEYJb0_mFUK@04OmF
U[;oEYJaoeRE/OmFU[7oF9FaoeJF/OmHUK7oEYJaoeRE/OmFU[7oF9FaoeJF/OmHUK7oEYJaoeRE/OmD
U[So1E:000ko0U:700Go2Dn2oaM:MOm@Kh_omOoooocio`01ofeUNP0000WoHfYmooGjoonWZKKoJ6]d
omKFg_oHfMgoemSJol[MjolEC7<00_l5DH<3o`ABP`03o`EAP_l4DX?o0E:903ko05><00oo0E:9o`IB
Q?l9DH7o2E1lo`U>MomBU[_oDiBdoe:B[_mETjcoEI>ZoeJBZ_mFTZcoEI>/oeFB[_mETZl00_mCT[42
oeFB[`0?oeJA[omETZooEY6_oeFB[omFTJooEI:_oeJA[omETZooEY6_oeFB[omFTJooEI:_oeJA[omA
TkKo15:300ko05><00Go1e25oaI;MOm@Kh_omOoooocio`01ofeUNP0000WoI6UmooGkoonWZKKoJ6]d
omKFg_oHfMgoemSJol[MjolEC7<00_l5DH<0COl4DX?o0U:5o`9BQOl4DX?o0U:5o`1BR_l0Dhco05>>
o`1CS?l0Dhko05><o`1CS_l0Dhco05>>o`1CS?l0Dhko05><o`1CS_l0Dhco05>>o`1CS?l0Dhko05><
o`1CS_l0Dhco05>>o`1CS?l0Dhko05><o`1CS_l0Dhco05>>o`1CS?l0Dhko05><o`1CS_l0Dhco05>>
o`1CS?l0Dhko05><o`1CS_l0Dhco05>>o`1CS?l0Dhko05><o`1CS_l0Dhco05>>o`1CS?l0Dhko05><
o`1CS_l0Dhco05>>o`1CS?l0Dhko05><o`1CS_l0Dhco05>>o`1CS?l0Dhko05><o`1CS_l0Dhco05>>
o`1BR_l0ChCo1E63o`MDP_l@FXOoB8nioe6F_OmDV;_oEibk00;oEYRh00CoEYRjoeBI^_mDV;_oDiVm
0_mCV;l09?mDV;goEYRkoeJG_OmFV;_oEYNmoeJH^omFUkgoEYRkoeJG_OmFV;_oEYNmoeJH^omFUkgo
EYRkoeJG_OmAV<;o0E:7o`1CS?l0Dhko05><o`1CS_l0Dhco05>>o`1CS?l0Dhko05><o`1CS_l0Dhco
05>>o`1CS?l0Dhko1E65oaI;MOm@Kh_omOoooocio`7oKFEj00003?mVJGcomo[oojNY]OmZJWCoe]KN
omSIgOoEfM[ob=k[oa==MOl4DHOo0U:7o`5BQ`;o05>90_l1DXL2o`1CRP0lo`1CS?l0Dh[o05><o`1C
R_l0Dhco05>:o`1CS?l0Dh[o05><o`1CR_l0Dhco05>:o`1CS?l0Dh[o05><o`1CR_l0Dhco05>:o`1C
S?l0Dh[o05><o`1CR_l0Dhco05>:o`1CS?l0Dh[o05><o`1CR_l0Dhco05>:o`1CS?l0Dh[o05><o`1C
R_l0Dhco05>:o`1CS?l0Dh[o05><o`1CR_l0Dhco05>:o`1CS?l0Dh[o05><o`1CR_l0Dhco05>:o`1C
S?l0Dh[o05><o`1CR_l0Dhco05>:o`1CS?l0Dh[o05><o`1CR_l0Dhco05>:0_l0Dh`02?l0EI7o05JB
o`1@R_l0CH?o0eR>o`9EQol0Cgko055m0_l0DWh00ol0DH3o05:1o`1AP`03o`1BQ@0>o`1APol0DH7o
0563o`1APOl0DH?o0561o`1APol0DH7o0563o`1APOl0DH?o0561o`1APol0DH42o`1AP`;o05>:01;o
05><o`1CR_l0Dhco05>:o`1CS?l0Dh[o05><o`1CR_l0Dhco05>:o`1CS?l0Dh[o05><o`M@PolFBgGo
D6n;ooGoooolnOl1ofeUNP0000coIfUhooSjoonYZK?oJVYbomKGg?oHfMgoeMWLolSNk?lBCGOo0U69
o`5BR_l0DhX3o`1CS01;o`1CR_l0DhWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo
0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo
05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo
0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo
05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0Dh[o056?o`1EU?l0EY?o05NCo`1BS?l0E8co
05>8o`5HSOl0E8Wo05F900;o05F:00Go05F<o`1ES_l0EHko05F>o`1DS00>o`1CS00Eo`1DR_l0DhWo
05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl0DhWo0E:9o`1CROl1DXWo05>9o`5BROl8D8;o
5dYeoe1_Rooeooooo?Wo007oKFEj00003OmYJ7Kon_[oojZY/Om[JW3oemKLomSIgOoEfMcoamk^oa1=
NOl1DHco05:>o`1DT?l0E9800_l0EI80@_l0E8ko0U:7o`ABPol5DH?o15:3o`EAPol4DX?o1E63o`AB
Pol5DH?o15:3o`EAPol4DX?o1E63o`ABPol5DH?o15:3o`EAPol4DX?o1E63o`ABPol5DH?o15:3o`EA
Pol4DX?o1E63o`ABPol5DH?o15:3o`EAPol4DX?o1E63o`ABPol5DH?o15:3o`EAPol4DX?o1E63o`AB
Pol5DH?o15:3o`EAPol4DX?o1E63o`ABPol5DH?o15:3o`EAPol4DX?o1E63o`ABPol5DH?o15:3o`EA
Pol4DX?o1E63o`ABPol5DH?o15:3o`EAPol4DX?o1E63o`ABPol5DH?o0U:7o`1CS0;o05>>00Co05><
o`1CR_l0DhWo05>90ol0E8L00ol0DhWo05B:o`1DRP02o`1DS0;o05><3_l0DhX05Ol0DhWo0U:5o`AB
Pol5DH?o15:3o`EAPol4DX?o1E63o`ABPol4D8;o0Dn0o`A@P_l9EhSo1e>5o`1=O_l8E8Ko3U:1oaA8
L?mJNIGomoooooSeo001ofaTN@0000coJFUeoo[joon[Z;7oK6U`omOFfooIf=goemSLolONk_l?C7So
056;o`1BSOl0Dhl3o`1CTP03o`1CSol0DHSo0e2403go0e2400Co0E66o`1AR?l0DXSo05680ol0DHH4
o`1BQ003o`1AQ_l0DXKo05:800?o05:83ol0DHP00ol1DHKo0E64o`=@Q006o`=@Q00<o`ICQol9EX[o
0e24o`AAQOl0B7co3EZ>o`1<P?l3AgSo64adodASOoo_nOooooco0OmbJWl0000=ofUYMOojn_ooZjRa
ofaYL?oGe]_ofMWKomOHf_o8g^co4diho`9CRol0E8go05B?o`1ET@02o`1ET`03o`1ETOl0E8oo05B=
03go05B=00Co0E>;o`=CQ_l5DhCo1U:41_l6DX<01Ol5Dh?o1E>4o`ECQ?l5DhCo0e>400?o1E>43_l6
DX@00ol3DhKo0E>;o`1DS@06o`1DS@0<o`=IT_l0DX_o0URAo`1>Qol0E8go05F>o`1AR_l>FXko8UN1
oda[QoogoooooO[o0OmWGg@0000<ofMYM_ojn_ooZZVaof]ZL?oGe]_ofMWKomSHf?o:gN_o4Tado`=@
Q_l1DHKo05680_l0DXT00ol0DHWo05:9o`1BS@0no`1CS@04o`1BRol1DHCo0e62o`A@PPOo0e620ol3
D8@00ol3DH;o0e24o`=@Q00?o`=@Q003o`5AQ_l0DX_o05>=00Ko05>=00co04n9o`1@R_l0DXco05F?
o`9KUOl0DXco04f7o`9?QOl?A73oBfZ6ooKoooooo?l1ofmWO00000WoIVUhooOkoonYZK?oJfYbomOF
fooJf=WofMSFolcMiolHC7400_l9DH401_l8DX7o25:3o`QBPOl9DH7o1U:3o`5DRSko05B=00Go05B;
o`5DR_l1E8[o0U>:o`5DRP09o`5CR`03o`5DR_l1Dh_o0E>;00oo0E>;00?o05B;o`1DSOl0E8d01_l0
E8d03?l1Ei3o2f6Jo`16Ool0E8go04^4o`=IT_l0E8go04]ooaQ=MomHMi?okOOooogjo`7oN7250000
2_mSJWcomO_oojNY]_mZJW;oemKKom[HfOoKemCocmcToa]<K?l?Cg/3o`m@NP04o`m@N?l@D7Ko3e1h
o`YAOD7o25:10_l8DX<8o`IBQ0Co25:33ol6DX@00ol6DX?o25:3o`QBP@06o`QBP@03o`E?O_l2C7_o
25:100;o2eF400Oo04Uho`iHQol?DWgo4D9[oeYiUOogoooomoCk007oJf=h00004?mRJWoom?_oojJY
^?mXJgCoemKKomcHfOoLem?odMcPoai:IolBCGGo4deboa=>L?lECG3o5Ta^oaM<JolIC6]2oaM<J`;o
5da/0_lFC6h4oaI<L0;o5da^0_lIBf`00olIC6_o5da/oaI<KP0>oaI<KP03oaI=K?lGC6co5da[00Ko
5da[00Go6Di]o`]0GolWG7_o54UXo`i3HP02oaeBL@05oa95I?lWDgSo@V5mooOooookn?l00OmWGg@0
001@of9ZOoodnoooY:ZhofQ[M?oGe]cof]SIom_Ge?oCfmko00LKo`099Ol02R;o00XPo`098?l02Ako
00PNo`086ol021Wo00PGo`076Ol021Oo00LIo`085ol01aWo00PGo`076Ol021Oo00LIo`085ol01aWo
00PGo`076Ol021Oo00LIo`085ol01aWo00PGo`076Ol021Oo00LIo`085ol01aWo00PGo`076Ol021Oo
00LIo`085ol01aWo00PGo`076Ol021Oo00LIo`085ol01aWo00PGo`076Ol021Oo00LIo`085ol01aWo
00PGo`076Ol021Oo00LIo`085ol01aWo00PGo`076Ol021Oo00LIo`085ol01aWo00PGo`076Ol021Oo
00LIo`085ol01aWo00PGo`076Ol021L4o`076@;o00PK1?l01a`2o`076`Co00LI4?l021/05?l01aWo
00PGo`076Ol021Oo00LIo`085ol01aWo00PGo`076Ol02QWo00LIo`085ol03b7o_=c[ol?Rm?o0hOCo
_=_goeeeSOoco?ooooko0OmWHWH00009ofAZN_oenoooYZZfofQ[M?oFemcofMSMomWGf?oHfM_o0089
00;o00<;00?o00TAo`032ol01Ph00_l00`/0@Ol010[o00<7o`0:4?l00`Oo00H<o`8=4Ol00`Wo00<7
o`032Ol02`oo00<9o`052Ol00`Wo00@8o`063?l010So00D;o`042?l00`Wo00L;o`032Ol010So00D;
o`031ol00`Wo00L;o`032Ol020co00<9o`031ol010[o00<7o`032Ol00`Oo00<9o`062_l010[o00L;
o`032Ol00`Oo00D;o`031ol00`Wo0@`@o`032Ol00`Oo00X@o`031ol01Pco00<7o`052ol01@Wo00<9
o`0;3ol00`Wo00<7o`083_l00`Oo00P>o`042?l00`Wo00P<o`032Ol23A7o00@:00;o00<900?o00T?
o`032Ol02Q001Ol00`T01?l02a7o00<9o`032Ol43A@Bo`032@0Co`031ol00`Wo00<7o`032Ol00`Oo
00<9o`031ol00`Wo00D9o`032Ol00`Oo00/AolcGfooBgN?odM_Tom7KiomQJGKon_cooo[jo`01ofQU
MP0000[oIVUhooOkoonWZKKoJ6]domKFg_oHfMgof=SJomWIfOl1003o5A@B0_l000001?l410Co0@41
o`000_l720X2o`000006o`820_l0003o0000o`000?l20P;o20P80ol000000ol410Co1@D5o`820P03
o`00000Ao`D51Ol0003o10@4o`<30ol0003o1PH6o`000?l30`?o0000o`T92Ol30`?o0000o`820_l6
1PKo0000o`@41?l20P800_l000002Ol:2P[o0000o`000?l51@Go0@41o`D51Ol61PKo0000o`820P02
o`000005o`L71ol0003o0000o`000?l20P800ol000000ol30`?o0000o`000002o`00000Do``<3?l0
003o1@D5o`000?l820So0`<3o`000?l71`Oo0000o`<30ol0003o0P82o`L71oo:b/[ohN7QomGEeOoP
h>3oeMGEom3@d?oLg=`HomWIf@05omcLg?o>c/koj^[ZomOGeoo@d=000_oOgml01OoCdmGof=WNofMW
Koolo?oon_Wo007oIfIf00003?mVJGSomo_oojNY]_mXJgCoe]KNomSIgOoHf=[ofMWIo`<20?l;2PSo
0000o`X:20;o000000Co1`P:o`000_l71`Oo0P820_l30`<01ol410Co0000o`d=3Ol0003o0`<3o`/;
2ol820P01Ol000002_l820So0000o`L71ol10@7o0000o`L71ol10@7o0`<3o`000?l92@T3o`000003
o`H61_l0003o000000Co000000?o0P82o`000?l61PH01?l000001?l410Co0000o`000?l410@2o`00
0006oa0@4?l0003o0000o`H61_l10@7o0P820ol000001?l410Co2`/;o`000?l410@5o`00000=o`L7
1ol20P;o0000o`000?l10@7o0000on3Ph?oIfMWoe=CDon3Ph?oIfMWogMgMom_Kf`0HomSHf003omGE
eOoBd];of=SH00;ofm_K00Ooclo?omkNg_oKfmgof=WNofMWKoolo?oon_Wo007oIfIf00005omVJGSo
mo_oojNY]_mXJgCoe]KNomSIgOoHf=[ofMWIo`<20?l81`Go0000o`D50ol20P;o0000o`000_l10PCo
0@41o`000?l410Co0000o`D51Ol0003o0@4100Co000000Co20P8o`000?l0003o2@T90_l000001Ol<
30co10@4o`000?l20P;o0@4100;o00000_l20P801ol61PKo0000o`<30ol0003o10@4o`X:2_l61PH0
0_l000001?l61PKo0000o`@41?l71`L2o`000006o`D51Ol410Co0000o`T92Ol0003o2PX:0ol00000
2ol61PKo0P82o`000?l0003o10@4o`820_l0003o1`L7o`410Ol0003o10@400;o1`L700Go0000o`D5
1Ol:2P[o0000o`410@02o`00000:o`<30ol51@Go20P8omSHf?oAdM7oh^;Rom7AdOo?cloogmoOomCD
e1Sofm_K00cog]kNonSXj?o=cLgofm_Kom?CdooPh>3og=cLomGEeooHfMkoIfM_ooclooojnOl1ofMV
MP0001;oIVUhooOkoonWZKKoJ6]domKFg_oHfMgof=SJomWIfOl40`7o0@00o`@40_l20P3o0000o``<
3?l10PCo0002o`000?l820P3o`000008o`H61_l0003o1PH6o`000?l61PKo<30`oclo?olB4Q82o`00
0005o`@41?l0003o0000o`000?l61PH00_l000002?l20P;o1@D5o`410Ol0003o1`L7o`P82?l^;Rko
=cLg1?l000000ol92@Wo0@41o`000002o`00000:o`P82?l0003o0000o`000?l61PKo0000od10@?l_
;boo0000o`/;2`;o000000?o30`<obd];Ola<C400_l000002?l10@7o0000o`000?l71`Oo0000oaLG
5olM7Ago10@40_l000001Ol10@7o0P82o`000?l0003o10@400;o000000Oog=cLom[Jf_oOgmoof][J
on7QhOoIfMWofm_K01Sof=SH00coe=CDomKFe_oGemOof][Jon3Ph?oHf=Sod];BomOGfOoHfMkoIfM_
ooclooojnOl1ofMVMP0000[oIVUhooOkoonWZKKoJ6]domKFg_oHfMgof=SJomWIfOl20@3o2PT70_l1
0@00>?l92@Wo0000o`000_nKW9koooooofe]KOl0003o0@41oa0@4?l0003oooooooclo?l?3`ooM7Ad
ooOgmooooooooOgmoh^;Rol0003o30`<oooooonl_;co0000olC4a?oooooo0@41o`000?oHf=Sooooo
o`000?l;2`_od=3@ooooooofm_Kofm_KoeYJF_l0003oQHF5ooShn?m3@d?o0000o`H61_l820So3`l?
ooooool^;Rko0000oaHF5_o>c/kon?ShoooooooQhN7o<c<co`410OlH61Soa/K60_ooool02ooPh>3o
;Rh^o`000?mLG5cogmoOo`000?mlO7coooooon?ShonJVY[o2`/;00;o000000go0@41o`820_l20P;o
0P82o`000?l410CogMgMomGEeOo@d=3oe=CDon3Ph?o?cloof=SH01SofMWI00cogMgMomOGeooLg=co
dm?ComSHf?oIfMWoeMGEon7QhooHfMkoIfM_ooclooojnOl1ofMVMP0000_oIVUhooOkoonWZKKoJ6]d
omKFg_oHfMgof=SJomWIfOl1003o3Pd;o`H61002o`000006o`X:2_l000;o8B8TonWYjOofm_Ko51@D
0_l000008?ld=3CooOgmomoOgol820Solo?coooooomVIVKoYZJVoooooomWIfOo0@41omoOgoofm_Ko
0@41ohV9ROoooooo?Shno`000?nl_;conOWiobPX:?nGUiOoooooojj^[_mhN7SoooooooGemOm3@d?o
G5aLoooooom`L73o1`L70_l000007?l20P;ojNWYoeIFE_l?3`ooSXj>ol_;bolG5aOo0000ogIfM_oZ
j^[o:BTYoi:BT_o@d=3o2`/;o`000?m`L73om_Kfob<S8olc<c?oo?clo`000?lm?Cgo=cLgo`820_o7
alOoG5aLo`d=3Ol61PH4o`000009o`T92Ol30`?oe=CDomkNg_oTi>Coe]KFomGEeOoIfMWoh>3P01So
fMWI00cofm_KomkNg_oHf=SofMWIom7AdOoRh^;oeMGEom;Be?oHfMkoIfM_ooclooojnOl1ofMVMP00
01;oIVUhooOkoonWZKKoJ6]domKFg_oHfMgof=SJomWIfOl20@3o10<1o`000?l30`7o0000o`820_l0
0@?o0002ogEeMOojn_X2ooooo`0PooShn?oooooooooooiZJV_l0003ooooool?3`ol20P;o820Poooo
oong]kOo10@4okVi^Oono_ko3`l?ogemOOono_koIfMWo`000?mfMWKoooooodQ8B?nf][Koooooob4Q
8Ol0003o<C4aoooooon^[Zko@T92oooooonJVYX2o`00000Fo`410Ol0003o_knoogAdM?l0003oaLG5
ofm_Kol410Co0@41o`000?nJVY[oTi>Cokfm_OmfMWKo0000o`@41?l0003oVi^KoifMWOl0003oo_kn
oc@d=0;o000000?oHf=Sonk^k_mWIfL00_l000001ol20P;o10@4o`820_l0003o1@D5o`000?oJf]X0
0_oFe]H2om_Kf`03omoOgooCdm?ofMWI01OofMWI00cof=SHomKFe_oHf=Sog]kNom_KfooDe=Cog=cL
omcLg_oHfMkoIfM_ooclooojnOl1ofMVMP0000_oIVUhooOkoonWZKKoJ6]domKFg_oHfMgof=SJomWI
fOl1003o2`X8o`<30@03o`00000?o`421?l000;o51@Donk^k_ooooooa/K6ol30`?o[jn_ooOgmogIf
M_l0003oc<c<ooooool61PKo000000;ok^k^02Ko0000ohB4Q?oooooo@410oda<C?olo?coO7alo`00
0?m]KFgoooooofYZJ_na/K7ooOgmob@T9?l10@7o0`<3ooooooomoOgo0`<3ooooooo9bLWo10@4o`00
0?l;2`_o0000oh>3PonNWYko0000oi^KVon<S8co0000o`@41?l0003oNGUiokNg]onGUiOoRXZ:o`82
0P;o000000WoOGemokRh^?l410CocLg=oeEEEOl0003o^k^koo3`l?mfMWH00_l00002o`@410?o0000
00Go20P8o`000?oHf=Sof=SHomKFeP02omSHf003om_KfooHf=SofMWI01kofMWI00GofMWKomSIg_mW
Ifooo?cooo[io`01ofMVMP0000[oIVUhooOkoonWZKKoJ6]domKFg_oHfMgof=SJomWIfOl1003o2@P6
1?l00000@ol20`Go0002o`@41?mfMWKoooooog=cLol:2P[o/[:boooooom=CDgo2`/;oi^KVooooooo
:BTYo`000?nj^[[on_[jo``<3?nJVY[oooooohZ:R_lF5QKoooooonCTi?l?3`ooE5ADoooooomiNGWo
Fe]KoogmoOo8b<So3Ph>od51@Oolo?cok^k^o`000?oVi^KoooooofEUIOl10@7o2PX:o`000?n0P83o
]KFeo`@41?la<C7omoOgof][Jol0003o5ADEol[:b_nKVi_o>SXjoo_knomWIfOo2@T9oa8B4_o6a/Ko
VIVIo`000?nWYjOoM7Ado`000?oooooo3Ph>oaDE5Ol820P00_l000003Ol10@7o20P8o`D51Ol20P;o
1@D5o`000?oIfMWof][JomSHf?oIfMWof=SHom[Jf_oHf=P07ooIfMT01OoIfM_of=WNofMWKoolo?oo
n_Wo007oIfIf00002_mVJGSomo_oojNY]_mXJgCoe]KNomSIgOoHf=[ofMWIo`810?l920H4o`000009
o`831Ol000;o0000o`@41?oPh>3ojNWYo`000?ono_kolO7a00;o000000koOGemookno_m7AdOo10@4
oijNW_oooooo=CDeomgMgOojn_[oo?clol71`Oolo?cono_koo?cl`;ooooo00CoM7Ado`000?nWYjOo
nOWi0oooool01?mmOGgo0000okZj^_oinOT2ooooo`0LoemOGol;2`_o?Shnookno_l20P;o1`L7oe5A
DOoWinOoi^KVookno_oDe=Co:BTYo`000?m<C4cohN7Qom?Cdoooooooclo?ob8R8_l0003oM7Adok>c
/ol0003oRXZ:onSXj?oYjNWo=cLgoaLG5`;o000000?o0P82o`000?l000000_l000001ooIfMWofm_K
om[Jf_oJf][oemOGom[Jf_oHf=P07ooIfMT01OoIfM_of=WNofMWKoolo?oon_Wo007oIfIf0000<?mV
JGSomo_oojNY]_mXJgCoe]KNomSIgOoHf=[ofMWIo`810?l;2PSo0@40o`000?l10@7o0000o`010ol0
00;o20P8o`000?mQHF7oo?clogYjN_oinOWodM7Ao`d=3Ol0003o?3`logalO?li>CWo0`<3ocdm?Omj
NW[o:2PXofMWIooooooohN7QofQXJ?o4a<Coooooochn?_mcLg?oL71`o`000?l30`?o0000od92@_ma
LG7oN7Qhod=3@`;o000000coEUIFogYjN_m;Bd_oMGEeodM7Aol0003o92@Too_knolT92Co0000o`82
0_l00002ochn?P0<o`820_l0003o2PX:o`000?l61PKoB4Q8ocdm?Ol10@7o0`<3o`410OmXJ6So/k>c
0_l000000olZ:R[o>SXjo`<30`02o`000007o`410Ol61PKo0`<3o`@41?l;2`_o0000omSHf002om[J
fP04om_KfooGemOofMWIomSHf1oofMWI00GofMWKomSIg_mWIfooo?cooo[io`01ofMVMP0000[oIVUh
ooOkoonWZKKoJ6]domKFg_oHfMgof=SJomWIfOl1003o2@P60_l20P004Ol20P;o0000o`000_l000;o
0000o`H61_l0003ohN7Qoooooookno_oUIFEo`000?l410Co0@41o`000?l<30co0@4100?o000000Wo
0`<3oooooooKfm_o0000ojb/[?ojn_[o;bl_o``<3?l:2PX01?l000001_lB4Q;o0000o`000?l410Co
0000o`410@?o000000Go1PH6o`000?l30`?oooooodI6AP02o`000004o`P82?l10@7o1PH6o`820P;o
000000Co2@T9o`000?l0003o2PX:0ol000002_lo?cooooooo`P82?l92@Wo0000o`820_l0003o0@41
o`D51Ol410@4o`000006o`820_oGemOoemOGomWIfOoKfm_oemOG8OoIfMT01OoIfM_of=WNofMWKool
o?oon_Wo007oIfIf00002_mVJGSomo_oojNY]_mXJgCoe]KNomSIgOoHf=[ofMWIo`400?l61@<2o`00
000>o`820_l0003o0002o`421?l20P;o0000o`D51Om9BDWooOgmookno_mTI6Co1@D5o`000?l10@43
o`00000:o`@41?l71`Oo0000o`000?mWIfOoM7Ado`T92OmgMgOooooooda<C0;o000000?o30`<o`00
0?l000000ol000003_l61PKo0`<3o`000?l0003o2`/;o`D51Ol0003o10@4odM7Aom1@D7oc<c<ogin
O_m?Cdoo;bl_1?l000004_l410Co0000o`<30ol820So0000o`820_l0003o10@4o`000?l61PKooooo
oaDE5Ol0003o10@4o`000?l410Co1@D5o`820P;o000000[o0`<3o`P82?l92@Wo2@T9omWIfOoEeMGo
emOGom_KfooGemOof][J8?oIfMT01OoIfM_of=WNofMWKoolo?oon_Wo007oIfIf00002_mVJGSomo_o
ojNY]_mXJgCoe]KNomSIgOoHf=[ofMWIo`H50ol920H2o`000006o`820_l0003o0043o`010ol0003o
0`<30_l000001oo1`L7oooooobDU9Ol:2P[o0@41o`000?l:2PX00ol000002ol30`?o0000o`H61_l0
003o2PX:o`000?mDE5CoooooogUiNOl0003o1@D500;o000000So20P8o`410Ol0003o0000o`820_l0
003o0@41o`@410;o000000Co10@4o`000?nh^;So];Bd0_o0`<001?nb/[;o[:b/o`<30ol410@2o`00
0008o`820_l0003o0000o`000?l>3Pko0000o`<30ol410@2o`000004on3Ph?m1@D7o0@41o`410@Co
000000?o0@41o`<30ol10@400_l000002?lB4Q;ogMgMomGEeOoFe]Kofm_KomSHf?oIfMWof=SH7ooI
fMT01OoIfM_of=WNofMWKoolo?oon_Wo007oIfIf00002_mWJGSon?[oojNY]_mXJgCoe]KNomSIgOoH
f=[ofMWIoa8A3ol?3P`2o`000003o`@41?l10@7o004300;o000201Ko0`<3o`<31Ol0003o0002o`00
0?l:2Pco0000o`000_l0003o0002o`000?l000;o1@D5o`000_l10@7o0000o`P82?l0003o2`/;odI6
A_ofm_KoXj>S1?l000003_l51@Go0000o`<30ol30`?o0000o`@41?l20P;o0000o`410Ol410Co0000
o`d=3Ol0003o0@410ol000002_l71`Oo0000o`000?l30`?o0@41o`000?l71`Oo0000o`<30ol20P83
o`0000;o0`<300Ko]kNgogalO?l0003o0000o`410Ol30`<2o`00000=o`820_l10@7o0000o`410Ol9
2@Wo6ATIon7QhOoFe]KoeMGEom_KfooHf=SofMWIomSHf002omWIf@0@omWIfooIfMWofMWKomWIfOoI
fM_ofMWIomWIfooIfMWofMWKomWIfOoIfM_ofMWIomWIfooIfMWof]SIomWIf@?of=[I00KofMWIom[H
fooLf=Wog=OKomcHfOoIfM/2omSJf@07omWIfOoJf=Wof]SKomWHg_mWIg7oo?cooo[io`01ofMVN000
00coJFQjoo[ioonYZ;KoJVYfomKFh?oHfMkoemSLomSJfOlK6aWo0`<1o`000?l41082o`00000Bo`D5
1ol000;o0002o`000_l000Co0@43o`811_l20PCo0@05o`410ol000Co0002o`001?l000;o0004o`00
0_l000Co0002:_l000001_l92@Wo92@Tob@T9?l:2P[o0000o`410@;o00000_l10@402?l0003o0`<3
o`<30ol0003o6a/Kom_KfooFe]Kog=cL0_oIfMT07OoGemOofMWIomWIfooIfM_ofMSMomWIfooIf=go
fMWKomWHgOoIfM_ofMSMomWIfooIf=gofMWKomWHgOoIfM_ofMSMom[HfooLem_of]SKomKJfooCg=_o
eM_KomSIfooOeMgohMCKon?CgOoPeM_of]SM00;oe][K00Oof=WKomgGfooMe]gof]OPofQVLOomnooo
noSo007oIfEj00002_mYJ7[on_WoojVX]_mZJWKoe]KPomSIg_oGf=cof=[IoeEEEOlD5182o`000004
o`820_l10@7o10@6o`410`;o0P8400?o0@43o`000_l000802ol0008;o`000005o`410Ol20P;o0`<3
o`@41?l51@D06?l000001Ol20P;o0000o`000?l92@Wo20P800?o000000Co0`<3o`000?l0003o0@41
0ol000001?l92@WoF5QHomoOgooDe=@2om[JfP03omSHf?oGemOof][J00oofMWK00Cof]SKomgGfooJ
f=WoeM_I0_oBg=/03ooFf]_ogmKKon?DfooSe=_oh=GKomWIfooEfm_odmcKomKJfOoMemWogmKKom[G
h?mXIW?ooO_ooo_ho`01ofMUN`0000koJFQhoo[ioonYZ;KoJVYfomKFh?oHfMkoemSLomSJfOnUYJGo
CDe;o``<2_l20P3o0P82o`0000;o00021?l000001?l10@7o0`<3o`@41?l51@D`o`0000;o0@411?l0
0002o`D51@04o`000?l10@7o0P82o`<30`;o000000[o6ATIodY:B_nUYJGohN7Qom?CdooIfMWofm_K
omOGeooHf=Sofm_K3ooIfMT01?oJfMOog=SGomWIeooCg=L2om7Mf@06omGKfOoLf=WogmKIomoFfOoL
f=WoeM_I0_oBgMT01ooEfmOog=SGomgGfOoJemkoJ6Iaoogkoookn?l00OmWIGX0000@ofUXN?ojnOoo
ZJRfofYZM_oFe^3of=WNomOHg?oHfM_oinOWoj>SXOmIFEOo:BTWoa0@4?l<30co3`lAo`/;2`?o0000
00Go0P80o`D50ol820Ko30`:o`h>3008oa<C4@So4a<C00So5QHFoaDE5OlE5AGo4a<Coa0@4?l=3@go
2PX:o`P821So0@4100Ko0000o`<30ol20P;o0000o`410Ol:2PX2o`h>3P0>oa@D5?lI6AWo410@o`/;
2olB4Q;o8b<SoeUIFOnOWiooemOGomcLg?oGemOofMWIom[Jf_oFe]H2om[JfPoofMWG00Sof]WGomcH
eOoIf]GodmcGom7NeooBgMOoeM_Gom[Ie`;ogMOG00_ofMWGomGKeooBgMOod]gGomGKeooJfMGog=SG
om[HgOmXIW7ooO_ooo_ho`01ofMUNP0001;oJFQhoo[ioonYZ;KoJVYfomKFh?oHfMkoemSLomSIfooF
e]KofMWIomcLg?oKfm_og=cNon3Ph_oMgMoodm?Com[Jf?oIf]D3omSIe003omWJeOoKg=Oog=gH00Oo
fM[E00?ofMWGomWIfOoIfMT01ooIfMT2om[JfP;ofm_K00?ofMWIomSHf?oGemL06?oHf=P00ooGemOo
f=SHomWIf@02omWIf@?of][J017odm?ComgMgOoJf][of][Jon7QhOoHf=Sodm?ConCTi?oQhN7oe=CD
om_KfooJf][oemOGomKFe_oKfm_of=SHomWIe`0>omWJe@08om[IeOoMf=Gog=SEomKKeOoEg=GodmgE
omKKeOoJfMD2omcHe@0;omWJeOoEg=GodmgEom?MeOoFfmGof]WEomcHeooIf=goIfM_ooclooojnOl0
0OmWIGX00009ofUXN?ojnOooZJRfofYZM?oFe^3of=WNomOHg?oHfM_oemOG00?ofMWI01;oemOIomKF
f?oGemWofMWKom_KfOoJfmKofMWGomSIe?oHf=Kof=WDomSHe_oHfMCof=SFomSIe?oHf=Kof=WDomSH
e_oHfM@2omSHePSof=SH0_oGemL01?oHf=SofMWIom[Jf_oJf]X2omWIfAWof][J0_oHf=P01?oJf][o
fMWIomOGeooFe]H2omSHf003omgMgOoGemOodm?C00;of][J00CoeMGEomWIfOoIfMWod];B0_oLg=`0
5?oFe]Kof=SHom_KfooGemOofMWGomWJeOoIfMOofM[EomWIeooIf]GofMWGomWJeOoIfMOofM[EomWI
eooIf]GofMWGomWJeOoIfMOof]WG0_oMemL04_oJfMOof=[GomSJeooHf]Oof]WGomcHeOoLf=OofMWG
omKKeooEfmOoe]_GomSJeooLf=Oog=SIomWHgOmWIfooo?cooo[io`7oIfEj00002_mYJ7Son_WoojVX
]_mZJWCoe]KPomSIg_oGf=cof=WKomgMgOoLg=`2omWIf@0Bom_KgOoHf=[oe]GJom_KgOoHf=Sof=SF
omWIfOoIfMOof][Jom[Jf?oKfm_ofm_Iom[Jf_oJf]Sof][Jom[Jf?oJf][of][H0ooJf]X7om[Jg0?o
fm_M0_oJf]`2omWIf`03omSHf_oJf]cof][L01Kof][L00KofMWKom[Jg?oJf]cofMWKom[Jg?oKfmd2
omcLgP0?omKFf?oLg=kogmoQomcLg_oIfM_of=SJom[Jg?oLg=koeMGGomKFf?oHf=[og=cNomOGfOoJ
f]cofMWK00;ofMWI01?ofMWGomWIfOoIfMOofMWIomWIeooIfMWofMWGomWIfOoIfMOofMWIomWIeooI
fMWofMWGomWIfOoJf=WogmKKon3EfooMem_of]SK00;of]SI00Cog=SIomcHeooLf=Wof]SI0_oIfMT0
2?oIfM_of]SKomgGfooMem_ofMSMofMXKOolo?oon_Wo0OmWIGX0000@ofUXN?ojnOooZJRfofYZM?oF
e^3of=WNomOHg?oHfM_oeMGEomgMgOoLg=coemOGom[Jg?oLg=kofMSMomSGg0;of=SJ1?oIfM/BomSH
fP03om[Jg?oIfM_ofMWK00CofMWK00?of][LomWIfooIfM/05_oIfM/00ooFe]Sofm_Mom_Kg@02omOG
f@;ofm_M00Goe]KHom_KgOoFe]SoemOIom[Jg002omWIf`0:om[Jg?oGemWof=SJomgMgooDe=Kog=cN
om[Jg?oKfmgoemOIom_Kg@oofMWK00Gof]SKomgFg_oOeMkogMKNomcGgP02omcGg@;og=OK0_oJf=/2
om[Hg@;of]ON00Kog=ONom[Gg_oIf=goIfQ]ooclooojnOl1ofMUNP0000SoJFQhookmoonUY;;oIVI`
om[Ji?oFemcogn3Tolo@dPCofMWK0_oIf=d2omWHgUoofM[N00?ofM[Oom[HhooHe^<00_oHeN004?oK
f>7oemCMomcKhOoLfn7of]WOom?Bf?oFeMgoh=oWomGCg_oGen7od]CPomSKi?oAd]KoL75eoocloood
lol1ofUZOP0000SoHf9booSgoonTXk7oJ6QbobTY<olT9B[o9BHZobPY:`Co9BDW0_lU92T2obDT:P;o
92DZ00ko92@/ob@U:_lT92co92DZob@T;?lT9B[o92@/ob@U:_lT92co92DZob@T;?lT9B[o92@/ob@U
:T3o92DY0_lT9BX08_lT92co92DZob@T;?lT9B[o92@/ob@U:_lT92co92DZob@T;?lT9B[o92@/ob@U
:_lT92co8RD/ob4U<?lP92oo:RXfobTW<_l/:CCo8QlXob8Q:OlU9R_o:2T^obLV;_lV9Bgo9R@_ob0P
:_lX:SKo9bhhoalV;_l^<SGoDeAHooknooofmOl1ofEVNP0000SoKFalon?Rl?ng]/CoVYZToh61Ron;
S97oRhb@ohV:SP;oT92B0_n@Si@2oi2?U@;oT8nG0_n>SYH03on>SYSoSXjFohj>V?n>SYKoSXjHohj>
U_n>SYSoSXjFohj>V?n>SYKoSXjHohj>U_n>SYSoSXjFohj?U00nohj?T`0Hohj?U?n>SYKoSXjFohj>
V?n>SYKoSXjHohj>U_n>SYSoSXjFohj>V?n>SYKoSXjHohj>U_n>SYSoSXjFohj>V?n;SiSoQY>Koh2=
UOn;SiSoR8R@oiNDWOnASYGoSHbA0_n?SY<02on9R8goRhJ=oi2=U_n@SiOoR8bEohVCW?n3SYCoR8f@
oi>GV_oZkOKo`lGD007oKFj300002?maL83od]7OomkMjoo7am7oh^;/om[Kh?oOh>GoemSL0_oIfM/2
omWHg@;ofMSN0_oIf>02omOGg`0?omOGhOoGemooemOQomOGgooGen7oemOOomOGhOoGemooemOQomOG
gooGen7oemOOomOGhOoGemooemSM03koemSL02GoemSMomOGgooGemooemOQomOGgooGen7oemOOomOG
hOoGemooemOQomOGgooGen7oemOOomOGhOoGemooemOQomCIgoo@g^7odmkPomSIg_oAb]7oh=GKon7E
fOoOeMKohmWJonGKg?oUfM_oj=WNonOHgooTfN7oeM?HomCKhOoEgn7of=gPomWMh?oio?oocm7P007o
NWZB00001_mbLH7oe=?Qookmooono_oomoOooo[ko`;oo_oo0_ooool4ooono`0Aooomooooo_ooo_ko
ookoooono_ooo_ooooknooonooooo_koookoooono_ooo_ooooknooonooooo_koookoooono_l0@oon
ool08_ono_ooo_ooooknooonooooo_koookoooono_ooo_ooooknooonooooo_koookoooono_ooo?oo
oo3fm_onoogooocmooofn?oom_[oooCgooobl_oom?7ooncZooo`lOooko?ooncbooofnooonO_onoGg
ookooooloOoomo[ooo;doono`M01ofa/Q00000SoKVemomKEhoodm?oom_KoooOgoooin_ook^odooKg
n`;omOGg0_oem?T2ooGdo00@ooGco_oem?com?GjooCenOodmO[om?GiooCen_odmOWom?GjooCenOod
mO[om?GiooCen_odmOWom?GjooCenD?om?Gj02?om?GiooCen_odmOWom?GjooCenOodmO[om?GiooCe
n_odmOWom?GjooCenOodmO[om?GiooCen_oemOOooookooGZi?nQQHCoSVIVohMEE_n8EECoR5EBohMF
D_n9EU?oTE]IoiYOHOnEGF3oREMJohMPHOnKPh?ooo_ioo?am?ohnooon_coolo@hP01og5aR`0000So
JFQfomgLj_oclooohn?]ooGeoooZjo3oi>GZoo?dn0;okNg_0_o]k?42ong/m00@ong[m_o]k?Cok>ga
onc]koo/kO7ok>g_onc]lOo/kNook>gaonc]koo/kO7ok>g_onc]lOo/kNook>gaonc]k`;ok>ga@?o/
kO809?o/kO7ok>g_onc]lOo/kNook>gaonc]koo/kO7ok>g_onc]lOo/kNook>gaonc]koo/kO7ok>g_
onc]lOo`k>_on^_TooOJd_nTM7;oeYVHonbTYOogZj_om:VVonnUX_oj[jcojYZIonNBUOodXZKolZZ]
om^OWonOLg;on^7Moo?]kooXjo3oh>;^olG6f07oMWJ@00002?m]K7[oblgJonCTl?oYjoOoemOQonCW
k_oYj^oog]oS0_oSi>P01ooThnSohnCYonCSjooShn_oi>;]on?SjooSi>T03ooSi>P2on?Tj@0non?S
jooSi>Wohn?[on?TjOoShn_ohnCYon?SjooSi>Wohn?[on?TjOoShn_ohnCYon?SjooSi>Wohn?[on?T
jOoShn_ohnCYon?SjooSi>Wohn?[on?TjOoShn_ohnCYon?SjooSi>Wohn?[on?TjOoShn_ohnCYon?S
jooSi>Wohn?[on?TjOoShn_ohnCYon?SjooSi>Wohn?[on?TjOoShn_ohnCYon?SjooSi>Wohn?[on?T
jOoShn_ohnCYon?SjooSi>Wohn?[on?TjOoShn_ohnCYon?SjooSi>Wohn?[on?TjOoShn_ohnCYon?S
jooSi>T?on?Tj00EonORi_o/g]koo=SHokEcM?oo];;ookNaoo>/Y_obZjOoo;:aooNYZOoo]k[ookNg
ooR/[?ol[ZcookRgok1dM?ome]WoiM[Non[]m?oTi_?o`lCH007oMgNA00002?m/KW_ob<cHomgOk?oD
f>?of=_TomcQiooEf=oofMcQ0_oHfn001_oJfn3of=_Rom[Jh_oHfnCof][VomSKi1;of=_R03kof=_T
omSKh_oHfnCof=_RomSKi?oHfn;of=_TomSKh_oHfnCof=_RomSKi?oHfn;of=_TomSKh_oHfnCof=_R
omSKi?oHfn;of=_TomSKh_oHfnCof=_RomSKi?oHfn;of=_TomSKh_oHfnCof=_RomSKi?oHfn;of=_T
omSKh_oHfnCof=_RomSKi?oHfn;of=_TomSKh_oHfnCof=_RomSKi?oHfn;of=_TomSKh_oHfnCof=_R
omSKi?oHfn;of=_TomSKh_oHfnCof=_RomSKi?oHfn;of=_TomSKh_oHfnCof=_RomSKi?oHfn;of=_T
omSKhPSoem[Q1ooHfn805OoJf^Cof]OXono@h?noK7CookBaonF`X?oomnCoooC/on>e]Oo]];_oi[6g
oooel?oomNcokZ^RooV[YonmMgoonl_Gon7DgOoGfnCof]kZolW<g@01ofi`Q`0000SoJVelolG9eOoE
fNGoc];Nom3DgooDf>7ocM7Jom3Ef`?odMCK0ooAe=d3om7Cg`1com7DgOoAdmoodMCMom7CgooAe=go
dM?Oom7DgOoAdmoodMCMom7CgooAe=godM?Oom7DgOoAdmoodMCMom7CgooAe=godM?Oom7DgOoAdmoo
dMCMom7CgooAe=godM?Oom7DgOoAdmoodMCMom7CgooAe=godM?Oom7DgOoAdmoodMCMom7CgooAe=go
dM?Oom7DgOoAdmoodMCMom7CgooAe=godM?Oom7DgOoAdmoodMCMom7CgooAe=godM?Oom7DgOoAdmoo
dMCMom7CgooAe=godM?Oom7DgOoAdmoodMCMom7CgooAe=godM?Oom7DgOoAdmoodMCMom7CgooAe=go
dM?Oom7DgOoAdmoodMCMom7CgooAe=godM?Oom7DgOoAdmoodMCMom7CgooAe=godM?Oom7DgOoAdmoo
dMCMom7CgooAe=godM?Oom7DgOoAdmoodMCMom7CgooAe=godM?Oom7DgOoAdmoodMCMom7Cgoo@e>3o
dMS[onO>hOnoJ73oojNRoo>jZOoomn?oooW_ooogm_oI/K[ooo;kooogm_ookN?okK2Noonl/OngL7Ko
ml?@om_>f?oAeN3oeMSWolO:f`01og1bR@0000SoJVenol?6eOo=d=ooa/[FolO;eoo:c]WoaLWDolS<
e@?obLcE0oo9bmL3olW;f01colW;eoo9bmSobL_GolW;f?o9bmOobL_HolW;eoo9bmSobL_GolW;f?o9
bmOobL_HolW;eoo9bmSobL_GolW;f?o9bmOobL_HolW;eoo9bmSobL_GolW;f?o9bmOobL_HolW;eoo9
bmSobL_GolW;f?o9bmOobL_HolW;eoo9bmSobL_GolW;f?o9bmOobL_HolW;eoo9bmSobL_GolW;f?o9
bmOobL_HolW;eoo9bmSobL_GolW;f?o9bmOobL_HolW;eoo9bmSobL_GolW;f?o9bmOobL_HolW;eoo9
bmSobL_GolW;f?o9bmOobL_HolW;eoo9bmSobL_GolW;f?o9bmOobL_HolW;eoo9bmSobL_GolW;f?o9
bmOobL_HolW;eoo9bmSobL_GolW;f?o9bmOobL_HolW;eoo9bmSobL_GolW;f?o9bmOobL_HolW;eoo9
bmSobL_GolW;f?o9bmOobL_HolW;eoo9bmSobL_GolW;f?o8c=So_lWComK5boo:NgOoojRPooncZOoW
[:CoooK^oooln_oom_oooo7oooo/mOoa/Joom;2MooRdWondLfgokl74omC7d?o8c=Ooc]7Pol;5f001
og=eS00000SoJfj1ol?6eoo6bM[o`<?Bol74doo2a];o`LGAol?7dPCo`lGA1?o3aM80M?o3aMCo`lGB
ol?5e?o3aM;o`lGDol?5d_o3aMCo`lGBol?5e?o3aM;o`lGDol?5d_o3aMCo`lGBol?5e?o3aM;o`lGD
ol?5d_o3aMCo`lGBol?5e?o3aM;o`lGDol?5d_o3aMCo`lGBol?5e?o3aM;o`lGDol?5d_o3aMCo`lGB
ol?5e?o3aM;o`lGDol?5d_o3aMCo`lGBol?5e?o3aM;o`lGDol?5d_o3aMCo`lGBol?5e?o3aM;o`lGD
ol?5d_o3aMCo`lGBol?5e?o3aM;o`lGDol?5d_o3aMCo`lGBol?5e?o3aM;o`lGDol?5d_o3aMCo`lGB
ol?5e?o3aM;o`lGDol?5d_o3aMCo`lGBol?5e?o3aM;o`lGDol?5d_o3aMCo`lGBol?5e?o3aM;o`lGD
ol?5d_o3aMCo`lGBolC6eOo4a]?oa<KEolC6doo4a]Goa<KColC6eOo4a]?o`lGDol?5d_o3aMCo`lGB
ol?5e?o3aM;o`lGDol;6d_o0bM;ockc0ok]]JOooXYgooj6Oonj]Zoo;][7oookkooogooooioKoijNe
on^OXoo]Y9GojJFBokimMooO/kCoc/7:ol75dOo7b]_o_;oB0OmeMhh00008ofa^Poo2aMSo_l;EokZm
c_nm`=7o^kk=okk1d?nn`/h4oko1cPCo_l7@07Co_l3Boko1d?no`=;o_l7@oko0d_no`M3o_l3Boko1
d?no`=;o_l7@oko0d_no`M3o_l3Boko1d?no`=;o_l7@oko0d_no`M3o_l3Boko1d?no`=;o_l7@oko0
d_no`M3o_l3Boko1d?no`=;o_l7@oko0d_no`M3o_l3Boko1d?no`=;o_l7@oko0d_no`M3o_l3Boko1
d?no`=;o_l7@oko0d_no`M3o_l3Boko1d?no`=;o_l7@oko0d_no`M3o_l3Boko1d?no`=;o_l7@oko0
d_no`M3o_l3Boko1d?no`=;o_l7@oko0d_no`M3o_l3Boko1d?no`=;o_l7@oko0d_no`M3o_l3Boko1
d?no`=;o_l7@oko0d_no`M3o_l3Boko1d?no`=;o_l7@oko0d_no`M3o_l3Boko1d?nn_m7o_/3?okjo
dOnn`<oo_[oAokk0conn_m7o_/3?oko0d_no`M3o_l3Boko1d?no`=;o_l7@oko0d_no`M3obLcMol:X
]OnhIfgoojZ/oo:MX?oLY:GoooKdooomoooonOoooo?oooo/nooYXj_olZBPoo2SWOnbJfooh:jiolVk
b?nm`Lgo`/GFok>ebP7oMGN>00002?m[KH;o`<;GokNic_ne^<_o^;_>okBgb?nj_Lko^Kc;1?ni^lYT
okVjc00Dok2ca?oA^LOoaGAkoonOXOoKSHgoono/ooofkooomO;ocZN/oooYlOooj?7oon[^omN6Pooa
X9go^WAlonFga?o3]lGo^[g<okk1e?nXZ[l1og=eSP0000SoJff4oko1f?nc]Lco/[C9okFhbon_//?o
][W:ok>fa`Co];G7Hond]LT05Onc]/Oo/K_7olFd^_nmKfoomiB>on6ER?oohm7oongLomnER?oLRH?o
k9fHoooXh?ooj^7oii>8ooJVWonZKg?obJRaokZb_ong^/_o^Kc?oifO]001ofmaRP0000SoK6j7ol32
fOna/l[o/K?:okBfbon/[l;o];O:ok2ca0Go/[?71?nb/lP0Lonb/lOo/[?8ok:caonb/lSo/[?7ok:c
b?nb/lOo/[?8ok:caonb/lSo/[?7ok:cb?nb/lOo/[?8ok:caonb/lSo/[?7ok:cb?nb/lOo/[?8ok:c
aonb/lSo/[?7ok:cb?nb/lOo/[?8ok:caonb/lSo/[?7ok:cb?nb/lOo/[?8ok:caonb/lSo/[?7ok:c
b?nb/lOo/[?8ok:caonb/lSo/[?7ok:cb?nb/lOo/[?8ok:caonb/lSo/[?7ok:cb?nb/lOo/[?8ok:c
aonb/lSo/[?7ok:cb?nb/lOo/[?8ok:caonb/lSo/[?7ok:cb?nb/lOo/[?8ok:caonb/lSo/[?7ok:c
b?nb/lOo/[?8ok:caonb/lSo/[?7ok:cb?nb/lOo/[?8ok:caonb/lSo/[?7ok:cb?nb/lOo/[?8ok:c
aonb/lSo/[?7ok:cb?nb/lOo/[?8ok:caonb/lSo/[?7ok:cb?nb/lOo/[?8ok:caonb/lSo/KC7ojng
a?nnZk7o_g1coonRWOoGPgSoj9J8onJ:NooYQGKol8EkonN2N_oXUHgofH^1omUoM_ohYJ7o[7=iolj^
^onf[[go]KS;okJhcOnEUjh00Om[KHH00008ofe^R_no`M[oZjg6ojZ/`onYZl;o[Jo4ojb^`onZ[L05
ojf^``Co[Jg507?o[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo
[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o
[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo
[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o
[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo
[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o
[Jg5ojf^`on][LGo[Jk3ojf]aOn][/?o[Jg5ojn]`ong[lCo^9NXol]kQ_ocRi;ooiROooN>T_ooV9?o
oiZDoonBT?ooW9kooiBJoo^FW?ooX:?oi8fEol>0T_o7WK?o/JFioj^^`Onf^<goRH^R007oLG><0000
2?mWJ8Co_;gIojFW`?n/[/OoZJ_2oj6S^_nSYK[oZZc11?nSY;USoj>S^`0EojJR^on`Y[oo]IN_okQo
S_o:OX_od7R>olA]O_o2LW_o_Ficoke/L_o6L7_o_VEiokaWN_o5NHGo^gV7okAlUOo0VKKo]Z[2oj>U
^_n[[LCoQhVR007oMGJB00002?maLXkoa/OSoiVJ]_nHV[?oXJ>joj:T^onUYkcoWInd1?nWZ;d2ojNW
_`;oYjO1GonWYkl05OnWYl7oYjC1ojjX`_n/Wk7o[Y^^okFF]OneU[Ko]:6gojZL[OndXkGo^ZBiok^L
^onhV[Ko]Z6`okBO/?nfW;Wo_ZK6oj>M]onSYKco/kG<oh^=YP01og9cS`0000SoH65molC5hOnRXkoo
YZS1ojZ/aOnSYKcoZJ_0ojNY_PCoXjBi0_nSXk/2oj>S_EooXj>k01GoXZBmoj6R__nTZ/;oX:bloifX
^_nTY<KoZJO>ojV^c?nQZlCoVJ>loijU_onWZ<OoYjS6oj2W]onPY[CoYInioj>J]onYY/7oXjFlojf_
b?n5Qj000Om_L8`00008ofe^R_nn_m_oVY^gojBV_onXZ/?oW9jeoj2R]onTY[/2ojJW_0CoYZJn0_nV
Y/1OojJV_P0EojFW_?nTZkgoWZZhoi^/]?nLZKWoWZC4oj6TaonRWkkoXj2kojBR^_nQXkcoXZO4oijX
`OnKYk?oXjffoj^a`OnXZ[ooZjg4oifO^?nVYl?oRhbX007oNgbJ00002?mWJ8Co_;gIojRYaOnQXkco
Wj6joj^]a?n/[/?oXjFj0_nVYk`4ojJV_P;oYZK0GonVY[h05OnUYkcoYJjooiZV]?nPZ[KoXjZmojRX
b_nYYlcoYj;0ojbX_onYZ[koYZRmojBX`onRY[ooWZBboinW/_nOZk_oVjJjoi^O^?nXZ/?o]kSDohJ7
X`01ofa]R`0000SoMWNComCElOoVioooh>;kolk@jOoMgoKogModom[Ll@Cofmca0_oKfo<2om_KmEoo
fm_c01Gof=gcom[UnooDg?7oh]keonCGmOoVe?koi]OnomKGk?oGhNgod^7XomKNjooOfOGoj=WjonSJ
looPfo7odmghom3NnOoGgOOohN;nomkOnonBTjl00OmZJhT00008ofIWPomaLXkoGf1lofi`ROm/KXOo
LWB;of=UN_m[KH84ofa]PP;oK6b40_m/K8IOofa/Q00EofU]Q_mUKhSoIF^5ogU^S?mhHXKoNUn<ogaZ
T_mZKH3oIgQoofAiO?mWM7goLVF1ogUQQOmmIX?oLFN2of9[R_mSM9;oKW>@oemPO?m`LHgoK6f9007o
LG:@0000\
\>"], "ListGraphic",
 Evaluatable->False,
 ImageSize->{133, 378},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"i:70", "AuthorTools palette"}]
}, Open  ]],

Cell[TextData[{
 StyleBox["MakeProject", "SR"],
 "\[LongDash]set up and handle projects involving multiple notebooks"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[TextData[{
 StyleBox["MakeIndex", "SR"],
 "\[LongDash]create an index"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[TextData[{
 StyleBox["MakeContents", "SR"],
 "\[LongDash]create a table of contents"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[TextData[{
 StyleBox["MakeCategories", "SR"],
 "\[LongDash]create a ",
 "browser categories",
 " file to customize the contents of the Help Browser"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[TextData[{
 StyleBox["MakeBilateralCells", "SR"],
 "\[LongDash]create a bilateral cell to display example calculations"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[TextData[{
 StyleBox["NotebookDiff", "SR"],
 "\[LongDash]find differences between notebooks"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[TextData[{
 StyleBox["NotebookRestore", "SR"],
 "\[LongDash]retrieve content from a notebook that contains a syntax error"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[TextData[{
 StyleBox["Paginate", "SR"],
 "\[LongDash]set page numbers for one or more notebooks"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[TextData[{
 StyleBox["ExportCells", "SR"],
 "\[LongDash]extract all cells of a specified type, for example, graphics \
cells"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[TextData[{
 StyleBox["InsertValue", "SR"],
 "\[LongDash]insert the value of variables, such as the current date and \
time"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}],

Cell[TextData[{
 StyleBox["SetPrintingOptions", "SR"],
 "\[LongDash]specify properties of printed pages, for example, headers and \
footers"
}], "BulletedList",
 CellTags->{"i:70", "AuthorTools palette"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeProject", "Subsection"],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
 CellTags->{"MakeProjectIntro", "i:80"}],

Cell["\<\
The MakeProject dialog box makes it easy to set up and manage projects \
involving multiple notebooks. For example, you can use this dialog box to \
generate a unified table of contents or index for a set of notebooks.\
\>", "Text",
 CellTags->{"MakeProjectIntro", "i:80"}],

Cell[CellGroupData[{

Cell[BoxData[
 ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "OpenCloseItemizedPicture",
   FormatType->StandardForm,
   ImageSize->{54, 13},
   ImageMargins->{{0, 0}, {0, 0}},
   ImageRegion->{{0, 1}, {0, 1}}],
  Active->True,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& )]], "OpenCloseItemizedPicture",
 CellTags->{"i:80", "MakeProjectIntro"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006H0001ZR000`400?l00000o`00003ooomSIG^I
of=UN`0000?oHfEkooooooooool0oooooonEooooo`7oHfEk00000omSIG_oooooojfZ_@3oojfZ_ICo
[JZm0Oooool1of=UN`0000?oHfEkoooooon]Z[d0oomSIG^Cof=UN`7o[JZm0Oooool1of=UN`0000Co
HfEkoooooon]Z[goHfEkoooooon0oooooa7oimoW00?oHfEkojfZ_Oooool00OmSIG/00005of=UNooo
oooo[JZmof=UNonLWZD0oooWgnMnonOOi`03oooooooWgnOoimoW00CoimoW0_ooool2onOOi`;ooooo
0_oWgnL2ooooo`04onOOiomSIG_o[JZmooooo`7oHfEk00001OmSIG_oooooojfZ_OmSIG_oW9jU0?oo
imoWO_oWgnL00oooooooimoWonOOi`03onOOi`;o_KJU00KoooooonOOionm]ZGo_KJUoooooooWgnL2
okffY@05oooooooWgnOoHfEkojfZ_Oooool00OmSIG/00005of=UNooooooo[JZmof=UNonLWZD0oooW
gnMnonOOi`03oooooooWgnOoimoW00?oimoW0_nm]ZD2onOOi`;o_KJU0_oWgnL2okffY@;oimoW00?o
HfEkojfZ_Oooool00OmSIG/00005of=UNooooooo[JZmof=UNonLWZD0oooWgnMnonOOi`03oooooooW
gnOoimoW00ooimoW00?oHfEkojfZ_Oooool00OmSIG/00005of=UNooooooo[JZmof=UNonLWZD0oooW
gnMnonOOi`03oooooooWgnOoimoW00SoimoW0_ooool2onOOi`;ooooo00CoimoWof=UNon]Z[gooooo
0OmSIG/00005of=UNooooooo[JZmof=UNonLWZD0oooWgnMnonOOi`03oooooooWgnOoimoW00OoimoW
0_nm]ZD02OooooooimoWokffYOnm]ZGoooooonOOiomSIG_o[JZmooooo`01of=UN`0000GoHfEkoooo
oon]Z[goHfEkoibNY@3oonOOigkoimoW00?oooooonOOiooWgnL01ooWgnL2okffY@;oimoW0_nm]ZD2
onOOi`03of=UNon]Z[gooooo007oHfEk00001OmSIG_oooooojfZ_OmSIG_oW9jU0?ooimoWO_oWgnL0
0oooooooimoWonOOi`0?onOOi`03of=UNon]Z[gooooo007oHfEk00001OmSIG_oooooojfZ_OmSIG_o
W9jU0?ooimoWO_oWgnL00oooooooimoWonOOi`0<onOOi`;ooooo00CoimoWof=UNon]Z[gooooo0OmS
IG/00005of=UNooooooo[JZmof=UNonLWZD0oooWgnMnonOOi`03oooooooWgnOoimoW00_oimoW0_nm
]ZD01OooooooimoWof=UNon]Z[gooooo007oHfEk00001OmSIG_oooooojfZ_OmSIG_oW9jU0?ooimoW
O_oWgnL00oooooooimoWonOOi`0;onOOi`;o_KJU0_oWgnL00omSIG_o[JZmooooo`01of=UN`0000Go
HfEkoooooon]Z[goHfEkoibNY@3oonOOigkoimoW00?oooooonOOiooWgnL03ooWgnL00omSIG_o[JZm
ooooo`01of=UN`0000GoHfEkoooooon]Z[goHfEkoibNY@3oonOOigkoimoW00?oooooonOOiooWgnL0
3ooWgnL00omSIG_o[JZmooooo`01of=UN`0000GoHfEkoooooon]Z[goHfEkoibNY@3oonOOigkoimoW
00?oooooonOOiooWgnL03ooWgnL00omSIG_o[JZmooooo`01of=UN`0000GoHfEkoooooon]Z[goHfEk
oibNY@3oonOOigkoimoW00?oooooonOOiooWgnL03ooWgnL00omSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEkoonLWZEooibNY@03oooooooWgnOoimoW00ooimoW00?oHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh00oo_knOoknogohb>W00<oibN[@05ohb:
W?oWinooHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh00oo_knOo
U9JUomkOi`0<omkKi`05omkOionDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=U
Nooog]_NP?oNfmh00oo_knOoU9JUooooo`0<olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UNooog]_NP?oNfmh00oo_knOoU9JUooooo`0<olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh00oo_knOoU9JUoooo
o`0<olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N
P?oNfmh00oo_knOoU9JUooooo`05olk?gP03ocTl>Oo>cmkoc/oN00Coc/oN00GooooooiBFYOmSIG_o
[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP03ono_ionDUZGooooo00Co
c/oN0oli?3T5olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=U
Nooog]_NP?oNfmh00oo_knOoU9JUooooo`03olk?gPGo>C`i1?o>cmh01OooooooU9JUof=UNon]Z[go
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00?oknoWoiBFYOooool00_oFdnL3
ocTl>@04omKCioli?3Wo>C`iocTl>@?oe]?W00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEkoooNfmj0omkKgP04ono_ionDUZGoooooomkKi`?o>C`i0ooNfnL3ocTl>@;o
g]_W00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmkoo`00
06[o00002_oNfmh00oo_knOoU9JUooooo`02onOSk`03ocTl>OoWhnooin?_00?oin?_00Wo>C`ionOS
kooWhnooin?_oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N
00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N00?oknoWoiBFYOooool0
3?o_koL01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03
o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP03ono_ionDUZGooooo00co
moOg00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0
003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh00oo_knOoU9JUooooo`0=oooo
o`04oiBFYOmSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooo
oooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP03ono_ionDUZGooooo00gooooo00CoU9JU
of=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooo
oomVooooo`03o`000?oNfmkog]_N00Sog]_N00?oknoWoiBFYOoFemh03?ooool01OoFemkoU9JUof=U
Non]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?oooooo
I_ooool00ol0003og]_NomkKgP08omkKgP03ono_iooFfmkoS9:L00_o]KJm00Ko]K:mohb>W?oFfmko
HfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3ooooo
ofKooooo00?o0000omkKg_oNfmh02?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=U
Nooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00So
g]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`00
0?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Ooo
ool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o
0000omkKg_oNfmh02?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZm
of=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01Cooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo
0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`00
00CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oN
fmh02?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N
00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o
[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_oo
ool00ol0003og]_NomkKgP08omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooo
oon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh0
5?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000oooo
ooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7o
HfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003o
g]_NomkKgP08omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk
3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?ooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
of=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooo
oomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mS
IG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08
omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0
003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?oWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[go
oooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03
o`000?oNfmkog]_N00Sog]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ
_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003ooooooooo
o`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/0
0004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmko
g]_N00Sog]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkK
gP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEk
ojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKo
oooo00?o0000omkKg_oNfmh02?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooo
oooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N
01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oo
oooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1
of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000
omkKg_oNfmh02?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=U
N`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
iomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?oo
ooooI_ooool00ol0003og]_NomkKgP08omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000Co
HfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh0
2?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o
0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZm
ooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKg_oo0000J_l0000:omkKgP0DonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
HfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP0DoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEk
ojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP0DonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ
_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP0DoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Ooo
ool1of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP0DonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1
of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP0DoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=U
N`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`00
00CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000Co
HfEkoooooon]Z[goHfEkjOoNfmh2oaQUW4Kog]_N1?l0000domkKgP;o00005?oNfmh05?oWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
of=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNjgog]_ND_lHII`bomkKgP05o`000?oN
fmkog]_NomkKg_l00000<ooNfmh00ol0003og]_No`00000ComkKgP0DoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Ooo
ool1of=UN`0000CoHfEkoooooon]Z[goHfEkk?oNfmh00olHIIcog]_NomkKgP12omkKgP03o`000?oN
fmkog]_N00;o0000=OoNfmh00ol0003og]_NomkKgP0AomkKgP0DonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1
of=UN`0000CoHfEkoooooon]Z[goHfEk3ooNfmh00ol0003og]_NomkKgP02omkKgP04o`000?oNfmko
g]_No`0000?og]_N1?l000000ooNfmko0000o`000002o`0000?og]_N00?o0000omkKg_oNfmh0PooN
fmh01?lHIIcog]_NoaQUW?lHII`2omkKgP?o66FL0_oNfmh2oaQUW004omkKg_lHIIco66FLoaQUW0?o
g]_N0_lHII`2omkKgP;o66FL1?oNfmh2oaQUW004omkKg_lHIIco66FLomkKgP;o66FL00?og]_NoaQU
W?lHII`01?oNfmh01?lHIIcog]_NomkKg_lHII`2omkKgP;o66FL0_oNfmh2oaQUW0Kog]_N00?o66FL
omkKg_oNfmh00_lHII`01?oNfmko66FLoaQUW?oNfmh3oaQUW0;og]_N0olHII`5omkKgP;o000000Co
g]_No`000?oNfmkog]_N0_l00004omkKgP;o000000Cog]_No`000?oNfmkog]_N0_l000001?oNfmko
0000o`000?l00006omkKgP?o00000ooNfmh2o`000005omkKg_l0003o0000omkKg_l000001OoNfmh2
o`0000?og]_N0ol00002omkKgP;o00001?oNfmh6o`0000?og]_N0_l000000ooNfmko0000omkKgP03
omkKgP?o00000ooNfmh2o`0000;og]_N0_l00002omkKgP;o00000ooNfmh00ol0003og]_NomkKgP03
omkKgP05o`000?oNfmkog]_NomkKg_l000003_oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/0
0004of=UNooooooo[JZmof=UN`oog]_N00?o0000omkKg_oNfmh00_oNfmh01?l0003og]_NomkKg_l0
0002omkKgP03o`000?oNfmkog]_N00Oog]_N00?o0000omkKg_oNfmh0Q_oNfmh2oaQUW0;og]_N00?o
66FLomkKg_lHII`00_oNfmh00olHIIcog]_NoaQUW002omkKgP06oaQUW?oNfmkog]_NoaQUW?oNfmko
66FL0_oNfmh00olHIIcog]_NoaQUW005omkKgP04oaQUW?oNfmko66FLoaQUW0;og]_N00Co66FLomkK
g_oNfmko66FL2?oNfmh01?lHIIcog]_NomkKg_lHII`2omkKgP04oaQUW?oNfmkog]_NoaQUW0Gog]_N
00Co66FLomkKg_oNfmko66FL0_oNfmh01?lHIIcog]_NomkKg_lHII`2omkKgP03oaQUW?oNfmko66FL
00;og]_N00?o66FLomkKg_oNfmh00_oNfmh01?l0003og]_NomkKg_l00002omkKgP03o`000?oNfmko
g]_N00?og]_N00Co0000omkKg_oNfmko00000_oNfmh01?l0003og]_NomkKg_l00002omkKgP03o`00
0?oNfmkog]_N00Cog]_N00?o0000omkKg_oNfmh00_oNfmh01?l0003og]_No`000?l00002omkKgP03
o`000?oNfmkog]_N00?og]_N00?o0000omkKg_oNfmh00_oNfmh01_l0003og]_NomkKg_l0003og]_N
o`0000Kog]_N00?o0000omkKg_oNfmh00_oNfmh01?l0003og]_NomkKg_l00002omkKgP03o`000?oN
fmkog]_N00;og]_N00Ko0000omkKg_oNfmko0000omkKg_l00002omkKgP03o`000?oNfmko000000;o
g]_N00Co0000omkKg_oNfmko00000_oNfmh00ol0003og]_NomkKgP03omkKgP;o00004OoNfmh05?oW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`oog]_N00?o0000omkKg_oN
fmh00_oNfmh01?l0003og]_NomkKg_l00002omkKgPGo00000_oNfmh3o`0008[og]_N00Go66FLomkK
g_oNfmko66FLomkKgP03oaQUW0;og]_N00?o66FLomkKg_oNfmh00olHII`2omkKgP03oaQUW?oNfmko
g]_N00;og]_N00?o66FLomkKg_oNfmh00ooNfmh01?lHIIcog]_NomkKg_lHII`2omkKgP04oaQUW?oN
fmkog]_NoaQUW0Wog]_N00Ko66FLomkKg_oNfmko66FLomkKg_lHII`3omkKgP03oaQUW?oNfmkog]_N
00?og]_N00Ko66FLomkKg_oNfmko66FLomkKg_lHII`2omkKgP?o66FL1OoNfmh00olHIIcog]_NomkK
gP03omkKgP04o`000?oNfmkog]_No`0000;og]_N00?o0000omkKg_oNfmh00_oNfmh01Ol0003og]_N
omkKg_oNfmko000000;og]_N00?o0000omkKg_l000000_l00008omkKgP05o`000?oNfmkog]_NomkK
g_l000000_oNfmh01Ol0003og]_NomkKg_oNfmko000000Cog]_N0ol00002omkKgP?o00000_oNfmh0
0ol0003og]_NomkKgP05omkKgP03o`000?oNfmkog]_N00;og]_N00Co0000omkKg_oNfmko00000_oN
fmh01?l0003og]_NomkKg_oNfmh3o`0000;og]_N00?o0000omkKg_oNfmh00_oNfmh01?l0003og]_N
omkKg_l00003omkKgP04o`000?oNfmkog]_No`0000Cog]_N00?o0000omkKg_l000004?oNfmh05?oo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`oog]_N1?l000001OoNfmko
0000omkKg_oNfmko000000;og]_N00Oo0000omkKg_oNfmkog]_No`000?oNfmko0000093og]_N00?o
66FLomkKg_lHII`00_oNfmh01_lHIIcog]_NomkKg_lHIIcog]_NoaQUW0;og]_N00?o66FLomkKg_lH
II`01OoNfmh00olHIIcog]_NomkKgP02omkKgP05oaQUW?oNfmkog]_NomkKg_lHII`00_oNfmh01?lH
IIcog]_NomkKg_lHII`8omkKgP04oaQUW?oNfmkog]_NoaQUW0;og]_N00Co66FLomkKg_oNfmko66FL
1OoNfmh01?lHIIcog]_NomkKg_lHII`2omkKgP03oaQUW?oNfmko66FL00;og]_N00Go66FLomkKg_oN
fmkog]_NoaQUW006omkKgP04o`000?oNfmkog]_No`0000;og]_N00?o0000omkKg_oNfmh00ooNfmh0
1?l0003og]_NomkKg_l00002omkKgP03o`000?oNfmko000000;og]_N00?o0000omkKg_oNfmh01OoN
fmh01Ol0003og]_NomkKg_oNfmko000000?og]_N00Co0000omkKg_oNfmko00001?oNfmh01_l0003o
g]_NomkKg_l0003og]_No`0000;og]_N00Co0000omkKg_oNfmko00001_oNfmh00ol0003og]_NomkK
gP03omkKgP03o`000?oNfmko000000;og]_N00Go0000omkKg_oNfmkog]_No`000002omkKgP03o`00
0?oNfmko000000Gog]_N00?o0000omkKg_l000000ooNfmh01?l0003og]_NomkKg_l00004omkKgP03
o`000?oNfmko0000013og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ
_OmSIG/?omkKgP03o`000?oNfmkog]_N00;og]_N00Co0000omkKg_oNfmko00000ooNfmh3o`0000?o
g]_N1?l00002omkKgP03o`000?oNfmkog]_N08Kog]_N00Oo66FLomkKg_oNfmkog]_NoaQUW?oNfmko
66FL00;og]_N00Ko66FLomkKg_oNfmko66FLomkKg_lHII`2omkKgP03oaQUW?oNfmko66FL00;og]_N
00?o66FLomkKg_oNfmh00ooNfmh01?lHIIcog]_NomkKg_lHII`2omkKgP04oaQUW?oNfmkog]_NoaQU
W0Sog]_N0_lHII`01?oNfmko66FLomkKg_oNfmh2oaQUW003omkKg_lHIIcog]_N00Cog]_N00Co66FL
omkKg_oNfmko66FL0_oNfmh01_lHIIcog]_NomkKg_lHIIcog]_NoaQUW0;og]_N00?o66FLomkKg_oN
fmh01OoNfmh00ol0003og]_NomkKgP02o`000003omkKg_l0003og]_N00Cog]_N00?o0000omkKg_oN
fmh00_l000001ooNfmko0000omkKg_oNfmko0000omkKg_l000001ooNfmh00ol0003og]_NomkKgP02
omkKgP04o`000?oNfmkog]_No`0000;og]_N0ol00002omkKgP04o`000?oNfmkog]_No`0000;og]_N
00?o0000omkKg_l000000_oNfmh00ol0003og]_NomkKgP04omkKgP03o`000?oNfmkog]_N00?og]_N
00?o0000omkKg_l000000_oNfmh3o`0000;og]_N00?o0000omkKg_l000000_oNfmh00ol0003og]_N
o`000002omkKgP04o`000?oNfmkog]_No`0000;og]_N00?o0000omkKg_oNfmh00ol00002omkKgP03
o`000?oNfmko0000013og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ
_OmSIG/?omkKgP03o`000?oNfmkog]_N00Gog]_N00?o0000omkKg_oNfmh0UOoNfmh00olHIIcog]_N
omkKgP03omkKgP;o66FL0_oNfmh01?lHIIcog]_NomkKg_oNfmh2oaQUW0?og]_N0_lHII`01?oNfmko
66FLoaQUW?lHII`5omkKgP?o66FL0_oNfmh01?lHIIcog]_NomkKg_lHII`7omkKgP;o66FL00?og]_N
oaQUW?lHII`00_oNfmh01?lHIIcog]_NoaQUW?lHII`4omkKgPGo66FL0_oNfmh01?lHIIcog]_NomkK
g_oNfmh2oaQUW0?og]_N0_lHII`4omkKgP;o000000Cog]_No`000?l0003og]_N0_l00004omkKgP?o
000000?og]_No`000?oNfmh00_l00003omkKgP;o00001ooNfmh00ol0003og]_NomkKgP03omkKgP?o
000000Gog]_No`000?l0003og]_No`000003omkKgPCo00000_oNfmh2o`000004omkKg_l0003o0000
o`0000Gog]_N00?o0000omkKg_oNfmh00ooNfmh3o`000005omkKg_l0003o0000omkKg_l000000ooN
fmh2o`0000?og]_N0_l000001?oNfmko0000o`000?l00002omkKgP;o00000_oNfmh2o`000003omkK
g_l0003og]_N00;o000000?og]_No`000?oNfmh03ooNfmh05?oWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmS
IG/00004of=UNooooooo[JZmof=UN`oog]_N1?l000001OoNfmko0000omkKg_oNfmko000009Oog]_N
00Co66FLomkKg_oNfmko66FL1_oNfmh00olHIIcog]_NomkKgP0:omkKgP03oaQUW?oNfmkog]_N00Wo
g]_N00Co66FLomkKg_oNfmko66FL3_oNfmh00olHIIcog]_NomkKgP06omkKgP03oaQUW?oNfmkog]_N
00?og]_N00?o66FLomkKg_oNfmh06OoNfmh01?l0003og]_NomkKg_l0000@omkKgP03o`000?oNfmko
g]_N01Oog]_N00?o0000omkKg_oNfmh01?oNfmh00ol0003og]_NomkKgP03omkKgP03o`000?oNfmko
g]_N017og]_N00?o0000omkKg_oNfmh07_oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UNjoog]_N00?o66FLomkKg_oNfmh00_lHII`6omkKgP03oaQUW?oNfmkog]_N
00[og]_N00?o66FLomkKg_oNfmh02OoNfmh01?lHIIcog]_NomkKg_lHII`>omkKgP03oaQUW?oNfmko
g]_N00Kog]_N00Co66FLomkKg_lHIIco66FL0_oNfmh00olHIIcog]_NomkKgP0=omkKgP03o`000?oN
fmkog]_N00Wog]_N00Co0000omkKg_oNfmko00003?oNfmh01?l0003og]_NomkKg_l00002omkKgP03
o`000?oNfmkog]_N01Gog]_N00?o0000omkKg_oNfmh01?oNfmh01Ol0003og]_NomkKg_oNfmko0000
00?og]_N00?o0000omkKg_oNfmh03ooNfmh00ol0003og]_NomkKgP0MomkKgP0DonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEk
ojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk/?oNfmh2oaQUW003omkKg_lHIIcog]_N00Co
g]_N0_lHII`GomkKgP;o66FL00?og]_NoaQUW?lHII`03OoNfmh2oaQUW0Wog]_N0_lHII`2omkKgP;o
66FL7OoNfmh2o`0000cog]_N1ol0000MomkKgPGo0000=_oNfmh05?ooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh05?oWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmS
IG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/0
0004of=UNooooooo[JZmof=UNooog]_NP?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UNooog]_NP?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=U
Nooooooo[JZmof=UNooog]_NP?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooo
oooo[JZmof=UNooog]_NP?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo
[JZmof=UNooog]_NP?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZm
of=UNooog]_NP?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=U
Nooog]_NP?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooo
g]_NP?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N
P?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oN
fmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh0
5?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh05?oo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh05?oWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_Nool0001Zo`0000[og]_N
01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oo
oooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1
of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000
omkKg_oNfmh02?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=U
N`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
iomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?oo
ooooI_ooool00ol0003og]_NomkKgP08omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000Co
HfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh0
2?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o
0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZm
ooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool0
0ol0003og]_NomkKgP08omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]
Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?oo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000oooooooo
ool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk
00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_N
omkKgP08omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oN
fmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?oWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=U
Non]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomV
ooooo`03o`000?oNfmkog]_N00Sog]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_o
ooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkK
gP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003o
ooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?ooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`00
0?oNfmkog]_N00Sog]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmS
IG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3o
ooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N
00Sog]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03
o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ
_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo
00?o0000omkKg_oNfmh02?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo
[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01Co
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooo
oooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=U
N`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkK
g_oNfmh02?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`co
g]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomS
IG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?oooooo
I_ooool00ol0003og]_NomkKgP08omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEk
oooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oN
fmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000
ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmoooo
o`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0
003og]_NomkKgP08omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[go
HfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?oWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0
oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk0000
1?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkK
gP08omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh0
0ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?ooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]
Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVoooo
o`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0D
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003ooooo
ooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?oWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmS
IG/00004of=UNooooooo[JZmof=UN`cog]_Nool0001Zo`0000[og]_N01CoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZm
ooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmoooo
o`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7o
HfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk
00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk0000
1?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mS
IG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_o
ooooojfZ_OmSIG_oomkKgX3og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_ooooo
ojfZ_OmSIG_^omkKgP;o66FL@OoNfmh4o`0003Cog]_N0_l0000DomkKgP0DoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ
_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk=OoNfmh2o`0009Wog]_N;olHII`bomkKgP05o`00
0?oNfmkog]_NomkKg_l00000<ooNfmh00ol0003og]_No`00000ComkKgP0DonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ
_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk=ooNfmh00ol0003og]_NomkKgP2gomkKgP03oaQU
W?oNfmkog]_N03gog]_N00?o0000omkKg_oNfmh00_l0000eomkKgP03o`000?oNfmkog]_N017og]_N
01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/?omkKgPCo00000_oN
fmh01?l0003og]_NomkKg_l00004omkKgPCo00000_oNfmh3o`0000;og]_N0_l00002omkKgP?o0000
0_oNfmh00ol0003og]_NomkKgP03omkKgP05o`000?oNfmkog]_NomkKg_l00000U?oNfmh3oaQUW0Co
g]_N0_lHII`2omkKgP;o66FL0_oNfmh01?lHIIcog]_NomkKg_lHII`5omkKgP;o66FL00?og]_NoaQU
W?lHII`01?oNfmh00olHIIcog]_NomkKgP02oaQUW004omkKg_lHIIco66FLomkKgP?o66FL1OoNfmh2
o`000004omkKg_l0003og]_NomkKgP;o00001?oNfmh2o`000004omkKg_l0003og]_NomkKgP;o0000
00Cog]_No`000?l0003o00001_oNfmh3o`0000?og]_N0_l000001OoNfmko0000o`000?oNfmko0000
00Gog]_N0_l00003omkKgP?o00000_oNfmh2o`0000Cog]_N1_l00003omkKgP;o000000?og]_No`00
0?oNfmh00ooNfmh3o`0000?og]_N0_l00002omkKgP;o00000_oNfmh2o`0000?og]_N00?o0000omkK
g_oNfmh00ooNfmh01Ol0003og]_NomkKg_oNfmko000000kog]_N01CoimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmoooo
o`7oHfEk00001?mSIG_oooooojfZ_OmSIG/?omkKgP07o`000?oNfmkog]_NomkKg_l0003og]_No`00
0002omkKgP05o`000?oNfmkog]_NomkKg_l000001OoNfmh01ol0003og]_NomkKg_oNfmko0000omkK
g_l000000_oNfmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000001?oNfmh00ol0003og]_No`00
002HomkKgP03oaQUW?oNfmkog]_N00?og]_N00Co66FLomkKg_oNfmko66FL0_oNfmh01olHIIcog]_N
oaQUW?oNfmko66FLomkKg_lHII`01?oNfmh01?lHIIcog]_NoaQUW?lHII`5omkKgP04oaQUW?oNfmko
g]_NoaQUW0;og]_N00Co66FLomkKg_oNfmko66FL0_oNfmh00olHIIcog]_NomkKgP02omkKgP04o`00
0?oNfmkog]_No`0000;og]_N00?o0000omkKg_oNfmh00ooNfmh01?l0003og]_NomkKg_l00002omkK
gP04o`000?oNfmkog]_No`0000;og]_N00?o0000omkKg_oNfmh01?oNfmh00ol0003og]_NomkKgP02
omkKgP04o`000?oNfmko0000o`0000;og]_N00?o0000omkKg_oNfmh00ooNfmh00ol0003og]_NomkK
gP02omkKgP06o`000?oNfmkog]_No`000?oNfmko00001_oNfmh00ol0003og]_NomkKgP02omkKgP04
o`000?oNfmkog]_No`0000;og]_N00?o0000omkKg_oNfmh00_oNfmh01_l0003og]_NomkKg_l0003o
g]_No`0000;og]_N00?o0000omkKg_l000000_oNfmh01?l0003og]_NomkKg_l00002omkKgP03o`00
0?oNfmkog]_N00?og]_N0_l0000AomkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEk
oooooon]Z[goHfEk3ooNfmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000000_oNfmh01?l0003o
g]_NomkKg_oNfmh5o`000003omkKg_l0003og]_N00Cog]_N00Co0000omkKg_oNfmko00000ooNfmh0
0ol0003og]_No`000004omkKgP03o`000?oNfmko000009Wog]_N00?o66FLomkKg_oNfmh00ooNfmh0
0olHIIcog]_NoaQUW005omkKgP;o66FL1_oNfmh01?lHIIcog]_NomkKg_lHII`6omkKgP06oaQUW?oN
fmkog]_NoaQUW?oNfmko66FL0_oNfmh3oaQUW0Kog]_N00Co0000omkKg_oNfmko00000_oNfmh00ol0
003og]_NomkKgP02omkKgP05o`000?oNfmkog]_NomkKg_l000000_oNfmh00ol0003og]_No`000002
o`0000Sog]_N00Go0000omkKg_oNfmkog]_No`000002omkKgP05o`000?oNfmkog]_NomkKg_l00000
1?oNfmh3o`0000;og]_N0ol00002omkKgP03o`000?oNfmkog]_N00Gog]_N00?o0000omkKg_oNfmh0
0_oNfmh01?l0003og]_NomkKg_l00002omkKgP04o`000?oNfmkog]_NomkKgP?o00000_oNfmh00ol0
003og]_NomkKgP02omkKgP04o`000?oNfmkog]_No`0000?og]_N00Co0000omkKg_oNfmko00001?oN
fmh00ol0003og]_No`00000@omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooo
oon]Z[goHfEk3ooNfmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000000_oNfmh01Ol0003og]_N
omkKg_oNfmko000000?og]_N00?o0000omkKg_l000000ooNfmh00ol0003og]_No`000002omkKgP07
o`000?oNfmkog]_NomkKg_l0003og]_No`000004omkKgP03o`000?oNfmko000009Wog]_N00?o66FL
omkKg_oNfmh00ooNfmh00olHIIcog]_NoaQUW005omkKgP;o66FL1_oNfmh01OlHIIcog]_NomkKg_oN
fmko66FL00Gog]_N00Co66FLomkKg_oNfmko66FL0_oNfmh00olHIIcog]_NoaQUW002omkKgP03oaQU
W?oNfmkog]_N00?og]_N00Co0000omkKg_oNfmko00000_oNfmh00ol0003og]_NomkKgP03omkKgP04
o`000?oNfmkog]_No`0000;og]_N00?o0000omkKg_l000000_oNfmh00ol0003og]_NomkKgP05omkK
gP05o`000?oNfmkog]_NomkKg_l000000ooNfmh01?l0003og]_NomkKg_l00004omkKgP06o`000?oN
fmkog]_No`000?oNfmko00000_oNfmh01?l0003og]_NomkKg_l00006omkKgP03o`000?oNfmkog]_N
00?og]_N00?o0000omkKg_l000000_oNfmh01Ol0003og]_NomkKg_oNfmko000000;og]_N00?o0000
omkKg_l000001OoNfmh00ol0003og]_No`000003omkKgP04o`000?oNfmkog]_No`0000Cog]_N00?o
0000omkKg_l000004?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZm
of=UN`oog]_N00Oo0000omkKg_oNfmkog]_No`000?oNfmko000000;og]_N0ol00002omkKgP?o0000
0ooNfmh3o`000004omkKg_l0003o0000o`0000;og]_N0ol00002omkKgP?o000000?og]_No`000?oN
fmh00_oNfmh00ol0003og]_No`00002FomkKgPCo66FL0_oNfmh01_lHIIcog]_NomkKg_lHIIcog]_N
oaQUW0;og]_N00?o66FLomkKg_lHII`01_oNfmh01?lHIIcog]_NomkKg_lHII`5omkKgP04oaQUW?oN
fmkog]_NoaQUW0;og]_N00Ko66FLomkKg_oNfmko66FLomkKg_lHII`5omkKgP03o`000?oNfmkog]_N
00;o000000?og]_No`000?oNfmh01?oNfmh00ol0003og]_NomkKgP02o`000007omkKg_l0003og]_N
omkKg_l0003og]_No`000007omkKgP03o`000?oNfmkog]_N00;og]_N00Co0000omkKg_oNfmko0000
0_oNfmh3o`0000;og]_N00Co0000omkKg_oNfmko00000_oNfmh00ol0003og]_No`000002omkKgP03
o`000?oNfmkog]_N00Cog]_N00?o0000omkKg_oNfmh00ooNfmh00ol0003og]_No`000002omkKgP?o
00000_oNfmh00ol0003og]_No`000002omkKgP03o`000?oNfmko000000;og]_N00Co0000omkKg_oN
fmko00000_oNfmh00ol0003og]_NomkKgP03o`0000;og]_N00?o0000omkKg_l000004?oNfmh05?oW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`oog]_N00Go0000omkKg_oN
fmkog]_No`00000DomkKgP03o`000?oNfmkog]_N0:Oog]_N00Co66FLomkKg_oNfmkog]_N0olHII`3
omkKgP;o66FL0_oNfmh00olHIIcog]_NoaQUW002oaQUW0Gog]_N0olHII`4omkKgPGo66FL0_oNfmh0
1?lHIIcog]_NomkKg_oNfmh2oaQUW0Cog]_N0_l000001?oNfmko0000o`000?oNfmh2o`0000Cog]_N
0ol000000ooNfmko0000omkKgP02o`0000?og]_N0_l00007omkKgP03o`000?oNfmkog]_N00?og]_N
0ol000001OoNfmko0000o`000?oNfmko000000?og]_N1?l00002omkKgP;o000000Cog]_No`000?l0
003o00001OoNfmh00ol0003og]_NomkKgP03omkKgP?o000000Gog]_No`000?l0003og]_No`000003
omkKgP;o00000ooNfmh2o`000004omkKg_l0003o0000o`0000;og]_N0_l00002omkKgP;o000000?o
g]_No`000?oNfmh00_l000000ooNfmko0000omkKgP0?omkKgP0DoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1
of=UN`0000CoHfEkoooooon]Z[goHfEk3ooNfmh4o`0000;og]_N00?o0000omkKg_oNfmh04?oNfmh0
0ol0003og]_NomkKgP2WomkKgP05oaQUW?oNfmkog]_NomkKg_lHII`02OoNfmh00olHIIcog]_NomkK
gP0?omkKgP03oaQUW?oNfmkog]_N00?og]_N00?o66FLomkKg_oNfmh05?oNfmh01?l0003og]_NomkK
g_l0000@omkKgP03o`000?oNfmkog]_N01Oog]_N00?o0000omkKg_oNfmh01?oNfmh00ol0003og]_N
omkKgP03omkKgP03o`000?oNfmkog]_N017og]_N00?o0000omkKg_oNfmh07_oNfmh05?oWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
of=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNm?og]_N00Co66FLomkKg_oNfmko66FL
0_oNfmh00olHIIcog]_NomkKgP05omkKgP03oaQUW?oNfmkog]_N00oog]_N00Co66FLomkKg_lHIIco
66FL0_oNfmh00olHIIcog]_NomkKgP08omkKgP03o`000?oNfmkog]_N00Wog]_N00Co0000omkKg_oN
fmko00003?oNfmh01?l0003og]_NomkKg_l00002omkKgP03o`000?oNfmkog]_N01Gog]_N00?o0000
omkKg_oNfmh01?oNfmh01Ol0003og]_NomkKg_oNfmko000000?og]_N00?o0000omkKg_oNfmh03ooN
fmh00ol0003og]_NomkKgP0MomkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooo
oon]Z[goHfEkd_oNfmh4oaQUW0[og]_N0_lHII`BomkKgP;o66FL0_oNfmh2oaQUW1Sog]_N0_l0000<
omkKgPOo00007OoNfmh5o`0003Kog]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_o
ooooojfZ_OmSIG_oomkKgX3og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_ooooo
ojfZ_OmSIG_oomkKgX3og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ
_OmSIG_oomkKgX3og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmS
IG_oomkKgX3og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_o
omkKgX3og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkK
gX3og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3o
g]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N
01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01Co
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomS
IG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o
[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZm
ooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N01CoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmoooo
o`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKg_oo0000J_l0000:omkKgP0DonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEk
ojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKo
oooo00?o0000omkKg_oNfmh02?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooo
oooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N
01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oo
oooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1
of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000
omkKg_oNfmh02?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=U
N`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?oo
ooooI_ooool00ol0003og]_NomkKgP08omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000Co
HfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh0
2?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o
0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZm
ooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool0
0ol0003og]_NomkKgP08omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]
Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?oW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000oooooooo
ool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk
00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_N
omkKgP08omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oN
fmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?ooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=U
Non]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomV
ooooo`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_o
ooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkK
gP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003o
ooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?oWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`00
0?oNfmkog]_N00Sog]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmS
IG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3o
ooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N
00Sog]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03
o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ
_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo
00?o0000omkKg_oNfmh02?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo
[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01Co
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooo
oooo0?ooooooI_ooool00ol0003og]_NomkKgP08omkKgP0DonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=U
N`0000CoHfEkoooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkK
g_oNfmh02?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`co
g]_N00?o0000ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomS
IG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?oooooo
I_ooool00ol0003og]_NomkKgP08omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEk
oooooon]Z[goHfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oN
fmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000
ooooooooool0oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmoooo
o`7oHfEk00001?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0
003og]_NomkKgP08omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[go
HfEk3?oNfmh00ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?oooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0
oooooomVooooo`03o`000?oNfmkog]_N00Sog]_N01CoimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk0000
1?mSIG_oooooojfZ_OmSIG/<omkKgP03o`000?oooooooooo0?ooooooI_ooool00ol0003og]_NomkK
gP08omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh0
0ol0003oooooooooo`3oooooofKooooo00?o0000omkKg_oNfmh02?oNfmh05?oWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]
Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N00?o0000ooooooooool0oooooomVoooo
o`03o`000?oNfmkog]_N00Sog]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/<omkKg_oo0000J_l0000:omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000Co
HfEkoooooon]Z[goHfEkoooNfmj0omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEk
oooooon]Z[goHfEkoooNfmj0omkKgP03ono_ioo_loOoS8jL00coW9j]00GoS8jLono_iomSIG_o[JZm
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP03ono_ionDUZGog]oW00coe]?N
00Gog]oWoiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP04
ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUoooo
ooogmol2ono_m`;okn__00Coin?_omkKiooNfnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2
ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04
onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEkAooNfmh2o`000?oog]_N=ooNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Co
in?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG]9omkKgP03o`000?oNfmkog]_N0?oog]_N=?oNfmh01?o_knOoU9JUooooooogmol2ono_
m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/=omkKgP05o`000?oNfmkog]_NomkKg_l000000_oNfmh4o`0000;og]_N
00Co0000omkKg_oNfmko00000_oNfmh00ol0003og]_NomkKgP04o`0000Gog]_N0ol00002omkKgP03
o`000?oNfmkog]_N00Cog]_N00?o0000omkKg_oNfmh00ooNfmh00ol0003og]_NomkKgP02omkKgP?o
00000ooNfmh01?l0003og]_NomkKg_oNfmh4o`0000;og]_N0ol00002omkKgP;o00000_oNfmh00ol0
003og]_NomkKgP3oomkKgR7og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOo
g]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
3OoNfmh00ol0003og]_NomkKgP02o`000003omkKg_l0003og]_N00;og]_N00Co0000omkKg_oNfmko
00000_oNfmh01_l0003og]_NomkKg_l0003og]_No`0000Sog]_N00Oo0000omkKg_oNfmkog]_No`00
0?oNfmko000000Kog]_N00?o0000omkKg_oNfmh00ooNfmh01Ol0003og]_NomkKg_oNfmko000000?o
g]_N00Co0000omkKg_oNfmko00000_oNfmh00ol0003og]_NomkKgP03omkKgP07o`000?oNfmkog]_N
omkKg_l0003og]_No`00003oomkKgROog]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOS
kooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk3OoNfmh00ol0003og]_NomkKgP02o`0000;og]_N1?l00002omkKgP04o`000?oNfmkog]_N
o`0000;og]_N00?o0000omkKg_l000001?l00004omkKgP07o`000?oNfmkog]_NomkKg_l0003og]_N
o`000006omkKgP03o`000?oNfmkog]_N00?og]_N00Go0000omkKg_oNfmkog]_No`000003omkKgP04
o`000?oNfmkog]_No`0000;og]_N1Ol000000ooNfmko0000omkKgP04omkKgP03o`000?oNfmkog]_N
0?oog]_N9OoNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>
cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/=omkKgP05o`00
0?oNfmko0000omkKg_l000001OoNfmh01?l0003og]_NomkKg_l00002omkKgP06o`000?oNfmkog]_N
o`000?oNfmko00000ooNfmh00ol0003og]_NomkKgP02omkKgP07o`000?oNfmkog]_NomkKg_l0003o
g]_No`000006omkKgPCo00000_oNfmh01Ol0003og]_NomkKg_oNfmko000000?og]_N00Co0000omkK
g_oNfmko00000_oNfmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000000ooNfmh00ol0003og]_N
o`00003oomkKgROog]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKG
i`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmh2
o`0000;og]_N00?o0000omkKg_l000000ol00003omkKgP?o000000?og]_No`000?l000000ooNfmh3
o`0000Kog]_N0ol000001?oNfmko0000o`000?l00005omkKgP06o`000?oNfmkog]_NomkKg_l0003o
g]_N0ol00002omkKgP?o00000ooNfmh01?l0003og]_NomkKg_oNfmh3o`0000?og]_N0ol000001?oN
fmko0000o`000?l00002omkKgP03o`000?oNfmkog]_N0?oog]_N8OoNfmh01?o_knOoU9JUooooooog
mol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/=omkKgP;o00000_oNfmh00ol0003og]_NomkKgP0MomkKgP03
o`000?oNfmkog]_N00Cog]_N00Go0000omkKg_oNfmkog]_No`00000KomkKgP03o`000?oNfmkog]_N
0?oog]_N9OoNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>
cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/=omkKgP05o`00
0?oNfmkog]_NomkKg_l000007ooNfmh2o`0000Gog]_N1?l0000=omkKgP03o`000?oNfmkog]_N00co
g]_N00?o0000omkKg_oNfmh0oooNfmhUomkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oW
hnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo
[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOo
e]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkK
gX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00Go
oooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP04ono_
ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEk
ojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUooooooog
mol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[
k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEkoooNfmj0omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oW
omkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=U
Nooog]_NP?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>
cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N
00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBF
YOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP04ono_ionDUZGo
ooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Ooo
ool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUooooooogmol2ono_
m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOS
kooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEkoooNfmj0omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooF
enL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N
P?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01Ooo
ooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00CoknoW
oiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o
[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP04ono_ionDUZGoooooooOg
o`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmS
IG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__
00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOo
g]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
oooNfmj0omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?
gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh0
1?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JU
of=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoo
oooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmoooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP04ono_ionDUZGoooooooOgo`;oknog
0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004
of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_
omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKG
i`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0
omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooo
oonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004
ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionD
UZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ
_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGooooo
ooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGoooooooOgo`;o
knog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_
jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oW
hnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo
[JZmof=UN`gog]_NXOl0DH`00ooooooo056<o`1AS03>o`1AS004ono_ionDUZGoooooooOgo`;oknog
0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004
of=UNooooooo[JZmof=UN`gog]_NX_l0DH`00ooooooo056<o`1AS03=o`1AS004ono_ionDUZGooooo
ooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`gog]_NT_l0DH`00ooooooo056<o`1AS004o`1AS004oooo
ool0DHco056<o`1AS0;ooooo0ol0DH`01?oooooo056<o`1AS?l0DH`3ooooo`?o056<0_ooool2o`1A
S0;ooooo0_l0DH`00ooooooo056<o`1AS003o`1AS003ooooool0DHco056<00;ooooo0_l0DH`2oooo
o`03o`1AS?oooooo056<00;o056<0_ooool3o`1AS005ooooool0DHco056<ooooool0DH`00ooooonM
o`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooo
oonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_NT_l0DH`00ooooooo
056<o`1AS004o`1AS004ooooool0DHco056<ooooo`;o056<00Coooooo`1AS?l0DHcooooo0_l0DH`0
0ooooooo056<o`1AS003o`1AS006ooooool0DHco056<ooooool0DHcooooo1?l0DH`01Ooooooo056<
o`1AS?l0DHcooooo00;o056<00Koooooo`1AS?l0DHcoooooo`1AS?ooool2o`1AS004ooooool0DHco
056<ooooo`;o056<00Coooooo`1AS?l0DHcooooo0_l0DH`00ooooooo056<o`1AS002o`1AS003oooo
ool0DHco056<00Co056<00?oooooo`1AS?l0DH`0Tol0DH`01?o_knOoU9JUooooooogmol2ono_m`;o
kn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/=omkKgY;o056<00?oooooo`1AS?l0DH`01?l0DH`01?oooooo056<o`1AS?oo
ool2o`1AS004ooooool0DHco056<ooooo`;o056<1?ooool2o`1AS003ooooool0DHco056<00;o056<
00?oooooo`1AS?l0DH`00_l0DH`5ooooo`;o056<00?oooooo`1AS?l0DH`00_l0DH`01?oooooo056<
o`1AS?ooool2o`1AS004ooooool0DHco056<ooooo`;o056<00Coooooo`1AS?l0DHcooooo0_l0DH`2
ooooo`Ko056<0ooooonDo`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkO
iooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`go
g]_NT_l0DH`4ooooo`?o056<00Coooooo`1AS?l0DHcooooo0_l0DH`01?oooooo056<o`1AS?ooool2
o`1AS004ooooool0DHco056<ooooo`;o056<00Koooooo`1AS?l0DHcoooooo`1AS?ooool4o`1AS005
ooooool0DHco056<o`1AS?ooool00_l0DH`01_oooooo056<o`1AS?oooooo056<ooooo`;o056<00Co
ooooo`1AS?l0DHcooooo0_l0DH`01?oooooo056<o`1AS?ooool2o`1AS003ooooool0DHcooooo00Oo
056<1OoooonCo`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3
olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_NT_l0
DH`01Ooooooo056<o`1AS?l0DHcooooo00;o056<0_ooool2o`1AS0;ooooo0ol0DH`01?oooooo056<
o`1AS?l0DH`2ooooo`Co056<0_ooool01?l0DHcoooooooooooooool4o`1AS003ooooool0DHcooooo
00Co056<0_ooool01_l0DHcooooooooooooooooo056<ooooo`?o056<0_ooool3o`1AS0?ooooo0ol0
DH`3ooooo`?o056<1ooooonBo`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oW
omkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=U
N`gog]_NT_l0DH`01Ooooooo056<o`1AS?l0DHcooooo01Wo056<00?oooooo`1AS?l0DH`00ol0DH`0
0ooooooo056<ooooo`08o`1AS003ooooool0DHco056<0:ko056<00CoknoWoiBFYOoooooomoOo0_o_
koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk3OoNfmjBo`1AS0Cooooo3?l0DH`00ooooooo056<o`1AS00;o`1AS003
ooooool0DHco056<00Co056<00?oooooo`1AS?l0DH`01ol0DH`01?oooooo056<o`1AS?oooon]o`1A
S004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonD
UZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_
ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEk
ojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGo
ooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Ooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGoooooooOg
o`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmS
IG/00004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGoooooooOgo`;oknog
0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004
of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_jnl0
1?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoo
g]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZm
of=UNooog]_NP?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OW
olkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooo
g]_NP?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02
olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oN
fmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05
oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_
knOoU9JUooooooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonD
UZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JU
ooooooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEk
ojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUooooooog
mol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Ooo
ool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUooooooogmol2ono_
m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmS
IG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__
00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004
of=UNooooooo[JZmof=UN`gog]_NoomBU[Eaoe:F]@;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2
ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/=omkKg_ooDYJeLOmBU[D2omkKgP04ono_ionDUZGoooooooOgo`;o
knog0_o_jnl01OoWhnoog]_WomkKiooFenOoc]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmkooe:F]G7oDYJe0_oNfmh01?o_knOoU9JUooooooog
mol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Ooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_NoomBU[Eaoe:F]@;og]_N00CoknoWoiBFYOoo
oooomoOo0_o_koL2ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]
Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/=omkKg_ooDYJeLOmBU[D2omkKgP04ono_ionD
UZGoooooooOgo`;oknog0_o_jnl01OoWhnoog]_WomkKiooFenOoc]?N00;oc/oN00GooooooiBFYOmS
IG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmkooe:F]G7oDYJe0_oNfmh01?o_
knOoU9JUooooooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonD
UZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_NoomBU[Eaoe:F]@;og]_N
00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOog]_WomKGi`?oc/oN00GooooooiBF
YOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmkooe:F]G7oDYJe0_oNfmh0
1?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkKiooNfnOoe]OW0oo>cmh01OooooooU9JU
of=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/=omkKg_ooDYJeLOmBU[D2omkKgP04
ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_N6_mBU[D6ooooo`;oDYJe1?oo
ool3oe:F]@Gooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@;ooooo0_mB
U[D2oooooccoDYJe1Oooool3oe:F]@Gooooo0_mBU[D3ooooo`?oDYJe1?ooooldoe:F]@Gooooo0omB
U[D5ooooo`;oDYJe0oooool3oe:F]@Cooooo1?mBU[D2ooooo`?oDYJe0_ooool2oe:F]@Cooooo0omB
U[D2ooooo`;oDYJe0_ooool2oe:F]@;ooooo=?mBU[D4ooooo`;oDYJe0_ooool2oe:F]@Cooooo0omB
U[D5ooooo`03oe:F]Ooooooooooo02;oDYJe0_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__
00Coin?_omkKiooNfnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/=omkKgQ[oDYJe0_ooool5oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool01?mBU[GooooooooooomBU[D3ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D2
oooooc_oDYJe0_ooool3oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe0oooool2
oe:F]@;ooooo0_mBU[D2oooooc;oDYJe0_ooool3oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2
ooooo`;oDYJe0oooool2oe:F]@;ooooo0_mBU[D2ooooo`?oDYJe0_ooool3oe:F]@;ooooo00?oDYJe
ooooooooool00_mBU[D2ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D2oooooc?oDYJe0_ooool2
oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`03oe:F]Ooooooooooo02;oDYJe0_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__
00Coin?_omkKiooNfnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/=omkKgQ[oDYJe0_ooool5oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;oooooC?mBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`03oe:F]Ooooooooooo03_oDYJe0_ooool0
0omBU[Goooooooooo`02oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool00omBU[Gooooooooo
o`07oe:F]@Oooooo1?mBU[D3ooooockoDYJe0_ooool6oe:F]@;ooooo00?oDYJeooooooooool01OmB
U[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`0Roe:F]@;og]_N00CoknoWoiBFYOoooooomoOo
0_o_koL2ono[k`04onOSkooNfnOog]_WomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk3OoNfmhJoe:F]@;ooooo1OmBU[D2ooooo`;oDYJe0_ooool2oe:F
]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@;oooooB_mBU[D4ooooo`;oDYJe0_ooool0
1?mBU[GooooooooooomBU[D2ooooo`04oe:F]Ooooooooooooe:F]@Kooooo=OmBU[D4ooooo`;oDYJe
0_ooool01?mBU[GooooooooooomBU[D2ooooo`04oe:F]Ooooooooooooe:F]@Kooooo1?mBU[D2oooo
o`03oe:F]Ooooooooooo00?oDYJe1?oooolooe:F]@;ooooo1_mBU[D2ooooo`03oe:F]Ooooooooooo
00Cooooo0_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo8_mBU[D2omkKgP04ono_ionDUZGo
ooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Ooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_N6_mBU[D2ooooo`GoDYJe0_ooool2oe:F]@;o
oooo0omBU[D4ooooo`03oe:F]Ooooooooooo00;oDYJe0_oooom8oe:F]@Gooooo1?mBU[D4ooooo`04
oe:F]Ooooooooooooe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooooc?oDYJe1Oooool4oe:F
]@Cooooo00CoDYJeooooooooooooDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo1?mBU[D2
ooooo`03oe:F]Ooooooooooo00;oDYJe0ooooom1oe:F]@;ooooo1_mBU[D2ooooo`03oe:F]Ooooooo
oooo00;oDYJe0_ooool3oe:F]@Cooooo00?oDYJeooooooooool08_mBU[D2omkKgP04ono_ionDUZGo
ooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Ooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_N6_mBU[D2ooooo`GoDYJe0_ooool2oe:F]@;o
oooo00?oDYJeoooooomBU[D00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@?oooooAomBU[D4oooo
o`CoDYJe00Cooooooe:F]OmBU[GoDYJe1?ooool3oe:F]@Cooooo0_mBU[D2oooooc;oDYJe1?ooool4
oe:F]@04oooooomBU[GoDYJeoe:F]@Cooooo0omBU[D4ooooo`;oDYJe0_ooool4oe:F]@;ooooo00?o
DYJeooooooooool00_mBU[D2ooooo`;oDYJe0_oooolnoe:F]@;ooooo1_mBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool00omBU[Gooooooe:F]@02oe:F]@;ooooo00?oDYJeooooooooool08_mB
U[D2omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3olk?gP05
oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_N6_mBU[D2oooo
o`KoDYJe1?ooool3oe:F]@Cooooo0omBU[D2ooooo`03oe:F]Ooooooooooo04OoDYJe0_ooool7oe:F
]@Cooooo00?oDYJeooooooooool00omBU[D2ooooo`03oe:F]Ooooooooooo00;ooooo<omBU[D2oooo
o`OoDYJe1?ooool00omBU[Goooooooooo`03oe:F]@;ooooo00?oDYJeooooooooool00_ooool5oe:F
]@;ooooo00?oDYJeooooooooool00omBU[D4ooooocooDYJe0_ooool6oe:F]@;ooooo0_mBU[D4oooo
o`?oDYJe1?ooool2oe:F]@Cooooo8?mBU[D2omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl0
1?oWhnoog]_WomkKiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`gog]_N6_mBU[D2oooooaOoDYJe0_oooom7oe:F]@;ooooo0omBU[D2ooooodKoDYJe
0_ooool3oe:F]@;ooooo6OmBU[D3ooooodSoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool0
<omBU[D2omkKgP04ono_ionDUZGoooooooOgo`;oknog1_n<UZD3olk?gP05oooooonDUZGoHfEkojfZ
_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_N6_mBU[D2oooooaOoDYJe0_oooom8oe:F
]@GoooooB?mBU[D5oooooa[oDYJe0ooooom9oe:F]@Cooooo0_mBU[D2oooooc?oDYJe0_oNfmh01Oo_
knOoU9JUooooooogmoooknog00Kooooo00Woe]OWolk?g_o>cmkoc/oNoooooonDUZGoHfEkojfZ_Ooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_NoomBU[Eaoe:F]@;og]_N00CoknoWoiBFYOoo
oooomoOo0_o_koL6ohbFY@?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk3OoNfmkooe:F]G7oDYJe0_oNfmh01Oo_knOoU9JUooooooogmoooknog00Kooooo00Wo
e]OWolk?g_o>cmkoc/oNoooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=U
N`gog]_NoomBU[Eaoe:F]@;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL6ohbFY@?oc/oN00Gooooo
oiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmkooe:F]G7oDYJe0_oN
fmh01Oo_knOoU9JUooooooogmoooknog00Kooooo00Woe]OWolk?g_o>cmkoc/oNoooooonDUZGoHfEk
ojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`gog]_NoomBU[Eaoe:F]@;og]_N00CoknoW
oiBFYOoooooomoOo0_o_koL6ohbFY@?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk3OoNfmkooe:F]G7oDYJe0_oNfmh01Oo_knOoU9JUooooooogmoooknog00Ko
oooo00Woe]OWolk?g_o>cmkoc/oNoooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo
[JZmof=UN`gog]_NoomBU[Eaoe:F]@;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOS
kooNfnOog]_WomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk3OoNfmkoo`1AS7?o056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOo
g]_WomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
3OoNfmkoo`1AS7?o056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOog]_WomKG
i`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmko
o`1AS7?o056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOog]_WomKGi`?oc/oN
00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmkoo`1AS7?o
056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOog]_WomKGi`?oc/oN00Gooooo
oiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmkoo`1AS7?o056<00Co
knoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOog]_WomKGi`?oc/oN00GooooooiBFYOmS
IG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmkoo`1AS7?o056<00CoknoWoiBF
YOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOog]_WomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZm
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmjZo`1AS003ooooool0DHco056<0<Go056<
00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOog]_WomKGi`?oc/oN00GooooooiBF
YOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmj[o`1AS003ooooool0DHco
056<0<Co056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOog]_WomKGi`?oc/oN
00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk3OoNfmjKo`1AS003
ooooool0DHco056<00Co056<00Coooooo`1AS?l0DHco056<0_ooool3o`1AS004ooooool0DHco056<
o`1AS0?ooooo0ol0DH`2ooooo`;o056<0_ooool3o`1AS003ooooool0DHco056<00?o056<00Cooooo
o`1AS?l0DHcooooo0ol0DH`3ooooojCo056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOS
kooNfnOog]_WomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk3OoNfmjKo`1AS003ooooool0DHco056<00Co056<00Coooooo`1AS?l0DHcooooo0_l0DH`0
1?oooooo056<o`1AS?ooool2o`1AS003ooooool0DHco056<00?o056<00Koooooo`1AS?l0DHcooooo
o`1AS?ooool4o`1AS003ooooool0DHco056<00?o056<00Coooooo`1AS?l0DHcooooo0_l0DH`00ooo
oooo056<o`1AS006o`1AS003ooooool0DHco056<09co056<00CoknoWoiBFYOoooooomoOo0_o_koL2
ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/=omkKgY_o056<00?oooooo`1AS?l0DH`01?l0DH`01?oooooo056<
o`1AS?ooool2o`1AS004ooooool0DHco056<ooooo`;o056<1?ooool2o`1AS003ooooool0DHco056<
00;o056<00?oooooo`1AS?l0DH`00_l0DH`00ooooooo056<o`1AS003o`1AS004ooooool0DHco056<
ooooo`;o056<1?ooool4o`1AS0?oooooWOl0DH`01?o_knOoU9JUooooooogmol2ono_m`;okn__00Go
in?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`gog]_NVol0DH`4ooooo`?o056<00Coooooo`1AS?l0DHcooooo0_l0DH`01?oo
oooo056<o`1AS?ooool2o`1AS004ooooool0DHco056<ooooo`;o056<00Koooooo`1AS?l0DHcooooo
o`1AS?ooool4o`1AS0?ooooo0ol0DH`01?oooooo056<o`1AS?ooool2o`1AS004ooooool0DHco056<
ooooo`?o056<1OoooonLo`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01OoWhnoog]_WomkK
iooFenOoc]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk3OoNfmjKo`1AS005ooooool0DHco056<o`1AS?ooool00_l0DH`2ooooo`;o056<0_ooool3o`1A
S004ooooool0DHco056<o`1AS0;ooooo1?l0DH`2ooooo`04o`1AS?ooooooooooooooo`?o056<00?o
ooooo`1AS?l0DH`00ol0DH`01?oooooo056<o`1AS?ooool3o`1AS0;ooooo0ol0DH`7oooooi_o056<
00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01Ooo
ooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/=omkKgY_o056<00Gooooo
o`1AS?l0DHco056<ooooo`0Io`1AS003ooooool0DHco056<00;o056<00?oooooo`1AS?l0DH`01_l0
DH`00ooooooo056<o`1AS02Xo`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01OoWhnoog]_W
omkKiooFenOoc]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk3OoNfmjKo`1AS0Cooooo3?l0DH`00ooooooo056<o`1AS00;o`1AS003ooooool0DHco056<
00;o056<1?ooool2o`1AS004ooooool0DHco056<oooooj[o056<00CoknoWoiBFYOoooooomoOo0_o_
koL2ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/=omkKg_oo056<Lol0DH`01?o_knOoU9JUooooooogmol2ono_
m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmS
IG/00004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGoooooooOgo`;oknog
0_o_jnl01OoWhnoog]_WomkKiooFenOoc]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk3OoNfmkoo`1AS7?o056<00CoknoWoiBFYOoooooomoOo0_o_koL2
ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/=omkKg_oo056<Lol0DH`01?o_knOoU9JUooooooogmol2ono_m`;o
kn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`gog]_Nool0DHaco`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_
jnl01OoWhnoog]_WomkKiooFenOoc]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk3OoNfmkoo`1AS7?o056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[
k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOS
kooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOSkooNfnOo
g]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKG
i`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0
omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooo
oonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOo
U9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]
Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00CoknoWoiBFYOoooooomoOo
0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl0
1?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooo
oooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooN
gnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_o
omkKgX3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN
00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP04
ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh01?o_knOoU9JUoooo
ooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKg_oo056<O?l0DH`01?o_knOoU9JUooooooogmol2
ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKg_oo056<O?l0DH`01?o_knOoU9JUooooooogmol2ono_m`;o
kn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/4omkKg_oo056<O?l0DH`01?o_knOoU9JUooooooogmol2ono_m`;okn__00Co
in?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/4omkKg_oo056<O?l0DH`01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkO
iooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/4omkKg_oo056<O?l0DH`01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOo
e]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkK
g_oo056<O?l0DH`01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>
cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKg_oo056<
O?l0DH`01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01Ooo
ooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKg_oo056<O?l0DH`0
1?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JU
of=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKg_oo056<O?l0DH`01?o_knOo
U9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]
Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKg_oo056<F_l0DH`Hoe:F]@[o056<00Co
knoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmS
IG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmkoo`1AS5[o056<6?mBU[D:o`1A
S004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonD
UZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_Nool0DHaJo`1AS1SoDYJe
2_l0DH`01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01Ooo
ooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKg_oo056<F_l0DH`H
oe:F]@[o056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN
00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmi:o`1AS0?o
ooooool0DH`=o`1AS1SoDYJe2_l0DH`01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkO
iooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/4omkKgT[o056<1?ooooooo`1AS0co056<6?mBU[D:o`1AS004ono_ionDUZGoooooooOgo`;oknog
0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004
of=UNooooooo[JZmof=UN`Cog]_NC?l0DH`2oooooooo056<3?l0DH`Hoe:F]@[o056<00CoknoWoiBF
YOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZm
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1AS0;ooooo0ol0DH`01?oooooo056<
o`1AS?l0DH`2ooooo`?o056<0oooool01?l0DHcoooooooooool0DH`2ooooo`;o056<0_ooool4o`1A
S0Cooooo1_l0DH`2ooooo`Oo056<0_ooool6o`1AS0?ooooo1?l0DH`2ooooo`Co056<1?ooool5o`1A
S0?ooooo1?l0DH`3ooooooCo056<2_mBU[D2ooooo`coDYJe2_l0DH`01?o_knOoU9JUooooooogmol2
ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgP_o056<0_ooool2o`1AS0?ooooo0_l0DH`2ooooo`;o056<
1_ooool2o`1AS0;ooooo0_l0DH`2ooooo`?o056<1_ooool5o`1AS0;ooooo1ol0DH`2ooooo`Go056<
1Oooool3o`1AS0;ooooo0ol0DH`6ooooo`?o056<1Oooool2o`1AS0Cooooom?l0DH`:oe:F]@;ooooo
3?mBU[D:o`1AS004ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?
gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`2
ooooo`;o056<0oooool2o`1AS0;ooooo0_l0DH`2ooooo`;o056<0_ooool2o`1AS0;ooooo00?o056<
ooooooooool00ol0DH`2ooooo`[o056<0_ooool7o`1AS0;ooooo1?l0DH`3ooooo`04o`1AS?oooooo
ooooooooo`;o056<0_ooool2o`1AS0;ooooo1ol0DH`2ooooo`;o056<0_ooool2o`1AS0;ooooom_l0
DH`Hoe:F]@[o056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?o
c/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1A
S0;ooooo0_l0DH`00ooooooo056<ooooo`02o`1AS0;ooooo0ol0DH`2ooooo`03o`1AS?oooooooooo
00;o056<1Oooool3o`1AS0Oooooo1Ol0DH`2ooooo`Oo056<0_ooool4o`1AS0;ooooo0ol0DH`2oooo
o`;o056<0_ooool2o`1AS0Oooooo0_l0DH`2ooooo`Ko056<0_ooooofo`1AS0[oDYJe0_ooool<oe:F
]@[o056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00Go
oooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1AS0;ooooo
00Co056<oooooooooooo056<0_ooool00ol0DHcoooooooooo`04o`1AS0Cooooo0_l0DH`4ooooo`Co
056<1oooool5o`1AS0Kooooo0ol0DH`2ooooo`Co056<0_ooool3o`1AS0;ooooo0_l0DH`2ooooo`;o
056<1oooool2o`1AS0;ooooo1_l0DH`2ooooooKo056<2_mBU[D2ooooo`coDYJe2_l0DH`01?o_knOo
U9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]
Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP_o056<0_ooool01?l0DHcooooooooo
ool0DH`2ooooo`03o`1AS?oooooooooo00Ko056<0_ooool2o`1AS0Cooooo1?l0DH`2ooooo`?o056<
0_ooool5o`1AS0Oooooo0_l0DH`3ooooo`?o056<0oooool01?l0DHcoooooooooooooool2o`1AS0;o
oooo0_l0DH`2ooooo`?o056<0_ooool2o`1AS0;ooooo0_l0DH`2ooooo`;o056<0_ooooofo`1AS0_o
DYJe0_ooool;oe:F]@[o056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oW
omKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oN
fmh;o`1AS0;ooooo00?o056<ooooool0DH`00_l0DH`01?oooooo056<ooooooooool2o`1AS0Kooooo
0_l0DH`2ooooo`03o`1AS?oooooooooo00Co056<1Oooool6o`1AS0;ooooo0ol0DH`2ooooo`;o056<
1Oooool2o`1AS0Gooooo0ol0DH`2ooooo`?o056<1Oooool4o`1AS0Gooooo00?o056<ooooooooool0
0oooooodo`1AS0coDYJe0_ooool:oe:F]@[o056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04
onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmh;o`1AS0Cooooo0ol0DH`4ooooo`?o056<1?ooool3o`1AS0;ooooo0_l0DH`2
ooooo`Co056<0oooool7o`1AS0;ooooo0ol0DH`2ooooo`;o056<0_ooool00ol0DHcoooooooooo`03
o`1AS0?ooooo1?l0DH`2ooooo`Co056<0oooool6o`1AS0?ooooo0_l0DH`5ooooooCo056<2?mBU[D2
ooooo`;oDYJe0_ooool:oe:F]@[o056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooN
gnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk1?oNfmh;o`1AS0Cooooo0ol0DH`4ooooo`[o056<0_oooolBo`1AS0Oooooo9_l0DH`2ooooooKo
056<2OmBU[D4ooooo`_oDYJe2_l0DH`01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkO
iooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/4omkKgP_o056<0oooool5o`1AS0?ooooo2_l0DH`2oooooa;o056<1_oooolBo`1AS0;ooooo5?l0
DH`00ooooooo056<o`1AS03do`1AS1SoDYJe2_l0DH`01?o_knOoU9JUooooooogmol2ono_m`;okn__
00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/4omkKg_oo056<F_l0DH`Hoe:F]@[o056<00CoknoWoiBFYOoooooomoOo0_o_koL2
ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmkoo`1AS5[o056<6?mBU[D:o`1AS004ono_ionDUZGoooooooOgo`;o
knog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`Cog]_Nool0DHaJo`1AS1SoDYJe2_l0DH`01?o_knOoU9JUooooooog
mol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/4omkKg_oo056<F_l0DH`Hoe:F]@[o056<00CoknoWoiBFYOoo
oooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmoooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmkoo`1AS7co056<00CoknoWoiBFYOoooooomoOo
0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk1?oNfmkoo`1AS7co056<00CoknoWoiBFYOoooooomoOo0_o_koL2
ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmkoo`1AS7co056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04
onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmkoo`1AS7co056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooN
gnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk1?oNfmkoo`1AS7co056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oW
omKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oN
fmkoo`1AS7co056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?o
c/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmkoo`1A
S7co056<00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00Go
oooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmkoo`1AS7co056<
00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBF
YOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmkoo`1AS7co056<00CoknoW
oiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o
[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmkoo`0007co000000CoknoWoiBFYOoo
oooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmoooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmkoo`0007co000000CoknoWoiBFYOoooooomoOo
0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`00001Vo`000?oog]_N4ooNfmh01?o_
knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=U
Non]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000006Ko0000
oooNfmhComkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?
gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000
o`P82?l00000I_l0003oomkKgQ?og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooN
gnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk1?oNfmh00ol0003o20P8o`00000Ko`000003ob4P8Om2@D;o410@00oo00000_la<34?o`0000;o
<C0a1Ol00002oc4`<@Oo00000_lQ824Fo`000?oog]_N4ooNfmh01?o_knOoU9JUooooooogmol2ono_
m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So0000013o000000?oW9jLoooooomcLG<01?l0
0002ooooo`03oa0@4?mcLG?ooooo00;ooooo00SoS8j<o`000?l@413ooooookfn_Ol0003o_Kjmoooo
o`;o000000Gog]oNooooool0003o410@olk?cP02ooooo`06omkOg_mBDE;o0000og=aLooooooo@T52
0ol000001_l@413ooooooc4`<Ol0003o410@olk?cP;ooooo00Gog]oNoc4`<Ol0003o410@olk?cP02
ooooo`0:omkOg_la<37o0000oe9AD_oNgmko0000og=aLooooooog]oNoibNW1Go0000oooNfmhComkK
gP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonD
UZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l00000
4?l000001?lQ827okno_ono_kol@4102o`000004oc4`<Ooooooog]oNo`0000;ooooo01WoHf5Sojf^
[OooooooHf5So`000?oNgmkokno_o`000?nLWYcooooood91@_l0003o_KjmoooooolQ827oW9jLoooo
oon][ZgoLg5cono_kooooooo@T52of=QHoooooooLg5c00Co000001Wokno_oe9AD_l0003oW9jLolk?
c_l@413o0000og=aLoo_knoo8B0QoibNW?o>clko410@o`000?mcLG?okno_ob4P8Ola<37oooooo`00
0?m2@D;o<C0ao`000?o>clkoHf5S01Co0000oooNfmhComkKgP04ono_ionDUZGoooooooOgo`;oknog
0_o_jnl01OoWhnoog]_WomkKiooFenOoc]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`00000Ao`000003og=aLooooooooooo
00Cooooo01goW9jLo`000?ooooooc/o>o`000?lQ827ooooookfn_Ol0003o_Kjmooooool@413oLg5c
oooooomSHF?o0000og=aLooooooo@T52okfn_Ooooooo8B0Qo`000?la<37oooooojf^[Om2@D;ooooo
oibNW004o`000005okfn_OmcLG?o0000okfn_OmcLG<00ol00002oibNW003okfn_OmcLG?o000000;o
00000_nLWY`00ol0003ooooooc4`<@02o`000003of=QHoo_knooHf5S01Co0000oooNfmhComkKgP04
ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l000004Ol0
00002ol@413okno_ooooooo>clko_Kjmono_koooooooLg5co`000?o>clkooooo00;o00000_o_knl0
0ol0003oS8j<ooooo`02od91@P09oooooomcLG?o0000of=QHoooooooLg5cojf^[Ooooooo8B0Q00;o
00000_ooool00ol0003oooooolk?cP04o`000005ohb>S?nLWYco0000oibNW?n<SX`00ol000001?mc
LG?o_KjmoibNW?n<SX`3o`000009og=aLonm_[go0000olk?c_mBDE;o0000okfn_Oo_knooLg5c01Go
0000oooNfmhComkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3
olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o
0000o`P82?l000004_l00000?omcLG?oooooog=aLol0003o_Kjmoooooom2@D;o0000ojf^[Ooooooo
<C0ao`000?nm_[goooooo`000?nLWYcoooooohb>S?lQ827oooooomkOg_l@413oDU5BoooooomcLG?o
DU5Booooooo>clko410@od91@_ooooookno_o`000?oNgmkoooooof=QHol0003o410@o`000?mcLG?o
_Kjmo`000?la<37oooooof=QHol0003o410@olk?c_nLWYco<C0aoooooomSHF?o0000oa0@4?o>clko
W9jLo`000?n][ZgoLg5co`000?oooooo8B0Qoa0@400Eo`000?oog]_N4ooNfmh00oo_knOoU9JUomKG
gP0<ooooo`05omKGg_nDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N
00?o0000o`P82?l000004ol000001OoNgmkokno_o`000?o_knoooooo00;o000000SoLg5coooooom2
@D;o0000oibNW?oooooo@T52omkOgP;ooooo00Co_Kjmooooooooooookno_0_ooool00omcLG?o0000
oibNW004ooooo`03og=aLol0003o_Kjm00?ooooo00CoHf5So`000?m2@D;ooooo0_l000002?mBDE;o
g]oNomkOg_ooooooc/o>ob4P8Ol0003oDU5B0_oNgmh02oooooooc/o>ob4P8Ol0003oLg5cojf^[Ol0
003oS8j<omkOg_o_knoo@T5201Co0000oooNfmhComkKgP03ono_ioooooooU9:L00co]KJm00GoU9:L
ono_iomSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`00
000Co`000005of=QHoooooooLg5cooooooo>clh00_l000003_m2@D;oLg5cod91@_l0003o@T52og=a
LolQ827oHf5SoooooooNgmkoHf5Solk?c_oooooo@T520_mcLG<3o`000004od91@_mcLG?oLg5cod91
@P;o000000WoDU5Bog=aLom2@D;oLg5cod91@_l0003o8B0QoooooolQ82400ol00002od91@PGo0000
0_m2@D83o`000004of=QHonm_[go0000o`0000;o<C0a5Ol0003oomkKgQ?og]_N00?oknoWono_mon<
SY`03?nLWZd01On<RYcoinO_of=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkK
gP03o`000?l820So000001Co000000Cog]oNooooooooooooS8j<2_l000001_oooooog]oNo`000?n]
[Zgooooooc4`<A;o000000?ooooood91@_l000003_l000000om2@D;oooooo`00000Ho`000?oog]_N
4ooNfmh00oo_knOoU9JUomkOi`0<omkKi`05omkOionDUZGoHfEkojfZ_Oooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l000005?l000001?m2@D;ooooooooooomSHF<:o`00
0006of=QHomcLG?o0000og=aLoooooooDU5B4?l00002od91@P04olk?c_n<SXco@T52oc4`<@ko0000
00?oooooob4P8Ol000005ol0003oomkKgQ?og]_N00?oknoWoiBFYOooool03?o>cmh01OooooooU9JU
of=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000001Go
000000?o_Kjmoooooola<3403Ol000000omBDE;oooooog=aL`0@o`0000Go_Kjm00?o[Jj]o`000?l0
00003?l000000ooNgmko@T52o`00000Fo`000003oaPH6?oNfmkog]_N0?oog]_N4OoNfmh00oo_knOo
U9JUooooo`0<olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=U
N`Cog]_N00?o61PHo`000?l000009Ol000000om2@D;ooooooibNW00To`000003okfn_OmcLG?o0000
01Ko000000?o61PHomkKg_oNfmh0oooNfmhAomkKgP03ono_ionDUZGooooo00coc/oN00GooooooiBF
YOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00olH61So0000o`00001<
o`000003oc4`<OlQ827o000001Ko000000?o61PHomkKg_oNfmh0oooNfmhAomkKgP03ono_ionDUZGo
oooo00coc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oN
fmh00omJFE[o0000o`00001Uo`000003oeYIF_oNfmkog]_N0?oog]_N4OoNfmh00oo_knOoU9JUoooo
o`02olk?gP03ocTl>Oo>cmkoc/oN00?oc/oN00Wo>C`iolk?g_o>cmkoc/oNoooooonDUZGoHfEkojfZ
_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o[Jj]odY9B_l00000I?l000000om:
BD[o[Jj]omkKgP3oomkKgQ;og]_N00CoknoWoiBFYOooooooc/oN0oli?3T3olk?gP?o>C`i0_o>cmh0
1OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP04onOWion]
[ZgoFUUJob4P8@;o410@3?l000000ol@413o0000o`000005o`0001So410@7ol000001?l820So410@
oa0@4?l@410<o`0000;o410@00Ko20P8oa0@4?lQ827oFUUJojf^[OoWinOoomkKgQ?og]_N00?oknoW
oiBFYOooool00_oFdnL3ocTl>@04omKCioli?3Wo>C`iocTl>@?oe]?W00GooooooiBFYOmSIG_o[JZm
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP03ono_ionDUZGooooo00?og]_W
1Oli?3T4omkKi`05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooo
g]_NP?oNfmh00oo_knOoU9JUooooo`04onOSk`?o>C`i1OoWhnl01OooooooU9JUof=UNon]Z[gooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00?oknoWoiBFYOooool01Oo_koL00oli
?3Woknogono_m`04ono_m`05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZm
of=UNooog]_NP?oNfmh00oo_knOoU9JUooooo`0<ooOgm`05oooooonDUZGoHfEkojfZ_Oooool00OmS
IG/00004of=UNooooooo[JZmof=UNooog]_NP?oNfmh00oo_knOoU9JUooooo`0=ooooo`04oiBFYOmS
IG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgX3og]_N00?oknoWoiBFYOooool0
3Oooool01?nDUZGoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmj0omkKgP03
ono_ionDUZGoe]ON00cooooo00Goe]ONoiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEkoooNfmj0omkKgP03ono_iooFfmkoS9:L00_o]KJm00Ko]K:mohb>W?oFfmkoHfEkojfZ_Ooo
ool1of=UN`0000?oHfEkooOgoonLVZD0oomcMIBCog=eU07oW9ZU0Oogmol1of=UN`0000?oHfEkooOg
oonm_/h0oonm_/jDokfncP7omoOo0OmSIG/00003of=UNoogmoooin?W0?ooin?WU?oWhnL1ooOgo`7o
HfEk00000omSIG_omo?gooooo`05ooooo`koQ8:4oooooom?ooooo`03onOSionLY[goJgF<00;oJgF<
0_m[MI@5of]eS006oibV_OoWhnOooooooooooooWhnOoW:Jm0om[MH`2of]eU0GoJgF<00KoW:JmonOS
ioooooooooooono[konLY[d:ojDh@P03oibV_Oo_jnoooooo00?ooooo0OogloL1of=UN`0000GoHfEk
onOSiooooooooo_oooooo`02oooko`;oQ8:43?ooool00on4PXCoooooooooo`02ooooo`03oookoooo
oooooo_o07;ooo_oeOooool00onLY[goJgF<ohB:]@09ohB:]@06of]eS?nLY[gooooooooooonLY[go
JgF<2_n4R[D01_m[MHcoW:JmoookooooooooW:JmojDh@P[o[CaB00OoYCQ2oibV_Ooooooooooooook
ooooooooin?W007oHfEk00000omSIG_oin?WooOgo`05ooOgo`0:ohB2Q?oooooooooooooooon]_Zgo
YJ:UolKOa_ooooooe]ooojG;m`?ooooo00?oQ8:4ooOgooogmol0ooogmom=ooOgo`03of]eS?n4R[Go
W9jm00WoW9jm00KoQ8Zeof]eS?ogmooomoOoof]eS?n4R[D:oibN_@07ohB:]Om[MHcomoOoooOgoonU
>4;o[CaBolIAFP08olIEFP03olIAF_n]?5;oYCQ200ComoOo0OoWhnL1of=UN`0000?oHfEkomkOioog
loL01OogloL03_n4PXCooooooookmoo6glKoYJ:UomJn[On]OJgoYJ:Uoe9M[OmkOJgooooooookmooo
ooooQ8:4ooogloM?ooOcm`03of]eS?ne]]KoYJ[600WoYJ[600Ko]KKFof]eS?ogloOomo?gof]eS?ne
]]H7ooooo`?oYJ[600Go]KKFof]eS?ogloOomo?gojDh@P02olIAFP03oliEF_o>FE[ocUUJ00CocUUJ
00CocUEJolIAF_o6DE[oYCQ21?ogloL1omkOi`7oHfEk00001OmSIG_og]_Wono[moo_joOoknog00;o
kn__0_n4PX@03Oooooooe]ooohB2Q?n]GJgoe[iBomJND_nUXZGo[GeBoe9MD_n]OJgoe[j]oooooon4
PX@00_o_joL01?o_jnookn_gono[moo_jnmcono[mg?oknogH_o_jnl00om[MHco]K[Fojf^aP06oooo
o`?o[Jk600Oo]K[Fof]eS?o_jnookn__of]eS?ne^]Kooooo00KoJff<00Go8B@aojf^a_n][/Ko]K[F
of]eS002ono[m`03ojDh@_o>FE[ocUEJ00;ooooo0ooFFEX2ooooo`;ocUEJ00CocUUJojDh@_o_jnoo
kn_g0_o_jnl1omkKi`7oHfEk00000omSIG_oe]_NomkOi`05omkOi`07ohB2Q?n]_ZgoYJ:UojfND_oF
_U;oe]n]omJn[@02omJNDP;oeYj]0_ooool00on4PXCog]oWomkOi`3oomkOidgog]oW00CoJgF<okg3
e_nm^/kooooo1?m[KH`01_lQ937o_K[>okfjc_nm^/ko_L?Fof]eS0;og]oW00CoJgF<okg3e_oooooo
Jff<1?nm^/h01_oooooo8B@aokfjc_nm^/ko_L?Fof]eS0;og]oW00?oYCQ2oliIF_oFFEX00oooool0
2?oFGF?oooooooooooooooooeUeSomIIF_o>FE[oYCQ21?oNgnL1omKKgP7oHfEk00000omSIG_oe]ON
omKKi`03omKKi`04omKGiooFfnOoQ8:4ojFRY@;oNij]00Ooe[iBoooOD_n4PXCo[Gd0omIm[OoFGJgo
eYj]00;ooooo00CoQ8:4omKKiooFfnOoe]OW0_oFfnMdomKGimGoe]_W00?oJgF<olk?g_o>bmh01_lQ
9343olk;gP08olk?g_m[MHcoe]_WomKKiom[MHcoc/oNoooooom[KH`4olk;gP06oooooolQ937oc/_N
olk;g_o>cmkoJgF<0_oFfnL01?nU>4;oeUeJomiUHom271P5ooooo`05od8L6?oWIF?ogVESomIMF_nU
>4800_oFfnL00ooFenOoe]_WomKGgP01of=UN`0000?oHfEkomKGg_o>dmh01?oFdmh2ohB2Q007oook
momkWZgoDYj]omJND_oFO@3o[Ed0ojemDP02omHLDP04omHlD_oFWZgoooooohB2Q0?oe]?N00?oc]?N
omKCg_o>dmh0LooFdmicolkCgV;oe]?N00?oJgF<omKCioo>dmh02Oo>dmh02?oFdnOoJgF<omKCg_oF
dmkoJgF<omKCioooooooJff<1?o>dmh03Ooooooo8B@aolkCg_o>dmkoe]?Wof]eS?oFdmkoc]?NojDh
@_oNIF?oifUSonM]Jom271P00oooool01_m271Soife[onM]JooWJF?ogVESojDh@P?oe]?N0Oo>dmh1
omKGgP7oHfEk00000omSIG_oe]?Nolk?gP05olk?gP0>ohB2Q?oonoOoYJ:Uoe:N[OoFOE;oQ8:4oe9m
[OmBGJgo[EeBomIMD_n]OJgoe[j]oooooon4PXCoolk?gTooc/oN00?oJgF<omKGiooNfnL02OoNfnL0
2?oFenOoJgF<olk?g_o>cmkoJgF<omKGioooooooJff<1Oooool01OlQ937og]_WomkKiooFenOoJgF<
00;oc/oN00CoYCQ2onM]JooWMF_oig5[1Oooool01OoWMF_oig5[onMeJooWKF_oYCQ200Coc/oN0OoF
dmh1of=UN`0000?oHfEkolk?g_o6bmH01?o6bmH01?o6amKoQ8:4olKOa_mkWZd2ohB2Q006og^NoomB
GJgo:Cb]obUM[Omk?5;ooo_g0_ooool00on4PXCoa/_FolK7eP1golK7eW?oa/_FH_o6amH00om[MHco
e]OWonOOk`09onOOk`07omKGiom[MHcoa/OFolK7e_m[MHcoe]OWooooo`06of]]S005ob4T<OoWgnoo
imo_omKGiom[MH`00_o6bmH00onU>4;okgUconmmN`03ooooo`08od8L6?ooooooooooooooooo_PW_o
kgekonmiLonU>483olK;eP7oa/OF0Oo>cmh1of=UN`0000?oHfEkolk?g_o6amH01?o6amH2ohB2Q0;o
oo_g00?o[Kj]og^N[OmkWZd00_mBOJd00onUXZGoNgf]omJn[@02ooooo`03ohB2Q?o6amKoa/OF0?oo
a/OFCOo6amH00om[MHcokn_gono[m`0:ono[m`04of]eS?o6amKoa/OFof]eS0;okn_g1olQ9343ono[
m`06of]eS?o6amKoa/OFojDh@_ogPW?omhIk0_ooool00om271Somk:Lod8L6002ooooo`04ooN>Q?og
QW_omh9cojDh@PCoa/OF0Oo>cmh1of=UN`0000?oHfEkolk?g_nm`lh01Onm`lh02On4PXCooooooook
mon]_Zgoa]o6omKOoonUXZGoNgf]oookm`04ooooo`03ohB2Q?nm`lko_L?>0?oo_L?>COnm`lh00om[
MHcoe]?WooOcm`09ooOcm`06omKCiom[MHco_L?>okg3c_m[MHcoe]?W2_ogloL01ooFdnOoJgF<okg3
c_nm`lkoYCQ2ooN:NoogTX@00_m271P3ooNjW0;o@Q`H0_ogTX@00oogRW_oYCQ2okg3cP03okg3cP7o
c/oN0OmSIG/00003of=UNoo>bmko]K[>00Go_Kk>00?oQ8:4ooooooooool00oooool00oo6glKo[Ij]
oookm`04ooooo`03ohB2Q?nm_/ko_K[>0?oo_Kk>COnm_/h01?n4SZGoJgF<olk;g_oonol6ooooo`04
oookooo>bmkoJgF<ohB>Y@;o_Kk>00CoQ8jUof]eS?o>bmkooo_o1_ooool01?oonoooc/_Nof]eS?n4
SZD2okfncP05oiBJ[OnU>4;ooij<oonnYOoogkD01?oojkD02_oogkGookjUoonNS?nU>4;oU9Z]okfn
c_nm^/ko_Kk>okFjc_o>bmh1of=UN`0000?oHfEkolK;e_nm]/h01?n][/H2ohB2Q0cooooo00?oQ8:4
ojf^a_n][/H0oon][/I>ojf^aP03ohB>YOm[MHcoJgF<00SoJgF<00?oQ8jUojf^a_n][/H00_n][/H0
0on4SZGoJgF<of]eS008of]eS003ohB>YOn][/Ko[Jk600;o[Jk600?oQ8jUojDh@_nU>4802?nU>480
0on4SZGo[Jk6ojf^aP02ojf^aP7o_KK>0Oo6bmH1of=UN`0000?oHfEkolK3e_o6amH01On]Z/H>ohB2
Q?oo[J[6P?n]Z/H1olK7eP7oa/?F0OmSIG/00006ookno_n]Y[goinO_omKCionm_/ko]K;6oon]Y[f=
ojfV_@05okFba_nm_/koe]?WonOWkon]Y[d00Oono_h00007ookno_n4QYcoe]_WoooooooWhnooe]?W
olk;gP3ookfncX_o_Kk>00Koc/_NomKCiooWhnooooooomKKion4QY`1ooknoP000_ono_h01_nDUZgo
e]_WooooooogloOokn__onOSkoooe]_WROoFfnL01_oWhnookn__ooOcmoooooooe]_WoiBF[@;oo_kn
0003ooknoP;oHfEk00?oS8JLoiBF[On]Y[d0oon]Y[f:ojfV_@04oiBF[On<QYcoHfEkof=UN`?oo_kn
0000\
\>"], "ListGraphic",
 Evaluatable->False,
 ImageSize->{408, 426},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"i:80", "MakeProjectIntro"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating a Project File", "Subsubsection",
 CellTags->{"Creating a Project File", "i:115"}],

Cell["\<\
The first step in processing multiple notebooks is to create a project file. \
This is a file that specifies the names and location of all notebooks in a \
project. You can create any number of project files, one for each project you \
are working on. Each project file has a .m suffix.\
\>", "Text",
 CellTags->{"Creating a Project File", "i:115"}],

Cell[TextData[StyleBox["To create a project file:", "TB"]], "Text",
 CellTags->{"Creating a Project File", "i:115"}],

Cell["Open the MakeProject dialog box.", "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Creating a Project File", "i:115"}],

Cell[TextData[{
 "Type in a name for your project in the ",
 StyleBox["Name of Project", "SR"],
 " text box."
}], "ItemizedList",
 CellTags->{"Creating a Project File", "i:115"}],

Cell[TextData[{
 "Click ",
 StyleBox["Target Directory", "SR"],
 ". A file browse dialog box appears."
}], "ItemizedList",
 CellTags->{"Creating a Project File", "i:115"}],

Cell[TextData[{
 "Select a file in the directory containing your source notebooks. The full \
",
 "pathname",
 " of the directory is pasted into the ",
 StyleBox["Directory", "SR"],
 " text box."
}], "ItemizedList",
 CellTags->{"Creating a Project File", "i:115"}],

Cell[TextData[{
 "Click ",
 StyleBox["Select all", "SR"],
 ". A list of all notebook files in the directory you specified appears in \
the ",
 StyleBox["Files", "SR"],
 " text box."
}], "ItemizedList",
 CellTags->{"Creating a Project File", "i:115"}],

Cell["\<\
Edit the list to delete any notebooks that do not belong in the project.\
\>", "ItemizedList",
 CellTags->{"Creating a Project File", "i:115"}],

Cell[TextData[{
 "Click ",
 StyleBox["Save", "SR"],
 " under the",
 StyleBox[" Project File", "SR"],
 " tab to save the project file."
}], "ItemizedList",
 CellTags->{"Creating a Project File", "i:115"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Handling a Project", "Subsubsection",
 CellTags->{"Handling a Project", "i:71"}],

Cell[TextData[StyleBox["To process all notebooks in a project:", "TB"]], \
"Text",
 CellTags->{"Handling a Project", "i:71"}],

Cell["Open the MakeProject dialog box.", "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Handling a Project", "i:71"}],

Cell[TextData[{
 "Click ",
 StyleBox["Load", "SR"],
 " and choose the project file you need. (If you have not already created a \
project file, see ",
 ButtonBox["Creating a Project File",
  ButtonData:>"Creating a Project File",
  ButtonStyle->"AddOnsLinkText"],
 " to learn how.)"
}], "ItemizedList",
 CellTags->{"Handling a Project", "i:71"}],

Cell["\<\
With the MakeProject dialog box as the current notebook, click the button for \
the palette you want to use. The palette functions will apply to all \
notebooks in the specified project.\
\>", "ItemizedList",
 CellTags->{"Handling a Project", "i:71"}],

Cell[TextData[{
 "Once you have loaded a project, you can use the buttons under the ",
 StyleBox["Project Actions", "SR"],
 " tab to perform a variety of tasks."
}], "Text",
 CellTags->{"Handling a Project", "i:71"}],

Cell[TextData[{
 "To create a table of contents in a specific style, click the corresponding \
button under ",
 StyleBox["Contents", "SR"],
 "."
}], "BulletedList",
 CellTags->{"Handling a Project", "i:71"}],

Cell[TextData[{
 "To create an index in a specific style, click the corresponding button \
under ",
 StyleBox["Index", "SR"],
 "."
}], "BulletedList",
 CellTags->{"Handling a Project", "i:71"}],

Cell[TextData[{
 "To create a BrowserCategories.m file, click ",
 StyleBox["BrowserCategories", "SR"],
 " under ",
 StyleBox["Other", "SR"],
 "."
}], "BulletedList",
 CellTags->{"Handling a Project", "i:71"}],

Cell[TextData[{
 "To create a BrowserIndex.nb file, click ",
 StyleBox["BrowserIndex", "SR"],
 " under ",
 StyleBox["Other", "SR"],
 "."
}], "BulletedList",
 CellTags->{"Handling a Project", "i:71"}],

Cell[TextData[{
 "To create page numbers for all notebooks in the project, click ",
 StyleBox["Paginate", "SR"],
 " under ",
 StyleBox["Other", "SR"],
 "."
}], "BulletedList",
 CellTags->{"Handling a Project", "i:71"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeIndex", "Subsection"],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[TextData[{
 "The MakeIndex palette enables you to generate an index for your notebook or \
project. ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "calculates page numbers for all the index entries that you specify and \
lists them in alphabetical order. Each entry in the index is hyperlinked to \
the related material in the source notebook(s)."
}], "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[CellGroupData[{

Cell[BoxData[
 ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "OpenCloseItemizedPicture",
   FormatType->StandardForm,
   ImageSize->{54, 13},
   ImageMargins->{{0, 0}, {0, 0}},
   ImageRegion->{{0, 1}, {0, 1}}],
  Active->True,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& )]], "OpenCloseItemizedPicture",
 CellTags->{"i:88", "MakeIndexIntro"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002S0001DR000`400?l00000o`00003oXomSIG/0
0003of=UNooooooooooo09oooooo0OmSIG/00003of=UNooooooo[JZm09ko[JZm0Oooool1of=UN`00
00?oHfEkoooooon]Z[d0WOmSIG/1ojfZ_@7ooooo0OmSIG/00004of=UNooooooo[JZmof=UNi_og]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UNi_og]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUon<^]H2omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjGohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NUon<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgYOoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjGohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
Uon<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQ7oS;[F
1Oooool3ohbjePCooooo0on<^]H2ooooo`?oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo
0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F1?ooool2ohbjeP;ooooo0_n<^]H2ooooo`?oS;[F
0_ooool4ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H4ooooo`;oS;[F0_ooool3ohbjeP;ooooo
0_n<^]H5ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F
0_ooool2ohbjeP;ooooo0_n<^]H2oooooa;oS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmh@ohbjeP;ooooo0on<^]H2ooooo`03ohbje_oooooooooo00;oS;[F
0_ooool00on<^]Koooooooooo`04ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`04ohbj
e_ooooooooooohbjeP?ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;o
S;[F0_ooool3ohbjeP;ooooo1?n<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo0_n<^]H2oooo
o`03ohbje_oooooooooo00;oS;[F0oooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Foooo
ooooool00_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2oooo
o`;oS;[F0_ooool2ohbjeP;ooooo4_n<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgQGoS;[F0_ooool00on<^]Koooooooooo`05ohbjeP;ooooo1?n<^]H2oooo
o`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Foooo
ooooool01_n<^]H4ooooo`CoS;[F0_ooool4ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool5
ohbjeP;ooooo0_n<^]H3ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02
ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo02;oS;[F0_oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhCohbjePCooooo00?oS;[Fooooooooool01?ooool0
0on<^]Koooooooooo`04ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooo
oooo00;oS;[F0_ooool00on<^]Koooooooooo`04ooooo`?oS;[F0_ooool5ohbjeP;ooooo1?n<^]H2
ooooo`04ohbje_ooooooooooohbjePKooooo00CoS;[FooooooooooooS;[F1?ooool2ohbjeP;ooooo
00CoS;[FooooooooooooS;[F0_ooool2ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00Co
oooo7_n<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQ7o
S;[F1Oooool2ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00CoS;[F0_ooool00on<^]Ko
ooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;o
S;[F0_ooool2ohbjePCooooo1?n<^]H5ooooo`04ohbje_ooooooooooohbjeP;ooooo00?oS;[Foooo
ooooool00_n<^]H2ooooo`06ohbje_ooooooooooohbje_ooooooS;[F0_ooool3ohbjePCooooo00?o
S;[Fooooooooool00_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo7_n<
^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQ3oS;[F1?oo
ool4ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00CoS;[F0_ooool01On<^]Kooooooooo
ooooooooS;[F00;ooooo00CoS;[FooooooooooooS;[F0oooool00on<^]Koooooooooo`02ohbjeP;o
oooo00?oS;[Fooooooooool00_n<^]H2ooooo`?oS;[F0_ooool4ohbjeP;ooooo00CoS;[Foooooooo
ooooS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_ooool01On<^]Kooooooooooon<^]Ko
oooo00?oS;[F0_ooool01On<^]KoooooooooooooooooS;[F00?ooooo00CoS;[FooooooooooooS;[F
0_ooool2ohbjeP;ooooo7_n<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgQ3oS;[F0_ooool7ohbjePCooooo00?oS;[Fooooooooool00_ooool3ohbjeP;ooooo
00CoS;[FooooooooooooS;[F0_ooool3ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H4ooooo`;o
S;[F0_ooool2ohbjeP;ooooo0on<^]H2ooooo`CoS;[F0_ooool00on<^]Koooooooooo`02ohbjePCo
oooo0_n<^]H3ooooo`;oS;[F0_ooool2ohbjePCooooo0_n<^]H2ooooo`05ohbje_oooooooooooooo
oon<^]H00_ooool3ohbjePCooooo7on<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgQ3oS;[F0_ooool3ohbjeP;ooooo2?n<^]H2ooooo`CoS;[F0_ooool<ohbj
eP;ooooo4On<^]H2ooooo`OoS;[F0_ooool8ohbjeP?ooooo0_n<^]H2ooooocOoS;[F0_oNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhAohbjePGooooo2_n<^]H00ooo
ooooS;[FohbjeP02ohbjeP;ooooo3?n<^]H2oooooa7oS;[F1Oooool01?n<^]Kooooooooooon<^]H2
ooooo`SoS;[F0_ooool3ohbjeP;ooooo=on<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgYOoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmjGohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`;og]_NUon<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2
omkKgYOoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjG
ohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUon<^]H2
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoS;[F0_oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGohbjeP;og]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUon<^]H2omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoS;[F0_oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGohbjeP;og]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_NUon<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgPOoS;[F0_ooool4ohbjeP;ooooo00?oS;[Fooooooooool00_ooool2
ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool2ohbjePCooooo0on<^]H3ooooo`?oS;[F1?ooool4
ohbjeP;ooooo0on<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo0on<^]H2ooooo`03ohbje_oo
oooooooo00;oS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H4ooooo`;oS;[F0_oo
ool2ohbjeP;ooooo0on<^]H6ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo00?o
S;[Fooooooooool00on<^]H2ooooo`;oS;[F1?ooool3ohbjePCooooo2On<^]H2omkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPOoS;[F0_ooool3ohbjeP;ooooo00?o
S;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo00?o
S;[Fooooooooool00_n<^]H2ooooo`;oS;[F0oooool2ohbjeP;ooooo0_n<^]H2ooooo`?oS;[F0_oo
ool3ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool3ohbjeP;ooooo00?oS;[Fooooooooool0
0_n<^]H2ooooo`04ohbje_ooooooooooohbjeP?ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03
ohbje_oooooooooo00;oS;[F0_ooool3ohbjeP;ooooo1On<^]H2ooooo`;oS;[F0_ooool00on<^]Ko
ooooooooo`02ohbjeP;ooooo0on<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Ko
ooooooooo`02ohbjeP;ooooo2?n<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgPOoS;[F0_ooool3ohbjeP;ooooo00?oS;[Fooooooooool01On<^]H2ooooo`;o
S;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`04ohbje_ooooooooooohbj
eP;ooooo00?oS;[Fooooooooool01on<^]H7ooooo`04ohbje_ooooooooooohbjeP;ooooo0on<^]H2
ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[F
ooooooooool01_n<^]H4ooooo`CoS;[F0_ooool5ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooo
oooo00;oS;[F0_ooool3ohbjeP;ooooo00?oS;[Fooooooooool02?n<^]H3ooooo`SoS;[F0_oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh7ohbjeP;ooooo0_n<^]H2
ooooo`;oS;[F1_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooo
oooo00;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`03ohbje_oooooooooo00Cooooo1?n<
^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`03ohbjeP;ooooo00?o
S;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Kooooooooo
o`04ooooo`?oS;[F0_ooool5ohbjeP;ooooo1On<^]H2ooooo`;oS;[F0_ooool00on<^]Kooooooooo
o`02ohbjeP;ooooo0on<^]H2ooooo`03ohbje_oooooooooo00Cooooo0_n<^]H4ooooo`WoS;[F0_oN
fmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh7ohbjePKooooo0_n<
^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oo
oooooooo00;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`03ohbje_oooooooooo00;oS;[F
0_ooool4ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00?oS;[F
0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbj
e_oooooooooo00;oS;[F0_ooool2ohbjePCooooo1?n<^]H6ooooo`03ohbje_oooooooooo00;oS;[F
0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0on<^]H2ooooo`03ohbje_oooooooooo00;oS;[F
0_ooool01?n<^]Koooooooooooooool;ohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_N1on<^]H2ooooo`?oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;o
oooo00GoS;[FooooooooooooooooohbjeP03ooooo`04ohbje_ooooooooooohbjeP;ooooo0_n<^]H4
ooooo`?oS;[F1?ooool2ohbjeP;ooooo1?n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool0
0on<^]Koooooooooo`03ohbjeP;ooooo00GoS;[FooooooooooooooooohbjeP02ooooo`04ohbje_oo
ooooooooohbjeP?ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F
0_ooool3ohbjeP;ooooo1On<^]H3ooooo`04ohbje_ooooooooooohbjeP;ooooo0_n<^]H2ooooo`?o
S;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`So
S;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh7ohbjeP;o
oooo0on<^]H2ooooo`;oS;[F1?ooool2ohbjeP;ooooo00GoS;[FooooooooooooooooohbjeP02oooo
o`?oS;[F1?ooool00on<^]Koooooooooo`03ohbjeP;ooooo00?oS;[Fooooooooool00_ooool5ohbj
eP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00?oS;[F0_ooool01?n<
^]Kooooooooooon<^]H2ooooo`?oS;[F0_ooool00on<^]Koooooooooo`02ohbjePCooooo0_n<^]H2
ooooo`;oS;[F0_ooool3ohbjeP;ooooo1On<^]H2ooooo`04ohbje_ooooooooooohbjePCooooo00?o
S;[Fooooooooool00_ooool00on<^]Koooooooooo`02ohbjePCooooo0on<^]H4ooooo`WoS;[F0_oN
fmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh7ohbjeP;ooooo0on<
^]H2ooooob_oS;[F0oooool3ohbjeP;ooooo00?oS;[Fooooooooool00on<^]H2ooooo`coS;[F0_oo
oolAohbjeP;ooooo3?n<^]H2oooooaooS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmh7ohbjePKooooo;?n<^]H3ooooo`?oS;[F0_ooool00on<^]Kooooooooo
o`03ohbjeP;ooooo3?n<^]H2oooooa7oS;[F1_ooool9ohbjeP03oooooon<^]KoS;[F00GoS;[F0_oo
oolFohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUon<
^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoS;[F0_oN
fmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGohbjeP;og]_N00?o
HfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUon<^]H2omkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoS;[F0_oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGohbjeP;og]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`;og]_NUon<^]H2omkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgYOoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmjGohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_NUon<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/2omkKgYOoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oN
fmjGohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N1On<
^]H2ooooo`CoS;[F0_ooool00on<^]Koooooooooo`02ooooo`;oS;[F0_ooool2ohbjeP;ooooo0_n<
^]H2ooooo`;oS;[F1?ooool3ohbjeP?ooooo0on<^]H4ooooo`KoS;[F1?ooool3ohbjeP;ooooo00?o
S;[Fooooooooool00on<^]H4ooooo`?oS;[F1?ooool2ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F0_oo
ool2ohbjePCooooo1?n<^]H6ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo00?o
S;[Fooooooooool00on<^]H2ooooo`;oS;[F1?ooool3ohbjePCooooo1on<^]H2omkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPGoS;[F0_ooool3ohbjeP;ooooo00?o
S;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo00?o
S;[Fooooooooool00_n<^]H2ooooo`;oS;[F0oooool2ohbjeP;ooooo0_n<^]H2ooooo`CoS;[F0_oo
ool2ohbjeP;ooooo0_n<^]H3ooooo`04ohbje_ooooooooooohbjeP;ooooo0_n<^]H2ooooo`03ohbj
e_oooooooooo00;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool00on<^]Ko
ooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`?oS;[F0_ooool5ohbjeP;ooooo0_n<^]H2ooooo`03
ohbje_oooooooooo00;oS;[F0_ooool3ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03
ohbje_oooooooooo00;oS;[F0_ooool6ohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_N1On<^]H2ooooo`?oS;[F0_ooool00on<^]Koooooooooo`05ohbjeP;o
oooo0_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00CoS;[Foooooooo
ooooS;[F0_ooool00on<^]Koooooooooo`07ohbjeP;ooooo1?n<^]H2ooooo`03ohbje_oooooooooo
00;oS;[F0_ooool4ohbjeP?ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`04ohbje_oooooooooo
ohbjeP;ooooo1On<^]H2ooooo`;oS;[F0_ooool7ohbjeP;ooooo1On<^]H2ooooo`;oS;[F0_ooool0
0on<^]Koooooooooo`02ohbjeP;ooooo0on<^]H2ooooo`03ohbje_oooooooooo00SoS;[F0oooool6
ohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N1On<^]H2
ooooo`;oS;[F0_ooool2ohbjePKooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F0_ooool0
0on<^]Koooooooooo`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool00on<^]Kooooooooo
o`04ooooo`?oS;[F0_ooool4ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F1?oo
ool2ohbjeP;ooooo0_n<^]H2ooooo`04ohbje_ooooooooooohbjePKooooo00?oS;[Fooooooooool0
0_n<^]H6ooooo`?oS;[F0_ooool5ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F
0_ooool3ohbjeP;ooooo00?oS;[Fooooooooool01?ooool2ohbjePCooooo1on<^]H2omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPGoS;[F1_ooool2ohbjeP;ooooo
0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool0
0_n<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`?o
S;[F0_ooool4ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`04ohbje_oooooooooooooo
o`CoS;[F0_ooool2ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool2ohbjeP;ooooo00?oS;[F
ooooooooool00_n<^]H2ooooo`;oS;[F0_ooool3ohbjePKooooo00?oS;[Fooooooooool00_n<^]H2
ooooo`03ohbje_oooooooooo00;oS;[F0_ooool3ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2
ooooo`04ohbje_ooooooooooooooo`WoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmh5ohbjeP;ooooo0on<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_oo
ool01On<^]KoooooooooooooooooS;[F00?ooooo00CoS;[FooooooooooooS;[F0_ooool2ohbjePCo
oooo0on<^]H4ooooo`;oS;[F0_ooool3ohbjeP;ooooo1?n<^]H2ooooo`05ohbje_oooooooooooooo
oon<^]H00_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2oooo
o`04ohbje_ooooooooooohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2
ohbjeP;ooooo0on<^]H2ooooo`GoS;[F0oooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_oo
ool3ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_oo
ool6ohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N1On<
^]H2ooooo`?oS;[F0_ooool2ohbjePCooooo0_n<^]H2ooooo`05ohbje_oooooooooooooooon<^]H0
0_ooool3ohbjePCooooo00?oS;[Fooooooooool00on<^]H2ooooo`03ohbje_oooooooooo00;ooooo
1?n<^]H2ooooo`CoS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`?oS;[F1?ooool3ohbjePCo
oooo0_n<^]H2ooooo`;oS;[F1?ooool00on<^]Koooooooooo`02ooooo`;oS;[F1?ooool4ohbjeP;o
oooo1On<^]H2ooooo`04ohbje_ooooooooooohbjePCooooo00?oS;[Fooooooooool00_ooool00on<
^]Koooooooooo`02ohbjePCooooo0on<^]H4ooooo`OoS;[F0_oNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk0_oNfmh5ohbjeP;ooooo0on<^]H2ooooob[oS;[F0_ooool2ohbj
eP;ooooo0_n<^]H2oooooa?oS;[F0_ooool8ohbjeP;ooooo2on<^]H2ooooo`coS;[F0_oooolMohbj
eP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N1On<^]H6oooo
obcoS;[F1?ooool3ohbjeP;ooooo4on<^]H2ooooo`WoS;[F00?oooooohbje_n<^]H02On<^]H6oooo
o`WoS;[F00?oooooohbje_n<^]H01On<^]H2oooooaCoS;[F0_oNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`;og]_NUon<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgYOoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmjGohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_NUon<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gYOoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGohbj
eP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUon<^]H2omkK
gP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoS;[F0_oNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGohbjeP;og]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N@_n<^]H4oooooe7oS;[F0_oNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmi1ohbjeP04oooooon<^]KoS;[F
ohbjeP;oooooD?n<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2
omkKgS;oS;[F0_ooool7ohbjePGooooo0_n<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo00?o
S;[Fooooooooool00_n<^]H2ooooo`;oS;[F1Oooool2ohbjeP;ooooo0_n<^]H4ooooocGoS;[F0_oN
fmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhbohbjeP;ooooo1_n<
^]H2ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H3ooooo`04ohbje_ooooooooooohbjeP;o
oooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;o
oooo0_n<^]H2ooooocCoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmhbohbjeP;ooooo1_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;o
oooo00CoS;[FooooooooooooS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2oooo
o`03ohbje_oooooooooo00;oS;[F0_oooolhohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`;og]_N<_n<^]H6ooooo`?oS;[F0_ooool01?n<^]Kooooooooooon<^]H2
ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool2ohbjeP;ooooo00Co
S;[FooooooooooooS;[F0_ooool2ohbjePKooooo=?n<^]H2omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgS;oS;[F0_ooool3ohbjeP;ooooo0on<^]H4ooooo`03ohbj
e_oooooooooo00;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool3ohbjePCo
oooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F0_ooooldohbjeP;og]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N<_n<^]H2ooooo`?oS;[F0_ooool00on<^]Ko
ooooohbjeP02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0oooool01?n<^]Kooooooooooon<^]H3
ooooo`05ohbje_ooooooooooohbje_ooool00on<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_oo
ool2ohbjeP;ooooo=?n<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/2omkKgS;oS;[F0_ooool3ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F0_ooool01?n<^]Kooooooooo
oon<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo0on<^]H4ooooo`03ohbje_oooooooooo00;o
oooo0_n<^]H4ooooocGoS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmhbohbjeP;ooooo0on<^]H2ooooob3oS;[F0_oooollohbjeP;og]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N<_n<^]H6oooooa3oS;[F0_ooool@ohbjeP03
oooooon<^]KoS;[F03[oS;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmjGohbjeP;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_NUon<^]H2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOo
S;[F0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGohbjeP;o
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUon<^]H2omkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_o
ooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQ;o
DYJe0_ooool2oe:F]@03oooooomBU[GoDYJe00;ooooo0_mBU[D5ooooo`03oe:F]Ooooooooooo00;o
DYJe0_ooool2oe:F]@Cooooo1?mBU[D6ooooo`;oDYJe0_ooool4oe:F]@Cooooo0omBU[D2ooooo`?o
DYJe0_ooool3oe:F]@Cooooo0omBU[D4ooooo`;oDYJe0_ooool5oe:F]@;ooooo00?oDYJeoooooooo
ool00_mBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@Cooooo0_mBU[D2ooooo`;o
DYJe0_oooolCoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_N4_mBU[D2ooooo`05oe:F]OoooooooooooooooomBU[D00_ooool00omBU[Goooooooooo`02oe:F
]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F
]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool2oe:F]@;ooooo0_mBU[D3oooo
o`04oe:F]Oooooooooooooooo`;oDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2
ooooo`03oe:F]Ooooooooooo00GoDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00CoDYJe
ooooooooooooDYJe0oooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2oooooa?oDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oN
fmhBoe:F]@;ooooo00GoDYJeoooooooooooooooooe:F]@02ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe0_ooool7oe:F]@;ooooo0omBU[D2ooooo`03
oe:F]Ooooooooooo00?oDYJe0_ooool2oe:F]@;ooooo0_mBU[D3ooooo`04oe:F]Ooooooooooooooo
o`GoDYJe0oooool00omBU[Goooooooooo`05oe:F]@;ooooo1OmBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool01_mBU[D4oooo
oaCoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhBoe:F
]@;ooooo00GoDYJeoooooomBU[Gooooooe:F]@02ooooo`;oDYJe0_ooool01?mBU[GooooooooooomB
U[D5ooooo`;oDYJe1_ooool3oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_oo
ool2oe:F]@;ooooo00SoDYJeooooooooooooDYJeoooooomBU[Gooooooe:F]@;ooooo0_mBU[D4oooo
o`;oDYJe1_ooool00omBU[Goooooooooo`05oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooo
o`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`04ooooo`?oDYJe0_oooolEoe:F
]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N4_mBU[D2oooo
o`05oe:F]OooooooDYJeoooooomBU[D00_ooool3oe:F]@Cooooo00?oDYJeooooooooool00_ooool3
oe:F]@;ooooo0_mBU[D2ooooo`?oDYJe1_ooool2oe:F]@;ooooo0omBU[D2ooooo`;oDYJe0_ooool0
1?mBU[GooooooooooomBU[D3ooooo`04oe:F]Ooooooooooooe:F]@?ooooo1?mBU[D2ooooo`;oDYJe
0_ooool00omBU[Goooooooooo`05oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F
]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D4oooooaCoDYJe
0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhBoe:F]@Cooooo
00?oDYJeooooooooool00_ooool00omBU[Gooooooe:F]@02oe:F]@;ooooo00CoDYJeoooooooooooo
DYJe0_ooool2oe:F]@;ooooo0_mBU[D2ooooo`?oDYJe0_ooool3oe:F]@;ooooo00?oDYJeoooooooo
ool00omBU[D2ooooo`;oDYJe0_ooool01?mBU[GooooooooooomBU[D3ooooo`04oe:F]Ooooooooooo
oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`05
oe:F]@;ooooo00GoDYJeoooooooooooooooooe:F]@02ooooo`04oe:F]Ooooooooooooe:F]@?ooooo
00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_oooolCoe:F]@;og]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N4_mBU[D4ooooo`03oe:F
]Ooooooooooo00;ooooo0_mBU[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D4ooooo`CoDYJe
0_ooool3oe:F]@;ooooo00?oDYJeooooooooool00_ooool2oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe
00?ooooooe:F]OmBU[D00_ooool2oe:F]@Cooooo0omBU[D4ooooo`;oDYJe1?ooool3oe:F]@;ooooo
00CoDYJeooooooooooooDYJe0_ooool3oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D4ooooo`;o
DYJe0_ooool2oe:F]@;ooooo4omBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgQ;oDYJe0oooool3oe:F]@?ooooo2?mBU[D2ooooo`koDYJe0_ooool3oe:F]@;o
oooo;?mBU[D2ooooo`coDYJe0_oooolQoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_N4_mBU[D3ooooo`?oDYJe0oooool8oe:F]@;ooooo3_mBU[D6ooooobgo
DYJe0_ooool<oe:F]@;ooooo8OmBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOo
DYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;o
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_o
ooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOo
DYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh8oe:F]@;o
oooo0_mBU[D00oooooooDYJeoe:F]@02ooooo`;oDYJe1Oooool00omBU[Goooooooooo`02oe:F]@;o
oooo0_mBU[D4ooooo`KoDYJe0_ooool4oe:F]@;ooooo0omBU[D2ooooo`?oDYJe1?ooool6oe:F]@Co
oooo0omBU[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F
]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo00?oDYJeoooo
ooooool00_mBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@Cooooo0_mBU[D2oooo
o`;oDYJe0_ooool9oe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_N2?mBU[D2ooooo`05oe:F]OoooooooooooooooomBU[D00_ooool00omBU[Goooooooooo`02
oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool5
oe:F]@;ooooo1?mBU[D3ooooo`04oe:F]Oooooooooooooooo`;oDYJe0_ooool2oe:F]@;ooooo1?mB
U[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00CoDYJeooooooooooooDYJe
0_ooool01OmBU[GoooooooooooooooooDYJe00;ooooo0_mBU[D2ooooo`;oDYJe0_ooool00omBU[Go
ooooooooo`02oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool01?mBU[Go
oooooooooomBU[D3ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F
]@;ooooo2OmBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gPSoDYJe0_ooool01OmBU[GoooooooooooooooooDYJe00;ooooo00?oDYJeooooooooool00_mBU[D2
ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`WoDYJe0_ooool4oe:F]@?ooooo00Co
DYJeoooooooooooooooo0_mBU[D2ooooo`;oDYJe0_ooool3oe:F]@;ooooo1_mBU[D2ooooo`;oDYJe
0_ooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;o
oooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo00?oDYJeoooooooo
ool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`06oe:F]@Co
oooo2_mBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPSo
DYJe0_ooool01OmBU[Gooooooe:F]OooooooDYJe00;ooooo0_mBU[D2ooooo`04oe:F]Ooooooooooo
oe:F]@Gooooo0_mBU[D6ooooo`GoDYJe0_ooool3oe:F]@;ooooo00GoDYJeoooooomBU[Gooooooe:F
]@02ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo1_mBU[D2ooooo`;oDYJe0_oo
ool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo
0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo00?oDYJeooooooooool0
0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`04ooooo`?oDYJe
0_ooool;oe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
2?mBU[D2ooooo`05oe:F]OooooooDYJeoooooomBU[D00_ooool3oe:F]@Cooooo00?oDYJeoooooooo
ool00_ooool3oe:F]@;ooooo0_mBU[D2ooooo`GoDYJe0_ooool3oe:F]@;ooooo00GoDYJeoooooooo
oooooooooe:F]@02ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo1_mBU[D2oooo
o`;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02
oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo00?oDYJe
ooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02
oe:F]@;ooooo0_mBU[D4ooooo`[oDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmh8oe:F]@Cooooo00?oDYJeooooooooool00_ooool00omBU[Gooooooe:F]@02
oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@;ooooo0_mBU[D2ooooo`GoDYJe0_oo
ool3oe:F]@;ooooo00GoDYJeoooooooooooooooooe:F]@02ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool3oe:F]@;ooooo1_mBU[D2ooooo`;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;o
DYJe0_ooool01OmBU[GoooooooooooooooooDYJe00?ooooo00CoDYJeooooooooooooDYJe0oooool0
0omBU[Goooooooooo`03oe:F]@;ooooo00GoDYJeoooooooooooooooooe:F]@02ooooo`04oe:F]Ooo
oooooooooe:F]@?ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool9oe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
2?mBU[D4ooooo`03oe:F]Ooooooooooo00;ooooo0_mBU[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo
0_mBU[D4ooooo`KoDYJe0_ooool3oe:F]@;ooooo0_mBU[D00oooooooDYJeoe:F]@02ooooo`;oDYJe
1?ooool4oe:F]@;ooooo1omBU[D4ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo
00CoDYJeooooooooooooDYJe0oooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeoooooooo
ool01?mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe1?ooool2oe:F]@;ooooo0_mBU[D2ooooo`WoDYJe0_oNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk0_oNfmh8oe:F]@?ooooo0omBU[D3ooooo`SoDYJe0_ooool@oe:F
]@;ooooo5omBU[D2ooooo`;oDYJe0_ooool8oe:F]@;ooooo7?mBU[D2ooooo`coDYJe0_oooolGoe:F
]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N2?mBU[D3oooo
o`?oDYJe0oooool8oe:F]@;ooooo3_mBU[D6oooooaKoDYJe1?ooool9oe:F]@;ooooo7?mBU[D2oooo
o`coDYJe0_oooolGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F
]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkK
gP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F
]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkK
gP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQcoDYJe0_ooool2oe:F
]@03oooooomBU[GoDYJe00;ooooo0_mBU[D5ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F
]@Cooooo1?mBU[D6ooooo`?oDYJe1?ooool3oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe0_ooool3oe:F
]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F
]@Cooooo0_mBU[D2ooooo`;oDYJe0_oooolMoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`;og]_N7?mBU[D2ooooo`05oe:F]OoooooooooooooooomBU[D00_ooool0
0omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooo
oooo00;oDYJe0_ooool3oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool0
0omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`?oDYJe0_ooool0
0omBU[Goooooooooo`02oe:F]@;ooooo00CoDYJeooooooooooooDYJe0oooool00omBU[Gooooooooo
o`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooooagoDYJe0_oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhLoe:F]@;ooooo00GoDYJeoooooooooooooooo
oe:F]@02ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;o
DYJe0_ooool7oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Go
ooooooooo`02oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool4oe:F]@;ooooo00?oDYJeoooo
ooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`06oe:F
]@Cooooo7_mBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gQcoDYJe0_ooool01OmBU[Gooooooe:F]OooooooDYJe00;ooooo0_mBU[D2ooooo`04oe:F]Ooooooo
oooooe:F]@Gooooo0_mBU[D6ooooo`?oDYJe0_ooool3oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`03ooooo`CoDYJe0_oo
ool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooo
oooooooo00Cooooo0omBU[D2oooooaooDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmhLoe:F]@;ooooo00GoDYJeoooooomBU[Gooooooe:F]@02ooooo`?oDYJe
1?ooool00omBU[Goooooooooo`02ooooo`?oDYJe0_ooool2oe:F]@;ooooo0omBU[D6ooooo`;oDYJe
0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;ooooo
1OmBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo
00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe1?oooolNoe:F]@;og]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N7?mBU[D4ooooo`03oe:F]Ooooooooooo00;ooooo
00?oDYJeoooooomBU[D00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`;o
DYJe0_ooool3oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Go
ooooooooo`02oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool4oe:F]@;ooooo00GoDYJeoooo
oooooooooooooe:F]@02ooooo`04oe:F]Ooooooooooooe:F]@?ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_oooolMoe:F]@;og]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`;og]_N7?mBU[D4ooooo`03oe:F]Ooooooooooo00;ooooo0_mB
U[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D4ooooo`CoDYJe0_ooool3oe:F]@;ooooo0_mB
U[D4ooooo`?oDYJe1?ooool2oe:F]@;ooooo0_mBU[D2ooooo`?oDYJe0_ooool01?mBU[Gooooooooo
oomBU[D2ooooo`?oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe
0_oooolMoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
7?mBU[D3ooooo`?oDYJe0oooool8oe:F]@;ooooo3_mBU[D2ooooo`?oDYJe0_ooool?oe:F]@;ooooo
1omBU[D2ooooo`coDYJe0_ooool[oe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_N7?mBU[D3ooooo`?oDYJe0oooool8oe:F]@;ooooo3_mBU[D6oooooa3oDYJe
0_ooool7oe:F]@;ooooo3?mBU[D2ooooob_oDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
UomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe
0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgTkoDYJe0_oooom7oe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NC_mBU[D2ooooodOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmhGoe:F]@;ooooo0_mBU[D00oooooooDYJeoe:F]@02ooooo`;oDYJe
1Oooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D4ooooo`GoDYJe1Oooool2oe:F]@;ooooo
00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;o
DYJe0_ooool2oe:F]@Cooooo1?mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@;o
oooo00?oDYJeooooooooool00_mBU[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo6?mBU[D2omkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQOoDYJe0_ooool01OmBU[Go
ooooooooooooooooDYJe00;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0omBU[D2ooooo`?oDYJe0_ooool01?mB
U[GooooooooooomBU[D2ooooo`;oDYJe0_ooool2oe:F]@;ooooo00GoDYJeoooooooooooooooooe:F
]@02ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`?oDYJe0_ooool00omBU[Gooooo
ooooo`02oe:F]@;ooooo00CoDYJeooooooooooooDYJe0oooool00omBU[Goooooooooo`02oe:F]@;o
oooo00?oDYJeooooooooool00_mBU[D2oooooaSoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk0_oNfmhGoe:F]@;ooooo00GoDYJeoooooooooooooooooe:F]@02oooo
o`03oe:F]Ooooooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe0_ooool<
oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`OoDYJe0_ooool00omBU[Gooooo
ooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00KoDYJe
1?oooolIoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
5omBU[D2ooooo`05oe:F]OooooooDYJeoooooomBU[D00_ooool2oe:F]@;ooooo00CoDYJeoooooooo
ooooDYJe1Oooool2oe:F]@Kooooo1_mBU[D4ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2
ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00CoDYJeooooooooooooDYJe1_oo
ool3oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_oo
ool00omBU[Goooooooooo`04ooooo`?oDYJe0_oooolJoe:F]@;og]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`;og]_N5omBU[D2ooooo`05oe:F]OooooooDYJeoooooomBU[D0
0_ooool3oe:F]@Cooooo00?oDYJeooooooooool00_ooool3oe:F]@;ooooo0_mBU[D2ooooo`CoDYJe
1Oooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe0_ooool00omBU[Gooooo
ooooo`02oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@;ooooo0omBU[D2ooooo`03
oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeoooooooo
ool00_mBU[D2ooooo`;oDYJe1?oooolIoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_N5omBU[D4ooooo`03oe:F]Ooooooooooo00;ooooo00?oDYJeoooooomB
U[D00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`;oDYJe0_ooool3oe:F
]@Cooooo1?mBU[D2ooooo`05oe:F]OoooooooooooooooomBU[D00oooool01?mBU[GooooooooooomB
U[D3ooooo`04oe:F]Ooooooooooooe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`?oDYJe
0_ooool01OmBU[GoooooooooooooooooDYJe00;ooooo00CoDYJeooooooooooooDYJe0oooool00omB
U[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooooaSoDYJe0_oNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhGoe:F]@Cooooo00?oDYJeoooo
ooooool00_ooool2oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe0_ooool2oe:F]@Cooooo1?mBU[D2oooo
o`KoDYJe0_ooool01?mBU[GooooooooooomBU[D3ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool0
0omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D4ooooo`CoDYJe0_ooool01?mBU[GooooooooooomB
U[D2ooooo`?oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe0_oo
oolHoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N5omB
U[D3ooooo`?oDYJe0oooool8oe:F]@;ooooo3_mBU[D2ooooo`?oDYJe0_oooolFoe:F]@;ooooo2_mB
U[D2ooooo`coDYJe0_oooolVoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_N5omBU[D3ooooo`?oDYJe0oooool8oe:F]@;ooooo3omBU[D5ooooo`;oDYJe0_oo
oolCoe:F]@;ooooo2_mBU[D2ooooo`coDYJe0_oooolVoe:F]@;og]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oN
fmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomB
U[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oN
fmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?o
HfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/2omkKgPcoDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe1?ooool2oe:F]@;ooooo0_mBU[D2ooooo`GoDYJe1?ooool3oe:F]@Cooooo0_mB
U[D2ooooo`03oe:F]Ooooooooooo00GoDYJe1?ooool3oe:F]@;ooooo0_mBU[D2ooooo`CoDYJe1Ooo
ool3oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe1?ooool3oe:F]@Cooooo0omBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe1?ooool2oe:F]@;ooooo0_mBU[D2ooooo`goDYJe0_oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh<oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`04oe:F]Ooooooooooooe:F]@?ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F
]Ooooooooooo00;oDYJe0_ooool4oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool01?mBU[GooooooooooomBU[D2ooooo`CoDYJe0_ooool2oe:F]@;ooooo0_mBU[D2ooooo`;o
DYJe0_ooool3oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool01?mBU[Go
oooooooooomBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeoooo
ooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F
]@;ooooo3OmBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gPcoDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooo
o`03oe:F]Ooooooooooo00KoDYJe1?ooool4oe:F]@;ooooo1_mBU[D2ooooo`GoDYJe0_ooool00omB
U[Goooooooooo`03oe:F]@;ooooo1?mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool8oe:F
]@;ooooo00?oDYJeooooooooool01OmBU[D2ooooo`03oe:F]Ooooooooooo00GoDYJe0_ooool5oe:F
]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F
]@;ooooo3OmBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gPcoDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooo
o`03oe:F]Ooooooooooo00Cooooo0omBU[D2ooooo`GoDYJe0_ooool6oe:F]@Kooooo00CoDYJeoooo
ooooooooDYJe0_ooool3oe:F]@;ooooo1?mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool6
oe:F]@Cooooo00?oDYJeooooooooool01?ooool01?mBU[GooooooooooomBU[D6ooooo`03oe:F]Ooo
oooooooo00GoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool=oe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_N3?mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Gooooooooo
o`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe1?ooool4oe:F]@;ooooo1_mB
U[D2ooooo`;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`?oDYJe0_ooool4oe:F]@;ooooo
00?oDYJeooooooooool00_mBU[D2ooooo`CoDYJe1Oooool2oe:F]@;ooooo0_mBU[D2ooooo`04oe:F
]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00GoDYJe0_ooool2oe:F]@;o
oooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool=oe:F]@;o
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N3?mBU[D2ooooo`05
oe:F]OoooooooooooooooomBU[D00_ooool01?mBU[GooooooooooomBU[D3ooooo`03oe:F]Ooooooo
oooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0omBU[D2ooooo`KoDYJe0_ooool2
oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool3oe:F]@;ooooo1?mBU[D2ooooo`05oe:F]Ooo
oooooooooooooomBU[D00_ooool3oe:F]@Cooooo1?mBU[D2ooooo`;oDYJe0_ooool01?mBU[Gooooo
oooooomBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeoooooooo
ool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool01OmBU[GoooooooooooooooooDYJe
00;ooooo3OmBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gPcoDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`?oDYJe0_ooool00omBU[Goooooooooo`02
oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe0_ooool3oe:F]@;ooooo1omBU[D4ooooo`;oDYJe0_ooool0
0omBU[Goooooooooo`03oe:F]@;ooooo1?mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo1?mB
U[D2ooooo`OoDYJe1?ooool2oe:F]@;ooooo0_mBU[D4ooooo`?oDYJe1?ooool00omBU[Gooooooooo
o`02ooooo`03oe:F]Ooooooooooo00;oDYJe1?ooool2oe:F]@;ooooo00?oDYJeooooooooool03_mB
U[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPcoDYJe0_oo
ool<oe:F]@;ooooo4_mBU[D2ooooo`;oDYJe0_ooool8oe:F]@;ooooo00?oDYJeooooooooool01?mB
U[D2ooooo`;oDYJe0_ooool;oe:F]@;ooooo0omBU[D2ooooo`SoDYJe0_ooool?oe:F]@;ooooo7omB
U[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPcoDYJe0_oo
ool<oe:F]@;ooooo4omBU[D4ooooo`WoDYJe0_ooool00omBU[Goooooooooo`05oe:F]@Cooooo3OmB
U[D5ooooo`WoDYJe0_ooool@oe:F]@03oooooomBU[GoDYJe00;ooooo6omBU[D2omkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oN
fmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomB
U[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oN
fmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?o
HfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmh>oe:F]@Kooooo0_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo
0_mBU[D2ooooo`?oDYJe0_ooool3oe:F]@;ooooo0_mBU[D4ooooo`?oDYJe0_ooool2oe:F]@Cooooo
0_mBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe1?ooool3oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe
0_ooool3oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe0_ooool00omBU[Gooooo
ooooo`02oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D2ooooo`;oDYJe
0_ooool@oe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
3_mBU[D2ooooo`GoDYJe0_ooool01OmBU[GoooooooooooooooooDYJe00;ooooo00?oDYJeoooooooo
ool01?mBU[D2ooooo`;oDYJe0oooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeoooooooo
ool00_mBU[D2ooooo`;oDYJe0_ooool01OmBU[GoooooooooooooooooDYJe00;ooooo00?oDYJeoooo
ooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F
]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D3
ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2
ooooo`;oDYJe0_ooool2oe:F]@;ooooo4?mBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgPkoDYJe0_ooool5oe:F]@;ooooo0_mBU[D2ooooo`04oe:F]Ooooooo
oooooe:F]@;ooooo1?mBU[D2ooooo`;oDYJe0oooool00omBU[Goooooooooo`02oe:F]@;ooooo00?o
DYJeooooooooool00_mBU[D2ooooo`GoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`CoDYJe
0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F
]Ooooooooooo00KoDYJe1?oooolMoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_N3_mBU[D2ooooo`GoDYJe0_ooool2oe:F]@;ooooo00CoDYJeoooooooooooo
DYJe0_ooool4oe:F]@;ooooo00?oDYJeooooooooool00_ooool00omBU[Goooooooooo`02oe:F]@;o
oooo00?oDYJeooooooooool00_mBU[D6ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Go
ooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00?o
oooo1?mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;o
oooo00?oDYJeooooooooool01?ooool3oe:F]@;ooooo7_mBU[D2omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPkoDYJe1_ooool00omBU[Goooooooooo`02oe:F]@;o
oooo00CoDYJeooooooooooooDYJe0_ooool4oe:F]@;ooooo00?oDYJeoooooomBU[D00_ooool00omB
U[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe0_ooool00omB
U[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool00omBU[Goooooooooo`02ooooo`GoDYJe0_ooool00omBU[Goooooooooo`02oe:F
]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F
]@Cooooo7OmBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gPkoDYJe0_ooool5oe:F]@;ooooo00GoDYJeoooooooooooooooooe:F]@02ooooo`03oe:F]Ooooooo
oooo00CoDYJe1?ooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe0_ooool00omBU[Gooooooooo
o`02oe:F]@;ooooo0_mBU[D2ooooo`05oe:F]OoooooooooooooooomBU[D00_ooool00omBU[Gooooo
ooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;o
oooo1?mBU[D2ooooo`05oe:F]OoooooooooooooooomBU[D00_ooool01?mBU[GooooooooooomBU[D3
ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo7?mBU[D2
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPkoDYJe0_ooool6
oe:F]@;ooooo00CoDYJeooooooooooooDYJe1_ooool3oe:F]@?ooooo0_mBU[D2ooooo`;oDYJe1?oo
ool00omBU[Goooooooooo`02ooooo`;oDYJe1?ooool2oe:F]@;ooooo00?oDYJeooooooooool00omB
U[D4ooooo`?oDYJe1?ooool2oe:F]@;ooooo0_mBU[D2ooooo`?oDYJe0_ooool01?mBU[Gooooooooo
oomBU[D2ooooo`?oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe
0_oooolLoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
3_mBU[D2ooooo`WoDYJe0_ooool4oe:F]@;ooooo1?mBU[D3ooooo`;oDYJe0_ooool8oe:F]@;ooooo
2OmBU[D2oooooa?oDYJe0_ooool7oe:F]@;ooooo3?mBU[D2ooooob[oDYJe0_oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh>oe:F]@Kooooo1OmBU[D2ooooo`03oe:F
]Ooooooooooo00;oDYJe00?ooooooe:F]OmBU[D00_mBU[D2ooooo`?oDYJe0_ooool9oe:F]@03oooo
oomBU[GoDYJe00OoDYJe0_oooolCoe:F]@;ooooo1omBU[D2ooooo`coDYJe0_oooolZoe:F]@;og]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgYOoDYJe0_oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjGoe:F]@;og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NUomBU[D2omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG^KomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^KomkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^KomkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG^KomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG^KomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgY?o0000
1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjCo`1AS0Cog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NTol0DH`4omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgY?o056<1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjCo`1AS0Cog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NTol0DH`4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgY?o056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmjCo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`Cog]_NTol0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/4omkKgY?o056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
1?oNfmiSo`1AS1coDYJe5?l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/4omkKgV?o056<7?mBU[DDo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`Cog]_NHol0DH`Loe:F]ACo056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmiSo`1AS1coDYJe5?l0DH`4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgV?o056<7?mBU[DDo`1AS0Cog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NHol0DH`Loe:F]ACo056<1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmiSo`1AS1coDYJe5?l0DH`4omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgV?o056<7?mBU[DDo`1AS0Cog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NHol0DH`Loe:F]ACo056<
1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1AS0;ooooo
0ol0DH`01?oooooo056<o`1AS?l0DH`2ooooo`?o056<0oooool01?l0DHcoooooooooool0DH`2oooo
o`;o056<0_ooool4o`1AS0Cooooo1_l0DH`2ooooo`;o056<0_ooool3o`1AS0;ooooo1?l0DH`2oooo
o`03o`1AS?oooooooooo00Co056<1?ooool3o`1AS0;ooooo0_l0DH`2ooooo`[o056<3?mBU[D2oooo
o`koDYJe5?l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkK
gP_o056<0_ooool2o`1AS0?ooooo0_l0DH`2ooooo`;o056<1_ooool2o`1AS0;ooooo0_l0DH`2oooo
o`?o056<1_ooool5o`1AS0;ooooo0_l0DH`2ooooo`?o056<0_ooool3o`1AS0Kooooo0ol0DH`6oooo
o`;o056<0_ooool2o`1AS0;ooooo2_l0DH`<oe:F]@;ooooo3_mBU[DDo`1AS0Cog]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`2ooooo`;o056<0oooool2o`1A
S0;ooooo0_l0DH`2ooooo`;o056<0_ooool2o`1AS0;ooooo00?o056<ooooooooool00ol0DH`2oooo
o`[o056<0_ooool2o`1AS0;ooooo0ol0DH`2ooooo`;o056<0oooool01?l0DHcoooooooooooooool2
o`1AS0;ooooo2?l0DH`4ooooo`_o056<7?mBU[DDo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`2ooooo`;o056<00?oooooo`1AS?ooool00_l0DH`2
ooooo`?o056<0_ooool00ol0DHcoooooooooo`02o`1AS0Gooooo0ol0DH`7ooooo`Go056<0_ooool2
o`1AS0;ooooo0ol0DH`2ooooo`;o056<0_ooool3o`1AS0;ooooo0_l0DH`7ooooo`Co056<0_ooool<
o`1AS0coDYJe0_ooool>oe:F]ACo056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmh;o`1AS0;ooooo00Co056<oooooooooooo056<0_ooool00ol0DHcooooooooo
o`04o`1AS0Cooooo0_l0DH`4ooooo`Co056<1oooool5o`1AS0;ooooo0_l0DH`2ooooo`?o056<0_oo
ool2o`1AS0;ooooo0ol0DH`2ooooo`;o056<1oooool4o`1AS0;ooooo3?l0DH`<oe:F]@;ooooo3_mB
U[DDo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0
DH`2ooooo`04o`1AS?ooooooooooo`1AS0;ooooo00?o056<ooooooooool01_l0DH`2ooooo`;o056<
1?ooool4o`1AS0;ooooo0ol0DH`2ooooo`Go056<0_ooool2o`1AS0?ooooo0_l0DH`2ooooo`;o056<
0oooool01?l0DHcoooooooooooooool2o`1AS0;ooooo0ol0DH`2ooooo`?o056<1?ooool;o`1AS0go
DYJe0_ooool=oe:F]ACo056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk1?oNfmh;o`1AS0;ooooo00?o056<ooooool0DH`00_l0DH`01?oooooo056<ooooooooool2o`1A
S0Kooooo0_l0DH`2ooooo`03o`1AS?oooooooooo00Co056<1Oooool6o`1AS0;ooooo0_l0DH`7oooo
o`?o056<1_ooool3o`1AS0Gooooo0ol0DH`2ooooo`;o056<0_ooool:o`1AS0koDYJe0_ooool<oe:F
]ACo056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1A
S0Cooooo0ol0DH`4ooooo`?o056<1?ooool3o`1AS0;ooooo0_l0DH`2ooooo`Co056<0oooool7o`1A
S0;ooooo0_l0DH`2ooooo`04o`1AS?ooooooooooooooo`Go056<0_ooool00ol0DHcoooooooooo`04
o`1AS0?ooooo1?l0DH`2ooooo`;o056<0_ooool:o`1AS0[oDYJe0_ooool2oe:F]@;ooooo3?mBU[DD
o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`4
ooooo`?o056<1?ooool:o`1AS0;ooooo4_l0DH`2oooooa3o056<0_oooolKo`1AS0_oDYJe1?ooool=
oe:F]ACo056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;
o`1AS0?ooooo1Ol0DH`3ooooo`[o056<0_oooolBo`1AS0;ooooo4?l0DH`2oooooa_o056<7?mBU[DD
o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NHol0DH`L
oe:F]ACo056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmiS
o`1AS1coDYJe5?l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgV?o056<7?mBU[DDo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`Cog]_NHol0DH`Loe:F]ACo056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmiSo`1AS1coDYJe5?l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/4omkKgV?o056<7?mBU[DDo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`Cog]_NTol0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/4omkKgY?o056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmjCo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`Cog]_NTol0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgY?o056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjC
o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NTol0DH`4
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgY?o056<1?oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjCo`1AS0Cog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NTol00004omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgY?o00001?oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`00001>o`0004Kog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l00000C_l00016
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So
000004ko0000A_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh0
0ol0003o20P8o`00000?o`000003ob4P8Om2@D;o410@00oo00000_la<34?o`0000;o<C0a1Ol00002
oc4`<@Oo00000_lQ824:o`0004Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`Cog]_N00?o0000o`P82?l000001?l000000onLWYcoooooog=aL`04o`0000;ooooo00?o410@
og=aLoooool00_ooool02?n<SXco0000oa0@4?oooooo_Kjmo`000?nm_[gooooo0_l000001OoNgmko
ooooo`000?l@413oc/o>00;ooooo00Kog]oNoe9AD_l0003oLg5coooooom2@D83o`000006oa0@4?oo
oooo<C0ao`000?l@413oc/o>0_ooool01OoNgmko<C0ao`000?l@413oc/o>00;ooooo00[og]oNoc4`
<Ol0003oDU5BomkOg_l0003oLg5coooooooNgmkoW9jL2Ol00016omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000000Co000000Co8B0Qono_koo_
knoo410@0_l000001?la<37oooooomkOg_l00002ooooo`0Iof=QHon][Zgoooooof=QHol0003og]oN
ono_kol0003oW9jLoooooom2@D;o0000okfn_Ooooooo8B0QoibNW?oooooo[Jj]og=aLoo_knoooooo
od91@_mSHF?oooooog=aL`04o`00000Iono_komBDE;o0000oibNW?o>clko410@o`000?mcLG?okno_
ob4P8OnLWYcoc/o>oa0@4?l0003oLg5cono_kolQ827o<C0aooooool0003o@T52oc4`<Ol0003oc/o>
of=QH`08o`0004Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N
00?o0000o`P82?l000001Ol000000omcLG?oooooooooo`04ooooo`0MoibNW?l0003oooooolk?c_l0
003o8B0Qoooooonm_[go0000okfn_Ooooooo410@og=aLoooooooHf5So`000?mcLG?ooooood91@_nm
_[goooooob4P8Ol0003o<C0aoooooon][Zgo@T52oooooonLWY`01?l000001Onm_[goLg5co`000?nm
_[goLg5c00?o00000_nLWY`00onm_[goLg5co`000002o`0000;oW9jL00?o0000oooooola<3400_l0
00000omSHF?okno_of=QH`08o`0004Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`Cog]_N00?o0000o`P82?l000001Ol000002ol@413okno_ooooooo>clko_Kjmono_kooo
ooooLg5co`000?o>clkooooo00;o00000_o_knl00ol0003oS8j<ooooo`02od91@P09oooooomcLG?o
0000of=QHoooooooLg5cojf^[Ooooooo8B0Q00;o00000_ooool00ol0003oooooolk?cP04o`000005
ohb>S?nLWYco0000oibNW?n<SX`00ol000001?mcLG?o_KjmoibNW?n<SX`3o`000009og=aLonm_[go
0000olk?c_mBDE;o0000okfn_Oo_knooLg5c00Wo0000A_oNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`000006o`00000oog=aLoooooooLg5co`00
0?nm_[gooooood91@_l0003o[Jj]oooooola<37o0000okfn_Ooooooo0000oibNW?ooooooS8j<ob4P
8Ooooooog]oNoa0@4?mBDE;oooooog=aLomBDE;oooooolk?c_l@413o@T52ooooooo_knoo0000omkO
g_ooooooHf5So`000?l@413o0000og=aLonm_[go0000oc4`<OooooooHf5So`000?l@413oc/o>oibN
W?la<37oooooof=QHol0003o410@olk?c_nLWYco0000ojf^[OmcLG?o0000oooooolQ827o410@00Wo
0000A_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o
20P8o`000007o`000005omkOg_o_knoo0000ono_koooool00_l000002?mcLG?ooooood91@_l0003o
W9jLoooooom2@D;og]oN0_ooool01?nm_[goooooooooooo_knl2ooooo`03og=aLol0003oW9jL00Co
oooo00?oLg5co`000?nm_[d00oooool01?mSHF?o0000od91@_ooool2o`000008oe9AD_oNgmkog]oN
ooooooo>clko8B0Qo`000?mBDE82omkOgP0;ooooooo>clko8B0Qo`000?mcLG?o[Jj]o`000?n<SXco
g]oNono_kom2@D802?l00016omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/4omkKgP03o`000?l820So000000Oo000000GoHf5SoooooomcLG?oooooolk?cP02o`00000>od91
@_mcLG?o@T52o`000?m2@D;oLg5cob4P8OmSHF?oooooomkOg_mSHF?oc/o>oooooom2@D82og=aL`?o
000000Co@T52og=aLomcLG?o@T520_l000002OmBDE;oLg5cod91@_mcLG?o@T52o`000?lQ827ooooo
ob4P8@03o`0000;o@T521Ol00002od91@P?o000000CoHf5Sokfn_Ol0003o00000_la<349o`0004Ko
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l0
00002?l000001?oNgmkooooooooooon<SX`:o`000006oooooooNgmko0000ojf^[Ooooooo<C0a4_l0
00000ooooooo@T52o`00000>o`000003od91@_oooooo000000co0000A_oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`000008o`000004od91@_oo
ooooooooof=QH`[o000000KoHf5Sog=aLol0003oLg5coooooomBDE8@o`0000;o@T5200Coc/o>ohb>
S?m2@D;o<C0a3_l000000ooooooo8B0Qo`00000;o`0004Kog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l000002Ol000000onm_[gooooooc4`<@0=
o`000003oe9AD_ooooooLg5c013o00001Onm_[d00on][Zgo0000o`00000<o`000003omkOg_m2@D;o
000000[o000000?o61PHomkKg_oNfmh0A?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmh00olH61So0000o`00000Io`000003od91@_ooooooW9jL02Co000000?o_Kjm
og=aLol000002_l000000olH61Sog]_NomkKgP14omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/4omkKgP03oaPH6?l0003o0000043o000000?o<C0aob4P8Ol000002_l00000
0olH61Sog]_NomkKgP14omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgP03oeYIF_l0003o000004go000000?oFUUJomkKg_oNfmh0A?oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00on][ZgoBTU:o`00001<o`000003odY9B_n][Zgo
g]_N04Gog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00CoinOW
ojf^[OmJFE[o8B0Q0ol@4107o`0001So410@7ol000000ol820So410@oa0@4003oa0@4006o`P82?l@
413o8B0QoeYIF_n][ZgoinOWA_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEkVooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkVooNfmh00omSIG_o
ooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkVooNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEkVooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEkVooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkVooNfmh00omSIG_o
ooooooooo`01of=UN`0000?oJff<omkOione//h0WOn<RZD1oooko`7oa/_F0OmcLI@00003of=]S?oN
gnOog]oW09gog]_N0Ooonol1olK;eP7oLg6D00000omSKHcog]_Wooooo`2Mooooo`7ooo_o0Oo6bmH1
og=aU00000?oHff<omKGiooonol0SOogmol00onLWZgoW5E2ojE=@P08ojE=@P07oiaE@_nLWZgomoOo
ooOgoooonooomoOoolK;eP01og=aU00000?oHff<omKCg_ogloL0SOo_koL00oneED[ooi:DoonRY@07
oonNW003oonRYOooTYCo]EE:00Coknog0Oo6bmH1og=aU00000CoHff<olk?g_oWjnooinO_0ooWhnl0
0ooWinooin?_onOWk`04onOWk`03onOSkooWinooin?_00?oin?_1OoWinl01_oWhnooinO_onOWkooW
hnooinO_onOSk`;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOS
kooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOS
kooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOS
kooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOS
kooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOS
kooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOS
kooWinooin?_00;oinO_00Coin?_onOWkooWhnooin?_1?oWinl00ooWhnooinO_onOSk`03onOSk`Go
inO_00Coin?_onOWkooNIF?ookJe2Ooo[Zd00ooo][GogVESonOWk`03onOWk`7oa/_F0OmcLI@00003
of=]S?o>cmkog]oW08gog]_W00?ogVESoonb]OooZZD00_ooool3oonZY@;ooooo00?oojZUoonb]OoN
IF<00_oNfnL2omkOi`7oa/_F0OmcLI@00003of=]S?o>bmkoe]ON00;oe]?N00?oe]ONomKCg_oFdmh0
R?oFdmh00ooNIF?ook:eoonZY@03ooooo`07oon^YOooooooooooooooooooZZGook:eomiUH`02omKC
gP03omKGg_oFenOoa/_F007oLg6D00000omSKHcoa/_Folk?gP03olk?eP04olk?g_o>bmkoc/oFolk?
ePCoc/oN00Woc/oFolk?g_o>cmKoc/_Nolk?e_o>bmKoc/oFolk?g_o>bmH00oo>cmH00oo>bmKoc/oF
olk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oF
olk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oF
olk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oF
olk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oF
olk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oF
olk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oF
olk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF1Oo>cmh02Oo>cmKoc/oNolk?e_o>bmkoc/oFolk;
e_o>cmKoc/oNolk;eP03olk?eP03olk;e_oNIF?ook:]00;oojZU1Oooool2oonVW003oon^[OoNIF?o
c/oN00;oc/oN0Oo>dmh1olK;eP7oLg6D00000omSKHcoa/OFolK7eP2=olK7eP03omiUF_ooZZGooj:L
00;ooj:L0oooool2oonNU003oonJU?ooYYcogVEJ00?oa/OF0Oo>bmh1okg3eP7oLg6D00000omSKHco
a/OFokg3cP2=okg3cP04omiUF_ooYYcooiZDoonJU0Gooooo0_ooTX`00oooWYcogVEJokg3cP02okg3
cP7oa/OF0One]/h1og=aU00000?oHff<olK7e_nm^/h0SOnm^/h00ooNIF?ooijLoonBS003ooooo`07
oon>S?ooooooooooooooooogRXCooiJDomiUH`03okfjcP7oa/?F0On]Z[d1og=aU00000?oHff<olK7
e_ne]/H05?ne]/h00one]/Ko]KK>okFfaP04okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFf
c_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFf
c_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFf
c_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFf
c_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFf
c_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFf
c_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFf
c_ne]/h03?ne]/h01one]/Ko]KK>okFfa_ne]/kogVESoonFU?ogQX@00_ooool3ooN:Q0;ooooo00?o
khJ4oonFU?oNIF<00one]/h1okfncP7oW9je0OmcLI@00003of=]S?o6amKo[K;608go]K;>00?ogVUS
oonFU?o_PX@01oo_QX@00oo_PXCooiJDomiUH`03okFbcP7o_Kk>0OnDTZd1og=aU00000?oHff<olK3
e_n]Z/H0SOn][/H00oo>JE[ooiZDoonFU008oonFU003oonJW?o>JE[o[Jk600;o[Jk60One]/h1ohb:
Y@7oLg6D00000omSKHcoa/?FojFR_@2=ojFV_@03oibN[Oo>IE[ogVUS00OogVES00?ogVUSoliUHonL
WZd00_nUY[d00onUX[go]Jk>ohb:Y@01og=aU00000?oHff<olK3e_nUX[d0W?nUY[d00onUX[go]Jk>
ohb:Y@01og=aU00000?oHff<olK3e_nUX[d0W?nUY[d00onUX[go]Jk>ohb:Y@01og=aU00000?oHff<
olK3e_nUX[d0W?nUY[d00onUX[go]Jk>ohb:Y@01og=aU00000?oHff<olK3e_nUX[d0WOnUY[d1okFb
cP7oS8ZU0OmcLI@00003of=]S?oWinoog]o_09gog]o_0OoWioL1ohb:Y@7oLg6D002Rof=]S07oLg6D
0000\
\>"], "ListGraphic",
 Evaluatable->False,
 ImageSize->{163, 338},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"MakeIndexIntro", "i:88"}]
}, Open  ]],

Cell[TextData[{
 "To create an index for a document, you must assign an index entry to each \
cell in the notebook that will be referenced in the index. This is done using \
the",
 StyleBox[" Edit Notebook Index ", "TR"],
 "dialog box of the MakeIndex palette."
}], "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell["\<\
Once all the index entries have been defined, you can click a button on the \
palette to generate the index. For any document, you can generate several \
different types of indexes.\
\>", "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[TextData[StyleBox["Simple Index", "TB"]], "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell["\<\
A simple index is used to check that all the index entries you specified were \
entered correctly. It lists all the entries including duplicate entries and \
sub-entries on a separate line. The text of the hyperlink for each entry \
consists of the cell tag of the target material and the name of the notebook \
in which it occurs.\
\>", "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[TextData[{
 "The simple index is saved in the same directory as the source notebook(s). \
By default the file is called SimpleIndex.nb but you can specify a different \
name using the ",
 StyleBox["Set Index FileName...", "SR"],
 " button at the bottom of the palette."
}], "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[TextData[StyleBox["Book Index", "TB"]], "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell["\<\
A book index contains all the index entries formatted with the following \
features.\
\>", "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell["\<\
Duplicate index entries to the same page are removed. Duplicate index entries \
on consecutive pages in the same notebook are combined into a single page \
range.\
\>", "BulletedList",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell["\<\
Index sub-entries are formatted on a separate line and indented as shown \
here.\
\>", "BulletedList",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[TextData[{
 "element, ",
 ButtonBox["2",
  ButtonData:>{"1_SetsVersusFuzzySets.nb", "i:8"},
  ButtonStyle->"Hyperlink"],
 "\n",
 StyleBox["Fuzzy Logic",
  FontSlant->"Italic"],
 ", ",
 ButtonBox["1",
  ButtonData:>{"1_SetsVersusFuzzySets.nb", "i:4"},
  ButtonStyle->"Hyperlink"],
 "\n\tloading, ",
 ButtonBox["1-2",
  ButtonData:>{"1_SetsVersusFuzzySets.nb", "i:5"},
  ButtonStyle->"Hyperlink"],
 "\nFuzzy Sets, ",
 ButtonBox["1",
  ButtonData:>{"1_SetsVersusFuzzySets.nb", "i:1"},
  ButtonStyle->"Hyperlink"],
 ", ",
 ButtonBox["3",
  ButtonData:>{"1_SetsVersusFuzzySets.nb", "i:13"},
  ButtonStyle->"Hyperlink"],
 "\n\tas functions, ",
 ButtonBox["1",
  ButtonData:>{"1_SetsVersusFuzzySets.nb", "i:2"},
  ButtonStyle->"Hyperlink"],
 "\n\tas models, ",
 ButtonBox["4",
  ButtonData:>{"1_SetsVersusFuzzySets.nb", "i:17"},
  ButtonStyle->"Hyperlink"]
}], "ListNote",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell["\<\
Each hyperlink specifies the page number(s) on which the index entry appears.\
\
\>", "BulletedList",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[TextData[{
 "If the book index builds without error, it is saved in the same directory \
as the source notebook(s). By default the file is called BookIndex.nb, but \
you can specify a different name using the ",
 StyleBox["Set Index FileName...", "SR"],
 " button at the bottom of the palette."
}], "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[TextData[StyleBox["Two Column Index", "TB"]], "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell["\<\
A two column index has the same features as a book index, except that the \
entries are arranged in two columns.\
\>", "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[TextData[{
 "If the two column index builds without error, it is saved in the same \
directory as the source notebook(s). By default the file is called \
TwoColumnIndex.nb, but you can specify a different name using the ",
 StyleBox["Set Index FileName...", "SR"],
 " button at the bottom of the palette."
}], "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[TextData[StyleBox["Browser Index", "TB"]], "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell["\<\
A browser index file defines a list of keywords to be included in the Master \
Index of the Help Browser. By creating a browser index for your notebook(s), \
you can integrate your own reference material into the existing online help.\
\>", "Text",
 CellTags->{"MakeIndexIntro", "i:88"}],

Cell[TextData[{
 "For the BrowserIndex.nb file to be compiled without error, an appropriate \
browser categories file must exist in the same directory as the source \
notebook(s). To create a ",
 "browser categories",
 " file, you can use the MakeCategories palette included with ",
 StyleBox["AuthorTools",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->{"MakeIndexIntro", "i:88"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting Up an Index", "Subsubsection",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[StyleBox["Setting Up Index Entries", "TB"]], "Text",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 "To create an index, you must associate index entries with specific cells in \
your source notebooks. This is done using the ",
 StyleBox["Edit Notebook Index", "TR"],
 " dialog box, which allows you to add, edit, and remove index entries."
}], "Text",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[CellGroupData[{

Cell[BoxData[
 ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "PictureGroup",
   FormatType->StandardForm,
   ImageSize->{54, 13},
   ImageMargins->{{0, 0}, {0, 0}},
   ImageRegion->{{0, 1}, {0, 1}}],
  Active->True,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& )]], "OpenCloseItemizedPicture",
 CellTags->{"i:89", "Setting up an Index"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000580001Zb000`400?l00000o`00003ooomSIG]9
of=UN`0000?oHfEkooooooooool0oooooom5ooooo`7oHfEk00000omSIG_oooooojfZ_@3oojfZ_DCo
[JZm0Oooool1of=UN`0000?oHfEkoooooon]Z[d0oomSIG]3of=UN`7o[JZm0Oooool1of=UN`0000Ko
HfEkoooooon]Z[goHfEkono_mon<SY`=oibN[@04ohb:W?oWinooknoWokfj_GCoW9j]09Wo_Kjmono_
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooono_
mon<SY`03OnLWZd00on<RYcoinO_onOOi`0@onOOi`03of=UNon]Z[gooooo007oHfEk00001_mSIG_o
ooooojfZ_OmSIG_oU9JUomkOi`gog]_W00Cog]oWoiBFYOnDUZGog]_NM?o6bmH0VOoNfmkoYJ:]onOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoU9JUomkO
i`0=omkKi`03omkOionDUZGoimoW00GoimoW0_ooool2onOOi`;ooooo0_oWgnL2ooooo`04onOOiomS
IG_o[JZmooooo`7oHfEk00001_mSIG_oooooojfZ_OmSIG_oU9JUooooo`goc/oN00CooooooiBFYOnD
UZGoooooM?o>cmh0VOooooooU9JUoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooU9JUooooo`0=olk?gP03oooooonDUZGoimoW00CoimoW0_nm]ZD01_oo
ooooimoWokffYOnm]ZGoooooonOOi`;o_KJU00GoooooonOOiomSIG_o[JZmooooo`01of=UN`0000Ko
HfEkoooooon]Z[goHfEkoiBFYOooool=olk?gP04oooooonDUZGoU9JUooooogCoc/oN09WooooooiBF
YOoWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoiBF
YOooool03Oo>cmh00oooooooU9JUonOOi`04onOOi`;o_KJU0_oWgnL2okffY@;oimoW0_nm]ZD2onOO
i`03of=UNon]Z[gooooo007oHfEk00001_mSIG_oooooojfZ_OmSIG_oU9JUooooo`Koc/oN00?o>C`i
olk?g_o>cmh01?o>cmh01?ooooooU9JUoiBFYOooool2olk?gP03olkCg_o>cmkoc/oN02?oc/oN2Oo>
dmhBolk?gPWoc]?N9Oo>cmh0W?o>dmkoc/oNolk?g_ooooooU9JUoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooU9JUooooo`Goc/oN00?o>C`iolk?g_o>
cmh01Oo>cmh00oooooooU9JUonOOi`0@onOOi`03of=UNon]Z[gooooo007oHfEk00001_mSIG_ooooo
ojfZ_OmSIG_oU9JUooooo`Goc/oN0oli?3T5olk?gP04oooooonDUZGoU9JUooooocOoe]OW00OoS9JU
omKGion<UZGoe]OWohbFYOoFenOoS9JU03Koe]OW09WooooooiBFYOoWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoiBFYOooool01?o>cmh3ocTl>@Koc/oN
00?ooooooiBFYOoWgnL02OoWgnL2ooooo`;oimoW0_ooool01?oWgnOoHfEkojfZ_Oooool1of=UN`00
00KoHfEkoooooon]Z[goHfEkoiBFYOooool4olk?gP?o>C`i1_o>cmh01?ooooooU9JUoiBFYOooool3
omkKibGog]oW3_oNfnL02?ooooooS9JUoooooon<UZGoooooohbFYOooooooS9JU3_oNfnLUomkOi`;o
g]_W09[og]oWoooooonDUZGoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooonDUZGooooo1Oo>cmh3ocTl>@Goc/oN00?ooooooiBFYOoWgnL02?oWgnL2okff
Y@09oooooooWgnOo_KJUokffYOooooooimoWof=UNon]Z[gooooo007oHfEk00001_mSIG_oooooojfZ
_OmSIG_oU9JUooooo`?oe]?W0oli?3T7omKCi`04oooooonDUZGoU9JUooooo`?og]_W9OoNgnL>omkK
i`08oooooon<UZGoooooohbFYOooooooS9JUoooooon<UZD>omkKibGog]oW0_oNfnL0V_oNgnOooooo
oiBFYOoWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oiBFYOooool6omKCi`?o>C`i1?oFdnL00oooooooU9JUonOOi`08onOOi`;o_KJU0_oWgnL2okffY@;o
imoW00?oHfEkojfZ_Oooool00OmSIG/00006of=UNooooooo[JZmof=UNonDUZGooooo0_oNfnL3ocTl
>@Sog]_W00CooooooiBFYOnDUZGooooo=_oWhnl02?ooooooS9JUoooooon<UZGoooooohbFYOoooooo
S9JU=_oWhnl0VOooooooU9JUoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooU9JUooooo`07omkKi`?o>C`i0ooNfnL00oooooooU9JUonOOi`0@onOOi`03
of=UNon]Z[gooooo007oHfEk00001_mSIG_oooooojfZ_OmSIG_oU9JUooooo`?oin?_0oli?3T7onOS
k`04oooooonDUZGoU9JUooooocKokn__00SoooooohbFYOooooooS9JUoooooon<UZGoooooohbFYCKo
kn__09WooooooiBFYOoWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoiBFYOooool01_oWhnl3ocTl>@Coin?_00?ooooooiBFYOoWgnL03OoWgnL2ooooo`04
onOOiomSIG_o[JZmooooo`7oHfEk00001_mSIG_oooooojfZ_OmSIG_oU9JUooooo`Coknog0oli?3T6
ono_m`04oooooonDUZGoU9JUooooocKokn__00SoooooohbFYOooooooS9JUoooooon<UZGoooooohbF
YCKokn__09WooooooiBFYOooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOooooooiBFYOooool01Oo_koL3ocTl>@Goknog00?ooooooiBFYOoWgnL03?oWgnL2okff
Y@05oooooooWgnOoHfEkojfZ_Oooool00OmSIG/00006of=UNooooooo[JZmof=UNonDUZGooooo1Oog
moL3ocTl>@GomoOg00CooooooiBFYOnDUZGooooo=_o_koL01oooooooknogooooooo_koOoooooono_
moooool0=oo_koL0VOooooooU9JUonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoU9JUooooo`04ooOgm`?o>C`i1_ogmoL00oooooooU9JUonOOi`0<onOO
i`;o_KJU0_oWgnL00omSIG_o[JZmooooo`01of=UN`0000GoHfEkoooooon]Z[goHfEkoiBFY@07oooo
o`03ocTl>Ooooooooooo00Gooooo0_nDUZD00oooooooknogono_m`1bono_m`2HoooooonDUZGooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooonDUZD6oooo
o`03ocTl>Ooooooooooo00Kooooo00?oU9JUonOOiooWgnL03ooWgnL00omSIG_o[JZmooooo`01of=U
N`0000GoHfEkoooooon]Z[goHfEkoiBFY@0?ooooo`;oU9JU00?oooooooOgooogmol0L_ogmol0V?oo
ooooU9JUonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoU9JU3oooool00onDUZGoimoWonOOi`0?onOOi`03of=UNon]Z[gooooo007oHfEk00001_mSIG_o
ooooojfZ_OmSIG_oU9JUomKGgPgooooo00Coe]ONoiBFYOnDUZGooo_oM?ooool0VOoonoooU9JUoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooU9JUomKG
gP0=ooooo`03omKGg_nDUZGoimoW013oimoW00?oHfEkojfZ_Oooool00OmSIG/00006of=UNooooooo
[JZmof=UNooFfmkoS9:L3?ne][d01One/[goS8jLomKKg_oFemko[Jjm07Co]KJm09WoYJZeolk?e_oW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWomKKg_n<
TY`03?ne][d00one/[goS8jLomKKgP0AonOOi`03of=UNon]Z[gooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/Aono_igSokn_W09GoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWooooo`0Aono_ia7oimoW00?oHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo
[JZmof=UNooog]_N<?oNfmh00oo_knOoknogohb>W00<oibN[@05ohb:W?oWinooHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh00oo_knOoU9JUomkOi`0<omkKi`05omkO
ionDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh00oo_knOo
U9JUooooo`0<olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=U
Nooog]_N<?oNfmh00oo_knOoU9JUooooo`0<olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UNooog]_N<?oNfmh00oo_knOoU9JUooooo`0<olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh00oo_knOoU9JUoooo
o`05olk?gP03ocTl>Oo>cmkoc/oN00Coc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEkoooNfmh`omkKgP03ono_ionDUZGooooo00Coc/oN0oli?3T5olk?gP05oooo
oonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh00oo_knOo
U9JUooooo`03olk?gPGo>C`i1?o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG_oomkKgS3og]_N00?oknoWoiBFYOooool00_oFdnL3ocTl>@04omKCioli?3Wo>C`i
ocTl>@?oe]?W00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooN
fmh`omkKgP04ono_ionDUZGoooooomkKi`?o>C`i0ooNfnL3ocTl>@;og]_W00GooooooiBFYOmSIG_o
[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmh`omkKgP03ono_ionDUZGooooo00;o
in?_00?o>C`ionOSkooWhnl00ooWhnl02Oli?3Woin?_onOSkooWhnoooooooiBFYOmSIG_o[JZmoooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmh`omkKgP03ono_ionDUZGooooo00coknog00Go
oooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEknOoNfmhdoe:F]@;og]_N
00?oknoWoiBFYOooool03?ogmoL01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG_iomkKgSCoDYJe0_oNfmh00oo_knOoU9JUooooo`0=ooooo`04oiBFYOmSIG_o[JZmoooo
o`7oHfEk00001?mSIG_oooooojfZ_OmSIG_iomkKgSCoDYJe0_oNfmh00oo_knOoU9JUooooo`0=oooo
o`04oiBFYOmSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_iomkKgSCoDYJe0_oNfmh0
0oo_knOoU9JUomKGgP0<ooooo`05omKGg_nDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo
[JZmof=UNoWog]_N=?mBU[D2omkKgP03ono_iooFfmkoS9:L00_o]KJm00Ko]K:mohb>W?oFfmkoHfEk
ojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEknOoNfmhdoe:F]@;og]_N01CoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomS
IG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_iomkKgPCoDYJe0_ooool3oe:F]@;ooooo
00?oDYJeooooooooool00_ooool2oe:F]@;ooooo0_mBU[D2ooooo`CoDYJe1?ooool3oe:F]@Cooooo
0_mBU[D2ooooo`;oDYJe0_ooool5oe:F]@;og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk0000
1?mSIG_oooooojfZ_OmSIG_iomkKgPCoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo1OmBU[D2omkKgP0DoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEknOoNfmh4oe:F]@;ooooo00?oDYJe
ooooooooool00_mBU[D2ooooo`GoDYJe0_ooool2oe:F]@;ooooo0omBU[D2ooooo`OoDYJe1?ooool0
0omBU[Goooooooooo`02oe:F]@;ooooo1OmBU[D2omkKgP0DonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=U
N`0000CoHfEkoooooon]Z[goHfEknOoNfmh4oe:F]@Gooooo0_mBU[D6ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool3oe:F]@Kooooo00?oDYJeooooooooool00_ooool3oe:F]@;ooooo0_mBU[D2oooo
o`GoDYJe0_oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNoWo
g]_N1?mBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeoooooooo
ool00_mBU[D2ooooo`?oDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03
oe:F]Ooooooooooo00;oDYJe0_ooool5oe:F]@;og]_N01CoimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk
00001?mSIG_oooooojfZ_OmSIG_iomkKgPCoDYJe0_ooool2oe:F]@;ooooo0_mBU[D4ooooo`03oe:F
]Ooooooooooo00;ooooo00?oDYJeooooooooool00_ooool2oe:F]@Cooooo0omBU[D4ooooo`;oDYJe
1Oooool6oe:F]@;og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmS
IG_iomkKgPCoDYJe0_ooool2oe:F]@;ooooo2?mBU[D2oooooaGoDYJe0_ooool9oe:F]@;og]_N01Co
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_iomkKgPCoDYJe1Oooool:
oe:F]@?ooooo4omBU[D2ooooo`WoDYJe0_oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UNoWog]_N=?mBU[D2omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`00
00CoHfEkoooooon]Z[goHfEknOoNfmhdoe:F]@;og]_N01CoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk
00001?mSIG_oooooojfZ_OmSIG_iomkKgSCoDYJe0_oNfmh05?oWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmS
IG/00004of=UNooooooo[JZmof=UNoWog]_N=?mBU[D2omkKgP0DoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1
of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmh`omkKgP0DonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=U
N`0000CoHfEkoooooon]Z[goHfEk2_oNfmkoo`0002;o00001?oNfmh05?ooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[go
oooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000omkKg_oNfmh0oooNfmhNomkKgP03
o`000?oNfmkog]_N00;og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ
_OmSIG/:omkKgP03o`000?oNfmkog]_N0?oog]_N7_oNfmh00ol0003og]_NomkKgP02omkKgP0Doooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003og]_NomkK
gP3oomkKgQkog]_N00?o0000omkKg_oNfmh00_oNfmh05?oWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/0
0004of=UNooooooo[JZmof=UN`[og]_N00?o0000omkKg_oNfmh0oooNfmhNomkKgP03o`000?oNfmko
g]_N00;og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkK
gP03o`000?oNfmkog]_N0?oog]_N7_oNfmh00ol0003og]_NomkKgP02omkKgP0DonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEk
ojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003og]_NomkKgP3oomkKgQko
g]_N00?o0000omkKg_oNfmh00_oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooo
oooo[JZmof=UN`[og]_N00?o0000omkKg_oNfmh0oooNfmhNomkKgP03o`000?oNfmkog]_N00;og]_N
01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oN
fmkog]_N0?oog]_N7_oNfmh00ol0003og]_NomkKgP02omkKgP0DoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1
of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003og]_NomkKgP3oomkKgQkog]_N00?o0000
omkKg_oNfmh00_oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=U
N`[og]_N00?o0000omkKg_oNfmh0oooNfmhNomkKgP03o`000?oNfmkog]_N00;og]_N01CoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oNfmkog]_N0?oo
g]_N7_oNfmh00ol0003og]_NomkKgP02omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000Co
HfEkoooooon]Z[goHfEk2_oNfmh00ol0003og]_NomkKgP3oomkKgQkog]_N00?o0000omkKg_oNfmh0
0_oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o
0000omkKg_oNfmh01OoNfmh3o`0000?og]_N00Co0000omkKg_oNfmkog]_N0ol00002omkKgP?o0000
00Cog]_No`000?l0003og]_N0_l0003oomkKgP7og]_N00?o0000omkKg_oNfmh00_oNfmh05?oWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000omkKg_oNfmh0
1_oNfmh00ol0003og]_NomkKgP02omkKgP04o`000?oNfmkog]_No`0000?og]_N00Co0000omkKg_oN
fmko00000_oNfmh00ol0003og]_No`000002omkKgP03o`000?oNfmkog]_N0?gog]_N00?o0000omkK
g_oNfmh00_oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`[o
g]_N00?o0000omkKg_oNfmh01_oNfmh01?l0003og]_NomkKg_oNfmh2o`0000;og]_N00Go0000omkK
g_oNfmkog]_No`000002omkKgP06o`000?oNfmkog]_No`000?oNfmko0000oooNfmh3omkKgP03o`00
0?oNfmkog]_N00;og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmS
IG/:omkKgP03o`000?oNfmkog]_N00Kog]_N00Ko0000omkKg_oNfmko0000omkKg_l00002omkKgP05
o`000?oNfmkog]_NomkKg_l000000_oNfmh01Ol0003og]_NomkKg_l0003og]_N00Co0000oooNfmh0
0ol0003og]_NomkKgP02omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]
Z[goHfEk2_oNfmh00ol0003og]_NomkKgP06omkKgP06o`000?oNfmkog]_No`000?oNfmko00000_oN
fmh01Ol0003og]_NomkKg_oNfmko000000;og]_N0_l000001?oNfmko0000omkKg_l00002omkKgP03
o`000?oNfmkog]_N0?gog]_N00?o0000omkKg_oNfmh00_oNfmh05?oWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000omkKg_oNfmh01_oNfmh00ol0003og]_N
o`000002omkKgP04o`000?oNfmkog]_NomkKgP?o00000_oNfmh2o`000003omkKg_l0003og]_N00;o
g]_N0_l0003oomkKgP7og]_N00?o0000omkKg_oNfmh00_oNfmh05?ooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000omkKg_oNfmh01_oNfmh2o`0000?og]_N
00?o0000omkKg_oNfmh0oooNfmh@omkKgP03o`000?oNfmkog]_N00;og]_N01CoimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o
[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oNfmkog]_N00Kog]_N00?o
0000omkKg_oNfmh00_oNfmh00ol0003og]_NomkKgP3oomkKgQ3og]_N00?o0000omkKg_oNfmh00_oN
fmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000
omkKg_oNfmh01OoNfmh2o`0000?og]_N0ol0003oomkKgQ7og]_N00?o0000omkKg_oNfmh00_oNfmh0
5?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000omkK
g_oNfmh0oooNfmhNomkKgP03o`000?oNfmkog]_N00;og]_N01CoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7o
HfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oNfmkog]_N0?oog]_N7_oNfmh00ol0003o
g]_NomkKgP02omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk
2_oNfmh00ol0003og]_NomkKgP3oomkKgQkog]_N00?o0000omkKg_oNfmh00_oNfmh05?ooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
of=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000omkKg_oNfmh0oooN
fmhNomkKgP03o`000?oNfmkog]_N00;og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mS
IG_oooooojfZ_OmSIG/:omkKgP03o`000?oNfmkog]_N0?oog]_N7_oNfmh00ol0003og]_NomkKgP02
omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0
003og]_NomkKgP3oomkKgQkog]_N00?o0000omkKg_oNfmh00_oNfmh05?oWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[go
oooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000omkKg_oNfmh0oooNfmhNomkKgP03
o`000?oNfmkog]_N00;og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ
_OmSIG/:omkKgP03o`000?oNfmkog]_N0?oog]_N7_oNfmh00ol0003og]_NomkKgP02omkKgP0DonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003og]_NomkK
gP3oomkKgQkog]_N00?o0000omkKg_oNfmh00_oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/0
0004of=UNooooooo[JZmof=UN`[og]_N00?o0000omkKg_oNfmh0oooNfmhNomkKgP03o`000?oNfmko
g]_N00;og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkK
gP03o`000?oNfmkog]_N0?oog]_N7_oNfmh00ol0003og]_NomkKgP02omkKgP0DoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEk
ojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmkoo`0002;o00001?oNfmh05?oWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
of=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=U
Non]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]
Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[go
oooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UN`_og]_N00?o0000omkKg_l000000ooNfmh00ol0003og]_N
omkKgP04o`0000;og]_N1?l000000ooNfmko0000omkKgP02omkKgP03o`000?oNfmkog]_N00?og]_N
1Ol000000ooNfmko0000omkKgP02omkKgP06o`000?oNfmko0000o`000?oNfmko00000ooNfmh01?l0
003og]_NomkKg_oNfmh4o`000003omkKg_l0003o000000;o00001OoNfmh01?l0003og]_NomkKg_oN
fmh3o`0000;og]_N00?o0000omkKg_oNfmh01?oNfmh2o`000003omkKg_l0003og]_N00;og]_N00?o
0000omkKg_oNfmh01?l00006omkKgP?o00000ooNfmh4o`000003omkKg_l0003og]_N00;og]_N00?o
0000omkKg_oNfmh00_oNfmh4o`000003omkKg_l0003og]_N00;og]_N00Co0000omkKg_l0003o0000
1_oNfmh3o`0000?og]_N1?l000001OoNfmko0000omkKg_oNfmko000000?og]_N00?o0000omkKg_oN
fmh0POoNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`_og]_N
00?o0000omkKg_l000000ooNfmh00ol0003og]_No`000003omkKgP03o`000?oNfmko000000Kog]_N
00?o0000omkKg_l000001_oNfmh00ol0003og]_NomkKgP03omkKgP07o`000?oNfmkog]_NomkKg_l0
003og]_No`000002omkKgP05o`000?oNfmkog]_NomkKg_l000000_oNfmh00ol0003og]_NomkKgP07
omkKgP03o`000?oNfmkog]_N00;og]_N00Co0000omkKg_oNfmko00000ooNfmh00ol0003og]_No`00
0006omkKgP04o`000?oNfmkog]_No`0000?og]_N00?o0000omkKg_l000002OoNfmh01ol0003og]_N
omkKg_oNfmko0000omkKg_l000000ooNfmh00ol0003og]_No`000003omkKgP05o`000?oNfmkog]_N
omkKg_l000001OoNfmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000001_oNfmh01ol0003og]_N
omkKg_oNfmko0000omkKg_l000001OoNfmh01?l0003og]_NomkKg_l00027omkKgP0DoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
HfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2ooNfmh00ol0003og]_No`000003omkK
gP03o`000?oNfmko000000?og]_N00?o0000omkKg_l000001?l00003omkKgP03o`000?oNfmkog]_N
00Gog]_N00?o0000omkKg_oNfmh00ooNfmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000000_oN
fmh01Ol0003og]_NomkKg_oNfmko000000;og]_N1Ol00002omkKgP?o00001OoNfmh01?l0003og]_N
omkKg_l00003omkKgP03o`000?oNfmko000000Kog]_N00Co0000omkKg_oNfmko00000ooNfmh00ol0
003og]_No`000004o`0000Gog]_N00?o0000omkKg_oNfmh00ooNfmh01ol0003og]_NomkKg_oNfmko
0000omkKg_l000000ooNfmh01?l0003og]_NomkKg_oNfmh5o`000003omkKg_l0003og]_N00;og]_N
00?o0000omkKg_l000001_oNfmh00ol0003og]_NomkKgP03omkKgPGo000000Gog]_No`000?oNfmko
g]_No`000027omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk
2ooNfmh00ol0003og]_No`000003omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_l00000
0ooNfmh01_l0003og]_NomkKg_l0003og]_No`0000Kog]_N1Ol000000ooNfmko0000omkKgP02omkK
gP03o`000?oNfmko000000;og]_N00Go0000omkKg_oNfmkog]_No`000002omkKgP07o`000?oNfmko
g]_NomkKg_l0003og]_No`000008omkKgP04o`000?oNfmkog]_No`0000?og]_N00?o0000omkKg_l0
00001_oNfmh01?l0003og]_NomkKg_l00003omkKgP03o`000?oNfmko000000?og]_N00?o0000omkK
g_oNfmh00ooNfmh00ol0003og]_NomkKgP03omkKgP07o`000?oNfmkog]_NomkKg_l0003og]_No`00
0003omkKgP05o`000?oNfmkog]_NomkKg_l000000ooNfmh00ol0003og]_No`000003omkKgP03o`00
0?oNfmko000000Kog]_N00?o0000omkKg_oNfmh00ooNfmh01ol0003og]_NomkKg_oNfmko0000omkK
g_l000000_oNfmh00ol0003og]_NomkKgP25omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`00
00CoHfEkoooooon]Z[goHfEk2ooNfmh00ol0003og]_No`000003o`0000?og]_N1?l00002omkKgP?o
00000_oNfmh01Ol0003og]_NomkKg_oNfmko000000Gog]_N00?o0000omkKg_oNfmh00ooNfmh4o`00
0005omkKg_l0003o0000o`000?oNfmh00ol000000ooNfmko0000omkKgP02omkKgP?o00000ooNfmh4
o`0000?og]_N0ol00002omkKgP?o00000_oNfmh3o`0000?og]_N0ol000000ooNfmko0000o`000002
o`0000?og]_N0ol00006omkKgP03o`000?oNfmkog]_N00?og]_N00Ko0000omkKg_oNfmkog]_No`00
0?oNfmh3o`000004omkKg_l0003o0000o`0000;og]_N0ol00002omkKgPCo000000Cog]_No`000?l0
003o00001OoNfmh00ol0003og]_NomkKgP04omkKgP?o00000_oNfmh01?l0003og]_NomkKg_l00003
omkKgP03o`000?oNfmkog]_N087og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_o
ooooojfZ_OmSIG/;omkKgP03o`000?oNfmkog]_N00Wog]_N00?o0000omkKg_oNfmh03ooNfmh00ol0
003og]_NomkKgP09omkKgP03o`000?oNfmkog]_N01Kog]_N00?o0000omkKg_oNfmh03OoNfmh01?l0
003og]_NomkKg_l0000?omkKgP05o`000?oNfmkog]_NomkKg_l000006ooNfmh00ol0003og]_NomkK
gP04omkKgP05o`000?oNfmkog]_NomkKg_l000001ooNfmh01?l0003og]_NomkKg_l00027omkKgP0D
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2ooNfmh00ol0003og]_N
omkKgP09omkKgP03o`000?oNfmkog]_N00oog]_N1Ol00007omkKgP03o`000?oNfmkog]_N00Cog]_N
00?o0000omkKg_oNfmh03ooNfmh2o`0000kog]_N00Co0000omkKg_oNfmko00004?oNfmh3o`0001co
g]_N00?o0000omkKg_oNfmh01OoNfmh3o`0000Sog]_N00Co0000omkKg_oNfmko0000QooNfmh05?oW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
of=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=U
Non]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]
Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[go
oooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmS
IG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/0
0004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=U
Nooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooo
oooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo
[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZm
of=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=U
Nooog]_N<?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooo
g]_N<?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N
<?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNigog]_NH?mB
U[D8omkKgRSoDYJe0_oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZm
of=UNigog]_NH?mBU[D8omkKgRSoDYJe0_oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UNigog]_NH?mBU[D8omkKgRSoDYJe0_oNfmh05?oWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[go
oooo0OmSIG/00004of=UNooooooo[JZmof=UNigog]_NH?mBU[D8omkKgRSoDYJe0_oNfmh05?oooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNigog]_N4_mBU[D4oooood[oDYJe
2?oNfmhXoe:F]@;og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmS
IG^MomkKgQ7oDYJe00Cooooooe:F]OmBU[GoDYJe0_oooom9oe:F]@Sog]_N:?mBU[D2omkKgP0Doooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEkWOoNfmh6oe:F]@;ooooo1?mB
U[D4ooooo`;oDYJe1Oooool5oe:F]@Cooooo0omBU[D5ooooo`03oe:F]Ooooooooooo00?oDYJe0_oo
ool4oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe0_ooool2oe:F]@;ooooo1OmBU[D4ooooo`?oDYJe1?oo
ool2oe:F]@;ooooo00?oDYJeooooooooool01OmBU[D8omkKgPKoDYJe1?ooool2oe:F]@;ooooo0_mB
U[D4ooooo`?oDYJe1?ooool3oe:F]@Cooooo1_mBU[D2omkKgP0DonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1
of=UN`0000CoHfEkoooooon]Z[goHfEkWOoNfmh6oe:F]@;ooooo0omBU[D2ooooo`04oe:F]Ooooooo
oooooe:F]@;ooooo0_mBU[D2ooooo`CoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool3oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool00omBU[Goooooooooo`05oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`GoDYJe2?oNfmh5oe:F]@;ooooo
0_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;o
DYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo1OmBU[D2omkKgP0DoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ
_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEkWOoNfmh6oe:F]@;ooooo0omBU[D2ooooo`04oe:F
]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`?oDYJe0_ooool6oe:F]@;ooooo0_mBU[D2ooooo`03
oe:F]Ooooooooooo00?oDYJe0_ooool3oe:F]@;ooooo1OmBU[D2ooooo`;oDYJe0_ooool00omBU[Go
ooooooooo`04oe:F]@;ooooo1_mBU[D2ooooo`GoDYJe0_ooool00omBU[Goooooooooo`05oe:F]@So
g]_N1?mBU[D2ooooo`KoDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0omBU[D4ooooo`03
oe:F]Ooooooooooo00WoDYJe0_oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooo
oooo[JZmof=UNigog]_N1_mBU[D2ooooo`CoDYJe1?ooool00omBU[Goooooooooo`02oe:F]@;ooooo
0omBU[D2ooooo`KoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00omBU[D2ooooo`?oDYJe
1_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool01?mBU[D2ooooo`KoDYJe
1_ooool01?mBU[GooooooooooomBU[D2ooooo`GoDYJe2?oNfmh4oe:F]@;ooooo1_mBU[D2ooooo`03
oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02ooooo`?oDYJe1_ooool5oe:F]@;o
g]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG^MomkKgPKoDYJe
0_ooool3oe:F]@03oooooomBU[GoDYJe00;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`?oDYJe
0_ooool6oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool3oe:F]@;ooooo
0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`04oe:F]@;ooooo
1_mBU[D2ooooo`;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`GoDYJe2?oNfmh4oe:F]@;o
oooo1_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;o
oooo00?oDYJeooooooooool00_mBU[D2ooooo`GoDYJe0_oNfmh05?oWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UNigog]_N1_mBU[D2ooooo`CoDYJe0oooool3oe:F]@Gooooo
0omBU[D2ooooo`KoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_ooool00omBU[Gooooo
ooooo`02ooooo`;oDYJe1?ooool2oe:F]@Gooooo00?oDYJeooooooooool00_ooool3oe:F]@;ooooo
1omBU[D4ooooo`;oDYJe0_ooool00omBU[Goooooooooo`05oe:F]@Sog]_N1?mBU[D2ooooo`KoDYJe
0_ooool2oe:F]@Cooooo0omBU[D4ooooo`?oDYJe1?ooool6oe:F]@;og]_N01CoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o
[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG^MomkKgPKoDYJe0_oooolCoe:F]@;ooooo0_mB
U[D2ooooob3oDYJe0_ooool5oe:F]@;ooooo0_mBU[D2ooooo`SoDYJe0_ooool00omBU[Gooooooooo
o`05oe:F]@Sog]_N1OmBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`0Joe:F]@;og]_N01Co
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG^MomkKgPCoDYJe1_oooolB
oe:F]@Cooooo8_mBU[D00oooooooDYJeoe:F]@04oe:F]@Cooooo2OmBU[D2ooooo`03oe:F]Ooooooo
oooo00GoDYJe2?oNfmh6oe:F]@Cooooo0_mBU[D2oooooa[oDYJe0_oNfmh05?ooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]
Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNigog]_NH?mBU[D8omkKgRSoDYJe0_oNfmh05?oW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNigog]_NH?mBU[D8omkKgRSo
DYJe0_oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNigog]_N
H?mBU[D8omkKgRSoDYJe0_oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo
[JZmof=UNigog]_NH?mBU[D8omkKgRSoDYJe0_oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/0
0004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=U
Nooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooo
oooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo
[JZmof=UN`[og]_Nool0000Ro`0000Cog]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mS
IG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02
omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0
003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh05?oWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[go
oooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03
o`000?oNfmkog]_N00;og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ
_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP0DonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003ooooooooo
o`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/0
0004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmko
g]_N00;og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkK
gP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP0DoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEk
ojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooako
oooo00?o0000omkKg_oNfmh00_oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooo
oooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N
01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oo
oooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP0DonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1
of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000
omkKg_oNfmh00_oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=U
N`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N01CoimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
iomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oo
oooo7_ooool00ol0003og]_NomkKgP02omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000Co
HfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh0
0_oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o
0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N01CoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZm
ooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool0
0ol0003og]_NomkKgP02omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]
Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh05?oo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000oooooooo
ool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N01CoimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk
00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_N
omkKgP02omkKgP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oN
fmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh05?oWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=U
Non]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolN
ooooo`03o`000?oNfmkog]_N00;og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_o
ooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkK
gP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003o
ooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh05?ooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`00
0?oNfmkog]_N00;og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmS
IG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP0DoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3o
oooooakooooo00?o0000omkKg_oNfmh00_oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N
00;og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03
o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP0DonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ
_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo
00?o0000omkKg_oNfmh00_oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo
[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N01Co
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooo
oooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP0DoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ_Oooool1of=U
N`0000CoHfEkoooooon]Z[goHfEk2_oNfmkoo`0002;o00001?oNfmh05?oWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[go
oooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmS
IG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/0
0004of=UNooooooo[JZmof=UNdCog]_N00?o0000omkKg_oNfmh01ooNfmh00ol0003og]_NomkKgP2C
omkKgP;o00001?oNfmh00ol0003og]_NomkKgP12omkKgP0DonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=U
N`0000CoHfEkoooooon]Z[goHfEk@ooNfmh00ol0003og]_NomkKgP08omkKgP03o`000?oNfmkog]_N
09Gog]_N00?o0000omkKg_oNfmh00_oNfmh00ol0003og]_NomkKgP11omkKgP0DoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEk
ojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3?oNfmh3o`0000;og]_N00Go0000omkKg_oN
fmkog]_No`000002omkKgP?o00000_oNfmh01?l0003og]_NomkKg_oNfmh2o`0000Gog]_N00?o0000
omkKg_oNfmh00ooNfmh3o`0000;og]_N00?o0000omkKg_oNfmh00_oNfmh01?l0003og]_NomkKg_l0
0002omkKgP03o`000?oNfmkog]_N00;og]_N00?o0000omkKg_oNfmh00_oNfmh4o`0000;og]_N1?l0
0002omkKgP;o000000?og]_No`000?oNfmh00_oNfmh3o`0000;og]_N00Go0000omkKg_oNfmkog]_N
o`000002omkKgPCo000000?og]_No`000?oNfmh04_oNfmh00ol0003og]_NomkKgP03omkKgP?o0000
0_oNfmh00ol0003og]_NomkKgP05omkKgP04o`000?oNfmkog]_No`0000;og]_N00?o0000omkKg_oN
fmh01?l000000ooNfmko0000o`000002o`0000;og]_N0_l00002omkKgPCo000000?og]_No`000?oN
fmh01OoNfmh01?l0003og]_NomkKg_l00003omkKgP03o`000?oNfmkog]_N00Co00000_oNfmh4o`00
0003omkKg_l0003og]_N00;og]_N00?o0000omkKg_oNfmh00ooNfmh3o`0000;og]_N00Oo0000omkK
g_oNfmkog]_No`000?oNfmko000000Cog]_N00?o0000omkKg_oNfmh00_oNfmh00ol0003og]_No`00
0011omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2ooNfmh0
1ol0003og]_NomkKg_oNfmko0000omkKg_l000000ooNfmh00ol0003og]_No`000003omkKgP03o`00
0?oNfmko000000?og]_N00?o0000omkKg_oNfmh01?oNfmh00ol0003og]_NomkKgP02omkKgP07o`00
0?oNfmkog]_NomkKg_l0003og]_No`000004omkKgP04o`000?oNfmkog]_No`0000;og]_N00?o0000
omkKg_oNfmh00_oNfmh01Ol0003og]_NomkKg_oNfmko000000Cog]_N00?o0000omkKg_l000000ooN
fmh00ol0003og]_No`000002omkKgP04o`000?oNfmkog]_No`0000?og]_N00?o0000omkKg_l00000
0ooNfmh00ol0003og]_No`000003omkKgP03o`000?oNfmko000001?og]_N00?o0000omkKg_oNfmh0
0_oNfmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000001ooNfmh01?l0003og]_NomkKg_l00002
omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_oNfmh00ooNfmh00ol0003og]_No`000002
omkKgP03o`000?oNfmkog]_N00?og]_N00?o0000omkKg_oNfmh01?oNfmh01?l0003og]_NomkKg_l0
0003omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_l000001_oNfmh00ol0003og]_No`00
0005omkKgP07o`000?oNfmkog]_NomkKg_l0003og]_No`000003omkKgP03o`000?oNfmko000000?o
g]_N00?o0000omkKg_l000000ooNfmh00ol0003og]_NomkKgP11omkKgP0DoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ
_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk3ooNfmh00ol0003og]_No`000003omkKgP03o`00
0?oNfmko000000?og]_N00?o0000omkKg_l000000ooNfmh00ol0003og]_NomkKgP04omkKgP03o`00
0?oNfmkog]_N00;og]_N00Oo0000omkKg_oNfmkog]_No`000?oNfmko000000Cog]_N00Co0000omkK
g_oNfmko00000_oNfmh00ol0003og]_NomkKgP02omkKgP05o`000?oNfmkog]_NomkKg_l000001?oN
fmh00ol0003og]_No`000003omkKgP03o`000?oNfmko000000;og]_N00Co0000omkKg_oNfmko0000
0ooNfmh00ol0003og]_No`000003omkKgP03o`000?oNfmkog]_N00Co000000?og]_No`000?oNfmh0
1?oNfmh:o`0000Cog]_N00?o0000omkKg_oNfmh00_oNfmh01ol0003og]_NomkKg_oNfmko0000omkK
g_l000001ooNfmh01?l0003og]_NomkKg_l00002omkKgP03o`000?oNfmkog]_N00Co00000_oNfmh3
o`0000;og]_N00?o0000omkKg_oNfmh01Ol000000ooNfmko0000omkKgP05omkKgP04o`000?oNfmko
g]_No`0000?og]_N00?o0000omkKg_l000000ooNfmh00ol0003og]_No`000004o`0000?og]_N00?o
0000omkKg_oNfmh01?oNfmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000000ooNfmh00ol0003o
g]_No`000003omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_oNfmh0@OoNfmh05?oWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`cog]_N0ol00002omkKgP07o`00
0?oNfmkog]_NomkKg_l0003og]_No`000003omkKgP03o`000?oNfmko000000?og]_N00?o0000omkK
g_oNfmh01?oNfmh4o`000003omkKg_l0003og]_N00;og]_N00?o0000omkKg_l000001?oNfmh01?l0
003og]_NomkKg_l00002omkKgP03o`000?oNfmkog]_N00;og]_N00Go0000omkKg_oNfmkog]_No`00
0004omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_l000000_oNfmh01?l0003og]_NomkK
g_l00003omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_oNfmh00ooNfmh00ol0003og]_N
o`00000ComkKgPCo000000?og]_No`000?oNfmh00_oNfmh00ol0003og]_No`000007omkKgP04o`00
0?oNfmkog]_No`0000;og]_N00?o0000omkKg_oNfmh00ooNfmh00ol0003og]_No`000005omkKgP04
o`000?oNfmkog]_No`0000?og]_N00?o0000omkKg_l000001_oNfmh01?l0003og]_NomkKg_l00003
omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_l000000ooNfmh01_l0003og]_NomkKg_l0
003og]_No`0000Gog]_N00Oo0000omkKg_oNfmkog]_No`000?oNfmko000000?og]_N00?o0000omkK
g_l000000ooNfmh00ol0003og]_No`000003omkKgP03o`000?oNfmkog]_N047og]_N01CoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/;omkKgP03o`000?oNfmkog]_N00?o
g]_N1?l00003omkKgP?o00000_oNfmh6o`0000Gog]_N00?o0000omkKg_oNfmh00ooNfmh3o`0000;o
g]_N0ol00002omkKgP?o000000?og]_No`000?l000001OoNfmh01Ol0003og]_NomkKg_oNfmko0000
00Cog]_N00?o0000omkKg_l000000ol000001_oNfmko0000o`000?l0003og]_No`0000?og]_N0ol0
0002omkKgPCo00000_oNfmh4o`0000;og]_N00?o0000omkKg_oNfmh04OoNfmh00ol0003og]_NomkK
gP03omkKgP?o00000_oNfmh3o`0000Gog]_N0ol000000ooNfmko0000o`000002omkKgPCo00000ooN
fmh7o`0000;og]_N0ol00002omkKgP?o00001?oNfmh00ol0003og]_NomkKgP04o`0000?og]_N1?l0
0002omkKgP?o00000_oNfmh01Ol0003og]_NomkKg_oNfmko000000Gog]_N0ol00002omkKgPCo0000
0_oNfmh01?l0003og]_NomkKg_l00003omkKgP06o`000?oNfmkog]_No`000?oNfmko0000@OoNfmh0
5?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOO
ioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`_og]_N00Oo0000omkK
g_oNfmkog]_No`000?oNfmko000000oog]_N00?o0000omkKg_oNfmh01?oNfmh00ol0003og]_NomkK
gP0HomkKgP05o`000?oNfmkog]_NomkKg_l000001?oNfmh00ol0003og]_NomkKgP05omkKgP03o`00
0?oNfmkog]_N01Gog]_N00?o0000omkKg_oNfmh04OoNfmh00ol0003og]_NomkKgP0TomkKgP03o`00
0?oNfmkog]_N01[og]_N00?o0000omkKg_oNfmh06_oNfmh00ol0003og]_NomkKgP07omkKgP03o`00
0?oNfmkog]_N047og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmS
IG/<omkKgP?o00000_oNfmh00ol0003og]_NomkKgP0=omkKgP03o`000?oNfmkog]_N00Cog]_N1?l0
000HomkKgP04o`000?oNfmkog]_NomkKgPCo00002?oNfmh01?l0003og]_NomkKg_l0000DomkKgP03
o`000?oNfmkog]_N017og]_N1?l0000SomkKgP03o`000?oNfmkog]_N00gog]_N00?o0000omkKg_oN
fmh02_oNfmh00ol0003og]_NomkKgP0JomkKgP03o`000?oNfmkog]_N00Kog]_N00?o0000omkKg_oN
fmh0@_oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N
<?oNfmh05?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oN
fmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh0
5?ooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
of=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=U
Non]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]
Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[go
oooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmS
IG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/0
0004of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UNooog]_N<?oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=U
Nooooooo[JZmof=UN`[og]_Nool0000Ro`0000Cog]_N01CoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk
00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_N
omkKgP02omkKgP0DonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oN
fmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh05?ooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=U
Non]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolN
ooooo`03o`000?oNfmkog]_N00;og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_o
ooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkK
gP0DoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOo
ooooonOOioooooooHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003o
ooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh05?oWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo
0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`00
0?oNfmkog]_N00;og]_N01CoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooo
oooWgnOoooooonOOioooooooimoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmS
IG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP0DonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooW
gnOoHfEkojfZ_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3o
oooooakooooo00?o0000omkKg_oNfmh00_oNfmh05?ooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooof=UNon]Z[gooooo0OmSIG/00004
of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N
00;og]_N01CoimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoW
oooooooWgnOoooooonOOiomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03
o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP0DoooooooWgnOoooooonOO
ioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooHfEkojfZ
_Oooool1of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo
00?o0000omkKg_oNfmh00_oNfmh05?oWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooo
ooooimoWoooooooWgnOoooooonOOioooooooimoWof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo
[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N01Co
ooooonOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoooooonOOiooooooo
imoWoooooomSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooo
oooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP0DonOOioooooooimoWoooooooWgnOooooo
onOOioooooooimoWoooooooWgnOoooooonOOioooooooimoWoooooooWgnOoHfEkojfZ_Oooool1of=U
N`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkK
g_oNfmh00_oNfmh00oo_knOoko?gohb>W00<oibN[@05ohb>W?o_knOoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmko
g]_N00;og]_N00?oknoWoiBFYOoNgnL03?oFdmh01OoNgnOoU9JUof=UNon]Z[gooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkK
gP02omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05
oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000oooo
ooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2
ono[k`04onOSkooNfnOog]_WomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh0
0_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?
gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000
ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_
koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oN
fmh00_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh0
1OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oo
oooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP04ono_ionDUZGoooooooOgo`;oknog
0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004
of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N
00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00Go
oooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003ooooo
ooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;o
kn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02
omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooo
oonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000oooooooo
ool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[
k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oN
fmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01Ooooooo
U9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo
0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl0
1?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N
00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBF
YOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3o
oooooakooooo00?o0000omkKg_oNfmh00_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Co
in?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP04
ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooo
oolNooooo`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOS
kooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh01?o_
knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=U
Non]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKg_oo00008_l00004omkKgP04ono_
ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEk
ojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh01?o_knOoU9JUooooooog
mol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[
k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEkoooNfmh`omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oW
omkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=U
Ne;og]_N0_l00007omkKgP03o`000?oNfmkog]_N00Oog]_N00?o0000omkKg_oNfmh07ooNfmh00ol0
003og]_NomkKgP2UomkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooF
enL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNeCog]_N
00?o0000omkKg_oNfmh00ooNfmh00ol0003og]_NomkKgP08omkKgP03o`000?oNfmkog]_N023og]_N
00?o0000omkKg_oNfmh0Y?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooN
gnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/;
omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_oNfmh01?l00002omkKgPCo000000?og]_N
o`000?oNfmh00_oNfmh00ol0003og]_NomkKgP04omkKgP?o00000ooNfmh4o`000003omkKg_l0003o
000000;o00001_oNfmh5o`000003omkKg_l0003og]_N00;og]_N00Ko0000omkKg_l0003o0000omkK
g_l00005omkKgP03o`000?oNfmkog]_N00?og]_N00?o0000omkKg_oNfmh00_oNfmh4o`0000;og]_N
1?l00002omkKgP;o000000?og]_No`000?oNfmh00_oNfmh3o`0000;og]_N00Go0000omkKg_oNfmko
g]_No`000002omkKgPCo000000?og]_No`000?oNfmh00ooNfmh00ol0003og]_No`00002TomkKgP04
ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`_og]_N00?o0000omkKg_l000000ooN
fmh00ol0003og]_No`000003omkKgP03o`000?oNfmko000000Kog]_N00?o0000omkKg_l000001_oN
fmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000000ooNfmh00ol0003og]_No`000003omkKgP03
o`000?oNfmkog]_N00?og]_N00?o0000omkKg_oNfmh00ooNfmh01ol0003og]_NomkKg_oNfmko0000
omkKg_l000000_oNfmh00ol0003og]_NomkKgP02omkKgP03o`000?oNfmko000000Cog]_N00Go0000
omkKg_oNfmkog]_No`000004omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_l000000_oN
fmh01?l0003og]_NomkKg_l00003omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_l00000
0ooNfmh00ol0003og]_No`000004omkKgP03o`000?oNfmkog]_N0:Cog]_N00CoknoWoiBFYOoooooo
moOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk2ooNfmh00ol0003og]_No`000003omkKgP03o`000?oNfmko
000000?og]_N00?o0000omkKg_l000001?l00003omkKgP03o`000?oNfmkog]_N00Wog]_N00?o0000
omkKg_l000000ooNfmh00ol0003og]_No`000003omkKgP04o`000?oNfmko0000o`0000;og]_N00?o
0000omkKg_oNfmh00ooNfmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000000_oNfmh00ol0003o
g]_NomkKgP02omkKgP03o`000?oNfmko000000Cog]_N00Go0000omkKg_oNfmkog]_No`000004omkK
gP03o`000?oNfmko000000?og]_N00?o0000omkKg_l000000_oNfmh01?l0003og]_NomkKg_l00003
omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_oNfmh01?l000000ooNfmko0000omkKgP03
omkKgP03o`000?oNfmkog]_N0:Cog]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooN
gnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk2ooNfmh00ol0003og]_No`000003omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_l0
00000ooNfmh01_l0003og]_NomkKg_l0003og]_No`0000Oog]_N0ol00002omkKgP07o`000?oNfmko
g]_NomkKg_l0003og]_No`000003omkKgP03o`000?oNfmkog]_N00?og]_N1Ol000000ooNfmko0000
omkKgP02omkKgP03o`000?oNfmko000000;og]_N00?o0000omkKg_oNfmh00_oNfmh00ol0003og]_N
o`000004omkKgP05o`000?oNfmkog]_NomkKg_l000001?oNfmh00ol0003og]_No`000003omkKgP03
o`000?oNfmko000000;og]_N00Co0000omkKg_oNfmko00000ooNfmh00ol0003og]_No`000003omkK
gP03o`000?oNfmkog]_N00?og]_N00?o0000omkKg_l000001?oNfmh00ol0003og]_NomkKgP2TomkK
gP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonD
UZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`_og]_N00?o0000omkKg_l00000
0ol00003omkKgPCo00000_oNfmh3o`0000;og]_N00Go0000omkKg_oNfmkog]_No`000005omkKgP03
o`000?oNfmkog]_N00?og]_N00Ko0000omkKg_oNfmkog]_No`000?oNfmh4o`0000Kog]_N00?o0000
omkKg_oNfmh00ooNfmh4o`000005omkKg_l0003o0000o`000?oNfmh00ol000000ooNfmko0000omkK
gP02omkKgP05o`000?oNfmkog]_NomkKg_l000000ooNfmh00ol0003og]_NomkKgP02omkKgP03o`00
0?oNfmko000000?o000000Kog]_No`000?l0003o0000omkKg_l00003omkKgP?o00000_oNfmh4o`00
00;og]_N1?l00002omkKgP03o`000?oNfmkog]_N00;og]_N00?o0000omkKg_l00000Y?oNfmh01?o_
knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=U
Non]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/;omkKgP03o`000?oNfmkog]_N00Wog]_N
00?o0000omkKg_oNfmh03ooNfmh01Ol0003og]_NomkKg_oNfmko000000Oog]_N00?o0000omkKg_oN
fmh01ooNfmh00ol0003og]_NomkKgP09omkKgP03o`000?oNfmkog]_N00cog]_N00Go0000omkKg_oN
fmkog]_No`000004omkKgP03o`000?oNfmkog]_N00Gog]_N00?o0000omkKg_oNfmh05OoNfmh00ol0
003og]_NomkKgP02omkKgP03o`000?oNfmkog]_N0:Cog]_N00CoknoWoiBFYOoooooomoOo0_o_koL2
ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk2ooNfmh00ol0003og]_NomkKgP09omkKgP03o`000?oNfmkog]_N013og]_N
0ol00008omkKgP03o`000?oNfmkog]_N00Oog]_N1Ol00007omkKgP03o`000?oNfmkog]_N00gog]_N
00Co0000omkKg_oNfmkog]_N1?l00008omkKgP04o`000?oNfmkog]_No`0001Cog]_N00Go0000omkK
g_oNfmkog]_No`00002WomkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkO
iooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooo
g]_N<?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh0
1OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgS3og]_N00Co
knoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmS
IG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmh`omkKgP04ono_ionDUZGooooo
ooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;o
kn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooN
gnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEkoooNfmh`omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3
olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oN
fmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01Ooooooo
U9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBF
YOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZm
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmh`omkKgP04ono_ionDUZGoooooooOgo`;o
knog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UNooog]_N<?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Co
in?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oW
omKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooN
fmh`omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05
oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh01?o_
knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=U
Non]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBFYOoooooo
moOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmkoo`0002;o00001?oNfmh01?o_knOoU9JUooooooog
mol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003o
g]_NomkKgP02omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3
olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o
0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo
0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkK
g_oNfmh00_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>
cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`00
0?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP04ono_ionDUZGoooooooOgo`;o
knog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmko
g]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN
00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003o
ooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh01?o_knOoU9JUooooooogmol2ono_
m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkK
gP02omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05
oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000oooo
ooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2
ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh0
0_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01Ooo
ooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooo
oooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_
jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;o
g]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00Gooooo
oiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003ooooooooo
o`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__
00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkK
gP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonD
UZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0
oooooolNooooo`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04
onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh0
1?o_knOoU9JUooooooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooo
oonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000oooooooo
ool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[
k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkK
gP02omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01OoWhnoog]_WomkKiooFenOoc]?N00;o
c/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0
003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh01?o_knOoU9JUooooooogmol2
ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`00
0?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOSkooNfnOog]_WomKG
ioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/:
omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP04ono_ionDUZGo
ooooooOgo`;oknog0_o_jnl01OoWhnoog]_WomkKiooFenOoc]?N00;oc/oN00GooooooiBFYOmSIG_o
[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooako
oooo00?o0000omkKg_oNfmh00_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Goin?_omkK
iooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo
[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N00Co
knoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01Ooooooo
U9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo
0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl0
1OoWhnoog]_WomkKiooFenOoc]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh0
0_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?
gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000
ooooooooool0oooooolNooooo`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_
koL2ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003o
g]_NomkKgP02omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01OoWhnoog]_WomkKiooFenOo
c]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk2_oN
fmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh01?o_knOoU9JUoooo
ooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ
_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolNoooo
o`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOSkooNfnOo
g]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/:omkKgP03o`000?oooooooooo0?oooooo7_ooool00ol0003og]_NomkKgP02omkKgP04ono_
ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3olk?gP05oooooonDUZGoHfEk
ojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`[og]_N00?o0000ooooooooool0oooooolN
ooooo`03o`000?oNfmkog]_N00;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooN
fnOog]_WomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk2_oNfmh00ol0003oooooooooo`3ooooooakooooo00?o0000omkKg_oNfmh00_oNfmh01?o_knOo
U9JUooooooogmol2ono_m`;okn__00Coin?_omkKiooNfnOoe]OW0oo>cmh01OooooooU9JUof=UNon]
Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/:omkKg_oo00008_l00004omkKgP04ono_ionD
UZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3olk?gP05oooooonDUZGoHfEkojfZ
_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh01?o_knOoU9JUooooooogmol2
ono_m`;okn__00Coin?_omkKiooNfnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04
onOSkooNfnOog]_WomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEkoooNfmh`omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkK
iooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNeOo
g]_N0_l0003FomkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3
olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNeWog]_N00?o
0000omkKg_oNfmh0dooNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkKiooNfnOo
e]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/;omkK
gP03o`000?oNfmko000000?og]_N00?o0000omkKg_oNfmh01?l00002omkKgPCo000000?og]_No`00
0?oNfmh00_oNfmh00ol0003og]_NomkKgP03omkKgP04o`000?oNfmkog]_No`0000;og]_N00?o0000
omkKg_oNfmh01?l000001OoNfmko0000omkKg_oNfmko000000?og]_N00?o0000omkKg_oNfmh00ooN
fmh5o`000003omkKg_l0003og]_N00;og]_N00Ko0000omkKg_l0003o0000omkKg_l00005omkKgP05
o`000?oNfmkog]_NomkKg_l00000dOoNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_
omkKiooNfnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/;omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_l000000ooNfmh00ol0003og]_N
o`000006omkKgP03o`000?oNfmko000000Kog]_N00Co0000omkKg_oNfmko00000_oNfmh00ol0003o
g]_No`000003omkKgP03o`000?oNfmko000000;og]_N00Go0000omkKg_oNfmkog]_No`000005omkK
gP03o`000?oNfmkog]_N00?og]_N00Oo0000omkKg_oNfmkog]_No`000?oNfmko000000;og]_N00?o
0000omkKg_oNfmh00_oNfmh00ol0003og]_No`00003DomkKgP04ono_ionDUZGoooooooOgo`;oknog
1_n<UZD3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`_o
g]_N00?o0000omkKg_l000000ooNfmh00ol0003og]_No`000003omkKgP03o`000?oNfmko000000Co
00000ooNfmh00ol0003og]_NomkKgP05omkKgP07o`000?oNfmko0000omkKg_l0003og]_No`000002
omkKgPCo000000Gog]_No`000?oNfmkog]_No`000003omkKgP03o`000?oNfmkog]_N00?og]_N00?o
0000omkKg_oNfmh00ooNfmh01ol0003og]_NomkKg_oNfmko0000omkKg_l000000_oNfmh00ol0003o
g]_NomkKgP02omkKgP03o`000?oNfmko00000=Cog]_N00GoknoWoiBFYOoooooomoOoono_m`06oooo
o`09omKGioo>cmkoc/oNolk?g_ooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/;omkKgP03o`000?oNfmko000000?og]_N00?o0000omkKg_l000000ooNfmh00ol0003og]_N
o`000003omkKgP06o`000?oNfmkog]_No`000?oNfmko00001_oNfmh01ol0003og]_No`000?oNfmko
0000omkKg_l000001OoNfmh00ol0003og]_No`000002omkKgP05o`000?oNfmkog]_NomkKg_l00000
1OoNfmh5o`000003omkKg_l0003og]_N00;og]_N00?o0000omkKg_l000000_oNfmh00ol0003og]_N
omkKgP02omkKgP03o`000?oNfmko00000=Cog]_N00CoknoWoiBFYOoooooomoOo0_o_koL6ohbFY@?o
c/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk2ooNfmh00ol0
003og]_No`000003o`0000?og]_N1?l00002omkKgP?o00000_oNfmh01Ol0003og]_NomkKg_oNfmko
000000Gog]_N0_l00003omkKgP;o000000?og]_No`000?l000000_l00002omkKgP03o`000?oNfmko
g]_N00Co00001_oNfmh00ol0003og]_NomkKgP03omkKgPCo000000Gog]_No`000?l0003o0000omkK
gP03o`000003omkKg_l0003og]_N00;og]_N00?o0000omkKg_l00000dOoNfmh01Oo_knOoU9JUoooo
ooogmoooknog00Kooooo00Woe]OWolk?g_o>cmkoc/oNoooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`_og]_N00?o0000omkKg_oNfmh02OoNfmh00ol0003og]_NomkKgP0?
omkKgP;o00000ooNfmh2o`0001Cog]_N00?o0000omkKg_oNfmh02OoNfmh00ol0003og]_NomkKgP3L
omkKgP04ono_ionDUZGoooooooOgo`;oknog1_n<UZD3olk?gP05oooooonDUZGoHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`_og]_N00?o0000omkKg_oNfmh02OoNfmh00ol0003og]_N
omkKgP0?omkKgP03o`000?oNfmkog]_N00?og]_N00?o0000omkKg_oNfmh01OoNfmh00ol0003og]_N
omkKgP0:omkKgPGo00001ooNfmh00ol0003og]_NomkKgP3LomkKgP05ono_ionDUZGoooooooOgooo_
koL01_ooool02OoFenOoc/oNolk?g_o>cmkooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEkoooNfmh`omkKgP04ono_ionDUZGoooooooOgo`;oknog1_n<UZD3olk?gP05oooo
oonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh01Oo_knOo
U9JUooooooogmoooknog00Kooooo00Woe]OWolk?g_o>cmkoc/oNoooooonDUZGoHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;o
kn__00Coin?_omkKiooNfnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooN
fnOog]_WomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEkoooNfmh`omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3
olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oN
fmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkKiooNfnOoe]OW0oo>cmh01Ooooooo
U9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBF
YOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOog]_WomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZm
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmh`omkKgP04ono_ionDUZGoooooooOgo`;o
knog0_o_jnl01?oWhnoog]_WomkKiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UNooog]_N<?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Co
in?_omkKiooNfnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNfnOog]_W
omKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk[_oN
fmh4o`0001;og]_N1?l0001WomkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]_W
omkKiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=U
Njkog]_N00Go0000omkKg_oNfmkog]_No`00000AomkKgP05o`000?oNfmkog]_NomkKg_l00000I_oN
fmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05
oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNjkog]_N00?o0000omkK
g_oNfmh00_l0000AomkKgP03o`000?oNfmkog]_N00;o0000I_oNfmh01?o_knOoU9JUooooooogmol2
ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UNgCog]_N0ol00002omkKgPGo000000Cog]_No`000?l0003o
g]_N0_l000000ooNfmko0000o`000004omkKgP?o000000Cog]_No`000?oNfmkog]_N0_l000001?oN
fmko0000o`000?oNfmh2o`000004omkKg_l0003o0000o`0000;og]_N00Go0000omkKg_oNfmko0000
omkKgP02o`000004omkKg_l0003og]_NomkKgP;o00000_oNfmh2o`0000Oog]_N0ol00003omkKgP;o
000000?og]_No`000?l000000_oNfmh2o`0000?og]_N0ol00005omkKgP;o00000_oNfmh2o`0000Ko
g]_N0_l000001?oNfmko0000omkKg_oNfmh2o`000004omkKg_l0003o0000o`0000Sog]_N1?l00000
0ooNfmko0000o`000003o`000003omkKg_l0003og]_N00?og]_N00?o0000omkKg_oNfmh00_oNfmh3
o`0000;og]_N00?o0000omkKg_oNfmh00_l000000ooNfmko0000o`000007omkKgPCo000000Cog]_N
o`000?l0003o00000_oNfmh2o`000003omkKg_l0003o000000Gog]_N00CoknoWoiBFYOoooooomoOo
0_o_koL2ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG]eomkKgP03o`000?oNfmkog]_N00;og]_N00Co0000omkK
g_l0003og]_N0_l00002omkKgP04o`000?oNfmko0000o`0000Kog]_N00Co0000omkKg_oNfmko0000
0_oNfmh01Ol0003og]_NomkKg_l0003og]_N00;o00000_oNfmh01?l0003og]_NomkKg_l00002omkK
gP05o`000?oNfmko0000omkKg_l000000_oNfmh01?l0003og]_NomkKg_l00003omkKgP03o`000?oN
fmkog]_N00Oog]_N00?o0000omkKg_oNfmh00_oNfmh01?l0003og]_No`000?l00003omkKgP03o`00
0?oNfmkog]_N00;og]_N00Co0000omkKg_oNfmko00001?oNfmh01?l0003og]_NomkKg_l00002omkK
gP03o`000?oNfmkog]_N00?og]_N00Co0000omkKg_oNfmko00000_oNfmh01?l0003og]_NomkKg_l0
0002omkKgP03o`000?oNfmkog]_N00Cog]_N00?o0000omkKg_oNfmh00_oNfmh2o`0000;og]_N00Co
0000omkKg_oNfmko00001?oNfmh00ol0003og]_NomkKgP02omkKgP06o`000?oNfmkog]_No`000?oN
fmko00000_oNfmh01?l0003og]_NomkKg_l00007omkKgP03o`000?oNfmkog]_N00;og]_N0_l00002
omkKgP03o`000?oNfmko000000;og]_N00?o0000omkKg_oNfmh01?oNfmh01?o_knOoU9JUooooooog
mol2ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Ooo
ool00OmSIG/00004of=UNooooooo[JZmof=UNgKog]_N00Oo0000omkKg_oNfmkog]_No`000?oNfmko
000000;og]_N0_l000001?oNfmko0000omkKg_oNfmh2o`0000Kog]_N00Co0000omkKg_oNfmko0000
0_oNfmh00ol0003og]_No`000002omkKgP;o000000Cog]_No`000?l0003o00001?oNfmh01Ol0003o
g]_NomkKg_oNfmko000000;og]_N00Co0000omkKg_oNfmko00000_oNfmh3o`0000Sog]_N00Go0000
omkKg_oNfmkog]_No`000002omkKgP04o`000?oNfmkog]_NomkKgP?o00001OoNfmh00ol0003og]_N
omkKgP02omkKgP04o`000?oNfmkog]_No`0000?og]_N00?o0000omkKg_oNfmh00_oNfmh01Ol0003o
g]_NomkKg_oNfmko000000;og]_N00?o0000omkKg_l000000_l00006omkKgP03o`000?oNfmkog]_N
00Cog]_N00Co0000omkKg_oNfmko00000ooNfmh00ol0003og]_NomkKgP02omkKgP04o`000?oNfmko
g]_NomkKgP?o00000ooNfmh01_l0003og]_NomkKg_l0003og]_No`0000Kog]_N00?o0000omkKg_oN
fmh01?oNfmh3o`0000;og]_N00Co0000omkKg_oNfmko00001_oNfmh01?o_knOoU9JUooooooogmol2
ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UNgKog]_N1Ol000000ooNfmko0000omkKgP02omkKgP03o`00
0?oNfmko000000?og]_N00?o0000omkKg_oNfmh01?oNfmh01?l0003og]_NomkKg_l00002omkKgP03
o`000?oNfmko000000?og]_N00?o0000omkKg_l000000_oNfmh01Ol0003og]_NomkKg_oNfmko0000
00?og]_N00Co0000omkKg_oNfmko00000_oNfmh01?l0003og]_NomkKg_l00002omkKgP03o`000?oN
fmkog]_N00Gog]_N00Go0000omkKg_oNfmkog]_No`000003omkKgP04o`000?oNfmkog]_No`0000;o
g]_N00Go0000omkKg_oNfmkog]_No`000006omkKgP03o`000?oNfmko000000?og]_N00?o0000omkK
g_oNfmh00ooNfmh01?l0003og]_NomkKg_l00002omkKgP03o`000?oNfmko000000;og]_N00?o0000
omkKg_oNfmh00ooNfmh00ol0003og]_NomkKgP05omkKgP04o`000?oNfmkog]_No`0000;og]_N00?o
0000omkKg_oNfmh00_oNfmh01Ol0003og]_NomkKg_oNfmko000000;og]_N00Co0000omkKg_oNfmko
00000_oNfmh01?l0003og]_NomkKg_l00005omkKgP03o`000?oNfmkog]_N00Cog]_N00Co0000omkK
g_oNfmko00000_oNfmh01?l0003og]_NomkKg_l00005omkKgP04ono_ionDUZGoooooooOgo`;oknog
0_o_jnl01OoWhnoog]_WomkKiooFenOoc]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEkMooNfmh01?l0003og]_NomkKg_l00002omkKgP04o`000?oNfmko
g]_No`0000;og]_N00Co0000omkKg_oNfmko00001_oNfmh00ol0003og]_NomkKgP02o`000005omkK
g_l0003og]_NomkKg_l000000_oNfmh01_l0003og]_NomkKg_l0003og]_No`0000?og]_N0_l00002
omkKgP03o`000?oNfmkog]_N00;o000000Gog]_No`000?oNfmkog]_No`000002omkKgP03o`000?oN
fmkog]_N00Gog]_N00?o0000omkKg_oNfmh00_oNfmh01?l0003og]_NomkKg_l00002omkKgP04o`00
0?oNfmkog]_No`0000;og]_N00?o0000omkKg_oNfmh01OoNfmh01?l0003og]_NomkKg_l00002omkK
gP03o`000?oNfmkog]_N00?og]_N00?o0000omkKg_oNfmh00_l000001ooNfmko0000omkKg_oNfmko
0000omkKg_l000001OoNfmh00ol0003og]_NomkKgP05omkKgP04o`000?oNfmkog]_No`0000;og]_N
0ol00002omkKgP?o00000_oNfmh00ol0003og]_No`000002omkKgP;o000000Gog]_No`000?oNfmko
g]_No`000005omkKgP03o`000?oNfmkog]_N00Gog]_N00?o0000omkKg_l000000_oNfmh01?l0003o
g]_NomkKg_l00005omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01OoWhnoog]_WomkKiooF
enOoc]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
N?oNfmh00ol0003og]_No`000003omkKgP?o00000ooNfmh3o`0000Kog]_N00Go0000omkKg_l0003o
0000omkKgP02o`0000?og]_N0ol00003omkKgP;o00000_oNfmh2o`000005omkKg_l0003o0000o`00
0?oNfmh00_l000000ooNfmko0000o`000003omkKgPCo00001_oNfmh00ol0003og]_NomkKgP03omkK
gP?o00000ooNfmh4o`0000;og]_N0_l00004omkKgP?o00000_oNfmh2o`0000Gog]_N0ol000000ooN
fmko0000omkKgP02o`0000?og]_N0_l00005omkKgP03o`000?oNfmkog]_N00Cog]_N0_l00002omkK
gP07o`000?oNfmko0000o`000?oNfmko0000omkKgP02o`000003omkKg_l0003og]_N00;og]_N0_l0
00001?oNfmko0000o`000?oNfmh2o`000004omkKg_l0003o0000o`0000Cog]_N00?o0000omkKg_oN
fmh01_oNfmh2o`0000;og]_N00Co0000omkKg_oNfmko00001OoNfmh01?o_knOoU9JUooooooogmol2
ono_m`;okn__00Goin?_omkKiooNfnOoe]OWolkCgP02olk?gP05oooooonDUZGoHfEkojfZ_Oooool0
0OmSIG/00004of=UNooooooo[JZmof=UNgSog]_N00?o0000omkKg_l000001OoNfmh00ol0003og]_N
omkKgP03omkKgP03o`000?oNfmkog]_N00Cog]_N00?o0000omkKg_oNfmh02OoNfmh00ol0003og]_N
omkKgP0OomkKgP03o`000?oNfmkog]_N01Gog]_N00?o0000omkKg_oNfmh02OoNfmh01?l0003og]_N
omkKg_l0000>omkKgP03o`000?oNfmkog]_N00;og]_N00?o0000omkKg_oNfmh06_oNfmh00ol0003o
g]_NomkKgP04omkKgP03o`000?oNfmkog]_N00;og]_N00?o0000omkKg_oNfmh01?oNfmh01?l0003o
g]_NomkKg_l00005omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01OoWhnoog]_WomkKiooF
enOoc]?N00;oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
NOoNfmh2o`0000Kog]_N00?o0000omkKg_oNfmh00ooNfmh00ol0003og]_NomkKgP04omkKgP03o`00
0?oNfmkog]_N00Wog]_N00?o0000omkKg_oNfmh02_oNfmh00ol0003og]_NomkKgP0>omkKgP04o`00
0?oNfmkog]_No`0000;og]_N00?o0000omkKg_oNfmh04ooNfmh00ol0003og]_NomkKgP09omkKgP04
o`000?oNfmkog]_No`0000kog]_N00Co0000omkKg_oNfmkog]_N0_l0000LomkKgP03o`000?oNfmko
g]_N00Cog]_N00Co0000omkKg_oNfmkog]_N0_l00006omkKgP04o`000?oNfmkog]_No`0000Cog]_N
00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>cmh01Ooo
ooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG]jomkKgP03o`000?oNfmko
g]_N00?og]_N0_l00004omkKgP;o00001OoNfmh3o`0000Wog]_N0_l0000MomkKgPOo00008ooNfmh2
o`0000oog]_N0ol000000ooNfmko0000omkKgP0SomkKgP?o000000?og]_No`000?oNfmh01?oNfmh2
o`000003omkKg_l0003o000000Cog]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOSkooN
fnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOSkooNfnOog]_W
omKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG_oomkKgS3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOSkooNfnOog]_WomKGioo>
dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkK
gS3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOSkooNfnOog]_WomKGioo>dmh00_o>
cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgS3og]_N
00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBF
YOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmh`omkKgP04ono_ionDUZGo
ooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Ooo
ool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh01?o_knOoU9JUooooooogmol2ono_
m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG_oomkKgS3og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`04onOS
kooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEkoooNfmh`omkKgP04ono_ionDUZGoooooooOgo`;oknog0_o_jnl01?oWhnoog]oWomkOiooF
enL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N
<?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01Ooo
ooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgS3og]_N00CoknoW
oiBFYOoooooomoOo0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o
[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmh`omkKgP04ono_ionDUZGoooooooOg
o`;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmS
IG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__
00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/4omkKg_oo0000;?l000001?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_
omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/4omkKgP03o`000?l0DHco056<0?oo056<:?l0DH`01Ol0003oknoWoiBFYOoooooomoOo00;o
knog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`1AS?l0DH`0ool0DH`Xo`1AS005o`000?o_knOo
U9JUooooooogmol00_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o
[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o056<o`1AS03oo`1AS2So
056<00Go0000ono_ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh0
1OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l0
DHco056<0?oo056<:?l0DH`01Ol0003oknoWoiBFYOoooooomoOo00;oknog0_o_jnl01?oWhnoog]oW
omkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=U
N`Cog]_N00?o0000o`1AS?l0DH`0ool0DH`Xo`1AS005o`000?o_knOoU9JUooooooogmol00_o_koL2
ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmh00ol0003o056<o`1AS03oo`1AS2So056<00Go0000ono_ionDUZGo
ooooooOgo`02ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[go
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l0DHco056<0?oo056<:?l0DH`0
1Ol0003oknoWoiBFYOoooooomoOo00;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooo
oonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`1AS?l0
DH`0ool0DH`Xo`1AS005o`000?o_knOoU9JUooooooogmol00_o_koL2ono[k`04onOSkooNgnOog]oW
omKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oN
fmh00ol0003o056<o`1AS03oo`1AS2So056<00Go0000ono_ionDUZGoooooooOgo`02ono_m`;okn__
00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/4omkKgP03o`000?l0DHco056<0?oo056<1?l0DH`Hoe:F]@co056<00Go0000ono_
ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=U
Non]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l0DHco056<0?oo056<
1?l0DH`Hoe:F]@co056<00Go0000ono_ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkOiooN
gnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgP03o`000?l0DHco056<0?oo056<1?l0DH`Hoe:F]@co056<00Go0000ono_ionDUZGoooooooOg
o`02ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l0DHco056<0?oo056<1?l0DH`Hoe:F]@co
056<00Go0000ono_ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh0
1OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l0
DHco056<0?oo056<1?l0DH`Hoe:F]@co056<00Go0000ono_ionDUZGoooooooOgo`02ono_m`;okn__
00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/4omkKgP03o`000?l0DHco056<0?oo056<1?l0DH`Hoe:F]@co056<00Go0000ono_
ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=U
Non]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l0DHco056<0?oo056<
1?l0DH`Hoe:F]@co056<00Go0000ono_ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkOiooN
gnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgP03o`000?l0DHco056<00So056<1oooool4o`1AS0;ooooo00?o056<ooooooooool00_l0DH`2
ooooo`?o056<0oooool5o`1AS0;ooooo1?l0DH`2ooooo`Co056<0oooool5o`1AS0?ooooo0ol0DH`4
ooooo`?o056<0_ooool00ol0DHcoooooooooo`06o`1AS0?ooooo1_l0DH`3ooooo`Co056<0_ooool2
o`1AS0;ooooo1_l0DH`2ooooo`;o056<0_ooool3o`1AS0;ooooo1?l0DH`2ooooo`03o`1AS?oooooo
oooo00Co056<1?ooool3o`1AS0;ooooo0_l0DH`2ooooofoo056<2omBU[D2ooooo`_oDYJe3?l0DH`0
1Ol0003oknoWoiBFYOoooooomoOo00;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooo
oonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`1AS?l0
DH`02?l0DH`7ooooo`?o056<1_ooool2o`1AS0;ooooo0_l0DH`4ooooo`Go056<0_ooool3o`1AS0?o
oooo0ol0DH`5ooooo`?o056<1?ooool2o`1AS0Kooooo0_l0DH`6ooooo`Co056<1Oooool4o`1AS0Go
oooo0ol0DH`2ooooo`;o056<0_ooool6o`1AS0;ooooo0_l0DH`2ooooo`?o056<0_ooool3o`1AS0Ko
oooo0ol0DH`6ooooo`;o056<0_ooool2o`1AS0;oooooKol0DH`;oe:F]@;ooooo2omBU[D<o`1AS005
o`000?o_knOoU9JUooooooogmol00_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00Gooooo
oiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o056<o`1A
S008o`1AS0;ooooo1ol0DH`3ooooo`04o`1AS?ooooooooooooooo`;o056<0_ooool2o`1AS0;ooooo
1ol0DH`2ooooo`;o056<1?ooool2o`1AS0?ooooo00Co056<oooooooooooooooo0_l0DH`2ooooo`?o
056<0_ooool7o`1AS0;ooooo0_l0DH`3ooooo`;o056<0oooool01?l0DHcoooooooooooooool2o`1A
S0?ooooo00Co056<oooooooooooooooo0_l0DH`2ooooo`03o`1AS?oooooooooo00Oo056<0_ooool2
o`1AS0;ooooo0ol0DH`2ooooo`;o056<0oooool01?l0DHcoooooooooooooool2o`1AS0;ooooo2?l0
DH`4ooooog3o056<6?mBU[D<o`1AS005o`000?o_knOoU9JUooooooogmol00_o_koL2ono[k`04onOS
kooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk1?oNfmh00ol0003o056<o`1AS008o`1AS0;ooooo1ol0DH`2ooooo`?o056<0_ooool2o`1A
S0;ooooo0_l0DH`2ooooo`Oo056<0_ooool2o`1AS0Cooooo0_l0DH`2ooooo`?o056<0_ooool2o`1A
S0;ooooo0ol0DH`7ooooo`;o056<0_ooool3o`1AS0;ooooo0_l0DH`2ooooo`?o056<0_ooool2o`1A
S0;ooooo0ol0DH`2ooooo`;o056<1Oooool7o`1AS0;ooooo0_l0DH`2ooooo`?o056<0_ooool2o`1A
S0;ooooo0ol0DH`2ooooo`;o056<1oooool4o`1AS0;oooooLOl0DH`;oe:F]@;ooooo2omBU[D<o`1A
S005o`000?o_knOoU9JUooooooogmol00_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00Go
oooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o056<
o`1AS008o`1AS0Oooooo0_l0DH`2ooooo`?o056<0_ooool2o`1AS0;ooooo0_l0DH`2ooooo`Oo056<
0_ooool01?l0DHcoooooooooool0DH`2ooooo`;o056<0_ooool3o`1AS0;ooooo0_l0DH`2ooooo`?o
056<1oooool2o`1AS0;ooooo0ol0DH`2ooooo`;o056<0_ooool3o`1AS0;ooooo0_l0DH`2ooooo`?o
056<0_ooool2o`1AS0Cooooo2?l0DH`2ooooo`;o056<0_ooool3o`1AS0;ooooo0_l0DH`2ooooo`?o
056<0_ooool2o`1AS0Oooooo1?l0DH`2ooooog7o056<2omBU[D2ooooo`_oDYJe3?l0DH`01Ol0003o
knoWoiBFYOoooooomoOo00;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`1AS?l0DH`02?l0
DH`7ooooo`;o056<0oooool01?l0DHcoooooooooooooool2o`1AS0;ooooo0_l0DH`2ooooo`Oo056<
0_ooool01?l0DHcoooooooooool0DH`2ooooo`;o056<0oooool01?l0DHcoooooooooooooool2o`1A
S0;ooooo0ol0DH`2ooooo`?o056<0_ooool2o`1AS0?ooooo00Co056<oooooooooooooooo0_l0DH`3
ooooo`04o`1AS?ooooooooooooooo`;o056<0oooool01?l0DHcoooooooooooooool2o`1AS0Cooooo
2?l0DH`2ooooo`;o056<0oooool2o`1AS0;ooooo0_l0DH`3ooooo`04o`1AS?ooooooooooooooo`;o
056<0_ooool3o`1AS0;ooooo0ol0DH`4ooooog3o056<3?mBU[D2ooooo`[oDYJe3?l0DH`01Ol0003o
knoWoiBFYOoooooomoOo00;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGo
HfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`1AS?l0DH`02?l0
DH`2ooooo`So056<1_ooool2o`1AS0;ooooo00?o056<ooooooooool00oooool5o`1AS0Cooooo0_l0
DH`2ooooo`?o056<1Oooool2o`1AS0Gooooo0_l0DH`5ooooo`?o056<1_ooool4o`1AS0Gooooo1?l0
DH`5ooooo`?o056<0_ooool00ol0DHcoooooooooo`07o`1AS0;ooooo0_l0DH`7ooooo`?o056<1_oo
ool3o`1AS0Gooooo0ol0DH`2ooooo`;o056<0_oooom_o`1AS0goDYJe0_ooool9oe:F]@co056<00Go
0000ono_ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01Ooooooo
U9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l0DHco056<
00So056<0_ooool9o`1AS0;ooooo00?o056<ooooooooool00_l0DH`2ooooo`03o`1AS?oooooooooo
00?ooooo1Ol0DH`4ooooo`;o056<0_ooool4o`1AS0?ooooo0ol0DH`5ooooo`?o056<0oooool4o`1A
S0;ooooo00?o056<ooooooooool01_l0DH`3ooooo`Ko056<0oooool4o`1AS0;ooooo0_l0DH`2oooo
o`Ko056<0_ooool2o`1AS0;ooooo00Co056<oooooooooooooooo1Ol0DH`2ooooo`03o`1AS?oooooo
oooo00Co056<0oooool4o`1AS0;ooooo0_l0DH`2ooooofoo056<2OmBU[D2ooooo`;oDYJe0_ooool9
oe:F]@co056<00Go0000ono_ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkOiooNgnOoe]OW
0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03
o`000?l0DHco056<00So056<1oooool7o`1AS0;ooooo1_l0DH`2ooooo`Oo056<0oooool3o`1AS0;o
oooo2ol0DH`2ooooo`co056<0_oooolIo`1AS0;ooooo2_l0DH`2oooooa3o056<0_oooon0o`1AS0[o
DYJe1?ooool:oe:F]@co056<00Go0000ono_ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkO
iooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/4omkKgP03o`000?l0DHco056<00So056<1oooool7o`1AS0;ooooo0_l0DH`2ooooo`?o056<00?o
ooooo`1AS?l0DH`01Ol0DH`2ooooo`Co056<0_ooool<o`1AS003ooooool0DHco056<00[o056<0_oo
oolIo`1AS0;ooooo2_l0DH`2oooooa3o056<0_oooon0o`1AS1SoDYJe3?l0DH`01Ol0003oknoWoiBF
YOoooooomoOo00;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ
_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`1AS?l0DH`0ool0DH`4o`1A
S1SoDYJe3?l0DH`01Ol0003oknoWoiBFYOoooooomoOo00;oknog0_o_jnl01?oWhnoog]oWomkOiooF
enL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N
00?o0000o`1AS?l0DH`0ool0DH`4o`1AS1SoDYJe3?l0DH`01Ol0003oknoWoiBFYOoooooomoOo00;o
knog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`1AS?l0DH`0ool0DH`4o`1AS1SoDYJe3?l0DH`0
1Ol0003oknoWoiBFYOoooooomoOo00;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooo
oonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`1AS?l0
DH`0ool0DH`4o`1AS1SoDYJe3?l0DH`01Ol0003oknoWoiBFYOoooooomoOo00;oknog0_o_jnl01?oW
hnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo
[JZmof=UN`Cog]_N00?o0000o`1AS?l0DH`0ool0DH`Xo`1AS005o`000?o_knOoU9JUooooooogmol0
0_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o056<o`1AS03oo`1AS2So056<00Go0000ono_
ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=U
Non]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l0DHco056<0?oo056<
:?l0DH`01Ol0003oknoWoiBFYOoooooomoOo00;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?
gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000
o`1AS?l0DH`0ool0DH`Xo`1AS005o`000?o_knOoU9JUooooooogmol00_o_koL2ono[k`04onOSkooN
gnOog]oWomKGi`?oc/oN00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk1?oNfmh00ol0003o056<o`1AS03oo`1AS2So056<00Go0000ono_ionDUZGoooooooOgo`02ono_
m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l0DHco056<0?oo056<:?l0DH`01Ol0003oknoWoiBF
YOoooooomoOo00;oknog0_o_jnl01?oWhnoog]oWomkOiooFenL3olk?gP05oooooonDUZGoHfEkojfZ
_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`1AS?l0DH`0ool0DH`Xo`1A
S005o`000?o_knOoU9JUooooooogmol00_o_koL2ono[k`04onOSkooNgnOog]oWomKGi`?oc/oN00Go
oooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o056<
o`1AS03oo`1AS2So056<00Go0000ono_ionDUZGoooooooOgo`02ono_m`;okn__00Coin?_omkOiooN
gnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKg_oo0000;?l000001?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW
0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKg_oo
0000;?l000001?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh0
1OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKg_oo0000;?l0
00001?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01Ooooooo
U9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So0000
06Ko0000`_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>
cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`00
0?l820So000006Ko0000`_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooN
gnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgP03o`000?l820So000006Ko0000`_oNfmh01?o_knOoU9JUooooooogmol2ono_m`;okn__00Co
in?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/4omkKgP03o`000?l820So000001_o000000?o8B0Qod95@_l@41003ol00002oc4`<@oo
00000_la<345o`0000;o<C0a1ol00002ob4P8AKo0000`_oNfmh01?o_knOoU9JUooooooogmol2ono_
m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So0000013o000000?oW9ZLoooooomcMG<01?l0
0002ooooo`03oa0@4?mcMG?ooooo00;ooooo00SoS8Z<o`000?l@413ooooookfj_Ol0003o_KZmoooo
o`;o000000Gog]oNooooool0003o410@olk?cP02ooooo`06omkOg_mBEE;o0000og=eLooooooo@TE2
0ol000001_l@413ooooooc4`<Ol0003o410@olk?cP;ooooo00Gog]oNoc4`<Ol0003o410@olk?cP02
ooooo`0:omkOg_la<37o0000oe9ED_oNgmko0000og=eLooooooog]oNoibJW1Go0000`_oNfmh01?o_
knOoU9JUooooooogmol2ono_m`;okn__00Coin?_omkOiooNgnOoe]OW0oo>cmh01OooooooU9JUof=U
Non]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So0000013o0000
00Co8B0Qono_koo_knoo410@0_l000001?la<37oooooomkOg_l00002ooooo`0Iof=UHon]ZZgooooo
of=UHol0003og]oNono_kol0003oW9ZLoooooom2AD;o0000okfj_Ooooooo8B0QoibJW?oooooo[JZ]
og=eLoo_knoooooood95@_mSIF?oooooog=eL`04o`00000Iono_komBEE;o0000oibJW?o>clko410@
o`000?mcMG?okno_ob4P8OnLVYcoc/o>oa0@4?l0003oLgEcono_kolQ827o<C0aooooool0003o@TE2
oc4`<Ol0003oc/o>of=UH`0Do`000<;og]_N00CoknoWoiBFYOoooooomoOo0_o_koL2ono[k`05onOS
kooNfnOog]_WomKGioo>dmh00_o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/4omkKgP03o`000?l820So0000017o000000?oLgEcooooooooool01?ooool07OnL
VYco0000ooooooo>clko0000ob4P8Ooooooo_KZmo`000?nm^[gooooooa0@4?mcMG?oooooof=UHol0
003oLgEcoooooom2AD;o_KZmoooooolQ827o0000oc4`<Ooooooo[JZ]od95@_ooooooW9ZL00Co0000
00Go_KZmog=eLol0003o_KZmog=eL`03o`0000;oW9ZL00?o_KZmog=eLol000000_l00002oibJW003
o`000?oooooo<C0a00;o000000?oHfESono_komSIF<05?l00032omkKgP04ono_ionDUZGoooooooOg
o`;oknog0_o_jnl01?oWhnoog]_WomkKiooFenL3olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmS
IG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l000004Ol000002ol@413okno_oooo
ooo>clko_KZmono_koooooooLgEco`000?o>clkooooo00;o00000_o_knl00ol0003oS8Z<ooooo`02
od95@P09oooooomcMG?o0000of=UHoooooooLgEcojfZ[Ooooooo8B0Q00;o00000_ooool00ol0003o
ooooolk?cP04o`000005ohb:S?nLVYco0000oibJW?n<RX`00ol000001?mcMG?o_KZmoibJW?n<RX`3
o`000009og=eLonm^[go0000olk?c_mBEE;o0000okfj_Oo_knooLgEc01Go0000`_oNfmh01?o_knOo
U9JUooooooogmol2ono_m`;okn__00Coin?_omkKiooNfnOoe]OW0oo>cmh01OooooooU9JUof=UNon]
Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000001;o000003oo
LgEcoooooomcMG?o0000okfj_Ooooooo@TE2o`000?n]ZZgooooooc4`<Ol0003o_KZmooooool0003o
W9ZLoooooon<RXco8B0QoooooooNgmko410@oe9ED_ooooooLgEcoe9ED_ooooooc/o>oa0@4?m2AD;o
ooooono_kol0003og]oNoooooomSIF?o0000oa0@4?l0003oLgEcokfj_Ol0003o<C0aoooooomSIF?o
0000oa0@4?o>clkoW9ZLoc4`<OooooooHfESo`000?l@413oc/o>oibJW?l0003o[JZ]og=eLol0003o
ooooob4P8Ol@41005Ol00032omkKgP03ono_ionDUZGoe]ON00cooooo00Goe]ONoiBFYOmSIG_o[JZm
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`00000Co`000005omkO
g_o_knoo0000ono_koooool00_l000002?mcMG?ooooood95@_l0003oW9ZLoooooom2AD;og]oN0_oo
ool01?nm^[goooooooooooo_knl2ooooo`03og=eLol0003oW9ZL00Cooooo00?oLgEco`000?nm^[d0
0oooool01?mSIF?o0000od95@_ooool2o`000008oe9ED_oNgmkog]oNooooooo>clko8B0Qo`000?mB
EE82omkOgP0;ooooooo>clko8B0Qo`000?mcMG?o[JZ]o`000?n<RXcog]oNono_kom2AD805?l00032
omkKgP03ono_ioooooooU9:L00co]KJm00GoU9:Lono_iomSIG_o[JZmooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`00000Co`000005of=UHoooooooLgEcooooooo>clh0
0_l000003_m2AD;oLgEcod95@_l0003o@TE2og=eLolQ827oHfESoooooooNgmkoHfESolk?c_oooooo
@TE20_mcMG<3o`000004od95@_mcMG?oLgEcod95@P;o000000WoDUEBog=eLom2AD;oLgEcod95@_l0
003o8B0QoooooolQ82400ol00002od95@PGo00000_m2AD83o`000004of=UHonm^[go0000o`0000;o
<C0a5Ol00032omkKgP03ono_ioo_koOoS8jL00coW9j]00GoS8ZLonOWkomSIG_o[JZmooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`00000Do`000004omkOg_oooooooooo
ohb:S0[o000000KoooooomkOg_l0003o[JZ]oooooola<34Bo`000003oooooom2AD;o000000ko0000
00?o@TE2ooooool000006?l00032omkKgP03ono_ionDUZGog]oW00cog]_W00Gog]oWoiBFYOmSIG_o
[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`00000Do`000004
od95@_ooooooooooof=UH`[o000000KoHfESog=eLol0003oLgEcoooooomBEE8@o`0000;o@TE200Co
c/o>ohb:S?m2AD;o<C0a3_l000000ooooooo8B0Qo`00000Eo`0000;o00@0`_oNfmh00oo_knOoU9JU
ooooo`0<olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Co
g]_N00?o0000o`P82?l000005Ol000000onm^[gooooooc4`<@0=o`000003oe9ED_ooooooLgEc013o
00001Onm^[d00on]ZZgo0000o`00000<o`000003omkOg_m2AD;o000001Ko000000?o61`HomkKg_oN
fmh0`?oNfmh00oo_knOoU9JUooooo`0<olk?gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004
of=UNooooooo[JZmof=UN`Cog]_N00?o61PHo`000?l000009Ol000000om2AD;ooooooibJW00To`00
0003okfj_OmcMG?o000001Ko000000?o61PHomkKg_oNfmh0`?oNfmh00oo_knOoU9JUooooo`0<olk?
gP05oooooonDUZGoHfEkojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o61PH
o`000?l00000C?l000000ola<37o8B0Qo`00000Fo`000003oaPH6?oNfmkog]_N0<3og]_N00?oknoW
oiBFYOooool03?o>cmh01OooooooU9JUof=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/4omkKgP03oeYIF_l0103o000006Co000000?o00@0oeYIF_oNfmh0`OoNfmh00oo_knOoU9JUoooo
o`02olk?gP03ocTl>Oo>cmkoc/oN00?oc/oN00Wo>C`iolk?g_o>cmkoc/oNoooooonDUZGoHfEkojfZ
_Oooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o[JZ]odY=B_l01000Hol000000ol0
103oBTe:ojfZ[@32omkKgP04ono_ionDUZGoooooolk?gP?o>C`i0oo>cmh3ocTl>@;oc/oN00Gooooo
oiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh01_oWhnOo[JZ]oeYI
F_lQ927o41@@oa0@40co000000?o410@o`000?l000001Ol0000Goa0@4003oa0D4?l0003o000001go
000000Co20P8oa0@4?l@413o410@3?l00002oa0@4006o`P82?l@513o8B@QoeYIF_n]ZZgoin?W`_oN
fmh00oo_knOoU9JUooooo`02omKCi`?o>C`i00Coe]?WocTl>Oli?3Wo>C`i0ooFdnL01OooooooU9JU
of=UNon]Z[gooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkKgS3og]_N00?oknoWoiBFYOoo
ool00ooNfnL5ocTl>@Cog]_W00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEkoooNfmh`omkKgP03ono_ionDUZGooooo00Coin?_0oli?3T5onOSk`05oooooonDUZGoHfEk
ojfZ_Oooool00OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh00oo_knOoU9JUooooo`05
ono_m`03ocTl>Oo_koOoknog00Coknog00GooooooiBFYOmSIG_o[JZmooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEkoooNfmh`omkKgP03ono_ionDUZGooooo00comoOg00GooooooiBFYOmSIG_o[JZm
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEkoooNfmh`omkKgP03ono_ionDUZGooooo00gooooo
00CoU9JUof=UNon]Z[gooooo0OmSIG/00004of=UNooooooo[JZmof=UNooog]_N<?oNfmh00oo_knOo
U9JUooooo`0=ooooo`04oiBFYOmSIG_o[JZmooooo`7oHfEk00001?mSIG_oooooojfZ_OmSIG_oomkK
gS3og]_N00?oknoWoiBFYOoFemh03?ooool01OoFemkoU9JUof=UNon]Z[gooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG_oob4T8C3o8B@Q00?oknoWomKKg_n<TY`02one][d01_ne/[goS8jLomKKg_mS
IG_o[JZmooooo`7oHfEk00000omSIG_omoOooibJY@3oog=eU4?oLgFD0OnLVZD1ooOgo`7oHfEk0000
0omSIG_omoOookfncP3ookfncTCo_Kk>0Oogmol1of=UN`0000?oHfEkooOgoooWhnL0oooWhnM4onOS
i`7omoOo0OmSIG/00003of=UNoogloOooooo00Gooooo3_n4PXCnooooo`03onOSionLY[goJgF<00;o
JgF<0_m[MI@5of]eS006oibV_OoWhnOooooooooooooWhnOoW:Jm0om[MH`2of]eU0GoJgF<00KoW:Jm
onOSioooooooooooono[konLY[d:ojDh@P03oibV_Oo_jnoooooo00?ooooo0OogloL1of=UN`0000Go
HfEkonOSiooooooooo_oooooo`02oooko`;oQ8:43?ooool00on4PXCoooooooooo`02ooooo`03oook
oooooooooo_o05Oooo_oX?ooool00onLY[goJgF<ohB:]@09ohB:]@06of]eS?nLY[gooooooooooonL
Y[goJgF<2_n4R[D01_m[MHcoW:JmoookooooooooW:JmojDh@P[o[CaB00OoYCQ2oibV_Ooooooooooo
oookooooooooin?W007oHfEk00000omSIG_oin?WooOgo`05ooOgo`0:ohB2Q?oooooooooooooooon]
_ZgoYJ:UolKOa_ooooooe]ooojG;m`?ooooo00?oQ8:4ooOgooogmol00oogmol5olK3eP;omoOo1?o6
`mH2ooOgo`04olK3e_ogmooomoOoooOgo`;oa/?F1?ogmol00oo6`mKomoOoooOgo`02ooOgo`03olK3
e_ogmooomoOo00?oa/?F1?ogmol2olK3eP;omoOo0oo6`mH2ooOgo`Coa/?F0oogmol3olK3eP?omoOo
0oo6`mH2ooOgo`05olK3e_ogmooomoOoooOgooo6`mH01Oogmol01?o6`mKomoOoooOgooo6`mH3ooOg
o`03olK3e_ogmooomoOo00Coa/?F0_ogmol3olK3eP;omoOo00Goa/?FooOgooogmooomoOoolK3eP2D
ooOgo`03of]eS?n4R[GoW9jm00WoW9jm00KoQ8Zeof]eS?ogmooomoOoof]eS?n4R[D:oibN_@07ohB:
]Om[MHcomoOoooOgoonU>4;o[CaBolIAFP08olIEFP03olIAF_n]?5;oYCQ200ComoOo0OoWhnL1of=U
N`0000?oHfEkomkOioogloL01OogloL03_n4PXCooooooookmoo6glKoYJ:UomJn[On]OJgoYJ:Uoe9M
[OmkOJgooooooookmoooooooQ8:41?ogloL5o`P@40;omo?g1?l841001?o6`mKomo?go`P@4?o6`mH2
ooOcm`;o210@1?ogloL00ol8413oa/?FooOcm`02ooOcm`03o`P@4?o6`mKomo?g00?o210@00Como?g
olK3e_ogloOomo?g0_l84102ooOcm`?o210@00?omo?golK3e_l841000ol841000oogloOoa/?FooOc
m`03o`P@4003ooOcmoo6`mKomo?g00?o210@00Como?golK3e_l8413oa/?F0_ogloL00ol8413omo?g
ooOcm`03ooOcm`05o`P@4?o6`mKomo?go`P@4?o6`mH00_ogloL00ol8413oa/?FooOcm`04o`P@4003
olK3e_ogloOo210@00;o210@00Oomo?golK3e_l8413omo?golK3e_ogloOo210@09Gomo?g00?oJgF<
okFfe_nUZ/H02OnUZ/H01_ne]]KoJgF<ooOcmoogloOoJgF<okFfePOooooo0onUZ/H01One]]KoJgF<
ooOcmoogloOoYCQ200;oaU5J00?ocUEJoliIF_o>FEX01?o>FEX01?o>EE[oaU5JolIAF_nU>484ooOc
m`7og]oW0OmSIG/00005of=UNooNfnOokn_gono[moo_koL00_o_jnl2ohB2Q00=oooooooFgoooQ8:4
ojeM[OoF_U;oeYiBojFRYOn]OE;oDUeBojem[OoF_ZgoooooohB2Q002ono[m`04ono[koo_joOo210@
olK3ePCokn_g00co210@olK3e_o_joOokn_go`P@4?o6`mKokn_go`P@4?o6`mKokn_go`P@4?o6`mH5
ono[m`04o`P@4?o6`mKokn_gono[m`;o210@00?oa/?Fo`P@4?o6`mH00_o_joL01Ol8413oa/?Fono[
mol8413oa/?F00;okn_g00So210@olK3e_o_joOokn_go`P@4?o_joOo210@olK3eP;okn_g00Co210@
olK3e_l8413oa/?F0_o_joL01?l8413oa/?Fo`P@4?o6`mH2ono[m`06o`P@4?o6`mKo210@olK3e_o_
joOo210@1_o_joL01Ol8413oa/?Fono[mol8413oa/?F00;okn_g00Co210@olK3e_l8413oa/?F0_o_
joL01?l8413oa/?Fo`P@4?o6`mH2ono_m`06o`P@4?o_koOoknogo`P@4?o_koOo210@Coo_koM7ono[
k`03of]eS?ne^]Ko[Jk600Kooooo0on][/H01one^]KoJgF<ono[koo_jnooJgF<okFje_ooool01_m[
KH`01OlQ937o[Jk6ojf^a_ne^]KoJgF<00;okn_g00?oYCQ2oliIF_o>EEX00_ooool3omIIFP;ooooo
0_o>EEX01?o>FE[oYCQ2ono[koo_joL2ono[k`7og]_W0OmSIG/00003of=UNooFfmkog]oW00Gog]oW
00OoQ8:4ojfn[OnUXZGo[IiBomJnD_oFgjgoe[j]00;oeYiB0_oFWZd2ooooo`03ohB2Q?oNgnOog]oW
00;og]oW00?o210@olK3e_oNgnL00ooNgnL03?l8413oa/?FomkOiooNgnOo210@olK3e_oNgnOo210@
olK3e_oNgnOo210@olK3ePGog]oW00Wo210@olK3e_oNgnOo210@olK3e_l8413oa/?Fo`P@4?o6`mH0
0_oNgnL01Ol8413oa/?FomkOiol8413oa/?F00;og]oW00?o210@olK3e_o6`mH00oo6`mH02?l8413o
a/?FomkOiooNgnOo210@olK3e_l8413oa/?F0_oNgnL01?l8413oa/?Fo`P@4?o6`mH2omkOi`05o`P@
4?o6`mKo210@olK3e_l841001ooNgnL01Ol8413oa/?FomkOiol8413oa/?F00;og]oW00Co210@olK3
e_l8413oa/?F0_oNgnL00ol8413oa/?Fo`P@4005olK3eP;og]oW00?o210@olK3e_oNgnL0UOoNgnL0
1?m[MHco_L?Fokfjc_ooool4of]]S006ob4T<Onm^/ko_K[>okfjc_nm`mKoJgF<0_oNgnL01?m[MHco
_L?Foooooom[KH`4okfjcP06oooooolQ937o_K[>okfjc_nm`mKoJgF<0_oNgnL00onU>4;ocUUJomII
FP03ooooo`08omIMHooooooooooooooooooFGF?oeUUJoliIF_nU>484omkOi`7oe]_N0OmSIG/00003
of=UNooFemkoe]_W00?oe]_W00Coe]OWomKKion4PXCoYJ:U0_mkWZd01ooF_U;oommBohB2Q?n]O@3o
eWf]omIM[OoFWZd00_ooool01_n4PXCoe]_WomKKiooFenOoe]_Wo`P@40Coa/?F00?oe]OWo`P@4?o6
`mH00_oFenL02?l8413oa/?FomKGiol8413oa/?FomKGiol8413oa/?F1OoFenL02Ol8413oa/?FomKG
iol8413oe]OWo`P@4?o6`mKo210@olK3eP02omKGi`05o`P@4?o6`mKoe]OWo`P@4?o6`mH00_oFenL5
o`P@4003olK3e_l8413oa/?F00;oe]OW00Co210@olK3e_l8413oa/?F0_oFenL01?l8413oa/?Fo`P@
4?o6`mH2omKGi`06o`P@4?o6`mKo210@o`P@4?oFenOoa/?F1_oFenL01Ol8413oa/?FomKGiol8413o
a/?F00;oe]OW00Co210@olK3e_l8413oa/?F0_oFenL00ol8413oa/?Fo`P@4004o`P@4006olK3e_oF
fnOoe]_Wo`P@4?oFfnOoa/?FUOoFfnL00om[MHcoc/oNolk;gP06ob4T<@?oc/_N00Soc/oNof]eS?oF
fnOoe]_Wof]eS?o>cmkoooooof]]S0Coc/_N00Koooooob4T<Oo>bmkoc/_Nolk?g_m[MH`2omKKi`04
ojDh@_oFGE[ogVESod8L60Gooooo00Go@Q`HonMUHooNIF?oeUeJojDh@P02omKKi`03omKGiooFfnOo
e]ON007oHfEk00000omSIG_oe]ONolkCgP04omKCgP;oQ8:400Oooo_gog^N[OmBWZgoeYiBomIm0?n]
G@3o[GeB00;oeQaB00CoeSaBomJN[OooooooQ8:40ooFdmh00oo>dmko210@o`P@4002o`P@40;oe]?N
00_o210@omKCg_o6`mKoa/?Fo`P@4?o6`mKoe]?No`P@4?o6`mKoe]?No`P@4003olK3eP?oe]?N00Wo
210@olK3e_l8413oa/?FomKCg_l8413oa/?Fo`P@4?oFdmh00_o6`mH01?l8413oe]?NomKCg_l84103
olK3eP07o`P@4?oFdmkoa/?FolK3e_l8413oe]?No`P@4003olK3eP04o`P@4?oFdmko210@omKCgP;o
a/?F00Co210@omKCg_l8413oe]?N0_o6`mH01ol8413oe]?No`P@4?o6`mKo210@omKCg_o6`mH01OoF
dmh01?l8413oa/?FomKCg_l84103olK3eP04o`P@4?oFdmko210@omKCgP;oa/?F00Co210@olK3e_l8
413oc]?N0_o6`mH02?l8413oc]?NolkCg_l8413oc]?No`P@4?o>dmkoa/?FCOo>dmi7omKCgP03of]e
S?oFdnOoc]?N00Woc]?N00Soe]?Wof]eS?oFdmkoe]?Nof]eS?oFdnOoooooof]]S0Coc]?N00gooooo
ob4T<Oo>dmkoc]?NomKCiom[MHcoe]?NolkCg_nU>4;ogVESonMYHooWKF_o@Q`H00?ooooo00Ko@Q`H
onM]JooWKF_oifUSomiUHonU>483omKCgP7oc]?N0OoFemh1of=UN`0000?oHfEkomKCg_o>cmh01Oo>
cmh03_n4PXCooo_gojFRYOmBWZgoeWeBohB2Q?mBOJgoDUf]ojeMD_oFGE;o[Gf]omJn[OooooooQ8:4
1?o>cmh00ol8413oa/?Folk?gP04olk?gPCo210@00Coa/?Fo`P@4?l8413oc/oN1?l84104olk?gP03
o`P@4?o6`mKo210@00;oc/oN00?o210@olK3e_o>cmh00ol84102olk?gPCo210@0_o>cmh3o`P@40;o
c/oN1?l84103olk?gP?o210@0oo>cmh3o`P@40;oc/oN00Co210@olK3e_o>cmko210@1_o>cmh00ol8
413oa/?Folk?gP04o`P@40?oc/oN1?l841000oo6`mKoc/oNo`P@4002o`P@40;oc/oN00Go210@olk?
g_o>cmkoc/oNo`P@402Eolk?gP03of]eS?oFenOog]_W00Wog]_W00Soe]OWof]eS?o>cmkoc/oNof]e
S?oFenOoooooof]]S0Gooooo00Go8B@aomkKiooNfnOoe]OWof]eS002olk?gP04ojDh@_oWKF_oigE[
onMaJ`Gooooo00GoigE[onMaJooWMF_oife[ojDh@P04olk?gP7oe]?N0OmSIG/00003of=UNoo>cmko
a/_F00Coa/_F00Coa/OFohB2Q?o6glKoNij]0_n4PX@01_mkW_ooDUf]obTl[OlYGJgoNcaBoookm`;o
oooo00?oQ8:4olK;e_o6amH00_o6amH00ol8413oa/?FolK3eP03olK3ePCoa/OF00So210@olK3e_o6
amKoa/OFolK3e_o6amKo210@olK3ePGoa/OF0_l84103olK7eP03o`P@4?o6`mKoa/OF00Koa/OF00?o
210@olK3e_o6amH01oo6amH00ol8413oa/?FolK7eP0?olK7eP03o`P@4?o6`mKoa/OF00Ooa/OF00?o
210@olK3e_o6amH02_o6amH00ol8413oa/?FolK;eP1HolK;eTOoa/OF00?oJgF<omKGiooWgnl02OoW
gnl01ooFenOoJgF<olK7e_o6amKoJgF<omKGioooool01_m[KH`01OlQ937oimo_onOOkooFenOoJgF<
00;oa/_F00?oYCQ2onmiLoo_OG/00oooool02?m271Soooooooooooooooookh9konmmNoo_NG?oYCQ2
0oo6bmH1olK7eP7oc/oN0OmSIG/00003of=UNoo>cmkoa/OF00Coa/OF0_n4PX@2oookm`03ojfn[Omk
WZgoNij]00;oDWf]00?oYJ:Uog]m[OoF_Zd00_ooool00on4PXCoa/OFolK7eP02olK7ePGo210@1Oo6
amH01?l8413oa/OFolK7e_l84102olK7eP03o`P@4?o6amKoa/OF00Coa/OF00?o210@olK7e_o6amH0
0_o6amH00ol8413oa/OFolK7eP06olK7eP03o`P@4?o6amKoa/OF00Ooa/OF00?o210@olK7e_o6amH0
3oo6amH00ol8413oa/OFolK7eP07olK7eP03o`P@4?o6amKoa/OF00[oa/OF00?o210@olK7e_o6amH0
Woo6amH00om[MHcokn_gono[m`0:ono[m`04of]eS?o6amKoa/OFof]eS0;okn_g1olQ9343ono[m`06
of]eS?o6amKoa/OFojDh@_ogPW?omhIk0_ooool00om271Somk:Lod8L6002ooooo`04ooN>Q?ogQW_o
mh9cojDh@PCoa/OF0Oo>cmh1of=UN`0000?oHfEkolk?g_nm`lh01Onm`lh02On4PXCooooooookmon]
_Zgoa]o6omKOoonUXZGoNgf]oookm`04ooooo`03ohB2Q?nm`lko_L?>0?co_L?>00?oJgF<omKCioog
loL02OogloL01_oFdnOoJgF<okg3c_nm`lkoJgF<omKCi`[omo?g00Ooe]?Wof]eS?nm`lko_L?>ojDh
@_ogRW_omi:400;o@Q`H0oog^Y`2od8L60;omi:400?omhYkojDh@_nm`lh00onm`lh1olk?gP7oHfEk
00000omSIG_oc/_NokFjcP05okfncP03ohB2Q?oooooooooo00?ooooo00?oa]o6ojfN[OoonoL01?oo
ool00on4PXCo_Kk>okfjcP3lokfncP04ohB>YOm[MHcoc/_Noooko`Kooooo00Cooo_oolk;g_m[MHco
Q8jU0_nm_/h01?n4SZGoJgF<olk;g_oonol6ooooo`04oookooo>bmkoJgF<ohB>Y@;o_Kk>00GoU9Z]
ojDh@_ooWXcookjUoooO]@04ooo[]@0:oooO]Ooo_ZGooij<ojDh@_nDVZgo_Kk>okfjc_nm_/ko]K[>
olk;gP7oHfEk00000omSIG_oa/_FokffcP04ojf^aP;oQ8:43?ooool00on4PXCo[Jk6ojf^aP3mojf^
aP03ohB>YOm[MHcoJgF<00SoJgF<00?oQ8jUojf^a_n][/H00_n][/H00on4SZGoJgF<of]eS008of]e
S003ohB>YOn][/Ko[Jk600;o[Jk600?oQ8jUojDh@_nU>4802?nU>4800on4SZGo[Jk6ojf^aP02ojf^
aP7o_KK>0Oo6bmH1of=UN`0000?oHfEkolK3e_o6amH01On]Z/H>ohB2Q?oo[J[6<?n]Z/H1olK7eP7o
a/?F0OmSIG/00006ookno_n]Y[goinO_omKCionm_/ko]K;6oon]Y[dmojfV_@05okFba_nm_/koe]?W
onOWkon]Y[d00Oono_h00007ookno_n4QYcoe]_WoooooooWhnooe]?Wolk;gP3ookfncS_o_Kk>00Ko
c/_NomKCiooWhnooooooomKKion4QY`1ooknoP000_ono_h01_nDUZgoe]_WooooooogloOokn__onOS
koooe]_W>OoFfnL01_oWhnookn__ooOcmoooooooe]_WoiBF[@;oo_kn0003ooknoP;oHfEk00?oS8JL
oiBF[On]Y[d0oon]Y[djojfV_@04oiBF[On<QYcoHfEkof=UN`?oo_kn0005ookno_ooHfEk?omSIG/5
ooknoP00\
\>"], "ListGraphic",
 Evaluatable->False,
 ImageSize->{328, 427},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Setting up an Index", "i:89"}]
}, Open  ]],

Cell["This dialog box contains three text boxes:", "Text",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 StyleBox["Index Main Entry", "TB",
  FontWeight->"Plain"],
 "\[LongDash]specifies a term in the index."
}], "IndentedText",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 StyleBox["Index Sub-Entry", "TB",
  FontWeight->"Plain"],
 "\[LongDash]distinguishes two cells that fall under the same main entry."
}], "IndentedText",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 StyleBox["Short Form", "TB",
  FontWeight->"Plain"],
 "\[LongDash]defines a short word or phrase to represent the entry in the \
Master Index of the Help Browser."
}], "IndentedText",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[StyleBox["To associate an index entry with a cell (or group of \
cells):", "TB"]], "Text",
 CellTags->{"Setting up an Index", "i:89"}],

Cell["Select the cell(s).", "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Setting up an Index", "i:89"}],

Cell["\<\
Specify the entry by typing it into the text fields of the dialog box. The \
main entry and sub-entry can be either a string or a two-dimensional \
expression, but the short form must be a string.\
\>", "ItemizedList",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 "Click ",
 StyleBox["Tag Current Cell", "SR"],
 " to assign the entry to the selected cell(s)."
}], "ItemizedList",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 "Any index entries associated with a cell are displayed in the box at the \
bottom of the dialog box if you select that cell. After you add a new entry, \
you can click ",
 StyleBox["Refresh", "SR"],
 " to check that the entry you specified has been assigned."
}], "Text",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " Alternatively, you can select all or part of a cell\[CloseCurlyQuote]s \
contents and click the ",
 StyleBox["Index Cell on Selection", "SR"],
 " button. This makes the index entry for the cell the same as the selected \
text."
}], "Text",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[StyleBox["To edit or remove an index entry:", "TB"]], "Text",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 "Select the cell. A list of the currently assigned entries associated with \
that cell is displayed at the bottom of the ",
 "dialog box",
 ". Each entry also has hyperlinks marked ",
 StyleBox["Edit", "SR"],
 " and ",
 StyleBox["Remove", "SR"],
 " next to it."
}], "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 "Click ",
 StyleBox["Edit", "SR"],
 " to edit the entry or ",
 StyleBox["Remove", "SR"],
 " to remove it."
}], "ItemizedList",
 CellTags->{"Setting up an Index", "i:89"}],

Cell["\<\
Edit the entries displayed in the text fields of the dialog box.\
\>", "ItemizedList",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 "Click ",
 StyleBox["Tag Current Cell", "SR"],
 ". This replaces the entry that you edited with the new entry."
}], "ItemizedList",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[StyleBox["To generate an index:", "TB"]], "Text",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 "For a single notebook, open the notebook and make it the currently selected \
notebook. For multiple notebooks, open the MakeProject ",
 "dialog box",
 " and load the project file for your project. (If you have not already \
created a project file, see ",
 ButtonBox["Creating a Project File",
  ButtonData:>"Creating a Project File",
  ButtonStyle->"AddOnsLinkText"],
 " to learn how.)"
}], "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Setting up an Index", "i:89"}],

Cell["Open the MakeIndex palette.", "ItemizedList",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 "Click ",
 StyleBox["Edit Notebook Index...", "SR"],
 ". This brings up a ",
 "dialog box",
 "."
}], "ItemizedList",
 CellTags->{"Setting up an Index", "i:89"}],

Cell["\<\
Use this dialog box to associate index entries with all cells in the notebook \
that are to be referenced in the index.\
\>", "ItemizedList",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 "Click ",
 StyleBox["Paginate", "SR"],
 " to assign page numbers to the source notebook(s). You can skip this step \
if you have paginated the notebooks previously or if you are creating a \
simple index, which does not contain any page numbers."
}], "ItemizedList",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 "Click the button corresponding to the type of index you want to create. For \
example, to build a simple index click ",
 StyleBox["Make", "SR"],
 " ",
 StyleBox["Simple Index", "SR"],
 ". The other formats available are book index, two column index and browser \
index. See ",
 ButtonBox["Make Index",
  ButtonData:>"Make Index: Introduction",
  ButtonStyle->"AddOnsLinkText"],
 " to learn about the differences among these four types of indexes."
}], "ItemizedList",
 CellTags->{"Setting up an Index", "i:89"}],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 StyleBox[" Mathematica",
  FontSlant->"Italic"],
 " automatically creates an index based on all the index entries that you \
defined. The index is saved as a separate notebook in the same directory as \
the source notebook."
}], "Text",
 CellTags->{"Setting up an Index", "i:89"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Browser Index", "Subsubsection",
 CellTags->{"Types of Index", "Note on Browser Index", "i:90"}],

Cell[TextData[{
 "When you click an entry in a ",
 "browser index",
 ", the target cells are displayed in the Help Browser. For the index entries \
to work properly, an appropriate browser categories file must be present in \
the same directory as the source notebooks. (For details of how browser \
categories files work, see ",
 ButtonBox["Creating a Browser Categories File",
  ButtonData:>"Creating a Browser Categories File",
  ButtonStyle->"AddOnsLinkText"],
 ".)"
}], "Text",
 CellTags->{"Note on Browser Index", "i:90"}],

Cell["\<\
If you associate an index entry with a cell that cannot be displayed in the \
Help Browser, the index entry will bear the label \
\[OpenCurlyDoubleQuote]match not found\[CloseCurlyDoubleQuote] to indicate \
that the entry does not have a well-defined target.\
\>", "Text",
 CellTags->{"Note on Browser Index", "i:90"}],

Cell["\<\
For a cell to be displayed in the Help Browser, the browser categories file \
must contain an item corresponding to that cell. If no such item is present, \
the cells are not the target of a terminal category in the columns of the \
Help Browser and so the index entry cannot link to those cells.\
\>", "Text",
 CellTags->{"Note on Browser Index", "i:90"}],

Cell[TextData[{
 "This can happen if the source notebook is not in strict ",
 ButtonBox["outline format",
  ButtonData:>"Outline Format",
  ButtonStyle->"AddOnsLinkText"],
 " and the target cells fall outside the outline. Even if the source notebook \
is in outline format but the target cell is a heading cell that does not \
correspond to an item in the ",
 "browser categories",
 " file, the index entry will not work."
}], "Text",
 CellTags->{"Note on Browser Index", "i:90"}],

Cell[TextData[StyleBox["To fix an index entry that does not have a match:", \
"TB"]], "Text",
 CellTags->{"Note on Browser Index", "i:90"}],

Cell[TextData[{
 "Edit the browser categories file by hand to insert an item corresponding to \
the target cells for the index entry. (For details of how ",
 "browser categories",
 " files work, see ",
 ButtonBox["Creating a Browser Categories File",
  ButtonData:>"Creating a Browser Categories File",
  ButtonStyle->"AddOnsLinkText"],
 ".)"
}], "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Note on Browser Index", "i:90"}],

Cell["Use the MakeIndex palette to regenerate the browser index.", \
"ItemizedList",
 CellTags->{"Note on Browser Index", "i:90"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeContents", "Subsection"],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
 CellTags->{"MakeContentsIntro", "i:81"}],

Cell["\<\
The MakeContents palette enables you to generate a table of contents for any \
notebook or group of notebooks.\
\>", "Text",
 CellTags->{"MakeContentsIntro", "i:81"}],

Cell[CellGroupData[{

Cell[BoxData[
 ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "OpenCloseItemizedPicture",
   FormatType->StandardForm,
   ImageSize->{54, 13},
   ImageMargins->{{0, 0}, {0, 0}},
   ImageRegion->{{0, 1}, {0, 1}}],
  Active->True,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& )]], "OpenCloseItemizedPicture",
 CellTags->{"i:81", "MakeContentsIntro"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002^000172000`400?l00000o`00003o[_mSIG/0
0003of=UNooooooooooo0:[ooooo0OmSIG/00003of=UNooooooo[JZm0:Wo[JZm0Oooool1of=UN`00
00?oHfEkoooooon]Z[d0Z?mSIG/1ojfZ_@7ooooo0OmSIG/00004of=UNooooooo[JZmof=UNjKog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UNjKog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmiWohbjeP?ooooo=_n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgVWoS;[F0_ooooleohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_N5_n<^]H5ooooo`?oS;[F1?ooool2ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F
1?ooool3ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F0_ooool00on<^]Koooooooooo`03ohbjePCooooo
0on<^]H4ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjePGooooo0on<^]H2ooooo`;oS;[F
0oooool2ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F1?ooool3ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F
0_oooolFohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
5On<^]H2ooooo`?oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00CoS;[Foooooooooooo
S;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;o
S;[F0_ooool2ohbjeP;ooooo00CoS;[FooooooooooooS;[F0oooool2ohbjeP;ooooo0_n<^]H2oooo
o`03ohbje_oooooooooo00;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`03ohbje_oooooo
oooo00?oS;[F0_ooool00on<^]Koooooooooo`03ohbjeP?ooooo0_n<^]H2ooooo`03ohbje_oooooo
oooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool2
ohbjeP;ooooo5_n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2
omkKgQ[oS;[F0_ooool00on<^]Koooooooooo`05ohbjeP;ooooo00?oS;[Fooooooooool01On<^]H2
ooooo`GoS;[F0_ooool2ohbjeP;ooooo1On<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`06
ohbjeP;ooooo1On<^]H2ooooo`03ohbje_oooooooooo00KoS;[F0_ooool00on<^]Koooooooooo`02
ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool00on<^]Koooooooooo`08ohbjeP?ooooo8_n<
^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQSoS;[F1?oo
ool00on<^]Koooooooooo`04ooooo`04ohbje_ooooooooooohbjePKooooo00?oS;[Fooooooooool0
1On<^]H2ooooo`;oS;[F1_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool0
1_n<^]H6ooooo`04ohbje_ooooooooooohbjeP;ooooo1?n<^]H4ooooo`03ohbje_oooooooooo00;o
S;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`03ohbje_oooooooooo00Cooooo0_n<^]H4oooo
ob?oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhFohbj
ePGooooo0_n<^]H2ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool0
0on<^]Koooooooooo`05ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02
ohbjeP;ooooo00?oS;[Fooooooooool01_n<^]H2ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<
^]H2ooooo`;oS;[F1Oooool2ohbjeP;ooooo0_n<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo
00?oS;[Fooooooooool00_n<^]H2ooooo`04ohbje_ooooooooooooooobGoS;[F1?oNfmh00omSIG_o
ooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhEohbjePCooooo1?n<^]H2ooooo`;o
S;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbj
eP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H3
ooooo`03ohbje_oooooooooo00KoS;[F0_ooool2ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_oo
ool00on<^]Koooooooooo`02ooooo`CoS;[F0_ooool00on<^]Koooooooooo`03ohbjePCooooo00?o
S;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_oooolRohbjePCog]_N00?o
HfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N5On<^]H2ooooo`OoS;[F1?oo
ool2ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F1?ooool00on<^]Koooooooooo`02ooooo`;oS;[F1?oo
ool3ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool7ohbjePCooooo0_n<^]H2ooooo`04ohbj
e_ooooooooooohbjeP;ooooo1On<^]H6ooooo`?oS;[F1?ooool2ohbjePCooooo0on<^]H4ooooob?o
S;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhEohbjeP;o
oooo0on<^]H2ooooo`SoS;[F0_ooool?ohbjeP;ooooo3On<^]H2ooooo`;oS;[F0_ooool2ohbjeP;o
oooo2?n<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo0on<^]H2ooooo`03ohbje_oooooooooo
00SoS;[F0_ooool`ohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_N5_n<^]H5ooooo`WoS;[F0_ooool@ohbjeP03oooooon<^]KoS;[F00_oS;[F0_ooool3ohbj
ePCooooo2On<^]H2ooooo`03ohbje_oooooooooo00;oS;[F1Oooool3ohbjeP03oooooon<^]KoS;[F
00KoS;[F0_ooool`ohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPohbj
ePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?n<^]H4omkK
gP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oS;[F1?oNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_N6?n<^]H4ooooo`?oS;[F1?ooool2ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool2ohbj
ePCooooo0_n<^]H2ooooo`;oS;[F0_ooool2ohbjeP;ooooo0_n<^]H4ooooo`;oS;[F0_ooool4ohbj
eP;ooooo00?oS;[Fooooooooool00_n<^]H4ooooo`;oS;[F0_ooool3ohbjeP;ooooo0_n<^]H5oooo
o`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F0_ooool2ohbj
eP;ooooo0_n<^]H2oooooaSoS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmhGohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<
^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F0_ooool00on<
^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F0_ooool00on<
^]Koooooooooo`04ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool2ohbjeP;ooooo00?oS;[F
ooooooooool00_n<^]H3ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02
ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo0_n<^]H2
ooooo`;oS;[F0_oooolHohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`;og]_N5_n<^]H2ooooo`KoS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2
ooooo`03ohbje_oooooooooo00;oS;[F0_ooool5ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooo
oooo00GoS;[F0oooool00on<^]Koooooooooo`04ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_oo
ool5ohbjeP;ooooo0_n<^]H3ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Kooooooooo
o`02ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo02SoS;[F1?oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhFohbjeP;ooooo1_n<^]H2ooooo`;oS;[F0_oo
ool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H6ooooo`03ohbje_oo
oooooooo00;oS;[F0_ooool00on<^]Koooooooooo`03ohbjePCooooo0_n<^]H2ooooo`CoS;[F0_oo
ool01?n<^]Kooooooooooon<^]H6ooooo`04ohbje_ooooooooooohbjePCooooo0_n<^]H2ooooo`04
ohbje_ooooooooooohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`04oooo
obCoS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhFohbj
eP;ooooo1_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Foooo
ooooool00_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Foooo
ooooool00_n<^]H3ooooo`CoS;[F1Oooool01?n<^]Kooooooooooon<^]H2ooooo`03ohbje_oooooo
oooo00;oS;[F0_ooool01_n<^]Kooooooooooon<^]KoooooohbjeP;ooooo0on<^]H4ooooo`03ohbj
e_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooobCoS;[F
1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhFohbjeP;ooooo
1_n<^]H2ooooo`;oS;[F0_ooool01On<^]KoooooooooooooooooS;[F00;ooooo00?oS;[Foooooooo
ool00_n<^]H2ooooo`;oS;[F0_ooool01On<^]KoooooooooooooooooS;[F00;ooooo00?oS;[Foooo
ooooool00_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`04ohbjeP;ooooo00CoS;[Foooo
ooooooooS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_ooool01On<^]Kooooooooooon<
^]Kooooo00?oS;[F0_ooool01On<^]KoooooooooooooooooS;[F00?ooooo00CoS;[Foooooooooooo
S;[F0_ooool2ohbjeP;ooooo9?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgQKoS;[F0_ooool7ohbjePCooooo0_n<^]H2ooooo`04ohbje_ooooooooooohbj
ePCooooo0_n<^]H4ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H4ooooo`;oS;[F1?ooool2
ohbjeP;ooooo1?n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F1?ooool2ohbjeP?ooooo0_n<^]H2
ooooo`;oS;[F1?ooool2ohbjeP;ooooo00GoS;[FooooooooooooooooohbjeP02ooooo`?oS;[F1?oo
oolUohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N5on<
^]H2ooooo`;oS;[F0_ooool?ohbjeP;ooooo4?n<^]H2ooooo`WoS;[F0_ooool7ohbjeP;ooooo2?n<
^]H3ooooo`;oS;[F0_oooolmohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_N6?n<^]H4oooooa7oS;[F00?oooooohbje_n<^]H03on<^]H00oooooooS;[Fohbj
eP07ohbjePGooooo00CoS;[FooooooooooooS;[F0_ooool8ohbjeP;ooooo0on<^]H2ooooocgoS;[F
1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oS;[F1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
B?n<^]H4oooooeCoS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmi7ohbjeP04oooooon<^]KoS;[FohbjeP;oooooDon<^]H4omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgRKoS;[F1?ooool3ohbjePCooooo0_n<^]H2ooooo`03
ohbje_oooooooooo00?oS;[F0_ooool4ohbjePGooooo0_n<^]H2ooooo`04ohbje_ooooooooooohbj
eP;ooooo1_n<^]H2ooooo`CoS;[F1?ooool2ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo
00;oS;[F0_ooool2ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_oooolUohbjePCog]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N9On<^]H2ooooo`;oS;[F0_ooool00on<
^]Koooooooooo`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool3ohbjeP;ooooo0on<^]H2
ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H3ooooo`03ohbje_oooooooooo00KoS;[F0_oo
ool3ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Kooooooooo
o`02ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool2ohbjeP;ooooo9On<^]H4omkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgRCoS;[F0_ooool6ohbjeP;ooooo1On<
^]H2ooooo`03ohbje_oooooooooo00?oS;[F0_ooool3ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oo
oooooooo00;oS;[F0_ooool00on<^]Koooooooooo`06ohbjeP;ooooo0on<^]H2ooooo`GoS;[F0_oo
ool2ohbjeP;ooooo0_n<^]H4oooooc;oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmhTohbjeP;ooooo1_n<^]H6ooooo`04ohbje_ooooooooooohbjeP;ooooo
0on<^]H2ooooo`CoS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool00on<^]Ko
ooooooooo`04ooooo`;oS;[F0_ooool3ohbjePKooooo00?oS;[Fooooooooool00_n<^]H2ooooo`?o
S;[F0_oooolcohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_N9?n<^]H2ooooo`KoS;[F0_ooool2ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool3ohbj
eP;ooooo1On<^]H4ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`03ohbj
eP;ooooo00?oS;[Fooooooooool00on<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbj
eP;ooooo0_n<^]H4oooooc;oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmhTohbjeP;ooooo1_n<^]H2ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2
ooooo`?oS;[F0_ooool3ohbjeP04oooooon<^]KoS;[FohbjeP;ooooo00CoS;[FooooooooooooS;[F
0oooool00on<^]Koooooooooo`03ohbjeP;ooooo00?oS;[Fooooooooool00on<^]H2ooooo`;oS;[F
0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2oooooc7oS;[F
1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhTohbjeP;ooooo
1on<^]H4ooooo`;oS;[F0_ooool00on<^]Koooooooooo`03ohbjeP;ooooo1?n<^]H4ooooo`?oS;[F
0_ooool01?n<^]Kooooooooooon<^]H2ooooo`?oS;[F0_ooool00on<^]Koooooooooo`02ooooo`;o
S;[F1?ooool00on<^]Koooooooooo`02ooooo`04ohbje_ooooooooooohbjeP;ooooo0_n<^]H2oooo
oc7oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhUohbj
eP;ooooo0_n<^]H2ooooo`SoS;[F0_ooool00on<^]Koooooooooo`03ohbjeP;ooooo4On<^]H2oooo
o`?oS;[F0_ooool=ohbjeP;ooooo??n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgRKoS;[F1?ooool9ohbjeP;ooooo00CoS;[FooooooooooooS;[F1_ooool?
ohbjePKooooo3on<^]H5ooooocSoS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2
omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjP
ohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?n<^]H4
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oS;[F1?oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_NK?n<^]H4oooooc3oS;[F1?oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmi[ohbjeP04oooooon<^]KoS;[FohbjeP;ooooo;on<
^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgRSoS;[F1?oo
ool2ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F1Oooool00on<^]Koooooooooo`07ohbjePCooooo0on<
^]H4ooooo`;oS;[F0_ooool00on<^]Koooooooooo`05ohbjeP;ooooo1?n<^]H5ooooo`;oS;[F0_oo
ool00on<^]Koooooooooo`02ohbjePCooooo:On<^]H4omkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgROoS;[F0_ooool2ohbjeP;ooooo00CoS;[FooooooooooooS;[F
0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00KoS;[F
0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`04ohbje_ooooooooooohbjeP;o
oooo1On<^]H2ooooo`?oS;[F0_ooool2ohbjeP;ooooo00CoS;[FooooooooooooS;[F0oooool00on<
^]Koooooooooo`02ohbjeP;ooooo:?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgRKoS;[F0_ooool6ohbjeP;ooooo00?oS;[Fooooooooool01On<^]H2oooo
o`;oS;[F0_ooool00on<^]Koooooooooo`05ohbjeP;ooooo1_n<^]H2ooooo`GoS;[F0_ooool00on<
^]Koooooooooo`05ohbjeP;ooooo0on<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbj
eP;ooooo1?n<^]H3ooooobSoS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmhVohbjeP;ooooo1_n<^]H2ooooo`03ohbje_oooooooooo00Cooooo0_n<^]H2oooo
o`04ohbje_ooooooooooohbjeP;ooooo1On<^]H2ooooo`KoS;[F1_ooool01?n<^]Kooooooooooon<
^]H2ooooo`GoS;[F0_ooool4ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool2ohbjeP;ooooo
0_n<^]H4ooooobWoS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmhVohbjeP;ooooo1_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool3ohbjePCooooo
00?oS;[Fooooooooool01On<^]H2ooooo`KoS;[F0_ooool2ohbjeP;ooooo00CoS;[Foooooooooooo
S;[F0_ooool5ohbjeP;ooooo1On<^]H4ooooo`03ohbje_oooooooooo00;oS;[F0_ooool01?n<^]Ko
ooooooooooooool[ohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_N9_n<^]H2ooooo`KoS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Foooo
oon<^]H00_n<^]H2ooooo`03ohbje_oooooooooo00GoS;[F0_ooool6ohbjeP;ooooo0_n<^]H2oooo
o`04ohbje_ooooooooooohbjeP;ooooo1On<^]H2ooooo`?oS;[F00Coooooohbje_n<^]KoS;[F0_oo
ool01?n<^]Kooooooooooon<^]H3ooooo`03ohbje_oooooooooo00;oS;[F0_oooolXohbjePCog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N9_n<^]H2ooooo`KoS;[F
0_ooool2ohbjePCooooo0on<^]H4ooooo`;oS;[F1?ooool3ohbjeP;ooooo1on<^]H4ooooo`;oS;[F
0_ooool00on<^]Koooooooooo`05ohbjeP;ooooo1?n<^]H4ooooo`?oS;[F0_ooool00on<^]Kooooo
ooooo`02ohbjePCooooo:On<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgROoS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool05on<^]H2ooooo`;oS;[F
0_ooool8ohbjeP;ooooo00?oS;[Fooooooooool01On<^]H2ooooocooS;[F1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhXohbjePCooooo0_n<^]H2oooooaSoS;[F
1?ooool9ohbjeP;ooooo00?oS;[Fooooooooool00on<^]H6ooooocgoS;[F1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
X?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oS;[F
1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPohbjePCog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NAon<^]H4oooooeGoS;[F
1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmi6ohbjeP04oooo
oon<^]KoS;[FohbjeP;oooooE?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgSOoS;[F0_ooool7ohbjePGooooo0_n<^]H2ooooo`04ohbje_ooooooooooohbj
eP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F1Oooool2ohbjeP;ooooo0_n<^]H4oooo
ocWoS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhgohbj
eP;ooooo1_n<^]H2ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H3ooooo`04ohbje_oooooo
ooooohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Kooooooooo
o`02ohbjeP;ooooo0_n<^]H2ooooocSoS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmhgohbjeP;ooooo1_n<^]H2ooooo`;oS;[F0_ooool00on<^]Kooooooooo
o`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool0
0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_oooollohbjePCog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N=on<^]H6ooooo`?oS;[F0_ooool01?n<^]Kooooo
oooooon<^]H2ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool2ohbj
eP;ooooo00CoS;[FooooooooooooS;[F0_ooool2ohbjePKooooo>?n<^]H4omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgSOoS;[F0_ooool3ohbjeP;ooooo0on<^]H4
ooooo`03ohbje_oooooooooo00;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_oo
ool3ohbjePCooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F0_oooolhohbjePCog]_N00?o
HfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N=on<^]H2ooooo`?oS;[F0_oo
ool00on<^]KoooooohbjeP02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0oooool01?n<^]Kooooo
oooooon<^]H3ooooo`05ohbje_ooooooooooohbje_ooool00on<^]H2ooooo`03ohbje_oooooooooo
00;oS;[F0_ooool2ohbjeP;ooooo>?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgSOoS;[F0_ooool3ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F0_ooool01?n<
^]Kooooooooooon<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo0on<^]H4ooooo`03ohbje_oo
oooooooo00;ooooo0_n<^]H4ooooocWoS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmhgohbjeP;ooooo0on<^]H2ooooob3oS;[F0_oooom0ohbjePCog]_N00?o
HfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N=on<^]H6oooooa3oS;[F0_oo
ool@ohbjeP03oooooon<^]KoS;[F03koS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_NX?n<^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/2omkKgZ3oS;[F1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oN
fmjPohbjePCog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?n<
^]H4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oDYJe1?oN
fmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPoe:F]@Cog]_N00?o
HfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?mBU[D4omkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPoe:F]@Cog]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`;og]_NX?mBU[D4omkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmjPoe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_NX?mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/2omkKgPOoDYJe0_ooool2oe:F]@03oooooomBU[GoDYJe00;ooooo0_mBU[D5ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool2oe:F]@Cooooo1?mBU[D4ooooo`?oDYJe1?ooool2oe:F]@;ooooo0_mB
U[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe0_oo
ool2oe:F]@Cooooo0omBU[D4ooooo`?oDYJe0_ooool00omBU[Goooooooooo`03oe:F]@Cooooo0omB
U[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D2ooooo`;oDYJe1?ooool2oe:F]@;ooooo0_mB
U[D2ooooo`;oDYJe0_ooool2oe:F]@Cooooo2OmBU[D4omkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgPOoDYJe0_ooool01OmBU[GoooooooooooooooooDYJe00;ooooo
00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Gooooo
ooooo`02oe:F]@;ooooo0_mBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo
00?oDYJeooooooooool00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@?ooooo00?oDYJeoooooooo
ool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;o
oooo00?oDYJeooooooooool00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@?ooooo0_mBU[D2oooo
o`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooo
o`03oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooo
o`03oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@;ooooo2?mBU[D4omkKgP03of=UNooooooooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPOoDYJe0_ooool01OmBU[Gooooooooooooooooo
DYJe00;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mB
U[D2ooooo`GoDYJe0_ooool6oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_oo
ool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool01OmBU[D2ooooo`;oDYJe0_oo
ool4oe:F]@?ooooo00?oDYJeooooooooool01OmBU[D2ooooo`;oDYJe0_ooool00omBU[Gooooooooo
o`06oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Gooooooooo
o`02oe:F]@;ooooo1OmBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`05oe:F]@?ooooo2?mB
U[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPOoDYJe0_oo
ool01OmBU[Gooooooe:F]OooooooDYJe00;ooooo0_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@Go
oooo0_mBU[D6ooooo`03oe:F]Ooooooooooo00KoDYJe0_ooool2oe:F]@;ooooo00?oDYJeoooooooo
ool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`04ooooo`03
oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@Cooooo0_mBU[D6ooooo`03oe:F]Ooooooooooo00;o
DYJe0_ooool00omBU[Goooooooooo`06oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;o
DYJe0_ooool00omBU[Goooooooooo`02oe:F]@Kooooo00?oDYJeooooooooool00_mBU[D2ooooo`03
oe:F]Ooooooooooo00?oDYJe1?ooool9oe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_N1omBU[D2ooooo`05oe:F]OooooooDYJeoooooomBU[D00_ooool3oe:F
]@Cooooo00?oDYJeooooooooool00_ooool3oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo
00KoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooo
o`04oe:F]Oooooooooooooooo`CoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2
ooooo`03oe:F]Ooooooooooo00KoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2
ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2
ooooo`03oe:F]Ooooooooooo00;oDYJe0oooool;oe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_N1omBU[D4ooooo`03oe:F]Ooooooooooo00;ooooo00?oDYJe
oooooomBU[D00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`;oDYJe0_oo
ool00omBU[Goooooooooo`06oe:F]@;ooooo0_mBU[D2ooooo`05oe:F]OoooooooooooooooomBU[D0
0_ooool01?mBU[GooooooooooomBU[D3ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool01OmBU[Go
ooooooooooooooooDYJe00;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool01?mBU[GooooooooooomBU[D3ooooo`03oe:F]Ooooooooooo00KoDYJe0_ooool2
oe:F]@;ooooo00GoDYJeoooooooooooooooooe:F]@02ooooo`03oe:F]Ooooooooooo00;oDYJe0_oo
ool2oe:F]@;ooooo00GoDYJeoooooooooooooooooe:F]@02ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool2oe:F]@;ooooo2?mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgPOoDYJe1?ooool00omBU[Goooooooooo`02ooooo`;oDYJe1?ooool2oe:F]@;ooooo
0_mBU[D2ooooo`;oDYJe1?ooool2oe:F]@;ooooo1omBU[D4ooooo`;oDYJe0_ooool00omBU[Gooooo
ooooo`03oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D4ooooo`;oDYJe0_ooool00omBU[Gooooo
ooooo`03oe:F]@Cooooo0omBU[D4ooooo`?oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`Oo
DYJe1?ooool2oe:F]@;ooooo00CoDYJeooooooooooooDYJe1?ooool2oe:F]@Cooooo0_mBU[D2oooo
o`04oe:F]Ooooooooooooe:F]@Cooooo0_mBU[D4ooooo`WoDYJe1?oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh7oe:F]@?ooooo0omBU[D3ooooo`SoDYJe0_ooool=
oe:F]@;ooooo0_mBU[D2oooooa?oDYJe0_oooolQoe:F]@;ooooo0_mBU[D2ooooo`;oDYJe0_ooool?
oe:F]@;ooooo4?mBU[D2oooooa3oDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmh7oe:F]@?ooooo0omBU[D3ooooo`SoDYJe0_ooool>oe:F]@Cooooo5?mBU[D2
ooooob7oDYJe0_ooool3oe:F]@Cooooo4OmBU[D00oooooooDYJeoe:F]@0?oe:F]@03oooooomBU[Go
DYJe00koDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjP
oe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?mBU[D4
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPoe:F]@Cog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?mBU[D4omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPoe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_NX?mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmjPoe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`;og]_NX?mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2
omkKgZ3oDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjP
oe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?mBU[D4
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPoe:F]@Cog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N5_mBU[D2ooooo`;oDYJe00?ooooo
oe:F]OmBU[D00_ooool2oe:F]@Gooooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe1?ooool4
oe:F]@Kooooo0omBU[D4ooooo`?oDYJe1?ooool2oe:F]@;ooooo0_mBU[D2ooooo`GoDYJe1?ooool3
oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D4ooooo`;oDYJe0_ooool2
oe:F]@;ooooo0_mBU[D2ooooo`;oDYJe1?oooolIoe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_N5_mBU[D2ooooo`05oe:F]OoooooooooooooooomBU[D00_oo
ool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool3oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_oo
ool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`CoDYJe0_oo
ool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_oo
ool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_oo
ool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2oooooaSoDYJe1?oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhFoe:F]@;ooooo00GoDYJeoooooooooooooooo
oe:F]@02ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;o
DYJe0_ooool7oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Go
ooooooooo`02oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool4oe:F]@;ooooo1_mBU[D2oooo
o`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooo
o`GoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool01OmBU[D3oooooaSoDYJe1?oNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhFoe:F]@;ooooo00GoDYJeoooo
oomBU[Gooooooe:F]@02ooooo`;oDYJe0_ooool01?mBU[GooooooooooomBU[D5ooooo`;oDYJe1_oo
ool3oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Gooooooooo
o`02oe:F]@;ooooo00?oDYJeooooooooool00oooool4oe:F]@;ooooo1_mBU[D2ooooo`;oDYJe0_oo
ool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D6ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool00omBU[Goooooooooo`03oe:F]@Cooooo6OmBU[D4omkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQKoDYJe0_ooool01OmBU[Gooooooe:F
]OooooooDYJe00;ooooo0omBU[D4ooooo`03oe:F]Ooooooooooo00;ooooo0omBU[D2ooooo`;oDYJe
0_ooool3oe:F]@Kooooo0_mBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo
00?oDYJeooooooooool00_ooool5oe:F]@;ooooo1_mBU[D2ooooo`;oDYJe0_ooool00omBU[Gooooo
ooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe0_ooool00omBU[Gooooo
ooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D3oooooa_oDYJe1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhFoe:F]@Cooooo00?oDYJeooooooooool0
0_ooool00omBU[Gooooooe:F]@02oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@;o
oooo0_mBU[D2ooooo`?oDYJe0_ooool3oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03
oe:F]Ooooooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`CoDYJe0_ooool6oe:F
]@;ooooo0_mBU[D2ooooo`05oe:F]OoooooooooooooooomBU[D00_ooool00omBU[Goooooooooo`02
oe:F]@;ooooo0_mBU[D2ooooo`05oe:F]OoooooooooooooooomBU[D00_ooool00omBU[Gooooooooo
o`02oe:F]@;ooooo0_mBU[D2oooooaSoDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmhFoe:F]@Cooooo00?oDYJeooooooooool00_ooool2oe:F]@Cooooo0_mB
U[D2ooooo`;oDYJe0_ooool2oe:F]@Cooooo1?mBU[D2ooooo`?oDYJe0_ooool2oe:F]@Cooooo0omB
U[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo0omBU[D2ooooo`OoDYJe1?ooool2oe:F]@;ooooo00Co
DYJeooooooooooooDYJe1?ooool2oe:F]@Cooooo0_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@Co
oooo0_mBU[D4oooooaWoDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmhFoe:F]@?ooooo0omBU[D3ooooo`SoDYJe0_ooool>oe:F]@;ooooo0omBU[D2ooooo`oo
DYJe0_ooool8oe:F]@;ooooo0_mBU[D2ooooo`ooDYJe0_ooool@oe:F]@;ooooo8?mBU[D4omkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQKoDYJe0oooool3oe:F]@?o
oooo2?mBU[D2ooooo`koDYJe1_ooool@oe:F]@;ooooo2OmBU[D4oooooa7oDYJe00?ooooooe:F]OmB
U[D03omBU[D00oooooooDYJeoe:F]@0Noe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_NX?mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmjPoe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_NX?mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3o
DYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPoe:F]@Co
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?mBU[D4omkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh00omSIG_o
ooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjPoe:F]@Cog]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?mBU[D4omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk0_oNfmjPoe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_NX?mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmi8oe:F]@;oooooE_mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgTSoDYJe0_oooomFoe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_N4OmBU[D2ooooo`;oDYJe00?ooooooe:F]OmBU[D00_ooool2oe:F]@Go
oooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe1?ooool5oe:F]@Gooooo0_mBU[D2ooooo`03
oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F
]@;ooooo0_mBU[D4ooooo`KoDYJe1?ooool3oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe0_ooool2oe:F
]@;ooooo0_mBU[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D2ooooo`;oDYJe1?oooolDoe:F
]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N4OmBU[D2oooo
o`05oe:F]OoooooooooooooooomBU[D00_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJe
ooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo0omBU[D2
ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`;oDYJe0_ooool01OmBU[Gooooooooo
ooooooooDYJe00;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@;ooooo1?mBU[D2ooooo`;o
DYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03
oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03
oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@;ooooo4omBU[D4omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQ7oDYJe0_ooool01OmBU[GoooooooooooooooooDYJe
00;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2
ooooo`coDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe0_ooool2oe:F]@;ooooo00?o
DYJeooooooooool00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo1omBU[D2ooooo`KoDYJe
0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool5oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00GoDYJe0ooooolCoe:F]@Cog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N4OmBU[D2ooooo`05oe:F
]OooooooDYJeoooooomBU[D00_ooool2oe:F]@;ooooo00CoDYJeooooooooooooDYJe1Oooool2oe:F
]@Kooooo1_mBU[D4ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`;oDYJe0_ooool0
0omBU[Goooooooooo`02oe:F]@;ooooo00CoDYJeooooooooooooDYJe1_ooool3oe:F]@;ooooo1_mB
U[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D6ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`03oe:F]@Cooooo5?mB
U[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQ7oDYJe0_oo
ool01OmBU[Gooooooe:F]OooooooDYJe00;ooooo0omBU[D4ooooo`03oe:F]Ooooooooooo00;ooooo
0omBU[D2ooooo`;oDYJe0_ooool4oe:F]@Gooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;o
oooo0_mBU[D2ooooo`?oDYJe0_ooool6oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;o
DYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;o
DYJe0_ooool00omBU[Goooooooooo`02oe:F]@?ooooo5_mBU[D4omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQ7oDYJe1?ooool00omBU[Goooooooooo`02ooooo`03
oe:F]OooooooDYJe00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe0_ooool2oe:F
]@;ooooo0omBU[D4ooooo`CoDYJe0_ooool01OmBU[GoooooooooooooooooDYJe00?ooooo00CoDYJe
ooooooooooooDYJe0oooool01?mBU[GooooooooooomBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool3oe:F]@;ooooo1_mBU[D2ooooo`;oDYJe0_ooool01OmBU[GoooooooooooooooooDYJe00;o
oooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe0_ooool01OmBU[GoooooooooooooooooDYJe
00;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`;oDYJe0_oooolCoe:F]@Cog]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N4OmBU[D4ooooo`03oe:F]Ooooooooooo
00;ooooo0_mBU[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D4ooooo`CoDYJe0_ooool6oe:F
]@;ooooo00CoDYJeooooooooooooDYJe0oooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJe
ooooooooool00_mBU[D2ooooo`;oDYJe1?ooool4oe:F]@;ooooo1omBU[D4ooooo`;oDYJe0_ooool0
1?mBU[GooooooooooomBU[D4ooooo`;oDYJe1?ooool2oe:F]@;ooooo00CoDYJeooooooooooooDYJe
1?ooool2oe:F]@Cooooo5?mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgQ7oDYJe0oooool3oe:F]@?ooooo2?mBU[D2ooooo`koDYJe0_ooool3oe:F]@;ooooo
5_mBU[D2ooooo`_oDYJe0_ooool2oe:F]@;ooooo3omBU[D2oooooa3oDYJe0_oooolKoe:F]@Cog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N4OmBU[D3ooooo`?oDYJe
0oooool8oe:F]@;ooooo3omBU[D5ooooo`;oDYJe0_oooolCoe:F]@;ooooo3?mBU[D4oooooa7oDYJe
00?ooooooe:F]OmBU[D03omBU[D00oooooooDYJeoe:F]@0Ioe:F]@Cog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NX?mBU[D4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgZ3oDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjPoe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NX?mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgZ3oDYJe1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjPoe:F]@Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
X?mBU[D4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^VomkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^VomkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG^VomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG^VomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^VomkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgYko00001?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjNo`1AS0Cog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NW_l0DH`4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgYko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmjNo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`Cog]_NW_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/4omkKgYko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
1?oNfmjNo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N
W_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgYko056<
1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmilo`1AS1coDYJe
1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgWco056<
7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N
O?l0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
1?oNfmilo`1AS1coDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/4omkKgWco056<7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`Cog]_NO?l0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmilo`1AS1coDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgWco056<7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NO?l0DH`Loe:F]@Ko056<1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1AS0;ooooo0ol0DH`01?oooooo056<
o`1AS?l0DH`2ooooo`?o056<0oooool01?l0DHcoooooooooool0DH`2ooooo`;o056<0_ooool4o`1A
S0Cooooo2?l0DH`4ooooo`Ko056<0oooool4o`1AS0;ooooo0ol0DH`2ooooo`?o056<0oooool3o`1A
S0Cooooo0ol0DH`2ooooo`?o056<0_ooool3o`1AS0?ooooo0_l0DH`4ooooo`_o056<3?mBU[D2oooo
o`koDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkK
gP_o056<0_ooool2o`1AS0?ooooo0_l0DH`2ooooo`;o056<1_ooool2o`1AS0;ooooo0_l0DH`2oooo
o`?o056<1_ooool6o`1AS0Kooooo1?l0DH`5ooooo`?o056<0_ooool3o`1AS0;ooooo0_l0DH`4oooo
o`;o056<1_ooool2o`1AS0;ooooo0ol0DH`2ooooo`;o056<1?ooool00ol0DHcoooooooooo`04oooo
o`[o056<3?mBU[D2ooooo`koDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/4omkKgP_o056<0_ooool2o`1AS0?ooooo0_l0DH`2ooooo`;o056<0_ooool2o`1A
S0;ooooo0_l0DH`2ooooo`03o`1AS?oooooooooo00?o056<0_ooool:o`1AS0?ooooo0_l0DH`3oooo
o`;o056<0oooool01?l0DHcoooooooooooooool2o`1AS0;ooooo0ol0DH`2ooooo`;o056<0_ooool3
o`1AS0;ooooo1ol0DH`2ooooo`?o056<0_ooool2o`1AS0;ooooo1ol0DH`2ooooo`[o056<7?mBU[D6
o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`2
ooooo`;o056<00?oooooo`1AS?ooool00_l0DH`2ooooo`?o056<0_ooool00ol0DHcoooooooooo`02
o`1AS0Gooooo0ol0DH`7ooooo`Go056<0_ooool4o`1AS004ooooool0DHco056<o`1AS0;ooooo0ol0
DH`2ooooo`;o056<0_ooool3o`1AS0;ooooo0_l0DH`2ooooo`?o056<1oooool2o`1AS0;ooooo0ol0
DH`2ooooo`;o056<0_ooool4o`1AS0Gooooo2_l0DH`<oe:F]@;ooooo3_mBU[D6o`1AS0Cog]_N00?o
HfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`2ooooo`04o`1AS?oo
ooooooooo`1AS0;ooooo00?o056<ooooooooool01?l0DH`4ooooo`;o056<1?ooool4o`1AS0Oooooo
1Ol0DH`2ooooo`So056<0_ooool3o`1AS0;ooooo0_l0DH`2ooooo`?o056<0_ooool2o`1AS0;ooooo
0ol0DH`7ooooo`;o056<0_ooool3o`1AS0;ooooo0_l0DH`2ooooo`?o056<1Oooool;o`1AS0coDYJe
0_ooool>oe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
1?oNfmh;o`1AS0;ooooo00Co056<oooooooooooo056<0_ooool00ol0DHcoooooooooo`06o`1AS0;o
oooo0_l0DH`4ooooo`Co056<0_ooool3o`1AS0;ooooo1Ol0DH`2ooooo`So056<0oooool01?l0DHco
ooooooooooooool2o`1AS0?ooooo0_l0DH`2ooooo`;o056<0_ooool3o`1AS0;ooooo0ol0DH`2oooo
o`;o056<0oooool2o`1AS0;ooooo0_l0DH`2ooooo`?o056<0_ooool>o`1AS0goDYJe0_ooool=oe:F
]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1A
S0;ooooo00?o056<ooooool0DH`00_l0DH`01?oooooo056<ooooooooool2o`1AS0Kooooo0_l0DH`2
ooooo`03o`1AS?oooooooooo00Co056<1Oooool6o`1AS0;ooooo1?l0DH`00ooooooo056<o`1AS002
o`1AS0Gooooo0ol0DH`7ooooo`03o`1AS?oooooooooo00?ooooo0_l0DH`5ooooo`?o056<1oooool0
0ol0DHcoooooooooo`03ooooo`03o`1AS?oooooooooo00Cooooo2_l0DH`>oe:F]@;ooooo3?mBU[D6
o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`4
ooooo`?o056<1?ooool3o`1AS0Cooooo0ol0DH`2ooooo`;o056<0_ooool4o`1AS0?ooooo1ol0DH`3
ooooo`;o056<0oooool4o`1AS0?ooooo1?l0DH`2ooooo`04o`1AS?ooooooooooooooo`;o056<1Ooo
ool3o`1AS0?ooooo1?l0DH`2ooooo`04o`1AS?ooooooooooooooo`;o056<1Oooool2o`1AS0Cooooo
2ol0DH`:oe:F]@;ooooo0_mBU[D2ooooo`coDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgP_o056<1?ooool3o`1AS0Cooooo2_l0DH`2oooooa?o056<
1_oooolEo`1AS0;ooooo5Ol0DH`2oooooa?o056<2omBU[D4ooooo`goDYJe1_l0DH`4omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP_o056<0oooool5o`1AS0?ooooo
2_l0DH`2oooooaCo056<1?oooolGo`1AS003ooooool0DHco056<01Co056<00?oooooo`1AS?l0DH`0
4Ol0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
1?oNfmilo`1AS1coDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/4omkKgWco056<7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`Cog]_NO?l0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmilo`1AS1coDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgWco056<7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NO?l0DH`Loe:F]@Ko056<1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjNo`1AS0Cog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NW_l0DH`4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgYko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmjNo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`Cog]_NW_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/4omkKgYko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
1?oNfmjNo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N
W_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgYko056<
1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjNo`0000Cog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NW_l00004omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000004ko0000
DOoNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8
o`00001>o`00057og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N
00?o0000o`P82?l00000C_l0001AomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/4omkKgP03o`000?l820So000000oo000000?o8B0Qod91@_l@41003ol00002oc4`<@oo0000
0_la<345o`0000;o<C0a1ol00002ob4P8@[o0000DOoNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`000004o`000003oibNW?ooooooLg5c00Co0000
0_ooool00ol@413oLg5cooooo`02ooooo`08ohb>S?l0003o410@oooooonm_[go0000okfn_Oooool2
o`000005omkOg_oooooo0000oa0@4?o>clh00_ooool01_oNgmkoDU5Bo`000?mcLG?ooooood91@P?o
000000Ko410@oooooola<37o0000oa0@4?o>clh2ooooo`05omkOg_la<37o0000oa0@4?o>clh00_oo
ool02_oNgmko<C0ao`000?mBDE;og]oNo`000?mcLG?oooooomkOg_nLWY`9o`00057og]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l000001?l00000
1?lQ827okno_ono_kol@4102o`000004oc4`<Ooooooog]oNo`0000;ooooo01WoHf5Sojf^[Ooooooo
Hf5So`000?oNgmkokno_o`000?nLWYcooooood91@_l0003o_KjmoooooolQ827oW9jLoooooon][Zgo
Lg5cono_kooooooo@T52of=QHoooooooLg5c00Co000001Wokno_oe9AD_l0003oW9jLolk?c_l@413o
0000og=aLoo_knoo8B0QoibNW?o>clko410@o`000?mcLG?okno_ob4P8Ola<37oooooo`000?m2@D;o
<C0ao`000?o>clkoHf5S00So0000DOoNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk1?oNfmh00ol0003o20P8o`000005o`000003og=aLooooooooooo00Cooooo01goW9jLo`00
0?ooooooc/o>o`000?lQ827ooooookfn_Ol0003o_Kjmooooool@413oLg5coooooomSHF?o0000og=a
Looooooo@T52okfn_Ooooooo8B0Qo`000?la<37oooooojf^[Om2@D;ooooooibNW004o`000005okfn
_OmcLG?o0000okfn_OmcLG<00ol00002oibNW003okfn_OmcLG?o000000;o00000_nLWY`00ol0003o
oooooc4`<@02o`000003of=QHoo_knooHf5S00So0000DOoNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`000005o`00000;oa0@4?o_knooooooolk?
c_nm_[gokno_oooooomcLG?o0000olk?c_ooool00_l00002ono_k`03o`000?n<SXcooooo00;o@T52
00Woooooog=aLol0003oHf5SoooooomcLG?o[Jj]oooooolQ82400_l00002ooooo`03o`000?oooooo
c/o>00Co000000GoS8j<oibNW?l0003oW9jLohb>S003o`000004og=aLonm_[goW9jLohb>S0?o0000
00WoLg5cokfn_Ol0003oc/o>oe9AD_l0003o_Kjmono_komcLG<02Ol0001AomkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000000Ko000003ooLg5c
oooooomcLG?o0000okfn_Ooooooo@T52o`000?n][Zgooooooc4`<Ol0003o_Kjmooooool0003oW9jL
oooooon<SXco8B0QoooooooNgmko410@oe9AD_ooooooLg5coe9AD_ooooooc/o>oa0@4?m2@D;ooooo
ono_kol0003og]oNoooooomSHF?o0000oa0@4?l0003oLg5cokfn_Ol0003o<C0aoooooomSHF?o0000
oa0@4?o>clkoW9jLoc4`<OooooooHf5So`000?l@413oc/o>oibNW?l0003o[Jj]og=aLol0003ooooo
ob4P8Ol@41002Ol0001AomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgP03o`000?l820So000000Oo000000Gog]oNono_kol0003okno_ooooo`02o`000008og=aLooo
oooo@T52o`000?nLWYcooooood91@_oNgmh2ooooo`04okfn_Oooooooooooono_k`;ooooo00?oLg5c
o`000?nLWY`01?ooool00omcLG?o0000okfn_@03ooooo`04of=QHol0003o@T52ooooo`;o000000So
DU5BomkOg_oNgmkoooooolk?c_lQ827o0000oe9ADP;og]oN00_oooooolk?c_lQ827o0000og=aLon]
[Zgo0000ohb>S?oNgmkokno_od91@P08o`00057og]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l000001ol000001OmSHF?oooooog=aLoooooooc/o>
00;o000000ko@T52og=aLom2@D;o0000od91@_mcLG?o8B0Qof=QHooooooog]oNof=QHoo>clkooooo
od91@P;oLg5c0ol000001?m2@D;oLg5cog=aLom2@D82o`000009oe9AD_mcLG?o@T52og=aLom2@D;o
0000ob4P8Ooooooo8B0Q00?o00000_m2@D85o`0000;o@T520ol000001?mSHF?o_Kjmo`000?l00002
oc4`<@Wo0000DOoNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh0
0ol0003o20P8o`000008o`000004omkOg_ooooooooooohb>S0[o000000KoooooomkOg_l0003o[Jj]
oooooola<34Bo`000003oooooom2@D;o000000ko000000?o@T52ooooool000003?l0001AomkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000000So
000000Co@T52ooooooooooooHf5S2_l000001_mSHF?oLg5co`000?mcLG?ooooooe9ADQ3o00000_m2
@D801?o>clkoS8j<od91@_la<34>o`000003oooooolQ827o000000_o0000DOoNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`000009o`000003okfn
_Ooooooo<C0a00go000000?oDU5BoooooomcLG<04?l00005okfn_@03ojf^[Ol0003o000000co0000
00?og]oNod91@_l000002_l000000olH61Sog]_NomkKgP1?omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgP03oaPH6?l0003o000001Wo000000?o@T52oooooonLWY`0
9?l000000onm_[goLg5co`00000:o`000003oaPH6?oNfmkog]_N04oog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o61PHo`000?l00000@?l000000ola<37o8B0Q
o`00000:o`000003oaPH6?oNfmkog]_N04oog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`Cog]_N00?oFUUJo`000?l00000COl000000omJFE[og]_NomkKgP1?omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03ojf^[Om:BD[o000004co0000
00?oBTU:ojf^[OoNfmh0D?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
1?oNfmh01?oWinOo[Jj]oeYIF_lQ8243oa0@40Oo00006?l@410Oo`000003o`P82?l@413o410@00?o
410@00Ko20P8oa0@4?lQ827oFUUJojf^[OoWinMAomkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG^VomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^V
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^VomkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^VomkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG^VomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^V
omkKgP03of=UNooooooooooo007oHfEk00000om[KHcog]oWokFbcP2Xohb:Y@7ooo_o0Oo6bmH1og=a
U00000?oHff<omkOiooNgnL0Z?oNfmh1oooko`7oa/_F0OmcLI@00003of=]S?oNfnOooooo0:Sooooo
0Ooonol1olK;eP7oLg6D00000omSKHcoe]OWoooko`2HooOgo`03oibN[OnLED;oYDe200SoYDe200Oo
W5E2oibN[OogmooomoOooookooogmoooa/_F007oLg6D00000omSKHcoe]?NooOcm`2Hono_m`03okEE
B_ooTYCooj:U00OooijL00?ooj:UoonBU?neEDX01?o_koL1olK;eP7oLg6D00001?mSKHcoc/oNonO[
kooWinl3onOSk`03onOWkooWhnooinO_00CoinO_00?oin?_onOWkooWhnl00ooWhnl5onOWk`06onOS
kooWinooinO_onOSkooWinooin?_0_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_
00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_
00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_
00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_
00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_
00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_
00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_
00;oinO_00Goin?_onOWkooWhnooinO_onOSk`04onOWk`03onOSkooWinooin?_00?oin?_1OoWinl0
1?oWhnooinO_omiUHooo][D9oon^[@03oonf]OoNIF?oinO_00?oinO_0Oo6bmH1og=aU00000?oHff<
olk?g_oNgnL0V?oNfnL00ooNIF?ook:eoonZY@02ooooo`?oojZU0_ooool00oooZZGook:eomiUH`02
omkKi`;og]oW0Oo6bmH1og=aU00000?oHff<olk;g_oFemh00_oFdmh00ooFemkoe]?NomKCgP2ComKC
gP03omiUHooo/[GoojZU00?ooooo00OoojjUoooooooooooooooooonZYOoo/[GogVES00;oe]?N00?o
e]ONomKGioo6bmH00OmcLI@00003of=]S?o6bmKoc/oN00?oc/oF00Coc/oNolk;g_o>cmKoc/oF1?o>
cmh02Oo>cmKoc/oNolk?e_o>bmkoc/oFolk;e_o>cmKoc/oNolk;eP03olk?eP03olk;e_o>cmKoc/oF
00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF
00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF
00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF
00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF
00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF
00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF
00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF
00;oc/oF00?oc/_Folk?g_o>cmh00oo>cmh02Oo>cmKoc/oNolk?e_o>bmkoc/oFolk;e_o>cmKoc/oN
olk;eP03olk?eP03olk;e_oNIF?ook:]00;oojZU1Oooool2oonVW003oon^[OoNIF?oc/oN00;oc/oN
0Oo>dmh1olK;eP7oLg6D00000omSKHcoa/OFolK7eP2HolK7eP03omiUF_ooZZGooj:L00;ooj:L0ooo
ool2oonNU003oonJU?ooYYcogVEJ00?oa/OF0Oo>bmh1okg3eP7oLg6D00000omSKHcoa/OFokg3cP2H
okg3cP04omiUF_ooYYcooiZDoonJU0Gooooo0_ooTX`00oooWYcogVEJokg3cP02okg3cP7oa/OF0One
]/h1og=aU00000?oHff<olK7e_nm^/h0V?nm^/h00ooNIF?ooijLoonBS003ooooo`07oon>S?oooooo
ooooooooooogRXCooiJDomiUH`03okfjcP7oa/?F0On]Z[d1og=aU00000?oHff<olK7e_ne]/H05?ne
]/h00one]/Ko]KK>okFfaP04okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne
]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne
]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne
]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne
]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne
]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne
]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne
]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00go]KK>00Oo]KK6okFfc_ne]/Ko]KK>
omiUHoooUYComhJ400;ooooo0oogRX@2ooooo`03onn6Q?ooUYCogVES00?o]KK>0Onm_/h1oibN]@7o
Lg6D00000omSKHcoa/OFojfbaP2HokFbcP03omiYHoooUYCokh:400OokhJ400?okh:4oonFU?oNIF<0
0one//h1okfncP7oU9:]0OmcLI@00003of=]S?o6`mKo[J[609So[Jk600?ocVUJoonJU?ooUY@02?oo
UY@00oooVYcocVUJojf^aP02ojf^aP7o]KK>0On<RZD1og=aU00000?oHff<olK3e_nUX[d0V?nUY[d0
0onLWZgocVEJomiYH`07omiUH`03omiYHoo>IF?oW9j]00;oYJJm00?oYJ:mokF^c_n<RZD00OmcLI@0
0003of=]S?o6`mKoYJ:m0:OoYJJm00?oYJ:mokF^c_n<RZD00OmcLI@00003of=]S?o6`mKoYJ:m0:Oo
YJJm00?oYJ:mokF^c_n<RZD00OmcLI@00003of=]S?o6`mKoYJ:m0:OoYJJm00?oYJ:mokF^c_n<RZD0
0OmcLI@00003of=]S?o6`mKoYJ:m0:SoYJJm0One//h1ohb:Y@7oLg6D00000omSKHcoinO_omkOk`2X
omkOk`7oinOg0On<RZD1og=aU000[OmSKH`1og=aU000\
\>"], "ListGraphic",
 Evaluatable->False,
 ImageSize->{174, 284},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"MakeContentsIntro", "i:81"}]
}, Open  ]],

Cell["\<\
You can format your table of contents in any of three predefined styles: \
\>", "Text",
 CellTags->{"MakeContentsIntro", "i:81"}],

Cell["\<\
Simple\[LongDash]this style lists all the entries without page numbers or any \
special formatting. A simple table of contents is like an outline. It is \
useful for checking that your topics are in the right order before generating \
a table of contents in one of the other two styles.\
\>", "BulletedList",
 CellTags->{"MakeContentsIntro", "i:81"}],

Cell["\<\
Book\[LongDash]this style resembles a table of contents in a typical book, \
with each topic and subtopic on a separate line. \
\>", "BulletedList",
 CellTags->{"MakeContentsIntro", "i:81"}],

Cell["\<\
Condensed\[LongDash]this style combines multiple subtopics on the same line \
to achieve a more compact appearance. \
\>", "BulletedList",
 CellTags->{"MakeContentsIntro", "i:81"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating a Table of Contents", "Subsubsection",
 CellTags->{"Generating a TOC", "i:82"}],

Cell[TextData[StyleBox["To create a table of contents:", "TB"]], "Text",
 CellTags->{"Generating a TOC", "i:82"}],

Cell[TextData[{
 "For a single notebook, open the notebook and make it the currently selected \
notebook. For multiple notebooks, open the MakeProject ",
 "dialog box",
 " and load the project file for your project. (If you have not already \
created a project file, see ",
 ButtonBox["Creating a Project File",
  ButtonData:>"Creating a Project File",
  ButtonStyle->"AddOnsLinkText"],
 " to learn how.)"
}], "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Generating a TOC", "i:82"}],

Cell["Open the MakeContents palette.", "ItemizedList",
 CellTags->{"Generating a TOC", "i:82"}],

Cell[TextData[{
 "Click ",
 StyleBox["Paginate", "SR"],
 " to assign page numbers to the source notebook(s). You can skip this step \
if you have paginated the notebooks previously or are creating a simple table \
of contents, which does not contain any page numbers."
}], "ItemizedList",
 CellTags->{"Generating a TOC", "i:82"}],

Cell[TextData[{
 "Click either ",
 StyleBox["Make Simple Contents", "SR"],
 ", ",
 StyleBox["Make Book Contents", "SR"],
 ", or ",
 StyleBox["Make Condensed Contents", "SR"],
 ", depending on which style of table of contents you want to create."
}], "ItemizedList",
 CellTags->{"Generating a TOC", "i:82"}],

Cell["\<\
It may take a few moments for the evaluation to be completed, depending on \
the size of the source notebook(s). The newly generated table of contents \
appears on the screen and is saved in the same directory as the source \
notebook.\
\>", "Text",
 CellTags->{"Generating a TOC", "i:82"}],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically adds cell tags to the source notebook(s) and saves all \
changes. It is therefore advisable to make a ",
 "backup",
 " copy of your notebook(s) before generating a table of contents."
}], "Text",
 CellTags->{"Generating a TOC", "i:82"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Customizing a Table of Contents", "Subsubsection",
 CellTags->{"Customizing a TOC", "i:83"}],

Cell[TextData[{
 "The buttons at the bottom of the palette let you specify options to \
customize various features of the table of contents. To set the value of an \
option, click the button bearing the name of that option. This brings up a \
dialog box displaying the current value of the option. You can edit the text \
and click ",
 StyleBox["Apply", "SR"],
 " for the changes to take effect. Click ",
 StyleBox["OK", "SR"],
 " to close the ",
 "dialog box",
 "."
}], "Text",
 CellTags->{"Customizing a TOC", "i:83"}],

Cell[TextData[{
 StyleBox["Paginate", "SR"],
 " calculates page numbers for the source notebook(s). The page numbers are \
saved as ",
 StyleBox["TaggingRules", "MR"],
 " in the notebook. By default, the first notebook has starting page number \
1."
}], "BulletedList",
 CellTags->{"Customizing a TOC", "i:83"}],

Cell[TextData[{
 StyleBox["Clear Cell Tags", "SR"],
 " removes the automatically generated cell tags in the source notebook(s). \
If you remove the cell tags, the hyperlinks in the table of contents will \
take you to the start of the notebook instead of to a specific topic."
}], "BulletedList",
 CellTags->{"Customizing a TOC", "i:83"}],

Cell[TextData[{
 StyleBox["CellTagPrefix...", "SR"],
 " lets you specify a prefix to the automatically generated cell tags."
}], "BulletedList",
 CellTags->{"Customizing a TOC", "i:83"}],

Cell[TextData[{
 StyleBox["ContentsFileName...", "SR"],
 " lets you specify the name of the notebook containing the table of \
contents."
}], "BulletedList",
 CellTags->{"Customizing a TOC", "i:83"}],

Cell[TextData[{
 StyleBox["SelectedCellStyles...", "SR"],
 " lets you specify the cell styles that should be included in the table of \
contents. The default setting is ",
 StyleBox["SelectedCellStyles", "MR"],
 " \[Rule] ",
 StyleBox["{\"Title\", \"Section\", \"Subsection\", \"Subsubsection\"}", 
  "MR"],
 "."
}], "BulletedList",
 CellTags->{"Customizing a TOC", "i:83"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeCategories", "Subsection"],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
 CellTags->{"MakeCategoriesIntro", "i:84"}],

Cell[TextData[{
 "A BrowserCategories.m file determines how information is organized and \
displayed in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Help Browser. The MakeCategories palette enables you to generate a \
BrowserCategories.m file for your notebook or project. By creating such a \
file, you can add your own content to the online help so it is accessible \
from the Help Browser."
}], "Text",
 CellTags->{"MakeCategoriesIntro", "i:84"}],

Cell[CellGroupData[{

Cell[BoxData[
 ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "OpenCloseItemizedPicture",
   FormatType->StandardForm,
   ImageSize->{54, 13},
   ImageMargins->{{0, 0}, {0, 0}},
   ImageRegion->{{0, 1}, {0, 1}}],
  Active->True,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& )]], "OpenCloseItemizedPicture",
 CellTags->{"i:84", "MakeCategoriesIntro"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002k0000jR000`400?l00000o`00003o^omSIG/0
0003of=UNooooooooooo0;Oooooo0OmSIG/00003of=UNooooooo[JZm0;Ko[JZm0Oooool1of=UN`00
00?oHfEkoooooon]Z[d0]OmSIG/1ojfZ_@7ooooo0OmSIG/00004of=UNooooooo[JZmof=UNk?og]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UNk?og]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjNohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmh_ohbjePCoooooJon<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgRkoS;[F00Coooooohbje_n<^]KoS;[F0_oooomZohbjeQ?og]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N2On<^]H5ooooo`?oS;[F0_ooool2ohbjePGo
oooo00?oS;[Fooooooooool01?n<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo0_n<^]H2oooo
o`;oS;[F0_ooool00on<^]Koooooooooo`03ohbjePCooooo0on<^]H4ooooo`?oS;[F0_ooool01?n<
^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool2ohbjeP;ooooo0_n<^]H4ooooo`;oS;[F0_ooool5
ohbjeP?ooooo1?n<^]H5ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02
ohbjePCooooo0on<^]H4ooooo`?oS;[F0_ooool2ohbjeP;ooooo0_n<^]H2ooooo`[oS;[F4ooNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh8ohbjeP;ooooo0on<^]H2
ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00on<^]H2
ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0ooo
ool2ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool01?n<^]Kooooooooo
oon<^]H3ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo
0_n<^]H2ooooo`03ohbje_oooooooooo00GoS;[F0oooool3ohbjeP;ooooo0_n<^]H2ooooo`04ohbj
e_ooooooooooohbjeP;ooooo00GoS;[FooooooooooooooooohbjeP02ooooo`;oS;[F0_ooool00on<
^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool2ohbjeP;ooooo2_n<^]HComkK
gP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPgoS;[F0_ooool00on<
^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00?oS;[F0_ooool2ohbj
eP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<
^]Koooooooooo`06ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<
^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`GoS;[F0_ooool4ohbj
eP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2
ooooo`;oS;[F0_ooool00on<^]Koooooooooo`08ohbjeP?ooooo5_n<^]HComkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgP_oS;[F1?ooool00on<^]Koooooooooo`03
ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool3ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oo
oooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool01_n<
^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<
^]H2ooooo`03ohbje_oooooooooo00;oS;[F1_ooool00on<^]Koooooooooo`04ohbjeP;ooooo00?o
S;[Fooooooooool00on<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo00?oS;[Fooooooooool0
0_n<^]H2ooooo`03ohbje_oooooooooo00Cooooo0_n<^]H4oooooaOoS;[F4ooNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh9ohbjePGooooo0_n<^]H2ooooo`CoS;[F
1?ooool00on<^]Koooooooooo`03ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F
0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool01_n<^]H2ooooo`;oS;[F
0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbj
e_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool01?n<^]H2ooooo`03ohbj
e_oooooooooo00CoS;[F1?ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool00on<^]Ko
ooooooooo`02ohbjeP;ooooo00CoS;[Foooooooooooooooo6On<^]HComkKgP03of=UNooooooooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPSoS;[F1?ooool4ohbjeP;ooooo0_n<^]H01?oo
ooooS;[Fohbje_n<^]H2ooooo`03ohbje_oooooooooo00?oS;[F0_ooool2ohbjeP;ooooo00GoS;[F
ooooooooooooooooohbjeP02ooooo`04ohbje_ooooooooooohbjeP?ooooo00?oS;[Fooooooooool0
1_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00GoS;[Foooooooooooo
ooooohbjeP02ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo00?oS;[Foooooooo
ool00on<^]H2ooooo`?oS;[F0_ooool00on<^]KoooooohbjeP02ohbjeP;ooooo00CoS;[Foooooooo
ooooS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo
00;oS;[F0_oooolFohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_N2?n<^]H2ooooo`GoS;[F1?ooool2ohbjePCooooo0_n<^]H8ooooo`04ohbje_oooooooooo
ohbjeP;ooooo00?oS;[Fooooooooool00on<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo1on<
^]H4ooooo`;oS;[F0_ooool2ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool00on<^]Kooooo
ooooo`02ooooo`;oS;[F1?ooool2ohbjePCooooo00?oS;[Fooooooooool00on<^]H2ooooo`;oS;[F
1?ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F1?ooool3ohbjePCooooo
5on<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPSoS;[F
0_ooool3ohbjeP;ooooo00?oS;[Fooooooooool03_n<^]H2oooooaCoS;[F0_ooool2ohbjeP;ooooo
5_n<^]H2ooooo`koS;[F0_ooool3ohbjeP;ooooo2?n<^]H2ooooob_oS;[F4ooNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh9ohbjePGooooo0on<^]H00oooooooS;[F
ohbjeP0=ohbjeP03oooooon<^]KoS;[F00;ooooo4On<^]H4oooooaSoS;[F00?oooooohbje_n<^]H0
2on<^]H2ooooo`GoS;[F0_ooool7ohbjeP;ooooo:on<^]HComkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjNohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjNohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
W_n<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F
4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjNohbjeQ?og]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmiVohbjeP?ooooo=On<^]HComkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgVSoS;[F0_ooooldohbjeQ?og]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N5On<^]H5ooooo`?oS;[F
1?ooool2ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F1?ooool3ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F
0_ooool00on<^]Koooooooooo`03ohbjePCooooo0on<^]H4ooooo`;oS;[F0_ooool00on<^]Kooooo
ooooo`02ohbjePGooooo0on<^]H2ooooo`;oS;[F0oooool2ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F
1?ooool3ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_oooolEohbjeQ?og]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N5?n<^]H2ooooo`?oS;[F0_ooool00on<^]Kooooo
ooooo`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool2ohbjeP;ooooo00?oS;[Foooooooo
ool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo00CoS;[Foooooooo
ooooS;[F0oooool2ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool01?n<
^]Kooooooooooon<^]H2ooooo`03ohbje_oooooooooo00?oS;[F0_ooool00on<^]Koooooooooo`03
ohbjeP?ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02
ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool2ohbjeP;ooooo5On<^]HComkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQWoS;[F0_ooool00on<^]Koooooooooo`05
ohbjeP;ooooo00?oS;[Fooooooooool01On<^]H2ooooo`GoS;[F0_ooool2ohbjeP;ooooo1On<^]H2
ooooo`;oS;[F0_ooool00on<^]Koooooooooo`06ohbjeP;ooooo1On<^]H2ooooo`03ohbje_oooooo
oooo00KoS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_oo
ool00on<^]Koooooooooo`08ohbjeP?ooooo8On<^]HComkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgQOoS;[F1?ooool00on<^]Koooooooooo`04ooooo`04ohbje_oo
ooooooooohbjePKooooo00?oS;[Fooooooooool01On<^]H2ooooo`;oS;[F1_ooool00on<^]Kooooo
ooooo`02ohbjeP;ooooo00?oS;[Fooooooooool01_n<^]H6ooooo`04ohbje_ooooooooooohbjeP;o
oooo1?n<^]H4ooooo`03ohbje_oooooooooo00;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2oooo
o`03ohbje_oooooooooo00Cooooo0_n<^]H4ooooob;oS;[F4ooNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk0_oNfmhEohbjePGooooo0_n<^]H2ooooo`;oS;[F0_ooool01?n<
^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`05ohbjeP;ooooo0_n<^]H2
ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool01_n<^]H2
ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F1Oooool2ohbjeP;ooooo0_n<
^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`04ohbj
e_ooooooooooooooobCoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmhDohbjePCooooo1?n<^]H2ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2oooo
o`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2oooo
o`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H3ooooo`03ohbje_oooooooooo00KoS;[F0_ooool2
ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool00on<^]Koooooooooo`02ooooo`CoS;[F0_oo
ool00on<^]Koooooooooo`03ohbjePCooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oo
oooooooo00;oS;[F0_oooolQohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_N5?n<^]H2ooooo`OoS;[F1?ooool2ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F1?oo
ool00on<^]Koooooooooo`02ooooo`;oS;[F1?ooool3ohbjeP;ooooo00CoS;[FooooooooooooS;[F
0_ooool7ohbjePCooooo0_n<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo1On<^]H6ooooo`?o
S;[F1?ooool2ohbjePCooooo0on<^]H4ooooob;oS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk0_oNfmhDohbjeP;ooooo0on<^]H2ooooo`SoS;[F0_ooool?ohbjeP;o
oooo3On<^]H2ooooo`;oS;[F0_ooool2ohbjeP;ooooo2?n<^]H2ooooo`04ohbje_ooooooooooohbj
eP;ooooo0on<^]H2ooooo`03ohbje_oooooooooo00SoS;[F0_ooool_ohbjeQ?og]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N5On<^]H5ooooo`WoS;[F0_ooool@ohbj
eP03oooooon<^]KoS;[F00_oS;[F0_ooool3ohbjePCooooo2On<^]H2ooooo`03ohbje_oooooooooo
00;oS;[F1Oooool3ohbjeP03oooooon<^]KoS;[F00KoS;[F0_ooool_ohbjeQ?og]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=UNooooooooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk0_oNfmjNohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmjNohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_NW_n<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkK
gYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjNohbj
eQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NW_n<^]HComkK
gP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgTcoS;[F1?oooom>ohbj
eQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NBon<^]H01?oo
ooooS;[Fohbje_n<^]H2ooooodgoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmhNohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F0_ooool0
0on<^]Koooooooooo`02ohbjePCooooo0_n<^]H2ooooo`;oS;[F0_ooool3ohbjeP;ooooo1?n<^]H5
ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`KoS;[F0_ooool4ohbjePCooooo0_n<
^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_oo
ool2ohbjeP;ooooo7on<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/2omkKgQkoS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F
0oooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`?oS;[F
0_ooool3ohbjeP;ooooo0_n<^]H2ooooo`04ohbje_ooooooooooohbjeP?ooooo00?oS;[Foooooooo
ool01_n<^]H2ooooo`?oS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03
ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_oooolOohbjeQ?o
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N7_n<^]H2ooooo`03
ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Foooooooo
ool01_n<^]H4ooooo`CoS;[F0_ooool3ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;o
S;[F0_ooool00on<^]Koooooooooo`06ohbjeP;ooooo0on<^]H2ooooo`GoS;[F0_ooool2ohbjeP;o
oooo0_n<^]H4ooooobcoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmhNohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;o
S;[F0_ooool00on<^]Koooooooooo`04ooooo`?oS;[F0_ooool5ohbjeP;ooooo1?n<^]H2ooooo`04
ohbje_ooooooooooohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00Cooooo0_n<^]H2oooo
o`?oS;[F1_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0on<^]H2ooooobgoS;[F4ooNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhNohbjeP;ooooo00?oS;[Foooo
ooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbj
eP;ooooo0_n<^]H4ooooo`CoS;[F0_ooool5ohbjePCooooo00?oS;[Fooooooooool00_n<^]H2oooo
o`03ohbje_oooooooooo00?oS;[F0_ooool00on<^]Koooooooooo`03ohbjeP;ooooo0_n<^]H2oooo
o`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjePCooooo;?n<^]HComkKgP03of=UNooooooooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQkoS;[F0_ooool01On<^]Kooooooooooooooooo
S;[F00;ooooo00CoS;[FooooooooooooS;[F0oooool00on<^]Koooooooooo`02ohbjeP;ooooo00?o
S;[Fooooooooool00_n<^]H2ooooo`?oS;[F0_ooool3ohbjeP04oooooon<^]KoS;[FohbjeP;ooooo
00CoS;[FooooooooooooS;[F0oooool00on<^]Koooooooooo`03ohbjeP;ooooo00?oS;[Foooooooo
ool00on<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Foooooooo
ool00_n<^]H2ooooob_oS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmhNohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool3ohbjeP;ooooo00?oS;[Foooo
ooooool00_n<^]H4ooooo`;oS;[F0_ooool2ohbjeP;ooooo0on<^]H2ooooo`CoS;[F1?ooool3ohbj
eP;ooooo00CoS;[FooooooooooooS;[F0_ooool3ohbjeP;ooooo00?oS;[Fooooooooool00_ooool2
ohbjePCooooo00?oS;[Fooooooooool00_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_oo
ool[ohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N7_n<
^]H2ooooo`coS;[F0_oooolAohbjeP;ooooo4On<^]H2ooooo`?oS;[F0_ooool=ohbjeP;ooooo=_n<
^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQkoS;[F0_oo
ool<ohbjeP;ooooo3on<^]H6ooooo`ooS;[F1_ooool?ohbjePGooooo<_n<^]HComkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjNohbjeQ?og]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmjNohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_NW_n<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/2omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oN
fmjNohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NW_n<
^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooN
fmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh^ohbjeP;ooooo1?n<
^]H3oooooa?oS;[F1?oooom@ohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo
[JZmof=UN`;og]_N;_n<^]H2ooooo`KoS;[F0_oooolAohbjeP04oooooon<^]KoS;[FohbjeP;ooooo
Con<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgR7oS;[F
1?ooool3ohbjePCooooo0_n<^]H2ooooo`03ohbje_oooooooooo00?oS;[F0oooool4ohbjeP;ooooo
1?n<^]H5ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`KoS;[F0_ooool4ohbjePCo
oooo0_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`;o
S;[F0_ooool2ohbjeP;ooooo8On<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgR3oS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`05
ohbje_oooooooooooooooon<^]H00_ooool2ohbjeP?ooooo1?n<^]H2ooooo`?oS;[F0_ooool2ohbj
eP;ooooo00CoS;[FooooooooooooS;[F0oooool00on<^]Koooooooooo`06ohbjeP;ooooo0on<^]H2
ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2
ooooo`;oS;[F0_ooool2ohbjeP;ooooo0_n<^]H2ooooob7oS;[F4ooNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhOohbjeP;ooooo1_n<^]H2ooooo`;oS;[F0_ooool0
0on<^]Koooooooooo`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool3ohbjeP;ooooo0on<
^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool01_n<
^]H2ooooo`?oS;[F0_ooool5ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F1?ooool^ohbjeQ?og]_N00?o
HfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N7on<^]H2ooooo`KoS;[F0_oo
ool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo
0on<^]H2ooooo`CoS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool00on<^]Ko
ooooooooo`04ooooo`;oS;[F0_ooool3ohbjePKooooo00?oS;[Fooooooooool00_n<^]H2ooooo`?o
S;[F0_ooool_ohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_N7on<^]H2ooooo`KoS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`04
ohbje_ooooooooooohbjeP;ooooo0on<^]H2ooooo`GoS;[F1?ooool00on<^]Koooooooooo`02ohbj
eP;ooooo00?oS;[Fooooooooool00on<^]H2ooooo`03ohbje_oooooooooo00?oS;[F0_ooool2ohbj
eP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F1?ooool^ohbjeQ?og]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N7on<^]H2ooooo`KoS;[F0_ooool2ohbj
eP;ooooo00GoS;[FooooooooooooooooohbjeP04ooooo`?oS;[F0_ooool2ohbjeP;ooooo0on<^]H0
1?ooooooS;[Fohbje_n<^]H2ooooo`04ohbje_ooooooooooohbjeP?ooooo00?oS;[Fooooooooool0
0on<^]H2ooooo`03ohbje_oooooooooo00?oS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool0
0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool]ohbjeQ?og]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N7on<^]H2ooooo`OoS;[F1?ooool2ohbjeP;ooooo
00CoS;[FooooooooooooS;[F0_ooool3ohbjeP;ooooo0_n<^]H2ooooo`CoS;[F1?ooool3ohbjeP;o
oooo00CoS;[FooooooooooooS;[F0_ooool3ohbjeP;ooooo00?oS;[Fooooooooool00_ooool2ohbj
ePCooooo00?oS;[Fooooooooool00_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_ooool]
ohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N8?n<^]H2
ooooo`;oS;[F0_oooolGohbjeP;ooooo4On<^]H2ooooo`?oS;[F0_ooool=ohbjeP;ooooo>?n<^]HC
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgR7oS;[F1?oooolF
ohbjePKooooo3on<^]H6ooooo`ooS;[F1OooooldohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmjNohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`;og]_NW_n<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2
omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjN
ohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NW_n<^]HC
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjNohbjeQ?og]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgV_oS;[F1?ooool_ohbjeQ?og]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NJ_n<^]H01?ooooooS;[Fohbje_n<
^]H2ooooobkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oN
fmhWohbjePCooooo0_n<^]H2ooooo`;oS;[F1?ooool3ohbjePGooooo00?oS;[Fooooooooool01on<
^]H4ooooo`?oS;[F1?ooool2ohbjeP;ooooo00?oS;[Fooooooooool01On<^]H2ooooo`CoS;[F1Ooo
ool2ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H4ooooobSoS;[F4ooNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhVohbjeP;ooooo0_n<^]H2ooooo`04ohbje_oo
ooooooooohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Kooooo
ooooo`06ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool01?n<^]Kooooo
oooooon<^]H2ooooo`GoS;[F0_ooool3ohbjeP;ooooo0_n<^]H2ooooo`04ohbje_ooooooooooohbj
eP?ooooo00?oS;[Fooooooooool00_n<^]H2ooooobOoS;[F4ooNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk0_oNfmhUohbjeP;ooooo1_n<^]H2ooooo`03ohbje_oooooooooo
00GoS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool01On<^]H2ooooo`KoS;[F0_ooool5ohbj
eP;ooooo00?oS;[Fooooooooool01On<^]H2ooooo`?oS;[F0_ooool2ohbjeP;ooooo00?oS;[Foooo
ooooool00_n<^]H2ooooo`CoS;[F0ooooolWohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`;og]_N9On<^]H2ooooo`KoS;[F0_ooool00on<^]Koooooooooo`04oooo
o`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`GoS;[F0_ooool6ohbjePKooooo00CoS;[F
ooooooooooooS;[F0_ooool5ohbjeP;ooooo1?n<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo
0_n<^]H2ooooo`;oS;[F1?oooolXohbjeQ?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_N9On<^]H2ooooo`KoS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo
0on<^]H4ooooo`03ohbje_oooooooooo00GoS;[F0_ooool6ohbjeP;ooooo0_n<^]H2ooooo`04ohbj
e_ooooooooooohbjeP;ooooo1On<^]H2ooooo`GoS;[F1?ooool00on<^]Koooooooooo`02ohbjeP;o
oooo00CoS;[Foooooooooooooooo:_n<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgRGoS;[F0_ooool6ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2oooo
o`03ohbje_ooooooS;[F00;oS;[F0_ooool00on<^]Koooooooooo`05ohbjeP;ooooo1_n<^]H2oooo
o`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`GoS;[F0_ooool3ohbjeP04oooooon<^]Ko
S;[FohbjeP;ooooo00CoS;[FooooooooooooS;[F0oooool00on<^]Koooooooooo`02ohbjeP;ooooo
9on<^]HComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgRGoS;[F
0_ooool6ohbjeP;ooooo0_n<^]H4ooooo`?oS;[F1?ooool2ohbjePCooooo0on<^]H2ooooo`OoS;[F
1?ooool2ohbjeP;ooooo00?oS;[Fooooooooool01On<^]H2ooooo`CoS;[F1?ooool3ohbjeP;ooooo
00?oS;[Fooooooooool00_n<^]H4ooooobSoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmhVohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo01OoS;[F
0_ooool2ohbjeP;ooooo2?n<^]H2ooooo`03ohbje_oooooooooo00GoS;[F0_oooolnohbjeQ?og]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N9on<^]H4ooooo`;oS;[F
0_oooolHohbjePCooooo2On<^]H2ooooo`03ohbje_oooooooooo00?oS;[F1_oooollohbjeQ?og]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjNohbjeQ?og]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NW_n<^]HComkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoS;[F4ooNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjNoe:F]A?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NW_mBU[DComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgYkoDYJe4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjNoe:F]A?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
W_mBU[DComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoDYJe
4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjNoe:F]A?og]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NM?mBU[D4ooooobKoDYJe
4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmicoe:F]@04oooo
oomBU[GoDYJeoe:F]@;ooooo9OmBU[DComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgPOoDYJe0_ooool2oe:F]@03oooooomBU[GoDYJe00;ooooo0_mBU[D5ooooo`03
oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@Cooooo1?mBU[D6ooooo`;oDYJe0_ooool4oe:F]@Co
oooo0omBU[D2ooooo`?oDYJe0_ooool3oe:F]@Cooooo0omBU[D4ooooo`;oDYJe0_ooool5oe:F]@Co
oooo0omBU[D5ooooo`;oDYJe0_ooool2oe:F]@Cooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;o
DYJe1?ooool2oe:F]@;ooooo0omBU[D2ooooo`;oDYJe1?ooool3oe:F]@Cooooo2OmBU[DComkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPOoDYJe0_ooool01OmBU[Go
ooooooooooooooooDYJe00;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0omBU[D2ooooo`?oDYJe0_ooool00omB
U[Goooooooooo`03oe:F]@;ooooo0_mBU[D2ooooo`;oDYJe0oooool01?mBU[Goooooooooooooool2
oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`04
oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02
oe:F]@;ooooo0_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@?ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?o
DYJeooooooooool00_mBU[D2ooooo`SoDYJe4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEk
oooooon]Z[goHfEk0_oNfmh7oe:F]@;ooooo00GoDYJeoooooooooooooooooe:F]@02ooooo`03oe:F
]Ooooooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe0_ooool7oe:F]@;o
oooo0omBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool2oe:F]@;ooooo0_mBU[D3ooooo`04
oe:F]Oooooooooooooooo`GoDYJe0oooool00omBU[Goooooooooo`05oe:F]@;ooooo0omBU[D2oooo
o`KoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`GoDYJe0_ooool2oe:F
]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool00omB
U[Goooooooooo`08oe:F]@?ooooo2?mBU[DComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgPOoDYJe0_ooool01OmBU[Gooooooe:F]OooooooDYJe00;ooooo0_mBU[D2
ooooo`04oe:F]Ooooooooooooe:F]@Gooooo0_mBU[D6ooooo`?oDYJe0_ooool3oe:F]@;ooooo00?o
DYJeooooooooool00omBU[D2ooooo`;oDYJe0_ooool02?mBU[GooooooooooomBU[Gooooooe:F]Ooo
ooooDYJe0_ooool2oe:F]@Cooooo0_mBU[D6ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool7oe:F
]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@Kooooo00?oDYJeooooooooool00_mBU[D2
ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`03oe:F]@;ooooo00?oDYJe
ooooooooool01?ooool2oe:F]@Cooooo2OmBU[DComkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgPOoDYJe0_ooool01OmBU[Gooooooe:F]OooooooDYJe00;ooooo0omB
U[D4ooooo`03oe:F]Ooooooooooo00;ooooo0omBU[D2ooooo`;oDYJe0_ooool3oe:F]@Kooooo0_mB
U[D2ooooo`?oDYJe0_ooool2oe:F]@;ooooo00CoDYJeooooooooooooDYJe0oooool01?mBU[Gooooo
oooooomBU[D3ooooo`CoDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00omBU[D2ooooo`So
DYJe1?ooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;o
DYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00omBU[D2ooooo`03
oe:F]Ooooooooooo00;oDYJe0_ooool01?mBU[Goooooooooooooool;oe:F]A?og]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N1omBU[D4ooooo`03oe:F]Ooooooooooo
00;ooooo00?oDYJeoooooomBU[D00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2
ooooo`;oDYJe0_ooool3oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool2
oe:F]@;ooooo00CoDYJeooooooooooooDYJe0oooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe
0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00omBU[D2ooooo`KoDYJe
00Cooooooe:F]OmBU[GoDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2ooooo`04
oe:F]Ooooooooooooe:F]@?ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo
00?oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooo
o`SoDYJe4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh7oe:F
]@Cooooo00?oDYJeooooooooool00_ooool2oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe0_ooool2oe:F
]@Cooooo1?mBU[D2ooooo`?oDYJe0_ooool00omBU[Goooooooooo`02ooooo`;oDYJe1?ooool2oe:F
]@;ooooo0_mBU[D00oooooooDYJeoe:F]@02ooooo`;oDYJe1?ooool3oe:F]@Cooooo0_mBU[D4oooo
o`03oe:F]Ooooooooooo00OoDYJe1?ooool00omBU[Goooooooooo`02ooooo`;oDYJe1?ooool3oe:F
]@;ooooo00?oDYJeooooooooool00_mBU[D4ooooo`;oDYJe1?ooool00omBU[Goooooooooo`02oe:F
]@Cooooo0omBU[D4ooooo`WoDYJe4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmh7oe:F]@?ooooo0omBU[D3ooooo`SoDYJe0_ooool>oe:F]@;ooooo0omBU[D2oooo
ob_oDYJe0_ooool2oe:F]@;ooooo2?mBU[D2ooooocCoDYJe4ooNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk0_oNfmh7oe:F]@?ooooo0omBU[D3ooooo`SoDYJe0_ooool>oe:F
]@Kooooo;OmBU[D4ooooo`[oDYJe00?ooooooe:F]OmBU[D06_mBU[D2oooooaKoDYJe4ooNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjNoe:F]A?og]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NW_mBU[DComkKgP03of=UNooooooooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYkoDYJe4ooNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk0_oNfmjNoe:F]A?og]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`;og]_NW_mBU[DComkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/2omkKgYkoDYJe4ooNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmjNoe:F]A?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
Nk?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UNk?og]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UNk?og]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UNk?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
Nk?og]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NZol00004omkK
gP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgZ_o056<1?oNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmj[o`1AS0Cog]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NZol0DH`4omkKgP03of=UNooooooooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgZ_o056<1?oNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk1?oNfmj[o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`Cog]_NZol0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/4omkKgZ_o056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk1?oNfmj[o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`Cog]_NZol0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkK
gXWo056<7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`Cog]_NROl0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk1?oNfmj9o`1AS1coDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_o
ooooojfZ_OmSIG/4omkKgXWo056<7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`Cog]_NROl0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk1?oNfmj9o`1AS1coDYJe1_l0DH`4omkKgP03of=UNooooooooooo
007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgUGo056<1Oooool_o`1AS1coDYJe1_l0DH`4omkK
gP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgUCo056<1oooool^o`1A
S1coDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkK
gUCo056<0_ooool3o`1AS0;ooooo;_l0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1AS0;ooooo0ol0DH`01?oooooo056<o`1AS?l0DH`2
ooooo`?o056<0oooool01?l0DHcoooooooooool0DH`2ooooo`;o056<0_ooool4o`1AS0Cooooo2?l0
DH`4ooooo`Go056<0oooool00ol0DHcoooooooooo`02o`1AS0?ooooo0ol0DH`4ooooo`Go056<0_oo
ool00ol0DHcoooooooooo`04o`1AS0?ooooo1?l0DH`2ooooo`Co056<0_ooool4o`1AS0Cooooo1?l0
DH`4ooooo`_o056<3?mBU[D2ooooo`koDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/4omkKgP_o056<0_ooool2o`1AS0?ooooo0_l0DH`2ooooo`;o056<1_oo
ool2o`1AS0;ooooo0_l0DH`2ooooo`?o056<1_ooool6o`1AS0Kooooo0ol0DH`6ooooo`;o056<1?oo
ool2o`1AS0Kooooo0ol0DH`6ooooo`?o056<1Oooool3o`1AS0;ooooo1?l0DH`2ooooo`?o056<1_oo
ool2o`1AS0Kooooo2_l0DH`<oe:F]@;ooooo3_mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`2ooooo`;o056<0oooool2o`1AS0;ooooo0_l0
DH`2ooooo`;o056<0_ooool2o`1AS0;ooooo00?o056<ooooooooool00ol0DH`2ooooo`[o056<0ooo
ool2o`1AS0?ooooo0_l0DH`2ooooo`;o056<0_ooool2o`1AS0;ooooo0ol0DH`2ooooo`Oo056<0ooo
ool01?l0DHcoooooooooooooool2o`1AS0?ooooo00Co056<oooooooooooooooo0_l0DH`2ooooo`Co
056<0_ooool2o`1AS0;ooooo2ol0DH`2ooooo`[o056<7?mBU[D6o`1AS0Cog]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`2ooooo`;o056<00?oooooo`1AS?oo
ool00_l0DH`2ooooo`?o056<0_ooool00ol0DHcoooooooooo`02o`1AS0Gooooo0ol0DH`7ooooo`Go
056<0_ooool4o`1AS003ooooool0DHco056<00;o056<0_ooool00ol0DHcoooooooooo`02o`1AS0;o
oooo0ol0DH`7ooooo`;o056<0_ooool3o`1AS0;ooooo0_l0DH`2ooooo`?o056<0_ooool2o`1AS0;o
oooo1?l0DH`2ooooo`;o056<1oooool3o`1AS0Gooooo2_l0DH`<oe:F]@;ooooo3_mBU[D6o`1AS0Co
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`2ooooo`04
o`1AS?ooooooooooo`1AS0;ooooo00?o056<ooooooooool01?l0DH`4ooooo`;o056<1?ooool4o`1A
S0Oooooo1Ol0DH`2ooooo`[o056<1?ooool2o`1AS0;ooooo0ol0DH`7ooooo`;o056<0_ooool3o`1A
S0;ooooo0_l0DH`2ooooo`?o056<0_ooool2o`1AS0;ooooo1?l0DH`2ooooo`;o056<1oooool2o`1A
S0Gooooo2ol0DH`<oe:F]@;ooooo3_mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004
of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`2ooooo`04o`1AS?ooooooooooo`1AS0;ooooo00?o056<
ooooooooool01_l0DH`2ooooo`;o056<1?ooool4o`1AS0;ooooo0ol0DH`2ooooo`Go056<0_ooool<
o`1AS0;ooooo0_l0DH`2ooooo`?o056<0_ooool3o`1AS0;ooooo0_l0DH`3ooooo`04o`1AS?oooooo
ooooooooo`;o056<0oooool01?l0DHcoooooooooooooool2o`1AS0?ooooo0ol0DH`2ooooo`;o056<
0_ooool3o`1AS0;ooooo0_l0DH`2ooooo`ko056<3OmBU[D2ooooo`goDYJe1_l0DH`4omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP_o056<0_ooool00ol0DHcooooo
o`1AS002o`1AS004ooooool0DHcoooooooooo`;o056<1_ooool2o`1AS0;ooooo00?o056<oooooooo
ool01?l0DH`5ooooo`Ko056<0_ooool4o`1AS004ooooool0DHco056<o`1AS0Kooooo00?o056<oooo
ooooool00oooool2o`1AS0Gooooo1?l0DH`6ooooo`?o056<1Oooool3o`1AS0Gooooo00?o056<oooo
ooooool00ol0DH`5ooooo`?o056<1_ooool:o`1AS0koDYJe0_ooool<oe:F]@Ko056<1?oNfmh00omS
IG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1AS0Cooooo0ol0DH`4oooo
o`?o056<1?ooool3o`1AS0;ooooo0_l0DH`2ooooo`Co056<0oooool7o`1AS0?ooooo0_l0DH`3oooo
o`?o056<1?ooool2o`1AS0Gooooo0ol0DH`3ooooo`Ko056<0_ooool00ol0DHcoooooooooo`04o`1A
S0?ooooo1?l0DH`2ooooo`04o`1AS?ooooooooooo`1AS0;ooooo1?l0DH`3ooooo`Go056<1?ooool;
o`1AS0[oDYJe0_ooool2oe:F]@;ooooo3?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`4ooooo`?o056<1?ooool:o`1AS0;ooooo4ol0DH`6
ooooo`_o056<0_oooom1o`1AS0_oDYJe1?ooool=oe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1AS0?ooooo1Ol0DH`3ooooo`[o056<0_oooolD
o`1AS0Cooooo3Ol0DH`00ooooooo056<o`1AS00Ro`1AS0;ooooo6ol0DH`Loe:F]@Ko056<1?oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmj9o`1AS1coDYJe1_l0DH`4
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgXWo056<7?mBU[D6
o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NROl0DH`L
oe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmj9
o`1AS1coDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgXWo056<7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`Cog]_NROl0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmj[o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`Cog]_NZol0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgZ_o056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmj[
o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NZol0DH`4
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgZ_o056<1?oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmj[o`1AS0Cog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NZol0DH`4omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgZ_o056<1?oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmj[o`0000Cog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`Cog]_NZol00004omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000004ko0000G_oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`00001>o`0005kog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l00000C_l0001N
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So
000000oo000000?o8B0Qod91@_l@41003ol00002oc4`<@oo00000_la<345o`0000;o<C0a1ol00002
ob4P8@[o0000G_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh0
0ol0003o20P8o`000004o`000003oibNW?ooooooLg5c00Co00000_ooool00ol@413oLg5cooooo`02
ooooo`08ohb>S?l0003o410@oooooonm_[go0000okfn_Oooool2o`000005omkOg_oooooo0000oa0@
4?o>clh00_ooool01_oNgmkoDU5Bo`000?mcLG?ooooood91@P?o000000Ko410@oooooola<37o0000
oa0@4?o>clh2ooooo`05omkOg_la<37o0000oa0@4?o>clh00_ooool02_oNgmko<C0ao`000?mBDE;o
g]oNo`000?mcLG?oooooomkOg_nLWY`9o`0005kog]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l000001?l000001?lQ827okno_ono_kol@4102o`00
0004oc4`<Ooooooog]oNo`0000;ooooo01WoHf5Sojf^[OooooooHf5So`000?oNgmkokno_o`000?nL
WYcooooood91@_l0003o_KjmoooooolQ827oW9jLoooooon][ZgoLg5cono_kooooooo@T52of=QHooo
ooooLg5c00Co000001Wokno_oe9AD_l0003oW9jLolk?c_l@413o0000og=aLoo_knoo8B0QoibNW?o>
clko410@o`000?mcLG?okno_ob4P8Ola<37oooooo`000?m2@D;o<C0ao`000?o>clkoHf5S00So0000
G_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8
o`000005o`000003og=aLooooooooooo00Cooooo01goW9jLo`000?ooooooc/o>o`000?lQ827ooooo
okfn_Ol0003o_Kjmooooool@413oLg5coooooomSHF?o0000og=aLooooooo@T52okfn_Ooooooo8B0Q
o`000?la<37oooooojf^[Om2@D;ooooooibNW004o`000005okfn_OmcLG?o0000okfn_OmcLG<00ol0
0002oibNW003okfn_OmcLG?o000000;o00000_nLWY`00ol0003ooooooc4`<@02o`000003of=QHoo_
knooHf5S00So0000G_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oN
fmh00ol0003o20P8o`000005o`00000;oa0@4?o_knooooooolk?c_nm_[gokno_oooooomcLG?o0000
olk?c_ooool00_l00002ono_k`03o`000?n<SXcooooo00;o@T5200Woooooog=aLol0003oHf5Soooo
oomcLG?o[Jj]oooooolQ82400_l00002ooooo`03o`000?ooooooc/o>00Co000000GoS8j<oibNW?l0
003oW9jLohb>S003o`000004og=aLonm_[goW9jLohb>S0?o000000WoLg5cokfn_Ol0003oc/o>oe9A
D_l0003o_Kjmono_komcLG<02Ol0001NomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/4omkKgP03o`000?l820So000000Ko000003ooLg5coooooomcLG?o0000okfn_Ooooooo
@T52o`000?n][Zgooooooc4`<Ol0003o_Kjmooooool0003oW9jLoooooon<SXco8B0QoooooooNgmko
410@oe9AD_ooooooLg5coe9AD_ooooooc/o>oa0@4?m2@D;oooooono_kol0003og]oNoooooomSHF?o
0000oa0@4?l0003oLg5cokfn_Ol0003o<C0aoooooomSHF?o0000oa0@4?o>clkoW9jLoc4`<Ooooooo
Hf5So`000?l@413oc/o>oibNW?l0003o[Jj]og=aLol0003oooooob4P8Ol@41002Ol0001NomkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000000Oo
000000Gog]oNono_kol0003okno_ooooo`02o`000008og=aLooooooo@T52o`000?nLWYcooooood91
@_oNgmh2ooooo`04okfn_Oooooooooooono_k`;ooooo00?oLg5co`000?nLWY`01?ooool00omcLG?o
0000okfn_@03ooooo`04of=QHol0003o@T52ooooo`;o000000SoDU5BomkOg_oNgmkoooooolk?c_lQ
827o0000oe9ADP;og]oN00_oooooolk?c_lQ827o0000og=aLon][Zgo0000ohb>S?oNgmkokno_od91
@P08o`0005kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o
0000o`P82?l000001ol000001OmSHF?oooooog=aLoooooooc/o>00;o000000ko@T52og=aLom2@D;o
0000od91@_mcLG?o8B0Qof=QHooooooog]oNof=QHoo>clkooooood91@P;oLg5c0ol000001?m2@D;o
Lg5cog=aLom2@D82o`000009oe9AD_mcLG?o@T52og=aLom2@D;o0000ob4P8Ooooooo8B0Q00?o0000
0_m2@D85o`0000;o@T520ol000001?mSHF?o_Kjmo`000?l00002oc4`<@Wo0000G_oNfmh00omSIG_o
ooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`000008o`000004
omkOg_ooooooooooohb>S0[o000000KoooooomkOg_l0003o[Jj]oooooola<34Bo`000003oooooom2
@D;o000000ko000000?o@T52ooooool000003?l0001NomkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000000So000000Co@T52ooooooooooooHf5S
2_l000001_mSHF?oLg5co`000?mcLG?ooooooe9ADQ3o00000_m2@D801?o>clkoS8j<od91@_la<34>
o`000003oooooolQ827o000000_o0000G_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmh00ol0003o20P8o`000009o`000003okfn_Ooooooo<C0a00go000000?oDU5B
oooooomcLG<04?l00005okfn_@03ojf^[Ol0003o000000co000000?og]oNod91@_l000002_l00000
0olH61Sog]_NomkKgP1LomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgP03oaPH6?l0003o000001Wo000000?o@T52oooooonLWY`09?l000000onm_[goLg5co`00000:
o`000003oaPH6?oNfmkog]_N05cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`Cog]_N00?o61PHo`000?l00000@?l000000ola<37o8B0Qo`00000:o`000003oaPH6?oNfmko
g]_N05cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?oFUUJ
o`000?l00000COl000000omJFE[og]_NomkKgP1LomkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/4omkKgP03ojf^[Om:BD[o000004co000000?oBTU:ojf^[OoNfmh0GOoNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh01?oWinOo[Jj]oeYIF_lQ
8243oa0@40Oo00006?l@410Oo`000003o`P82?l@413o410@00?o410@00Ko20P8oa0@4?lQ827oFUUJ
ojf^[OoWinMNomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^comkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^comkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG^comkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG^comkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^comkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^comkKgP03of=UNooooooooooo007o
HfEk00000om[KHcog]oWokFbcP2eohb:Y@7ooo_o0Oo6bmH1og=aU00000?oHff<omkOiooNgnL0]OoN
fmh1oooko`7oa/_F0OmcLI@00003of=]S?oNfnOooooo0;Gooooo0Ooonol1olK;eP7oLg6D00000omS
KHcoe]OWoooko`2UooOgo`03oibN[OnLED;oYDe200SoYDe200OoW5E2oibN[OogmooomoOooookooog
moooa/_F007oLg6D00000omSKHcoe]?NooOcm`2Uono_m`03okEEB_ooTYCooj:U00OooijL00?ooj:U
oonBU?neEDX01?o_koL1olK;eP7oLg6D00001?mSKHcoc/oNonO[kooWinl3onOSk`03onOWkooWhnoo
inO_00CoinO_00?oin?_onOWkooWhnl00ooWhnl5onOWk`06onOSkooWinooinO_onOSkooWinooin?_
0_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl0
0_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl0
0_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl0
0_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl0
0_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl0
0_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl0
0_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl0
0_oWinl00ooWhnooinO_onOSk`02onOWk`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl0
1?oWinl00ooWhnooinO_onOSk`03onOSk`GoinO_00Coin?_onOWkooNIF?ookJe2Ooo[Zd00ooo][Go
gVESonOWk`03onOWk`7oa/_F0OmcLI@00003of=]S?o>cmkog]oW0:Gog]_W00?ogVESoonb]OooZZD0
0_ooool3oonZY@;ooooo00?oojZUoonb]OoNIF<00_oNfnL2omkOi`7oa/_F0OmcLI@00003of=]S?o>
bmkoe]ON00;oe]?N00?oe]ONomKCg_oFdmh0X?oFdmh00ooNIF?ook:eoonZY@03ooooo`07oon^YOoo
ooooooooooooooooZZGook:eomiUH`02omKCgP03omKGg_oFenOoa/_F007oLg6D00000omSKHcoa/_F
olk?gP03olk?eP04olk?g_o>bmkoc/oFolk?ePCoc/oN00Woc/oFolk?g_o>cmKoc/_Nolk?e_o>bmKo
c/oFolk?g_o>bmH00oo>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?o
c/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?o
c/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?o
c/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?o
c/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?o
c/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?o
c/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?o
c/_Folk?e_o>cmH00_o>cmH00oo>bmKoc/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?o
c/_Folk?e_o>cmH00_o>cmH01?o>bmKoc/oFolk?e_o>cmH5olk?gP09olk?e_o>cmkoc/oFolk;g_o>
cmKoc/_Folk?e_o>cmkoc/_F00?oc/oF00?oc/_FomiUHooo/Zd00_ooZZD5ooooo`;oojJL00?oojj]
omiUHoo>cmh00_o>cmh1olkCgP7oa/_F0OmcLI@00003of=]S?o6amKoa/OF0:Goa/OF00?ogVEJoonZ
YOooXY`00_ooXY`3ooooo`;ooijD00?ooiZDoonVW?oNIEX00oo6amH1olk;gP7o_L?F0OmcLI@00003
of=]S?o6amKo_L?>0:Go_L?>00CogVEJoonVW?ooVYCooiZD1Oooool2oonBS003oonNW?oNIE[o_L?>
00;o_L?>0Oo6amH1okFfcP7oLg6D00000omSKHcoa/OFokfjcP2UokfjcP03omiUHoooWYcooi:<00?o
oooo00Ooohj<ooooooooooooooooooN:Q?ooUYCogVES00?o_K[>0Oo6`mH1ojfZ_@7oLg6D00000omS
KHcoa/OFokFfaP0DokFfcP03okFfa_ne]/ko]KK600Co]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one
]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one
]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one
]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one
]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one
]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one
]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one
]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one
]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko]KK>013o]KK>00Oo]KK6okFfc_ne]/Ko]KK>omiUHooo
UYComhJ400;ooooo0oogRX@2ooooo`03onn6Q?ooUYCogVES00?o]KK>0Onm_/h1oibN]@7oLg6D0000
0omSKHcoa/OFojfbaP2UokFbcP03omiYHoooUYCokh:400OokhJ400?okh:4oonFU?oNIF<00one//h1
okfncP7oU9:]0OmcLI@00003of=]S?o6`mKo[J[60:Go[Jk600?ocVUJoonJU?ooUY@02?ooUY@00ooo
VYcocVUJojf^aP02ojf^aP7o]KK>0On<RZD1og=aU00000?oHff<olK3e_nUX[d0YOnUY[d00onLWZgo
cVEJomiYH`07omiUH`03omiYHoo>IF?oW9j]00;oYJJm00?oYJ:mokF^c_n<RZD00OmcLI@00003of=]
S?o6`mKoYJ:m0;CoYJJm00?oYJ:mokF^c_n<RZD00OmcLI@00003of=]S?o6`mKoYJ:m0;CoYJJm00?o
YJ:mokF^c_n<RZD00OmcLI@00003of=]S?o6`mKoYJ:m0;CoYJJm00?oYJ:mokF^c_n<RZD00OmcLI@0
0003of=]S?o6`mKoYJ:m0;GoYJJm0One//h1ohb:Y@7oLg6D00000omSKHcoinO_omkOk`2eomkOk`7o
inOg0On<RZD1og=aU000^_mSKH`1og=aU000\
\>"], "ListGraphic",
 Evaluatable->False,
 ImageSize->{187, 234},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"MakeCategoriesIntro", "i:84"}]
}, Open  ]],

Cell[TextData[{
 "To see details of how a browser categories file works, see ",
 ButtonBox["Creating a Browser Categories File",
  ButtonData:>"Creating a Browser Categories File",
  ButtonStyle->"AddOnsLinkText"],
 ". However, in most cases, you can use the Make Categories palette to \
generate such a file without having to know the details of its structure."
}], "Text",
 CellTags->{"MakeCategoriesIntro", "i:84"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outline Format", "Subsubsection",
 CellTags->{"Outline Format", "i:85"}],

Cell[TextData[{
 "When generating a browser categories file, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that the source notebook is in strict outline format. This means \
that all cells in the notebook are arranged in a consistent hierarchical \
order."
}], "Text",
 CellTags->{"Outline Format", "i:85"}],

Cell["\<\
Consider a notebook composed entirely of section, subsection, and text cells. \
If every text cell is contained in a subsection cell and every subsection \
cell is contained in a section cell, as shown here, the notebook is said to \
be in strict outline format.\
\>", "Text",
 CellTags->{"Outline Format", "i:85"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007g00017b000`400?l00000o`00003ooomVIWkh
ofIVOP0000?oIVInoo_loOoko?d0oooko?gdoo_lo@7oIVIn00000omVIWkonocmojRY^`3oojRY^o?o
Z:Vk0Ooko?d1ofIVOP0000?oIVInoo_loOnXZK/0oomVIWkbofIVOP7oZ:Vk0Ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInV?oooolgon3Oh`03onc]m?n;S9WoWIj[00coWIj[00CoRX^Ion?VkOo^kNGo
^KZnP?nMWZ/00onm_Kook^gUonGVkP1XonGVkP03onc]m?n;S9WoWIj[00coWIj[00?oRX^Ion?VkOoP
gn<04?oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03
oooooooPgn?oh=oS03Goh=oS00?oU9FRomgNhOoIf^@03?oIf^@01?oMg^7oU9FRoiBEX_oJfmj0olO8
eP03om[Kg_nQXZkono_n06Sono_n00?oU9FRomgNhOoIf^@03?oIf^@00ooMg^7oU9FRon3Oh`05on3O
h`;ooooo0_oPgn<2ooooo`;oh=oS0_ooool01?oPgn?oIVInojRY^ooko?d1ofIVOP0000GoIVInoo_l
oOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS03Goh=oS00?oU9FRooooooo;c=X03?o;c=X0
1?ooooooU9FRoiBEX_oooon0olg>g003oooooonDUJ;ono_n06Sono_n00?oU9FRooooooo;c=X03?o;
c=X00oooooooU9FRon3Oh`04on3Oh`0?okRdXonh]J7oooooon3Ohonh]:?o^;FQoooooooPgn?o^;BS
okReXOooooooh=oSofIVO_nXZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS
00?oooooon3OhooPgn<0=OoPgn<00onDUJ;ooooool_<fP0<ol_<fP04oooooonDUJ;oU9FRoooooh3o
c<gK00?ooooooiBEX_oknoh0J?oknoh00onDUJ;ooooool_<fP0<ol_<fP03oooooonDUJ;oh=oS00Co
h=oS00Ko^;BSokRdXOoPgn?oh=oSokRdXonh]:42on3Oh`07okRdXonh]:7oh=oSon3OhomVIWkoZ:Vk
oo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS00?oh=oS
0ol00003on3Oh`?o00000ooPgn<3o`0000Goh=oS00Co0000on3OhooPgn?oh=oS0_l0000Hon3Oh`03
oiBEX_ooooooblcJ00GoblcJ00?o?cdmol_<f_o;c=X01?o;c=X01oooooooU9FRoiBEX_ooooooc/oM
olk?g?o>d=d05?o>cm`:olo?g@_ocloL2_o>d=d:olk?g@[oc/oL2_o>d=dEolk?g0[ocloM2_o?cm`0
1Oo>d=goc/oMolk?gOooooooU9FR06Won_[m00?oU9FRooooooo;c=X01?o;c=X00olo?CgoblcJol_<
fP05ol_<fP03oooooonDUJ;oh=oS013oh=oS00?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?go
Z:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`04on3Oh`05o`000?oPgn?oh=oSon3Ohol00000
0ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o
00000_oPgn<00ol0003oh=oSon3Oh`0Eon3Oh`03oiBEX_ooooooblcJ00CoblcJ0olo?Cd5ol_<fP04
oooooonDUJ;oU9FRooooo`goe=GP5?oDeN4;omGEh@[oe=GQ1ooDeN001on>UJ;oe=GPohjEX_oDeN3o
SYFRomCEh?n>UJ806_oDeN0EomCEh@[oeMGQ0ooDeN400oooooooU9FRooWin`1XooWin`03oiBEX_oo
ooooblcJ00?oblcJ0olo?Cd6ol_<fP03oooooonDUJ;oh=oS00Woh=oS0_ooool2on3Oh`;ooooo00Co
h=oSofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oS
on3Oh`04on3Oh`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03
o`000?oPgn?oh=oS00?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`0Eon3Oh`03
oiBEX_ooooooc<gK00?oc<gK0olo?Cd6olc=f`04oooooonDUJ;oU9FRooooo`;ofm_V00?ofm_Uom_L
iOoKg>D09ooKg>D@om_KiP08oooooon>UJ;oooooohjEX_ooooooSYFRoooooon>UJ86om_KiP[ofm_U
:OoKg>D2om_KiP03om_LiOooooooU9FR06WonOWk00?oU9FRooooooo<cM/01?o<cM/3oclm?@Goc<gK
00?ooooooiBEX_oPgn<02?oPgn<02onh]:?o^;FQoooooooPgn?o^;BSokReXOooooooh=oSofIVO_nX
ZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?oooooon3OhooPgn<01?oP
gn<01Ol0003oh=oSon3OhooPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oS
on3Oh`03on3Oh`03o`000?oPgn?oh=oS00;o00003?oPgn<7o`0000Goh=oS00?oU9FRoooooooAd^00
0_oAd^03oclm?@OodM;P00CooooooiBEX_nDUJ;ooooo0_oKfnH00ooKfnGofmcUom_Li@0Wom_LiA3o
fm_V00SoooooohjEX_ooooooSYFRoooooon>UJ;oooooohjEXPKofm_V2_oKfnDYom_Li@;ofm_V00?o
fmcUoooooonDUJ80JOohn?/00onDUJ;oooooom7Bh005om7Bh0?o?cdm1?oAd^000oooooooU9FRon3O
h`08on3Oh`06okRdXonh]:7oh=oSon3Ohonh]:?o^;BQ0_oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP00
00GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS00Coh=oS00Go0000on3OhooP
gn?oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_l00002on3O
h`03o`000?oPgn?oh=oS00koh=oS1Ol00006on3Oh`04oiBEX_oooooofM[TomWJi0?o?cdm2?oIf^@0
1oooooooU9FRoiBEX_oooooohn?Zon?RjooRh^X02_oShnX:on?RjP[oh^;Z2ooRhnX@on?SjP08oooo
oon>UJ;oooooohjEX_ooooooSYFRoooooon>UJ86on?Rj`[oh^;Z2_oShnX;on?RjP[oh^;Z2_oRhnX0
1OoShn[oh^;[on;SjoooooooU9FR06WomoOi00?oU9FRoooooooIf^@01_oIf^@3oclm?@?ofM[T00?o
oooooiBEX_oPgn<04?oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifM
X@2Fon3Oh`03oooooooPgn?oh=oS00Coh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`03o`00
0?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSo`00000Aon3Oh`?o0000
1ooPgn<00onDUJ;oooooon?Sj`02on?Sj`?o?cdm1ooShn/01oooooooU9FRoiBEX_oooooojNW^onSY
k_oXj>l02_oYjNh:onWXkQGoj>W^2_oXjNl6onWYkP08oooooon>UJ;oooooohjEX_ooooooSYFRoooo
oon>UJ86onSYkP[oj>S_2_oYjNh;onWXkQCoj>W^00Goj>W_onSXk_oXj>kooooooiBEXP1YooCen@03
oiBEX_oooooohn?[00Gohn?[0olo?Cd4on?Sj`03oooooonDUJ;oh=oS00goh=oS0_ooool01?oPgn?o
IVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS
00?oh=oS0_l00003on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oP
gn?o000000;oh=oS00Co0000on3OhooPgn?o00004OoPgn<00ol0003oh=oSon3Oh`06on3Oh`03oiBE
X_ooooook>ca00?ok>ca0olo?Cd6onc/l@07oooooonDUJ;oU9FRoooooooYjNkoj>W^onSXk`0:onWY
kP[ojNS^5OoXjNh:onSYk`KojNW^00SoooooohjEX_ooooooSYFRoooooon>UJ;oooooohjEXPKoj>W^
2_oXj>l:onWYkP_ojNS^5?oXjNh01OoXjNooj>S^onSXk_ooooooU9FR06Wolo?g00?oU9FRooooooo/
k?401?o/k?43oclm?@Gok>ca00?ooooooiBEX_oPgn<03?oPgn<01onh]:?o^;FQoooooooPgn?oIVIn
ojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`04
on3Oh`03o`000?oPgn?oh=oS00;oh=oS0ol00003on3Oh`?o00000ooPgn<2o`0000?oh=oS00?o0000
on3OhooPgn<06?oPgn<00onDUJ;oooooooCdm`04ooCdm`?o?cdm1Oodm?L01?ooooooU9FRoiBEX_oo
oollonc/l@07ooooooo/k?7oooooonc/lOooooook>caooooo`0monc/l@03oooooonDUJ;ol?7f06So
l?7f00?oU9FRooooooodm?L00oodm?L3oclm?@Kom?Cg00?ooooooiBEX_oPgn<03?oPgn<01onh]:?o
^;BQon3OhooPgn?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<0
0oooooooh=oSon3Oh`0eon3Oh`03oiBEX_oooooonocl00Gonocl00?o?cdmoo_lo?oko?`01?oko?`0
1?ooooooU9FRoiBEX_oooon0onc/l@03oooooonDUJ;oko3e06Soko3e00?oU9FRoooooooko?`01?ok
o?`00olo?Cgonocloo_lo005oo_lo003oooooonDUJ;oh=oS013oh=oS00?oIVInojRY^ooko?d00OmV
IWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`0eon3Oh`03oiBEX_oo
oooooooo00gooooo0_nDUJ800ooooooomoOiooOgn@1nooOgn@03oooooonDUJ;ok^od06Sok^od00?o
U9FRooooooooool03Oooool00onDUJ;oh=oSon3Oh`0?on3Oh`03ofIVO_nXZK_onocm007oIVIn0000
1OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?oooooon3OhooPgn<0=OoPgn<00onDUJ;oe]KKoooo
o`0<ooooo`04omKFfonDUJ;oU9FRoo[jnh3ooooo00?on_[koiBEX_o/ko@0J?o/ko@00onDUJ;oe]KK
ooooo`0<ooooo`03omKFfonDUJ;oh=oS013oh=oS00?oIVInojRY^ooko?d00OmVIWh00005ofIVO_ok
o?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`0eon3Oh`04omKKfOn?T9ko]KFnokBd_POo
];Bm00So/kBmokBd_Ond];go/k>mohb=W?oFfmWoeMKIojj_^H3o]kNo00?oYJRfol_>eOo/k_<0J?o/
k_<01?oFfmWoSi2NokFe__nd];h7okBd_@06ok>d_Ond];go];Bmok>c_On<SIcoe]_I4OoPgn<00omV
IWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInUonMWJ400oooooooh=oSon3Oh`0eon3O
ha7ok^gUQ?o[jnMYonGVkQ7ok^gU4OoPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooOooooo`03onk]iOo/kOCoRhbI00coWIj[00GoRX^Ion?VkOmVIWkoZ:Vkoo_lo@01
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ogMkQ00cofM[T00GogMkQ
oiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnD
UJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mV
IWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo
00GoblcJ00?o?cdmol_<f_o;c=X01?o;c=X01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mV
IWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool01?o;c=X3oclm?@GoblcJ00Gooooo
oiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnD
UJ;ooooo00?oc<gK1Olo?Cd4olc=f`05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FRooooo`02om7Bh0?o?cdm00CodM;Poclm?Olo?Cgo
?cdm0ooAd^001OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00Cok^gUoiBEX_oooooofM[T0olo?Cd3omWJi0?o?cdm0_oIf^@01OooooooU9FRofIVO_nX
ZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool00_oS
hn/00olo?Cgohn?[on?Sj`03on?Sj`09oclm?OoShn_ohn?[on?SjoooooooU9FRofIVO_nXZK_onocm
007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03?o/k?401Ooo
ooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gU
oiBEX_ooool03?odm?L01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omV
IWkoooooomoooooo00?ok^gUoiBEX_ooool03?oko?`01OooooooU9FRofIVO_nXZK_onocm007oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03Oooool01?nDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;oe]KK00co
oooo00Goe]KKoiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOoooo
o`05onk]iOoFfmWoSi2NokFe__nd];h01Ond];d02_nc];go];Bmok>d_Ond];go/k>mohb=W?oFfmWo
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gU
ong`l_n;S9X01OnMWZ`00onMWZ_oWIj/oifN[003oifN[006oifO[?n=Si_ok^gUofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FRomgNh@0<om3Ag`05omgN
hOnDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGo
U9FRooooooogmoT2onc/l@;oj>S^00coh^?[om_LiOoKg>Goe=GQolk?gOo<cM_ocLkLoooooonDUJ;o
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oXj>h03?oRh^_ofm_Vom_Ki_oDeN7oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onSYk`0<on?Sj_oKfnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^
00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[o
fmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcU
omGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
O_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?
g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooO
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Co
k^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?oooooo
U9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FR
ooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOg
n@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42
onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00co
h^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcU
om_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkoooooolSooooo1Om5CYT2ooooo`GoADjI0_ooool5odE>V@Cooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooc?ooool00om5CYWoooooooooo`04ooooo`03
odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/
l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInooooooo<ooooo`03odE>VOoooooooooo00Cooooo00?oADjIoooo
ooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh0
3?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWkoooooolcooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`04
ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oK
g>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_ooooooc?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00Cooooo00?o
ADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Go
e=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
?_ooool3o`0000Cooooo0_l00002ooooo`;o000000Coooooo`000?l0003ooooo0_l0003oooooog_o
oooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;o
oooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>
g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOSoooooo00?o0000oooo
ooooool00_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooooooool0oooooomjooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool01?ooool0
0om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_L
iOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWhoooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooo
oooooooo00000?ooooooO?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00Cooooo
00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoK
g>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVIn?oooool00ol0003oooooooooo`02ooooo`Co00000oooool01Ol0003ooooooooooooooooo0000
0?ooooooO?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00Cooooo00?oADjIoooo
ooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?
gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn?oooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_oo
ool00ol0003oooooooooo`3oooooog[ooooo00?oADjIooooooooool01?ooool00om5CYWooooooooo
o`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;R
j_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVOSoooooo00?o0000ooooooooool00oooool2o`0000;ooooo0_l000000ooooooo0000
o`000003o`000?ooooooNoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00Cooooo
00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoK
g>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVIn?oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo0?ooooooN_ooool00om5CYWo
ooooooooo`04ooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGo
U9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;o
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn??ooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0oooooomjooooo`03odE>VOoooooo
oooo00Cooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;o
ooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhlooooo`Oo0000oooooon9ooooo`03odE>VOoo
oooooooo00Cooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooolcooooo00?oADjIooooooooool0
1?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooc?ooool00om5CYWoooooooooo`04ooooo`03
odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/
l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInooooooo9ooooo`CoADjI1_ooool00om5CYWoooooooooo`04oooo
o`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>Go
fmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_ooooooc?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00Cooooo00?oADjI
ooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQ
olk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooo
ooo8ooooo`GoADjI1_ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Co
k^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?oooooo
U9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWooooo
ooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<
on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;o
oooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>
g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5
CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42
onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooo
oooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmco
c<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodooo
ool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>
VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCE
h?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oo
oooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04oooo
o`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>Go
fmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gU
oiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FR
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWooooooooo
o`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?S
j_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo
00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?oo
ooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWo
ooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWY
kP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo
00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool0
0om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoo
oooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>
d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooo
b?ooool5odE>V@Kooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]
iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oRh^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooooiBE
X_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooolcooooo00?oADjIoooooooo
ool01?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooc?ooool00om5CYWoooooooooo`04oooo
o`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2
onc/l@;oj>S_00coh^;Zom_KiOoKfnGoe=GPolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooo<ooooo`03odE>VOoooooooooo00Cooooo00?oADjI
ooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oX
j>l03?oRh^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWhnooooo`05okfm_Om=CDgo0000ode=COnWYjL00oooool01OoYjNWoO7al
o`000?mXJ6Sod=3@00;o00000_ooool2o`000004olO7aom=CDgoCDe=om3@d0?ooooo00Kol?3`oiZJ
V_l0003o0000ohb<S?oYjNT3ooooo`05olO7aomXJ6So0000ode=COnWYjL01?ooool01?o@d=3oCDe=
o`000?nWYjL3ooooo`05omWIfOm=CDgo0000ohb<S?ooool00_l00003ooooo`05omWIfOmXJ6So0000
ofQXJ?oIfMT00oooool2o`0000?ooooo0_l0003ooooood;ooooo00?oADjIooooooooool01?ooool0
0om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVOS7ooooo1_l00006ooooo`03okfm_Ol0003o000000?o000000Co
YjNWooooooooooooO7al1_l00002ooooo`Ko000000CofMWIooooooooooooO7al1?l000001?n<S8co
oooooooooooIfMT5o`000004ohb<S?ooooooooooomWIf@Co000000CoYjNWooooooooooooCDe=0_l0
00001?nJVY[oooooo`000?l00002ooooo`03omWIfOl0003o000000?o000000?ohN7Qooooooooool0
0_l00003ooooo`;o0000oooooom2ooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool0
1?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oRh^[o
fm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWhaooooo`Ko00001_ooool01Om=CDgo0000omWIfOoooooojNWY00;o00000_ooool2o`00
0003omWIfOooooooYjNW00;o00000_ooool2o`000005okfm_Ooooooo/[:bo`000?mlO7`01_ooool2
o`0000;ooooo00?oO7alo`000?oQhN401_ooool01_mlO7co0000omWIfOoYjNWo0000ode=C@;ooooo
0_l00003ooooo`;o00000_ooool01omlO7co0000ojNWYoooooooYjNWo`000?mlO7`00_ooool2o`00
00?ooooo0_l0003ooooood;ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`04oooo
o`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<on;Rj_oKfnGo
fm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVOS7ooooo1_l00009ooooo`04onWYjOo7alOo0000o`0000;ooooo0_l00003ooooo`;o00000_oo
ool2o`0000;ooooo00?ol?3`o`000?l000000oooool01Onm_KgoS8b<ofQXJ?l0003oS8b<00;ooooo
1ol00002ooooo`;o00001_ooool2o`0000?ooooo0_l00002ooooo`;o00000_ooool00oo`l?3o0000
o`000002ooooo`;o00000oooool2o`000?oooooo@_ooool00om5CYWoooooooooo`04ooooo`03odE>
VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;o
j>W^00cohn;[om_Ki_oKfnKoe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVIn<Oooool6o`0000Oooooo00?o/[:bofQXJ?l000000_l000000onb/[;o
ooooooooo`02o`0000?ooooo0_l00002ooooo`;o000000?ol?3`ooooooo`l?000_l00002ooooo`05
ok:b/_l0003o0000ogalO?nm_Kd00oooool6o`000003ode=COoooooooooo00;o00001_ooool2o`00
00?ooooo0_l00002ooooo`;o00000oooool2o`0000;ooooo0_l000000oo`l?3oooooooooo`02o`00
0?oooooo@_ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00Cooooo00?oADjIoooo
ooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00cohn;[om_Ki_oKfnKoe=GPolk?
g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn<Oooool6
o`0000Kooooo00?oYjNWo`000?l000000_l000001?nb/[;oooooooooooooool2o`0000?ooooo0_l0
0002ooooo`;o000000Go/[:boooooonb/[;o0000ogalO002ooooo`;o000000?ol?3`ooooooooool0
0oooool01omlO7co0000on7QhOoooooohN7Qo`000?nJVYX00_ooool01_mlO7co0000on7QhOoYjNWo
0000ofQXJ0;ooooo0_l00003ooooo`;o00000_ooool01omlO7co0000ojNWYoooooooYjNWo`000?ml
O7`00_ooool2o`000003ohb<S?oooooofMWI00;o0000oooooom2ooooo`03odE>VOoooooooooo00Co
oooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOg
n@;ok>ca0_oXjNh03?oSh^_ofm_Vom_Ki_oDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWhaooooo`Ko00001_ooool00om=CDgo0000olO7a`06oooo
o`;o00000oooool2o`0000;ooooo1_l000001?o@d=3ooooooooooomXJ6P4o`000004ogalO?oooooo
ooooomWIf@Go000000CohN7QoooooooooooofMWI1?l000000onm_Kgoooooo`000004o`000003oooo
ool0003o000000;ooooo00?ofMWIo`000?l000000ol000000ooIfMWoooooooooo`06o`000003ogal
O?oooooooooo0?oooooo@?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00Cooooo
00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00cohn;[om_Ki_oK
fnKoe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVIn?Oooool2o`000005onWYjOoooooofMWIo`000?m=CDd00_ooool2o`0000?ooooo0_l00002oooo
o`;o000000Cod=3@ode=COm=CDgoalO70oooool01_oYjNWoO7alo`000?l0003oS8b<onWYj@?ooooo
00God=3@ofQXJ?l0003oJ6QXomWIf@04ooooo`04om3@d?m=CDgo0000ojNWY`;ooooo1Ol000000ooo
oooo0000o`000003ooooo`05omWIfOmXJ6So0000ofQXJ?oIfMT00oooool2o`000005omWIfOmXJ6So
0000ogalO?oYjNT0oooooom2ooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool01?oo
ool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oSh^_ofm_V
om_Ki_oDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWhmooooo`03ojNWYol0003o000000?o000000?o/[:booooooooool02Oooool2o`00023ooooo
0_l0003ooooooeWooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`04ooooo`03odE>
VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on?RjooKfnKofm_VomCE
h?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOSko
oooo00GoYjNWode=COl0003oCDe=ok:b/P0<ooooo`;o00008?ooool00ooQhN7oS8b<ooooo`02oooo
o`;o0000oooooomDooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool01?ooool00om5
CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oSh^_ofm_Vom_Ki_oD
eN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWko
ooooolcooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooo
oooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?46ohjEXP08olk?g?o<cM_ocLkLoooooonDUJ;o
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooo9ooooo`CoADjI1_ooool00om5
CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Gok^gUoiBEX_oooooomoOionc/l@06
ooooo`09omCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooolcooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`04ooooo`03
odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?46ohjEXP08olk?g?o<cM_ocLkL
oooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooo8ooooo`GoADjI
0_ooool5odE>V@Kooooo00?oADjIooooooooool00_ooool01Oo^kNGoU9FRooooooogmoWok>ca00Ko
oooo00Woe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca
1_n>UJ802?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooof_ooool00om5CYWoooooooooo`02ooooo`05onk]iOnDUJ;oooooooOgnOo/k?401_oo
ool02OoDeN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?46
ohjEXP08olk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Gok^gUoiBEX_oooooomoOionc/l@06oooo
o`09omCEh?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY
^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;o
jNW^00cohn?Zom_Ki_oKfnKoe=GPolk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWYkP0<on?Sj_oKfnKofm_VomCEh?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02oooo
o`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofm_Vom_Ki_oDeN3oc/oMolc=foo=c]co
oooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjI
ooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_Ki_oKfnKoe=GP
olk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooo
oooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?S
j_oKfnKofm_VomCEh?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;o
k>ca0_oYjNh03?oShn[ofm_Vom_Ki_oDeN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool01?o^kNGo
U9FRooooooogmoT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;o
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo
00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<on?Sj_oKfnKofm_VomCEhOo>d=goc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool0
0om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNl03?oShn[ofm_Vom_K
i_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWkoooooom[ooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W_
00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onSYk`0<on?Sj_oKfnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02ooooo`04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNl03?oShn[ofm_Vom_Ki_oDeN7oc]3Molc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjIoooo
ooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@
gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJ
ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<on?Sj_oK
fnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca
0_oXjNl03?oShn[ofm_Vom_Ki_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FR
ooooooogmoT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooo?ooooo`GoADjI1_ooool00om5CYWo
ooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNl03?oShn[ofm_Vom_Ki_oDeN7o
c]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
om?ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool0
0om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_L
iOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWkoooooom?ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom?ooooo00?oADjIooooooooool0
1?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[o
fmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhNooooo`03omWIfOnJVY[o0000
00;o000000?oO7alolO7aoooool01Oooool01_nb/[;oJ6QXo`000?l0003oVYZJonWYj@Gooooo00Ko
d=3@ogalO?l0003o0000oiZJV_oQhN43ooooo`05onWYjOn<S8co0000o`000?n<S8`00_ooool3o`00
00Cooooo00Kod=3@ogalO?l0003o0000ogalO?o@d=04ooooo`?o00001?ooool3o`000?ooooooL_oo
ool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVOQgooooo00?oYjNWo`000?l000001Ol000001_n<S8cooooo
ooooooooooool?3`ofQXJ0Go000000?oCDe=onWYjOooool00_ooool00onWYjOo0000o`000004o`00
0004omWIfOoooooooooooiZJVP?o000000?oVYZJooooooooool00ol00003ooooo`03ojNWYol0003o
000000Co000000CoYjNWoooooooooooooooo0ol00004ooooo`?o0000oooooombooooo`03odE>VOoo
oooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^
00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVIn7?ooool00ooQhN7o0000o`000007o`000004okfm_Ooooooooooook:b/P;o
000000?oVYZJoooooooIfMT00_l000001?n<S8coooooooooooo@d=02o`000006ogalO?o`l?3ooooo
ojNWYol0003oJ6QX0_ooool3o`0000Cooooo0ol00002ooooo`04omWIfOl0003o0000ogalO0;ol?3`
00CoO7alo`000?l0003ohN7Q0_ooool3o`0000Cooooo0ol0003oooooog;ooooo00?oADjIoooooooo
ool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oR
hn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWhLooooo`05oiZJV_l0003o0000ogalO?o`l?000_ooool01?nWYjOo0000o`000?m=
CDd2ooooo`04ogalO?l0003o0000onWYj@Oooooo00CoS8b<o`000?l0003ofMWI0_ooool00oo`l?3o
S8b<on7Qh@02ooooo`?o00001?ooool3o`0000;ooooo00CoVYZJo`000?l0003ofMWI0_ooool01?oI
fMWo0000o`000?nJVYX2ooooo`?o00001?ooool3o`000?ooooooL_ooool00om5CYWoooooooooo`04
ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oK
g>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVOQcooooo00CoCDe=o`000?l0003ol?3`1?ooool3o`0000;ooooo0ol00008ooooo`?o0000
2?ooool3o`0000Cooooo0ol00002ooooo`03ode=COl0003o000000Cooooo0_l000000om=CDgooooo
ooooo`03o`0000Cooooo0ol0003oooooog;ooooo00?oADjIooooooooool01?ooool00om5CYWooooo
ooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloL
olc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhRooooo`05
on7QhOnJVY[o0000o`000?mXJ6P00_ooool9o`0000;ooooo0ol00008ooooo`?o00001?ooool3o`00
00;ooooo0ol00004ooooo`?o00000_ooool3o`0000Cooooo0ol0003oooooog;ooooo00?oADjIoooo
ooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh0
3?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWhOooooo`03olO7aonJVY[oCDe=00Co000000?oalO7ooooooooool02Ol00002
ooooo`?o00002?ooool3o`0000Cooooo0ol00002ooooo`03ode=COl0003o000000Cooooo0_l00000
0om=CDgoooooooooo`03o`0000Cooooo0ol0003oooooog;ooooo00?oADjIooooooooool01?ooool0
0om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_L
iOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWhMooooo`03om3@d?m=CDgo000000Go000000Go_KfmooooooooooooooooogalO002o`0000?ooooo
0_l000001?mlO7cooooooooooon<S8`2o`000006on7QhOoooooooooooo3`l?n<S8cohN7Q0_ooool3
o`0000Cooooo0ol00002ooooo`04oiZJV_l0003o0000omWIf@;ooooo00CofMWIo`000?l0003oVYZJ
0_ooool3o`000004on7QhOooooooooooooooo`?o0000oooooombooooo`03odE>VOoooooooooo00Co
oooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_L
iOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVIn7?ooool00ooIfMWo0000o`000003o`000003ohb<S?o7alOol?3`00Cooooo00Ko/[:bo`00
0?l0003ofMWIoooooonm_Kd2o`000004ok:b/_ooooooooooom3@d0;o000000KoO7aloo3`l?oooooo
YjNWo`000?mlO7`2ooooo`?o00001?ooool3o`0000;ooooo00CohN7Qo`000?l0003oO7al0_o`l?00
1?mlO7co0000o`000?oQhN42ooooo`?o000000CoO7aloo3`l?ooooooYjNW0_l000000omXJ6Sooooo
ooooo`3oooooog3ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]
iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBE
X_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhLooooo`05ogalO?l0003o0000ohb<
S?oIfMT02Oooool00om=CDgo0000o`000003o`000003ode=COo`l?3ooooo00;ooooo00?oYjNWo`00
0?l000001?l000000ooQhN7oooooo`000005o`0000;ooooo0ol00003ooooo`03ojNWYol0003o0000
00Co000000Co/[:boooooooooooooooo0ol000000omlO7co0000o`000003o`000003okfm_Ooooooo
oooo0?ooooooL?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gU
oiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FR
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo0ol00004ooooo`04oo3`l?l0
003o0000o`0000Cooooo00KoYjNWode=COl0003oCDe=ojNWYoo`l?05ooooo`06om3@d?n<S8co0000
o`000?nJVY[ohN7Q0_ooool6o`0000;ooooo0ol00004ooooo`06omWIfOmlO7co0000o`000?mlO7co
fMWI1?ooool3o`000006oooooonWYjOoCDe=o`000?mXJ6So_Kfmoooooomcooooo`03odE>VOoooooo
oooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00co
h^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVIn7?ooool01?mlO7co0000o`000?nWYjL2ooooo`05oo3`l?n<S8co0000o`000?ml
O7`06?ooool3o`000?ooooooTOooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;o
oooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>
g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo00?oalO7o`00
0?l000001ol000000oo@d=3oooooooooo`0Fooooo`?o0000oooooonAooooo`03odE>VOoooooooooo
00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Z
om_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn7Oooool00omlO7co0000o`000005o`000003ojNWYooooooooooo01Oooooo00?ofMWI
ode=COl000001?ooool3o`000?ooooooR_ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooo
oooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgo
c<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQkooooo00?o
_KfmogalO?l000000_l000000on<S8cod=3@ooooo`0Kooooo`03oiZJV_oooooooooo00;ooooo0ol0
003ooooooh[ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom?ooooo00?oADjIooooooooool0
1?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[o
fmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom?ooooo00?oADjIoooo
ooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h0
3?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom?ooooo00?o
ADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca
0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool00om5CYWooooo
ooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oL
olc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom?o
oooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOg
n@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom3ooooo1?m5CYT6ooooo`03odE>VOoooooooooo
00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool0
0om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVOQ_oooooool0002_o`0000Gooooo1Om5CYT2ooooo`GoADjI1?oo
ool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkL
oooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]
iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBE
X_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2
onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oY
jNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?S
j_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoK
g>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3o
c/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool0
1?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooo
oonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/
l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l0
3?oRh^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on?RjooK
fnKofm_VomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_Ki_oKfnKo
e=GPolk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`03onk]iOnDUJ;oe]KK00cooooo00Goe]KKoiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOomoO[oT96O00Go]kNo00?o];BmokNg_ong
]kl01?ng]kl01On@TIook^gUofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00?ok^gUonc]m?n;S9T03?nMWZ/01On:RiWohnK]ofIVO_nXZK_onocm007oIVIn00001?mV
IWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_oMg^403?oIf^@01OoMg^7oU9FRofIVO_nX
ZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03?o;
c=X01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo
00?ok^gUoiBEX_ooool03?o;c=X01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03?o;c=X01OooooooU9FRofIVO_nXZK_onocm
007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03?o;c=X01Ooo
ooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gU
oiBEX_ooool00_o;c=X00olo?CgoblcJol_<fP03ol_<fP09oclm?Oo;c=[oblcJol_<f_ooooooU9FR
ofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oo
ooooc<gK0olo?Cd3olc=f`?o?cdm0_o<cM/01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mV
IWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool00_oAd^03oclm?@04om7Bh?lo?Cgo
?cdmoclm?@?odM;P00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`03onk]iOnDUJ;ooooo00?ofM[T1Olo?Cd4omWJi005oooooonDUJ;oIVInojRY^ook
o?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FRooooo`04on?Sj`?o
?cdm1OoShn/01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00?ok^gUoiBEX_ooool01Oo/k?400olo?Cgok>caonc/l@04onc/l@05oooooonDUJ;oIVIn
ojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FRooooo`0<
ooCdm`05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool00oo^kNGoU9FRooooo`0<oo_lo005oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FRooooo`0=ooooo`04oiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_oFe]/03?ooool01OoFe]_o
U9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoo`000=oo000000Gok^gUomKK
fOn?T9ko]KFnokBd_P05okBd_@0:ok>d_Ond];go/kBmokBd_Onc/kgoS8fLomKKfOmVIWkoZ:Vkoo_l
o@7oIVIn00000omVIWkomoOioiRHY`3oogMgT_;oMgNB0OnHV:L1ooOgn@7oIVIn00000omVIWkomoOi
okbmc@3ookbmcO?o_;g=0OogmoT1ofIVOP0000?oIVInooOgnOoThn<0oooThn?conCSh`7omoOi0OmV
IWh00003ofIVO_o`lOCooooo00Cooooo00?oYjNWoj>RXonRXZ800_nQXJ400onPX:3oYIjEojZLR@02
oinOW`;oX:2P0_nQXJ400onWYjOoooooooooo`3oooooojcooooo00?oi>?SoibT^Om[MHl00_m[MHl2
ofafT0GoJgF?00KoW:BionCShoooooooooooonCShonLY;T3of]eS`;oK7J@1Om[MHl01_nLY;Woi>?S
ooooooooooook>[ZoibT^@?oYSU40_nW>T@5ojHiA003oibT^Oo/j^[ooooo00?ooooo0Oo`lO@1ofIV
OP0000WoIVInon;Qh_oko?cono_loo_loOolnogoV9RIoi^KVon/[:`00ooYjNT02_oZj^[ohlIjomUj
5?o/k>cokNg]onk^k_oaimGol?3`oo;bl_nSXj<2ooclo004oocloOolo?cono_moocloI?oo?_lT_ok
o?b2oo_lo@03oibT^Om[MHooQHV`00WoQHV`00KoJgF?oibT^Ooko?gonocmoibT^Om[MHl:ohF9/006
of]eSonLY;Wono_loo_loOnLY;WoYSU42_nZ?5D01onV>DCoW:Bioo_lo?olo?coo?_moo_loOoRhN80
0OmVIWh00004ofIVO_oPh>7om_OiooOgn@;om_Oi00Gom_Ohoj2PX?oZj^[ojNWYoo[XZ@02on[ZjP0:
ooSU6?o=I`3okNg]onk^k_ofZ3?om/j<oo;bl_oclo?oXj>SooOgn@?om_Oi00?om_OhooOgnOo7`]40
0oo7`]42ooOgn@05olO2dOogmoWomoOiooOgnOo7`]400oogmoT2olO2d@;omoOi00Coal;AooOgnOog
moWomoOi0_o7`]401?ogmoWoal;AooOgnOogmoT3olO2d@?omoOi1?o7`]48ooOgn@05olO2dOogmoWo
moOiooOgnOo7`]400_ogmoT01_o7`]7omoOiooOgnOogmoWoal;AooOgn@Coal;AE?ogmoVBooKgnH;o
moOi00?oJgF?ohF9/?nLW[h02OnLW[h01_n5RK3oJgF?ooOgnOogmoWoJgF?ohF9/0[oW9jn00SoQHV`
of]eSoogmoSomoOiojHiA?nZ?5Go`U9KolIDFPKoaUEL00WoaUAJol9BFonZ?5GoYSU4ooOgn?ogmoWo
moOhooOgnOoPh>400OmVIWh0000KofIVO_oNgN7olO7doo7am?o`lOCol?;doj6QXon?ShooSXj>onWY
jOoAN`3obS40olYfEOoom`3ojj/0om^NOooUX7Woed80oo;bl_oclo?om?CdojBTY?oalOCol?;eoo7a
m?oal_Col?;d00Co3Q0@00Col?7eolO2dOl>413oal;A0_o`lOD01?l>413oal;Aoo3amOo`lOD2o`h@
40;ol?7e00Co3Q0@olO2dOo`lOGol?7e0_l>41001?o`lOGo3Q0@olO2dOo`lOD3o`h@4003oo3amOo7
`]7ol?7e00Co3Q0@00?oal;Aoo3amOo`lOD01Oo`lOD02Ol>413oal;Aoo3amOo`lOGo3Q0@olO2dOo`
lOGo3Q0@olO2d@02oo3am@03o`h@4?o7`]7o3Q0@00?o3Q0@00?ol?7eolO2dOo`lOD0i?o`lOF2oo3a
m003of]eSonb]M3oYjS200WoYjS200Ko/[G@of]eSoo`lOCol?7dof]eSonb]M07ooooo`?oYjS200Go
/[G@of]eSoo`lOCol?7dojHiA002ol9BF`03ol]DFOo=FEkocEUN00CocEUN00CobeAIol9BFoo2DU_o
YSU40_o`lO@00ooalOCol?;domkMh@01ofIVOP0000WoIVInomcKh?oZjo3oj^_`on[/l?oYjnooU9BG
oj>SXooWi^H00_oZj^X02ong303od7P0oooU0?okc03of8P0okm:0?ngA03o^U0jomVJHOomg03o^Jij
00;oj^_`00Coj^__on[[l?l>413oal;A0ooZjo001?l>413oal;Ao`h@4?o7`]42on[[l005o`h@4?o7
`]7oj^_`o`h@4?o7`]400ooZjo001Ol>413oal;Aon[[l?l>413oal;A00;oj^_`00Co3Q0@olO2dOl>
413oal;A0_oZjo001?l>413oj^_`o`h@4?o7`]42on[[l003o`h@4?o7`]7oj^_`00Koj^_`00Go3Q0@
olO2dOoZjo3oj^_`o`h@4002on[[l008o`h@4?o7`]7oj^_`on[[l?l>413oal;Ao`h@4?o7`]42on[[
l003o`h@4?o7`]7oj^_`05;oj^_`T_oZk?22on[[k`03of]eSonf^M7o[Jk600Kooooo0_n][/H00on/
[/Ko][WAof]eS`02on[[k`03of]eSonf^M7ooooo00KoKVf?00Go9BDfojf^a_n/[/Ko][WAof]eS`02
on[[l003ojHiA?o=FEkobeAI00;ooooo0oo@FUl2ooooo`06oleFFoo;E5WocEUNojHiA?oZjnooj^_`
0_oZjnl1omcKh07oIVIn00000omVIWkoemSNomcNiP03omcNiP0AomcNiOn6QhKo_XiFooWOB?oikT;o
k;H0oo_@0?o`^P3oj[00onVb0?oJR`3ociD0on:o0?ong`3om_3LojBUYOoLg^H00_oLg^D00ooLg^Ko
3Q0@olO2d@03omcNi@04o`h@4?o7`]7o3Q0@olO2d@;og=kU00Go3Q0@olO2dOoLg^Go3Q0@olO2d@03
omcNi@05o`h@4?o7`]7og=kUo`h@4?o7`]400_oLg^D00ol>413oal;Ao`h@4005olO2d@07o`h@4?o7
`]7og=kUomcNiOl>413oal;AomcNi@03olO2d@?og=kU00?o3Q0@olO2dOoLg^D01?oLg^D02?l>413o
al;AomcNiOoLg^Go3Q0@olO2dOl>413oal;A0_oLg^D00ol>413oal;AomcNi@3oomcNiFOog=kU00Co
JgF?oko1e_nh^Lkooooo1?m^KHl01_lU9CKo^;W>okRic_nh^Lko_l7Fof]eS`;og=kU00CoJgF?oko1
e_ooooooKVf?1?nh^Lh01_oooooo9BDfokRic_nh^Lko_l7Fof]eS`;og=kU00?oYSU4oleIG_oAFUh0
0oooool02?oFGf?oooooooooooooooooe5eQom5JG_o=FEkoYSU40_oLg^D00ooLg^Kog=kUomOHgP01
ofIVOP0000CoIVInomGFgOoEf>3oe]SQ0_oEf>004?mkNh3oU9BDoielB_o7LP3oij@0oooX0?o[]P3o
jJX0onR/0?oCP@3o^T`0on:j0?ojlWOom_KfooShn?nUY:D2omGHh@04omGGh?oFf>3o3Q0@olO2d@?o
e]OP00Co3Q0@olO2dOl>413oal;A0_oFen001Ol>413oal;AomKGh?l>413oal;A00?oe]OP00Go3Q0@
olO2dOoFen3o3Q0@olO2d@02omKGh003o`h@4?o7`]7o3Q0@00Co3Q0@00?oal;Ao`h@4?o7`]400_oF
en000ol>413oal;Ao`h@4002o`h@40Coe]OP00?o3Q0@olO2dOoFen001?oFen002?l>413oal;AomKG
h?oFen3o3Q0@olO2dOl>413oal;A0_oFen000ol>413oal;AomKGh01BomKGh9;oe]SPP_oEf>400om[
MHooblcNolS:f@06obDU=P05olS:fOo8bMWob<[Iol_<g_m[MHl00_oEf>401?m[MHooblcNoooooom^
KHl3olS:f@0=olS9fOoooooo9BDfolS9fOo8b]WoblcNof]eSooFf>7oe]SPojHiA?oGGeooffATodHN
6P05ooooo`0:odHN6_oPIfGoffATomMOGonV>DCoe]SPomGHhOoEen3oeMSQomGFg@7oIVIn00001OmV
IWkod]CMoloBg?o@d]cod=;M00;od=;L00ooUiNGokNg]oo/k>cog[InomV80?oba03okK40onRZ0?oD
M@3o_VP0oocE0?okggWon?KaooWinOnUYJD00oo@d]`00oo?d]co3Q0@olO2d@03om3Bg003o`h@4?o7
`]7o3Q0@00?oal;A00Co3Q0@om3Bg?o@d]co3Q0@0oo7`]401Oo@d]co3Q0@olO2dOo@d]co3Q0@00?o
al;A00Co3Q0@olO2dOl>413od=;L0_o7`]401?l>413od=;Lo`h@4?o@d]`2olO2d@03o`h@4?o7`]7o
d=;L00God=;L00?oal;Ao`h@4?o7`]401Oo@d]`01ol>413oal;AolO2dOo7`]7o3Q0@om3Bg?l>4100
0oo7`]400ol>413od=;Lom3Bg01Bom3Bg9;ocm;MP_o@d]`00om[MHoodm?Rolo@g@09olo@g@08om?C
h_m[MHood=;Lom3Bg?m[MHoodm?Roooooom^KHl4olo@g@0=oooooolU9CKocm3Molo@gOoCdn;oJgF?
om3Bg?o?d]coYSU4om]TI?oQJFGoh6aYodHN6P03ooooo`07odHN6_oPK6Woh6aYon5YIOoKI6CoYSU4
om3Bg@02om3Bg07ocm;L0OoBe=d1ofIVOP0001coIVInom3Bfoo;cMSob/gIol_>f?o:cMSoNWb2oiVI
VOnVYjKokNg]onO:R_o7J03ol[T0omb90?o:I`3o]S40ok]B0?oobP3ook`0oo^i0?og/P3obZ]Pol_=
f?o;cMWob/gIol_>f?l>413oal;A0oo;cMT00ol>413oal;Ao`h@4003o`h@40;oblgI1?l>41001?o;
cMWo3Q0@o`h@4?o;cMT4o`h@4004ol_=fOl>413oal;Aol_=f@?o3Q0@0oo;cMT4o`h@4003olO2dOo;
cMWoblgI00?oblgI00Co3Q0@ol_=fOl>413oal;A1Oo;cMT4o`h@40;oblgI1?l>411Eol_=fI;oblkI
P_o;cMP01?m[MHooe]KTomSHiOoHf>H2omSHi@;of=SV00Kof=SUomSHi_oHf>Gof=SUomKFi?m[MHl2
ol_=f004of]eSooFe^Coooooofi]S`Gooooo00_o9BDfomSHiOoHf>Goe]KTof]eSoo;cMWob/kHojHi
A?oTKVgoi7A_onMaK`05ooooo`07onAdKooWLFooi7A_onA^KOnV>DCob/kHol[>f@02ol_=f@7od=;K
0OmVIWh00003ofIVO_o?cm[oaLSD00CoaLSD013oWYjMon?Shoo//UkofYP0om9l0?oNT`3ofG`0omQi
0?nd=03oX0H0onnJ0?oo[03on_K/oo_hlOnfZ8OoaLSD0_o5am@00oo5amGo3Q0@olO2d@03olC7e@03
o`h@4?o7`]7oa<OE00Koa<OE00?o3Q0@olO2dOo4amD00oo4amD01?o7`]7oa<OEo`h@4?o7`]42olC7
e@03o`h@4?o7`]7oa<OE00Woa<OE00?o3Q0@olO2dOo4amD01Oo4amD2o`h@4003olO2dOo4amGoa<OE
00Woa<OE00?o3Q0@olO2dOo4amD0E_o4amFBolC8e8;oa<OD00?oJgF?omGDhooPgnX02OoPgnX01ooE
e>?oJgF?olC7e?o4amCoJgF?omGDhoooool01_m^KHl02_lU9CKoh=oZon3Oj_oEe>?oJgF?olG8e?o4
b=CoYSU4onYiLooYO7P3ooooo`09odHN6_ooooooooooooooooo_PG[ojGahonYiLonV>DCoa<SE00;o
a<SD0Oo5amD1olo?fP7oIVIn00001?mVIWkoc<kJol;4d_o1a=42ol74dP0@oh63S?n=SHgoOgM_on2K
0?o`l?3oi;fHonb]0?oog`3oolH0onZW0?o2H03odGD0ooRW;Ookno_oo?clojJVYP?o`LCB00?o`/CA
o`h@4?o1a=800oo1a=400ol>413o`LCAol74d@06ol74d@03o`h@4?o1a=7o`LCA00;o`LCA00Co3Q0@
ol74dOo1a=7o3Q0@0oo1a=400ol>413o`LCAol74d@09ol74d@03o`h@4?o1a=7o`LCA00Ko`LCA00?o
3Q0@ol74dOo1a=402_o1a=400ol>413o`LCAol74d@1Fol74dI;o`LCBP_o2a=800om[MHookN_conWX
l@09onWXl@07ong[lom[MHoo`/CBol;4d_m[MHookN_conWXl@07obDU=P;ojNSa00OokN_cof]eSoo2
a=7o`LCAojHiA?oaP7Gol8Al00;ooooo00?oAQhJoo6bVom67QX00_ooool02OoeS8Col8Aloo60MOnV
>DCo`LCBol;4dOo1a=7o`LCBolc>fP01ofIVOP0000CoIVInol[<f?nn`<oo_L3?0_nn`<h05On;SISo
WYjNomGDe?o`l?3ol_;bonS;ZoohdP3om^B7oo?BSOobXP3oklVAonO5X_oQP@3oo?cloogmoOnVYjOo
_/3>okk0conn`<ko_/3?okg0cP2Dokk0cY;o_L3>P_nn`<h00om[MHood]7Soo;am`09oo;am`06om;A
hom[MHoo_/3>okk0c_m[MHood]7S2_oblOL01ooBdN?oJgF?okg0c_nn`<koYSU4ooB:OOoeT8D00_m6
7QX3oo:hWP;oAQhJ0_oeT8D00oodRWgoYSU4okg0c`02okk0c`7o_/3>0Oo:c=P1ofIVOP0001coIVIn
olW:f?nf^<So^Kc;okZlbonj_<co^[c;ohJ6Q_nDU9?ol_;boo?clooVY03on>f^ooKfm_ocfjcojYL0
oo[jn_okno_olMZkooVf;oono_koYjNWokVlc?nj^lco^Kc;okZlboni_<co^Kc;Toni_<bBokZlc8;o
^[c;00CoQ8bRof]eSoo<bmgono_l1_ooool01?oknococ<_Mof]eSon4S:82okZlb`04ohB<X_m[MHoo
c<_Moo_ko0Kooooo00_ono_lolc;gOm[MHooQ8bRokZlc?ni_<coTIRZojHiA?ooWhgoo[nToo[L]`02
oo[Y]P;onNVf00[on]bgoojoY?ooWhgoYSU4oi6HZ_nj_<co^[_<okVlbonf^<SobL[H0OmVIWh00003
ofIVO_o6b=Oo^;O?00?o[jk700goLg:2oj2PX?oQh>7olo?concWcoobk=kom_KfooShn?oinOWoiX/0
oo_knoolo?cooOgm00;oo_kn00?oYjNWojn^aon_[/L0oon_[/N]ojn^a`03ohB<X_m[MHooJgF?00So
JgF?00?oQ8bRojn^aon_[/L00_n_[/L00on4S:;oJgF?of]eS`08of]eS`03ohB<X_n_[/Oo[jk700;o
[jk700?oQ8bRojHiA?nV>D@02?nV>D@00on4S:;o[jk7ojn^a`02ojn^a`7o^;O?0Oo6b=L1ofIVOP00
00?oIVInol31dOo7am@01?n/Zl@00on=SHgoZZZZojZZZP05ojZZZP03okBVS_nZZZ[oZZZZ00CoZZZZ
oon/ZlCOojb[a07oalOD0Oo0`M41ofIVOP0000KoooooojRW_ooVi^god];Pokblcona/<CoojRW_nco
Z:No00Go/K34okblcooBd^3oi^K]ojRW_`01ooooo`0000OoooooohN7VooGf>;oo?clonCSj?o@d>3o
b/[J0?oo_;c?j_nl_<l01_o:b][od=3PonCSj?olo?coemSRohN7V`7ooooo0002ooooo`06oiFDZooG
f>;oo?cloo;aloo/jnkohN;[oooGf>;XomOHhP06on7Rjoo/jnkol_7cooclo?oGf>;oUIB[0_ooool0
00?ooooo0_mVIWh00on8QigoUIB[ojRW_`3oojRW_nWoZ:No00CoUIB[ohR7WOmVIWkoIVIn0oooool0
00GooooooomVIWk^ofIVOPGooooo0000\
\>"], "ListGraphic",
 Evaluatable->False,
 ImageSize->{503, 287},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"i:85", "Outline Format"}],

Cell["\<\
However, if the following sequence of cells occurs anywhere in the notebook, \
the hierarchical structure breaks down.\
\>", "Text",
 CellTags->{"Outline Format", "i:85"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007g00017b000`400?l00000o`00003ooomVIWkh
ofIVOP0000?oIVInoo_loOoko?d0oooko?gdoo_lo@7oIVIn00000omVIWkonocmojRY^`3oojRY^o?o
Z:Vk0Ooko?d1ofIVOP0000?oIVInoo_loOnXZK/0oomVIWkbofIVOP7oZ:Vk0Ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInV?oooolgon3Oh`03onc]m?n;S9WoWIj[00coWIj[00CoRX^Ion?VkOo^kNGo
^KZnP?nMWZ/00onm_Kook^gUonGVkP1XonGVkP03onc]m?n;S9WoWIj[00coWIj[00?oRX^Ion?VkOoP
gn<04?oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03
oooooooPgn?oh=oS03Goh=oS00?oU9FRomgNhOoIf^@03?oIf^@01?oMg^7oU9FRoiBEX_oJfmj0olO8
eP03om[Kg_nQXZkono_n06Sono_n00?oU9FRomgNhOoIf^@03?oIf^@00ooMg^7oU9FRon3Oh`05on3O
h`;ooooo0_oPgn<2ooooo`;oh=oS0_ooool01?oPgn?oIVInojRY^ooko?d1ofIVOP0000GoIVInoo_l
oOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS03Goh=oS00?oU9FRooooooo;c=X03?o;c=X0
1?ooooooU9FRoiBEX_oooon0olg>g003oooooonDUJ;ono_n06Sono_n00?oU9FRooooooo;c=X03?o;
c=X00oooooooU9FRon3Oh`04on3Oh`0?okRdXonh]J7oooooon3Ohonh]:?o^;FQoooooooPgn?o^;BS
okReXOooooooh=oSofIVO_nXZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS
00?oooooon3OhooPgn<0=OoPgn<00onDUJ;ooooool_<fP0<ol_<fP04oooooonDUJ;oU9FRoooooh3o
c<gK00?ooooooiBEX_oknoh0J?oknoh00onDUJ;ooooool_<fP0<ol_<fP03oooooonDUJ;oh=oS00Co
h=oS00Ko^;BSokRdXOoPgn?oh=oSokRdXonh]:42on3Oh`07okRdXonh]:7oh=oSon3OhomVIWkoZ:Vk
oo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS00?oh=oS
0ol00003on3Oh`?o00000ooPgn<3o`0000Goh=oS00Co0000on3OhooPgn?oh=oS0_l0000Hon3Oh`03
oiBEX_ooooooblcJ00GoblcJ00?o?cdmol_<f_o;c=X01?o;c=X01oooooooU9FRoiBEX_ooooooc/oM
olk?g?o>d=d05?o>cm`:olo?g@_ocloL2_o>d=d:olk?g@[oc/oL2_o>d=dEolk?g0[ocloM2_o?cm`0
1Oo>d=goc/oMolk?gOooooooU9FR06Won_[m00?oU9FRooooooo;c=X01?o;c=X00olo?CgoblcJol_<
fP05ol_<fP03oooooonDUJ;oh=oS013oh=oS00?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?go
Z:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`04on3Oh`05o`000?oPgn?oh=oSon3Ohol00000
0ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o
00000_oPgn<00ol0003oh=oSon3Oh`0Eon3Oh`03oiBEX_ooooooblcJ00CoblcJ0olo?Cd5ol_<fP04
oooooonDUJ;oU9FRooooo`goe=GP5?oDeN4;omGEh@[oe=GQ1ooDeN001on>UJ;oe=GPohjEX_oDeN3o
SYFRomCEh?n>UJ806_oDeN0EomCEh@[oeMGQ0ooDeN400oooooooU9FRooWin`1XooWin`03oiBEX_oo
ooooblcJ00?oblcJ0olo?Cd6ol_<fP03oooooonDUJ;oh=oS00Woh=oS0_ooool2on3Oh`;ooooo00Co
h=oSofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oS
on3Oh`04on3Oh`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03
o`000?oPgn?oh=oS00?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`0Eon3Oh`03
oiBEX_ooooooc<gK00?oc<gK0olo?Cd6olc=f`04oooooonDUJ;oU9FRooooo`;ofm_V00?ofm_Uom_L
iOoKg>D09ooKg>D@om_KiP08oooooon>UJ;oooooohjEX_ooooooSYFRoooooon>UJ86om_KiP[ofm_U
:OoKg>D2om_KiP03om_LiOooooooU9FR06WonOWk00?oU9FRooooooo<cM/01?o<cM/3oclm?@Goc<gK
00?ooooooiBEX_oPgn<02?oPgn<02onh]:?o^;FQoooooooPgn?o^;BSokReXOooooooh=oSofIVO_nX
ZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?oooooon3OhooPgn<01?oP
gn<01Ol0003oh=oSon3OhooPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oS
on3Oh`03on3Oh`03o`000?oPgn?oh=oS00;o00003?oPgn<7o`0000Goh=oS00?oU9FRoooooooAd^00
0_oAd^03oclm?@OodM;P00CooooooiBEX_nDUJ;ooooo0_oKfnH00ooKfnGofmcUom_Li@0Wom_LiA3o
fm_V00SoooooohjEX_ooooooSYFRoooooon>UJ;oooooohjEXPKofm_V2_oKfnDYom_Li@;ofm_V00?o
fmcUoooooonDUJ80JOohn?/00onDUJ;oooooom7Bh005om7Bh0?o?cdm1?oAd^000oooooooU9FRon3O
h`08on3Oh`06okRdXonh]:7oh=oSon3Ohonh]:?o^;BQ0_oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP00
00GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS00Coh=oS00Go0000on3OhooP
gn?oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_l00002on3O
h`03o`000?oPgn?oh=oS00koh=oS1Ol00006on3Oh`04oiBEX_oooooofM[TomWJi0?o?cdm2?oIf^@0
1oooooooU9FRoiBEX_oooooohn?Zon?RjooRh^X02_oShnX:on?RjP[oh^;Z2ooRhnX@on?SjP08oooo
oon>UJ;oooooohjEX_ooooooSYFRoooooon>UJ86on?Rj`[oh^;Z2_oShnX;on?RjP[oh^;Z2_oRhnX0
1OoShn[oh^;[on;SjoooooooU9FR06WomoOi00?oU9FRoooooooIf^@01_oIf^@3oclm?@?ofM[T00?o
oooooiBEX_oPgn<04?oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifM
X@2Fon3Oh`03oooooooPgn?oh=oS00Coh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`03o`00
0?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSo`00000Aon3Oh`?o0000
1ooPgn<00onDUJ;oooooon?Sj`02on?Sj`?o?cdm1ooShn/01oooooooU9FRoiBEX_oooooojNW^onSY
k_oXj>l02_oYjNh:onWXkQGoj>W^2_oXjNl6onWYkP08oooooon>UJ;oooooohjEX_ooooooSYFRoooo
oon>UJ86onSYkP[oj>S_2_oYjNh;onWXkQCoj>W^00Goj>W_onSXk_oXj>kooooooiBEXP1YooCen@03
oiBEX_oooooohn?[00Gohn?[0olo?Cd4on?Sj`03oooooonDUJ;oh=oS00goh=oS0_ooool01?oPgn?o
IVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS
00?oh=oS0_l00003on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oP
gn?o000000;oh=oS00Co0000on3OhooPgn?o00004OoPgn<00ol0003oh=oSon3Oh`06on3Oh`03oiBE
X_ooooook>ca00?ok>ca0olo?Cd6onc/l@07oooooonDUJ;oU9FRoooooooYjNkoj>W^onSXk`0:onWY
kP[ojNS^5OoXjNh:onSYk`KojNW^00SoooooohjEX_ooooooSYFRoooooon>UJ;oooooohjEXPKoj>W^
2_oXj>l:onWYkP_ojNS^5?oXjNh01OoXjNooj>S^onSXk_ooooooU9FR06Wolo?g00?oU9FRooooooo/
k?401?o/k?43oclm?@Gok>ca00?ooooooiBEX_oPgn<03?oPgn<01onh]:?o^;FQoooooooPgn?oIVIn
ojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`04
on3Oh`03o`000?oPgn?oh=oS00;oh=oS0ol00003on3Oh`?o00000ooPgn<2o`0000?oh=oS00?o0000
on3OhooPgn<06?oPgn<00onDUJ;oooooooCdm`04ooCdm`?o?cdm1Oodm?L01?ooooooU9FRoiBEX_oo
oollonc/l@07ooooooo/k?7oooooonc/lOooooook>caooooo`0monc/l@03oooooonDUJ;ol?7f06So
l?7f00?oU9FRooooooodm?L00oodm?L3oclm?@Kom?Cg00?ooooooiBEX_oPgn<03?oPgn<01onh]:?o
^;BQon3OhooPgn?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<0
0oooooooh=oSon3Oh`0eon3Oh`03oiBEX_oooooonocl00Gonocl00?o?cdmoo_lo?oko?`01?oko?`0
1?ooooooU9FRoiBEX_oooon0onc/l@03oooooonDUJ;oko3e06Soko3e00?oU9FRoooooooko?`01?ok
o?`00olo?Cgonocloo_lo005oo_lo003oooooonDUJ;oh=oS013oh=oS00?oIVInojRY^ooko?d00OmV
IWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`0eon3Oh`03oiBEX_oo
oooooooo00gooooo0_nDUJ800ooooooomoOiooOgn@1nooOgn@03oooooonDUJ;ok^od06Sok^od00?o
U9FRooooooooool03Oooool00onDUJ;oh=oSon3Oh`0?on3Oh`03ofIVO_nXZK_onocm007oIVIn0000
1OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?oooooon3OhooPgn<0=OoPgn<00onDUJ;oe]KKoooo
o`0<ooooo`04omKFfonDUJ;oU9FRoo[jnh3ooooo00?on_[koiBEX_o/ko@0J?o/ko@00onDUJ;oe]KK
ooooo`0<ooooo`03omKFfonDUJ;oh=oS013oh=oS00?oIVInojRY^ooko?d00OmVIWh00005ofIVO_ok
o?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`0eon3Oh`04omKKfOn?T9ko]KFnokBd_POo
];Bm00So/kBmokBd_Ond];go/k>mohb=W?oFfmWoeMKIojj_^H3o]kNo00?oYJRfol_>eOo/k_<0J?o/
k_<01?oFfmWoSi2NokFe__nd];h7okBd_@06ok>d_Ond];go];Bmok>c_On<SIcoe]_I4OoPgn<00omV
IWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInUonMWJ400oooooooh=oSon3Oh`0eon3O
ha7ok^gUQ?o[jnMYonGVkQ7ok^gU4OoPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooOooooo`03onk]iOo/kOCoRhbI00coWIj[00GoRX^Ion?VkOmVIWkoZ:Vkoo_lo@01
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ogMkQ00cofM[T00GogMkQ
oiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnD
UJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mV
IWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo
00GoblcJ00?o?cdmol_<f_o;c=X01?o;c=X01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mV
IWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool01?o;c=X3oclm?@GoblcJ00Gooooo
oiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnD
UJ;ooooo00?oc<gK1Olo?Cd4olc=f`05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FRooooo`02om7Bh0?o?cdm00CodM;Poclm?Olo?Cgo
?cdm0ooAd^001OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00Cok^gUoiBEX_oooooofM[T0olo?Cd3omWJi0?o?cdm0_oIf^@01OooooooU9FRofIVO_nX
ZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool00_oS
hn/00olo?Cgohn?[on?Sj`03on?Sj`09oclm?OoShn_ohn?[on?SjoooooooU9FRofIVO_nXZK_onocm
007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03?o/k?401Ooo
ooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gU
oiBEX_ooool03?odm?L01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omV
IWkoooooomoooooo00?ok^gUoiBEX_ooool03?oko?`01OooooooU9FRofIVO_nXZK_onocm007oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03Oooool01?nDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;oe]KK00co
oooo00Goe]KKoiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOoooo
o`05onk]iOoFfmWoSi2NokFe__nd];h01Ond];d02_nc];go];Bmok>d_Ond];go/k>mohb=W?oFfmWo
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gU
ong`l_n;S9X01OnMWZ`00onMWZ_oWIj/oifN[003oifN[006oifO[?n=Si_ok^gUofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FRomgNh@0<om3Ag`05omgN
hOnDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGo
U9FRooooooogmoT2onc/l@;oj>S^00coh^?[om_LiOoKg>Goe=GQolk?gOo<cM_ocLkLoooooonDUJ;o
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oXj>h03?oRh^_ofm_Vom_Ki_oDeN7oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onSYk`0<on?Sj_oKfnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^
00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[o
fmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcU
omGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
O_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?
g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooO
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Co
k^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?oooooo
U9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FR
ooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOg
n@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42
onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00co
h^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcU
om_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCE
hOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oo
oooocoooool5odE>V@;ooooo1Om5CYT4ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oR
h^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02oooo
o`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]co
oooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom?ooooo00?oADjI
ooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oX
jNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool00om5CYWooooooooo
o`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=
foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhnooooo`05okfm
_Om=CDgo0000ode=COnWYjL00oooool01OoYjNWoO7alo`000?mXJ6Sod=3@00;o00000_ooool2o`00
0004olO7aom=CDgoCDe=om3@d0?ooooo00Kol?3`oiZJV_l0003o0000ohb<S?oYjNT3ooooo`05olO7
aomXJ6So0000ode=COnWYjL01?ooool01?o@d=3oCDe=o`000?nWYjL3ooooo`05omWIfOm=CDgo0000
ohb<S?ooool00_l00003ooooo`05omWIfOmXJ6So0000ofQXJ?oIfMT00oooool2o`0000?ooooo0_l0
003oooooodWooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhaooooo`Ko00001_ooool00onm_Kgo0000
o`000003o`000004ojNWYoooooooooooogalO0Ko00000_ooool6o`000004omWIfOooooooooooogal
O0Co000000CoS8b<oooooooooooofMWI1Ol000001?n<S8cooooooooooooIfMT4o`000004ojNWYooo
ooooooooode=C@;o000000CoVYZJooooool0003o00000_ooool00ooIfMWo0000o`000003o`000003
on7QhOoooooooooo00;o00000oooool2o`000?ooooooBOooool00om5CYWoooooooooo`04ooooo`03
odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcU
omCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
OS7ooooo1_l00006ooooo`05ode=COl0003ofMWIoooooooYjNT00_l00002ooooo`;o000000?ofMWI
oooooonWYjL00_l00002ooooo`;o000000Go_Kfmoooooonb/[;o0000ogalO006ooooo`;o00000_oo
ool00omlO7co0000on7Qh@06ooooo`06ogalO?l0003ofMWIonWYjOl0003oCDe=0_ooool2o`0000?o
oooo0_l00002ooooo`07ogalO?l0003oYjNWoooooonWYjOo0000ogalO002ooooo`;o00000oooool2
o`000?ooooooBOooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gU
oiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FR
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOS7ooooo1_l00009ooooo`04onWYjOo7
alOo0000o`0000;ooooo0_l00003ooooo`;o00000_ooool2o`0000;ooooo00?ol?3`o`000?l00000
0oooool01Onm_KgoS8b<ofQXJ?l0003oS8b<00;ooooo1ol00002ooooo`;o00001_ooool2o`0000?o
oooo0_l00002ooooo`;o00000_ooool00oo`l?3o0000o`000002ooooo`;o00000oooool2o`000?oo
ooooBOooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOS7ooooo1_l00007ooooo`03ok:b/_mXJ6So0000
00;o000000?o/[:booooooooool00_l00003ooooo`;o00000_ooool2o`000003oo3`l?ooooool?3`
00;o00000_ooool01Onb/[;o0000o`000?mlO7co_Kfm00?ooooo1_l000000om=CDgoooooooooo`02
o`0000Kooooo0_l00003ooooo`;o00000_ooool2o`0000?ooooo0_l00002ooooo`;o000000?ol?3`
ooooooooool00_l0003oooooodWooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhaooooo`Ko00001_oo
ool00onWYjOo0000o`000002o`000004ok:b/_ooooooooooooooo`;o00000oooool2o`0000;ooooo
0_l000001Onb/[;ooooook:b/_l0003oO7al00;ooooo0_l000000oo`l?3oooooooooo`03ooooo`07
ogalO?l0003ohN7QoooooooQhN7o0000oiZJVP02ooooo`06ogalO?l0003ohN7QonWYjOl0003oJ6QX
0_ooool2o`0000?ooooo0_l00002ooooo`07ogalO?l0003oYjNWoooooonWYjOo0000ogalO002oooo
o`;o000000?oS8b<oooooooIfMT00_l0003oooooodWooooo00?oADjIooooooooool01?ooool00om5
CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoD
eN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWha
ooooo`Ko00001_ooool00om=CDgo0000olO7a`06ooooo`;o00000oooool2o`0000;ooooo1_l00000
1?o@d=3ooooooooooomXJ6P4o`000004ogalO?ooooooooooomWIf@Go000000CohN7Qoooooooooooo
fMWI1?l000000onm_Kgoooooo`000004o`000003ooooool0003o000000;ooooo00?ofMWIo`000?l0
00000ol000000ooIfMWoooooooooo`06o`000003ogalO?oooooooooo0?ooooooAoooool00om5CYWo
ooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWX
kP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVOSgooooo0_l000001OoYjNWoooooomWIfOl0003oCDe=00;ooooo0_l00003
ooooo`;o00000_ooool2o`000004om3@d?m=CDgoCDe=olO7a`?ooooo00KojNWYogalO?l0003o0000
ohb<S?oYjNT3ooooo`05om3@d?mXJ6So0000ofQXJ?oIfMT01?ooool01?o@d=3oCDe=o`000?nWYjL2
ooooo`Go000000?oooooo`000?l000000oooool01OoIfMWoJ6QXo`000?mXJ6SofMWI00?ooooo0_l0
00001OoIfMWoJ6QXo`000?mlO7cojNWY0?ooooooBOooool00om5CYWoooooooooo`04ooooo`03odE>
VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCE
hOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOSgo
oooo00?oYjNWo`000?l000000ol000000onb/[;oooooooooo`09ooooo`;o00008?ooool2o`000?oo
ooooH?ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOSkooooo00GoYjNWode=COl0003oCDe=ok:b/P0<
ooooo`;o00008?ooool00ooQhN7oS8b<ooooo`02ooooo`;o0000oooooomKooooo`03odE>VOoooooo
oooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00co
hn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_oo
ool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkL
oooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooo@ooooo`CoADjI
1_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[o
fmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooloooooo1Om5CYT6oooo
o`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>Go
fmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oY
j>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRoooo
ooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo
00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?oo
ooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWo
ooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3o
c/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
om[ooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Z
om_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjIooooooooool0
0_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_o
cLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03
odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcU
omCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
O_oooooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh0
3?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooog
moT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Co
k^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?oooooo
U9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWooooo
ooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oRh^[ofm_Uom_KiOoDeN3oc]3M
olc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[o
oooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>S_00coh^;Zom_K
iOoKfnGoe=GPolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42
onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;o
ooooooOgn@;ok>ca0_oXj>l03?oRh^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooooiBEX_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjIooooooooool00_oo
ool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>S_00coh^;Zom_KiOoKfnGoe=GPolk@gOo<cM_ocLkL
oooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>
VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCE
h?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oo
oooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oR
h^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkooooooloooooo1Om5CYT6ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBE
X_oooooomoOi0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04
ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<on;Rj_oK
fnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Co
k^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?oooooo
U9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWooooo
ooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<
on?RjooKfnKofm_VomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;o
oooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on?RjooKfnKofm_VomCEh?o>cmcoc<gKolg>
g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOSkooooo0ol00004oooo
o`;o00000_ooool2o`000004ooooool0003o0000ooooo`;o0000oooooon2ooooo`03odE>VOoooooo
oooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00co
hn;[om_Ki_oKfnKoe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVIn?oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooooooo`3ooooooh7ooooo00?oADjIooooooooool0
1?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oSh^_o
fm_Vom_Ki_oDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWhoooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool01Ol0003o
oooooooooooooooo00000?ooooooPoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo
00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on?RjooKfnKofm_VomCEh?o>cmcoc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOSoooooo00?o0000
ooooooooool00_ooool4o`0000?ooooo00Go0000ooooooooooooooooo`00003ooooooh?ooooo00?o
ADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca
0_oXjNh03?oSh^_ofm_Vom_Ki_oDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWhoooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo0?ooooooPOooool00om5CYWo
ooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSY
kP0<on?RjooKfnKofm_VomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVOSoooooo00?o0000ooooooooool00oooool2o`0000;ooooo0_l000000ooo
oooo0000o`000003o`000?ooooooP_ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo
00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?46ohjEXP08olk?g?o<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn?oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo0?ooooooPOooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;o
oooo00Gok^gUoiBEX_oooooomoOionc/l@06ooooo`09omCEh?o>cmcoc<gKolg>g?ooooooU9FRofIV
O_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWhlooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`3ooooooh7ooooo00?oADjIoooooooo
ool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca1_n>UJ802?o>
cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOScooooo
1ol0003ooooooi3ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`05onk]
iOnDUJ;oooooooOgnOo/k?401_ooool02OoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_l
o@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?o
ADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@KoSYFR00Soc/oMolc=foo=c]co
oooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom?ooooo00?oADjI
ooooooooool01?ooool00om5CYWoooooooooo`02ooooo`05onk]iOnDUJ;oooooooOgnOo/k?401_oo
ool02OoDeN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnX
ZK_oIVInooooooo@ooooo`CoADjI1_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca1_n>UJ802?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;o
oooo00Gok^gUoiBEX_oooooomoOionc/l@06ooooo`09omCEh?o>cmgoc<gKolg>g?ooooooU9FRofIV
O_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkooooooloooooo1Om5CYT6ooooo`03odE>
VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKfnKofm_VomCE
h?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oo
oooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oS
hn[ofm_Vom_Ki_oDeN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2
onc/l@;ojNW^00cohn?Zom_Ki_oKfnKoe=GPolk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gU
oiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKfnKofm_VomCEh?o>cmgoc<gKolg>g?ooooooU9FR
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWooooooooo
o`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofm_Vom_Ki_oDeN3oc/oMolc=
foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo
00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_Ki_oK
fnKoe=GPolk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSY
k`0<on?Sj_oKfnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oXjNl03?oShn[ofm_Vom_Ki_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool0
1?o^kNGoU9FRooooooogmoT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooo
oonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoo
oooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<on?Sj_oKfnKofm_VomCEhOo>
d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooo
f_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNl03?oShn[o
fm_Vom_Ki_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/
l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBE
X_oooooomoOi0_o/k?42onSYk`0<on?Sj_oKfnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNl03?oShn[ofm_Vom_Ki_oDeN7oc]3Molc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo00?o
ADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKo
e=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<
on?Sj_oKfnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooocoooool5odE>V@Kooooo00?oADjIooooooooool00_ooool01?o^kNGo
U9FRooooooogmoT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;o
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo
00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Z
om_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool0
1?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooo
oonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoo
oooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^
00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool0
0_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_o
cLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03
odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/
l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVIn7_ooool00ooIfMWoVYZJo`000002o`000003ogalO?o7alOooooo
00Gooooo00Ko/[:bofQXJ?l0003o0000oiZJV_oYjNT5ooooo`06om3@d?mlO7co0000o`000?nJVY[o
hN7Q0oooool01OoYjNWoS8b<o`000?l0003oS8b<00;ooooo0ol00004ooooo`06om3@d?mlO7co0000
o`000?mlO7cod=3@1?ooool3o`0000Cooooo0ol0003oooooog;ooooo00?oADjIooooooooool01?oo
ool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcU
om_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWhMooooo`03ojNWYol0003o000000Go000000KoS8b<oooooooooooooooooo3`l?mXJ6P5o`00
0003ode=COoYjNWooooo00;ooooo00?oYjNWo`000?l000001?l000001?oIfMWooooooooooonJVYX3
o`000003oiZJV_oooooooooo00?o00000oooool00onWYjOo0000o`000004o`000004ojNWYooooooo
ooooooooo`?o00001?ooool3o`000?ooooooL_ooool00om5CYWoooooooooo`04ooooo`03odE>VOoo
oooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?
cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo
00?ohN7Qo`000?l000001ol000001?nm_Kgooooooooooonb/[82o`000003oiZJV_oooooofMWI00;o
000000CoS8b<ooooooooooood=3@0_l000001_mlO7col?3`oooooonWYjOo0000ofQXJ0;ooooo0ol0
0004ooooo`?o00000_ooool01?oIfMWo0000o`000?mlO7`2oo3`l004ogalO?l0003o0000on7Qh@;o
oooo0ol00004ooooo`?o0000oooooombooooo`03odE>VOoooooooooo00Cooooo00?oADjIoooooooo
ool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ooool01OnJ
VY[o0000o`000?mlO7col?3`00;ooooo00CoYjNWo`000?l0003oCDe=0_ooool01?mlO7co0000o`00
0?oYjNT7ooooo`04ohb<S?l0003o0000omWIf@;ooooo00?ol?3`ohb<S?oQhN400_ooool3o`0000Co
oooo0ol00002ooooo`04oiZJV_l0003o0000omWIf@;ooooo00CofMWIo`000?l0003oVYZJ0_ooool3
o`0000Cooooo0ol0003oooooog;ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhLooooo`04ode=COl0
003o0000oo3`l0Cooooo0ol00002ooooo`?o00002?ooool3o`0000Sooooo0ol00004ooooo`?o0000
0_ooool00om=CDgo0000o`000004ooooo`;o000000?oCDe=ooooooooool00ol00004ooooo`?o0000
oooooombooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FR
ooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn8_ooool01OoQhN7oVYZJo`000?l0003oJ6QX
00;ooooo2Ol00002ooooo`?o00002?ooool3o`0000Cooooo0ol00002ooooo`?o00001?ooool3o`00
00;ooooo0ol00004ooooo`?o0000oooooombooooo`03odE>VOoooooooooo00Cooooo00?oADjIoooo
ooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?
gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7oooool0
0oo7alOoVYZJode=C@04o`000003olO7aooooooooooo00Wo00000_ooool3o`0000Sooooo0ol00004
ooooo`?o00000_ooool00om=CDgo0000o`000004ooooo`;o000000?oCDe=ooooooooool00ol00004
ooooo`?o0000oooooombooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool0
1?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooo
oonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7Oooool00oo@d=3oCDe=o`00
0005o`000005okfm_OoooooooooooooooomlO7`00_l00003ooooo`;o000000CoO7aloooooooooooo
S8b<0_l000001_oQhN7oooooooooooo`l?3oS8b<on7Qh@;ooooo0ol00004ooooo`?o00000_ooool0
1?nJVY[o0000o`000?oIfMT2ooooo`04omWIfOl0003o0000oiZJVP;ooooo0ol000001?oQhN7ooooo
ooooooooool3o`000?ooooooL_ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;o
oooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>
g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo00?ofMWIo`00
0?l000000ol000000on<S8coalO7oo3`l004ooooo`06ok:b/_l0003o0000omWIfOoooooo_Kfm0_l0
00001?nb/[;oooooooooooo@d=02o`000006ogalO?o`l?3oooooojNWYol0003oO7al0_ooool3o`00
00Cooooo0ol00002ooooo`04on7QhOl0003o0000ogalO0;ol?3`00CoO7alo`000?l0003ohN7Q0_oo
ool3o`000004ogalO?o`l?3oooooojNWY`;o000000?oJ6QXooooooooool0oooooom`ooooo`03odE>
VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;o
j>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVIn7?ooool01OmlO7co0000o`000?n<S8cofMWI00Wooooo00?oCDe=o`00
0?l000000ol000000om=CDgol?3`ooooo`02ooooo`03ojNWYol0003o000000Co000000?ohN7Qoooo
ool000001Ol00002ooooo`?o00000oooool00onWYjOo0000o`000004o`000004ok:b/_oooooooooo
ooooo`?o000000?oO7alo`000?l000000ol000000onm_Kgoooooooooo`3oooooog3ooooo00?oADjI
ooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oX
jNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWhLooooo`?o00001?ooool01?o`l?3o0000o`000?l00004ooooo`06ojNW
Yom=CDgo0000ode=COnWYjOol?3`1Oooool01_o@d=3oS8b<o`000?l0003oVYZJon7Qh@;ooooo1_l0
0002ooooo`?o00001?ooool01_oIfMWoO7alo`000?l0003oO7alomWIf@Cooooo0ol000001_oooooo
YjNWode=COl0003oJ6QXokfm_OooooooLoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooo
oooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgo
c<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo00Co
O7alo`000?l0003oYjNW0_ooool01Oo`l?3oS8b<o`000?l0003oO7al01Sooooo0ol0003ooooooi7o
oooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOg
n@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWhLooooo`03olO7aol0003o000000Oo000000?od=3@oooo
ooooool05_ooool3o`000?ooooooTOooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo
00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQgooooo00?oO7al
o`000?l000001Ol000000onWYjOoooooooooo`0Gooooo`03omWIfOm=CDgo000000Cooooo0ol0003o
oooooh[ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;o
ooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhNooooo`03okfm_OmlO7co000000;o000000?o
S8b<om3@d?ooool06oooool00onJVY[oooooooooo`02ooooo`?o0000oooooon:ooooo`03odE>VOoo
oooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^
00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool0
0_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_o
cLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03
odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/
l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIoooo
ooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?
g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooC
ooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooog
moT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?o
ADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Go
e=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FR
ooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Co
oooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_L
iOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVInooooooo@ooooo`CoADjI1_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool0
0om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_L
iOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWhKoooooooo0000[ol00005ooooo`GoADjI0_ooool5odE>V@Cooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;o
jNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oS
hn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>Go
fmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GP
olk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooo
oooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=
foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo
00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?oo
ooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGo
U9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;o
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^
00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[o
fmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcU
omCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
O_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>S_00coh^;Zom_KiOoKfnGoe=GPolk@
gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooO
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oSh^_ofm_Vom_Ki_oDeN3oc/oLolc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Co
k^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKfnKofm_VomCEh?o>cmgoc<gKolg>g?oooooo
U9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FR
omKFf`0<ooooo`05omKFfonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oo
oooogoooool00oo^kNGooOgjoi2AW`05okNg_`03okBd_Ong]koo]kNo00Co]kNo00GoT96Oonk]iOmV
IWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOo/kOCoRhbI
00coWIj[00GoRX^Ion?VkOmVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooO
ooooo`03onk]iOnDUJ;ogMkQ00cofM[T00GogMkQoiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vk
oo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ
00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03
onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00;oblcJ00?o?cdm
ol_<f_o;c=X00oo;c=X02Olo?CgoblcJol_<f_o;c=[ooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooolc=f`?o?cdm0oo<cM/3oclm
?@;oc<gK00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooO
ooooo`03onk]iOnDUJ;ooooo00;odM;P0olo?Cd01?oAd^3o?cdmoclm?Olo?Cd3om7Bh005oooooonD
UJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FR
ooooo`03omWJi0Go?cdm1?oIf^@01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool01?oShn/3oclm?@Gohn?[00GooooooiBEX_mV
IWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo
00Gok>ca00?o?cdmonc/lOo/k?401?o/k?401OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mV
IWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03?odm?L01OooooooU9FRofIVO_nX
ZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03?ok
o?`01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo
00?ok^gUoiBEX_ooool03Oooool01?nDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVInoooooooOooooo`03onk]iOnDUJ;oe]KK00cooooo00Goe]KKoiBEX_mVIWkoZ:Vkoo_lo@01ofIV
OP0000CoIVInoo_loOnXZK_oIVInool0003Oo`000005onk]iOoFfmWoSi2NokFe__nd];h01Ond];d0
2_nc];go];Bmok>d_Ond];go/k>mohb=W?oFfmWoIVInojRY^ooko?d1ofIVOP0000?oIVInooOgnOnH
V:L0oomgMi;bogMgTP7oV9RW0OogmoT1ofIVOP0000?oIVInooOgnOnl_Ld0oonl_Lgcokbmc@7omoOi
0OmVIWh00003ofIVO_ogmoWoi>?S0?ooi>?SlooThn<1ooOgn@7oIVIn00000omVIWkol?7dooooo`04
ooooo`03ojNWYonSXZ?oXZ:R00;oXJ6Q00?oX:2PojFNUOnZW8T00_nOWil2oj2PX0;oXJ6Q00?oYjNW
ooooooooool0oooooon/ooooo`03onCShonLY;WoJgF?00;oJgF?0_m/MY05of]eS`06oibT^OoThn?o
oooooooooooThn?oW:Bi0om[MHl2ofafT0GoJgF?00KoW:BionCShooooooooooooncZj_nLY;T3ojHi
A0;oYcY41OnV>D@00onLY;Wok>[Zooooo`03ooooo`7ol?7d0OmVIWh00009ofIVO_oRhN;onocloo_k
o?oko?goo?_moiRHVOnKVi_o[:b/00?ojNWY00[oj^[Zon?6N_oINQCok>c/ong]kOo^k^kolNOEoo3`
l?obl_;oXj>S0_olo?`01?olo?goo?cloo_koOolo?fCoocko9;onoclP_oko?d00onLY;WoJgF?ohF9
/009ohF9/006of]eSonLY;Wonocmoo_loOnLY;WoJgF?2_n5RK001_m[MHooW:Bioo_ko?oko?goW:Bi
ojHiA0[oZSaE00OoYSU4oibT^Ooko?coo?cloockoOoko?goh^7R007oIVIn00001?mVIWkoh>3QooKg
nOogmoT2ooKgn@05ooKgn?nPX:3oj^[ZonWYjOojj:T00_oZj^X02_ohiASocFL0ong]kOo^k^komZPc
ooK>S?obl_;olo?coj>SXoogmoT3ooKgn@03ooKgn?ogmoWoal;A00?oal;A0_ogmoT01Oo7`]7omoOi
ooOgnOogmoWoal;A00?omoOi0_o7`]42ooOgn@04olO2dOogmoWomoOiooOgn@;oal;A00ComoOiolO2
dOogmoWomoOi0oo7`]43ooOgn@Coal;A2?ogmoT01Oo7`]7omoOiooOgnOogmoWoal;A00;omoOi00Ko
al;AooOgnOogmoWomoOiolO2dOogmoT4olO2dEComoOiT_ofmoV2ooOgn@03of]eSon5RK3oW9jn00Wo
W9jn00KoQHV`of]eSoogmoWomoOiof]eSon5RK0:oibN_P08ohF9/?m[MHoomoOhooOgnOnV>DCoZSaE
ol9BFoo6E5X6olIEG009olIDF_o2DU_oZSaEojHiA?ogmoSomoOiooOgn?ogmoWoh>3Q007oIVIn0000
6omVIWkog]gQoo7am?oalOCol?7doo3bm?nQXJ?oShn?ohj>S_oYjNWodG/0olXa0?o:MUGoooL0on^[
0?oKWWooiJ1iomM20?obl_;olo?cooCdm?nTY:ColO7doo3bmOoalOColO;doo3bm004o`h@4004oo3a
mOo7`]7o3Q0@olO2d@;ol?7e00Co3Q0@olO2dOo`lOGol?7e0_l>4102oo3am@04o`h@4?o7`]7ol?7e
oo3am@;o3Q0@00Col?7eo`h@4?o7`]7ol?7e0ol>41000oo`lOGoal;Aoo3am@04o`h@4003olO2dOo`
lOGol?7e00Gol?7e00Wo3Q0@olO2dOo`lOGol?7eo`h@4?o7`]7ol?7eo`h@4?o7`]400_o`lOD00ol>
413oal;Ao`h@4003o`h@4003oo3amOo7`]7ol?7e0>Col?7eP_o`lO@00om[MHoo/[G@ojNX`P09ojNX
`P06ok:ed?m[MHool?7doo3am?m[MHoo/[G@1oooool3ojNX`P05ok:ed?m[MHool?7doo3am?nV>D@0
0_o2DU/00oo;E5WocEUNoleIGP04oleIGP04ol]DFOo2DU_o`U9KojHiA0;ol?7d00?olO7doo3bm?oN
gN400OmVIWh00009ofIVO_oLfn3oj^_`on[[l?oZk?3ojN__oiBDUonSXj?oinKV00;oj^[Z00_o]``0
om1h0?ooi@3onl`0omR80?noBP3o]d@0okY@>_oIVV7ooM`0okV^NP02on[[l004on[[kooZjo3o3Q0@
olO2d@?oj^_`00Co3Q0@olO2dOl>413oal;A0_oZjo001Ol>413oal;Aon[[l?l>413oal;A00?oj^_`
00Go3Q0@olO2dOoZjo3o3Q0@olO2d@02on[[l004o`h@4?o7`]7o3Q0@olO2d@;oj^_`00Co3Q0@on[[
l?l>413oal;A0_oZjo000ol>413oal;Aon[[l006on[[l005o`h@4?o7`]7oj^_`on[[l?l>41000_oZ
jo002?l>413oal;Aon[[l?oZjo3o3Q0@olO2dOl>413oal;A0_oZjo000ol>413oal;Aon[[l01Bon[[
l9;oj^c`P_oZjnl00om[MHoo][WAojf^aP06ooooo`;o[Jk600?o[:k6okJidOm[MHl00_oZjnl00om[
MHoo][WAooooo`06ofi]S`05obDU=_n][/Ko[:k6okJidOm[MHl00_oZjo000onV>DCocEUNol]DF@02
ooooo`?od5YO0_ooool01_o=EU_obeAIoleIG_nV>DCoj^__on[[l0;oj^__0OoLfn01ofIVOP0000?o
IVInomOHg_oLg^H00ooLg^H04OoLg^GoQXN6okj>E_oigdSonNi2onbf0?okd03ol;X0onZ`0?oY/P3o
fX/0olnE0?oR_`3oo]l0ooK`g?nTYJGog=kV00;og=kU00?og=kVo`h@4?o7`]400ooLg^D01?l>413o
al;Ao`h@4?o7`]42omcNi@05o`h@4?o7`]7og=kUo`h@4?o7`]400ooLg^D01Ol>413oal;AomcNiOl>
413oal;A00;og=kU00?o3Q0@olO2dOl>41001Oo7`]401ol>413oal;AomcNiOoLg^Go3Q0@olO2dOoL
g^D00oo7`]43omcNi@03o`h@4?o7`]7og=kU00Cog=kU00So3Q0@olO2dOoLg^Gog=kUo`h@4?o7`]7o
3Q0@olO2d@;og=kU00?o3Q0@olO2dOoLg^D0oooLg^EWomcNi@04of]eSono`MKo^;W>ooooo`CoKVf?
00Ko9BDfokRic_nh^Lko^;W>oko1e_m[MHl2omcNi@04of]eSono`MKoooooofi]S`Co^;W>00Kooooo
obDU=_nh^Lko^;W>oko1e_m[MHl2omcNi@03ojHiA?o=FEkodEYN00?ooooo00SoeUmSoooooooooooo
ooooomAMHOoAFUkocEUNojHiA0;og=kU00?og=kVomcNiOoGf=h00OmVIWh00004ofIVO_oEe]goeMSP
omKHh@;oeMSP013oNg^0oiBDU?nMO4[oag80onNT0?ooj03ojkH0onVZ0?oX[03odh40okY<0?oR^P3o
n_9gooKfm_ohn?SoYJBU0_oEf>401?oEen3oe]SPo`h@4?o7`]43omKGh004o`h@4?o7`]7o3Q0@olO2
d@;oe]OP00Go3Q0@olO2dOoFen3o3Q0@olO2d@03omKGh005o`h@4?o7`]7oe]OPo`h@4?o7`]400_oF
en000ol>413oal;Ao`h@4004o`h@4003olO2dOl>413oal;A00;oe]OP00?o3Q0@olO2dOl>41000_l>
4104omKGh003o`h@4?o7`]7oe]OP00Coe]OP00So3Q0@olO2dOoFen3oe]OPo`h@4?o7`]7o3Q0@olO2
d@;oe]OP00?o3Q0@olO2dOoFen00D_oFen2BomKHh8;oeMSQ00?oJgF?ol_<g_o8b]T01_lU9CH01Oo8
b]Wob<WIolS:fOo;c=koJgF?00;oeMSQ00CoJgF?ol_<g_ooooooKVf?0oo8b]T03Oo8bMWoooooobDU
=_o8bMWob<[Iol_<g_m[MHooe]SQomKHh?nV>DCoeemOom]TI?m67QX01Oooool02_m67Q[oh6MUom]T
I?oGGeooYSU4omKHh?oEf>7oeMOPomGHhOoEe]d1ofIVOP0000GoIVInom;DgOo?d]cod=;Lom3Bg@02
om3Bg00?oiNGUong]kOok>c/omjfO_oIR03ol/@0onfa0?oXZP3oe7D0okiX0?ole@3onmmiooSflOoi
nOWoYJFU00?od=;L00?ocm;Lo`h@4?o7`]400oo@d]`00ol>413oal;Ao`h@4003olO2d@04o`h@4?o@
d]cod=;Lo`h@40?oal;A00God=;Lo`h@4?o7`]7od=;Lo`h@4003olO2d@04o`h@4?o7`]7o3Q0@om3B
g0;oal;A00Co3Q0@om3Bg?l>413od=;L0_o7`]400ol>413oal;Aom3Bg005om3Bg003olO2dOl>413o
al;A00God=;L00Oo3Q0@olO2dOo7`]7oal;Ao`h@4?o@d]co3Q0@00?oal;A00?o3Q0@om3Bg?o@d]`0
D_o@d]bBoloBgH;od=;L00?oJgF?om?Ch_o?d=d02Oo?d=d02?oCdn;oJgF?om3Bg?o@d]coJgF?om?C
h_ooooooKVf?1?o?d=d03Ooooooo9BDfolo@gOo?d=godm?Rof]eSoo@d]cocm;LojHiA?oKI6CohFUU
on1/JOm67QX00oooool01om67Q[oh6aYon1/JOoQJFGoffATojHiA?o@d]d00_o@d]`1oloBg07od]CM
0OmVIWh0000LofIVO_o@d]_oblgHol[=fOo;c]Sob/gHogYlP_nIVIWoYZNVong]kOoWbX[oafP0oo:i
0?oLR@3obVL0okHa0?nkDP3oolX0oonl0?ok^@3omk80olZ[H?o;cMSoblgIol[=fOo;c]So3Q0@olO2
d@?oblgI00?o3Q0@olO2dOl>41000ol>4102ol_=f@Co3Q0@00CoblgIo`h@4?l>413oblgI1?l>4100
1?o;cMWo3Q0@olO2dOo;cMT3o`h@40?oblgI1?l>41000oo7`]7oblgIol_=f@03ol_=f@04o`h@4?o;
cMWo3Q0@olO2d@GoblgI1?l>4102ol_=f@Co3Q0@EOo;cMVBol_>fH;oblgH00CoJgF?omKFi?oHf>Go
f=SV0_oHf>D2omSHiP06omSHiOoHf>Kof=SUomSHiOoFe^CoJgF?0_o;cMP01?m[MHooe]KToooooom^
KHl5ooooo`0;obDU=_oHf>Gof=SUomKFi?m[MHooblgIol[>f?nV>DCoi6i]onAdKooWLFl01Oooool0
1ooTM6ooig5_onAdKooTKVgoYSU4ol[>f?o:c]T00_o;cMT1om3Bf`7oIVIn00000omVIWkocloJolG8
e004olG8e00@oijNWOoShn?ok;9NomZH0?oBO03ogY<0omUl0?oHN@3o]3@0oj060?o_VP3ooj`0oo[f
k?okn?7o]ZR7olG8e0;oaLOD00?oaLOEo`h@4?o7`]400oo4amD00ol>413oal;AolC7e@06olC7e@03
o`h@4?o7`]7oa<OE00?oa<OE00Coal;AolC7eOl>413oal;A0_o4amD00ol>413oal;AolC7e@09olC7
e@03o`h@4?o7`]7oa<OE00Goa<OE0_l>41000oo7`]7oa<OEolC7e@09olC7e@03o`h@4?o7`]7oa<OE
05Koa<OET_o4b=B2olC7e003of]eSooEe>?oh=oZ00Woh=oZ00OoeMCSof]eSoo4amCoa<ODof]eSooE
e>?ooooo00KoKVf?00[o9BDfon3Oj_oPgn[oeMCSof]eSoo5b=Coa<SDojHiA?oZNG?ojGah0oooool0
2Om67Q[oooooooooooooooookh5jonUlN?oZNG?oYSU4olC8e@02olC8e07oaLOE0Oo?cmX1ofIVOP00
00CoIVInolc>f_o2a=;o`LCA0_o1a=804?n1PhcoSHf=ogmgKooPV`3ol?3`onBmV?o/[@3ooml0ooo6
0?oZY`3o`V00om5e0?ohYbgono_kooclo?nVYZH3ol74dP03ol;4dOl>413o`LCB00?o`LCA00?o3Q0@
ol74dOo1a=401_o1a=400ol>413o`LCAol74d@02ol74d@04o`h@4?o1a=7o`LCAo`h@40?o`LCA00?o
3Q0@ol74dOo1a=402Oo1a=400ol>413o`LCAol74d@06ol74d@03o`h@4?o1a=7o`LCA00[o`LCA00?o
3Q0@ol74dOo1a=40E_o1a=6Bol74dX;o`/CB00?oJgF?ong[looYj?402OoYj?401oo]jo?oJgF?ol;4
d_o2a=;oJgF?ong[looYj?401olU9CH2onWXl@07ong[lom[MHoo`/CAol74dOnV>DColH1eoo24O002
ooooo`03odHN6_oa/Y_oAQhJ00;ooooo00WomHb4oo24O?oaP7GoYSU4ol74d_o2a=7o`LCAol74d_o<
c]X00OmVIWh00004ofIVO_o:c=So_/3?okg0c`;o_/3>01GoRhfHoijNW_oEe=Col?3`oo;bl_oXbj_o
n=80ooKTQoocdXgolZ80ono9TOoWaJ;ohH40ooclo?omoOgoYZNWokk0c_nn`<oo_/3>okk0conm`<h0
U?nn`<jBokg0cX;o_/3>00?oJgF?om;AhooblOL02OoblOL01_oBdN?oJgF?okk0c_nn`<koJgF?om;A
h`[ol_7g00Ood]7Sof]eSonm`<ko_/3>ojHiA?odRWgomI2500;oAQhJ0oob^9h2odHN6P;omI2500?o
m8YmojHiA?nm`<l00_nn`<l1okk0cP7ob/cH0OmVIWh0000LofIVO_o9b]So][S8okVlbonj_<_o^[c<
okZlbon6QXKoU9BCoo;bl_oclo?oiZ@0ooS][_ofm_Kolm^/onZG0?ojn_[ono_koo7J^ooi]Rooo_kn
ojNWYoni_<co^[_<okVlbonj_<_o^Kc<okVlbi?o^Kc<T_nj_<b2okZlb`04ohB<X_m[MHooc<_Moo_k
o0Kooooo00Cono_lolc;gOm[MHooQ8bR0_nj_</01?n4S:;oJgF?olc;gOokno`6ooooo`0;oo_ko?o<
bmgoJgF?ohB<X_nj_<co^Kc<oi6HZ_nV>DCooin=oojoY?ojg;L00_ojjKH2ooWY]P0:oo[L]oon_jCo
oin=ojHiA?nAV:[o^[c<okZkc?ni_<_o][S8olW:f07oIVIn00000omVIWkoa/SGokRgc`03ojn^a`0=
og=bP_nPX:3ohN3Qoo?cloo/ilool^cNooKfm_ohn?SonOWionJ;0?okno_oo?cloogmo@02ooknoP03
ojNWYon_[/Oo[jk70?oo[jk7[On_[/L00on4S:;oJgF?of]eS`08of]eS`03ohB<X_n_[/Oo[jk700;o
[jk700?oQ8bRof]eSom[MHl02?m[MHl00on4S:;o[jk7ojn^a`02ojn^a`03ohB<X_nV>DCoYSU400So
YSU400?oQ8bRojn^aon_[/L00_n_[/L1okRgc`7oa/SG0OmVIWh00003ofIVO_o0`M7oalOD00Co[:_4
00?oSHf=ojZZZ_nZZZX01OnZZZX00ondYXkoZZZZojZZZP04ojZZZ_oo[:_4gon/Zl@1olO7e07o`<7A
0OmVIWh00006oooooonXYkooi^K]om;Bh?nl_<oo/K34oonXYko/ojRW_`05ok6`a?nl_<ood];PonKV
kOnXYkl00Oooool00007oooooon7Qi_oemSRooclo?oThnSod=3Pol[:fP3ookblcn[o_;c?00Kob/[J
om3@h?oThnSoo?clomOHh_n7Qi/1ooooo`000_ooool01_nEU:_oemSRooclo?oblO?ok>_^on7Rjooo
emSRj?oGf>801_oQh^_ok>_^oo;aloolo?coemSRoiFDZ`;ooooo0003ooooo`;oIVIn00?oR8NMoiFD
ZonXYkl0oonXYkoYojRW_`04oiFDZon8QigoIVInofIVOP?ooooo0005ooooooooIVInk_mVIWh5oooo
o`00\
\>"], "ListGraphic",
 Evaluatable->False,
 ImageSize->{503, 287},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Outline Format", "i:85"}],

Cell["\<\
This is because in the resulting browser categories file, the section cell \
will have to serve both as an item (to display the text cell) and a category \
(to contain the subsection cell), which is not possible.\
\>", "Text",
 CellTags->{"Outline Format", "i:85"}],

Cell["\<\
Note that if a section cell group contains only text cells and no subsection \
cells as shown here, the strict outline format is again restored because now \
the section cell can serve as an item.\
\>", "Text",
 CellTags->{"Outline Format", "i:85"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007g00017b000`400?l00000o`00003ooomVIWkh
ofIVOP0000?oIVInoo_loOoko?d0oooko?gdoo_lo@7oIVIn00000omVIWkonocmojRY^`3oojRY^o?o
Z:Vk0Ooko?d1ofIVOP0000?oIVInoo_loOnXZK/0oomVIWkbofIVOP7oZ:Vk0Ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInV?oooolgon3Oh`03onc]m?n;S9WoWIj[00coWIj[00CoRX^Ion?VkOo^kNGo
^KZnP?nMWZ/00onm_Kook^gUonGVkP1XonGVkP03onc]m?n;S9WoWIj[00coWIj[00?oRX^Ion?VkOoP
gn<04?oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03
oooooooPgn?oh=oS03Goh=oS00?oU9FRomgNhOoIf^@03?oIf^@01?oMg^7oU9FRoiBEX_oJfmj0olO8
eP03om[Kg_nQXZkono_n06Sono_n00?oU9FRomgNhOoIf^@03?oIf^@00ooMg^7oU9FRon3Oh`05on3O
h`;ooooo0_oPgn<2ooooo`;oh=oS0_ooool01?oPgn?oIVInojRY^ooko?d1ofIVOP0000GoIVInoo_l
oOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS03Goh=oS00?oU9FRooooooo;c=X03?o;c=X0
1?ooooooU9FRoiBEX_oooon0olg>g003oooooonDUJ;ono_n06Sono_n00?oU9FRooooooo;c=X03?o;
c=X00oooooooU9FRon3Oh`04on3Oh`0?okRdXonh]J7oooooon3Ohonh]:?o^;FQoooooooPgn?o^;BS
okReXOooooooh=oSofIVO_nXZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS
00?oooooon3OhooPgn<0=OoPgn<00onDUJ;ooooool_<fP0<ol_<fP04oooooonDUJ;oU9FRoooooh3o
c<gK00?ooooooiBEX_oknoh0J?oknoh00onDUJ;ooooool_<fP0<ol_<fP03oooooonDUJ;oh=oS00Co
h=oS00Ko^;BSokRdXOoPgn?oh=oSokRdXonh]:42on3Oh`07okRdXonh]:7oh=oSon3OhomVIWkoZ:Vk
oo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS00?oh=oS
0ol00003on3Oh`?o00000ooPgn<3o`0000Goh=oS00Co0000on3OhooPgn?oh=oS0_l0000Hon3Oh`03
oiBEX_ooooooblcJ00GoblcJ00?o?cdmol_<f_o;c=X01?o;c=X01oooooooU9FRoiBEX_ooooooc/oM
olk?g?o>d=d05?o>cm`:olo?g@_ocloL2_o>d=d:olk?g@[oc/oL2_o>d=dEolk?g0[ocloM2_o?cm`0
1Oo>d=goc/oMolk?gOooooooU9FR06Won_[m00?oU9FRooooooo;c=X01?o;c=X00olo?CgoblcJol_<
fP05ol_<fP03oooooonDUJ;oh=oS013oh=oS00?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?go
Z:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`04on3Oh`05o`000?oPgn?oh=oSon3Ohol00000
0ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o
00000_oPgn<00ol0003oh=oSon3Oh`0Eon3Oh`03oiBEX_ooooooblcJ00CoblcJ0olo?Cd5ol_<fP04
oooooonDUJ;oU9FRooooo`goe=GP5?oDeN4;omGEh@[oe=GQ1ooDeN001on>UJ;oe=GPohjEX_oDeN3o
SYFRomCEh?n>UJ806_oDeN0EomCEh@[oeMGQ0ooDeN400oooooooU9FRooWin`1XooWin`03oiBEX_oo
ooooblcJ00?oblcJ0olo?Cd6ol_<fP03oooooonDUJ;oh=oS00Woh=oS0_ooool2on3Oh`;ooooo00Co
h=oSofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oS
on3Oh`04on3Oh`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03
o`000?oPgn?oh=oS00?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`0Eon3Oh`03
oiBEX_ooooooc<gK00?oc<gK0olo?Cd6olc=f`04oooooonDUJ;oU9FRooooo`;ofm_V00?ofm_Uom_L
iOoKg>D09ooKg>D@om_KiP08oooooon>UJ;oooooohjEX_ooooooSYFRoooooon>UJ86om_KiP[ofm_U
:OoKg>D2om_KiP03om_LiOooooooU9FR06WonOWk00?oU9FRooooooo<cM/01?o<cM/3oclm?@Goc<gK
00?ooooooiBEX_oPgn<02?oPgn<02onh]:?o^;FQoooooooPgn?o^;BSokReXOooooooh=oSofIVO_nX
ZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?oooooon3OhooPgn<01?oP
gn<01Ol0003oh=oSon3OhooPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oS
on3Oh`03on3Oh`03o`000?oPgn?oh=oS00;o00003?oPgn<7o`0000Goh=oS00?oU9FRoooooooAd^00
0_oAd^03oclm?@OodM;P00CooooooiBEX_nDUJ;ooooo0_oKfnH00ooKfnGofmcUom_Li@0Wom_LiA3o
fm_V00SoooooohjEX_ooooooSYFRoooooon>UJ;oooooohjEXPKofm_V2_oKfnDYom_Li@;ofm_V00?o
fmcUoooooonDUJ80JOohn?/00onDUJ;oooooom7Bh005om7Bh0?o?cdm1?oAd^000oooooooU9FRon3O
h`08on3Oh`06okRdXonh]:7oh=oSon3Ohonh]:?o^;BQ0_oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP00
00GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS00Coh=oS00Go0000on3OhooP
gn?oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_l00002on3O
h`03o`000?oPgn?oh=oS00koh=oS1Ol00006on3Oh`04oiBEX_oooooofM[TomWJi0?o?cdm2?oIf^@0
1oooooooU9FRoiBEX_oooooohn?Zon?RjooRh^X02_oShnX:on?RjP[oh^;Z2ooRhnX@on?SjP08oooo
oon>UJ;oooooohjEX_ooooooSYFRoooooon>UJ86on?Rj`[oh^;Z2_oShnX;on?RjP[oh^;Z2_oRhnX0
1OoShn[oh^;[on;SjoooooooU9FR06WomoOi00?oU9FRoooooooIf^@01_oIf^@3oclm?@?ofM[T00?o
oooooiBEX_oPgn<04?oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifM
X@2Fon3Oh`03oooooooPgn?oh=oS00Coh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`03o`00
0?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSo`00000Aon3Oh`?o0000
1ooPgn<00onDUJ;oooooon?Sj`02on?Sj`?o?cdm1ooShn/01oooooooU9FRoiBEX_oooooojNW^onSY
k_oXj>l02_oYjNh:onWXkQGoj>W^2_oXjNl6onWYkP08oooooon>UJ;oooooohjEX_ooooooSYFRoooo
oon>UJ86onSYkP[oj>S_2_oYjNh;onWXkQCoj>W^00Goj>W_onSXk_oXj>kooooooiBEXP1YooCen@03
oiBEX_oooooohn?[00Gohn?[0olo?Cd4on?Sj`03oooooonDUJ;oh=oS00goh=oS0_ooool01?oPgn?o
IVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooooPgn?oh=oS
00?oh=oS0_l00003on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oP
gn?o000000;oh=oS00Co0000on3OhooPgn?o00004OoPgn<00ol0003oh=oSon3Oh`06on3Oh`03oiBE
X_ooooook>ca00?ok>ca0olo?Cd6onc/l@07oooooonDUJ;oU9FRoooooooYjNkoj>W^onSXk`0:onWY
kP[ojNS^5OoXjNh:onSYk`KojNW^00SoooooohjEX_ooooooSYFRoooooon>UJ;oooooohjEXPKoj>W^
2_oXj>l:onWYkP_ojNS^5?oXjNh01OoXjNooj>S^onSXk_ooooooU9FR06Wolo?g00?oU9FRooooooo/
k?401?o/k?43oclm?@Gok>ca00?ooooooiBEX_oPgn<03?oPgn<01onh]:?o^;FQoooooooPgn?oIVIn
ojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`04
on3Oh`03o`000?oPgn?oh=oS00;oh=oS0ol00003on3Oh`?o00000ooPgn<2o`0000?oh=oS00?o0000
on3OhooPgn<06?oPgn<00onDUJ;oooooooCdm`04ooCdm`?o?cdm1Oodm?L01?ooooooU9FRoiBEX_oo
oollonc/l@07ooooooo/k?7oooooonc/lOooooook>caooooo`0monc/l@03oooooonDUJ;ol?7f06So
l?7f00?oU9FRooooooodm?L00oodm?L3oclm?@Kom?Cg00?ooooooiBEX_oPgn<03?oPgn<01onh]:?o
^;BQon3OhooPgn?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<0
0oooooooh=oSon3Oh`0eon3Oh`03oiBEX_oooooonocl00Gonocl00?o?cdmoo_lo?oko?`01?oko?`0
1?ooooooU9FRoiBEX_oooon0onc/l@03oooooonDUJ;oko3e06Soko3e00?oU9FRoooooooko?`01?ok
o?`00olo?Cgonocloo_lo005oo_lo003oooooonDUJ;oh=oS013oh=oS00?oIVInojRY^ooko?d00OmV
IWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`0eon3Oh`03oiBEX_oo
oooooooo00gooooo0_nDUJ800ooooooomoOiooOgn@1nooOgn@03oooooonDUJ;ok^od06Sok^od00?o
U9FRooooooooool03Oooool00onDUJ;oh=oSon3Oh`0?on3Oh`03ofIVO_nXZK_onocm007oIVIn0000
1OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?oooooon3OhooPgn<0=OoPgn<00onDUJ;oe]KKoooo
o`0<ooooo`04omKFfonDUJ;oU9FRoo[jnh3ooooo00?on_[koiBEX_o/ko@0J?o/ko@00onDUJ;oe]KK
ooooo`0<ooooo`03omKFfonDUJ;oh=oS013oh=oS00?oIVInojRY^ooko?d00OmVIWh00005ofIVO_ok
o?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooh=oSon3Oh`0eon3Oh`04omKKfOn?T9ko]KFnokBd_POo
];Bm00So/kBmokBd_Ond];go/k>mohb=W?oFfmWoeMKIojj_^H3o]kNo00?oYJRfol_>eOo/k_<0J?o/
k_<01?oFfmWoSi2NokFe__nd];h7okBd_@06ok>d_Ond];go];Bmok>c_On<SIcoe]_I4OoPgn<00omV
IWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInUonMWJ400oooooooh=oSon3Oh`0eon3O
ha7ok^gUQ?o[jnMYonGVkQ7ok^gU4OoPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooOooooo`03onk]iOo/kOCoRhbI00coWIj[00GoRX^Ion?VkOmVIWkoZ:Vkoo_lo@01
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ogMkQ00cofM[T00GogMkQ
oiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnD
UJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mV
IWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo
00GoblcJ00?o?cdmol_<f_o;c=X01?o;c=X01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mV
IWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool01?o;c=X3oclm?@GoblcJ00Gooooo
oiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnD
UJ;ooooo00?oc<gK1Olo?Cd4olc=f`05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FRooooo`02om7Bh0?o?cdm00CodM;Poclm?Olo?Cgo
?cdm0ooAd^001OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00Cok^gUoiBEX_oooooofM[T0olo?Cd3omWJi0?o?cdm0_oIf^@01OooooooU9FRofIVO_nX
ZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool00_oS
hn/00olo?Cgohn?[on?Sj`03on?Sj`09oclm?OoShn_ohn?[on?SjoooooooU9FRofIVO_nXZK_onocm
007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03?o/k?401Ooo
ooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gU
oiBEX_ooool03?odm?L01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omV
IWkoooooomoooooo00?ok^gUoiBEX_ooool03?oko?`01OooooooU9FRofIVO_nXZK_onocm007oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03Oooool01?nDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;oe]KK00co
oooo00Goe]KKoiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOoooo
o`05onk]iOoFfmWoSi2NokFe__nd];h01Ond];d02_nc];go];Bmok>d_Ond];go/k>mohb=W?oFfmWo
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omKooooo1Om5CYT4ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;o
nOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWkoooooom[ooooo00?oADjIooooooooool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_oc
loOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00[oiNK^onc^loo/
koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02
ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_k
o_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo
00?oADjIooooooooool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOoh
n?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVOQkooooo00?ofMWIoiZJV_l000000_l000000omlO7coalO7oooo
o`05ooooo`06ok:b/_mXJ6So0000o`000?nJVY[ojNWY1Oooool01_o@d=3oO7alo`000?l0003oVYZJ
on7Qh@?ooooo00GojNWYohb<S?l0003o0000ohb<S002ooooo`?o00001?ooool01_o@d=3oO7alo`00
0?l0003oO7alom3@d0Cooooo0ol00004ooooo`?o0000oooooomiooooo`03odE>VOoooooooooo00;o
oooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_n
oo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQgooooo00?oYjNW
o`000?l000001Ol000001_n<S8coooooooooooooooool?3`ofQXJ0Go000000?oCDe=onWYjOooool0
0_ooool00onWYjOo0000o`000004o`000004omWIfOoooooooooooiZJVP?o000000?oVYZJoooooooo
ool00ol00003ooooo`03ojNWYol0003o000000Co000000CoYjNWoooooooooooooooo0ol00004oooo
o`?o0000oooooomiooooo`03odE>VOoooooooooo00;ooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVOQcooooo00?ohN7Qo`000?l000001ol000001?nm_Kgooooooooo
oonb/[82o`000003oiZJV_oooooofMWI00;o000000CoS8b<ooooooooooood=3@0_l000001_mlO7co
l?3`oooooonWYjOo0000ofQXJ0;ooooo0ol00004ooooo`?o00000_ooool01?oIfMWo0000o`000?ml
O7`2oo3`l004ogalO?l0003o0000on7Qh@;ooooo0ol00004ooooo`?o0000oooooomiooooo`03odE>
VOoooooooooo00;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oi
nO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
OQcooooo00GoVYZJo`000?l0003oO7aloo3`l002ooooo`04ojNWYol0003o0000ode=C@;ooooo00Co
O7alo`000?l0003ojNWY1oooool01?n<S8co0000o`000?oIfMT2ooooo`03oo3`l?n<S8cohN7Q00;o
oooo0ol00004ooooo`?o00000_ooool01?nJVY[o0000o`000?oIfMT2ooooo`04omWIfOl0003o0000
oiZJVP;ooooo0ol00004ooooo`?o0000oooooomiooooo`03odE>VOoooooooooo00;ooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo00CoCDe=o`000?l0003o
l?3`1?ooool3o`0000;ooooo0ol00008ooooo`?o00002?ooool3o`0000Cooooo0ol00002ooooo`03
ode=COl0003o000000Cooooo0_l000000om=CDgoooooooooo`03o`0000Cooooo0ol0003oooooogWo
oooo00?oADjIooooooooool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn8_ooool01OoQhN7oVYZJo`000?l0003oJ6QX00;ooooo2Ol00002ooooo`?o00002?oo
ool3o`0000Cooooo0ol00002ooooo`?o00001?ooool3o`0000;ooooo0ol00004ooooo`?o0000oooo
oomiooooo`03odE>VOoooooooooo00;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCe
nOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVOQoooooo00?oalO7oiZJV_m=CDd01?l000000oo7alOoooooooooo`09o`0000;o
oooo0ol00008ooooo`?o00001?ooool3o`0000;ooooo00?oCDe=o`000?l000001?ooool2o`000003
ode=COoooooooooo00?o00001?ooool3o`000?ooooooNOooool00om5CYWoooooooooo`02ooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhMooooo`03om3@d?m=CDgo
000000Go000000Go_KfmooooooooooooooooogalO002o`0000?ooooo0_l000001?mlO7cooooooooo
oon<S8`2o`000006on7QhOoooooooooooo3`l?n<S8cohN7Q0_ooool3o`0000Cooooo0ol00002oooo
o`04oiZJV_l0003o0000omWIf@;ooooo00CofMWIo`000?l0003oVYZJ0_ooool3o`000004on7QhOoo
ooooooooooooo`?o0000oooooomiooooo`03odE>VOoooooooooo00;ooooo00[oiNK^onc^loo/koCo
k^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo00?ofMWIo`000?l000000ol000000on<
S8coalO7oo3`l004ooooo`06ok:b/_l0003o0000omWIfOoooooo_Kfm0_l000001?nb/[;ooooooooo
ooo@d=02o`000006ogalO?o`l?3oooooojNWYol0003oO7al0_ooool3o`0000Cooooo0ol00002oooo
o`04on7QhOl0003o0000ogalO0;ol?3`00CoO7alo`000?l0003ohN7Q0_ooool3o`000004ogalO?o`
l?3oooooojNWY`;o000000?oJ6QXooooooooool0oooooomgooooo`03odE>VOoooooooooo00;ooooo
00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_k
o_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo00GoO7alo`00
0?l0003oS8b<omWIf@09ooooo`03ode=COl0003o000000?o000000?oCDe=oo3`l?ooool00_ooool0
0onWYjOo0000o`000004o`000003on7QhOoooooo000000Go00000_ooool3o`0000?ooooo00?oYjNW
o`000?l000001?l000001?nb/[;oooooooooooooool3o`000003ogalO?l0003o000000?o000000?o
_Kfmooooooooool0oooooomgooooo`03odE>VOoooooooooo00;ooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo0ol00004ooooo`04oo3`l?l0003o0000o`00
00Cooooo00KoYjNWode=COl0003oCDe=ojNWYoo`l?05ooooo`06om3@d?n<S8co0000o`000?nJVY[o
hN7Q0_ooool6o`0000;ooooo0ol00004ooooo`06omWIfOmlO7co0000o`000?mlO7cofMWI1?ooool3
o`000006oooooonWYjOoCDe=o`000?mXJ6So_Kfmoooooomjooooo`03odE>VOoooooooooo00;ooooo
00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_k
o_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo00CoO7alo`00
0?l0003oYjNW0_ooool01Oo`l?3oS8b<o`000?l0003oO7al01Sooooo0ol0003ooooooiSooooo00?o
ADjIooooooooool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2
ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVIn7?ooool00oo7alOo0000o`000007o`000003om3@d?oooooooooo01Kooooo0ol0003ooooooiSo
oooo00?oADjIooooooooool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn7Oooool00omlO7co0000o`000005o`000003ojNWYooooooooooo01Oooooo00?ofMWI
ode=COl000001?ooool3o`000?ooooooTOooool00om5CYWoooooooooo`02ooooo`0:onGVk_o/k_?o
k>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhNooooo`03okfm_OmlO7co000000;o0000
00?oS8b<om3@d?ooool06oooool00onJVY[oooooooooo`02ooooo`?o0000oooooonAooooo`03odE>
VOoooooooooo00;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oi
nO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
O_oooooof_ooool00om5CYWoooooooooo`02ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?c
moodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool02_oUi^kok>kconc_
m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;o
oooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_n
oo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool0
0om5CYWoooooooooo`02ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooSh
n`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3a
m_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWooooooooo
o`02ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[m
oo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomOo
oooo1?m5CYT4ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk
00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWko
ooooom[ooooo00?oADjIooooooooool00_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOo
m?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVIn6oooooooo`000;Ko00001Oooool5odE>V@Cooooo00[oiNK^onc^loo/koCo
k^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool00oo^kNGokO3boh^<VP05oifN
[003oifNZonMWZcoWIj/00?oWIj/00KoWIn/ohf?Voo^kNGoIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ogMkQ00cod=7O00GogMkQoiBEX_mVIWkoZ:Vk
oo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;o
k>ca0_oXj>h03?oRhn_ofmcUom_LiOoDeN7oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSX
kP0<on;RjooKfnKofm_VomCEhOo>cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W_00cohn?Z
om_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_L
iOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?
cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooo
goooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_o
cLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBE
X_oooooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooog
moT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca
0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<
on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_L
iOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoD
eN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWko
ooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgo
c<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogooo
ool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkL
oooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]
iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBE
X_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2
onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oX
jNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;R
j_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoK
g>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7o
cloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
omoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool0
1?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooo
oonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/
l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h0
3?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oK
g>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Go
e=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oL
olc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoo
oooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>
g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^
kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonD
UJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;o
ooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;o
jNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oS
hn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>Go
fmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GP
olk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooo
ooo?ooooo`GoADjI0_ooool5odE>V@Cooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?S
j_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo
00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?oo
ooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWo
ooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSX
k`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooodoooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo
00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooodoooool0
0om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVOSkooooo0ol00004ooooo`;o00000_ooool2o`000004ooooool0
003o0000ooooo`;o0000oooooon2ooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool0
0_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>S_00coh^;Zom_KiOoKfnGoe=GPolk@gOo<cM_o
cLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn?oooool00ol0003o
ooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0
003oooooooooo`3ooooooh7ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02oooo
o`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oRh^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]co
oooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhoooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo00000?ooooooPooo
ool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVOSoooooo00?o0000ooooooooool00_ooool4o`0000?ooooo
00Go0000ooooooooooooooooo`00003ooooooh?ooooo00?oADjIooooooooool01?ooool00om5CYWo
ooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oRh^[ofm_Uom_KiOoDeN3o
c]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhooooo
o`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002
ooooo`03o`000?oooooooooo0?ooooooPOooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooo
oooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=go
c<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOSoooooo00?o
0000ooooooooool00oooool2o`0000;ooooo0_l000000ooooooo0000o`000003o`000?ooooooP_oo
ool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVOSoooooo00?o0000ooooooooool03Oooool00ol0003ooooo
ooooo`3ooooooh7ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]
iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oSh^_ofm_Vom_Ki_oDeN3oc/oLolc=foo=c]cooooooiBE
X_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhlooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`3ooooooh7ooooo00?oADjIoooo
ooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh0
3?oSh^_ofm_Vom_Ki_oDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWhlooooo`Oo0000oooooon@ooooo`03odE>VOoooooooooo00Cooooo00?oADjI
ooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00cohn;[om_Ki_oKfnKoe=GP
olk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooo
oooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRoooo
ooogmoT2onc/l@;oj>W^00cohn;[om_Ki_oKfnKoe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo
00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00cohn;[om_Ki_oK
fnKoe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVInooooooo@ooooo`CoADjI1_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOg
n@;ok>ca0_oXjNh03?oSh^_ofm_Vom_Ki_oDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool00om5
CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca1_n>UJ802?o>cmcoc<gKolg>g?oo
ooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooocoooool5odE>V@Ko
oooo00?oADjIooooooooool00_ooool01Oo^kNGoU9FRooooooogmoWok>ca00Kooooo00Woe=GPolk?
g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooo
f_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca1_n>UJ802?o>cmco
c<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_oo
ool00om5CYWoooooooooo`02ooooo`05onk]iOnDUJ;oooooooOgnOo/k?401_ooool02OoDeN3oc/oM
olc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJ
ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?46ohjEXP08olk?gOo<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJoooo
o`03odE>VOoooooooooo00;ooooo00Gok^gUoiBEX_oooooomoOionc/l@06ooooo`09omCEh?o>cmgo
c<gKolg>g?ooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[o
oooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@KoSYFR00Soc/oMolc=
foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo
00?oADjIooooooooool00_ooool01Oo^kNGoU9FRooooooogmoWok>ca00Kooooo00Woe=GPolk?gOo<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_oo
ool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofm_V
om_Ki_oDeN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;o
jNW^00cohn?Zom_Ki_oKfnKoe=GPolk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWYkP0<on?Sj_oKfnKofm_VomCEh?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02oooo
o`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofm_Vom_Ki_oDeN3oc/oMolc=foo=c]co
oooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjI
ooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_Ki_oKfnKoe=GP
olk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooo
oooJooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<on?S
j_oKfnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooof_ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;o
k>ca0_oXjNl03?oShn[ofm_Vom_Ki_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooooom[ooooo00?oADjIooooooooool00_ooool01?o^kNGo
U9FRooooooogmoT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;o
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooJooooo`03odE>VOoooooooooo
00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<on?Sj_oKfnKofm_VomCEhOo>d=goc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooocoooool5
odE>V@Kooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W_00co
hn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_oo
ool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkL
oooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>
VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;o
j>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIoooooooo
ool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCoooo
o`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2
onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjI
ooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQ
olo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7_oo
ool00ooIfMWoVYZJo`000002o`000003ogalO?o7alOooooo00Gooooo00Ko/[:bofQXJ?l0003o0000
oiZJV_oYjNT5ooooo`06om3@d?mlO7co0000o`000?nJVY[ohN7Q0oooool01OoYjNWoS8b<o`000?l0
003oS8b<00;ooooo0ol00004ooooo`06om3@d?mlO7co0000o`000?mlO7cod=3@1?ooool3o`0000Co
oooo0ol0003oooooog;ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhMooooo`03ojNWYol0003o0000
00Go000000KoS8b<oooooooooooooooooo3`l?mXJ6P5o`000003ode=COoYjNWooooo00;ooooo00?o
YjNWo`000?l000001?l000001?oIfMWooooooooooonJVYX3o`000003oiZJV_oooooooooo00?o0000
0oooool00onWYjOo0000o`000004o`000004ojNWYoooooooooooooooo`?o00001?ooool3o`000?oo
ooooL_ooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo00?ohN7Qo`000?l000001ol000001?nm
_Kgooooooooooonb/[82o`000003oiZJV_oooooofMWI00;o000000CoS8b<ooooooooooood=3@0_l0
00001_mlO7col?3`oooooonWYjOo0000ofQXJ0;ooooo0ol00004ooooo`?o00000_ooool01?oIfMWo
0000o`000?mlO7`2oo3`l004ogalO?l0003o0000on7Qh@;ooooo0ol00004ooooo`?o0000oooooomb
ooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooog
moT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ooool01OnJVY[o0000o`000?mlO7col?3`00;ooooo
00CoYjNWo`000?l0003oCDe=0_ooool01?mlO7co0000o`000?oYjNT7ooooo`04ohb<S?l0003o0000
omWIf@;ooooo00?ol?3`ohb<S?oQhN400_ooool3o`0000Cooooo0ol00002ooooo`04oiZJV_l0003o
0000omWIf@;ooooo00CofMWIo`000?l0003oVYZJ0_ooool3o`0000Cooooo0ol0003oooooog;ooooo
00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;o
k>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWhLooooo`04ode=COl0003o0000oo3`l0Cooooo0ol00002oooo
o`?o00002?ooool3o`0000Sooooo0ol00004ooooo`?o00000_ooool00om=CDgo0000o`000004oooo
o`;o000000?oCDe=ooooooooool00ol00004ooooo`?o0000oooooombooooo`03odE>VOoooooooooo
00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Z
om_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn8_ooool01OoQhN7oVYZJo`000?l0003oJ6QX00;ooooo2Ol00002ooooo`?o00002?oo
ool3o`0000Cooooo0ol00002ooooo`?o00001?ooool3o`0000;ooooo0ol00004ooooo`?o0000oooo
oombooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRoooo
ooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7oooool00oo7alOoVYZJode=C@04o`000003olO7
aooooooooooo00Wo00000_ooool3o`0000Sooooo0ol00004ooooo`?o00000_ooool00om=CDgo0000
o`000004ooooo`;o000000?oCDe=ooooooooool00ol00004ooooo`?o0000oooooombooooo`03odE>
VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;o
j>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVIn7Oooool00oo@d=3oCDe=o`000005o`000005okfm_Ooooooooooooooo
oomlO7`00_l00003ooooo`;o000000CoO7alooooooooooooS8b<0_l000001_oQhN7oooooooooooo`
l?3oS8b<on7Qh@;ooooo0ol00004ooooo`?o00000_ooool01?nJVY[o0000o`000?oIfMT2ooooo`04
omWIfOl0003o0000oiZJVP;ooooo0ol000001?oQhN7oooooooooooooool3o`000?ooooooL_ooool0
0om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVOQcooooo00?ofMWIo`000?l000000ol000000on<S8coalO7oo3`
l004ooooo`06ok:b/_l0003o0000omWIfOoooooo_Kfm0_l000001?nb/[;oooooooooooo@d=02o`00
0006ogalO?o`l?3oooooojNWYol0003oO7al0_ooool3o`0000Cooooo0ol00002ooooo`04on7QhOl0
003o0000ogalO0;ol?3`00CoO7alo`000?l0003ohN7Q0_ooool3o`000004ogalO?o`l?3oooooojNW
Y`;o000000?oJ6QXooooooooool0oooooom`ooooo`03odE>VOoooooooooo00Cooooo00?oADjIoooo
ooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?
g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ooool0
1OmlO7co0000o`000?n<S8cofMWI00Wooooo00?oCDe=o`000?l000000ol000000om=CDgol?3`oooo
o`02ooooo`03ojNWYol0003o000000Co000000?ohN7Qooooool000001Ol00002ooooo`?o00000ooo
ool00onWYjOo0000o`000004o`000004ok:b/_ooooooooooooooo`?o000000?oO7alo`000?l00000
0ol000000onm_Kgoooooooooo`3oooooog3ooooo00?oADjIooooooooool01?ooool00om5CYWooooo
ooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloM
olc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhLooooo`?o
00001?ooool01?o`l?3o0000o`000?l00004ooooo`06ojNWYom=CDgo0000ode=COnWYjOol?3`1Ooo
ool01_o@d=3oS8b<o`000?l0003oVYZJon7Qh@;ooooo1_l00002ooooo`?o00001?ooool01_oIfMWo
O7alo`000?l0003oO7alomWIf@Cooooo0ol000001_ooooooYjNWode=COl0003oJ6QXokfm_Ooooooo
Loooool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo00CoO7alo`000?l0003oYjNW0_ooool01Oo`
l?3oS8b<o`000?l0003oO7al01Sooooo0ol0003ooooooi7ooooo00?oADjIooooooooool01?ooool0
0om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_L
iOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWhLooooo`03olO7aol0003o000000Oo000000?od=3@ooooooooool05_ooool3o`000?ooooooTOoo
ool00om5CYWoooooooooo`04ooooo`03odE>VOoooooooooo00;ooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVOQgooooo00?oO7alo`000?l000001Ol000000onWYjOooooo
ooooo`0Gooooo`03omWIfOm=CDgo000000Cooooo0ol0003ooooooh[ooooo00?oADjIooooooooool0
1?ooool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[o
fmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWhNooooo`03okfm_OmlO7co000000;o000000?oS8b<om3@d?ooool06oooool00onJVY[o
ooooooooo`02ooooo`?o0000oooooon:ooooo`03odE>VOoooooooooo00Cooooo00?oADjIoooooooo
ool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCoooo
o`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2
onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjI
ooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQ
olo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooo
oooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRoooo
ooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo
00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoK
g>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool01?o^kNGo
U9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;o
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo
00Cooooo00?oADjIooooooooool00_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Z
om_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInoooooooCooooo`03odE>VOoooooooooo00Cooooo00?oADjIooooooooool00_ooool0
1?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooo
oonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooooooo@ooooo`CoADjI1_oo
ool00om5CYWoooooooooo`02ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcU
om_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkoooooom?ooooo00?oADjIooooooooool01?ooool00om5CYWoooooooooo`02ooooo`04onk]
iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBE
X_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhKoooooooo0000[ol00005ooooo`Go
ADjI0_ooool5odE>V@Cooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcU
omCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
O_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?
g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooO
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Co
k^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?oooooo
U9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FR
ooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOg
n@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42
onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00co
hn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcU
om_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCE
h?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oo
oooogoooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOoooo
o`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]co
oooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gU
oiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FR
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool01?o^kNGoU9FRoooo
ooogmoT2onc/l@;oj>S_00coh^;Zom_KiOoKfnGoe=GPolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`04onk]iOnDUJ;oooooooOgn@;o
k>ca0_oXjNh03?oSh^_ofm_Vom_Ki_oDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWY
kP0<on?Sj_oKfnKofm_VomCEh?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FRomKFf`0<ooooo`05omKFfonDUJ;oIVIn
ojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooogoooool00oo^kNGooOgjoi2AW`05
okNg_`03okBd_Ong]koo]kNo00Co]kNo00GoT96Oonk]iOmVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`03onk]iOo/kOCoRhbI00coWIj[00GoRX^Ion?VkOmVIWkoZ:Vk
oo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ogMkQ00cofM[T
00GogMkQoiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03
onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00coblcJ00Gooooo
oiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnD
UJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooOooooo`03onk]iOnDUJ;ooooo00;oblcJ00?o?cdmol_<f_o;c=X00oo;c=X02Olo?CgoblcJ
ol_<f_o;c=[ooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooO
ooooo`04onk]iOnDUJ;oooooolc=f`?o?cdm0oo<cM/3oclm?@;oc<gK00GooooooiBEX_mVIWkoZ:Vk
oo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00;odM;P
0olo?Cd01?oAd^3o?cdmoclm?Olo?Cd3om7Bh005oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooogoooool00oo^kNGoU9FRooooo`03omWJi0Go?cdm1?oIf^@01Ooo
ooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gU
oiBEX_ooool01?oShn/3oclm?@Gohn?[00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;ooooo00Gok>ca00?o?cdmonc/lOo/k?401?o/
k?401OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo
00?ok^gUoiBEX_ooool03?odm?L01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03?oko?`01OooooooU9FRofIVO_nXZK_onocm
007oIVIn00001?mVIWkonocmojRY^omVIWkoooooomoooooo00?ok^gUoiBEX_ooool03Oooool01?nD
UJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooOooooo`03onk]iOnDUJ;o
e]KK00cooooo00Goe]KKoiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInool0
003Oo`000005onk]iOoFfmWoSi2NokFe__nd];h01Ond];d02_nc];go];Bmok>d_Ond];go/k>mohb=
W?oFfmWoIVInojRY^ooko?d1ofIVOP0000?oIVInooOgnOnHV:L0oomgMi;bogMgTP7oV9RW0OogmoT1
ofIVOP0000?oIVInooOgnOnl_Ld0oonl_Lgcokbmc@7omoOi0OmVIWh00003ofIVO_ogmoWoi>?S0?oo
i>?SlooThn<1ooOgn@7oIVIn00000omVIWkol?7dooooo`04ooooo`03ojNWYonSXZ?oXZ:R00;oXJ6Q
00?oX:2PojFNUOnZW8T00_nOWil2oj2PX0;oXJ6Q00?oYjNWooooooooool0oooooon/ooooo`03onCS
honLY;WoJgF?00;oJgF?0_m/MY05of]eS`06oibT^OoThn?ooooooooooooThn?oW:Bi0om[MHl2ofaf
T0GoJgF?00KoW:BionCShooooooooooooncZj_nLY;T3ojHiA0;oYcY41OnV>D@00onLY;Wok>[Zoooo
o`03ooooo`7ol?7d0OmVIWh00009ofIVO_oRhN;onocloo_ko?oko?goo?_moiRHVOnKVi_o[:b/00?o
jNWY00[oj^[Zon?6N_oINQCok>c/ong]kOo^k^kolNOEoo3`l?obl_;oXj>S0_olo?`01?olo?goo?cl
oo_koOolo?fCoocko9;onoclP_oko?d00onLY;WoJgF?ohF9/009ohF9/006of]eSonLY;Wonocmoo_l
oOnLY;WoJgF?2_n5RK001_m[MHooW:Bioo_ko?oko?goW:BiojHiA0[oZSaE00OoYSU4oibT^Ooko?co
o?cloockoOoko?goh^7R007oIVIn00001?mVIWkoh>3QooKgnOogmoT2ooKgn@05ooKgn?nPX:3oj^[Z
onWYjOojj:T00_oZj^X02_ohiASocFL0ong]kOo^k^komZPcooK>S?obl_;olo?coj>SXoogmoT3ooKg
n@03ooKgn?ogmoWoal;A00?oal;A0_ogmoT01Oo7`]7omoOiooOgnOogmoWoal;A00?omoOi0_o7`]42
ooOgn@04olO2dOogmoWomoOiooOgn@;oal;A00ComoOiolO2dOogmoWomoOi0oo7`]43ooOgn@Coal;A
2?ogmoT01Oo7`]7omoOiooOgnOogmoWoal;A00;omoOi00Koal;AooOgnOogmoWomoOiolO2dOogmoT4
olO2dEComoOiT_ofmoV2ooOgn@03of]eSon5RK3oW9jn00WoW9jn00KoQHV`of]eSoogmoWomoOiof]e
Son5RK0:oibN_P08ohF9/?m[MHoomoOhooOgnOnV>DCoZSaEol9BFoo6E5X6olIEG009olIDF_o2DU_o
ZSaEojHiA?ogmoSomoOiooOgn?ogmoWoh>3Q007oIVIn00006omVIWkog]gQoo7am?oalOCol?7doo3b
m?nQXJ?oShn?ohj>S_oYjNWodG/0olXa0?o:MUGoooL0on^[0?oKWWooiJ1iomM20?obl_;olo?cooCd
m?nTY:ColO7doo3bmOoalOColO;doo3bm004o`h@4004oo3amOo7`]7o3Q0@olO2d@;ol?7e00Co3Q0@
olO2dOo`lOGol?7e0_l>4102oo3am@04o`h@4?o7`]7ol?7eoo3am@;o3Q0@00Col?7eo`h@4?o7`]7o
l?7e0ol>41000oo`lOGoal;Aoo3am@04o`h@4003olO2dOo`lOGol?7e00Gol?7e00Wo3Q0@olO2dOo`
lOGol?7eo`h@4?o7`]7ol?7eo`h@4?o7`]400_o`lOD00ol>413oal;Ao`h@4003o`h@4003oo3amOo7
`]7ol?7e0>Col?7eP_o`lO@00om[MHoo/[G@ojNX`P09ojNX`P06ok:ed?m[MHool?7doo3am?m[MHoo
/[G@1oooool3ojNX`P05ok:ed?m[MHool?7doo3am?nV>D@00_o2DU/00oo;E5WocEUNoleIGP04oleI
GP04ol]DFOo2DU_o`U9KojHiA0;ol?7d00?olO7doo3bm?oNgN400OmVIWh00009ofIVO_oLfn3oj^_`
on[[l?oZk?3ojN__oiBDUonSXj?oinKV00;oj^[Z00_o]``0om1h0?ooi@3onl`0omR80?noBP3o]d@0
okY@>_oIVV7ooM`0okV^NP02on[[l004on[[kooZjo3o3Q0@olO2d@?oj^_`00Co3Q0@olO2dOl>413o
al;A0_oZjo001Ol>413oal;Aon[[l?l>413oal;A00?oj^_`00Go3Q0@olO2dOoZjo3o3Q0@olO2d@02
on[[l004o`h@4?o7`]7o3Q0@olO2d@;oj^_`00Co3Q0@on[[l?l>413oal;A0_oZjo000ol>413oal;A
on[[l006on[[l005o`h@4?o7`]7oj^_`on[[l?l>41000_oZjo002?l>413oal;Aon[[l?oZjo3o3Q0@
olO2dOl>413oal;A0_oZjo000ol>413oal;Aon[[l01Bon[[l9;oj^c`P_oZjnl00om[MHoo][WAojf^
aP06ooooo`;o[Jk600?o[:k6okJidOm[MHl00_oZjnl00om[MHoo][WAooooo`06ofi]S`05obDU=_n]
[/Ko[:k6okJidOm[MHl00_oZjo000onV>DCocEUNol]DF@02ooooo`?od5YO0_ooool01_o=EU_obeAI
oleIG_nV>DCoj^__on[[l0;oj^__0OoLfn01ofIVOP0000?oIVInomOHg_oLg^H00ooLg^H04OoLg^Go
QXN6okj>E_oigdSonNi2onbf0?okd03ol;X0onZ`0?oY/P3ofX/0olnE0?oR_`3oo]l0ooK`g?nTYJGo
g=kV00;og=kU00?og=kVo`h@4?o7`]400ooLg^D01?l>413oal;Ao`h@4?o7`]42omcNi@05o`h@4?o7
`]7og=kUo`h@4?o7`]400ooLg^D01Ol>413oal;AomcNiOl>413oal;A00;og=kU00?o3Q0@olO2dOl>
41001Oo7`]401ol>413oal;AomcNiOoLg^Go3Q0@olO2dOoLg^D00oo7`]43omcNi@03o`h@4?o7`]7o
g=kU00Cog=kU00So3Q0@olO2dOoLg^Gog=kUo`h@4?o7`]7o3Q0@olO2d@;og=kU00?o3Q0@olO2dOoL
g^D0oooLg^EWomcNi@04of]eSono`MKo^;W>ooooo`CoKVf?00Ko9BDfokRic_nh^Lko^;W>oko1e_m[
MHl2omcNi@04of]eSono`MKoooooofi]S`Co^;W>00KoooooobDU=_nh^Lko^;W>oko1e_m[MHl2omcN
i@03ojHiA?o=FEkodEYN00?ooooo00SoeUmSooooooooooooooooomAMHOoAFUkocEUNojHiA0;og=kU
00?og=kVomcNiOoGf=h00OmVIWh00004ofIVO_oEe]goeMSPomKHh@;oeMSP013oNg^0oiBDU?nMO4[o
ag80onNT0?ooj03ojkH0onVZ0?oX[03odh40okY<0?oR^P3on_9gooKfm_ohn?SoYJBU0_oEf>401?oE
en3oe]SPo`h@4?o7`]43omKGh004o`h@4?o7`]7o3Q0@olO2d@;oe]OP00Go3Q0@olO2dOoFen3o3Q0@
olO2d@03omKGh005o`h@4?o7`]7oe]OPo`h@4?o7`]400_oFen000ol>413oal;Ao`h@4004o`h@4003
olO2dOl>413oal;A00;oe]OP00?o3Q0@olO2dOl>41000_l>4104omKGh003o`h@4?o7`]7oe]OP00Co
e]OP00So3Q0@olO2dOoFen3oe]OPo`h@4?o7`]7o3Q0@olO2d@;oe]OP00?o3Q0@olO2dOoFen00D_oF
en2BomKHh8;oeMSQ00?oJgF?ol_<g_o8b]T01_lU9CH01Oo8b]Wob<WIolS:fOo;c=koJgF?00;oeMSQ
00CoJgF?ol_<g_ooooooKVf?0oo8b]T03Oo8bMWoooooobDU=_o8bMWob<[Iol_<g_m[MHooe]SQomKH
h?nV>DCoeemOom]TI?m67QX01Oooool02_m67Q[oh6MUom]TI?oGGeooYSU4omKHh?oEf>7oeMOPomGH
hOoEe]d1ofIVOP0000GoIVInom;DgOo?d]cod=;Lom3Bg@02om3Bg00?oiNGUong]kOok>c/omjfO_oI
R03ol/@0onfa0?oXZP3oe7D0okiX0?ole@3onmmiooSflOoinOWoYJFU00?od=;L00?ocm;Lo`h@4?o7
`]400oo@d]`00ol>413oal;Ao`h@4003olO2d@04o`h@4?o@d]cod=;Lo`h@40?oal;A00God=;Lo`h@
4?o7`]7od=;Lo`h@4003olO2d@04o`h@4?o7`]7o3Q0@om3Bg0;oal;A00Co3Q0@om3Bg?l>413od=;L
0_o7`]400ol>413oal;Aom3Bg005om3Bg003olO2dOl>413oal;A00God=;L00Oo3Q0@olO2dOo7`]7o
al;Ao`h@4?o@d]co3Q0@00?oal;A00?o3Q0@om3Bg?o@d]`0D_o@d]bBoloBgH;od=;L00?oJgF?om?C
h_o?d=d02Oo?d=d02?oCdn;oJgF?om3Bg?o@d]coJgF?om?Ch_ooooooKVf?1?o?d=d03Ooooooo9BDf
olo@gOo?d=godm?Rof]eSoo@d]cocm;LojHiA?oKI6CohFUUon1/JOm67QX00oooool01om67Q[oh6aY
on1/JOoQJFGoffATojHiA?o@d]d00_o@d]`1oloBg07od]CM0OmVIWh0000LofIVO_o@d]_oblgHol[=
fOo;c]Sob/gHogYlP_nIVIWoYZNVong]kOoWbX[oafP0oo:i0?oLR@3obVL0okHa0?nkDP3oolX0oonl
0?ok^@3omk80olZ[H?o;cMSoblgIol[=fOo;c]So3Q0@olO2d@?oblgI00?o3Q0@olO2dOl>41000ol>
4102ol_=f@Co3Q0@00CoblgIo`h@4?l>413oblgI1?l>41001?o;cMWo3Q0@olO2dOo;cMT3o`h@40?o
blgI1?l>41000oo7`]7oblgIol_=f@03ol_=f@04o`h@4?o;cMWo3Q0@olO2d@GoblgI1?l>4102ol_=
f@Co3Q0@EOo;cMVBol_>fH;oblgH00CoJgF?omKFi?oHf>Gof=SV0_oHf>D2omSHiP06omSHiOoHf>Ko
f=SUomSHiOoFe^CoJgF?0_o;cMP01?m[MHooe]KToooooom^KHl5ooooo`0;obDU=_oHf>Gof=SUomKF
i?m[MHooblgIol[>f?nV>DCoi6i]onAdKooWLFl01Oooool01ooTM6ooig5_onAdKooTKVgoYSU4ol[>
f?o:c]T00_o;cMT1om3Bf`7oIVIn00000omVIWkocloJolG8e004olG8e00@oijNWOoShn?ok;9NomZH
0?oBO03ogY<0omUl0?oHN@3o]3@0oj060?o_VP3ooj`0oo[fk?okn?7o]ZR7olG8e0;oaLOD00?oaLOE
o`h@4?o7`]400oo4amD00ol>413oal;AolC7e@06olC7e@03o`h@4?o7`]7oa<OE00?oa<OE00Coal;A
olC7eOl>413oal;A0_o4amD00ol>413oal;AolC7e@09olC7e@03o`h@4?o7`]7oa<OE00Goa<OE0_l>
41000oo7`]7oa<OEolC7e@09olC7e@03o`h@4?o7`]7oa<OE05Koa<OET_o4b=B2olC7e003of]eSooE
e>?oh=oZ00Woh=oZ00OoeMCSof]eSoo4amCoa<ODof]eSooEe>?ooooo00KoKVf?00[o9BDfon3Oj_oP
gn[oeMCSof]eSoo5b=Coa<SDojHiA?oZNG?ojGah0oooool02Om67Q[oooooooooooooooookh5jonUl
N?oZNG?oYSU4olC8e@02olC8e07oaLOE0Oo?cmX1ofIVOP0000CoIVInolc>f_o2a=;o`LCA0_o1a=80
4?n1PhcoSHf=ogmgKooPV`3ol?3`onBmV?o/[@3ooml0ooo60?oZY`3o`V00om5e0?ohYbgono_koocl
o?nVYZH3ol74dP03ol;4dOl>413o`LCB00?o`LCA00?o3Q0@ol74dOo1a=401_o1a=400ol>413o`LCA
ol74d@02ol74d@04o`h@4?o1a=7o`LCAo`h@40?o`LCA00?o3Q0@ol74dOo1a=402Oo1a=400ol>413o
`LCAol74d@06ol74d@03o`h@4?o1a=7o`LCA00[o`LCA00?o3Q0@ol74dOo1a=40E_o1a=6Bol74dX;o
`/CB00?oJgF?ong[looYj?402OoYj?401oo]jo?oJgF?ol;4d_o2a=;oJgF?ong[looYj?401olU9CH2
onWXl@07ong[lom[MHoo`/CAol74dOnV>DColH1eoo24O002ooooo`03odHN6_oa/Y_oAQhJ00;ooooo
00WomHb4oo24O?oaP7GoYSU4ol74d_o2a=7o`LCAol74d_o<c]X00OmVIWh00004ofIVO_o:c=So_/3?
okg0c`;o_/3>01GoRhfHoijNW_oEe=Col?3`oo;bl_oXbj_on=80ooKTQoocdXgolZ80ono9TOoWaJ;o
hH40ooclo?omoOgoYZNWokk0c_nn`<oo_/3>okk0conm`<h0U?nn`<jBokg0cX;o_/3>00?oJgF?om;A
hooblOL02OoblOL01_oBdN?oJgF?okk0c_nn`<koJgF?om;Ah`[ol_7g00Ood]7Sof]eSonm`<ko_/3>
ojHiA?odRWgomI2500;oAQhJ0oob^9h2odHN6P;omI2500?om8YmojHiA?nm`<l00_nn`<l1okk0cP7o
b/cH0OmVIWh0000LofIVO_o9b]So][S8okVlbonj_<_o^[c<okZlbon6QXKoU9BCoo;bl_oclo?oiZ@0
ooS][_ofm_Kolm^/onZG0?ojn_[ono_koo7J^ooi]Rooo_knojNWYoni_<co^[_<okVlbonj_<_o^Kc<
okVlbi?o^Kc<T_nj_<b2okZlb`04ohB<X_m[MHooc<_Moo_ko0Kooooo00Cono_lolc;gOm[MHooQ8bR
0_nj_</01?n4S:;oJgF?olc;gOokno`6ooooo`0;oo_ko?o<bmgoJgF?ohB<X_nj_<co^Kc<oi6HZ_nV
>DCooin=oojoY?ojg;L00_ojjKH2ooWY]P0:oo[L]oon_jCooin=ojHiA?nAV:[o^[c<okZkc?ni_<_o
][S8olW:f07oIVIn00000omVIWkoa/SGokRgc`03ojn^a`0=og=bP_nPX:3ohN3Qoo?cloo/ilool^cN
ooKfm_ohn?SonOWionJ;0?okno_oo?cloogmo@02ooknoP03ojNWYon_[/Oo[jk70?oo[jk7[On_[/L0
0on4S:;oJgF?of]eS`08of]eS`03ohB<X_n_[/Oo[jk700;o[jk700?oQ8bRof]eSom[MHl02?m[MHl0
0on4S:;o[jk7ojn^a`02ojn^a`03ohB<X_nV>DCoYSU400SoYSU400?oQ8bRojn^aon_[/L00_n_[/L1
okRgc`7oa/SG0OmVIWh00003ofIVO_o0`M7oalOD00Co[:_400?oSHf=ojZZZ_nZZZX01OnZZZX00ond
YXkoZZZZojZZZP04ojZZZ_oo[:_4gon/Zl@1olO7e07o`<7A0OmVIWh00006oooooonXYkooi^K]om;B
h?nl_<oo/K34oonXYko/ojRW_`05ok6`a?nl_<ood];PonKVkOnXYkl00Oooool00007oooooon7Qi_o
emSRooclo?oThnSod=3Pol[:fP3ookblcn[o_;c?00Kob/[Jom3@h?oThnSoo?clomOHh_n7Qi/1oooo
o`000_ooool01_nEU:_oemSRooclo?oblO?ok>_^on7RjoooemSRj?oGf>801_oQh^_ok>_^oo;alool
o?coemSRoiFDZ`;ooooo0003ooooo`;oIVIn00?oR8NMoiFDZonXYkl0oonXYkoYojRW_`04oiFDZon8
QigoIVInofIVOP?ooooo0005ooooooooIVInk_mVIWh5ooooo`00\
\>"], "ListGraphic",
 Evaluatable->False,
 ImageSize->{503, 287},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Outline Format", "i:85"}],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " If you attempt to generate a browser categories file from a notebook that \
is not in strict outline format, you will get a warning message. The \
resulting ",
 "browser categories",
 " file will ignore the presence of any cells that stray from the strict \
outline format, so those cells will not be viewable in the Help Browser."
}], "Text",
 CellTags->{"Outline Format", "i:85"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating Browser Categories", "Subsubsection",
 CellTags->{"Setting up Browser Categories", "i:86"}],

Cell[TextData[{
 StyleBox["To generate a ", "TB"],
 StyleBox["browser categories",
  FontWeight->"Bold"],
 StyleBox[" file:", "TB"]
}], "Text",
 CellTags->{"Setting up Browser Categories", "i:86"}],

Cell[TextData[{
 "For a single notebook, open the notebook and make it the currently selected \
notebook. For multiple notebooks, open the MakeProject ",
 "dialog box",
 " and load the project file for your project. (If you have not already \
created a project file, see ",
 ButtonBox["Creating a Project File",
  ButtonData:>"Creating a Project File",
  ButtonStyle->"AddOnsLinkText"],
 " to learn how.)"
}], "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Setting up Browser Categories", "i:86"}],

Cell["Open the MakeCategories palette.", "ItemizedList",
 CellTags->{"Setting up Browser Categories", "i:86"}],

Cell[TextData[{
 "Click ",
 StyleBox["Make Browser Categories", "SR"],
 "."
}], "ItemizedList",
 CellTags->{"Setting up Browser Categories", "i:86"}],

Cell["\<\
A browser categories file is created and saved in the same directory as your \
source notebook. Cell tags are automatically added to the input notebook.\
\>", "Text",
 CellTags->{"Setting up Browser Categories", "i:86"}],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " Your source notebooks are modified and all changes automatically saved \
when you generate a browser categories file. It is therefore advisable to \
make a ",
 "backup",
 " copy of your notebook before using this palette."
}], "Text",
 CellTags->{"Setting up Browser Categories", "i:86"}],

Cell[TextData[{
 "The BrowserCategories palette automatically inserts cell tags into the \
target notebook. To remove the automatically generated cell tags in the \
source notebook(s), click ",
 StyleBox["Clear Cell Tags", "SR"],
 ". If you remove the cell tags, the hyperlinks in the table of contents will \
take you to the start of the notebook instead of to a specific topic."
}], "Text",
 CellTags->{"i:87", "Setting up Browser Categories"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Customizing the Browser Categories", "Subsubsection",
 CellTags->{"Customizing Browser Categories", "i:87"}],

Cell[TextData[{
 "The three buttons at the bottom of the palette enable you to specify \
options to customize various features of the BrowserCategories.m file. To set \
the value of an option, click the button bearing the name of that option. \
This brings up a dialog box displaying the current value of the option. You \
can edit the text and click ",
 StyleBox["Apply", "SR"],
 " for the changes to take effect. Click ",
 StyleBox["OK", "SR"],
 " to close the ",
 "dialog box",
 "."
}], "Text",
 CellTags->{"Customizing Browser Categories", "i:87"}],

Cell["Here are the options:", "Text",
 CellTags->{"Customizing Browser Categories", "i:87"}],

Cell[TextData[{
 StyleBox["CopyTagPrefix", "MR"],
 " lets you specify a string that is prepended to all copy tags in the \
BrowserCategories.m file. The default setting for this option is ",
 StyleBox["CopyTagPrefix \[Rule] \"b: \"", "MR"],
 "."
}], "BulletedList",
 CellTags->{"Customizing Browser Categories", "i:87"}],

Cell[TextData[{
 StyleBox["IndexTagPrefix", "MR"],
 " lets you specify a string that is prepended to all index tags in the \
BrowserCategories.m file. The purpose of this option is to make the index \
tags unique among all applications installed in the Help Browser. If set to \
",
 StyleBox["Automatic", "MR"],
 ", ",
 StyleBox["IndexTagPrefix", "MR"],
 " defaults to the setting for ",
 StyleBox["ProjectName", "MR"],
 "."
}], "BulletedList",
 CellTags->{"Customizing Browser Categories", "i:87"}],

Cell[TextData[{
 StyleBox["SelectedCellStyles", "MR"],
 " lets you specify the cell styles that are used in creating the ",
 "browser categories",
 " file. Possible settings are ",
 StyleBox["Automatic", "MR"],
 " or a list of cell styles. The default setting for this option is ",
 StyleBox["SelectedCellStyles \[Rule] {Title, Section, Subsection, \
Subsubsection}", "MR"],
 "."
}], "BulletedList",
 CellTags->{"Customizing Browser Categories", "i:87"}],

Cell[TextData[{
 StyleBox["StartingCounterValues", "MR"],
 " lets you specify the automatic numbering of chapters, sections, \
subsections, and so on. A setting of ",
 StyleBox["StartingCounterValues \[Rule] {1,0,1,0}", "MR"],
 ", for example, will number the chapters starting at 1, the sections \
starting at 0, the subsections starting at 1, and so on. The default setting \
for the option, ",
 StyleBox["StartingCounterValues", "MR"],
 " ",
 StyleBox["\[Rule]", "MR"],
 " ",
 StyleBox["{0,0,0,0}", "MR"],
 ", numbers everything starting at 0."
}], "BulletedList",
 CellTags->{"Customizing Browser Categories", "i:87"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeBilateralCells", "Subsection"],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
 CellTags->{"MakeBilateralCellsIntro", "i:94"}],

Cell[TextData[{
 "The MakeBilateralCells palette allows you to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calculations in a compact, bilateral format. Each bilateral cell consists \
of expository text to the left and input and output cells to the right. \
Bilateral cells are used extensively in ",
 StyleBox["The Mathematica Book", "TI"],
 " to display examples."
}], "Text",
 CellTags->{"MakeBilateralCellsIntro", "i:94"}],

Cell[CellGroupData[{

Cell[BoxData[
 ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "OpenCloseItemizedPicture",
   FormatType->StandardForm,
   ImageSize->{54, 13},
   ImageMargins->{{0, 0}, {0, 0}},
   ImageRegion->{{0, 1}, {0, 1}}],
  Active->True,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& )]], "OpenCloseItemizedPicture",
 CellTags->{"i:94", "MakeBilateralCellsIntro"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002U00012R000`400?l00000o`00003oYOmSIG/0
0003of=UNooooooooooo0:7ooooo0OmSIG/00003of=UNooooooo[JZm0:3o[JZm0Oooool1of=UN`00
00?oHfEkoooooon]Z[d0WomSIG/1ojfZ_@7ooooo0OmSIG/00004of=UNooooooo[JZmof=UNigog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOn<^]H6omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoS;[F1_oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEohbjePKog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOn<^]H6omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmiTohbjeP?ooooo;_n<^]H6omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgVKoS;[F0_ooool]ohbjePKog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N3?n<^]H2ooooo`CoS;[F0_ooool00on<^]Kooooo
ooooo`02ooooo`?oS;[F1?ooool3ohbjeP;ooooo0on<^]H6ooooo`;oS;[F0_ooool00on<^]Kooooo
ooooo`02ohbjePGooooo0_n<^]H2ooooo`;oS;[F1?ooool2ohbjeP;ooooo1?n<^]H5ooooo`03ohbj
e_oooooooooo00CoS;[F1Oooool3ohbjeP;ooooo0_n<^]H3ooooo`;oS;[F0_ooool2ohbjePCooooo
0on<^]H4ooooo`?oS;[F0_ooool2ohbjeP;ooooo0_n<^]H2ooooo`koS;[F1_oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh<ohbjeP;ooooo0on<^]H2ooooo`03ohbj
e_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool0
1?n<^]H2ooooo`?oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`03ohbje_oooooooooo00;o
S;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00?o
S;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00on<^]H2ooooo`?oS;[F0_ooool00on<^]Ko
ooooooooo`03ohbjeP?ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Ko
ooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool2ohbjeP;ooooo3_n<^]H6omkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPcoS;[F0_ooool3ohbjeP;o
oooo00?oS;[Fooooooooool02?n<^]H3ooooo`03ohbje_oooooooooo00CoS;[F0_ooool3ohbjeP;o
oooo00CoS;[FooooooooooooS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Foooo
ooooool00_n<^]H2ooooo`GoS;[F0_ooool3ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo
00SoS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool0
0on<^]Koooooooooo`08ohbjeP?ooooo6_n<^]H6omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgPcoS;[F0_ooool2ohbjeP;ooooo0_n<^]H6ooooo`;oS;[F1?ooool2
ohbjeP;ooooo1?n<^]H2ooooo`?oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F0_oo
ool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F1_ooool00on<^]Koooooooooo`04ohbjeP;ooooo
00CoS;[FooooooooooooS;[F0_ooool6ohbjePCooooo00?oS;[Fooooooooool00_n<^]H2ooooo`04
ohbje_ooooooooooohbjeP;ooooo00?oS;[Fooooooooool01?ooool2ohbjePCooooo6on<^]H6omkK
gP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPcoS;[F1_ooool2ohbj
eP;ooooo0_n<^]H2ooooo`04ohbje_ooooooooooooooo`CoS;[F0_ooool4ohbjePKooooo0_n<^]H2
ooooo`03ohbje_oooooooooo00?oS;[F1?ooool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2
ooooo`03ohbje_oooooooooo00GoS;[F1?ooool00on<^]Koooooooooo`04ohbjePGooooo0_n<^]H2
ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_oo
ool01?n<^]KooooooooooooooolMohbjePKog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_N3?n<^]H2ooooo`?oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo
00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00CoS;[F0_ooool3ohbjeP;ooooo
00CoS;[FooooooooooooS;[F0_ooool00on<^]KoooooohbjeP02ohbjeP;ooooo00?oS;[Foooooooo
ool00_n<^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`03ohbjeP04oooooon<^]KoS;[Fohbj
eP;ooooo00?oS;[Fooooooooool00on<^]H4ooooo`CoS;[F0_ooool00on<^]Koooooooooo`03ohbj
ePCooooo00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_oooolJohbj
ePKog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N3?n<^]H2oooo
o`?oS;[F0_ooool2ohbjePCooooo0on<^]H4ooooo`03ohbje_oooooooooo00;ooooo0on<^]H2oooo
o`?oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`;oS;[F1?ooool00on<^]Koooooooooo`02
ooooo`;oS;[F1?ooool2ohbjePCooooo0_n<^]H4ooooo`;oS;[F0_ooool3ohbjeP;ooooo1On<^]H6
ooooo`?oS;[F1?ooool2ohbjePCooooo0on<^]H4oooooa_oS;[F1_oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh<ohbjeP;ooooo0on<^]H2ooooo`ooS;[F0_ooool4
ohbjeP;ooooo0on<^]H2ooooo`CoS;[F0_ooool8ohbjeP;ooooo5On<^]H2ooooo`?oS;[F0_ooool3
ohbjeP;ooooo00?oS;[Fooooooooool02?n<^]H2ooooobSoS;[F1_oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh<ohbjePKooooo4On<^]H00oooooooS;[FohbjeP02
ohbjePKooooo0_n<^]H2ooooo`03ohbje_oooooooooo00WoS;[F00?oooooohbje_n<^]H04on<^]H2
ooooo`CoS;[F1Oooool3ohbjeP03oooooon<^]KoS;[F00KoS;[F0_oooolXohbjePKog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOn<^]H6omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoS;[F1_oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEohbjePKog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_NUOn<^]H6omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgYGoS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmjEohbjePKog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`;og]_NUOn<^]H6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2
omkKgYGoS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjE
ohbjePKog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOn<^]H6
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgVCoS;[F0oooool^
ohbjePKog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NI_n<^]H2
ooooobgoS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh=
ohbjeP;ooooo1?n<^]H2ooooo`03ohbje_oooooooooo00CoS;[F1?ooool3ohbjeP;ooooo0on<^]H6
ooooo`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjePGooooo0_n<^]H2ooooo`;oS;[F1?ooool2
ohbjeP;ooooo1?n<^]H5ooooo`03ohbje_oooooooooo00CoS;[F1Oooool3ohbjeP;ooooo0_n<^]H3
ooooo`;oS;[F0_ooool2ohbjePCooooo0on<^]H4ooooo`?oS;[F0_ooool2ohbjeP;ooooo0_n<^]H2
ooooo`koS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh=
ohbjeP;ooooo1?n<^]H2ooooo`03ohbje_oooooooooo00?oS;[F0_ooool2ohbjeP;ooooo00?oS;[F
ooooooooool01?n<^]H2ooooo`?oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`03ohbje_oo
oooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oo
oooooooo00?oS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool00on<^]H2ooooo`?oS;[F0_oo
ool00on<^]Koooooooooo`03ohbjeP?ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_oo
ool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool2ohbjeP;ooooo3_n<
^]H6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPgoS;[F0_oo
ool4ohbjeP;ooooo00?oS;[Fooooooooool01_n<^]H3ooooo`03ohbje_oooooooooo00CoS;[F0_oo
ool3ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo
00?oS;[Fooooooooool00_n<^]H2ooooo`GoS;[F0_ooool3ohbjeP;ooooo0_n<^]H2ooooo`03ohbj
e_oooooooooo00SoS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00CoS;[Foooooooooooo
S;[F0_ooool00on<^]Koooooooooo`08ohbjeP?ooooo6_n<^]H6omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPgoS;[F0_ooool4ohbjeP;ooooo00?oS;[Foooooooo
ool01?n<^]H4ooooo`;oS;[F0_ooool4ohbjeP;ooooo0on<^]H2ooooo`04ohbje_ooooooooooohbj
eP;ooooo0_n<^]H2ooooo`04ohbje_ooooooooooohbjeP;ooooo0_n<^]H6ooooo`03ohbje_oooooo
oooo00CoS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`KoS;[F1?ooool00on<^]Kooooooooo
o`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool00on<^]Koooooooooo`04ooooo`;oS;[F
1?oooolKohbjePKog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
3On<^]H5ooooo`04ohbje_ooooooooooohbjeP;ooooo0on<^]H3ooooo`CoS;[F0_ooool4ohbjePKo
oooo0_n<^]H2ooooo`03ohbje_oooooooooo00?oS;[F1?ooool00on<^]Koooooooooo`02ohbjeP;o
oooo0_n<^]H2ooooo`03ohbje_oooooooooo00GoS;[F1?ooool00on<^]Koooooooooo`04ohbjePGo
oooo0_n<^]H2ooooo`;oS;[F0_ooool01?n<^]Kooooooooooon<^]H2ooooo`03ohbje_oooooooooo
00;oS;[F0_ooool01?n<^]KooooooooooooooolMohbjePKog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_N3On<^]H2ooooo`CoS;[F0_ooool00on<^]Koooooooooo`03
ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00CoS;[F0_ooool3ohbjeP;ooooo00CoS;[F
ooooooooooooS;[F0_ooool00on<^]KoooooohbjeP02ohbjeP;ooooo00?oS;[Fooooooooool00_n<
^]H2ooooo`;oS;[F0_ooool00on<^]Koooooooooo`03ohbjeP04oooooon<^]KoS;[FohbjeP;ooooo
00?oS;[Fooooooooool00on<^]H4ooooo`CoS;[F0_ooool00on<^]Koooooooooo`03ohbjePCooooo
00?oS;[Fooooooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_oooolJohbjePKog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N3On<^]H2ooooo`CoS;[F
0_ooool00on<^]Koooooooooo`02ooooo`;oS;[F1?ooool00on<^]Koooooooooo`02ooooo`?oS;[F
0_ooool3ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool2ohbjePCooooo00?oS;[Foooooooo
ool00_ooool2ohbjePCooooo0_n<^]H4ooooo`;oS;[F1?ooool2ohbjeP;ooooo0on<^]H2ooooo`Go
S;[F1_ooool3ohbjePCooooo0_n<^]H4ooooo`?oS;[F1?oooolKohbjePKog]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N3On<^]H2oooooa?oS;[F0_ooool4ohbjeP;o
oooo0on<^]H2ooooo`CoS;[F0_ooool8ohbjeP;ooooo5On<^]H2ooooo`?oS;[F0_ooool3ohbjeP;o
oooo00?oS;[Fooooooooool02?n<^]H2ooooobSoS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk0_oNfmh=ohbjePGooooo00?oS;[Fooooooooool03_n<^]H00ooooooo
S;[FohbjeP02ohbjePKooooo0_n<^]H2ooooo`03ohbje_oooooooooo00WoS;[F00?oooooohbje_n<
^]H04on<^]H2ooooo`CoS;[F1Oooool3ohbjeP03oooooon<^]KoS;[F00KoS;[F0_oooolXohbjePKo
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOn<^]H6omkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoS;[F1_oNfmh00omSIG_o
ooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEohbjePKog]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOn<^]H6omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk0_oNfmjEohbjePKog]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_NUOn<^]H6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgYGoS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmjEohbjePKog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_NUOn<^]H6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgU[o
S;[F0_ooooliohbjePKog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_NF_n<^]H2ooooocWoS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmhNohbjeP;ooooo1on<^]H5ooooo`;oS;[F1?ooool3ohbjeP;ooooo0_n<^]H4ooooo`Ko
S;[F0_ooool4ohbjePCooooo0_n<^]H2ooooo`;oS;[F0_ooool2ohbjeP;ooooo00CoS;[Foooooooo
ooooS;[F0_ooool2ohbjeP;ooooo0_n<^]H5ooooo`;oS;[F0_ooool2ohbjePCooooo8On<^]H6omkK
gP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQkoS;[F0_ooool6ohbj
eP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool00on<^]Koooooooooo`02ohbj
eP;ooooo0_n<^]H2ooooo`GoS;[F0_ooool3ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo
00;oS;[F0_ooool2ohbjeP;ooooo00GoS;[FooooooooooooooooohbjeP02ooooo`04ohbje_oooooo
ooooohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo8?n<
^]H6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQkoS;[F0_oo
ool6ohbjeP;ooooo0_n<^]H2ooooo`CoS;[F0oooool00on<^]Koooooooooo`02ohbjeP;ooooo2On<
^]H2ooooo`?oS;[F0_ooool5ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool00on<^]Kooooooooo
o`02ohbjeP;ooooo00CoS;[FooooooooooooS;[F0_ooool2ohbjeP;ooooo00?oS;[Fooooooooool0
0_n<^]H2ooooobCoS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmhNohbjePKooooo0on<^]H2ooooo`03ohbje_oooooooooo00;oS;[F1?ooool2ohbjeP;ooooo
0_n<^]H6ooooo`GoS;[F0_ooool3ohbjePKooooo00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F
0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo00?oS;[Fooooooooool00_n<^]H2ooooo`04ohbj
e_ooooooooooohbjeP;ooooo0_n<^]H6ooooob3oS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk0_oNfmhNohbjeP;ooooo0on<^]H2ooooo`?oS;[F1?ooool01?n<^]Ko
ooooooooooooool4ohbjeP;ooooo0_n<^]H2ooooo`;oS;[F0_ooool5ohbjeP;ooooo0on<^]H2oooo
o`;oS;[F0_ooool00on<^]Koooooooooo`02ohbjeP;ooooo0_n<^]H2ooooo`03ohbje_oooooooooo
00;oS;[F0_ooool00on<^]Koooooooooo`03ohbjePCooooo00?oS;[Fooooooooool00_n<^]H2oooo
o`;oS;[F0_oooolPohbjePKog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=U
N`;og]_N7_n<^]H2ooooo`?oS;[F0_ooool00on<^]KoooooohbjeP02ohbjeP;ooooo00?oS;[Foooo
ooooool00_n<^]H2ooooo`03ohbje_oooooooooo00;oS;[F0_ooool2ohbjeP;ooooo1On<^]H2oooo
o`?oS;[F0_ooool2ohbjeP;ooooo00GoS;[FooooooooooooooooohbjeP03ooooo`04ohbje_oooooo
ooooohbjeP?ooooo00CoS;[FooooooooooooS;[F0_ooool00on<^]KoooooohbjeP02ohbjeP;ooooo
00?oS;[Fooooooooool00_n<^]H2ooooo`;oS;[F0_oooolPohbjePKog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N7_n<^]H2ooooo`?oS;[F0_ooool2ohbjePCooooo
0on<^]H4ooooo`03ohbje_oooooooooo00;ooooo0_n<^]H4ooooo`KoS;[F0_ooool4ohbjePCooooo
0_n<^]H2ooooo`05ohbje_oooooooooooooooon<^]H00_ooool2ohbjeP;ooooo00?oS;[Foooooooo
ool00_n<^]H2ooooo`;oS;[F1?ooool00on<^]Koooooooooo`02ooooo`;oS;[F1?oooolQohbjePKo
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N7_n<^]H2ooooo`?o
S;[F0_ooool?ohbjeP;ooooo3On<^]H2oooooacoS;[F0_ooool8ohbjeP;ooooo:?n<^]H6omkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQkoS;[F1_oooolAohbjeP03
oooooon<^]KoS;[F00WoS;[F1_oooolJohbjeP;ooooo2On<^]H00oooooooS;[FohbjeP0VohbjePKo
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOn<^]H6omkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoS;[F1_oNfmh00omSIG_o
ooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEohbjePKog]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOn<^]H6omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoS;[F1_oNfmh00omSIG_oooooooooo`01of=UN`00
00CoHfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=U
Nooooooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_ooooo
ojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[go
HfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGo
DYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Ko
g]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03
of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_o
ooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhIoe:F]@Gooooo0omBU[D2ooooo`;o
DYJe0oooool2oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe1?ooool4oe:F]@;o
oooo0omBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0omBU[D6ooooo`;oDYJe0_ooool00omB
U[Goooooooooo`02oe:F]@Gooooo0_mBU[D2ooooo`;oDYJe1?ooool2oe:F]@;ooooo1?mBU[D5oooo
o`03oe:F]Ooooooooooo01[oDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmhIoe:F]@;ooooo0_mBU[D2ooooo`;oDYJe0_ooool2oe:F]@?ooooo0_mBU[D2oooo
o`04oe:F]Ooooooooooooe:F]@?ooooo00?oDYJeooooooooool00_mBU[D2ooooo`?oDYJe0_ooool3
oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool3oe:F]@;ooooo0omBU[D2ooooo`04oe:F]Ooo
oooooooooe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00omBU[D2ooooo`;oDYJe0_ooool00omBU[Gooooo
ooooo`0Joe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
6OmBU[D2ooooo`?oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`04oe:F]Ooooooooooooe:F
]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00OoDYJe1oooool01?mB
U[GooooooooooomBU[D2ooooo`?oDYJe0_ooool3oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_oo
ool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`GoDYJe0_oo
ool3oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo01[oDYJe1_oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhIoe:F]@;ooooo0omBU[D2ooooo`04oe:F]Ooo
oooooooooe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;o
oooo00?oDYJeooooooooool01?ooool4oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03
oe:F]Ooooooooooo00?oDYJe0_ooool3oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F
]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@Kooooo00?oDYJeooooooooool01?mBU[D2
ooooo`04oe:F]Ooooooooooooe:F]@;ooooo6_mBU[D6omkKgP03of=UNooooooooooo007oHfEk0000
1?mSIG_oooooojfZ_OmSIG/2omkKgQWoDYJe0_ooool3oe:F]@;ooooo00CoDYJeooooooooooooDYJe
0_ooool01?mBU[GooooooooooomBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Go
ooooooooo`02oe:F]@;ooooo1?mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Go
ooooooooo`03oe:F]@Kooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe1?ooool00omBU[Go
ooooooooo`02oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00GoDYJe1?ooool00omBU[Go
ooooooooo`0Joe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;o
g]_N6OmBU[D2ooooo`?oDYJe0_ooool00omBU[Goooooooooo`02ooooo`?oDYJe1?ooool01?mBU[Go
oooooooooomBU[D3ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool4oe:F]@;ooooo00?oDYJeoooo
ooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool3oe:F]@;ooooo00CoDYJeoooo
ooooooooDYJe0_ooool00omBU[Gooooooe:F]@02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2
ooooo`;oDYJe0_ooool00omBU[Goooooooooo`03oe:F]@04oooooomBU[GoDYJeoe:F]@;ooooo00?o
DYJeooooooooool06_mBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmS
IG/2omkKgQWoDYJe0_ooool3oe:F]@;ooooo00?oDYJeooooooooool00_ooool3oe:F]@Cooooo0_mB
U[D2ooooo`03oe:F]Ooooooooooo00;oDYJe1?ooool5oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool3oe:F]@;ooooo00CoDYJeooooooooooooDYJe
0_ooool2oe:F]@Cooooo00?oDYJeooooooooool00_ooool2oe:F]@Cooooo0_mBU[D4ooooo`;oDYJe
1?ooool2oe:F]@;ooooo6_mBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgQWoDYJe0_ooool2oe:F]@;ooooo4_mBU[D2ooooo`coDYJe0oooool3oe:F]@;ooooo
00?oDYJeooooooooool00omBU[D2ooooo`?oDYJe0_ooool4oe:F]@;ooooo2?mBU[D2oooooaGoDYJe
0_oooolJoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
6OmBU[D5ooooo`?oDYJe0_ooool7oe:F]@;ooooo1OmBU[D2ooooo`coDYJe0oooool3oe:F]@;ooooo
00?oDYJeooooooooool00omBU[D6ooooo`;oDYJe0_ooool00omBU[Goooooooooo`09oe:F]@03oooo
oomBU[GoDYJe01?oDYJe0_oooolJoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
UOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoDYJe
1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
UOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQGoDYJe
1Oooool3oe:F]@;ooooo0_mBU[D3ooooo`;oDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool0
0_mBU[D4ooooo`CoDYJe1_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D5ooooo`;oDYJe
0_ooool2oe:F]@Cooooo0_mBU[D2ooooo`CoDYJe1Oooool00omBU[Goooooooooo`05oe:F]@Cooooo
0omBU[D4ooooo`;oDYJe0_ooool00omBU[Goooooooooo`0Goe:F]@Kog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N5OmBU[D2ooooo`;oDYJe0_ooool2oe:F]@;ooooo
0_mBU[D3ooooo`;oDYJe0_ooool01?mBU[GooooooooooomBU[D3ooooo`03oe:F]Ooooooooooo00;o
DYJe0_ooool3oe:F]@;ooooo0omBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo00?oDYJeoooo
ooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@;ooooo00?oDYJeoooo
ooooool00omBU[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`04oe:F]@;ooooo0_mBU[D2oooo
o`03oe:F]Ooooooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2oooooaOoDYJe1_oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhEoe:F]@;ooooo0omBU[D2
ooooo`04oe:F]Ooooooooooooe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool00omBU[Gooooo
ooooo`02oe:F]@;ooooo00?oDYJeooooooooool01omBU[D2ooooo`?oDYJe0_ooool01?mBU[Gooooo
oooooomBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;o
oooo1OmBU[D2ooooo`?oDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool00omBU[D2ooooo`Ko
DYJe0_ooool5oe:F]@;ooooo00?oDYJeooooooooool05omBU[D6omkKgP03of=UNooooooooooo007o
HfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQGoDYJe0_ooool3oe:F]@;ooooo00CoDYJeoooooooo
ooooDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool0
0omBU[Goooooooooo`04ooooo`?oDYJe0_ooool3oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_oo
ool2oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@Kooooo00?oDYJeooooooooool0
1?mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0omBU[D2ooooo`KoDYJe1_ooool01?mBU[Go
oooooooooomBU[D2oooooaOoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]
Z[goHfEk0_oNfmhEoe:F]@;ooooo0omBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo00CoDYJe
ooooooooooooDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`?oDYJe1_ooool2oe:F]@;ooooo00?oDYJeooooooooool00omBU[D4ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool01OmBU[D4ooooo`03oe:F]Ooo
oooooooo00?oDYJe0_ooool6oe:F]@;ooooo0_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo
5omBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQGoDYJe
0_ooool3oe:F]@;ooooo00?oDYJeooooooooool00_ooool3oe:F]@Cooooo00CoDYJeoooooooooooo
DYJe0oooool00omBU[Goooooooooo`02oe:F]@;ooooo0omBU[D2ooooo`?oDYJe0_ooool01?mBU[Go
oooooooooomBU[D2ooooo`03oe:F]OooooooDYJe00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F
]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe00Cooooooe:F]OmBU[GoDYJe0_ooool0
0omBU[Goooooooooo`03oe:F]@;ooooo1_mBU[D2ooooo`;oDYJe0_ooool01?mBU[GooooooooooomB
U[D2oooooaOoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oN
fmhEoe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;ooooo0omBU[D4ooooo`;oDYJe0_oo
ool00omBU[Goooooooooo`02oe:F]@Cooooo1?mBU[D2ooooo`?oDYJe0_ooool01?mBU[Gooooooooo
oomBU[D2ooooo`;oDYJe1?ooool00omBU[Goooooooooo`02ooooo`;oDYJe1?ooool2oe:F]@Cooooo
0_mBU[D4ooooo`;oDYJe0_ooool3oe:F]@;ooooo1omBU[D4ooooo`;oDYJe0_ooool00omBU[Gooooo
ooooo`0Goe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
5OmBU[D2ooooo`;oDYJe0_oooolBoe:F]@;ooooo2_mBU[D2ooooo`?oDYJe0_ooool4oe:F]@;ooooo
2?mBU[D2oooooaGoDYJe0_ooool4oe:F]@;ooooo0_mBU[D2ooooo`SoDYJe0_ooool00omBU[Gooooo
ooooo`0Goe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
5OmBU[D5ooooo`?oDYJe0_ooool7oe:F]@;ooooo1OmBU[D2ooooo`[oDYJe1_ooool2oe:F]@;ooooo
00?oDYJeooooooooool02OmBU[D00oooooooDYJeoe:F]@0Coe:F]@;ooooo1OmBU[D4ooooo`WoDYJe
0_ooool00omBU[Goooooooooo`0Goe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
UOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoDYJe
1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N
UOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQ[oDYJe
0_ooool2oe:F]@03oooooomBU[GoDYJe00;ooooo0_mBU[D5ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool2oe:F]@Cooooo1?mBU[D2ooooo`?oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`?o
DYJe1_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D5ooooo`;oDYJe0_ooool2oe:F]@Co
oooo0_mBU[D2ooooo`CoDYJe1Oooool00omBU[Goooooooooo`0Loe:F]@Kog]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N6_mBU[D2ooooo`05oe:F]Ooooooooooooooo
oomBU[D00_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2oooo
o`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo0omBU[D2ooooo`04oe:F]Ooooooooooo
oe:F]@;ooooo0omBU[D2ooooo`?oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooo
oooooooo00?oDYJe0_ooool2oe:F]@;ooooo00?oDYJeooooooooool07?mBU[D6omkKgP03of=UNooo
oooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgQ[oDYJe0_ooool01OmBU[Gooooooooo
ooooooooDYJe00;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;o
oooo0_mBU[D2ooooo`OoDYJe1oooool01?mBU[GooooooooooomBU[D2ooooo`?oDYJe0_ooool3oe:F
]@;ooooo00CoDYJeooooooooooooDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJe
ooooooooool00_mBU[D2ooooo`GoDYJe0_ooool3oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooo
oooo01coDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhJ
oe:F]@;ooooo00GoDYJeoooooomBU[Gooooooe:F]@02ooooo`;oDYJe0_ooool01?mBU[Gooooooooo
oomBU[D5ooooo`;oDYJe1_ooool4oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F
]Ooooooooooo00?oDYJe0_ooool3oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@;o
oooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@Kooooo00?oDYJeooooooooool01?mBU[D2oooo
o`04oe:F]Ooooooooooooe:F]@;ooooo7?mBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgQ[oDYJe0_ooool01OmBU[Gooooooe:F]OooooooDYJe00;ooooo0omB
U[D4ooooo`03oe:F]Ooooooooooo00;ooooo0omBU[D2ooooo`;oDYJe0_ooool4oe:F]@;ooooo00?o
DYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe1_ooool2oe:F]@;ooooo00?o
DYJeooooooooool00omBU[D4ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool2oe:F]@;ooooo00?o
DYJeooooooooool01OmBU[D4ooooo`03oe:F]Ooooooooooo01coDYJe1_oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmhJoe:F]@Cooooo00?oDYJeooooooooool00_oo
ool00omBU[Gooooooe:F]@02oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@;ooooo
0_mBU[D2ooooo`CoDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool0
0omBU[D2ooooo`?oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`03oe:F]OooooooDYJe00;o
DYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00?o
DYJe00Cooooooe:F]OmBU[GoDYJe0_ooool00omBU[Goooooooooo`0Loe:F]@Kog]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N6_mBU[D4ooooo`03oe:F]Ooooooooooo
00;ooooo0_mBU[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D4ooooo`GoDYJe0_ooool00omB
U[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00omBU[D2ooooo`?oDYJe0_ooool01?mB
U[GooooooooooomBU[D2ooooo`;oDYJe1?ooool00omBU[Goooooooooo`02ooooo`;oDYJe1?ooool2
oe:F]@Cooooo0_mBU[D4ooooo`;oDYJe0_oooolLoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_N6_mBU[D3ooooo`?oDYJe0oooool8oe:F]@;ooooo4?mBU[D3
ooooo`?oDYJe0_ooool00omBU[Goooooooooo`03oe:F]@;ooooo0omBU[D2ooooo`CoDYJe0_ooool8
oe:F]@;ooooo5OmBU[D2oooooacoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmhJoe:F]@?ooooo0omBU[D3ooooo`SoDYJe0_ooool@oe:F]@?ooooo0omBU[D2
ooooo`03oe:F]Ooooooooooo00?oDYJe1_ooool2oe:F]@;ooooo00?oDYJeooooooooool02OmBU[D0
0oooooooDYJeoe:F]@0Coe:F]@;ooooo7?mBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2
omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjE
oe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOmBU[D6
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2
omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh7
oe:F]@;ooooo0_mBU[D00oooooooDYJeoe:F]@02ooooo`;oDYJe1Oooool00omBU[Goooooooooo`02
oe:F]@;ooooo0_mBU[D4ooooo`GoDYJe1Oooool3oe:F]@Cooooo0_mBU[D2ooooo`;oDYJe1?ooool3
oe:F]@Cooooo0omBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe1?ooool2oe:F]@;ooooo0_mBU[D2
ooooo`?oDYJe1_ooool2oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D5ooooo`;oDYJe0_ooool2
oe:F]@Cooooo0_mBU[D2ooooo`CoDYJe1Oooool00omBU[Goooooooooo`08oe:F]@Kog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N1omBU[D2ooooo`05oe:F]Ooooooo
oooooooooomBU[D00_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo0omBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe0_ooool00omBU[Gooooo
ooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe
0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0omBU[D2ooooo`?oDYJe0_ooool01?mBU[Gooooo
oooooomBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;o
oooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00?oDYJe0_ooool2oe:F]@;ooooo00?oDYJeoooooooo
ool02?mBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPOo
DYJe0_ooool01OmBU[GoooooooooooooooooDYJe00;ooooo00?oDYJeooooooooool00_mBU[D2oooo
o`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2ooooo`coDYJe0_ooool00omBU[Goooooooooo`05
oe:F]@;ooooo00?oDYJeooooooooool01OmBU[D2ooooo`GoDYJe0_ooool2oe:F]@;ooooo00?oDYJe
ooooooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@;ooooo0omBU[D2
ooooo`04oe:F]Ooooooooooooe:F]@;ooooo00?oDYJeooooooooool00_mBU[D2ooooo`03oe:F]Ooo
oooooooo00;oDYJe0_ooool5oe:F]@;ooooo0omBU[D2ooooo`;oDYJe0_ooool00omBU[Gooooooooo
o`08oe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N1omB
U[D2ooooo`05oe:F]OooooooDYJeoooooomBU[D00_ooool2oe:F]@;ooooo00CoDYJeoooooooooooo
DYJe1Oooool2oe:F]@Kooooo1_mBU[D4ooooo`03oe:F]Ooooooooooo00Cooooo00CoDYJeoooooooo
ooooDYJe1_ooool00omBU[Goooooooooo`05oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo
00;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0omBU[D2ooooo`?oDYJe0_ooool01?mB
U[GooooooooooomBU[D2ooooo`;oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`;oDYJe1_oo
ool00omBU[Goooooooooo`04oe:F]@;ooooo00CoDYJeooooooooooooDYJe0_ooool8oe:F]@Kog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N1omBU[D2ooooo`05oe:F
]OooooooDYJeoooooomBU[D00_ooool3oe:F]@Cooooo00?oDYJeooooooooool00_ooool3oe:F]@;o
oooo0_mBU[D2ooooo`CoDYJe1Oooool2oe:F]@;ooooo0_mBU[D2ooooo`04oe:F]Ooooooooooooe:F
]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00GoDYJe0_ooool2oe:F]@;ooooo00?oDYJeoooo
ooooool00_mBU[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool3oe:F]@Kooooo0_mBU[D2oooo
o`03oe:F]Ooooooooooo00?oDYJe1?ooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2oooo
o`03oe:F]Ooooooooooo00GoDYJe1?ooool00omBU[Goooooooooo`08oe:F]@Kog]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N1omBU[D4ooooo`03oe:F]Ooooooooooo
00;ooooo00?oDYJeoooooomBU[D00_mBU[D2ooooo`04oe:F]Ooooooooooooe:F]@;ooooo0_mBU[D2
ooooo`;oDYJe0_ooool3oe:F]@Cooooo1?mBU[D2ooooo`;oDYJe0_ooool01?mBU[GooooooooooomB
U[D2ooooo`;oDYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo00?oDYJeooooooooool00_mB
U[D2ooooo`03oe:F]Ooooooooooo00;oDYJe0_ooool01OmBU[GoooooooooooooooooDYJe00;ooooo
0omBU[D2ooooo`?oDYJe0_ooool01?mBU[GooooooooooomBU[D2ooooo`03oe:F]OooooooDYJe00;o
DYJe0_ooool00omBU[Goooooooooo`02oe:F]@;ooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00?o
DYJe00Cooooooe:F]OmBU[GoDYJe0_ooool00omBU[Goooooooooo`08oe:F]@Kog]_N00?oHfEkoooo
ooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_N1omBU[D4ooooo`03oe:F]Ooooooooooo
00;ooooo0_mBU[D4ooooo`;oDYJe0_ooool2oe:F]@;ooooo0_mBU[D4ooooo`CoDYJe0_ooool7oe:F
]@Cooooo0_mBU[D2ooooo`;oDYJe1?ooool3oe:F]@Cooooo00?oDYJeooooooooool00_ooool00omB
U[Goooooooooo`02oe:F]@Cooooo0_mBU[D2ooooo`03oe:F]Ooooooooooo00CoDYJe0_ooool3oe:F
]@;ooooo00CoDYJeooooooooooooDYJe0_ooool2oe:F]@Cooooo00?oDYJeooooooooool00_ooool2
oe:F]@Cooooo0_mBU[D4ooooo`;oDYJe1?ooool2oe:F]@;ooooo2?mBU[D6omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgPOoDYJe0oooool3oe:F]@?ooooo2?mBU[D2
ooooo`koDYJe0_ooool3oe:F]@;ooooo2?mBU[D2ooooo`ooDYJe0_oooolEoe:F]@;ooooo0omBU[D2
ooooo`CoDYJe0_ooool8oe:F]@;ooooo5OmBU[D2ooooo`SoDYJe1_oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmh7oe:F]@?ooooo0omBU[D3ooooo`SoDYJe0_ooool?
oe:F]@Gooooo2OmBU[D2oooooa3oDYJe00?ooooooe:F]OmBU[D00_oooolAoe:F]@Kooooo0_mBU[D2
ooooo`03oe:F]Ooooooooooo00WoDYJe00?ooooooe:F]OmBU[D04omBU[D2ooooo`SoDYJe1_oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`;og]_NUOmBU[D6omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/2omkKgYGoDYJe1_oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk0_oNfmjEoe:F]@Kog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UNigog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UNigog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UNigog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UNigog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UNigog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NUOl00004
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgYGo056<1?oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjEo`1AS0Cog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NUOl0DH`4omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgYGo056<1?oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjEo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`Cog]_NUOl0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/4omkKgYGo056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmjEo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`Cog]_NUOl0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4
omkKgW?o056<7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZm
of=UN`Cog]_NLol0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmico`1AS1coDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/4omkKgW?o056<7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/0
0004of=UNooooooo[JZmof=UN`Cog]_NLol0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01
of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmico`1AS1coDYJe1_l0DH`4omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgW?o056<7?mBU[D6o`1AS0Cog]_N00?oHfEk
ooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NLol0DH`Loe:F]@Ko056<1?oNfmh0
0omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmico`1AS1coDYJe1_l0DH`4
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP_o056<1oooool3
o`1AS0;ooooo0_l0DH`2ooooo`?o056<0oooool00ol0DHcoooooooooo`02o`1AS0?ooooo0ol0DH`4
ooooo`?o056<0_ooool5o`1AS0?ooooo00Co056<oooooooooooo056<0_ooool7o`1AS0Cooooo1_l0
DH`4ooooo`?o056<0_ooool2o`1AS0;ooooo0ol0DH`4ooooo`_o056<3?mBU[D2ooooo`koDYJe1_l0
DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP_o056<2?oo
ool2o`1AS0;ooooo0_l0DH`2ooooo`;o056<1_ooool2o`1AS0Cooooo0_l0DH`6ooooo`;o056<0_oo
ool4o`1AS0Kooooo0_l0DH`2ooooo`Ko056<1_ooool4o`1AS0Kooooo0_l0DH`2ooooo`;o056<0_oo
ool2o`1AS0Kooooo2_l0DH`<oe:F]@;ooooo3_mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmS
IG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`2ooooo`Co056<0_ooool2o`1AS0;ooooo0_l0
DH`2ooooo`;o056<0_ooool2o`1AS0;ooooo0_l0DH`2ooooo`?o056<0_ooool7o`1AS0;ooooo1?l0
DH`2ooooo`;o056<0_ooool2o`1AS0;ooooo1Ol0DH`3ooooo`;o056<0oooool2o`1AS0;ooooo1ol0
DH`2ooooo`;o056<0_ooool6o`1AS0;ooooo2_l0DH`Loe:F]@Ko056<1?oNfmh00omSIG_ooooooooo
o`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1AS0;ooooo1?l0DH`2ooooo`;o056<0_oo
ool2o`1AS0;ooooo0ol0DH`2ooooo`03o`1AS?oooooooooo00;o056<0_ooool3o`1AS0Oooooo0_l0
DH`2ooooo`Go056<0_ooool00ol0DHcoooooooooo`02o`1AS0;ooooo1Ol0DH`2ooooo`Co056<00Co
ooooo`1AS?l0DHco056<1oooool2o`1AS0;ooooo0_l0DH`2ooooo`?o056<1Oooool:o`1AS0coDYJe
0_ooool>oe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
1?oNfmh;o`1AS0Sooooo0_l0DH`2ooooo`;o056<0_ooool4o`1AS0Cooooo0_l0DH`2ooooo`?o056<
1oooool2o`1AS0;ooooo1_l0DH`4ooooo`;o056<0_ooool5o`1AS0;ooooo2?l0DH`7ooooo`;o056<
0_ooool2o`1AS0;ooooo0_l0DH`5ooooo`_o056<3?mBU[D2ooooo`koDYJe1_l0DH`4omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP_o056<1oooool3o`1AS0;ooooo
0_l0DH`2ooooo`Ko056<0_ooool2o`1AS0;ooooo0ol0DH`2ooooo`?o056<0_ooool2o`1AS0?ooooo
1ol0DH`2ooooo`;o056<0_ooool5o`1AS0;ooooo2?l0DH`2ooooo`?o056<0_ooool2o`1AS0;ooooo
0_l0DH`2ooooo`;o056<0_ooool>o`1AS0goDYJe0_ooool=oe:F]@Ko056<1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh;o`1AS0;ooooo1?l0DH`2ooooo`;o056<
0_ooool2o`1AS0;ooooo0_l0DH`6ooooo`03o`1AS?oooooooooo00?ooooo0_l0DH`5ooooo`?o056<
1Oooool00ol0DHcoooooooooo`04ooooo`;o056<0_ooool5o`1AS0;ooooo1?l0DH`00ooooooo056<
o`1AS002o`1AS0Gooooo0ol0DH`2ooooo`;o056<0_ooool2o`1AS0Kooooo2_l0DH`>oe:F]@;ooooo
3?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N
2ol0DH`2ooooo`Co056<0_ooool2o`1AS0;ooooo0_l0DH`2ooooo`?o056<1?ooool2o`1AS0Gooooo
0ol0DH`3ooooo`Co056<0_ooool00ol0DHcoooooooooo`02o`1AS0Cooooo0ol0DH`2ooooo`Go056<
0oooool2o`1AS0?ooooo1?l0DH`3ooooo`Co056<0_ooool2o`1AS0;ooooo0ol0DH`4ooooo`_o056<
2_mBU[D2ooooo`;oDYJe0_ooool<oe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmh;o`1AS0Sooooo1_l0DH`2ooooo`[o056<0_oooolJo`1AS0;ooooo
1_l0DH`6ooooo`co056<0_ooool2o`1AS0;ooooo4_l0DH`;oe:F]@Cooooo3OmBU[D6o`1AS0Cog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N2ol0DH`7ooooo`?o056<
0_ooool2o`1AS0;ooooo2ol0DH`00ooooooo056<o`1AS00Ho`1AS0;ooooo1ol0DH`4ooooo`go056<
0_ooool2o`1AS0;ooooo4_l0DH`Loe:F]@Ko056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmico`1AS1coDYJe1_l0DH`4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgW?o056<7?mBU[D6o`1AS0Cog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NLol0DH`Loe:F]@Ko056<1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmico`1AS1coDYJe1_l0DH`4omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgW?o056<7?mBU[D6o`1AS0Cog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NLol0DH`Loe:F]@Ko056<
1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjEo`1AS0Cog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NUOl0DH`4omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgYGo056<1?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmjEo`1AS0Cog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_NUOl0DH`4omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgYGo056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmjEo`1AS0Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`Cog]_NUOl0DH`4omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ
_OmSIG/4omkKgYGo056<1?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
1?oNfmjEo`0000Cog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N
UOl00004omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`00
0?l820So000004ko0000B?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk
1?oNfmh00ol0003o20P8o`00001>o`0004Sog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooo
oooo[JZmof=UN`Cog]_N00?o0000o`P82?l00000C_l00018omkKgP03of=UNooooooooooo007oHfEk
00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000000oo000000?o8B0Qod91@_l@4100
3ol00002oc4`<@oo00000_la<345o`0000;o<C0a1ol00002ob4P8@[o0000B?oNfmh00omSIG_ooooo
ooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`000004o`000003oibN
W?ooooooLg5c00Co00000_ooool00ol@413oLg5cooooo`02ooooo`08ohb>S?l0003o410@oooooonm
_[go0000okfn_Oooool2o`000005omkOg_oooooo0000oa0@4?o>clh00_ooool01_oNgmkoDU5Bo`00
0?mcLG?ooooood91@P?o000000Ko410@oooooola<37o0000oa0@4?o>clh2ooooo`05omkOg_la<37o
0000oa0@4?o>clh00_ooool02_oNgmko<C0ao`000?mBDE;og]oNo`000?mcLG?oooooomkOg_nLWY`9
o`0004Sog]_N00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000
o`P82?l000001?l000001?lQ827okno_ono_kol@4102o`000004oc4`<Ooooooog]oNo`0000;ooooo
01WoHf5Sojf^[OooooooHf5So`000?oNgmkokno_o`000?nLWYcooooood91@_l0003o_KjmoooooolQ
827oW9jLoooooon][ZgoLg5cono_kooooooo@T52of=QHoooooooLg5c00Co000001Wokno_oe9AD_l0
003oW9jLolk?c_l@413o0000og=aLoo_knoo8B0QoibNW?o>clko410@o`000?mcLG?okno_ob4P8Ola
<37oooooo`000?m2@D;o<C0ao`000?o>clkoHf5S00So0000B?oNfmh00omSIG_oooooooooo`01of=U
N`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`000005o`000003og=aLooooooooooo
00Cooooo01goW9jLo`000?ooooooc/o>o`000?lQ827ooooookfn_Ol0003o_Kjmooooool@413oLg5c
oooooomSHF?o0000og=aLooooooo@T52okfn_Ooooooo8B0Qo`000?la<37oooooojf^[Om2@D;ooooo
oibNW004o`000005okfn_OmcLG?o0000okfn_OmcLG<00ol00002oibNW003okfn_OmcLG?o000000;o
00000_nLWY`00ol0003ooooooc4`<@02o`000003of=QHoo_knooHf5S00So0000B?oNfmh00omSIG_o
ooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8o`000005o`00000;
oa0@4?o_knooooooolk?c_nm_[gokno_oooooomcLG?o0000olk?c_ooool00_l00002ono_k`03o`00
0?n<SXcooooo00;o@T5200Woooooog=aLol0003oHf5SoooooomcLG?o[Jj]oooooolQ82400_l00002
ooooo`03o`000?ooooooc/o>00Co000000GoS8j<oibNW?l0003oW9jLohb>S003o`000004og=aLonm
_[goW9jLohb>S0?o000000WoLg5cokfn_Ol0003oc/o>oe9AD_l0003o_Kjmono_komcLG<02Ol00018
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So
000000Ko000003ooLg5coooooomcLG?o0000okfn_Ooooooo@T52o`000?n][Zgooooooc4`<Ol0003o
_Kjmooooool0003oW9jLoooooon<SXco8B0QoooooooNgmko410@oe9AD_ooooooLg5coe9AD_oooooo
c/o>oa0@4?m2@D;oooooono_kol0003og]oNoooooomSHF?o0000oa0@4?l0003oLg5cokfn_Ol0003o
<C0aoooooomSHF?o0000oa0@4?o>clkoW9jLoc4`<OooooooHf5So`000?l@413oc/o>oibNW?l0003o
[Jj]og=aLol0003oooooob4P8Ol@41002Ol00018omkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG/4omkKgP03o`000?l820So000000Oo000000Gog]oNono_kol0003okno_oooo
o`02o`000008og=aLooooooo@T52o`000?nLWYcooooood91@_oNgmh2ooooo`04okfn_Ooooooooooo
ono_k`;ooooo00?oLg5co`000?nLWY`01?ooool00omcLG?o0000okfn_@03ooooo`04of=QHol0003o
@T52ooooo`;o000000SoDU5BomkOg_oNgmkoooooolk?c_lQ827o0000oe9ADP;og]oN00_oooooolk?
c_lQ827o0000og=aLon][Zgo0000ohb>S?oNgmkokno_od91@P08o`0004Sog]_N00?oHfEkoooooooo
ool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o0000o`P82?l000001ol000001OmSHF?o
ooooog=aLoooooooc/o>00;o000000ko@T52og=aLom2@D;o0000od91@_mcLG?o8B0Qof=QHooooooo
g]oNof=QHoo>clkooooood91@P;oLg5c0ol000001?m2@D;oLg5cog=aLom2@D82o`000009oe9AD_mc
LG?o@T52og=aLom2@D;o0000ob4P8Ooooooo8B0Q00?o00000_m2@D85o`0000;o@T520ol000001?mS
HF?o_Kjmo`000?l00002oc4`<@Wo0000B?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooo
oon]Z[goHfEk1?oNfmh00ol0003o20P8o`000008o`000004omkOg_ooooooooooohb>S0[o000000Ko
ooooomkOg_l0003o[Jj]oooooola<34Bo`000003oooooom2@D;o000000ko000000?o@T52ooooool0
00003?l00018omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03
o`000?l820So000000So000000Co@T52ooooooooooooHf5S2_l000001_mSHF?oLg5co`000?mcLG?o
oooooe9ADQ3o00000_m2@D801?o>clkoS8j<od91@_la<34>o`000003oooooolQ827o000000_o0000
B?oNfmh00omSIG_oooooooooo`01of=UN`0000CoHfEkoooooon]Z[goHfEk1?oNfmh00ol0003o20P8
o`000009o`000003okfn_Ooooooo<C0a00go000000?oDU5BoooooomcLG<04?l00005okfn_@03ojf^
[Ol0003o000000co000000?og]oNod91@_l000002_l000000olH61Sog]_NomkKgP16omkKgP03of=U
Nooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03oaPH6?l0003o000001Wo0000
00?o@T52oooooonLWY`09?l000000onm_[goLg5co`00000:o`000003oaPH6?oNfmkog]_N04Kog]_N
00?oHfEkooooooooool00OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?o61PHo`000?l00000
@?l000000ola<37o8B0Qo`00000:o`000003oaPH6?oNfmkog]_N04Kog]_N00?oHfEkooooooooool0
0OmSIG/00004of=UNooooooo[JZmof=UN`Cog]_N00?oFUUJo`000?l00000COl000000omJFE[og]_N
omkKgP16omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG/4omkKgP03ojf^
[Om:BD[o000004co000000?oBTU:ojf^[OoNfmh0AooNfmh00omSIG_oooooooooo`01of=UN`0000Co
HfEkoooooon]Z[goHfEk1?oNfmh01?oWinOo[Jj]oeYIF_lQ8243oa0@40Oo00006?l@410Oo`000003
o`P82?l@413o410@00?o410@00Ko20P8oa0@4?lQ827oFUUJojf^[OoWinM8omkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^MomkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG^MomkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^M
omkKgP03of=UNooooooooooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^MomkKgP03of=UNooooooo
oooo007oHfEk00001?mSIG_oooooojfZ_OmSIG^MomkKgP03of=UNooooooooooo007oHfEk00001?mS
IG_oooooojfZ_OmSIG^MomkKgP03of=UNooooooooooo007oHfEk00000om[KHcog]oWokFbcP2Oohb:
Y@7ooo_o0Oo6bmH1og=aU00000?oHff<omkOiooNgnL0WooNfmh1oooko`7oa/_F0OmcLI@00003of=]
S?oNfnOooooo09oooooo0Ooonol1olK;eP7oLg6D00000omSKHcoe]OWoooko`2?ooOgo`03oibN[OnL
ED;oYDe200SoYDe200OoW5E2oibN[OogmooomoOooookooogmoooa/_F007oLg6D00000omSKHcoe]?N
ooOcm`2?ono_m`03okEEB_ooTYCooj:U00OooijL00?ooj:UoonBU?neEDX01?o_koL1olK;eP7oLg6D
00001?mSKHcoc/oNonO[kooWinl3onOSk`03onOWkooWhnooinO_00CoinO_00?oin?_onOWkooWhnl0
0ooWhnl5onOWk`06onOSkooWinooinO_onOSkooWinooin?_0_oWinl00ooWhnooinO_onOSk`02onOW
k`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOW
k`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOW
k`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOW
k`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOW
k`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOW
k`03onOSkooWinooin?_00;oinO_00?oin?_onOWkooWhnl00_oWinl00ooWhnooinO_onOSk`02onOW
k`03onOSkooWinooinO_00;oinO_00?oin?_onOWkooWhnl00ooWhnl5onOWk`04onOSkooWinoogVES
oonf]@Woojj]00?ookJeomiUHooWinl00ooWinl1olK;eP7oLg6D00000omSKHcoc/oNomkOi`2?omkK
i`03omiUHooo/[GoojZU00;ooooo0oooZZD2ooooo`03oonZYOoo/[GogVES00;og]_W0_oNgnL1olK;
eP7oLg6D00000omSKHcoc/_NomKGgP02omKCgP03omKGg_oFdmkoe]?N08[oe]?N00?ogVESoonb]Ooo
ZZD00oooool01ooo[ZGoooooooooooooooooojZUoonb]OoNIF<00_oFdmh00ooFemkoe]OWolK;eP01
og=aU00000?oHff<olK;e_o>cmh00oo>cmH01?o>cmkoc/_Nolk?e_o>cmH4olk?gP09olk?e_o>cmko
c/oFolk;g_o>cmKoc/_Folk?e_o>cmkoc/_F00?oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKo
c/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKo
c/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKo
c/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKo
c/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKo
c/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKo
c/oFolk?eP02olk?eP03olk;e_o>cmKoc/oF00;oc/oF00?oc/_Folk?e_o>cmH00_o>cmH00oo>bmKo
c/oFolk?eP02olk?eP03olk;e_o>cmKoc/oN00Coc/oN00Woc/oFolk?g_o>cmKoc/_Nolk?e_o>bmKo
c/oFolk?g_o>bmH00oo>cmH00oo>bmKogVESoonb[@02oonZY@Gooooo0_ooYY`00ooo[ZgogVESolk?
gP02olk?gP7oc]?N0Oo6bmH1og=aU00000?oHff<olK7e_o6amH0Soo6amH00ooNIE[oojZUoonRW002
oonRW0?ooooo0_ooWY@00oooVYCoojJLomiUFP03olK7eP7oc/_N0Onm`mH1og=aU00000?oHff<olK7
e_nm`lh0Sonm`lh01?oNIE[oojJLoonJU?ooVY@5ooooo`;ooi:<00?ooijLomiUF_nm`lh00_nm`lh1
olK7eP7o]KK>0OmcLI@00003of=]S?o6amKo_K[>08oo_K[>00?ogVESoonNW?ooTX`00oooool01ooo
SXcooooooooooooooooomhZ4oonFU?oNIF<00onm^/h1olK3eP7o[JZm0OmcLI@00003of=]S?o6amKo
]KK601Co]KK>00?o]KK6okFfc_ne]/H01?ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko
]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko
]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko
]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko
]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko
]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko
]KK>00;o]KK>00?o]KK6okFfc_ne]/h00_ne]/h00one]/Ko]KK>okFfcP02okFfcP03okFfa_ne]/ko
]KK>00ko]KK>00Oo]KK6okFfc_ne]/Ko]KK>omiUHoooUYComhJ400;ooooo0oogRX@2ooooo`03onn6
Q?ooUYCogVES00?o]KK>0Onm_/h1oibN]@7oLg6D00000omSKHcoa/OFojfbaP2?okFbcP03omiYHooo
UYCokh:400OokhJ400?okh:4oonFU?oNIF<00one//h1okfncP7oU9:]0OmcLI@00003of=]S?o6`mKo
[J[608oo[Jk600?ocVUJoonJU?ooUY@02?ooUY@00oooVYcocVUJojf^aP02ojf^aP7o]KK>0On<RZD1
og=aU00000?oHff<olK3e_nUX[d0SonUY[d00onLWZgocVEJomiYH`07omiUH`03omiYHoo>IF?oW9j]
00;oYJJm00?oYJ:mokF^c_n<RZD00OmcLI@00003of=]S?o6`mKoYJ:m09koYJJm00?oYJ:mokF^c_n<
RZD00OmcLI@00003of=]S?o6`mKoYJ:m09koYJJm00?oYJ:mokF^c_n<RZD00OmcLI@00003of=]S?o6
`mKoYJ:m09koYJJm00?oYJ:mokF^c_n<RZD00OmcLI@00003of=]S?o6`mKoYJ:m09ooYJJm0One//h1
ohb:Y@7oLg6D00000omSKHcoinO_omkOk`2OomkOk`7oinOg0On<RZD1og=aU000Y?mSKH`1og=aU000
\
\>"], "ListGraphic",
 Evaluatable->False,
 ImageSize->{165, 266},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"MakeBilateralCellsIntro", "i:94"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating Bilateral Cells", "Subsubsection",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[TextData[{
 StyleBox["To convert a ", "TB"],
 StyleBox["Mathematica", "TBI"],
 StyleBox[" example into bilateral form:", "TB"]
}], "Text",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[TextData[{
 "Create the example that you want to convert to bilateral form. With the \
default settings, each example must consist of a single MathCaption cell \
followed by any number of input and output cells. However, you can change the \
cell styles used to construct a bilateral cell, as explained in ",
 ButtonBox["Specifying Cell Styles",
  ButtonData:>"Specifying Cell Styles",
  ButtonStyle->"AddOnsLinkText"],
 "."
}], "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell["Open the MakeBilateralCell palette.", "ItemizedList",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell["Select the cells that you want to format.", "ItemizedList",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[TextData[{
 "Click ",
 StyleBox["Make Selection Bilateral", "SR"],
 "."
}], "ItemizedList",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell["\<\
The selected cells are automatically converted into bilateral cells. The text \
from each MathCaption cell appears in the left column while the corresponding \
input and output cells appear in the right column.\
\>", "Text",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell["For example, consider the following sequence of cells:", "Text",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[TextData[{
 "Here is the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "n"], " ", "d", "x"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic},
  CellTags->"AT:3.1.0"],
 " in ",
 StyleBox["Mathematica", "TI"],
 "."
}], "MathCaption",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[CellGroupData[{

Cell["Integrate[x^n, x]", "Input",
 CellLabel->"In[1]:=",
 GeneratedCell->True,
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 CellLabel->"Out[1]=",
 CellTags->{"i:95", "Creating Bilateral Cells"}]
}, Open  ]],

Cell[TextData[{
 "If you select the cells and click ",
 StyleBox["Make Selection Bilateral", "SR"],
 ", all three cells are combined into the bilateral cell shown here."
}], "Text",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Here is the integral ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      Cell[BoxData[
       FormBox[
        RowBox[{"\[Integral]", 
         RowBox[{
          SuperscriptBox["x", "n"], " ", "d", "x"}]}], TraditionalForm]],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Mathematica",
       FontSlant->"Italic"],
      StyleBox[". ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }], "MathCaption",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], GridBox[{
       {Cell[TextData[StyleBox["In[1]:=",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}]], "CellLabel",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}], Cell[TextData[StyleBox["Integrate[x^n, x]",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}]], "Input",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4},
         CellTags->{"S1.5.3", "AT:3.1.0"}]},
       {Cell[TextData[StyleBox["Out[1]=",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}]], "CellLabel",
         GridBoxOptions->{RowLines->False,
         RowSpacings->0.4}], Cell[BoxData[Cell[BoxData[
          FractionBox[
           SuperscriptBox["x", 
            RowBox[{"1", "+", "n"}]], 
           RowBox[{"1", "+", "n"}]]], "Output",
          GridBoxOptions->{RowLines->False,
          RowSpacings->0.4},
          CellTags->{"S1.5.3", "AT:3.1.0"}]], "Output",
         GeneratedCell->False,
         CellAutoOverwrite->False]}
       },
      ColumnAlignments->{Left}]}
    },
   ColumnAlignments->{Left},
   ColumnWidths->{0.4, 0.6},
   RowAlignments->Top], Global`InlineCell]], "Text",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[TextData[{
 "If you have a notebook containing multiple ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " examples, you can convert all the examples into bilateral form in one \
step. Each example must consist of a single MathCaption cell followed by any \
number of input and output cells."
}], "Text",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[TextData[StyleBox["To convert all examples in a notebook or project into \
bilateral form:", "TB"]], "Text",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[TextData[{
 "For a single notebook, open the notebook and make it the currently selected \
notebook. For multiple notebooks, open the MakeProject ",
 "dialog box",
 " and load the project file for your project. (If you have not already \
created a project file, see ",
 ButtonBox["Creating a Project File",
  ButtonData:>"Creating a Project File",
  ButtonStyle->"AddOnsLinkText"],
 " to learn how.)"
}], "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell["Open the MakeBilateralCell palette.", "ItemizedList",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[TextData[{
 "Click ",
 StyleBox["Make All Bilateral", "SR"],
 "."
}], "ItemizedList",
 CellTags->{"i:95", "Creating Bilateral Cells"}],

Cell[TextData[{
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "automatically finds all cases in the notebook where input and output cells \
follow a MathCaption cell and converts each such example into a single \
bilateral cell."
}], "Text",
 CellTags->{"i:95", "Creating Bilateral Cells"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dividing Bilateral Cells", "Subsubsection",
 CellTags->{"Dividing Bilateral Cells", "i:96"}],

Cell[TextData[{
 "Once you have created a bilateral cell, you can reverse the process and \
convert the cell back into its constituent input, output, and MathCaption \
cells. To do this, select the bilateral cell and click ",
 StyleBox["Divide Bilateral Cell", "SR"],
 ". To divide all bilateral cells in a notebook in one step, select the \
notebook and click ",
 StyleBox["Divide All Bilateral", "SR"],
 "."
}], "Text",
 CellTags->{"Dividing Bilateral Cells", "i:96"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Updating Bilateral Cells", "Subsubsection",
 CellTags->{"Updating Bilateral Cells", "i:97"}],

Cell["\<\
Once you have created a bilateral cell, you cannot evaluate its input cells. \
If you want to modify the input and re-evaluate it, you must divide the \
bilateral cell, evaluate the raw input cells, and then change your cells back \
into bilateral form.\
\>", "Text",
 CellTags->{"Updating Bilateral Cells", "i:97"}],

Cell[TextData[StyleBox["To modify input and output in a bilateral cell:", \
"TB"]], "Text",
 CellTags->{"Updating Bilateral Cells", "i:97"}],

Cell[TextData[{
 "Select the bilateral cell and decompose it by clicking ",
 StyleBox["Divide Bilateral Cell", "SR"],
 "."
}], "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Updating Bilateral Cells", "i:97"}],

Cell["Edit the cell(s) that you want to modify.", "ItemizedList",
 CellTags->{"Updating Bilateral Cells", "i:97"}],

Cell["\<\
Select any input cell that you edited and re-evaluate it (by pressing \
\[ShiftKey]\[KeyBar]\[EnterKey]). A new output cell is generated.\
\>", "ItemizedList",
 CellTags->{"Updating Bilateral Cells", "i:97"}],

Cell[TextData[{
 "Reformat the group of cells by selecting it and clicking ",
 StyleBox["Make Selection Bilateral", "SR"],
 "."
}], "ItemizedList",
 CellTags->{"Updating Bilateral Cells", "i:97"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pasting Bilateral Templates", "Subsubsection",
 CellTags->{"Pasting Bilateral Templates", "i:98"}],

Cell["\<\
Another way to create a bilateral cell is to first create a template and then \
add the content you need in the appropriate text fields.\
\>", "Text",
 CellTags->{"Pasting Bilateral Templates", "i:98"}],

Cell[TextData[StyleBox["To create a template for a bilateral cell:", "TB"]], \
"Text",
 CellTags->{"Pasting Bilateral Templates", "i:98"}],

Cell["Open the MakeBilateralCell palette.", "ItemizedList",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"Pasting Bilateral Templates", "i:98"}],

Cell["\<\
Place the cursor at the point where you want the bilateral cell to be \
created.\
\>", "ItemizedList",
 CellTags->{"Pasting Bilateral Templates", "i:98"}],

Cell[TextData[{
 "Click ",
 StyleBox["Paste Template.", "SR"],
 " A template containing some sample text is pasted into the notebook."
}], "ItemizedList",
 CellTags->{"Pasting Bilateral Templates", "i:98"}],

Cell["\<\
Replace the sample text with material appropriate for your example.\
\>", "ItemizedList",
 CellTags->{"Pasting Bilateral Templates", "i:98"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Specifying Cell Styles", "Subsubsection",
 CellTags->{"Specifying Cell Styles", "i:99"}],

Cell[TextData[{
 "The two buttons at the bottom of the palette allow you to specify what cell \
styles should be used in creating a bilateral cell. To set the value of \
either option, click the appropriate button to bring up a dialog box. You can \
edit the text and click ",
 StyleBox["Apply", "SR"],
 " for the changes to take effect. Click ",
 StyleBox["OK", "SR"],
 " to close the ",
 "dialog box",
 "."
}], "Text",
 CellTags->{"Specifying Cell Styles", "i:99"}],

Cell[TextData[{
 StyleBox["First Bilateral Styles...", "SR"],
 " specifies the cell styles that should be used for the caption of a \
bilateral cell. The default setting is ",
 StyleBox["$FirstBilateralStyles", "MR"],
 ". This typically has the value ",
 StyleBox["{\"MathCaption\"}", "MR"],
 "."
}], "BulletedList",
 CellTags->{"Specifying Cell Styles", "i:99"}],

Cell[TextData[{
 StyleBox["Rest Bilateral Styles...", "SR"],
 " determines what cell styles should be used for the content of a bilateral \
cell. The default setting is ",
 StyleBox["$RestBilateralStyles", "MR"],
 ". This typically includes input, output, and graphics cells."
}], "BulletedList",
 CellTags->{"Specifying Cell Styles", "i:99"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotebookDiff", "Subsection"],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
 CellTags->"NotebookDiffIntro"],

Cell["\<\
The NotebookDiff palette enables you to find differences in content or \
formatting between any two notebooks or groups of notebooks. The results of \
the diffing operation are displayed in a new notebook, which provides a \
convenient way to view and manipulate the differences in the source \
notebooks.\
\>", "Text",
 CellTags->"NotebookDiffIntro"],

Cell[CellGroupData[{

Cell[BoxData[
 ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "OpenCloseItemizedPicture",
   FormatType->StandardForm,
   ImageSize->{54, 13},
   ImageMargins->{{0, 0}, {0, 0}},
   ImageRegion->{{0, 1}, {0, 1}}],
  Active->True,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& )]], "OpenCloseItemizedPicture",
 CellTags->"NotebookDiffIntro"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002U0000kR000`400?l00000o`00003o00So`L??
ol[=e_o;c]Ooa/W>olW:coo9b/kob<O=olO6c0;ob/OB00Sob/KDol[7d_o:am3ob/S=olW9boo8bL_o
b<S@olK9dQ;ob<SB0_o9am84olW8d0Cob<S@0_o6bM8@olS8d0;obLS@0_o8b=08olS8dP;ob<S@00?o
bLS@olW8c_o8b/T07_o8b/L00oo8b/Wob<S@olS8dP0MolS8dP05olK9d_o5bMCoaLWDolK9d_o8b=80
0_o:am801?o9b=3ob<S@olS8d?o6bM02olG:d0;ob<S@00Kob/OBolW8d?o8alooc/oDolW9dOoCdm/1
ol71b`0000God]CPoo7doOohnooomOSmoo_no`02ookoo`03ooonooono?ooooco00?oooco00Cooogo
ooomo_ono_kooOko5OomoOl00oono?oooOgoooklo`05oogmo`;onoko8?omoOlPoognoaoooOgo00Go
nokoooSoooohoooonokooogmo`02ooklo`03ookmooomoOoonoko00?on_oo00SonokooogmooonoOoo
o_gooo_looonoooom?Cloo[jo`7ocloI00004_o8c=OomOWoooChoooXkO7ojo3donO[k_oWj^oojnca
on_[mOo/j_GokN[eongZloo_j_3okn_/ono[j?o]k>[ok>_`on_[l`Sojn_e1_oYjoL6onW/m@05on_[
mOoYk?Gojn_gon_[mOo[joL05_o[joD00ooYk?GojN_gonW/m@02onW/m@Cojn_e1?oYk?D00ooYjoOo
jn_eon_[m@0Oon_[mA3ojn_g3oo[joD01OoYk?Goi^geonG^mOoXk?GojNce00;ojn_e00?ojn_conW/
looXkO<00ooVkO<02?oYk?7ojncaonc[lOo/jo7ojN[_ong^loo_koOonOWo0Oo6a]000003olK8e?og
noooi^_a00;oc=7E00Coa<W=olG:c_o7c=;oal_D0_o8b]H00oo:b]Cobl[@ol_;c@02ol_;b@03olc:
cOo<b/oobl[@00Gobl[@0_o;b]86ol[:dPGob/_@1Oo:b]83ol_:dP03ol_:d?o;b];obl[@00oobl[@
1_o:b]800oo:bm3obl[@ol_:d002ol_:d0;ob/_@0oo:b]800oo:b]CoblWFol_9eP0Nol_9eP03ol_9
e?o;b];obl[B00kobl[B3_o;b]001Oo:bm3oalc@olG=d?o8bm3ob/_@00?obl[@00?ob/_?olS<coo7
c<l00_o7c<l02?o:blgobl_=olc:cOo<b/goc<_Aol_<dOo[jo?onOWo0Oo;bmD00009olS8d_oloooo
hnS^olS=dOoBf]godM_MomGNiOoEgnSodM_U00?odM_W00God]_Tom;Kh?oCfmgoe][Kom[Ie`03omgG
e`;og=SI0_oJf=T4om[Hf`Cog=SI0_oJfML3omWIf@?ofMWK0_oJf=/2omcGf`03omgGfooMemWogMOK
00;og=SI3ooJf=T00ooJf=_ofMWKom[Hf`03om[Hf@Cog=SI0_oJf=T2om[Hf`03omWIfooJf=gog=KP
01kog=KR00?og=KPomcGgOoLem/03OoLem/00ooLf=Wof]SIom[Hf@0>om[Hf@;of=[G00?ofMWIom[H
fOoLf=T00_oLf=T00ooJfMOofMWGomWIe`02omWJe@08omcIe?oMf=Coh=KDomoGeOoFe=Wob<W>oo[j
oooknol1ol_;e@0000[ob/W?ookooooQi>WoaL[>om?MgooBgN7oc]gTolWJi?o;gN_obmc/0_o:gNh0
1Oo;g>cobmgYol_NiOo>gNCodMcR00;odm[P0_oBfn82om7Ki003oloLi?oAfnCodM_T00;odM_T1?oB
fn82om7Lh0;ocmcR0oo?g>@2oloLi@;odM_U0_oBfn@2om?Ji003om;Ki?oAg>;odMcR00godMcR00Co
cmcToloLiOo?g>GodM_U0_oAfn@00ooAg>;od]_Rom;KhP02om;KhP;odMcR00GodM_ToloLi?o?g>Go
cm_Wom7Jj@0Nom;Ij@03om;JiooBf^God]_T00god]_T0_oAfn@>om7LhP;ocmcR00?ocmgPom7Lh_oB
fn800_oCf^800ooCf^Cod]_Rom7LhP02oloMh009om7Lg_oCfmkoeM[MomSIgOoIf=gog=gRolK7c?on
o_oonOWo007obl_E00004Oo<b/goo_coonKWjOo9c]7od]cNolgLhOnQ/kgoWK?0oiZcaonI/l[oV;C<
oiJdc?nF]L[oU[G9oiJeaonE]/WoT[K<00;oTKK@0_n?]m42ohjgd`0Johbhdon:/looUKkJohjfd?n;
/lgoUK[DoiBidonB]/koTKO>oiBmdonC_=;oQjo8oi2hdOn:]<goS[SAohjjeOn8]=7oS[[Goi:kfOn<
]M?oRk;?oiBie_nB]mCoSk;>oi>hdon9/L/2oi:le@CoSKO@013oTkgFoi2jdon=]m3oSkWBoi>me_nA
^mCoRkG>ohZdcOn>^=7oS[OCoh^gd_n>]m?oSkWBoi6idon@^=;oT;G?0_n>/ld02OnA]]3oT;SBoh^c
cOnB^mOoSkSDohRaconA^]KoU;cFoh^cc002oi:jd`0HohbdcOn@^=7oT[[Coi2hdOnA^M;oRk?<ohjf
conD_=GoT;SAohfec_n?]m3oT;SAohbdcOn9/L[oSkO@oiBleOn>]/ooR[;;ohR`bOnF_]OoT[[Coh^c
c?n<]<goT;SA0_n>]/l00onA^M;oT;SAohbdcP02ohnfd`;oS;?@0_n?]]<02_n</m3oS[GBohjed_n?
]]?oT[WFoi6heOn?]]?oSKCAohfecon<]<h2ohjhd@;oRkG>0_n>^=403?n;]LkoV<;KohZdcOn<]/oo
UKoHoi2jdon<]/ooS[SAohfgcon>^=3oSkO@oi6fd@?oT[GA00koT[GCoi6fdOn?]m7oSkO@ohnhc_nA
]lcoTKC:oiNgc?nF//Sobmk_om?Ji?o:bm3ooOgooo_ko`7obl_E00003Oo?bL_ooocmonOWjOo9c]7o
dMcPol_LhonM]KooVKC5oiFec?nB]]3oTKKCohnfeOn?]]<00_n?]m401on<^=7oR;WGohNif_n5^][o
QK[LohBjg?n4^]h00_n3^mh07?n;`nKoO;;DohBifOn?`N;oP;?Boh:cdOnA`=koQ[GAogf^c?n=`=go
RKcIohJif?n6^m_oR;oNohFkgon5_N3oN[3DohFkgon>a>SoR[kSoh>ef?n5]m[oR[_LohJhfOn=`^;o
OKCCogjee?n7_]d2ohFlf`04ohBkf_mi/<ooPk[Ioh6he`?oP;OF00?oP[WHohFlfon8_^000_n5^ml0
6on3^M_oPkSJoh:geon6^MSoR[_KohbmgOn:^m_oQKSGohFgf?n5^][oRKkPoh:hf_mo]MWoRl7Soh>h
eon;`MgoQkgIoh2fd_n6_=SoPkWEohRnf_n1]m?oRKoKohRnf_n3^MGoOK??oh2fdP02ohRnfP0Boh2f
d_n=`mooR;kJohRnf_mo]M7oR/3Lohk4h?n;`MgoPKOCohBje_n6_=SoR/3Lohc2g_n8_][oP[SDoh6g
don4^MSoS<7Q0_n4^M/2ohc1h`;oQ;WK00CoS<7SohVnh?n8_MooQ;WK0_mo]=H01?n4^M_oR;gOohVn
h?n<`N42oh>jf@;oRl;Q0_n3^]T07On;`^7oN[7@ohBkf_n5_=_oP;OFoh6heon5_=_oQ[gLohNngOn5
^][oQkWJohRif_n8^=coR[SLohZgg_n8^=koR;SLohNig?n5^][oQK[IohNjeon9]]GoS[[GohnddOo4
h?KodM_Uol[;d?omoOoono_o007obl_E00003OoAb<WooocmonOWjOo9c]7ocmgPolWMi?nJ]/;oUKK9
oi6fd?n>]mOoRkOJohZhg?n8^MX00_n8^MT01_n8^MOoR[WEohZieOn8^]GoR;WGohNje`CoQk[I023o
P;7?ohBccon>_=KoTKgFohfgcon<]L_oSkS<ohjhc_n<]/coQkC;ohNcc?nC`M_oQ[G?ogZ[bOn<_mco
S;gMoh>de?n5]]CoQkSFohJedOn?_=WoTkoJohFccOn9^=CoQ[SCohZleon<_]WoR;[EohNie?n9^mKo
R[cGohVkeP;oRkgH0_n9^mH07?n:_=OoQkWDoh>ed?n5]]CoRK[Hohfof_n@_m_oS[cFohZhd?n8]<go
Q[?:ohfjdOn?_=?oR[K?ohNecon8]m?oS/3Kohbmfon6^=?oQ[SAohZjdOn3/l[oQkO>oiO7g_n0/<Oo
R;S?ohjneOn5]L`2ohVid005ohZjdOn<_=?oR;S?ohJfcOn<_=<00_n5]L`02_n>_]GoR;S?ohfme?n3
/l[oQkO>ohFec?n>_]GoS;cCohFec?n4]</2ohVid003ohZjdOn?_]SoQ;??00;oRk[F0_n4/ll2oh^j
eP04ohBccon6]M7oRk[Fohflf0;oRk[F00CoSKcHoh^je_n4]]7oP[C?0_n9^mH2oh:dc`;oRK_F00Wo
P[C?ohfof_n@`]goR;[EohJhdon>`=_oRkgHoh>ed?n7^M@00_n:^MD01?n;^=GoS;OGohjgeon<]mT2
oh^hf@0<ohZhfOn:^MOoR[WCoh^idOn=]LkoTkW@oi>cb_o8go7od]_Tol[;d?omoOoono_o0Oo;bmD0
000Eom78boooo?goinOYolW>d_o?g>;oamkVoiVfa_nB]/coS[OCoh^hfOn8^=koQkSPohFig_n5^]co
QK[JohNjeon:^MGoRkWCohZidon:^MGoR;[E00?oR;WG06OoRKSDoiS6h?nE`M[oQJo5ohZcaonE^/go
T;?6oiJjb_nA]LGoU[_=oiVod_n9//KoTK_AoiG2fOn=^m?oSK_Eoi2mf_n9^=;oR[SBohjle?n=^M;o
S;K>ohnidOnC_MGoQ;;:oi;2fOn9]looOJg4ohfkdon@`=OoRKO?ohZjdOn7]LgoQ[K=ohVgcon;^m;o
S[cDohbldon:^=3oQ[K=ohbje?n;^M?oR[S@oh^hcon>^<koTK[>oiJldOnH_]7oS;;7oiFkd?nA^/ko
U;kDohZgc_n;^M7oR;K@oh:`b_n8]]3oS[cDoiG1g?n4//[oT;cGohfkdonD`=_oR;K>ohZfdOn<^];o
S[[EohnmeOnC_m[oRkWAohRdcon?_MGoSk_Fohbjd_n;]m;oSK_Coi:nfOn=^m?oTKgHoh^idOn:]]7o
SK_Cohbhdon<^];oTkoJoi2ne_n<^=?oSK_Cohnke?n<^];oSKWBohjle?n?^mCoS;[Bohfid_n>_=Co
S[[Cohfkdon=^M;oRkWAohfid_n=^m?oS[[C00;oS[cD00koRk_Bohbjd_n=_MCoS[cDoh^kd_n<^];o
SKgDohZhd?n8^<ooQkG=ohNgc_n<^];oRk_BohZhd0;oRkWA00KoRkWCohbhdon>]mGoS[OEohjgeon<
]mL2oh^he`0;oh^heOn;^M7oS[S@ohnec?nE^<koU;?8olWNkooBfnCob/_@oogmoooknol00Oo;bmD0
000Eolo9cOoonoooinK[olO>e?o>gNCoa]kXoiNfb?nA]lkoS;SEohZhf_n8^=koQkSPohNig_n7^Mco
Qk[IohRieon:^MGoRkSEohZieOn:^MOoR;WG00;oR;WI07[oR;WGohRgdommZLCoTK_Coic2fOnC^<_o
TkC7oi6a`?nE]LCoV[[9oi6b`onC]/WoTkS;ohbbbOn;/lcoSKO@ohfid_n8]<ooS;[DohVed?n9]Lko
U;kGoi2hdOn7[lSoRk?<ohZfcon@_]SoT[kIohbje?n=^MCoS;[Dohbhdon;^M?oTkoJohbje?n;]m;o
SK_EohjjeOn:^=;oRkOBohnmeon=^MCoRkOBoh^ec_n<]<goSkG<oi2db_n@/lOoS[74oi:ebOnD]l_o
QZ[0oiRneOn@^=7oR[C=oh^gd_nE`MkoT;_Koh2[bonE_N3oRKCDohVae?n:]MGoS;CGohJadOn@^=_o
Sk[Joh^ce_n3[/koR[;Eohfhf?n=]MSoQ[7AohZbeOnD_mooRk?FohZeeOn5[M3oR[GEoi>kg_n<]mOo
R[;EohjifOnB^]goS;OGohZbeOn6/M7oR[;Eohfhf?n<]M7oSKWBohnid_n:]/ooS;K?ohfid_n?^M;o
R[K?ohfgd?n7/lcoRK?<ohbhdOn?^M;oR;C=ohZdcOn<^=7oR[K?ohbjd_n=^M;oRKO?ohZfcon<^];o
SKWBohVgcon9]LkoR[S@oi>of?n>_=CoQ;39ohZhd?nD`=WoRKO?oh^id`;oRkSE0_n<]mL03on<]mWo
RkSIohZhfOn:^MOoR[WEohZidon<^=7oSKK<oiBhc_nD/lSobMkaom;Ki?o:bm3ooOgooo_ko`01ol_;
e@00017oclS?ookloooVincoa/oFolcMiOo6g^[oU[O8oi6gc_n<^=GoR[SJohRhg?n8^=koR;SLohRi
fOn:^MOoR[WEoh^he@02oh^he`;oR[SI0_n8^MT0NOn:^=WoS;WHohjjeOnA]]3oT;C:ol7Qm_oYoooo
j_ooon_ooooMn?oo_m[[oiJbaonJ^/ooT;?9ohndc_n?]m7oT;[Cohffd_nG`mkoTkgFohVcc?n@^=7o
UKgFoiBjdOnC^=;oT;[CogfYa?n=]];oV<COohZccon8]<ooTkcHohNcc_n9//koQk?>ohbedOn=^MCo
SkSDoh^gd_n=]];oT;WEoi6je_n@^]?oT;SBoi>id?nE^M7oU[W=oiNgc?nG]/[oioooon3ooonK_]Co
Sk?9ohfbc?nD_=GoS;GAohRacOnD_MgoQJk>ohjee_nD_MgoSkKGohnhf?n@]mSoU;gMohjee_n9/];o
TKSIoiJogon@]mSoS;GEoi>jfonD_MgoS[GFoi6jf_n:/M;oV<7QoiNngon8/M7oSkKGohbeeOnB^M[o
S;GEohjee_n>]mOoS;?Doi6jf_nE_=goSKKDohnfdon?^M;oT;SBohjhdOn?]m7oSkWBoi2hd_n>^=7o
T[[DohjhdOn?]m7oTK_Doi:je?n?^M;oTKWCoiBneon>^=7oSKWBohnid_n<^=7oS[SAohfid_n?^M;o
S;SAoiFof?n5/L[oRK?<oi2leOn?^M;oRkO@ohnid_n;]m800_n:^MD04_n;^=OoRkSIoh^hfOn;]m[o
R[SJohRif_n8^MWoR;WGohRjeOn;^M7oSKG>oiBhd?nD//[obMkaom;Ki?o:bm3ooOgooo_ko`7obl_E
00003_o>bM3ooOcoonCWk_o5cmSobmgWolCNjonF]lSoTKO>ohjgdon;^=WoRkOJohZhf_n;^=WoRkSE
0_n<^=400on<^=GoRkSIoh^hf@04ohZhfP1koh^hfOn;]]KoT[_GohnccOnN_]GofoOooloYn_nM]<Co
_mKVongooooWo_ooV;77oiVebonF]<coU[SCohjacOnB]mCoT;ODohF^b_n>]M;oU;cFohZbbon=//co
Uk_Coi2fcOnD^mSoT[_Iohjee?n8/LooS;?Boi:kfOnC^]WoSKKDohbcd_nD_M_oU[gLohbedon9/<oo
S[OEoi:if?n?]]GoRk;?ohndcon@]M3oSk?;oi6ab_nC//OoVKG;oific_oYooooh_kooiJdc?n@/<Oo
T[K@oiJkeOn>/m3oUKgGohZbc?nQbN;oQJ[4ohjfcon?]<koRk?<ohfbc?n=]LkoTkSBohfec_nE^]Co
S[K?ohBY`on?]m3oVl3JohN_b?nA]]3oT;SAohfbc?n5[LKoVKkHohN_b?nOa=koRk?<oi:gdOn9/L[o
U[_EoiJneon9[/SoS;C=oiRmeon9/L[oT;G@oi2hd_nB]m;oS[K@oi2ed?n@^=;oT[OBohjfd?n;/<_o
S[K@oi:gd_n<]<koSkC?oi6idonC^=?oS;C>ohjed_n?^=CoT;ODohffd_n>]M;oSkSDoi2ge?n=]];o
R[7>oiJofonA^=GoRK;>oi>jeon@^MGoRk;?ohnke_n:^MGoR;WG00;oR[SI013oR[SJohZhg?n:^=co
R;WJohNif_n7^]WoR;[EohZidon<]/ooTkW@oi>cb_o8go7od]_Tol[;d?omoOoono_o0Oo;bmD0000=
olc9d_omo?ooi>O^olK?e_o?g>CoamgXoiBgb_n?]m3oS;SEoh^heon:^=[oRkSIohbhe@02ohjhd@05
ohbhdon<]mOoS;OIoh^hfOn:^=X00_n8^MX0@_n;^=WoS;SEoi2ed?oRoooojOoooiB_`_nR^L_oj?ko
on?ioooFk?Wol?ooonSkoonR^L_ojOooonCnoonL^];oTK3<onCooooSooooUKWCoiBhd_o@l_ooi?oo
onKoooo=k_ooU[K;ohndc_oRoooog?oooi^ofOn=]LooRK7;oi^ke?o@l_oog_ooon3oooo<l?ooX<CN
ohJ]b_n=]];oTk[Gohbac?nnh?_od?;oon?ooooToooog?OookkGjonP_=;oT:c1on_oooo^oooocNWo
onOooooGloooW;S=ohn]aOo9jOoohoooomcooonH^looh_ooonCooonF^LcoU;O:om;eo`;oi_oo00go
c^oooiZkc_nJ^lkoh_ooonKooonF]l[oV;_?om_noooVooooUKS;ohZ`aon@]/goi?oo00;oh?oo00So
f_ooon7oooo6iOOoUKK9oj;3e_oIm_oojOoooiNgcP;ohooo0_nE]m02on?oo`04oiFgd?nB]<go]mWb
omSjo`;ohooo01Gof_gookWKm?nD^=3oTKWComkooooOooooT;WEoi6heOoNoooogooooi2ieOn?]]?o
goooomgooonC_=SoRK3=oiBmfOn=]=7oR[KCohZieon8^ML00_n:^=T3ohZhfP0=ohRif_n7^M[oQk[I
ohRieon:^MGoS;K?oi>id?nC/l[ob=oaom;Ki?o:bm3ooOgooo_ko`01ol_;e@00013obl[@oocmoooV
incob/kAomKJgOo;g>CoTkO=oh^heon;^=GoR[WGohNif_n8^MWoS[SAohngd?n;^=GoR[WG0_n<]mL0
Gon:^MOoQk[GohFkeon7^]GoR[WCohnhc_nK^/koj_ooon_koonQ[kcoioGoongooooDjo?oh?Ooonoo
oooaooooVjjmonkoooo/ooooV[G8oiNcb?oYooooiooooiJbaoo@k?ooioooomOaoooKl_ookOooom?]
o?n>/LCoi?ooonWooon?[;coUKk@oi:ib_oFjOOok_oool[dooncg^ooj_ooomojoonD_]CoP[38oiO1
eoncf>_ohoooomchoonceNko_=_`on[jooo/o_oo`>3goi>baooeoooomoooom?/ooo?j_ool_ooomk/
mOnZ_L_oj_ooon_ooonF//3oV[G6on[ooooTo_ooX;[9om;/noo[ooooe>_iom?Zn?o]ooooeNgioibd
`?o]ooook_oooiR__OnH//?oiooooo3ooonH//7oTKWCohVaboo[ooooj_oooi6jf?n6[l_ojOooon[k
ooo@ioOoW[?4onkkoooeooooWkC500;ojooo01ooUZo3oiN`a?o[oooojooooiNa`_nO^L[ogoWoon[o
oonle^Oo^]CUon_ooooYooooUKC8oi>hd_oLoooog_ooohjjeOn@^MGog?ooomkooon>^]GoS[OComgo
oooLooooTKgHohRacOnB_]WoS;GAohVfdon8^MOoR;WI00;oR[WG00CoRkSGohZieon:^=WoR;WI0_n8
^MX02_n8^MWoRkSEohfeconD^=3oTk?8olSOkooBfnCob/_?oognoooknol1ol_;e@0002?ob/_@oocm
oooWi^_ocLg?omWIfOo>fn7oTkOAohRifOn;^=OoR[WGohFjg?n7^]WoSkOAohngd?n:^MOoR;WIohbg
eon<^=GoR;WGohFkeon4_=GoQK_CohZjd?nA]lcoUK31oo7oooogooooZ[BnooGoooo^ooooYKc4oije
^ooaoooom?oooi^/]P02oo3oo`1@oine`onQ^<SokOooonWooonN]LGok_oooo3ooonN/;coWZnion_i
oooaooooVkS8on?oooo^ooooWK?0oiRmcOnI^lOomoooooGooonD^<KoSkK5oijb_OnO//3oS;;5ohnl
don<//Ooh?ooongooooAjocoT;37oiRdbOoDhNWomOooomWioonM_=7olocooo_ooonQ^lcoUk;5ooOo
oooiooooVjVboo3oooo[ooooW;?1oj2gaOoPmoook_oooiJ/^_o`oooojokooifa_?nR]/7okoooongo
oonN/;[okOoooo;ooonW^LGoWK?1on_oooodooooV:jkoi>keOn@^=;ok_ooongooon:/m7oV;oLol;C
gOohooooiOKooiRZ^?okoooom__ooj2^^ooYooool?ooojBjb?nT]lP2on_oo`0:oj2fa?nO]L?oV:jl
oj[0c_oBj?Koh?KoonWooooPm_ooXKc=oi2fc@;oSKWD0_n;]m82ohfie00;oh^gd_n7/lkoU<3Kohjj
eOn7/lkoT;cGohjjeOn8]<ooS[_HohRieon7^]T00_n:^ML2oh^he@;oR[WG0_n8^MX02_n:^=WoRkSG
ohfeconD^=3oTk?8olSOkooBfn;ob/_?oognoooko?l1ol_;e@0002Oob/_@oocmoooWi^_ocLg?omWI
fOo>fn7oTkOAohRifOn;^=OoR[WGohFjg?n7^]WoSkOAohngd?n:^MOoR;WIohbgeon<^=GoR;WGohFk
eon4_=OoQK_EohZjdOnA]lcoTjk1oo3oooo_o?ooWJVeooCoooo`ooooVK6koiR_]ooeooookoSmokK1
aOoao_ooloooojBe_onDYJl00_oaool09_nJZkGok?goooCooonP[K?oZkJjooSooooao_ooWK;3onko
oooeooooXJjnoiBa`On?ZKSonoooooWmoooZoooohOooooGoooo`o?ooX;oDoiVmeOn>[<Coj?ooon;h
oonS^/[oTK35oiJaa?na_<;ok?Woon3ooonB/LKolocoooWooonJ]<GoWKS;oo;moooiooooY;:m0_o/
ool04onQ]lCoUZbionkoooo^ooooXkW6onGhooo`ooooY;S3oiZ^^Oo^ooool?oooinc__o`oooolOoo
oiZ]^onS^/[ok_ooooCooonEZkP00_n@]Ll2oo3oo`0=oh^ccOn@]LooYkFnooWoooo^ooooX[C2ooWo
oooio_ooX[2koo3ooooaooooVJbjoif^_P02oo3oo`;oVZfk00?of>_ion;hoooYool00_o^ool00ooC
jOKoUk;3oi6gcP02ohfie0;oS;SC0_n=^M@02on<^=?oTkoJohFac?n7/lkoT;cGohfie?n;]m;oSKWD
ohZge?n8^MOoQk[I00;oR[WG0_n;^=D2ohZie`;oR;WJ00[oR[SIoh^heon=]LooU;S@oi>cb?o8gnoo
d]_Rol[;coomo_oonoco0Oo;bmD0000Lol[;d?oloOooinK[olg=cooIfMWoc]_Qoi>gdOn8^MWoRkSG
ohZieon5^]coQk[IohngdOn?]m3oR[WGohRifOn<]mOoS;SEohRieon5^mOoQ;cGohFkeOn:^]7oSkS>
oiZicOo]ooookooooj:b`@;okOoo02[oV[K2oing`Oo`oOoonOoooj>//Oogoooolooooin]]_nZ^<?o
k_oooo7ooonS];colOooooGooonQ[;;oZ;6fooSoooodo_ooUjZi