(* :Context: AuthorTools`Headers` *)

(* :Author: Louis J. D'Andria *)

(* :Summary:
    Package to support the Headers and Footers dialog in V6.
    
*)

(* :Copyright: *)

(* :Package Version: $Revision: 1.7 $, $Date: 2004/03/04 21:28:25 $ *)

(* :Mathematica Version: 6.0 *)

(* :History:
    
*)

(* :Keywords:
     
*)

(* :Discussion:
    
*)

(* :Warning:
    Some SetOptions commands do not respect a value of True or False,
    but rather convert this to a value of Inherited.  This explains
    some of the behavior of the headers and footers dialog.
*)



BeginPackage["AuthorTools`Headers`", "AuthorTools`Common`"]


NotebookHeadersDialog::usage = "NotebookHeadersDialog[nb] opens a dialog for editing the headers and footers for the given notebook.";


Begin["`Private`"]


$font = "Arial";


gridOpts = {
  Background->$Resource["WhiteBackground"],
  FontColor->GrayLevel[0],
  FontWeight->"Plain",
  FontFamily->$font,
  GridBoxOptions->{GridFrameMargins->{{1,1},{2,2}}}
};

grid1[nb_] :=
StyleBox[GridBox[{{
    StyleBox[DynamicBox[ToBoxes @ $h[nb, "StartingPageNumber"]], FontSize->18]}},
    GridFrame->True],
  Sequence @@ gridOpts
];

grid12[nb_] :=
RowBox[{
  StyleBox[GridBox[{{ StyleBox[DynamicBox[ToBoxes @ $h[nb, "StartingPageNumber"]], FontSize->18]}},
    GridFrame->True],
    Sequence @@ gridOpts
  ],
  " ", 
  StyleBox[GridBox[{{ StyleBox[DynamicBox[ToBoxes @ $h[nb, "StartingPageNumber"]], FontSize->18, FontColor->GrayLevel[1]]}},
    GridFrame->True],
    Sequence @@ gridOpts
  ]
}];


grid21[nb_] :=
RowBox[{
  StyleBox[GridBox[{{ StyleBox[DynamicBox[ToBoxes @ $h[nb, "StartingPageNumber"]], FontSize->18, FontColor->GrayLevel[1]]}},
    GridFrame->True],
    Sequence @@ gridOpts
  ],
  " ", 
  StyleBox[GridBox[{{ StyleBox[DynamicBox[ToBoxes @ $h[nb, "StartingPageNumber"]], FontSize->18]}},
    GridFrame->True],
    Sequence @@ gridOpts
  ]
}];




insertSpecialButton[] := ButtonBox["Insert Value\[Ellipsis]",
  ButtonFunction:>FrontEnd`MessagesToConsole[OpenAuthorTool["InsertValue.nb"]],
  ButtonEvaluator->"Local",
  Active->True]


closeButton[] := ButtonBox[
  $Resource["Cancel"],
  ButtonFunction:>FrontEndExecute[NotebookClose[ButtonNotebook[]]],
  ButtonEvaluator->None,
  Active->True]


okButton[nb_] := ButtonBox[
  $Resource["OK"],
  Active->True,
  ButtonEvaluator->"Local",
  ButtonFunction:>FrontEnd`MessagesToConsole[
    setHeaderOptions[ButtonNotebook[], nb];
    NotebookClose[ButtonNotebook[]] ]]


applyButton[nb_] := ButtonBox[
  $Resource["Apply"],
  Active->True,
  ButtonEvaluator->"Local",
  ButtonFunction:>FrontEnd`MessagesToConsole[
    setHeaderOptions[ButtonNotebook[], nb] ]]










startingPageCell[nb_] :=
Cell[BoxData[FormBox[GridBox[{{
    Cell["Starting Page Number:"],
    InputFieldBox[Dynamic[$h[nb, "StartingPageNumber"]], FieldSize -> {5, 1}]
    }}], TraditionalForm]],
  "Text",
  Active->True,
  CellMargins -> {{25,25},{5,15}},
  FontFamily -> $font
]



facingPagesCell[nb_] :=
Cell[BoxData[FormBox[GridBox[{{
    Cell["Set Facing Pages: "],
    TooltipBox[
      RadioButtonBox[Dynamic[$h[nb, "FacingComposite"]], 1],
      TextData @ "Use the same headers and\nfooters on all pages."
    ],
    grid1[nb],
    TooltipBox[
      RadioButtonBox[Dynamic[$h[nb, "FacingComposite"]], 2],
      TextData @ "Alternate left and right pages when\nprinting, starting on the left."
    ],
    grid12[nb],
    TooltipBox[
      RadioButtonBox[Dynamic[$h[nb, "FacingComposite"]], 3],
      TextData @ "Alternate left and right pages when\nprinting, starting on the right."
    ],
    grid21[nb]
  }}, ColumnSpacings -> {0,0.2,1,0.2,1,0.2}], TraditionalForm]],
  "Text",
  Active->True,
  CellMargins -> {{25,25},{5,5}},
  FontFamily -> $font
]



tempCells[nb_, "Header"] := {
Cell[BoxData[GridBox[{{
    RadioButtonBox[Dynamic[$h[nb, "CurrentHeader"]], "LeftPageLeftHeader"],
    RadioButtonBox[Dynamic[$h[nb, "CurrentHeader"]], "LeftPageCenterHeader"],
    RadioButtonBox[Dynamic[$h[nb, "CurrentHeader"]], "LeftPageRightHeader"],
    "  ",
    RadioButtonBox[Dynamic[$h[nb, "CurrentHeader"]], "RightPageLeftHeader"],
    RadioButtonBox[Dynamic[$h[nb, "CurrentHeader"]], "RightPageCenterHeader"],
    RadioButtonBox[Dynamic[$h[nb, "CurrentHeader"]], "RightPageRightHeader"]}}]],
  "Text",
  CellMargins -> {{25,25},{0,0}},
  TextAlignment -> Center
]
,
Cell[BoxData[FormBox[
  InputFieldBox[Dynamic[$h[nb, $h[nb, "CurrentHeader"]]], FieldSize -> {47, 1}],
  TraditionalForm]],
  "Text",
  CellMargins -> {{25,25},{0,0}},
  TextAlignment -> Center
]
}




pageCell[nb_] :=
Cell[BoxData[FormBox[pageGraphic[nb], TraditionalForm]],
  "Text",
  Active->True,
  TextAlignment -> Center,
  (* CellMargins -> {{25,25},{5,5}} *)
  CellMargins -> {{25, 25}, {0,0}} (* temporary for tempCells[] *)
]




tempCells[nb_, "Footer"] := {
Cell[BoxData[FormBox[
  InputFieldBox[Dynamic[$h[nb, $h[nb, "CurrentFooter"]]], FieldSize -> {47, 1}],
  TraditionalForm]],
  "Text",
  CellMargins -> {{25,25},{0,0}},
  TextAlignment -> Center
]
,
Cell[BoxData[GridBox[{{
    RadioButtonBox[Dynamic[$h[nb, "CurrentFooter"]], "LeftPageLeftFooter"],
    RadioButtonBox[Dynamic[$h[nb, "CurrentFooter"]], "LeftPageCenterFooter"],
    RadioButtonBox[Dynamic[$h[nb, "CurrentFooter"]], "LeftPageRightFooter"],
    "  ",
    RadioButtonBox[Dynamic[$h[nb, "CurrentFooter"]], "RightPageLeftFooter"],
    RadioButtonBox[Dynamic[$h[nb, "CurrentFooter"]], "RightPageCenterFooter"],
    RadioButtonBox[Dynamic[$h[nb, "CurrentFooter"]], "RightPageRightFooter"]}}]],
  "Text",
  CellMargins -> {{25,25},{0,0}},
  TextAlignment -> Center
]
}




firstPageCell[nb_] :=
Cell[BoxData[FormBox[GridBox[{{GridBox[{{
    CheckboxBox[Dynamic[$h[nb, "FirstPageHeader"]]],
    Cell["Print Header on First Page"]}, {
    CheckboxBox[Dynamic[$h[nb, "FirstPageFooter"]]],
    Cell["Print Footer on First Page"]}}]
    ,
    insertSpecialButton[]}}, ColumnWidths -> 0.5], TraditionalForm]],
  "Text",
  FontFamily -> $font,
  Active->True,
  CellMargins -> {{25,25},{5,5}}
]






okCell[nb_] :=
Cell[BoxData[FormBox[GridBox[{
          {closeButton[],
          "",
          applyButton[nb],
          okButton[nb]}
        }, ColumnWidths->{0.25}], TraditionalForm]],
  "Text",
  CellMargins -> {{25,0},{0,25}},
  TextAlignment->Right,
  FontFamily->$font,
  ButtonBoxOptions->{
    ButtonFrame -> "DialogBox"}
]








pageLabel[str_] := 
 Cell[BoxData[str], FontFamily -> $font, FontSize -> 18, FontColor -> RGBColor[0.02, 0.7, 0.96]]

pageGraphic[nb_] :=
Block[{},
  
  (* DynamicBox @ ToBoxes[#,StandardForm]& @ Graphics[]  --- crashes?? *)

  Graphics[{
    {
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "LeftPageLeftHeader"]], {0.5, 10.5}, {Left, Center}],
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "LeftPageCenterHeader"]], {4.25, 10.5}, {Center, Center}],
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "LeftPageRightHeader"]], {8, 10.5}, {Right, Center}],
     
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "RightPageLeftHeader"]], {10, 10.5}, {Left, Center}],
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "RightPageCenterHeader"]], {13.75, 10.5}, {Center, Center}],
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "RightPageRightHeader"]], {17.5, 10.5}, {Right, Center}]
     },
    {
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "LeftPageLeftFooter"]], {0.5, 0.5}, {Left, Center}],
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "LeftPageCenterFooter"]], {4.25, 0.5}, {Center, Center}],
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "LeftPageRightFooter"]], {8, 0.5}, {Right, Center}],
     
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "RightPageLeftFooter"]], {10, 0.5}, {Left, Center}],
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "RightPageCenterFooter"]], {13.75, 0.5}, {Center, Center}],
     Inset[BoxData @ simplifyCell2[nb, $h[nb, "RightPageRightFooter"]], {17.5, 0.5}, {Right, Center}]
     },
    {EdgeForm[GrayLevel[0]], FaceForm[Opacity[0]],
     Polygon[{{0, 0}, {8.5, 0}, {8.5, 11}, {0, 11}}],
     Polygon[({9.5, 0} + #) & /@ {{0, 0}, {8.5, 0}, {8.5, 11}, {0, 11}}]},
    {
     Text[pageLabel["Left Page"], {4.25, 6.5}, {0, 0}],
     Text[pageLabel["Right Page"], {13.75, 6.5}, {0, 0}]
     },
    {
     Inset[BoxData @ TooltipBox[CheckboxBox @ Dynamic[$h[nb,"LeftPageFooterLine"]], TextData @ "Include footer line\non left pages."], {0.5, 1}, {Left,Bottom}],
     Inset[BoxData @ TooltipBox[CheckboxBox @ Dynamic[$h[nb,"RightPageFooterLine"]], TextData @ "Include footer line\non right pages."], {10, 1}, {Left,Bottom}],
     Inset[BoxData @ TooltipBox[CheckboxBox @ Dynamic[$h[nb,"LeftPageHeaderLine"]], TextData @ "Include header line\non left pages."], {0.5, 10}, {Left,Top}],
     Inset[BoxData @ TooltipBox[CheckboxBox @ Dynamic[$h[nb,"RightPageHeaderLine"]], TextData @ "Include header line\non right pages."], {10, 10}, {Left,Top}],
     
     GrayLevel[Dynamic[If[$h[nb, "LeftPageFooterLine"], 0, 1, 1]]], Line[{{0.5, 1}, {8, 1}}],
     GrayLevel[Dynamic[If[$h[nb, "RightPageFooterLine"], 0, 1, 1]]], Line[{{10, 1}, {17.5, 1}}],
     GrayLevel[Dynamic[If[$h[nb, "LeftPageHeaderLine"], 0, 1, 1]]], Line[{{0.5, 10}, {8, 10}}],
     GrayLevel[Dynamic[If[$h[nb, "RightPageHeaderLine"], 0, 1, 1]]], Line[{{10, 10}, {17.5, 10}}]
     },
    {
     FaceForm[Opacity[0.2]],
     Polygon[{{0, 12}, {18, 12}, {Dynamic[polyc[$h[nb,"CurrentHeader"]] + 1.4], 11}, {Dynamic[polyc[$h[nb,"CurrentHeader"]] + 1.4], 10}, {Dynamic[polyc[$h[nb,"CurrentHeader"]] - 1.4], 10}, {Dynamic[polyc[$h[nb,"CurrentHeader"]] - 1.4], 11}}],
     Polygon[{{0, -1}, {18, -1}, {Dynamic[polyc[$h[nb,"CurrentFooter"]] + 1.4], 0}, {Dynamic[polyc[$h[nb,"CurrentFooter"]] + 1.4], 1}, {Dynamic[polyc[$h[nb,"CurrentFooter"]] - 1.4], 1}, {Dynamic[polyc[$h[nb,"CurrentFooter"]] - 1.4], 0}}]
    },
    
    (* commented out while tempCells[] are in place *)
    (*
    {
     Inset[BoxData[
        InputFieldBox[Part[{h1, h2, h3, h4, h5, h6}, i], 
         FieldSize -> {{25, 20}, {1, 1}}]], {9, 12}, {Center, Bottom}],
     Inset[BoxData[
        InputFieldBox[Part[{f1, f2, f3, f4, f5, f6}, j], 
         FieldSize -> {{25, 20}, {1, 1}}]], {9, -1}, {Center, Top}]
     }
     *)
     {}
    },
    (* PlotRange -> {{-0.1, 18.1}, {-3.1, 14.1}}, *)
    PlotRange -> {{-0.1, 18.1}, {-1.1, 12.1}}, (* temporary for tempCells[] *)
    AspectRatio -> Automatic]
  ]


polyc["LeftPageLeftHeader" | "LeftPageLeftFooter" | 1] = 1.4;
polyc["LeftPageCenterHeader" | "LeftPageCenterFooter" | 2] = 8.5/2;
polyc["LeftPageRightHeader" | "LeftPageRightFooter" | 3] = 8.5-1.4;

polyc["RightPageLeftHeader" | "RightPageLeftFooter" | 4] = polyc[1] + 9.5;
polyc["RightPageCenterHeader" | "RightPageCenterFooter" | 5] = polyc[2] + 9.5;
polyc["RightPageRightHeader" | "RightPageRightFooter" | 6] = polyc[3] + 9.5;

polyc[___] = 9;




(* simplifyCell is so severe, for now, because of Inset limitations. *)


simplifyCell[nb_, sym_Symbol] := BoxData[ToString[sym]]
 
simplifyCell[nb_, Cell[str_String, opts___]] := simplifyCell[nb, Cell[TextData[{str}], opts]]

simplifyCell[nb_, Cell[TextData[args___], opts___]] := simplifyCell[nb, BoxData[RowBox @ Flatten @ {args}]]

simplifyCell[nb_, Cell[BoxData[args___], opts___]] := simplifyCell[nb, BoxData[RowBox @ Flatten @ {args}]]

(* Make counters and values display as if they were in the target notebook: *)
simplifyCell[nb_, BoxData[a_,___]] := BoxData[a] //. {
  CounterBox[x_] :> CounterBox[x, {NotebookFilePath[nb], None}],
  CounterBox[x_, y_String] :> CounterBox[x, {NotebookFilePath[nb], y}],
  ValueBox[x_] :> ValueBox[x, {NotebookFilePath[nb], None}],
  ValueBox[x_, y_String] :> ValueBox[x, {NotebookFilePath[nb], y}]
}

simplifyCell[nb_, args___] := BoxData[StyleBox[StringJoin[ToString /@ {args}], FontSize->8]]




simplifyCell2[nb_, expr_] := First[ simplifyCell[nb, expr] ] (* drop the BoxData wrapper *)


































headerDialog[nb_] :=
Notebook[Flatten @ {
    startingPageCell[nb],
    facingPagesCell[nb],
    tempCells[nb, "Header"], (* temporary shim *)
    pageCell[nb],
    tempCells[nb, "Footer"], (* temporary shim *)
    firstPageCell[nb],
    okCell[nb]},
  StyleDefinitions -> "Default.nb",
  WindowToolbars->{},
  WindowTitle->$h[nb, "WindowTitle"],
  PageWidth->WindowWidth,
  Sequence @@ $userOptions,
  WindowElements->{},
  ScrollingOptions -> {"VerticalScrollRange" -> Fit},
  Saveable -> False,
  ShowCellBracket->False,
  ShowCellLabel->False,
  ShowCellTags->False,
  ImageMargins->{{0, Inherited}, {Inherited, 0}}
]


$userOptions = {
WindowSize->{425, FitAll},
WindowMargins->{{Automatic, 131}, {Automatic, 0}},
Magnification->1
};



NotebookHeadersDialog[] := NotebookHeadersDialog[InputNotebook[]];

NotebookHeadersDialog[nbFile_String, args___] :=
  NotebookHeadersDialog[NotebookOpen[nbFile], args] /; FileType[nbFile] === File;

NotebookHeadersDialog[nb_NotebookObject, opts___] :=
(
  If[Not @ MemberQ[Notebooks[], nb], Return @ $Failed];
  If[Not @ MemberQ[Notebooks[], $NotebookHeadersDialog @ nb],
    initializeHeaderVariables[nb];
    $NotebookHeadersDialog[nb] = NotebookPut @ headerDialog[nb]
    ,
    SetSelectedNotebook @ $NotebookHeadersDialog[nb]
  ]
)


NotebookHeadersDialog[___] :=
MessageDialog[$Resource["Printing", "no nb"]] /;
  ButtonNotebook[] =!= $Failed



initializeHeaderVariables[nb_NotebookObject] :=
Block[{opts, opts2, info},
  opts = Options[nb, {PageHeaders, PageFooters, PrintingStartingPageNumber,
    PageHeaderLines, PageFooterLines}];
  opts2 = PrintingOptions /. Options[nb, PrintingOptions];
  info = NotebookInformation[nb];
  
  
  (* because of Evaluate's below, we need to a little careful *)
  DownValues[$h] = DeleteCases[DownValues[$h],
    _[HoldPattern[HoldPattern][$h[nb,_]], _]
  ];
  
  $h[nb, "WindowTitle"] = "Headers and Footers for " <> NotebookName[nb];
  Evaluate[Map[$h[nb,#]&, {
    {"LeftPageLeftHeader","LeftPageCenterHeader","LeftPageRightHeader"},
    {"RightPageLeftHeader", "RightPageCenterHeader", "RightPageRightHeader"}}, {2}]] =
    PageHeaders /. opts;
  
  Evaluate[Map[$h[nb,#]&, {
    {"LeftPageLeftFooter","LeftPageCenterFooter","LeftPageRightFooter"},
    {"RightPageLeftFooter", "RightPageCenterFooter", "RightPageRightFooter"}}, {2}]] =
    PageFooters /. opts;
  
  $h[nb, "StartingPageNumber"] = PrintingStartingPageNumber /. opts;
  
  Evaluate[Map[$h[nb, #]&, {"LeftPageHeaderLine", "RightPageHeaderLine"}]] = PageHeaderLines /. opts;
  Evaluate[Map[$h[nb, #]&, {"LeftPageFooterLine", "RightPageFooterLine"}]] = PageFooterLines /. opts;
  
  Evaluate[Map[$h[nb, #]&, {"FirstPageHeader", "FirstPageFooter", "FacingPages", "FirstPageFace"}]] =
    {"FirstPageHeader", "FirstPageFooter", "FacingPages", "FirstPageFace"} /. opts2;
  
  $h[nb, "FacingComposite"] = Switch[$h[nb,#]& /@ {"FacingPages", "FirstPageFace"},
    {True, "Left" | Left}, 2,
    {True, "Right" | Right}, 3,
    _, 1
  ];
  
  
  $h[nb, "CurrentHeader"] = "RightPageLeftHeader";
  $h[nb, "CurrentFooter"] = "RightPageLeftFooter";
]
  








fixHeaders[{{a_,b_,c_},{d_,e_,f_}}] := 
  {{a,b,c},{d,e,f}} //. {
    Cell["" | _[""] | _[_[""]], ___] :> None,
    Cell["Inherited" | _["Inherited"] | _[_["Inherited"]], ___] :> Inherited,
    Cell["Automatic" | _["Automatic"] | _[_["Automatic"]], ___] :> Automatic,
    Cell["None" | _["None"] | _[_["None"]], ___] :> None,
        
    _[CellFrame | CellMargins | Background | GeneratedCell | 
      CellAutoOverwrite | CellTags ,_] :> Sequence[]}

fixHeaders[{{a_,b_,c_}}] := fixHeaders[{{a,b,c},{a,b,c}}];



fixLines[a_Symbol] := {a, a};
fixLines[a_String] := {a, a};
fixLines[{a_}] := {a, a};
fixLines[{a_, b_}] := {a, b};




setHeaderOptions[bnb_, nb_] :=
Block[{},
  $userOptions = Options[bnb, {WindowSize, WindowMargins, Magnification}];
  
  SetOptions[nb,
    PageHeaders -> Map[$h[nb,#]&, {
      {"LeftPageLeftHeader","LeftPageCenterHeader","LeftPageRightHeader"},
      {"RightPageLeftHeader", "RightPageCenterHeader", "RightPageRightHeader"}}, {2}],
    PageFooters -> Map[$h[nb,#]&, {
      {"LeftPageLeftFooter","LeftPageCenterFooter","LeftPageRightFooter"},
      {"RightPageLeftFooter", "RightPageCenterFooter", "RightPageRightFooter"}}, {2}],
    PrintingStartingPageNumber -> $h[nb, "StartingPageNumber"],
    PageHeaderLines -> Map[$h[nb,#]&, {"LeftPageHeaderLine", "RightPageHeaderLine"}],
    PageFooterLines -> Map[$h[nb,#]&, {"LeftPageFooterLine", "RightPageFooterLine"}]
  ];
  
  Switch[$h[nb, "FacingComposite"],
    2 | "2",
    $h[nb, "FacingPages"] = True;
    $h[nb, "FirstPageFace"] = "Left";
    ,
    3 | "3",
    $h[nb, "FacingPages"] = True;
    $h[nb, "FirstPageFace"] = "Right";
    ,
    1 | "1" | _,
    $h[nb, "FacingPages"] = False
  ];
  
  SetOptions[nb, PrintingOptions -> Map[(# -> $h[nb, #])&,
    {"FirstPageHeader", "FirstPageFooter", "FacingPages", "FirstPageFace"}]
  ];
]





End[]

EndPackage[]
