(* ::Package:: *)

(* :Title: Master Declarations File for Calculus *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 11 December 2004 at 21:09 *)

Message[General::obspkg,"Calculus`"];

If[! MemberQ[$Packages, "Calculus`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "Calculus`"];
     Protect @@ System`Private`p
];

(* Declarations for package Calculus`DSolveIntegrals` *)

DeclarePackage["Calculus`DSolveIntegrals`",
     {"B", "CompleteIntegral", "IntegralConstants"}]


(* Declarations for package Calculus`FourierTransform` *)

DeclarePackage["Calculus`FourierTransform`",
     {"DTFourierTransform", "FourierCoefficient", "FourierCosCoefficient", 
      "FourierCosSeriesCoefficient", "FourierExpSeries", 
      "FourierExpSeriesCoefficient", "FourierFrequencyConstant", 
      "FourierOverallConstant", "FourierSample", "FourierSeries", 
      "FourierSinCoefficient", "FourierSinSeriesCoefficient", 
      "FourierTrigSeries", "InverseDTFourierTransform", 
      "InverseFourierCoefficient", "NDTFourierTransform", 
      "NFourierCoefficient", "NFourierCosCoefficient", 
      "NFourierCosSeriesCoefficient", "NFourierCosTransform", 
      "NFourierExpSeries", "NFourierExpSeriesCoefficient", "NFourierSeries", 
      "NFourierSinCoefficient", "NFourierSinSeriesCoefficient", 
      "NFourierSinTransform", "NFourierTransform", "NFourierTrigSeries", 
      "NInverseDTFourierTransform", "NInverseFourierCoefficient", 
      "NInverseFourierCosTransform", "NInverseFourierSinTransform", 
      "NInverseFourierTransform", "$FourierFrequencyConstant", 
      "$FourierOverallConstant"}]


(* Declarations for package Calculus`Pade` *)

DeclarePackage["Calculus`Pade`",{"EconomizedRationalApproximation", "Pade"}]


(* Declarations for package Calculus`VariationalMethods` *)

DeclarePackage["Calculus`VariationalMethods`",
     {"EulerEquations", "FirstIntegral", "FirstIntegrals", "NVariationalBound", 
      "VariationalBound", "VariationalD"}]


(* Declarations for package Calculus`VectorAnalysis` *)

DeclarePackage["Calculus`VectorAnalysis`",
     {"ArcLengthFactor", "Biharmonic", "Bipolar", "Bispherical", "Cartesian", 
      "ConfocalEllipsoidal", "ConfocalParaboloidal", "Conical", 
      "CoordinateRanges", "Coordinates", "CoordinatesFromCartesian", 
      "CoordinatesToCartesian", "CoordinateSystem", "CrossProduct", "Curl", 
      "Cylindrical", "Div", "DotProduct", "Eeta", "EllipticCylindrical", 
      "Grad", "JacobianDeterminant", "JacobianMatrix", "Laplacian", "Llambda", 
      "Mmu", "Nnu", "OblateSpheroidal", "ParabolicCylindrical", "Paraboloidal", 
      "ParameterRanges", "Parameters", "Pphi", "ProlateSpheroidal", "Rr", 
      "ScalarTripleProduct", "ScaleFactors", "SetCoordinates", "Spherical",
      "Toroidal", "Ttheta", "Uu", "Vv", "Xx", "Xxi", "Yy", "Zz"}]


(* End of Master package *)

Null

