(* ::Package:: *)

(* :Name: DiscreteMath`CombinatorialFunctions` *)

(* :Context: DiscreteMath`CombinatorialFunctions` *)

(* :Author: Wolfram Research, Inc. *)

(* :Mathematica Version: 3.0 *)

(* :Package Version: 1.2 *)

(* :Copyright: Copyright 1988-2007, Wolfram Research, Inc. *)

(* :History:
    Version 1.0, 1988, Wolfram Research, Inc.
    Version 1.2, May 1999, by John M. Novak -- added Listable attribute
        to the functions in the package
*)

(* :Summary:
This package defines the functions Hofstadter and Subfactorial,
used commonly in combinatorial analysis.
*)

(* :Warning:
For Mathematica V2.2 and earlier, Fibonacci[n] was a package function.
For V3.0, Fibonacci[n] is a kernel function and gives what the package
function Fibonacci[n-1] used to give.
*)

		(** Combinatorial functions **)

Message[General::obspkg, "DiscreteMath`CombinatorialFunctions`"]

BeginPackage["DiscreteMath`CombinatorialFunctions`"]

(* Subfactorials *)

(*
Subfactorial::usage =
	"Subfactorial[n] gives the number of permutations of n objects \
which leave no object fixed."
*)

(* Catalan numbers: definition in Combinatorica.m commented out so that
	there is no symbol shadowing when all DiscreteMath packages are
	read in *)
(*
CatalanNumber::usage =
	"CatalanNumber[n] gives the nth Catalan number."
*)
(* Hofstadter's function *)

Hofstadter::usage =
	"Hofstadter[n] gives Hofstadter's function for positive integer n."

Begin["`Private`"]

issueObsoleteFunMessage[fun_, context_] :=
        (Message[fun::obspkgfn, fun, context];
         )

(*
Attributes[Subfactorial] = {Listable};

Subfactorial[n_Integer?NonNegative] := 
	n! Sum[(-1)^k/k!, {k, 0, n}]

Attributes[CatalanNumber] = {Listable};

CatalanNumber[n_Integer] := Binomial[2n,n]/(n+1)
*)

Attributes[Hofstadter] = {Listable};

Hofstadter[n_Integer?Positive] :=
       (issueObsoleteFunMessage[Hofstadter,  "DiscreteMath`CombinatorialFunctions`"];
	Hofstadter[n] =
	Hofstadter[n - Hofstadter[n-1]] + Hofstadter[n - Hofstadter[n-2]])

Hofstadter[1] = Hofstadter[2] = 1

End[ ]
EndPackage[ ]
