(* ::Package:: *)

(* :Copyright: Copyright 1989-2007, Wolfram Research, Inc. *)

(* :Mathematica Version: 6.0 *)

(* :Title: Control Functions for Animation *)

(* :Author: R. Maeder, after a version by Theodore Gray and David Ballman *)

(* :Keywords: Animation, Movie, Animate *)

(* :Summary:
This package is obsolete in V6.
*)


Message[General::obspkg, "Graphics`Animation`"]
Quiet[
BeginPackage["Graphics`Animation`",
             {"Utilities`FilterOptions`", "Geometry`Rotations`"}]
, {General::obspkg, General::newpkg}]


ShowAnimation::usage = "ShowAnimation[{g,h,...}, options...] is an \
obsolete function to produce an animation from a sequence of graphics objects. \
Use ListAnimate instead."

ShowAnimation = ListAnimate;

MoviePlot::usage = "MoviePlot[f[x,t], {x,x0,x1}, {t,t0,t1}, options...] will \
animate plots of f[x,t] regarded as a function of x, with t serving as \
the animation (or time) variable."

MoviePlot3D::usage = "MoviePlot3D[f[x,y,t], {x,x0,x1}, {y,y0,y1}, {t,t0,t1}, \
options...] will animate x,y-plots of the given function by varying t."

MovieDensityPlot::usage = "MovieDensityPlot[f[x,y,t], {x,x0,x1}, {y,y0,y1}, \
{t,t0,t1}, options...] will animate x,y-density-plots of the given \
function by varying t."

MovieContourPlot::usage = "MovieContourPlot[f[x,y,t], {x,x0,x1}, {y,y0,y1}, \
{t,t0,t1}, options...] will animate x,y-contour-plots of the given \
function by varying t."

MovieParametricPlot::usage = "MovieParametricPlot[{f[x,t],g{x,t}}, {x,x0,x1}, \
{t,t0,t1}, options...] will animate parametric curve plots of the given \
function by varying t."

SpinShow::usage = "SpinShow[graphics, opts...] \
will animate a three-dimensional graphics object by rotating it."

SpinOrigin::usage = "SpinOrigin is an option of SpinShow which is used \
with SpinDistance to determine the ViewPoint of each frame."
	
SpinDistance::usage = "SpinDistance is an option of SpinShow which is used \
with SpinOrigin to determine the ViewPoint of each frame."

SpinTilt::usage = "SpinTilt is an option of SpinShow which specifies \
Euler angles to give a tilt to the rotation."

SpinRange::usage = "SpinRange is an option of SpinShow which specifies \
the range over which the first Euler angle is varied. A third value \
can be given indicating a step size."

RotateLights::usage = "RotateLights is an option of SpinShow which specifies \
whether the light sources should rotate with the object."

Frames::usage = "Frames is an obsolete option of Animate that is not used \
any longer."

Closed::usage = "Closed is an obsolete option of Animate that is not used \
any longer."

Unprotect[ShowAnimation, MoviePlot, MoviePlot3D,
	MovieDensityPlot, MovieContourPlot, MovieParametricPlot, SpinShow,
	Frames, Closed, SpinOrigin,
	SpinTilt, SpinDistance, SpinRange, RotateLights]

Options[SpinShow] = Sort[Options[Animate] ~Join~ {
	SpinOrigin -> {0,0,1.5},
	SpinTilt -> {0,0},
	SpinDistance -> 2,
	SpinRange -> {0 Degree, 360 Degree},
	RotateLights -> False
	}]

Begin["`Private`"]

issueObsoleteFunMessage[fun_, context_] := Message[General::obspkgfn, fun, context];

(* the following borrow their options from Animate *)

Attributes[MoviePlot] = {HoldFirst};
MoviePlot[ function_, xRange_List, animationRange_List, opts___?OptionQ ] := 
	(issueObsoleteFunMessage[MoviePlot,"Graphics`Animation`"];
	Animate[ Plot[function, xRange, DisplayFunction->Identity,
	            Evaluate[FilterOptions[Plot, opts]]], 
	       animationRange, Evaluate[FilterOptions[Animate, opts]] ]);

Attributes[MoviePlot3D] = {HoldFirst};
MoviePlot3D[ function_, xRange_List, yRange_List, animationRange_List, opts___?OptionQ ] := 
	(issueObsoleteFunMessage[MoviePlot3D,"Graphics`Animation`"];
	Animate[ Plot3D[function, xRange, yRange, DisplayFunction->Identity,
	            Evaluate[FilterOptions[Plot3D, opts]]], 
	       animationRange, Evaluate[FilterOptions[Animate, opts]] ]);

Attributes[MovieDensityPlot] = {HoldFirst};
MovieDensityPlot[function_, xRange_List, yRange_List, animationRange_List, opts___?OptionQ ] :=
	(issueObsoleteFunMessage[MovieDensityPlot,"Graphics`Animation`"];
	Animate[ DensityPlot[function, xRange, yRange, DisplayFunction->Identity,
	            Evaluate[FilterOptions[DensityPlot, opts]]], 
	       animationRange, Evaluate[FilterOptions[Animate, opts]] ]);

Attributes[MovieContourPlot] = {HoldFirst};
MovieContourPlot[ function_, xRange_List, yRange_List, animationRange_List, opts___?OptionQ ] := 
	(issueObsoleteFunMessage[MovieContourPlot,"Graphics`Animation`"];
	Animate[ ContourPlot[function, xRange, yRange, DisplayFunction->Identity,
	            Evaluate[FilterOptions[ContourPlot, opts]]], 
	       animationRange, Evaluate[FilterOptions[Animate, opts]] ]);

Attributes[MovieParametricPlot] = {HoldFirst};
MovieParametricPlot[ function_, xRange_List, animationRange_List, opts___?OptionQ ] := 
	(issueObsoleteFunMessage[MovieParametricPlot,"Graphics`Animation`"];
	Animate[ ParametricPlot[function, xRange, DisplayFunction->Identity,
	            Evaluate[FilterOptions[ParametricPlot, opts]]], 
	       animationRange, Evaluate[FilterOptions[Animate, opts]] ]);

SpinShow[theGraphic_, options___?OptionQ] :=
    (issueObsoleteFunMessage[SpinShow,"Graphics`Animation`"];
	Module[{spinOrigin, spinTilt, spinDistance, spinRange, rotateLights,
            closed, frames, lightSources, thetaFactor, phiFactor,
            rhoFactor, theta},
       (* handle the options *)
        {spinOrigin, spinTilt, spinDistance, spinRange, rotateLights} =
           {SpinOrigin, SpinTilt, SpinDistance, SpinRange, RotateLights}/.
            Flatten[{options, Options[SpinShow]}];
        lightSources = Lighting /.
            Flatten[{Options[theGraphic], Options[Head[theGraphic]]}];
        If[TrueQ[rotateLights] && (lightSources === True || lightSources === Automatic),
            lightSources = {RGBColor[0.45, 0.3, 0.6],
             {RGBColor[0.9, 0.05, 0.05], ImageScaled[{2.0, 0., 2.0}]},
             {RGBColor[0.05, 0.9, 0.05], ImageScaled[{2.0, 2.0, 2.0}] },
             {RGBColor[0.05, 0.05, 0.9], ImageScaled[{0., 2.0, 2.0}]},
             {RGBColor[0.9, 0.7, 0.9], ImageScaled[{-2.0, -2.0, -2.0}]}}
        ];
        If[lightSources === True, lightSources = Automatic]; (* kludge *)
      (* handle the angles *)
        thetaFactor = Switch[rotateLights,  False, 0, 
	                                    True, 1,
	                                    Opposite, -1,
	                                    _, 0];
	    phiFactor = If[rotateLights, 1, 0, 0];
	    rhoFactor = If[rotateLights, 1, 0, 0];
	  (* do the animation *)
	    Animate[ Show[theGraphic,
		    ViewPoint->(spinOrigin +
		     spinDistance Rotate3D[{1,0,0}, theta, spinTilt[[1]], spinTilt[[2]]]),
		    Lighting -> (lightSources/.vec:{_?NumericQ, _?NumericQ, _?NumericQ} :> 
                                Rotate3D[vec, 
			         thetaFactor theta,
				 phiFactor spinTilt[[1]],
				 rhoFactor spinTilt[[2]]]), 
	            FilterOptions[Head[theGraphic], options],
	            SphericalRegion -> True],
	       Evaluate[Prepend[spinRange, theta]],
	       Evaluate[FilterOptions[Animate, options]]
	    ]
	])

End[]   (* Graphics`Animation`Private` *)

Protect[Evaluate[Context[] <> "*"]]

EndPackage[]   (* Graphics`Animation` *)

(*:Examples:
MoviePlot[ Sin[x t], {x,-5,5}, {t,0,1}, PlotRange->{-1, 1} ]

MoviePlot3D[ Sin[ x y t], {x,-2,2}, {y,-2,2}, {t,0,1},
    PlotRange->{-1, 1}, Frames->24]

MovieParametricPlot[ {Sin[x t], Cos[x t]}, {x, -Pi, Pi}, {t, 0, 1, 1/11},
	PlotRange->{{-1, 1}, {-1, 1}}, AspectRatio->1 ]

graphics = Plot3D[ Sin[x y],{x,-2,2},{y,-2,2}, Axes->None, Boxed->False];
SpinShow[ graphics ]

*)
