(* ::Package:: *)

(*:Copyright: Copyright 1991-2007, Wolfram Research, Inc. *)

(*:Mathematica Version: 3.0 *)

(*:Title:  ArgColors  *)

(*:Author: R. Maeder *)

(*:Keywords: Arg, Hue, GrayLevel *)

(*:Summary:
This package provides functions for specifying the color or
gray level of graphics elements using the argument of a complex
number.
*)

(*:Sources: 
        Adapted from
        Roman E. Maeder: Programming in Mathematica,
        Third Edition, Addison-Wesley, 1996.
*)


Message[General::obspkg, "Graphics`ArgColors`"]
BeginPackage["Graphics`ArgColors`"]


Unprotect[ArgColor, ArgShade, ColorCircle]

ArgColor::usage = 
"ArgColor[z] gives a color value whose hue is proportional \
to the argument of the complex number z."

ArgShade::usage = 
"ArgShade[z] gives a gray level proportional \
to the argument of the complex number z."

ColorCircle::usage = 
"ColorCircle[r, (light:1)] gives a color value whose hue \
is proportional to r (mod 2Pi) with lightness light."

Begin["`Private`"]

issueObsoleteFunMessage[fun_, context_] := Message[General::obspkgfn, fun, context];

ArgColor[z_] /; z == 0.0 := (issueObsoleteFunMessage[ArgColor,"Graphics`ArgColors`"];
	Hue[0, 0, 1])
ArgColor[z_?NumericQ] := (issueObsoleteFunMessage[ArgColor,"Graphics`ArgColors`"];
	ColorCircle[ Arg[z] ])

ArgShade[z_] /; z == 0.0 := (issueObsoleteFunMessage[ArgShade,"Graphics`ArgColors`"];
	GrayLevel[1])
ArgShade[z_?NumericQ] := (issueObsoleteFunMessage[ArgShade,"Graphics`ArgColors`"];
	GrayLevel[ N[(Pi + Arg[z])/(2Pi)] ])

ColorCircle[r_?NumericQ, light_:1] := (issueObsoleteFunMessage[ColorCircle,"Graphics`ArgColors`"];
	Hue[ N[r/(2Pi)], 1, light ])

End[]

Protect[ArgColor, ArgShade, ColorCircle]

EndPackage[]
