(* ::Package:: *)

(* :Title: Filled Plot *)

(* :Context: Graphics`FilledPlot` *)

(* :Author: John M. Novak *)

(* :Summary: 
This package is obsolete, replaced by the Filling and FillingStyle
options to Plot and ListLinePlot.
*)

(* :Package Version: 3.0 *)

(* :Mathematica Version: 6.0 *)

(* :History:
	V1.0 by John M. Novak, May 1991.
	V2.0 by John M. Novak, April 1994.
	V2.0.1 by John M. Novak, February 1997, bug fix for DisplayString. 
    V2.0.2 by John M. Novak, January 1998, bug fix for Background->None.
    V3.0 by John M. Novak, October 2005, obsoleting for V6.
*)

(* :Copyright: Copyright 1991-2007, Wolfram Research, Inc.*)

Message[General::obspkg, "Graphics`FilledPlot`"]
Quiet[
BeginPackage["Graphics`FilledPlot`",
	"Utilities`FilterOptions`"]
, {General::obspkg, General::newpkg}]


FilledPlot::usage =
"FilledPlot[function,{var,varmin,varmax}] is an obsolete \
function to generate a plot with the area between the curve \
and the var axis filled, superseded by the Filling option \
to Plot.";

FilledListPlot::usage =
"FilledListPlot[data] is an obsolete function to generate \
a plot with the area between the x axis and the curve given by the data \
filled, superseded by the Filling option to ListLinePlot.";

Fills::usage =
"Fills is an option to the obsolete function FilledPlot. Use \
the Filling option to Plot or ListLinePlot instead.";

Curves::usage =
"Curves is an option to the obsolete function FilledPlot.";

(* Front, Back, and Axis are system syms now; don't override the
   usage messages. *)
   
AxesFront::usage =
"AxesFront is an obsolete option. Use the Method -> {\"AxesInFront\" -> True} \
option to Graphics instead.";
AxesFront/: Rule[AxesFront, t_] := Method -> {"AxesInFront" -> t}

(* Backwards compatibility *)
ListFilledPlot::usage =
"ListFilledPlot is the old name for the obsolete function FilledListPlot."

ListFilledPlot = FilledListPlot;

Begin["`Private`"]

issueObsoleteFunMessage[fun_, context_] := Message[General::obspkgfn, fun, context];

(* numberQ utility *)
numberQ[n_] := NumberQ[N[n]]

(* Curves option takes None, Front, or Back. *)

Options[FilledPlot] = Join[{
		Fills->Automatic,
		Curves->Back},
	(*	AxesFront -> True}, *)
	Options[Plot]];

FilledPlot::badfill =
"The Fills option has been given an incorrect form: `1`.";

FilledPlot::badcurv =
"The Curves option has been given bad value `1`; using \
'Back' in its place.";

(* Design Note: The following implementation is not robust, as it
   depends heavily on the structure of Plot. Plot is required to
   generate an adaptively-sampled curve; if this can be replaced at
   some point by a non-graphics function that does adaptive sampling,
   that would be ideal. The possibility of generating each plot separately
   isn't being used, becaue I think there may be some use in the variations
   of the adaptive sampling algorithm when handling multiple curves simultaneously.
   --JMN 05.06.04 *)
FilledPlot[funcs_List,{x_?(!NumericQ[#]&),xmin_,xmax_},opts___] :=
	(issueObsoleteFunMessage[FilledPlot,"Graphics`FilledPlot`"];
	Module[{ln = Length[funcs], fills, curve, ps, df},
		{fills, curve, ps, df} = {Fills, Curves, PlotStyle, DisplayFunction}/.
			Flatten[{opts,Options[FilledPlot]}];
		curve = checkcurve[curve, FilledPlot];
        fills = checkfills[fills, ln, FilledPlot];
        If[curve === Back,
            ps = CycleValues[ps, ln];
            Show[Map[With[{f = If[#[[2,1]] === Axis, 
                                       funcs[[#[[1]]]],
                                       funcs[[{#[[1]], #[[2,1,1]]}]]],
                            o = If[#[[2,1]] === Axis,
                                       {1 -> {Axis, #[[2,2]]}},
                                       {1 -> {{2}, #[[2,2]]}}],
                            plotstyle = If[#[[2,1]] === Axis,
                                ps[[#[[1]]]],
                                ps[[{#[[1]], #[[2,1,1]]}]]]},
                     Plot[f, {x, xmin, xmax}, 
                          DisplayFunction -> Identity,
                          Evaluate[PlotStyle -> (plotstyle/.{Automatic..} -> Automatic)],
                          Evaluate[Filling -> o],
                          Evaluate[FilterOptions[Plot, opts]]]]&,
                    fills
            ], DisplayFunction -> df],
            Plot[funcs, {x, xmin, xmax},
                 Evaluate[If[curve === None, PlotStyle -> None, PlotStyle -> ps]],
                 Filling -> fills,
                 Evaluate[FilterOptions[Plot, opts]]
            ]
        ]
	])

FilledPlot[func_,rng_List,opts___] :=
	FilledPlot[{func},rng,opts]

(* FilledListPlot *)
FilledListPlot::badfill =
"The Fills option has been given an incorrect form: `1`.";

FilledListPlot::badcurv =
"The Curves option has been given bad value `1`; using \
'Back' in its place.";

Options[FilledListPlot] = Join[{
	Curves -> Back,
	Fills -> Automatic,
	(* AxesFront -> True, *)
	PlotStyle -> Automatic},
	Options[Graphics]
];

SetOptions[FilledListPlot, Axes -> Automatic, AspectRatio -> 1/GoldenRatio];

FilledListPlot[lists:(({_?numberQ..} | {{_?numberQ, _?numberQ}..})..),
				opts:((_Rule | _RuleDelayed)...)] :=
	(issueObsoleteFunMessage[FilledListPlot,"Graphics`FilledPlot`"];
	Module[{ln = Length[{lists}], fills, curve, ps, df},
		{fills, curve, ps, df} = {Fills, Curves, PlotStyle, DisplayFunction}/.
			Flatten[{opts,Options[FilledPlot]}];
		curve = checkcurve[curve, FilledPlot];
        fills = checkfills[fills, ln, FilledPlot];
        If[curve === Back,
            ps = CycleValues[ps, ln];
            Show[Map[With[{f = If[#[[2,1]] === Axis, 
                                       {lists}[[#[[1]]]],
                                       {lists}[[{#[[1]], #[[2,1,1]]}]]],
                            o = If[#[[2,1]] === Axis,
                                       {1 -> {Axis, #[[2,2]]}},
                                       {1 -> {{2}, #[[2,2]]}}],
                            plotstyle = If[#[[2,1]] === Axis,
                                ps[[#[[1]]]],
                                ps[[{#[[1]], #[[2,1,1]]}]]]},
                     ListLinePlot[f, 
                          DisplayFunction -> Identity,
                          Evaluate[PlotStyle -> (plotstyle/.{Automatic..} -> Automatic)],
                          Evaluate[Filling -> o],
                          FilterOptions[ListLinePlot, opts]]]&,
                    fills
            ], DisplayFunction -> df],
            ListLinePlot[{lists},
                 Evaluate[If[curve === None, PlotStyle -> None, PlotStyle -> ps]],
                 Filling -> fills,
                 FilterOptions[ListLinePlot, opts]
            ]
        ]
	])

(* check form of curve *)
checkcurve[curve_, callingfun_] :=
	If[!MatchQ[curve,(Front | Back | None)],
		Message[callingfun::badcurv,curve];Back,
		curve
	]

(* Checking the form of fills *)
$stylepat = _Hue | _GrayLevel | _RGBColor | _CMYKColor | _Opacity;

checkfills[fills_, ln_, callingfun_] :=
	Module[{fillsout = fills},
		If[MatchQ[fillsout, $stylepat],
			fillsout = {fillsout}];
		If[!MatchQ[fillsout,({{{(_Integer | Axis),(_Integer | Axis)},
				$stylepat | {$stylepat..}}..} |
				{($stylepat | {$stylepat..})..} |
				Automatic)],
			Message[callingfun::badfill,fillsout]; fillsout = Automatic];
		If[MatchQ[fillsout,{($stylepat | {$stylepat..})..}],
			If[Length[fillsout] > ln,
				fillsout = Take[fillsout,ln]];
			part = Partition[Range[1,ln],2,1];
			If[Length[fillsout] === ln,
				PrependTo[part,{1,Axis}]];
			fillsout = Transpose[{part,fillsout}]
		];
		If[fillsout === Automatic,
			If[ln === 1,
				fillsout = {{{1,Axis}, GrayLevel[.5]}},
				fillsout = Transpose[{
					Partition[Range[1,ln],2,1],
					Table[Hue[n/ln],{n,1,ln-1}]}]
			]
		];
        fillsout = (#1[[1]] -> {If[#1[[2]] === Axis, Axis, {#1[[2]]}], Directive @@ Flatten[{#2}]}) & @@@ fillsout;
		fillsout
	]

(* The following is a useful internal utility function to be
used when you have a list of values that need to be cycled to
some length (as PlotStyle works in assigning styles to lines
in a plot).  The list is the list of values to be cycled, the
integer is the number of elements you want in the final list. *)

CycleValues[{},_] := {}

CycleValues[list_List, n_Integer] :=
	Module[{hold = list},
		While[Length[hold] < n,hold = Join[hold,hold]];
		Take[hold,n]
	]

CycleValues[item_,n_] := CycleValues[{item},n]


End[]

EndPackage[]
