(* ::Package:: *)

(* :Title: Master Declarations File for LinearAlgebra *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 11 December 2004 at 21:09 *)

Message[General::obspkg,"LinearAlgebra`"];

If[! MemberQ[$Packages, "LinearAlgebra`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "LinearAlgebra`"];
     Protect @@ System`Private`p
];

(* Declarations for package LinearAlgebra`FourierTrig` *)

DeclarePackage["LinearAlgebra`FourierTrig`",{"FourierCos", "FourierSin"}]


(* Declarations for package LinearAlgebra`GaussianElimination` *)

DeclarePackage["LinearAlgebra`GaussianElimination`",
     {"LU", "LUFactor", "LUSolve"}]


(* Declarations for package LinearAlgebra`MatrixManipulation` *)

DeclarePackage["LinearAlgebra`MatrixManipulation`",
     {"AppendColumns", "AppendRows", "BlockMatrix", "HankelMatrix", 
      "HilbertMatrix", "InsertColumn", "InsertRow", "InverseMatrixNorm", 
      "LinearEquationsToMatrices", "LowerDiagonalMatrix", "LUMatrices", 
      "MatrixConditionNumber", "MatrixNorm", "MatrixPlot", "MatrixPlotScaling", 
      "MaxMatrixSize", "PolarDecomposition", "SquareMatrixQ", "SubMatrix", 
      "TakeColumns", "TakeMatrix", "TakeRows", "TridiagonalMatrix", 
      "UpperDiagonalMatrix", "VectorNorm", "ZeroMatrix"}]


(* Declarations for package LinearAlgebra`Orthogonalization` *)

DeclarePackage["LinearAlgebra`Orthogonalization`",
     {"GramSchmidt", "Householder", "InnerProduct", "Normalize", "Normalized", 
      "Projection"}]


(* Declarations for package LinearAlgebra`Tridiagonal` *)

DeclarePackage["LinearAlgebra`Tridiagonal`",{"TridiagonalSolve"}]


(* End of Master package *)

Null

