(*:Copyright: Copyright 1988-2007 Wolfram Research, Inc. *)

(*:Mathematica Version: 5.0 *)

(*:Package Version: 1.0 *)

(*:Name: NumberTheory`Frobenius` *)

(*:Title: Functions for solving the Frobenius equation and computing
          Frobenius numbers.
*) 

(*:Authors: David Einstein, Daniel Lichtblau, Adam Strzebonski, Stan Wagon *)

(*:Keywords: Frobenius equation, Frobenius number *)

(*:Sources: 
David Einstein, Daniel Lichtblau, Adam Strzebonski, Stan Wagon,
"Frobenius Numbers by Integer-Linear Programming"
Dale Beihoffer, Jemimah  Hendry, Albert Nijenhuis, Stan Wagon,
"Faster algorithms for Frobenius numbers",
Electronic Journal of Combinatorics, 12:1 (2005) R27.
*)

(*:Summary:
The Frobenius equation has the from a1 x1+...+an xn==b, where a1, ..., an
are positive integers, b is an integer, and the solutions {x1, ..., xn} are
required to have nonnegative integer coordinates. The package introduces
the following functions:

FrobeniusInstance[{a1, ..., an}, b] gives a solution instance or {},
FrobeniusSolve[{a1, ..., an}, b] gives a list of all solutions,
FrobeniusF[{a1, ..., an}] gives the Frobenius number, the largest b for
   which the Frobenius equation a1 x1+...+an xn==b has no solutions.
*)

Message[General::obspkg, "NumberTheory`Frobenius`"]

BeginPackage["NumberTheory`Frobenius`"]

FrobeniusInstance::usage = "FrobeniusInstance[{a1, ..., an}, b] gives a solution of the Frobenius equation a1 x1+...+an xn==b. If there are no solutions gives an empty list." 
(*
FrobeniusSolve::usage = "FrobeniusSolve[{a1, ..., an}, b] gives a list of all solutions of the Frobenius equation a1 x1+...+an xn==b." 
*)
FrobeniusF::usage = "FrobeniusF[{a1, ..., an}] gives the Frobenius number of {a1, ..., an}." 
(*
FrobeniusInstance::frcf = FrobeniusSolve::frcf = FrobeniusF::frcf = "`1` is not a list of at least two positive integers." 
*)

Unprotect[FrobeniusInstance]
Unprotect[FrobeniusF]

Begin["`Private`"]

issueObsoleteFunMessage[fun_, context_] :=
        (Message[fun::obspkgfn, fun, context];
         )

FrobeniusInstance[a_, b_] :=
    (issueObsoleteFunMessage[FrobeniusInstance,"NumberTheory`Frobenius`"];
     If[Length[#] > 0, First[#], #]&[FrobeniusSolve[a, b, 1]])

FrobeniusF[a_] :=
    (issueObsoleteFunMessage[FrobeniusF,"NumberTheory`Frobenius`"];
     FrobeniusNumber[a])

End[] (* `Private` *)

Attributes[FrobeniusInstance] = {Protected, ReadProtected}
Attributes[FrobeniusF] = {Protected, ReadProtected}

EndPackage[]  (* NumberTheory`Frobenius` *)

            
