(* ::Package:: *)

(* :Title: PrimitiveElement *)

(* :Summary:
The PrimitiveElement package is obsolete. Use instead functionality
provided by ToNumberField and AlgebraicNumberPolynomial.
*)

(* :Copyright: Copyright 1990-2007, Wolfram Research, Inc.  *)

Message[General::obspkg, "NumberTheory`PrimitiveElement`"]

BeginPackage["NumberTheory`PrimitiveElement`"]

PrimitiveElement::usage = "PrimitiveElement[z, {a1,...,an}] returns a pair {r, {f1,...,fn}}, where r is a primitive element for the extension of rationals by algebraic numbers a1,...,an, and f1,...,fn are polynomials in z such that ai==fi/.z->r for 1<=i<=n."

Begin["`Private`"]

issueObsoleteFunMessage[fun_, context_] :=
        (Message[fun::obspkgfn, fun, context];
         )

PrimitiveElement[z_, algs_List] := 
   (issueObsoleteFunMessage[PrimitiveElement, "NumberTheory`PrimitiveElement`"];
   Module[{ans=ToNumberField[algs], aa},
      If[ListQ[ans],
         aa=Select[ans, Head[#]===AlgebraicNumber&];
         ans={If[aa==={}, 1, aa[[1, 1]]], AlgebraicNumberPolynomial[ans, z]}];
      ans /; ListQ[ans]])

End[]

EndPackage[]
