(* :Title: Recognize *)

(* :Summary:
The Recognize package is obsolete. Use instead functionality provided by
RootApproximant and MinimalPolynomial.
*)

(* :Copyright: Copyright 1990-2007, Wolfram Research, Inc.  *)

Message[General::obspkg, "NumberTheory`Recognize`"];

BeginPackage["NumberTheory`Recognize`"]

Recognize::usage =
"Recognize[x, n, t] finds a polynomial of degree at
most n in the variable t, which is approximately satisfied by the
number x. Recognize[x, n, t, k] also finds a polynomial of degree at
most n in the variable t, but with a penalty of weight k against
higher degree polynomials. k must be a nonnegative integer."

Begin["`Private`"]

issueObsoleteFunMessage[fun_, context_] :=
        (Message[fun::obspkgfn, fun, context];
         )

Recognize[x_?NumericQ, n_Integer?Positive, t_Symbol, k_Integer:0] :=
  (issueObsoleteFunMessage[Recognize, "NumberTheory`Recognize`"];
   With[{ans=RootApproximant[x, n, k]},
      MinimalPolynomial[ans, t] /; Head[ans]=!=RootApproximant])
      
End[]

EndPackage[]
