(*:Mathematica Version: 3.0 *)

(*:Name: Statistics`Common`PopulationsCommon` *)

(*:Context: Statistics`Common`PopulationsCommon` *)

(*:Title:
  Options for functions for computing Confidence Intervals and Hypothesis Tests
	on Population Parameters
*)

(*:Author:
  Dave Withoff (Wolfram Research), March 1991
*)

(*:Copyright: Copyright 1991-2007, Wolfram Research, Inc. *)

(*:Reference: Usage messages only. *)

(*:Summary:
This package introduces symbols ins a common context for use in statistical
packages that test hypotheses about or compute confidence intervals for
population parameters.
*)

(*:Keywords: Mean, variance, sample mean *)

(*:Requirements: No special system requirements. *)

(*:Warning: This package is a subsidiary package to
        ConfidenceIntervals.m and HypothesisTests.m.  It is
        not meant to be loaded as an individual package. *)

(*:Sources: Basic statistics texts. *)

BeginPackage["Statistics`Common`PopulationsCommon`"]
 
KnownVariance::usage =
"KnownVariance is an option to statistical confidence interval and \
hypothesis test functions, and is used to specify the population variance \
whenever formulas corresponding to known population variance are to \
be used. The variance specification should be a list of variances if \
more than one different variance is to be specified. If only one \
variance is specified, it is used for all appropriate populations."

KnownStandardDeviation::usage =
"KnownStandardDeviation is an option to statistical confidence interval and \
hypothesis test functions, and is used to specify the population standard \
deviation whenever formulas corresponding to known population standard \
deviation are to be used. The standard deviation specification should be \
a list of standard deviations if more than one different standard deviation \
is to be specified. If only one standard deviation is specified, it is \
used for all appropriate populations."

EqualVariances::usage =
"EqualVariances is an option to certain statistical confidence interval \
and hypothesis test functions and is used to specify that the appropriate \
unknown population variances are equal."



 

EndPackage[]
