(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12718,        441]
NotebookOptionsPosition[      9328,        327]
NotebookOutlinePosition[     10865,        373]
CellTagsIndexPosition[     10754,        367]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Services Link User Guide" :> 
          Documentation`HelpLookup["paclet:WebServices/tutorial/Overview"], 
          "Advanced Topics in Web Services Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/tutorial/AdvancedTopics"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Web Services Link User Guide\"\>", 
       2->"\<\"Advanced Topics in Web Services Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToServiceRequest" :> 
          Documentation`HelpLookup["paclet:WebServices/ref/ToServiceRequest"],
           "$PrintServiceResponse" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/$PrintServiceResponse"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ToServiceRequest\"\>", 
       2->"\<\"$PrintServiceResponse\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Service Operations" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/guide/WebServiceOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Web Service Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$PrintServiceRequest", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$PrintServiceRequest"], "InlineFormula"],
     " \[LineSeparator]uses the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " ",
     Cell[BoxData[
      ButtonBox["Print",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Print"]], "InlineFormula"],
     " function to print the message sent to a web service. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->453255740],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->72045083],

Cell["Load the package and install a service:", "ExampleText",
 CellID->25852921],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellLabel->"In[1]:=",
 CellID->130542498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Hello.m?wsdl\
\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"In[2]:=",
 CellID->1869],

Cell[BoxData[
 RowBox[{"{", "HelloWorld", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"Out[2]=",
 CellID->45970805]
}, Open  ]],

Cell[TextData[{
 "Set ",
 Cell[BoxData["$PrintServiceRequest"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->194179741],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrintServiceRequest", " ", "=", " ", "True"}], ";"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[3]:=",
 CellID->318029893],

Cell["\<\
Evaluating a web service function prints the request message:\
\>", "ExampleText",
 CellID->379053363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HelloWorld", "[", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[4]:=",
 CellID->982057571],

Cell[BoxData["\<\"<soapenv:Envelope \
xmlns:soapenv='http://schemas.xmlsoap.org/soap/envelope/'\\r\\n    \
xmlns:xsd='http://www.w3.org/2001/XMLSchema'\\r\\n    \
xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\\r\\n    \
xmlns:soapenc='http://schemas.xmlsoap.org/soap/encoding/'>\\r\\n \
<soapenv:Body>\\r\\n  <ns0:HelloWorld \
xmlns:ns0='http://localhost:8080/webMathematica/Examples/WebServices/Hello.m'/\
>\\r\\n </soapenv:Body>\\r\\n</soapenv:Envelope>\"\>"], "Print", \
"ConversionLockdown",
 CellLabel->"During evaluation of In[4]:=",
 CellID->273953245],

Cell[BoxData["\<\"Hello! The current date is {2007, 3, 29, 15, 20, \
41.9102459}\"\>"], "Output", "ConversionLockdown",
 CellLabel->"Out[4]=",
 CellID->120477895]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToServiceRequest",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/ToServiceRequest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PrintServiceResponse",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/$PrintServiceResponse"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1390575883]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Advanced Topics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"]
}], "Tutorials",
 CellID->807310188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->627035431],

Cell[TextData[ButtonBox["Web Service Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:WebServices/guide/WebServiceOperations"]], "MoreAbout",
 CellID->30733157]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$PrintServiceRequest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 24.0900760}", "context" -> 
    "WebServices`", "keywords" -> {}, "index" -> True, "label" -> 
    "Web Services Symbol", "language" -> "en", "paclet" -> "WebServices", 
    "status" -> "None", "summary" -> 
    "$PrintServiceRequest uses the Mathematica Print function to print the \
message sent to a web service. ", "synonyms" -> {}, "title" -> 
    "$PrintServiceRequest", "type" -> "Symbol", "uri" -> 
    "WebServices/ref/$PrintServiceRequest"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4212, 137, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->453255740]},
 "b:1.2.2"->{
  Cell[4977, 168, 231, 6, 70, "Input",
   CellTags->"b:1.2.2",
   CellID->1869],
  Cell[5211, 176, 145, 4, 70, "Output",
   CellTags->"b:1.2.2",
   CellID->45970805]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10429, 353},
 {"b:1.2.2", 10563, 357}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2202, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2825, 81, 63, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2891, 84, 582, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3510, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3988, 124, 187, 8, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[4212, 137, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->453255740],
Cell[CellGroupData[{
Cell[4597, 151, 147, 5, 70, "ExampleSection",
 CellID->72045083],
Cell[4747, 158, 81, 1, 70, "ExampleText",
 CellID->25852921],
Cell[4831, 161, 121, 3, 70, "Input",
 CellID->130542498],
Cell[CellGroupData[{
Cell[4977, 168, 231, 6, 70, "Input",
 CellTags->"b:1.2.2",
 CellID->1869],
Cell[5211, 176, 145, 4, 70, "Output",
 CellTags->"b:1.2.2",
 CellID->45970805]
}, Open  ]],
Cell[5371, 183, 245, 10, 70, "ExampleText",
 CellID->194179741],
Cell[5619, 195, 166, 5, 70, "Input",
 CellID->318029893],
Cell[5788, 202, 112, 3, 70, "ExampleText",
 CellID->379053363],
Cell[CellGroupData[{
Cell[5925, 209, 123, 3, 70, "Input",
 CellID->982057571],
Cell[6051, 214, 567, 10, 70, "Print",
 CellID->273953245],
Cell[6621, 226, 162, 3, 70, "Output",
 CellID->120477895]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6844, 236, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7163, 247, 522, 17, 70, "SeeAlso",
 CellID->1390575883]
}, Open  ]],
Cell[CellGroupData[{
Cell[7722, 269, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8043, 280, 294, 9, 70, "Tutorials",
 CellID->341631938],
Cell[8340, 291, 422, 12, 70, "Tutorials",
 CellID->807310188]
}, Open  ]],
Cell[CellGroupData[{
Cell[8799, 308, 319, 9, 70, "MoreAboutSection",
 CellID->627035431],
Cell[9121, 319, 165, 3, 70, "MoreAbout",
 CellID->30733157]
}, Open  ]],
Cell[9301, 325, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

