(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13994,        478]
NotebookOptionsPosition[     10278,        350]
NotebookOutlinePosition[     12210,        410]
CellTagsIndexPosition[     12099,        404]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Services Link User Guide" :> 
          Documentation`HelpLookup["paclet:WebServices/tutorial/Overview"], 
          "Advanced Topics in Web Services Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/tutorial/AdvancedTopics"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Web Services Link User Guide\"\>", 
       2->"\<\"Advanced Topics in Web Services Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToServiceRequest" :> 
          Documentation`HelpLookup["paclet:WebServices/ref/ToServiceRequest"],
           "$PrintServiceResponse" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/$PrintServiceResponse"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ToServiceRequest\"\>", 
       2->"\<\"$PrintServiceResponse\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Service Operations" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/guide/WebServiceOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Web Service Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FromServiceResponse", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromServiceResponse", "[", 
       StyleBox["response", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts a response message into a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->212910519],

Cell["Load the package and install a web service:", "ExampleText",
 CellID->25852921],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[1]:=",
 CellID->22888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m?\
wsdl\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[2]:=",
 CellID->19156],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "IntegrateExpression", ",", "IntegrateExpressionToGIF", ",", 
   "IntegrateMathML", ",", "IntegrateMathMLToGIF", ",", "IntegrateString", 
   ",", "IntegrateStringToGIF"}], "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[2]=",
 CellID->57227571]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InvokeServiceOperation",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " to send the message to the server:"
}], "ExampleText",
 CellID->264850573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"response", " ", "=", " ", 
  RowBox[{"InvokeServiceOperation", "[", 
   RowBox[{"IntegrateString", ",", "\"\<Sin[x]\>\""}], "]"}]}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[3]:=",
 CellID->20055],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>", 
       ",", "\<\"Envelope\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
         ",", "\<\"soapenv\"\>"}], "}"}], 
       "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>", 
          ",", "\<\"Body\"\>"}], "}"}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"http://localhost:8080/webMathematica/Examples/\
WebServices/Integrate.m\"\>", ",", "\<\"IntegrateStringReturn\"\>"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
               ",", "\<\"ns1\"\>"}], "}"}], 
             "\[Rule]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\"\>\
"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\<\"\"\>", ",", "\<\"element\"\>"}], "}"}], ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"-Cos[x]\"\>", "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[3]=",
 CellID->267481822]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["FromServiceResponse"], "InlineFormula"],
 " to process the message from the server:"
}], "ExampleText",
 CellID->713834637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromServiceResponse", "[", 
  RowBox[{"IntegrateString", ",", " ", "response"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[4]:=",
 CellID->28433],

Cell[BoxData["\<\"-Cos[x]\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[4]=",
 CellID->477902895]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToServiceRequest",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/ToServiceRequest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PrintServiceResponse",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/$PrintServiceResponse"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->793828170]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Advanced Topics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"]
}], "Tutorials",
 CellID->136232443]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->21163502],

Cell[TextData[ButtonBox["Web Service Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:WebServices/guide/WebServiceOperations"]], "MoreAbout",
 CellID->18716689]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FromServiceResponse - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 19.4963554}", "context" -> 
    "WebServices`", "keywords" -> {}, "index" -> True, "label" -> 
    "Web Services Symbol", "language" -> "en", "paclet" -> "WebServices", 
    "status" -> "None", "summary" -> 
    "FromServiceResponse[response] converts a response message into a \
Mathematica expression. ", "synonyms" -> {}, "title" -> "FromServiceResponse",
     "type" -> "Symbol", "uri" -> "WebServices/ref/FromServiceResponse"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3417, 104, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:1.4.1"->{
  Cell[4033, 128, 139, 4, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->22888],
  Cell[4197, 136, 236, 6, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->19156],
  Cell[4436, 144, 317, 8, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->57227571],
  Cell[5057, 168, 251, 7, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->20055],
  Cell[5311, 177, 1883, 52, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->267481822],
  Cell[7397, 241, 206, 6, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->28433],
  Cell[7606, 249, 129, 3, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->477902895]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11359, 375},
 {"b:1.4.1", 11485, 379}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2202, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2825, 81, 62, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2890, 84, 490, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3417, 104, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3794, 118, 148, 5, 70, "ExampleSection",
 CellID->212910519],
Cell[3945, 125, 85, 1, 70, "ExampleText",
 CellID->25852921],
Cell[4033, 128, 139, 4, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->22888],
Cell[CellGroupData[{
Cell[4197, 136, 236, 6, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->19156],
Cell[4436, 144, 317, 8, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->57227571]
}, Open  ]],
Cell[4768, 155, 264, 9, 70, "ExampleText",
 CellID->264850573],
Cell[CellGroupData[{
Cell[5057, 168, 251, 7, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->20055],
Cell[5311, 177, 1883, 52, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->267481822]
}, Open  ]],
Cell[7209, 232, 163, 5, 70, "ExampleText",
 CellID->713834637],
Cell[CellGroupData[{
Cell[7397, 241, 206, 6, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->28433],
Cell[7606, 249, 129, 3, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->477902895]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7796, 259, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8115, 270, 521, 17, 70, "SeeAlso",
 CellID->793828170]
}, Open  ]],
Cell[CellGroupData[{
Cell[8673, 292, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8994, 303, 294, 9, 70, "Tutorials",
 CellID->341631938],
Cell[9291, 314, 422, 12, 70, "Tutorials",
 CellID->136232443]
}, Open  ]],
Cell[CellGroupData[{
Cell[9750, 331, 318, 9, 70, "MoreAboutSection",
 CellID->21163502],
Cell[10071, 342, 165, 3, 70, "MoreAbout",
 CellID->18716689]
}, Open  ]],
Cell[10251, 348, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

