(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19101,        624]
NotebookOptionsPosition[     14731,        483]
NotebookOutlinePosition[     17104,        549]
CellTagsIndexPosition[     16993,        543]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Services Link User Guide" :> 
          Documentation`HelpLookup["paclet:WebServices/tutorial/Overview"], 
          "Advanced Topics in Web Services Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/tutorial/AdvancedTopics"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Web Services Link User Guide\"\>", 
       2->"\<\"Advanced Topics in Web Services Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InstallServiceOperation" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/InstallServiceOperation"], 
          "InstallService" :> 
          Documentation`HelpLookup["paclet:ref/InstallService"], 
          "ToServiceRequest" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/ToServiceRequest"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"InstallServiceOperation\"\>", 
       2->"\<\"InstallService\"\>", 
       3->"\<\"ToServiceRequest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Service Operations" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/guide/WebServiceOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Web Service Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InvokeServiceOperation", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InvokeServiceOperation", "[", 
       RowBox[{
        StyleBox[
         RowBox[{"\"\<\>", "url", "\"\<\>"}], "TI"], ",", 
        StyleBox["request", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]invokes a web service operation using the request \
message ",
     Cell[BoxData[
      StyleBox["request", "TI"]], "InlineFormula"],
     ". The message is sent to the end point specified in ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"\"\<\>", "url", "\"\<\>"}], "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InvokeServiceOperation", "[", 
       RowBox[{
        StyleBox["symbol", "TI"], ",", 
        StyleBox["parameters", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]builds a request message using ",
     Cell[BoxData[
      StyleBox["parameters", "TI"]], "InlineFormula"],
     " and invokes a web service operation using the request message and \
information linked with ",
     Cell[BoxData[
      StyleBox["symbol", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InvokeServiceOperation", "[", 
       RowBox[{
        StyleBox["symbol", "TI"], ",", 
        StyleBox["request", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]invokes a web service operation using the request \
message ",
     Cell[BoxData[
      StyleBox["request", "TI"]], "InlineFormula"],
     " and information linked with ",
     Cell[BoxData[
      StyleBox["symbol", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["InvokeServiceOperation"], "InlineFormula"],
 " returns the response message."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->103609759],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->34969251],

Cell["Load the package and install a web service:", "ExampleText",
 CellID->25852921],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[1]:=",
 CellID->22888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m?\
wsdl\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[2]:=",
 CellID->19156],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "IntegrateExpression", ",", "IntegrateExpressionToGIF", ",", 
   "IntegrateMathML", ",", "IntegrateMathMLToGIF", ",", "IntegrateString", 
   ",", "IntegrateStringToGIF"}], "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[2]=",
 CellID->51350147]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToServiceRequest",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/ToServiceRequest"]], "InlineFormula"],
 " to build a message in symbolic XML:"
}], "ExampleText",
 CellID->860419062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"symbolicXML", " ", "=", 
  RowBox[{"ToServiceRequest", "[", 
   RowBox[{"IntegrateString", ",", "\"\<Sin[x]\>\""}], "]"}]}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[3]:=",
 CellID->16202],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"soapenv\"\>", ",", "\<\"Envelope\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"soapenv\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>"}], ",",
        
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"xsd\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/2001/XMLSchema\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"xsi\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/2001/XMLSchema-instance\"\>"}], ",",
        
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"soapenc\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/encoding/\"\>"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"soapenv\"\>", ",", "\<\"Body\"\>"}], "}"}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\<\"ns0\"\>", ",", "\<\"IntegrateString\"\>"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"xmlns\"\>", ",", "\<\"ns0\"\>"}], "}"}], 
             "\[Rule]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\"\>\
"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\<\"\"\>", ",", "\<\"str\"\>"}], "}"}], ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"Sin[x]\"\>", "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[3]=",
 CellID->282642575]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["InvokeServiceOperation"], "InlineFormula"],
 " to send the message to the server:"
}], "ExampleText",
 CellID->264850573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvokeServiceOperation", "[", 
  RowBox[{"IntegrateString", ",", "symbolicXML"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[4]:=",
 CellID->20055],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>", 
       ",", "\<\"Envelope\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
         ",", "\<\"soapenv\"\>"}], "}"}], 
       "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>", 
          ",", "\<\"Body\"\>"}], "}"}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"http://localhost:8080/webMathematica/Examples/\
WebServices/Integrate.m\"\>", ",", "\<\"IntegrateStringReturn\"\>"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
               ",", "\<\"ns1\"\>"}], "}"}], 
             "\[Rule]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\"\>\
"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\<\"\"\>", ",", "\<\"element\"\>"}], "}"}], ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"-Cos[x]\"\>", "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[4]=",
 CellID->321079653]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstallServiceOperation",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/InstallServiceOperation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstallService",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InstallService"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToServiceRequest",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/ToServiceRequest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Advanced Topics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"]
}], "Tutorials",
 CellID->807310188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->238420407],

Cell[TextData[ButtonBox["Web Service Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:WebServices/guide/WebServiceOperations"]], "MoreAbout",
 CellID->24007880]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InvokeServiceOperation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 21.3557185}", "context" -> 
    "WebServices`", "keywords" -> {}, "index" -> True, "label" -> 
    "Web Services Symbol", "language" -> "en", "paclet" -> "WebServices", 
    "status" -> "None", "summary" -> 
    "InvokeServiceOperation[\"url \", request] invokes a web service \
operation using the request message request. The message is sent to the end \
point specified in \" url \". InvokeServiceOperation[symbol, parameters] \
builds a request message using parameters and invokes a web service operation \
using the request message and information linked with symbol. \
InvokeServiceOperation[symbol, request] invokes a web service operation using \
the request message request and information linked with symbol. ", 
    "synonyms" -> {}, "title" -> "InvokeServiceOperation", "type" -> "Symbol",
     "uri" -> "WebServices/ref/InvokeServiceOperation"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5560, 172, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->103609759]},
 "b:1.4.1"->{
  Cell[6183, 196, 139, 4, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->22888],
  Cell[6347, 204, 236, 6, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->19156],
  Cell[6586, 212, 317, 8, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->51350147],
  Cell[7193, 235, 243, 7, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->16202],
  Cell[7439, 244, 2193, 60, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->282642575],
  Cell[9833, 316, 207, 6, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->20055],
  Cell[10043, 324, 1883, 52, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->321079653]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16242, 514},
 {"b:1.4.1", 16376, 518}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2354, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2977, 85, 65, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3045, 88, 1821, 53, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4903, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5381, 163, 142, 4, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[5560, 172, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->103609759],
Cell[CellGroupData[{
Cell[5945, 186, 147, 5, 70, "ExampleSection",
 CellID->34969251],
Cell[6095, 193, 85, 1, 70, "ExampleText",
 CellID->25852921],
Cell[6183, 196, 139, 4, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->22888],
Cell[CellGroupData[{
Cell[6347, 204, 236, 6, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->19156],
Cell[6586, 212, 317, 8, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->51350147]
}, Open  ]],
Cell[6918, 223, 250, 8, 70, "ExampleText",
 CellID->860419062],
Cell[CellGroupData[{
Cell[7193, 235, 243, 7, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->16202],
Cell[7439, 244, 2193, 60, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->282642575]
}, Open  ]],
Cell[9647, 307, 161, 5, 70, "ExampleText",
 CellID->264850573],
Cell[CellGroupData[{
Cell[9833, 316, 207, 6, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->20055],
Cell[10043, 324, 1883, 52, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->321079653]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11987, 383, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[12306, 394, 782, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[13125, 425, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[13446, 436, 294, 9, 70, "Tutorials",
 CellID->341631938],
Cell[13743, 447, 422, 12, 70, "Tutorials",
 CellID->807310188]
}, Open  ]],
Cell[CellGroupData[{
Cell[14202, 464, 319, 9, 70, "MoreAboutSection",
 CellID->238420407],
Cell[14524, 475, 165, 3, 70, "MoreAbout",
 CellID->24007880]
}, Open  ]],
Cell[14704, 481, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

