(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45782,       1438]
NotebookOptionsPosition[     34147,       1050]
NotebookOutlinePosition[     41387,       1259]
CellTagsIndexPosition[     41220,       1251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Print" :> Documentation`HelpLookup["paclet:ref/Print"], 
         "$PrintServiceRequest" :> 
         Documentation`HelpLookup[
          "paclet:WebServices/ref/$PrintServiceRequest"], 
         "$PrintServiceResponse" :> 
         Documentation`HelpLookup[
          "paclet:WebServices/ref/$PrintServiceResponse"], 
         "$PrintShortErrorMessages" :> 
         Documentation`HelpLookup[
          "paclet:WebServices/ref/$PrintShortErrorMessages"], 
         "$PrintWSDLDebug" :> 
         Documentation`HelpLookup[
          "paclet:WebServices/ref/$PrintWSDLDebug"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Print\"\>", 2->"\<\"$PrintServiceRequest\"\>", 
      3->"\<\"$PrintServiceResponse\"\>", 
      4->"\<\"$PrintShortErrorMessages\"\>", 
      5->"\<\"$PrintWSDLDebug\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Advanced Topics", "Title",
 CellID->7958],

Cell[CellGroupData[{

Cell["Working with Messages", "Section",
 CellID->6191],

Cell[TextData[{
 "Sometimes it is useful to work directly with the request message that is \
sent to a web service. This message may be retrieved using the ",
 Cell[BoxData[
  ButtonBox["ToServiceRequest",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/ToServiceRequest"]], "InlineFormula"],
 " function. ",
 Cell[BoxData[
  ButtonBox["ToServiceRequest",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/ToServiceRequest"]], "InlineFormula"],
 " is called by providing a web service function as the first parameter and \
its parameters as the additional parameters. The function will not invoke the \
web service operation. Rather the function will return the symbolic XML \
representation of the request message that would generally be sent to the web \
service."
}], "Text",
 CellTags->"b:1.4.1",
 CellID->19815],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[1]:=",
 CellID->22888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m?\
wsdl\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[2]:=",
 CellID->19156],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "IntegrateExpression", ",", "IntegrateExpressionToGIF", ",", 
   "IntegrateMathML", ",", "IntegrateMathMLToGIF", ",", "IntegrateString", 
   ",", "IntegrateStringToGIF"}], "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[2]=",
 CellID->51350147]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"symbolicXML", " ", "=", 
  RowBox[{"ToServiceRequest", "[", 
   RowBox[{"IntegrateString", ",", "\"\<Sin[x]\>\""}], "]"}]}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[3]:=",
 CellID->16202],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"soapenv\"\>", ",", "\<\"Envelope\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"soapenv\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>"}], ",",
        
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"xsd\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/2001/XMLSchema\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"xsi\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/2001/XMLSchema-instance\"\>"}], ",",
        
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"soapenc\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/encoding/\"\>"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"soapenv\"\>", ",", "\<\"Body\"\>"}], "}"}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\<\"ns0\"\>", ",", "\<\"IntegrateString\"\>"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"xmlns\"\>", ",", "\<\"ns0\"\>"}], "}"}], 
             "\[Rule]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\"\>\
"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\<\"\"\>", ",", "\<\"str\"\>"}], "}"}], ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"Sin[x]\"\>", "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[3]=",
 CellID->282642575]
}, Open  ]],

Cell[TextData[{
 "A user may change the request message to have different values or different \
attributes. In fact, the user may create an entirely new message. However, \
the message must still follow the format specified in the SOAP specification. \
Using ",
 Cell[BoxData[
  ButtonBox["ToServiceRequest",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/ToServiceRequest"]], "InlineFormula"],
 " gives the user a nice starting point. The request message can then be \
invoked using the ",
 Cell[BoxData[
  ButtonBox["InvokeServiceOperation",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " function. The first parameter of this function is the end point URI or the \
symbol representing a web service function. The web service function \
specifies the end point URI internally along with other options for invoking \
the service. The second argument is the symbolic XML representation of the \
request message."
}], "Text",
 CellTags->"b:1.4.1",
 CellID->24272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvokeServiceOperation", "[", 
  RowBox[{"IntegrateString", ",", "symbolicXML"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[4]:=",
 CellID->20055],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>", 
       ",", "\<\"Envelope\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
         ",", "\<\"soapenv\"\>"}], "}"}], 
       "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>", 
          ",", "\<\"Body\"\>"}], "}"}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"http://localhost:8080/webMathematica/Examples/\
WebServices/Integrate.m\"\>", ",", "\<\"IntegrateStringReturn\"\>"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
               ",", "\<\"ns1\"\>"}], "}"}], 
             "\[Rule]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\"\>\
"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\<\"\"\>", ",", "\<\"element\"\>"}], "}"}], ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"-Cos[x]\"\>", "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[4]=",
 CellID->321079653]
}, Open  ]],

Cell[TextData[{
 "The result of this call is the response message. Sometimes it is useful to \
work directly with the response message. However, web service functions by \
default return a deserialized version of the response message. The original \
response message may be retrieved using the ",
 Cell[BoxData[
  ButtonBox["InvokeServiceOperation",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " function. The first parameter is the web service function, and the \
function\[CloseCurlyQuote]s parameters follow. ",
 Cell[BoxData[
  ButtonBox["InvokeServiceOperation",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " invokes the service and returns the entire response message in symbolic \
XML. This will allow the user to customize how the data is deserialized into \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " representation."
}], "Text",
 CellTags->"b:1.4.1",
 CellID->22646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"response", " ", "=", " ", 
  RowBox[{"InvokeServiceOperation", "[", 
   RowBox[{"IntegrateString", ",", "\"\<Sin[x]\>\""}], "]"}]}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[5]:=",
 CellID->26362],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>", 
       ",", "\<\"Envelope\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
         ",", "\<\"soapenv\"\>"}], "}"}], 
       "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>", 
          ",", "\<\"Body\"\>"}], "}"}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"http://localhost:8080/webMathematica/Examples/\
WebServices/Integrate.m\"\>", ",", "\<\"IntegrateStringReturn\"\>"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
               ",", "\<\"ns1\"\>"}], "}"}], 
             "\[Rule]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\"\>\
"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\<\"\"\>", ",", "\<\"element\"\>"}], "}"}], ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"-Cos[x]\"\>", "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[5]=",
 CellID->81979719]
}, Open  ]],

Cell[TextData[{
 "Once a web service function is called using ",
 Cell[BoxData[
  ButtonBox["InvokeServiceOperation",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 ", the results come back in the form of a SOAP envelope. ",
 Cell[BoxData[
  ButtonBox["FromServiceResponse",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/FromServiceResponse"]], 
  "InlineFormula"],
 " can be used to extract the results from the SOAP envelope. The data will \
be deserialized into the proper ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " types specified by the operation symbol."
}], "Text",
 CellTags->"b:1.4.1",
 CellID->18875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromServiceResponse", "[", 
  RowBox[{"IntegrateString", ",", " ", "response"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[6]:=",
 CellID->28433],

Cell[BoxData["\<\"-Cos[x]\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[6]=",
 CellID->71252234]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working without a WSDL", "Section",
 CellTags->"b:1.4.2",
 CellID->20142],

Cell[TextData[{
 "Web services will work without a WSDL file, and sometimes the user may be \
forced into a situation where a WSDL file is not available. Although it is \
much more convenient to use web services with a WSDL file, it is possible to \
use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " web services client without a WSDL. A user can build the SOAP message from \
scratch in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using symbolic XML."
}], "Text",
 CellTags->"b:1.4.2",
 CellID->23844],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToServiceRequest",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/ToServiceRequest"]], "InlineFormula"],
 " can also be used to build a SOAP message using XML Schema definitions. ",
 StyleBox["DefineSchema", "MR"],
 " can be used to define type definitions for a web service. In this example, \
the ",
 StyleBox["IntegrateString", "MR"],
 " web services have a root element of ",
 StyleBox["IntegrateString", "MR"],
 ", have a namespace of \
http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m, and \
take a string named ",
 StyleBox["str", "MR"],
 " as a parameter."
}], "Text",
 CellTags->"b:1.4.2",
 CellID->1416],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"In[1]:=",
 CellID->21881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefineSchema", "[", 
  RowBox[{
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\>\
\"", ",", " ", "\[IndentingNewLine]", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"IntegrateString", ":", 
     RowBox[{"IntegrateStringType", "[", "str_String", "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"In[2]:=",
 CellID->31998],

Cell[BoxData[
 RowBox[{"{", "IntegrateString", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"Out[2]=",
 CellID->93495576]
}, Open  ]],

Cell[TextData[{
 StyleBox["NewSchemaInstance", "MR"],
 " can be used to create an instance of the type just defined and this can be \
passed into ",
 Cell[BoxData[
  ButtonBox["ToServiceRequest",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/ToServiceRequest"]], "InlineFormula"],
 ", which takes two parameters. First it takes a list of parameters for the \
body of the message. Second it takes a list of parameters for the header."
}], "Text",
 CellTags->"b:1.4.2",
 CellID->18651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToServiceRequest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"NewSchemaInstance", "[", 
     RowBox[{"IntegrateString", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<str\>\"", "\[Rule]", "\"\<Sin[x]\>\""}], "}"}]}], "]"}], 
    "}"}], ",", " ", 
   RowBox[{"{", "}"}]}], "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"In[3]:=",
 CellID->10021],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"soapenv\"\>", ",", "\<\"Envelope\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"soapenv\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>"}], ",",
        
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"xsd\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/2001/XMLSchema\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"xsi\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/2001/XMLSchema-instance\"\>"}], ",",
        
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"soapenc\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/encoding/\"\>"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"soapenv\"\>", ",", "\<\"Body\"\>"}], "}"}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\<\"ns1\"\>", ",", "\<\"IntegrateString\"\>"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"xmlns\"\>", ",", "\<\"ns1\"\>"}], "}"}], 
             "\[Rule]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\"\>\
"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\<\"\"\>", ",", "\<\"str\"\>"}], "}"}], ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"Sin[x]\"\>", "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"Out[3]=",
 CellID->45665699]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToServiceRequest",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/ToServiceRequest"]], "InlineFormula"],
 " supports two options as well. First, ",
 Cell[BoxData["OperationName"], "InlineFormula"],
 " can be used to wrap an element that identifies a web service operation \
around the parameters. This is often useful when using RPC-style web services \
or when mapping document-style web services to functions. Second,",
 " ",
 Cell[BoxData["EncodingStyleURI"], "InlineFormula"],
 " may be used to set the encoding style. The only encoding style supported \
is SOAP encoding as demonstrated next. This adds type attributes to the \
parameters."
}], "Text",
 CellTags->"b:1.4.2",
 CellID->3557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msg", " ", "=", 
  RowBox[{"ToServiceRequest", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<str\>\"", "\[Rule]", "\"\<Sin[x]\>\""}], "}"}], ",", " ", 
    RowBox[{"{", "}"}], ",", " ", "\[IndentingNewLine]", 
    RowBox[{"OperationName", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<http://localhost:8080/webMathematica/Examples/WebServices/\
Integrate.m\>\"", ",", "\"\<IntegrateString\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"EncodingStyleURI", "\[Rule]", 
     RowBox[{
     "{", "\"\<http://schemas.xmlsoap.org/soap/encoding/\>\"", "}"}]}]}], " ",
    "\[IndentingNewLine]", "]"}]}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"In[4]:=",
 CellID->28476],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"soapenv\"\>", ",", "\<\"Envelope\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"soapenv\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>"}], ",",
        
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"xsd\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/2001/XMLSchema\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"xsi\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/2001/XMLSchema-instance\"\>"}], ",",
        
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"soapenc\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/encoding/\"\>"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"soapenv\"\>", ",", "\<\"Body\"\>"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\<\"soapenv\"\>", ",", "\<\"encodingStyle\"\>"}], "}"}], 
          "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/encoding/\"\>"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\<\"ns0\"\>", ",", "\<\"IntegrateString\"\>"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"xmlns\"\>", ",", "\<\"ns0\"\>"}], "}"}], 
             "\[Rule]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\"\>\
"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\<\"\"\>", ",", "\<\"str\"\>"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"\<\"xsi\"\>", ",", "\<\"type\"\>"}], "}"}], 
                "\[Rule]", "\<\"xsd:string\"\>"}], "}"}], ",", 
              RowBox[{"{", "\<\"Sin[x]\"\>", "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"Out[4]=",
 CellID->262395889]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InvokeServiceOperation",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " can then be used to invoke the service with the message that has been \
generated. ",
 Cell[BoxData[
  ButtonBox["InvokeServiceOperation",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " requires two parameters. First the end point is required, which specifies \
the URL where the message will be sent. The second parameter is the message. \
A couple of options are supported as well. ",
 Cell[BoxData[
  ButtonBox["SOAPActionURI",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " may be used to set a SOAP Action header. ",
 Cell[BoxData[
  ButtonBox["TransportStyleURI",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " may be used to set the transport style (although http is the only \
transport currently supported). ",
 Cell[BoxData[
  ButtonBox["Username",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Password",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " may be used for authentication and ",
 Cell[BoxData[
  ButtonBox["Timeout",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 " may be used to set a timeout."
}], "Text",
 CellTags->"b:1.4.2",
 CellID->24389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"response", " ", "=", " ", 
  RowBox[{"InvokeServiceOperation", "[", 
   RowBox[{
   "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\
\>\"", ",", " ", "msg"}], "]"}]}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"In[5]:=",
 CellID->5075],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>", 
       ",", "\<\"Envelope\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
         ",", "\<\"soapenv\"\>"}], "}"}], 
       "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>", 
          ",", "\<\"Body\"\>"}], "}"}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"http://localhost:8080/webMathematica/Examples/\
WebServices/Integrate.m\"\>", ",", "\<\"IntegrateStringReturn\"\>"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
               ",", "\<\"ns1\"\>"}], "}"}], 
             "\[Rule]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\"\>\
"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\<\"\"\>", ",", "\<\"element\"\>"}], "}"}], ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"-Cos[x]\"\>", "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"Out[5]=",
 CellID->481681480]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromServiceResponse",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/FromServiceResponse"]], 
  "InlineFormula"],
 " can be used to process a SOAP message using XML Schema definitions. ",
 StyleBox["DefineSchema", "MR"],
 " can be used to define a return type for a web service. In this example, \
the ",
 StyleBox["IntegrateString", "MR"],
 " returns an element with a string named ",
 StyleBox["element", "MR"],
 ". ",
 Cell[BoxData[
  ButtonBox["FromServiceResponse",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/FromServiceResponse"]], 
  "InlineFormula"],
 " takes the message as a parameter and the option ",
 Cell[BoxData[
  ButtonBox["ReturnType",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/FromServiceResponse"]], 
  "InlineFormula"],
 " is used to specify the return type."
}], "Text",
 CellTags->"b:1.4.2",
 CellID->2600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefineSchema", "[", 
  RowBox[{
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\>\
\"", ",", " ", "\[IndentingNewLine]", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"IntegrateStringReturnType", "[", "element_String", "]"}], 
    "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"In[6]:=",
 CellID->2510],

Cell[BoxData[
 RowBox[{"{", "IntegrateStringReturnType", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"Out[6]=",
 CellID->198244508]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromServiceResponse", "[", 
  RowBox[{"response", ",", " ", 
   RowBox[{"ReturnType", "\[Rule]", "IntegrateStringReturnType"}]}], 
  "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"In[7]:=",
 CellID->26869],

Cell[BoxData["\<\"-Cos[x]\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"Out[7]=",
 CellID->342386383]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InstallServiceOperation",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InstallServiceOperation"]], 
  "InlineFormula"],
 " can be used to install these definitions as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function. It takes a symbol as its first parameter that the function \
definition will be associated with. It takes a URL as its second parameter \
that will define where a message is sent. The third parameter is a list of \
parameters for the function. These parameters are defined using XML Schema \
element definition symbols defined using ",
 StyleBox["DefineSchema", "MR"],
 ". The fourth parameter is a list of header parameters. Finally, options may \
be used. Each option from ",
 Cell[BoxData[
  ButtonBox["ToServiceRequest",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/ToServiceRequest"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InvokeServiceOperation",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FromServiceResponse",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/FromServiceResponse"]], 
  "InlineFormula"],
 " is valid."
}], "Text",
 CellTags->"b:1.4.2",
 CellID->14688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallServiceOperation", "[", "\[IndentingNewLine]", 
  RowBox[{
  "integrateString", ",", " ", "\[IndentingNewLine]", 
   "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\
\>\"", ",", " ", "\[IndentingNewLine]", 
   RowBox[{"TypeElements", "[", 
    RowBox[{"ElementType", "[", "IntegrateString", "]"}], "]"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "}"}], ",", " ", "\[IndentingNewLine]", 
   RowBox[{"OperationName", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.\
m\>\"", ",", " ", "\"\<IntegrateString\>\""}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"ReturnType", "\[Rule]", "IntegrateStringReturnType"}]}], 
  "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"In[8]:=",
 CellID->13401],

Cell[BoxData["integrateString"], "Output", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"Out[8]=",
 CellID->646352002]
}, Open  ]],

Cell[TextData[{
 "Once the function is installed, it may be used just like other functions \
installed using ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:1.4.2",
 CellID->15255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "integrateString"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"In[9]:=",
 CellID->16423],

Cell[BoxData[
 StyleBox["\<\"String integrateString[str_String]\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->{"b:1.4.2", "Info3384169895-8612076"},
 CellID->598335664]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"integrateString", "[", "\"\<Cos[x]\>\"", "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"In[10]:=",
 CellID->10585],

Cell[BoxData["\<\"Sin[x]\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.4.2",
 CellLabel->"Out[10]=",
 CellID->513990637]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Debugging", "Section",
 CellTags->"b:1.4.3",
 CellID->10285],

Cell[TextData[{
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " provides a few symbols that can help in debugging. The debugging symbols \
are defined in the following table."
}], "Text",
 CellTags->"b:1.4.3",
 CellID->27088],

Cell[BoxData[GridBox[{
   {Cell["Symbol", "TableText"], Cell["Description", "TableText"]},
   {
    ButtonBox["$PrintServiceRequest",
     BaseStyle->"Link",
     ButtonData->"paclet:WebServices/ref/$PrintServiceRequest"], Cell[
    TextData[{
     "uses the ",
     Cell[BoxData[
      ButtonBox["Print",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Print"]], "InlineFormula"],
     " function to print the message in XML format sent to a web service"
    }], "TableText"]},
   {
    ButtonBox["$PrintServiceResponse",
     BaseStyle->"Link",
     ButtonData->"paclet:WebServices/ref/$PrintServiceResponse"], Cell[
    TextData[{
     "uses the ",
     Cell[BoxData[
      ButtonBox["Print",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Print"]], "InlineFormula"],
     " function to print the message in XML format received from a web \
service before it is deserialized into a rule syntax expression"
    }], "TableText"]},
   {
    ButtonBox["$PrintWSDLDebug",
     BaseStyle->"Link",
     ButtonData->"paclet:WebServices/ref/$PrintWSDLDebug"], Cell["\<\
prints information about web services being installed that can be used to \
debug; information printed includes option values, parameter signatures, and \
the endpoint URI for web service operation\
\>", "TableText"]},
   {
    ButtonBox["$PrintShortErrorMessages",
     BaseStyle->"Link",
     ButtonData->"paclet:WebServices/ref/$PrintShortErrorMessages"], 
    Cell["\<\
specifies whether error messages will be shortened for the user to avoid long \
intimidating error messages\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->119200707],

Cell["Debugging symbols.", "Caption",
 CellID->731545154]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Advanced Topics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 27.8400520}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Web Services Tutorial", 
    "language" -> "en", "paclet" -> "WebServices", "status" -> "None", 
    "summary" -> 
    "Sometimes it is useful to work directly with the request message that is \
sent to a web service. This message may be retrieved using the \
ToServiceRequest function. ToServiceRequest is called by providing a web \
service function as the first parameter and its parameters as the additional \
parameters. The function will not invoke the web service operation. Rather \
the function will return the symbolic XML representation of the request \
message that would generally be sent to the web service. A user may change \
the request message to have different values or different attributes. In \
fact, the user may create an entirely new message. However, the message must \
still follow the format specified in the SOAP specification. Using \
ToServiceRequest gives the user a nice starting point. The request message \
can then be invoked using the InvokeServiceOperation function. The first \
parameter of this function is the end point URI or the symbol representing a \
web service function. The web service function specifies the end point URI \
internally along with other options for invoking the service. The second \
argument is the symbolic XML representation of the request message. The \
result of this call is the response message. Sometimes it is useful to work \
directly with the response message. However, web service functions by default \
return a deserialized version of the response message. The original response \
message may be retrieved using the InvokeServiceOperation function. The first \
parameter is the web service function, and the function's parameters follow. \
InvokeServiceOperation invokes the service and returns the entire response \
message in symbolic XML. This will allow the user to customize how the data \
is deserialized into Mathematica representation.", "synonyms" -> {}, "title" -> 
    "Advanced Topics", "type" -> "Tutorial", "uri" -> 
    "WebServices/tutorial/AdvancedTopics"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:1.4.1"->{
  Cell[1971, 63, 840, 19, 70, "Text",
   CellTags->"b:1.4.1",
   CellID->19815],
  Cell[2814, 84, 139, 4, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->22888],
  Cell[2978, 92, 236, 6, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->19156],
  Cell[3217, 100, 317, 8, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->51350147],
  Cell[3571, 113, 243, 7, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->16202],
  Cell[3817, 122, 2193, 60, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->282642575],
  Cell[6025, 185, 1041, 23, 70, "Text",
   CellTags->"b:1.4.1",
   CellID->24272],
  Cell[7091, 212, 207, 6, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->20055],
  Cell[7301, 220, 1883, 52, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->321079653],
  Cell[9199, 275, 1020, 25, 70, "Text",
   CellTags->"b:1.4.1",
   CellID->22646],
  Cell[10244, 304, 251, 7, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->26362],
  Cell[10498, 313, 1882, 52, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->81979719],
  Cell[12395, 368, 700, 20, 70, "Text",
   CellTags->"b:1.4.1",
   CellID->18875],
  Cell[13120, 392, 206, 6, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->28433],
  Cell[13329, 400, 128, 3, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->71252234]},
 "b:1.4.2"->{
  Cell[13506, 409, 79, 2, 70, "Section",
   CellTags->"b:1.4.2",
   CellID->20142],
  Cell[13588, 413, 526, 14, 70, "Text",
   CellTags->"b:1.4.2",
   CellID->23844],
  Cell[14117, 429, 692, 19, 70, "Text",
   CellTags->"b:1.4.2",
   CellID->1416],
  Cell[14812, 450, 139, 4, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->21881],
  Cell[14976, 458, 477, 12, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->31998],
  Cell[15456, 472, 150, 4, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->93495576],
  Cell[15621, 479, 498, 12, 70, "Text",
   CellTags->"b:1.4.2",
   CellID->18651],
  Cell[16144, 495, 403, 12, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->10021],
  Cell[16550, 509, 2192, 60, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->45665699],
  Cell[18757, 572, 752, 17, 70, "Text",
   CellTags->"b:1.4.2",
   CellID->3557],
  Cell[19534, 593, 748, 19, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->28476],
  Cell[20285, 614, 2577, 69, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->262395889],
  Cell[22877, 686, 1673, 49, 70, "Text",
   CellTags->"b:1.4.2",
   CellID->24389],
  Cell[24575, 739, 310, 8, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->5075],
  Cell[24888, 749, 1883, 52, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->481681480],
  Cell[26786, 804, 924, 28, 70, "Text",
   CellTags->"b:1.4.2",
   CellID->2600],
  Cell[27735, 836, 446, 11, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->2510],
  Cell[28184, 849, 161, 4, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->198244508],
  Cell[28382, 858, 256, 7, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->26869],
  Cell[28641, 867, 129, 3, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->342386383],
  Cell[28785, 873, 1318, 36, 70, "Text",
   CellTags->"b:1.4.2",
   CellID->14688],
  Cell[30128, 913, 875, 20, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->13401],
  Cell[31006, 935, 129, 3, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->646352002],
  Cell[31150, 941, 221, 8, 70, "Text",
   CellTags->"b:1.4.2",
   CellID->15255],
  Cell[31396, 953, 141, 4, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->16423],
  Cell[31540, 959, 173, 4, 70, "Print",
   CellTags->{"b:1.4.2", "Info3384169895-8612076"},
   CellID->598335664],
  Cell[31750, 968, 167, 5, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->10585],
  Cell[31920, 975, 129, 3, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->513990637]},
 "Info3384169895-8612076"->{
  Cell[31540, 959, 173, 4, 70, "Print",
   CellTags->{"b:1.4.2", "Info3384169895-8612076"},
   CellID->598335664]},
 "b:1.4.3"->{
  Cell[32098, 984, 66, 2, 70, "Section",
   CellTags->"b:1.4.3",
   CellID->10285],
  Cell[32167, 988, 235, 7, 70, "Text",
   CellTags->"b:1.4.3",
   CellID->27088]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:1.4.1", 37191, 1106},
 {"b:1.4.2", 38468, 1152},
 {"Info3384169895-8612076", 40900, 1237},
 {"b:1.4.3", 41030, 1241}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1216, 28, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1841, 55, 47, 1, 70, "Title",
 CellID->7958],
Cell[CellGroupData[{
Cell[1913, 60, 55, 1, 70, "Section",
 CellID->6191],
Cell[1971, 63, 840, 19, 70, "Text",
 CellTags->"b:1.4.1",
 CellID->19815],
Cell[2814, 84, 139, 4, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->22888],
Cell[CellGroupData[{
Cell[2978, 92, 236, 6, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->19156],
Cell[3217, 100, 317, 8, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->51350147]
}, Open  ]],
Cell[CellGroupData[{
Cell[3571, 113, 243, 7, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->16202],
Cell[3817, 122, 2193, 60, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->282642575]
}, Open  ]],
Cell[6025, 185, 1041, 23, 70, "Text",
 CellTags->"b:1.4.1",
 CellID->24272],
Cell[CellGroupData[{
Cell[7091, 212, 207, 6, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->20055],
Cell[7301, 220, 1883, 52, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->321079653]
}, Open  ]],
Cell[9199, 275, 1020, 25, 70, "Text",
 CellTags->"b:1.4.1",
 CellID->22646],
Cell[CellGroupData[{
Cell[10244, 304, 251, 7, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->26362],
Cell[10498, 313, 1882, 52, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->81979719]
}, Open  ]],
Cell[12395, 368, 700, 20, 70, "Text",
 CellTags->"b:1.4.1",
 CellID->18875],
Cell[CellGroupData[{
Cell[13120, 392, 206, 6, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->28433],
Cell[13329, 400, 128, 3, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->71252234]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13506, 409, 79, 2, 70, "Section",
 CellTags->"b:1.4.2",
 CellID->20142],
Cell[13588, 413, 526, 14, 70, "Text",
 CellTags->"b:1.4.2",
 CellID->23844],
Cell[14117, 429, 692, 19, 70, "Text",
 CellTags->"b:1.4.2",
 CellID->1416],
Cell[14812, 450, 139, 4, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->21881],
Cell[CellGroupData[{
Cell[14976, 458, 477, 12, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->31998],
Cell[15456, 472, 150, 4, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->93495576]
}, Open  ]],
Cell[15621, 479, 498, 12, 70, "Text",
 CellTags->"b:1.4.2",
 CellID->18651],
Cell[CellGroupData[{
Cell[16144, 495, 403, 12, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->10021],
Cell[16550, 509, 2192, 60, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->45665699]
}, Open  ]],
Cell[18757, 572, 752, 17, 70, "Text",
 CellTags->"b:1.4.2",
 CellID->3557],
Cell[CellGroupData[{
Cell[19534, 593, 748, 19, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->28476],
Cell[20285, 614, 2577, 69, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->262395889]
}, Open  ]],
Cell[22877, 686, 1673, 49, 70, "Text",
 CellTags->"b:1.4.2",
 CellID->24389],
Cell[CellGroupData[{
Cell[24575, 739, 310, 8, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->5075],
Cell[24888, 749, 1883, 52, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->481681480]
}, Open  ]],
Cell[26786, 804, 924, 28, 70, "Text",
 CellTags->"b:1.4.2",
 CellID->2600],
Cell[CellGroupData[{
Cell[27735, 836, 446, 11, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->2510],
Cell[28184, 849, 161, 4, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->198244508]
}, Open  ]],
Cell[CellGroupData[{
Cell[28382, 858, 256, 7, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->26869],
Cell[28641, 867, 129, 3, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->342386383]
}, Open  ]],
Cell[28785, 873, 1318, 36, 70, "Text",
 CellTags->"b:1.4.2",
 CellID->14688],
Cell[CellGroupData[{
Cell[30128, 913, 875, 20, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->13401],
Cell[31006, 935, 129, 3, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->646352002]
}, Open  ]],
Cell[31150, 941, 221, 8, 70, "Text",
 CellTags->"b:1.4.2",
 CellID->15255],
Cell[CellGroupData[{
Cell[31396, 953, 141, 4, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->16423],
Cell[31540, 959, 173, 4, 70, "Print",
 CellTags->{"b:1.4.2", "Info3384169895-8612076"},
 CellID->598335664]
}, Open  ]],
Cell[CellGroupData[{
Cell[31750, 968, 167, 5, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->10585],
Cell[31920, 975, 129, 3, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->513990637]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32098, 984, 66, 2, 70, "Section",
 CellTags->"b:1.4.3",
 CellID->10285],
Cell[32167, 988, 235, 7, 70, "Text",
 CellTags->"b:1.4.3",
 CellID->27088],
Cell[32405, 997, 1628, 44, 70, "DefinitionBox",
 CellID->119200707],
Cell[34036, 1043, 57, 1, 70, "Caption",
 CellID->731545154]
}, Open  ]]
}, Open  ]],
Cell[34120, 1048, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

