(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     96059,       3323]
NotebookOptionsPosition[     57378,       1963]
NotebookOutlinePosition[     78928,       2648]
CellTagsIndexPosition[     77635,       2610]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Basic Examples", "Title",
 CellID->9741],

Cell[CellGroupData[{

Cell["DataTypes: Echo", "Section",
 CellID->27529],

Cell["\<\
Often a web service requires using data other than a simple string. This data \
could be something simple like an integer or a real. Often the data is more \
complex and is a combination of simple data types. This example demonstrates \
how to use different data types.\
\>", "Text",
 CellID->778],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellLabel->"In[1]:=",
 CellID->12316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Echo.m?wsdl\>\
\"", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[2]:=",
 CellID->3035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "EchoBase64Binary", ",", "EchoBoolean", ",", "EchoDate", ",", 
   "EchoDateTime", ",", "EchoDatum", ",", "EchoDatumArray", ",", 
   "EchoExpression", ",", "EchoInteger", ",", "EchoIntegerArray", ",", 
   "EchoMathML", ",", "EchoReal", ",", "EchoString", ",", "EchoTime"}], 
  "}"}]], "Output", "ConversionLockdown",
 CellLabel->"Out[2]=",
 CellID->72701709]
}, Open  ]],

Cell["\<\
For each of the examples, the usage message may be used to determine the data \
types used by a web service.\
\>", "Text",
 CellID->288],

Cell[CellGroupData[{

Cell["Simple Data Types", "Subsection",
 CellTags->"b:1.3.1.1",
 CellID->30106],

Cell[TextData[{
 "Simple data types are the easiest data types to use in ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users should be familiar with the symbols ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". Each of these may be used with a web service function."
}], "Text",
 CellTags->"b:1.3.1.1",
 CellID->9040],

Cell[TextData[{
 "Here is an example of using ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " with a web service."
}], "Text",
 CellTags->"b:1.3.1.1",
 CellID->8942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "EchoBoolean"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"In[3]:=",
 CellID->19264],

Cell[BoxData[
 StyleBox["\<\"(True | False) EchoBoolean[bool:(True | False)]\\n\\nEchos \
True or False\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.1", "Info3384166734-3649653"},
 CellID->20668706]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoBoolean", "[", "True", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"In[4]:=",
 CellID->27446],

Cell[BoxData["True"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"Out[4]=",
 CellID->569709683]
}, Open  ]],

Cell[TextData[{
 "Here is an example of using ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 " with a web service."
}], "Text",
 CellTags->"b:1.3.1.1",
 CellID->15890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "EchoString"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"In[5]:=",
 CellID->6729],

Cell[BoxData[
 StyleBox["\<\"String EchoString[str_String]\\n\\nEchos a String.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.1", "Info3384166739-6453784"},
 CellID->339841411]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoString", "[", "\"\<Hello.\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"In[6]:=",
 CellID->15350],

Cell[BoxData["\<\"Hello.\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"Out[6]=",
 CellID->600919964]
}, Open  ]],

Cell[TextData[{
 "Here is an example of using ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 " with a web service."
}], "Text",
 CellTags->"b:1.3.1.1",
 CellID->31101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "EchoInteger"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"In[7]:=",
 CellID->24393],

Cell[BoxData[
 StyleBox["\<\"Integer EchoInteger[int_Integer]\\n\\nEchos an Integer.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.1", "Info3384166743-7463781"},
 CellID->203715183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoInteger", "[", "13", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"In[8]:=",
 CellID->19629],

Cell[BoxData["13"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"Out[8]=",
 CellID->8351290]
}, Open  ]],

Cell[TextData[{
 "Here is an example of using ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " with a web service."
}], "Text",
 CellTags->"b:1.3.1.1",
 CellID->24084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "EchoReal"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"In[9]:=",
 CellID->19954],

Cell[BoxData[
 StyleBox["\<\"Real EchoReal[real_Real]\\n\\nEchos a Real.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.1", "Info3384166746-7470668"},
 CellID->100067754]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoReal", "[", "2.3333", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"In[10]:=",
 CellID->11840],

Cell[BoxData["2.3333`"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.1.1",
 CellLabel->"Out[10]=",
 CellID->295651900]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Non-Standard Simple Data Types", "Subsection",
 CellTags->"b:1.3.1.2",
 CellID->7376],

Cell[TextData[{
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " provides some data types that may be mapped to the XML Schema of a web \
service. ",
 Cell[BoxData["SchemaDate"], "InlineFormula"],
 ", ",
 Cell[BoxData["SchemaTime"], "InlineFormula"],
 ", ",
 Cell[BoxData["SchemaDateTime"], "InlineFormula"],
 ", ",
 Cell[BoxData["SchemaExpr"], "InlineFormula"],
 ", ",
 Cell[BoxData["SchemaMathML"], "InlineFormula"],
 ", and ",
 Cell[BoxData["SchemaBase64Binary"], "InlineFormula"],
 " are each simple data types that may be used with a web service."
}], "Text",
 CellTags->"b:1.3.1.2",
 CellID->13931],

Cell[TextData[{
 "Here is an example of using ",
 Cell[BoxData["SchemaDate"], "InlineFormula"],
 " with a web service."
}], "Text",
 CellTags->"b:1.3.1.2",
 CellID->26308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "EchoDate"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"In[11]:=",
 CellID->16944],

Cell[BoxData[
 StyleBox["\<\"SchemaDate EchoDate[d_SchemaDate]\\n\\nEchos a date.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.2", "Info3384166760-1720084"},
 CellID->2887067]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SchemaDate"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"In[12]:=",
 CellID->24626],

Cell[BoxData[
 StyleBox["\<\"SchemaDate[year_Integer, month_Integer, day_Integer] \
represents a date that may be used with XMLSchema.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->{"b:1.3.1.2", "Info3384166762-5083763"},
 CellID->37153882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoDate", "[", 
  RowBox[{"SchemaDate", "[", 
   RowBox[{"2005", ",", "7", ",", "4"}], "]"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"In[13]:=",
 CellID->5537],

Cell[BoxData[
 RowBox[{"SchemaDate", "[", 
  RowBox[{"2005", ",", "7", ",", "4"}], "]"}]], "Output", \
"ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"Out[13]=",
 CellID->780638570]
}, Open  ]],

Cell[TextData[{
 "Here is an example of using ",
 Cell[BoxData["SchemaTime"], "InlineFormula"],
 " with a web service."
}], "Text",
 CellTags->"b:1.3.1.2",
 CellID->16118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "EchoTime"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"In[14]:=",
 CellID->2082],

Cell[BoxData[
 StyleBox["\<\"SchemaTime EchoTime[t_SchemaTime]\\n\\nEchos a time.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.2", "Info3384166766-2524988"},
 CellID->61585654]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SchemaTime"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"In[15]:=",
 CellID->16541],

Cell[BoxData[
 StyleBox["\<\"SchemaDateTime[hour_Integer, minute_Integer, second_Real] \
represents a time that may be used with XMLSchema.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->{"b:1.3.1.2", "Info3384166768-4481433"},
 CellID->307981648]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoTime", "[", 
  RowBox[{"SchemaTime", "[", 
   RowBox[{"5", ",", "0", ",", "0."}], "]"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"In[16]:=",
 CellID->31115],

Cell[BoxData[
 RowBox[{"SchemaTime", "[", 
  RowBox[{"5", ",", "0", ",", "0"}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"Out[16]=",
 CellID->798062808]
}, Open  ]],

Cell[TextData[{
 "Here is an example of using ",
 Cell[BoxData["SchemaDateTime"], "InlineFormula"],
 " with a web service."
}], "Text",
 CellTags->"b:1.3.1.2",
 CellID->29658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "EchoDateTime"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"In[17]:=",
 CellID->22704],

Cell[BoxData[
 StyleBox["\<\"SchemaDateTime EchoDateTime[dt_SchemaDateTime]\\n\\nEchos a \
date time.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.2", "Info3384166773-2807980"},
 CellID->118561596]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SchemaDateTime"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"In[18]:=",
 CellID->13977],

Cell[BoxData[
 StyleBox["\<\"SchemaDateTime[year_Integer, month_Integer, day_Integer, \
hour_Integer, minute_Integer, second_Real] represents a dateTime that may be \
used with XMLSchema.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.2", "Info3384166774-7971642"},
 CellID->116735973]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoDateTime", "[", 
  RowBox[{"SchemaDateTime", "@@", 
   RowBox[{"Date", "[", "]"}]}], "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"In[19]:=",
 CellID->31673],

Cell[BoxData[
 RowBox[{"SchemaDateTime", "[", 
  RowBox[{
  "2007", ",", "3", ",", "29", ",", "14", ",", "19", ",", "36.950069`"}], 
  "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.1.2",
 CellLabel->"Out[19]=",
 CellID->133114824]
}, Open  ]],

Cell[TextData[{
 "Examples of ",
 Cell[BoxData["SchemaExpr"], "InlineFormula"],
 ", ",
 Cell[BoxData["SchemaMathML"], "InlineFormula"],
 ", and ",
 Cell[BoxData["SchemaBase64Binary"], "InlineFormula"],
 " follow in the next section."
}], "Text",
 CellTags->"b:1.3.1.2",
 CellID->5021]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compound Data Types", "Subsection",
 CellTags->"b:1.3.1.3",
 CellID->28745],

Cell[TextData[{
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " generates symbols that are used to build compound data types. Compound \
data types are ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions that contain instances of simple data types and/or compound \
data types. Compound data types are created in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using a symbol representing the data type as the head of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression.",
 " ",
 "The members of the data type are represented using rules in the body of the \
expression. The left-hand side of the rule specifies the name of a member of \
the data type. The right-hand side specifies the value of the member. The \
value may be a simple or compound value."
}], "Text",
 CellTags->"b:1.3.1.3",
 CellID->26924],

Cell["\<\
Here is an example of a web service that uses a compound data type.\
\>", "Text",
 CellTags->"b:1.3.1.3",
 CellID->19072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "EchoDatum"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.3",
 CellLabel->"In[20]:=",
 CellID->6270],

Cell[BoxData[
 StyleBox["\<\"Datum EchoDatum[d_Datum]\\n\\nEchos a datum.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.3", "Info3384167126-8240469"},
 CellID->353041394]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Datum"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.3",
 CellLabel->"In[21]:=",
 CellID->26777],

Cell[BoxData[
 StyleBox["\<\"TYPE PROPERTIES\\nName      Datum\\nNamespace \
http://localhost:8080/webMathematica/Examples/WebServices/Echo.m\\nGlobal    \
True\\nArray     False\\n\\nTYPE ELEMENTS\\nName  Type    MinOccurs MaxOccurs \
Default Fixed Symbol\\nvalue Integer 1         1         Null    Null  \
value$488\\ntext  String  1         1         Null    Null  text$493\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.3", "Info3384167128-9039531"},
 CellID->560281400]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["NewSchemaInstance"], "InlineFormula"],
 " may be used to generate an instance of ",
 Cell[BoxData["Datum"], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:1.3.1.3",
 CellID->5097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"datum", " ", "=", " ", 
  RowBox[{"NewSchemaInstance", "[", 
   RowBox[{"Datum", ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<value\>\"", "\[Rule]", 
       RowBox[{"5", "!"}]}], ",", " ", 
      RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Hello!\>\""}]}], "}"}]}], 
   "]"}]}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.3",
 CellLabel->"In[22]:=",
 CellID->16512],

Cell[BoxData[
 RowBox[{"Datum", "[", 
  RowBox[{
   RowBox[{"\<\"value\"\>", "\[Rule]", "120"}], ",", 
   RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Hello!\"\>"}]}], "]"}]], "Output", \
"ConversionLockdown",
 CellTags->"b:1.3.1.3",
 CellLabel->"Out[22]=",
 CellID->7654136]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoDatum", "[", "datum", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.3",
 CellLabel->"In[23]:=",
 CellID->13290],

Cell[BoxData[
 RowBox[{"Datum", "[", 
  RowBox[{
   RowBox[{"\<\"value\"\>", "\[Rule]", "120"}], ",", 
   RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Hello!\"\>"}]}], "]"}]], "Output", \
"ConversionLockdown",
 CellTags->"b:1.3.1.3",
 CellLabel->"Out[23]=",
 CellID->216467156]
}, Open  ]],

Cell["\<\
Here is an example of how to retrieve data from a compound data type.\
\>", "Text",
 CellTags->"b:1.3.1.3",
 CellID->18636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"datum", "[", "\"\<value\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.3",
 CellLabel->"In[24]:=",
 CellID->22355],

Cell[BoxData["120"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.1.3",
 CellLabel->"Out[24]=",
 CellID->8445004]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["ReplaceSchemaInstanceValue"], "InlineFormula"],
 " may be used to set a value for a compound data type."
}], "Text",
 CellTags->"b:1.3.1.3",
 CellID->23655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceSchemaInstanceValue", "[", 
  RowBox[{"datum", ",", " ", 
   RowBox[{"\"\<value\>\"", "\[Rule]", 
    RowBox[{"6", "!"}]}]}], "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.3",
 CellLabel->"In[25]:=",
 CellID->15574],

Cell[BoxData[
 RowBox[{"Datum", "[", 
  RowBox[{
   RowBox[{"\<\"value\"\>", "\[Rule]", "720"}], ",", 
   RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Hello!\"\>"}]}], "]"}]], "Output", \
"ConversionLockdown",
 CellTags->"b:1.3.1.3",
 CellLabel->"Out[25]=",
 CellID->117754405]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arrays", "Subsection",
 CellTags->"b:1.3.1.4",
 CellID->12052],

Cell[TextData[{
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " supports arrays using ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". To use an array, you need only to use a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " consisting entirely of the data type defined by the array."
}], "Text",
 CellTags->"b:1.3.1.4",
 CellID->27350],

Cell["\<\
Here is an example of a web service that uses an array of simple data types.\
\>", "Text",
 CellTags->"b:1.3.1.4",
 CellID->1150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "EchoIntegerArray"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.4",
 CellLabel->"In[26]:=",
 CellID->16941],

Cell[BoxData[
 StyleBox["\<\"{___Integer} \
EchoIntegerArray[array:{___Integer}]\\\\n\\\\nEchos an integer array.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->{"b:1.3.1.4", "Info3384167157-1802425"},
 CellID->368327798]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoIntegerArray", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.1.4",
 CellLabel->"In[27]:=",
 CellID->13966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.1.4",
 CellLabel->"Out[27]=",
 CellID->438245499]
}, Open  ]],

Cell["\<\
Here is an example of a web service that uses an array of compound data \
types.\
\>", "Text",
 CellTags->"b:1.3.1.4",
 CellID->31107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "EchoDatumArray"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.4",
 CellLabel->"In[28]:=",
 CellID->30191],

Cell[BoxData[
 StyleBox["\<\"{___Datum} EchoDatumArray[array:{___Datum}]\\n\\nEchos a datum \
array\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.1.4", "Info3384167159-5445807"},
 CellID->235763305]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"datum", " ", "=", " ", 
  RowBox[{"NewSchemaInstance", "[", 
   RowBox[{"Datum", ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<value\>\"", "\[Rule]", 
       RowBox[{"5", "!"}]}], ",", " ", 
      RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Hello!\>\""}]}], "}"}]}], 
   "]"}]}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.1.4",
 CellLabel->"In[29]:=",
 CellID->11337],

Cell[BoxData[
 RowBox[{"Datum", "[", 
  RowBox[{
   RowBox[{"\<\"value\"\>", "\[Rule]", "120"}], ",", 
   RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Hello!\"\>"}]}], "]"}]], "Output", \
"ConversionLockdown",
 CellTags->"b:1.3.1.4",
 CellLabel->"Out[29]=",
 CellID->277924982]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoDatumArray", "[", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ReplaceSchemaInstanceValue", "[", 
     RowBox[{"datum", ",", " ", 
      RowBox[{"\"\<value\>\"", "\[Rule]", 
       RowBox[{"7", "!"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ReplaceSchemaInstanceValue", "[", 
     RowBox[{"datum", ",", " ", 
      RowBox[{"\"\<value\>\"", "\[Rule]", 
       RowBox[{"8", "!"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ReplaceSchemaInstanceValue", "[", 
     RowBox[{"datum", ",", " ", 
      RowBox[{"\"\<value\>\"", "\[Rule]", 
       RowBox[{"9", "!"}]}]}], "]"}]}], "}"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.1.4",
 CellLabel->"In[30]:=",
 CellID->12287],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Datum", "[", 
    RowBox[{
     RowBox[{"\<\"value\"\>", "\[Rule]", "5040"}], ",", 
     RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Hello!\"\>"}]}], "]"}], ",", 
   RowBox[{"Datum", "[", 
    RowBox[{
     RowBox[{"\<\"value\"\>", "\[Rule]", "40320"}], ",", 
     RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Hello!\"\>"}]}], "]"}], ",", 
   RowBox[{"Datum", "[", 
    RowBox[{
     RowBox[{"\<\"value\"\>", "\[Rule]", "362880"}], ",", 
     RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Hello!\"\>"}]}], "]"}]}], 
  "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.1.4",
 CellLabel->"Out[30]=",
 CellID->184471997]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Images: Plot", "Section",
 CellTags->"b:1.3.2",
 CellID->10383],

Cell["\<\
Strings are a natural way to transmit graphics within web services. In order \
to ensure its integrity, binary data is encoded in base64. This example \
demonstrates how to use binary data types.\
\>", "Text",
 CellTags->"b:1.3.2",
 CellID->14945],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.2",
 CellLabel->"In[1]:=",
 CellID->8909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Plot.m?wsdl\>\
\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.2",
 CellLabel->"In[2]:=",
 CellID->32209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PlotExpression", ",", "PlotString"}], "}"}]], "Output", \
"ConversionLockdown",
 CellTags->"b:1.3.2",
 CellLabel->"Out[2]=",
 CellID->644280174]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PlotString"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.2",
 CellLabel->"In[3]:=",
 CellID->24221],

Cell[BoxData[
 StyleBox["\<\"SchemaBase64Binary \
PlotString[expr_String,limit_Integer]\\n\\nPlots a function of x from 0 to a \
limit. The function is passed in as an InputForm string and the result is a \
GIF.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.2", "Info3384167277-9567975"},
 CellID->49307453]
}, Open  ]],

Cell[TextData[{
 "In the ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " example, ",
 Cell[BoxData[
  ButtonBox["PlotString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InstallService#454620743"]], "InlineFormula"],
 " takes a string and an integer as parameters and returns a base64 binary \
string. The function converts the string into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression and then plots this as a function of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " from 0 to a limit specified by the integer. The service returns a list of \
base64 binary bytes wrapped in a head of ",
 Cell[BoxData["SchemaBase64Binary"], "InlineFormula"],
 ". This head is used to identify this data as base64 binary. ",
 Cell[BoxData[
  ButtonBox["FromCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFormula"],
 " can be used to decode the base64 binary data into a string consisting of \
GIF data. This string may be imported to a GIF with ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"b:1.3.2",
 CellID->6422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
   RowBox[{"FromCharacterCode", "[", 
    RowBox[{"First", "[", 
     RowBox[{"PlotString", "[", 
      RowBox[{"\"\<Sin[x]\>\"", ",", " ", "10"}], "]"}], "]"}], "]"}], ",", 
   " ", "\"\<GIF\>\""}], "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.2",
 CellLabel->"In[4]:=",
 CellID->24946],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztXd162jgQjbslgEMIJSRNaEgwj7SP0Ku929fdx9kQwNjGskbzr13O9227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   "], {{0, 0}, {360, 216}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJzt00tKm3EUxuFQXEBBKLbiwB0IolIovG5BUZS2OhAcC6VKQXAPVq1JbE23
UKlUvO7AVk1MjJfmHnPxhqWlrRF73nz/c0ZShw7yQDiE3+T7zkmah0a6hx/4
fL7Of5863/+c42NIfEVoXmyildJwvYu2sPWNMD0lrO9sE7ppGz8uhfUeCiO8
Q3hNGe27EUIvRRAJC+t9FEV0l9BGWe17MULAL2J4NyOsP6c4nlAcjyin/WCf
8H5O7GOMrA/QIZro0HsO69+PyNvfEToor72FEnhICfhnhfWLc5Hw9ptAAx1r
X/gkkng7KZJ4Q9ZfUcrbf8rbh3V3z3pK4ykVtLt7Ve+TRjAgrC9+FhnMTIsM
/vwW1kcp690v6+27qL2dcrr3lWVh/ddPkdO9NlJJ+9IXkde9Ve9k3e2jn45x
9VdYd+/7mAp4SWXt7n3ie6KAtVVh3T3vXFAUvd/BifZxKuEFlTD/QVh/RmWd
1xVhvXIlyjoH6VT7+po40bmxLqxP0KnOqjPt7rub1f+79bvN29R6rdf6fe43
Zs/xJg==
      "], #]]& ),
   ColorFunctionScaling->False],
  Background->None,
  ImageSize->{360, 216},
  PlotRange->{{0, 360}, {0, 216}}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.2",
 CellLabel->"Out[4]=",
 CellID->117676709]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical Data: Integrate", "Section",
 CellID->16413],

Cell[TextData[{
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " supports mathematical data using strings, typeset images, MathML, or ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "expressions. This example demonstrates using mathematical data."
}], "Text",
 CellID->29168],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellLabel->"In[1]:=",
 CellID->900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m?\
wsdl\>\"", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[2]:=",
 CellID->32591],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "IntegrateExpression", ",", "IntegrateExpressionToGIF", ",", 
   "IntegrateMathML", ",", "IntegrateMathMLToGIF", ",", "IntegrateString", 
   ",", "IntegrateStringToGIF"}], "}"}]], "Output", "ConversionLockdown",
 CellLabel->"Out[2]=",
 CellID->95719984]
}, Open  ]],

Cell[CellGroupData[{

Cell["Strings", "Subsection",
 CellTags->"b:1.3.3.1",
 CellID->1655],

Cell[TextData[{
 "Mathematical data can be used with a web service by using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions within a string. The string data type has some limitations for \
communicating mathematical data. For one, it is one-dimensional. If you use \
",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " to represent the data, information about its presentation may be left out. \
It is also worth noting that while all web services support strings, they may \
not all support parsing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions from a string. However, sending a string to web service is \
probably the simplest way to communicate mathematical data, if not the most \
advanced."
}], "Text",
 CellTags->"b:1.3.3.1",
 CellID->17410],

Cell["\<\
This example demonstrates using strings to communicate mathematical data. \
\>", "Text", "ConversionLockdown",
 CellTags->"b:1.3.3.1",
 CellID->6359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "IntegrateString"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.3.1",
 CellLabel->"In[3]:=",
 CellID->27624],

Cell[BoxData[
 StyleBox["\<\"String IntegrateString[str_String]\\n\\nIntegrates an equation \
with respect to x. The function is passed in as an InputForm string and the \
result is an InputForm string.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.3.1", "Info3384167352-8864364"},
 CellID->715432717]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", " ", "=", " ", 
  RowBox[{"IntegrateString", "[", "\"\<Sin[x]\>\"", "]"}]}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.3.1",
 CellLabel->"In[4]:=",
 CellID->21548],

Cell[BoxData["\<\"-Cos[x]\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.3.1",
 CellLabel->"Out[4]=",
 CellID->255790239]
}, Open  ]],

Cell[TextData[{
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " does not take a string and automatically convert it into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. This is because all strings are not necessarily ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions."
}], "Text", "ConversionLockdown",
 CellTags->"b:1.3.3.1",
 CellID->27595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", " ", "//", "InputForm"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.3.1",
 CellLabel->"In[5]:=",
 CellID->4041],

Cell["\"-Cos[x]\"", "Output", "ConversionLockdown",
 CellTags->"b:1.3.3.1",
 CellLabel->"Out[5]//InputForm=",
 CellID->91017436]
}, Open  ]],

Cell[TextData[{
 "But because this is ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " the result can easily be turned into an expression."
}], "Text", "ConversionLockdown",
 CellTags->"b:1.3.3.1",
 CellID->24350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", " ", "=", " ", 
  RowBox[{"ToExpression", "[", "result", "]"}]}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.3.1",
 CellLabel->"In[6]:=",
 CellID->10291],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.3.1",
 CellLabel->"Out[6]=",
 CellID->252258319]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Typeset Images", "Subsection",
 CellTags->"b:1.3.3.2",
 CellID->9374],

Cell["\<\
Mathematical data can be presented with a web service by using images. An \
image has one major limitation for communicating mathematical data. An image \
cannot be easily manipulated or processed. This means data cannot be easily \
taken from it except visually and it cannot be changed and updated easily. \
Images are often useful, however, because typeset equations are not supported \
on nearly as many systems as images. So generating an image of a typeset \
equation is a nice way to present typeset equations on systems that do not \
support them.\
\>", "Text",
 CellTags->"b:1.3.3.2",
 CellID->11020],

Cell[TextData[{
 "The following example demonstrates using images to communicate mathematical \
data. The service returns a list base64 binary bytes wrapped in a head of ",
 Cell[BoxData["SchemaBase64Binary"], "InlineFormula"],
 ". This head is used to identify this data as base64 binary. ",
 Cell[BoxData[
  ButtonBox["FromCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFormula"],
 " can be used to decode the base64 binary data into a string consisting of \
GIF data. This string may be imported to a GIF with ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:1.3.3.2",
 CellID->4596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "IntegrateStringToGIF"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.3.2",
 CellLabel->"In[7]:=",
 CellID->24021],

Cell[BoxData[
 StyleBox["\<\"SchemaBase64Binary \
IntegrateStringToGIF[str_String]\\n\\nIntegrates an equation with respect to \
x. The function is passed in as an InputForm string and the result is a \
GIF.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.3.2", "Info3384167482-4356473"},
 CellID->233108318]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
   RowBox[{"FromCharacterCode", "[", 
    RowBox[{"First", "[", 
     RowBox[{"IntegrateStringToGIF", "[", "\"\<x^2\>\"", "]"}], "]"}], "]"}], 
   ",", " ", "\"\<GIF\>\""}], "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.3.2",
 CellLabel->"In[8]:=",
 CellID->23199],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4,
    4, 4, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 1, 4, 4, 4, 1, 4, 
   4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 4, 4}, {4,
    4, 4, 4, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 1, 
   1, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 
   4, 4}, {4, 4, 4, 4, 4, 1, 4, 4, 4, 1, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4,
    4, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
   4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 
   4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 
   4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
   4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
   4, 4, 4, 4, 4, 4, 4}, {4, 4, 1, 1, 4, 4, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 
   4}, {4, 4, 4, 1, 4, 4, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 1, 1,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 1, 1, 4, 4, 4, 4, 4, 4, 4, 
   4, 4, 4, 4}, {4, 4, 4, 1, 4, 4, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 1,
    1, 4, 4, 1, 1, 4, 4, 1, 1, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
   4, 4, 1, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 
   4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 1, 4, 1, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 4, 
   4, 4, 4, 4}}, {{0, 0}, {17, 31}},
   ColorFunction->(Apply[RGBColor, 
     Part[{{0., 0., 0., 1.}, {0.25098039215686274`, 0.25098039215686274`, 
      0.25098039215686274`, 1.}, {0.7490196078431373, 0.7490196078431373, 
      0.7490196078431373, 1.}, {1., 1., 1., 1.}}, #]]& ),
   ColorFunctionScaling->False],
  Background->None,
  ImageSize->{17, 31},
  PlotRange->{{0, 17}, {0, 31}}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.3.2",
 CellLabel->"Out[8]=",
 CellID->257144274]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Expression"
}], "Subsection",
 CellTags->"b:1.3.3.3",
 CellID->8281],

Cell[TextData[{
 "Mathematical data can be presented with a web service by using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. Expressions are how data is represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Expressions address some of the limitations of strings and images. \
However, expressions do have a few limitations of their own, the biggest \
being that they are not supported on all systems. However, since expressions \
are the standard for using mathematical data with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", they can be very useful for interfacing with other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " systems."
}], "Text",
 CellTags->"b:1.3.3.3",
 CellID->4734],

Cell[TextData[{
 "The following example demonstrates using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions to communicate mathematical data. The service returns an \
expression wrapped in a head of ",
 Cell[BoxData["SchemaExpr"], "InlineFormula"],
 ". This head is used to identify the following data as an expression."
}], "Text",
 CellTags->"b:1.3.3.3",
 CellID->53],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "IntegrateExpression"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.3.3",
 CellLabel->"In[9]:=",
 CellID->1999],

Cell[BoxData[
 StyleBox["\<\"SchemaExpr \
IntegrateExpression[expr_SchemaExpr]\\n\\nIntegrates an equation with respect \
to x. The function is passed in as an InputForm Expression and the result is \
an InputForm Expression.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.3.3", "Info3384167520-1349916"},
 CellID->380846584]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegrateExpression", "[", 
  RowBox[{"SchemaExpr", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.3.3",
 CellLabel->"In[10]:=",
 CellID->27938],

Cell[BoxData[
 RowBox[{"SchemaExpr", "[", 
  RowBox[{"-", 
   RowBox[{"Cos", "[", "x", "]"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.3.3",
 CellLabel->"Out[10]=",
 CellID->372349811]
}, Open  ]],

Cell[TextData[{
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " encodes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions as ExpressionML within web services messages. The ExpressionML \
is automatically converted into an expression."
}], "Text",
 CellTags->"b:1.3.3.3",
 CellID->3788]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathML", "Subsection",
 CellTags->"b:1.3.3.4",
 CellID->18127],

Cell[TextData[{
 "Mathematical data can be presented with a web service by using MathML. \
MathML is the standard for representing mathematical data across systems. \
MathML addresses some of the limitations that strings and images have. \
However, MathML does have a few limitations of its own, the biggest being \
that it is not supported on all systems. Another limitation is its \
complexity. MathML is more difficult to look at than something like ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". However, since it is the standard for using mathematical data outside of \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it can be very useful for interfacing with other systems that do not use \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:1.3.3.4",
 CellID->467],

Cell[TextData[{
 "This example demonstrates using MathML to communicate mathematical data. \
The service returns symbolic MathML wrapped in a head of ",
 Cell[BoxData["SchemaMathML"], "InlineFormula"],
 ", which is used to identify the data as MathML."
}], "Text",
 CellTags->"b:1.3.3.4",
 CellID->3728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "IntegrateMathML"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.3.4",
 CellLabel->"In[11]:=",
 CellID->14893],

Cell[BoxData[
 StyleBox["\<\"SchemaMathML \
IntegrateMathML[mathml_SchemaMathML]\\n\\nIntegrates an equation with respect \
to x. The function is passed in as an MathML and the result is MathML.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.3.4", "Info3384167561-4916499"},
 CellID->97844372]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", " ", "=", " ", 
  RowBox[{"IntegrateMathML", "[", 
   RowBox[{"SchemaMathML", "[", 
    RowBox[{"XML`MathML`ExpressionToSymbolicMathML", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}], "]"}], "]"}]}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.3.4",
 CellLabel->"In[12]:=",
 CellID->22483],

Cell[BoxData[
 RowBox[{"SchemaMathML", "[", 
  RowBox[{"XMLElement", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"http://www.w3.org/1998/Math/MathML\"\>", 
      ",", "\<\"math\"\>"}], "}"}], ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"XMLElement", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"http://www.w3.org/1998/Math/MathML\"\>", 
         ",", "\<\"mrow\"\>"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          
          RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
           ",", "\<\"ns0\"\>"}], "}"}], 
         "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"http://www.w3.org/1998/Math/MathML\"\>", 
             ",", "\<\"mo\"\>"}], "}"}], ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"{", "\<\"-\"\>", "}"}]}], "]"}], ",", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"http://www.w3.org/1998/Math/MathML\"\>", 
             ",", "\<\"mrow\"\>"}], "}"}], ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"XMLElement", "[", 
              RowBox[{
               RowBox[{"{", 
                
                RowBox[{"\<\"http://www.w3.org/1998/Math/MathML\"\>", 
                 ",", "\<\"mi\"\>"}], "}"}], ",", 
               RowBox[{"{", "}"}], ",", 
               RowBox[{"{", "\<\"cos\"\>", "}"}]}], "]"}], ",", 
             RowBox[{"XMLElement", "[", 
              RowBox[{
               RowBox[{"{", 
                
                RowBox[{"\<\"http://www.w3.org/1998/Math/MathML\"\>", 
                 ",", "\<\"mo\"\>"}], "}"}], ",", 
               RowBox[{"{", "}"}], ",", 
               RowBox[{"{", "\<\"\[InvisibleApplication]\"\>", "}"}]}], "]"}],
              ",", 
             RowBox[{"XMLElement", "[", 
              RowBox[{
               RowBox[{"{", 
                
                RowBox[{"\<\"http://www.w3.org/1998/Math/MathML\"\>", 
                 ",", "\<\"mo\"\>"}], "}"}], ",", 
               RowBox[{"{", "}"}], ",", 
               RowBox[{"{", "\<\"(\"\>", "}"}]}], "]"}], ",", 
             RowBox[{"XMLElement", "[", 
              RowBox[{
               RowBox[{"{", 
                
                RowBox[{"\<\"http://www.w3.org/1998/Math/MathML\"\>", 
                 ",", "\<\"mi\"\>"}], "}"}], ",", 
               RowBox[{"{", "}"}], ",", 
               RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
             RowBox[{"XMLElement", "[", 
              RowBox[{
               RowBox[{"{", 
                
                RowBox[{"\<\"http://www.w3.org/1998/Math/MathML\"\>", 
                 ",", "\<\"mo\"\>"}], "}"}], ",", 
               RowBox[{"{", "}"}], ",", 
               RowBox[{"{", "\<\")\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}]}], 
        "}"}]}], "]"}], "}"}]}], "]"}], "]"}]], "Output", \
"ConversionLockdown",
 CellTags->"b:1.3.3.4",
 CellLabel->"Out[12]=",
 CellID->46815542]
}, Open  ]],

Cell[TextData[{
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " does not take a MathML expression and automatically convert it into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, because not all MathML instances are necessarily supported by \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. But because this is ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " the result can easily be turned into an expression."
}], "Text",
 CellTags->"b:1.3.3.4",
 CellID->2421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`MathML`SymbolicMathMLToExpression", "[", 
  RowBox[{"First", "[", "result", "]"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.3.4",
 CellLabel->"In[13]:=",
 CellID->14310],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.3.4",
 CellLabel->"Out[13]=",
 CellID->676012798]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SOAP Headers", "Section",
 CellTags->"b:1.3.4",
 CellID->22813],

Cell["\<\
SOAP headers are an important component to web services because they allow \
web services to process metadata separate from the body of a SOAP message. \
The body will contain information directly related to the web service \
operation being invoked. However, a header may contain more general content \
that is used across any number of the web service operations. For example, a \
header may contain a username and password. It is useful to include the \
username and password as a header, because a separate component can be used \
to process the username and password without needing to know anything about \
the body.\
\>", "Text",
 CellTags->"b:1.3.4",
 CellID->9514],

Cell[TextData[{
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " supports headers by including the header as part of the function signature \
of an operation. So it will look like any other parameter of the operation. \
If an operation requires two strings defining the username and password as \
headers, then these two strings will be expected when calling this function."
}], "Text",
 CellTags->"b:1.3.4",
 CellID->14309],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.4",
 CellLabel->"In[1]:=",
 CellID->7616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/SOAPHeaders.\
m?wsdl\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.4",
 CellLabel->"In[2]:=",
 CellID->18935],

Cell[BoxData[
 RowBox[{"{", "Authenticate", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.4",
 CellLabel->"Out[2]=",
 CellID->99140279]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Authenticate"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.4",
 CellLabel->"In[3]:=",
 CellID->20600],

Cell[BoxData[
 StyleBox["\<\"String \
Authenticate[Username_String,Password_String]\\n\\nSimple authentication web \
service example.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.4", "Info3384167774-1396201"},
 CellID->647916694]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Authenticate", "[", 
  RowBox[{"\"\<anonymous\>\"", ",", "\"\<password\>\""}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.4",
 CellLabel->"In[4]:=",
 CellID->16519],

Cell[BoxData["\<\"Hello anonymous.\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.4",
 CellLabel->"Out[4]=",
 CellID->44988406]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sessions", "Section",
 CellTags->"b:1.3.5",
 CellID->22798],

Cell[TextData[{
 "Sessions are used by web services to persist user data over multiple calls \
to a web service. For example, they can be used to save a user\
\[CloseCurlyQuote]s settings, data, or other things. Sessions are supported \
by ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 ". However, there are no special functions or options. If a web service \
provides operations that use sessions, then sessions should be used by the \
Java client."
}], "Text",
 CellTags->"b:1.3.5",
 CellID->30303],

Cell["\<\
Here is an example that uses sessions. This example returns how many times a \
user has accessed the operation.\
\>", "Text",
 CellTags->"b:1.3.5",
 CellID->6224],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.5",
 CellLabel->"In[1]:=",
 CellID->11008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Session.m?\
wsdl\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.5",
 CellLabel->"In[2]:=",
 CellID->5844],

Cell[BoxData[
 RowBox[{"{", "GetAccesses", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.5",
 CellLabel->"Out[2]=",
 CellID->670639522]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "GetAccesses"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.5",
 CellLabel->"In[3]:=",
 CellID->14989],

Cell[BoxData[
 StyleBox["\<\"Integer GetAccesses[]\\n\\nGets the number of times this \
function has been accessed.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.3.5", "Info3384167844-3529236"},
 CellID->449510239]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetAccesses", "[", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.5",
 CellLabel->"In[4]:=",
 CellID->3195],

Cell[BoxData["0"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.5",
 CellLabel->"Out[4]=",
 CellID->148907919]
}, Open  ]],

Cell[TextData[{
 "Additional calls to ",
 Cell[BoxData["GetAccesses"], "InlineFormula"],
 " increments the counter."
}], "Text",
 CellTags->"b:1.3.5",
 CellID->3093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetAccesses", "[", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.5",
 CellLabel->"In[5]:=",
 CellID->14343],

Cell[BoxData["1"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.5",
 CellLabel->"Out[5]=",
 CellID->634167884]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Authentication", "Section",
 CellTags->"b:1.3.6",
 CellID->1587],

Cell[TextData[{
 "Authentication is used by some web services to validate a user. This is \
based on functionality provided by HTTP. Digest and basic authentication are \
supported. A user can set the username and password by using the ",
 Cell[BoxData[
  ButtonBox["Username",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InstallService"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Password",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InstallService"]], "InlineFormula"],
 " options. These can be passed into any web service function and used for \
authentication."
}], "Text",
 CellTags->"b:1.3.6",
 CellID->29314],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.6",
 CellLabel->"In[59]:=",
 CellID->9503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  RowBox[{
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Hello.m?wsdl\
\>\"", ",", 
   RowBox[{"\"\<Username\>\"", "\[Rule]", "\"\<user\>\""}], ",", 
   RowBox[{"\"\<Password\>\"", "\[Rule]", "\"\<password\>\""}]}], 
  "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.6",
 CellLabel->"In[36]:=",
 CellID->7448],

Cell[BoxData[
 RowBox[{"{", "HelloWorld", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.6",
 CellLabel->"Out[36]=",
 CellID->1834554590]
}, Open  ]],

Cell["\<\
HTTP authentication is reused for supplemental calls to a URL. The username \
and password are stored in memory and will be required every time the Java \
Virtual Machine (JVM) is shut down.\
\>", "Text",
 CellTags->"b:1.3.6",
 CellID->13458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HelloWorld", "[", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.6",
 CellLabel->"In[37]:=",
 CellID->6618],

Cell[BoxData["\<\"Hello! The current date is {2007, 1, 31, 12, 32, 35.848595}\
\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.6",
 CellLabel->"Out[37]=",
 CellID->1936274151]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timeouts", "Section",
 CellTags->"b:1.3.8",
 CellID->19589],

Cell[TextData[{
 "A timeout may be required when calling a web service operation. A user can \
set the timeout by using the ",
 Cell[BoxData["Timeout"], "InlineFormula"],
 " option. This can be passed into any web service function. The value of the \
option must be a positive integer specifying the timeout in milliseconds."
}], "Text",
 CellTags->"b:1.3.8",
 CellID->20798],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.8",
 CellLabel->"In[1]:=",
 CellID->28009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Hello.m?wsdl\
\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.3.8",
 CellLabel->"In[2]:=",
 CellID->27157],

Cell[BoxData[
 RowBox[{"{", "HelloWorld", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.3.8",
 CellLabel->"Out[2]=",
 CellID->16044692]
}, Open  ]],

Cell["Here is an example setting the timeout to 10 milliseconds.", "Text",
 CellTags->"b:1.3.8",
 CellID->23622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HelloWorld", "[", 
  RowBox[{"Timeout", "\[Rule]", "10"}], "]"}]], "Input", "ConversionLockdown",
 
 CellTags->"b:1.3.8",
 CellLabel->"In[3]:=",
 CellID->18538],

Cell[BoxData[
 RowBox[{
  RowBox[{"InvokeServiceOperation", "::", "\<\"native\"\>"}], ":", 
  " ", "\<\"An error occurred: \\!\\(\\\"Read timed out\\\"\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:null/ref/InvokeServiceOperation\\\", ButtonNote -> \
\\\"WebServices`InvokeServiceOperation::native\\\"]\\)\"\>"}]], "Message", \
"MSG", "ConversionLockdown",
 CellTags->"b:1.3.8",
 CellLabel->"During evaluation of In[3]:=",
 CellID->18589147],

Cell[BoxData["$Failed"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.8",
 CellLabel->"Out[3]=",
 CellID->648641257]
}, Open  ]],

Cell["Here is an example setting the timeout to 1 second.", "Text",
 CellTags->"b:1.3.8",
 CellID->24179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HelloWorld", "[", 
  RowBox[{"Timeout", "\[Rule]", "1000"}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.3.8",
 CellLabel->"In[4]:=",
 CellID->18190],

Cell[BoxData["\<\"Hello! The current date is {2007, 3, 29, 14, 38, \
39.6414826}\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.3.8",
 CellLabel->"Out[4]=",
 CellID->674229548]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Basic Examples - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 29.7619147}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Web Services Tutorial", 
    "language" -> "en", "paclet" -> "WebServices", "status" -> "None", 
    "summary" -> 
    "Often a web service requires using data other than a simple string. This \
data could be something simple like an integer or a real. Often the data is \
more complex and is a combination of simple data types. This example \
demonstrates how to use different data types. For each of the examples, the \
usage message may be used to determine the data types used by a web service. \
Simple data types are the easiest data types to use in Web Services Link. \
Mathematica users should be familiar with the symbols String, Integer, Real, \
True, and False. Each of these may be used with a web service function.", 
    "synonyms" -> {}, "title" -> "Basic Examples", "type" -> "Tutorial", 
    "uri" -> "WebServices/tutorial/BasicExamples"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:1.3.1.1"->{
  Cell[2101, 79, 79, 2, 70, "Subsection",
   CellTags->"b:1.3.1.1",
   CellID->30106],
  Cell[2183, 83, 944, 35, 70, "Text",
   CellTags->"b:1.3.1.1",
   CellID->9040],
  Cell[3130, 120, 234, 9, 70, "Text",
   CellTags->"b:1.3.1.1",
   CellID->8942],
  Cell[3389, 133, 139, 4, 70, "Input",
   CellTags->"b:1.3.1.1",
   CellID->19264],
  Cell[3531, 139, 212, 4, 70, "Print",
   CellTags->{"b:1.3.1.1", "Info3384166734-3649653"},
   CellID->20668706],
  Cell[3780, 148, 152, 4, 70, "Input",
   CellTags->"b:1.3.1.1",
   CellID->27446],
  Cell[3935, 154, 120, 3, 70, "Output",
   CellTags->"b:1.3.1.1",
   CellID->569709683],
  Cell[4070, 160, 239, 9, 70, "Text",
   CellTags->"b:1.3.1.1",
   CellID->15890],
  Cell[4334, 173, 137, 4, 70, "Input",
   CellTags->"b:1.3.1.1",
   CellID->6729],
  Cell[4474, 179, 192, 4, 70, "Print",
   CellTags->{"b:1.3.1.1", "Info3384166739-6453784"},
   CellID->339841411],
  Cell[4703, 188, 161, 4, 70, "Input",
   CellTags->"b:1.3.1.1",
   CellID->15350],
  Cell[4867, 194, 130, 3, 70, "Output",
   CellTags->"b:1.3.1.1",
   CellID->600919964],
  Cell[5012, 200, 241, 9, 70, "Text",
   CellTags->"b:1.3.1.1",
   CellID->31101],
  Cell[5278, 213, 139, 4, 70, "Input",
   CellTags->"b:1.3.1.1",
   CellID->24393],
  Cell[5420, 219, 197, 4, 70, "Print",
   CellTags->{"b:1.3.1.1", "Info3384166743-7463781"},
   CellID->203715183],
  Cell[5654, 228, 150, 4, 70, "Input",
   CellTags->"b:1.3.1.1",
   CellID->19629],
  Cell[5807, 234, 116, 3, 70, "Output",
   CellTags->"b:1.3.1.1",
   CellID->8351290],
  Cell[5938, 240, 235, 9, 70, "Text",
   CellTags->"b:1.3.1.1",
   CellID->24084],
  Cell[6198, 253, 136, 4, 70, "Input",
   CellTags->"b:1.3.1.1",
   CellID->19954],
  Cell[6337, 259, 185, 4, 70, "Print",
   CellTags->{"b:1.3.1.1", "Info3384166746-7470668"},
   CellID->100067754],
  Cell[6559, 268, 152, 4, 70, "Input",
   CellTags->"b:1.3.1.1",
   CellID->11840],
  Cell[6714, 274, 124, 3, 70, "Output",
   CellTags->"b:1.3.1.1",
   CellID->295651900]},
 "Info3384166734-3649653"->{
  Cell[3531, 139, 212, 4, 70, "Print",
   CellTags->{"b:1.3.1.1", "Info3384166734-3649653"},
   CellID->20668706]},
 "Info3384166739-6453784"->{
  Cell[4474, 179, 192, 4, 70, "Print",
   CellTags->{"b:1.3.1.1", "Info3384166739-6453784"},
   CellID->339841411]},
 "Info3384166743-7463781"->{
  Cell[5420, 219, 197, 4, 70, "Print",
   CellTags->{"b:1.3.1.1", "Info3384166743-7463781"},
   CellID->203715183]},
 "Info3384166746-7470668"->{
  Cell[6337, 259, 185, 4, 70, "Print",
   CellTags->{"b:1.3.1.1", "Info3384166746-7470668"},
   CellID->100067754]},
 "b:1.3.1.2"->{
  Cell[6887, 283, 91, 2, 70, "Subsection",
   CellTags->"b:1.3.1.2",
   CellID->7376],
  Cell[6981, 287, 613, 19, 70, "Text",
   CellTags->"b:1.3.1.2",
   CellID->13931],
  Cell[7597, 308, 171, 6, 70, "Text",
   CellTags->"b:1.3.1.2",
   CellID->26308],
  Cell[7793, 318, 137, 4, 70, "Input",
   CellTags->"b:1.3.1.2",
   CellID->16944],
  Cell[7933, 324, 192, 4, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166760-1720084"},
   CellID->2887067],
  Cell[8162, 333, 139, 4, 70, "Input",
   CellTags->"b:1.3.1.2",
   CellID->24626],
  Cell[8304, 339, 245, 5, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166762-5083763"},
   CellID->37153882],
  Cell[8586, 349, 222, 7, 70, "Input",
   CellTags->"b:1.3.1.2",
   CellID->5537],
  Cell[8811, 358, 192, 6, 70, "Output",
   CellTags->"b:1.3.1.2",
   CellID->780638570],
  Cell[9018, 367, 171, 6, 70, "Text",
   CellTags->"b:1.3.1.2",
   CellID->16118],
  Cell[9214, 377, 136, 4, 70, "Input",
   CellTags->"b:1.3.1.2",
   CellID->2082],
  Cell[9353, 383, 193, 4, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166766-2524988"},
   CellID->61585654],
  Cell[9583, 392, 139, 4, 70, "Input",
   CellTags->"b:1.3.1.2",
   CellID->16541],
  Cell[9725, 398, 251, 5, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166768-4481433"},
   CellID->307981648],
  Cell[10013, 408, 221, 7, 70, "Input",
   CellTags->"b:1.3.1.2",
   CellID->31115],
  Cell[10237, 417, 187, 5, 70, "Output",
   CellTags->"b:1.3.1.2",
   CellID->798062808],
  Cell[10439, 425, 175, 6, 70, "Text",
   CellTags->"b:1.3.1.2",
   CellID->29658],
  Cell[10639, 435, 141, 4, 70, "Input",
   CellTags->"b:1.3.1.2",
   CellID->22704],
  Cell[10783, 441, 211, 4, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166773-2807980"},
   CellID->118561596],
  Cell[11031, 450, 143, 4, 70, "Input",
   CellTags->"b:1.3.1.2",
   CellID->13977],
  Cell[11177, 456, 297, 5, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166774-7971642"},
   CellID->116735973],
  Cell[11511, 466, 215, 6, 70, "Input",
   CellTags->"b:1.3.1.2",
   CellID->31673],
  Cell[11729, 474, 242, 7, 70, "Output",
   CellTags->"b:1.3.1.2",
   CellID->133114824],
  Cell[11986, 484, 284, 10, 70, "Text",
   CellTags->"b:1.3.1.2",
   CellID->5021]},
 "Info3384166760-1720084"->{
  Cell[7933, 324, 192, 4, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166760-1720084"},
   CellID->2887067]},
 "Info3384166762-5083763"->{
  Cell[8304, 339, 245, 5, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166762-5083763"},
   CellID->37153882]},
 "Info3384166766-2524988"->{
  Cell[9353, 383, 193, 4, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166766-2524988"},
   CellID->61585654]},
 "Info3384166768-4481433"->{
  Cell[9725, 398, 251, 5, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166768-4481433"},
   CellID->307981648]},
 "Info3384166773-2807980"->{
  Cell[10783, 441, 211, 4, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166773-2807980"},
   CellID->118561596]},
 "Info3384166774-7971642"->{
  Cell[11177, 456, 297, 5, 70, "Print",
   CellTags->{"b:1.3.1.2", "Info3384166774-7971642"},
   CellID->116735973]},
 "b:1.3.1.3"->{
  Cell[12307, 499, 81, 2, 70, "Subsection",
   CellTags->"b:1.3.1.3",
   CellID->28745],
  Cell[12391, 503, 855, 22, 70, "Text",
   CellTags->"b:1.3.1.3",
   CellID->26924],
  Cell[13249, 527, 131, 4, 70, "Text",
   CellTags->"b:1.3.1.3",
   CellID->19072],
  Cell[13405, 535, 137, 4, 70, "Input",
   CellTags->"b:1.3.1.3",
   CellID->6270],
  Cell[13545, 541, 186, 4, 70, "Print",
   CellTags->{"b:1.3.1.3", "Info3384167126-8240469"},
   CellID->353041394],
  Cell[13768, 550, 134, 4, 70, "Input",
   CellTags->"b:1.3.1.3",
   CellID->26777],
  Cell[13905, 556, 490, 8, 70, "Print",
   CellTags->{"b:1.3.1.3", "Info3384167128-9039531"},
   CellID->560281400],
  Cell[14410, 567, 212, 7, 70, "Text",
   CellTags->"b:1.3.1.3",
   CellID->5097],
  Cell[14647, 578, 411, 12, 70, "Input",
   CellTags->"b:1.3.1.3",
   CellID->16512],
  Cell[15061, 592, 270, 8, 70, "Output",
   CellTags->"b:1.3.1.3",
   CellID->7654136],
  Cell[15368, 605, 152, 4, 70, "Input",
   CellTags->"b:1.3.1.3",
   CellID->13290],
  Cell[15523, 611, 272, 8, 70, "Output",
   CellTags->"b:1.3.1.3",
   CellID->216467156],
  Cell[15810, 622, 133, 4, 70, "Text",
   CellTags->"b:1.3.1.3",
   CellID->18636],
  Cell[15968, 630, 156, 4, 70, "Input",
   CellTags->"b:1.3.1.3",
   CellID->22355],
  Cell[16127, 636, 118, 3, 70, "Output",
   CellTags->"b:1.3.1.3",
   CellID->8445004],
  Cell[16260, 642, 187, 5, 70, "Text",
   CellTags->"b:1.3.1.3",
   CellID->23655],
  Cell[16472, 651, 259, 7, 70, "Input",
   CellTags->"b:1.3.1.3",
   CellID->15574],
  Cell[16734, 660, 272, 8, 70, "Output",
   CellTags->"b:1.3.1.3",
   CellID->117754405]},
 "Info3384167126-8240469"->{
  Cell[13545, 541, 186, 4, 70, "Print",
   CellTags->{"b:1.3.1.3", "Info3384167126-8240469"},
   CellID->353041394]},
 "Info3384167128-9039531"->{
  Cell[13905, 556, 490, 8, 70, "Print",
   CellTags->{"b:1.3.1.3", "Info3384167128-9039531"},
   CellID->560281400]},
 "b:1.3.1.4"->{
  Cell[17055, 674, 68, 2, 70, "Subsection",
   CellTags->"b:1.3.1.4",
   CellID->12052],
  Cell[17126, 678, 537, 19, 70, "Text",
   CellTags->"b:1.3.1.4",
   CellID->27350],
  Cell[17666, 699, 139, 4, 70, "Text",
   CellTags->"b:1.3.1.4",
   CellID->1150],
  Cell[17830, 707, 145, 4, 70, "Input",
   CellTags->"b:1.3.1.4",
   CellID->16941],
  Cell[17978, 713, 276, 7, 70, "Print",
   CellTags->{"b:1.3.1.4", "Info3384167157-1802425"},
   CellID->368327798],
  Cell[18291, 725, 214, 7, 70, "Input",
   CellTags->"b:1.3.1.4",
   CellID->13966],
  Cell[18508, 734, 173, 5, 70, "Output",
   CellTags->"b:1.3.1.4",
   CellID->438245499],
  Cell[18696, 742, 144, 5, 70, "Text",
   CellTags->"b:1.3.1.4",
   CellID->31107],
  Cell[18865, 751, 143, 4, 70, "Input",
   CellTags->"b:1.3.1.4",
   CellID->30191],
  Cell[19011, 757, 209, 4, 70, "Print",
   CellTags->{"b:1.3.1.4", "Info3384167159-5445807"},
   CellID->235763305],
  Cell[19257, 766, 411, 12, 70, "Input",
   CellTags->"b:1.3.1.4",
   CellID->11337],
  Cell[19671, 780, 272, 8, 70, "Output",
   CellTags->"b:1.3.1.4",
   CellID->277924982],
  Cell[19980, 793, 755, 19, 70, "Input",
   CellTags->"b:1.3.1.4",
   CellID->12287],
  Cell[20738, 814, 662, 18, 70, "Output",
   CellTags->"b:1.3.1.4",
   CellID->184471997]},
 "Info3384167157-1802425"->{
  Cell[17978, 713, 276, 7, 70, "Print",
   CellTags->{"b:1.3.1.4", "Info3384167157-1802425"},
   CellID->368327798]},
 "Info3384167159-5445807"->{
  Cell[19011, 757, 209, 4, 70, "Print",
   CellTags->{"b:1.3.1.4", "Info3384167159-5445807"},
   CellID->235763305]},
 "b:1.3.2"->{
  Cell[21461, 839, 69, 2, 70, "Section",
   CellTags->"b:1.3.2",
   CellID->10383],
  Cell[21533, 843, 257, 6, 70, "Text",
   CellTags->"b:1.3.2",
   CellID->14945],
  Cell[21793, 851, 138, 4, 70, "Input",
   CellTags->"b:1.3.2",
   CellID->8909],
  Cell[21956, 859, 231, 6, 70, "Input",
   CellTags->"b:1.3.2",
   CellID->32209],
  Cell[22190, 867, 184, 6, 70, "Output",
   CellTags->"b:1.3.2",
   CellID->644280174],
  Cell[22411, 878, 136, 4, 70, "Input",
   CellTags->"b:1.3.2",
   CellID->24221],
  Cell[22550, 884, 318, 6, 70, "Print",
   CellTags->{"b:1.3.2", "Info3384167277-9567975"},
   CellID->49307453],
  Cell[22883, 893, 1273, 35, 70, "Text",
   CellTags->"b:1.3.2",
   CellID->6422],
  Cell[24181, 932, 355, 10, 70, "Input",
   CellTags->"b:1.3.2",
   CellID->24946],
  Cell[24539, 944, 4968, 89, 70, "Output",
   CellTags->"b:1.3.2",
   CellID->117676709]},
 "Info3384167277-9567975"->{
  Cell[22550, 884, 318, 6, 70, "Print",
   CellTags->{"b:1.3.2", "Info3384167277-9567975"},
   CellID->49307453]},
 "b:1.3.3.1"->{
  Cell[30604, 1078, 68, 2, 70, "Subsection",
   CellTags->"b:1.3.3.1",
   CellID->1655],
  Cell[30675, 1082, 990, 26, 70, "Text",
   CellTags->"b:1.3.3.1",
   CellID->17410],
  Cell[31668, 1110, 159, 4, 70, "Text",
   CellTags->"b:1.3.3.1",
   CellID->6359],
  Cell[31852, 1118, 143, 4, 70, "Input",
   CellTags->"b:1.3.3.1",
   CellID->27624],
  Cell[31998, 1124, 312, 5, 70, "Print",
   CellTags->{"b:1.3.3.1", "Info3384167352-8864364"},
   CellID->715432717],
  Cell[32347, 1134, 206, 6, 70, "Input",
   CellTags->"b:1.3.3.1",
   CellID->21548],
  Cell[32556, 1142, 131, 3, 70, "Output",
   CellTags->"b:1.3.3.1",
   CellID->255790239],
  Cell[32702, 1148, 390, 12, 70, "Text",
   CellTags->"b:1.3.3.1",
   CellID->27595],
  Cell[33117, 1164, 152, 4, 70, "Input",
   CellTags->"b:1.3.3.1",
   CellID->4041],
  Cell[33272, 1170, 128, 3, 70, "Output",
   CellTags->"b:1.3.3.1",
   CellID->91017436],
  Cell[33415, 1176, 220, 7, 70, "Text",
   CellTags->"b:1.3.3.1",
   CellID->24350],
  Cell[33660, 1187, 193, 6, 70, "Input",
   CellTags->"b:1.3.3.1",
   CellID->10291],
  Cell[33856, 1195, 164, 5, 70, "Output",
   CellTags->"b:1.3.3.1",
   CellID->252258319]},
 "Info3384167352-8864364"->{
  Cell[31998, 1124, 312, 5, 70, "Print",
   CellTags->{"b:1.3.3.1", "Info3384167352-8864364"},
   CellID->715432717]},
 "b:1.3.3.2"->{
  Cell[34069, 1206, 75, 2, 70, "Subsection",
   CellTags->"b:1.3.3.2",
   CellID->9374],
  Cell[34147, 1210, 619, 11, 70, "Text",
   CellTags->"b:1.3.3.2",
   CellID->11020],
  Cell[34769, 1223, 745, 18, 70, "Text",
   CellTags->"b:1.3.3.2",
   CellID->4596],
  Cell[35539, 1245, 148, 4, 70, "Input",
   CellTags->"b:1.3.3.2",
   CellID->24021],
  Cell[35690, 1251, 317, 6, 70, "Print",
   CellTags->{"b:1.3.3.2", "Info3384167482-4356473"},
   CellID->233108318],
  Cell[36044, 1262, 331, 9, 70, "Input",
   CellTags->"b:1.3.3.2",
   CellID->23199],
  Cell[36378, 1273, 2246, 35, 70, "Output",
   CellTags->"b:1.3.3.2",
   CellID->257144274]},
 "Info3384167482-4356473"->{
  Cell[35690, 1251, 317, 6, 70, "Print",
   CellTags->{"b:1.3.3.2", "Info3384167482-4356473"},
   CellID->233108318]},
 "b:1.3.3.3"->{
  Cell[38673, 1314, 136, 6, 70, "Subsection",
   CellTags->"b:1.3.3.3",
   CellID->8281],
  Cell[38812, 1322, 743, 19, 70, "Text",
   CellTags->"b:1.3.3.3",
   CellID->4734],
  Cell[39558, 1343, 387, 10, 70, "Text",
   CellTags->"b:1.3.3.3",
   CellID->53],
  Cell[39970, 1357, 146, 4, 70, "Input",
   CellTags->"b:1.3.3.3",
   CellID->1999],
  Cell[40119, 1363, 335, 6, 70, "Print",
   CellTags->{"b:1.3.3.3", "Info3384167520-1349916"},
   CellID->380846584],
  Cell[40491, 1374, 228, 7, 70, "Input",
   CellTags->"b:1.3.3.3",
   CellID->27938],
  Cell[40722, 1383, 203, 6, 70, "Output",
   CellTags->"b:1.3.3.3",
   CellID->372349811],
  Cell[40940, 1392, 312, 10, 70, "Text",
   CellTags->"b:1.3.3.3",
   CellID->3788]},
 "Info3384167520-1349916"->{
  Cell[40119, 1363, 335, 6, 70, "Print",
   CellTags->{"b:1.3.3.3", "Info3384167520-1349916"},
   CellID->380846584]},
 "b:1.3.3.4"->{
  Cell[41289, 1407, 68, 2, 70, "Subsection",
   CellTags->"b:1.3.3.4",
   CellID->18127],
  Cell[41360, 1411, 893, 22, 70, "Text",
   CellTags->"b:1.3.3.4",
   CellID->467],
  Cell[42256, 1435, 303, 7, 70, "Text",
   CellTags->"b:1.3.3.4",
   CellID->3728],
  Cell[42584, 1446, 144, 4, 70, "Input",
   CellTags->"b:1.3.3.4",
   CellID->14893],
  Cell[42731, 1452, 306, 6, 70, "Print",
   CellTags->{"b:1.3.3.4", "Info3384167561-4916499"},
   CellID->97844372],
  Cell[43074, 1463, 333, 9, 70, "Input",
   CellTags->"b:1.3.3.4",
   CellID->22483],
  Cell[43410, 1474, 3210, 86, 70, "Output",
   CellTags->"b:1.3.3.4",
   CellID->46815542],
  Cell[46635, 1563, 522, 16, 70, "Text",
   CellTags->"b:1.3.3.4",
   CellID->2421],
  Cell[47182, 1583, 215, 6, 70, "Input",
   CellTags->"b:1.3.3.4",
   CellID->14310],
  Cell[47400, 1591, 165, 5, 70, "Output",
   CellTags->"b:1.3.3.4",
   CellID->676012798]},
 "Info3384167561-4916499"->{
  Cell[42731, 1452, 306, 6, 70, "Print",
   CellTags->{"b:1.3.3.4", "Info3384167561-4916499"},
   CellID->97844372]},
 "b:1.3.4"->{
  Cell[47626, 1603, 69, 2, 70, "Section",
   CellTags->"b:1.3.4",
   CellID->22813],
  Cell[47698, 1607, 683, 12, 70, "Text",
   CellTags->"b:1.3.4",
   CellID->9514],
  Cell[48384, 1621, 433, 9, 70, "Text",
   CellTags->"b:1.3.4",
   CellID->14309],
  Cell[48820, 1632, 138, 4, 70, "Input",
   CellTags->"b:1.3.4",
   CellID->7616],
  Cell[48983, 1640, 238, 6, 70, "Input",
   CellTags->"b:1.3.4",
   CellID->18935],
  Cell[49224, 1648, 147, 4, 70, "Output",
   CellTags->"b:1.3.4",
   CellID->99140279],
  Cell[49408, 1657, 138, 4, 70, "Input",
   CellTags->"b:1.3.4",
   CellID->20600],
  Cell[49549, 1663, 241, 5, 70, "Print",
   CellTags->{"b:1.3.4", "Info3384167774-1396201"},
   CellID->647916694],
  Cell[49827, 1673, 204, 6, 70, "Input",
   CellTags->"b:1.3.4",
   CellID->16519],
  Cell[50034, 1681, 137, 3, 70, "Output",
   CellTags->"b:1.3.4",
   CellID->44988406]},
 "Info3384167774-1396201"->{
  Cell[49549, 1663, 241, 5, 70, "Print",
   CellTags->{"b:1.3.4", "Info3384167774-1396201"},
   CellID->647916694]},
 "b:1.3.5"->{
  Cell[50220, 1690, 65, 2, 70, "Section",
   CellTags->"b:1.3.5",
   CellID->22798],
  Cell[50288, 1694, 513, 12, 70, "Text",
   CellTags->"b:1.3.5",
   CellID->30303],
  Cell[50804, 1708, 172, 5, 70, "Text",
   CellTags->"b:1.3.5",
   CellID->6224],
  Cell[50979, 1715, 139, 4, 70, "Input",
   CellTags->"b:1.3.5",
   CellID->11008],
  Cell[51143, 1723, 233, 6, 70, "Input",
   CellTags->"b:1.3.5",
   CellID->5844],
  Cell[51379, 1731, 147, 4, 70, "Output",
   CellTags->"b:1.3.5",
   CellID->670639522],
  Cell[51563, 1740, 137, 4, 70, "Input",
   CellTags->"b:1.3.5",
   CellID->14989],
  Cell[51703, 1746, 223, 4, 70, "Print",
   CellTags->{"b:1.3.5", "Info3384167844-3529236"},
   CellID->449510239],
  Cell[51963, 1755, 141, 4, 70, "Input",
   CellTags->"b:1.3.5",
   CellID->3195],
  Cell[52107, 1761, 115, 3, 70, "Output",
   CellTags->"b:1.3.5",
   CellID->148907919],
  Cell[52237, 1767, 165, 6, 70, "Text",
   CellTags->"b:1.3.5",
   CellID->3093],
  Cell[52427, 1777, 142, 4, 70, "Input",
   CellTags->"b:1.3.5",
   CellID->14343],
  Cell[52572, 1783, 115, 3, 70, "Output",
   CellTags->"b:1.3.5",
   CellID->634167884]},
 "Info3384167844-3529236"->{
  Cell[51703, 1746, 223, 4, 70, "Print",
   CellTags->{"b:1.3.5", "Info3384167844-3529236"},
   CellID->449510239]},
 "b:1.3.6"->{
  Cell[52736, 1792, 70, 2, 70, "Section",
   CellTags->"b:1.3.6",
   CellID->1587],
  Cell[52809, 1796, 642, 17, 70, "Text",
   CellTags->"b:1.3.6",
   CellID->29314],
  Cell[53454, 1815, 139, 4, 70, "Input",
   CellTags->"b:1.3.6",
   CellID->9503],
  Cell[53618, 1823, 384, 10, 70, "Input",
   CellTags->"b:1.3.6",
   CellID->7448],
  Cell[54005, 1835, 148, 4, 70, "Output",
   CellTags->"b:1.3.6",
   CellID->1834554590],
  Cell[54168, 1842, 252, 6, 70, "Text",
   CellTags->"b:1.3.6",
   CellID->13458],
  Cell[54445, 1852, 141, 4, 70, "Input",
   CellTags->"b:1.3.6",
   CellID->6618],
  Cell[54589, 1858, 185, 4, 70, "Output",
   CellTags->"b:1.3.6",
   CellID->1936274151]},
 "b:1.3.8"->{
  Cell[54823, 1868, 65, 2, 70, "Section",
   CellTags->"b:1.3.8",
   CellID->19589],
  Cell[54891, 1872, 375, 8, 70, "Text",
   CellTags->"b:1.3.8",
   CellID->20798],
  Cell[55269, 1882, 139, 4, 70, "Input",
   CellTags->"b:1.3.8",
   CellID->28009],
  Cell[55433, 1890, 232, 6, 70, "Input",
   CellTags->"b:1.3.8",
   CellID->27157],
  Cell[55668, 1898, 145, 4, 70, "Output",
   CellTags->"b:1.3.8",
   CellID->16044692],
  Cell[55828, 1905, 112, 2, 70, "Text",
   CellTags->"b:1.3.8",
   CellID->23622],
  Cell[55965, 1911, 184, 6, 70, "Input",
   CellTags->"b:1.3.8",
   CellID->18538],
  Cell[56152, 1919, 518, 11, 70, "Message",
   CellTags->"b:1.3.8",
   CellID->18589147],
  Cell[56673, 1932, 121, 3, 70, "Output",
   CellTags->"b:1.3.8",
   CellID->648641257],
  Cell[56809, 1938, 105, 2, 70, "Text",
   CellTags->"b:1.3.8",
   CellID->24179],
  Cell[56939, 1944, 186, 6, 70, "Input",
   CellTags->"b:1.3.8",
   CellID->18190],
  Cell[57128, 1952, 184, 4, 70, "Output",
   CellTags->"b:1.3.8",
   CellID->674229548]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:1.3.1.1", 59227, 2003},
 {"Info3384166734-3649653", 61245, 2070},
 {"Info3384166739-6453784", 61390, 2074},
 {"Info3384166743-7463781", 61536, 2078},
 {"Info3384166746-7470668", 61682, 2082},
 {"b:1.3.1.2", 61815, 2086},
 {"Info3384166760-1720084", 64071, 2159},
 {"Info3384166762-5083763", 64215, 2163},
 {"Info3384166766-2524988", 64360, 2167},
 {"Info3384166768-4481433", 64505, 2171},
 {"Info3384166773-2807980", 64651, 2175},
 {"Info3384166774-7971642", 64798, 2179},
 {"b:1.3.1.3", 64932, 2183},
 {"Info3384167126-8240469", 66571, 2238},
 {"Info3384167128-9039531", 66718, 2242},
 {"b:1.3.1.4", 66852, 2246},
 {"Info3384167157-1802425", 68155, 2289},
 {"Info3384167159-5445807", 68302, 2293},
 {"b:1.3.2", 68434, 2297},
 {"Info3384167277-9567975", 69337, 2328},
 {"b:1.3.3.1", 69468, 2332},
 {"Info3384167352-8864364", 70661, 2372},
 {"b:1.3.3.2", 70796, 2376},
 {"Info3384167482-4356473", 71469, 2398},
 {"b:1.3.3.3", 71604, 2402},
 {"Info3384167520-1349916", 72357, 2427},
 {"b:1.3.3.4", 72492, 2431},
 {"Info3384167561-4916499", 73423, 2462},
 {"b:1.3.4", 73555, 2466},
 {"Info3384167774-1396201", 74463, 2497},
 {"b:1.3.5", 74594, 2501},
 {"Info3384167844-3529236", 75758, 2541},
 {"b:1.3.6", 75889, 2545},
 {"b:1.3.8", 76585, 2570}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 46, 1, 70, "Title",
 CellID->9741],
Cell[CellGroupData[{
Cell[800, 34, 50, 1, 70, "Section",
 CellID->27529],
Cell[853, 37, 307, 6, 70, "Text",
 CellID->778],
Cell[1163, 45, 117, 3, 70, "Input",
 CellID->12316],
Cell[CellGroupData[{
Cell[1305, 52, 208, 5, 70, "Input",
 CellID->3035],
Cell[1516, 59, 399, 9, 70, "Output",
 CellID->72701709]
}, Open  ]],
Cell[1930, 71, 146, 4, 70, "Text",
 CellID->288],
Cell[CellGroupData[{
Cell[2101, 79, 79, 2, 70, "Subsection",
 CellTags->"b:1.3.1.1",
 CellID->30106],
Cell[2183, 83, 944, 35, 70, "Text",
 CellTags->"b:1.3.1.1",
 CellID->9040],
Cell[3130, 120, 234, 9, 70, "Text",
 CellTags->"b:1.3.1.1",
 CellID->8942],
Cell[CellGroupData[{
Cell[3389, 133, 139, 4, 70, "Input",
 CellTags->"b:1.3.1.1",
 CellID->19264],
Cell[3531, 139, 212, 4, 70, "Print",
 CellTags->{"b:1.3.1.1", "Info3384166734-3649653"},
 CellID->20668706]
}, Open  ]],
Cell[CellGroupData[{
Cell[3780, 148, 152, 4, 70, "Input",
 CellTags->"b:1.3.1.1",
 CellID->27446],
Cell[3935, 154, 120, 3, 70, "Output",
 CellTags->"b:1.3.1.1",
 CellID->569709683]
}, Open  ]],
Cell[4070, 160, 239, 9, 70, "Text",
 CellTags->"b:1.3.1.1",
 CellID->15890],
Cell[CellGroupData[{
Cell[4334, 173, 137, 4, 70, "Input",
 CellTags->"b:1.3.1.1",
 CellID->6729],
Cell[4474, 179, 192, 4, 70, "Print",
 CellTags->{"b:1.3.1.1", "Info3384166739-6453784"},
 CellID->339841411]
}, Open  ]],
Cell[CellGroupData[{
Cell[4703, 188, 161, 4, 70, "Input",
 CellTags->"b:1.3.1.1",
 CellID->15350],
Cell[4867, 194, 130, 3, 70, "Output",
 CellTags->"b:1.3.1.1",
 CellID->600919964]
}, Open  ]],
Cell[5012, 200, 241, 9, 70, "Text",
 CellTags->"b:1.3.1.1",
 CellID->31101],
Cell[CellGroupData[{
Cell[5278, 213, 139, 4, 70, "Input",
 CellTags->"b:1.3.1.1",
 CellID->24393],
Cell[5420, 219, 197, 4, 70, "Print",
 CellTags->{"b:1.3.1.1", "Info3384166743-7463781"},
 CellID->203715183]
}, Open  ]],
Cell[CellGroupData[{
Cell[5654, 228, 150, 4, 70, "Input",
 CellTags->"b:1.3.1.1",
 CellID->19629],
Cell[5807, 234, 116, 3, 70, "Output",
 CellTags->"b:1.3.1.1",
 CellID->8351290]
}, Open  ]],
Cell[5938, 240, 235, 9, 70, "Text",
 CellTags->"b:1.3.1.1",
 CellID->24084],
Cell[CellGroupData[{
Cell[6198, 253, 136, 4, 70, "Input",
 CellTags->"b:1.3.1.1",
 CellID->19954],
Cell[6337, 259, 185, 4, 70, "Print",
 CellTags->{"b:1.3.1.1", "Info3384166746-7470668"},
 CellID->100067754]
}, Open  ]],
Cell[CellGroupData[{
Cell[6559, 268, 152, 4, 70, "Input",
 CellTags->"b:1.3.1.1",
 CellID->11840],
Cell[6714, 274, 124, 3, 70, "Output",
 CellTags->"b:1.3.1.1",
 CellID->295651900]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6887, 283, 91, 2, 70, "Subsection",
 CellTags->"b:1.3.1.2",
 CellID->7376],
Cell[6981, 287, 613, 19, 70, "Text",
 CellTags->"b:1.3.1.2",
 CellID->13931],
Cell[7597, 308, 171, 6, 70, "Text",
 CellTags->"b:1.3.1.2",
 CellID->26308],
Cell[CellGroupData[{
Cell[7793, 318, 137, 4, 70, "Input",
 CellTags->"b:1.3.1.2",
 CellID->16944],
Cell[7933, 324, 192, 4, 70, "Print",
 CellTags->{"b:1.3.1.2", "Info3384166760-1720084"},
 CellID->2887067]
}, Open  ]],
Cell[CellGroupData[{
Cell[8162, 333, 139, 4, 70, "Input",
 CellTags->"b:1.3.1.2",
 CellID->24626],
Cell[8304, 339, 245, 5, 70, "Print",
 CellTags->{"b:1.3.1.2", "Info3384166762-5083763"},
 CellID->37153882]
}, Open  ]],
Cell[CellGroupData[{
Cell[8586, 349, 222, 7, 70, "Input",
 CellTags->"b:1.3.1.2",
 CellID->5537],
Cell[8811, 358, 192, 6, 70, "Output",
 CellTags->"b:1.3.1.2",
 CellID->780638570]
}, Open  ]],
Cell[9018, 367, 171, 6, 70, "Text",
 CellTags->"b:1.3.1.2",
 CellID->16118],
Cell[CellGroupData[{
Cell[9214, 377, 136, 4, 70, "Input",
 CellTags->"b:1.3.1.2",
 CellID->2082],
Cell[9353, 383, 193, 4, 70, "Print",
 CellTags->{"b:1.3.1.2", "Info3384166766-2524988"},
 CellID->61585654]
}, Open  ]],
Cell[CellGroupData[{
Cell[9583, 392, 139, 4, 70, "Input",
 CellTags->"b:1.3.1.2",
 CellID->16541],
Cell[9725, 398, 251, 5, 70, "Print",
 CellTags->{"b:1.3.1.2", "Info3384166768-4481433"},
 CellID->307981648]
}, Open  ]],
Cell[CellGroupData[{
Cell[10013, 408, 221, 7, 70, "Input",
 CellTags->"b:1.3.1.2",
 CellID->31115],
Cell[10237, 417, 187, 5, 70, "Output",
 CellTags->"b:1.3.1.2",
 CellID->798062808]
}, Open  ]],
Cell[10439, 425, 175, 6, 70, "Text",
 CellTags->"b:1.3.1.2",
 CellID->29658],
Cell[CellGroupData[{
Cell[10639, 435, 141, 4, 70, "Input",
 CellTags->"b:1.3.1.2",
 CellID->22704],
Cell[10783, 441, 211, 4, 70, "Print",
 CellTags->{"b:1.3.1.2", "Info3384166773-2807980"},
 CellID->118561596]
}, Open  ]],
Cell[CellGroupData[{
Cell[11031, 450, 143, 4, 70, "Input",
 CellTags->"b:1.3.1.2",
 CellID->13977],
Cell[11177, 456, 297, 5, 70, "Print",
 CellTags->{"b:1.3.1.2", "Info3384166774-7971642"},
 CellID->116735973]
}, Open  ]],
Cell[CellGroupData[{
Cell[11511, 466, 215, 6, 70, "Input",
 CellTags->"b:1.3.1.2",
 CellID->31673],
Cell[11729, 474, 242, 7, 70, "Output",
 CellTags->"b:1.3.1.2",
 CellID->133114824]
}, Open  ]],
Cell[11986, 484, 284, 10, 70, "Text",
 CellTags->"b:1.3.1.2",
 CellID->5021]
}, Open  ]],
Cell[CellGroupData[{
Cell[12307, 499, 81, 2, 70, "Subsection",
 CellTags->"b:1.3.1.3",
 CellID->28745],
Cell[12391, 503, 855, 22, 70, "Text",
 CellTags->"b:1.3.1.3",
 CellID->26924],
Cell[13249, 527, 131, 4, 70, "Text",
 CellTags->"b:1.3.1.3",
 CellID->19072],
Cell[CellGroupData[{
Cell[13405, 535, 137, 4, 70, "Input",
 CellTags->"b:1.3.1.3",
 CellID->6270],
Cell[13545, 541, 186, 4, 70, "Print",
 CellTags->{"b:1.3.1.3", "Info3384167126-8240469"},
 CellID->353041394]
}, Open  ]],
Cell[CellGroupData[{
Cell[13768, 550, 134, 4, 70, "Input",
 CellTags->"b:1.3.1.3",
 CellID->26777],
Cell[13905, 556, 490, 8, 70, "Print",
 CellTags->{"b:1.3.1.3", "Info3384167128-9039531"},
 CellID->560281400]
}, Open  ]],
Cell[14410, 567, 212, 7, 70, "Text",
 CellTags->"b:1.3.1.3",
 CellID->5097],
Cell[CellGroupData[{
Cell[14647, 578, 411, 12, 70, "Input",
 CellTags->"b:1.3.1.3",
 CellID->16512],
Cell[15061, 592, 270, 8, 70, "Output",
 CellTags->"b:1.3.1.3",
 CellID->7654136]
}, Open  ]],
Cell[CellGroupData[{
Cell[15368, 605, 152, 4, 70, "Input",
 CellTags->"b:1.3.1.3",
 CellID->13290],
Cell[15523, 611, 272, 8, 70, "Output",
 CellTags->"b:1.3.1.3",
 CellID->216467156]
}, Open  ]],
Cell[15810, 622, 133, 4, 70, "Text",
 CellTags->"b:1.3.1.3",
 CellID->18636],
Cell[CellGroupData[{
Cell[15968, 630, 156, 4, 70, "Input",
 CellTags->"b:1.3.1.3",
 CellID->22355],
Cell[16127, 636, 118, 3, 70, "Output",
 CellTags->"b:1.3.1.3",
 CellID->8445004]
}, Open  ]],
Cell[16260, 642, 187, 5, 70, "Text",
 CellTags->"b:1.3.1.3",
 CellID->23655],
Cell[CellGroupData[{
Cell[16472, 651, 259, 7, 70, "Input",
 CellTags->"b:1.3.1.3",
 CellID->15574],
Cell[16734, 660, 272, 8, 70, "Output",
 CellTags->"b:1.3.1.3",
 CellID->117754405]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17055, 674, 68, 2, 70, "Subsection",
 CellTags->"b:1.3.1.4",
 CellID->12052],
Cell[17126, 678, 537, 19, 70, "Text",
 CellTags->"b:1.3.1.4",
 CellID->27350],
Cell[17666, 699, 139, 4, 70, "Text",
 CellTags->"b:1.3.1.4",
 CellID->1150],
Cell[CellGroupData[{
Cell[17830, 707, 145, 4, 70, "Input",
 CellTags->"b:1.3.1.4",
 CellID->16941],
Cell[17978, 713, 276, 7, 70, "Print",
 CellTags->{"b:1.3.1.4", "Info3384167157-1802425"},
 CellID->368327798]
}, Open  ]],
Cell[CellGroupData[{
Cell[18291, 725, 214, 7, 70, "Input",
 CellTags->"b:1.3.1.4",
 CellID->13966],
Cell[18508, 734, 173, 5, 70, "Output",
 CellTags->"b:1.3.1.4",
 CellID->438245499]
}, Open  ]],
Cell[18696, 742, 144, 5, 70, "Text",
 CellTags->"b:1.3.1.4",
 CellID->31107],
Cell[CellGroupData[{
Cell[18865, 751, 143, 4, 70, "Input",
 CellTags->"b:1.3.1.4",
 CellID->30191],
Cell[19011, 757, 209, 4, 70, "Print",
 CellTags->{"b:1.3.1.4", "Info3384167159-5445807"},
 CellID->235763305]
}, Open  ]],
Cell[CellGroupData[{
Cell[19257, 766, 411, 12, 70, "Input",
 CellTags->"b:1.3.1.4",
 CellID->11337],
Cell[19671, 780, 272, 8, 70, "Output",
 CellTags->"b:1.3.1.4",
 CellID->277924982]
}, Open  ]],
Cell[CellGroupData[{
Cell[19980, 793, 755, 19, 70, "Input",
 CellTags->"b:1.3.1.4",
 CellID->12287],
Cell[20738, 814, 662, 18, 70, "Output",
 CellTags->"b:1.3.1.4",
 CellID->184471997]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21461, 839, 69, 2, 70, "Section",
 CellTags->"b:1.3.2",
 CellID->10383],
Cell[21533, 843, 257, 6, 70, "Text",
 CellTags->"b:1.3.2",
 CellID->14945],
Cell[21793, 851, 138, 4, 70, "Input",
 CellTags->"b:1.3.2",
 CellID->8909],
Cell[CellGroupData[{
Cell[21956, 859, 231, 6, 70, "Input",
 CellTags->"b:1.3.2",
 CellID->32209],
Cell[22190, 867, 184, 6, 70, "Output",
 CellTags->"b:1.3.2",
 CellID->644280174]
}, Open  ]],
Cell[CellGroupData[{
Cell[22411, 878, 136, 4, 70, "Input",
 CellTags->"b:1.3.2",
 CellID->24221],
Cell[22550, 884, 318, 6, 70, "Print",
 CellTags->{"b:1.3.2", "Info3384167277-9567975"},
 CellID->49307453]
}, Open  ]],
Cell[22883, 893, 1273, 35, 70, "Text",
 CellTags->"b:1.3.2",
 CellID->6422],
Cell[CellGroupData[{
Cell[24181, 932, 355, 10, 70, "Input",
 CellTags->"b:1.3.2",
 CellID->24946],
Cell[24539, 944, 4968, 89, 70, "Output",
 CellTags->"b:1.3.2",
 CellID->117676709]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29556, 1039, 63, 1, 70, "Section",
 CellID->16413],
Cell[29622, 1042, 290, 8, 70, "Text",
 CellID->29168],
Cell[29915, 1052, 115, 3, 70, "Input",
 CellID->900],
Cell[CellGroupData[{
Cell[30055, 1059, 214, 5, 70, "Input",
 CellID->32591],
Cell[30272, 1066, 295, 7, 70, "Output",
 CellID->95719984]
}, Open  ]],
Cell[CellGroupData[{
Cell[30604, 1078, 68, 2, 70, "Subsection",
 CellTags->"b:1.3.3.1",
 CellID->1655],
Cell[30675, 1082, 990, 26, 70, "Text",
 CellTags->"b:1.3.3.1",
 CellID->17410],
Cell[31668, 1110, 159, 4, 70, "Text",
 CellTags->"b:1.3.3.1",
 CellID->6359],
Cell[CellGroupData[{
Cell[31852, 1118, 143, 4, 70, "Input",
 CellTags->"b:1.3.3.1",
 CellID->27624],
Cell[31998, 1124, 312, 5, 70, "Print",
 CellTags->{"b:1.3.3.1", "Info3384167352-8864364"},
 CellID->715432717]
}, Open  ]],
Cell[CellGroupData[{
Cell[32347, 1134, 206, 6, 70, "Input",
 CellTags->"b:1.3.3.1",
 CellID->21548],
Cell[32556, 1142, 131, 3, 70, "Output",
 CellTags->"b:1.3.3.1",
 CellID->255790239]
}, Open  ]],
Cell[32702, 1148, 390, 12, 70, "Text",
 CellTags->"b:1.3.3.1",
 CellID->27595],
Cell[CellGroupData[{
Cell[33117, 1164, 152, 4, 70, "Input",
 CellTags->"b:1.3.3.1",
 CellID->4041],
Cell[33272, 1170, 128, 3, 70, "Output",
 CellTags->"b:1.3.3.1",
 CellID->91017436]
}, Open  ]],
Cell[33415, 1176, 220, 7, 70, "Text",
 CellTags->"b:1.3.3.1",
 CellID->24350],
Cell[CellGroupData[{
Cell[33660, 1187, 193, 6, 70, "Input",
 CellTags->"b:1.3.3.1",
 CellID->10291],
Cell[33856, 1195, 164, 5, 70, "Output",
 CellTags->"b:1.3.3.1",
 CellID->252258319]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34069, 1206, 75, 2, 70, "Subsection",
 CellTags->"b:1.3.3.2",
 CellID->9374],
Cell[34147, 1210, 619, 11, 70, "Text",
 CellTags->"b:1.3.3.2",
 CellID->11020],
Cell[34769, 1223, 745, 18, 70, "Text",
 CellTags->"b:1.3.3.2",
 CellID->4596],
Cell[CellGroupData[{
Cell[35539, 1245, 148, 4, 70, "Input",
 CellTags->"b:1.3.3.2",
 CellID->24021],
Cell[35690, 1251, 317, 6, 70, "Print",
 CellTags->{"b:1.3.3.2", "Info3384167482-4356473"},
 CellID->233108318]
}, Open  ]],
Cell[CellGroupData[{
Cell[36044, 1262, 331, 9, 70, "Input",
 CellTags->"b:1.3.3.2",
 CellID->23199],
Cell[36378, 1273, 2246, 35, 70, "Output",
 CellTags->"b:1.3.3.2",
 CellID->257144274]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38673, 1314, 136, 6, 70, "Subsection",
 CellTags->"b:1.3.3.3",
 CellID->8281],
Cell[38812, 1322, 743, 19, 70, "Text",
 CellTags->"b:1.3.3.3",
 CellID->4734],
Cell[39558, 1343, 387, 10, 70, "Text",
 CellTags->"b:1.3.3.3",
 CellID->53],
Cell[CellGroupData[{
Cell[39970, 1357, 146, 4, 70, "Input",
 CellTags->"b:1.3.3.3",
 CellID->1999],
Cell[40119, 1363, 335, 6, 70, "Print",
 CellTags->{"b:1.3.3.3", "Info3384167520-1349916"},
 CellID->380846584]
}, Open  ]],
Cell[CellGroupData[{
Cell[40491, 1374, 228, 7, 70, "Input",
 CellTags->"b:1.3.3.3",
 CellID->27938],
Cell[40722, 1383, 203, 6, 70, "Output",
 CellTags->"b:1.3.3.3",
 CellID->372349811]
}, Open  ]],
Cell[40940, 1392, 312, 10, 70, "Text",
 CellTags->"b:1.3.3.3",
 CellID->3788]
}, Open  ]],
Cell[CellGroupData[{
Cell[41289, 1407, 68, 2, 70, "Subsection",
 CellTags->"b:1.3.3.4",
 CellID->18127],
Cell[41360, 1411, 893, 22, 70, "Text",
 CellTags->"b:1.3.3.4",
 CellID->467],
Cell[42256, 1435, 303, 7, 70, "Text",
 CellTags->"b:1.3.3.4",
 CellID->3728],
Cell[CellGroupData[{
Cell[42584, 1446, 144, 4, 70, "Input",
 CellTags->"b:1.3.3.4",
 CellID->14893],
Cell[42731, 1452, 306, 6, 70, "Print",
 CellTags->{"b:1.3.3.4", "Info3384167561-4916499"},
 CellID->97844372]
}, Open  ]],
Cell[CellGroupData[{
Cell[43074, 1463, 333, 9, 70, "Input",
 CellTags->"b:1.3.3.4",
 CellID->22483],
Cell[43410, 1474, 3210, 86, 70, "Output",
 CellTags->"b:1.3.3.4",
 CellID->46815542]
}, Open  ]],
Cell[46635, 1563, 522, 16, 70, "Text",
 CellTags->"b:1.3.3.4",
 CellID->2421],
Cell[CellGroupData[{
Cell[47182, 1583, 215, 6, 70, "Input",
 CellTags->"b:1.3.3.4",
 CellID->14310],
Cell[47400, 1591, 165, 5, 70, "Output",
 CellTags->"b:1.3.3.4",
 CellID->676012798]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47626, 1603, 69, 2, 70, "Section",
 CellTags->"b:1.3.4",
 CellID->22813],
Cell[47698, 1607, 683, 12, 70, "Text",
 CellTags->"b:1.3.4",
 CellID->9514],
Cell[48384, 1621, 433, 9, 70, "Text",
 CellTags->"b:1.3.4",
 CellID->14309],
Cell[48820, 1632, 138, 4, 70, "Input",
 CellTags->"b:1.3.4",
 CellID->7616],
Cell[CellGroupData[{
Cell[48983, 1640, 238, 6, 70, "Input",
 CellTags->"b:1.3.4",
 CellID->18935],
Cell[49224, 1648, 147, 4, 70, "Output",
 CellTags->"b:1.3.4",
 CellID->99140279]
}, Open  ]],
Cell[CellGroupData[{
Cell[49408, 1657, 138, 4, 70, "Input",
 CellTags->"b:1.3.4",
 CellID->20600],
Cell[49549, 1663, 241, 5, 70, "Print",
 CellTags->{"b:1.3.4", "Info3384167774-1396201"},
 CellID->647916694]
}, Open  ]],
Cell[CellGroupData[{
Cell[49827, 1673, 204, 6, 70, "Input",
 CellTags->"b:1.3.4",
 CellID->16519],
Cell[50034, 1681, 137, 3, 70, "Output",
 CellTags->"b:1.3.4",
 CellID->44988406]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50220, 1690, 65, 2, 70, "Section",
 CellTags->"b:1.3.5",
 CellID->22798],
Cell[50288, 1694, 513, 12, 70, "Text",
 CellTags->"b:1.3.5",
 CellID->30303],
Cell[50804, 1708, 172, 5, 70, "Text",
 CellTags->"b:1.3.5",
 CellID->6224],
Cell[50979, 1715, 139, 4, 70, "Input",
 CellTags->"b:1.3.5",
 CellID->11008],
Cell[CellGroupData[{
Cell[51143, 1723, 233, 6, 70, "Input",
 CellTags->"b:1.3.5",
 CellID->5844],
Cell[51379, 1731, 147, 4, 70, "Output",
 CellTags->"b:1.3.5",
 CellID->670639522]
}, Open  ]],
Cell[CellGroupData[{
Cell[51563, 1740, 137, 4, 70, "Input",
 CellTags->"b:1.3.5",
 CellID->14989],
Cell[51703, 1746, 223, 4, 70, "Print",
 CellTags->{"b:1.3.5", "Info3384167844-3529236"},
 CellID->449510239]
}, Open  ]],
Cell[CellGroupData[{
Cell[51963, 1755, 141, 4, 70, "Input",
 CellTags->"b:1.3.5",
 CellID->3195],
Cell[52107, 1761, 115, 3, 70, "Output",
 CellTags->"b:1.3.5",
 CellID->148907919]
}, Open  ]],
Cell[52237, 1767, 165, 6, 70, "Text",
 CellTags->"b:1.3.5",
 CellID->3093],
Cell[CellGroupData[{
Cell[52427, 1777, 142, 4, 70, "Input",
 CellTags->"b:1.3.5",
 CellID->14343],
Cell[52572, 1783, 115, 3, 70, "Output",
 CellTags->"b:1.3.5",
 CellID->634167884]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52736, 1792, 70, 2, 70, "Section",
 CellTags->"b:1.3.6",
 CellID->1587],
Cell[52809, 1796, 642, 17, 70, "Text",
 CellTags->"b:1.3.6",
 CellID->29314],
Cell[53454, 1815, 139, 4, 70, "Input",
 CellTags->"b:1.3.6",
 CellID->9503],
Cell[CellGroupData[{
Cell[53618, 1823, 384, 10, 70, "Input",
 CellTags->"b:1.3.6",
 CellID->7448],
Cell[54005, 1835, 148, 4, 70, "Output",
 CellTags->"b:1.3.6",
 CellID->1834554590]
}, Open  ]],
Cell[54168, 1842, 252, 6, 70, "Text",
 CellTags->"b:1.3.6",
 CellID->13458],
Cell[CellGroupData[{
Cell[54445, 1852, 141, 4, 70, "Input",
 CellTags->"b:1.3.6",
 CellID->6618],
Cell[54589, 1858, 185, 4, 70, "Output",
 CellTags->"b:1.3.6",
 CellID->1936274151]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54823, 1868, 65, 2, 70, "Section",
 CellTags->"b:1.3.8",
 CellID->19589],
Cell[54891, 1872, 375, 8, 70, "Text",
 CellTags->"b:1.3.8",
 CellID->20798],
Cell[55269, 1882, 139, 4, 70, "Input",
 CellTags->"b:1.3.8",
 CellID->28009],
Cell[CellGroupData[{
Cell[55433, 1890, 232, 6, 70, "Input",
 CellTags->"b:1.3.8",
 CellID->27157],
Cell[55668, 1898, 145, 4, 70, "Output",
 CellTags->"b:1.3.8",
 CellID->16044692]
}, Open  ]],
Cell[55828, 1905, 112, 2, 70, "Text",
 CellTags->"b:1.3.8",
 CellID->23622],
Cell[CellGroupData[{
Cell[55965, 1911, 184, 6, 70, "Input",
 CellTags->"b:1.3.8",
 CellID->18538],
Cell[56152, 1919, 518, 11, 70, "Message",
 CellTags->"b:1.3.8",
 CellID->18589147],
Cell[56673, 1932, 121, 3, 70, "Output",
 CellTags->"b:1.3.8",
 CellID->648641257]
}, Open  ]],
Cell[56809, 1938, 105, 2, 70, "Text",
 CellTags->"b:1.3.8",
 CellID->24179],
Cell[CellGroupData[{
Cell[56939, 1944, 186, 6, 70, "Input",
 CellTags->"b:1.3.8",
 CellID->18190],
Cell[57128, 1952, 184, 4, 70, "Output",
 CellTags->"b:1.3.8",
 CellID->674229548]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[57351, 1961, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

