(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12478,        392]
NotebookOptionsPosition[      8064,        250]
NotebookOutlinePosition[     11294,        340]
CellTagsIndexPosition[     11226,        335]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction", "Title",
 CellID->9961],

Cell["\<\
The World Wide Web is increasingly being used for communication between \
applications. The programmatic interfaces made available over the web for \
application-to-application communication are often referred to as web \
services. There are many types of applications that can be considered web \
services but interoperability between applications is enhanced most by the \
use of familiar technologies such as XML and HTTP. These technologies allow \
applications using differing languages and platforms to interface in a \
familiar way.\
\>", "Text",
 FontWeight->"Plain",
 CellTags->"b:1.1",
 CellID->491],

Cell[TextData[{
 "The web services client for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows users to call operations that are based remotely on other platforms \
or languages that are not immediately accessible to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This opens up a whole new realm of functionality and data to users of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->2995],

Cell[TextData[{
 "There are several keys technologies that enable ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to interact with web services. Following is an explanation of each \
technology. "
}], "Text",
 CellTags->"b:1.1",
 CellID->11942],

Cell[CellGroupData[{

Cell["XML and HTTP", "Section",
 CellTags->"b:1.1",
 CellID->4827],

Cell[TextData[{
 "XML and HTTP are the foundation for calling web services with ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 ". A user interacts with the web service interfaces by sending XML messages \
over HTTP. XML and HTTP are useful for creating and sending messages because \
they are flexible and widely supported on many platforms and languages. This \
interoperability allows applications to communicate using differing languages \
and platforms using these common technologies. ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " supports XML 1.0 and HTTP 1.1. The XML functionality is supplied by the \
XML capabilities built into ",
 StyleBox["Mathematica. ",
  FontSlant->"Italic"],
 "The HTTP functionality is supplied by the Apache Commons HTTP client. The \
user may find knowledge of XML and HTTP to be helpful, however, it is not \
required. For more information about HTTP, please see ",
 ButtonBox["http://www.w3.org/Protocols/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.w3.org/Protocols/"], None}],
 ". For more information about XML, please see ",
 ButtonBox["http://www.w3.org/XML/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.w3.org/XML/"], None}],
 "."
}], "Text",
 CellTags->"b:1.1",
 CellID->5436]
}, Open  ]],

Cell[CellGroupData[{

Cell["SOAP", "Section",
 CellTags->"b:1.1",
 CellID->32391],

Cell[TextData[{
 "Because XML and HTTP are so flexible, a web service message may be \
represented and communicated in many different ways. Therefore it is \
important to have standards that are common among all platforms and languages \
that use a web service. Simple Object Access Protocol (SOAP) is one standard \
that formally sets the conventions governing the format and processing rules \
of XML messages and how they are used with HTTP. ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " supports SOAP 1.1. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users are not required to know any specifics of SOAP. For more \
information, please see ",
 ButtonBox["http://www.w3.org/TR/SOAP/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.w3.org/TR/SOAP/"], None}],
 ". "
}], "Text",
 FontWeight->"Plain",
 CellTags->"b:1.1",
 CellID->14604]
}, Open  ]],

Cell[CellGroupData[{

Cell["WSDL", "Section",
 CellTags->"b:1.1",
 CellID->3902],

Cell[TextData[{
 "Another useful technology that is associated with web services is Web \
Service Description Language (WSDL). WSDL formally sets the format for \
describing a web service using XML. By providing a Uniform Resource \
Identifier (URI) to a WSDL, applications can discover what operations a \
particular web service provides and how an operation\[CloseCurlyQuote]s \
messages look. With this information ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " can generate SOAP messages using input from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions. A web services operation may be used without a WSDL, however, \
the WSDL is key for promoting a web service. ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " supports WSDL 1.1. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users are not required to know any specifics of WSDL. For more \
information, please see ",
 ButtonBox["http://www.w3.org/TR/wsdl",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.w3.org/TR/wsdl"], None}],
 "."
}], "Text",
 FontWeight->"Plain",
 CellTags->"b:1.1",
 CellID->153]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML Schema", "Section",
 CellTags->"b:1.1",
 CellID->292],

Cell[TextData[{
 "Data types are a very important component of web services because different \
data types may be used to compose SOAP messages. WSDL uses XML Schema to \
describe data types used in a web service. ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " uses the XML Schema package to dynamically bind ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions to XML. This package validates data against a schema to make \
sure it correctly matches the definition for a data type. ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " supports XML Schema 1.0. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users are not required to know any specifics of XML Schema. For more \
information, please see ",
 ButtonBox["http://www.w3.org/XML/Schema",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.w3.org/XML/Schema"], None}],
 ". "
}], "Text",
 CellTags->"b:1.1",
 CellID->12382]
}, Open  ]],

Cell[CellGroupData[{

Cell["WS-I Basic Profiles", "Section",
 CellTags->"b:1.1",
 CellID->17421],

Cell[TextData[{
 "While SOAP and WSDL are great starts for implementing web services, there \
are compatibility issues that result from these specifications. WS-I Basic \
Profiles address all compatibility issues by specifying implementation \
guidelines on how core web services specifications should be used together to \
develop interoperable web services. This specification gives guidelines for \
WSDL, SOAP, and Universal Description, Discovery and Integration (UDDI) \
implementations. The focus of this specification is easier integration among \
varying implementations of web services and their clients. The client uses \
these guidelines for the implementation. A web service that follows these \
guidelines is more likely to work correctly with the client. ",
 StyleBox["Web Services Link",
  FontSlant->"Italic"],
 " supports WS-I Profiles 1.1. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users are not required to know any specifics of Basic Profiles. For more \
information, please see ",
 ButtonBox["http://www.ws-i.org/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.ws-i.org/"], None}],
 "."
}], "Text",
 CellTags->"b:1.1",
 CellID->18716]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 32.7150208}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Web Services Tutorial", 
    "language" -> "en", "paclet" -> "WebServices", "status" -> "None", 
    "summary" -> 
    "The World Wide Web is increasingly being used for communication between \
applications. The programmatic interfaces made available over the web for \
application-to-application communication are often referred to as web \
services. There are many types of applications that can be considered web \
services but interoperability between applications is enhanced most by the \
use of familiar technologies such as XML and HTTP. These technologies allow \
applications using differing languages and platforms to interface in a \
familiar way. The web services client for Mathematica allows users to call \
operations that are based remotely on other platforms or languages that are \
not immediately accessible to Mathematica. This opens up a whole new realm of \
functionality and data to users of Mathematica. There are several keys \
technologies that enable Mathematica to interact with web services. Following \
is an explanation of each technology. ", "synonyms" -> {}, "title" -> 
    "Introduction", "type" -> "Tutorial", "uri" -> 
    "WebServices/tutorial/Introduction"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:1.1"->{
  Cell[776, 32, 619, 12, 70, "Text",
   CellTags->"b:1.1",
   CellID->491],
  Cell[1840, 61, 251, 8, 70, "Text",
   CellTags->"b:1.1",
   CellID->11942],
  Cell[2116, 73, 66, 2, 70, "Section",
   CellTags->"b:1.1",
   CellID->4827],
  Cell[2185, 77, 1287, 30, 70, "Text",
   CellTags->"b:1.1",
   CellID->5436],
  Cell[3509, 112, 59, 2, 70, "Section",
   CellTags->"b:1.1",
   CellID->32391],
  Cell[3571, 116, 877, 22, 70, "Text",
   CellTags->"b:1.1",
   CellID->14604],
  Cell[4485, 143, 58, 2, 70, "Section",
   CellTags->"b:1.1",
   CellID->3902],
  Cell[4546, 147, 1125, 29, 70, "Text",
   CellTags->"b:1.1",
   CellID->153],
  Cell[5708, 181, 63, 2, 70, "Section",
   CellTags->"b:1.1",
   CellID->292],
  Cell[5774, 185, 937, 25, 70, "Text",
   CellTags->"b:1.1",
   CellID->12382],
  Cell[6748, 215, 74, 2, 70, "Section",
   CellTags->"b:1.1",
   CellID->17421],
  Cell[6825, 219, 1185, 25, 70, "Text",
   CellTags->"b:1.1",
   CellID->18716]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:1.1", 10249, 295}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 44, 1, 70, "Title",
 CellID->9961],
Cell[776, 32, 619, 12, 70, "Text",
 CellTags->"b:1.1",
 CellID->491],
Cell[1398, 46, 439, 13, 70, "Text",
 CellID->2995],
Cell[1840, 61, 251, 8, 70, "Text",
 CellTags->"b:1.1",
 CellID->11942],
Cell[CellGroupData[{
Cell[2116, 73, 66, 2, 70, "Section",
 CellTags->"b:1.1",
 CellID->4827],
Cell[2185, 77, 1287, 30, 70, "Text",
 CellTags->"b:1.1",
 CellID->5436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3509, 112, 59, 2, 70, "Section",
 CellTags->"b:1.1",
 CellID->32391],
Cell[3571, 116, 877, 22, 70, "Text",
 CellTags->"b:1.1",
 CellID->14604]
}, Open  ]],
Cell[CellGroupData[{
Cell[4485, 143, 58, 2, 70, "Section",
 CellTags->"b:1.1",
 CellID->3902],
Cell[4546, 147, 1125, 29, 70, "Text",
 CellTags->"b:1.1",
 CellID->153]
}, Open  ]],
Cell[CellGroupData[{
Cell[5708, 181, 63, 2, 70, "Section",
 CellTags->"b:1.1",
 CellID->292],
Cell[5774, 185, 937, 25, 70, "Text",
 CellTags->"b:1.1",
 CellID->12382]
}, Open  ]],
Cell[CellGroupData[{
Cell[6748, 215, 74, 2, 70, "Section",
 CellTags->"b:1.1",
 CellID->17421],
Cell[6825, 219, 1185, 25, 70, "Text",
 CellTags->"b:1.1",
 CellID->18716]
}, Open  ]]
}, Open  ]],
Cell[8037, 248, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

