(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14979,        409]
NotebookOptionsPosition[     11026,        295]
NotebookOutlinePosition[     14227,        378]
CellTagsIndexPosition[     14131,        372]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["XMethods", "Section",
 CellTags->"b:1.5.4",
 CellID->30527],

Cell[TextData[{
 ButtonBox["XMethods.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.xmethods.com"], None}],
 " is a website that lists publicly available web services. It is a great \
place for finding web services and advertising web services that you provide. \
This example queries the XMethods database and builds a notebook listing of \
each web service listed on XMethods. Each web service is listed with the \
title, description, and an ",
 Cell[BoxData[
  ButtonBox["InstallService",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InstallService"]], "InlineFormula"],
 " function that can be used to install and use a service."
}], "Text",
 CellTags->"b:1.5.4",
 CellID->2625],

Cell[TextData[{
 "This example demonstrates using the XMethods Query Service to discover and \
use many of the web services available. This example searches the XMethods \
database for the web services registered. Once the query is finished, a user \
can conveniently browse through the services and install the services that \
may be interesting. If ",
 StyleBox["GetServiceSummaries", "MR"],
 " is called again, the code will match service IDs with cell tags. If an ID \
exists as a cell tag, no new cells will be added. If an ID does not exist, \
the appropriate cells are added for the service."
}], "Text",
 CellTags->"b:1.5.4",
 CellID->1543],

Cell[TextData[{
 "To try this example, evaluate all the initialization cells. (You can do \
this using ",
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" ", "MenuName"],
 StyleBox["\[FilledRightTriangle]", "MenuNameDelimiter"],
 StyleBox[" ", "MenuName"],
 StyleBox[ButtonBox["Evaluate Initialization Cells",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/EvaluateInitializationCells"], 
  "MenuName"],
 ".) Then go to the examples here."
}], "Text",
 CellTags->"b:1.5.1",
 CellID->469878615],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellTags->"b:1.5.4",
 CellID->11023],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BeginPackage", "[", 
    RowBox[{"\"\<WebServices`Examples`XMethods`\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<WebServices`\>\"", ",", "\"\<JLink`\>\""}], "}"}]}], "]"}],
    ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GetServiceSummaries", ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
   "InstallService", "[", "\"\<http://www.xmethods.net/wsdl/query.wsdl\>\"", 
    "]"}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GetServiceSummaries", "[", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", 
     RowBox[{
      RowBox[{"result", "=", 
       RowBox[{"getAllServiceSummaries", "[", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"result", "===", "$Failed"}], ",", 
        RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"notebook", "=", 
       RowBox[{"EvaluationNotebook", "[", "]"}]}], ";", "\[IndentingNewLine]",
       
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"NotebookFind", "[", 
          RowBox[{"notebook", ",", "\"\<Results\>\"", ",", "All", ",", 
           RowBox[{"{", "CellTags", "}"}]}], "]"}], "===", "$Failed"}], ",", 
        RowBox[{
         RowBox[{"SelectionMove", "[", 
          RowBox[{"notebook", ",", "After", ",", "EvaluationCell"}], "]"}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"NotebookWrite", "[", 
          RowBox[{"notebook", ",", 
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<Results\>\"", ",", "\"\<Section\>\"", ",", 
             RowBox[{"CellTags", "\[Rule]", 
              RowBox[{"{", "\"\<Results\>\"", "}"}]}]}], "]"}]}], "]"}], 
         ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"printResult", "/@", "result"}], ";", "\[IndentingNewLine]", 
      RowBox[{"NotebookFind", "[", 
       RowBox[{"notebook", ",", "\"\<Results\>\"", ",", "All", ",", 
        RowBox[{"{", "CellTags", "}"}]}], "]"}], ";"}]}], "]"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"printResult", "[", "result_", "]"}], ":=", "\[IndentingNewLine]", 
   
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "name", ",", "id", ",", "shortDescription", ",", "wsdlURL", ",", 
       "publisherID"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"name", "=", 
       RowBox[{"result", "[", "\"\<name\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"id", "=", 
       RowBox[{"result", "[", "\"\<id\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"shortDescription", "=", 
       RowBox[{"result", "[", "\"\<shortDescription\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"wsdlURL", "=", 
       RowBox[{"result", "[", "\"\<wsdlURL\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"publisherID", "=", 
       RowBox[{"result", "[", "\"\<publisherID\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"notebook", "=", 
       RowBox[{"EvaluationNotebook", "[", "]"}]}], ";", "\[IndentingNewLine]",
       
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"NotebookFind", "[", 
          RowBox[{"notebook", ",", "id", ",", "All", ",", 
           RowBox[{"{", "CellTags", "}"}], ",", 
           RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}], "===", 
         "$Failed"}], ",", 
        RowBox[{
         RowBox[{"NotebookFind", "[", 
          RowBox[{"notebook", ",", "\"\<Results\>\"", ",", "All", ",", 
           RowBox[{"{", "CellTags", "}"}], ",", 
           RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"SelectionMove", "[", 
          RowBox[{"notebook", ",", "After", ",", "Cell", ",", 
           RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"NotebookWrite", "[", 
          RowBox[{"notebook", ",", 
           RowBox[{"Cell", "[", 
            RowBox[{"CellGroupData", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cell", "[", 
                 RowBox[{
                  RowBox[{"BoxData", "[", 
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"name", ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\< from \>\"", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Plain\>\""}]}], 
                    "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"publisherID", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Plain\>\""}], ",", 
                    RowBox[{"FontSlant", "\[Rule]", "\"\<Italic\>\""}]}], 
                    "]"}], ",", 
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<(wsdl)\>\"", ",", 
                    RowBox[{"ButtonData", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", "wsdlURL", "]"}], ",", "None"}], 
                    "}"}]}], ",", 
                    RowBox[{"ButtonStyle", "\[Rule]", "\"\<Hyperlink\>\""}]}],
                     "]"}]}], "}"}], "]"}], "]"}], ",", "\"\<Subsection\>\"", 
                  ",", 
                  RowBox[{"ShowGroupOpenCloseIcon", "\[Rule]", "True"}], ",", 
                  
                  RowBox[{"CellDingbat", "\[Rule]", "None"}], ",", 
                  RowBox[{"CellTags", "\[Rule]", 
                   RowBox[{"{", "id", "}"}]}]}], "]"}], ",", 
                RowBox[{"Cell", "[", 
                 RowBox[{"shortDescription", ",", "\"\<Text\>\"", ",", 
                  RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
                  RowBox[{"CellMargins", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"55", ",", "Inherited"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Inherited", ",", "Inherited"}], "}"}]}], "}"}]}],
                   ",", 
                  RowBox[{"CellFrame", "\[Rule]", "True"}], ",", 
                  RowBox[{"Background", "\[Rule]", 
                   RowBox[{"GrayLevel", "[", "0.850004", "]"}]}]}], "]"}], 
                ",", 
                RowBox[{"Cell", "[", 
                 RowBox[{
                  RowBox[{"BoxData", "[", 
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<InstallService[\\\"\>\"", "<>", "wsdlURL", "<>", 
                    "\"\<\\\"]\>\""}], "}"}], "]"}], "]"}], ",", 
                  "\"\<Input\>\"", ",", 
                  RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
                  RowBox[{"CellFrame", "\[Rule]", "True"}], ",", 
                  RowBox[{"CellMargins", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"55", ",", "Inherited"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Inherited", ",", "Inherited"}], "}"}]}], "}"}]}],
                   ",", 
                  RowBox[{"Background", "\[Rule]", 
                   RowBox[{"GrayLevel", "[", "0.850004", "]"}]}]}], "]"}]}], 
               "}"}], ",", "Open"}], "]"}], "]"}]}], "]"}], ";"}]}], "]"}], 
      ";"}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.4",
 CellID->29972]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellTags->"b:1.5.4",
 CellID->13061],

Cell[BoxData[
 RowBox[{"GetServiceSummaries", "[", "]"}]], "Input",
 CellTags->"b:1.5.4",
 CellID->14181]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XMethods - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 34.5743839}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Web Services Tutorial", 
    "language" -> "en", "paclet" -> "WebServices", "status" -> "None", 
    "summary" -> 
    "XMethods.com is a website that lists publicly available web services. It \
is a great place for finding web services and advertising web services that \
you provide. This example queries the XMethods database and builds a notebook \
listing of each web service listed on XMethods. Each web service is listed \
with the title, description, and an InstallService function that can be used \
to install and use a service. This example demonstrates using the XMethods \
Query Service to discover and use many of the web services available. This \
example searches the XMethods database for the web services registered. Once \
the query is finished, a user can conveniently browse through the services \
and install the services that may be interesting. If GetServiceSummaries is \
called again, the code will match service IDs with cell tags. If an ID exists \
as a cell tag, no new cells will be added. If an ID does not exist, the \
appropriate cells are added for the service. To try this example, evaluate \
all the initialization cells. (You can do this using Evaluation > Evaluate \
Initialization Cells.) Then go to the examples here.", "synonyms" -> {}, 
    "title" -> "XMethods", "type" -> "Tutorial", "uri" -> 
    "WebServices/tutorial/XMethodsExample"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:1.5.4"->{
  Cell[729, 29, 65, 2, 70, "Section",
   CellTags->"b:1.5.4",
   CellID->30527],
  Cell[797, 33, 707, 17, 70, "Text",
   CellTags->"b:1.5.4",
   CellID->2625],
  Cell[1507, 52, 648, 12, 70, "Text",
   CellTags->"b:1.5.4",
   CellID->1543],
  Cell[2762, 86, 70, 2, 70, "SubsectionOpener",
   CellTags->"b:1.5.4",
   CellID->11023],
  Cell[2835, 90, 7925, 187, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.4",
   CellID->29972],
  Cell[10797, 282, 67, 2, 70, "Subsection",
   CellTags->"b:1.5.4",
   CellID->13061],
  Cell[10867, 286, 105, 3, 70, "Input",
   CellTags->"b:1.5.4",
   CellID->14181]},
 "b:1.5.1"->{
  Cell[2158, 66, 579, 16, 70, "Text",
   CellTags->"b:1.5.1",
   CellID->469878615]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:1.5.4", 13393, 342},
 {"b:1.5.1", 14022, 365}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 65, 2, 70, "Section",
 CellTags->"b:1.5.4",
 CellID->30527],
Cell[797, 33, 707, 17, 70, "Text",
 CellTags->"b:1.5.4",
 CellID->2625],
Cell[1507, 52, 648, 12, 70, "Text",
 CellTags->"b:1.5.4",
 CellID->1543],
Cell[2158, 66, 579, 16, 70, "Text",
 CellTags->"b:1.5.1",
 CellID->469878615],
Cell[CellGroupData[{
Cell[2762, 86, 70, 2, 70, "SubsectionOpener",
 CellTags->"b:1.5.4",
 CellID->11023],
Cell[2835, 90, 7925, 187, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.4",
 CellID->29972]
}, Closed]],
Cell[CellGroupData[{
Cell[10797, 282, 67, 2, 70, "Subsection",
 CellTags->"b:1.5.4",
 CellID->13061],
Cell[10867, 286, 105, 3, 70, "Input",
 CellTags->"b:1.5.4",
 CellID->14181]
}, Open  ]]
}, Open  ]],
Cell[10999, 293, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

